 $!I $!***********************************************************************  $! $! SHOW_LINKS.COM  $! $!< $!	This procedure simulates the NCP command SHOW KNOWN LINKS $!	for DECnet/OSI  $! $! $! VERSION:	01.00  $! $! AUTHOR:	Kari Salminen $! $! DATE:	18-APR-1996 $! $! $! MODIFIED BY:  $!( $!	V1.1    19-APR-1996     Kari Salminen/ $!				Add check if using the same NSP/OSI port. O $!                              Add debug switch, delete temp files if not dbg.  $!( $!	V1.2    29-APR-1996     Kari Salminen5 $!				Add save/search for NSP/OSI ports out of order.  $!( $!	V1.3     3-MAY-1996     Kari Salminen1 $!				Handle missing and "<Default value>" cases. ! $!				Change the .TMP file names.  $! $! $! $!I $!***********************************************************************  $!4 $!	The debug option D will not delete the .TMP files $!8 $!	The debug option X will use the last .TMP files againH $!	The debug option Y will use the last .TMP files again and skip GETJPI $!I $!	If P1 = X/Y , then if P2 .eqs. "" , use current PID for .TMP file name 9 $!			      P2 .nes. "" , use P2 as PID for .TMP file name  $! $!				    " PID  " $!				OSI_3B415B62.TMP;1 $! $!O $! 	For a good NSP link from node A to B you must see similar to the following. 5 $! 	Note:  the "REM and LOC LINK" numbers must match:  $!	 $!   LINK v $! REM     LOC    DIRECTION   LOCAL USER          PID       PROCESS NAME     REMOTE USER                  NODE    PORT $!--------------  ---------   ---------------     --------  ---------------  ---------------------------  ------  ---------------  $! - On node A:  $! 60      132    OUTGOING    [0,0]SALMINEN       20204E8C  DECW$TE_4E8C     X$X0                         B       NSP$PORT_00002323  $! - On node B:  $! 132     60     INCOMING    X$X0                41E0005D  DECW$SERVER_0    [0,0]SALMINEN                A       NSP$PORT_0000203C  $! $! $!  $ DEBUG = 0 		! Default no debug $!! $  if p1 .eqs. "D" then DEBUG = 1 ! $  if p1 .eqs. "d" then DEBUG = 1  $! $! $! $ wo = "WRITE SYS$OUTPUT"  $!
 $ wo (" ")4 $ wo ("              *****************************")4 $ wo ("              *   SHOW_LINKS.COM  V1.3    *")4 $ wo ("              *   Show DECnet/OSI Links   *")4 $ wo ("              *****************************")
 $ wo (" ")
 $ wo (" ")= $ wo ("   This procedure simulates the PHASE IV NCP command") + $ wo ("   SHOW KNOWN LINKS for DECnet/OSI") 
 $ wo (" ") $ wo ("   Collecting data...")
 $ wo (" ")
 $ wo (" ") $!
 $ total =0 $!% $ nsp_counter  = 0		! NSP ring buffer * $ nsp_saved    = 0		! # of saved NSP ports% $ osi_counter  = 0		! OSI ring buffer * $ osi_saved    = 0		! # of saved OSI ports $ init_counter = 0 $! $ init_loop: $!& $ NSP_SAVE'init_counter'_SCL_PORT = ""& $ NSP_SAVE'init_counter'_TMP_PORT = ""$ $ NSP_SAVE'init_counter'_NODE	  = ""& $ NSP_SAVE'init_counter'_LOC_LINK = ""& $ NSP_SAVE'init_counter'_REM_LINK = "" $!& $ OSI_SAVE'init_counter'_SCL_PORT = ""& $ OSI_SAVE'init_counter'_TMP_PORT = ""$ $ OSI_SAVE'init_counter'_NODE	  = ""& $ OSI_SAVE'init_counter'_LOC_LINK = ""& $ OSI_SAVE'init_counter'_REM_LINK = "" $!! $ init_counter = init_counter + 1 - $ if init_counter .lt. 17 then goto init_loop  $! $!O $!*********** Temporary filename and version **********************************  $!E $!	Insert PID into .TMP file name, so the user can run simultaneously I $!	several copies of this procedure from the same directory on a cluster.  $!( $ MY_PID = F$GETJPI("","PID")		! Get PID6 $ if P2 .nes. "" then MY_PID = P2	! Debug mode, use P2 $! $ file   = "SCL_''MY_PID'.TMP;"  $ file_2 = "NSP_''MY_PID'.TMP;"  $ file_3 = "OSI_''MY_PID'.TMP;"  $!' $ if p1 .eqs. "x" then goto skip	! test ' $ if p1 .eqs. "X" then goto skip	! test ' $ if p1 .eqs. "y" then goto skip	! test ' $ if p1 .eqs. "Y" then goto skip	! test  $!? $!	We must use version numbers for the temp files, so the user  @ $!	may run several times this procedure from the same directory. $!
 $ version = 1  $ string = F$SEARCH ("''file'") 7 $ if string .eqs. "" then goto OK	! File does not exist  $!= $!****** File exists already, create new version ************  $!9 $ tmpstr = F$EXTRACT(F$LOCATE("]",string) + 1 ,20,string)  $!$ $ version = f$extract(17, 4, tmpstr) $ version = version + 1  $! $ OK:  $ file = "''file'''version'" $!M $!***************************************************************************  $!
 $ version = 1 ! $ string = F$SEARCH ("''file_2'") : $ if string .eqs. "" then goto OK_2		! File does not exist $!= $!****** File exists already, create new version ************  $!9 $ tmpstr = F$EXTRACT(F$LOCATE("]",string) + 1 ,20,string)  $!$ $ version = f$extract(17, 4, tmpstr) $ version = version + 1  $! $ OK_2:   $ file_2 = "''file_2'''version'" $! $!**************************** $!
 $ version = 1 ! $ string = F$SEARCH ("''file_3'") ? $ if string .eqs. "" then goto OK_3       ! File does not exist  $!= $!****** File exists already, create new version ************  $!9 $ tmpstr = F$EXTRACT(F$LOCATE("]",string) + 1 ,20,string)  $!$ $ version = f$extract(17, 4, tmpstr) $ version = version + 1  $! $ OK_3:   $ file_3 = "''file_3'''version'" $!M $!*************************************************************************** M $!***************************************************************************  $! $!	Get all link information. $!B $!	NOTE:	Doing this from DCL is rather slow and a link may go away% $!		or come up between the NCL calls.  $!A $!		Unfortunately the SHOW NSP and OSI PORT do not always display = $!		the ports in the same order as SHOW SESSION CONTROL PORT.  $!= $!		This is checked later to prevent the information getting  * $!		out of order after a missing/new link. $! $!( $ DEF/USER SYS$OUTPUT 'file				! SCL.TMP4 $ MC NCL SHOW SESSION CONTROL PORT  * ALL ATTRIBUTES $!* $ DEF/USER SYS$OUTPUT 'file_2				! NSP.TMP' $ MC NCL SHOW NSP PORT * ALL ATTRIBUTES  $!* $ DEF/USER SYS$OUTPUT 'file_3				! OSI.TMP1 $ MC NCL SHOW OSI TRANSPORT PORT * ALL ATTRIBUTES  $! $ skip:  $!N $!****************************************************************************M $!***************************************************************************  $! $!	Get screen width  $! $ set_term = 03 $ screen_width = F$GETDVI("SYS$OUTPUT","DEVBUFSIZ")  $! $!***	Screen width must be 132 $!+ $ if screen_width .lt. 81 then set_term = 1 2 $ if screen_width .lt. 81 then $set term/width=132 $!M $!****	Output file for links ************************************************  $!0 $ link_file = "''F$GETSYI("nodename")_LINKS.TMP"+ $ open/write/error=error outfile 'link_file  $!
 $ wo (" ")  $ write/error=error outfile  " " $ wo ("    LINK") ' $ write/error=error outfile  "    LINK" } $ wo (" REM     LOC    DIRECTION   LOCAL USER          PID       PROCESS NAME     REMOTE USER                  NODE    PORT")  $ write/error=error outfile  " REM     LOC    DIRECTION   LOCAL USER          PID       PROCESS NAME     REMOTE USER                  NODE    PORT"  $ wo ("--------------  ---------   ---------------     --------  ---------------  ---------------------------  ------  ---------------") $ write/error=error outfile  "--------------  ---------   ---------------     --------  ---------------  ---------------------------  ------  ---------------" $!! $ ON CONTROL_Y THEN GOTO clean_up  $! $ open/read tempfile 'file $ open/read nspfile 'file_2  $ open/read osifile 'file_3  $!N $!****************************************************************************N $!*************** Scan for items *********************************************N $!**************************************************************************** $! $ BIG_LOOP:  $! $!L $!***	Search "Node 0 Session Control Port SCL$PORTxxxx " ******************* $! $ next_line_20:  $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") + $ if string .eqs. "" then goto next_line_20  $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr  $!/ $ if tmpstr .nes. "NODE" then goto next_line_20 + $ if tmpstr .eqs. "" then goto next_line_20  $! $ !xxxxx show symbol string  $!A $ SCL_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30 ,string)  $! $ !xxxxx show symbol SCL_PORT  $! $!L $!***	Search "Local End User Address  = UIC = [0,0]SYSTEM" ***************** $! $ next_line_1: $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") * $ if string .eqs. "" then goto next_line_1 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 5, tmpstr) $! $ !xxxxx show symbol tmpstr  $!/ $ if tmpstr .nes. "LOCAL" then goto next_line_1 * $ if tmpstr .eqs. "" then goto next_line_1 $! $ !xxxxx show symbol string  $!< $ tmpstr = F$EXTRACT(F$LOCATE("=", string) + 1 , 30 ,string) $! $ !xxxxx show symbol tmpstr  $!; $ LUSER = F$EXTRACT(F$LOCATE("=", tmpstr) + 1 , 30 ,tmpstr)  $! $ !xxxxx show symbol LUSER $!L $!***	Search for "Transport Port" ****************************************** $! $! $ next_line_2: $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") * $ if string .eqs. "" then goto next_line_2 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 9, tmpstr) $! $ !xxxxx show symbol tmpstr  $!3 $ if tmpstr .nes. "TRANSPORT" then goto next_line_2 * $ if tmpstr .eqs. "" then goto next_line_2 $! $ !xxxxx show symbol string  $!D $!    Transport Port                    = NSP Port NSP$PORT_00002004L $!    Transport Port                    = OSI Transport Port OSI$PORT_0_0040 $!: $ temp_p = F$EXTRACT(F$LOCATE("=", string) + 2, 3 ,string) $! $ !xxxxx show symbol temp  $![ $ if temp_p .eqs. "NSP" then NSP_PORT = F$EXTRACT(F$LOCATE("NSP$PORT", string), 30 ,string) [ $ if temp_p .eqs. "OSI" then NSP_PORT = F$EXTRACT(F$LOCATE("OSI$PORT", string), 30 ,string)  $!% $!	We can have "<Default value>" too.  $!- $ if temp_p .eqs. "<DE" then NSP_PORT = "???"  $! $ !xxxxx show symbol NSP_PORT  $ !xxxxx show symbol temp_p  $!L $!***	Search for "Direction" *********************************************** $! $ next_line_3: $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") * $ if string .eqs. "" then goto next_line_3 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 9, tmpstr) $! $ !xxxxx show symbol tmpstr  $!3 $ if tmpstr .nes. "DIRECTION" then goto next_line_3 * $ if tmpstr .eqs. "" then goto next_line_3 $! $ !xxxxx show symbol string  $!? $ DIRECTION = F$EXTRACT(F$LOCATE("=", string) + 2 , 30 ,string)  $! $ !xxxxx show symbol DIRECTION $! $!M $!***	Search for "Remote End User" ******************************************  $! $ next_line_4: $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") * $ if string .eqs. "" then goto next_line_4 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstr  $!0 $ if tmpstr .nes. "REMOTE" then goto next_line_4* $ if tmpstr .eqs. "" then goto next_line_4 $! $ !xxxxx show symbol string  $!< $ tmpstr = F$EXTRACT(F$LOCATE("=", string) + 1 , 40 ,string) $! $ !xxxxx show symbol tmpstr  $!; $ RUSER = F$EXTRACT(F$LOCATE("=", tmpstr) + 1 , 30 ,tmpstr)  $! $ !xxxxx show symbol RUSER $!L $!***	Search for "Node Name Sent" ****************************************** $! $ next_line_9: $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") * $ if string .eqs. "" then goto next_line_9 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 9, tmpstr) $! $ !xxxxx show symbol tmpstr  $!3 $ if tmpstr .nes. "NODE NAME" then goto next_line_9 * $ if tmpstr .eqs. "" then goto next_line_9 $! $ !xxxxx show symbol string  $!@ $ NODE_X = F$EXTRACT(F$LOCATE("LOCAL:", string) + 7 , 6 ,string) $! $ !xxxxx show symbol NODE_X  $! $!M $!***	Search for "PID" ******************************************************  $! $ next_line_5: $!7 $ read/error=error/END_OF_FILE=end_file tempfile string  $!+ $ string = f$edit(string,"upcase,compress") * $ if string .eqs. "" then goto next_line_5 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 7, tmpstr) $! $ !xxxxx show symbol tmpstr  $!1 $ if tmpstr .nes. "PROCESS" then goto next_line_5 * $ if tmpstr .eqs. "" then goto next_line_5 $! $ !xxxxx show symbol string  $!8 $ PID = F$EXTRACT(F$LOCATE("=", string) + 3 , 8 ,string) $! $ !xxxxx show symbol PID $!( $ PROC_NAME = "???"				! Default if gone $!G $ if PID .eqs. "DEFAULT " then goto skip3	! It can be <Default value> !  $!( $ if p1 .eqs. "y" then goto skip3	! test( $ if p1 .eqs. "Y" then goto skip3	! test $!) $ PROC_NAME = F$GETJPI("''PID'","PRCNAM")  $! $ skip3: $!M $!***************************************************************************  $!* $ if temp_p .eqs. "OSI" then goto OSI_PORT $!N $!****************************************************************************N $!**************************************************************************** $! $!	NSP port  $!= $ if nsp_saved .eq. 0 then goto next_line_06	! No saved ports  $!N $!***** Look if we have the values in saved ones ***************************** $!
 $ counter = 0  $!
 $ nsp_loop_0:  $!J $ if NSP_PORT .eqs. NSP_SAVE'counter'_TMP_PORT then goto found_nsp_saved_0L $ if SCL_PORT .eqs. NSP_SAVE'counter'_SCL_PORT then goto found_nsp_saved_x_0 $! $ counter = counter + 1 6 $ if counter .lt. 16 then goto nsp_loop_0       ! Next! $ goto next_line_06				! Was last  $!# $!********** Found from saved ports  $! $ found_nsp_saved_x_0: $!' $ NSP_PORT = NSP_SAVE'counter'_TMP_PORT  $! $ found_nsp_saved_0: $!P $! wo ("====> JUHUU 0 we can use the saved values ''counter' left ''nsp_saved'") $! $ nsp_saved = nsp_saved - 1  $!" $ NODE	   = NSP_SAVE'counter'_NODE' $ LOC_LINK = NSP_SAVE'counter'_LOC_LINK ' $ REM_LINK = NSP_SAVE'counter'_REM_LINK  $! $ goto conti $!M $!*************************************************************************** K $!***	Search for "NSP$PORT" to verify we have the right port ************** M $!***************************************************************************  $! $ next_line_06:  $!6 $ read/error=error/END_OF_FILE=end_file nspfile string $!+ $ string = f$edit(string,"upcase,compress") + $ if string .eqs. "" then goto next_line_06  $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr  $!/ $ if tmpstr .nes. "NODE" then goto next_line_06 + $ if tmpstr .eqs. "" then goto next_line_06  $!A $ TMP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)  $! $ !xxxxx show symbol TMP_PORT  $!L $!***	Search for "Client Name" ********************************************* $! $ next_line_21:  $!6 $ read/error=error/END_OF_FILE=end_file nspfile string $!+ $ string = f$edit(string,"upcase,compress") + $ if string .eqs. "" then goto next_line_21  $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstr  $!1 $ if tmpstr .nes. "CLIENT" then goto next_line_21 + $ if tmpstr .eqs. "" then goto next_line_21  $!< $ tmpstr = F$EXTRACT(F$LOCATE("=", string) + 1 , 40 ,string) $! $ !xxxxx show symbol tmpstr  $!E $ SCL_NSP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)  $!! $ !xxxxx show symbol SCL_NSP_PORT  $! $!0 $ if NSP_PORT .eqs. TMP_PORT then goto found_nsp6 $ if SCL_PORT .eqs. SCL_NSP_PORT then goto found_nsp_x $!M $!*************************************************************************** M $!**** NSP ports are out of order ******************************************* M $!***************************************************************************  $!M $!**** Save the values for this port into NSP ring buffer *******************  $! $ gosub READ_NSP $! $ !xxxxx show symbol TMP_PORT  $ !xxxxx show symbol LOC_LINK  $ !xxxxx show symbol REM_LINK  $! $ nsp_saved = nsp_saved + 1  $!C $! wo ("********* Save NSP values ''nsp_counter' now ''nsp_saved'")  $!0 $ NSP_SAVE'nsp_counter'_SCL_PORT = SCL_NSP_PORT + $ NSP_SAVE'nsp_counter'_TMP_PORT = TMP_PORT $ $ NSP_SAVE'nsp_counter'_NODE	 = NODE+ $ NSP_SAVE'nsp_counter'_LOC_LINK = LOC_LINK*+ $ NSP_SAVE'nsp_counter'_REM_LINK = REM_LINK  $! $ nsp_counter = nsp_counter + 1 - $ if nsp_counter .gt. 15 then nsp_counter = 0/ $! $!= $!	We might have the case "Transport Port = <Default value>",D< $!	read one NSP port and if no match then read one OSI port. $!* $ if temp_p .eqs. "<DE" then goto OSI_PORT $!M $!***************************************************************************eN $!*** NSP Port not found, Scan nspfile ***************************************M $!***************************************************************************  $! $ scan_nsp:! $!L $!***	Scan first the next 15 entries for the NSP$PORT ********************** $!
 $ counter = 0  $!/ $ !xxxxx show symbol NSP_SAVE'counter'_TMP_PORT* $! $ next_line_XXX6:! $!= $ read/error=error/END_OF_FILE=NSP_NOT_FOUND_X nspfile stringd $!+ $ string = f$edit(string,"upcase,compress") - $ if string .eqs. "" then goto next_line_XXX6l $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr  $!1 $ if tmpstr .nes. "NODE" then goto next_line_XXX6!- $ if tmpstr .eqs. "" then goto next_line_XXX6  $! $ counter = counter + 1n. $ if counter .eq. 16 then goto NSP_NOT_FOUND_X $!A $ TMP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)  $! $ !xxxxx show symbol TMP_PORTT $!L $!***	Search for "Client Name" ********************************************* $! $ next_line_X21: $!6 $ read/error=error/END_OF_FILE=end_file nspfile string $!+ $ string = f$edit(string,"upcase,compress")-, $ if string .eqs. "" then goto next_line_X21 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstr0 $!2 $ if tmpstr .nes. "CLIENT" then goto next_line_X21, $ if tmpstr .eqs. "" then goto next_line_X21 $!< $ tmpstr = F$EXTRACT(F$LOCATE("=", string) + 1 , 40 ,string) $! $ !xxxxx show symbol tmpstrb $!E $ SCL_NSP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)  $!! $ !xxxxx show symbol SCL_NSP_PORTT $!P $! if NSP_PORT .eqs. TMP_PORT then $ wo (" ====> JIPPII NSP counter ''counter'")0 $ if NSP_PORT .eqs. TMP_PORT then goto found_nsp6 $ if SCL_PORT .eqs. SCL_NSP_PORT then goto found_nsp_x $! $!O $!****** Save values for this port into NSP ring buffer ***********************u $! $ gosub READ_NSP $! $ nsp_saved = nsp_saved + 1W $!C $! wo ("********* Save NSP values ''nsp_counter' now ''nsp_saved'")) $!0 $ NSP_SAVE'nsp_counter'_SCL_PORT = SCL_NSP_PORT + $ NSP_SAVE'nsp_counter'_TMP_PORT = TMP_PORT % $ NSP_SAVE'nsp_counter'_NODE	  = NODEn+ $ NSP_SAVE'nsp_counter'_LOC_LINK = LOC_LINK=+ $ NSP_SAVE'nsp_counter'_REM_LINK = REM_LINK0 $!3 $ !xxxxx show symbol NSP_SAVE'nsp_counter'_TMP_PORT  $! $ nsp_counter = nsp_counter + 1R- $ if nsp_counter .gt. 15 then nsp_counter = 0  $! $ goto next_line_XXX6L $!M $!***************************************************************************P $! $ NSP_NOT_FOUND_X: $!M $!***** Scan from beginning of the file *************************************n $! $!	Close and reopen nspfilei $!G $ wo ("======> NSP ports badly out of order, need to scan the file...")o $! $ close nspfilet $ open/read nspfile 'file_2* $!L $!***	Scan for the NSP$PORT ************************************************ $! $ next_line_X6:i $!; $ read/error=error/END_OF_FILE=NSP_NOT_FOUND nspfile stringf $!+ $ string = f$edit(string,"upcase,compress")t+ $ if string .eqs. "" then goto next_line_X6t $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr" $!/ $ if tmpstr .nes. "NODE" then goto next_line_X6 + $ if tmpstr .eqs. "" then goto next_line_X6  $!A $ TMP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)  $! $ !xxxxx show symbol TMP_PORTn $!0 $ if NSP_PORT .eqs. TMP_PORT then goto found_nsp $! $ goto next_line_X6h $!M $!***************************************************************************e $! $ NSP_NOT_FOUND: $!K $!***	Reposition to the begin of the file *********************************  $! $ close nspfiles $ open/read nspfile 'file_2n $!M $!***** The following can be found only from NSP ****************************  $! $ NO_PORT_INFO:( $!( $ if nsp_saved .eq. 0 then goto skip_nsp $!M $!***** Look if we have the values in saved ones ***************************** $!
 $ counter = 0* $!
 $ nsp_loop_2:! $!J $ if NSP_PORT .eqs. NSP_SAVE'counter'_TMP_PORT then goto found_nsp_saved_2L $ if NSP_PORT .eqs. NSP_SAVE'counter'_SCL_PORT then goto found_nsp_saved_x_2 $! $ counter = counter + 1 ) $ if counter .lt. 16 then goto nsp_loop_2  $ goto skip_nsp  $!N $!**************************************************************************** $! $ found_nsp_saved_x_2: $!' $ NSP_PORT = NSP_SAVE'counter'_TMP_PORTs $! $ found_nsp_saved_2: $!O $ wo ("====> JUHUU 0 we can use the saved values ''counter' left ''nsp_saved'")  $! $ nsp_saved = nsp_saved - 1  $!" $ NODE	   = NSP_SAVE'counter'_NODE' $ LOC_LINK = NSP_SAVE'counter'_LOC_LINK ' $ REM_LINK = NSP_SAVE'counter'_REM_LINK( $! $ goto conti $!M $!**************************************************************************** $! $ skip_nsp:* $!( $ if osi_saved .eq. 0 then goto skip_osi $!M $!***** Look if we have the values in saved ones ***************************** $!
 $ counter = 0l $!
 $ osi_loop_2:! $!J $ if NSP_PORT .eqs. OSI_SAVE'counter'_TMP_PORT then goto found_osi_saved_2L $ if NSP_PORT .eqs. OSI_SAVE'counter'_SCL_PORT then goto found_osi_saved_x_2 $! $ counter = counter + 1h) $ if counter .lt. 16 then goto osi_loop_2O $ goto skip_osi  $! $ found_osi_saved_x_2: $!' $ NSP_PORT = OSI_SAVE'counter'_TMP_PORTf $! $ found_osi_saved_2: $!O $ wo ("====> JIPII 0 we can use the saved values ''counter' left ''osi_saved'")O $! $ osi_saved = osi_saved - 1E $!" $ NODE	   = OSI_SAVE'counter'_NODE' $ LOC_LINK = OSI_SAVE'counter'_LOC_LINK ' $ REM_LINK = OSI_SAVE'counter'_REM_LINKI $! $ goto conti $!M $!**************************************************************************** $! $ skip_osi:* $! $ NODE     = "???"/ $ if f$length(NODE_X) .ne. 0 then NODE = NODE_X* $! $ LOC_LINK = " ???"* $ REM_LINK = " ???"! $! $ goto conti $!M $!**************************************************************************** $! $ found_nsp_x: $! $ NSP_PORT = TMP_PORTt $! $ found_nsp: $! $ gosub READ_NSP $! $ goto conti $!N $!****************************************************************************N $!******************* OSI port ***********************************************N $!**************************************************************************** $! $ OSI_PORT:o $!- $ if osi_saved .eq. 0 then goto next_line_016I $!N $!***** Look if we have the values in saved ones ***************************** $!
 $ counter = 0  $!
 $ osi_loop_0:  $!J $ if NSP_PORT .eqs. OSI_SAVE'counter'_TMP_PORT then goto found_osi_saved_0L $ if SCL_PORT .eqs. OSI_SAVE'counter'_SCL_PORT then goto found_osi_saved_x_0 $! $ counter = counter + 1-) $ if counter .lt. 16 then goto osi_loop_0- $ goto next_line_016 $!M $!***************************************************************************- $! $ found_osi_saved_x_0: $!' $ NSP_PORT = OSI_SAVE'counter'_TMP_PORT- $! $ found_osi_saved_0: $!P $! wo ("====> JIPII 0 we can use the saved values ''counter' left ''osi_saved'") $! $ osi_saved = osi_saved - 1  $!" $ NODE	   = OSI_SAVE'counter'_NODE' $ LOC_LINK = OSI_SAVE'counter'_LOC_LINK*' $ REM_LINK = OSI_SAVE'counter'_REM_LINK* $! $ goto conti $!K $!***	Search for "OSI$PORT" to verify we have the right port *************** $! $ next_line_016: $!6 $ read/error=error/END_OF_FILE=end_file osifile string $!+ $ string = f$edit(string,"upcase,compress")x, $ if string .eqs. "" then goto next_line_016 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr  $!0 $ if tmpstr .nes. "NODE" then goto next_line_016, $ if tmpstr .eqs. "" then goto next_line_016 $!B $ TMP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 10 , 30, string) $! $ !xxxxx show symbol TMP_PORT2 $!L $!***	Search for "Client Name" ********************************************* $! $ next_line_021: $!6 $ read/error=error/END_OF_FILE=end_file osifile string $!+ $ string = f$edit(string,"upcase,compress")", $ if string .eqs. "" then goto next_line_021 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstrg $!2 $ if tmpstr .nes. "CLIENT" then goto next_line_021, $ if tmpstr .eqs. "" then goto next_line_021 $!< $ tmpstr = F$EXTRACT(F$LOCATE("=", string) + 1 , 40 ,string) $! $ !xxxxx show symbol tmpstrf $!E $ SCL_OSI_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)o $!! $ !xxxxx show symbol SCL_OSI_PORTs $!0 $ if NSP_PORT .eqs. TMP_PORT then goto found_osi6 $ if SCL_PORT .eqs. SCL_OSI_PORT then goto found_osi_x $!M $!***************************************************************************yM $!**** OSI ports are out of order ********************************************M $!***************************************************************************l $!M $!**** Save the values for this port into OSI ring buffer *******************e $! $ gosub READ_OSI $! $ !xxxxx show symbol TMP_PORTg $ !xxxxx show symbol LOC_LINKA $ !xxxxx show symbol REM_LINKs $! $ osi_saved = osi_saved + 1t $!C $! wo ("********* Save OSI values ''osi_counter' now ''osi_saved'")o $!/ $ OSI_SAVE'osi_counter'_SCL_PORT = SCL_OSI_PORT!+ $ OSI_SAVE'osi_counter'_TMP_PORT = TMP_PORTo$ $ OSI_SAVE'osi_counter'_NODE	 = NODE+ $ OSI_SAVE'osi_counter'_LOC_LINK = LOC_LINKO+ $ OSI_SAVE'osi_counter'_REM_LINK = REM_LINKC $! $ osi_counter = osi_counter + 1 - $ if osi_counter .gt. 15 then osi_counter = 0s $! $!B $!      We might have the case "Transport Port = <Default value>",A $!      read one NSP port and if no match then read one OSI port.O $!	If both fail, then skip.! $!. $ if temp_p .eqs. "<DE" then goto NO_PORT_INFO $!M $!***************************************************************************xM $!*** OSI Port not found, Scan osifile ***************************************M $!***************************************************************************E $! $ scan_osi:e $!M $!***   Scan first the next 15 entries for the OSI$PORT *********************e $!
 $ counter = 0  $! $ next_line_YYY016:i $!= $ read/error=error/END_OF_FILE=OSI_NOT_FOUND_X osifile stringo $!+ $ string = f$edit(string,"upcase,compress")N/ $ if string .eqs. "" then goto next_line_YYY016e $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr0 $!3 $ if tmpstr .nes. "NODE" then goto next_line_YYY016!/ $ if tmpstr .eqs. "" then goto next_line_YYY016* $!B $ TMP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 10 , 30, string) $! $ !xxxxx show symbol TMP_PORT  $!K $!***	Search for "Client Name" ********************************************o $! $ next_line_X021:s $!6 $ read/error=error/END_OF_FILE=end_file osifile string $!+ $ string = f$edit(string,"upcase,compress")f- $ if string .eqs. "" then goto next_line_X021  $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstr= $!3 $ if tmpstr .nes. "CLIENT" then goto next_line_X021p- $ if tmpstr .eqs. "" then goto next_line_X021s $!< $ tmpstr = F$EXTRACT(F$LOCATE("=", string) + 1 , 40 ,string) $! $ !xxxxx show symbol tmpstr* $!E $ SCL_OSI_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 5 , 30, string)e $!! $ !xxxxx show symbol SCL_OSI_PORTn $!P $! if NSP_PORT .eqs. TMP_PORT then $ wo (" ====> JIPPII OSI counter ''counter'")0 $ if NSP_PORT .eqs. TMP_PORT then goto found_osi6 $ if SCL_PORT .eqs. SCL_OSI_PORT then goto found_osi_x $! $ counter = counter + 1p. $ if counter .eq. 15 then goto OSI_NOT_FOUND_X $!M $!****** Save values for this port into OSI ring buffer *********************O $! $ gosub READ_OSI $! $ osi_saved = osi_saved + 1r $!C $! wo ("********* Save OSI values ''osi_counter' now ''osi_saved'")* $!+ $ OSI_SAVE'osi_counter'_TMP_PORT = TMP_PORT*$ $ OSI_SAVE'osi_counter'_NODE	 = NODE+ $ OSI_SAVE'osi_counter'_LOC_LINK = LOC_LINK + $ OSI_SAVE'osi_counter'_REM_LINK = REM_LINKs $!3 $ !xxxxx show symbol OSI_SAVE'osi_counter'_TMP_PORTm $! $ osi_counter = osi_counter + 1m- $ if osi_counter .gt. 15 then osi_counter = 0o $! $ goto next_line_YYY016p $!M $!***************************************************************************e $! $ OSI_NOT_FOUND_X: $!M $!***** Scan from beginning of the file *************************************x $! $!	Close and reopen osifileN $!G $ wo ("======> OSI ports badly out of order, need to scan the file...")p $! $ close osifilet $ open/read osifile 'file_3  $!K $!***	Scan for the OSI$PORT ***********************************************N $! $ next_line_Y16: $!; $ read/error=error/END_OF_FILE=OSI_NOT_FOUND osifile string* $!+ $ string = f$edit(string,"upcase,compress") , $ if string .eqs. "" then goto next_line_Y16 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 4, tmpstr) $! $ !xxxxx show symbol tmpstr* $!0 $ if tmpstr .nes. "NODE" then goto next_line_Y16, $ if tmpstr .eqs. "" then goto next_line_Y16 $!B $ TMP_PORT = F$EXTRACT(F$LOCATE("PORT", string) + 10 , 30, string) $! $ !xxxxx show symbol TMP_PORT* $!0 $ if NSP_PORT .eqs. TMP_PORT then goto found_osi $! $ goto next_line_Y16 $!M $!***************************************************************************u $! $ OSI_NOT_FOUND: $!L $!*** 	Reposition to the begin of the file ********************************* $! $ close osifile  $ open/read osifile 'file_3! $!M $!***** The following can be found only from OSI ****************************! $! $ NODE     = "???" $ LOC_LINK = " ???"! $ REM_LINK = " ???": $! $ goto conti $!M $!***************************************************************************e $! $ found_osi_x: $! $ NSP_PORT = TMP_PORTu $! $ found_osi: $! $ gosub READ_OSI $!N $!****************************************************************************N $!********** We have now all the information for this port *******************N $!**************************************************************************** $! $ conti: $! $!	 tmp = F$LOCATE("=",string)9 $!	 tmpstr = F$EXTRACT(0,F$LOCATE("Local",string),string)r $!_ $!   REM  LOC   DIRECTION  REMOTE USER      PID       PROCESS NAME     NODE   LOCAL USER   PORTr $! $!G $ if f$length(NODE) .eq. 0 then NODE = NODE_X	! (LOCAL:.mynode) missing J $ if f$length(NODE) .eq. 0 then NODE = "???"	! Neither in "Node Name Sent" $! $!@ $!               REM LOC   DIR   LUSER   PID  PNAM  RU  NOD LINKH $ text = f$fao("!7AS !7AS !10AS !20AS !10AS!15AS !27AS   !6AS  !20AS", -M 	REM_LINK, LOC_LINK, DIRECTION, LUSER, PID, PROC_NAME, RUSER, NODE, NSP_PORT)t $! $!	12345678901234567890123456* $!	[145003,20040]KUDA_STARTUPn $!	 $ wo texte! $ write/error=error outfile  text  $! $ total = total + 1i $! $ goto BIG_LOOPp $!N $!****************************************************************************N $!********** Oops, something went wrong **************************************N $!**************************************************************************** $! $ error: $ end_file:e $! $ wo ("--------------  ---------   ---------------     --------  ---------------  ---------------------------  ------  ---------------") $ write/error=error outfile  "--------------  ---------   ---------------     --------  ---------------  ---------------------------  ------  ---------------"} $ wo (" REM     LOC    DIRECTION   LOCAL USER          PID       PROCESS NAME     REMOTE USER                  NODE    PORT")P $ write/error=error outfile  " REM     LOC    DIRECTION   LOCAL USER          PID       PROCESS NAME     REMOTE USER                  NODE    PORT" 
 $ wo (" ")  $ write/error=error outfile  " " $ wo (" Total ''total' Links")4 $ write/error=error outfile  " Total ''total' Links"
 $ wo (" ")  $ write/error=error outfile  " " $! $!: $ wo (" Screen output is stored in the file ''link_file'")
 $ wo (" ") $!M $!***************************************************************************_ $! $ clean_up:P $! $ ON CONTROL_Y THEN GOTO exit_ $! $ close tempfile $ close nspfile  $ close osifile  $ close outfilet $!( $ if p1 .eqs. "x" then goto skip1	! test( $ if p1 .eqs. "X" then goto skip1	! test( $ if p1 .eqs. "y" then goto skip1	! test( $ if p1 .eqs. "Y" then goto skip1	! test $! $!	Delete temporary filesP $! $  if DEBUG .eq. 0 $  then  $ DELETE/NOLOG 'file'm $ DELETE/NOLOG 'file_2'r $ DELETE/NOLOG 'file_3'  $  elsen $ wo ("	For debug purposes:")*= $ wo ("		SCL port information is stored in the file ''file'")*? $ wo ("		NSP port information is stored in the file ''file_2'")*? $ wo ("		OSI port information is stored in the file ''file_3'")*
 $ wo ("	") $  endif $! $ skip1: $!# $ if set_term .eq. 0 then goto exitx $! $ tmp = "Y"t $!Y $ INQUIRE TMP "Do you want the terminal width set back to ''screen_width' [y/n, Def=y]? "e $!! $ if tmp .eqs. "N" then goto exit!! $ if tmp .eqs. "n" then goto exitP $! $ set term/width='screen_width't $! $exit: $! $ exit $! $!N $!****************************************************************************N $!********* Subroutine read from NSP file ************************************N $!**************************************************************************** $! $ READ_NSP:n $!L $!***	Search for "Remote NSAP" ********************************************* $! $ next_line_6: $!6 $ read/error=error/END_OF_FILE=end_file nspfile string $!+ $ string = f$edit(string,"upcase,compress")	* $ if string .eqs. "" then goto next_line_6 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstr! $!0 $ if tmpstr .nes. "REMOTE" then goto next_line_6* $ if tmpstr .eqs. "" then goto next_line_6 $! $!@ $ tmpstr = F$EXTRACT(F$LOCATE("LOCAL:", string) + 7 , 6 ,string) $ tmp    = F$LOCATE(")",tmpstr) " $ NODE   = F$EXTRACT(0,tmp,tmpstr) $! $! $ !xxxxx show symbol NODEs $! $!L $!***	Search for "Local Reference" ***************************************** $! $ next_line_7: $!6 $ read/error=error/END_OF_FILE=end_file nspfile string $!+ $ string = f$edit(string,"upcase,compress")x* $ if string .eqs. "" then goto next_line_7 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 5, tmpstr) $! $ !xxxxx show symbol tmpstrf $!/ $ if tmpstr .nes. "LOCAL" then goto next_line_7f* $ if tmpstr .eqs. "" then goto next_line_7 $!= $ LOC_LINK = F$EXTRACT(F$LOCATE("=", string) + 1 , 6 ,string)u $! $ !xxxxx show symbol LOC_LINKa $! $!L $!***	Search for "Remote Reference" **************************************** $! $ next_line_8: $!6 $ read/error=error/END_OF_FILE=end_file nspfile string $!+ $ string = f$edit(string,"upcase,compress")=* $ if string .eqs. "" then goto next_line_8 $!  $ tmpstr = f$edit(string,"TRIM") $!" $ tmpstr = F$EXTRACT(0, 6, tmpstr) $! $ !xxxxx show symbol tmpstr  $!0 $ if tmpstr .nes. "REMOTE" then goto next_line_8* $ if tmpstr .eqs. "" then goto next_line_8 $!= $ REM_LINK = F$EXTRACT(F$LOCATE("=", string) + 1 , 6 ,string)* $! $ !xxxxx show symbol REM_LINK! $! $ return $!N $!****************************************************************************N $!********* Subroutine read from OSI file ************************************N $!**************************************************************************** $! $ READ_OSI:! $!L $!***	Search for "Remote NSAP" ********************************************* $! $ next_line_16:  $!6 $ read/error=error/END_OF_FILE=end_file osifile string $!+ $ string = f$edit(string,"upcase,compress") + $ if string .eqs. "" then goto next_line_16  $!  $ tmpstr = f$edit(string,"TRIM") $!# $ tmpstr = F$EXTRACT(0, 11, tmpstr)! $! $ !xxxxx show symbol tmpstr! $!6 $ if tmpstr .nes. "REMOTE NSAP" then goto next_line_16+ $ if tmpstr .eqs. "" then goto next_line_16M $!@ $ tmpstr = F$EXTRACT(F$LOCATE("LOCAL:", string) + 7 , 6 ,string) $ tmp    = F$LOCATE(")",tmpstr) " $ NODE   = F$EXTRACT(0,tmp,tmpstr) $! $ !xxxxx show symbol NODEi $! $!L $!***	Search for "Local Reference" ***************************************** $! $ next_line_17:O $!6 $ read/error=error/END_OF_FILE=end_file osifile string $!+ $ string = f$edit(string,"upcase,compress") + $ if string .eqs. "" then goto next_line_17  $!  $ tmpstr = f$edit(string,"TRIM") $!# $ tmpstr = F$EXTRACT(0, 15, tmpstr)R $! $ !xxxxx show symbol tmpstr  $!: $ if tmpstr .nes. "LOCAL REFERENCE" then goto next_line_17+ $ if tmpstr .eqs. "" then goto next_line_17  $!= $ LOC_LINK = F$EXTRACT(F$LOCATE("=", string) + 1 , 6 ,string)E $! $ !xxxxx show symbol LOC_LINKn $! $!L $!***	Search for "Remote Reference" **************************************** $! $ next_line_18:o $!6 $ read/error=error/END_OF_FILE=end_file osifile string $!+ $ string = f$edit(string,"upcase,compress")*+ $ if string .eqs. "" then goto next_line_18* $!  $ tmpstr = f$edit(string,"TRIM") $!# $ tmpstr = F$EXTRACT(0, 16, tmpstr)  $! $ !xxxxx show symbol tmpstr= $!; $ if tmpstr .nes. "REMOTE REFERENCE" then goto next_line_18v+ $ if tmpstr .eqs. "" then goto next_line_18  $!= $ REM_LINK = F$EXTRACT(F$LOCATE("=", string) + 1 , 6 ,string)L $! $ !xxxxx show symbol REM_LINKn $! $ return $!N $!**************************************************************************** $!