 /* **++ **  FACILITY:	NEWSRDR  **' **  ABSTRACT:	Article-related routines.  ** **  MODULE DESCRIPTION:  **B **  	This module contains routines that deal directly with article
 **  handling.  ** **  AUTHOR: 	    M. Madison 6 **  	    	    COPYRIGHT  1993, 1994 MADGOAT SOFTWARE." **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  06-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	06-SEP-1992 V1.0    Madison 	Initial coding. G **  	13-SEP-1992 V1.0-1  Madison 	Slight cache management improvements. ? **  	13-OCT-1992 V1.0-2  Madison 	Work around $FAO !AZ problem. @ **  	16-OCT-1992 V1.0-3  Madison 	Fix signature file line count.< **  	15-FEB-1993 V1.0-4  Madison 	Fix LIB$SIGNAL references.H **  	15-FEB-1993 V1.1    Madison 	Replace Mark_Xref_Seen with Mark_Xref.3 **  	12-APR-1993 V1.2    Madison 	Add Edit_Article. I **  	22-AUG-1993 V1.2-1  Madison 	Trim trailing blanks from header lines. = **  	21-SEP-1993 V1.3    Madison 	Add authentication support. 3 **  	22-SEP-1993 V1.4    Madison 	Add XHDR support. ; **  	23-SEP-1993 V1.5    Madison 	Add Check_For_Holes, etc. G **  	28-SEP-1993 V1.5-1  Madison 	Fix Get_One_Header header allocation. ? **  	30-SEP-1993 V1.5-2  Madison 	Another fix for XHDR support. F **  	02-OCT-1993 V1.5-3  Madison 	Fix another bug in Get_Article_Hdrs.0 **  	09-OCT-1993 V1.6    Madison 	Fix up header.3 **  	26-OCT-1993 V1.6-1  Madison 	Another XHDR fix. J **  	15-JAN-1994 V1.6-2  Madison 	Handle nosucharticle status differently.E **  	16-MAR-1994 V1.7    Madison 	Add support for kill by message-id. 9 **  	13-APR-1994 V1.8    Madison 	Start of XOVER support. @ **  	29-APR-1994 V1.8-1  Madison 	Fixup of XHDR & XOVER support.H **  	25-MAY-1994 V1.8-2  Madison 	Wasn't caching (none) replies on XHDR.K **  	01-JUN-1994 V1.8-3  Madison 	Fix ACCVIO processing bad XOVER response. E **  	06-JUL-1994 V1.8-4  Madison 	Fix another XOVER bad-reply ACCVIO. < **  	09-JAN-1995 V1.8-5  Madison 	Fix XHDR bad-reply ACCVIO. **-- */ #include "newsrdr.h" #include "globals.h"       struct ART {     	struct QUE *hdrqptr;      	unsigned int bodyunit;      	int lines;      	int hlines;     	int remlines;     	int status;    #define ART_K_STATUS_RETRIEVED	0! #define ART_K_STATUS_IN_HEADERS	1  #define ART_K_STATUS_IN_BODY	2 #define ART_K_STATUS_DONE   	3       	struct HDR *hlnptr;     	int artnum;     	struct GRP *grpptr;      	char bodyfspec[FSPEC_SIZE];     };   #define XHDR_COUNT 7' #define XHDR_MASK (~((-1)<<XHDR_COUNT)) )     static int xhdr_codes[XHDR_COUNT] = { >     	NEWS_K_HDR_SUBJECT, NEWS_K_HDR_FROM, NEWS_K_HDR_KEYWORDS,>     	NEWS_K_HDR_LINES, NEWS_K_HDR_DATE, NEWS_K_HDR_MESSAGE_ID,     	NEWS_K_HDR_REFERENCES}; #define XHDR_CODE_LINES 3    /*E **  The values in this vector are indices into the xhdr_codes vector.  */5     static int xover_hdrs[] = {0, 1, 4, 5, 6, -1, 3};        struct CHDR {       	struct CHDR *flink, *blink;     	struct QUE hdrq; #     	struct HDR *xhdrs[XHDR_COUNT];      	unsigned int have_xhdrs;  #define CHDR_M_SUBJECT	(1<<0)  #define CHDR_M_FROM 	(1<<1)  #define CHDR_M_KEYWORDS	(1<<2) #define CHDR_M_LINES	(1<<3)  #define CHDR_M_DATE 	(1<<4)   #define CHDR_M_MESSAGE_ID (1<<5)  #define CHDR_M_REFERENCES (1<<6)     	int have_all_headers;     	int artnum;     	int hlines;     }; /* ** Forward declarations  */N     unsigned int Retrieve_Article(int, struct ART **, char *, char *, char *);2     unsigned int Show_Article_Page(struct ART **);/     void         Rewind_Article(struct ART **); .     void         Close_Article(struct ART **);-     static void  wipe_article(struct ART **); 6     int          Mark_Article_Seen(struct GRP *, int);8     int          Mark_Article_Unseen(struct GRP *, int);(     void         Mark_Xref(char *, int);=     int          Next_Unseen_Article(int, int, struct GRP *); ,     int          Count_Unseen(struct GRP *);9     unsigned int Post_Article(struct QUE *, char *, int); P     unsigned int Get_Article_Hdrs(struct GRP *, int, struct QUE **, int, int *);G     unsigned int Get_One_Header(struct GRP *, int, int, struct HDR **); 4     int	    	 Preload_Cache(struct GRP *, int, int);C     unsigned int Get_Article_Body(int, char *, char *, int *, int); 3     int          Ignore_Article(struct GRP *, int); -     unsigned int Edit_Article(struct ART **); #     unsigned int Article_ExH(void); 6     void    	 Check_For_Holes(struct GRP *, int, int);2     int	    	 Is_Valid_Article(struct GRP *, int);.     int	    	 Article_Seen(struct GRP *, int);*     static void	 Cache_Init(struct GRP *);*     static struct CHDR *Cache_Lookup(int);;     static struct CHDR *Cache_Add(struct CHDR *, int, int);         EXTERN struct GRP *curgroup;"     EXTERN int        rotate_text;'     EXTERN int	      Read_Full_Headers;      EXTERN int	      pb_cols;        static struct ART *artsave; 8     static struct QUE hdrcache = {&hdrcache, &hdrcache};&     static struct GRP *hcgroup = NULL;     static int hccount = 0; -     static int hdrcache_remove_from_tail = 0;   1     extern void Parse_Xref(char *, struct QUE *); *     extern struct GRP *Find_Group(char *);1     extern void Make_Return_Address(char *, int); I     extern unsigned int Parse_Headers(struct QUE *, struct QUE *, int *); #     extern void mem_initcache(int); +     extern struct CHDR *mem_getcache(void); -     extern void mem_freecache(struct CHDR *); #     extern void mem_delcache(void); <     extern unsigned int get_cmd_noecho(char *, int, char *);   /* **++ **  ROUTINE:	Retrieve_Article  ** **  FUNCTIONAL DESCRIPTION:  **8 **  	Retrieves an entire article, both headers and body. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **Z **  	Retrieve_Article(int artnum, struct ART **ctxp, char *tsubj, char *xref, char *msgid) **, ** artnum: article number, integer, by valueH ** ctxp:   pointer to internally-defined structure, modify, by reference= ** tsubj:  character string, write only, by reference (ASCIZ) = ** xref:   character string, write only, by reference (ASCIZ) = ** msgid:  character string, write only, by reference (ASCIZ)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */d unsigned int Retrieve_Article(int artnum, struct ART **ctxp, char *tsubj, char *xref, char *msgid) {       struct ART *ctx = *ctxp;     char tmp[STRING_SIZE], *cp;      struct HDR *hdr;     int reply_code;      unsigned int status;   /*C ** We cache one entire article, making CURRENT and EXTRACT a little J ** faster.  A larger cache may be appropriate for some time in the future. */     ctx = NULL;      if (artsave != NULL) {D     	if (artnum == artsave->artnum && artsave->grpptr == curgroup) {     	    ctx = artsave;      	    artsave = NULL;
     	} else {       	    wipe_article(&artsave);     	}     }    /*  ** Establish new article context */     if (ctx == NULL) {&     	ctx = malloc(sizeof(struct ART));(     	memset(ctx, 0, sizeof(struct ART));     	ctx->artnum = artnum;     	ctx->grpptr = curgroup;     }    /* ** Fetch the article headers */     *ctxp = ctx;P     status = Get_Article_Hdrs(curgroup, artnum, &ctx->hdrqptr, 0, &ctx->hlines);     if (!OK(status)) {     	wipe_article(ctxp);     	return status;      }    /*4 ** Find the Subject:, Message-ID:, and Xref: headers */#     *tsubj = *xref = *msgid = '\0';   F     for (hdr = ctx->hdrqptr->head; hdr != (struct HDR *) ctx->hdrqptr;!     	    	    hdr = hdr->flink) { +     	if (hdr->code == NEWS_K_HDR_SUBJECT) {      	    strcpy(tmp, hdr->str);      	    upcase(tmp); +     	    if (strncmp(tmp, "RE:", 3) == 0) {      	    	cp = tmp+3;      	    } else {      	    	cp = tmp; 
     	    }#     	    while (isspace(*cp)) cp++;      	    strcpy(tsubj, cp); N     	    for (cp = tsubj+strlen(tsubj); cp > tsubj && isspace(*(cp-1)); cp--);     	    *cp = '\0';/     	} else if (hdr->code == NEWS_K_HDR_XREF) {       	    strcpy(xref, hdr->str);5     	} else if (hdr->code == NEWS_K_HDR_REFERENCES) { !     	    strcpy(msgid, hdr->str); G     	} else if (hdr->code == NEWS_K_HDR_MESSAGE_ID && *msgid == '\0') { !     	    strcpy(msgid, hdr->str);      	}     }    /* ** Fetch the article body  */$     if (ctx->bodyfspec[0] == '\0') {'     	make_temp_fspec(tmp, sizeof(tmp)); L     	status = Get_Article_Body(artnum, tmp, ctx->bodyfspec, &ctx->lines, 1);     	if (!OK(status)) {      	    wipe_article(ctxp);     	    return status;      	}     }    /*& ** Set things up for Show_Article_Page */     ctx->bodyunit = 0;)     ctx->status = ART_K_STATUS_RETRIEVED; %     ctx->hlnptr = ctx->hdrqptr->head; 1     ctx->remlines = ctx->hlines + ctx->lines + 1;        return SS$_NORMAL;   } /* Retrieve_Article */   /* **++ **  ROUTINE:	Show_Article_Page ** **  FUNCTIONAL DESCRIPTION:  **1 **  	Displays the next screen page of an article.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **) **  	Show_Article_Page(struct ART **ctxp)  **F ** ctxp: pointer to internally-defined structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: 3 **  	SS$_NORMAL: 	    Normal successful completion. M **  	NEWS__EOARTICLE:    Normal completion; article has been fully displayed.  ** **  SIDE EFFECTS:   	None. ** **-- */3 unsigned int Show_Article_Page(struct ART **ctxp) {        struct ART *ctx = *ctxp;&     struct GRP *grp = (*ctxp)->grpptr;     struct HDR *hdr;     struct dsc$descriptor sdsc;      char tmp[STRING_SIZE];     short tlen;      int len;     unsigned int status;Y     static $DESCRIPTOR(alphabet, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"); Y     static $DESCRIPTOR(rotabet,  "NOPQRSTUVWXYZABCDEFGHIJKLMnopqrstuvwxyzabcdefghijklm");    /*B ** This is done first - just after the article has been retrieved. */0     if (ctx->status == ART_K_STATUS_RETRIEVED) {I     	static $DESCRIPTOR(ctrstr, "article !UL of [!UL,!UL] (!UL unseen)"); !     	char tmp2[STRING_SIZE], *cp; !     	int i = strlen(grp->grpnam); (     	INIT_SDESC(sdsc, sizeof(tmp), tmp);>     	sys$fao(&ctrstr, &tlen, &sdsc, ctx->artnum, grp->frstavl,+     	    	grp->lastavl, Count_Unseen(grp));      	*(tmp+tlen) = '\0';     	if (tlen+i < pb_cols) {#     	    strcpy(tmp2, grp->grpnam); E     	    for (cp = tmp2+i; cp < tmp2+(pb_cols-tlen); cp++) *cp = ' ';      	    strcpy(cp, tmp); &     	} else strcpy(tmp2, grp->grpnam);     	Begin_Paged_Output(tmp2);+     	ctx->status = ART_K_STATUS_IN_HEADERS;      }    /* ** Header display  */1     if (ctx->status == ART_K_STATUS_IN_HEADERS) { 9     	while (ctx->hlnptr != (struct HDR *) ctx->hdrqptr) {      	    ctx->remlines--; !     	    if (Read_Full_Headers) { :     	    	Format_Header(ctx->hlnptr, tmp, sizeof(tmp), 0);@     	    	if (!Put_Paged(tmp, ctx->remlines)) return SS$_NORMAL;     	    } else { ,     	    	for (hdr = news_prof.hdrlist.head;8     	    	    	hdr != (struct HDR *) &news_prof.hdrlist;"     	    	    	hdr = hdr->flink) {3     	    	    if (hdr->code == ctx->hlnptr->code) { ?     	    	    	Format_Header(ctx->hlnptr, tmp, sizeof(tmp), 0); E     	    	    	if (!Put_Paged(tmp, ctx->remlines)) return SS$_NORMAL;      	    	    	break;      	    	    }      	    	} 
     	    }*     	    ctx->hlnptr = ctx->hlnptr->flink;     	}   /*$ ** Setup for display of article body */A     	status = file_open(ctx->bodyfspec, &ctx->bodyunit, 0, 0, 0);      	if (!OK(status)) { =     	    lib$signal(NEWS__BODYERR, 2, strlen(ctx->bodyfspec), +     	    	    	    ctx->bodyfspec, status);      	    ctx->bodyunit = 0; )     	    ctx->status = ART_K_STATUS_DONE; 
     	} else { ,     	    ctx->status = ART_K_STATUS_IN_BODY;     	    ctx->remlines--; >     	    if (!Put_Paged("", ctx->remlines)) return SS$_NORMAL;     	}     }    /* ** Display of article body */.     if (ctx->status == ART_K_STATUS_IN_BODY) {E     	while (OK(file_read(ctx->bodyunit, tmp, sizeof(tmp)-1, &len))) {      	    ctx->remlines--;      	    *(tmp+len) = '\0';      	    if (rotate_text) { %     	    	struct dsc$descriptor tdsc; !     	    	char tmp2[STRING_SIZE]; %     	    	INIT_SDESC(sdsc, len, tmp); &     	    	INIT_SDESC(tdsc, len, tmp2);     	    	*(tmp2+len) = '\0'; ;     	    	str$translate(&tdsc, &sdsc, &alphabet, &rotabet); 
     	    	A     	    	if (!Put_Paged(tmp2, ctx->remlines)) return SS$_NORMAL; F     	    } else if (!Put_Paged(tmp, ctx->remlines)) return SS$_NORMAL;     	}  %     	ctx->status = ART_K_STATUS_DONE;        }    /*
 ** Completion  */       if (Paged_Output_Done()) {7     	if (ctx->bodyunit != 0) file_close(ctx->bodyunit);      	ctx->bodyunit = 0;      	artsave = ctx;      	return NEWS__EOARTICLE;     }        return SS$_NORMAL;   } /* Show_Article_Page */    /* **++ **  ROUTINE:	Rewind_Article  ** **  FUNCTIONAL DESCRIPTION:  **9 **  	Sets up an article for redisplay from the beginning.  ** **  RETURNS:	void  ** **  PROTOTYPE: **& **  	Rewind_Article(struct ART **ctxp) **F ** ctxp: pointer to internally-defined structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */( void Rewind_Article(struct ART **ctxp) {       struct ART *ctx = *ctxp;       Discard_Paged_Output(); "     file_setpos(ctx->bodyunit, 0);%     ctx->hlnptr = ctx->hdrqptr->head; *     ctx->status = ART_K_STATUS_IN_HEADERS;   } /* Rewind_Article */   /* **++ **  ROUTINE:	Close_Article ** **  FUNCTIONAL DESCRIPTION:  **8 **  	Closes an article, but saves the context in case we **  need it again right away.  ** **  RETURNS:	void  ** **  PROTOTYPE: **% **  	Close_Article(struct ART **ctxp)  **F ** ctxp: pointer to internally-defined structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */' void Close_Article(struct ART **ctxp) {        struct ART *ctx = *ctxp;       Discard_Paged_Output(); 6     if (ctx->bodyunit != 0) file_close(ctx->bodyunit);     ctx->bodyunit = 0;     artsave = ctx;     *ctxp = NULL;    } /* Close_Article */    /* **++ **  ROUTINE:	wipe_article  ** **  FUNCTIONAL DESCRIPTION:  **( **  	Deletes an article and its context. ** **  RETURNS:	void  ** **  PROTOTYPE: **$ **  	wipe_article(struct ART **ctxp) **F ** ctxp: pointer to internally-defined structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */- static void wipe_article(struct ART **ctxp) {        struct ART *ctx = *ctxp;       if (ctx->bodyfspec[0]) {!     	file_delete(ctx->bodyfspec);      }      free(ctx);     *ctxp = NULL;    } /* wipe_article */   /* **++ **  ROUTINE:	Mark_Article_Seen ** **  FUNCTIONAL DESCRIPTION:  **, **  	Adds an article to a group's seen list. ** **  RETURNS:	boolean ** **  PROTOTYPE: **3 **  	Mark_Article_Seen(struct GRP *grp, int artnum)  **/ ** grp:     GRP structure, modify, by reference / ** artnum:  article number, read only, by value  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: ' **  	1:  Success.  Article marked seen. $ **  	0:  Article was already marked. ** **  SIDE EFFECTS:   	None. ** **-- */4 int Mark_Article_Seen(struct GRP *grp, int artnum) {       struct RNG *r, *r2;    /*H ** The seen list is represented as a linked list of cells, each of whichN ** contains a starting and ending article number for a range of seen articles.H ** The list is kept in order and cells are merged together into one when ** they overlap. **; ** Start by finding the right cell for this article number.  */N     for (r = grp->seenq.head; r != (struct RNG *) &grp->seenq; r = r->flink) {"     	if (artnum <= r->last) break;     }  /*I ** If we found none, artnum must be higher than all articles seen so far. + ** So we tack it onto the tail of the list.  */*     if (r == (struct RNG *) &grp->seenq) {     	r = grp->seenq.tail; +     	if (r != (struct RNG *) &grp->seenq) { J     	    if (artnum == r->last+1) {     /* no new cell if just 1 higher */F     	    	r->last += 1;                                                    	    } else {      	    	r2 = mem_getrng();(     	    	r2->first = r2->last = artnum;     	    	queue_insert(r2, r);
     	    }6     	} else {                     /* list was empty */     	    r = mem_getrng();%     	    r->first = r->last = artnum; &     	    queue_insert(r, &grp->seenq);     	} /*H ** We found a cell with article numbers higher than the current article.I ** Now we check to see if we need a new cell for this article, or whether1G ** we can just update the existing cell or its predecessor in the list.9 */     } else {;     	if (artnum >= r->first) return 0; /* already marked */n     	r2 = r->blink;e?     	if (artnum == r->first-1) { 	  /* Just update this cell */t     	    r->first -= 1;VM     	    if (r2 != (struct RNG *) &grp->seenq) {  /* See if we now overlap */ J     	    	if (r2->last >= r->first-1) {        /* with predecessor; if  */J     	    	    r->first = r2->first;            /* so, coalesce the two  */J     	    	    queue_remove(r2, &r2);           /* cells into one.       */     	    	    mem_freerng(r2);     	    	} 
     	    }
     	} else { 0     	    if (r2 != (struct RNG *) &grp->seenq) {C     	    	if (artnum == r2->last+1) { 	    /* tack onto end of   */*@     	    	    r2->last += 1;  	    	    /* predecessor cell   */     	    	} else {B     	    	    r2 = mem_getrng();	    	    /* New cell required  */,     	    	    r2->first = r2->last = artnum;)     	    	    queue_insert(r2, r->blink);X     	    	}      	    } else {VC     	    	r2 = mem_getrng();  	    	    /* no previous; get new  */-H     	    	r2->first = r2->last = artnum;	    /* and stick at listhead */(     	    	queue_insert(r2, &grp->seenq);
     	    }     	}     }9  
     return 1;n   } /* Mark_Article_Seen */  V /* **++  **  ROUTINE:	Mark_Article_Unseen ** **  FUNCTIONAL DESCRIPTION:  **? **  	Removes an article from the seen-article list for a group.s ** **  RETURNS:	boolean ** **  PROTOTYPE: **5 **  	Mark_Article_Unseen(struct GRP *grp, int artnum); **/ ** grp:	    GRP structure, modify, by reference0/ ** artnum:  article number, read only, by value_ ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:u **  	    1:	successg( **  	    0:	Article was not on seen list ** **  SIDE EFFECTS:   	None. ** **-- */6 int Mark_Article_Unseen(struct GRP *grp, int artnum) {       struct RNG *r, *r2;_   /*8 ** Locate the cell that this article number is a part of */N     for (r = grp->seenq.head; r != (struct RNG *) &grp->seenq; r = r->flink) {"     	if (artnum <= r->last) break;     }u  D     if (r == (struct RNG *) &grp->seenq) return 0;  /* none found */E     if (artnum < r->first) return 0;	    	    /* between two cells */    /*H ** If number is the boundary of the cell, just update the cell boundary,/ ** and check to see if the cell should go away.f */2     if (artnum == r->first || artnum == r->last) {(     	if (artnum == r->first) r->first++;     	else r->last--;     	if (r->first > r->last) {     	    queue_remove(r, &r);      	    mem_freerng(r);     	}     	return 1;     }r   /** ** Must break the cell up into two pieces. */     r2 = mem_getrng();     r2->first = artnum+1;v     r2->last = r->last;      r->last = artnum-1;*     queue_insert(r2, r);  
     return 1;c   } /* Mark_Article_Unseen */w _ /* **++ **  ROUTINE:	Mark_Xref ** **  FUNCTIONAL DESCRIPTION:  **E **  	Parse an Xref header and marks the referenced articles [un]seen._ ** **  RETURNS:	void  ** **  PROTOTYPE: **% **  	Mark_Xref(char *xref, int unsee)t **: ** xref: character string, read only, by reference (ASCIZ)& ** unsee: boolean, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.i ** **  COMPLETION CODES:	None.r ** **  SIDE EFFECTS:   	None. ** **-- */' void Mark_Xref(char *xref, int unsee) {t       struct QUE grpq;     struct HDR *h;     struct GRP *g;  "     grpq.head = grpq.tail = &grpq;     Parse_Xref(xref, &grpq);)     while (queue_remove(grpq.head, &h)) {a     	g = Find_Group(h->str);     	if (g != NULL) {r     	    if (unsee) {)*     	    	Mark_Article_Unseen(g, h->code);     	    } else {d(     	    	Mark_Article_Seen(g, h->code);
     	    }     	}     	mem_freehdr(h);     }    } /* Mark_Xref */s c /* **++  **  ROUTINE:	Next_Unseen_Article ** **  FUNCTIONAL DESCRIPTION:i **H **  	Finds the next unseen article in a group (or in the current group). ** **  RETURNS:	article numberu ** **  PROTOTYPE: **B **  	Next_Unseen_Article(int artnum, int nocheck, struct GRP *grp) **/ ** artnum:  article number, read only, by valueE( ** nocheck: boolean, read only, by value2 ** grp:	    GRP structure, read only, by reference **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.; ** **  COMPLETION CODES:0 **  	non-0:	next unseen articlee$ **  	    0:  no unseen articles left ** **  SIDE EFFECTS:   	None. ** **-- */C int Next_Unseen_Article(int artnum, int nocheck, struct GRP *grp) {h       struct RNG *r;
     int a;  $     if (grp == NULL) grp = curgroup;>     a = (grp->frstavl > artnum + 1) ? grp->frstavl : artnum+1;(     if (artnum > grp->lastavl) return 0;       while (1) {a   /*( ** Check to see if it's on the seen list */O     	for (r = grp->seenq.tail; r != (struct RNG *) &grp->seenq; r = r->blink) {+"     	    if (a >= r->first) break;     	}+     	if (r != (struct RNG *) &grp->seenq) {      	    if (a <= r->last) {     	    	a = r->last+1;!     	    	if (a > grp->lastavl) {r     	    	    a = 0;     	    	    break;     	    	}_
     	    }     	}     	if (a > grp->lastavl) {     	    a = 0;r     	    break;a     	} /*D ** Normally, we STAT the article to see if it actually exists on theD ** server, but we don't have to if XHDR is used (different mechanism ** for finding holes). */     	if (!nocheck) {  0     	    static $DESCRIPTOR(ctrstr, "STAT !UL");$     	    struct dsc$descriptor sdsc;     	    char tmp[STRING_SIZE];I     	    short tlen;     	    int reply_code, i;   +     	    i = Is_Valid_Article(curgroup, a);l     	    if (i > 0) break;     	    else if (i < 0) {/     	    	INIT_SDESC(sdsc, sizeof(tmp)-1, tmp); ,     	    	sys$fao(&ctrstr, &tlen, &sdsc, a);     	    	*(tmp+tlen) = '\0';u     	    	server_send(tmp);r>     	    	server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);1     	    	if (reply_code == NNTP__TEXTSEPARATE) {n"     	    	    if (grp->valid != 0)8     	    	    	grp->valid[a-grp->frstavl] = GRP_K_VALID;     	    	    break;     	    	} else {-     	    	    Mark_Article_Seen(curgroup, a); "     	    	    if (grp->valid != 0):     	    	    	grp->valid[a-grp->frstavl] = GRP_K_INVALID;     	    	}e
     	    }     	} else break;     	a += 1;     }a  
     return a;    } /* Next_Unseen_Article */c c /* **++ **  ROUTINE:	Count_Unseen  ** **  FUNCTIONAL DESCRIPTION:) **5 **  	Counts the number of unseen articles in a group.n **  **  RETURNS:	int (article count) ** **  PROTOTYPE: **  **  	Count_Unseen(struct GRP *g) **, ** g:	GRP structure, read only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.) ** **  COMPLETION CODES:;' **  	-1: 	something is very wrong here!F1 **  	not -1: that's the number of unseen articles/ ** **  SIDE EFFECTS:   	None. ** **-- */! int Count_Unseen(struct GRP *g) {!       struct RNG *r, *r2;t     int s, a, b, count;d       s = g->frstavl-1;r'     if (s > g->lastavl) s = g->lastavl; 5     if (g->lastavl == 0 && g->frstavl == 0) return 0;      r = g->seenq.head;(     if (r == (struct RNG *) &g->seenq) {2     	return (g->lastavl-s > 0) ? g->lastavl-s : 0;     }        count = 0;     while (1) {      	r2 = r->flink; #     	a = r->last > s ? r->last : s;b(     	if (a > g->lastavl) a = g->lastavl;*     	if (r2 == (struct RNG *) &g->seenq) {#     	    return count+g->lastavl-a;      	}'     	b = r2->first > s ? r2->first : s;d(     	if (b > g->lastavl) b = g->lastavl;+     	count = count + (b-a > 1 ? b-a-1 : 0);-     	r = r2;     }E  -     return -1;  /* should never reach here */s   } /* Count_Unseen */   /* **++ **  ROUTINE:	Post_Article  ** **  FUNCTIONAL DESCRIPTION:= **5 **  	Sends an article to the NNTP server for posting.a **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	Post_Article(struct QUE *hdrq, char *fspec, int use_signature)  **/ ** hdrq:    QUE structure, modify, by reference F ** fspec:   file specification, read only, by reference (ASCIZ string). ** use_signature: boolean, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: 2 **  	SS$_NORMAL: 	Article was successfully posted.( **  	NEWS__POSTERR:	Some error occurred. ** **  SIDE EFFECTS:   	None. ** **-- */M unsigned int Post_Article(struct QUE *hdrq, char *fspec, int use_signature) {T       char tmp[STRING_SIZE];     struct dsc$descriptor sdsc;x     struct HDR *hdr;
     TIME tod;c     unsigned int unit, status;     int reply_code, len;     short tlen;T   /*/ ** Open the article body file (if there is one)N */     if (fspec) {/     	status = file_open(fspec, &unit, 0, 0, 0);r     	if (!OK(status)) {a.     	    lib$signal(NEWS__POSTERR, 0, status);     	    return NEWS__POSTERR;     	}     }l   /*' ** Prepare the server for the onslaught* */     server_send("POST");8     server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);   /* **  Authentication stuff */'     if (reply_code == NNTP__AUTHREQD) {e  8     	put_output("Authentication required for posting.");  #     	strcpy(tmp, "AUTHINFO USER ");j3     	get_cmd(tmp+14, sizeof(tmp)-14, "Username: ");      	server_send(tmp);9     	server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);i  )     	if (reply_code == NNTP__PASSWREQD) {e'     	    strcpy(tmp, "AUTHINFO PASS ");U>     	    get_cmd_noecho(tmp+14, sizeof(tmp)-14, "Password: ");     	    server_send(tmp);=     	    server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);p     	}  ,     	if (reply_code != NNTP__AUTHACCEPTED) {(     	    lib$signal(NEWS__NOPOSTING, 0);      	    return NEWS__NOPOSTING;     	}       	server_send("POST");p9     	server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);p  
     }	         +     if (reply_code != NNTP__SENDPARTICLE) {c$     	lib$signal(NEWS__NOPOSTING, 0);     	return NEWS__NOPOSTING;     }y   /*B ** Get current date and time for the couple of headers we generate */     sys$gettim(&tod);    /*A ** Format the headers and send them.  Note that this destroys theN ** header queue passed to us!h */,     while (queue_remove(hdrq->head, &hdr)) {-     	Format_Header(hdr, tmp, sizeof(tmp), 0);e     	server_send(tmp);     	mem_freehdr(hdr);     }f   /*G ** Add the standard headers.  The news system usually sorts the headers I ** into some standard arrangement, so we really don't have to worry about  ** how pretty this order looks.o */     strcpy(tmp, "From: ");.     Make_Return_Address(tmp+6, sizeof(tmp)-6);     server_send(tmp);      strcpy(tmp, "Reply-To: ");#     strcat(tmp, news_cfg.reply_to);      server_send(tmp);(  )     INIT_SDESC(sdsc, sizeof(tmp)-1, tmp);      if (news_cfg.dopath) {'     	if (news_cfg.pathstr[0] == '\0') { !     	    if (news_cfg.bangpath) {;7     	    	static $DESCRIPTOR(ctrstr, "Path: !AD!!!AD"); (     	    	sys$fao(&ctrstr, &tlen, &sdsc,=     	    	    strlen(news_cfg.node_name), news_cfg.node_name,b<     	    	    strlen(news_cfg.username), news_cfg.username);     	    	*(tmp+tlen) = '\0';)     	    } else {o6     	    	static $DESCRIPTOR(ctrstr, "Path: !AD@!AD");D     	    	sys$fao(&ctrstr, &tlen, &sdsc, strlen (news_cfg.username),<     	    	    news_cfg.username, strlen(news_cfg.node_name),"     	    	    news_cfg.node_name);     	    	*(tmp+tlen) = '\0'; 
     	    }
     	} else {u     	    strcpy(tmp, "Path: "); '     	    strcat(tmp, news_cfg.pathstr);s(     	    strcat(tmp, news_cfg.username);     	}     	server_send(tmp);     }        if (news_cfg.gendate) {      	strcpy(tmp, "Date: ");o+     	Make_Date(&tod, tmp+6, sizeof(tmp)-6);      	server_send(tmp);     }      if (news_cfg.genmsgid) {=     	static $DESCRIPTOR(ctrstr, "Message-ID: <!XL.!XL@!AD>");$9     	sys$fao(&ctrstr, &tlen, &sdsc, tod.long2, tod.long1, >     	    	    strlen(news_cfg.node_name), news_cfg.node_name);     	*(tmp+tlen) = '\0';     	server_send(tmp);     }e'     if (news_cfg.org_name[0] != '\0') {t#     	strcpy(tmp, "Organization: "); $     	strcat(tmp, news_cfg.org_name);     	server_send(tmp);     }x   /* ** End of headerss **/-     server_send("");   /*& ** Now send the body, if there is one. */     if (fspec) {     	char *cp;     	tmp[0] = '.';>     	while (OK(file_read(unit, tmp+1, sizeof(tmp)-2, &len))) {     	    *(tmp+1+len) = '\0';S.     	    cp = (*(tmp+1) == '.') ? tmp : tmp+1;     	    if (news_cfg.chrcnv) {*#     	    	char tmp2[STRING_SIZE*2]; 6     	    	(*news_cfg.chrlton)(cp, tmp2, sizeof(tmp2));     	     	server_send(tmp2);s     	    } else {y     	    	server_send(cp);
     	    }     	}       	file_close(unit);     	unit = 0;       }D   /** ** Attach signature, if we're supposed to. */  8     if (use_signature && news_prof.sigfile[0] != '\0') {;     	status = file_open(news_prof.sigfile, &unit, 0, 0, 0);t     	if (!OK(status)) { @     	    lib$signal(NEWS__SIGFERR, 2, strlen(news_prof.sigfile),.     	    	    	    news_prof.sigfile, status);
     	} else {T     	    int i;e     	    char *cp;     	    tmp[0] = '.';"     	    for (i = 0; i < 8; i++) {F     	    	if (!OK(file_read(unit, tmp+1, sizeof(tmp)-2, &len))) break;     	    	*(tmp+1+len) = '\0';/     	    	cp = (*(tmp+1) == '.') ? tmp : tmp+1;i      	    	if (news_cfg.chrcnv) {'     	    	    char tmp2[STRING_SIZE*2];T:     	    	    (*news_cfg.chrlton)(cp, tmp2, sizeof(tmp2));!     	     	    server_send(tmp2);E     	    	} else {     	       		server_send(cp);     	    	}*
     	    }     	    file_close(unit);     	    unit = 0;     	}     }    /*7 ** End of the article.  Echo the reply from the server.b */     server_send("."); 6     server_get_reply(SRV__ECHO, &reply_code, 0, 0, 0);,     if (reply_code != NNTP__ARTICLEPOSTED) {"     	lib$signal(NEWS__POSTERR, 0);     	return NEWS__POSTERR;     }        return SS$_NORMAL;   } /* Post_Article */ w /* **++ **  ROUTINE:	Get_Article_Hdrsx ** **  FUNCTIONAL DESCRIPTION:s **: **  	Retrieves an article's headers, either from the local$ **  header cache or from the server. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **F **  	Get_Article_Hdrs(struct GRP *grp, int artnum, struct QUE **hdrqp,1 **  	    	    	    	    int nosignal, int *lines))3 ** grp:	     GRP structure, read only, by reference*0 ** artnum:   article number, read only, by value? ** hdrqp:    pointer to QUE structure, write only, by referencea) ** nosignal: boolean, read only, by valueU. ** lines:    integer, write only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.t ** **  COMPLETION CODES:c/ **  	SS$_NORMAL: 	Normal successful completion.u ** **  SIDE EFFECTS:   	None. ** **-- */N unsigned int Get_Article_Hdrs(struct GRP *grp, int artnum, struct QUE **hdrqp,3     	    	    	    	    int nosignal, int *lines) {*       struct QUE tmpq;     struct CHDR *ch, *ch2;     struct HDR *hdr, *hdr2;,-     char tmp[STRING_SIZE], tmp2[STRING_SIZE];*
     char *cp;i     int reply_code, len;     unsigned int status;   /*E ** If the requested group is the group we're caching, then search thea ** cache for the headers.p */     if (hcgroup == grp) {      	ch = Cache_Lookup(artnum);v+     	if (ch != 0 && artnum == ch->artnum) {lD     	    if (ch->have_all_headers && ch->hdrq.head == &(ch->hdrq)) {     	    	if (!nosignal) {?     	    	    lib$signal(NEWS__ARTRERR, 3, strlen(grp->grpnam),I,     	    	    	    	    grp->grpnam, artnum,.     	    	    	       NEWS__NOSUCHARTICLE, 0);     	    	}h%     	    	return NEWS__NOSUCHARTICLE;*
     	    }$     	    if (ch->have_all_headers) {     	    	*hdrqp = &(ch->hdrq);e)     	    	if (lines) *lines = ch->hlines;      	    	return SS$_NORMAL;
     	    }     	} /*/ ** New group, so wipe the cache and start anew.  */     } else {     	Cache_Init(grp);=     	ch = 0;     }    /*> ** If the request is for a group other than the current group, ** coordinate with the server. */     if (grp != curgroup) {     	strcpy(tmp, "GROUP ");      	strcat(tmp, grp->grpnam);     	server_send(tmp);H     	server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp), &len);+     	if (reply_code != NNTP__GRPSELECTED) { I     	    if (!nosignal) lib$signal(NEWS__ARTRERR, 3, strlen(grp->grpnam), 5     	    	    grp->grpnam, artnum, NEWS__UNEXPRSP, 3, $     	    	    reply_code, len, tmp);     	    return NEWS__ARTRERR;     	}     }n /*" ** Get the headers from the server */$     sprintf(tmp, "HEAD %d", artnum);     server_send(tmp);sI     server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp)-1, &len);w     tmp[len] = '\0';*     if (reply_code != NNTP__HEADFOLLOWS) {     	unsigned int status; Q     	if (reply_code == NNTP__NOSUCHARTNUM || reply_code == NNTP__NOSUCHARTICLE) { N     	    if (grp->valid != 0) grp->valid[artnum-grp->frstavl] = GRP_K_INVALID;I     	    if (!nosignal) lib$signal(NEWS__ARTRERR, 3, strlen(grp->grpnam),=A     	    	    	    	grp->grpnam, artnum, NEWS__NOSUCHARTICLE, 0); &     	    status = NEWS__NOSUCHARTICLE;
     	} else {t     	    if (!nosignal) {e;     	    	lib$signal(NEWS__ARTRERR, 3, strlen(grp->grpnam),t2     	    	    grp->grpnam, artnum, NEWS__UNEXPRSP,'     	    	    3, reply_code, len, tmp); 
     	    }      	    status = NEWS__ARTRERR;     	}     	if (grp != curgroup) {2     	    strcpy(tmp, "GROUP "); '     	    strcat(tmp, curgroup->grpnam);s     	    server_send(tmp);=     	    server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);e     	}     	return status;      } G     if (grp->valid != 0) grp->valid[artnum-grp->frstavl] = GRP_K_VALID;r   /*E ** This loop reads the lines coming from the server and converts themlI ** into headers.  Servers don't usually wrap lines, but this code handles*
 ** that case.* */"     tmpq.head = tmpq.tail = &tmpq;     cp = tmp2;     tmp2[0] = '\0'; G     while (server_get_line(tmp, sizeof(tmp)-1, &len) != NEWS__EOLIST) {b     	struct HDR *hln;C2     	while (len > 0 && isspace(tmp[len-1])) len--;     	*(tmp+len) = '\0';u     	if (isspace(*tmp)) { H     	    if (len > sizeof(tmp2)-(cp-tmp2)) len = sizeof(tmp2)-(cp-tmp2);+     	    if (len > 0) memcpy(cp, tmp, len);*     	    cp += len;      	    *cp = '\0';
     	} else {c     	    int tlen;     	    if (tmp2[0]) {r     	    	tlen = strlen(tmp2);#     	    	hln = mem_gethdr(tlen+1);n     	    	hln->len = tlen;!     	    	strcpy(hln->str, tmp2); '     	    	queue_insert(hln, tmpq.tail);)
     	    }8     	    if (len > sizeof(tmp2)-1) len = sizeof(tmp2)-1;      	    memcpy(tmp2, tmp, len);     	    cp = tmp2+len;o     	    *cp = '\0';     	}     }e       if (tmp2[0]) {     	struct HDR *hln;      	int tlen;     	tlen = strlen(tmp2);f     	hln = mem_gethdr(tlen+1);     	hln->len = tlen;s     	strcpy(hln->str, tmp2);"     	queue_insert(hln, tmpq.tail);     }   #     ch2 = Cache_Add(ch, artnum, 1);m     ch2->have_all_headers = 1;   /*A ** Parse the headers, sticking the result in the cache, then wipe2H ** the original text version.  Set hdrqp to point to the cached headers. */7     Parse_Headers(&tmpq, &(ch2->hdrq), &(ch2->hlines));n;     while (queue_remove(tmpq.head, &hdr)) mem_freehdr(hdr);N   /*$ **  Set up the quick-access pointers */;     for (hdr = ch2->hdrq.head, len = 0; len != XHDR_MASK &&eA     	    	hdr != (struct HDR *) &(ch2->hdrq); hdr = hdr->flink) {M     	int i;   '     	for (i = 0; i < XHDR_COUNT; i++) {s*     	    if (hdr->code == xhdr_codes[i]) {     	    	ch2->xhdrs[i] = hdr;     	    	len |= (1<<i);     	    	break;
     	    }     	}     }*       *hdrqp = &(ch2->hdrq);$     if (lines) *lines = ch2->hlines;   /*? ** If we had changed the group on the server, change back againp */     if (grp != curgroup) {     	strcpy(tmp, "GROUP "); #     	strcat(tmp, curgroup->grpnam);e     	server_send(tmp);9     	server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);;     }i       return SS$_NORMAL;   } /* Get_Article_Hdrs */ A /* **++ **  ROUTINE:	Get_One_Headere ** **  FUNCTIONAL DESCRIPTION:e **D **  	Retrieves a single header for an article, either from the local$ **  header cache or from the server. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **L **  	Get_One_Header(struct GRP *grp, int artnum, int code, struct HDR **hdr) **3 ** grp:	     GRP structure, read only, by referencei0 ** artnum:   article number, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:t/ **  	SS$_NORMAL: 	Normal successful completion.P ** **  SIDE EFFECTS:   	None. ** **-- */B unsigned int Get_One_Header(struct GRP *grp, int artnum, int code,6     	    	    	    	    	    	    struct HDR **hdrp) {       struct QUE tmpq;     struct CHDR *ch, *ch2;     struct HDR *hdr, *hdr2; -     char tmp[STRING_SIZE], tmp2[STRING_SIZE]; 
     char *cp;L3     int reply_code, len, i, is_xover_hdr, fallback;1     unsigned int status;     static char *hdrname[] = {;     	"From", "Date", "Newsgroups", "Subject", "Message-ID",'<     	"Path", "Reply-To", "Sender", "Followup-To", "Expires",=     	"References", "Control", "Distribution", "Organization",-L     	"Keywords", "Summary", "Approved", "Lines", "Xref", "NoSuchHeader..."};   /*E ** If the requested group is the group we're caching, then search thel ** cache for the headers.  */     if (hcgroup == grp) {	     	ch = Cache_Lookup(artnum);a     } else {     	Cache_Init(grp);      	ch = 0;     }    /* **  Is it in the cache?  */*     if (ch != 0 && ch->artnum == artnum) {'     	for (i = 0; i < XHDR_COUNT; i++) {u%     	    if (code == xhdr_codes[i]) {gB     	    	if (ch->have_all_headers || (ch->have_xhdrs & (1<<i))) {#     	    	    *hdrp = ch->xhdrs[i];s      	    	    return SS$_NORMAL;     	    	}Z
     	    }     	}     	*hdrp = 0;iS     	for (hdr = ch->hdrq.head; hdr != (struct HDR *) &ch->hdrq; hdr = hdr->flink) {0!     	    if (hdr->code == code) {{     	    	*hdrp = hdr;     	    	return SS$_NORMAL;
     	    }     	}     }l   /*A **  Not in the cache.  We're going to have to talk to the server.)> **  First see if this is one of the headers returned by XOVER. */        fallback = is_xover_hdr = 0;D     for (i = 0; i < sizeof(xover_hdrs)/sizeof(xover_hdrs[0]); i++) {%     	if (xover_hdrs[i] < 0) continue; -     	if (code == xhdr_codes[xover_hdrs[i]]) {      	    is_xover_hdr = 1;     	    break;      	}     }r /*L **  If XOVER and XHDR aren't supported on the server, do a full header fetch */   Do_Full_Fetch:E     if (news_cfg.xhdr < 0 && (!is_xover_hdr || news_cfg.xover < 0)) {n     	struct QUE *hdrq;9     	status = Get_Article_Hdrs(grp, artnum, &hdrq, 1, 0);R     	if (OK(status)) {     	    *hdrp = 0;nO     	    for (hdr = hdrq->head; hdr != (struct HDR *) hdrq; hdr = hdr->flink) { "     	    	if (hdr->code == code) {     	    	    *hdrp = hdr;     	    	    break;     	    	}L
     	    }     	}     	return status;U     }e   /*> ** If the request is for a group other than the current group, ** coordinate with the server. */     if (grp != curgroup) {     	strcpy(tmp, "GROUP ");*     	strcat(tmp, grp->grpnam);     	server_send(tmp);H     	server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp), &len);?     	if (reply_code != NNTP__GRPSELECTED) return NEWS__ARTRERR;>     }    /*/ ** Try XOVER first, if this is an XOVER header.( */     hdr = 0;.     if (is_xover_hdr && news_cfg.xover >= 0) {&     	sprintf(tmp, "XOVER %d", artnum);     	server_send(tmp);J     	server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp)-1, &len);     	tmp[len] = '\0';  /*J **  If we get back a DATAFOLLOWS reply, then we parse out the XOVER headerI **  response and get back a lot more information that might come in handy=
 **  later. */+     	if (reply_code == NNTP__DATAFOLLOWS) {      	    int did_it, j, n;     	    char *cp, *anchor;c     	    struct HDR *h, *h2;       	    did_it = 0;     	    news_cfg.xover = 1;L     	    while (server_get_line(tmp, sizeof(tmp)-1, &len) != NEWS__EOLIST) {     	    	int i;     	    	tmp[len] = '\0';!     	    	cp = strchr(tmp, '\t');      	    	if (cp == 0) {     	    	    cp = tmp + len;q     	    	    fallback = 1;u     	    	}h     	    	*cp = '\0';m     	    	n = atoi(tmp);$     	    	if (n != artnum) continue;H     	    	if (grp->valid != 0) grp->valid[n-grp->frstavl] = GRP_K_VALID;     	    	anchor = cp + 1;     	    	did_it = 1;T /*; **  This is the article we want.  Let's add it to the cacher */)     	    	ch2 = Cache_Add(ch, artnum, 0);E /*0 **  Now let's get the headers from the response. */-     	    	for (i = 0; anchor < (tmp + len) &&QG     	    	    	    i < sizeof(xover_hdrs)/sizeof(xover_hdrs[0]); i++) {;(     	    	    cp = strchr(anchor, '\t');*     	    	    if (cp == 0) cp = tmp + len;&     	    	    if (xover_hdrs[i] < 0) {     	    	    	anchor = cp + 1;O     	    	    	continue;     	    	    }N!     	    	    if (cp == anchor) { -     	    	    	ch2->xhdrs[xover_hdrs[i]] = 0;!5     	    	    	ch2->have_xhdrs |= (1<<xover_hdrs[i]);t     	    	    	anchor = cp + 1;T     	    	    	continue;     	    	    }s     	    	    *cp = '\0';/!     	    	    j = strlen(anchor);v      	    	    h = mem_gethdr(j);%     	    	    strcpy(h->str, anchor);n2     	    	    h->code = xhdr_codes[xover_hdrs[i]];     	    	    h->len = j;t+     	    	    if (h->code == code) hdr = h;pH     	    	    for (h2 = ch2->hdrq.head; h2 != (struct HDR *) &ch2->hdrq;$     	    	    	    h2 = h2->flink) {.     	    	    	if (h2->code == h->code) break;     	    	    }r4     	    	    if (h2 == (struct HDR *) &ch2->hdrq) {/     	    	    	queue_insert(h, ch2->hdrq.tail);+-     	    	    	ch2->xhdrs[xover_hdrs[i]] = h;r5     	    	    	ch2->have_xhdrs |= (1<<xover_hdrs[i]);&$     	    	    } else mem_freehdr(h);     	    	    anchor = cp + 1;9     	    	}  /* loop through the XOVER response fields */ 6     	    } /* loop through the XOVER response lines */ /*H **  If we didn't see the article we wanted, then it doesn't exist on the **  server.  */     	    if (!did_it) {A     	    	if (grp->valid != 0)>     	    	    grp->valid[artnum-grp->frstavl] = GRP_K_INVALID;      	    	if (grp != curgroup) {     	    	    int i;$     	    	    strcpy(tmp, "GROUP ");,     	    	    strcat(tmp, curgroup->grpnam);     	    	    server_send(tmp);a9     	    	    server_get_reply(SRV__NOECHO, &i, 0, 0, 0);>     	    	}{     	    	return NEWS__ARTRERR;z
     	    } /*E **  If we got back CMDUNRECOGNZD, then this server definitely doesn'te **  support XOVER. */4     	} else if (reply_code == NNTP__CMDUNRECOGNZD) {     	    news_cfg.xover = -1;l3     	    if (news_cfg.xhdr < 0) goto Do_Full_Fetch;r     	}     }  /*< ** Try XHDR next, if we have to.  Format the XHDR request... */J     if (hdr == 0 && (fallback || !(is_xover_hdr && news_cfg.xover > 0))) {9     	sprintf(tmp, "XHDR %s %d", hdrname[code-1], artnum);E     	server_send(tmp);J     	server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp)-1, &len);     	tmp[len] = '\0';.+     	if (reply_code != NNTP__HEADFOLLOWS) {r     	    if (grp != curgroup) {      	    	int i;      	    	strcpy(tmp, "GROUP ");(     	    	strcat(tmp, curgroup->grpnam);     	    	server_send(tmp);_5     	    	server_get_reply(SRV__NOECHO, &i, 0, 0, 0);n
     	    } /*A **  If the server doesn't do XHDR, fall back to full header fetch" */1     	    if (reply_code == NNTP__CMDUNRECOGNZD) {w     	    	news_cfg.xhdr = -1;      	    	goto Do_Full_Fetch;c
     	    }     	    return NEWS__ARTRERR;     	} else news_cfg.xhdr = 1;   /*! ** Get the header we've requested  */H     	while (server_get_line(tmp, sizeof(tmp)-1, &len) != NEWS__EOLIST) {     	    int i = 0;.     	    tmp[len] = '\0';rU     	    for (cp = tmp; *cp != '\0' && !isspace(*cp); cp++) i = i * 10 + (*cp - '0'); G     	    if (grp->valid != 0) grp->valid[i-grp->frstavl] = GRP_K_VALID; '     	    if (hdr == 0 && i == artnum) {i$     	    	while (isspace(*cp)) cp++;1     	    	hdr = mem_gethdr(len - (cp - tmp) + 1);      	    	strcpy(hdr->str, cp);	     	    	hdr->code = code;)$     	    	hdr->len = len - (cp-tmp);
     	    }     	} /*/ **  If it's a nonexistent article, let 'em know! */     	if (hdr == 0) {N     	    if (grp->valid != 0) grp->valid[artnum-grp->frstavl] = GRP_K_INVALID;     	    if (grp != curgroup) {d      	    	strcpy(tmp, "GROUP ");(     	    	strcat(tmp, curgroup->grpnam);     	    	server_send(tmp); >     	    	server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);
     	    }     	    return NEWS__ARTRERR;     	}   /*F **  XHDR returns (none) if the article exists but the header requested **  is not present.  */  +     	if (strcmp(hdr->str, "(none)") == 0) {g     	    mem_freehdr(hdr);     	    hdr = 0;s     	} /*  ** Add this header to the cache. */$     	ch2 = Cache_Add(ch, artnum, 0);  5     	if (hdr != 0) queue_insert(hdr, ch2->hdrq.tail);  /*$ **  Set up the quick-access pointers */'     	for (i = 0; i < XHDR_COUNT; i++) {g%     	    if (code == xhdr_codes[i]) {o     	    	ch2->xhdrs[i] = hdr;$     	    	ch2->have_xhdrs |= (1<<i);     	    	break;
     	    }     	}       } /* Using XHDR */       *hdrp = hdr;   /*? ** If we had changed the group on the server, change back againc */     if (grp != curgroup) {     	strcpy(tmp, "GROUP "); #     	strcat(tmp, curgroup->grpnam);n     	server_send(tmp);9     	server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);	     }(       return SS$_NORMAL;   } /* Get_One_Header */ c /* **++ **  ROUTINE:	Preload_Cache ** **  FUNCTIONAL DESCRIPTION:s **F **  	Uses XOVER to pre-load the header cache with a range of articles. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **K **  	Preload_Cache(struct GRP *grp, int artnum, int code, struct HDR **hdr)c **3 ** grp:	     GRP structure, read only, by reference 0 ** artnum:   article number, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.g ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.N ** **  SIDE EFFECTS:   	None. ** **-- */9 int Preload_Cache(struct GRP *grp, int first, int last) {I       struct CHDR *ch, *ch2;     struct HDR *h, *hdr2, *h2;     char tmp[STRING_SIZE];     char *cp, *anchor;?     int reply_code, len, i, j, artnum, xi, last_valid, old_min;      unsigned int status;   /*B **  If this isn't the group we're caching, or we don't have XOVER, **  forget it. */     if (hcgroup == 0) {)     	Cache_Init(grp);c     	ch = 0;     }e  7     if (hcgroup != grp || news_cfg.xover < 0) return 0;    /*5 **  Only check the articles we need to for holechecksc */  3     if (first < grp->frstavl) first = grp->frstavl; 1     if (last > grp->lastavl) last = grp->lastavl;T     if (first > last) return 1;O   /* **  Get the headersP */     if (first == last) {%     	sprintf(tmp, "XOVER %d", first);      } else {.     	sprintf(tmp, "XOVER %d-%d", first, last);     }r     server_send(tmp);aI     server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp)-1, &len);s*     if (reply_code != NNTP__DATAFOLLOWS) {@     	if (reply_code == NNTP__CMDUNRECOGNZD) news_cfg.xover = -1;     	return 0;     }*     last_valid = first-1;eG     while (server_get_line(tmp, sizeof(tmp)-1, &len) != NEWS__EOLIST) {      	tmp[len] = '\0';i     	cp = strchr(tmp, '\t');     	if (cp == 0) continue;f     	*cp = '\0';     	artnum = atoi(tmp);3     	if (artnum < first || artnum > last) continue;  /*> **  Look up this article in the cache, and add it if necessary */     	ch = Cache_Lookup(artnum); $     	ch2 = Cache_Add(ch, artnum, 0); /*; **  This is a valid article, so catch up on holes if neededu */#     	if (artnum - last_valid > 1) {I2     	    for (i = last_valid+1; i < artnum; i++) {$     	    	Mark_Article_Seen(grp, i);5     	    	grp->valid[i-grp->frstavl] = GRP_K_INVALID;e
     	    }     	}     	last_valid = artnum; 3     	grp->valid[artnum-grp->frstavl] = GRP_K_VALID;*   /*E **  If we already have these headers, no need to parse them out againI */I     	if (ch2->have_all_headers || ch2->have_xhdrs == XHDR_MASK) continue;t   /*0 **  Now let's get the headers from the response. */     	anchor = cp + 1;)(     	for (i = 0; anchor < (tmp + len) &&C     	    	    	i < sizeof(xover_hdrs)/sizeof(xover_hdrs[0]); i++) {(#     	    cp = strchr(anchor, '\t');(%     	    if (cp == 0) cp = tmp + len;T!     	    if (xover_hdrs[i] < 0) {o     	    	anchor = cp + 1;     	    	continue;g
     	    }     	    if (cp == anchor) {(     	    	ch2->xhdrs[xover_hdrs[i]] = 0;0     	    	ch2->have_xhdrs |= (1<<xover_hdrs[i]);     	    	anchor = cp + 1;     	    	continue; 
     	    }   /*J **  If we already have this header, no need to add it to the list _again_. */     	    xi = xover_hdrs[i];)     	    if (ch2->have_xhdrs & (1<<xi)) {      	    	anchor = cp + 1;     	    	continue;u
     	    }   /* **  Now parse out the header */     	    *cp = '\0';     	    j = strlen(anchor);     	    h = mem_gethdr(j);0      	    strcpy(h->str, anchor);"     	    h->code = xhdr_codes[xi];     	    h->len = j;)     	    queue_insert(h, ch2->hdrq.tail);      	    if (xi >= 0) {a     	    	ch2->xhdrs[xi] = h; %     	    	ch2->have_xhdrs |= (1<<xi);;
     	    }     	    anchor = cp + 1;l  4     	}  /* loop through the XOVER response fields */  1     } /* loop through the XOVER response lines */U   /*& **  Final catch-up on holes, if needed */       if (last_valid < last-1) {.     	for (i = last_valid + 1; i < last; i++) {#     	    Mark_Article_Seen(grp, i); 4     	    grp->valid[i-grp->frstavl] = GRP_K_INVALID;     	}     }   
     return 1;e   } /* Preload_Cache */l o /* **++ **  ROUTINE:	Get_Article_Bodys ** **  FUNCTIONAL DESCRIPTION:  **; **  	Fetches an article body from the server (or out of our  **  single article cache). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **< **  	Get_Article_Body(int artnum, char *fspec, char *xrspec,. **  	    	    	    	int *xlines, int nosignal) **/ ** artnum:  article number, read only, by value!F ** fspec:   file specification, read only, by reference (ASCIZ string)G ** rspec:   file specification, write only, by reference (ASCIZ string) - ** lines:   integer, write only, by referencel) ** nosignal: integer, read only, by valuel ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.p ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */D unsigned int Get_Article_Body(int artnum, char *fspec, char *xrspec,0     	    	    	    	int *xlines, int nosignal) {  /     char tmp[STRING_SIZE], tmp2[STRING_SIZE*2];l      int reply_code, tlen, lines;     unsigned int status, unit;   /*G ** We keep one article body around locally; check to see if that's what G ** they want.  If so, copy it over and return.  Otherwise, clear things= ** out for our new article.n */     if (artsave != NULL) {D     	if (curgroup == artsave->grpptr && artnum == artsave->artnum) {B     	    status = Copy_File(artsave->bodyfspec, fspec, xrspec, 0);+     	    if (OK(status)) return SS$_NORMAL;e%     	    else wipe_article(&artsave);t     	}     }h   /*C ** Create the file using the name they gave us, then fetch the bodyd ** over from the server. */2     status = file_create(fspec, &unit, 0, xrspec);     if (!OK(status)) {J     	if (!nosignal) lib$signal(NEWS__ARTRERR, 3, strlen(curgroup->grpnam),1     	    	    	curgroup->grpnam, artnum, status);-     	return status;i     }   $     sprintf(tmp, "BODY %d", artnum);     server_send(tmp); H     server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp), &tlen);*     if (reply_code != NNTP__BODYFOLLOWS) {     	file_dclose(unit); Q     	if (reply_code == NNTP__NOSUCHARTNUM || reply_code == NNTP__NOSUCHARTICLE) {d]     	    if (curgroup->valid != 0) curgroup->valid[artnum-curgroup->frstavl] = GRP_K_INVALID;pN     	    if (!nosignal) lib$signal(NEWS__ARTRERR, 3, strlen(curgroup->grpnam),F     	    	    	    	curgroup->grpnam, artnum, NEWS__NOSUCHARTICLE, 0);$     	    return NEWS__NOSUCHARTICLE;
     	} else {AN     	    if (!nosignal) lib$signal(NEWS__ARTRERR, 3, strlen(curgroup->grpnam),N     	    	curgroup->grpnam, artnum, NEWS__UNEXPRSP, 3, reply_code, tlen, tmp);     	    return NEWS__ARTRERR;     	}     }nV     if (curgroup->valid != 0) curgroup->valid[artnum-curgroup->frstavl] = GRP_K_VALID;       lines = 0;H     while (server_get_line(tmp, sizeof(tmp)-1, &tlen) != NEWS__EOLIST) {
     	lines++;,     	if (news_cfg.chrcnv) {a     	    *(tmp+tlen) = '\0';6     	    (*news_cfg.chrntol)(tmp, tmp2, sizeof(tmp2));7     	    status = file_write(unit, tmp2, strlen(tmp2));A
     	} else {e.     	    status = file_write(unit, tmp, tlen);     	}     	if (!OK(status)) {tJ     	    while (server_get_line(tmp, sizeof(tmp), &tlen) != NEWS__EOLIST);N     	    if (!nosignal) lib$signal(NEWS__ARTRERR, 3, strlen(curgroup->grpnam),0     	    	    curgroup->grpnam, artnum, status);     	    file_dclose(unit);      	    return status;      	}     },        if (xlines) *xlines = lines;       file_close(unit);t     return SS$_NORMAL;   } /* Get_Article_Body */ u /* **++ **  ROUTINE:	Ignore_Articlea ** **  FUNCTIONAL DESCRIPTION:w **> **  	Checks to see if the specified article should be ignored. ** **  RETURNS:	boolean ** **  PROTOTYPE: **0 **  	Ignore_Article(struct GRP *grp, int artnum) **2 ** grp:	    GRP structure, read only, by reference/ ** artnum:  article number, read only, by value  ** **  IMPLICIT INPUTS:	news_prof.a ** **  IMPLICIT OUTPUTS:	None.{ ** **  COMPLETION CODES: & **  	    1: Article should be ignored.' **  	    0: Do not ignore this article.t ** **  SIDE EFFECTS:   	None. ** **-- */1 int Ignore_Article(struct GRP *grp, int artnum) {g        struct QUE *hdrqptr, *kq[2];     struct HDR *hdr;     char tmp[STRING_SIZE+2];(     struct dsc$descriptor cand, pattern;     int ignore, i, j;Z   #define IGNORE_COUNT 4+ #define IGNORE_MASK (~((-1)<<IGNORE_COUNT))h       unsigned int ignore_flags;)     struct HDR *ignore_hdr[IGNORE_COUNT];=     struct {
     	int len;      	char *str;e"     } ignore_string[IGNORE_COUNT];,     static int ignore_code[IGNORE_COUNT] = {@     	NEWS_K_HDR_SUBJECT, NEWS_K_HDR_FROM, NEWS_K_HDR_MESSAGE_ID,     	NEWS_K_HDR_NEWSGROUPS}; /*D ** Check degenerate case - no local and no global kill lists.  Saves) ** us fetching the headers unnecessarily.  */)     if (grp->killq.head == &grp->killq &&c<     	    news_prof.killq.head == &news_prof.killq) return 0;   /*L **  Now let's see which headers we will need.  Check local kill queue first. */     ignore_flags = 0;rD     for (hdr = grp->killq.head; hdr != (struct HDR *) &grp->killq &&:     	    	ignore_flags != IGNORE_MASK; hdr = hdr->flink) {)     	for (i = 0; i < IGNORE_COUNT; i++) {r+     	    if (hdr->code == ignore_code[i]) {*!     	    	ignore_flags |= (1<<i);q     	    	break;
     	    }     	}     }-   /*  **  Now check global kill queue. */N     for (hdr = news_prof.killq.head; hdr != (struct HDR *) &news_prof.killq &&:     	    	ignore_flags != IGNORE_MASK; hdr = hdr->flink) {)     	for (i = 0; i < IGNORE_COUNT; i++) {u+     	    if (hdr->code == ignore_code[i]) {f!     	    	ignore_flags |= (1<<i);m     	    	break;
     	    }     	}     };   /*? **  If ignore_flags is still zero (it shouldn't be), forget it.e */$     if (ignore_flags == 0) return 0;   /*+ **  Set up things to begin the ignore check  */     ignore = 0;X(     for (i = 0; i < IGNORE_COUNT; i++) {     	ignore_hdr[i] = 0;(     	ignore_string[i].str = 0;     }  /*D ** Fetch the headers over.  If there's a problem, assume it's a dead) ** article and tell the caller to ignore.s */(     for (i = 0; i < IGNORE_COUNT; i++) {!     	if (ignore_flags & (1<<i)) {SP     	    if (!OK(Get_One_Header(grp, artnum, ignore_code[i], &ignore_hdr[i]))) {     	    	ignore = 1;o     	    	break;
     	    }     	}     	if (ignore_hdr[i] != 0) {3     	    ignore_string[i].len = ignore_hdr[i]->len;*F     	    ignore_string[i].str = (char *) malloc(ignore_hdr[i]->len+1);)     	    if (ignore_string[i].str != 0) {r;     	    	strcpy(ignore_string[i].str, ignore_hdr[i]->str); '     	    	upcase(ignore_string[i].str); 
     	    }     	}     }t   /*C ** Now check the local and global kill lists to see if this article E ** meets the criteria, unless it has already been marked for ignoringt4 ** because the basic headers could not be retrieved. */     if (!ignore) {     	kq[0] = &grp->killq;      	kq[1] = &news_prof.killq;)     	for (i = 0; !ignore && i < 2; i++) { \     	    for (hdr = kq[i]->head; !ignore && hdr != (struct HDR *) kq[i]; hdr = hdr->flink) {A     	    	if (!strchr(hdr->str, '*') && !strchr(hdr->str, '%')) {/     	    	    tmp[0] = '*';r(     	    	    strcpy(&tmp[1], hdr->str);     	    	    strcat(tmp, "*");h4     	    	    INIT_SDESC(pattern, strlen(tmp), tmp);     	    	} else {>     	    	    INIT_SDESC(pattern, strlen(hdr->str), hdr->str);     	    	} 9     	    	for (j = 0; !ignore && j < IGNORE_COUNT; j++) { M     	    	    if (hdr->code == ignore_code[j] && ignore_string[j].str != 0) {dL     	    	    	INIT_SDESC(cand, ignore_string[j].len, ignore_string[j].str);<     	    	    	ignore = OK(str$match_wild(&cand, &pattern));     	    	    }	     	    	}'
     	    }     	}     }n   /*$ **  Free up the strings we allocated */(     for (i = 0; i < IGNORE_COUNT; i++) {?     	if (ignore_string[i].str != 0) free(ignore_string[i].str);l     }t   /*C ** If we are supposed to ignore this article, mark it seen as well.- *//     if (ignore) Mark_Article_Seen(grp, artnum);        return ignore;   } /* Ignore_Article */ - /* **++ **  ROUTINE:	Article_ExH ** **  FUNCTIONAL DESCRIPTION:s **: **  	Routine to be called by the NEWSRDR exit handler that) **  cleans up our one-article body cache.e **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	Article_ExH() ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.R ** **  COMPLETION CODES: " **  	SS$_NORMAL: 	Always returned. ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int Article_ExH() {  0     if (artsave != NULL) wipe_article(&artsave);       return SS$_NORMAL;   } /* Article_ExH */	   /* **++ **  ROUTINE:	Edit_Article_ ** **  FUNCTIONAL DESCRIPTION:c **: **  	Puts an article into a file for viewing by an editor. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **$ **  	Edit_Article(struct ART **ctxp) **F ** ctxp: pointer to internally-defined structure, modify, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.o ** **  COMPLETION CODES: 3 **  	SS$_NORMAL: 	    Normal successful completion.)M **  	NEWS__EOARTICLE:    Normal completion; article has been fully displayed.l ** **  SIDE EFFECTS:   	None. ** **-- */. unsigned int Edit_Article(struct ART **ctxp) {       struct ART *ctx = *ctxp;&     struct GRP *grp = (*ctxp)->grpptr;     struct HDR *hdr;     struct dsc$descriptor sdsc;a-     char tmp[STRING_SIZE], rspec[FSPEC_SIZE];e     short tlen;H     int len, is_temp;z     unsigned int status, unit;Y     static $DESCRIPTOR(alphabet, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"); Y     static $DESCRIPTOR(rotabet,  "NOPQRSTUVWXYZABCDEFGHIJKLMnopqrstuvwxyzabcdefghijklm");;  &     make_temp_fspec(tmp, sizeof(tmp));/     status = file_create(tmp, &unit, 0, rspec); #     if (!OK(status)) return status;  /* ** Header displayu */8     while (ctx->hlnptr != (struct HDR *) ctx->hdrqptr) {
     	int len; 8     	Format_Header(ctx->hlnptr, tmp, sizeof(tmp), &len);      	file_write(unit, tmp, len);&     	ctx->hlnptr = ctx->hlnptr->flink;     }*       file_write(unit, "", 0);  @     status = file_open(ctx->bodyfspec, &ctx->bodyunit, 0, 0, 0);     if (!OK(status)) {9     	lib$signal(NEWS__BODYERR, 2, strlen(ctx->bodyfspec),=+     	    	    	    ctx->bodyfspec, status);      	file_dclose(unit);      	return status;      }r   /* ** Display of article body */D     while (OK(file_read(ctx->bodyunit, tmp, sizeof(tmp)-1, &len))) {       	if (rotate_text) { $     	    struct dsc$descriptor tdsc;      	    char tmp2[STRING_SIZE];$     	    INIT_SDESC(sdsc, len, tmp);%     	    INIT_SDESC(tdsc, len, tmp2);}:     	    str$translate(&tdsc, &sdsc, &alphabet, &rotabet);%     	    file_write(unit, tmp2, len);i'     	} else file_write(unit, tmp, len);-     }l       file_close(unit);      file_close(ctx->bodyunit);     ctx->bodyunit = 0;     artsave = ctx;  6     status = Compose_Message(rspec, tmp, 1, &is_temp);0     if (OK(status) && is_temp) file_delete(tmp);     file_delete(rspec);        return status;   } /* Edit_Article */   /* **++ **  ROUTINE:	Check_For_Holes ** **  FUNCTIONAL DESCRIPTION:s **: **  	Uses the XHDR command to check a newsgroup for holes. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:* ** ** **  SIDE EFFECTS:   	None. ** **-- */< void Check_For_Holes(struct GRP *grp, int first, int last) {       char tmp[STRING_SIZE];     unsigned int status;3     int i, j, last_valid, len, reply_code, old_min; 
     char *cp;        if (news_cfg.xover >= 0) {1     	if (Preload_Cache(grp, first, last)) return;      }   "     if (news_cfg.xhdr < 0) return;  3     if (first < grp->frstavl) first = grp->frstavl;(1     if (last > grp->lastavl) last = grp->lastavl;        if (first > last) return;&  4     sprintf(tmp, "XHDR Subject %d-%d", first, last);     server_send(tmp); I     server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp)-1, &len);N*     if (reply_code != NNTP__HEADFOLLOWS) {?     	if (reply_code == NNTP__CMDUNRECOGNZD) news_cfg.xhdr = -1;l     	return;     }r     news_cfg.xhdr = 1;       last_valid = first-1;oG     while (server_get_line(tmp, sizeof(tmp)-1, &len) != NEWS__EOLIST) {*     	int i = 0;r     	tmp[len] = '\0';e9     	for (cp = tmp; *cp != '\0' && !isspace(*cp); cp++) {      	    if (!isdigit(*cp)) {      	    	i = 0;     	    	break;
     	    }"     	    i = i * 10 + (*cp - '0');     	}     	if (i == 0) continue;     	if (i - last_valid > 1) {-     	    for (j = last_valid+1; j < i; j++) {r$     	    	Mark_Article_Seen(grp, j);5     	    	grp->valid[j-grp->frstavl] = GRP_K_INVALID;S
     	    }     	}     	last_valid = i;.     	grp->valid[i-grp->frstavl] = GRP_K_VALID;     }m       if (last_valid < last-1) {.     	for (j = last_valid + 1; j < last; j++) {#     	    Mark_Article_Seen(grp, j);.4     	    grp->valid[j-grp->frstavl] = GRP_K_INVALID;     	}     }        return;f   } /* Check_For_Holes */g v /* **++ **  ROUTINE:	Is_Valid_Articlet ** **  FUNCTIONAL DESCRIPTION:e **@ **  	Checks to see if an article is on the invalid-article list. ** **  RETURNS:	int (1 or 0)  ** **  PROTOTYPE: **2 **  	Is_Valid_Article(struct GRP *grp, int artnum) **/ ** artnum:  article number, read only, by valueV2 ** grp:	    GRP structure, read only, by reference **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:C **  	   >0:	article is valid/ **  	   <0:	article may be valid, we don't knowO) **  	    0:  article definitely not validN ** **  SIDE EFFECTS:   	None. ** **-- */3 int Is_Valid_Article(struct GRP *grp, int artnum) {e       struct RNG *r;     int base, a;  $     if (grp == NULL) grp = curgroup;  (     if (artnum > grp->lastavl) return 0;       if (grp->valid == 0) {%     	a = grp->lastavl-grp->frstavl+1;      	grp->valid = malloc(a);$     	if (grp->valid == 0) return -1;     	memset(grp->valid, 0, a);     }s  !     base = artnum - grp->frstavl;u      if (grp->valid[base] == 0) {,     	for (a = 1; artnum+a <= grp->lastavl &&2     	    	grp->valid[base+a] == 0 && a < 11; a++);.     	Check_For_Holes(grp, artnum, artnum+a-1);     } )     if (grp->valid[base] == 0) return -1;(  3     return grp->valid[base] == GRP_K_VALID ? 1 : 0;I   } /* Is_Valid_Article */   /* **++ **  ROUTINE:	Article_Seena ** **  FUNCTIONAL DESCRIPTION:V **@ **  	Checks to see if an article is on the invalid-article list. ** **  RETURNS:	int (1 or 0)2 ** **  PROTOTYPE: **. **  	Article_Seen(struct GRP *grp, int artnum) **/ ** artnum:  article number, read only, by value 2 ** grp:	    GRP structure, read only, by reference **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:  **  	    1:	article seen **  	    0:  article not seent ** **  SIDE EFFECTS:   	None. ** **-- *// int Article_Seen(struct GRP *grp, int artnum) {g       struct RNG *r;
     int a;  $     if (grp == NULL) grp = curgroup;  (     if (artnum > grp->lastavl) return 0;   /*3 ** Check to see if it's on the invalid article listt */N     for (r = grp->seenq.tail; r != (struct RNG *) &grp->seenq; r = r->blink) {#     	if (artnum >= r->first) break;o     }s*     if (r != (struct RNG *) &grp->seenq) {%     	if (artnum <= r->last) return 1;      }t  
     return 0;}   } /* Article_Seen */ h /* **++ **  ROUTINE:	Cache_Init  ** **  FUNCTIONAL DESCRIPTION:  **" **  	Initializes the header cache. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.] ** **  COMPLETION CODES:_ ** ** **  SIDE EFFECTS:   	None. ** **-- */) static void Cache_Init(struct GRP *grp) {E       mem_delcache(); '     mem_initcache(sizeof(struct CHDR));l.     hdrcache.head = hdrcache.tail = &hdrcache;     hcgroup = grp;     hccount = 0; })   /* **++ **  ROUTINE:	Cache_Lookupt ** **  FUNCTIONAL DESCRIPTION:e **- **  	Looks up an article in the header cache.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.s ** **  COMPLETION CODES:e ** ** **  SIDE EFFECTS:   	None. ** **-- */. static struct CHDR *Cache_Lookup(int artnum) {       struct CHDR *ch;  %     if (hdrcache.head != &hdrcache &&B<     	    artnum > ((struct CHDR *) hdrcache.tail)->artnum) {#     	hdrcache_remove_from_tail = 0;a/     	return 0;  /* short cut for common case */f     } else {P     	for (ch = hdrcache.head; ch != (struct CHDR *) &hdrcache; ch = ch->flink) {$     	    if (artnum <= ch->artnum) {A     	    	if (ch == hdrcache.head) hdrcache_remove_from_tail = 1;:     	    	return ch;
     	    }     	}     }I  "     hdrcache_remove_from_tail = 1;  
     return 0;    } /* Cache_Lookup */ $ /* **++ **  ROUTINE:	Cache_Add ** **  FUNCTIONAL DESCRIPTION:N ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.* ** **  COMPLETION CODES:l ** ** **  SIDE EFFECTS:   	None. ** **-- */Q static struct CHDR *Cache_Add(struct CHDR *insert_point, int artnum, int clear) {a       struct CHDR *ch;     struct HDR *hdr;  >     if (insert_point != 0 && insert_point->artnum == artnum) {     	ch = insert_point;r     	if (!clear) return ch;r@     	while (queue_remove(ch->hdrq.head, &hdr)) mem_freehdr(hdr);     } else {)     	if (hccount >= news_cfg.cachesize) {t'     	    if (hdrcache_remove_from_tail)c+     	    	queue_remove(hdrcache.tail, &ch);t
     	    elseg+     	    	queue_remove(hdrcache.head, &ch); 
     	} else {e     	    ch = mem_getcache();_     	    hccount += 1;     	}     	if (insert_point == 0) )     	    queue_insert(ch, hdrcache.tail);,	     	elseg/     	    queue_insert(ch, insert_point->blink);a     }s,     memset(ch->xhdrs, 0, sizeof(ch->xhdrs));.     ch->hdrq.head = ch->hdrq.tail = &ch->hdrq;     ch->artnum = artnum;     ch->have_xhdrs = 0;c     ch->have_all_headers = 0;        return ch;   } /* Cache_Add */)