 /* **++ **  FACILITY:	NEWSRDR  **
 **  ABSTRACT:  **+ **  	Commands relating to reading articles.  ** **  MODULE DESCRIPTION:  **> **  	This module contains all the READ commands and some other **  related commands.  **C **  	All of these routines make extensive use of the module statics  **  and global variables.  ** **  AUTHOR: 	    M. Madison 7 **  	    	    COPYRIGHT  1993, 1994  MADGOAT SOFTWARE. " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  03-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	03-SEP-1992 V1.0    Madison 	Initial coding. H **  	12-SEP-1992 V1.0-1  Madison 	Support user-specified group ordering.K **  	16-SEP-1992 V1.0-2  Madison 	READ/THREAD wasn't marking articles seen. = **  	23-SEP-1992 V1.0-3  Madison 	Fix EXTRACT's append logic. F **  	21-OCT-1992 V1.0-4  Madison 	Fix looping problem in cmd_readsubj.E **  	15-FEB-1993 V1.0-5  Madison 	Make compatibile with pre-VMS V5.2. J **  	15-FEB-1993 V1.1    Madison 	Add SET [NO]SEE/SUBJ, /CROSS, NOSEE/THR.I **  	12-APR-1993 V1.2    Madison 	Get_Article_* has changed; autoreadnew. D **  	14-MAY-1993 V1.2-1  Madison 	Find_Group_Wild now takes context.C **  	31-MAY-1993 V1.2-2  Madison 	Fix looping bug in cont_readsubj. , **  	22-JUN-1993 V1.3    Madison 	Auto save.3 **  	23-SEP-1993 V1.4    Madison 	Add XHDR support. = **  	09-OCT-1993 V1.5    Madison 	Fix MARKCOUNT message, etc. H **  	21-OCT-1993 V1.6    Madison 	Add cont_readthread, fix cmd_skipsubj.: **  	28-OCT-1993 V1.6-1  Madison 	Really fix cmd_skipsubj.B **  	03-NOV-1993 V1.6-2  Madison 	Yet another fix in cmd_skipsubj.B **  	10-NOV-1993 V1.6-3  Madison 	Split GRPSET msg into two parts.G **  	05-DEC-1993 V1.6-4  Madison 	Have EXTRACT do valid article checks. 4 **  	15-JAN-1994 V1.7    Madison 	More EXTRACT mods.< **  	16-MAY-1994 V1.8    Madison 	Ref-threads, EXTRACT mods.W **  	19-MAY-1994 V1.8-1  Madison 	Add /IGNORE to EXTRACT; fix loop in Find_Next_Unseen. F **  	25-MAY-1994 V1.8-2  Madison 	Fix missing file closure in EXTRACT. **-- */ #include "newsrdr.h" #include "globals.h"   /* ** Forward declarations  */  G     unsigned int cmd_read(void), cmd_readcont(void), cmd_readnew(void); O     unsigned int cmd_readnext(void), cmd_readprev(void), cmd_readnextnew(void); B     unsigned int cmd_readnextnewgroup(void), cmd_readthread(void);'     unsigned int cont_readthread(void); L     unsigned int cmd_readsubj(void), cont_readsubj(void), cmd_current(void);K     unsigned int cmd_skipthread(void), cmd_skipsubj(void), cmd_group(void); ;     static unsigned int Find_And_Set_Current_Group(char *); 1     unsigned int Set_Current_Group(struct GRP *); #     unsigned int cmd_extract(void); '     unsigned int Clear_ArtInProg(void); 4     static unsigned int Find_Next_Unseen(int, int*);  I     GLOBAL int cur_artnum = 0;	    	/* Current article number   	      */ M     GLOBAL int rotate_text = 0;	    	/* ROT13 flag, used in ARTICLE module */ N     GLOBAL int Read_Full_Headers = 0;	/* Header-settings override flag      */M     EXTERN struct GRP *curgroup;    	/* Current group                      */ P     EXTERN int User_Interrupt;          /* User pressed CTRL/C                */   /*, ** Statics for tracking info for READ/THREAD */     static int thread_base = 0; ,     static char thread_subject[STRING_SIZE];*     static char thread_msgid[STRING_SIZE];/     static struct QUE subjq = {&subjq, &subjq};      static int thread_newonly;     static int thread_strict;    /*D ** Context about our current state, for those multiple-action reads.C ** We use saved_default_action to track the routine that we started ? ** with, so when someone uses READ/NEXT/NEW to read an article, D ** just pressing return will continue to use READ/NEXT NEW; likewiseD ** for READ/NEXT.  We need this because routine cmd_readcont is usedA ** by all of these commands to handle continuation of the current  ** article.  */K     static unsigned int (*saved_default_action)() = (unsigned int (*)()) 0; '     static unsigned int cur_artctx = 0; '     static int Article_In_Progress = 0; "     static unsigned int rgctx = 0;   /*3 ** External references, mostly from module ARTICLE.  */N     extern unsigned int Retrieve_Article(int, void *, char *, char *, char *);4     extern int Mark_Article_Seen(struct GRP *, int);6     extern int Mark_Article_Unseen(struct GRP *, int);'     extern void Mark_Xref(char *, int); 2     extern unsigned int Show_Article_Page(void *);1     extern int Ignore_Article(struct GRP *, int); P     extern unsigned int Get_Article_Hdrs(struct GRP *, int, void *, int, int *);N     extern unsigned int Get_One_Header(struct GRP *, int, int, struct HDR **);J     extern unsigned int Get_Article_Body(int, char *, char *, int *, int);/     extern void Rewind_Article(unsigned int *); .     extern void Close_Article(unsigned int *);*     extern struct GRP *Find_Group(char *);?     extern struct GRP *Find_Group_Wild(char *, unsigned int *); G     extern unsigned int parse_group_reply(char *, int *, int *, int *); M     extern unsigned int Parse_Range(char *, int *, int *, int, struct GRP *); 5     extern struct GRP *Traverse_Tree(unsigned int *); 0     extern void Traverse_Finish(unsigned int *);8     extern struct GRP *Current_TreeNode(unsigned int *);;     extern int Next_Unseen_Article(int, int, struct GRP *); *     extern int Count_Unseen(struct GRP *);-     extern unsigned int Edit_Article(void *); ,     extern unsigned int Write_Profile(void);3     extern int Is_Valid_Article(struct GRP *, int); ,     extern int Thread_Match(char *, char *);   /* **++ **  ROUTINE:	cmd_read  ** **  FUNCTIONAL DESCRIPTION:  **7 **  	The READ command.  Reads an article by its number. ; ** Also handles READ/FIRST, READ/LAST, and the synonyms for   ** those commands (FIRST, LAST). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_read()  ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_read() {        unsigned int status;;     char xref_hdr[STRING_SIZE], tmp[STRING_SIZE], verb[32];      int artnum;    /*+ ** READ/SUBJECT is handled by cmd_readsubj.  */F     if (cli_present("SUBJECT") == CLI$_PRESENT) return cmd_readsubj();       Clear_ArtInProg();  /     if (cli_present("GROUP") == CLI$_PRESENT) { .     	cli_get_value("GROUP", tmp, sizeof(tmp));.     	status = Find_And_Set_Current_Group(tmp);(     	if (!OK(status)) return SS$_NORMAL;     }        if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);      	return SS$_NORMAL;      }   /     cli_get_value("$VERB", verb, sizeof(verb)); 0     if (cli_present("ARTNUM") == CLI$_PRESENT) {/     	cli_get_value("ARTNUM", tmp, sizeof(tmp)); +     	if (tmp[0] == '.' && tmp[1] == '\0') {      	    if (cur_artnum == 0) { (     	    	lib$signal(NEWS__NOCURART, 0);     	    	return SS$_NORMAL;     	    } else {      	    	artnum = cur_artnum;
     	    }
     	} else { 9     	    status = lib$cvt_dtb(strlen(tmp), tmp, &artnum);      	    if (!OK(status)) { .     	    	lib$signal(NEWS__CMDERR, 0, status);     	    	return SS$_NORMAL;
     	    }     	}&     	if (artnum < curgroup->frstavl ||'     	    	artnum > curgroup->lastavl) { ?     	    lib$signal(NEWS__OUTRNG, 3, artnum, curgroup->frstavl, &     	    	    	    curgroup->lastavl);     	    return SS$_NORMAL;      	}H     } else if (verb[0] == 'F' || cli_present("FIRST") == CLI$_PRESENT) {      	artnum = curgroup->frstavl;G     } else if (verb[0] == 'L' || cli_present("LAST") == CLI$_PRESENT) {       	artnum = curgroup->lastavl;     } else {$     	lib$signal(NEWS__NOARTSPEC, 0);     	return SS$_NORMAL;      }        cur_artnum = artnum;"     default_action = cmd_readcont;%     cleanup_action = Clear_ArtInProg;      xref_hdr[0] = '\0'; [     status = Retrieve_Article(artnum, &cur_artctx, thread_subject, xref_hdr, thread_msgid); ,     Mark_Article_Seen(curgroup, cur_artnum);     if (OK(status)) {      	thread_base = cur_artnum;5     	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0); )     	saved_default_action = cmd_readnext;      	Article_In_Progress = 1; -     	status = Show_Article_Page(&cur_artctx); %     	if (status == NEWS__EOARTICLE) { '     	    default_action = cmd_readnext; *     	    cleanup_action = Clear_ArtInProg;     	}     } else {     	Clear_ArtInProg();      }        return SS$_NORMAL;   } /* cmd_read */   /* **++ **  ROUTINE:	cmd_readcont  ** **  FUNCTIONAL DESCRIPTION:  **2 **  	Continues paging through the current article.9 **  At the end of the article, the default action becomes 1 **  the one we saved when we started the article.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readcont()  ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_readcont() {        unsigned int status;       if (Article_In_Progress) {-     	status = Show_Article_Page(&cur_artctx); %     	if (status == NEWS__EOARTICLE) { /     	    default_action = saved_default_action; *     	    cleanup_action = Clear_ArtInProg;     	}     } else {#     	lib$signal(NEWS__NOCURART, 0);      }        return SS$_NORMAL;   } /* cmd_readcont */   /* **++ **  ROUTINE:	cmd_readnew ** **  FUNCTIONAL DESCRIPTION:  **4 **  	READ/NEW command.  Reads the first new article. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readnew() ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_readnew() {       unsigned int status;     char xref_hdr[STRING_SIZE];      struct GRP *g;       Clear_ArtInProg();     if (thread_base != 0) {      	cur_artnum = thread_base;     	thread_base = 0;      }        g = curgroup;      while (1) { 1     	if (!OK(Find_Next_Unseen(0, &cur_artnum))) { $     	    lib$signal(NEWS__NONEW, 0);B     	    default_action = cleanup_action = (unsigned int (*)()) 0;     	    return SS$_NORMAL;      	}6     	if (!Ignore_Article(curgroup, cur_artnum)) break;     }      if (g != curgroup) {:     	lib$signal(NEWS__GRPSET, 2, strlen(curgroup->grpnam),@     	    	curgroup->grpnam, NEWS__GRPINFO, 3, curgroup->frstavl,5     	    	curgroup->lastavl, Count_Unseen(curgroup)); -     	if (news_prof.autosave) Write_Profile(); "     	if (!news_prof.autoreadnew) {&     	    default_action = cmd_readnew;     	    cleanup_action = 0;     	    cur_artnum = 0;     	    return SS$_NORMAL;      	}     }   "     default_action = cmd_readcont;%     cleanup_action = Clear_ArtInProg;      xref_hdr[0] = '\0'; _     status = Retrieve_Article(cur_artnum, &cur_artctx, thread_subject, xref_hdr, thread_msgid); ,     Mark_Article_Seen(curgroup, cur_artnum);     if (OK(status)) {      	thread_base = cur_artnum;5     	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);      	Article_In_Progress = 1; ,     	saved_default_action = cmd_readnextnew;-     	status = Show_Article_Page(&cur_artctx); %     	if (status == NEWS__EOARTICLE) { *     	    default_action = cmd_readnextnew;*     	    cleanup_action = Clear_ArtInProg;     	}     }        return SS$_NORMAL;   } /* cmd_readnew */    /* **++ **  ROUTINE:	cmd_readnext  ** **  FUNCTIONAL DESCRIPTION:  ** **  	The READ/NEXT command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readnext()  ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_readnext() {        char xref_hdr[STRING_SIZE];      unsigned int status;       Clear_ArtInProg();     if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);      	return SS$_NORMAL;      }        if (thread_base != 0) {      	cur_artnum = thread_base;     	thread_base = 0;      }        while (1) { +     	if (cur_artnum >= curgroup->lastavl) { %     	    lib$signal(NEWS__NOMORE, 0);      	    return SS$_NORMAL;      	}  *     	if (cur_artnum < curgroup->frstavl) {(     	    cur_artnum = curgroup->frstavl;
     	} else {      	    cur_artnum += 1;      	};     	if (!Is_Valid_Article(curgroup, cur_artnum)) continue; 6     	if (!Ignore_Article(curgroup, cur_artnum)) break;     }   "     default_action = cmd_readcont;%     cleanup_action = Clear_ArtInProg;      xref_hdr[0] = '\0'; _     status = Retrieve_Article(cur_artnum, &cur_artctx, thread_subject, xref_hdr, thread_msgid); ,     Mark_Article_Seen(curgroup, cur_artnum);     if (OK(status)) {      	thread_base = cur_artnum;5     	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);      	Article_In_Progress = 1; )     	saved_default_action = cmd_readnext; -     	status = Show_Article_Page(&cur_artctx); %     	if (status == NEWS__EOARTICLE) { '     	    default_action = cmd_readnext; *     	    cleanup_action = Clear_ArtInProg;     	}     }        return SS$_NORMAL;   } /* cmd_readnext */   /* **++ **  ROUTINE:	cmd_readprev  ** **  FUNCTIONAL DESCRIPTION:  ** **  	The READ/PREVIOUS command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readprev()  ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_readprev() {        char xref_hdr[STRING_SIZE];      unsigned int status;       Clear_ArtInProg();     if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);      	return SS$_NORMAL;      }        if (thread_base != 0) {      	cur_artnum = thread_base;     	thread_base = 0;      }        while (1) { +     	if (cur_artnum <= curgroup->frstavl) { %     	    lib$signal(NEWS__NOMORE, 0);      	    return SS$_NORMAL;      	}  *     	if (cur_artnum > curgroup->lastavl) {(     	    cur_artnum = curgroup->lastavl;
     	} else {      	    cur_artnum -= 1;      	};     	if (!Is_Valid_Article(curgroup, cur_artnum)) continue; 6     	if (!Ignore_Article(curgroup, cur_artnum)) break;     }   "     default_action = cmd_readcont;%     cleanup_action = Clear_ArtInProg;      xref_hdr[0] = '\0'; _     status = Retrieve_Article(cur_artnum, &cur_artctx, thread_subject, xref_hdr, thread_msgid); ,     Mark_Article_Seen(curgroup, cur_artnum);     if (OK(status)) {      	thread_base = cur_artnum;5     	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);      	Article_In_Progress = 1; )     	saved_default_action = cmd_readprev; -     	status = Show_Article_Page(&cur_artctx); %     	if (status == NEWS__EOARTICLE) { '     	    default_action = cmd_readprev; *     	    cleanup_action = Clear_ArtInProg;     	}     }        return SS$_NORMAL;   } /* cmd_readprev */   /* **++ **  ROUTINE:	cmd_readnextnew ** **  FUNCTIONAL DESCRIPTION:  ** **  	The READ/NEXT/NEW command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readnextnew() ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */  unsigned int cmd_readnextnew() {       struct GRP *g, *cyclepoint;      char xref_hdr[STRING_SIZE];      unsigned int status;       Clear_ArtInProg();     if (thread_base != 0) {      	cur_artnum = thread_base;     	thread_base = 0;      }        g = curgroup;      while (1) { :     	if (!OK(Find_Next_Unseen(cur_artnum, &cur_artnum))) {$     	    lib$signal(NEWS__NONEW, 0);     	    return SS$_NORMAL;      	}9     	if (!Ignore_Article(curgroup, cur_artnum)) break;         } 0     if ((g != curgroup) && (curgroup != NULL)) {     	if (g != NULL) { C     	    lib$signal(NEWS__EOGROUP, 2, strlen(g->grpnam), g->grpnam, 4     	    	NEWS__GRPSET, 2, strlen(curgroup->grpnam),@     	    	curgroup->grpnam, NEWS__GRPINFO, 3, curgroup->frstavl,5     	    	curgroup->lastavl, Count_Unseen(curgroup));S
     	} else { ?     	    lib$signal(NEWS__GRPSET, 2,  strlen(curgroup->grpnam),*@     	    	curgroup->grpnam, NEWS__GRPINFO, 3, curgroup->frstavl,5     	    	curgroup->lastavl, Count_Unseen(curgroup));      	}-     	if (news_prof.autosave) Write_Profile();I"     	if (!news_prof.autoreadnew) {*     	    default_action = cmd_readnextnew;     	    cleanup_action = 0;     	    cur_artnum = 0;     	    return SS$_NORMAL;V     	}     }	  "     default_action = cmd_readcont;%     cleanup_action = Clear_ArtInProg;o     xref_hdr[0] = '\0';-_     status = Retrieve_Article(cur_artnum, &cur_artctx, thread_subject, xref_hdr, thread_msgid);n,     Mark_Article_Seen(curgroup, cur_artnum);     if (OK(status)) {      	thread_base = cur_artnum;5     	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);t     	Article_In_Progress = 1;9,     	saved_default_action = cmd_readnextnew;-     	status = Show_Article_Page(&cur_artctx);n%     	if (status == NEWS__EOARTICLE) {w*     	    default_action = cmd_readnextnew;*     	    cleanup_action = Clear_ArtInProg;     	}     }s       return SS$_NORMAL;   } /* cmd_readnextnew */9 V /* **++! **  ROUTINE:	cmd_readnextnewgroupV ** **  FUNCTIONAL DESCRIPTION:  **: **  	The READ/NEXT/NEW/GROUP command.  Skips to next group$ **  before looking for new articles. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readnextnewgroup()d ** **  IMPLICIT INPUTS:	Several.b ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.* ** **-- */% unsigned int cmd_readnextnewgroup() {*       struct GRP *g, *cyclepoint;-     char xref_hdr[STRING_SIZE];A     unsigned int status;  3     if (curgroup == NULL) return cmd_readnextnew();*       Clear_ArtInProg();     if (thread_base != 0) {e     	cur_artnum = thread_base;     	thread_base = 0;"     }.       g = curgroup;d#     cur_artnum = curgroup->lastavl;c     while (1) {d:     	if (!OK(Find_Next_Unseen(cur_artnum, &cur_artnum))) {$     	    lib$signal(NEWS__NONEW, 0);     	    return SS$_NORMAL;i     	}     	if (curgroup == g) {,$     	    lib$signal(NEWS__NONEW, 0);     	    return SS$_NORMAL;      	}9     	if (!Ignore_Article(curgroup, cur_artnum)) break;   (     } 0     if ((g != curgroup) && (curgroup != NULL)) {     	if (g != NULL) {)C     	    lib$signal(NEWS__EOGROUP, 2, strlen(g->grpnam), g->grpnam, 4     	    	NEWS__GRPSET, 2, strlen(curgroup->grpnam),@     	    	curgroup->grpnam, NEWS__GRPINFO, 3, curgroup->frstavl,5     	    	curgroup->lastavl, Count_Unseen(curgroup));n
     	} else {B>     	    lib$signal(NEWS__GRPSET, 2, strlen(curgroup->grpnam),@     	    	curgroup->grpnam, NEWS__GRPINFO, 3, curgroup->frstavl,5     	    	curgroup->lastavl, Count_Unseen(curgroup));	     	}-     	if (news_prof.autosave) Write_Profile();r"     	if (!news_prof.autoreadnew) {-        	    default_action = cmd_readnextnew;e     	    cleanup_action = 0;     	    cur_artnum = 0;     	    return SS$_NORMAL;t     	}     }r  "     default_action = cmd_readcont;%     cleanup_action = Clear_ArtInProg;b     xref_hdr[0] = '\0';t_     status = Retrieve_Article(cur_artnum, &cur_artctx, thread_subject, xref_hdr, thread_msgid);c,     Mark_Article_Seen(curgroup, cur_artnum);     if (OK(status)) {t     	thread_base = cur_artnum;5     	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);i     	Article_In_Progress = 1; ,     	saved_default_action = cmd_readnextnew;-     	status = Show_Article_Page(&cur_artctx);r%     	if (status == NEWS__EOARTICLE) {W*     	    default_action = cmd_readnextnew;*     	    cleanup_action = Clear_ArtInProg;     	}     }m       return SS$_NORMAL;   } /* cmd_readnextnewgroup */ / /* **++ **  ROUTINE:	cmd_readthreadl ** **  FUNCTIONAL DESCRIPTION:) **5 **  	The READ/THREAD command.  Finds the next articleiB **  with subject "matching" the thread base's subject.  The threadB **  base is established by reading an article with a command other **  than READ/THREAD.e **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readthread()M ** **  IMPLICIT INPUTS:	Several.t ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:e. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_readthread() {c       struct GRP *g;9     char tmp[STRING_SIZE], xref_hdr[STRING_SIZE], *tsubj;      struct HDR *hdr;     struct QUE *hdrqptr;     unsigned int status;
     int doit;h       Clear_ArtInProg();     if (curgroup == NULL) {g%     	lib$signal(NEWS__NOCURGROUP, 0);i     	return SS$_NORMAL;      }s     if (thread_base == 0) {;#     	lib$signal(NEWS__NOTHREAD, 0);i     	return SS$_NORMAL;)     } ?     if (thread_msgid[0] == '\0' && thread_subject[0] == '\0') {)$     	lib$signal(NEWS__NOSUBJECT, 0);     	return SS$_NORMAL;n     }c  8     thread_newonly = cli_present("NEW") == CLI$_PRESENT;:     thread_strict = cli_present("STRICT") == CLI$_PRESENT;       while (1) { L     	if (thread_newonly) cur_artnum = Next_Unseen_Article(cur_artnum, 0, 0);>     	if (cur_artnum == 0 || cur_artnum >= curgroup->lastavl) {%     	    lib$signal(NEWS__NOMORE, 0);i"     	    cur_artnum = thread_base;     	    thread_base = 0;n*     	    default_action = cmd_readnextnew;1     	    cleanup_action = (unsigned int (*)()) 0;*     	    return SS$_NORMAL;      	}  *     	if (cur_artnum < curgroup->frstavl) {(     	    cur_artnum = curgroup->frstavl;
     	} else {e.     	    if (!thread_newonly) cur_artnum += 1;     	}  6     	if (!Ignore_Article(curgroup, cur_artnum)) break;       }s       while (1) {        	if (User_Interrupt) break;*     	doit = 0;Q     	if (OK(Get_One_Header(curgroup, cur_artnum, NEWS_K_HDR_REFERENCES, &hdr))) {PC     	    if (hdr != 0) doit = Thread_Match(hdr->str, thread_msgid);*9     	    else if (OK(Get_One_Header(curgroup, cur_artnum,d3     	    	    	    NEWS_K_HDR_MESSAGE_ID, &hdr))) {_D     	    	if (hdr != 0) doit = Thread_Match(thread_msgid, hdr->str);
     	    }     	}#     	if (!doit && !thread_strict &&fO     	    	OK(Get_One_Header(curgroup, cur_artnum, NEWS_K_HDR_SUBJECT, &hdr))) {I     	    if (hdr != 0) {      	    	strcpy(tmp, hdr->str);     	    	upcase(tmp);*     	    	if (strstr(tmp, "RE:") == tmp) {<     	    	    for (tsubj = tmp+3; isspace(*tsubj); tsubj++);     	    	 } else {      	    	    tsubj = tmp;     	    	 }     	    } else {      	    	tsubj = "(none)"; 
     	    }4     	    doit = (strstr(tsubj, thread_subject) != 0)5     	    	   || (strstr(thread_subject, tsubj) != 0);g     	}       	if (doit) {     	    xref_hdr[0] = '\0';P     	    status = Retrieve_Article(cur_artnum, &cur_artctx, tmp, xref_hdr, tmp);1     	    Mark_Article_Seen(curgroup, cur_artnum);      	    if (OK(status)) {(     	    	default_action = cmd_readcont;+     	    	cleanup_action = Clear_ArtInProg;n1     	    	saved_default_action = cont_readthread; :     	    	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);"     	    	Article_In_Progress = 1;0     	    	saved_default_action = cmd_readthread;2     	    	status = Show_Article_Page(&cur_artctx);*     	    	if (status == NEWS__EOARTICLE) {/     	    	    default_action = cont_readthread; /     	    	    cleanup_action = Clear_ArtInProg;v     	    	}      	    	break;
     	    }     	}       	while (1) {     	    if (thread_newonly) {=     	    	cur_artnum = Next_Unseen_Article(cur_artnum, 0, 0);      	    } else {p     	    	cur_artnum += 1;
     	    }F     	    if (cur_artnum == 0 || cur_artnum > curgroup->lastavl) break;:     	    if (!Ignore_Article(curgroup, cur_artnum)) break;     	}B     	if (cur_artnum == 0 || cur_artnum > curgroup->lastavl) break;       }(  <     if (cur_artnum == 0 || cur_artnum > curgroup->lastavl) {!     	lib$signal(NEWS__NOMORE, 0);_     	cur_artnum = thread_base;     	thread_base = 0;r&     	default_action = cmd_readnextnew;-     	cleanup_action = (unsigned int (*)()) 0;t     }m       return SS$_NORMAL;   } /* cmd_readthread */ u /* **++ **  ROUTINE:	cont_readthread ** **  FUNCTIONAL DESCRIPTION:  **C **  	Continuation of a READ/THREAD command.  Finds the next articlelB **  with subject "matching" the thread base's subject.  The threadB **  base is established by reading an article with a command other **  than READ/THREAD.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cont_readthread() ** **  IMPLICIT INPUTS:	Several.h ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:c. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.c ** **-- */  unsigned int cont_readthread() {       struct GRP *g;9     char tmp[STRING_SIZE], xref_hdr[STRING_SIZE], *tsubj;A     struct HDR *hdr;     struct QUE *hdrqptr;     unsigned int status;
     int doit;n       Clear_ArtInProg();     if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);a     	return SS$_NORMAL;c     }t     if (thread_base == 0) {_#     	lib$signal(NEWS__NOTHREAD, 0);o     	return SS$_NORMAL;      } ?     if (thread_msgid[0] == '\0' && thread_subject[0] == '\0') {l$     	lib$signal(NEWS__NOSUBJECT, 0);     	return SS$_NORMAL;;     }*       while (1) { L     	if (thread_newonly) cur_artnum = Next_Unseen_Article(cur_artnum, 0, 0);>     	if (cur_artnum == 0 || cur_artnum >= curgroup->lastavl) {%     	    lib$signal(NEWS__NOMORE, 0);r"     	    cur_artnum = thread_base;     	    thread_base = 0; *     	    default_action = cmd_readnextnew;1     	    cleanup_action = (unsigned int (*)()) 0;S     	    return SS$_NORMAL;s     	}  *     	if (cur_artnum < curgroup->frstavl) {(     	    cur_artnum = curgroup->frstavl;
     	} else {i.     	    if (!thread_newonly) cur_artnum += 1;     	}  6     	if (!Ignore_Article(curgroup, cur_artnum)) break;       }        while (1) {        	if (User_Interrupt) break;0     	doit = 0;Q     	if (OK(Get_One_Header(curgroup, cur_artnum, NEWS_K_HDR_REFERENCES, &hdr))) { C     	    if (hdr != 0) doit = Thread_Match(hdr->str, thread_msgid);l9     	    else if (OK(Get_One_Header(curgroup, cur_artnum,_3     	    	    	    NEWS_K_HDR_MESSAGE_ID, &hdr))) {cD     	    	if (hdr != 0) doit = Thread_Match(thread_msgid, hdr->str);
     	    }     	}#     	if (!doit && !thread_strict &&gO     	    	OK(Get_One_Header(curgroup, cur_artnum, NEWS_K_HDR_SUBJECT, &hdr))) {C     	    if (hdr != 0) {      	    	strcpy(tmp, hdr->str);     	    	upcase(tmp);*     	    	if (strstr(tmp, "RE:") == tmp) {<     	    	    for (tsubj = tmp+3; isspace(*tsubj); tsubj++);     	    	 } else {      	    	    tsubj = tmp;     	    	 }     	    } else {=     	    	tsubj = "(none)";c
     	    }4     	    doit = (strstr(tsubj, thread_subject) != 0)6     	    	    || (strstr(thread_subject, tsubj) != 0);     	}     	if (doit) {     	    xref_hdr[0] = '\0';P     	    status = Retrieve_Article(cur_artnum, &cur_artctx, tmp, xref_hdr, tmp);1     	    Mark_Article_Seen(curgroup, cur_artnum);      	    if (OK(status)) {(     	    	default_action = cmd_readcont;+     	    	cleanup_action = Clear_ArtInProg;t:     	    	if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);"     	    	Article_In_Progress = 1;1     	    	saved_default_action = cont_readthread; 2     	    	status = Show_Article_Page(&cur_artctx);*     	    	if (status == NEWS__EOARTICLE) {/     	    	    default_action = cont_readthread;//     	    	    cleanup_action = Clear_ArtInProg;w     	    	})     	    	break;
     	    }     	}       	while (1) {     	    if (thread_newonly) {=     	    	cur_artnum = Next_Unseen_Article(cur_artnum, 0, 0);P     	    } else {      	    	cur_artnum += 1;
     	    }F     	    if (cur_artnum == 0 || cur_artnum > curgroup->lastavl) break;:     	    if (!Ignore_Article(curgroup, cur_artnum)) break;     	}B     	if (cur_artnum == 0 || cur_artnum > curgroup->lastavl) break;       }a  <     if (cur_artnum == 0 || cur_artnum > curgroup->lastavl) {!     	lib$signal(NEWS__NOMORE, 0);r     	cur_artnum = thread_base;     	thread_base = 0; &     	default_action = cmd_readnextnew;-     	cleanup_action = (unsigned int (*)()) 0;E     }O       return SS$_NORMAL;   } /* cont_readthread */    /* **++ **  ROUTINE:	cmd_readsubj  ** **  FUNCTIONAL DESCRIPTION:t ** **  	The READ/SUBJECT command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_readsubj(), ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:n. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.t ** **-- */ unsigned int cmd_readsubj() {        struct GRP *g;9     char xref_hdr[STRING_SIZE], tmp[STRING_SIZE], *tsubj;a     struct HDR *hdr, *shdr;      struct QUE *hdrqptr;%     struct dsc$descriptor tdsc, sdsc;r     unsigned int status;
     int doit;        Clear_ArtInProg();  =     if (OK(cli_get_value("SUBJECT", tmp+1, sizeof(tmp)-1))) {A=     	while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);c	     	do {o     	    upcase(tmp+1); :     	    if (!strchr(tmp+1, '*') && !strchr(tmp+1, '%')) {     	    	tmp[0] = '*';N"     	    	tsubj = tmp+strlen(tmp);     	    	*tsubj++ = '*';e     	    	*tsubj = '\0';     	    	tsubj = tmp;     	    } else {g     	    	tsubj = tmp+1;
        	    }T-     	    insert_header(tsubj, subjq.tail, 0);TC     	 } while (OK(cli_get_value("SUBJECT", tmp+1, sizeof(tmp)-1)));E     }D       if (subjq.head == &subjq) {e%     	lib$signal(NEWS__NOSUBJSPEC, 0);      	return SS$_NORMAL;/     }n  /     if (cli_present("GROUP") == CLI$_PRESENT) {G.     	cli_get_value("GROUP", tmp, sizeof(tmp));.     	status = Find_And_Set_Current_Group(tmp);     	if (!OK(status)) {OA     	    while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);=     	    return SS$_NORMAL;e	     	}         	cur_artnum = 0;     }        if (curgroup == NULL) {r%     	lib$signal(NEWS__NOCURGROUP, 0); =     	while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);      	return SS$_NORMAL;t     }          xref_hdr[0] = '\0';c     do {*     	if (cur_artnum < curgroup->frstavl) {(     	    cur_artnum = curgroup->frstavl;
     	} else {c     	    cur_artnum += 1;n     	};     	if (!Is_Valid_Article(curgroup, cur_artnum)) continue; 6     	if (!Ignore_Article(curgroup, cur_artnum)) break;.     } while (cur_artnum <= curgroup->lastavl);  -     while (cur_artnum <= curgroup->lastavl) {tN     	if (OK(Get_One_Header(curgroup, cur_artnum, NEWS_K_HDR_SUBJECT, &hdr))) {     	    if (hdr != 0) {      	    	strcpy(tmp, hdr->str);     	    	upcase(tmp);*     	    	if (strstr(tmp, "RE:") == tmp) {<     	    	    for (tsubj = tmp+3; isspace(*tsubj); tsubj++);     	    	} else {     	    	    tsubj = tmp;     	    	}      	    } else {W     	    	tsubj = "(none)";f
     	    }       	    doit = 0;0     	    INIT_SDESC(tdsc, strlen(tsubj), tsubj);V     	    for (shdr = subjq.head; shdr != (struct HDR * ) &subjq; shdr = shdr->flink) {9     	    	INIT_SDESC(sdsc, strlen(shdr->str), shdr->str);R1     	    	if (OK(str$match_wild(&tdsc, &sdsc))) {,     	    	    doit = 1;t     	    	    break;     	    	}:
     	    }     	    if (doit) {Q     	    	status = Retrieve_Article(cur_artnum, &cur_artctx, tmp, xref_hdr, tmp);I2     	    	Mark_Article_Seen(curgroup, cur_artnum);     	    	if (OK(status)) { ,     	    	    default_action = cmd_readcont;/     	    	    cleanup_action = Clear_ArtInProg; >     	    	    if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);&     	    	    Article_In_Progress = 1;3     	    	    saved_default_action = cont_readsubj;r6     	    	    status = Show_Article_Page(&cur_artctx);.     	    	    if (status == NEWS__EOARTICLE) {.     	    	    	default_action = cont_readsubj;0     	    	    	cleanup_action = Clear_ArtInProg;     	    	    }t     	    	    break;     	    	} 
     	    }     	}       	while (1) {     	    cur_artnum++;3     	    if (cur_artnum > curgroup->lastavl) break;U?     	    if (!Is_Valid_Article(curgroup, cur_artnum)) continue;s:     	    if (!Ignore_Article(curgroup, cur_artnum)) break;     	}       }o  )     if (cur_artnum > curgroup->lastavl) {u&     	lib$signal(NEWS__NOMOREMATCH, 0);=     	while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);*     	cur_artnum = thread_base;     	thread_base = 0;p&     	default_action = cmd_readnextnew;-     	cleanup_action = (unsigned int (*)()) 0;w     }a       return SS$_NORMAL;   } /* cmd_readsubj */ e /* **++ **  ROUTINE:	cont_readsubj ** **  FUNCTIONAL DESCRIPTION:a **> **  	The continuation of a subject-based read (when invoked as **  a default_action). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cont_readsubj() ** **  IMPLICIT INPUTS:	Several.r ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:u. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.i ** **-- */ unsigned int cont_readsubj() {       struct GRP *g;9     char xref_hdr[STRING_SIZE], tmp[STRING_SIZE], *tsubj;      struct HDR *hdr, *shdr;g     struct QUE *hdrqptr;%     struct dsc$descriptor tdsc, sdsc;      unsigned int status;
     int doit;        Clear_ArtInProg();         if (subjq.head == &subjq) {u%     	lib$signal(NEWS__NOSUBJSPEC, 0);*     	return SS$_NORMAL;T     }d       if (curgroup == NULL) {C%     	lib$signal(NEWS__NOCURGROUP, 0);/=     	while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);g     	return SS$_NORMAL;*     }        xref_hdr[0] = '\0';s     while (1) {y+     	if (cur_artnum >= curgroup->lastavl) {r*     	    lib$signal(NEWS__NOMOREMATCH, 0);A     	    while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);C"     	    cur_artnum = thread_base;     	    thread_base = 0; *     	    default_action = cmd_readnextnew;1     	    cleanup_action = (unsigned int (*)()) 0;G     	    return SS$_NORMAL;r     	}  *     	if (cur_artnum < curgroup->frstavl) {(     	    cur_artnum = curgroup->frstavl;
     	} else {      	    cur_artnum += 1;f     	};     	if (!Is_Valid_Article(curgroup, cur_artnum)) continue;a6     	if (!Ignore_Article(curgroup, cur_artnum)) break;     }u  -     while (cur_artnum <= curgroup->lastavl) {_N     	if (OK(Get_One_Header(curgroup, cur_artnum, NEWS_K_HDR_SUBJECT, &hdr))) {     	    if (hdr != 0) {      	    	strcpy(tmp, hdr->str);     	    	upcase(tmp);*     	    	if (strstr(tmp, "RE:") == tmp) {<     	    	    for (tsubj = tmp+3; isspace(*tsubj); tsubj++);     	    	} else {     	    	    tsubj = tmp;     	    	}U     	    } else {!     	    	tsubj = "(none)";a
     	    }       	    doit = 0;0     	    INIT_SDESC(tdsc, strlen(tsubj), tsubj);V     	    for (shdr = subjq.head; shdr != (struct HDR * ) &subjq; shdr = shdr->flink) {9     	    	INIT_SDESC(sdsc, strlen(shdr->str), shdr->str); 1     	    	if (OK(str$match_wild(&tdsc, &sdsc))) {r     	    	    doit = 1;      	    	    break;     	    	}I
     	    }     	    if (doit) {Q     	    	status = Retrieve_Article(cur_artnum, &cur_artctx, tmp, xref_hdr, tmp);v2     	    	Mark_Article_Seen(curgroup, cur_artnum);     	    	if (OK(status)) {i,     	    	    default_action = cmd_readcont;/     	    	    cleanup_action = Clear_ArtInProg; >     	    	    if (xref_hdr[0] != '\0') Mark_Xref(xref_hdr, 0);&     	    	    Article_In_Progress = 1;3     	    	    saved_default_action = cont_readsubj;r6     	    	    status = Show_Article_Page(&cur_artctx);.     	    	    if (status == NEWS__EOARTICLE) {.     	    	    	default_action = cont_readsubj;0     	    	    	cleanup_action = Clear_ArtInProg;     	    	    }f     	    	    break;     	    	}s
     	    }     	}       	while (1) {     	    cur_artnum++;3     	    if (cur_artnum > curgroup->lastavl) break; ?     	    if (!Is_Valid_Article(curgroup, cur_artnum)) continue;;:     	    if (!Ignore_Article(curgroup, cur_artnum)) break;     	}       }$  )     if (cur_artnum > curgroup->lastavl) { &     	lib$signal(NEWS__NOMOREMATCH, 0);=     	while (queue_remove(subjq.head, &hdr)) mem_freehdr(hdr);a     	cur_artnum = thread_base;     	thread_base = 0;g&     	default_action = cmd_readnextnew;-     	cleanup_action = (unsigned int (*)()) 0;      }c       return SS$_NORMAL;   } /* cont_readsubj */N c /* **++ **  ROUTINE:	cmd_current ** **  FUNCTIONAL DESCRIPTION:P **2 **  	The CURRENT command.  Re-displays the current **  article. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_current() ** **  IMPLICIT INPUTS:	Several.* ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_current() {       unsigned int status;     char tmp[STRING_SIZE];     int back_to_base;   >     back_to_base = cli_present("THREAD_BASE") == CLI$_PRESENT;       if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);i     	return SS$_NORMAL;)     }        if (back_to_base) {=4     	if (thread_base != 0) cur_artnum = thread_base;     }_       if (cur_artnum == 0) {#     	lib$signal(NEWS__NOCURART, 0);n     } else {E     	Read_Full_Headers = cli_present("FULL_HEADERS") == CLI$_PRESENT;=9     	rotate_text = cli_present("ROTATE") == CLI$_PRESENT;)     	if (cur_artctx == 0) {iK     	    status = Retrieve_Article(cur_artnum, &cur_artctx, thread_subject,a     	    	    	    tmp, tmp);E
     	} else {i%     	    Rewind_Article(&cur_artctx);      	    status = SS$_NORMAL;      	}       	if (OK(status)) {8     	    if (thread_base == 0) thread_base = cur_artnum;!     	    Article_In_Progress = 1; 3     	    if (cli_present("EDIT") == CLI$_PRESENT) { -     	    	status = Edit_Article(&cur_artctx);e0     	    	default_action = saved_default_action;     	    } else {!2     	    	status = Show_Article_Page(&cur_artctx);8     	    	default_action = (status == NEWS__EOARTICLE) ?2     	    	    saved_default_action : cmd_readcont;
     	    }*     	    cleanup_action = Clear_ArtInProg;
     	} else {)     	    Clear_ArtInProg();,     	}     }*       return SS$_NORMAL;   } /* cmd_current */u r /* **++ **  ROUTINE:	cmd_skipthreadE ** **  FUNCTIONAL DESCRIPTION:f **! **  	The SET SEEN/THREAD command.m **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_skipthread()r ** **  IMPLICIT INPUTS:	Several.I ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_skipthread() {        struct GRP *g;"     char tmp[STRING_SIZE], *tsubj;     struct HDR *hdr, *xhdr;      struct QUE *hdrqptr;     unsigned int status;.     int count, artnum, unsee, mark_xref, doit;     int strict;d       Clear_ArtInProg();     if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);a     	return SS$_NORMAL;r     },     if (thread_base == 0) {t#     	lib$signal(NEWS__NOTHREAD, 0);r     	return SS$_NORMAL;      }O  ?     if (thread_msgid[0] == '\0' && thread_subject[0] == '\0') {l$     	lib$signal(NEWS__NOSUBJECT, 0);     	return SS$_NORMAL;n     }_  3     strict = cli_present("STRICT") == CLI$_PRESENT;r  4     unsee = (cli_present("SEEN") == CLI$_NEGATED) ||1     	    (cli_present("UNSEEN") == CLI$_PRESENT);   B     mark_xref = (cli_present("CROSS_REFERENCES") == CLI$_PRESENT);       count = 0;T     for (artnum = (cur_artnum < curgroup->frstavl ? curgroup->frstavl : cur_artnum);1     	    artnum <= curgroup->lastavl; artnum++) {      	if (User_Interrupt) break;)7     	if (!Is_Valid_Article(curgroup, artnum)) continue;=-     	if (!Ignore_Article(curgroup, artnum)) {      	    doit = 0;Q     	    if (OK(Get_One_Header(curgroup, artnum, NEWS_K_HDR_REFERENCES, &hdr))) {r     	    	if (hdr != 0) { :     	    	    doit = Thread_Match(hdr->str, thread_msgid);8     	    	} else if (OK(Get_One_Header(curgroup, artnum,8     	    	    	    	    NEWS_K_HDR_MESSAGE_ID, &hdr))) {H     	    	    if (hdr != 0) doit = Thread_Match(thread_msgid, hdr->str);     	    	}d
     	    }      	    if (!doit && !strict &&O     	    	    OK(Get_One_Header(curgroup, artnum, NEWS_K_HDR_SUBJECT, &hdr))) {      	    	tsubj = NULL;      	    	if (hdr != 0) {u$     	    	    strcpy(tmp, hdr->str);     	    	    upcase(tmp);D     	    	    if (tmp[0] == 'R' && tmp[1] == 'E' && tmp[2] == ':') {=     	    	    	for (tsubj = tmp+3; isspace(*tsubj); tsubj++);j     	    	    } else {     	    	    	tsubj = tmp;a     	    	    }c     	    	}   &     	    	if (tsubj == NULL) continue;  8     	    	doit = (strstr(tsubj, thread_subject) != 0) ||4     	    	    	(strstr(thread_subject, tsubj) != 0);
     	    }       	    if (doit) {C     	    	count += (unsee ? Mark_Article_Unseen(curgroup, artnum) :	9     	    	    	    	Mark_Article_Seen(curgroup, artnum));r     	    	if (mark_xref) {Q     	    	    if (OK(Get_One_Header(curgroup, artnum, NEWS_K_HDR_XREF, &xhdr))) {[:     	    	    	if (xhdr != 0) Mark_Xref(xhdr->str, unsee);     	    	    }n     	    	}a
     	    }     	}     }   P     lib$signal(NEWS__MARKCOUNT, 3, count, (unsee ? 2 : 0), (unsee ? "un" : ""));       return SS$_NORMAL;   } /* cmd_skipthread */ b /* **++ **  ROUTINE:	cmd_skipsubjO ** **  FUNCTIONAL DESCRIPTION:M **" **  	The SET SEEN/SUBJECT command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_skipsubj()  ** **  IMPLICIT INPUTS:	Several.l ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.O ** **-- */ unsigned int cmd_skipsubj() {;       struct GRP *g;     char tmp[STRING_SIZE], *cp; %     struct HDR *hdr, *subjhdr, *xhdr;o     struct QUE tmpq, *hdrqptr;%     struct dsc$descriptor tdsc, sdsc;      unsigned int status;(     int count, artnum, unsee, mark_xref;     int rstart, rend;e       Clear_ArtInProg();     if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);r     	return SS$_NORMAL;      }   "     tmpq.head = tmpq.tail = &tmpq;  =     if (OK(cli_get_value("SUBJECT", tmp+1, sizeof(tmp)-1))) {r	     	do {a     	    upcase(tmp+1);C:     	    if (!strchr(tmp+1, '*') && !strchr(tmp+1, '%')) {     	    	tmp[0] = '*'; !     	    	cp = tmp + strlen(tmp);(     	    	*cp++ = '*';     	    	*cp++ = '\0';_     	    	cp = tmp;)     	    } else {(     	    	cp = tmp+1;_
     	    })     	    insert_header(cp, tmpq.tail, 0); B     	} while (OK(cli_get_value("SUBJECT", tmp+1, sizeof(tmp)-1)));     }_       if (tmpq.head == &tmpq) {)%     	lib$signal(NEWS__NOSUBJSPEC, 0);      	return SS$_NORMAL;      }   4     unsee = (cli_present("SEEN") == CLI$_NEGATED) ||1     	    (cli_present("UNSEEN") == CLI$_PRESENT);j  B     mark_xref = (cli_present("CROSS_REFERENCES") == CLI$_PRESENT);       count = 0;   /*M **  Must be able to handle just SET SEEN/SUBJ (implies current->last article)r( **  and specification of article ranges. */     while (1) {u  1     	if (cli_present("ARTRNG") == CLI$_PRESENT) {dC     	    if (!OK(cli_get_value("ARTRNG", tmp, sizeof(tmp)))) break;cK     	    if (!OK(Parse_Range(tmp, &rstart, &rend, cur_artnum, curgroup))) { ;     	    	lib$signal(NEWS__INVARTRNG, 2, strlen(tmp), tmp);a     	    } else {l     	    	int i;     	    	if (rstart > rend) {     	    	    i = rstart;f     	    	    rstart = rend;     	    	    rend = i;      	    	}e
     	    }@     	    if (rend > curgroup->lastavl) rend = curgroup->lastavl;
     	} else {      	    rstart = cur_artnum;)"     	    rend = curgroup->lastavl;     	}  M     	for (artnum = (rstart < curgroup->frstavl ? curgroup->frstavl : rstart); 9     	    	    	    	    	    	artnum <= rend; artnum++) {i#     	    if (User_Interrupt) break;r;     	    if (!Is_Valid_Article(curgroup, artnum)) continue;s1     	    if (!Ignore_Article(curgroup, artnum)) {   F     	    	if (!OK(Get_One_Header(curgroup, artnum, NEWS_K_HDR_SUBJECT,,     	    	    	    	&subjhdr))) subjhdr = 0;     	    	if (subjhdr != 0) {u  8     	    	    strncpy(tmp, subjhdr->str, sizeof(tmp)-1);(     	    	    tmp[sizeof(tmp)-1] = '\0';     	    	    upcase(tmp);1     	    	    INIT_SDESC(tdsc, strlen(tmp), tmp);eT     	    	    for (hdr = tmpq.head; hdr != (struct HDR *) &tmpq; hdr = hdr->flink) {<     	    	    	INIT_SDESC(sdsc, strlen(hdr->str), hdr->str);6     	    	    	if (OK(str$match_wild(&tdsc, &sdsc))) {L     	    	    	    count += (unsee ? Mark_Article_Unseen(curgroup, artnum) :=     	    	    	    	    Mark_Article_Seen(curgroup, artnum)); #     	    	    	    if (mark_xref) {P;     	    	    	    	if (OK(Get_One_Header(curgroup, artnum,l4     	    	    	    	    	NEWS_K_HDR_XREF, &xhdr))) {C     	    	    	    	    if (xhdr != 0) Mark_Xref(xhdr->str, unsee);      	    	    	    	}l     	    	    	    }     	    	    	    break;      	    	    	}     	    	    }_     	    	}Z
     	    }     	}  6     	if (cli_present("ARTRNG") != CLI$_PRESENT) break;       }   ;     while (queue_remove(tmpq.head, &hdr)) mem_freehdr(hdr);;P     lib$signal(NEWS__MARKCOUNT, 3, count, (unsee ? 2 : 0), (unsee ? "un" : ""));       return SS$_NORMAL;   } /* cmd_skipsubj */ s /* **++ **  ROUTINE:	cmd_group ** **  FUNCTIONAL DESCRIPTION:m ** **  	The GROUP command.t **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_group() ** **  IMPLICIT INPUTS:	Several.0 ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.h ** **-- */ unsigned int cmd_group() {       char tmp[STRING_SIZE];     unsigned int status;  .     cli_get_value("GRPNAM", tmp, sizeof(tmp));-     status = Find_And_Set_Current_Group(tmp);s1     if (OK(status)) default_action = cmd_readnew;e       return status;   } /* cmd_group */  d /* **++' **  ROUTINE:	Find_And_Set_Current_Group  ** **  FUNCTIONAL DESCRIPTION:s **< **  	Actually does the real work of a GROUP command... well, **  at least the lookup part.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **- **  	Find_And_Set_Current_Group(char *grpnam)) **< ** grpnam: character string, read only, by reference (ASCIZ) ** **  IMPLICIT INPUTS:	Several.u ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.u ** **-- */> static unsigned int Find_And_Set_Current_Group(char *grpnam) {       struct GRP *g;     char tmp[STRING_SIZE];     unsigned int status, ctx;c       locase(grpnam);      g = Find_Group(grpnam);r     if (g == NULL) {     	strcpy(tmp, grpnam); J     	if (strchr(tmp, '*') == 0 && strchr(tmp, '%') == 0) strcat(tmp, "*");
     	ctx = 0;	4     	while ((g = Find_Group_Wild(tmp, &ctx)) != 0) {     	    if (g->subscribed) {t      	    	Traverse_Finish(&ctx);     	    	break;
     	    }     	}     }      if (g == NULL) {G     	lib$signal((status = NEWS__NOSUCHGRP), 2, strlen(grpnam), grpnam);(      } else if (!g->subscribed) {G     	lib$signal((status = NEWS__NOTSUBSCR), 2, strlen(grpnam), grpnam);>     } else {#     	status = Set_Current_Group(g);t#     	if (news_prof.glist == NULL) {r-     	    if (g != Current_TreeNode(&rgctx)) {o     	    	struct GRP *gtmp;;"     	    	Traverse_Finish(&rgctx);6     	    	while ((gtmp = Traverse_Tree(&rgctx)) != g);
     	    }     	}:     	lib$signal(NEWS__GRPSET, 2, strlen(curgroup->grpnam),@     	    	curgroup->grpnam, NEWS__GRPINFO, 3, curgroup->frstavl,5     	    	curgroup->lastavl, Count_Unseen(curgroup));C     }t       return SS$_NORMAL;  " } /* Find_And_Set_Current_Group */ , /* **++ **  ROUTINE:	Set_Current_Group ** **  FUNCTIONAL DESCRIPTION:c **' **  	Makes a group the "current" group.= **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **' **  	Set_Current_Group(struct GRP *grp)  **+ ** grp: GRP structure, modify, by reference  ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:a. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.l ** **-- */1 unsigned int Set_Current_Group(struct GRP *grp) {e       char tmp[STRING_SIZE];-     int artcnt, reply_code, first, len, last;m       cur_artnum = 0;u+     if (curgroup == grp) return SS$_NORMAL;        curgroup = grp;b     strcpy(tmp, "GROUP ");     strcat(tmp, grp->grpnam);d     server_send(tmp);eI     server_get_reply(SRV__NOECHO, &reply_code, tmp, sizeof(tmp)-1, &len);g*     if (reply_code != NNTP__GRPSELECTED) {9     	lib$signal(NEWS__UNEXPRSP, 3, reply_code, len, tmp);:     	return NEWS__UNEXPRSP;I     }S       tmp[len] = '\0';3     parse_group_reply(tmp, &artcnt, &first, &last);sL     if (grp->valid != 0 && (first > grp->frstavl || last != grp->lastavl)) {     	free(grp->valid);     	grp->valid = 0;     }_A     grp->frstavl = (first > grp->frstavl) ? first : grp->frstavl;T       return SS$_NORMAL;   } /* Set_Current_Group */R : /* **++ **  ROUTINE:	cmd_extract ** **  FUNCTIONAL DESCRIPTION:* ** **  	The EXTRACT command.e **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_extract() ** **  IMPLICIT INPUTS:	Several.  ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.  ** **-- */ unsigned int cmd_extract() {  C     char fspec[FSPEC_SIZE], rspec[FSPEC_SIZE], tmpfile[FSPEC_SIZE];a@     char tmp[STRING_SIZE], tmp2[STRING_SIZE], gnam[STRING_SIZE];%     struct dsc$descriptor dsc1, dsc2;_     struct QUE rangeq, *hdrq;r     struct RNG *rng;     struct HDR *hdr;"     struct GRP *g, *curgroup_save;Q     int rstart, rend, did_one, do_headers, rotate, append, i, tlen, full_headers;&?     int do_new, do_mark, do_group, do_wild, do_file, do_ignore; +     unsigned int unit, unit2, status, gctx;o7     $DESCRIPTOR(underscores, "______________________"); 9     $DESCRIPTOR(specials,    "!\"#%&'()*+,/@[\\]^{|}~."); R     $DESCRIPTOR(alphabet, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");R     $DESCRIPTOR(rot13bet, "NOPQRSTUVWXYZABCDEFGHIJKLMnopqrstuvwxyzabcdefghijklm");  4     do_group = cli_present("GROUP") == CLI$_PRESENT;  (     if (!do_group && curgroup == NULL) {%     	lib$signal(NEWS__NOCURGROUP, 0);_     	return SS$_NORMAL;d     }r  3     do_file = cli_present("FSPEC") == CLI$_PRESENT;      if (do_file) {2     	cli_get_value("FSPEC", fspec, sizeof(fspec));4     	append = cli_present("APPEND") == CLI$_PRESENT;     }   (     rangeq.head = rangeq.tail = &rangeq;  8     do_headers = cli_present("HEADERS") != CLI$_NEGATED;     if (do_headers) {!:     	if (OK(cli_get_value("HEADERS", tmp, sizeof(tmp)))) {&     	    full_headers = tmp[0] == 'F';     	} else full_headers = 0;h     } else full_headers = 0;  3     rotate = cli_present("ROTATE") == CLI$_PRESENT;T0     do_new = cli_present("NEW") == CLI$_PRESENT;2     do_mark = cli_present("MARK") == CLI$_PRESENT;6     do_ignore = cli_present("IGNORE") == CLI$_PRESENT;  0     if (cli_present("ARTRNG") == CLI$_PRESENT) {<     	while (OK(cli_get_value("ARTRNG", tmp, sizeof(tmp)))) {K     	    if (!OK(Parse_Range(tmp, &rstart, &rend, cur_artnum, curgroup))) {a;     	    	lib$signal(NEWS__INVARTRNG, 2, strlen(tmp), tmp); C     	    	while (queue_remove(rangeq.head, &rng)) mem_freerng(rng);r     	    	return SS$_NORMAL;
     	    }     	    if (rstart > rend) { ;     	    	lib$signal(NEWS__INVARTRNG, 2, strlen(tmp), tmp); C     	    	while (queue_remove(rangeq.head, &rng)) mem_freerng(rng);(     	    	return SS$_NORMAL;
     	    }S     	    if (!do_group && (rend > curgroup->lastavl || rend < curgroup->frstavl)) { >     	    	lib$signal(NEWS__OUTRNG, 3, rend, curgroup->frstavl,&     	    	    	    curgroup->lastavl);C     	    	while (queue_remove(rangeq.head, &rng)) mem_freerng(rng);      	    	return SS$_NORMAL;
     	    }W     	    if (!do_group && (rstart > curgroup->lastavl || rstart < curgroup->frstavl)) { @     	    	lib$signal(NEWS__OUTRNG, 3, rstart, curgroup->frstavl,&     	    	    	    curgroup->lastavl);C     	    	while (queue_remove(rangeq.head, &rng)) mem_freerng(rng);      	    	return SS$_NORMAL;
     	    }     	    rng = mem_getrng();     	    rng->first = rstart;u     	    rng->last = rend;(     	    queue_insert(rng, rangeq.tail);     	}     } else if (!do_new) {T     	if (cur_artnum == 0) {C'     	    lib$signal(NEWS__NOCURART, 0);T     	    return SS$_NORMAL;r     	}     	rng = mem_getrng();)     	rng->first = rng->last = cur_artnum;n$     	queue_insert(rng, rangeq.tail);     } else {     	rng = mem_getrng();     	rng->first = 1;     	rng->last = 9999999;.$     	queue_insert(rng, rangeq.tail);     }:       if (do_file) {     	if (append) {8     	    status = file_exists(fspec, news_prof.archive);%     	    if (!OK(status)) append = 0;      	}       	did_one = append;       	if (append) {I     	    status = file_append(fspec, &unit, news_prof.archive, rspec, 0);g
     	} else { F     	    status = file_create(fspec, &unit, news_prof.archive, rspec);     	}     	if (!OK(status)) { D     	    lib$signal(NEWS__OPENERR, 2, strlen(fspec), fspec, status);B     	    while (queue_remove(rangeq.head, &rng)) mem_freerng(rng);     	    return SS$_NORMAL;c     	}     }L  
     g = 0;
     gctx = 0;      curgroup_save = curgroup;"       while (1) {E     	int count;c       	if (User_Interrupt) break;        	if (do_group) {     	    if (gctx == 0) {sE     	    	if (!OK(cli_get_value("GROUP", gnam, sizeof(gnam)))) break;n     	    	locase(gnam); E     	    	do_wild = strchr(gnam, '%' != 0) || strchr(gnam, '*') != 0; 8     	    	if (do_wild) g = Find_Group_Wild(gnam, &gctx);$     	    	else g = Find_Group(gnam);1     	    } else g = Find_Group_Wild(gnam, &gctx);      	    if (g == 0) continue;1     	    if (do_wild && !g->subscribed) continue;a'     	    status = Set_Current_Group(g);t#     	    if (!OK(status)) continue; 
     	} else {l"     	    if (g == curgroup) break;     	    g = curgroup;     	}       	if (!do_file) {;     	    INIT_SDESC(dsc1, strlen(curgroup->grpnam), fspec); F     	    INIT_SDESC(dsc2, strlen(curgroup->grpnam), curgroup->grpnam);>     	    str$translate(&dsc1, &dsc2, &underscores, &specials);8     	    strcpy(fspec+strlen(curgroup->grpnam), ".TXT");4 	    append = cli_present("APPEND") != CLI$_NEGATED;       	    if (append) {9     	    	status = file_exists(fspec, news_prof.archive);i&     	    	if (!OK(status)) append = 0;
     	    }       	    did_one = append;     	    unit = 0;       	    if (append) {J     	    	status = file_append(fspec, &unit, news_prof.archive, rspec, 0);     	    } else {cG     	    	status = file_create(fspec, &unit, news_prof.archive, rspec);b
     	    }     	    if (!OK(status)) {uE     	    	lib$signal(NEWS__OPENERR, 2, strlen(fspec), fspec, status);e     	    	break;
     	    }     	}       	count = 0;o  O     	for (rng = rangeq.head; rng != (struct RNG *) &rangeq; rng = rng->flink) {t       	    rstart = rng->first;(6     	    if (rstart < g->frstavl) rstart = g->frstavl;6     	    if (rstart > g->lastavl) rstart = g->lastavl;     	    rend = rng->last;2     	    if (rend < g->frstavl) rend = g->frstavl;2     	    if (rend > g->lastavl) rend = g->lastavl;  #     	    if (User_Interrupt) break;E       	    status = SS$_NORMAL;"  H     	    for (i = do_new ? Next_Unseen_Article(rstart-1, 0, 0) : rstart;#     	    	    	i != 0 && i <= rend;RA     	    	    	i = do_new ? Next_Unseen_Article(i, 0, 0) : i+1) {u  $     	    	if (User_Interrupt) break;  0     	    	if (!Is_Valid_Article(g, i)) continue;:     	    	if (do_ignore && Ignore_Article(g, i)) continue;/     	    	if (do_mark) Mark_Article_Seen(g, i);)     	    	if (do_headers) {e;     	    	    status = Get_Article_Hdrs(g, i, &hdrq, 1, 0);i      	    	    if (!OK(status)) {;     	    	    	if (status == NEWS__NOSUCHARTICLE) continue;0W     	    	    	if (status == NEWS__ARTRERR) lib$signal(NEWS__EXTRERR, 1, i, status, 0);(<     	    	    	else lib$signal(NEWS__EXTRERR, 1, i, status);     	    	    	break;)     	    	    }      	    	}0  *     	    	if (!do_headers || OK(status)) {0     	    	    make_temp_fspec(tmp, sizeof(tmp));?     	    	    status = Get_Article_Body(i, tmp, tmpfile, 0, 0);S      	    	    if (!OK(status)) {      	    	    	file_delete(tmp);;     	    	    	if (status == NEWS__NOSUCHARTICLE) continue;	W     	    	    	if (status == NEWS__ARTRERR) lib$signal(NEWS__EXTRERR, 1, i, status, 0); <     	    	    	else lib$signal(NEWS__EXTRERR, 1, i, status);     	    	    	break;      	    	    } else {     	    	    	count++;      	    	    	if (did_one) {b$     	    	    	    if (do_headers) {$     	    	    	    	file_write(unit,X "================================================================================", 80);     	    	    	    }"     	    	    	} else did_one = 1;      	    	    	if (do_headers) {     	    	    	    int len;p!     	    	    	    struct HDR *h;e&     	    	    	    if (full_headers) {D     	    	    	    	len = sprintf(tmp, "Local-Article-ID: %s:%s#%d",C     	    	    	    	    news_cfg.server_name, curgroup->grpnam, i);a/     	    	    	    	file_write(unit, tmp, len);W     	    	    	    }F     	    	    	    for (hdr = hdrq->head;  hdr != (struct HDR *) hdrq;6     	    	    	    	    	    	    	hdr = hdr->flink) {'     	    	    	    	if (full_headers) { C     	    	    	    	    Format_Header(hdr, tmp, sizeof(tmp), &len);l<     	    	    	    	    status = file_write(unit, tmp, len);     	    	    	    	} else {,     	    	    	    	    status = SS$_NORMAL;9     	    	    	    	    for (h = news_prof.ehdrlist.head;NA     	    	    	    	    	h != (struct HDR *) &news_prof.ehdrlist;r(     	    	    	    	    	h = h->flink) {4     	    	    	    	    	if (h->code == hdr->code) {H     	    	    	    	    	    Format_Header(hdr, tmp, sizeof(tmp), &len);A     	    	    	    	    	    status = file_write(unit, tmp, len);s#     	    	    	    	    	    break;      	    	    	    	    	}     	    	    	    	    }o     	    	    	    	}=+     	    	    	    	if (!OK(status)) break;      	    	    	    }D     	    	    	    if (OK(status)) status = file_write(unit, "", 0);     	    	    	}L     	    	    	if (OK(status)) status = file_open(tmpfile, &unit2, 0, 0, 0);!     	    	    	if (!OK(status)) {h;     	    	    	    lib$signal(NEWS__EXTRERR, 1, i, status);p(     	    	    	    file_delete(tmpfile);     	    	    	    break;      	    	    	}H     	    	    	while (OK(file_read(unit2, tmp, sizeof(tmp)-1, &tlen))) {$     	    	    	    tmp[tlen] = '\0';      	    	    	    if (rotate) {8     	    	    	    	INIT_SDESC(dsc1, strlen(tmp), tmp2);7     	    	    	    	INIT_SDESC(dsc2, strlen(tmp), tmp);rF     	    	    	    	str$translate(&dsc1, &dsc2, &alphabet, &rot13bet);/     	    	    	    	*(tmp2+strlen(tmp)) = '\0';RG     	    	    	    	status = file_write(unit, tmp2, dsc1.dsc$w_length);EF     	    	    	    } else status = file_write(unit, tmp, strlen(tmp));*     	    	    	    if (!OK(status)) break;     	    	    	}!     	    	    	file_close(unit2); $     	    	    	file_delete(tmpfile);!     	    	    	if (!OK(status)) {K;     	    	    	    lib$signal(NEWS__EXTRERR, 1, i, status);      	    	    	    break;r     	    	    	}     	    	    })     	    	}      	    } /* for i */      	    if (!OK(status)) break;     	} /* for rng */  !     	if (!do_file && unit != 0) {n     	    file_close(unit);     	    unit = 0;     	}       	if (!OK(status)) break;  D     	lib$signal(NEWS__EXTRACTED, 3, count, strlen(curgroup->grpnam),%     	    	    	    curgroup->grpnam);        } /* loop through groups */   "     if (do_file) file_close(unit);=     while (queue_remove(rangeq.head, &rng)) mem_freerng(rng);s*     if (gctx != 0) Traverse_Finish(&gctx);0     if (!did_one && !append) file_delete(rspec);$     if (curgroup != curgroup_save) {6     	if (curgroup_save == 0) curgroup = curgroup_save;+     	else Set_Current_Group(curgroup_save);      }	       return SS$_NORMAL;   } /* cmd_extract */D U /* **++ **  ROUTINE:	Clear_ArtInProg ** **  FUNCTIONAL DESCRIPTION:d **3 **  	Clears the article read currently in progress.z **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	Clear_ArtInProg() ** **  IMPLICIT INPUTS:	Several.h ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:{. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.O ** **-- */  unsigned int Clear_ArtInProg() {       if (Article_In_Progress) {     	if (cur_artctx != 0) {:$     	    Close_Article(&cur_artctx);     	}     	Article_In_Progress = 0; )     	rotate_text = Read_Full_Headers = 0;      	Finish_Paged_Output(0);>     	default_action = cleanup_action = (unsigned int (*)()) 0;     }        return SS$_NORMAL;   } /* Clear_ArtInProg */r n /* **++ **  ROUTINE:	Find_Next_Unseen	 ** **  FUNCTIONAL DESCRIPTION:e **@ **  	Finds the next unseen article, following the group tree (or
 **  list). **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **2 **  	Find_Next_Unseen(int startpoint, int *newart) **2 ** startpoint: article number, read only, by value7 ** newart:     article number, write only, by reference  ** **  IMPLICIT INPUTS:	Several.* ** **  IMPLICIT OUTPUTS:	Several. ** **  COMPLETION CODES:*. **  	SS$_NORMAL: 	normal successful completion ** **  SIDE EFFECTS:   	Several.T ** **-- */C static unsigned int Find_Next_Unseen(int startpoint, int *newart) {T       struct GRP *g, *hold;E"     int a, b, pass2, was_curgroup;     unsigned int status;       if (curgroup == NULL) {l     	if (news_prof.glist) {t     	    g = news_prof.glist;S
     	} else { !     	    Traverse_Finish(&rgctx);e#     	    g = Traverse_Tree(&rgctx);      	}     	while (g != NULL) {     	    if (g->subscribed) {)+     	    	a = Next_Unseen_Article(0, 1, g);n     	    	if (a > 0) {,     	    	    status = Set_Current_Group(g);     	    	    if (OK(status)) {N0     	    	    	a = Next_Unseen_Article(0, 0, 0);     	    	    	if (a > 0) {l     	    	    	    *newart = a; %     	    	    	    return SS$_NORMAL;      	    	    	}     	    	    }*     	    	}P
     	    }?     	    g = news_prof.glist ? g->next : Traverse_Tree(&rgctx);t     	}     } else {     	g = hold = curgroup;*     	a = startpoint;     	pass2 = 0;M	     	do {U     	    if (g->subscribed) {N7     	    	if ((b = Next_Unseen_Article(a, 1, g)) > 0) { ,     	    	    status = Set_Current_Group(g);     	    	    if (OK(status)) {S0     	    	    	a = Next_Unseen_Article(a, 0, 0);     	    	    	if (a > 0) {E     	    	    	    *newart = a;c%     	    	    	    return SS$_NORMAL;G     	    	    	}     	    	    }{     	    	}(
     	    }?     	    g = news_prof.glist ? g->next : Traverse_Tree(&rgctx);a#     	    if (g == NULL && !pass2) {iH     	    	g = news_prof.glist ? news_prof.glist : Traverse_Tree(&rgctx);     	    	pass2 = 1;
     	    }     	    a = 0;a     	} while (g != NULL);        	if (hold->subscribed) {*     	    status = Set_Current_Group(hold);     	    if (OK(status)) {+     	    	a = Next_Unseen_Article(0, 0, 0);()     	    	if (a > 0 && a != startpoint) {m     	    	    *newart = a;      	    	    return SS$_NORMAL;     	    	}n
     	    }     	}     }        return NEWS__NONEW;r   } /* Find_Next_Unseen */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      