 /* **++ **  FACILITY:	NEWSRDR  **$ **  ABSTRACT:	SET and SHOW commands. ** **  MODULE DESCRIPTION:  **@ **  	This module contains most, if not all, of the SET commands, **  and the SHOW command.  ** **  AUTHOR: 	    M. Madison 7 **  	    	    COPYRIGHT  1993, 1994  MADGOAT SOFTWARE. " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  09-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	09-SEP-1992 V1.0    Madison 	Initial coding. 3 **  	11-SEP-1992 V1.0-1  Madison 	Added SET NEWSRC. C **  	12-SEP-1992 V1.0-2  Madison 	Added SET DIR, SET QUE, SET FORM. > **  	17-SEP-1992 V1.0-3  Madison 	Fixed problem in SET IGNORE.H **  	28-SEP-1992 V1.0-4  Madison 	Fixed big SET HEADER-related problems.D **  	07-OCT-1992 V1.0-5  Madison 	Fix SET SEEN/UNSEEN range problem.5 **  	08-OCT-1992 V1.0-6  Madison 	Added SHOW VERSION. D **  	15-FEB-1993 V1.0-7  Madison 	Make compatible with pre-VMS V5.2.7 **  	15-FEB-1993 V1.1    Madison 	Added SET SEEN/CROSS. G **  	12-APR-1993 V1.2    Madison 	Get_Article_* changes, SET AUTO_READ. B **  	23-APR-1993 V1.2-1  Madison 	Add FORCE_MAIL_PROTOCOL support.@ **  	23-MAY-1993 V1.2-2  Madison 	Allow SET SEEN/THREAD w/range.; **  	22-JUN-1993 V1.3    Madison 	Add SET AUTO_SAVE_PROFILE : **  	09-OCT-1993 V1.3-1  Madison 	Fixed MARKCOUNT message.> **  	16-MAR-1994 V1.4    Madison 	Added SET IGNORE/MESSAGE_ID.< **  	16-MAY-1994 V1.5    Madison 	Customizable REPLY prefix. **-- */ #include "newsrdr.h" #include "globals.h" #ifdef __GNUC__  #include <vms/fscndef.h> #include <vms/rmsdef.h>  #else  #include <fscndef.h> #include <rmsdef.h>  #endif        EXTERN struct GRP *curgroup;!     EXTERN int        cur_artnum;      EXTERN int        pb_cols;$     EXTERN int	      User_Interrupt;"     EXTERN char       *$$$Version;  !     static char *hdrname[] = {"", ;     	"FROM", "DATE", "NEWSGROUPS", "SUBJECT", "MESSAGE_ID", <     	"PATH", "REPLY_TO", "SENDER", "FOLLOWUP_TO", "EXPIRES",=     	"REFERENCES", "CONTROL", "DISTRIBUTION", "ORGANIZATION", B     	"KEYWORDS", "SUMMARY", "APPROVED", "LINES", "XREF", "OTHER"};  4     extern int Mark_Article_Seen(struct GRP *, int);6     extern int Mark_Article_Unseen(struct GRP *, int);1     extern int Ignore_Article(struct GRP *, int); M     extern unsigned int Parse_Range(char *, int *, int *, int, struct GRP *); *     extern struct GRP *Find_Group(char *);?     extern struct GRP *Find_Group_Wild(char *, unsigned int *); 8     extern unsigned int Traverse_Finish(unsigned int *);*     extern int Count_Unseen(struct GRP *);+     extern unsigned int cmd_skipsubj(void); -     extern unsigned int cmd_skipthread(void); '     extern void Mark_Xref(char *, int); ;     extern unsigned int Get_Article_Hdrs(struct GRP *, int, .     	    	    	    struct QUE **, int, int *);4     extern void Get_Mail_Personal_Name(char *, int);   /* **++ **  ROUTINE:	cmd_set_headers ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET HEADERS command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_headers() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_prof  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */  unsigned int cmd_set_headers() {       char tmp[STRING_SIZE], *cp;      struct HDR *h, *h2;      int remove, hdrcode;     struct QUE *hq;   G     hq = cli_present("EXTRACT") == CLI$_PRESENT ? &news_prof.ehdrlist :      	    	&news_prof.hdrlist;   ;     while (OK(cli_get_value("HDRNAM", tmp, sizeof(tmp)))) {      	cp = tmp;)     	remove = strncmp(tmp, "NO", 2) == 0;      	if (remove) cp += 2; M     	for (hdrcode = 1; hdrcode < sizeof(hdrname)/sizeof(char *); hdrcode++) { E     	    if (strstr(hdrname[hdrcode], cp) == hdrname[hdrcode]) break;      	}?     	for (h = hq->head; h != (struct HDR *) hq; h = h->flink) { '     	    if (h->code >= hdrcode) break;      	}8     	if (h == (struct HDR *) hq || h->code != hdrcode) {     	    if (remove) {;     	    	lib$signal(NEWS__HDRNOTFOUND, 2, strlen(cp), cp);      	    } else {      	    	h2 = mem_gethdr(0);      	    	h2->code = hdrcode; K     	    	queue_insert(h2, (h == (struct HDR *) hq ? hq->tail : h->blink)); 
     	    }
     	} else {      	    if (remove) {     	    	queue_remove(h, &h2);      	    	mem_freehdr(h2);     	    } else { 8     	    	lib$signal(NEWS__HDRALRDY, 2, strlen(cp), cp);
     	    }     	}     }        return SS$_NORMAL;   } /* cmd_set_headers */    /* **++ **  ROUTINE:	cmd_set_reply ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET REPLY command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_reply() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_prof  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_reply() {       char tmp[STRING_SIZE];
     int i;     unsigned int status;     static struct {      	int *flag;      	char *tag; L     } pm[2] = {{&news_prof.replypost,"POST"},{&news_prof.replymail,"MAIL"}};    3     if (cli_present("REPLYTYPE") == CLI$_PRESENT) { 3     	news_prof.replypost = news_prof.replymail = 0; ?     	while (OK(cli_get_value("REPLYTYPE", tmp, sizeof(tmp)))) { "     	    for (i = 0; i < 2; i++) {E     	    	if (strstr(pm[i].tag, tmp) == pm[i].tag) *(pm[i].flag) = 1; 
     	    }     	}     }   #     status = cli_present("PREFIX"); !     if (status == CLI$_PRESENT) { /     	cli_get_value("PREFIX", tmp, sizeof(tmp));      	i = strlen(tmp); .     	if (i > sizeof(news_prof.reply_prefix)-1).     	    i = sizeof(news_prof.reply_prefix)-1;,     	memcpy(news_prof.reply_prefix, tmp, i);&     	news_prof.reply_prefix[i] = '\0';$     	news_prof.reply_prefix_len = i;(     } else if (status == CLI$_NEGATED) {&     	news_prof.reply_prefix[0] = '\0';$     	news_prof.reply_prefix_len = 0;     }        return SS$_NORMAL;   } /* cmd_set_reply */    /* **++ **  ROUTINE:	cmd_set_persnam ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET PERSONAL_NAME command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_persnam() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_prof  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */  unsigned int cmd_set_persnam() {       unsigned int status;  *     status = cli_present("PERSONAL_NAME");!     if (status == CLI$_NEGATED) { $     	*news_prof.personalname = '\0';     	news_prof.usemailpnam = 0;      } else {2     	if (cli_present("PERSNAM") == CLI$_PRESENT) {9     	    cli_get_value("PERSNAM", news_prof.personalname, .     	    	    sizeof(news_prof.personalname));#     	    news_prof.usemailpnam = 0; 6     	} else if (cli_present("MAIL") == CLI$_PRESENT) {#     	    news_prof.usemailpnam = 1; 7     	    Get_Mail_Personal_Name(news_prof.personalname, 8     	    	    	    	    sizeof(news_prof.personalname));
     	} else {      	    char tmp[STRING_SIZE];      	    *tmp = '\0'; -     	    get_cmd(tmp, sizeof(tmp), "Name: ");      	    if (*tmp) {.     	    	strcpy(news_prof.personalname, tmp);$     	    	news_prof.usemailpnam = 0;
     	    }     	}     }        return SS$_NORMAL;   } /* cmd_set_persnam */    /* **++ **  ROUTINE:	cmd_set_edit  ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET EDIT command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_edit()  ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_prof  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_edit() {   .     char tmp[STRING_SIZE], edkwd[STRING_SIZE];+     char *edtype[2] = {"CALLABLE","SPAWN"};      unsigned int status;  9     news_prof.edit = cli_present("EDIT") != CLI$_NEGATED; 0     if (cli_present("EDITOR") == CLI$_PRESENT) {8     	status = cli_get_value("EDITOR", tmp, sizeof(tmp));      	if (status == CLI$_COMMA) {7     	    cli_get_value("EDITOR", edkwd, sizeof(edkwd)); 
     	} else { #     	    strcpy(edkwd, "CALLABLE");      	}0     	if (strstr(edtype[0],edkwd) == edtype[0]) {     	    strcat(tmp, "SHR");5     	    status = file_exists(tmp, "SYS$SHARE:.EXE"); %     	    *(tmp+strlen(tmp)-3) = '\0';      	    if (!OK(status)) { <     	    	lib$signal(NEWS__EDNOTFOUND, 2, strlen(tmp), tmp);     	    } else { "     	    	news_prof.spawnedit = 0;,     	    	strcpy(news_prof.editorname, tmp);
     	    }7     	} else if (strstr(edtype[1],edkwd) == edtype[1]) { +     	    strcpy(news_prof.editorname, tmp); !     	    news_prof.spawnedit = 1; 
     	} else { O     	    lib$signal(NEWS__CMDERR, 0, NEWS__KWDSYNTAX, 2, strlen(edkwd), edkwd);      	}     }        return SS$_NORMAL;   } /* cmd_set_edit */   /* **++ **  ROUTINE:	cmd_set_seen  ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET SEEN/UNSEEN commands. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_seen()  **) **  IMPLICIT INPUTS:	curgroup, cur_artnum  ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  **% **  SIDE EFFECTS:   	curgroup->seenq.  ** **-- */ unsigned int cmd_set_seen() {        char tmp[STRING_SIZE], *cp; "     char thread_subj[STRING_SIZE];     struct RNG *r;     struct QUE *hdrqptr;     struct HDR *hdr, *xhdr; '     int unsee, rstart, rend, mark_xref;      int count, mark_thread;    /*0 **  SET SEEN/SUBJECT is handled by cmd_skipsubj. */1     if (cli_present("SUBJECT") == CLI$_PRESENT) {      	return cmd_skipsubj();      }        if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);      	return SS$_NORMAL;      }   4     unsee = (cli_present("SEEN") == CLI$_NEGATED) ||1     	    (cli_present("UNSEEN") == CLI$_PRESENT);   B     mark_xref = (cli_present("CROSS_REFERENCES") == CLI$_PRESENT);:     mark_thread = (cli_present("THREAD") == CLI$_PRESENT);     count = 0;  -     if (cli_present("ALL") == CLI$_PRESENT) {   5     	while (queue_remove(curgroup->seenq.head, &r)) {      	    mem_freerng(r);     	}     	if (!unsee) {     	    r = mem_getrng();     	    r->first = 1;%     	    r->last = curgroup->lastavl; -     	    queue_insert(r, &(curgroup->seenq));      	}     	return SS$_NORMAL;      }   /     if (cli_present("ARTRNG") == CLI$_ABSENT) { .     	if (mark_thread) return cmd_skipthread();:     	if (unsee) Mark_Article_Unseen(curgroup, cur_artnum);     	if (mark_xref) { J     	    if (OK(Get_Article_Hdrs(curgroup, cur_artnum, &hdrqptr, 1, 0))) {B     	    	for (hdr = hdrqptr->head; hdr != (struct HDR *) hdrqptr;6     	    	    	    	    	    	    	hdr = hdr->flink) {1     	    	    if (hdr->code == NEWS_K_HDR_XREF) { *     	    	    	Mark_Xref(hdr->str, unsee);     	    	    	break;      	    	    }      	    	} 
     	    }     	}     	return SS$_NORMAL;      }   ;     while (OK(cli_get_value("ARTRNG", tmp, sizeof(tmp)))) { G     	if (!OK(Parse_Range(tmp, &rstart, &rend, cur_artnum, curgroup))) { :     	    lib$signal(NEWS__INVARTRNG, 2, strlen(tmp), tmp);
     	} else {      	    int i, j;     	    if (rstart > rend) {      	    	i = rstart;      	    	rstart = rend;     	    	rend = i; 
     	    }@     	    if (rend > curgroup->lastavl) rend = curgroup->lastavl;+     	    for (i = rstart; i <= rend; i++) { $     	    	if (User_Interrupt) break;     	    	if (unsee) {8     	    	    count += Mark_Article_Unseen(curgroup, i);     	    	} else {6     	    	    count += Mark_Article_Seen(curgroup, i);     	    	} )     	    	if (mark_xref || mark_thread) {      	    	    xhdr = 0; $     	    	    thread_subj[0] = '\0';F     	    	    if (OK(Get_Article_Hdrs(curgroup, i, &hdrqptr, 1, 0))) {G     	    	    	for (hdr = hdrqptr->head; hdr != (struct HDR *) hdrqptr; :     	    	    	    	    	    	    	    hdr = hdr->flink) {C     	    	    	    if (mark_xref && hdr->code == NEWS_K_HDR_XREF) {      	    	    	    	xhdr = hdr; F     	    	    	    	if (!mark_thread || thread_subj[0] != '\0') break;     	    	    	    }H     	    	    	    if (mark_thread && hdr->code == NEWS_K_HDR_SUBJECT) {*     	    	    	    	strcpy(tmp, hdr->str);      	    	    	    	upcase(tmp);9     	    	    	    	if (tmp[0] == 'R' && tmp[1] == 'E' && )     	    	    	    	    	tmp[2] == ':') { =     	    	    	    	    for (cp = tmp+3; isspace(*cp); cp++); $     	    	    	    	} else cp = tmp;-     	    	    	    	strcpy(thread_subj, tmp); 7     	    	    	    	if (!mark_xref || xhdr != 0) break;      	    	    	    }     	    	    	}G     	    	    	if (mark_xref && xhdr != 0) Mark_Xref(xhdr->str, unsee); ;     	    	    	if (mark_thread && thread_subj[0] != '\0') { =     	    	    	    for (j = i; j <= curgroup->lastavl; j++) { 7     	    	    	    	if (!Ignore_Article(curgroup, j)) { <     	    	    	    	    if (OK(Get_Article_Hdrs(curgroup, j,1     	    	    	    	    	    	&hdrqptr, 1, 0))) { "     	    	    	    	    	xhdr = 0;      	    	    	    	    	cp = 0;2     	    	    	    	    	for (hdr = hdrqptr->head;<     	    	    	    	    	    	hdr != (struct HDR *) hdrqptr;1     	    	    	    	    	    	hdr = hdr->flink) { C     	    	    	    	    	    if (hdr->code == NEWS_K_HDR_SUBJECT) { 4     	    	    	    	    	    	strcpy(tmp, hdr->str);*     	    	    	    	    	    	upcase(tmp);2     	    	    	    	    	    	if (tmp[0] == 'R' &&3     	    	    	    	    	    	    	tmp[1] == 'E' && 3     	    	    	    	    	    	    	tmp[2] == ':') { >     	    	    	    	    	    	    for (cp = tmp; isspace(*cp);-     	    	    	    	    	    	    	    cp++); .     	    	    	    	    	    	} else cp = tmp;A     	    	    	    	    	    	if (!mark_xref || xhdr != 0) break; G     	    	    	    	    	    } else if (hdr->code == NEWS_K_HDR_XREF) { )     	    	    	    	    	    	xhdr = hdr; 1     	    	    	    	    	    	if (cp != 0) break;      	    	    	    	    	    }     	    	    	    	    	}4     	    	    	    	    	if (strstr(cp, thread_subj);     	    	    	    	    	    	|| strstr(thread_subj, cp)) { .     	    	    	    	    	    count += (unsee ?>     	    	    	    	    	    	Mark_Article_Unseen(curgroup, j)@     	    	    	    	    	    	: Mark_Article_Seen(curgroup, j));:     	    	    	    	    	    if (mark_xref && xhdr != 0) {:     	    	    	    	    	    	Mark_Xref(xhdr->str, unsee);     	    	    	    	    	    }     	    	    	    	    	}     	    	    	    	    }      	    	    	    	}      	    	    	    }     	    	    	}     	    	    }      	    	} 
     	    }     	}     }   P     lib$signal(NEWS__MARKCOUNT, 3, count, (unsee ? 2 : 0), (unsee ? "un" : ""));       return SS$_NORMAL;   } /* cmd_set_seen */   /* **++ **  ROUTINE:	cmd_set_sig ** **  FUNCTIONAL DESCRIPTION:   **                               **  	SET SIGNATURE command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_sig() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_prof  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_sig() {       char tmp[STRING_SIZE];     unsigned int status;  8     if (cli_present("SIGNATURE_FILE") == CLI$_NEGATED) {     	*news_prof.sigfile = '\0'; 7     	news_prof.autosigmail = news_prof.autosigpost = 0;      	return SS$_NORMAL;      }   0     if (cli_present("SIGFILE") == CLI$_ABSENT) {     	*tmp = '\0'; ;     	get_cmd(tmp, sizeof(tmp), "Name of signature file: "); "     	if (!*tmp) return SS$_NORMAL;$     	strcpy(news_prof.sigfile, tmp);     } else {L     	cli_get_value("SIGFILE", news_prof.sigfile, sizeof(news_prof.sigfile));     }   &     status = cli_present("AUTOMATIC");!     if (status == CLI$_NEGATED) { 7     	news_prof.autosigpost = news_prof.autosigmail = 0; (     } else if (status == CLI$_PRESENT) {     	unsigned int statm, statp; +     	statm = cli_present("AUTOMATIC.MAIL"); +     	statp = cli_present("AUTOMATIC.POST"); 7     	news_prof.autosigmail = (statm == CLI$_PRESENT) || 8     	    (statm == CLI$_ABSENT && statp == CLI$_ABSENT);7     	news_prof.autosigpost = (statp == CLI$_PRESENT) ||n8     	    (statm == CLI$_ABSENT && statp == CLI$_ABSENT);     }m       return SS$_NORMAL;   } /* cmd_set_sig */    /* **++ **  ROUTINE:	cmd_set_archive ** **  FUNCTIONAL DESCRIPTION:S ** **  	SET ARCHIVE command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_archive() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profe ** **  COMPLETION CODES:M/ **  	SS$_NORMAL: 	Normal successful completion.e ** **  SIDE EFFECTS:   	None. ** **-- */  unsigned int cmd_set_archive() {       char tmp[STRING_SIZE];     unsigned int flds;)     static struct fscndef fscn = {0,0,0};2     struct dsc$descriptor sdsc;I     unsigned int status;  ;     if (cli_present("ARCHIVE_DIRECTORY") == CLI$_NEGATED) {9     	*news_prof.archive = '\0';N     	return SS$_NORMAL;3     }   0     if (cli_present("ARCHIVE") == CLI$_ABSENT) {     	*tmp = '\0';->     	get_cmd(tmp, sizeof(tmp), "Name of archive directory: ");"     	if (!*tmp) return SS$_NORMAL;     } else {0     	cli_get_value("ARCHIVE", tmp, sizeof(tmp));     }        while (1) {V(     	INIT_SDESC(sdsc, strlen(tmp), tmp);0     	status = sys$filescan(&sdsc, &fscn, &flds);     	if (!OK(status)) {-1     	    lib$signal(NEWS__SETARCHERR, 0, status);*     	    return SS$_NORMAL;      	}     	if (flds == FSCN$M_NAME) {i     	    strcat(tmp, ":");
     	} else {f     	    break;c     	}     }>;     if (!((flds & FSCN$M_NODE) || (flds & FSCN$M_DEVICE) ||r=     	    (flds & FSCN$M_ROOT) || (flds & FSCN$M_DIRECTORY) || 8     	    (flds & FSCN$M_NAME) || (flds & FSCN$M_TYPE) ||$     	    (flds & FSCN$M_VERSION))) {/     	lib$signal(NEWS__SETARCHERR, 0, RMS$_DIR);E     	return SS$_NORMAL;S     }"  #     strcpy(news_prof.archive, tmp);"       return SS$_NORMAL;   } /* cmd_set_archive */" D /* **++ **  ROUTINE:	cmd_set_newsrcE ** **  FUNCTIONAL DESCRIPTION:L ** **  	SET NEWSRC command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_newsrcn ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profa ** **  COMPLETION CODES:n/ **  	SS$_NORMAL: 	Normal successful completion.r ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_newsrc() {   "     unsigned int substat, purstat;  0     if (cli_present("NEWSRC") == CLI$_NEGATED) {     	*news_prof.newsrc = '\0';     	return SS$_NORMAL;      }e  -     substat = cli_present("SUBSCRIBED_ONLY");n#     purstat = cli_present("PURGE");x  4     if (cli_present("NEWSRC_FILE") == CLI$_ABSENT) {'     	if (news_prof.newsrc[0] == '\0') {t9     	    strcpy(news_prof.newsrc, "SYS$LOGIN:XX.NEWSRC"); >     	    news_prof.newsrc_subonly = (substat == CLI$_PRESENT);<     	    news_prof.newsrc_purge = (purstat != CLI$_NEGATED);
     	} else {n$     	    if (substat != CLI$_ABSENT)?     	    	news_prof.newsrc_subonly = (substat == CLI$_PRESENT);T$     	    if (purstat != CLI$_ABSENT)=     	    	news_prof.newsrc_purge = (purstat == CLI$_PRESENT);:     	}     } else {N     	cli_get_value("NEWSRC_FILE", news_prof.newsrc, sizeof(news_prof.newsrc));:     	news_prof.newsrc_subonly = (substat == CLI$_PRESENT);8     	news_prof.newsrc_purge = (purstat != CLI$_NEGATED);     }        return SS$_NORMAL;   } /* cmd_set_newsrc */ r /* **++ **  ROUTINE:	cmd_set_queue ** **  FUNCTIONAL DESCRIPTION:_ ** **  	SET QUEUE command.m **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_queue() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profs ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_queue() {  S     cli_get_value("QUENAME", news_prof.print_queue, sizeof(news_prof.print_queue));        return SS$_NORMAL;   } /* cmd_set_queue */O U /* **++ **  ROUTINE:	cmd_set_forme ** **  FUNCTIONAL DESCRIPTION:( ** **  	SET FORM command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_form()  ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profe ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.c ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_form() {t       char tmp[STRING_SIZE];  .     if (cli_present("FORM") == CLI$_NEGATED) {"     	*news_prof.print_form = '\0';     	return SS$_NORMAL;_     }l  1     if (cli_present("FORMNAME") == CLI$_ABSENT) {T     	*tmp = '\0';d.     	get_cmd(tmp, sizeof(tmp), "Form name: ");"     	if (!*tmp) return SS$_NORMAL;'     	strcpy(news_prof.print_form, tmp);N     } else {S     	cli_get_value("FORMNAME", news_prof.print_form, sizeof(news_prof.print_form));c     }r       return SS$_NORMAL;   } /* cmd_set_form */   /* **++ **  ROUTINE:	cmd_set_dir ** **  FUNCTIONAL DESCRIPTION:c ** **  	SET DIRECTORY command._ **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_dir() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_proft ** **  COMPLETION CODES:z/ **  	SS$_NORMAL: 	Normal successful completion.{ ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_dir() {       char tmp[STRING_SIZE];  .     if (cli_present("FROM") == CLI$_PRESENT) {-     	cli_get_value("FROM", tmp, sizeof(tmp));X;     	lib$cvt_dtb(strlen(tmp), tmp, &news_prof.dir_fromwid);s     } else {      	news_prof.dir_fromwid = -1;     }e1     if (cli_present("SUBJECT") == CLI$_PRESENT) {l0     	cli_get_value("SUBJECT", tmp, sizeof(tmp));;     	lib$cvt_dtb(strlen(tmp), tmp, &news_prof.dir_subjwid);      } else {      	news_prof.dir_subjwid = -1;     }[       return SS$_NORMAL;   } /* cmd_set_dir */    /* **++ **  ROUTINE:	cmd_set_ignored ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET IGNORE command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_ignore()r **4 **  IMPLICIT INPUTS:	news_prof, curgroup, cur_artnum ** **  IMPLICIT OUTPUTS:	news_profw ** **  COMPLETION CODES:T/ **  	SS$_NORMAL: 	Normal successful completion.  **7 **  SIDE EFFECTS:   	curgroup->killq could be modified.F ** **-- */ unsigned int cmd_set_ignore() {s       char tmp[STRING_SIZE];     struct QUE *q;     struct HDR *h;     struct GRP *grp;     short testcode;N     int remove;*  3     remove = cli_present("IGNORE") == CLI$_NEGATED;n0     if (cli_present("GLOBAL") == CLI$_PRESENT) {     	q = &news_prof.killq;     } else {1     	if (cli_present("GRPNAM") == CLI$_PRESENT) { 3     	    cli_get_value("GRPNAM", tmp, sizeof(tmp));_     	    locase(tmp);      	    grp = Find_Group(tmp);"     	    if (grp == NULL) { ;     	    	lib$signal(NEWS__NOSUCHGRP, 2, strlen(tmp), tmp);(     	    	return SS$_NORMAL;
     	    }     	    q = &(grp->killq);o
     	} else {       	    if (curgroup == NULL) {*     	    	lib$signal(NEWS__NOCURGROUP, 0);     	    	return SS$_NORMAL;
     	    }      	    q = &(curgroup->killq);     	}     }r       *tmp = '\0';1     if (cli_present("SUBJECT") == CLI$_PRESENT) { #     	testcode = NEWS_K_HDR_SUBJECT; 0     	cli_get_value("SUBJECT", tmp, sizeof(tmp));;     } else if (cli_present("NEWSGROUPS") == CLI$_PRESENT) { &     	testcode = NEWS_K_HDR_NEWSGROUPS;3     	cli_get_value("NEWSGROUPS", tmp, sizeof(tmp));*5     } else if (cli_present("FROM") == CLI$_PRESENT) {L      	testcode = NEWS_K_HDR_FROM;-     	cli_get_value("FROM", tmp, sizeof(tmp));C;     } else if (cli_present("MESSAGE_ID") == CLI$_PRESENT) { &     	testcode = NEWS_K_HDR_MESSAGE_ID;3     	cli_get_value("MESSAGE_ID", tmp, sizeof(tmp));N     } else if (remove) {6     	while (queue_remove(q->head, &h)) mem_freehdr(h);     	return SS$_NORMAL;      } else {%     	lib$signal(NEWS__NOIGHDSPEC, 0);      	return SS$_NORMAL;I     }=     upcase(tmp);<     for (h = q->head; h != (struct HDR *) q; h = h->flink) {@     	if (h->code == testcode && strcmp(h->str, tmp) == 0) break;     }e      if (h == (struct HDR *) q) {     	if (remove) {8     	    lib$signal(NEWS__NOMATCH, 2, strlen(tmp), tmp);
     	} else { /     	    insert_header(tmp, q->tail, testcode);e     	}     } else {     	if (remove) {     	    queue_remove(h, &h);      	    mem_freehdr(h);
     	} else {i*     	    lib$signal(NEWS__ALRDYIGNORE, 0);     	}     }}       return SS$_NORMAL;   } /* cmd_set_ignore */ 	 /* **++ **  ROUTINE:	cmd_set_arn ** **  FUNCTIONAL DESCRIPTION:r ** **  	SET AUTO_READ_NEW command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_arn() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_prof  ** **  COMPLETION CODES:;/ **  	SS$_NORMAL: 	Normal successful completion.N ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_arn() {  I     news_prof.autoreadnew = cli_present("AUTO_READ_NEW") != CLI$_NEGATED;v       return SS$_NORMAL;   } /* cmd_set_arn */  * /* **++ **  ROUTINE:	cmd_set_asp ** **  FUNCTIONAL DESCRIPTION:S **# **  	SET AUTO_SAVE_PROFILE command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_asp() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profu ** **  COMPLETION CODES:t/ **  	SS$_NORMAL: 	Normal successful completion.R ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_asp() {  J     news_prof.autosave = cli_present("AUTO_SAVE_PROFILE") != CLI$_NEGATED;       return SS$_NORMAL;   } /* cmd_set_asp */  t /* **++ **  ROUTINE:	cmd_set_fmp ** **  FUNCTIONAL DESCRIPTION:b ** **  	SET EDIT command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_fmp() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profE ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.E ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_fmp() {  O     news_prof.force_proto = cli_present("FORCE_MAIL_PROTOCOL") != CLI$_NEGATED;        return SS$_NORMAL;   } /* cmd_set_fmp */(   /* **++ **  ROUTINE:	cmd_set_nga ** **  FUNCTIONAL DESCRIPTION:  ** **  	SET EDIT command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_set_nga() ** **  IMPLICIT INPUTS:	news_prof ** **  IMPLICIT OUTPUTS:	news_profe ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion._ ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_set_nga() {  <     static char *nganam[] = {"NONE", "PROMPT", "SUBSCRIBE"};F     static int  ngaction[] = {NG_K_NONE, NG_K_PROMPT, NG_K_SUBSCRIBE};     char tmp[STRING_SIZE];
     int i;  I     if (!OK(cli_get_value("NGAKW", tmp, sizeof(tmp)))) return SS$_NORMAL;   9     for (i = 0; i < sizeof(nganam)/sizeof(char *); i++) {O/     	if (strstr(nganam[i], tmp) == nganam[i]) { *     	    news_prof.ngaction = ngaction[i];     	    return SS$_NORMAL;      	}     }g  !     /* should never reach here */t       return SS$_NORMAL;   } /* cmd_set_nga */    /* **++ **  ROUTINE:	cmd_show  ** **  FUNCTIONAL DESCRIPTION:; ** **  	SHOW command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **
 **  	cmd_shown **? **  IMPLICIT INPUTS:	news_prof, news_cfg, curgroup, and others.) ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.r ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_show() {h  L     static char *shokwd[] = {"HEADERS", "PERSONAL_NAME", "EDITOR", "SERVER",;         "CURRENT_GROUP", "ALL", "SIGNATURE_FILE", "IGNORE",)I         "ARCHIVE_DIRECTORY", "GROUP", "REPLY", "NEWSRC", "QUEUE", "FORM", J     	"DIRECTORY_WIDTH", "VERSION", "AUTO_READ_NEW", "FORCE_MAIL_PROTOCOL",-     	"NEWGROUP_ACTION", "AUTO_SAVE_PROFILE"};R-     char tmp[STRING_SIZE], tmp2[STRING_SIZE];      struct dsc$descriptor tdsc;      short tlen;      int kwnum;  )     INIT_SDESC(tdsc, sizeof(tmp)-1, tmp);r     put_output(""); ;     while (OK(cli_get_value("SHOWKW", tmp, sizeof(tmp)))) {-F     	for (kwnum = 0; kwnum < sizeof(shokwd)/sizeof(char *); kwnum++) {@     	    if (strstr(shokwd[kwnum], tmp) == shokwd[kwnum]) break;     	}%     	if (kwnum == 15 || kwnum == 5) {;)     	    strcpy(tmp, "This is NEWSRDR ");	!     	    strcat(tmp, $$$Version);      	    put_output(tmp);      	}$     	if (kwnum == 0 || kwnum == 5) {<     	    if (news_prof.hdrlist.head == &news_prof.hdrlist) {E     	    	put_output("No headers selected for interactive display.");      	    } else {h     	    	char *cp;]     	    	struct HDR *h;     	    	int max, indent;  7     	    	strcpy(tmp, "Interactive display headers: ");i,     	    	cp = tmp + (indent = strlen(tmp));1     	    	max = (pb_cols < 20 ? 10 : pb_cols-20); *     	    	for (h = news_prof.hdrlist.head;F     	    	    	h != (struct HDR *) &news_prof.hdrlist; h = h->flink) {!     	    	    if (cp-tmp > max) {-     	    	    	*cp++ = ',';      	    	    	*cp = '\0';     	    	    	put_output(tmp); (     	    	    	strcpy(tmp, "         ");'     	    	    	cp = tmp + (indent = 9);H     	    	    } 0     	    	    if (cp != tmp+indent) *cp++ = ',';+     	    	    strcpy(cp, hdrname[h->code]); -     	    	    cp += strlen(hdrname[h->code]);      	    	}	!     	    	if (cp != tmp+indent) {'     	    	    *cp = '\0';	     	    	    put_output(tmp);     	    	} 
     	    }       	    put_output ("");a  >     	    if (news_prof.ehdrlist.head == &news_prof.ehdrlist) {D     	    	put_output("No headers selected for extracted articles.");     	    } else {h     	    	char *cp;      	    	struct HDR *h;     	    	int max, indent;  5     	    	strcpy(tmp, "Extracted article headers: "); ,     	    	cp = tmp + (indent = strlen(tmp));1     	    	max = (pb_cols < 20 ? 10 : pb_cols-20); +     	    	for (h = news_prof.ehdrlist.head;sG     	    	    	h != (struct HDR *) &news_prof.ehdrlist; h = h->flink) {b!     	    	    if (cp-tmp > max) {      	    	    	*cp++ = ',';      	    	    	*cp = '\0';     	    	    	put_output(tmp); (     	    	    	strcpy(tmp, "         ");'     	    	    	cp = tmp + (indent = 9);      	    	    }r0     	    	    if (cp != tmp+indent) *cp++ = ',';+     	    	    strcpy(cp, hdrname[h->code]); -     	    	    cp += strlen(hdrname[h->code]);      	    	} !     	    	if (cp != tmp+indent) {      	    	    *cp = '\0';      	    	    put_output(tmp);     	    	} 
     	    }     	}  $     	if (kwnum == 1 || kwnum == 5) {'     	    if (*news_prof.personalname) {")     	    	strcpy(tmp, "Personal name: ");s.     	    	strcat(tmp, news_prof.personalname);F     	    	if (news_prof.usemailpnam) strcat(tmp, "  (from VMS MAIL)");     	    	put_output(tmp);     	    } else {c.     	    	put_output("No personal name set.");
     	    }     	}  $     	if (kwnum == 2 || kwnum == 5) {!     	    strcpy(tmp, "Editor: ");M+     	    strcat(tmp, news_prof.editorname);N#     	    if (news_prof.spawnedit) {c&     	    	strcat(tmp, " (spawned), ");     	    } else {*'     	    	strcat(tmp, " (callable), "); 
     	    }     	    if (news_prof.edit) {B     	    	strcat(tmp, "used by default when composing messages.");     	    } else {f.     	    	strcat(tmp, "not used by default.");
     	    }     	    put_output(tmp);_     	}  %     	if (kwnum == 10 || kwnum == 5) {)0     	    strcpy(tmp, "REPLY command default: ");6     	    if (news_prof.replypost) strcat(tmp, "POST");#     	    if (news_prof.replymail) {s8     	    	if (news_prof.replypost) strcat(tmp, " and ");     	    	strcat(tmp, "MAIL");
     	    }     	    put_output(tmp); J     	    strcpy(tmp, "Prefix for messages included with REPLY/EXTRACT: ");/     	    if (news_prof.reply_prefix_len == 0) {g      	    	strcat(tmp, "(none)");     	    } else { .     	    	strcat(tmp, news_prof.reply_prefix);
     	    }     	    put_output(tmp);a     	}  $     	if (kwnum == 3 || kwnum == 5) {&     	    strcpy(tmp, "News server: ");+     	    strcat(tmp, news_cfg.server_name);t     	    put_output(tmp);w     	}  %     	if (kwnum == 11 || kwnum == 5) { !     	    if (*news_prof.newsrc) {t'     	    	strcpy(tmp, "Newsrc file: ");n(     	    	strcat(tmp, news_prof.newsrc);)     	    	if (news_prof.newsrc_subonly) { ;     	    	    strcat(tmp, " (subscribed newsgroups only)");      	    	}N     	    	put_output(tmp);=     	    	strcpy(tmp, "  Old versions of newsrc file will ");s;     	    	if (!news_prof.newsrc_purge) strcat(tmp, "NOT ");L$     	    	strcat(tmp, "be purged.");     	    	put_output(tmp);     	    } else {s,     	    	put_output("No newsrc file set.");
     	    }     	}  %     	if (kwnum == 12 || kwnum == 5) {r&     	    if (*news_prof.print_queue) {'     	    	strcpy(tmp, "Print queue: ");,-     	    	strcat(tmp, news_prof.print_queue);i     	    	put_output(tmp);     	    } else {E/     	    	put_output("Print queue: SYS$PRINT");.
     	    }     	}  %     	if (kwnum == 13 || kwnum == 5) {(%     	    if (*news_prof.print_form) {{&     	    	strcpy(tmp, "Print form: ");,     	    	strcat(tmp, news_prof.print_form);     	    	put_output(tmp);     	    } else {{2     	    	put_output("No form set for printing.");
     	    }     	}  %     	if (kwnum == 14 || kwnum == 5) {,6     	    strcpy(tmp, "Directory field widths: FROM=");*     	    if (news_prof.dir_fromwid >= 0) {5     	    	sprintf(tmp2, "%d", news_prof.dir_fromwid);_     	    	strcat(tmp, tmp2);     	    } else {i!     	    	strcat(tmp, "default");}
     	    }#     	    strcat(tmp, ", SUBJECT=");f*     	    if (news_prof.dir_subjwid >= 0) {5     	    	sprintf(tmp2, "%d", news_prof.dir_subjwid);C     	    	strcat(tmp, tmp2);     	    } else { !     	    	strcat(tmp, "default"); 
     	    }     	    put_output(tmp);s     	}  2     	if (kwnum == 4 || kwnum == 5 || kwnum == 9) {      	    if (curgroup == NULL) {.     	    	put_output("No current group set.");     	    } else {*$     	    	static $DESCRIPTOR(ctrstr,?     	    	    	    "Articles available: !UL-!UL, !UL unseen.");o.     	    	strcpy(tmp, "Current group:      ");(     	    	strcat(tmp, curgroup->grpnam);     	    	put_output(tmp);;     	    	sys$fao(&ctrstr, &tlen, &tdsc, curgroup->frstavl,O9     	    	    curgroup->lastavl, Count_Unseen(curgroup));R(     	    	put_output_counted(tmp, tlen);
     	    }     	}  $     	if (kwnum == 6 || kwnum == 5) {"     	    if (*news_prof.sigfile) {*     	    	strcpy(tmp, "Signature file: ");)     	    	strcat(tmp, news_prof.sigfile);e     	    	put_output(tmp);B     	    	if (!(news_prof.autosigmail || news_prof.autosigpost)) {:     	    	    put_output("  Not automatically appended.");     	    	} else {:     	    	    strcpy(tmp, "  Automatically appended to ");*     	    	    if (news_prof.autosigmail) {+     	    	    	if (news_prof.autosigpost) {l4     	    	    	    strcat(tmp, "mail and postings");     	    	    	} else {L,     	    	    	    strcat(tmp, "mail only");     	    	    	}2     	    	    } else strcat(tmp, "postings only");     	    	    put_output(tmp);     	    	}$     	    } else {	/     	    	put_output("No signature file set.");)
     	    }     	}  $     	if (kwnum == 8 || kwnum == 5) {"     	    if (*news_prof.archive) {-     	    	strcpy(tmp, "Archive directory: ");t)     	    	strcat(tmp, news_prof.archive);_     	    	put_output(tmp);     	    } else { 2     	    	put_output("No archive directory set.");
     	    }     	}  %     	if (kwnum == 16 || kwnum == 5) {R%     	    if (news_prof.autoreadnew) { J     	    	put_output("Automatically READ/NEW when visiting a new group.");     	    } else { E     	    	put_output("Pause for command when visiting a new group.");C
     	    }     	}  %     	if (kwnum == 17 || kwnum == 5) {N%     	    if (news_prof.force_proto) { P     	    	put_output("Forced use of mail protocol prefix, even on local mail.");     	    } else {EG     	    	put_output("Use mail protocol prefix only on network mail.");u
     	    }     	}  %     	if (kwnum == 18 || kwnum == 5) {O&     	    switch (news_prof.ngaction) {     	    case NG_K_SUBSCRIBE:RH     	    	put_output("Will automatically subscribe to new newsgroups.");     	    	break;     	    case NG_K_PROMPT:H     	    	put_output("Will prompt for subscription to new newsgroups.");     	    	break;     	    default: L     	    	put_output("Will not automatically subscribe to new newsgroups.");     	    	break;
     	    }     	}  %     	if (kwnum == 19 || kwnum == 5) { "     	    if (news_prof.autosave) {Y     	    	put_output("Will automatically save profile information on newsgroup change.");f     	    } else {ND     	    	put_output("Profile will be saved only on program exit.");
     	    }     	}  $     	if (kwnum == 7 || kwnum == 5) {     	    struct HDR *h;n1     	    int doglobal, dolocal, do_list, do_wild;O       	    if (kwnum == 5) {!     	    	doglobal = dolocal = 1;      	    	do_list = 0;     	    } else {s;     	    	doglobal = cli_present("GLOBAL") == CLI$_PRESENT;UH     	    	dolocal = !doglobal || (cli_present("LOCAL") == CLI$_PRESENT);:     	    	do_list = cli_present("GRPNAM") == CLI$_PRESENT;
     	    }     	    if (doglobal) {9     	    	if (news_prof.killq.head == &news_prof.killq) {U9     	    	    put_output("Global ignore strings: none.");:     	    	} else {3     	    	    put_output("Global ignore strings:");-,     	    	    for (h = news_prof.killq.head;9     	    	    	    	h != (struct HDR *) &news_prof.killq;R#     	    	    	    	h = h->flink) {t#     	    	    	strcpy(tmp, "    ");s-     	    	    	strcat(tmp, hdrname[h->code]); "     	    	    	strcat(tmp, "=\"");#     	    	    	strcat(tmp, h->str);S!     	    	    	strcat(tmp, "\"");c     	    	    	put_output(tmp);o     	    	    }b     	    	}e
     	    }       	    if (dolocal) {      	    	unsigned int gctx;     	    	struct GRP *g;!     	    	char gnam[STRING_SIZE];d       	    	g = 0;     	    	gctx = 0;c     	    	do_wild = 0;     	    	while (1) {      	    	    if (do_list) {     	    	    	if (gctx == 0) {nO     	    	    	    if (!OK(cli_get_value("GRPNAM", gnam, sizeof(gnam)))) break;r      	    	    	    locase(gnam);6     	    	    	    do_wild = strchr(gnam, '%') != 0 ||1     	    	    	    	      strchr(gnam, '*') != 0;RA     	    	    	    if (do_wild) g = Find_Group_Wild(gnam, &gctx);r-     	    	    	    else g = Find_Group(gnam);n7     	    	    	} else g = Find_Group_Wild(gnam, &gctx);E$     	    	    	if (g == 0) continue;     	    	    } else {(     	    	    	if (g == curgroup) break;&     	    	    	if (curgroup == NULL) {3     	    	    	    lib$signal(NEWS__NOCURGROUP, 0);I     	    	    	    break;s     	    	    	}     	    	    	g = curgroup;     	    	    }$7     	    	    strcpy(tmp, "Ignore strings for group ");f%     	    	    strcat(tmp, g->grpnam);       	    	    strcat(tmp, ": ");/     	    	    if (g->killq.head == &g->killq) {_     	    	    	if (!do_wild) {(     	    	    	    strcat(tmp, "none.");s     	    	    	    if (doglobal) put_output(""); doglobal = 1;  /* now just use it to show we should skip a line */R#     	    	    	    put_output(tmp);;     	    	    	}     	    	    } else {o     	    	    	if (doglobal) put_output(""); doglobal = 1;  /* now just use it to show we should skip a line */S     	    	    	put_output(tmp);l&     	    	    	for (h = g->killq.head;2     	    	    	    	h != (struct HDR *) &g->killq;#     	    	    	    	h = h->flink) {O'     	    	    	    strcpy(tmp, "    ");p1     	    	    	    strcat(tmp, hdrname[h->code]);)&     	    	    	    strcat(tmp, "=\"");'     	    	    	    strcat(tmp, h->str);,%     	    	    	    strcat(tmp, "\"");i#     	    	    	    put_output(tmp);T     	    	    	}     	    	    }S     	    	} 0     	    	if (gctx != 0) Traverse_Finish(&gctx);
     	    }     	}     } /* while */u       put_output("");)       return SS$_NORMAL;   } /* cmd_show */    	    {