 /* **++ **  FACILITY:	NEWSRDR  **$ **  ABSTRACT:	Miscellaneous routines ** **  MODULE DESCRIPTION:  **= **  	Various utility routines needed by various other NEWSRDR  **  modules. ** **  AUTHOR: 	    M. Madison 1 **  	    	    COPYRIGHT  1993, MADGOAT SOFTWARE. " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  05-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	05-SEP-1992 V1.0    Madison 	Initial coding. D **  	15-FEB-1993 V1.0-1  Madison 	Make compatible with pre-VMS V5.2.; **  	05-APR-1993 V1.0-2  Madison 	Got DST adjustment wrong! 7 **  	17-APR-1993 V1.1    Madison 	Add Check_Connection. 6 **  	23-APR-1993 V1.1-1  Madison 	get_logical changes.J **  	22-MAY-1993 V1.1-2  Madison 	Fix loss of keydefs after msg prompting.G **  	24-MAY-1992 V1.1-3  Madison 	Fix weekday computation in Make_Date. B **  	15-AUG-1993 V1.1-4  Madison 	Don't edit infspec if it's null.D **  	21-SEP-1993 V1.1-5  Madison 	EDT$EDIT requires input file name.9 **  	16-MAY-1994 V1.1-6  Madison 	Slight mod to locase(). 7 **  	17-MAY-1994 V1.2    Madison 	Thread_Match routine. > **  	19-JUN-1995 V1.5    Madison 	Moved Yes_Answer to PAGER.C. **-- */ #define MODULE_MISC  #include "newsrdr.h" #include "globals.h" #ifdef __GNUC__  #include <vms/jpidef.h>  #include <vms/lnmdef.h>  #include <vms/psldef.h>  #else  #include <jpidef.h>  #include <lnmdef.h>  #include <psldef.h>  #include <smg$routines.h>  #endif #include <signal.h>    /* **  Forward declarations */&     void make_temp_fspec(char *, int);1     void make_nntp_dtstring(TIME *, char *, int); =     unsigned int Compose_Message(char *, char *, int, int *);      void upcase(char *);     void locase(char *);9     void Format_Header(struct HDR *, char *, int, int *); (     void Make_Date(TIME *, char *, int);4     unsigned int cli_get_value(char *, char *, int);%     unsigned int cli_present(char *); -     unsigned int get_logical(char *, char *); 4     unsigned int get_system_logical(char *, char *);*     int streql_case_blind(char *, char *);0     int strneql_case_blind(char *, char *, int); #ifdef __GNUC__ 2     void queue_insert(struct QUE *, struct QUE *);-     int  queue_remove(struct QUE *, void **);  #endif  ;     unsigned int find_image_symbol(char *, char *, void *); D     static unsigned int x_find_image_symbol(struct dsc$descriptor *,4     	    	    	    struct dsc$descriptor *, void *);2     void insert_header(char *, struct HDR *, int);5     unsigned int table_parse(void *, void *, void *);       void Check_Connection(void);%     int Thread_Match(char *, char *);  /* **  External references  */8     extern unsigned int Set_Current_Group(struct GRP *);      EXTERN struct GRP *curgroup;   /* **++ **  ROUTINE:	make_temp_fspec ** **  FUNCTIONAL DESCRIPTION:  **= **  	Builds a file-spec for a temporary file from the current  **  PID and date/time. ** **  RETURNS:	void  ** **  PROTOTYPE: **1 **  	make_temp_fspec(char *fspec, int fspec_size)  **H **  fspec:  	file specification, write only, by reference (ASCIZ string), **  fspec_size:	integer, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */3 void make_temp_fspec(char *fspec, int fspec_size) {        struct dsc$descriptor tdsc;      TIME time;'     unsigned int pid, jpi_pid=JPI$_PID;      unsigned short len; <     $DESCRIPTOR(ctrstr, "SYS$SCRATCH:NEWS_!XL-!XL-!XL.TMP");  %     lib$getjpi(&jpi_pid, 0, 0, &pid);      sys$gettim(&time);(     INIT_SDESC(tdsc, fspec_size, fspec);?     sys$fao(&ctrstr, &len, &tdsc, pid, time.long2, time.long1);      *(fspec+len) = '\0';   } /* make_temp_fspec */    /* **++ **  ROUTINE:	make_nntp_dtstring  ** **  FUNCTIONAL DESCRIPTION:  **F **  	Makes a date/time string suitable for the NEWGROUPS NNTP command. ** **  RETURNS:	void  ** **  PROTOTYPE: **@ **  	make_nntp_dtstring(TIME *dt_stamp, char *str, int str_size) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */B void make_nntp_dtstring(TIME *dt_stamp, char *str, int str_size) {       short dtnum[7], len;     struct dsc$descriptor sdsc;      unsigned int status;5     $DESCRIPTOR(ctrstr, "!2ZW!2ZW!2ZW !2ZW!2ZW!2ZW");         sys$numtim(dtnum, dt_stamp);     dtnum[0] %= 100;$     INIT_SDESC(sdsc, str_size, str);?     sys$fao(&ctrstr, &len, &sdsc, dtnum[0], dtnum[1], dtnum[2], '     	    dtnum[3], dtnum[4], dtnum[5]);      *(str+len) = '\0';   } /* make_nntp_dtstring */   /* **++ **  ROUTINE:	Compose_Message ** **  FUNCTIONAL DESCRIPTION:  **< **  	Message composition.  Prompts user for message or fires **  up a text editor.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **B **  	Compose_Message(char *infspec, char *outspec, int use_editor,! **  	    	    	    	int *is_temp)  **> **  infspec:	file_spec, read only, by reference (ASCIZ string)? **  outspec:	file_spec, write only, by reference (ASCIZ string) , **  use_editor:	boolean, read only, by value. **  is_temp:	boolean, write only, by reference ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */J unsigned int Compose_Message(char *infspec, char *outspec, int use_editor,'     	    	    	    	    int *is_temp) {   &     struct dsc$descriptor sdsc, sdsc2;     unsigned int status;  "     if (*infspec && !use_editor) {     	strcpy(outspec, infspec);     	*is_temp = 0;     	return SS$_NORMAL;      }   )     make_temp_fspec(outspec, FSPEC_SIZE);      *is_temp = 1;    /*B ** If we're not using an editor, then just prompt the user for the ** message text. */     if (!use_editor) {     	char tmp[STRING_SIZE];       	struct dsc$descriptor tdsc;     	short len;      	unsigned int unit, kbid;      	$DESCRIPTOR(prompt, "> ");   0     	status = file_create(outspec, &unit, 0, 0);     	if (!OK(status)) { I     	    lib$signal(NEWS__CREATERR, 2, strlen(outspec), outspec, status);      	    return status;      	}     	put_output("");>     	put_output("Enter message text; type CTRL/Z when done.");     	put_output("");(     	INIT_SDESC(tdsc, sizeof(tmp), tmp);     	Finish_Paged_Output(2);(     	smg$create_virtual_keyboard(&kbid);I     	while (OK(smg$read_composed_line(&kbid, 0, &tdsc, &prompt, &len))) { $     	    file_write(unit, tmp, len);     	}     	file_close(unit);(     	smg$delete_virtual_keyboard(&kbid);     	Pager_Init(1);      	status = SS$_NORMAL;      } else {   /*+ ** We're supposed to fire up a text editor.  */6     	char edfspec[STRING_SIZE], edsymbol[STRING_SIZE];     	unsigned int (*editrtn)();        	put_output("");&     	put_output("Starting editor...");   /* ** Spawned?  */     	if (news_prof.spawnedit) { !     	    if (news_prof.captive) { :     	    	lib$signal(NEWS__SPAWNERR, 0, NEWS__CAPTIVE, 0);      	    	return NEWS__SPAWNERR;
     	    }@     	    sprintf(edsymbol, "%s \"%s\" %s", news_prof.editorname,     	    	infspec, outspec);      	    Finish_Paged_Output(2);6     	    INIT_SDESC(sdsc, strlen(edsymbol), edsymbol);#     	    status = lib$spawn(&sdsc);      	    Pager_Init(1);      	    if (!OK(status)) { 0     	    	lib$signal(NEWS__SPAWNERR, 0, status);
     	    }
     	} else {  /* ** Callable  *//     	    strcpy(edfspec, news_prof.editorname);       	    strcat(edfspec, "SHR");0     	    strcpy(edsymbol, news_prof.editorname);#     	    strcat(edsymbol, "$EDIT"); 4     	    INIT_SDESC(sdsc, strlen(edfspec), edfspec);7     	    INIT_SDESC(sdsc2, strlen(edsymbol), edsymbol); A     	    status = lib$find_image_symbol(&sdsc, &sdsc2, &editrtn);      	    if (!OK(status)) { D     	    	lib$signal(NEWS__EDITERR, 4, sdsc2.dsc$w_length, edsymbol,8     	    	    	    	sdsc.dsc$w_length, edfspec, status);     	    	return status;
     	    }      	    Finish_Paged_Output(2);4     	    INIT_SDESC(sdsc, strlen(infspec), infspec);5     	    INIT_SDESC(sdsc2, strlen(outspec), outspec); <     	    if (strncmp(news_prof.editorname, "EDT", 3) == 0) {/     	    	$DESCRIPTOR(scratch, "SYS$SCRATCH:"); $     	    	$DESCRIPTOR(nl, "_NLA0:");8     	    	status = (*editrtn)((sdsc.dsc$w_length == 0 ? L     	    	    	(struct dsc$descriptor *) &nl : &sdsc), &sdsc2, 0, &scratch);     	    } else { L     	    	status = (*editrtn)((sdsc.dsc$w_length == 0 ? 0 : &sdsc), &sdsc2);
     	    }     	    Pager_Init(1);      	}       }    /*? ** If we were successful, then look for the actual existence of  ** the output file.  */     if (OK(status)) { "     	unsigned int ffctx=0, status;     	struct dsc$descriptor str; 0     	INIT_SDESC(sdsc, strlen(outspec), outspec);     	INIT_DYNDESC(str); 1     	status = lib$find_file(&sdsc, &str, &ffctx);      	if (OK(status)) {#     	    lib$find_file_end(&ffctx); ?     	    strncpy(outspec, str.dsc$a_pointer, str.dsc$w_length); ,     	    *(outspec+str.dsc$w_length) = '\0';
     	} else {      	    *outspec = '\0';      	}     	str$free1_dx(&str);     }        Check_Connection();        return status;   } /* Compose_Message */    /* **++ **  ROUTINE:	upcase  ** **  FUNCTIONAL DESCRIPTION:  **% **  	Converts a string to upper case.  ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	upcase(char *str) **: **  str:    character string, modify, by reference (ASCIZ) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */ void upcase(char *s) {       register char *cp;  A     for (cp = s; *cp; cp++) if (islower(*cp)) *cp = toupper(*cp);    } /* upcase */   /* **++ **  ROUTINE:	locase  ** **  FUNCTIONAL DESCRIPTION:  **< **  	Converts a string to lower case, but only if it doesn't' **  already contain lower case letters.  ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	locase(char *str) **A **  str:    character string, modify, by reference (ASCIZ string)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */ void locase(char *s) {       register char *cp;  5     for (cp = s; *cp; cp++) if (islower(*cp)) return; A     for (cp = s; *cp; cp++) if (isupper(*cp)) *cp = tolower(*cp);    } /* locase */   /* **++ **  ROUTINE:	Format_Header ** **  FUNCTIONAL DESCRIPTION:  **> **  	Takes a header that is in TLV format and formats it as anF **  ordinary string (bascially converting the tag into the appropriate **  message header). ** **  RETURNS:	void  ** **  PROTOTYPE: **I **  	Format_Header(struct HDR *hdr, char *str, int str_size, int *retlen)  **2 **  hdr:    HDR structure, read only, by reference> **  str:    character string, write only, by reference (ASCIZ)* **  str_size: integer, read only, by value- **  retlen: integer, write only, by reference  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */K void Format_Header(struct HDR *hdr, char *str, int str_size, int *retlen) {        static char *hdrtxt[] = { E     	"From: ", "Date: ", "Newsgroups: ", "Subject: ", "Message-ID: ", F     	"Path: ", "Reply-To: ", "Sender: ", "Followup-To: ", "Expires: ",E     	"References: ", "Control: ", "Distribution: ", "Organization: ", C     	"Keywords: ", "Summary: ", "Approved: ", "Lines: ", "Xref: "};      int len, hlen, copylen;          len = strlen(hdr->str); (     if (hdr->code == NEWS_K_HDR_OTHER) {3     	copylen = len < str_size-1 ? len : str_size-1; $    	strncpy(str, hdr->str, copylen);     	*(str+copylen) = '\0';      } else {(     	hlen = strlen(hdrtxt[hdr->code-1]);2     	hlen = hlen < str_size-1 ? hlen : str_size-1;-     	strncpy(str, hdrtxt[hdr->code-1], hlen);      	str_size -= hlen;3     	copylen = len < str_size-1 ? len : str_size-1; *     	strncpy(str+hlen, hdr->str, copylen);      	*(str+hlen+copylen) = '\0';*     	if (retlen) *retlen = hlen + copylen;     }    } /* Format_Header */    /* **++ **  ROUTINE:	Make_Date ** **  FUNCTIONAL DESCRIPTION:  **F **  	Makes an RFC822-type date/time string from a VMS date/time stamp. ** **  RETURNS:	void  ** **  PROTOTYPE: **9 **  	Make_Date(TIME *timadr, char *fmt_date, int fd_size)  **/ **  timadr: 	date_time, read only, by reference @ **  fmt_date:	character string, write only, by reference (ASCIZ)) **  fd_size:	integer, read only, by value  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */; void Make_Date(TIME *timadr, char *fmt_date, int fd_size) {   2     enum {YEAR, MONTH, DAY, HOUR, MINUTE, SECOND};     TIME xtime, time2;      struct dsc$descriptor fddsc;     short timbuf[7], len;      unsigned int status;     int dst, dow; @     $DESCRIPTOR(ctrstr, "!AD, !2ZW !AD !ZW !2ZW:!2ZW:!2ZW GMT");2     char *dowstr = "Sun Mon Tue Wed Thu Fri Sat ";J     char *monstr = "    Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ";       if (timadr == NULL) {      	sys$gettim(&xtime);     } else {     	xtime = *timadr;      }   (     status = sys$numtim(timbuf, &xtime);     if (!OK(status)) {     	lib$signal(status);     	return;     } +     status = lib$day_of_week(&xtime, &dow);      if (!OK(status)) {     	lib$signal(status);     	return;     } 
     dow %= 7;        if (news_cfg.dst) { 
     	dst = 0;      	switch (timbuf[MONTH]) {        	case 4:#     	    if (timbuf[DAY]-dow > 0) { 2     	    	if (dow == 0) dst = (timbuf[HOUR] >= 3);     	    	else dst = 1;      	    } else dst = 0;     	    break;   
     	case 10: $     	    if (timbuf[DAY]-dow > 24) {2     	    	if (dow == 0) dst = (timbuf[HOUR] == 0);     	    	else dst = 0;      	    } else dst = 1;     	    break;        	case 5:     	case 6:     	case 7:     	case 8:     	case 9:     	    dst = 1;      	    break;   
     	default:      	    dst = 0;      	    break;      	}     }        if (news_cfg.neggmtoff) { 8     	lib$add_times(&xtime, &news_cfg.gmtoffset, &time2);     } else {8     	lib$sub_times(&xtime, &news_cfg.gmtoffset, &time2);     }        if (news_cfg.dst && dst) {)     	static $DESCRIPTOR(s, "0 01:00:00");      	static TIME onehr;      	static int did1hr = 0;      	TIME time3;  5     	if (!did1hr) {sys$bintim(&s, &onehr); did1hr=1;} +     	lib$sub_times(&time2, &onehr, &time3);      	time2 = time3;      }      sys$numtim(timbuf, &time2); "     lib$day_of_week(&time2, &dow);
     dow %= 7;   )     INIT_SDESC(fddsc, fd_size, fmt_date);      len = 0;>     status = sys$fao(&ctrstr, &len, &fddsc, 3, dowstr+(dow*4),3     	    	timbuf[DAY], 3, monstr+(timbuf[MONTH]*4), F     	    	timbuf[YEAR], timbuf[HOUR], timbuf[MINUTE], timbuf[SECOND]);(     if (!OK(status)) lib$signal(status);     *(fmt_date+len) = '\0';        return;    } /* Make_Date */    /* **++ **  ROUTINE:	cli_get_value ** **  FUNCTIONAL DESCRIPTION:  **" **  	C Interface to CLI$GET_VALUE. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **0 **  	cli_get_value (char *argname, DESCRIP *arg) **1 ** argname: ASCIZ_string, read only, by reference < ** arg:	    char_string, write only, by descriptor (dynamic) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  **2 **  	All those from CLI$PRESENT and CLI$GET_VALUE. ** **  SIDE EFFECTS:   	None. ** **-- */C unsigned int cli_get_value(char *argname, char *arg, int argsize) {   (     struct dsc$descriptor argnamd, argd;     unsigned short arglen;     int status;   2     INIT_SDESC(argnamd, strlen(argname), argname);%     INIT_SDESC(argd, argsize-1, arg); #     status = cli$present(&argnamd); &     if ($VMS_STATUS_SUCCESS(status)) {6     	status = cli$get_value(&argnamd, &argd, &arglen);*     	if (OK(status)) *(arg+arglen) = '\0';     }      return status; }    /* **++ **  ROUTINE:	cli_present ** **  FUNCTIONAL DESCRIPTION: ! **                                  **  	C Interface to CLI$PRESENT. **A **  RETURNS:	cond_value, intword (unsigned), write only, by value  ** **  PROTOTYPE: **  **  	cli_present (char *argname) **1 ** argname: ASCIZ_string, read only, by reference	 ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.E ** **  COMPLETION CODES:r **  **  	All those from CLI$PRESENT. ** **  SIDE EFFECTS:   	None. ** **-- */) unsigned int cli_present(char *argname) {   "     struct dsc$descriptor argnamd;  2     INIT_SDESC(argnamd, strlen(argname), argname);!     return cli$present(&argnamd);O }  * /* **++ **  ROUTINE:	get_logical ** **  FUNCTIONAL DESCRIPTION:3 **D **  	Translates a logical name using a standard LNM$FILE_DEV search. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **& **  	get_logical(char *lnm, char *str) **@ **  lnm:    logical_name, read only, by reference (ASCIZ string)E **  str:    character string, write only, by reference (ASCIZ string)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.' ** **  COMPLETION CODES:./ **  	SS$_NORMAL: 	Normal successful completion.i ** **  SIDE EFFECTS:   	None. ** **-- */0 unsigned int get_logical(char *lnm, char *str) {       ITMLST lnmlst[2];d!     struct dsc$descriptor lnmdsc;V     short slen;o     unsigned int status;.     static unsigned int attr=LNM$M_CASE_BLIND;/     static $DESCRIPTOR(tabnam, "LNM$FILE_DEV");i  C     ITMLST_INIT(lnmlst[0], LNM$_STRING, STRING_SIZE-1, str, &slen);h'     ITMLST_INIT(lnmlst[1], 0, 0, 0, 0);e)     INIT_SDESC(lnmdsc, strlen(lnm), lnm);eH     status = sys$trnlnm(&attr, &tabnam, &lnmdsc, 0, (str ? lnmlst : 0));'     if (OK(status)) *(str+slen) = '\0';      return status;   } /* get_logical */* h /* **++ **  ROUTINE:	get_system_logicala ** **  FUNCTIONAL DESCRIPTION:  **A **  	Translates an executive-mode logical name out of LNM$SYSTEM.d **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **- **  	get_system_logical(char *lnm, char *str)i **@ **  lnm:    logical_name, read only, by reference (ASCIZ string)> **  str:    character string, write only, by reference (ASCIZ) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.b ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.E ** **  SIDE EFFECTS:   	None. ** **-- */7 unsigned int get_system_logical(char *lnm, char *str) {g       ITMLST lnmlst[2];v!     struct dsc$descriptor lnmdsc;_     short slen;(     unsigned int status;A     static unsigned int attr=LNM$M_CASE_BLIND, acmode=PSL$C_EXEC;r-     static $DESCRIPTOR(tabnam, "LNM$SYSTEM");n  C     ITMLST_INIT(lnmlst[0], LNM$_STRING, STRING_SIZE-1, str, &slen);('     ITMLST_INIT(lnmlst[1], 0, 0, 0, 0); )     INIT_SDESC(lnmdsc, strlen(lnm), lnm); N     status = sys$trnlnm(&attr, &tabnam, &lnmdsc, &acmode, (str ? lnmlst : 0));'     if (OK(status)) *(str+slen) = '\0';e     return status;   } /* get_system_logical */ B /* **++ **  ROUTINE:	streql_case_blind ** **  FUNCTIONAL DESCRIPTION:t **= **  	Compares two ASCIZ strings for equality, in a case-blindp **  fashion. ** **  RETURNS:	boolean **                     **  PROTOTYPE: **. **  	streql_case_blind(char *str1, char *str2) **= **  str1:   character string, read only, by reference (ASCIZ)*= **  str2:   character string, read only, by reference (ASCIZ)* ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.c ** **  COMPLETION CODES: , **  	0:  	strings are not equal (case-blind)* **  	non-0:	strings are equal (case-blind) ** **  SIDE EFFECTS:   	None. ** **-- */+ int streql_case_blind(char *s1, char *s2) {"  "     register unsigned char c1, c2;       while (1) {t1         c1 = islower(*s1) ? toupper(*s1) : (*s1);;1         c2 = islower(*s2) ? toupper(*s2) : (*s2);,         if (c1 != c2) break;!         if (c1 == '\0') return 1;*         s1++; s2++;      }:  
     return 0;n }    /* **++ **  ROUTINE:	strneql_case_blinds ** **  FUNCTIONAL DESCRIPTION:t **1 **  	Counted case-blind string equality function.  ** **  RETURNS:	boolean ** **  PROTOTYPE: **8 **  	strneql_case_blind(char *str1, char *str2, int len) **; **  str1: character string, read only, by reference (ASCIZ)D; **  str2: character string, read only, by reference (ASCIZ)d& **  len:  integer, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.c ** **  COMPLETION CODES:iI **  	    0:	strings are not equal up to the specified length (case-blind) E **  	non-0:	strings are equal up to the specified length (case-blind)s ** **  SIDE EFFECTS:   	None. ** **-- */5 int strneql_case_blind(char *s1, char *s2, int len) {m  "     register unsigned char c1, c2;       while (len > 0) {_1         c1 = islower(*s1) ? toupper(*s1) : (*s1);e1         c2 = islower(*s2) ? toupper(*s2) : (*s2);          if (c1 != c2) return 0;e!         if (c1 == '\0') return 1;x         s1++; s2++;E     	len--;a     }n  
     return 1;  }t n /* **++ **  ROUTINE:	queue_insert  ** **  FUNCTIONAL DESCRIPTION:c **< **  	Inserts an entry into a queue.  The QUE structure isn'tA **  required, as long as the first two longwords of the structuren! **  being used is a queue header.n **H **  USED ONLY WITH GNU C.  VAX C and DEC C use the appropriate builtins.5 **  	    	    	   See NEWSRDR.H for more information.* ** **  RETURNS:	void. ** **  PROTOTYPE: ** **  	queue_insert(item, pred)C ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.d ** **  COMPLETION CODES:	None.c ** **  SIDE EFFECTS:   	None. ** **-- */ #ifdef __GNUC__i7 void queue_insert(struct QUE *item, struct QUE *pred) {        item->head = pred->head;     item->tail = pred;     (pred->head)->tail = item;     pred->head = item; }  #endif _ /* **++ **  ROUTINE:	queue_removee ** **  FUNCTIONAL DESCRIPTION:_ **4 **  	Removes an entry from a queue, if there is one. **H **  USED ONLY WITH GNU C.  VAX C and DEC C use the appropriate builtins.5 **  	    	    	   See NEWSRDR.H for more information.s ** **  RETURNS:	int ** **  PROTOTYPE: **2 **  	queue_remove(struct QUE *entry, void **addr); ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:_ **  	1: Remove successful. **  	0: No entry to remove.  ** **  SIDE EFFECTS:   	None. ** **-- */ #ifdef __GNUC__(2 int queue_remove(struct QUE *entry, void **addr) {  '     if (entry->head == entry) return 0;e&     (entry->tail)->head = entry->head;&     (entry->head)->tail = entry->tail;     *addr = entry;
     return 1;p }d #endif , /* **++ **  ROUTINE:	find_image_symbol ** **  FUNCTIONAL DESCRIPTION:} *** **  	C interface to LIB$FIND_IMAGE_SYMBOL. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **? **  	find_image_symbol(char *image, char *symbol, void *symval)I **= **  image:  file_spec, read only, by reference (ASCIZ string) = **  symbol: character string, read only, by reference (ASCIZ) 1 **  symval: unspecified, write only, by referencet ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.W ** **  COMPLETION CODES:V/ **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */I unsigned int find_image_symbol(char *image, char *symbol, void *symval) {_  %     struct dsc$descriptor idsc, sdsc;l  "     lib$establish(lib$sig_to_ret);+     INIT_SDESC(idsc, strlen(image), image);(-     INIT_SDESC(sdsc, strlen(symbol), symbol);i5     return x_find_image_symbol(&idsc, &sdsc, symval);}   } /* find_image_symbol *//  F static unsigned int x_find_image_symbol(struct dsc$descriptor *imgnam,=     	    	    	struct dsc$descriptor *symnam, void *symval) {   9     return lib$find_image_symbol(imgnam, symnam, symval);    }n f /* **++ **  ROUTINE:	insert_header ** **  FUNCTIONAL DESCRIPTION:) **> **  	Makes a HDR structure from a character string and inserts **  it in a queue. ** **  RETURNS:	void	 ** **  PROTOTYPE: **9 **  	insert_header(char *str, struct HDR *pred, int code)c **= **  str:    character string, read only, by reference (ASCIZ) / **  pred:   HDR structure, modify, by referenceI( **  code:   integer, read only, by value ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.i ** **  COMPLETION CODES:	None." ** **  SIDE EFFECTS:   	None. ** **-- */; void insert_header(char *str, struct HDR *pred, int code) {        struct HDR *h;     int len;       len = strlen(str)+1;     h = mem_gethdr(len);     memcpy(h->str, str, len);      h->code = code;}     queue_insert(h, pred);   } /* insert_header */e h /* **++ **  ROUTINE:	table_parse ** **  FUNCTIONAL DESCRIPTION:  **@ **  	Glue to LIB$TABLE_PARSE/LIB$TPARSE, automatically using the **  former if present. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **5 **  	table_parse(void *tpablk, void *tbl, void *key);, ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.( ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */> unsigned int table_parse(void *tpablk, void *tbl, void *key) {  /     static unsigned int (*parse_routine)() = 0;0     unsigned int status;       if (parse_routine == 0) { M     	status = find_image_symbol("LIBRTL", "LIB$TABLE_PARSE", &parse_routine);      	if (!OK(status)) { L     	    status = find_image_symbol("LIBRTL", "LIB$TPARSE", &parse_routine);     	}$     	if (!OK(status)) return status;     }:  .     return (*parse_routine)(tpablk, tbl, key);   } /* table_parse */h c /* **++ **  ROUTINE:	Check_Connection  ** **  FUNCTIONAL DESCRIPTION:* **A **  	Verifies that the server connection is still there.  If not,*9 **  attempts to reconnect and restore our server context.) ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	Check_Connection()c ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.T ** **  COMPLETION CODES:	None.D ** **  SIDE EFFECTS:   	None. ** **-- */ void Check_Connection() {e       unsigned int status;     int reply_code;*       status = server_check();     if (OK(status)) return;r       server_disconnect();)     server_connect(news_cfg.server_name);t8     server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);.     if (curgroup) Set_Current_Group(curgroup);     return;E   } /* Check_Connection */ / /* **++ **  ROUTINE:	Thread_Matcht ** **  FUNCTIONAL DESCRIPTION:* ** **  	tbs ** **  RETURNS:	int ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.+ ** **  COMPLETION CODES:r ** ** **  SIDE EFFECTS:   	None. ** **-- */& int Thread_Match(char *m1, char *m2) {       register char *anchor, *cp;b     char tmp[STRING_SIZE];       anchor = m2;     while (*anchor != '\0') { 8     	while (*anchor != '<' && *anchor != '\0') anchor++;     	if (anchor == '\0') break;s;     	for (cp = anchor; *cp != '\0' && !isspace(*cp); cp++);n     	if (*cp == '\0') {:/     	    if (strstr(m1, anchor) != 0) return 1;S     	    anchor = cp;e
     	} else { )     	    strncpy(tmp, anchor, cp-anchor);b     	    tmp[cp-anchor] = '\0';P,     	    if (strstr(m1, tmp) != 0) return 1;     	    anchor = cp + 1;o     	}     }I  
     return 0;n   } /* Thread_Match */