 /* **++ **  FACILITY:	NEWSRDR  **" **  ABSTRACT:	NEWSRDR main module. ** **  MODULE DESCRIPTION:  ** **  	Main routine for NEWSRDR. ** **  AUTHOR: 	    M. Madison K **  	    	    COPYRIGHT  1993, 1994 MADGOAT SOFTWARE. ALL RIGHTS RESERVED.  ** **  CREATION DATE:  01-SEP-1992  ** **  MODIFICATION HISTORY:  **I **  	01-SEP-1992 X4.0    Madison 	Initial coding (conversion from BLISS). 3 **  	17-SEP-1992 V4.0    Madison 	Make it official. = **  	22-SEP-1992 V4.0-1  Madison 	Fix Display_Announce logic. I **  	22-SEP-1992 V4.0-2  Madison 	Workaround for strange $FAO happenings. 4 **  	22-SEP-1992 V4.0-3  Madison 	Fix STORE problem.G **  	28-SEP-1992 V4.0-4  Madison 	Fix EXTRACT problem, profile problem. > **  	29-SEP-1992 V4.0-5  Madison 	Fix mail long-lines problem.6 **  	30-SEP-1992 V4.0-6  Madison 	Fix yesterday's fix.I **  	07-OCT-1992 V4.0-7  Madison 	Fix REPLY/TO problem, SET SEEN problem. G **  	08-OCT-1992 V4.0-8  Madison 	SHOW VERSION, Parse_List_Reply stuff. 9 **  	13-OCT-1992 V4.0-9  Madison 	Fix Set_Initial_Groups. H **  	16-OCT-1992 V4.0-10 Madison 	Fix line count in sig file processing.F **  	21-OCT-1992 V4.0-11 Madison 	Fix looping problem in READ/SUBJECT.I **  	07-DEC-1992 V4.0-12 Madison 	Move exit handler decl to after update. Q **  	23-DEC-1992 V4.0-13 Madison 	Posting errors were not being handled properly. M **  	10-FEB-1993 V4.0-14 Madison 	Fix PAGER routines to work from batch jobs. < **  	15-FEB-1993 V4.0-15 Madison 	Remove all !AZ references.? **  	15-FEB-1993 V4.1    Madison 	Add SET SEEN/CROSS, /SUBJECT. I **  	17-FEB-1993 V4.1-1  Madison 	Fix up LIB$STOPs in SERVER_xxx modules. ? **  	24-FEB-1993 V4.1-2  Madison 	Fix DIRECTORY output problem. A **  	01-MAR-1993 V4.1-3  Madison 	Expand name_conversion support. 8 **  	17-MAR-1993 V4.1-4  Madison 	Fix REPLY/FOLLOWUP_TO.6 **  	23-MAR-1993 V4.1-5  Madison 	Fix FORWARD problem.H **  	05-APR-1993 V4.1-6  Madison 	Fix DST adjustment in date generation.C **  	08-APR-1993 V4.1-7  Madison 	Cmd locasing fix; REPLY/DIST fix. H **  	12-APR-1993 A4.2    Madison 	Add remaining lines to paged displays.C **  	16-APR-1993 B4.2    Madison 	Add support for faking NEWGROUPS. 5 **  	17-APR-1993 C4.2    Madison 	Add auto-reconnect. ? **  	23-APR-1993 D4.2    Madison 	Add DISALLOW_POSTING logical. E **  	14-MAY-1993 V4.2-1  Madison 	Fix wildcard group name processing. ? **  	17-MAY-1993 V4.2-2  Madison 	Fix directory paged displays. 6 **  	19-MAY-1993 V4.2-3  Madison 	Fix Parse_Range bug.D **  	22-MAY-1993 V4.2-4  Madison 	Work around MAIL$ bug in VMS T6.0.L **  	23-MAY-1993 V4.2-5  Madison 	Allow SET SEEN/THREAD with article ranges.G **  	24-MAY-1993 V4.2-6  Madison 	Fix weekday computation in Make_Date. = **  	25-MAY-1993 V4.2-7  Madison 	Fix partial update problem. C **  	31-MAY-1993 V4.2-8  Madison 	Fix looping bug in cont_readsubj. K **  	03-JUN-1993 V4.2-9  Madison 	Got time check backwards in server check. 8 **  	22-JUN-1993 A4.3    Madison 	SET AUTO_SAVE_PROFILE.G **  	08-JUL-1993 B4.3    Madison 	Let user specify names of keep files. N **  	22-SEP-1993 V4.3    Madison 	New POST, REPLY qualifiers. XHDR. Bug fixes.3 **  	24-SEP-1993 V4.4    Madison 	More use of XHDR. J **  	26-SEP-1993 V4.4-1  Madison 	Fix ACCVIO in condition handling on AXP.@ **  	28-SEP-1993 V4.4-2  Madison 	Fix header allocation problem.M **  	29-SEP-1993 V4.4-3  Madison 	Found another bug lurking in the XHDR code. 4 **  	29-SEP-1993 V4.4-4  Madison 	Fix POST/KEYWORDS.D **  	30-SEP-1993 V4.4-5  Madison 	Fix for cmd_dir, another XHDR fix.? **  	02-OCT-1993 V4.4-6  Madison 	Found another bug in ARTICLE. C **  	05-OCT-1993 V4.4-7  Madison 	Fix bug in FORWARD To: prompting. 9 **  	09-OCT-1993 V4.5    Madison 	All sorts of new stuff. : **  	14-OCT-1993 V4.5-1  Madison 	INN MODE READER support.@ **  	21-OCT-1993 V4.5-2  Madison 	Fix for slow DIRECTORY/UNSEEN.F **  	22-OCT-1993 V4.5-3  Madison 	Fix null-subject problem in cmd_dir.3 **  	26-OCT-1993 V4.5-4  Madison 	Another XHDR fix. 9 **  	26-OCT-1993 V4.5-5  Madison 	Pager, CMD_TABLE fixes. I **  	28-OCT-1993 V4.5-6  Madison 	Fix SET SEEN/SUBJECT, directory widths. ? **  	10-NOV-1993 V4.5-7  Madison 	ACCVIO server_check fix, etc. 1 **  	23-NOV-1993 V4.5-8  Madison 	Fix up globals. ? **  	01-DEC-1993 V4.5-9  Madison 	CAPTIVE flag fix for AXP/VMS. J **  	05-DEC-1993 V4.5-10 Madison 	Have EXTRACT check validity of articles.5 **  	15-JAN-1994 V4.5-11 Madison 	More EXTRACT fixes. 8 **  	16-MAR-1994 V4.6    Madison 	SET IGNORE/MESSAGE_ID.B **  	28-MAR-1994 V4.6-1  Madison 	Check Copy_File status on saves.> **  	13-APR-1994 V4.7    Madison 	Start of some XOVER support.7 **  	28-APR-1994 V4.7-1  Madison 	Rework hole checking. G **  	29-APR-1994 V4.7-2  Madison 	Fixed XOVER support broken in V4.7-1. D **  	16-MAY-1994 X4.8    Madison 	Add mixed-case group name support,? **  	    	    	    	    	    support for settable reply-prefix. F **  	22-MAY-1994 Y4.8    Madison 	Profile/newsrc writing improvements.A **  	23-MAY-1994 Y4.8-1  Madison 	Add /NEWGROUP_ACTION qualifier. < **  	25-MAY-1994 V4.8    Madison 	Removed SET_HANDLER stuff.N **  	16-JUN-1994 V4.8-1  Madison 	Fixed skipped-articles-after-update problem.G **  	06-JUL-1994 V4.8-2  Madison 	XOVER, NEWSRC, profile-writing fixes. : **  	21-SEP-1994 V4.8-3  Madison 	autosave fix, glist fix.F **  	08-DEC-1994 V4.8-4  Madison 	Fixed References: header formatting.4 **  	09-JAN-1995 V4.8-5  Madison 	Fixed XHDR ACCVIO.J **  	20-JUN-1995 V4.8-6  Madison 	Keypad fix, increased default hdr cache. **-- */ #define NR_VERSION	"V4.8-6" \ #define NR_COPYRIGHT	"Copyright  1993, 1994, 1995  MadGoat Software.  All Rights Reserved."  
 #ifdef __DECC ! #pragma module NEWSRDR NR_VERSION  #else  #ifndef __GNUC__ #module NEWSRDR NR_VERSION #endif #endif   #include "newsrdr.h" #ifdef __GNUC__  #include <vms/jpidef.h #include <vms/prvdef.h>  #include <vms/lnmdef.h>  #else  #include <jpidef.h>  #include <prvdef.h>  #include <lnmdef.h>  #endif #include <signal.h>   
 #ifdef __DECC  #pragma extern_model save ' #pragma extern_model common_block noshr  #endif+     char $$$Copyright[]     = NR_COPYRIGHT; 
 #ifdef __DECC  #pragma extern_model restore #endif)     GLOBAL char *$$$Version = NR_VERSION;    /* ** Forward declarations  */     unsigned int main();*     static unsigned int Read_Config(void);'     static unsigned int exit_handler(); '     static void Display_Announce(void); )     static void Set_Initial_Groups(void);   S     GLOBAL unsigned int (*default_action)(); /* Fired when user just hits RETURN */ S     GLOBAL unsigned int (*cleanup_action)(); /* Cleanup for non-default action   */ P     GLOBAL struct PROF news_prof;   	     /* The user profile                 */P     GLOBAL struct CFG  news_cfg;    	     /* Configuration information        */S     GLOBAL unsigned int image_privs[2];      /* Our image privilege mask         */ S     GLOBAL int pager_set_up = 0;             /* PAGER module initialization flag */   S     static unsigned int final_status;        /* Final status for exit handler    */ S     static struct {                          /* Exit handler block               */      	unsigned int flink;     	unsigned int (*exh)();      	unsigned int argcnt;      	unsigned int *statusp; 3     } exhblk = {0, exit_handler, 1, &final_status};    /* **  External references  */S     EXTERN int User_Interrupt;               /* User pressed CTRL/C              */    #ifdef __GNUC__ * #define RMS$_EOF ((unsigned int) rms$_eof)#     extern unsigned int rms$_eof();  #else  #pragma nostandard&     globalvalue unsigned int RMS$_EOF; #pragma standard #endif  +     extern unsigned int cli$dispatch(void); 3     extern unsigned int newsrdr_cld(), cmd_table(); +     extern unsigned int cli_error_filter(); #     extern void Read_Profile(void); Q     extern unsigned int Set_Initial_Group(struct GRP *, struct dsc$descriptor *); *     extern struct GRP *Find_Group(char *);?     extern struct GRP *Find_Group_Wild(char *, unsigned int *); 0     extern void Traverse_Finish(unsigned int *);%     extern void cmd_initialize(void); '     extern unsigned int cmd_exit(void); )     extern unsigned int cmd_update(void); .     extern unsigned int cmd_readnextnew(void);,     extern unsigned int Do_Full_Update(int);1     extern void Make_Return_Address(char *, int); &     extern void Clear_ArtInProg(void);"     extern void Article_ExH(void);$     extern void Write_Profile(void);!     extern void print_clup(void); &     extern void Check_New_Groups(int);   /* **++ **  ROUTINE:	main  ** **  FUNCTIONAL DESCRIPTION:  **D **  	Main program.  Initializes things.  Parses the NEWSRDR command,K **  Contacts the NNTP server.  Identifies new groups and does a new article ( **  check.  Goes into main command loop. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **	 **  	main  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	normal successful completion.  ** **  SIDE EFFECTS:   	Many. ** **-- */ unsigned int main() {   H     unsigned int jpi_imagpriv=JPI$_IMAGPRIV, jpi_procpriv=JPI$_PROCPRIV;     unsigned int procprivs[2];)     $DESCRIPTOR(newsrdr_cmd, "NEWSRDR ");      struct dsc$descriptor str;1     unsigned int status, reply_code, update_type;      int finish_up, ng_action;      char tmp[STRING_SIZE];   /*C ** Turn off all image privileges, except NETMBX.  We shouldn't need B ** any privileges to do anything, unless the foreign mail protocol' ** we send messages through needs them.  */1     lib$getjpi(&jpi_imagpriv, 0, 0, image_privs); /     lib$getjpi(&jpi_procpriv, 0, 0, procprivs); $     image_privs[0] &= ~procprivs[0];$     image_privs[1] &= ~procprivs[1];$     image_privs[0] &= ~PRV$M_NETMBX;%     sys$setprv(0, image_privs, 0, 0);    /*F ** Our all-purpose condition handler is below.  It filters any signalsC ** coming from CLI$ routines.  Other errors it prints out using our  ** output routines.  */$     lib$establish(cli_error_filter);   /* ** Parse the command.  */     INIT_DYNDESC(str);     lib$get_foreign(&str);#     str$prefix(&str, &newsrdr_cmd); P     status = cli$dcl_parse(&str, newsrdr_cld, lib$get_foreign, lib$get_foreign);7     if (!OK(status)) lib$stop(NEWS__CMDERR, 0, status);    /*J ** Determine the update type.  FULL means use NNTP LIST (default); PARTIALG ** means use NNTP GROUP commands for each subscribed group.  BOTH means E ** do full followed by partial update (the GROUP command returns more . ** accurate information about each newsgroup). */       update_type = 2;#     status = cli_present("UPDATE"); !     if (status == CLI$_PRESENT) { 8     	status = cli_get_value("UPDATE", tmp, sizeof(tmp));     	if (OK(status)) {4     	    static char *both={"BOTH"}, *full={"FULL"};     	    upcase(tmp); 8     	    if (strstr(both, tmp) == both) update_type = 3;=     	    else if (strstr(full, tmp) != full) update_type = 1;      	}7     } else if (status == CLI$_NEGATED) update_type = 0;    /*8 **  Check to see if newgroup_action is to be overridden. */     ng_action = -1; 9     if (cli_present("NEWGROUP_ACTION") == CLI$_PRESENT) { 8     	cli_get_value("NEWGROUP_ACTION", tmp, sizeof(tmp));3     	if (tmp[0] == 'S') ng_action = NG_K_SUBSCRIBE; 5     	else if (tmp[0] == 'P') ng_action = NG_K_PROMPT;       	else ng_action = NG_K_NONE;     }    /* ** Initialize stuff  */     Read_Config();  !     pager_set_up = Pager_Init(0);        Display_Announce();        Read_Profile();  /*/ ** Connect to server, and check for new groups.  */A     lib$signal(NEWS__CONNECTING, 2, strlen(news_cfg.server_name), $     	    	    news_cfg.server_name);)     server_connect(news_cfg.server_name);    /*I **  If posting isn't disallowed by logical name NEWSRDR_DISALLOW_POSTING, , **  check to see if it's OK with the server. */6     server_get_reply(SRV__ECHO, &reply_code, 0, 0, 0);K     if (reply_code != NNTP__HELOPOSTOK && reply_code != NNTP__HELONOPOST) {      	server_disconnect(); ?     	lib$stop(NEWS__NOSERVICE, 2, strlen(news_cfg.server_name),      	    news_cfg.server_name);      }   ?     if (news_cfg.postingok && reply_code == NNTP__HELONOPOST) {      	news_cfg.postingok = 0;     }    /*K **  INN's server uses a MODE READER command to determine whether or not the - **  client is a reader or a peer news system.  */5     if (OK(get_logical("NEWSRDR_INN_SERVER", tmp))) { (     	if (strchr("TtYy1", tmp[0]) != 0) {$     	    server_send("MODE READER");=     	    server_get_reply(SRV__NOECHO, &reply_code, 0, 0, 0);      	}     }   8     if (news_prof.profread) Check_New_Groups(ng_action);   /*F ** Command processing initialization - inits the default_action stuff. */     cmd_initialize();    /* ** Our let's-go-home flag  */     finish_up = 0;   /*F ** Do the newsgroup update.  For first-time users (no profile exists),D ** do a full update and set up the initial groups.  For other users,D ** the update is controlled by what they put on the NEWSRDR command. */3     if (news_prof.profread && (update_type != 0)) { #     	lib$signal(NEWS__UPDATING, 0);      	switch (update_type) { %     	    case 1: cmd_update(); break; *     	    case 2: Do_Full_Update(0); break;8     	    case 3: Do_Full_Update(1); cmd_update(); break;     	}%     } else if (!news_prof.profread) {      	Do_Full_Update(1);      	Set_Initial_Groups();#     	lib$signal(NEWS__UPDATING, 0);      	cmd_update();     }  /*A ** Set up exit handler (below) to write our profile back out when  ** we're through.  */     sys$dclexh(&exhblk);   /* ** Main command loop.  */     while (!finish_up) {     	char *cp;       	put_output("");     	User_Interrupt = 0;6     	status = get_cmd(tmp+6, sizeof(tmp)-6, "News> "); /*C ** The only non-OK status we expect here is RMS$_EOF -- i.e., EXIT.  */     	if (!OK(status)) { K     	    if (cleanup_action != (unsigned int (*)()) 0) (*cleanup_action)();      	    cmd_exit();     	    break;      	}   /* ** Trim blanks from the command  */F     	for (cp = tmp+strlen(tmp); cp > tmp+6 && isspace(*(cp-1)); cp--);     	*cp = '\0';1     	for (cp = tmp+6; *cp && isspace(*cp); cp++);    /*H ** If it's a null command, perform the default_action routine.  If there+ ** is no default action, use READ/NEXT/NEW.  **F ** Otherwise, if it's all digits then assume it's an article number toE ** be read; if it's just a group name, then assume they want to go to  ** that group. */     	if (*cp == '\0') { 8     	    if (default_action == (unsigned int (*)()) 0) {9     	    	finish_up = cmd_readnextnew() == NEWS__ALLDONE;      	    } else { ;     	    	finish_up = (*default_action)() == NEWS__ALLDONE; 
     	    }
     	} else { &     	    struct dsc$descriptor tmpdsc;'     	    $DESCRIPTOR(Prompt, "News> "); 6     	    if (strspn(cp, "0123456789") == strlen(cp)) {     	    	cp -= 5;!     	    	memcpy(cp, "READ ", 5); .     	    } else if (strchr(cp, ' ') == NULL) {     	    	locase(cp); $     	    	if (Find_Group(cp) == 0) {     	    	    unsigned int ctx;      	    	    struct GRP *g;  A     	    	    if (strchr(cp, '*') != 0 || strchr(cp, '%') != 0) {      	    	    	ctx = 0; =     	    	    	while ((g = Find_Group_Wild(cp, &ctx)) != 0) { '     	    	    	    if (g->subscribed) { *     	    	    	    	Traverse_Finish(&ctx);     	    	    	    	break;     	    	    	    }     	    	    	}     	    	    	if (g != 0) {)     	    	    	    strcpy(tmp, "GROUP "); *     	    	    	    strcat(tmp, g->grpnam);     	    	    	    cp = tmp;     	    	    	}     	    	    }        	    	} else {     	    	    cp -= 6;&     	    	    memcpy(cp, "GROUP ", 6);     	    	} 
     	    }   /*G ** Parse the command and perform the specified action.  If the parse is C ** successful or we need to exit due to an end-of-file, perform the ! ** cleanup action first (if any).  */,     	    INIT_SDESC(tmpdsc, strlen(cp), cp);K     	    status = cli$dcl_parse(&tmpdsc, cmd_table, get_cmd_dx, get_cmd_dx,      	    	&Prompt); "     	    if (status == RMS$_EOF) {L     	    	if (cleanup_action != (unsigned int (*)()) 0) (*cleanup_action)();     	    	cmd_exit();      	    	break;     	    } else { ?     	    	if (!OK(status)) lib$signal(NEWS__CMDERR, 0, status);      	    	else {;     	    	    if (cleanup_action != (unsigned int (*)()) 0)S#     	    	    	(*cleanup_action)();m:     	    	    finish_up = cli$dispatch() == NEWS__ALLDONE;     	    	} 
     	    }     	}     }i   /*  ** Say good-night to the server. */       server_send("QUIT");6     server_get_reply(SRV__ECHO, &reply_code, 0, 0, 0);     server_disconnect();       return SS$_NORMAL;  
 }  /* main */a o /* **++ **  ROUTINE:	Read_Config ** **  FUNCTIONAL DESCRIPTION:e **< **  	Sets up the news_cfg structure, which consists of items@ **  of information that aren't directly settable by the user (at! **  least, not within NEWSRDR).  - **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	Read_Config() ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.* ** **  COMPLETION CODES:s/ **  	SS$_NORMAL: 	normal successful completion.  **& **  SIDE EFFECTS:   	Changes news_cfg. ** **-- */# static unsigned int Read_Config() {I       ITMLST jpilst[3];f     char tmp[STRING_SIZE];#     unsigned int prcprv[2], status;*     unsigned short tlen;     int ok;e  -     memset(&news_cfg, 0, sizeof(struct CFG));VA     news_cfg.bangpath = news_cfg.newgroups = news_cfg.dopath = 1;9  K     news_cfg.postingok = !OK(get_logical("NEWSRDR_DISALLOW_POSTING", tmp));V  C     ITMLST_INIT(jpilst[0], JPI$_USERNAME, sizeof(tmp), tmp, &tlen);1E     ITMLST_INIT(jpilst[1], JPI$_PROCPRIV, sizeof(prcprv), prcprv, 0); '     ITMLST_INIT(jpilst[2], 0, 0, 0, 0);e3     status = sys$getjpiw(0, 0, 0, jpilst, 0, 0, 0);n#     if (!OK(status)) return status; :     while (isspace(tmp[tlen-1])) tlen--; tmp[tlen] = '\0';#     strcpy(news_cfg.username, tmp);M  H     status = get_system_logical("NEWSRDR_SERVER", news_cfg.server_name);N     if (!OK(status) || (prcprv[0]&PRV$M_SETPRV) || (prcprv[0]&PRV$M_SYSNAM)) {B     	status = get_logical("NEWSRDR_SERVER", news_cfg.server_name);     }P#     if (!OK(status)) return status;t  I     status = get_system_logical("NEWSRDR_NODE_NAME", news_cfg.node_name);      if (!OK(status)) {K     	status = get_hostname(news_cfg.node_name, sizeof(news_cfg.node_name));P     }B#     if (!OK(status)) return status;g  J     if (!OK(get_system_logical("NEWSRDR_MAIL_NODE", news_cfg.mailnode))) {3     	strcpy(news_cfg.mailnode, news_cfg.node_name);l     }   ;     get_logical("NEWSRDR_ORGANIZATION", news_cfg.org_name);g>     get_logical("NEWSRDR_MAIL_PROTOCOL", news_cfg.mail_proto);9     get_logical("NEWSRDR_PATH_STRING", news_cfg.pathstr);.       ok = 1;9G     if (OK(get_system_logical("NEWSRDR_DISABLE_USER_REPLY_TO", tmp))) {V*     	ok = strchr("TtYy1", tmp[0]) == NULL;     }rH     if (ok) ok = OK(get_logical("NEWSRDR_REPLY_TO", news_cfg.reply_to));O     if (!ok) Make_Return_Address(news_cfg.reply_to, sizeof(news_cfg.reply_to));A  4     if (OK(get_logical("NEWSRDR_BANG_PATH", tmp))) {9     	news_cfg.bangpath = strchr("TtYy1", tmp[0]) != NULL;r     }e7     if (OK(get_logical("NEWSRDR_BANG_ADDRESS", tmp))) {S9     	news_cfg.bangaddr = strchr("TtYy1", tmp[0]) != NULL;e     }m8     if (OK(get_logical("NEWSRDR_DO_MESSAGE-ID", tmp))) {9     	news_cfg.genmsgid = strchr("TtYy1", tmp[0]) != NULL;V     }M2     if (OK(get_logical("NEWSRDR_DO_DATE", tmp))) {8     	news_cfg.gendate = strchr("TtYy1", tmp[0]) != NULL;     }97     if (OK(get_logical("NEWSRDR_DO_NEWGROUPS", tmp))) {2:     	news_cfg.newgroups = strchr("TtYy1", tmp[0]) != NULL;     }oP     if (!news_cfg.newgroups && OK(get_logical("NEWSRDR_FAKE_NEWGROUPS", tmp))) {B     	news_cfg.newgroups = strchr("TtYy1", tmp[0]) == NULL ? 0 : 2;     }d  2     if (OK(get_logical("NEWSRDR_DO_PATH", tmp))) {7     	news_cfg.dopath = strchr("TtYy1", tmp[0]) != NULL;      }-  2     if (OK(get_logical("NEWSRDR_NO_XHDR", tmp))) {@     	news_cfg.xhdr = (strchr("TtYy1", tmp[0]) != NULL) ? -1 : 0;     }.  3     if (OK(get_logical("NEWSRDR_NO_XOVER", tmp))) {CA     	news_cfg.xover = (strchr("TtYy1", tmp[0]) != NULL) ? -1 : 0;2     }9  <     if (OK(get_logical("NEWSRDR_HEADER_CACHE_SIZE", tmp))) {C     	if (!OK(lib$cvt_dtb(strlen(tmp), tmp, &news_cfg.cachesize))) {	"     	    news_cfg.cachesize = 512;     	}$     } else news_cfg.cachesize = 512;  5     if (OK(get_logical("NEWSRDR_GMT_OFFSET", tmp))) {n     	char *cp;"     	struct dsc$descriptor tmpdsc;     	if (!isdigit(tmp[0])) {,     	    news_cfg.neggmtoff = tmp[0] == '-';     	    cp = &tmp[1];     	} else cp = tmp;9(     	INIT_SDESC(tmpdsc, strlen(cp), cp);.     	sys$bintim(&tmpdsc, &news_cfg.gmtoffset);     } else {$     	$DESCRIPTOR(est, "0 05:00:00");+     	sys$bintim(&est, &news_cfg.gmtoffset);.     	news_cfg.neggmtoff = 1;     	news_cfg.dst = 1;     }V  6     if (OK(get_logical("NEWSRDR_US_DST_ZONE", tmp))) {4     	news_cfg.dst = strchr("TtYy1", tmp[0]) != NULL;     }1  ?     if (OK(get_logical("NEWSRDR_CHARACTER_CONVERSION", tmp))) { ?     	status = find_image_symbol("NEWSRDR_CHARACTER_CONVERSION", 5     	    	    "LOCAL_TO_NETWORK", &news_cfg.chrlton);p     	if (OK(status)) {C     	    status = find_image_symbol("NEWSRDR_CHARACTER_CONVERSION",95     	    	    "NETWORK_TO_LOCAL", &news_cfg.chrntol);-     	}"     	news_cfg.chrcnv = OK(status);     }t  A     if (OK(get_system_logical("NEWSRDR_NAME_CONVERSION", tmp))) {p       	unsigned int (*init)();  :     	status = find_image_symbol("NEWSRDR_NAME_CONVERSION",     	    	    "INIT", &init);e     	if (OK(status)) {>     	    status = find_image_symbol("NEWSRDR_NAME_CONVERSION",+     	    	    "CONVERT", &news_cfg.namcvt);r     	}     	if (OK(status)) {<     	    (void) find_image_symbol("NEWSRDR_NAME_CONVERSION",0     	    	    "FULL_CONVERT", &news_cfg.fnmcvt);     	}     	if (OK(status)) {>     	    status = find_image_symbol("NEWSRDR_NAME_CONVERSION",,     	    	    "CLEANUP", &news_cfg.namclup);     	}8     	if (OK(status)) status = (*init)(&news_cfg.namctx);"     	news_cfg.namcnv = OK(status);     }f  D     if (OK(get_system_logical("NEWSRDR_ADDRESS_CONVERSION", tmp))) {       	unsigned int (*init)();  =     	status = find_image_symbol("NEWSRDR_ADDRESS_CONVERSION",n     	    	    "INIT", &init);d     	if (OK(status)) {A     	    status = find_image_symbol("NEWSRDR_ADDRESS_CONVERSION",o+     	    	    "CONVERT", &news_cfg.adrcvt);V     	}     	if (OK(status)) {A     	    status = find_image_symbol("NEWSRDR_ADDRESS_CONVERSION",d,     	    	    "CLEANUP", &news_cfg.adrclup);     	}7     	if (OK(status)) status = (init)(&news_cfg.adrctx);v"     	news_cfg.adrcnv = OK(status);     }L       return SS$_NORMAL;   } /* Read_Config */u   /* **++ **  ROUTINE:	exit_handlerg ** **  FUNCTIONAL DESCRIPTION:l **@ **  	Exit handler for NEWSRDR.  Calls cleanup routines to deleteF **  temporary files and such, and writes out the NEWSRDR_PROFILE file. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **- **  	exit_handler(unsigned int *final_status)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.i ** **  COMPLETION CODES:t ** ** **  SIDE EFFECTS:   	None. ** **-- */> static unsigned int exit_handler(unsigned int *final_status) {       Clear_ArtInProg();     Article_ExH();     Write_Profile();     print_clup();g?     if (news_cfg.namcnv) (*news_cfg.namclup)(&news_cfg.namctx); ?     if (news_cfg.adrcnv) (*news_cfg.adrclup)(&news_cfg.namctx);        return SS$_NORMAL;   } /* exit_handler */ e /* **++ **  ROUTINE:	Display_Announced ** **  FUNCTIONAL DESCRIPTION:f **? **  	Displays the announcement message, if one has been set up.s ** **  RETURNS:	void  ** **  PROTOTYPE: ** **  	Display_Announce()n ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.e ** **  SIDE EFFECTS:   	None. ** **-- */  static void Display_Announce() {       unsigned int status, unit;4     char annfile[FSPEC_SIZE], tmp[STRING_SIZE], *cp;
     int tlen;*  <     status = get_logical("NEWSRDR_SUPPRESS_COPYRIGHT", tmp);     if (!OK(status)) {     	strcpy(tmp, "NEWSRDR ");,     	strcat(tmp, $$$Version);v     	put_output(tmp);i     	put_output($$$Copyright);     }a6     status = get_logical("NEWSRDR_ANNOUNCE", annfile);0     if (!OK(status) || *annfile == '\0') return;       put_output("");e     if (*annfile == '@') {.     	for (cp = annfile+1; isspace(*cp); cp++);,     	status = file_open(cp, &unit, 0, 0, 0);     	if (!OK(status)) return;;=     	while (OK(file_read(unit, tmp, sizeof(tmp)-1, &tlen))) {f     	    tmp[tlen] = '\0';     	    put_output(tmp);e     	}     	file_close(unit);     } else {     	put_output(annfile);      }N   } /* Display_Announce */   /* **++ **  ROUTINE:	Set_Initial_GroupsE ** **  FUNCTIONAL DESCRIPTION:N **; **  	Subscribes a new user to an initial set of newsgroups.hB **  The logical name NEWSRDR_INITIAL_GROUPS is translated from theD **  process, job, group, and system logical name tables; the user isK **  subscribed to all newsgroups resulting from each of those translations.* ** **  RETURNS:	void* ** **  PROTOTYPE: ** **  	Set_Initial_Groups()  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.P **, **  SIDE EFFECTS:   	Changes the group tree. ** **-- */" static void Set_Initial_Groups() {       ITMLST lnmlst[3];u     char lnmbuf[256]; '     struct dsc$descriptor tabnam, sdsc;t2     $DESCRIPTOR(lognam, "NEWSRDR_INITIAL_GROUPS");N     static char *table[] = {"LNM$PROCESS","LNM$JOB","LNM$GROUP","LNM$SYSTEM"};     int i, maxidx;     short len;     unsigned int status;  #     ITMLST_INIT(lnmlst[2],0,0,0,0); 8     for (i = 0; i < sizeof(table)/sizeof(char *); i++) {D     	ITMLST_INIT(lnmlst[0],LNM$_MAX_INDEX,sizeof(maxidx),&maxidx,0);$     	ITMLST_INIT(lnmlst[1],0,0,0,0);2     	INIT_SDESC(tabnam,strlen(table[i]),table[i]);9     	status = sys$trnlnm(0, &tabnam, &lognam, 0, lnmlst);)     	if (OK(status)) {     	    int j;n(     	    for (j = 0; j <= maxidx; j++) {;     	    	ITMLST_INIT(lnmlst[0],LNM$_INDEX,sizeof(j),&j,0); J     	    	ITMLST_INIT(lnmlst[1],LNM$_STRING,sizeof(lnmbuf)-1,lnmbuf,&len);>     	    	status = sys$trnlnm(0, &tabnam, &lognam, 0, lnmlst);     	    	if (OK(status)) {x#     	    	    *(lnmbuf+len) = '\0';c     	    	    locase(lnmbuf); ,     	    	    INIT_SDESC(sdsc, len, lnmbuf);D     	    	    lib$traverse_tree(&news_prof.gtree, Set_Initial_Group,     	    	    	    &sdsc);     	    	}d
     	    }     	}     }u } /* Set_Initial_Groups */