 /* **++ **  FACILITY:	NEWSRDR  **5 **  ABSTRACT:	Routines dealing with NEWSRDR profiles.  ** **  MODULE DESCRIPTION:  **: **  	This module contains the routines that read and write **  NEWSRDR profiles.  ** **  AUTHOR: 	    M. Madison 1 **  	    	    COPYRIGHT  1993, MADGOAT SOFTWARE. " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  09-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	09-SEP-1992 V1.0    Madison 	Initial coding. 7 **  	11-SEP-1992 V1.1    Madison 	Added NEWSRC support. J **  	28-SEP-1992 V1.1-1  Madison 	Header settings weren't stored properly.G **  	29-SEP-1992 V1.1-2  Madison 	Default headers weren't set properly. G **  	12-APR-1993 V1.2    Madison 	Added autoreadnew, usemailpnam flags. > **  	16-APR-1993 V1.2-1  Madison 	Support for faked NEWGROUPS.H **  	23-APR-1993 V1.2-2  Madison 	Add support for force_proto, ngaction.A **  	25-MAY-1993 V1.2-3  Madison 	Make sure directpost flag is 1. > **  	22-JUN-1993 V1.3    Madison 	Don't free stuff on updates.> **  	24-SEP-1993 V1.4    Madison 	mem_getgrp now inits queues.= **  	09-OCT-1993 V1.5    Madison 	Added extract_hdrs support. I **  	01-DEC-1993 V1.5-1  Madison 	Fix captive flag check for OpenVMS AXP. 8 **  	16-MAY-1994 V1.6    Madison 	reply-prefix suppport.? **  	22-MAY-1994 V1.7    Madison 	"Safer" profile writing code. M **  	17-JUN-1994 V1.7-1  Madison 	Defaults were applied when hdrs turned off.  **-- */ #include "newsrdr.h" #include "globals.h" #ifdef __GNUC__  #include <vms/rms.h> #include <vms/syidef.h>  #include <vms/uaidef.h>  #include <vms/maildef.h> #include <vms/prvdef.h>  #else  #include <rms.h> #include <syidef.h>  #include <uaidef.h>  #include <maildef.h> #include <prvdef.h>  #endif   #ifndef UAI$M_RESTRICTED& #define UAI$M_RESTRICTED UAI$M_CAPTIVE #endif  $     unsigned int Read_Profile(void);%     unsigned int Write_Profile(void); C     static unsigned int write_grp_info(struct GRP *, struct RAB *);   "     extern void Read_NewsRC(void);#     extern void Write_NewsRC(void);    /*D ** Basically, profile information is kept in a private tagged-recordJ ** format, so it's easy to add more profile items in a backward-compatibleD ** way.  The tags are binary (and so is the information, in a lot of/ ** cases), so users keep their noses out of it.  */    #define PFILE__LASTGRPCHK    201 #define PFILE__GROUP	     315   #define PFILE__GROUP_NOSUB   316  #define PFILE__RANGELIST     739  #define PFILE__KILLLIST	     822 #define PFILE__HEADER	     421  #define PFILE__NEWHEADER     351  #define PFILE__PERSONALNAME  167  #define PFILE__EDITORNAME    293  #define PFILE__SIGFILENAME   386 #define PFILE__FLAGS	     550   #define PFILE__GLOBALKILL    679 #define PFILE__ARCHIVE	     484  #define PFILE__NEWSRC	     796 #define PFILE__QUEUE	     809   #define PFILE__FORM           46  #define PFILE__DIRWIDTH       98  #define PFILE__NGACTION	     145  #define PFILE__EXTRACT_HDRS  504  #define PFILE__REPLY_PREFIX  642       struct PFREC {     	int code;     	union {     	    TIME lgc;     	    struct {      	    	short textlen;     	    	short hdrcode;     	    	char text[256];      	    } txt;      	    struct {      	    	int rcount;      	    	int range[1];      	    } rng;      	    struct {      	    	int fromwid;     	    	int subjwid;     	    } wid;      	    unsigned int flags;	     	} u;      };  7 #define PFREC_S_FRONT	    (sizeof(int)+sizeof(short)*2)    #define PFREC_M_EDIT	    1 #define PFREC_M_AUTOSIG	    2  #define PFREC_M_SPAWNEDIT   4  #define PFREC_M_NEWFLAGS    8  #define PFREC_M_AUTOSIGP    16 #define PFREC_M_AUTOSIGM    32 #define PFREC_M_REPLYP	    64  #define PFREC_M_REPLYM	    128 #define PFREC_M_NOAUTORN    256  #define PFREC_M_USEMAILPN   512   #define PFREC_M_FORCEPROTO  1024  #define PFREC_M_AUTOSAVE    2048  #define PFREC_M_RCNOPURGE   4096  + #define MAXRCT ((sizeof(struct PFREC)-8)/8) + #define MAXHCT ((sizeof(struct PFREC)-8)/4)   D     static int default_header[] = {NEWS_K_HDR_FROM, NEWS_K_HDR_DATE,8     	    	    NEWS_K_HDR_NEWSGROUPS, NEWS_K_HDR_SUBJECT,=     	    	    NEWS_K_HDR_MESSAGE_ID, NEWS_K_HDR_DISTRIBUTION, 9     	    	    NEWS_K_HDR_ORGANIZATION, NEWS_K_HDR_LINES}; !     static char *hdrname[] = {"", ;     	"FROM", "DATE", "NEWSGROUPS", "SUBJECT", "MESSAGE-ID", <     	"PATH", "REPLY-TO", "SENDER", "FOLLOWUP-TO", "EXPIRES",=     	"REFERENCES", "CONTROL", "DISTRIBUTION", "ORGANIZATION", 9     	"KEYWORDS", "SUMMARY", "APPROVED", "LINES", "XREF"};   +     extern void Insert_Group(struct GRP *); Q     extern unsigned int mail$user_begin(), mail$user_get_info(), mail$user_end();    /* **++ **  ROUTINE:	Read_Profile  ** **  FUNCTIONAL DESCRIPTION:  **; **  	Reads in a profile, filling in the appropriate bits of C **  the in-memory profile structure (news_prof) and the group tree.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	Read_Profile()  ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int Read_Profile() {   8     ITMLST uailst[2], mailst[2], mailst3[5], mailnul[1];     struct FAB fab;      struct RAB rab;      struct PFREC pfr;      struct GRP *g;     struct RNG *rng;     struct HDR *h, *h2;      unsigned int uaflags;      char tmp[STRING_SIZE];     struct dsc$descriptor sdsc;      short tlen; 9     int vms_v52, i, Saw_Hdrs_Line, Saw_Extract_Hdrs_Line; !     unsigned int mailctx, status;        vms_v52 = 0;-     memset(&news_prof, 0, sizeof(news_prof)); $     news_prof.reply_prefix_len = -1;   /*C ** For some reason the captive flag is part of news_prof instead of * ** news_cfg.  That should probably change. */ #ifdef __ALPHA     vms_v52 = 1; #else B     ITMLST_INIT(uailst[0], SYI$_VERSION, sizeof(tmp), tmp, &tlen);'     ITMLST_INIT(uailst[1], 0, 0, 0, 0); 3     status = sys$getsyiw(0, 0, 0, uailst, 0, 0, 0); !     if (OK(status) && tlen > 4) { @     	vms_v52 = tmp[1] > '5' || (tmp[1] == '5' && tmp[3] >= '2');     }  #endifE     ITMLST_INIT(uailst[0], UAI$_FLAGS, sizeof(uaflags), &uaflags, 0); '     ITMLST_INIT(uailst[1], 0, 0, 0, 0); C     INIT_SDESC(sdsc, strlen(news_cfg.username), news_cfg.username); 6     status = sys$getuai(0, 0, &sdsc, uailst, 0, 0, 0); #ifdef __ALPHA2     news_prof.captive = (uaflags & UAI$M_CAPTIVE); #else A     news_prof.captive = (uaflags & UAI$M_RESTRICTED) && !vms_v52;  #endif   /*A ** Initialize news_prof the way we want it to be, even if there's  ** no profile. */I     news_prof.hdrlist.head = news_prof.hdrlist.tail = &news_prof.hdrlist; L     news_prof.ehdrlist.head = news_prof.ehdrlist.tail = &news_prof.ehdrlist;C     news_prof.killq.head = news_prof.killq.tail = &news_prof.killq; &     sys$gettim(&news_prof.lastgrpchk);/     strcpy(news_prof.print_queue, "SYS$PRINT"); 7     news_prof.dir_fromwid = news_prof.dir_subjwid = -1;      news_prof.usemailpnam = 1;#     news_prof.ngaction = NG_K_NONE;   .     Saw_Hdrs_Line = Saw_Extract_Hdrs_Line = 0;   /** ** Open it up and read in the information. */     fab = cc$rms_fab;      fab.fab$b_fac = FAB$M_GET;&     fab.fab$l_fna = "NEWSRDR_PROFILE";     fab.fab$b_fns = 15; &     fab.fab$l_dna = "SYS$LOGIN:.NRPF";     fab.fab$b_dns = 15; "     status = sys$open(&fab, 0, 0);     if (!OK(status)) {;     	lib$signal(NEWS__NOOPNPROF, 0, status, fab.fab$l_stv);      } else {     	rab = cc$rms_rab;     	rab.rab$l_fab = &fab;#     	rab.rab$l_ubf = (char *) &pfr; !     	rab.rab$w_usz = sizeof(pfr);      	sys$connect(&rab,0,0);  /*C ** g is used to keep track of the group we're currently working on, D ** since groups use more than one profile record -- the one with the* ** name, the seen list, and the kill list. */     	g = NULL;$     	while (OK(sys$get(&rab,0,0))) {     	    switch (pfr.code) {        	    case PFILE__LASTGRPCHK:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} +     	    	news_prof.lastgrpchk = pfr.u.lgc;      	    	break;       	    case PFILE__FLAGS:      	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 6     	    	news_prof.edit = pfr.u.flags & PFREC_M_EDIT;@     	    	news_prof.spawnedit = pfr.u.flags & PFREC_M_SPAWNEDIT;/     	    	if (pfr.u.flags & PFREC_M_NEWFLAGS) { E     	    	    news_prof.autosigpost = pfr.u.flags & PFREC_M_AUTOSIGP; E     	    	    news_prof.autosigmail = pfr.u.flags & PFREC_M_AUTOSIGM; C     	    	    news_prof.replypost   = pfr.u.flags & PFREC_M_REPLYP; C     	    	    news_prof.replymail   = pfr.u.flags & PFREC_M_REPLYM;      	    	} else {=     	    	    news_prof.autosigpost = news_prof.autosigmail = 1     	    	    	    pfr.u.flags & PFREC_M_AUTOSIG;      	    	} D     	    	news_prof.autoreadnew = !(pfr.u.flags & PFREC_M_NOAUTORN);B     	    	news_prof.usemailpnam = pfr.u.flags & PFREC_M_USEMAILPN;C     	    	news_prof.force_proto = pfr.u.flags & PFREC_M_FORCEPROTO; >     	    	news_prof.autosave = pfr.u.flags & PFREC_M_AUTOSAVE;F     	    	news_prof.newsrc_purge = !(pfr.u.flags & PFREC_M_RCNOPURGE);     	    	break;       	    case PFILE__NGACTION:)     	    	if (g != NULL) Insert_Group(g); +     	    	news_prof.ngaction = pfr.u.flags;      	    	break;       	    case PFILE__GROUP: !     	    case PFILE__GROUP_NOSUB: )     	    	if (g != NULL) Insert_Group(g);      	    	g = mem_getgrp(); 5     	    	g->subscribed = (pfr.code == PFILE__GROUP); +     	    	g->inprofile = g->directpost = 1; @     	    	strncpy(g->grpnam, pfr.u.txt.text, pfr.u.txt.textlen);0     	    	*(g->grpnam+pfr.u.txt.textlen) = '\0';     	    	break;       	    case PFILE__RANGELIST:      	    	if (g != NULL) {6     	    	    for (i = 0; i < pfr.u.rng.rcount; i++) {"     	    	    	rng = mem_getrng();1     	    	    	rng->first = pfr.u.rng.range[i*2]; 3     	    	    	rng->last  = pfr.u.rng.range[i*2+1]; 0     	    	    	queue_insert(rng, g->seenq.tail);     	    	    }      	    	}      	    	break;       	    case PFILE__KILLLIST:     	    	if (g != NULL) {2     	    	    h = mem_gethdr(pfr.u.txt.textlen+1);*     	    	    h->code = pfr.u.txt.hdrcode;A     	    	    strncpy(h->str, pfr.u.txt.text, pfr.u.txt.textlen); 1     	    	    *(h->str+pfr.u.txt.textlen) = '\0'; -     	    	    queue_insert(h, g->killq.tail);      	    	}      	    	break;        	    case PFILE__GLOBALKILL:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} .     	    	h = mem_gethdr(pfr.u.txt.textlen+1);&     	    	h->code = pfr.u.txt.hdrcode;=     	    	strncpy(h->str, pfr.u.txt.text, pfr.u.txt.textlen); .     	    	 *(h->str+pfr.u.txt.textlen) = '\0';0     	    	queue_insert(h, news_prof.killq.tail);     	    	break;   /*G ** Very old versions of NEWSRDR stored the headers in plain-text format D ** that had to be parsed each time.  This remains for compatibility. */       	    case PFILE__HEADER:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	}      	    	Saw_Hdrs_Line = 1;     	    	h = mem_gethdr(0);@     	    	for (i = 1; i < sizeof(hdrname)/sizeof(char *); i++) {<     	    	    if (strlen(hdrname[i]) == pfr.u.txt.textlen &&6     	    	    	    strncmp(hdrname[i], pfr.u.txt.text,.     	    	    	    	    	pfr.u.txt.textlen)) {     	    	    	h->code = i;	     	    	    	break;      	    	    }      	    	} +     	    	for (h2 = news_prof.hdrlist.head; 7     	    	    	h2 != (struct HDR *) &news_prof.hdrlist; !     	    	    	 h2 = h2->flink) { ,     	    	    if (h2->code > h->code) break;     	    	} 8     	    	if (h2 == (struct HDR *) &news_prof.hdrlist) {6     	    	    queue_insert(h, news_prof.hdrlist.tail);     	    	} else {)     	    	    queue_insert(h, h2->blink);      	    	}      	    	break;   /*O ** Later versions of NEWSRDR use this binary format for storing the SET HEADERS  ** information.  */     	    case PFILE__NEWHEADER:      	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	}      	    	Saw_Hdrs_Line = 1;2     	    	for (i = 0; i < pfr.u.rng.rcount; i++) {8     	    	    if (pfr.u.rng.range[i] >= NEWS_K_HDR_LO &&9     	    	    	    pfr.u.rng.range[i] <= NEWS_K_HDR_HI) { !     	    	    	h = mem_gethdr(0); ,     	    	    	h->code = pfr.u.rng.range[i];0     	    	    	for (h2 = news_prof.hdrlist.head;<     	    	    	    	h2 != (struct HDR *) &news_prof.hdrlist;%     	    	    	    	h2 = h2->flink) { 1     	    	    	    if (h2->code > h->code) break;      	    	    	}=     	    	    	if (h2 == (struct HDR *) &news_prof.hdrlist) { ;     	    	    	    queue_insert(h, news_prof.hdrlist.tail);      	    	    	} else { .     	    	    	    queue_insert(h, h2->blink);     	    	    	}     	    	    }      	    	}      	    	break;  "     	    case PFILE__EXTRACT_HDRS:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} $     	    	Saw_Extract_Hdrs_Line = 1;2     	    	for (i = 0; i < pfr.u.rng.rcount; i++) {8     	    	    if (pfr.u.rng.range[i] >= NEWS_K_HDR_LO &&9     	    	    	    pfr.u.rng.range[i] <= NEWS_K_HDR_HI) { !     	    	    	h = mem_gethdr(0); ,     	    	    	h->code = pfr.u.rng.range[i];1     	    	    	for (h2 = news_prof.ehdrlist.head; =     	    	    	    	h2 != (struct HDR *) &news_prof.ehdrlist; %     	    	    	    	h2 = h2->flink) { 1     	    	    	    if (h2->code > h->code) break;      	    	    	}>     	    	    	if (h2 == (struct HDR *) &news_prof.ehdrlist) {<     	    	    	    queue_insert(h, news_prof.ehdrlist.tail);     	    	    	} else { .     	    	    	    queue_insert(h, h2->blink);     	    	    	}     	    	    }      	    	}      	    	break;  "     	    case PFILE__PERSONALNAME:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 9     	    	strncpy(news_prof.personalname, pfr.u.txt.text, &     	    	    	    pfr.u.txt.textlen);=     	    	*(news_prof.personalname+pfr.u.txt.textlen) = '\0';      	    	break;        	    case PFILE__EDITORNAME:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 7     	    	strncpy(news_prof.editorname, pfr.u.txt.text, &     	    	    	    pfr.u.txt.textlen);;     	    	*(news_prof.editorname+pfr.u.txt.textlen) = '\0';      	    	break;  !     	    case PFILE__SIGFILENAME:      	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 4     	    	strncpy(news_prof.sigfile, pfr.u.txt.text,&     	    	    	    pfr.u.txt.textlen);8     	    	*(news_prof.sigfile+pfr.u.txt.textlen) = '\0';     	    	break;       	    case PFILE__ARCHIVE:      	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 4     	    	strncpy(news_prof.archive, pfr.u.txt.text,&     	    	    	    pfr.u.txt.textlen);8     	    	*(news_prof.archive+pfr.u.txt.textlen) = '\0';     	    	break;       	    case PFILE__NEWSRC:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 7     	    	news_prof.newsrc_subonly = pfr.u.txt.hdrcode; 3     	    	strncpy(news_prof.newsrc, pfr.u.txt.text, &     	    	    	    pfr.u.txt.textlen);7     	    	*(news_prof.newsrc+pfr.u.txt.textlen) = '\0';      	    	break;       	    case PFILE__QUEUE:      	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 8     	    	strncpy(news_prof.print_queue, pfr.u.txt.text,&     	    	    	    pfr.u.txt.textlen);<     	    	*(news_prof.print_queue+pfr.u.txt.textlen) = '\0';     	    	break;       	    case PFILE__FORM:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 7     	    	strncpy(news_prof.print_form, pfr.u.txt.text, &     	    	    	    pfr.u.txt.textlen);;     	    	*(news_prof.print_form+pfr.u.txt.textlen) = '\0';      	    	break;       	    case PFILE__DIRWIDTH:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 4     	    	news_prof.dir_fromwid = pfr.u.wid.fromwid;4     	    	news_prof.dir_subjwid = pfr.u.wid.subjwid;     	    	break;  "     	    case PFILE__REPLY_PREFIX:     	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;      	    	} 9     	    	news_prof.reply_prefix_len = pfr.u.txt.textlen;DL     	    	if (news_prof.reply_prefix_len > sizeof(news_prof.reply_prefix)-1)L     	    	    news_prof.reply_prefix_len = sizeof(news_prof.reply_prefix)-1;9     	    	strncpy(news_prof.reply_prefix, pfr.u.txt.text,0/     	    	    	    news_prof.reply_prefix_len); F     	    	*(news_prof.reply_prefix+news_prof.reply_prefix_len) = '\0';     	    	break;       	    default:      	    	if (g != NULL) {     	    	    Insert_Group(g);     	    	    g = NULL;r     	    	}-
     	    }     	}       	sys$close(&fab,0,0);a     	if (g != NULL) {-     	    Insert_Group(g);u     	    g = NULL;     	}       	news_prof.profread = 1;       }p   /*C ** If the user has set a newsrc file, read that in now, letting the > ** information in it supersede the information in the profile. */)     if (*news_prof.newsrc) Read_NewsRC();    /*) ** Now fetch our mail-related informationC */     mailctx = 0;4     ITMLST_INIT(mailst[0], MAIL$_NOSIGNAL, 0, 0, 0);'     ITMLST_INIT(mailst[1], 0, 0, 0, 0);e(     ITMLST_INIT(mailnul[0], 0, 0, 0, 0);8     status = mail$user_begin(&mailctx, mailst, mailnul);     if (OK(status)) {t     	unsigned short pnlen;4     	ITMLST_INIT(mailst3[0],MAIL$_USER_COPY_FORWARD,:     	    	    sizeof(news_prof.csfwd),&news_prof.csfwd,0);2     	ITMLST_INIT(mailst3[1],MAIL$_USER_COPY_REPLY,>     	    	    sizeof(news_prof.csreply),&news_prof.csreply,0);1     	ITMLST_INIT(mailst3[2],MAIL$_USER_COPY_SEND,m<     	    	    sizeof(news_prof.csmail),&news_prof.csmail,0);!     	if (news_prof.usemailpnam) {d9     	    ITMLST_INIT(mailst3[3],MAIL$_USER_PERSONAL_NAME,I7     	    	    (sizeof(news_prof.personalname)-1 < 255 ?;7     	    	     sizeof(news_prof.personalname)-1 : 255),g1     	    	    &news_prof.personalname[0],&pnlen); 
     	} else {v,     	    ITMLST_INIT(mailst[3], 0, 0, 0, 0);     	})     	ITMLST_INIT(mailst3[4], 0, 0, 0, 0);t<     	status = mail$user_get_info(&mailctx, mailst, mailst3);/     	if (OK(status) && news_prof.usemailpnam) {b.     	    news_prof.personalname[pnlen] = '\0';     	}7     	status = mail$user_end(&mailctx, mailst, mailnul);t     }   M     if (!news_prof.replymail || news_prof.replypost) news_prof.replypost = 1; D     if (!*news_prof.editorname) strcpy(news_prof.editorname, "TPU");I     if (!Saw_Hdrs_Line && news_prof.hdrlist.head == &news_prof.hdrlist) {E?     	for (i = 0; i < sizeof(default_header)/sizeof(int); i++) {I     	    h = mem_gethdr(0);_%     	    h->code = default_header[i];S1     	    queue_insert(h, news_prof.hdrlist.tail);n     	}     }ES     if (!Saw_Extract_Hdrs_Line && news_prof.ehdrlist.head == &news_prof.ehdrlist) {F7     	for (i = NEWS_K_HDR_LO; i <= NEWS_K_HDR_HI; i++) {      	    h = mem_gethdr(0);1     	    h->code = i;A2     	    queue_insert(h, news_prof.ehdrlist.tail);     	}     }{  )     if (news_prof.reply_prefix_len < 0) { $     	news_prof.reply_prefix_len = 1;)     	strcpy(news_prof.reply_prefix, ">");      }h       return SS$_NORMAL;   } /* Read_Profile */   /* **++ **  ROUTINE:	Write_Profile ** **  FUNCTIONAL DESCRIPTION:  **+ **  	Writes out the user's NEWSRDR profile.	 **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	Write_Profile() ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.E ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int Write_Profile() {       struct FAB fab;      struct NAM nam;M     struct RAB rab;E     struct PFREC pfr;d     struct HDR *hdr;&     unsigned int status, pp[2], pstat;      char espec[255], rspec[255];8     static unsigned int exquota[2] = {PRV$M_EXQUOTA, 0};1     static $DESCRIPTOR(fname, "NEWSRDR_PROFILE");(1     static $DESCRIPTOR(dname, "SYS$LOGIN:.NRPF");e  *     pstat = sys$setprv(1, exquota, 0, pp);       fab = cc$rms_fab;G     fab.fab$b_fac = FAB$M_PUT;(     fab.fab$l_fna = fname.dsc$a_pointer;'     fab.fab$b_fns = fname.dsc$w_length;R(     fab.fab$l_dna = dname.dsc$a_pointer;'     fab.fab$b_dns = dname.dsc$w_length;,       nam = cc$rms_nam;U     nam.nam$l_esa = espec;"     nam.nam$b_ess = sizeof(espec);     nam.nam$l_rsa = rspec;"     nam.nam$b_rss = sizeof(rspec);"     fab.fab$l_nam = (void *) &nam;  "     status = sys$create(&fab,0,0);     if (!OK(status)) {;     	lib$signal(NEWS__NOOPNPROF, 0, status, fab.fab$l_stv);uM     	if (OK(pstat) && !(pp[0] & PRV$M_EXQUOTA)) sys$setprv(0, exquota, 0, 0);:     	return NEWS__NOOPNPROF;     }S     rab = cc$rms_rab;a     rab.rab$l_fab = &fab; "     rab.rab$l_rbf = (char *) &pfr;"     rab.rab$l_ubf = (char *) &pfr;      rab.rab$w_usz = sizeof(pfr);     sys$connect(&rab,0,0);       pfr.code = PFILE__FLAGS;#     pfr.u.flags = PFREC_M_NEWFLAGS;r4     if (news_prof.edit) pfr.u.flags |= PFREC_M_EDIT;>     if (news_prof.spawnedit) pfr.u.flags |= PFREC_M_SPAWNEDIT;?     if (news_prof.autosigmail) pfr.u.flags |= PFREC_M_AUTOSIGM;.?     if (news_prof.autosigpost) pfr.u.flags |= PFREC_M_AUTOSIGP;sW     if (news_prof.autosigmail || news_prof.autosigpost) pfr.u.flags |= PFREC_M_AUTOSIG; ;     if (news_prof.replymail) pfr.u.flags |= PFREC_M_REPLYM; ;     if (news_prof.replypost) pfr.u.flags |= PFREC_M_REPLYP;r@     if (!news_prof.autoreadnew) pfr.u.flags |= PFREC_M_NOAUTORN;@     if (news_prof.usemailpnam) pfr.u.flags |= PFREC_M_USEMAILPN;A     if (news_prof.force_proto) pfr.u.flags |= PFREC_M_FORCEPROTO;&<     if (news_prof.autosave) pfr.u.flags |= PFREC_M_AUTOSAVE;B     if (!news_prof.newsrc_purge) pfr.u.flags |= PFREC_M_RCNOPURGE;"     rab.rab$w_rsz = PFREC_S_FRONT;     status = sys$put(&rab,0,0);i       if (OK(status)) {       	pfr.code = PFILE__NGACTION;&     	pfr.u.flags = news_prof.ngaction;#     	rab.rab$w_rsz = PFREC_S_FRONT;       	status = sys$put(&rab,0,0);     },  J     if (OK(status) && !news_prof.usemailpnam && *news_prof.personalname) {$     	pfr.code = PFILE__PERSONALNAME;4     	strcpy(pfr.u.txt.text, news_prof.personalname);8     	pfr.u.txt.textlen = strlen(news_prof.personalname);7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;e      	status = sys$put(&rab,0,0);     } 6     if (OK(status) && *news_prof.editorname != '\0') {"     	pfr.code = PFILE__EDITORNAME;2     	strcpy(pfr.u.txt.text, news_prof.editorname);6     	pfr.u.txt.textlen = strlen(news_prof.editorname);7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;       	status = sys$put(&rab,0,0);     } 3     if (OK(status) && *news_prof.sigfile != '\0') { #     	pfr.code = PFILE__SIGFILENAME;h/     	strcpy(pfr.u.txt.text, news_prof.sigfile);f3     	pfr.u.txt.textlen = strlen(news_prof.sigfile);q7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;t      	status = sys$put(&rab,0,0);     }e3     if (OK(status) && *news_prof.archive != '\0') {o     	pfr.code = PFILE__ARCHIVE;o/     	strcpy(pfr.u.txt.text, news_prof.archive);_3     	pfr.u.txt.textlen = strlen(news_prof.archive); 7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;       	status = sys$put(&rab,0,0);     } 2     if (OK(status) && *news_prof.newsrc != '\0') {     	pfr.code = PFILE__NEWSRC;.     	strcpy(pfr.u.txt.text, news_prof.newsrc);2     	pfr.u.txt.textlen = strlen(news_prof.newsrc);2     	pfr.u.txt.hdrcode = news_prof.newsrc_subonly;7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;c      	status = sys$put(&rab,0,0);     } 7     if (OK(status) && *news_prof.print_queue != '\0') {s     	pfr.code = PFILE__QUEUE;&3     	strcpy(pfr.u.txt.text, news_prof.print_queue);u7     	pfr.u.txt.textlen = strlen(news_prof.print_queue);t7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;s      	status = sys$put(&rab,0,0);     }=6     if (OK(status) && *news_prof.print_form != '\0') {     	pfr.code = PFILE__FORM;2     	strcpy(pfr.u.txt.text, news_prof.print_form);6     	pfr.u.txt.textlen = strlen(news_prof.print_form);7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;l      	status = sys$put(&rab,0,0);     }F       if (OK(status)) {f$     	pfr.code = PFILE__REPLY_PREFIX;4     	strcpy(pfr.u.txt.text, news_prof.reply_prefix);4     	pfr.u.txt.textlen = news_prof.reply_prefix_len;7     	rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT;E      	status = sys$put(&rab,0,0);     }_       if (OK(status) && F     	    (news_prof.dir_fromwid >= 0 || news_prof.dir_subjwid >= 0)) {      	pfr.code = PFILE__DIRWIDTH;/     	pfr.u.wid.fromwid = news_prof.dir_fromwid;./     	pfr.u.wid.subjwid = news_prof.dir_subjwid; 1     	rab.rab$w_rsz = sizeof(int) + PFREC_S_FRONT;E      	status = sys$put(&rab,0,0);     }      if (OK(status)) {p"     	pfr.code = PFILE__GLOBALKILL;%     	for (hdr = news_prof.killq.head;TC     	    	    OK(status) && hdr != (struct HDR *) &news_prof.killq; !     	    	    hdr = hdr->flink) {s*     	    strcpy(pfr.u.txt.text, hdr->str);'     	    pfr.u.txt.hdrcode = hdr->code; .     	    pfr.u.txt.textlen = strlen(hdr->str);;     	    rab.rab$w_rsz = pfr.u.txt.textlen + PFREC_S_FRONT; $     	    status = sys$put(&rab,0,0);     	}     }N       if (OK(status)) {;!     	pfr.code = PFILE__NEWHEADER;      	pfr.u.rng.rcount = 0;'     	for (hdr = news_prof.hdrlist.head;iE     	    	    OK(status) && hdr != (struct HDR *) &news_prof.hdrlist; !     	    	    hdr = hdr->flink) { *     	    if (pfr.u.rng.rcount == MAXHCT) {=     	    	rab.rab$w_rsz = PFREC_S_FRONT + pfr.u.rng.rcount*4; %     	    	status = sys$put(&rab,0,0);i     	    	pfr.u.rng.rcount = 0; 
     	    }9     	    pfr.u.rng.range[pfr.u.rng.rcount++] = hdr->code;-     	}/     	if (OK(status) && pfr.u.rng.rcount != 0) { <     	    rab.rab$w_rsz = PFREC_S_FRONT + pfr.u.rng.rcount*4;$     	    status = sys$put(&rab,0,0);     	}     }   G     if (OK(status) && news_prof.ehdrlist.head != &news_prof.ehdrlist) {a$     	pfr.code = PFILE__EXTRACT_HDRS;     	pfr.u.rng.rcount = 0;(     	for (hdr = news_prof.ehdrlist.head;F     	    	    OK(status) && hdr != (struct HDR *) &news_prof.ehdrlist;$     	       	    hdr = hdr->flink) {*     	    if (pfr.u.rng.rcount == MAXHCT) {=     	    	rab.rab$w_rsz = PFREC_S_FRONT + pfr.u.rng.rcount*4; %     	    	status = sys$put(&rab,0,0);e     	    	pfr.u.rng.rcount = 0; 
     	    }9     	    pfr.u.rng.range[pfr.u.rng.rcount++] = hdr->code;h     	}/     	if (OK(status) && pfr.u.rng.rcount != 0) { <     	    rab.rab$w_rsz = PFREC_S_FRONT + pfr.u.rng.rcount*4;$     	    status = sys$put(&rab,0,0);     	}     }        if (OK(status)) { "     	pfr.code = PFILE__LASTGRPCHK;&     	pfr.u.lgc = news_prof.lastgrpchk;     	rab.rab$w_rsz = 12;      	status = sys$put(&rab,0,0);     }        if (OK(status)) {.?     	lib$traverse_tree(&news_prof.gtree, write_grp_info, &rab);;     	status = rab.rab$l_sts;     }   1     if (!OK(status)) lib$signal(NEWS__WRITERR, 2,f>     	    nam.nam$b_rsl, nam.nam$l_rsa, status, rab.rab$l_stv);       sys$disconnect(&rab,0,0);   0     if (!OK(status)) fab.fab$l_fop |= FAB$M_DLT;     sys$close(&fab,0,0);       if (OK(status)) { %     	struct dsc$descriptor ddsc, dsc;;     	unsigned int ctx;8     	static $DESCRIPTOR(dname_del, "SYS$LOGIN:.NRPF;*");,     	static $DESCRIPTOR(fname_ren, "*.*;1");  &     	ddsc.dsc$b_dtype = DSC$K_DTYPE_T;&     	ddsc.dsc$b_class = DSC$K_CLASS_D;     	ddsc.dsc$w_length = 0;      	ddsc.dsc$a_pointer = 0;3     	INIT_SDESC(dsc, nam.nam$b_rsl, nam.nam$l_rsa); 
     	ctx = 0; A     	while (OK(lib$find_file(&fname, &ddsc, &ctx, &dname_del))) { G     	    if (str$compare_eql(&ddsc, &dsc) != 0) lib$delete_file(&ddsc);i     	}'     	lib$rename_file(&dsc, &fname_ren);a     	str$free1_dx(&ddsc);	     }=  L     if (OK(pstat) && !(pp[0] & PRV$M_EXQUOTA)) sys$setprv(0, exquota, 0, 0);  #     if (!OK(status)) return status;  /*C ** If the user has set a newsrc file, then also write out the group  ** & article information there.u */       if (*news_prof.newsrc) {     	Write_NewsRC();     }n       return SS$_NORMAL;   } /* Write_Profile */	 ( /* **++ **  ROUTINE:	write_grp_infop ** **  FUNCTIONAL DESCRIPTION:  **D **  	Tree traversal action routine that writes out group information **  to the profile.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **3 **  	write_grp_info(struct GRP *g, struct RAB *rab)  **. **  g:	    GRP structure, modify, by reference& **  rab:    RAB, modify, by reference. ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.; ** **  COMPLETION CODES:h" **  	SS$_NORMAL: 	Always returned. ** **  SIDE EFFECTS:   	None. ** **-- */D static unsigned int write_grp_info(struct GRP *g, struct RAB *rab) {       struct PFREC *pfr; (     struct RNG *rng;     struct HDR *hdr;     unsigned int status;
     int k;  %     if (!g->avail) return SS$_NORMAL;   *     pfr = (struct PFREC *) rab->rab$l_rbf;E     if (news_cfg.newgroups != 2 && !g->subscribed) return SS$_NORMAL;   B     pfr->code = g->subscribed ? PFILE__GROUP : PFILE__GROUP_NOSUB;'     strcpy(pfr->u.txt.text, g->grpnam); +     pfr->u.txt.textlen = strlen(g->grpnam); 8     rab->rab$w_rsz = pfr->u.txt.textlen + PFREC_S_FRONT;     status = sys$put(rab,0,0);#     if (!OK(status)) return status;	  *     if (!g->subscribed) return SS$_NORMAL;  
     k = 0;!     pfr->code = PFILE__RANGELIST;=@     for (rng = g->seenq.head; rng != (struct RNG *) &(g->seenq);"     	    	    	rng = rng->flink) {#     	if (rng->last >= g->frstavl) { L     	    pfr->u.rng.range[k*2] = (rng->first < g->frstavl ? 1 : rng->first);.     	    pfr->u.rng. range[k*2+1] = rng->last;     	    if (k == MAXRCT-1) {(      	    	pfr->u.rng.rcount = k;/     	    	rab->rab$w_rsz = PFREC_S_FRONT + k*8;s$     	    	status = sys$put(rab,0,0);)     	    	if (!OK(status)) return status;r     	    	k = 0;     	    } else {N     	    	k += 1;(
     	    }     	}     }      if (k != 0) {      	pfr->u.rng.rcount = k; *     	rab->rab$w_rsz = PFREC_S_FRONT + k*8;     	status = sys$put(rab,0,0);	$     	if (!OK(status)) return status;     }s        pfr->code = PFILE__KILLLIST;R     for (hdr = g->killq.head; hdr != (struct HDR *) &g->killq; hdr = hdr->flink) {+     	pfr->u.txt.textlen = strlen(hdr->str); $     	pfr->u.txt.hdrcode = hdr->code;:     	if (pfr->u.txt.textlen > sizeof(pfr->u.txt.text)-1) {8     	    pfr->u.txt.textlen = sizeof(pfr->u.txt.text)-1;@     	    strncpy(pfr->u.txt.text, hdr->str, pfr->u.txt.textlen);
     	} else {S+     	    strcpy(pfr->u.txt.text, hdr->str);      	}9     	rab->rab$w_rsz = PFREC_S_FRONT + pfr->u.txt.textlen;      	status = sys$put(rab,0,0);l$     	if (!OK(status)) return status;     }t       return SS$_NORMAL;   } /* write_grp_info */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        