 /*  * Program:	IMAP2bis server   *  * Author:	Mark Crispin &  *		Networks and Distributed Computing  *		Computing & Communications  *		University of Washington"  *		Administration Building, AG-44  *		Seattle, WA  98195$  *		Internet: MRC@CAC.Washington.EDU  *  * Date:	5 November 1990  * Last Edited:	8 October 1993  *1  * Copyright 1993 by the University of Washington   *I  *  Permission to use, copy, modify, and distribute this software and its L  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appears in all copies and that both theI  * above copyright notice and this permission notice appear in supporting J  * documentation, and that the name of the University of Washington not beN  * used in advertising or publicity pertaining to distribution of the softwareE  * without specific, written prior permission.  This software is made   * available "as is", and M  * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, I  * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED M  * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN I  * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL, M  * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM G  * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT N  * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION0  * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  *  */    /* Parameter files */ 2 /*~~~ The following FOUR were transposed on VMS */ #include <stdio.h> #include <ctype.h> #include "osdep.h" #include "mail.h"  #include <netdb.h> #include <errno.h> #include <signal.h>  #ifndef VMS  #include <pwd.h> #endif /* VMS */ #include <file.h>  #include <stat.h>  #include <time.h>  #include "misc.h"   
 #ifdef VMS #define	printf	our_printf  #define	fputs	our_fputs  #define	fgets	our_fgets  #define	putchar	our_putchar  #endif	/* VMS */     /* Autologout timer */ #define TIMEOUT 60*30    /* Size of temporary buffers */  #define TMPLEN 1024      /* Server states */    #define LOGIN 0  #define SELECT 1 #define OPEN 2 #define LOGOUT 3   /* Global storage */  > char *version = "7.5(72)";	/* version number of this server */ #ifndef VMS , struct itimerval timer;		/* timeout state */ #endif	/* !VMS */ & int state = LOGIN;		/* server state */& int mackludge = 0;		/* MacMS kludge *// int anonymous = 0;		/* non-zero if anonymous */ 9 long kodcount = 0;		/* set if KOD has happened already */ . MAILSTREAM *stream = NIL;	/* mailbox stream */9 MAILSTREAM *tstream = NIL;	/* temporary mailbox stream */ 8 MAILSTREAM *create_policy;	/* current creation policy */* long nmsgs = 0;			/* number of messages */1 long recent = 0;		/* number of recent messages */ ( char *host = NIL;		/* local host name */" char *user = NIL;		/* user name */! char *pass = NIL;		/* password */ ' char *home = NIL;		/* home directory */ # char *flags = NIL;		/* flag text */ * char cmdbuf[TMPLEN];		/* command buffer */) char *tag;			/* tag portion of command */ - char *cmd;			/* command portion of command */ 9 char *arg;			/* pointer to current argument of command */ ; char *lsterr = NIL;		/* last error message from c-client */ - char *response = NIL;		/* command response */ 2 char *litbuf = NIL;		/* buffer to hold literals */     /* Response texts */  ) char *win = "%s OK %s completed\015\012"; " char *altwin = "%s OK %s\015\012";+ char *lose = "%s NO %s failed: %s\015\012"; @ char *misarg = "%s BAD Missing required argument to %s\015\012";= char *badfnd = "%s BAD FIND option unrecognized: %s\015\012"; H char *badarg = "%s BAD Argument given to %s when none expected\015\012";5 char *badseq = "%s BAD Bogus sequence in %s\015\012"; ; char *badatt = "%s BAD Bogus attribute list in %s\015\012"; : char *badlit = "%s BAD Bogus literal count in %s\015\012";5 char *toobig = "* BAD Command line too long\015\012"; , char *nulcmd = "* BAD Null command\015\012";. char *argrdy = "+ Ready for argument\015\012";   /* Drivers we use */  
 #ifdef VMS2 extern DRIVER imapdriver,nntpdriver,vmsmaildriver; #else /* VMS */ H extern DRIVER bezerkdriver,tenexdriver,imapdriver,newsdriver,nntpdriver,   philedriver,dummydriver; #endif /* VMS */   /* Function prototypes */    void clkint  (); void kodint  (); void dorc  (); char *snarf  (); void fetch  ();  void fetch_body  (); void fetch_body_part  ();  void fetch_envelope  (); void fetch_encoding  (); void changed_flags  ();  void fetch_flags  ();  void fetch_internaldate  (); void fetch_rfc822  (); void fetch_rfc822_header  ();  void fetch_rfc822_size  ();  void fetch_rfc822_text  ();  void penv  (); void pbody  ();  void pstring  ();  void paddr  ();  long cstring  ();  long caddr  ();    /* Main program */   main (argc,argv)
 	int argc; 	char *argv[]; { 	   long i; #   char *s,*t,*u,*v,tmp[MAILTMPLEN];    struct hostent *hst;   void (*f) () = NIL;   
 #ifdef VMS8   mail_link (&imapdriver);	/* install the IMAP driver */8   mail_link (&nntpdriver);	/* install the NNTP driver */3   mail_link (&vmsmaildriver);	/* VMS/MAIL driver */  #else /* VMS */ ?   mail_link (&tenexdriver);	/* install the Tenex mail driver */ C   mail_link (&bezerkdriver);	/* install the Berkeley mail driver */ 8   mail_link (&imapdriver);	/* install the IMAP driver */;   mail_link (&newsdriver);	/* install the netnews driver */ 8   mail_link (&nntpdriver);	/* install the NNTP driver */9   mail_link (&philedriver);	/* install the file driver */ :   mail_link (&dummydriver);	/* install the dummy driver */ #endif /* VMS */H   create_policy = mailstd_proto;/* default to creating system default */   #ifndef VMS 4   gethostname (cmdbuf,TMPLEN-1);/* get local name */H   host = cpystr ((hst = gethostbyname (cmdbuf)) ? hst->h_name : cmdbuf); #else /* !VMS */ #ifdef MULTINET 4   gethostname (cmdbuf,TMPLEN-1);/* get local name */H   host = cpystr ((hst = gethostbyname (cmdbuf)) ? hst->h_name : cmdbuf); #endif /* Multinet */ 
 #ifdef NETLIB )     get_local_host_name(cmdbuf,TMPLEN-1);      host = cpystr(cmdbuf); #endif /* NETLIB */  #endif /* !VMS */   0   rfc822_date (cmdbuf);		/* get date/time now */ #ifndef VMS (   if (i = getuid ()) {		/* logged in? */A     if (!(s = (char *) getlogin ())) s = (getpwuid (i))->pw_name; D     if (i < 0) anonymous = T;	/* must be anonymous if pseudo-user */.     user = cpystr (s);		/* set up user name */0     pass = cpystr ("*");	/* and fake password */-     state = SELECT;		/* enter select state */ (     t = "PREAUTH";		/* pre-authorized */   }    else t = "OK"; #else /* VMS */      i = 0; t = "OK"; #endif /* VMS */  
 #ifdef VMS   ___ttopen(); #endif	/* VMS */M   printf ("* %s %s IMAP2bis Service %s at %s\015\012",t,host,version,cmdbuf); 
 #ifdef VMS2   dorc ("UTIL$:imapd.conf");	/* run system init */ 				/* run user's init */  #else /* VMS */ 1   dorc ("/etc/imapd.conf");	/* run system init */  				/* run user's init */ >   if (i) dorc (strcat (strcpy (tmp,myhomedir ()),"/.imaprc")); #endif /* VMS */,   fflush (stdout);		/* dump output buffer */<   signal (SIGALRM,clkint);	/* prepare for clock interrupt */ #ifndef VMS :   signal (SIGUSR2,kodint);	/* prepare for Kiss Of Death */ #endif /* VMS */% 				/* initialize timeout interval */  #ifndef VMS %   timer.it_interval.tv_sec = TIMEOUT;     timer.it_interval.tv_usec = 0; #endif	/* !VMS */ '   do {				/* command processing loop */ % 				/* get a command under timeout */  #ifndef VMS @     timer.it_value.tv_sec = TIMEOUT; timer.it_value.tv_usec = 0;'     setitimer (ITIMER_REAL,&timer,NIL);  #endif	/* !VMS */ 2     if (!fgets (cmdbuf,TMPLEN-1,stdin)) _exit (1);$ 				/* make sure timeout disabled */ #ifndef VMS 7     timer.it_value.tv_sec = timer.it_value.tv_usec = 0; '     setitimer (ITIMER_REAL,&timer,NIL);  #endif	/* !VMS */ ' 				/* no more last error or literal */ ,     if (lsterr) fs_give ((void **) &lsterr);,     if (litbuf) fs_give ((void **) &litbuf); 				/* find end of line */7     if (!strchr (cmdbuf,'\012')) fputs (toobig,stdout); I     else if (!(tag = strtok (cmdbuf," \015\012"))) fputs (nulcmd,stdout); /     else if (!(cmd = strtok (NIL," \015\012"))) 4       printf ("%s BAD Missing command\015\012",tag);      else {			/* parse command */1       response = win;		/* set default response */ 3       ucase (cmd);		/* canonicalize command case */  				/* snarf argument */$       arg = strtok (NIL,"\015\012");% 				/* LOGOUT command always valid */ #       if (!strcmp (cmd,"LOGOUT")) { ( 	if (state == OPEN) mail_close (stream); 	stream = NIL;H 	printf("* BYE %s IMAP2bis server terminating connection\015\012",host); 	state = LOGOUT;       }    				/* kludge for MacMS */)       else if (!strcmp (cmd,"VERSION")) {  				/* single argument */ , 	if (!(s = snarf (&arg))) response = misarg;! 	else if (arg) response = badarg;  	else { , 	  if (!((i = atol (s)) && i > 0 && i <= 4))1 	    response = "%s BAD Unknown version\015\012"; ! 	  else if (mackludge = (i == 4)) G 	    fputs ("* OK [MacMS] The MacMS kludge is enabled\015\012",stdout);  	}       } &       else if (!strcmp (cmd,"NOOP")) {. 	if ((state == OPEN) && !mail_ping (stream)) {; 	  printf ("* BYE %s Fatal mailbox error: %s\015\012",host, # 		  lsterr ? lsterr : "<unknown>");   	  state = LOGOUT;	/* go away */ 	}       } ?       else switch (state) {	/* dispatch depending upon state */ 1       case LOGIN:		/* waiting to get logged in */  	if (!strcmp (cmd,"LOGIN")) {  	  struct stat sbuf; 	  struct passwd *pwd; 	  fs_give ((void **) &user);  	  fs_give ((void **) &pass);  				/* two arguments */ * 	  if (!((user = cpystr (snarf (&arg))) &&5 		(pass = cpystr (snarf (&arg))))) response = misarg; # 	  else if (arg) response = badarg; - 				/* see if username and password are OK */ E 	  else if (server_login (user,pass,&home,argc,argv)) state = SELECT; ) 				/* nope, see if we allow anonymous */ / #ifndef VMS	/* Do not allow anonymous access */ 8 	  else if (!stat ("/etc/anonymous.newsgroups",&sbuf) &&A 		   !strcmp (user,"anonymous") && (pwd = getpwnam ("nobody"))) { @ 	    anonymous = T;	/* note we are anonymous, login as nobody */ 	    setgid (pwd->pw_gid); 	    setuid (pwd->pw_uid);( 	    state = SELECT;	/* make selected */ 				/* run user's init */ : 	    dorc (strcat (strcpy (tmp,myhomedir ()),"/.imaprc")); 	  } #endif	/* !VMS */ D 	  else response = "%s NO Bad %s user name and/or password\015\012"; 	}H 	else response = "%s BAD Command unrecognized/login please: %s\015\012"; 	break;   4       case OPEN:		/* valid only when mailbox open */" 				/* fetch mailbox attributes */ 	if (!strcmp (cmd,"FETCH")) { H 	  if (!(arg && (s = strtok (arg," ")) && (t = strtok(NIL,"\015\012")))) 	    response = misarg; ' 	  else fetch (s,t);	/* do the fetch */  	}* 				/* fetch partial mailbox attributes */$ 	else if (!strcmp (cmd,"PARTIAL")) {( 	  unsigned long msgno,start,count,size;G 	  if (!(arg && (msgno = strtol (arg,&s,10)) && (t = strtok (s," ")) && @ 		(s = strtok (NIL,"\015\012")) && (start = strtol (s,&s,10)) &&1 		(count = strtol (s,&s,10)))) response = misarg; ' 	  else if (s && *s) response = badarg; 5 	  else if (msgno > stream->nmsgs) response = badseq;  	  else {		/* looks good */ + 	    int f = mail_elt (stream,msgno)->seen; & 	    u = s = NIL;	/* no strings yet */( 	    if (!strcmp (ucase (t),"RFC822")) {2 				/* have to make a temporary buffer for this */3 	      size = mail_elt (stream,msgno)->rfc822_size; * 	      s = u = (char *) fs_get (size + 1);2 	      strcpy (u,mail_fetchheader (stream,msgno));0 	      strcat (u,mail_fetchtext (stream,msgno));+ 	      u[size] = '\0';	/* tie off string */  	    }* 	    else if (!strcmp (t,"RFC822.HEADER")); 	      size = strlen (s = mail_fetchheader (stream,msgno)); ( 	    else if (!strcmp (t,"RFC822.TEXT"))9 	      size = strlen (s = mail_fetchtext (stream,msgno)); G 	    else if (*t == 'B' && t[1] == 'O' && t[2] == 'D' && t[3] == 'Y' && " 		     t[4] == '[' && *(t += 5)) {+ 	      if ((v = strchr (t,']')) && !v[1]) { $ 		*v = '\0';	/* tie off body part */, 		s = mail_fetchbody (stream,msgno,t,&size); 	      } 	    }' 	    if (s) {		/* got a string back? */ $ 	      if (size <= --start) s = NIL;4 	      else {		/* have string we can make smaller */* 		s += start;	/* this is the first byte */  				/* tie off as appropriate */. 		if (count < (size - start)) s[count] = '\0'; 	      }+ 	      printf ("* %ld FETCH (%s ",msgno,t); * 	      pstring (s);	/* write the string */ 	      changed_flags (msgno,f); " 	      fputs (")\015\012",stdout);% 	      if (u) fs_give ((void **) &u);  	    } 	    else response = badatt; 	  } 	}  " 				/* store mailbox attributes */" 	else if (!strcmp (cmd,"STORE")) {# 				/* must have three arguments */ E 	  if (!(arg && (s = strtok (arg," ")) && (cmd = strtok (NIL," ")) && 4 		(t = strtok (NIL,"\015\012")))) response = misarg;= 	  else if (!strcmp (ucase (cmd),"+FLAGS")) f = mail_setflag; 7 	  else if (!strcmp (cmd,"-FLAGS")) f = mail_clearflag; $ 	  else if (!strcmp (cmd,"FLAGS")) {% 	    mail_clearflag (stream,s,flags); ; 	    f = mail_setflag;	/* gross, but rarely if ever done */  	  }A 	  else response = "%s BAD STORE %s not yet implemented\015\012"; - 	  if (f) {		/* if a function was selected */ # 	    (*f) (stream,s,t);	/* do it */ 6 	    fetch (s,"FLAGS");	/* get the new flags status */ 	  } 	} 				/* check for new mail */" 	else if (!strcmp (cmd,"CHECK")) { 				/* no arguments */ 	  if (arg) response = badarg;* 	  else if (anonymous) mail_ping (stream); 	  else mail_check (stream); 	}" 				/* expunge deleted messages */3 	else if (!(anonymous || strcmp (cmd,"EXPUNGE"))) {  				/* no arguments */ 	  if (arg) response = badarg; 	  else mail_expunge (stream); 	} 				/* copy message(s) */ 0 	else if (!(anonymous || strcmp (cmd,"COPY"))) {F 	  if (!((s = snarf (&arg)) && (t = snarf (&arg)))) response = misarg;# 	  else if (arg) response = badarg; & 	  else if (!mail_copy (stream,s,t)) { 	    response = lose; B 	    if (!lsterr) lsterr = cpystr ("No such destination mailbox"); 	  } 	}   				/* search mailbox */# 	else if (!strcmp (cmd,"SEARCH")) { ( 				/* one or more arguments required */ 	  if (!arg) response = misarg; " 	  else {		/* zap search vector */& 				/* end with a literal argument? */5 	    while ((*(t = arg + strlen (arg) - 1) == '}') && 2 		   (s = strrchr (arg,'{')) && response == win) {) 				/* get length of literal, validate */ H 	      if (((i = atol (++s)) < 1) || (TMPLEN - (t++ - cmdbuf) < i + 10)) 		response = badlit;
 	      else { % 		*t++ = '\015';	/* reappend CR/LF */  		*t++ = '\012'; 		fputs (argrdy,stdout);* 		fflush (stdout);/* dump output buffer */ 				/* copy the literal */  		while (i--) *t++ = getchar (); 				/* start a timeout */  #ifndef VMS > 		timer.it_value.tv_sec = TIMEOUT; timer.it_value.tv_usec = 0;% 		setitimer (ITIMER_REAL,&timer,NIL);  #endif	/* !VMS */  				/* get new command tail */: 		if (!fgets (t,TMPLEN - (t-cmdbuf) - 1,stdin)) _exit (1); 				/* clear timeout */  #ifndef VMS 5 		timer.it_value.tv_sec = timer.it_value.tv_usec = 0; % 		setitimer (ITIMER_REAL,&timer,NIL);  #endif	/* !VMS */  				/* find end of line */2 		if (!(s = strchr (t,'\012'))) response = toobig; 		else {  		  *s = NIL;	/* tie off line */! 		  if (*--s == '\015') *s = NIL;  		}  	      } 	    } 				/* punt if error */   	    if (response != win) break; 				/* do the search */  	    mail_search (stream,arg);1 	    if (response == win || response == altwin) {  				/* output search results */ ! 	      fputs ("* SEARCH",stdout); # 	      for (i = 1; i <= nmsgs; ++i) 6 		if (mail_elt (stream,i)->searched) printf (" %d",i);! 	      fputs ("\015\012",stdout);  	    } 	  } 	}# 	else			/* fall into select case */   2       case SELECT:		/* valid whenever logged in */ 				/* select new mailbox *// 	if ((!(anonymous || strcmp (cmd,"SELECT"))) || = 	    (!strcmp (cmd,"BBOARD")) || (!strcmp (cmd,"EXAMINE"))) {  				/* single argument */ . 	  if (!(s = snarf (&arg))) response = misarg;# 	  else if (arg) response = badarg; 	 	  else { 
 #ifdef VMSd 	    sprintf (tmp,"(%s)%s%s", home, (*cmd == 'B') ? "*" : "",s);	/* Add the user's sepcifications */ #else /* VMS */ 5 	    sprintf (tmp,"%s%s",(*cmd == 'B') ? "*" : "",s);: #endif /* VMS */2 	    recent = -1;	/* make sure we get an update */G 	    if ((stream = mail_open (stream,tmp,anonymous ? OP_ANONYMOUS : NILn. 				     + (*cmd == 'E') ? OP_READONLY : NIL))3 		&& ((response == win) || (response == altwin))) {  				/* flush old list */" 	      fs_give ((void **) &flags);H               mm_exists (stream,stream->nmsgs);	/*~~~~ Wasn't here... */' 	      s = tmp;		/* write flags here */n+ 	      *s = '(';		/* start new flag list */e 	      s[1] = '\0'; ' 	      for (i = 0; i < NUSERFLAGS; i++)s; 		if (t = stream->user_flags[i]) strcat (strcat (s,t)," ");n% 				/* append system flags to list */o; 	      strcat (s,"\\Answered \\Flagged \\Deleted \\Seen)");  				/* output list of flags */: 	      printf ("* FLAGS %s\015\012",(flags = cpystr (s)));/ 	      kodcount = 0;	/* initialize KOD count */i* 	      state = OPEN;	/* note state open */! 				/* note readonly/readwrite */F$ 	      response = stream->readonly ?, 		"%s OK [READ-ONLY] %s completed\015\012" :. 		  "%s OK [READ-WRITE] %s completed\015\012"; 	    }% 	    else {		/* nuke if still open */S' 	      if (stream) mail_close (stream);  	      stream = NIL;0 	      state = SELECT;	/* no mailbox open now */) 	      response = lose;	/* open failed */A 	    } 	  } 	}# 				/* APPEND message to mailbox */O2 	else if (!(anonymous || strcmp (cmd,"APPEND"))) {F 	  if (!((s = snarf (&arg)) && (t = snarf (&arg)))) response = misarg;# 	  else if (arg) response = badarg;E  	  else {		/* append the data */ 	    STRING st;s2 	    INIT (&st,mail_string,(void *) t,strlen (t)); 	    mail_append (NIL,s,&st);u 	  } 	}  # 				/* find mailboxes or bboards */ ! 	else if (!strcmp (cmd,"FIND")) {n0 	  response = "%s OK FIND %s completed\015\012";* 				/* get subcommand and true argument */F 	  if (!(arg && (s = strtok (arg," \015\012")) && (cmd = ucase (s)) &&9 		(arg = strtok (NIL,"\015\012")) && (s = snarf (&arg)))) 7 	    response = misarg;	/* missing required argument */e# 	  else if (arg) response = badarg;eB 	  else if (anonymous) {	/* special version for anonymous users */< 	    if (!strcmp (cmd,"BBOARDS")) mail_find_bboards (NIL,s);H 	    else if (!strcmp (cmd,"ALL.BBOARDS")) mail_find_all_bboard (NIL,s);$ 				/* bboards not supported here */      	    else response = badfnd; 	  }' 	  else {		/* dispatch based on type */e
 #ifdef VMS 	    char tmp[256]; . 	    sprintf(tmp, "(%s)%s", home, s); s = tmp; #endif	/* VMS */H 	    if ((!strcmp (cmd,"MAILBOXES"))||(!strcmp (cmd,"ALL.MAILBOXES"))) {> 	      if (*s == '{') tstream = mail_open (NIL,s,OP_HALFOPEN);. 	      if (*cmd == 'A') { /* want them all? */ 		mail_find_all (NIL,s);) 		if (tstream) mail_find_all (tstream,s);c 	      }$ 	      else {		/* just subscribed */ 		mail_find (NIL,s);% 		if (tstream) mail_find (tstream,s);r 	      } 	    }H 	    else if ((!strcmp (cmd,"BBOARDS"))||(!strcmp (cmd,"ALL.BBOARDS"))){9 	      if (*s == '{') {	/* prepend leading * if remote */	 		sprintf (tmp,"*%s",s);, 		tstream = mail_open (NIL,tmp,OP_HALFOPEN); 	      }. 	      if (*cmd == 'A') { /* want them all? */ 		mail_find_all_bboard (NIL,s);/0 		if (tstream) mail_find_all_bboard (tstream,s); 	      }$ 	      else {		/* just subscribed */ 		mail_find_bboards (NIL,s);- 		if (tstream) mail_find_bboards (tstream,s);L 	      } 	    } 	    else response = badfnd;' 	    if (tstream) mail_close (tstream);s2 	    tstream = NIL;	/* no more temporary stream */ 	  } 	} r( 				/* subscribe to mailbox or bboard */5 	else if (!(anonymous || strcmp (cmd,"SUBSCRIBE"))) {B5 	  response = "%s OK SUBSCRIBE %s completed\015\012";f* 				/* get subcommand and true argument */F 	  if (!(arg && (s = strtok (arg," \015\012")) && (cmd = ucase (s)) &&9 		(arg = strtok (NIL,"\015\012")) && (s = snarf (&arg))))\7 	    response = misarg;	/* missing required argument */\# 	  else if (arg) response = badarg;g' 	  else {		/* dispatch based on type */o9 	    if (!strcmp (cmd,"MAILBOX")) mail_subscribe (NIL,s);dD 	    else if (!strcmp (cmd,"BBOARD")) mail_subscribe_bboard (NIL,s);H 	    else response = "%s BAD SUBSCRIBE option unrecognized: %s\015\012"; 	  } 	}* 				/* unsubscribe to mailbox or bboard */7 	else if (!(anonymous || strcmp (cmd,"UNSUBSCRIBE"))) {t7 	  response = "%s OK UNSUBSCRIBE %s completed\015\012"; * 				/* get subcommand and true argument */F 	  if (!(arg && (s = strtok (arg," \015\012")) && (cmd = ucase (s)) &&9 		(arg = strtok (NIL,"\015\012")) && (s = snarf (&arg))))t7 	    response = misarg;	/* missing required argument */f# 	  else if (arg) response = badarg;o' 	  else {		/* dispatch based on type */c; 	    if (!strcmp (cmd,"MAILBOX")) mail_unsubscribe (NIL,s);iF 	    else if (!strcmp (cmd,"BBOARD")) mail_unsubscribe_bboard (NIL,s);H 	    else response="%s BAD UNSUBSCRIBE option unrecognized: %s\015\012"; 	  } 	} 				/* create mailbox */2 	else if (!(anonymous || strcmp (cmd,"CREATE"))) {. 	  if (!(s = snarf (&arg))) response = misarg;# 	  else if (arg) response = badarg;L' 				/* use specified creation policy */r+ 	  mail_create (tstream = create_policy,s); & 	  tstream = NIL;	/* drop prototype */ 	} 				/* delete mailbox */2 	else if (!(anonymous || strcmp (cmd,"DELETE"))) {. 	  if (!(s = snarf (&arg))) response = misarg;# 	  else if (arg) response = badarg;v 	  else mail_delete (NIL,s); 	} 				/* rename mailbox */2 	else if (!(anonymous || strcmp (cmd,"RENAME"))) {F 	  if (!((s = snarf (&arg)) && (t = snarf (&arg)))) response = misarg;# 	  else if (arg) response = badarg;/ 	  else mail_rename (NIL,s,t); 	} l 				/* purge cache */ " 	else if (!strcmp (cmd,"PURGE")) {G 	  response = "%s OK PURGE %s is unnecessary with this server\015\012";* 				/* get subcommand */E 	  if (!(arg && (s = strtok (arg," \015\012")) && (cmd = ucase (s))))c0 	    response = misarg;	/* missing subcommand */! 	  arg = strtok (NIL,"\015\012");  	  if (strcmp (cmd,"ALWAYS")) { 9 	    if (!(arg && (s = snarf (&arg)))) response = misarg;o% 	    else if (arg) response = badarg;u= 	    if (strcmp (cmd,"STATUS") && strcmp (cmd,"STRUCTURE") &&T 		strcmp (cmd,"TEXTS"))nE 	      response = "%s NO PURGE %s is unknown to this server\015\012";  	  }# 	  else if (arg) response = badarg;u 	}  ; 	else response = "%s BAD Command unrecognized: %s\015\012";* 	break;n       default:K         response = "%s BAD Server in unknown state for %s command\015\012";y 	break;	       }e.       if (state == OPEN) {	/* mailbox open? */) 				/* yes, change in recent messages? */y 	if (recent != stream->recent)< 	  printf ("* %d RECENT\015\012",(recent = stream->recent)); 				/* output changed flags */G 	for (i = 1; i <= stream->nmsgs; i++) if (mail_elt (stream,i)->spare) {  	  printf ("* %d FETCH (",i);e 	  fetch_flags (i,NIL);  	  fputs (")\015\012",stdout); 	}       }52 				/* get text for alternative win message now */+       if (response == altwin) cmd = lsterr;	 				/* output response */e'       printf (response,tag,cmd,lsterr);)     }n4     fflush (stdout);		/* make sure output blatted */3   } while (state != LOGOUT);	/* until logged out */;   exit (0);			/* all done */ }o ; /* Clock interrupt  *//   void clkint () {l?   fputs ("* BYE Autologout; idle for too long\015\012",stdout);(2   fflush (stdout);		/* make sure output blatted */, 				/* try to gracefully close the stream */)   if (state == OPEN) mail_close (stream);.   stream = NIL;    exit (0);			/* die die die */; }e     /* Kiss Of Death interrupt  */d   void kodint () { 
   char *s;4   if (!kodcount++) {		/* only do this once please */' 				/* must be open for this to work */vN     if ((state == OPEN) && stream && stream->dtb && (s = stream->dtb->name) &&F 	(!strcmp (s,"bezerk") || !strcmp (s,"mbox") || !strcmp (s,"mmdf"))) {O       fputs("* OK [READ-ONLY] Now READ-ONLY, mailbox lock surrendered\015\012", 
 	    stdout); :       stream->readonly = T;	/* make the stream readonly */2       mail_ping (stream);	/* cause it to stick! */     }dJ     else fputs ("* NO Unexpected KOD interrupt received, ignored\015\012",
 		stdout);4     fflush (stdout);		/* make sure output blatted */   }  }  e /* Process rc file  * Accepts: file namef  */(   void dorc (file) 	char *file; {=   char *s,*t,*k;   void *fs;    struct stat sbuf;i%   int fd = open (file,O_RDONLY, NIL);{,   if (fd < 0) return;		/* punt if no file */(   fstat (fd,&sbuf);		/* yes, get size */, 				/* make readin area and read the file */I   read (fd,(s = (char *) (fs = fs_get (sbuf.st_size + 1))),sbuf.st_size);o2   close (fd);			/* don't need the file any more */*   s[sbuf.st_size] = '\0';	/* tie it off */ 				/* parse init file */i'   while (*s && (t = strchr (s,'\n'))) { 6     *t = '\0';			/* tie off line, find second space */9     if ((k = strchr (s,' ')) && (k = strchr (++k,' '))) {,*       *k++ = '\0';		/* tie off two words*/;       if (!strcmp (lcase (s),"set create-folder-format")) {r> 	if (!strcmp (lcase (k),"same-as-inbox")) create_policy = NIL;0 	else if (!strcmp (lcase (k),"system-standard"))! 	  create_policy = mailstd_proto; = 	else printf ("* NO Unknown format in imaprc: %s\015\012",k);b       }1     }u"     s = ++t;			/* try next line */   }p#   fs_give (&fs);		/* free buffer */) }  i /* Snarf an argument,  * Accepts: pointer to argument text pointer  * Returns: argument  */l   char *snarf (arg)  	char **arg; {U	   long i;a   char *c = *arg;    char *s = c + 1;   char *t = NIL;2   if (!c) return NIL;		/* better be an argument */0   switch (*c) {			/* see what the argument is */!   case '\0':			/* catch bogons */s   case ' ':*     return NIL;(!   case '"':			/* quoted string */i?     if (!(strchr (s,'"') && (c = strtok (c,"\"")))) return NIL; 
     break;"   case '{':			/* literal string */1     if (isdigit (*s)) {		/* be sure about that */s0       i = strtol (s,&t,10);	/* get its length */! 				/* validate end of literal */n*       if (*t++ != '}' || *t++) return NIL;A       fputs (argrdy,stdout);	/* tell client ready for argument */o0       fflush (stdout);		/* dump output buffer */ 				/* get a literal buffer */)       c = litbuf = (char *) fs_get (i+1);w 				/* start timeout */  #ifndef VMSyB       timer.it_value.tv_sec = TIMEOUT; timer.it_value.tv_usec = 0;)       setitimer (ITIMER_REAL,&timer,NIL);  #endif	/* !VMS */;$       while (i--) *c++ = getchar ();2       *c++ = NIL;		/* make sure string tied off */%       c = litbuf;		/* return value */S"     				/* get new command tail */I       if (!fgets ((*arg = t),TMPLEN - (t - cmdbuf) - 1,stdin)) _exit (1);d 				/* clear timeout */e #ifndef VMS;9       timer.it_value.tv_sec = timer.it_value.tv_usec = 0;x)       setitimer (ITIMER_REAL,&timer,NIL);/ #endif	/* !VMS */,;       if (!strchr (t,'\012')) {	/* have a newline there? */s' 	response = toobig;	/* lost it seems */  	return NIL;       }        break;     }h3 				/* otherwise fall through (third party IMAP) */     default:			/* atomic string */     c = strtok (c," \015\012");c
     break;   }   				/* remainder of arguments */=   if ((*arg = strtok (t,"\015\012")) && **arg == ' ') ++*arg;)   return c;  }t ( /* Fetch message data=   * Accepts: sequence as a string)  *	    string of data items to be fetcheda  */    #define MAXFETCH 100   void fetch (s,t)	 	char *s; 	 	char *t;/ {o   char c,*v;   long i,k;m
   BODY *b;   int parse_bodies = NIL;=   void (*f[MAXFETCH]) ();    char *fa[MAXFETCH];c"   if (!mail_sequence (stream,s)) {4     response = badseq;		/* punt if sequence bogus */     return;m   }o 				/* process macros */    if (!strcmp (ucase (t),"ALL"));     strcpy (t,"(FLAGS INTERNALDATE RFC822.SIZE ENVELOPE)");s   else if (!strcmp (t,"FULL"))@     strcpy (t,"(FLAGS INTERNALDATE RFC822.SIZE ENVELOPE BODY)");M   else if (!strcmp (t,"FAST")) strcpy (t,"(FLAGS INTERNALDATE RFC822.SIZE)");eB   s = t + strlen (t) - 1;	/* last character in attribute string */3 				/* if multiple items, make sure in list form */)7   if (strchr (t,' ') && ((*t != '(') || (*s != ')'))) {      response = badatt;     return;'   }( 				/* nuke the parens now */c3   if ((*t == '(') && (*s == ')') && t++) *s = '\0';y   k = 0;			/* initial index */9   if (s = strtok (t," ")) do {	/* parse attribute list */ A     if (*s == 'B' && s[1] == 'O' && s[2] == 'D' && s[3] == 'Y') { ;       parse_bodies = T;		/* we will need to parse bodies */	       switch (s[4]) {t#       case '\0':		/* entire body *// 	f[k++] = fetch_body;  	break;[$       case '[':			/* body segment */2 	if ((v = strchr (s + 5,']')) && (!(*v = v[1]))) {$ 	  fa[k] = s + 5;	/* set argument */ 	  f[k++] = fetch_body_part;# 	  break;		/* valid body segment */ & 	}			/* else fall into default case */       default:			/* bogus */ 	response = badatt;o 	return;       }e     }e=     else if (!strcmp (s,"ENVELOPE")) f[k++] = fetch_envelope;n7     else if (!strcmp (s,"FLAGS")) f[k++] = fetch_flags;sE     else if (!strcmp (s,"INTERNALDATE")) f[k++] = fetch_internaldate;r9     else if (!strcmp (s,"RFC822")) f[k++] = fetch_rfc822;tG     else if (!strcmp (s,"RFC822.HEADER")) f[k++] = fetch_rfc822_header; C     else if (!strcmp (s,"RFC822.SIZE")) f[k++] = fetch_rfc822_size; C     else if (!strcmp (s,"RFC822.TEXT")) f[k++] = fetch_rfc822_text; $     else {			/* unknown attribute */       response = badatt;
       return;/     }f3   } while ((s = strtok (NIL," ")) && k < MAXFETCH);d   else {4     response = misarg;		/* missing attribute list */     return;	   }c'   if (s) {			/* too many attributes? */cI     response = "%s BAD Excessively complex FETCH attribute list\015\012";e     return;m   }m.   f[k++] = NIL;			/* tie off attribute list */$ 				/* for each requested message */C   for (i = 1; i <= nmsgs; i++) if (mail_elt (stream,i)->sequence) {r/ 				/* parse envelope, set body, do warnings */s;     mail_fetchstructure (stream,i,parse_bodies ? &b : NIL);s+     printf ("* %d FETCH (",i);	/* leader */ 0     (*f[0]) (i,fa[0]);		/* do first attribute */@     for (k = 1; f[k]; k++) {	/* for each subsequent attribute */.       putchar (' ');		/* delimit with space */0       (*f[k]) (i,fa[k]);	/* do that attribute */     }t-     fputs (")\015\012",stdout);	/* trailer */    }o }/ e /* Fetch message body structure   * Accepts: message number  *	    string argument  */r     void fetch_body (i,s)  	long i;	 	char *s;o {/
   BODY *body;t'   mail_fetchstructure (stream,i,&body);t0   fputs ("BODY ",stdout);	/* output attribute */#   pbody (body);			/* output body */) }      /* Fetch message body part  * Accepts: message number  *	    string argument  */-   void fetch_body_part (i,s) 	long i;	 	char *s;  {    unsigned long j;
   long k = 0;e
   BODY *body;	$   int f = mail_elt (stream,i)->seen;'   mail_fetchstructure (stream,i,&body);e0   printf ("BODY[%s] ",s);	/* output attribute */5   if (body && (s = mail_fetchbody (stream,i,s,&j))) {M 				/* and literal string */     printf ("{%d}\015\012",j);
 #ifdef VMS     while (j -= k) {  	k = (j <= TMPLEN ? j : TMPLEN); 	___write_terminal (s, k); 	s += k;    } #else	/* VMS */b2     while (j -= k) k = fwrite (s += k,1,j,stdout); #endif	/* VMS */3     changed_flags (i,f);	/* output changed flags */    }i?   else fputs ("NIL",stdout);	/* can't output anything at all */  }  l /* Fetch IMAP envelope  * Accepts: message number  *	    string argument  */L   void fetch_envelope (i,s)( 	long i;	 	char *s;N { 5   ENVELOPE *env = mail_fetchstructure (stream,i,NIL); 4   fputs ("ENVELOPE ",stdout);	/* output attribute */%   penv (env);			/* output envelope */i }r o /* Fetch flags  * Accepts: message number  *	    string argument  */    void fetch_flags (i,s) 	long i;	 	char *s;  {;   char tmp[MAILTMPLEN];(   unsigned long u;
   char *t;*   MESSAGECACHE *elt = mail_elt (stream,i);
   s = tmp;9   s[0] = s[1] = '\0';		/* start with empty flag string */  				/* output system flags */e*   if (elt->recent) strcat (s," \\Recent");&   if (elt->seen) strcat (s," \\Seen");,   if (elt->deleted) strcat (s," \\Deleted");,   if (elt->flagged) strcat (s," \\Flagged");.   if (elt->answered) strcat (s," \\Answered");3   if (u = elt->user_flags) do	/* any user flags? */ .     if ((TMPLEN - ((s += strlen (s)) - tmp)) >B 	(2 + strlen (t = stream->user_flags[find_rightmost_bit (&u)]))) {(       *s++ = ' ';		/* space delimiter */-       strcpy (s,t);		/* copy the user flag *//     }/-   while (u);			/* until no more user flags */tL   printf ("FLAGS (%s)",tmp+1);	/* output results, skip first char of list */0   elt->spare = NIL;		/* we've sent the update */ }&     /* Output flags if was unseen   * Accepts: message number  *	    prior value of Seen flag   */f   void changed_flags (i,f) 	long i; 	int f;> {g   if (!f) {			/* was unseen? */ 1     putchar (' ');		/* yes, delimit with space */(+     fetch_flags (i,NIL);	/* output flags */    }  }      /* Fetch message internal date  * Accepts: message number  *	    string argument  */,   void fetch_internaldate (i,s)s 	long i;	 	char *s;s {a   char tmp[MAILTMPLEN];dE   printf ("INTERNALDATE \"%s\"",mail_date (tmp,mail_elt (stream,i)));" }L  ( /* Fetch complete RFC-822 format message  * Accepts: message number  *	    string argument  */=   void fetch_rfc822 (i,s)/ 	long i;	 	char *s;y {a$   int f = mail_elt (stream,i)->seen;C   printf ("RFC822 {%d}\015\012%s",mail_elt (stream,i)->rfc822_size,[  	  mail_fetchheader (stream,i));+   fputs (mail_fetchtext (stream,i),stdout);*2   changed_flags (i,f);		/* output changed flags */ }r     /* Fetch RFC-822 headerL  * Accepts: message number  *	    string argument  */*   void fetch_rfc822_header (i,s) 	long i;	 	char *s;g {o"   fputs ("RFC822.HEADER ",stdout);(   pstring (mail_fetchheader (stream,i)); }n     /* Fetch RFC-822 message lengthe  * Accepts: message number  *	    string argument  */    void fetch_rfc822_size (i,s) 	long i;	 	char *s;  {I=   printf ("RFC822.SIZE %d",mail_elt (stream,i)->rfc822_size);I },     /* Fetch RFC-822 text only  * Accepts: message number  *	    string argument  */)   void fetch_rfc822_text (i,s) 	long i;	 	char *s;; {	$   int f = mail_elt (stream,i)->seen;    fputs ("RFC822.TEXT ",stdout);&   pstring (mail_fetchtext (stream,i));2   changed_flags (i,f);		/* output changed flags */ })   /* Print envelopei  * Accepts: body  */e   void penv (env)e 	ENVELOPE *env;o { 1   if (env) {			/* only if there is an envelope */s! 				/* disgusting MacMS kludge */ O     if (mackludge) printf ("%d ",cstring (env->date) + cstring (env->subject) +"/ 			   caddr (env->from) + caddr (env->sender) +	/ 			   caddr (env->reply_to) + caddr (env->to) +e* 			   caddr (env->cc) + caddr (env->bcc) +" 			   cstring (env->in_reply_to) +! 			   cstring (env->message_id));p#     putchar ('(');		/* delimiter */f5     pstring (env->date);	/* output envelope fields */c     putchar (' ');     pstring (env->subject);'     putchar (' ');     paddr (env->from);     putchar (' ');     paddr (env->sender);     putchar (' ');     paddr (env->reply_to);     putchar (' ');     paddr (env->to);     putchar (' ');     paddr (env->cc);     putchar (' ');     paddr (env->bcc);,     putchar (' ');     pstring (env->in_reply_to);B     putchar (' ');     pstring (env->message_id);)     putchar (')');		/* end of envelope */o   }	.   else fputs ("NIL",stdout);	/* no envelope */ }N t
 /* Print body;  * Accepts: body  */*   void pbody (body)  	BODY *body; {a-   if (body) {			/* only if there is a body */i     PARAMETER *param;e     PART *part; #     putchar ('(');		/* delimiter */  				/* multipart type? */;&     if (body->type == TYPEMULTIPART) { 				/* print each part */ %       if (part = body->contents.part)t7 	for (; part; part = part->next) pbody (&(part->body)); J       else fputs ("(\"TEXT\" \"PLAIN\" NIL NIL NIL \"7BIT\" 0 0)",stdout);+       putchar (' ');		/* space delimiter */U<       pstring (body->subtype);	/* and finally the subtype */     }f*     else {			/* non-multipart body type */0       pstring ((char *) body_types[body->type]);       putchar (' ');       pstring (body->subtype);$       if (param = body->parameter) { 	fputs (" (",stdout);i 	do {i 	  pstring (param->attribute); 	  putchar (' ');g 	  pstring (param->value);* 	  if (param = param->next) putchar (' '); 	} while (param);i 	fputs (") ",stdout);        }m"       else fputs (" NIL ",stdout);       pstring (body->id);p       putchar (' ');"       pstring (body->description);       putchar (' ');8       pstring ((char *) body_encodings[body->encoding]);&       printf (" %d",body->size.bytes);D       switch (body->type) {	/* extra stuff depends upon body type */       case TYPEMESSAGE: % 				/* can't do this if not RFC822 */\, 	if (strcmp (body->subtype,"RFC822")) break; 	putchar (' ');) 	penv (body->contents.msg.env);r 	putchar (' ');	! 	pbody (body->contents.msg.body);        case TYPETEXT:! 	printf (" %d",body->size.lines);h 	break;        default: 	break;p       }I     } %     putchar (')');		/* end of body */f   }r*   else fputs ("NIL",stdout);	/* no body */ }L ; /* Print stringn  * Accepts: string  */t   void pstring (s)	 	char *s;  {}   char c,*t;%   if (s) {			/* is there a string? */ ! 				/* must use literal string */ M     if (strpbrk (s,"\012\015\"%{\\")) printf ("{%d}\015\012%s",strlen (s),s); 9     else printf ("\"%s\"",s);	/* may use quoted string */s   } /   else fputs ("NIL",stdout);	/* empty string */r }t     /* Print address lista  * Accepts: address list  */    void paddr (a) 	ADDRESS *a; { ,   if (a) {			/* have anything in address? *//     putchar ('(');		/* open the address list */l!     do {			/* for each address */l,       putchar ('(');		/* open the address */0       pstring (a->personal);	/* personal name */       putchar (' ');-       pstring (a->adl);		/* at-domain-list */g       putchar (' ');)       pstring (a->mailbox);	/* mailbox */        putchar (' ');<       pstring (a->host);	/* domain name of mailbox's host */-       putchar (')');		/* terminate address */n5     } while (a = a->next);	/* until end of address */ ,     putchar (')');		/* close address list */   }s0   else fputs ("NIL",stdout);	/* empty address */ }   $ /* Count string and space afterwards  * Accepts: string#  * Returns: 1 plus length of string   */    long cstring (s)	 	char *s;  {i   char tmp[20];T   long i = s ? strlen (s) : 0;%   if (s) {			/* is there a string? */ ! 				/* must use literal string */o'     if (strpbrk (s,"\012\015\"%{\\")) {s%       sprintf (tmp,"{%d}\015\012",i);        i += strlen (tmp);     }u%     else i += 2;		/* quoted string */    }e   else i += 3;			/* NIL */9   return i + 1;			/* return string plus trailing space */b }k    * /* Count address list and space afterwards  * Accepts: address list  */e   long caddr (a) 	ADDRESS *a; {n,   long i = 3;			/* open, close, and space */' 				/* count strings in address list */	?   if (a) do i += 1 + cstring (a->personal) + cstring (a->adl) + -     cstring (a->mailbox) + cstring (a->host);"2   while (a = a->next);		/* until end of address */$   else i = 4;			/* NIL plus space */$   return i;			/* return the count */ }s  # /* Co-routines from MAIL library */      /* Message matches a searchp  * Accepts: MAIL streame  *	    message number)  */    void mm_searched (s,msgno) 	MAILSTREAM *s;l 	long msgno; {l 				/* nothing to do here */ }g     /* Message exists (mailbox)d2 	i.e. there are that many messages in the mailbox;  * Accepts: MAIL streamY  *	    message numbert  */n   void mm_exists (s,number)h 	MAILSTREAM *s;k
 	long number;l {e>   if (s != tstream) {		/* note change in number of messages */4     printf ("* %d EXISTS\015\012",(nmsgs = number));8     recent = -1;		/* make sure fetch new recent count */   }t }*     /* Message expunged   * Accepts: MAIL streamn  *	    message number   */p   void mm_expunged (s,number)o 	MAILSTREAM *s;v
 	long number;e { ;   if (s != tstream) printf ("* %d EXPUNGE\015\012",number);  }s     /* Message status changeds  * Accepts: MAIL streamm  *	    message number*  */R   void mm_flags (s,number) 	MAILSTREAM *s;e
 	long number;  { 3   if (s != tstream) mail_elt (s,number)->spare = T;t }m a /* Mailbox found  * Accepts: Mailbox name  */o   void mm_mailbox (string) 	char *string; {e)   printf ("* MAILBOX %s\015\012",string);2 }      /* BBoard foundh  * Accepts: BBoard nameo  */    void mm_bboard (string)* 	char *string; {*(   printf ("* BBOARD %s\015\012",string); }) c /* Notification event*  * Accepts: MAIL stream   *	    string to log  *	    error flag,  */N    void mm_notify (s,string,errflg) 	MAILSTREAM *s;  	char *string;
 	long errflg;, {t3   if (!tstream || (s != tstream)) switch (errflg) {/;   case NIL:			/* information message, set as OK response */s9   case PARSE:			/* parse glitch, output unsolicited OK */m&     printf ("* OK %s\015\012",string);
     break;=   case WARN:			/* warning, output unsolicited NO (kludge!) */)&     printf ("* NO %s\015\012",string);
     break;.   case ERROR:			/* error that broke command */.   default:			/* default should never happen */'     printf ("* BAD %s\015\012",string);e
     break;   }f }e o# /* Log an event for the user to sees  * Accepts: string to logc  *	    error flag(  */m   void mm_log (string,errflg)) 	char *string;
 	long errflg;o { =   switch (errflg) {		/* action depends upon the error flag */b;   case NIL:			/* information message, set as OK response */ >     if (response == win) {	/* only if no other response yet */@       response = altwin;	/* switch to alternative win message */"       fs_give ((void **) &lsterr);?       lsterr = cpystr (string);	/* copy string for later use */;     }r
     break;9   case PARSE:			/* parse glitch, output unsolicited OK */h.     printf ("* OK [PARSE] %s\015\012",string);
     break;=   case WARN:			/* warning, output unsolicited NO (kludge!) */	N     if (strcmp (string,"Mailbox is empty")) printf ("* NO %s\015\012",string);
     break;.   case ERROR:			/* error that broke command */.   default:			/* default should never happen */(     response = lose;		/* set fatality */5     fs_give ((void **) &lsterr);/* flush old error */t3     lsterr = cpystr (string);	/* note last error */t
     break;   }i }     & /* Log an event to debugging telemetry  * Accepts: string to log/  */	   void mm_dlog (string)/ 	char *string; {=8   mm_log (string,WARN);		/* shouldn't happen normally */ }M  + /* Get user name and password for this hosti  * Accepts: host name    *	    where to return user name  *	    where to return password   *	    trial count  */r  , void mm_login (host,username,password,trial) 	char *host; 	char *username; 	char *password; 	long trial; {w-   strcpy (username,user);	/* set user name */T,   strcpy (password,pass);	/* and password */ }	 c /* About to enter critical code   * Accepts: stream  */    void mm_critical (s) 	MAILSTREAM *s;i {e'   /* Not doing anything here for now */V }*     /* About to exit critical code  * Accepts: stream  */*   void mm_nocritical (s) 	MAILSTREAM *s;  {r'   /* Not doing anything here for now */h }	     /* Disk error foundg  * Accepts: stream  *	    system error code4  *	    flag indicating that mailbox may be clobbered  * Returns: abort flag  */o  % long mm_diskerror (s,errcode,serious)\ 	MAILSTREAM *s;r 	long errcode; 	long serious; {t=   if (serious) {		/* try your damnest if clobberage likely */ L     fputs ("* BAD Retrying to fix probable mailbox damage!\015\012",stdout);.     fflush (stdout);		/* dump output buffer */) 				/* make damn sure timeout disabled */a #ifndef VMSN7     timer.it_value.tv_sec = timer.it_value.tv_usec = 0; '     setitimer (ITIMER_REAL,&timer,NIL);e #endif	/* !VMS */*5     sleep (60);			/* give it some time to clear up */p     return NIL;    }(2 				/* otherwise die before more damage is done */L   printf ("* BYE Aborting due to disk error %s\015\012",strerror (errcode));   return T;  }E     /* Log a fatal error event  * Accepts: string to log(  */S   void mm_fatal (string) 	char *string; {Z8   mm_log (string,ERROR);	/* shouldn't happen normally */ }u    K /*=======================================================================*/(
 #ifdef VMS #include <iodef.h> #include <ttdef.h> #include <tt2def.h>e    /* Output channel and buffers */ static short	TerminalChan = 0;G #define	MAXBUF	512		/* Save up to 512 characters before sending them */ ' unsigned char	OutputBuffer[MAXBUF + 1];i int	OutputBufferCounter;  / /* For setting and resting the PASTHRU flag: */  struct	{ 	unsigned char	class, type;t 	unsigned short	width;" 	unsigned long	characteristics[2]; 	} TerminalChar;  & struct DESC {		/* String descriptor */ 	short	length, type; 	char	*address;( 	} ; /*J  * ___ttopen - this function is called once to set up the terminal device A  *          streams.  if called as pine composer, don't mess with}/  *          tty modes, but set signal handlers.l  *// ___ttopen()r {o
 	long	status;  	struct DESC TerminalDesc;% 	char	TerminalName[] = "SYS$OUTPUT:";k  < 	TerminalDesc.address = TerminalName; TerminalDesc.type = 0;, 	TerminalDesc.length = strlen(TerminalName);  G 	status = sys$assign(&TerminalDesc, &TerminalChan, (int)(0), (int)(0));" 	if((status & 0x1) == 0) { 		exit(status);c 	}  6 	OutputBufferCounter = 0;	/* Output buffer is empty */         return(1); }2       /*I  * ___ttclose - this function gets called just before we go back home to ]H  *           the command interpreter.  If called as pine composer, don'tF  *           worry about modes, but set signals to default, pine will %  *           rewire things as needed.n  */m ___ttclose() {g 	int	status;   	sys$dassgn(TerminalChan); 	TerminalChan = 0;     return(1); }     $ our_printf(fmt, A, B, C, D, E, F, G)
 char	*fmt; {l 	char	buffer[8192];e  + 	sprintf(buffer, fmt, A, B, C, D, E, F, G);i+ 	___write_terminal(buffer, strlen(buffer));g
 	return 0; }=     our_fputs(string) 
 char	*string;a {)+ 	___write_terminal(string, strlen(string));d
 	return 0; }*     our_putchar(c) char c;s {a 	___write_terminal(&c, 1); }      /*-  | Physically write a string to the terminal.]  */f ___write_terminal(string, size) 
 char	*string; 	 int	size;{ { 
 	long	status;u 	short	iosb[4];   B 	status = sys$qiow((int)(0), TerminalChan, (short)(IO$_WRITEVBLK), 			iosb, (int)(0), (int)(0),9 			string, size, (int)(0), (int)(0), (int)(0), (int)(0)); 6 	if(((status & 0x1) == 0) || ((iosb[0] & 0x1) == 0)) { 		exit(status);  	} 	return 0;	/* Success */ }d     our_fgets(buffer, buffersize) 
 char	*buffer;Y {o2 	int	status = read_from_stdin(buffer, buffersize); 	if(status > 0)u 		return buffer; 	else	return NULL; })    H /*----------------------------------------------------------------------M      Lowest level read command. This reads one character with timeout. (UNIX)   ' ~~~~~~~ >Do not use timeout at present.kB     Args:  time_out --  number of seconds before read will timeout  C   Result: Returns a single character read or a NO_OP_COMMAND if the D           timeout expired, or a KEY_RESIZE if a resize even occured.     ----*/ intl# read_from_stdin(buffer, buffersize)"
 char	*buffer;S int	buffersize;  {{
 	int size;
 	long	status;M 	short	iosb[4];_  * 	status = sys$qiow((int)(0), TerminalChan,V 		(short)(IO$_READLBLK | IO$M_NOFORMAT | IO$M_NOFILTR | IO$M_NOECHO | IO$M_TRMNOECHO), 			iosb, (int)(0), (int)(0),3 			buffer, buffersize - 1, NULL, NULL, NULL, NULL);'6 	if(((status & 0x1) == 0) || ((iosb[0] & 0x1) == 0)) { 		exit(status);  	}  / 	buffer[size = (int)(iosb[1] & 0xffff)] = '\0';t( 	if(size > 0) {	/* Something is there *// 		buffer[size++] = '\n'; buffer[size++] = '\0';, 	}
 	return size;" }E #endif	/* VMS */  
 #ifdef VMS( /* Dummy since we call it at VMS_MAIL */ q_status_message() {} #endif	/* VMS */ssage number  *	    string argument  */    void fetch_flags (i,s) 	long i;	 	char *s;  {;   char tmp[MAILTMPLEN];(   unsigned long u;
   char *t;*   MESSAGECACHE *elt = mail_elt (stream,i);
   s = tmp;9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   