M /****************************************************************************  *                   bezier.c * B *  This module implements the code for Bezier bicubic patch shapes * D *  This file was written by Alexander Enzmann.	He wrote the code forH *  bezier bicubic patches and generously provided us these enhancements. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"    METHODS Bicubic_Patch_Methods =    { "   All_Bicubic_Patch_Intersections,A   Inside_Bicubic_Patch, Bicubic_Patch_Normal, Copy_Bicubic_Patch, 0   Translate_Bicubic_Patch, Rotate_Bicubic_Patch,E   Scale_Bicubic_Patch, Transform_Bicubic_Patch, Invert_Bicubic_Patch,    Destroy_Bicubic_Patch    };  ; extern long Ray_Bicubic_Tests, Ray_Bicubic_Tests_Succeeded;  extern unsigned int Options; extern RAY *CM_Ray;  extern int Shadow_Test_Flag;   int max_depth_reached;  > static int InvertMatrix PARAMS((VECTOR in[3], VECTOR out[3]));P static void bezier_value PARAMS((VECTOR (*Control_Points)[4][4], DBL u0, DBL v0, VECTOR *P, VECTOR *N)); I static int intersect_subpatch PARAMS((BICUBIC_PATCH *, RAY *, VECTOR [3], < DBL [3], DBL [3], DBL *, VECTOR *, VECTOR *, DBL *, DBL *));B static void find_average PARAMS((int, VECTOR *, VECTOR *, DBL *));A static int spherical_bounds_check PARAMS((RAY *, VECTOR *, DBL)); O static int intersect_bicubic_patch0 PARAMS((RAY *, BICUBIC_PATCH *, ISTACK *)); D static DBL point_plane_distance PARAMS((VECTOR *, VECTOR *, DBL *));B static DBL determine_subpatch_flatness PARAMS((VECTOR (*)[4][4]));C static int flat_enough PARAMS((BICUBIC_PATCH *, VECTOR (*)[4][4])); N static void bezier_bounding_sphere PARAMS((VECTOR (*)[4][4], VECTOR *,DBL *));D static int bezier_subpatch_intersect PARAMS((RAY *, BICUBIC_PATCH *,% VECTOR (*)[4][4], DBL, DBL, DBL, DBL,  ISTACK *)); N static void bezier_split_left_right PARAMS((VECTOR (*)[4][4],VECTOR (*)[4][4], VECTOR (*)[4][4])); L static void bezier_split_up_down PARAMS((VECTOR (*)[4][4], VECTOR (*)[4][4], VECTOR (*)[4][4])); M static int bezier_subdivider PARAMS((RAY *, BICUBIC_PATCH *,VECTOR (*)[4][4], $ DBL, DBL, DBL, DBL, int, ISTACK *));< static void bezier_tree_deleter PARAMS((BEZIER_NODE *Node));F static BEZIER_NODE *bezier_tree_builder PARAMS((BICUBIC_PATCH *Object,% VECTOR(*Patch)[4][4], DBL u0, DBL u1,  DBL v0, DBL v1, int depth));L static int bezier_tree_walker PARAMS((RAY *, BICUBIC_PATCH *, BEZIER_NODE *, ISTACK *)); : static BEZIER_NODE *create_new_bezier_node PARAMS((void));B static BEZIER_VERTICES *create_bezier_vertex_block PARAMS((void));A static BEZIER_CHILDREN *create_bezier_child_block PARAMS((void)); F static int subpatch_normal PARAMS((VECTOR *v1, VECTOR *v2, VECTOR *v3, VECTOR *Result, DBL *d));      static DBL C[4] = {    1.0, 3.0, 3.0, 1.0   };   #define BEZIER_EPSILON 1.0e-10 #define BEZIER_TOLERANCE 1.0e-5   , static BEZIER_NODE *create_new_bezier_node()   { A   BEZIER_NODE *Node = (BEZIER_NODE *)malloc(sizeof(BEZIER_NODE));    if (Node == NULL)      MAError("bezier node");    Node->Data_Ptr = NULL;   return Node;   }   4 static BEZIER_VERTICES *create_bezier_vertex_block()   { Q   BEZIER_VERTICES *Vertices = (BEZIER_VERTICES *)malloc(sizeof(BEZIER_VERTICES));    if (Vertices == NULL)      MAError("bezier vertices");    return Vertices;   }   3 static BEZIER_CHILDREN *create_bezier_child_block()    { Q   BEZIER_CHILDREN *Children = (BEZIER_CHILDREN *)malloc(sizeof(BEZIER_CHILDREN));    if (Children == NULL)      MAError("bezier children");    return Children;   }   M static BEZIER_NODE *bezier_tree_builder(Object, Patch, u0, u1, v0, v1, depth)  BICUBIC_PATCH *Object; VECTOR (*Patch)[4][4]; DBL u0, u1, v0, v1; 
 int depth;   { -   VECTOR Lower_Left[4][4], Lower_Right[4][4]; -   VECTOR Upper_Left[4][4], Upper_Right[4][4];    BEZIER_CHILDREN *Children;   BEZIER_VERTICES *Vertices;/   BEZIER_NODE *Node = create_new_bezier_node();   ;   if (depth > max_depth_reached) max_depth_reached = depth;   3   /* Build the bounding sphere for this subpatch */ J   bezier_bounding_sphere(Patch, &(Node->Center), &(Node->Radius_Squared));  G   /* If the patch is close to being flat, then just perform a ray-plane        intersection test. */ "   if (flat_enough(Object, Patch))      { B     /* The patch is now flat enough to simply store the corners */'     Node->Node_Type = BEZIER_LEAF_NODE; ,     Vertices = create_bezier_vertex_block();+     Vertices->Vertices[0] = (*Patch)[0][0]; +     Vertices->Vertices[1] = (*Patch)[0][3]; +     Vertices->Vertices[2] = (*Patch)[3][3]; +     Vertices->Vertices[3] = (*Patch)[3][0];      Vertices->uvbnds[0] = u0;      Vertices->uvbnds[1] = u1;      Vertices->uvbnds[2] = v0;      Vertices->uvbnds[3] = v1; &     Node->Data_Ptr = (void *)Vertices;     } $   else if (depth >= Object->U_Steps)"     if (depth >= Object->V_Steps)        { B       /* We are at the max recursion depth. Just store corners. */)       Node->Node_Type = BEZIER_LEAF_NODE; .       Vertices = create_bezier_vertex_block();-       Vertices->Vertices[0] = (*Patch)[0][0]; -       Vertices->Vertices[1] = (*Patch)[0][3]; -       Vertices->Vertices[2] = (*Patch)[3][3]; -       Vertices->Vertices[3] = (*Patch)[3][0];        Vertices->uvbnds[0] = u0;        Vertices->uvbnds[1] = u1;        Vertices->uvbnds[2] = v0;        Vertices->uvbnds[3] = v1; (       Node->Data_Ptr = (void *)Vertices;       } 	     else         { ?       bezier_split_up_down(Patch, (VECTOR (*)[4][4])Lower_Left, &         (VECTOR (*)[4][4])Upper_Left);-       Node->Node_Type = BEZIER_INTERIOR_NODE; -       Children = create_bezier_child_block();        Children->Children[0] = ?       bezier_tree_builder(Object, (VECTOR (*)[4][4])Lower_Left, .         u0, u1, v0, (v0 + v1) / 2.0, depth+1);       Children->Children[1] = ?       bezier_tree_builder(Object, (VECTOR (*)[4][4])Upper_Left, .         u0, u1, (v0 + v1) / 2.0, v1, depth+1);       Node->Count = 2;(       Node->Data_Ptr = (void *)Children;       } %   else if (depth >= Object->V_Steps)       { @     bezier_split_left_right(Patch, (VECTOR (*)[4][4])Lower_Left,%       (VECTOR (*)[4][4])Lower_Right); +     Node->Node_Type = BEZIER_INTERIOR_NODE; +     Children = create_bezier_child_block();      Children->Children[0] = =     bezier_tree_builder(Object, (VECTOR (*)[4][4])Lower_Left, ,       u0, (u0 + u1) / 2.0, v0, v1, depth+1);     Children->Children[1] = >     bezier_tree_builder(Object, (VECTOR (*)[4][4])Lower_Right,,       (u0 + u1) / 2.0, u1, v0, v1, depth+1);     Node->Count = 2;&     Node->Data_Ptr = (void *)Children;     }    else       { @     bezier_split_left_right(Patch, (VECTOR (*)[4][4])Lower_Left,%       (VECTOR (*)[4][4])Lower_Right); 6     bezier_split_up_down((VECTOR (*)[4][4])Lower_Left,#       (VECTOR (*)[4][4])Lower_Left, $       (VECTOR (*)[4][4])Upper_Left);7     bezier_split_up_down((VECTOR (*)[4][4])Lower_Right, $       (VECTOR (*)[4][4])Lower_Right,%       (VECTOR (*)[4][4])Upper_Right); +     Node->Node_Type = BEZIER_INTERIOR_NODE; +     Children = create_bezier_child_block();      Children->Children[0] = =     bezier_tree_builder(Object, (VECTOR (*)[4][4])Lower_Left,*9       u0, (u0 + u1) / 2.0, v0, (v0 + v1) / 2.0, depth+1);      Children->Children[1] = =     bezier_tree_builder(Object, (VECTOR (*)[4][4])Upper_Left,s9       u0, (u0 + u1) / 2.0, (v0 + v1) / 2.0, v1, depth+1);t     Children->Children[2] =u>     bezier_tree_builder(Object, (VECTOR (*)[4][4])Lower_Right,9       (u0 + u1) / 2.0, u1, v0, (v0 + v1) / 2.0, depth+1);      Children->Children[3] =->     bezier_tree_builder(Object, (VECTOR (*)[4][4])Upper_Right,9       (u0 + u1) / 2.0, u1, (v0 + v1) / 2.0, v1, depth+1);      Node->Count = 4;&     Node->Data_Ptr = (void *)Children;     }r   return Node;   }t  H /* Determine the position and normal at a single coordinate point (u, v)    on a Bezier patch */u6 static void bezier_value(Control_Points, u0, v0, P, N) VECTOR (*Control_Points)[4][4];  DBL u0, v0;t VECTOR *P, *N;   {e   DBL c, t, ut, vt;O   DBL u[4], uu[4], v[4], vv[4];f#   DBL du[4], duu[4], dv[4], dvv[4];    int i, j;y   VECTOR U, V, T;i  B   /* Calculate binomial coefficients times coordinate positions */6   u[0]  = 1.0; uu[0] = 1.0; du[0] = 0.0; duu[0] = 0.0;6   v[0]  = 1.0; vv[0] = 1.0; dv[0] = 0.0; dvv[0] = 0.0;   for (i=1;i<4;i++)      {e     u[i]   = u[i-1] * u0;T"     uu[i]  = uu[i-1] * (1.0 - u0);     v[i]   = v[i-1] * v0;i"     vv[i]  = vv[i-1] * (1.0 - v0);     du[i]  =  i * u[i-1];*     duu[i] = -i * uu[i-1];     dv[i]  =  i * v[i-1];e     dvv[i] = -i * vv[i-1];     }   B   /* Now evaluate position and tangents based on control points */   Make_Vector(P, 0, 0, 0);   Make_Vector(&U, 0, 0, 0);o   Make_Vector(&V, 0, 0, 0);t   for (i=0;i<4;i++)t     for (j=0;j<4;j++)      {i     c = C[i] * C[j];     ut = u[i] * uu[3 - i];     vt = v[j] * vv[3 - j];     t = c * ut * vt;*     VScale(T, (*Control_Points)[i][j], t);     VAddEq(*P, T);5     t = c * vt * (du[i] * uu[3-i] + u[i] * duu[3-i]);a*     VScale(T, (*Control_Points)[i][j], t);     VAddEq(U, T);t5     t = c * ut * (dv[j] * vv[3-j] + v[j] * dvv[3-j]); *     VScale(T, (*Control_Points)[i][j], t);     VAddEq(V, T);L     }E  >   /* Make the normal from the cross product of the tangents */   VCross(*N, U, V);E   VDot(t, *N, *N);   if (t > BEZIER_EPSILON)      {,     t = 1.0 / sqrt(t);     VScaleEq(*N, t);     }t   else     Make_Vector(N, 1, 0, 0)c       }r  B /* Calculate the normal to a subpatch (triangle) return the vector/ <1.0 0.0 0.0> if the triangle is degenerate. */ 1 static int subpatch_normal(v1, v2, v3, Result, d)S VECTOR *v1, *v2, *v3, *Result; DBL *d;L   {r   VECTOR V1, V2;
   DBL Length;C     VSub(V1, *v1, *v2);i   VSub(V2, *v3, *v2);B   VCross(*Result, V1, V2);   VLength(Length, *Result);b   if (Length < BEZIER_EPSILON) [     {V     Result->x = 1.0;     Result->y = 0.0;     Result->z = 0.0;     *d = -1.0 * v1->x;
     return 0;      }L   else L     {A,     VInverseScale(*Result, *Result, Length);     VDot(*d, *Result, *v1);O     *d = 0.0 - *d;
     return 1;      }v   }e  
 static int InvertMatrix(in, out)[ VECTOR in[3], out[3];,   {T   int i;
   DBL det;  6   out[0].x =  (in[1].y * in[2].z - in[1].z * in[2].y);6   out[1].x = -(in[0].y * in[2].z - in[0].z * in[2].y);6   out[2].x =  (in[0].y * in[1].z - in[0].z * in[1].y);  6   out[0].y = -(in[1].x * in[2].z - in[1].z * in[2].x);6   out[1].y =  (in[0].x * in[2].z - in[0].z * in[2].x);6   out[2].y = -(in[0].x * in[1].z - in[0].z * in[1].x);  6   out[0].z =  (in[1].x * in[2].y - in[1].y * in[2].x);6   out[1].z = -(in[0].x * in[2].y - in[0].y * in[2].x);6   out[2].z =  (in[0].x * in[1].y - in[0].y * in[1].x);     det =    in[0].x * in[1].y * in[2].z +L   in[0].y * in[1].z * in[2].x +A   in[0].z * in[1].x * in[2].y -c   in[0].z * in[1].y * in[2].x -O   in[0].x * in[1].z * in[2].y -t   in[0].y * in[1].x * in[2].z;  4   if (det > -BEZIER_EPSILON && det < BEZIER_EPSILON)
     return 0;d     det = 1.0 / det;     for (i=0;i<3;i++)E     VScaleEq(out[i], det)o         return 1;R   }   
 static int< intersect_subpatch(Shape, ray, V, uu, vv, Depth, P, N, u, v) BICUBIC_PATCH *Shape;e	 RAY *ray;e VECTOR V[3]; DBL uu[3], vv[3], *Depth;  VECTOR *P, *N; DBL *u, *v;a   {z"   VECTOR B[3], IB[3], NN[3], Q, T;   DBL d, n, a, b, r;     VSub(B[0], V[1], V[0]);f   VSub(B[1], V[2], V[0]);(   VCross(B[2], B[0], B[1]);o   VDot(d, B[2], B[2]);   if (d < BEZIER_EPSILON) 
     return 0;H   d = 1.0 / sqrt(d);   VScaleEq(B[2], d);     if (!InvertMatrix(B, IB))B     /* Degenerate triangle */B
     return 0;)  !   VDot(d, ray->Direction, IB[2]);r0   if (d > -BEZIER_EPSILON && d < BEZIER_EPSILON)
     return 0;E     VSub(Q, V[0], ray->Initial);   VDot(n, Q, IB[2]);   *Depth = n / d;_    if (*Depth < BEZIER_TOLERANCE)
     return 0;1$   VScale(T, ray->Direction, *Depth);   VAdd(*P, ray->Initial, T);   VSub(Q, *P, V[0]);     VDot(a, Q, IB[0]);   VDot(b, Q, IB[1]);)   if (a < 0.0 || b < 0.0 || a + b > 1.0) i
     return 0;N     r = 1.0 - a - b;      Make_Vector(N, 0.0, 0.0, 0.0);8   bezier_value((VECTOR (*)[4][4])&Shape->Control_Points,     uu[0], vv[0], &T, &NN[0]);8   bezier_value((VECTOR (*)[4][4])&Shape->Control_Points,     uu[1], vv[1], &T, &NN[1]);8   bezier_value((VECTOR (*)[4][4])&Shape->Control_Points,     uu[2], vv[2], &T, &NN[2]);'   VScale(T, NN[0], r); VAdd(*N, *N, T);a'   VScale(T, NN[1], a); VAdd(*N, *N, T);l'   VScale(T, NN[2], b); VAdd(*N, *N, T); )   *u = r * uu[0] + a * uu[1] + b * uu[2]; )   *v = r * vv[0] + a * vv[1] + b * vv[2];    VDot(d, *N, *N);   if (d > BEZIER_EPSILON)      {c     d = 1.0 / sqrt(d);     VScaleEq(*N, d);     }t   else     Make_Vector(N, 1, 0, 0);   return 1;3   }*  I /* Find a sphere that contains all of the points in the list "vectors" */ ? static void find_average(vector_count, vectors, center, radius)  int vector_count;= VECTOR *vectors, *center;  DBL *radius;   {    DBL r0, r1, xc=0, yc=0, zc=0;=   DBL x0, y0, z0;    int i;   for (i=0;i<vector_count;i++) i     {h     xc += vectors[i].x;      yc += vectors[i].y;E     zc += vectors[i].z;e     }=   xc /= (DBL)vector_count;   yc /= (DBL)vector_count;   zc /= (DBL)vector_count;   r0 = 0.0;e   for (i=0;i<vector_count;i++)       {c     x0 = vectors[i].x - xc;[     y0 = vectors[i].y - yc;s     z0 = vectors[i].z - zc; %     r1 = x0 * x0 + y0 * y0 + z0 * z0;c     if (r1 > r0) r0 = r1;      }s1   center->x = xc; center->y = yc; center->z = zc;    *radius = r0;a   }=  6 static int spherical_bounds_check(Ray, center, radius)	 RAY *Ray;t VECTOR *center;V DBL radius;4   {e   DBL x, y, z, dist1, dist2;!   x = center->x - Ray->Initial.x;e!   y = center->y - Ray->Initial.y; !   z = center->z - Ray->Initial.z;o    dist1 = x * x + y * y + z * z;   if (dist1 < radius)_:     /* ray starts inside sphere - assume it intersects. */
     return 1;1   else d     {;I     dist2 = x*Ray->Direction.x + y*Ray->Direction.y + z*Ray->Direction.z;      dist2 = dist2 * dist2;.     if (dist2 > 0 && (dist1 - dist2 < radius))       return 1;;     }    return 0;r   }o  I /* Find a sphere that bounds all of the control points of a Bezier patch. F    The values returned are: the center of the bounding sphere, and the2    square of the radius of the bounding sphere. */9 static void bezier_bounding_sphere(Patch, center, radius)b VECTOR (*Patch)[4][4], *center;0 DBL *radius;   {e   DBL r0, r1, xc=0, yc=0, zc=0;4   DBL x0, y0, z0;    int i, j;1   for (i=0;i<4;i++)      {      for (j=0;j<4;j++)        {e       xc += (*Patch)[i][j].x;O       yc += (*Patch)[i][j].y;        zc += (*Patch)[i][j].z;p       }      }>
   xc /= 16.0; 
   yc /= 16.0;=
   zc /= 16.0;e   r0 = 0.0;    for (i=0;i<4;i++)      {l     for (j=0;j<4;j++)        {4!       x0 = (*Patch)[i][j].x - xc;[!       y0 = (*Patch)[i][j].y - yc;l!       z0 = (*Patch)[i][j].z - zc;L'       r1 = x0 * x0 + y0 * y0 + z0 * z0;        if (r1 > r0) r0 = r1;e       }      }i1   center->x = xc; center->y = yc; center->z = zc;    *radius = r0;]   }o  ; /* Precompute grid points and normals for a bezier patch */o# void Precompute_Patch_Values(Shape)  BICUBIC_PATCH *Shape;r   {d   int i, j;    VECTOR Control_Points[16];G   VECTOR (*Patch_Ptr)[4][4] = (VECTOR (*)[4][4]) Shape->Control_Points;u  ;   /* Calculate the bounding sphere for the entire patch. */h%   for (i=0;i<4;i++) for (j=0;j<4;j++)b8     Control_Points[4*i+j] = Shape->Control_Points[i][j];F   find_average(16, &Control_Points[0], &Shape->Bounding_Sphere_Center,$     &Shape->Bounding_Sphere_Radius);     if (Shape->Patch_Type == 0)      return;u   else 0     {/!     if (Shape->Node_Tree != NULL)l,       bezier_tree_deleter(Shape->Node_Tree);<     Shape->Node_Tree = bezier_tree_builder(Shape, Patch_Ptr,       0.0, 1.0, 0.0, 1.0, 0);      return;      }    }>  5 /* Determine the distance from a point to a plane. */t( static DBL point_plane_distance(p, n, d) VECTOR *p, *n; DBL *d;n   {    DBL temp1, temp2;t     VDot(temp1, *p, *n);   temp1 += *d;   VLength(temp2, *n);E&   if (fabs(temp2) < EPSILON) return 0;   temp1 /= temp2;;   return temp1;t   }   
 static intI bezier_subpatch_intersect(ray, Shape, Patch, u0, u1, v0, v1, Depth_Stack)y	 RAY *ray;U BICUBIC_PATCH *Shape;a VECTOR (*Patch)[4][4]; DBL u0, u1, v0, v1;i ISTACK *Depth_Stack;   {[   int cnt = 0;   VECTOR V[3];    DBL u, v, Depth, uu[3], vv[3];   VECTOR P, N;     V[0] = (*Patch)[0][0];   V[1] = (*Patch)[0][3];   V[2] = (*Patch)[3][3];  %   uu[0] = u0; uu[1] = u0; uu[2] = u1;i%   vv[0] = v0; vv[1] = v1; vv[2] = v1;   I   if (intersect_subpatch(Shape, ray, V, uu, vv, &Depth, &P, &N, &u, &v))       {-A     push_normal_entry(Depth, P, N, (OBJECT *)Shape, Depth_Stack);i
     cnt++;     }e     V[1] = V[2];   V[2] = (*Patch)[3][0];   uu[1] = uu[2]; uu[2] = u1;   vv[1] = vv[2]; vv[2] = v0;  I   if (intersect_subpatch(Shape, ray, V, uu, vv, &Depth, &P, &N, &u, &v)) C     { A     push_normal_entry(Depth, P, N, (OBJECT *)Shape, Depth_Stack);t
     cnt++;     }T  
   return cnt;s   }j    C static void bezier_split_left_right(Patch, Left_Patch, Right_Patch)uA VECTOR (*Patch)[4][4], (*Left_Patch)[4][4], (*Right_Patch)[4][4];    { "   VECTOR Temp1[4], Temp2[4], Half;   int i, j;j   for (i=0;i<4;i++)      {_     Temp1[0] = (*Patch)[0][i];4     VHalf(Temp1[1], (*Patch)[0][i], (*Patch)[1][i]);0     VHalf(Half, (*Patch)[1][i], (*Patch)[2][i]);$     VHalf(Temp1[2], Temp1[1], Half);4     VHalf(Temp2[2], (*Patch)[2][i], (*Patch)[3][i]);$     VHalf(Temp2[1], Half, Temp2[2]);(     VHalf(Temp1[3], Temp1[2], Temp2[1]);     Temp2[0] = Temp1[3];     Temp2[3] = (*Patch)[3][i];     for (j=0;j<4;j++)        {g&       (*Left_Patch)[j][i]  = Temp1[j];&       (*Right_Patch)[j][i] = Temp2[j];       }R     }    }d  @ static void bezier_split_up_down(Patch, Bottom_Patch, Top_Patch)A VECTOR (*Patch)[4][4], (*Top_Patch)[4][4], (*Bottom_Patch)[4][4];g   {R"   VECTOR Temp1[4], Temp2[4], Half;   int i, j;V     for (i=0;i<4;i++)      {u     Temp1[0] = (*Patch)[i][0];4     VHalf(Temp1[1], (*Patch)[i][0], (*Patch)[i][1]);0     VHalf(Half, (*Patch)[i][1], (*Patch)[i][2]);$     VHalf(Temp1[2], Temp1[1], Half);4     VHalf(Temp2[2], (*Patch)[i][2], (*Patch)[i][3]);$     VHalf(Temp2[1], Half, Temp2[2]);(     VHalf(Temp1[3], Temp1[2], Temp2[1]);     Temp2[0] = Temp1[3];     Temp2[3] = (*Patch)[i][3];     for (j=0;j<4;j++)        {*'       (*Bottom_Patch)[i][j] = Temp1[j];x'       (*Top_Patch)[i][j]    = Temp2[j];y       }u     }=   }[  G /* See how close to a plane a subpatch is, the patch must have at least[J    three distinct vertices. A negative result from this function indicates;    that a degenerate value of some sort was encountered. */[- static DBL determine_subpatch_flatness(Patch); VECTOR (*Patch)[4][4];   {[   VECTOR vertices[4], n, TempV;e   DBL d, dist, temp1;.   int i, j;L     vertices[0] = (*Patch)[0][0];    vertices[1] = (*Patch)[0][3]; (   VSub(TempV, vertices[0], vertices[1]);   VLength(temp1, TempV);   if (fabs(temp1) < EPSILON)       {(G     /* Degenerate in the V direction for U = 0. This is ok if the other M          two corners are distinct from the lower left corner - I'm sure there1M          are cases where the corners coincide and the middle has good values,uF          but that is somewhat pathalogical and won't be considered. */!     vertices[1] = (*Patch)[3][3]; *     VSub(TempV, vertices[0], vertices[1]);     VLength(temp1, TempV);+     if (fabs(temp1) < EPSILON) return -1.0;,!     vertices[2] = (*Patch)[3][0];)*     VSub(TempV, vertices[0], vertices[1]);     VLength(temp1, TempV);+     if (fabs(temp1) < EPSILON) return -1.0; *     VSub(TempV, vertices[1], vertices[2]);     VLength(temp1, TempV);+     if (fabs(temp1) < EPSILON) return -1.0;      }    else P     {&!     vertices[2] = (*Patch)[3][0];E*     VSub(TempV, vertices[0], vertices[1]);     VLength(temp1, TempV);     if (fabs(temp1) < EPSILON) A       { #       vertices[2] = (*Patch)[3][3];n,       VSub(TempV, vertices[0], vertices[2]);       VLength(temp1, TempV);        if (fabs(temp1) < EPSILON)         return -1.0;,       VSub(TempV, vertices[1], vertices[2]);       VLength(temp1, TempV);        if (fabs(temp1) < EPSILON)         return -1.0;       }r	     else         {,,       VSub(TempV, vertices[1], vertices[2]);       VLength(temp1, TempV);        if (fabs(temp1) < EPSILON)         return -1.0;       }[     }pE   /* Now that a good set of candidate points has been found, find ther&       plane equations for the patch */I   if (subpatch_normal(&vertices[0], &vertices[1], &vertices[2], &n, &d)) *     {+K     /* Step through all vertices and see what the maximum distance from thed$              plane happens to be. */     dist = 0.0;      for (i=0;i<4;i++)        {d       for (j=0;j<4;j++) 	         {,F         temp1 = fabs(point_plane_distance(&((*Patch)[i][j]), &n, &d));         if (temp1 > dist)t           dist = temp1;d	         }c       },     return dist;     }    else t     {t     if (Options & DEBUGGING)         {uH       printf("Subpatch normal failed in determine_subpatch_flatness\n");       fflush(stdout);n       }      return -1.0;     }[   }   % static int flat_enough(Object, Patch)t BICUBIC_PATCH *Object; VECTOR (*Patch)[4][4];   {/   DBL Dist;_  ,   Dist = determine_subpatch_flatness(Patch);   if (Dist < 0.0)o
     return 0; )   else if (Dist < Object->Flatness_Value)0
     return 1;    else
     return 0;s   }   @ static int bezier_subdivider(Ray, Object, Patch, u0, u1, v0, v1, recursion_depth, Depth_Stack)c	 RAY *Ray;  BICUBIC_PATCH *Object; VECTOR (*Patch)[4][4]; DBL u0, u1, v0, v1;l int recursion_depth; ISTACK *Depth_Stack;   {E-   VECTOR Lower_Left[4][4], Lower_Right[4][4]; -   VECTOR Upper_Left[4][4], Upper_Right[4][4];l   VECTOR center;   DBL ut, vt, radius;    int cnt = 0;  M   /* Make sure the ray passes through a sphere bounding the control points of        the patch */2   bezier_bounding_sphere(Patch, &center, &radius);4   if (!spherical_bounds_check(Ray, &center, radius))
     return 0;   G   /* If the patch is close to being flat, then just perform a ray-planei       intersection test. */ !   if (flat_enough(Object, Patch)) H     return bezier_subpatch_intersect(Ray, Object, Patch, u0, u1, v0, v1, 				     Depth_Stack);  )   if (recursion_depth >= Object->U_Steps),+     if (recursion_depth >= Object->V_Steps)dK        return bezier_subpatch_intersect(Ray, Object, Patch, u0, u1, v0, v1,E 					Depth_Stack);	     else         {u?       bezier_split_up_down(Patch, (VECTOR (*)[4][4])Lower_Left, &         (VECTOR (*)[4][4])Upper_Left);       vt = (v1 - v0) / 2.0; I       cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Lower_Left, : 			       u0, u1, v0, vt, recursion_depth+1, Depth_Stack);I       cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Upper_Left, : 			       u0, u1, vt, v1, recursion_depth+1, Depth_Stack);       } /   else if (recursion_depth >= Object->V_Steps) P     {]@     bezier_split_left_right(Patch, (VECTOR (*)[4][4])Lower_Left,%       (VECTOR (*)[4][4])Lower_Right);      ut = (u1 - u0) / 2.0; G     cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Lower_Left, 8 			     u0, ut, v0, v1, recursion_depth+1, Depth_Stack);H     cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Lower_Right,8 			     ut, u1, v0, v1, recursion_depth+1, Depth_Stack);     }S   else t     {n     ut = (u1 - u0) / 2.0;b     vt = (v1 - v0) / 2.0;r@     bezier_split_left_right(Patch, (VECTOR (*)[4][4])Lower_Left,& 			    (VECTOR (*)[4][4])Lower_Right);6     bezier_split_up_down((VECTOR (*)[4][4])Lower_Left,! 			 (VECTOR (*)[4][4])Lower_Left,o# 			 (VECTOR (*)[4][4])Upper_Left) ;-7     bezier_split_up_down((VECTOR (*)[4][4])Lower_Right,f" 			 (VECTOR (*)[4][4])Lower_Right,# 			 (VECTOR (*)[4][4])Upper_Right);;G     cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Lower_Left,,8 			     u0, ut, v0, vt, recursion_depth+1, Depth_Stack);G     cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Upper_Left,d8 			     u0, ut, vt, v1, recursion_depth+1, Depth_Stack);H     cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Lower_Right,8 			     ut, u1, v0, vt, recursion_depth+1, Depth_Stack);H     cnt += bezier_subdivider(Ray, Object, (VECTOR (*)[4][4])Upper_Right,8 			     ut, u1, vt, v1, recursion_depth+1, Depth_Stack);     }I
   return cnt;a   }T  % static void bezier_tree_deleter(Node)  BEZIER_NODE *Node;   {[   BEZIER_CHILDREN *Children;   int i;  =   /* If this is an interior node then continue the descent */]/   if (Node->Node_Type == BEZIER_INTERIOR_NODE) [     { 1     Children = (BEZIER_CHILDREN *)Node->Data_Ptr;      for (i=0;i<Node->Count;i++) 1       bezier_tree_deleter(Children->Children[i]);h     free((void *)Children);      }h0   else if (Node->Node_Type == BEZIER_LEAF_NODE)      {i0     /* Free the memory used for the vertices. */!     free((void *)Node->Data_Ptr);[     };*   /* Free the memory used for the node. */   free((void *)Node);a   }   < static int bezier_tree_walker(Ray, Shape, Node, Depth_Stack)	 RAY *Ray;  BICUBIC_PATCH *Shape;t BEZIER_NODE *Node; ISTACK *Depth_Stack;   {s   BEZIER_CHILDREN *Children;   BEZIER_VERTICES *Vertices;   VECTOR N, P, V[3];    DBL Depth, u, v, uu[3], vv[3];   int i, cnt = 0;a  M   /* Make sure the ray passes through a sphere bounding the control points ofi       the patch */J   if (!spherical_bounds_check(Ray, &(Node->Center), Node->Radius_Squared))
     return 0;l  @   /* If this is an interior node then continue the descent, else)       do a check against the vertices. */[/   if (Node->Node_Type == BEZIER_INTERIOR_NODE) e     {;1     Children = (BEZIER_CHILDREN *)Node->Data_Ptr;p     for (i=0;i<Node->Count;i++)(P       cnt += bezier_tree_walker(Ray, Shape, Children->Children[i], Depth_Stack);     } 0   else if (Node->Node_Type == BEZIER_LEAF_NODE)      { 1     Vertices = (BEZIER_VERTICES *)Node->Data_Ptr;t!     V[0] = Vertices->Vertices[0];h!     V[1] = Vertices->Vertices[1];o!     V[2] = Vertices->Vertices[2];m        uu[0] = Vertices->uvbnds[0];      uu[1] = Vertices->uvbnds[0];      uu[2] = Vertices->uvbnds[1];      vv[0] = Vertices->uvbnds[2];      vv[1] = Vertices->uvbnds[3];      vv[2] = Vertices->uvbnds[3];  A     /* Triangulate this subpatch, then check for intersections in[        the triangles. */L     if (intersect_subpatch(Shape, Ray, V, uu, vv, &Depth, &P, &N, &u, &v)) {C       push_normal_entry(Depth, P, N, (OBJECT *)Shape, Depth_Stack);j       cnt++;       }        V[1] = V[2];!     V[2] = Vertices->Vertices[3];)/     uu[1] = uu[2]; uu[2] = Vertices->uvbnds[1]; /     vv[1] = vv[2]; vv[2] = Vertices->uvbnds[2];t  L     if (intersect_subpatch(Shape, Ray, V, uu, vv, &Depth, &P, &N, &u, &v)) {C       push_normal_entry(Depth, P, N, (OBJECT *)Shape, Depth_Stack);n       cnt++;       }d     }e   else _     {s&     /* This should be a fatal error */     printf("Bad Node type\n");     } 
   return cnt;.   }n  < static int intersect_bicubic_patch0(Ray, Shape, Depth_Stack)	 RAY *Ray;] BICUBIC_PATCH *Shape;c ISTACK *Depth_Stack;   {nC   VECTOR (*Patch)[4][4] = (VECTOR (*)[4][4]) Shape->Control_Points;gD   return bezier_subdivider(Ray, Shape, Patch, 0.0, 1.0, 0.0, 1.0, 0, 			   Depth_Stack);s   }   = int All_Bicubic_Patch_Intersections(Object, Ray, Depth_Stack)w OBJECT *Object;c	 RAY *Ray;  ISTACK *Depth_Stack;   {u   int Found, cnt = 0;s     Found = FALSE;   Ray_Bicubic_Tests++;  0   switch (((BICUBIC_PATCH *)Object)->Patch_Type)   { 
   case 0: P     cnt = intersect_bicubic_patch0(Ray, ((BICUBIC_PATCH *)Object), Depth_Stack);
     break;
   case 1: :     cnt = bezier_tree_walker(Ray, (BICUBIC_PATCH *)Object,; 			     ((BICUBIC_PATCH *)Object)->Node_Tree, Depth_Stack);)
     break;
   default:     Error("Bad patch type\n");   }      if (cnt > 0) {#      Ray_Bicubic_Tests_Succeeded++;r      Found = TRUE;      }     return Found;t   }2  C /* A patch is not a solid, so an inside test doesn't make sense. */L) int Inside_Bicubic_Patch (IPoint, Object)  VECTOR *IPoint;  OBJECT *Object;s   {    return 0;]   }   2 void Bicubic_Patch_Normal (Result, Object, IPoint) OBJECT *Object;; VECTOR *Result, *IPoint;   {O   /* Should never get here! */   Result->x = 1.0;   Result->y = 0.0;   Result->z = 0.0;   }V  - void Translate_Bicubic_Patch (Object, Vector)u OBJECT *Object;r VECTOR *Vector;    { 2   BICUBIC_PATCH *Patch = (BICUBIC_PATCH *) Object;   int i, j;,%   for (i=0;i<4;i++) for (j=0;j<4;j++)OL     VAdd (Patch->Control_Points[i][j], Patch->Control_Points[i][j], *Vector)%       Precompute_Patch_Values(Patch);    }l  * void Rotate_Bicubic_Patch (Object, Vector) OBJECT *Object;[ VECTOR *Vector;    {i   TRANSFORM Trans;  .   Compute_Rotation_Transform (&Trans, Vector);*   Transform_Bicubic_Patch (Object,&Trans);   }p  ) void Scale_Bicubic_Patch (Object, Vector)  OBJECT *Object;  VECTOR *Vector;    {j2   BICUBIC_PATCH *Patch = (BICUBIC_PATCH *) Object;   int i, j;c%   for (i=0;i<4;i++) for (j=0;j<4;j++) *     VEvaluate(Patch->Control_Points[i][j],,       Patch->Control_Points[i][j], *Vector);!   Precompute_Patch_Values(Patch);n   }E    5 /* Inversion of a patch really doesn't make sense. */i" void Invert_Bicubic_Patch (Object) OBJECT *Object;u   {    ;    }   % BICUBIC_PATCH *Create_Bicubic_Patch()t   {_   BICUBIC_PATCH *New;   H   if ((New = (BICUBIC_PATCH *) malloc (sizeof (BICUBIC_PATCH))) == NULL)     MAError ("bicubic patch");  E   INIT_OBJECT_FIELDS(New,BICUBIC_PATCH_OBJECT,&Bicubic_Patch_Methods)t     New->Patch_Type = -1;    New->U_Steps = 0;0   New->V_Steps = 0;t   New->Flatness_Value = 0.0;   New->Node_Tree = NULL;  F   /* NOTE: Control_Points[4][4] is initialized in Parse_Bicubic_Patch.G    Bounding_Sphere_Center,Bounding_Sphere_Radius, Normal_Vector[], and t8    IPoint[] are initialized in Precompute_Patch_Values.   */      return (New);[   },  ! void *Copy_Bicubic_Patch (Object); OBJECT *Object;a   {    BICUBIC_PATCH *New;*
   int i,j;      New = Create_Bicubic_Patch ();  =   /*  Do not do *New = *Old so that Precompute works right */_  :   New->Patch_Type = ((BICUBIC_PATCH *)Object)->Patch_Type;7   New->U_Steps    = ((BICUBIC_PATCH *)Object)->U_Steps;a7   New->V_Steps    = ((BICUBIC_PATCH *)Object)->V_Steps;i%   for (i=0;i<4;i++) for (j=0;j<4;j++)l     New->Control_Points[i][j] 6     = ((BICUBIC_PATCH *)Object)->Control_Points[i][j];  F   New->Flatness_Value     = ((BICUBIC_PATCH *)Object)->Flatness_Value;     Precompute_Patch_Values(New);=     return (New);    }   , void Transform_Bicubic_Patch (Object, Trans) OBJECT *Object;  TRANSFORM *Trans;a   { 2   BICUBIC_PATCH *Patch = (BICUBIC_PATCH *) Object;   int i, j;*  %   for (i=0;i<4;i++) for (j=0;j<4;j++)[/     MTransPoint(&(Patch->Control_Points[i][j]), %       &(Patch->Control_Points[i][j]),e
       Trans);[!   Precompute_Patch_Values(Patch);1   }   # void Destroy_Bicubic_Patch (Object)  OBJECT *Object;_   {v  E   /* Need to add code to free() all malloc'ed memory created for this1      object. */+   free (Object);         } P
JF >( .
HP
JF >. 0.
HQ
0J2F 0>6 .
KT
JF >84G [ 4 B00H! H   C4 B C 2  24 B ; G ; (    kG# ?$  ~!  ^G ^ ~  ( 0 ޴8 @ G{G  #H   v H!&H4  (  Gb#_1H  &J GCG2v@J @  GGGb#_0H#!HJ
  4@@2H  .1&JuH	QBT JF  >? G&H` ĢG