M /****************************************************************************  *                bound.c * 9 *  This module implements the bounding slab calculations. G *  This file was written by Alexander Enzmann.    He wrote the code for J *  POV-Ray's bounding slabs and generously provided us these enhancements.O *  The slab intersection code was further hacked by Eric Haines to speed it up.  * H *  Just so everyone knows where this came from, the code is VERY heavilyC *  based on the slab code from Mark VandeWettering's MTV raytracer. J *  POV-Ray is just joining the crowd of admirers of Mark's contribution to *  the public domain. [ARE]  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment K *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file D *  named POVLEGAL.DOC which should be distributed with this file. IfL *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"      typedef struct {
   int x,y,z ;    }  VECTORI, *pVECTORI ;     typedef struct {   VECTOR slab_num ;    VECTOR slab_den ;    VECTORI nonzero ;    VECTORI positive ;   }  RAYINFO, *pRAYINFO ;     extern FRAME Frame;  extern long Bounds_Threshold;  extern int Use_Slabs;  static int Axis = 0;& static unsigned long maxprimcount = 0;   typedef struct t_qelem {   DBL     q_key;   OBJECT *q_obj;   }  Qelem;  @ static int FindAxis PARAMS((OBJECT **Prims, unsigned long first, unsigned long last)); 2 static COMPOSITE *Create_Composite PARAMS((void));> static int SortAndSplit PARAMS((OBJECT **Root, OBJECT **Prims,A unsigned long *nPrims, unsigned long first, unsigned long last)); F static void PriorityQueueInsert PARAMS((Qelem *Queue, unsigned *Qsize, DBL key, OBJECT *obj)); B static void CheckAndEnqueue PARAMS((Qelem *Queue, unsigned *Qsize,  OBJECT *obj, RAYINFO *rayinfo));F static void PriorityQueueDelete PARAMS((Qelem *Queue, unsigned *Qsize, DBL *key, OBJECT **obj)); < /* QSORT_FUNCT_RET compslabs PARAMS((QSORT_FUNCT_PARAM in_a, QSORT_FUNCT_PARAM in_b)); */  & /* Should move these out of here... */ unsigned long totalQueues = 0;# unsigned long totalQueueResets = 0;  unsigned long nChecked = 0;  unsigned long nEnqueued = 0;   unsigned MAXQUEUE = 512;   METHODS Composite_Methods =    { J   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, Destroy_Composite  };   void Destroy_Composite (Object)  OBJECT *Object;    {    free (Object);   }   % static COMPOSITE *Create_Composite ()    {    COMPOSITE *New;   @   if ((New = (COMPOSITE *) malloc (sizeof (COMPOSITE))) == NULL)     MAError ("composite");  ?   INIT_OBJECT_FIELDS(New, COMPOSITE_OBJECT, &Composite_Methods)      return New;    }    void recompute_bbox(bbox, trans)  BBOX *bbox;  TRANSFORM *trans;    { %   VECTOR lower_left, lengths, corner;    VECTOR mins, maxs;   int i;      lower_left = bbox->Lower_Left;   lengths    = bbox->Lengths; <   Make_Vector(&mins,  BOUND_HUGE,  BOUND_HUGE,  BOUND_HUGE);<   Make_Vector(&maxs, -BOUND_HUGE, -BOUND_HUGE, -BOUND_HUGE);   for (i=1;i<=8;i++)       {      corner = lower_left;,     corner.x += ((i & 1) ? lengths.x : 0.0);,     corner.y += ((i & 2) ? lengths.y : 0.0);,     corner.z += ((i & 4) ? lengths.z : 0.0);)     MTransPoint(&corner, &corner, trans); -     if (corner.x < mins.x) mins.x = corner.x; -     if (corner.x > maxs.x) maxs.x = corner.x; -     if (corner.y < mins.y) mins.y = corner.y; -     if (corner.y > maxs.y) maxs.y = corner.y; -     if (corner.z < mins.z) mins.z = corner.z; -     if (corner.z > maxs.z) maxs.z = corner.z;      }    bbox->Lower_Left = mins;"   VSub(bbox->Lengths, maxs, mins);   }    void# Recompute_Inverse_BBox(bbox, trans)  BBOX *bbox;  TRANSFORM *trans;    { %   VECTOR lower_left, lengths, corner;    VECTOR mins, maxs;   int i;      lower_left = bbox->Lower_Left;   lengths = bbox->Lengths;<   Make_Vector(&mins,  BOUND_HUGE,  BOUND_HUGE,  BOUND_HUGE);<   Make_Vector(&maxs, -BOUND_HUGE, -BOUND_HUGE, -BOUND_HUGE);   for (i=1;i<=8;i++)       {      corner = lower_left;,     corner.x += ((i & 1) ? lengths.x : 0.0);,     corner.y += ((i & 2) ? lengths.y : 0.0);,     corner.z += ((i & 4) ? lengths.z : 0.0);,     MInvTransPoint(&corner, &corner, trans);-     if (corner.x < mins.x) mins.x = corner.x; -     if (corner.x > maxs.x) maxs.x = corner.x; -     if (corner.y < mins.y) mins.y = corner.y; -     if (corner.y > maxs.y) maxs.y = corner.y; -     if (corner.z < mins.z) mins.z = corner.z; -     if (corner.z > maxs.z) maxs.z = corner.z;      }    bbox->Lower_Left = mins;"   VSub(bbox->Lengths, maxs, mins);   }   % QSORT_FUNCT_RET compslabs(in_a, in_b)  QSORT_FUNCT_PARAM in_a;  QSORT_FUNCT_PARAM in_b;    {      OBJECT **a, **b;
   DBL am, bm;      a = (OBJECT **)in_a;   b = (OBJECT **)in_b;     switch (Axis)    { 	   case 0: B     am = 2.0 * (*a)->Bounds.Lower_Left.x + (*a)->Bounds.Lengths.x;B     bm = 2.0 * (*b)->Bounds.Lower_Left.x + (*b)->Bounds.Lengths.x;
     break;	   case 1: B     am = 2.0 * (*a)->Bounds.Lower_Left.y + (*a)->Bounds.Lengths.y;B     bm = 2.0 * (*b)->Bounds.Lower_Left.y + (*b)->Bounds.Lengths.y;
     break;	   case 2: B     am = 2.0 * (*a)->Bounds.Lower_Left.z + (*a)->Bounds.Lengths.z;B     bm = 2.0 * (*b)->Bounds.Lower_Left.z + (*b)->Bounds.Lengths.z;
     break;
   default:%     Error("Bad axis in compslabs\n");    }      if (am < bm)     return -1;   else if (am == bm)
     return 0;    else
     return 1;    }   
 static int FindAxis(Prims, first, last) OBJECT **Prims;  unsigned long first, last;   { 
   BBOX *bbox;    VECTOR mins, maxs;   unsigned long i;   int which;   DBL d = -BOUND_HUGE, e;   9   Make_Vector(&mins, BOUND_HUGE, BOUND_HUGE, BOUND_HUGE); <   Make_Vector(&maxs, -BOUND_HUGE, -BOUND_HUGE, -BOUND_HUGE);     for (i=first;i<last;i++)       {      bbox = &(Prims[i]->Bounds); $     if (bbox->Lower_Left.x < mins.x)"       mins.x = bbox->Lower_Left.x;6     if (bbox->Lower_Left.x + bbox->Lengths.x > maxs.x)"       maxs.x = bbox->Lower_Left.x;$     if (bbox->Lower_Left.y < mins.y)"       mins.y = bbox->Lower_Left.y;6     if (bbox->Lower_Left.y + bbox->Lengths.y > maxs.y)"       maxs.y = bbox->Lower_Left.y;$     if (bbox->Lower_Left.z < mins.z)"       mins.z = bbox->Lower_Left.z;6     if (bbox->Lower_Left.z + bbox->Lengths.z > maxs.z)"       maxs.z = bbox->Lower_Left.z;     }      e = maxs.x - mins.x;
   if (e > d)       {      d = e; which = 0;    }    e = maxs.y - mins.y;
   if (e > d)       {      d = e; which = 1;    }    e = maxs.z - mins.z;
   if (e > d)       {      d = e; which = 2;    }      return which;    }   
 static int. SortAndSplit(Root, Prims, nPrims, first, last) OBJECT **Root; OBJECT **Prims;  unsigned long *nPrims; unsigned long first; unsigned long last;    {    COMPOSITE *cd;   unsigned long size, i, j, m;   DBL dmin, dmax, tmin, tmax;   &   Axis = FindAxis(Prims, first, last);   size = last - first;  F   /* Actually, we could do this faster in several ways. we could use aH       logn algorithm to find the median along the given axis, and then a?       linear algorithm to partition along the axis. Oh well. */   J   qsort((char *) (Prims + first), (int)size, sizeof(OBJECT *), compslabs);     if (size <= BUNCHING_FACTOR)       {      cd = Create_Composite();'     cd->Entries = (unsigned short)size;        for (i=0;i<size;i++) *       {*&       cd->Objects[i] = Prims[first+i];       /*A printf("Extent of object %ld/%d: <%g, %g, %g> -> <%g, %g, %g>\n",o%        first+i, cd->Objects[i]->Type,e+        cd->Objects[i]->Bounds.Lower_Left.x,e+        cd->Objects[i]->Bounds.Lower_Left.y,n+        cd->Objects[i]->Bounds.Lower_Left.z, N        cd->Objects[i]->Bounds.Lower_Left.x + cd->Objects[i]->Bounds.Lengths.x,N        cd->Objects[i]->Bounds.Lower_Left.y + cd->Objects[i]->Bounds.Lengths.y,O        cd->Objects[i]->Bounds.Lower_Left.z + cd->Objects[i]->Bounds.Lengths.z);i */       }g  (     /* Check bounds in each direction */      /* First along the x axis */*     dmin = BOUND_HUGE; dmax = -BOUND_HUGE;     for (j=0;j<size;j++) s       {V1       tmin = cd->Objects[j]->Bounds.Lower_Left.x;-5       tmax = tmin + cd->Objects[j]->Bounds.Lengths.x;o#       if (tmin < dmin) dmin = tmin;e#       if (tmax > dmax) dmax = tmax;n       }-#     cd->Bounds.Lower_Left.x = dmin;o'     cd->Bounds.Lengths.x = dmax - dmin;e       /* Now along the y axis */*     dmin = BOUND_HUGE; dmax = -BOUND_HUGE;     for (j=0;j<size;j++)         {l1       tmin = cd->Objects[j]->Bounds.Lower_Left.y;e5       tmax = tmin + cd->Objects[j]->Bounds.Lengths.y;o#       if (tmin < dmin) dmin = tmin;V#       if (tmax > dmax) dmax = tmax;a       }i#     cd->Bounds.Lower_Left.y = dmin; '     cd->Bounds.Lengths.y = dmax - dmin;m  !     /* Lastly along the z axis */s*     dmin = BOUND_HUGE; dmax = -BOUND_HUGE;     for (j=0;j<size;j++) e       {i1       tmin = cd->Objects[j]->Bounds.Lower_Left.z;05       tmax = tmin + cd->Objects[j]->Bounds.Lengths.z; #       if (tmin < dmin) dmin = tmin;*#       if (tmax > dmax) dmax = tmax;*       } #     cd->Bounds.Lower_Left.z = dmin;r'     cd->Bounds.Lengths.z = dmax - dmin;        *Root = (OBJECT *)cd; !     if (*nPrims <= maxprimcount)         { $       Prims[*nPrims] = (OBJECT *)cd;       *nPrims += 1;r       return 1;o       }      else%       Error("Too many primitives\n");e     }e   else o     {r     m = (first + last) / 2;s0     SortAndSplit(Root, Prims, nPrims, first, m);0     SortAndSplit(Root, Prims, nPrims, m , last);
     return 0;B     }_   return -1;   }      void   BuildBoundingSlabs(Root)     OBJECT **Root;   {s    OBJECT **Prims, **prim, *head;   unsigned long nPrims;i   unsigned long low, high;  J   /* We have to start by counting how many frame level object there are */   head   = Frame.Objects;n
   nPrims = 0;    while (head != NULL) u     { 
     nPrims++;Q     head = head->Sibling;      }J  H   /* The total # of prims inflates around 150% when bounding objects areH       generated.  If the 1.8 below proves to be too small, use 2.0.  The!       inflation is never 200%. */,5   maxprimcount = (unsigned long)(1.8 * (nPrims + 1));a  F   /* Now allocate an array to hold references to these prims & any new)      composite objects we may generate */lG   Prims = (OBJECT **)malloc((unsigned)maxprimcount * sizeof(OBJECT *));    if (Prims == NULL)F     Error("Failed to allocate bounding slab reference information\n");  3   /* Copy pointers to the objects into the array */    prim = Prims; 9   for (head=Frame.Objects;head!=NULL;head=head->Sibling)       {**     if (head->Type & LIGHT_SOURCE_OBJECT)        {OB       /* Only bother with lights if they have an attached shape */3       if (((LIGHT_SOURCE *)head)->Children != NULL) 3         *prim++ = ((LIGHT_SOURCE *)head)->Children;w
       else         nPrims--;M       }      else6       /* Normal sort of object - add it to the list */       *prim++ = head;a     }   F   /* Now do a sort on the objects, with the end result being a tree of2       objects sorted along the x, y, and z axes */   low  = 0;s   high = nPrims;=   while (SortAndSplit(Root, Prims, &nPrims, low, high) == 0) m     {O     low  = high;     high = nPrims;     }i  +   Use_Slabs = (nPrims >= Bounds_Threshold);;     /* Test */   /*9 printf("Extent of scene: <%g, %g, %g> -> <%g, %g, %g>\n",s$        (*Root)->Bounds.Lower_Left.x,$        (*Root)->Bounds.Lower_Left.y,$        (*Root)->Bounds.Lower_Left.z,@        (*Root)->Bounds.Lower_Left.x + (*Root)->Bounds.Lengths.x,@        (*Root)->Bounds.Lower_Left.y + (*Root)->Bounds.Lengths.y,A        (*Root)->Bounds.Lower_Left.z + (*Root)->Bounds.Lengths.z);m */  ?   /* Now we can get rid of the Prim array, and just use Root */z   free(Prims);   }o   static void;+ PriorityQueueInsert(Queue, Qsize, key, obj) 
 Qelem *Queue;_ unsigned *Qsize; DBL key; OBJECT *obj;   {F   unsigned size;   int i;   Qelem tmp;     totalQueues++;
   (*Qsize)++;x   size = *Qsize;5   /* if (size > maxQueueSize) maxQueueSize = size; */h   if (size >= MAXQUEUE) %     Error("Priority queue overflow");    Queue[size].q_key = key;   Queue[size].q_obj = obj;     i = size;15   while (i > 1 && Queue[i].q_key < Queue[i/2].q_key) n     {      tmp = Queue[i];:     Queue[i] = Queue[i/2];     Queue[i/2] = tmp;;     i = i / 2;     }    }l   static void;+ PriorityQueueDelete(Queue, Qsize, key, obj);
 Qelem *Queue;r unsigned *Qsize;	 DBL *key;x
 OBJECT **obj;n   {>   Qelem tmp;   int i, j;    unsigned size;     if (*Qsize == 0)%     Error("priority queue is empty");x     *key = Queue[1].q_key;   *obj = Queue[1].q_obj;   Queue[1] = Queue[*Qsize];>
   (*Qsize)--;    size = *Qsize;  	   i = 1 ;o     while (2 * i <= (int)size) n     {a     if (2 * i == (int)size)C       j = 2 * i;3     else if (Queue[2*i].q_key < Queue[2*i+1].q_key)A       j = 2 * i;     else       j = 2 * i + 1;  )     if (Queue[i].q_key > Queue[j].q_key) *       {        tmp = Queue[i];        Queue[i] = Queue[j];       Queue[j] = tmp;x       i = j;       }.     else       break;     }.   }_   static voidB+ CheckAndEnqueue(Queue, Qsize, obj, rayinfo) 
 Qelem *Queue;- unsigned *Qsize; OBJECT *obj; RAYINFO *rayinfo;    {2   DBL tmin, tmax;o   DBL dmin, dmax ;  
   nChecked++;      if (rayinfo->nonzero.x ) =     {(     if (rayinfo->positive.x )        {e?       dmin = (obj->Bounds.Lower_Left.x - rayinfo->slab_num.x) *.       rayinfo->slab_den.x;C       dmax = dmin + (obj->Bounds.Lengths.x  * rayinfo->slab_den.x);)$       if ( dmax < EPSILON ) return ;       } 	     else l       {e?       dmax = (obj->Bounds.Lower_Left.x - rayinfo->slab_num.x) *T         rayinfo->slab_den.x;$       if ( dmax < EPSILON ) return ;C       dmin = dmax + (obj->Bounds.Lengths.x  * rayinfo->slab_den.x);G       }      if ( dmin > dmax ) return ;B     }G   else H     { >     if ( ( rayinfo->slab_num.x < obj->Bounds.Lower_Left.x ) ||       ( rayinfo->slab_num.x > C       obj->Bounds.Lengths.x + obj->Bounds.Lower_Left.x ) ) return ;m*     dmin = -BOUND_HUGE; dmax = BOUND_HUGE;     }(     if (rayinfo->nonzero.y ) t     {m     if (rayinfo->positive.y )        {;?       tmin = (obj->Bounds.Lower_Left.y - rayinfo->slab_num.y) *r       rayinfo->slab_den.y;C       tmax = tmin + (obj->Bounds.Lengths.y  * rayinfo->slab_den.y);.       } 	     else e       {<?       tmax = (obj->Bounds.Lower_Left.y - rayinfo->slab_num.y) *_         rayinfo->slab_den.y;C       tmin = tmax + (obj->Bounds.Lengths.y  * rayinfo->slab_den.y);n       }fH     /* unwrap the logic - do the dmin and dmax checks only when tmin andB 	  tmax actually affect anything, also try to escape ASAP.  BetterA 	  yet, fold the logic below into the two branches above so as to  	  compute only what is needed.t 	*/tI     /* you might even try tmax < EPSILON first (instead of second) for an            early quick outn 	*/d     if ( tmax < dmax ) n       { #       if ( tmax < EPSILON ) return;n2       /* check bounds only if tmax changes dmax */       if ( tmin > dmin ) r	         { #         if ( tmin > tmax ) return ;l3         /* do this last in case it's not needed! */u         dmin = tmin ;t
         }        else n	         { #         if ( dmin > tmax ) return ;t	         }t1       /* do this last in case it's not needed! */)       dmax = tmax ;t       } 	     else *       {a       if ( tmin > dmin ) I	         { #         if ( tmin > dmax ) return ;;3         /* do this last in case it's not needed! */          dmin = tmin ; F         } /* else nothing needs to happen, since dmin and dmax did not 	       change! */
              g       }\     }    else t     {>9     if (rayinfo->slab_num.y < obj->Bounds.Lower_Left.y ||t       rayinfo->slab_num.y >BA       obj->Bounds.Lengths.y + obj->Bounds.Lower_Left.y ) return ;      }c     if (rayinfo->nonzero.z ) t     {-     if (rayinfo->positive.z )        {-?       tmin = (obj->Bounds.Lower_Left.z - rayinfo->slab_num.z) *.       rayinfo->slab_den.z;C       tmax = tmin + (obj->Bounds.Lengths.z  * rayinfo->slab_den.z);g       } 	     else d       { ?       tmax = (obj->Bounds.Lower_Left.z - rayinfo->slab_num.z) *H         rayinfo->slab_den.z;C       tmin = tmax + (obj->Bounds.Lengths.z  * rayinfo->slab_den.z);.       }t     if ( tmax < dmax )         {t#       if ( tmax < EPSILON ) return;m2       /* check bounds only if tmax changes dmax */       if ( tmin > dmin ) d	         {w#         if ( tmin > tmax ) return ;n3         /* do this last in case it's not needed! */          dmin = tmin ;G
         }        else  	         {j#         if ( dmin > tmax ) return ;c	         }j1       /* do this last in case it's not needed! */b       dmax = tmax ;t       } 	     else n       {d       if ( tmin > dmin ) x	         {a#         if ( tmin > dmax ) return ;L3         /* do this last in case it's not needed! */          dmin = tmin ;lF         } /* else nothing needs to happen, since dmin and dmax did not 	       change! */
                      }=     }    else B     {o9     if (rayinfo->slab_num.z < obj->Bounds.Lower_Left.z ||n       rayinfo->slab_num.z >iA       obj->Bounds.Lengths.z + obj->Bounds.Lower_Left.z ) return ;      }o  /   PriorityQueueInsert(Queue, Qsize, dmin, obj);z   nEnqueued++;   }    int ; Bounds_Intersect(Root, ray, Best_Intersection, Best_Object) 
 OBJECT *Root;n	 RAY *ray;B  INTERSECTION *Best_Intersection; OBJECT **Best_Object;    {    Qelem *Queue;o   unsigned Qsize = 0;n   int i;   OBJECT *cobj;    COMPOSITE *cdp;+   RAYINFO rayinfo;
   DBL t, key;,    INTERSECTION New_Intersection;   int Intersection_Found = 0;   4   Queue = (Qelem *)malloc(MAXQUEUE * sizeof(Qelem));   if (Queue == NULL)1     Error("Failed to allocate priority queue\n");*  1   /* Create the direction vectors for this ray */n&   rayinfo.slab_num.x = ray->Initial.x;&   rayinfo.slab_num.y = ray->Initial.y;&   rayinfo.slab_num.z = ray->Initial.z;=   if ( rayinfo.nonzero.x = ((t = ray->Direction.x) != 0.0) )       {+!     rayinfo.slab_den.x = 1.0 / t; 5     rayinfo.positive.x = ( ray->Direction.x > 0.0 ) ;e     }i=   if ( rayinfo.nonzero.y = ((t = ray->Direction.y) != 0.0) )       {l!     rayinfo.slab_den.y = 1.0 / t;s5     rayinfo.positive.y = ( ray->Direction.y > 0.0 ) ;*     }s=   if ( rayinfo.nonzero.z = ((t = ray->Direction.z) != 0.0) ) e     {s!     rayinfo.slab_den.z = 1.0 / t;w5     rayinfo.positive.z = ( ray->Direction.z > 0.0 ) ;e     }i  *   /* start with an empty priority queue */   Qsize = 0;   totalQueueResets++;o  2   CheckAndEnqueue(Queue, &Qsize, Root, &rayinfo );  
   for (;;)     {      if (Qsize == 0)        break;  4     PriorityQueueDelete(Queue, &Qsize, &key, &cobj);  '     if (key > Best_Intersection->Depth)U       break;     else'       if (cobj->Type & BOUNDING_OBJECT)h	         {c          cdp = (COMPOSITE *)cobj;6         for (i=0;(unsigned short)i < cdp->Entries;i++)9           CheckAndEnqueue(Queue, &Qsize, cdp->Objects[i],-             &rayinfo) ; 	         }a
       else	         {i7         if (Intersection(&New_Intersection, cobj, ray))N@           if (New_Intersection.Depth < Best_Intersection->Depth)
             {o2             *Best_Intersection = New_Intersection;              *Best_Object = cobj;&             Intersection_Found = TRUE;
             } 	         }g     }      free(Queue);   return Intersection_Found;   }u