M /****************************************************************************  *                vaxconf.h * I *  This header file contains all constants and types required to run on a - *  VAX/VMS 5.3 and OpenVMS for Alpha systems.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment K *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file D *  named POVLEGAL.DOC which should be distributed with this file. IfL *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/  E /* Below are several defines needed by the generic parts of POV.  You 6 *   may redefine them as needed in this config.h file. * H *   The following constants are needed by various POV modules.  Each hasL *   a default (shown below) which is will be defined in frame.h if you don't *   define them here.  * G *   #define EPSILON 1.0e-10               - a small value used for POLY D *   #define FILE_NAME_LENGTH 150          - default file name length? *   #define HUGE_VAL 1.0e+17              - a really big number S *   #define DBL_FORMAT_STRING "%lf"       - the string to use for scanfs of doubles A *   #define DEFAULT_OUTPUT_FORMAT  'd'    - the default +f format R *   #define RED_RAW_FILE_EXTENSION ".red" - for +fr, this is the extension for the4 *                                           red fileG *   #define GREEN_RAW_FILE_EXTENSION ".grn"  - ditto for the green file L *   #define BLUE_RAW_FILE_EXTENSION ".blu"   - ditto again for the blue fileN *   #define FILENAME_SEPARATOR "/"        - the character that separates names6 *                                           in a path.Q *   #define CASE_SENSITIVE_DEFAULT 2     - controls case sensitivity in DAT files I *   #define READ_FILE_STRING "rb"        - special binary (raw, uncooked) ; *   #define WRITE_FILE_STRING "wb"         modes of fopen() # *   #define APPEND_FILE_STRING "ab" R *   #define NORMAL '0'                   - machine-specific PaletteOption settings *   #define GREY   'G' * L *   These routines are required by POV to compute trace times.  The defaultsL *   shown below are defined in most versions of C.  You may redefine them ifK *   your compiler doesn't support these.  If time is completely unsupported  *   define them as 0.  * % *   #define START_TIME time(&tstart); $ *   #define STOP_TIME  time(&tstop);2 *   #define TIME_ELAPSED difftime (tstop, tstart); * N *   Note difftime can be replaced with: #define TIME_ELAPSED (tstop - tstart); *   in some cases. * D *   These are optional routines that POV calls.  You may define them= *   or if undefined they will be defined as empty in frame.h.  * K *   #define STARTUP_POVRAY             - first executable statement of main G *                                           (useful for initialization) c *   #define PRINT_OTHER_CREDITS           - used for people who extend the machine specific modules H *                                           (put your own printf's here)H *   #define TEST_ABORT                    - code to test for ^C or abortB *                                           (called on each pixel)O *   #define FINISH_POVRAY              - last statement before exiting normally C *   #define COOPERATE                    - called for multi-tasking  * J *   These items are standard on some C compilers.  If they are not definedJ *   on your compiler or are called something different you may define your? *   own or use the defaults supplied in frame.h as shown below.  * D *   #define DBL double                    - floating point precision= *   #define ACOS acos                     - arc cosine of DBL > *   #define SQRT sqrt                     - square root of DBLG *   #define POW pow                       - x to the y power - x, y DBL 9 *   #define COS cos                       - cosine of DBL 7 *   #define SIN sin                       - sine of DBL X *   #define labs(x) (long) ((x<0)?-x:x)   - Returns the absolute value of long integer x> *   #define max (x,y) ((x<y)?y:x)         - greater of x and y * G *   On some systems "sprintf" returns the string rather than the length D *   of the string.  If the string is returned, define the following: *   #define STRLN(x) strlen(x) * R *   #define setvbuf(w,x,y,z)              - some systems don't understand setvbuf.N *                                           If not, just define it away - it'sN *                                           not critical to the raytracer.  ItG *                                           just buffers disk accesses. G *   This macro controls prototyping and is required by POV.  Choose one I *   of the two options below or if left undefined it will default to ANSI  *   in frame.h * ? *   #define PARAMS (x) x                  - do ANSI prototyping G *   #define PARAMS (x) ()                 - do K&R non-ANSI prototyping  * G *   These allow command line vs non-command line versions and alternate P *   main routines.  Normally they should be undefined.  Define them 1 if needed. *   #define ALTMAIN 1  *   #define NOCMDLINE 1 5 ****************************************************/   
 #ifdef _STDC_  #define PARAMS(x) x  #else  #define PARAMS(x) () #define volatile #endif   #ifdef ALPHA$ #pragma message disable IMPLICITFUNC #endif   #define EPSILON 1.0e-5  1 /* Need prototypes for these standard routines */ " char *getenv PARAMS((char *name));  char *malloc PARAMS((int size)); void free PARAMS((void *));   % #define MAIN_TYPE                 int $ #define FILENAME_SEPARATOR        ""% #define DEFAULT_OUTPUT_FORMAT     't'   % #define MAIN_RETURN_TYPE          int   % #define WAIT_FOR_KEYPRESS getchar();     #define FINISH_POVRAY \ 1    if (Options & PROMPTEXIT) WAIT_FOR_KEYPRESS; \     return (0) ;    #ifdef XWINDOWS   void XTraceEventHandler (void) ;9 #define COOPERATE                 XTraceEventHandler () ; # #define ALTMAIN                   1  #endif