M /****************************************************************************  *                express.c * J *  This module implements an expression parser for the floats, vectors and& *  colours in scene description files. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"  #include "parse.h"  I /* This file implements a simple recursive-descent parser for reading the  input file.  */    extern DBL Max_Trace_Level;  extern char VerboseFormat; extern unsigned int Options;- extern char Stat_File_Name[FILE_NAME_LENGTH];   5 extern struct Reserved_Word_Struct Reserved_Words [];  extern DBL Antialias_Threshold;   ! extern struct Token_Struct Token; % extern char String[MAX_STRING_INDEX];   ' extern COLOUR_MAP_ENTRY *Build_Entries;  extern FRAME Frame;  extern DBL Clock_Value;  extern char **Symbol_Table;  extern int Max_Intersections;  extern DBL Language_Version;( extern METHODS Csg_Height_Field_Methods;  - static DBL Parse_Float_Factor PARAMS((void)); + static DBL Parse_Float_Term PARAMS((void)); 9 static void Parse_Vector_Factor PARAMS((VECTOR *Vector)); 7 static void Parse_Vector_Term PARAMS((VECTOR *Vector));   7 extern struct Constant_Struct Constants[MAX_CONSTANTS];    extern int Number_Of_Constants;  extern int Previous; extern short Have_Vector;  extern short Not_In_Default;   extern TOKEN *Brace_Stack; extern int Brace_Index;     static DBL Parse_Float_Factor ()   {     DBL Local_Float;   	    EXPECT       CASE (FLOAT_TOKEN) '        Local_Float = Token.Token_Float;         EXIT 
      END_CASE         CASE (FLOAT_ID_TOKEN)4        Local_Float = *((DBL *) Token.Constant_Data);        EXIT 
      END_CASE         CASE (CLOCK_TOKEN) !        Local_Float = Clock_Value;         EXIT 
      END_CASE         CASE (PLUS_TOKEN)
      END_CASE         CASE (DASH_TOKEN),        Local_Float = - Parse_Float_Factor();        EXIT 
      END_CASE         CASE (LEFT_PAREN_TOKEN)#        Local_Float = Parse_Float();         GET(RIGHT_PAREN_TOKEN);        EXIT 
      END_CASE         CASE (VERSION_TOKEN) &        Local_Float = Language_Version;        EXIT 
      END_CASE         OTHERWISE(        Parse_Error_Str ("float factor");
      END_CASE 
    END_EXPECT       return (Local_Float);   }    static DBL Parse_Float_Term ()   {     DBL Local_Float;   &    Local_Float = Parse_Float_Factor();  	    EXPECT       CASE (STAR_TOKEN)+        Local_Float *= Parse_Float_Factor(); 
      END_CASE         CASE (SLASH_TOKEN) +        Local_Float /= Parse_Float_Factor(); 
      END_CASE         OTHERWISE        UNGET        EXIT 
      END_CASE 
    END_EXPECT       return (Local_Float);   }    DBL Parse_Float ()   {     DBL Local_Float;       if (Language_Version < 1.5)"      return(Parse_Float_Factor());  $    Local_Float = Parse_Float_Term();  	    EXPECT       CASE (PLUS_TOKEN))        Local_Float += Parse_Float_Term(); 
      END_CASE         CASE (DASH_TOKEN))        Local_Float -= Parse_Float_Term(); 
      END_CASE         OTHERWISE        UNGET        EXIT 
      END_CASE 
    END_EXPECT       return (Local_Float);   }   ( static void Parse_Vector_Factor (Vector)   VECTOR *Vector;    {   	    EXPECT       CASE (LEFT_ANGLE_TOKEN)        Have_Vector = TRUE;4        Vector -> x = Parse_Float();   Parse_Comma();4        Vector -> y = Parse_Float();   Parse_Comma();#        Vector -> z = Parse_Float();         GET (RIGHT_ANGLE_TOKEN);         EXIT 
      END_CASE         CASE (VECTOR_ID_TOKEN)         Have_Vector = TRUE;3        *Vector = *((VECTOR *) Token.Constant_Data);         EXIT 
      END_CASE         CASE (X_TOKEN)         Have_Vector = TRUE;&        Make_Vector(Vector,1.0,0.0,0.0)        EXIT 
      END_CASE         CASE (Y_TOKEN)         Have_Vector = TRUE;&        Make_Vector(Vector,0.0,1.0,0.0)        EXIT 
      END_CASE         CASE (Z_TOKEN)         Have_Vector = TRUE;&        Make_Vector(Vector,0.0,0.0,1.0)        EXIT 
      END_CASE   5      CASE (PLUS_TOKEN)              /* uniary plus */ 
      END_CASE   6      CASE (DASH_TOKEN)              /* uniary minus */#        Parse_Vector_Factor(Vector);         Vector -> x *= -1.0;         Vector -> y *= -1.0;         Vector -> z *= -1.0;         EXIT 
      END_CASE         CASE (LEFT_PAREN_TOKEN)"        Parse_Vector_Float(Vector);        GET(RIGHT_PAREN_TOKEN);        EXIT 
      END_CASE   D      CASE4 (FLOAT_TOKEN, FLOAT_ID_TOKEN, CLOCK_TOKEN, VERSION_TOKEN)        UNGET        (Vector->x) =        (Vector->y) =+        (Vector->z) = Parse_Float_Factor ();         EXIT 
      END_CASE         OTHERWISE)        Parse_Error_Str ("vector factor"); 
      END_CASE 
    END_EXPECT      }   & static void Parse_Vector_Term (Vector)   VECTOR *Vector;    {     VECTOR Local_Vector;       Parse_Vector_Factor(Vector);   	    EXPECT       CASE (STAR_TOKEN)*        Parse_Vector_Factor(&Local_Vector);#        Vector->x *= Local_Vector.x; #        Vector->y *= Local_Vector.y; #        Vector->z *= Local_Vector.z; 
      END_CASE         CASE (SLASH_TOKEN) *        Parse_Vector_Factor(&Local_Vector);#        Vector->x /= Local_Vector.x; #        Vector->y /= Local_Vector.y; #        Vector->z /= Local_Vector.z; 
      END_CASE         OTHERWISE        UNGET        EXIT 
      END_CASE 
    END_EXPECT      }     void Parse_Vector_Float (Vector)   VECTOR *Vector;    {     VECTOR Local_Vector;       Parse_Vector_Term(Vector);   	    EXPECT       CASE (PLUS_TOKEN)(        Parse_Vector_Term(&Local_Vector);#        Vector->x += Local_Vector.x; #        Vector->y += Local_Vector.y; #        Vector->z += Local_Vector.z; 
      END_CASE         CASE (DASH_TOKEN)(        Parse_Vector_Term(&Local_Vector);#        Vector->x -= Local_Vector.x; #        Vector->y -= Local_Vector.y; #        Vector->z -= Local_Vector.z; 
      END_CASE         OTHERWISE        UNGET        EXIT 
      END_CASE 
    END_EXPECT      }     void Parse_Scale_Vector (Vector)   VECTOR *Vector;    {     Parse_Vector_Float(Vector);      if (Vector->x == 0.0)     {       Vector->x = 1.0; A      Warn("Illegal Value: Scale X by 0.0. Changed to 1.0\n",0.0);      }     if (Vector->y == 0.0)     {       Vector->y = 1.0; A      Warn("Illegal Value: Scale Y by 0.0. Changed to 1.0\n",0.0);      }     if (Vector->z == 0.0)     {       Vector->z = 1.0; A      Warn("Illegal Value: Scale Z by 0.0. Changed to 1.0\n",0.0);      }    }    void Parse_Vector (Vector)   VECTOR *Vector;    {     Have_Vector = FALSE;       if (Language_Version < 1.5)      {"       Parse_Vector_Factor(Vector);      }    else       {"       Parse_Vector_Float (Vector);       if (!Have_Vector) C          Error ("Vector expected but float only expression found");       }   }    void Parse_Colour (Colour)   COLOUR *Colour;    { 	    EXPECT       CASE (COLOUR_ID_TOKEN) 3        *Colour = *((COLOUR *) Token.Constant_Data);         EXIT 
      END_CASE         CASE (RGB_TOKEN)         GET (LEFT_ANGLE_TOKEN);;        (Colour -> Red)   = Parse_Float();    Parse_Comma(); ;        (Colour -> Green) = Parse_Float();    Parse_Comma();*)        (Colour -> Blue)  = Parse_Float();          (Colour -> Filter) = 0.0;        GET (RIGHT_ANGLE_TOKEN);a        EXITf
      END_CASEa        CASE (RGBF_TOKEN)        GET (LEFT_ANGLE_TOKEN);;        (Colour -> Red)   = Parse_Float();    Parse_Comma(); ;        (Colour -> Green) = Parse_Float();    Parse_Comma();-;        (Colour -> Blue)  = Parse_Float();    Parse_Comma();i*        (Colour -> Filter) = Parse_Float();        GET (RIGHT_ANGLE_TOKEN);         EXITh
      END_CASEl        OTHERWISE+        Make_Colour (Colour, 0.0, 0.0, 0.0);h        UNGET        EXIT 
      END_CASEe
    END_EXPECTs  	    EXPECT       CASE (COLOUR_ID_TOKEN) 3        *Colour = *((COLOUR *) Token.Constant_Data);t/        Warn("Previous color overwritten.",1.5);o
      END_CASE         CASE (RED_TOKEN)y'        (Colour -> Red) = Parse_Float();e
      END_CASEs        CASE (GREEN_TOKEN)F)        (Colour -> Green) = Parse_Float(); 
      END_CASEw        CASE (BLUE_TOKEN)(        (Colour -> Blue) = Parse_Float();
      END_CASET        CASE (ALPHA_TOKEN) E        Warn("Keyword ALPHA discontinued.  Use FILTER instead.",1.55);c               CASE (FILTER_TOKEN)*        (Colour -> Filter) = Parse_Float();
      END_CASE*        OTHERWISE        UNGET        EXITe
      END_CASEu
    END_EXPECT    }c   COLOUR_MAP *Parse_Colour_Map ()e   {     COLOUR_MAP *New;s    short Flag;    int i,j,c,p;u      Parse_Begin ();  	    EXPECTe      CASE (COLOUR_MAP_ID_TOKEN)aB        New = Copy_Colour_Map ((COLOUR_MAP *) Token.Constant_Data);        EXIT 
      END_CASE         OTHERWISE        UNGET!        if (Build_Entries == NULL)sE          Build_Entries = Create_CMap_Entries(MAX_COLOUR_MAP_ENTRIES);R
        i = 0; 
        j = 1;A        Flag = FALSE;  
        EXPECTF!          CASE (LEFT_SQUARE_TOKEN)xB            Build_Entries[i].value = Parse_Float();  Parse_Comma();              EXPECT !              CASE (COLOUR_TOKEN);h9                Parse_Colour (&(Build_Entries[i].Colour));t?                Flag |= (Build_Entries[i].Colour.Filter == 0.0);r                i++;R                j++;v                EXIT               END_CASE)
              r              OTHERWISE                UNGET6                Build_Entries[j].value = Parse_Float();  "                GET (COLOUR_TOKEN);9                Parse_Colour (&(Build_Entries[i].Colour));n?                Flag |= (Build_Entries[i].Colour.Filter == 0.0);D  "                GET (COLOUR_TOKEN);9                Parse_Colour (&(Build_Entries[j].Colour)); ?                Flag |= (Build_Entries[j].Colour.Filter == 0.0);                 i += 2;                j += 2;                EXITE              END_CASEC            END_EXPECTc
              k*            if (j > MAX_COLOUR_MAP_ENTRIES)+              Error ("Colour_Map too long");C  $            GET (RIGHT_SQUARE_TOKEN);          END_CASE(            OTHERWISE            UNGET            if (i < 1))B              Error ("Must have at least one color in colour map");  %            /* Eliminate duplicates */C'            for (c = 1, p = 0; c<i; c++)=              {-               if (memcmp(&(Build_Entries[p]),IL                          &(Build_Entries[c]),sizeof(COLOUR_MAP_ENTRY)) == 0)                 p--;  4               Build_Entries[++p] = Build_Entries[c];              }            p++;t&            New = Create_Colour_Map ();&            New->Number_Of_Entries = p;I            New->Colour_Map_Entries = Copy_CMap_Entries (Build_Entries,p); )            New->Transparency_Flag = Flag;             EXIT           END_CASE         END_EXPECTI        EXITC
      END_CASEP
    END_EXPECTr      Parse_End ();      return (New);   }   ( COLOUR_MAP *Parse_Colour_List (MinCount)   int MinCount;    {r    COLOUR_MAP *New;t    short Flag;	    int i;P      if (Build_Entries == NULL) B       Build_Entries = Create_CMap_Entries(MAX_COLOUR_MAP_ENTRIES);	    i = 0;S    Flag = FALSE;  	    EXPECT       CASE (COLOUR_TOKEN);l1        Parse_Colour (&(Build_Entries[i].Colour)); '        Build_Entries[i].value = (DBL)i; 7        Flag |= (Build_Entries[i].Colour.Filter == 0.0);v        i++;t
      END_CASEo
              e      OTHERWISE        UNGET        EXIT_
      END_CASE 
    END_EXPECTr
               "    if (i > MAX_COLOUR_MAP_ENTRIES)        Error ("Too many colors");    F3    /* the follow code assumes MinCount of 2 or 3 */F    )    if (i < MinCount)      {       if (MinCount == 3)	         { =          Make_Colour(&(Build_Entries[2].Colour),1.0,0.0,0.0); &          Build_Entries[2].value = 2.0;	         }        if (i < 2)	         { =          Make_Colour(&(Build_Entries[1].Colour),0.0,1.0,0.0);e&          Build_Entries[1].value = 1.0;	         }S       if (i == 0)T	         { =          Make_Colour(&(Build_Entries[0].Colour),0.0,0.0,1.0); &          Build_Entries[0].value = 0.0;	         }        i=MinCount;r      }      if (i == 0)       return (NULL);         New = Create_Colour_Map ();    New->Number_Of_Entries = i;A    New->Colour_Map_Entries = Copy_CMap_Entries (Build_Entries,i); !    New->Transparency_Flag = Flag;r      return (New);   }    (*b)->Bounds.Lower_Left.x + (*b)->Bounds.Lengths.x;
     break;	   case 1: B     am = 2.0 * (*a)->Bounds.Lower_Left.y + (*a)->Bounds.Lengths.y;B     bm = 2.0 * (*b)->Bounds.Lower_Left.y + (*b)->Bounds.Lengths.y;
     break;	   case 2: B     am = 2.0 * (*a)->Bounds.Lower_Left.z + (*a)->Bounds.Lengths.z;B     bm = 2.0 * (*b)->Bounds.Lower_Left.z + (*b)->Bounds.Lengths.z;
     break;
   default:%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 