M /****************************************************************************  *                   frame.h  * K *  This header file is included by all C modules in POV-Ray. It defines all + *  globally-accessible types and constants.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/  $ /* Generic header for all modules */   #include <math.h>  #include <stdio.h> #include <string.h>  #include <limits.h>  #include "config.h"     A /* These are used by POVRAY.C and the machine specific modules */    #define POV_RAY_VERSION "2.2"   < /* This message is for the personal distribution release. */Z #define DISTRIBUTION_MESSAGE_1 "   This is an unofficial OpenVMS AXP version compiled by:"R #define DISTRIBUTION_MESSAGE_2 "   Fred Kleinsorge, Digital Equipment Corporation"d #define DISTRIBUTION_MESSAGE_3 "   The POV-Ray Team is not responsible for supporting this version."   #ifndef READ_ENV_VAR_BEFORE  #define READ_ENV_VAR_BEFORE  #endif #ifndef READ_ENV_VAR_AFTERu #define READ_ENV_VAR_AFTER if ((Option_String_Ptr = getenv("POVRAYOPT")) != NULL) read_options(Option_String_Ptr);     #endif   #ifndef CONFIG_MATH  #define CONFIG_MATH  #endif   #ifndef EPSILON  #define EPSILON 1.0e-10  #endif   #ifndef FILE_NAME_LENGTH #define FILE_NAME_LENGTH 150 #endif   #ifndef HUGE_VAL #define HUGE_VAL 1.0e+17 #endif   #ifndef BOUND_HUGE #define BOUND_HUGE 1.0e30  #endif   #ifndef DBL_FORMAT_STRING  #define DBL_FORMAT_STRING "%lf"  #endif   #ifndef DEFAULT_OUTPUT_FORMAT ! #define DEFAULT_OUTPUT_FORMAT	'd'  #endif   #ifndef RED_RAW_FILE_EXTENSION% #define RED_RAW_FILE_EXTENSION ".red"  #endif    #ifndef GREEN_RAW_FILE_EXTENSION' #define GREEN_RAW_FILE_EXTENSION ".grn"  #endif   #ifndef BLUE_RAW_FILE_EXTENSION & #define BLUE_RAW_FILE_EXTENSION ".blu" #endif   #ifndef FILENAME_SEPARATOR #define FILENAME_SEPARATOR "/" #endif   /* 0==yes 1==no 2==opt */  #ifndef CASE_SENSITIVE_DEFAULT  #define CASE_SENSITIVE_DEFAULT 0 #endif   #ifndef READ_FILE_STRING #define READ_FILE_STRING "rb"  #endif   #ifndef WRITE_FILE_STRING  #define WRITE_FILE_STRING "wb" #endif   #ifndef APPEND_FILE_STRING #define APPEND_FILE_STRING "ab"  #endif   #ifndef NORMAL #define NORMAL '0' #endif   #ifndef GREY #define GREY   'G' #endif   #ifndef START_TIME& #define START_TIME time(&tstart);      #endif   #ifndef STOP_TIME   #define STOP_TIME  time(&tstop); #endif   #ifndef TIME_ELAPSED. #define TIME_ELAPSED difftime (tstop, tstart); #endif   #ifndef STARTUP_POVRAY #define STARTUP_POVRAY #endif   #ifndef PRINT_OTHER_CREDITS  #define PRINT_OTHER_CREDITS  #endif   #ifndef TEST_ABORT #define TEST_ABORT #endif   #ifndef FINISH_POVRAY  #define FINISH_POVRAY  #endif   #ifndef COOPERATE  #define COOPERATE  #endif   #ifndef DBL  #define DBL double #endif   #ifndef ACOS #define ACOS acos  #endif   #ifndef SQRT #define SQRT sqrt  #endif   #ifndef POW  #define POW pow  #endif   #ifndef COS  #define COS cos  #endif   #ifndef SIN  #define SIN sin  #endif   #ifndef labs# #define labs(x) (long) ((x<0)?-x:x)  #endif   #ifndef max  #define max(x,y) ((x<y)?y:x) #endif  
 #ifndef STRLN  #define STRLN(x) x #endif   #ifndef PARAMS #define PARAMS(x) x  #endif   #ifndef ANSIFUNC #define ANSIFUNC 1 #endif   #ifndef M_PI% #define M_PI 3.1415926535897932384626  #endif   #ifndef TRUE #define TRUE 1 #define FALSE 0  #endif   #ifndef IFF_SWITCH_CAST  #define IFF_SWITCH_CAST (int)  #endif   #ifndef PRINT_CREDITS & #define PRINT_CREDITS print_credits(); #endif   #ifndef PRINT_STATS " #define PRINT_STATS print_stats(); #endif   #ifndef MAX_CONSTANTS  #define MAX_CONSTANTS 1000 #endif   #ifndef WAIT_FOR_KEYPRESS  #define WAIT_FOR_KEYPRESS  #endif  
 #ifndef CDECL 
 #define CDECL  #endif   #ifndef MAX_BUFSIZE  #define MAX_BUFSIZE INT_MAX  #endif  D /* If compiler version is undefined, then make it 'u' for unknown */ #ifndef COMPILER_VER #define COMPILER_VER ".u"  #endif   #ifndef QSORT_FUNCT_RET ! #define QSORT_FUNCT_RET int CDECL  #endif   #ifndef QSORT_FUNCT_PARAM   #define QSORT_FUNCT_PARAM void * #endif   #ifndef MAIN_RETURN_TYPE #define MAIN_RETURN_TYPE void  #endif   #ifndef MAIN_RETURN_STATEMENT  #define MAIN_RETURN_STATEMENT  #endif  ; /* These values determine the minumum and maximum distances .    that qualify as ray-object intersections */ #define Small_Tolerance 0.001  #define Max_Distance 1.0e7  ' typedef struct istk_entry INTERSECTION; $ typedef struct Vector_Struct VECTOR; typedef DBL MATRIX [4][4];( typedef struct Bounding_Box_Struct BBOX;$ typedef struct Colour_Struct COLOUR;1 typedef struct Colour_Map_Entry COLOUR_MAP_ENTRY; , typedef struct Colour_Map_Struct COLOUR_MAP;* typedef struct Transform_Struct TRANSFORM;" typedef struct Image_Struct IMAGE;& typedef struct Texture_Struct TEXTURE;0 typedef struct Material_Texture_Struct MATERIAL;* typedef struct Tiles_Texture_Struct TILES;' typedef struct Pattern_Struct TPATTERN; & typedef struct Pigment_Struct PIGMENT;& typedef struct Tnormal_Struct TNORMAL;$ typedef struct Finish_Struct FINISH;% typedef struct Method_Struct METHODS; $ typedef struct Camera_Struct CAMERA;$ typedef struct Object_Struct OBJECT;* typedef struct Composite_Struct COMPOSITE;$ typedef struct Sphere_Struct SPHERE;& typedef struct Quadric_Struct QUADRIC;  typedef struct Poly_Struct POLY;  typedef struct Disc_Struct DISC;$ typedef struct Cone_Struct CYLINDER;  typedef struct Cone_Struct CONE;0 typedef struct Light_Source_Struct LIGHT_SOURCE;2 typedef struct Bicubic_Patch_Struct BICUBIC_PATCH;( typedef struct Triangle_Struct TRIANGLE;6 typedef struct Smooth_Triangle_Struct SMOOTH_TRIANGLE;" typedef struct Plane_Struct PLANE; typedef struct CSG_Struct CSG; typedef struct Box_Struct BOX;  typedef struct Blob_Struct BLOB; typedef struct Ray_Struct RAY;" typedef struct Frame_Struct FRAME;$ typedef struct istack_struct ISTACK; typedef int TOKEN; typedef int CONSTANT; 0 typedef struct Chunk_Header_Struct CHUNK_HEADER;* typedef struct Data_File_Struct DATA_FILE;% typedef struct complex_block complex; 0 typedef struct Height_Field_Struct HEIGHT_FIELD; typedef short WORD;    struct Vector_Struct   {     DBL x, y, z;    };0 #define Destroy_Vector(x) if ((x)!=NULL) free(x)/ #define Destroy_Float(x) if ((x)!=NULL) free(x)    struct Colour_Struct   {      DBL Red, Green, Blue, Filter;   };  Y #define Make_Colour(c,r,g,b) {(c)->Red=(r);(c)->Green=(g);(c)->Blue=(b);(c)->Filter=0.0;} \ #define Make_ColourA(c,r,g,b,a) {(c)->Red=(r);(c)->Green=(g);(c)->Blue=(b);(c)->Filter=(a);}B #define Make_Vector(v,a,b,c) { (v)->x=(a);(v)->y=(b);(v)->z=(c); }0 #define Destroy_Colour(x) if ((x)!=NULL) free(x)! #define MAX_COLOUR_MAP_ENTRIES 40    struct Colour_Map_Entry    { 
    DBL value;     COLOUR Colour;    };   struct Colour_Map_Struct   { 3    int Number_Of_Entries, Transparency_Flag, Users; (    COLOUR_MAP_ENTRY *Colour_Map_Entries;   };   struct Transform_Struct    {     MATRIX matrix;     MATRIX inverse;   };  3 #define Destroy_Transform(x) if ((x)!=NULL) free(x)   " /* Types for reading IFF files. */G typedef struct {unsigned short Red, Green, Blue, Filter;} IMAGE_COLOUR;    struct Image_Line    { %    unsigned char *red, *green, *blue;    };  % typedef struct Image_Line IMAGE_LINE;    /* Legal image attributes */ #define GIF_FILE   1 #define POT_FILE   2 #define DUMP_FILE  4 #define IFF_FILE   8 #define TGA_FILE  16 #define GRAD_FILE 32  D #define IMAGE_FILE    GIF_FILE+DUMP_FILE+IFF_FILE+GRAD_FILE+TGA_FILED #define NORMAL_FILE   GIF_FILE+DUMP_FILE+IFF_FILE+GRAD_FILE+TGA_FILED #define MATERIAL_FILE GIF_FILE+DUMP_FILE+IFF_FILE+GRAD_FILE+TGA_FILE0 #define HF_FILE       GIF_FILE+POT_FILE+TGA_FILE   struct Image_Struct    {     int Map_Type;    int File_Type;     int Interpolation_Type;    short Once_Flag;     short Use_Colour_Flag;     VECTOR Gradient;     DBL width, height;     int iwidth, iheight;     short Colour_Map_Size;     IMAGE_COLOUR *Colour_Map;	    union       {       IMAGE_LINE *rgb_lines;       unsigned char **map_lines; 
     } data;      };   /* Texture types */  #define PNF_TEXTURE     0  #define TILE_TEXTURE    1  #define MAT_TEXTURE     2   % /* Image/Bump Map projection types */  #define PLANAR_MAP      0  #define SPHERICAL_MAP   1  #define CYLINDRICAL_MAP 2  #define PARABOLIC_MAP   3  #define HYPERBOLIC_MAP  4  #define TORUS_MAP       5  #define PIRIFORM_MAP    6  #define OLD_MAP         7   ! /* Bit map interpolation types */  #define NO_INTERPOLATION 0 #define NEAREST_NEIGHBOR 1 #define BILINEAR         2 #define CUBIC_SPLINE     3 #define NORMALIZED_DIST  4   /* Coloration pigment list */ " #define NO_PIGMENT               0" #define COLOUR_PIGMENT           1" #define BOZO_PIGMENT             2" #define MARBLE_PIGMENT           3" #define WOOD_PIGMENT             4" #define CHECKER_PIGMENT          5" #define SPOTTED_PIGMENT          6" #define AGATE_PIGMENT            7" #define GRANITE_PIGMENT          8" #define GRADIENT_PIGMENT         9" #define IMAGE_MAP_PIGMENT       10# #define PAINTED1_PIGMENT        11  # #define PAINTED2_PIGMENT        12  # #define PAINTED3_PIGMENT        13  # #define ONION_PIGMENT           14  # #define LEOPARD_PIGMENT         15  " #define BRICK_PIGMENT           16" #define MANDEL_PIGMENT          17" #define HEXAGON_PIGMENT         18" #define RADIAL_PIGMENT          19    / /* Normal perturbation (bumpy) texture list  */  #define NO_NORMAL  0 #define WAVES      1 #define RIPPLES    2 #define WRINKLES   3 #define BUMPS      4 #define DENTS      5 #define BUMPY1     6 #define BUMPY2     7 #define BUMPY3     8 #define BUMP_MAP   9   /* Pattern flags */  #define NO_FLAGS      0  #define HAS_FILTER    1  #define FULL_BLOCKING 2  #define HAS_TURB      4  #define POST_DONE     8   G #define TPATTERN_FIELDS int Type, Octaves, Flags; VECTOR Turbulence;  \ F   DBL omega, lambda, Frequency, Phase; IMAGE *Image; TRANSFORM *Trans;  K #define INIT_TPATTERN_FIELDS(p,t) p->Type=t; p->Octaves=6; p->Image=NULL; \ !  p->Frequency=1.0; p->Phase=0.0;\ @  p->Trans=NULL; p->Flags=NO_FLAGS; p->omega=0.5;p->lambda=2.0; \+  Make_Vector(&(p->Turbulence),0.0,0.0,0.0);   = /* This is an abstract structure that is never actually used. @    Pigment and Tnormal are descendents of this primative type */   struct Pattern_Struct    {     TPATTERN_FIELDS   };   struct Pigment_Struct    {     TPATTERN_FIELDS    COLOUR *Colour1;     COLOUR Quick_Colour;     COLOUR_MAP *Colour_Map;    VECTOR Colour_Gradient;     DBL Mortar, Agate_Turb_Scale;7    int Iterations; /* mhs 10/92 for fractal textures */    };   struct Tnormal_Struct    {     TPATTERN_FIELDS    DBL Amount;   };   struct Finish_Struct   { E    DBL Reflection, Ambient, Diffuse, Brilliance, Index_Of_Refraction; :    DBL Refraction, Specular, Roughness, Phong, Phong_Size;
    DBL Crand;     short Metallic_Flag;    };  0 #define Destroy_Finish(x) if ((x)!=NULL) free(x)  J #define TEXTURE_FIELDS unsigned char Type,Flags; TEXTURE *Next_Material; \  TEXTURE *Next_Layer; = #define TRANS_TEXTURE_FIELDS TEXTURE_FIELDS TRANSFORM *Trans;    struct Texture_Struct    {     TEXTURE_FIELDS     PIGMENT *Pigment;    TNORMAL *Tnormal;    FINISH *Finish;   };   struct Tiles_Texture_Struct    {     TRANS_TEXTURE_FIELDS     TEXTURE *Tile1;    TEXTURE *Tile2;   };   struct Material_Texture_Struct   {     TRANS_TEXTURE_FIELDS     TEXTURE *Materials;    IMAGE *Image;    int Num_Of_Mats;    };   /* Object types */! #define BASIC_OBJECT            0 C #define PATCH_OBJECT            1   /* Has no inside, no inverse */ K #define TEXTURED_OBJECT         2   /* Has texture, possibly in children */   5 #define CHILDREN_FLAGS (PATCH_OBJECT+TEXTURED_OBJECT) A                                     /* Reverse inherited flags */   < #define COMPOUND_OBJECT         4   /* Has children field */5 #define STURM_OK_OBJECT         8   /* STRUM legal */ ; #define WATER_LEVEL_OK_OBJECT  16   /* WATER_LEVEL legal */ H #define LIGHT_SOURCE_OBJECT    32   /* link me in frame.light_sources */M #define BOUNDING_OBJECT        64   /* This is a holder for bounded object */ 6 #define SMOOTH_OK_OBJECT      128   /* SMOOTH legal */E #define IS_CHILD_OBJECT       256   /* Object is inside a COMPOUND */ J #define DOUBLE_ILLUMINATE     512   /* Illuminate both sides of surface toB                                        avoid normal purturb bug */  0 #define COMPOSITE_OBJECT       (BOUNDING_OBJECT)- #define SPHERE_OBJECT          (BASIC_OBJECT) - #define PLANE_OBJECT           (BASIC_OBJECT) - #define QUADRIC_OBJECT         (BASIC_OBJECT) - #define BOX_OBJECT             (BASIC_OBJECT) - #define CONE_OBJECT            (BASIC_OBJECT) - #define DISC_OBJECT            (BASIC_OBJECT) T #define HEIGHT_FIELD_OBJECT    (BASIC_OBJECT+WATER_LEVEL_OK_OBJECT+SMOOTH_OK_OBJECT)- #define TRIANGLE_OBJECT        (PATCH_OBJECT) ? #define SMOOTH_TRIANGLE_OBJECT (PATCH_OBJECT+DOUBLE_ILLUMINATE) ? #define BICUBIC_PATCH_OBJECT   (PATCH_OBJECT+DOUBLE_ILLUMINATE) 0 #define UNION_OBJECT           (COMPOUND_OBJECT)0 #define MERGE_OBJECT           (COMPOUND_OBJECT)0 #define INTERSECTION_OBJECT    (COMPOUND_OBJECT)0 #define CUBIC_OBJECT           (STURM_OK_OBJECT)0 #define QUARTIC_OBJECT         (STURM_OK_OBJECT)0 #define POLY_OBJECT            (STURM_OK_OBJECT)0 #define BLOB_OBJECT            (STURM_OK_OBJECT)Q #define LIGHT_OBJECT           (COMPOUND_OBJECT+PATCH_OBJECT+LIGHT_SOURCE_OBJECT)   K typedef int (*ALL_INTERSECTIONS_METHOD)PARAMS((OBJECT *, RAY *, ISTACK *)); 9 typedef int (*INSIDE_METHOD)PARAMS((VECTOR *, OBJECT *)); D typedef void (*NORMAL_METHOD)PARAMS((VECTOR *, OBJECT *, VECTOR *));/ typedef void *(*COPY_METHOD)PARAMS((OBJECT *)); = typedef void (*TRANSLATE_METHOD)PARAMS((OBJECT *, VECTOR *)); : typedef void (*ROTATE_METHOD)PARAMS((OBJECT *, VECTOR *));9 typedef void (*SCALE_METHOD)PARAMS((OBJECT *, VECTOR *)); @ typedef void (*TRANSFORM_METHOD)PARAMS((OBJECT *, TRANSFORM *));0 typedef void (*INVERT_METHOD)PARAMS((OBJECT *));1 typedef void (*DESTROY_METHOD)PARAMS((OBJECT *));    struct Method_Struct   { 5    ALL_INTERSECTIONS_METHOD All_Intersections_Method;     INSIDE_METHOD Inside_Method;     NORMAL_METHOD Normal_Method;     COPY_METHOD Copy_Method; %    TRANSLATE_METHOD Translate_Method;     ROTATE_METHOD Rotate_Method;     SCALE_METHOD Scale_Method; %    TRANSFORM_METHOD Transform_Method;     INVERT_METHOD Invert_Method; !    DESTROY_METHOD Destroy_Method;    };  V #define All_Intersections(x,y,z) ((*((x)->Methods->All_Intersections_Method)) (x,y,z))< #define Inside(x,y) ((*((y)->Methods->Inside_Method)) (x,y))@ #define Normal(x,y,z) ((*((y)->Methods->Normal_Method)) (x,y,z))4 #define Copy(x) ((*((x)->Methods->Copy_Method)) (x))B #define Translate(x,y) ((*((x)->Methods->Translate_Method)) (x,y)): #define Scale(x,y) ((*((x)->Methods->Scale_Method)) (x,y))< #define Rotate(x,y) ((*((x)->Methods->Rotate_Method)) (x,y))B #define Transform(x,y) ((*((x)->Methods->Transform_Method)) (x,y))8 #define Invert(x) ((*((x)->Methods->Invert_Method)) (x)): #define Destroy(x) ((*((x)->Methods->Destroy_Method)) (x))  0 #define Destroy_Camera(x) if ((x)!=NULL) free(x)   struct Camera_Struct   {     VECTOR Location;     VECTOR Direction;
    VECTOR Up;     VECTOR Right;    VECTOR Sky;   };   struct Bounding_Box_Struct {    VECTOR Lower_Left, Lengths;    };   , /* These fields are common to all objects */   #define OBJECT_FIELDS \C  METHODS *Methods;\I  int Type;\   OBJECT *Sibling;\  TEXTURE *Texture;\n  OBJECT *Bound;\  OBJECT *Clip;\s  BBOX Bounds;\  short No_Shadow_Flag;  5 /* These fields are common to all compound objects */- #define COMPOUND_FIELDS \-  OBJECT_FIELDS \  OBJECT *Children;  " #define INIT_OBJECT_FIELDS(o,t,m)\:  o->Type=t;o->Methods= m;o->Sibling=NULL;o->Texture=NULL;\5  o->Bound=NULL;o->Clip=NULL;o->No_Shadow_Flag=FALSE;\ Q  Make_Vector(&o->Bounds.Lower_Left, -BOUND_HUGE/2, -BOUND_HUGE/2, -BOUND_HUGE/2)\sD  Make_Vector(&o->Bounds.Lengths, BOUND_HUGE, BOUND_HUGE, BOUND_HUGE)  = /* This is an abstract structure that is never actually used.t>    All other objects are descendents of this primative type */   struct Object_Struct   {a    OBJECT_FIELDS   };   struct CSG_StructF   {     COMPOUND_FIELDS   };   struct Light_Source_Struct   {     COMPOUND_FIELDS    COLOUR Colour;r*    VECTOR Center, Points_At, Axis1, Axis2;    DBL Coeff, Radius, Falloff;#    LIGHT_SOURCE *Next_Light_Source;w7    unsigned char Light_Type, Area_Light, Jitter, Track;*!    int    Area_Size1, Area_Size2;*    int    Adaptive_Level;*    COLOUR **Light_Grid;e     OBJECT *Shadow_Cached_Object;   };   /* Light source types */ #define POINT_SOURCE     1 #define SPOT_SOURCE      2   #define BUNCHING_FACTOR 4y struct Composite_Struct    {f    OBJECT_FIELDS    unsigned short int Entries;$    OBJECT *Objects[BUNCHING_FACTOR];   };   struct Sphere_Struct   {I    OBJECT_FIELDS    TRANSFORM *Trans; i    VECTOR  Center;    DBL     Radius;    DBL     Radius_Squared;    DBL     Inverse_Radius;    VECTOR  CMOtoC;    DBL     CMOCSquared;I(    short   CMinside, CMCached, Inverted;   };   struct Quadric_Structv   {n    OBJECT_FIELDS    VECTOR  Square_Terms;    VECTOR  Mixed_Terms;d    VECTOR  Terms;V    DBL Constant;    DBL CM_Constant;i    short Constant_Cached;e    short Non_Zero_Square_Term;   };   typedef unsigned short HF_val;   typedef struct {    HF_val min_y, max_y;  } HF_BLOCK;n   typedef struct {         float x, z;e         VECTOR normal; } Cached_Normals;I   typedef short HF_Normals[3]; #define HF_CACHE_SIZE 16 #define LOWER_TRI 0f #define UPPER_TRI 1E       struct Height_Field_Struct   {     OBJECT_FIELDS S    TRANSFORM *Trans; M    BOX *bounding_box;f    DBL Block_Size;    DBL Inv_Blk_Size;    HF_BLOCK **Block;    HF_val **Map;    int Inverted;    int cache_pos;n/    Cached_Normals Normal_Vector[HF_CACHE_SIZE];e    int Smoothed;    HF_Normals **Normals;    };E   struct Box_Structd   {     OBJECT_FIELDS L    TRANSFORM *Trans; L    VECTOR bounds[2];    short Inverted;   };   #define MAX_ORDER 15  3 #define STURM_FIELDS  OBJECT_FIELDS int Sturm_Flag;=  F /* Number of coefficients of a three variable polynomial of order x */2 #define term_counts(x) (((x)+1)*((x)+2)*((x)+3)/6)   struct Poly_Struct   {     STURM_FIELDSE    TRANSFORM *Trans;    short Inverted;
    int Order;e    DBL *Coeffs;I   };   struct Disc_Struct {    OBJECT_FIELDS:    TRANSFORM *Trans; /* Transformation of a Disc object */-    VECTOR center;    /* Center of the disc */EM    VECTOR normal;    /* Direction perpendicular to the disc (plane normal) */ B    DBL d;            /* The constant part of the plane equation */K    DBL iradius2;     /* Distance from center to inner circle of the disc */nK    DBL oradius2;     /* Distance from center to outer circle of the disc */_    short Inverted;    };    struct Cone_Struct {    OBJECT_FIELDS<    TRANSFORM *Trans;   /* Transformation of a Cone object */:    short int cyl_flag; /* Is this a cone or a cylinder? */K    short int closed;   /* Currently unused - for making caps on the cone */n:    VECTOR apex;        /* Center of the top of the cone */=    VECTOR base;        /* Center of the bottom of the cone */ :    DBL apex_radius;    /* Radius of the cone at the top */=    DBL base_radius;    /* Radius of the cone at the bottom */nH    DBL dist;           /* Distance to end of cone in canonical coords */    short Inverted;    };n  . typedef struct Bezier_Node_Struct BEZIER_NODE;3 typedef struct Bezier_Child_Struct BEZIER_CHILDREN;16 typedef struct Bezier_Vertices_Struct BEZIER_VERTICES;   struct Bezier_Child_Struct   {     BEZIER_NODE *Children[4];   };   struct Bezier_Vertices_Structi   {     float uvbnds[4];n    VECTOR Vertices[4];   };   struct Bezier_Node_StructT   { @    int Node_Type;      /* Is this an interior node, or a leaf */E    VECTOR Center;      /* Center of sphere bounding the (sub)patch */d@    DBL Radius_Squared; /* Radius of bounding sphere (squared) */F    int Count;          /* # of subpatches associated with this node */N    void *Data_Ptr;     /* Either pointer to vertices or pointer to children */   };   #define BEZIER_INTERIOR_NODE 0 #define BEZIER_LEAF_NODE 1   #define MAX_PATCH_TYPE 4   struct Bicubic_Patch_Structn   {S    OBJECT_FIELDS$    int Patch_Type, U_Steps, V_Steps;    VECTOR Control_Points[4][4];d!    VECTOR Bounding_Sphere_Center;f    DBL Bounding_Sphere_Radius;    DBL Flatness_Value;    BEZIER_NODE *Node_Tree;   };    e #define X_AXIS 0 #define Y_AXIS 1 #define Z_AXIS 2   struct Triangle_Struct   {n    OBJECT_FIELDS    VECTOR  Normal_Vector;     DBL     Distance;    DBL     CMNormDotOrigin;E    unsigned int  CMCached:1;!    unsigned int  Dominant_Axis:2;R?    unsigned int  vAxis:2;  /* used only for smooth triangles */u    VECTOR  P1, P2, P3;    short int Degenerate_Flag;r   };   struct Smooth_Triangle_Structl   {a    OBJECT_FIELDS    VECTOR  Normal_Vector;m    DBL     Distance;    DBL     CMNormDotOrigin;G    unsigned int  CMCached:1;!    unsigned int  Dominant_Axis:2;aF    unsigned int  vAxis:2;         /* used only for smooth triangles */    VECTOR  P1, P2, P3;    short int Degenerate_Flag;t    VECTOR  N1, N2, N3, Perp;    DBL  BaseDelta;   };   struct Plane_Structt   {s    OBJECT_FIELDS    VECTOR  Normal_Vector;t    DBL     Distance;    DBL     CMNormDotOrigin;y    int     CMCached;   };   typedef struct {    VECTOR pos;    DBL radius2;y    DBL coeffs[3];_    DBL tcoeffs[5];    } Blob_Element;  . typedef struct blob_list_struct *blobstackptr; struct blob_list_struct {D    Blob_Element elem;n    blobstackptr next;e    };u   typedef struct {    int type, index;t
    DBL bound;L    } Blob_Interval;    struct Blob_Struct    {    STURM_FIELDSy    TRANSFORM *Trans;    short Inverted;
    int count;o    DBL threshold;     Blob_Element **list;     Blob_Interval *intervals; };  ! #define MAX_CONTAINING_OBJECTS 10u   struct Ray_Structy   { 3    VECTOR Initial;               /*  Xo  Yo  Zo  */A3    VECTOR Direction;             /*  Xv  Yv  Zv  */t9    VECTOR Initial_2;             /*  Xo^2  Yo^2  Zo^2  */S9    VECTOR Direction_2;           /*  Xv^2  Yv^2  Zv^2  */y9    VECTOR Initial_Direction;     /*  XoXv  YoYv  ZoZv  */m9    VECTOR Mixed_Initial_Initial; /*  XoYo  XoZo  YoZo  */I9    VECTOR Mixed_Dir_Dir;         /*  XvYv  XvZv  YvZv  */ H    VECTOR Mixed_Init_Dir;        /*  XoYv+XvYo  XoZv+XvZo  YoZv+YvZo  */    int Containing_Index;9    TEXTURE *Containing_Textures [MAX_CONTAINING_OBJECTS]; 0    DBL Containing_IORs [MAX_CONTAINING_OBJECTS];     int Quadric_Constants_Cached;   };   struct Frame_Structc   {l    CAMERA *Camera;#    int Screen_Height, Screen_Width;;    LIGHT_SOURCE *Light_Sources;>    OBJECT *Objects; +    DBL Atmosphere_IOR, Antialias_Threshold;(    DBL Fog_Distance;    COLOUR Fog_Colour;x    COLOUR Background_Colour;   };   #define DISPLAY 1t #define VERBOSE 2r #define DISKWRITE 4e #define PROMPTEXIT 8 #define ANTIALIAS 16 #define DEBUGGING 32 #define RGBSEPARATE 64 #define EXITENABLE 128 #define CONTINUE_TRACE 256 #define VERBOSE_FILE 512 #define JITTER 1024c  & /* Definitions for ISTACK structure */   struct istk_entryn   {t
    DBL Depth;)    VECTOR IPoint;e    VECTOR INormal;
    int NFlag;l    OBJECT *Object;   };   struct istack_struct   {,    struct istack_struct *next;    struct istk_entry *istack;e    unsigned int top_entry;   };  ' #define itop(i) i->istack[i->top_entry] @ #define push_entry(d,v,o,i) itop(i).Depth=d; itop(i).IPoint=v; \0  itop(i).NFlag=0; itop(i).Object=o; incstack(i);I #define push_normal_entry(d,v,n,o,i) itop(i).Depth=d; itop(i).IPoint=v; \_C  itop(i).INormal=n; itop(i).NFlag=1; itop(i).Object=o; incstack(i);_0 #define push_copy(i,e) itop(i)= *e; incstack(i);I #define pop_entry(i) (i->top_entry > 0)?&(i->istack[--i->top_entry]):NULLF   #define MAX_STRING_INDEX 41    struct Reserved_Word_Struct    {     TOKEN Token_Number;    char *Token_Name;   };  N /* Here's where you dump the information on the current token (fm. PARSE.C) */   struct Token_Struct    {i    TOKEN Token_Id;    int Token_Line_No;i    char *Token_String;    DBL Token_Float;     TOKEN Begin_Id;    int Constant_Index;     int Unget_Token, End_Of_File;"    char *Filename, *Constant_Data;   };  C /* Types of constants allowed in DECLARE statement (fm. PARSE.C) */T  ! #define COLOUR_CONSTANT         0c! #define VECTOR_CONSTANT         1 ! #define FLOAT_CONSTANT          2 ! #define PIGMENT_CONSTANT        3 ! #define TNORMAL_CONSTANT        4L! #define FINISH_CONSTANT         5 ! #define TEXTURE_CONSTANT        6f! #define OBJECT_CONSTANT         7p! #define COLOUR_MAP_CONSTANT     8O! #define TRANSFORM_CONSTANT      9E! #define CAMERA_CONSTANT        102   /* CSG types */I$ #define CSG_UNION_TYPE             1$ #define CSG_INTERSECTION_TYPE      2$ #define CSG_DIFFERENCE_TYPE        4$ #define CSG_MERGE_TYPE             8$ #define CSG_SINGLE_TYPE           16   struct Constant_Struct   {n    int Identifier_Number;4    CONSTANT Constant_Type;    char *Constant_Data;_   };   struct Chunk_Header_Struct M   { 
    long name;f
    long size;M   };   struct Data_File_Struct    {T    FILE *File;    char *Filename;    int Line_Number;A   };   struct complex_block f   {A    DBL r, c;   };   #define READ_MODE 03 #define WRITE_MODE 1 #define APPEND_MODE 2    struct file_handle_struct    {N    char *filename;
    int  mode;N    int width, height;     int buffer_size;     char *buffer;    FILE *file;/    char *(*Default_File_Name_p) PARAMS((void));*A    int  (*Open_File_p) PARAMS((struct file_handle_struct *handle,0: 		   char *name, int *width, int *height, int buffer_size, 		   int mode));B    void (*Write_Line_p) PARAMS((struct file_handle_struct *handle,* 		   COLOUR *line_data, int line_number));A    int  (*Read_Line_p) PARAMS((struct file_handle_struct *handle, + 		   COLOUR *line_data, int *line_number));d?    void (*Read_Image_p) PARAMS((IMAGE *Image, char *filename));ED    void (*Close_File_p) PARAMS((struct file_handle_struct *handle));   };  . typedef struct file_handle_struct FILE_HANDLE;  ? #define Default_File_Name(h) ((*((h)->Default_File_Name_p)) ())pJ #define Open_File(h,n,wd,ht,sz,m) ((*((h)->Open_File_p)) (h,n,wd,ht,sz,m))< #define Write_Line(h,l,n) ((*((h)->Write_Line_p)) (h, l, n)): #define Read_Line(h,l,n) ((*((h)->Read_Line_p)) (h, l, n))7 #define Read_Image(h,i) ((*((h)->Read_Image_p)) (h, i))a2 #define Close_File(h) ((*((h)->Close_File_p)) (h))     #define Q_FULL_AMBIENT 1 #define Q_QUICKC       2 #define Q_SHADOW       4 #define Q_AREA_LIGHT   8 #define Q_REFRACT     16 #define Q_REFLECT     32 #define Q_NORMAL      64  ) #define QUALITY_0 Q_QUICKC+Q_FULL_AMBIENTc #define QUALITY_1 QUALITY_0h* #define QUALITY_2 QUALITY_1-Q_FULL_AMBIENT #define QUALITY_3 QUALITY_2 $ #define QUALITY_4 QUALITY_3+Q_SHADOW( #define QUALITY_5 QUALITY_4+Q_AREA_LIGHT. #define QUALITY_6 QUALITY_5-Q_QUICKC+Q_REFRACT #define QUALITY_7 QUALITY_6o. #define QUALITY_8 QUALITY_7+Q_REFLECT+Q_NORMAL #define QUALITY_9 QUALITY_8_ETReT "ST9#Y@ `T  !W  \ ]  }jEUaU  = @,W GJ] ( ݅mUU(  /W G]0 0@ET"V?#0 P # d  DLU A1TBOUb  =lVAV( 0 V  DRRV dSsV TVSVTVueZk  D d b@T "  c`T  DdT d G8 ]@ ]H }P X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 