M /****************************************************************************  *                   gifdecod.c *  *  GIF-style LZW decoder.  * L *  NOTE:  Portions of this module were written by Steve Bennett and are used# *         here with his permission.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   /*I    This module was freely borrowed from FRACTINT, so here is their entire      copyright to keep them happy: */  % /* DECODER.C - An LZW decoder for GIF +  * Copyright (C) 1987, by Steven A. Bennett   *G  * Permission is given by the author to freely redistribute and include F  * this code in any program as long as this credit is given where due.  *I  * In accordance with the above, I want to credit Steve Wilhite who wrote 0  * the code which this is heavily inspired by...  *?  * GIF and 'Graphics Interchange Format' are trademarks (tm) of 2  * Compuserve, Incorporated, an H&R Block Company.  *E  * Release Notes: This file contains a decoder routine for GIF images L  * which is similar, structurally, to the original routine by Steve Wilhite.;  * It is, however, somewhat noticably faster in most cases.   *>  == This routine was modified for use in FRACTINT in two ways.  == K  == 1) The original #includes were folded into the routine strictly to hold 5  ==    down the number of files we were dealing with.   == J  == 2) The 'stack', 'suffix', 'prefix', and 'buf' arrays were changed fromE  ==    static and 'malloc()'ed to external only so that the assembler E  ==    program could use the same array space for several independent F  ==    chunks of code.  Also, 'stack' was renamed to 'dstack' for TASM  ==    compatibility.   == H  == 3) The 'out_line()' external function has been changed to reference E  ==    '*outln()' for flexibility (in particular, 3D transformations)   == H  == 4) A call to 'keypressed()' has been added after the 'outln()' callsC  ==    to check for the presenc of a key-press as a bail-out signal   == #  == (Bert Tyler and Timothy Wegner)  */   /*  W    This routine was modified for Persistence of Vision Raytracer in the following ways:   J    1)  Removed calls to buzzer() and keypressed() to get rid of ASM files.  I    2)  The dstack, suffix, and prefix arrays were made STATIC once again.   e    3)  Added the usual ANSI function prototypes, etc. in the Persistence of Vision Raytracer headers.  */   #include "frame.h" #include "povproto.h"    #define LOCAL static #define IMPORT extern    #define FAST register    /* typedef short WORD; */  typedef unsigned short UWORD;  typedef char TEXT; typedef unsigned char UTINY; typedef long LONG; typedef unsigned long ULONG; typedef int INT;    & /* Various error codes used by decoder%  * and my own routines...   It's okay '  * for you to define whatever you want, *  * as long as it's negative...  It will be,  * returned intact up the various subroutine  * levels...  */  #define OUT_OF_MEMORY -10  #define BAD_CODE_SIZE -20  #define READ_ERROR -1  #define WRITE_ERROR -2 #define OPEN_ERROR -3  #define CREATE_ERROR -4      /* IMPORT INT get_byte()  *F  *   - This external (machine specific) function is expected to returnC  * either the next byte from the GIF file, or a negative number, as   * defined in ERRS.H.   */  IMPORT INT get_byte();  ' /* IMPORT INT out_line(pixels, linelen)   *     UBYTE pixels[];  *     INT linelen;   *I  *   - This function takes a full line of pixels (one byte per pixel) and H  * displays them (or does whatever your program wants with them...).  ItI  * should return zero, or negative if an error or some other event occurs K  * which would require aborting the decode process...  Note that the length F  * passed will almost always be equal to the line length passed to theJ  * decoder function, with the sole exception occurring when an ending codeJ  * occurs in an odd place in the GIF file...  In any case, linelen will be*  * equal to the number of pixels passed...  */  IMPORT INT out_line();   /* IMPORT INT bad_code_count;   *I  * This value is the only other global required by the using program, and H  * is incremented each time an out of range code is read by the decoder.H  * When this value is non-zero after a decode, your GIF file is probably  * corrupt in some way...   */  INT bad_code_count;    #define MAX_CODES   4095   /* Static variables */E LOCAL WORD curr_size;                     /* The current code size */ F LOCAL WORD clear;                         /* Value for a clear code */G LOCAL WORD ending;                        /* Value for a ending code */ D LOCAL WORD newcodes;                      /* First available code */M LOCAL WORD top_slot;                      /* Highest code for current size */ > LOCAL WORD slot;                          /* Last read code */  * /* The following static variables are used  * for seperating out codes   */ E LOCAL WORD navail_bytes = 0;              /* # bytes left in block */ K LOCAL WORD nbits_left = 0;                /* # bits left in current byte */ < LOCAL UTINY b1;                           /* Current byte */= LOCAL UTINY byte_buff[257];               /* Current block */ M LOCAL UTINY *pbytes;                      /* Pointer to next byte in block */      LOCAL LONG code_mask[13] = {   0,   0x0001, 0x0003,    0x0007, 0x000F,    0x001F, 0x003F,    0x007F, 0x00FF,    0x01FF, 0x03FF,    0x07FF, 0x0FFF   };    A /* This function initializes the decoder for reading a new image.   */  WORD init_exp (i_size) int i_size;    {    WORD size;   size = (WORD)i_size;   curr_size = size + 1;    top_slot = 1 << curr_size;   clear = 1 << size;   ending = clear + 1;    slot = newcodes = ending + 1;     navail_bytes = nbits_left = 0;   return(0);   }    /* get_next_code()E  * - gets the next code from the GIF file.  Returns the code, or else .  * a negative number in case of file errors...  */  WORD get_next_code()   {    WORD i, x;   ULONG ret;     if (nbits_left == 0)     {      if (navail_bytes <= 0)       {   :       /* Out of bytes in current block, so read next block           */       pbytes = byte_buff; *       if ((navail_bytes = get_byte()) < 0)         return(navail_bytes);        else if (navail_bytes)	         { *         for (i = 0; i < navail_bytes; ++i)           { #           if ((x = get_byte()) < 0)              return(x);#           byte_buff[i] = (UTINY) x;            } 	         }        }      b1 = *pbytes++;      nbits_left = 8;      --navail_bytes;      }      ret = b1 >> (8 - nbits_left);     while (curr_size > nbits_left)     {      if (navail_bytes <= 0)       {   :       /* Out of bytes in current block, so read next block           */       pbytes = byte_buff; *       if ((navail_bytes = get_byte()) < 0)         return(navail_bytes);        else if (navail_bytes)	         { *         for (i = 0; i < navail_bytes; ++i)           { #           if ((x = get_byte()) < 0)              return(x);#           byte_buff[i] = (UTINY) x;            } 	         }        }      b1 = *pbytes++;      ret |= b1 << nbits_left;     nbits_left += 8;     --navail_bytes;      }    nbits_left -= curr_size;   ret &= code_mask[curr_size];   return((WORD)(ret));   }*    @ /* The reason we have these seperated like this instead of usingB  * a structure like the original Wilhite code did, is because thisF  * stuff generally produces significantly faster code when compiled...H  * This code is full of similar speedups...  (For a good book on writingF  * C for speed or for space optomisation, see Efficient C by Tom Plum,(  * published by Plum-Hall Associates...)  */i   /*E I removed the LOCAL identifiers in the arrays below and replaced them A with 'extern's so as to declare (and re-use) the space elsewhere.y9 The arrays are actually declared in the assembler source.y>                                                     Bert Tyler */  8 LOCAL UTINY *dstack;      /* Stack for storing pixels */, LOCAL UTINY *suffix;      /* Suffix table */2 LOCAL UWORD *prefix;      /* Prefix linked list */D extern UTINY *decoderline;              /* decoded line goes here */   /* WORD decoder(linewidth)@  *    WORD linewidth;               * Pixels per line of image *  *E  * - This function decodes an LZW image, according to the method usedeH  * in the GIF spec.  Every *linewidth* "characters" (ie. pixels) decodedH  * will generate a call to out_line(), which is a user specific functionA  * to display a line of pixels.  The function gets its codes fromoF  * get_next_code() which is responsible for reading blocks of data andF  * seperating them into the proper size codes.  Finally, get_byte() is>  * the global routine to read the next byte from the GIF file.  *I  * It is generally a good idea to have linewidth correspond to the actual F  * width of a line (as specified in the Image header) to make your own9  * code a bit simpler, but it isn't absolutely necessary.c  *9  * Returns: 0 if successful, else negative.  (See ERRS.H)r  *  */r   void cleanup_gif_decoder() *   {u   free(dstack);e   free(suffix);o   free(prefix);l   }N   WORD decoder (i_linewidth) int i_linewidth;   {a   WORD linewidth;i   FAST UTINY *sp, *bufptr;
   UTINY *buf;e!   FAST WORD code, fc, oc, bufcnt;e   WORD c, size, ret;      linewidth = (WORD)i_linewidth;  +   /* Initialize for decoding a new image...o     */   if ((size = get_byte()) < 0)     return(size);o   if (size < 2 || 9 < size)      return(BAD_CODE_SIZE);8   init_exp((int)size);        /* changed param to int */  ;   dstack = (UTINY *) malloc((MAX_CODES + 1)*sizeof(UTINY));a;   suffix = (UTINY *) malloc((MAX_CODES + 1)*sizeof(UTINY)); ;   prefix = (UWORD *) malloc((MAX_CODES + 1)*sizeof(UWORD));e  ;   /* Initialize in case they forgot to put in a clear code.'D     * (This shouldn't happen, but we'll try and decode it anyway...)     */   oc = fc = 0;     buf = decoderline;     bad_code_count = 0;   7   /* Set up the stack pointer and decode buffer pointer      */   sp = dstack;   bufptr = buf;d   bufcnt = linewidth;l  E   /* This is the main loop.  For each code we get we pass through the L     * linked list of prefix codes, pushing the corresponding "character" forK     * each code onto the stack.  When the list reaches a single "character"RC     * we push that on the stack too, and then start unstacking each E     * character for output in the correct order.  Special handling isnG     * included for the clear code, and the whole thing ends when we gett     * an ending code.r     */)   while ((c = get_next_code()) != ending)p     {   C     /* If we had a file error, return without completing the decodee	        */p     if (c < 0) *       {e       cleanup_gif_decoder();       return(0);       }i  E     /* If the code is a clear code, reinitialize all necessary items.e	        */      if (c == clear)c       {        curr_size = size + 1;t       slot = newcodes;        top_slot = 1 << curr_size;  =       /* Continue reading codes until we get a non-clear codea4           * (Another unlikely, but possible case...)           */,       while ((c = get_next_code()) == clear)	         ;-  @       /* If we get an ending code immediately after a clear codeD           * (Yet another unlikely case), then break out of the loop.           */       if (c == ending)         break;  G       /* Finally, if the code is beyond the range of already set codes, H           * (This one had better NOT happen...  I have no idea what willK           * result from this, but I doubt it will look good...) then set iti           * to color zero.           */       if (c >= slot)         c = 0;         oc = fc = c;  E       /* And let us not forget to put the char into the buffer... AndrI           * if, on the off chance, we were exactly one pixel from the endpE           * of the line, we have to send the buffer to the out_line()            * routine...           */       *bufptr++ = (UTINY) c;       if (--bufcnt == 0)	         {o         COOPERATE 2         if ((ret = out_line(buf, linewidth)) < 0)            {u            cleanup_gif_decoder();           return(ret);           }*           bufptr = buf;t         bufcnt = linewidth;o	         }l       }i     else       {o  B       /* In this case, it's not a clear code or an ending code, soI           * it must be a code code...  So we can now decode the code intoe>           * a stack of character codes. (Clear as mud, right?)           */       code = c;5  F       /* Here we go again with one of those off chances...  If, on theL           * off chance, the code we got is beyond the range of those alreadyJ           * set up (Another thing which had better NOT happen...) we trickI           * the decoder into thinking it actually got the last code read.bD           * (Hmmn... I'm not sure why this works...  But it does...)           */       if (code >= slot) 	         {          if (code > slot)           ++bad_code_count;a         code = oc;         *sp++ = (UTINY) fc;e	         }O  E       /* Here we scan back along the linked list of prefixes, pushingAJ           * helpless characters (ie. suffixes) onto the stack as we do so.           */       while (code >= newcodes)	         {/         *sp++ = suffix[code];          code = prefix[code];	         }T  A       /* Push the last character on the stack, and set up the new I           * prefix and suffix, and if the required slot number is greater0G           * than that allowed by the current bit size, increase the bitFF           * size.  (NOTE - If we are all full, we *don't* save the newG           * suffix and prefix...  I'm not certain if this is correct...sA           * it might be more proper to overwrite the last code...=           */       *sp++ = (UTINY) code;n       if (slot < top_slot)	         {          fc = code;"         suffix[slot] = (UTINY) fc;         prefix[slot++] = oc;         oc = c; 	         }r       if (slot >= top_slot)          if (curr_size < 12)            {e           top_slot <<= 1;O           ++curr_size;           };  D       /* Now that we've pushed the decoded string (in reverse order)F           * onto the stack, lets pop it off and put it into our decodeH           * buffer...  And when the decode buffer is full, write another           * line...            */       while (sp > dstack) 	         {e         *bufptr++ = *(--sp);         if (--bufcnt == 0)           {            COOPERATEg4           if ((ret = out_line(buf, linewidth)) < 0) 
             {T"             cleanup_gif_decoder();             return(ret);
             }_           bufptr = buf;b           bufcnt = linewidth;            }f	         }l       }i     }i
   ret = 0;   if (bufcnt != linewidth).     ret = out_line(buf, (linewidth - bufcnt));     cleanup_gif_decoder();   return(ret);   } hb
vZk4G4GPBXbAZkL U  b# D
  
@`BTG  'hbuZk4G4GPBXb}AZkG0b#G_B  (*T  b@T@P @TX 4 G 4Gb# D  @TG`B  'hbuZk4G4GPBXbZAZk  ? xD # H %1?J4 BH % Gb#@TG`B  (( hbuZk4G4GPBXb@AZk GGGUb#rJ@4G c
 `G  (    (  0 C8 c@ c0 E8 e@ eb#_G@ ]H ]