M /****************************************************************************  *                   hfield.c * I *    This file implements the height field shape primitive.  The shape is E *    implemented as a collection of triangles which are calculated as D *    needed.  The basic intersection routine first computes the raysD *    intersection with the box marking the limits of the shape, thenK *    follows the line from one intersection point to the other, testing the K *    two triangles which form the pixel for an intersection with the ray at  *    each step. ( *        height field added by Doug Muir9 *        with lots of advice and support from David Buck   *            and Drew Wells. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"   8 #define sign(x) (((x) > 0.0) ? 1: (((x) < 0.0) ? -1: 0))   #ifndef min_value . #define min_value(x,y) ((x) > (y) ? (y) : (x)) #endif #ifndef max_value . #define max_value(x,y) ((x) < (y) ? (y) : (x)) #endif   METHODS Height_Field_Methods =     {    All_HeightFld_Intersections,%   Inside_HeightFld, HeightFld_Normal, ;   Copy_HeightFld,    Translate_HeightFld, Rotate_HeightFld, J   Scale_HeightFld, Transform_HeightFld, Invert_HeightFld,Destroy_HeightFld };  # METHODS Csg_Height_Field_Methods =     { "   All_Csg_HeightFld_Intersections,%   Inside_HeightFld, HeightFld_Normal,    Copy_HeightFld, (   Translate_HeightFld, Rotate_HeightFld,J   Scale_HeightFld, Transform_HeightFld, Invert_HeightFld,Destroy_HeightFld };  = extern long Ray_Ht_Field_Tests, Ray_Ht_Field_Tests_Succeeded; C extern long Ray_Ht_Field_Box_Tests, Ray_HField_Box_Tests_Succeeded;  extern int Options;    int isdx, isdz, X_Dom;, DBL Gdx, Gdy, Gdz, Block_Size, Inv_Blk_Size; DBL Myx, Mxz, Mzx, Myz;  ISTACK *Hf_Stack; 
 RAY *RRay; DBL mindist, maxdist;   A #define Get_Height(x, z, H_Field) ((DBL)(H_Field)->Map[(z)][(x)])   6 static DBL Normalize PARAMS(( VECTOR *A, VECTOR *B ));# static DBL stretch PARAMS((DBL x)); E static int Intersect_Csg_Sub_Block PARAMS((HF_BLOCK *Block, RAY *Ray, 4 HEIGHT_FIELD *H_Field, VECTOR *start, VECTOR *end));I static int Intersect_Csg_Hf_Node PARAMS((RAY *Ray, HEIGHT_FIELD *H_Field,  VECTOR *start, VECTOR *end)); 6 static DBL Normalize PARAMS(( VECTOR *A, VECTOR *B ));I static int add_single_normal PARAMS((HF_val **data, int xsize, int zsize, 9 int x0, int z0,int x1, int z1,int x2, int z2,VECTOR *N)); Q static void smooth_height_field PARAMS((HEIGHT_FIELD *hf, int xsize, int zsize));   
 static DBL Normalize(A, B)  VECTOR *A, *B;   { <   DBL VTemp = sqrt(B->x * B->x + B->y * B->y + B->z * B->z);   if (fabs(VTemp) > EPSILON)       {      A->x = B->x / VTemp;     A->y = B->y / VTemp;     A->z = B->z / VTemp;     }    else       {      A->x = 0.0;      A->y = 1.0;      A->z = 0.0;      }    return VTemp;    }   ;   int Intersect_Pixel(x, z, Ray, H_Field, height1, height2) 
     int x; int z;	 RAY *Ray;  HEIGHT_FIELD *H_Field; DBL height1; DBL height2;   { 7   VECTOR T1V1,T1V2,T1V3,T2V1,T2V2,T2V3,Local_Normal,N1; 2   DBL pos1,pos2,dot,depth1,depth2,s,t,y1,y2,y3,y4;   DBL max_height, min_height;    int Found = FALSE;     y1 = Get_Height(x,z,H_Field); !   y2 = Get_Height(x+1,z,H_Field); !   y3 = Get_Height(x,z+1,H_Field); #   y4 = Get_Height(x+1,z+1,H_Field);   &   Make_Vector(&T1V1,(DBL)x,y1,(DBL)z);#   Make_Vector(&T1V2,1.0,y2-y1,0.0); #   Make_Vector(&T1V3,0.0,y3-y1,1.0); .   Make_Vector(&T2V1,(DBL)(x+1),y4,(DBL)(z+1));$   Make_Vector(&T2V2,-1.0,y3-y4,0.0);$   Make_Vector(&T2V3,0.0,y2-y4,-1.0);     /*C      * first, we check to see if it is even possible for the ray to       * intersect the triangle.      */   .   max_height = max_value(y1,max_value(y2,y3));.   min_height = min_value(y1,min_value(y2,y3));8   if((max_height >= height1) && (min_height <= height2))     { #     VCross(Local_Normal,T1V3,T1V2); *     VDot(dot,Local_Normal,Ray->Direction);  +     if((dot > EPSILON) || (dot < -EPSILON))        { #       VDot(pos1,Local_Normal,T1V1); +       VDot(pos2,Local_Normal,Ray->Initial);          pos1 -= pos2;          depth1 = pos1 / dot;  5       if((depth1 >= mindist) && (depth1 <= maxdist))  	         { <         s = Ray->Initial.x+(depth1*Ray->Direction.x)-(DBL)x;<         t = Ray->Initial.z+(depth1*Ray->Direction.z)-(DBL)z;  <         if((s>=-0.0001) && (t>=-0.0001) && ((s+t)<=1.0001))            { "           if (!H_Field->Smoothed) 
             {              N1 = Local_Normal;4             if (H_Field->cache_pos < HF_CACHE_SIZE)                { E               H_Field->Normal_Vector[H_Field->cache_pos].normal = N1; C               H_Field->Normal_Vector[H_Field->cache_pos].x = x + s; C               H_Field->Normal_Vector[H_Field->cache_pos].z = z + t; &               H_Field->cache_pos += 1;               } 
             }   3           VScale (T1V1, RRay -> Direction, depth1); )           VAddEq (T1V1, RRay -> Initial); 3           if (Point_In_Clip (&T1V1, H_Field->Clip)) 
             { ?             push_entry(depth1,T1V1,(OBJECT *)H_Field,Hf_Stack);              Found = TRUE; +             Ray_Ht_Field_Tests_Succeeded++; 
             }            } 	         }        }      }      /*@ 	 * first, we check to see if it is even possible for the ray to 	 * intersect the triangle. : 	   Rewritten to get around Code Builder FP stack problem. 	   Original code:@               if((max_value(y4,max_value(y2,y3)) >= height1) && A 	      (min_value(y4,min_value(y2,y3)) <= height2))            */   .   max_height = max_value(y4,max_value(y2,y3));.   min_height = min_value(y4,min_value(y2,y3));8   if((max_height >= height1) && (min_height <= height2))     { #     VCross(Local_Normal,T2V3,T2V2); *     VDot(dot,Local_Normal,Ray->Direction);  +     if((dot > EPSILON) || (dot < -EPSILON))        { #       VDot(pos1,Local_Normal,T2V1);   +       VDot(pos2,Local_Normal,Ray->Initial);        pos1 -= pos2;          depth2 = pos1 / dot;  2       if((depth2 >=mindist) && (depth2 <=maxdist))	         { <         s = Ray->Initial.x+(depth2*Ray->Direction.x)-(DBL)x;<         t = Ray->Initial.z+(depth2*Ray->Direction.z)-(DBL)z;  9         if((s<=1.0001) && (t<=1.0001) && ((s+t)>0.9999))             { "           if (!H_Field->Smoothed) 
             {              N1 = Local_Normal;4             if (H_Field->cache_pos < HF_CACHE_SIZE)                { E               H_Field->Normal_Vector[H_Field->cache_pos].normal = N1; C               H_Field->Normal_Vector[H_Field->cache_pos].x = x + s; C               H_Field->Normal_Vector[H_Field->cache_pos].z = z + t; &               H_Field->cache_pos += 1;               } 
             }   3           VScale (T1V1, RRay -> Direction, depth2); )           VAddEq (T1V1, RRay -> Initial); 3           if (Point_In_Clip (&T1V1, H_Field->Clip)) 
             { ?             push_entry(depth2,T1V1,(OBJECT *)H_Field,Hf_Stack);              Found = TRUE; +             Ray_Ht_Field_Tests_Succeeded++; 
             }            } 	         }        }      }      return(Found);   }   8 int Intersect_Sub_Block(Block, Ray, H_Field, start, end) HF_BLOCK *Block;	 RAY *Ray;* HEIGHT_FIELD *H_Field; VECTOR *start, *end;   {*
   DBL y1, y2; $   DBL sx, sy, sz, ex, ez, f, tx, tz;   int ix, iz, length, i;  4   if(min_value(start->y,end->y) > (DBL)Block->max_y)     return(FALSE);  4   if(max_value(start->y,end->y) < (DBL)Block->min_y)     return(FALSE);     sx = start->x;   ex = end->x;   sz = start->z;   ez = end->z;   sy = start->y;     if(X_Dom)      {o     if(isdx >= 0)        {t       f = floor(sx) - sx;t       sx = floor(sx);n       sy += Myx * f;       sz += Mzx * f;       ex = ceil(ex) - 1.0;       ix = (int)sx;i       } 	     else u       {        f = ceil(sx) - sx;       sx = ceil(sx) - 1.0;       sy += Myx * f;       sz += Mzx * f;       ex = floor(ex);        ix = (int)sx;g       }e  +       length = (int)abs((int)ex - (int)sx);-       if (isdz >= 0) -       {-!       tz = floor(start->z) + 1.0;i       iz = (int)start->z;d       f = sz - tz;       }n	     else         {n        tz = ceil(start->z) - 1.0;       iz = (int)tz;e       f = tz - sz;       }y         if(Gdy >= 0.0)         {t       y1 = sy;       y2 = sy + Gdy;       }        else h       {r       y1 = sy + Gdy;       y2 = sy;       }u         for(i=0;i<=length;i++)         {P2       if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))         return(TRUE);        f += Gdz;        if(f>0.0) 	         {S         iz += isdz;o4         if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))           return(TRUE);          f -= 1.0; 	         }e       ix += isdx;c       y1 += Gdy;       y2 += Gdy;       }r     }y   else       {      if(isdz >= 0)        {w       f = floor(sz) - sz;a       sz = floor(sz);*       sy += Myz * f;       sx += Mxz * f;       ez = ceil(ez) - 1.0;       iz = (int)sz;m       }c	     else r       {c       f = ceil(sz) - sz;       sz = ceil(sz) - 1.0;       sy += Myz * f;       sx += Mxz * f;       ez = floor(ez);,       iz = (int)sz;        }               +       length = (int)abs((int)ez - (int)sz);        if (isdx >= 0) E       {g!       tx = floor(start->x) + 1.0;e       ix = (int)start->x;n       f = sx - tx;       }m	     else y       {d        tx = ceil(start->x) - 1.0;       ix = (int)tx;e       f = tx - sx;       }          if(Gdy >= 0.0) H       {        y1 = sy;       y2 = sy + Gdy;       }        else e       {n       y1 = sy + Gdy;       y2 = sy;       }m         for(i=0;i<=length;i++) l       {t2       if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))         return(TRUE);h       f += Gdx;h       if(f>0.0) 	         {t         ix += isdx;F4         if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))           return(TRUE);s         f -= 1.0;n	         }s       iz += isdz;z       y1 += Gdy;       y2 += Gdy;       }B     };   return (FALSE);,   }   C static int Intersect_Csg_Sub_Block(Block, Ray, H_Field, start, end)_ HF_BLOCK *Block;	 RAY *Ray;H HEIGHT_FIELD *H_Field; VECTOR *start, *end;   {R
   DBL y1, y2;,$   DBL sx, sy, sz, ex, ez, f, tx, tz;    int ix, iz, length, i, retval;  4   if(min_value(start->y,end->y) > (DBL)Block->max_y)     return(FALSE);  4   if(max_value(start->y,end->y) < (DBL)Block->min_y)     return(FALSE);     retval = FALSE;H   sx = start->x;   ex = end->x;   sz = start->z;   ez = end->z;   sy = start->y;     if(X_Dom)      {a     if(isdx >= 0)        {a       f = floor(sx) - sx;i       sx = floor(sx);t       sy += Myx * f;       sz += Mzx * f;       ex = ceil(ex) - 1.0;       ix = (int)sx;D       } 	     else z       {        f = ceil(sx) - sx;       sx = ceil(sx) - 1.0;       sy += Myx * f;       sz += Mzx * f;       ex = floor(ex);(       ix = (int)sx;)       }   ,       length = (int) abs((int)ex - (int)sx);       if (isdz >= 0)         { !       tz = floor(start->z) + 1.0;0       iz = (int)start->z;        f = sz - tz;       }n	     else         {n        tz = ceil(start->z) - 1.0;       iz = (int)tz;        f = tz - sz;       }y         if(Gdy >= 0.0) ;       {g       y1 = sy;       y2 = sy + Gdy;       }V       else 2       {N       y1 = sy + Gdy;       y2 = sy;       },         for(i=0;i<=length;i++)         {t2       if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))         retval = TRUE;       f += Gdz;)       if(f>0.0) 	         {_         iz += isdz;H4         if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))           retval = TRUE;         f -= 1.0;.	         }e       ix += isdx;3       y1 += Gdy;       y2 += Gdy;       },     }+   else a     {o     if(isdz >= 0)        {a       f = floor(sz) - sz;1       sz = floor(sz);r       sy += Myz * f;       sx += Mxz * f;       ez = ceil(ez) - 1.0;       iz = (int)sz;        } 	     else t       {l       f = ceil(sz) - sz;       sz = ceil(sz) - 1.0;       sy += Myz * f;       sx += Mxz * f;       ez = floor(ez);h       iz = (int)sz;        }               +       length = (int)abs((int)ez - (int)sz);c       if (isdx >= 0)         {|!       tx = floor(start->x) + 1.0;        ix = (int)start->x;V       f = sx - tx;       }o	     else n       {         tx = ceil(start->x) - 1.0;       ix = (int)tx;        f = tx - sx;       }&         if(Gdy >= 0.0)         {        y1 = sy;       y2 = sy + Gdy;       }t       else ;       {        y1 = sy + Gdy;       y2 = sy;       }B         for(i=0;i<=length;i++) &       {02       if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))         retval = TRUE;       f += Gdx;        if(f>0.0) 	         {          ix += isdx;l4         if(Intersect_Pixel(ix,iz,Ray,H_Field,y1,y2))           retval = TRUE;         f -= 1.0;h	         }a       iz += isdz;        y1 += Gdy;       y2 += Gdy;       }]     }+   return (retval);   }l  / int Intersect_Hf_Node(Ray, H_Field, start, end) 	 RAY *Ray;  HEIGHT_FIELD *H_Field; VECTOR *start, *end;   { +   VECTOR *curr, *next, *temp, temp1, temp2;e&   DBL sx, sy, sz, ex, ey, ez, x, y, z;)   DBL tnear, tfar, t, bsx, bsz, bex, bez;n(   int ix, iz, x_size, z_size, length, i;     x = sx = start->x;   y = sy = start->y;   z = sz = start->z;   ex = end->x;   ey = end->y;   ez = end->z;     bsx = sx * Inv_Blk_Size;   bsz = sz * Inv_Blk_Size;   bex = ex * Inv_Blk_Size;   bez = ez * Inv_Blk_Size;     if (isdx >= 0) v     {i     bsx = floor(bsx);      bex = ceil(bex) - 1.0;     }t   else t     {      bsx = ceil(bsx) - 1.0;     bex = floor(bex);      }        if (isdz >= 0) m     {e     bsz = floor(bsz);      bez = ceil(bez) - 1.0;     },	     else g     {      bsz = ceil(bsz) - 1.0;     bez = floor(bez);u     })  &     x_size = abs((int)bex - (int)bsx);$   z_size = abs((int)bez - (int)bsz);     length = x_size + z_size;      curr = &temp1;   next = &temp2;   Make_Vector(curr, x, y, z);,
   t = 0.0;     if(X_Dom)      {P     if(isdx >= 0)        { '       ix = (int)floor(sx*Inv_Blk_Size);V%       tnear = Block_Size*(ix+1) - sx;y         if (isdz >= 0) -	         { )         iz = (int)floor(sz*Inv_Blk_Size);t.         tfar = Gdx * (Block_Size*(iz+1) - sz);	         }        else l	         {R,         iz = (int)ceil(sz*Inv_Blk_Size) - 1;,         tfar = Gdx * (sz - Block_Size*(iz));!         }                         #       for (i = 0; i < length; i++)  	         {(         if(tfar < tnear)             {            t = tfar;r           x = sx + t;_           y = sy + Myx * t;I           z = sz + Mzx * t; %           Make_Vector(next, x, y, z);>R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);_           temp = curr;           curr = next;           next = temp;           iz += isdz;            if (isdz >= 0)  2             tfar = Gdx * (Block_Size*(iz+1) - sz);           else  0             tfar = Gdx * (sz - Block_Size*(iz));           }&
         else C           {            t = tnear;           x = sx + t;(           y = sy + Myx * t;            z = sz + Mzx * t; %           Make_Vector(next, x, y, z);+R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);l           temp = curr;           curr = next;           next = temp;           ix++;;)           tnear = Block_Size*(ix+1) - sx;            }y	         }z       }t	     else x!       {                          s*       ix = (int)ceil(sx*Inv_Blk_Size) - 1;#       tnear = sx - Block_Size*(ix);>           if (isdz >= 0) _	         {u)         iz = (int)floor(sz*Inv_Blk_Size);>.         tfar = Gdx * (Block_Size*(iz+1) - sz);	         } 
         else  	         {i,         iz = (int)ceil(sz*Inv_Blk_Size) - 1;,         tfar = Gdx * (sz - Block_Size*(iz));	         }z  %         for (i = 0; i < length; i++)  	         {(         if(tfar < tnear) e           {            t = tfar;s           x = sx - t;            y = sy - Myx * t;            z = sz - Mzx * t;x%           Make_Vector(next, x, y, z); R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);t           temp = curr;           curr = next;           next = temp;           iz += isdz;            if (isdz >= 0) .2             tfar = Gdx * (Block_Size*(iz+1) - sz);           else y0             tfar = Gdx * (sz - Block_Size*(iz));           } 
         else e           {            t = tnear;           x = sx - t;u           y = sy - Myx * t;+           z = sz - Mzx * t;r%           Make_Vector(next, x, y, z); R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);t           temp = curr;           curr = next;           next = temp;           ix--;e'           tnear = sx - Block_Size*(ix);            };	         } $       }                                  }    else       {      if(isdz >= 0)        {='       iz = (int)floor(sz*Inv_Blk_Size); %       tnear = Block_Size*(iz+1) - sz;.         if (isdx >= 0)  	         { 0         ix = (int)floor(sx*Inv_Blk_Size);       .         tfar = Gdz * (Block_Size*(ix+1) - sx);	         }x       else  	         {e,         ix = (int)ceil(sx*Inv_Blk_Size) - 1;,         tfar = Gdz * (sx - Block_Size*(ix));	         } #       for (i = 0; i < length; i++) =	         {t         if(tfar < tnear) n           {            t = tfar;            z = sz + t;            y = sy + Myz * t;x           x = sx + Mxz * t;e%           Make_Vector(next, x, y, z); R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);s           temp = curr;           curr = next;           next = temp;           ix += isdx;e           if (isdx >= 0) y2             tfar = Gdz * (Block_Size*(ix+1) - sx);           else  0             tfar = Gdz * (sx - Block_Size*(ix));           }z
         else ,           {            t = tnear;           z = sz + t;            y = sy + Myz * t;            x = sx + Mxz * t; %           Make_Vector(next, x, y, z); R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);T           temp = curr;           curr = next;           next = temp;           iz++;,)           tnear = Block_Size*(iz+1) - sz;            }l	         },       } 	     else >!       {                          m*       iz = (int)ceil(sz*Inv_Blk_Size) - 1;#       tnear = sz - Block_Size*(iz);F           if (isdx >= 0)  	         {;)         ix = (int)floor(sx*Inv_Blk_Size);s.         tfar = Gdz * (Block_Size*(ix+1) - sx);	         } 
         else l	         {x,         ix = (int)ceil(sx*Inv_Blk_Size) - 1;,         tfar = Gdz * (sx - Block_Size*(ix));,         }                                   #       for (i = 0; i < length; i++) s	         {x         if(tfar < tnear) y           {            t = tfar;            z = sz - t;            y = sy - Myz * t;            x = sx - Mxz * t;(%           Make_Vector(next, x, y, z);)R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);            temp = curr;           curr = next;           next = temp;           ix += isdx;            if (isdx >= 0) .2             tfar = Gdz * (Block_Size*(ix+1) - sx);           else0             tfar = Gdz * (sx - Block_Size*(ix));           } 
         else (           {;           t = tnear;           z = sz - t;,           y = sy - Myz * t;            x = sx - Mxz * t;G%           Make_Vector(next, x, y, z); R           if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             return(TRUE);1           temp = curr;           curr = next;           next = temp;           iz--;+%           tnear = sz - Block_Size*iz;            } 	         }(,       }                                          }    Make_Vector(next,ex,ey,ez);    if(isdx >= 0).(     ix = (int)ceil(ex*Inv_Blk_Size) - 1;   else%     ix = (int)floor(ex*Inv_Blk_Size);    if(isdz >= 0).(     iz = (int)ceil(ez*Inv_Blk_Size) - 1;   else%     iz = (int)floor(ez*Inv_Blk_Size);zJ   if(Intersect_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))     return(TRUE);    return (FALSE);x   }o  : static int Intersect_Csg_Hf_Node(Ray, H_Field, start, end)	 RAY *Ray;  HEIGHT_FIELD *H_Field; VECTOR *start, *end;   {x+   VECTOR *curr, *next, *temp, temp1, temp2;-&   DBL sx, sy, sz, ex, ey, ez, x, y, z;)   DBL tnear, tfar, t, bsx, bsz, bex, bez; 0   int ix, iz, x_size, z_size, length, i, retval;     retval = FALSE;=   x = sx = start->x;   y = sy = start->y;   z = sz = start->z;   ex = end->x;   ey = end->y;   ez = end->z;     bsx = sx * Inv_Blk_Size;   bsz = sz * Inv_Blk_Size;   bex = ex * Inv_Blk_Size;   bez = ez * Inv_Blk_Size;     if (isdx >= 0) d     {)     bsx = floor(bsx);U     bex = ceil(bex) - 1.0;     }    else +     {      bsx = ceil(bsx) - 1.0;     bex = floor(bex);      }e       if (isdz >= 0)       {e     bsz = floor(bsz);e     bez = ceil(bez) - 1.0;     }T	     else i     {E     bsz = ceil(bsz) - 1.0;     bez = floor(bez);e     }p  &     x_size = abs((int)bex - (int)bsx);$   z_size = abs((int)bez - (int)bsz);     length = x_size + z_size;_     curr = &temp1;   next = &temp2;   Make_Vector(curr, x, y, z);;
   t = 0.0;     if(X_Dom)      {>     if(isdx >= 0)        {d'       ix = (int)floor(sx*Inv_Blk_Size); %       tnear = Block_Size*(ix+1) - sx;B         if (isdz >= 0) v	         { )         iz = (int)floor(sz*Inv_Blk_Size);o.         tfar = Gdx * (Block_Size*(iz+1) - sz);	         }        else  	         { ,         iz = (int)ceil(sz*Inv_Blk_Size) - 1;,         tfar = Gdx * (sz - Block_Size*(iz));!         }                        ,#       for (i = 0; i < length; i++) b	         {          if(tfar < tnear)             {i           t = tfar;i           x = sx + t;s           y = sy + Myx * t;e           z = sz + Mzx * t; %           Make_Vector(next, x, y, z);eV           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           iz += isdz;            if (isdz >= 0) I2             tfar = Gdx * (Block_Size*(iz+1) - sz);           else  0             tfar = Gdx * (sz - Block_Size*(iz));           }l
         else             {G           t = tnear;           x = sx + t;            y = sy + Myx * t;            z = sz + Mzx * t; %           Make_Vector(next, x, y, z); V           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           ix++;c)           tnear = Block_Size*(ix+1) - sx;            }U	         }        }=	     else  !       {                          =*       ix = (int)ceil(sx*Inv_Blk_Size) - 1;#       tnear = sx - Block_Size*(ix);x           if (isdz >= 0) ;	         { )         iz = (int)floor(sz*Inv_Blk_Size);k.         tfar = Gdx * (Block_Size*(iz+1) - sz);	         } 
         else a	         { ,         iz = (int)ceil(sz*Inv_Blk_Size) - 1;,         tfar = Gdx * (sz - Block_Size*(iz));	         }   %         for (i = 0; i < length; i++) o	         {d         if(tfar < tnear) d           {            t = tfar;U           x = sx - t;c           y = sy - Myx * t;            z = sz - Mzx * t; %           Make_Vector(next, x, y, z);eV           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           iz += isdz;            if (isdz >= 0) )2             tfar = Gdx * (Block_Size*(iz+1) - sz);           else z0             tfar = Gdx * (sz - Block_Size*(iz));           }e
         else i           {            t = tnear;           x = sx - t;            y = sy - Myx * t;            z = sz - Mzx * t;(%           Make_Vector(next, x, y, z); V           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           ix--;z'           tnear = sx - Block_Size*(ix);e           } 	         }e$       }                                  }    else m     {      if(isdz >= 0)        { '       iz = (int)floor(sz*Inv_Blk_Size);*%       tnear = Block_Size*(iz+1) - sz;l         if (isdx >= 0) G	         {B0         ix = (int)floor(sx*Inv_Blk_Size);       .         tfar = Gdz * (Block_Size*(ix+1) - sx);	         }        else y	         {+,         ix = (int)ceil(sx*Inv_Blk_Size) - 1;,         tfar = Gdz * (sx - Block_Size*(ix));	         }k#       for (i = 0; i < length; i++) d	         {)         if(tfar < tnear) t           {e           t = tfar;            z = sz + t;            y = sy + Myz * t;e           x = sx + Mxz * t;k%           Make_Vector(next, x, y, z); V           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           ix += isdx;            if (isdx >= 0) x2             tfar = Gdz * (Block_Size*(ix+1) - sx);           else ;0             tfar = Gdz * (sx - Block_Size*(ix));           }s
         else             {            t = tnear;           z = sz + t;            y = sy + Myz * t;g           x = sx + Mxz * t; %           Make_Vector(next, x, y, z); V           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           iz++;H)           tnear = Block_Size*(iz+1) - sz;)           } 	         };       } 	     else x!       {                           *       iz = (int)ceil(sz*Inv_Blk_Size) - 1;#       tnear = sz - Block_Size*(iz);(           if (isdx >= 0) e	         { )         ix = (int)floor(sx*Inv_Blk_Size); .         tfar = Gdz * (Block_Size*(ix+1) - sx);	         }a
         else  	         { ,         ix = (int)ceil(sx*Inv_Blk_Size) - 1;,         tfar = Gdz * (sx - Block_Size*(ix));,         }                                   #       for (i = 0; i < length; i++) ,	         {          if(tfar < tnear)             {c           t = tfar;=           z = sz - t;=           y = sy - Myz * t;            x = sx - Mxz * t;1%           Make_Vector(next, x, y, z); V           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           ix += isdx;S           if (isdx >= 0) *2             tfar = Gdz * (Block_Size*(ix+1) - sx);           else  0             tfar = Gdz * (sx - Block_Size*(ix));           }*
         else z           {            t = tnear;           z = sz - t;            y = sy - Myz * t;)           x = sx - Mxz * t;a%           Make_Vector(next, x, y, z); V           if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))             retval = TRUE;           temp = curr;           curr = next;           next = temp;           iz--;c%           tnear = sz - Block_Size*iz;            }p	         } ,       }                                          }    Make_Vector(next,ex,ey,ez);s   if(isdx >= 0) (     ix = (int)ceil(ex*Inv_Blk_Size) - 1;   else%     ix = (int)floor(ex*Inv_Blk_Size);x   if(isdz >= 0))(     iz = (int)ceil(ez*Inv_Blk_Size) - 1;   else%     iz = (int)floor(ez*Inv_Blk_Size);tN   if(Intersect_Csg_Sub_Block(&(H_Field->Block[ix][iz]),Ray,H_Field,curr,next))     retval = TRUE;   return (retval);   }t  
 static int@ add_single_normal(data, xsize, zsize, x0, z0, x1, z1, x2, z2, N)   HF_val **data;$   int xsize,zsize,x0,z0,x1,z1,x2,z2;   VECTOR *N;   {t    VECTOR v0, v1, v2, t0, t1, Nt;     if (x0 < 0 || z0 < 0 ||      x1 < 0 || z1 < 0 ||      x2 < 0 || z2 < 0 ||      x0 > xsize || z0 > zsize ||e     x1 > xsize || z1 > zsize ||d     x2 > xsize || z2 > zsize)      {_
     return 0;l     }    else )     {x0     Make_Vector(&v0, x0, (DBL)data[z0][x0], z0);0     Make_Vector(&v1, x1, (DBL)data[z1][x1], z1);0     Make_Vector(&v2, x2, (DBL)data[z2][x2], z2);     VSub(t0, v2, v0);z     VSub(t1, v1, v0);t     VCross(Nt, t0, t1);      Normalize(&Nt, &Nt);     if(Nt.y < 0.0) C       {e       VScale(Nt,Nt,-1.0);        }      VAdd(*N, *N, Nt);;
     return 1;,     }    }   B /* Given a height field that only contains an elevation grid, thisB    routine will walk through the data and produce averaged normals!    for all points on the grid. */t static voidv% smooth_height_field(hf, xsize, zsize)    HEIGHT_FIELD *hf;    int xsize;   int zsize;   {    int i, j, k;   VECTOR N;;   HF_val **map = hf->Map;z  ;   /* First off, allocate all the memory needed to store thee       normal information */fH   hf->Normals = (HF_Normals **)malloc((zsize+1) * sizeof(HF_Normals *));   if (hf->Normals == NULL)       { 5     fprintf(stderr, "Failed to allocate hf->norm\n");      exit(1);     }    for (i=0; i<=zsize; i++)       { J     hf->Normals[i] = (HF_Normals *)malloc((xsize+1) * sizeof(HF_Normals));      if (hf->Normals[i] == NULL)        {=>       fprintf(stderr, "Failed to allocate hf->norm[%d]\n", i);       exit(1);       }_     }   C   /* For now we will do it the hard way - by generating the normals .       individually for each elevation point */   for (i=0;i<=zsize;i++) (     {o     COOPERATE 5     if((i%(int)Block_Size) == 0) fprintf(stderr,".");f     for (j=0;j<=xsize;j++)         {=%       Make_Vector(&N, 0.0, 0.0, 0.0);        k = 0;       /*M          k += add_single_normal(map, xsize, zsize, j, i, j+1, i, j, i+1, &N);*Q          k += add_single_normal(map, xsize, zsize, j+1, i+1, j, i+1, j+1, i, &N); O          k += add_single_normal(map, xsize, zsize, j, i+1, j-1, i+1, j, i, &N);aO          k += add_single_normal(map, xsize, zsize, j-1, i, j, i, j-1, i+1, &N); M          k += add_single_normal(map, xsize, zsize, j, i, j-1, i, j, i-1, &N); Q          k += add_single_normal(map, xsize, zsize, j-1, i-1, j, i-1, j-1, i, &N);eO          k += add_single_normal(map, xsize, zsize, j, i-1, j+1, i-1, j, i, &N);rO          k += add_single_normal(map, xsize, zsize, j+1, i, j, i, j+1, i-1, &N);) */J       k += add_single_normal(map, xsize, zsize, j, i, j+1, i, j, i+1, &N);J       k += add_single_normal(map, xsize, zsize, j, i, j, i+1, j-1, i, &N);J       k += add_single_normal(map, xsize, zsize, j, i, j-1, i, j, i-1, &N);J       k += add_single_normal(map, xsize, zsize, j, i, j, i-1, j+1, i, &N);         if (k == 0) 	         {SK         fprintf(stderr, "Failed to find any normals at: (%d, %d)\n", i, j);l         exit(1);	         }r       Normalize(&N, &N);2       hf->Normals[i][j][0] = (short)(32767 * N.x);2       hf->Normals[i][j][1] = (short)(32767 * N.y);2       hf->Normals[i][j][2] = (short)(32767 * N.z);B       /* printf("n[%d,%d]: <%g %g %g>\n", j, i, N.x, N.y, N.z); */       }-     }S   }     $ void Find_Hf_Min_Max(H_Field, Image) HEIGHT_FIELD *H_Field;
 IMAGE *Image;S   {k>   int n, i, i2, j, j2, x, z, w, h, max_x, max_z, temp1, temp2;   DBL size;    HF_val temp_y;     max_x = Image->iwidth;3   if(Image->File_Type == POT_FILE) max_x = max_x/2;)   max_z = Image->iheight;o  &   size = (DBL)max_value(max_x, max_z);;   H_Field->Block_Size  = Block_Size = ceil(sqrt(size+1.0));U8   H_Field->Inv_Blk_Size = Inv_Blk_Size = 1.0/Block_Size;   n = (int)Block_Size;  *   w = (int)ceil((max_x+1.0)*Inv_Blk_Size);*   h = (int)ceil((max_z+1.0)*Inv_Blk_Size);  >   H_Field->Map = (HF_val **)calloc(max_z+1, sizeof(HF_val *));   if (H_Field->Map == NULL) @     fprintf(stderr,"Cannot allocate memory for height field\n");  =   H_Field->Block = (HF_BLOCK **)calloc(w,sizeof(HF_BLOCK *));i   if(H_Field->Block == NULL)H     fprintf(stderr, "Cannot allocate memory for height field buffer\n");   for(i=0; i<w; i++)       { ?     H_Field->Block[i] = (HF_BLOCK *)calloc(h,sizeof(HF_BLOCK));t"     if (H_Field->Block[i] == NULL)M       fprintf(stderr, "Cannot allocate memory for height field buffer line\n"F
         );     for(j=0; j<h; j++) ,       { )       H_Field->Block[i][j].min_y = 65535;c%       H_Field->Block[i][j].max_y = 0;        }m     }   =   H_Field->Map[0] = (HF_val *)calloc(max_x+1,sizeof(HF_val));    if (H_Field->Map[0] == NULL)@     fprintf(stderr,"Cannot allocate memory for height field\n");     for(j=0; j < h; j++)     {(1     for(j2=0;(j2 <= n) && (j*n+j2 <= max_z);j2++)        {        z = j*n+j2;)       if(j2!=0) 	         {(C         H_Field->Map[z] = (HF_val *)calloc(max_x+1,sizeof(HF_val));($         if (H_Field->Map[z] == NULL)G           fprintf(stderr, "Cannot allocate memory for height field\n");=	         }-         COOPERATE        for(i=0; i < w; i++)	         {h3         for(i2=0;(i2 <= n)&&(i*n+i2 <= max_x);i2++)            {            x = i*n+i2; A           if((x >= 0) && (x < max_x) && (z >= 0) && (z < max_z)) M
             { %             switch(Image->File_Type)  
             {t             case GIF_FILE:>               temp1 = Image->data.map_lines[max_z - z - 1][x];+               temp_y = (HF_val)(256*temp1);x               break;             case POT_FILE:>               temp1 = Image->data.map_lines[max_z - z - 1][x];F               temp2 = Image->data.map_lines[max_z - z - 1][x + max_x];3               temp_y = (HF_val)(256*temp1 + temp2);                break;             case TGA_FILE:-               if (Image->Colour_Map == NULL) +                 { D                 temp1 = Image->data.rgb_lines[max_z - z - 1].red[x];F                 temp2 = Image->data.rgb_lines[max_z - z - 1].green[x];                 }p               else u                 { @                 temp1 = Image->data.map_lines[max_z - z - 1][x];                 temp2 = 0;                 } 3               temp_y = (HF_val)(256*temp1 + temp2);                break;
             } (             H_Field->Map[z][x] = temp_y;
             }>           else  
             {(             if (z == max_z)                {z8               H_Field->Map[z][x] = H_Field->Map[z-1][x];               }              if (x == max_x)                { 8               H_Field->Map[z][x] = H_Field->Map[z][x-1];               } (             temp_y = H_Field->Map[z][x];
             }   1           if(temp_y < H_Field->Block[i][j].min_y) 0             H_Field->Block[i][j].min_y = temp_y;1           if(temp_y > H_Field->Block[i][j].max_y) 0             H_Field->Block[i][j].max_y = temp_y;           }B	         }e-       if((z >= 0) && (z < max_z) && (j2!=n))  	         {v"         switch (Image->File_Type) 	         {u         case GIF_FILE: t<           free(Image->data.map_lines[max_z - z - 1]); break;         case POT_FILE: (<           free(Image->data.map_lines[max_z - z - 1]); break;         case TGA_FILE:)           if (Image->Colour_Map == NULL)  
             { <             free(Image->data.rgb_lines[max_z - z - 1].blue);=             free(Image->data.rgb_lines[max_z - z - 1].green); ;             free(Image->data.rgb_lines[max_z - z - 1].red);l
             }y           else t
             { 7             free(Image->data.map_lines[max_z - z - 1]);n
             }            break;	         }c	         }        }z     }k  D     /* If this is a smoothed height field, then allocate storage for#       the normals & compute them */t     if (H_Field->Smoothed)1       smooth_height_field(H_Field, max_x, max_z);e     }x  9 int All_HeightFld_Intersections(Object, Ray, Depth_Stack)( OBJECT *Object;l	 RAY *Ray;; ISTACK *Depth_Stack;   {o   VECTOR Temp1, Temp2;   RAY Temp_Ray;S   DBL depth1, depth2;c   int ret_val = FALSE;2   HEIGHT_FIELD *H_Field = (HEIGHT_FIELD *) Object;     Ray_Ht_Field_Tests++;g  E   MInvTransPoint(&(Temp_Ray.Initial),&(Ray->Initial),H_Field->Trans);;M   MInvTransDirection(&(Temp_Ray.Direction),&(Ray->Direction),H_Field->Trans);,  F   if(!Intersect_Boxx(&Temp_Ray,H_Field->bounding_box,&depth1,&depth2))     return(FALSE);           H_Field->cache_pos = 0; #   Block_Size = H_Field->Block_Size; '   Inv_Blk_Size = H_Field->Inv_Blk_Size;e     if( depth1 == depth2)      {      depth1 = Small_Tolerance;a,     VScale(Temp1,Temp_Ray.Direction,depth1);#     VAddEq(Temp1,Temp_Ray.Initial);(,     VScale(Temp2,Temp_Ray.Direction,depth2);#     VAddEq(Temp2,Temp_Ray.Initial);      }s   else t     { ,     VScale(Temp1,Temp_Ray.Direction,depth1);#     VAddEq(Temp1,Temp_Ray.Initial); ,     VScale(Temp2,Temp_Ray.Direction,depth2);+     VAddEq(Temp2,Temp_Ray.Initial);        h     }      mindist = depth1;r   maxdist = depth2;w  +   if(fabs(Temp_Ray.Direction.x) > EPSILON) n     { 4     Mzx = Temp_Ray.Direction.z/Temp_Ray.Direction.x;4     Myx = Temp_Ray.Direction.y/Temp_Ray.Direction.x;     }n   else       {s'     Mzx = Temp_Ray.Direction.z/EPSILON; '     Myx = Temp_Ray.Direction.y/EPSILON;o     }o+   if(fabs(Temp_Ray.Direction.z) > EPSILON)       {l4     Mxz = Temp_Ray.Direction.x/Temp_Ray.Direction.z;4     Myz = Temp_Ray.Direction.y/Temp_Ray.Direction.z;     }L   else       { '     Mxz = Temp_Ray.Direction.x/EPSILON;o'     Myz = Temp_Ray.Direction.y/EPSILON;0     }i     Hf_Stack = Depth_Stack;o
   RRay = Ray;N  $   isdx = sign(Temp_Ray.Direction.x);$   isdz = sign(Temp_Ray.Direction.z);     X_Dom = FALSE;>   if(fabs(Temp_Ray.Direction.x) >= fabs(Temp_Ray.Direction.z))     X_Dom = TRUE;_     Gdx = fabs(Mxz);   Gdz = fabs(Mzx);   if(X_Dom)      {t     Gdy = Myx * (DBL)isdx;     }y   else       {o     Gdy = Myz * (DBL)isdz;     })  ;   if(Intersect_Hf_Node(&Temp_Ray, H_Field, &Temp1, &Temp2))r     ret_val = TRUE;    return(ret_val);   }   = int All_Csg_HeightFld_Intersections(Object, Ray, Depth_Stack)  OBJECT *Object;  RAY *Ray;  g ISTACK *Depth_Stack;   {,   VECTOR Temp1, Temp2;   RAY Temp_Ray;+   DBL depth1, depth2;,   int ret_val = FALSE;2   HEIGHT_FIELD *H_Field = (HEIGHT_FIELD *) Object;     Ray_Ht_Field_Tests++;+  E   MInvTransPoint(&(Temp_Ray.Initial),&(Ray->Initial),H_Field->Trans);zM   MInvTransDirection(&(Temp_Ray.Direction),&(Ray->Direction),H_Field->Trans);s  F   if(!Intersect_Boxx(&Temp_Ray,H_Field->bounding_box,&depth1,&depth2))     return(FALSE);     -  #   H_Field->cache_pos = 0;          g#   Block_Size = H_Field->Block_Size;j'   Inv_Blk_Size = H_Field->Inv_Blk_Size;i     if( depth1 == depth2)      {      depth1 = Small_Tolerance; ,     VScale(Temp1,Temp_Ray.Direction,depth1);#     VAddEq(Temp1,Temp_Ray.Initial);=,     VScale(Temp2,Temp_Ray.Direction,depth2);#     VAddEq(Temp2,Temp_Ray.Initial);n     }m   else s     {i,     VScale(Temp1,Temp_Ray.Direction,depth1);#     VAddEq(Temp1,Temp_Ray.Initial);i,     VScale(Temp2,Temp_Ray.Direction,depth2);0     VAddEq(Temp2,Temp_Ray.Initial);                  }o       mindist = depth1;    maxdist = depth2;;  +   if(fabs(Temp_Ray.Direction.x) > EPSILON) f     {l4     Mzx = Temp_Ray.Direction.z/Temp_Ray.Direction.x;4     Myx = Temp_Ray.Direction.y/Temp_Ray.Direction.x;     }=   else 3     {N'     Mzx = Temp_Ray.Direction.z/EPSILON;g'     Myx = Temp_Ray.Direction.y/EPSILON;      } +   if(fabs(Temp_Ray.Direction.z) > EPSILON) )     {T4     Mxz = Temp_Ray.Direction.x/Temp_Ray.Direction.z;4     Myz = Temp_Ray.Direction.y/Temp_Ray.Direction.z;     }    else l     {;'     Mxz = Temp_Ray.Direction.x/EPSILON;>'     Myz = Temp_Ray.Direction.y/EPSILON;      }        Hf_Stack = Depth_Stack;(
   RRay = Ray;a  $   isdx = sign(Temp_Ray.Direction.x);$   isdz = sign(Temp_Ray.Direction.z);     X_Dom = FALSE;>   if(fabs(Temp_Ray.Direction.x) >= fabs(Temp_Ray.Direction.z))     X_Dom = TRUE;x     Gdx = fabs(Mxz);   Gdz = fabs(Mzx);   if(X_Dom)      {;     Gdy = Myx * (DBL)isdx;     }l   else 1     {f     Gdy = Myz * (DBL)isdz;     }   A     if(Intersect_Csg_Hf_Node(&Temp_Ray, H_Field, &Temp1, &Temp2))"       ret_val = TRUE;=   return(ret_val);   }z  % int Inside_HeightFld (IPoint, Object)= VECTOR *IPoint;t OBJECT *Object;    {a2   HEIGHT_FIELD *H_Field = (HEIGHT_FIELD *) Object;
   int px, pz; %   DBL x,z,y1,y2,y3,water, dot1, dot2;)8   VECTOR Local_Origin, Temp1, Temp2, Local_Normal, Test;  0   MInvTransPoint(&Test, IPoint, H_Field->Trans);  -   water = H_Field->bounding_box->bounds[0].y;    if ((Test.x < 0.0) || (Test.x >= H_Field->bounding_box->bounds[1].x) || (Test.z < 0.0) || (Test.z >= H_Field->bounding_box->bounds[1].z))_     return (H_Field->Inverted);m  3   if (Test.y >= H_Field->bounding_box->bounds[1].y))     return (H_Field->Inverted);c     if (Test.y < water)l&     return (H_Field->Inverted ^ TRUE);     px = (int)Test.x;)   pz = (int)Test.z;;   x = Test.x - (DBL)px;    z = Test.z - (DBL)pz;0     if((x+z)<1.0)      {i4     y1 = max_value(Get_Height(px,pz,H_Field),water);6     y2 = max_value(Get_Height(px+1,pz,H_Field),water);6     y3 = max_value(Get_Height(px,pz+1,H_Field),water);2     Make_Vector(&Local_Origin,(DBL)px,y1,(DBL)pz);     Temp1.x = 1.0;     Temp1.z = 0.0;     Temp1.y = y2 - y1;     Temp2.x = 0.0;     Temp2.z = 1.0;     Temp2.y = y3 - y1;     }0   else       {&     px = (int)ceil(Test.x);      pz = (int)ceil(Test.z);w4     y1 = max_value(Get_Height(px,pz,H_Field),water);6     y2 = max_value(Get_Height(px-1,pz,H_Field),water);6     y3 = max_value(Get_Height(px,pz-1,H_Field),water);2     Make_Vector(&Local_Origin,(DBL)px,y1,(DBL)pz);     Temp1.x = -1.0;      Temp1.z = 0.0;     Temp1.y = y2 - y1;     Temp2.x = 0.0;     Temp2.z = -1.0;t     Temp2.y = y3 - y1;     }m#   VCross(Local_Normal,Temp2,Temp1);l   VDot(dot1,Test,Local_Normal); '   VDot(dot2,Local_Origin,Local_Normal);    if(dot1 < dot2)g#     return(TRUE^H_Field->Inverted); "   return(FALSE^H_Field->Inverted);   }t   static DBL stretch (x)r DBL x;   { 
   if(x<=0.5)       {-     x = 2 * x*x;     }    else n     { $     x = 1.0 - (2 * (1.0-x)*(1.0-x));     }    return x;    }   0   void HeightFld_Normal (Result, Object, IPoint)     OBJECT *Object;  VECTOR *Result, *IPoint;   { 2   HEIGHT_FIELD *H_Field = (HEIGHT_FIELD *) Object;   int px,pz, i, code;;   DBL x,z,y1,y2,y3,u,v; $   VECTOR Local_Origin, Temp1, Temp2;   VECTOR n[5];  8   MInvTransPoint(&Local_Origin, IPoint, H_Field->Trans);  $   for(i=0;i<H_Field->cache_pos;i++)      {[@     if(((float)Local_Origin.x == H_Field->Normal_Vector[i].x) &&>       ((float)Local_Origin.z == H_Field->Normal_Vector[i].z))        {a1       *Result = H_Field->Normal_Vector[i].normal;H1       MTransNormal(Result,Result,H_Field->Trans);t"       VNormalize(*Result,*Result);
       return;_       }o     }]     px = (int)Local_Origin.x;t   pz = (int)Local_Origin.z;m   x = Local_Origin.x - (DBL)px;k   z = Local_Origin.z - (DBL)pz;      px = (int)Local_Origin.x;0   pz = (int)Local_Origin.z;    x = Local_Origin.x - (DBL)px;g   z = Local_Origin.z - (DBL)pz;    if ((x+z) <= 1.0)      code = LOWER_TRI;a   else s     code = UPPER_TRI;;     if (H_Field->Smoothed)       { )     n[0].x = H_Field->Normals[pz][px][0]; )     n[0].y = H_Field->Normals[pz][px][1];f)     n[0].z = H_Field->Normals[pz][px][2]; +     n[1].x = H_Field->Normals[pz][px+1][0];x+     n[1].y = H_Field->Normals[pz][px+1][1];a+     n[1].z = H_Field->Normals[pz][px+1][2]; +     n[2].x = H_Field->Normals[pz+1][px][0];.+     n[2].y = H_Field->Normals[pz+1][px][1]; +     n[2].z = H_Field->Normals[pz+1][px][2];l-     n[3].x = H_Field->Normals[pz+1][px+1][0]; -     n[3].y = H_Field->Normals[pz+1][px+1][1]; -     n[3].z = H_Field->Normals[pz+1][px+1][2];,     x = stretch(x);e     z = stretch(z);l     u = (1.0 - x);     v = (1.0 - z);  &     /* 	 n[4].x = u*n[0].x + x*n[1].x; 	 n[4].y = u*n[0].y + x*n[1].y;  	 n[4].z = u*n[0].z + x*n[1].z;t   	 n[5].x = u*n[2].x + x*n[3].x;t 	 n[5].y = u*n[2].y + x*n[3].y;c 	 n[5].z = u*n[2].z + x*n[3].z;    	 n[6].x = v*n[0].x + z*n[2].x;t 	 n[6].y = v*n[0].y + z*n[2].y;E 	 n[6].z = v*n[0].z + z*n[2].z;L   	 n[7].x = v*n[1].x + z*n[3].x;s 	 n[7].y = v*n[1].y + z*n[3].y;a 	 n[7].z = v*n[1].z + z*n[3].z;d  8 	 Result->x = u*n[6].x + x*n[7].x + v*n[4].x + z*n[5].x;8 	 Result->y = u*n[6].y + x*n[7].y + v*n[4].y + z*n[5].y;8 	 Result->z = u*n[6].z + x*n[7].z + z*n[4].z + v*n[5].z; */D     Result->x = u*v*n[0].x + x*v*n[1].x + u*z*n[2].x + x*z*n[3].x;	 D     Result->y = u*v*n[0].y + x*v*n[1].y + u*z*n[2].y + x*z*n[3].y;	 D     Result->z = u*v*n[0].z + x*v*n[1].z + u*z*n[2].z + x*z*n[3].z;	      }i   else if (code == LOWER_TRI)      {_#     y1 = Get_Height(px,pz,H_Field);_%     y2 = Get_Height(px+1,pz,H_Field);2%     y3 = Get_Height(px,pz+1,H_Field);      Temp1.x = 1.0;     Temp1.z = 0.0;     Temp1.y = y2 - y1;     Temp2.x = 0.0;     Temp2.z = 1.0;     Temp2.y = y3 - y1;      VCross(*Result,Temp2,Temp1);     }a   else       { '     y1 = Get_Height(px+1,pz+1,H_Field);e%     y2 = Get_Height(px,pz+1,H_Field);x%     y3 = Get_Height(px+1,pz,H_Field);R     Temp1.x = -1.0;a     Temp1.z = 0.0;     Temp1.y = y2 - y1;     Temp2.x = 0.0;     Temp2.z = -1.0;      Temp2.y = y3 - y1;      VCross(*Result,Temp2,Temp1);     }p-   MTransNormal(Result,Result,H_Field->Trans);e   VNormalize(*Result,*Result);	   return;    }      void *Copy_HeightFld (Object)e     OBJECT *Object;e   {y   HEIGHT_FIELD *New;     New = Create_Height_Field ();   ;   /*  Create_Height_Field creates a transform and a box as y6     does Copy_Transform and Copy_Box so destroy these. */      Destroy_Transform(New->Trans);-   Destroy_Box((OBJECT *)(New->bounding_box));r  #   *New = *((HEIGHT_FIELD *)Object);b  G   New->Trans        = Copy_Transform (((HEIGHT_FIELD *)Object)->Trans); T   New->bounding_box = Copy_Box ((OBJECT *)(((HEIGHT_FIELD *)Object)->bounding_box));  K   /* Note: For the time being we will not support copying the Block and MaprI    arrays.  We will only copy the pointers.  This means Destroy_HeightFld F    must not destroy these arrays.  Actually it cannot because we don't"    really know how big they are!   */     return (New);e   }t  ) void Translate_HeightFld (Object, Vector)p OBJECT *Object;t VECTOR *Vector;n   {_   TRANSFORM Trans;  /   Compute_Translation_Transform(&Trans,Vector);a>   Compose_Transforms(((HEIGHT_FIELD *) Object)->Trans,&Trans);   }n  & void Rotate_HeightFld (Object, Vector) OBJECT *Object;i VECTOR *Vector;i   {o   TRANSFORM Trans;  ,   Compute_Rotation_Transform(&Trans,Vector);>   Compose_Transforms(((HEIGHT_FIELD *) Object)->Trans,&Trans);   }c  % void Scale_HeightFld (Object, Vector)F OBJECT *Object;j VECTOR *Vector;=   {e   TRANSFORM Trans;  +   Compute_Scaling_Transform(&Trans,Vector);==   Compose_Transforms(((HEIGHT_FIELD *)Object)->Trans,&Trans);;   }    void Invert_HeightFld (Object) OBJECT *Object;T   {a-   ((HEIGHT_FIELD *)Object)->Inverted ^= TRUE;.   }a  ( void Transform_HeightFld (Object, Trans) OBJECT *Object;e TRANSFORM *Trans;    {q=   Compose_Transforms(((HEIGHT_FIELD *)Object)->Trans, Trans);,   }2  + /* Allocate and intialize a Height Field */ # HEIGHT_FIELD *Create_Height_Field()    {a   HEIGHT_FIELD *New;  D   if((New = (HEIGHT_FIELD *) malloc (sizeof(HEIGHT_FIELD))) == NULL)     MAError ("height field");;  E   INIT_OBJECT_FIELDS(New, HEIGHT_FIELD_OBJECT, &Height_Field_Methods)   3     /* Always uses Trans so always create one. */  y&     New->Trans = Create_Transform (); %   New->bounding_box = Create_Box (); P   New->Block_Size   = 1.0;   New->Inv_Blk_Size = 1.0;   New->Block = NULL;   New->Map   = NULL;   New->Inverted = FALSE;   New->cache_pos = 0;;   New->Smoothed = FALSE;   New->Normals  = NULL;    return(New);   }y   void Destroy_HeightFld (Object)= OBJECT *Object;    {=6   Destroy_Transform (((HEIGHT_FIELD *)Object)->Trans);A   Destroy_Box ((OBJECT *)((HEIGHT_FIELD *)Object)->bounding_box);y   free (Object);   }e