M /****************************************************************************  *                image.c * K *  This module implements the mapped textures including image map, bump map  *  and material map.   * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"  #include "texture.h"  ] static int cylindrical_image_map PARAMS((DBL x, DBL y, DBL z, IMAGE *Image, DBL *u, DBL *v)); W static int torus_image_map PARAMS((DBL x, DBL y, DBL z, IMAGE *Image, DBL *u, DBL *v)); [ static int spherical_image_map PARAMS((DBL x, DBL y, DBL z, IMAGE *Image, DBL *u, DBL *v)); X static int planar_image_map PARAMS((DBL x, DBL y, DBL z, IMAGE *Image, DBL *u, DBL *v));b static void no_interpolation PARAMS((IMAGE *Image,DBL xcoor,DBL ycoor,COLOUR *colour,int *index));7 static DBL bilinear PARAMS((DBL *corners,DBL x,DBL y)); 8 static DBL norm_dist PARAMS((DBL *corners,DBL x,DBL y));X static void Interp PARAMS((IMAGE *Image,DBL xcoor,DBL ycoor,COLOUR *colour,int *index));a static void image_colour_at PARAMS((IMAGE *Image,DBL xcoor,DBL ycoor,COLOUR *colour,int *index));    /*M    2-D to 3-D Procedural Texture Mapping of a Bitmapped Image onto an Object:              I A. Simplistic (planar) method of image projection devised by DKB and AAC:   2    1. Transform texture in 3-D space if requested.J    2. Determine local object 2-d coords from 3-d coords by <X Y Z> triple.L    3. Return pixel color value at that position on the 2-d plane of "Image".N    3. Map colour value in Image [0..255] to a more normal colour range [0..1].  @ B. Specialized shape projection variations by Alexander Enzmann:      1. Cylindrical mapping     2. Spherical mapping     3. Torus mapping  */  ) void image_map (x, y, z, Pigment, colour)  DBL x, y, z; PIGMENT *Pigment;  COLOUR *colour;    { 9   /* determine local object 2-d coords from 3-d coords */ 5   /* "unwrap" object 2-d coord onto flat 2-d plane */ :   /* return pixel color value at that posn on 2-d plane */      DBL xcoor = 0.0, ycoor = 0.0	;   int reg_number;   I   if(map (x, y, z, ((TPATTERN *)Pigment), Pigment->Image,&xcoor, &ycoor))      { *     Make_ColourA (colour,1.0,1.0,1.0,1.0);     return;      } D   image_colour_at(Pigment->Image,xcoor, ycoor, colour, &reg_number);   }   L /* Very different stuff than the other routines here. This routine takes  */L /* an intersection point and a texture and returns a new texture based on */L /* the index/color of that point in an image/materials map. CdW 7/91      */  % TEXTURE *material_map(IPoint,Texture)  VECTOR *IPoint;  MATERIAL *Texture;   {    register DBL x, y, z;    DBL xcoor = 0.0, ycoor = 0.0;    int reg_number = 0;    COLOUR colour;   int Material_Number=0;   TEXTURE *Temp_Tex;
   int numtex;    VECTOR TPoint;   TPATTERN TPattern;  &   INIT_TPATTERN_FIELDS((&TPattern),0);(   Make_ColourA(&colour,0.0,0.0,0.0,0.0);     if (Texture->Trans != NULL) 5     MInvTransPoint (&TPoint, IPoint, Texture->Trans);    else       TPoint = *IPoint;      x = TPoint.x;    y = TPoint.y;    z = TPoint.z;   D   /* now we have transformed x, y, z we use image mapping routine */"   /* to determine texture index */=   if(map (x, y, z, &TPattern, Texture->Image,&xcoor, &ycoor))      Material_Number=0;	     else{ G     image_colour_at(Texture->Image,xcoor, ycoor, &colour, &reg_number);   ,     if (Texture->Image->Colour_Map == NULL) ,       Material_Number = (int)colour.Red*255;	     else  #       Material_Number = reg_number;      }   ,   if(Material_Number > Texture->Num_Of_Mats),     Material_Number %= Texture->Num_Of_Mats;.   for(numtex=0, Temp_Tex = Texture->Materials;A   (Temp_Tex->Next_Material != NULL) && (numtex<Material_Number);  /   Temp_Tex = Temp_Tex->Next_Material, numtex++)      ; /* do nothing */     return(Temp_Tex);      }   & TEXTURE *tiles_texture(IPoint,Texture) VECTOR *IPoint;  TILES *Texture;    {    int Block;   VECTOR TPoint;     if (Texture->Trans != NULL) 5     MInvTransPoint (&TPoint, IPoint, Texture->Trans);    else       TPoint = *IPoint;   /   Block = (int)(FLOOR(TPoint.x+Small_Tolerance) $     +FLOOR(TPoint.y+Small_Tolerance)&     +FLOOR(TPoint.z+Small_Tolerance));     if (Block & 1)     return(Texture->Tile1);    else     return(Texture->Tile2);      }     ( void bump_map (x, y, z, Tnormal, normal) DBL x, y, z; TNORMAL *Tnormal;  VECTOR *normal;    {    DBL xcoor = 0.0, ycoor = 0.0;    int index,index2,index3;"   COLOUR colour, colour2, colour3;   VECTOR p1,p2,p3;   VECTOR bump_normal; &   VECTOR xprime, yprime, zprime, Temp;
   DBL Length;    DBL Amount = Tnormal->Amount;     IMAGE *Image = Tnormal->Image;)   Make_ColourA (&colour,0.0,0.0,0.0,0.0); *   Make_ColourA (&colour2,0.0,0.0,0.0,0.0);*   Make_ColourA (&colour3,0.0,0.0,0.0,0.0);  $   /* going to have to change this */C   /* need to know if bump point is off of image for all 3 points */   >   if(map (x, y, z, (TPATTERN *)Tnormal, Image,&xcoor, &ycoor))     return;    else9     image_colour_at(Image,xcoor, ycoor, &colour, &index);   
   xcoor--;
   ycoor++;   if (xcoor < 0.0)      xcoor += (DBL)Image->iwidth;"   else if (xcoor >= Image->iwidth)      xcoor -= (DBL)Image->iwidth;   if (ycoor < 0.0)!     ycoor += (DBL)Image->iheight; (   else if (ycoor >=(DBL) Image->iheight)!     ycoor -= (DBL)Image->iheight; 9   image_colour_at(Image,xcoor, ycoor, &colour2, &index2);      xcoor +=2.0;   if (xcoor < 0.0)      xcoor += (DBL)Image->iwidth;"   else if (xcoor >= Image->iwidth)      xcoor -= (DBL)Image->iwidth;  9   image_colour_at(Image,xcoor, ycoor, &colour3, &index3);      if (Options & DEBUGGING)L     printf ("Bump Map %g %g %g xcoor %g ycoor %g\n", x, y, z, xcoor, ycoor);  #   if (Image->Colour_Map == NULL ||       Image->Use_Colour_Flag )       {      p1.x = 0; 
     p1.y =C     Amount*(0.229*colour.Red+0.587*colour.Green+0.114*colour.Blue); 
     p1.z = 0;      p2.x = 0; 
     p2.y =F     Amount*(0.229*colour2.Red+0.587*colour2.Green+0.114*colour2.Blue);
     p2.z = 1;      p3.x = 1; 
     p3.y =F     Amount*(0.229*colour3.Red+0.587*colour3.Green+0.114*colour3.Blue);
     p3.z = 1;      }    else       {      p1.x = 0;      p1.y = Amount * index;
     p1.z = 0;      p2.x = 0;      p2.y = Amount * index2; 
     p2.z = 1;      p3.x = 1;      p3.y = Amount * index3; 
     p3.z = 1;      } N   /* we have points 1,2,3 for a triangle now we need the surface normal for it */     VSub (xprime, p1, p2);   VSub (yprime, p3, p2);'   VCross (bump_normal, yprime, xprime); '   VNormalize(bump_normal, bump_normal);   7     Make_Vector(&yprime,normal->x,normal->y,normal->z); !   Make_Vector(&Temp,0.0,1.0,0.0);    VCross (xprime,yprime,Temp);   VLength(Length,xprime);    if(Length < 1.0e-9)      { -     if(fabs(normal->y - 1.0)<Small_Tolerance)        { '       Make_Vector(&yprime,0.0,1.0,0.0); '       Make_Vector(&xprime,1.0,0.0,0.0);        Length = 1.0;        }      else       { (       Make_Vector(&yprime,0.0,-1.0,0.0);'       Make_Vector(&xprime,1.0,0.0,0.0);        Length = 1.0;        }      } #   VScale(xprime,xprime,1.0/Length);     VCross (zprime,xprime,yprime);   VNormalize(zprime,zprime);&   VScale(xprime,xprime,bump_normal.x);&   VScale(yprime,yprime,bump_normal.y);&   VScale(zprime,zprime,bump_normal.z);   VAdd(Temp,xprime,yprime);    VAdd(*normal,Temp,zprime);   VNormalize(*normal,*normal);  	   return;a   }e    ? static void image_colour_at(Image, xcoor, ycoor, colour, index)- IMAGE *Image;      DBL xcoor, ycoor;- COLOUR *colour;  int *index;i   {  e  #   switch(Image->Interpolation_Type)y   {r   case NO_INTERPOLATION:5     no_interpolation(Image,xcoor,ycoor,colour,index);e
     break;   default: e.     Interp(Image,xcoor, ycoor, colour, index);
     break;   }      }r      J /* Map a point (x, y, z) on a cylinder of radius 1, height 1, that has itsB    axis of symmetry along the y-axis to the square [0,1]x[0,1]. */7 static int cylindrical_image_map (x, y, z, Image, u, v)T DBL x, y, z;
 IMAGE *Image;m DBL *u, *v;p   {e   DBL len, theta;e  5   if ((Image->Once_Flag) && ((y < 0.0) || (y > 1.0)))n
     return 0;./   *v = fmod (y * Image->height, Image->height);r  4   /* Make sure this vector is on the unit sphere. */   len = sqrt(x*x + y*y + z*z);   if (len == 0.0)w
     return 0;    else       {.
     x /= len; 
     z /= len;*     }   F   /* Determine its angle from the point (1, 0, 0) in the x-z plane. */     len = sqrt(x*x + z*z);   if (len == 0.0) 
     return 0;t   else       {i     if (z == 0.0)e       if (x > 0)         theta = 0.0;
       else         theta = M_PI;i	     else a       {R       theta = acos(x / len);.       if (z < 0.0) theta = 2.0 * M_PI - theta;       }m7     theta /= 2.0 * M_PI; /* This will be from 0 to 1 */      }    *u = (theta * Image->width);   return 1;L   }B  7 /* Map a point (x, y, z) on a torus  to a 2-d image. */o1 static int torus_image_map (x, y, z, Image, u, v)O DBL x, y, z;
 IMAGE *Image;t DBL *u, *v;a   {A   DBL len, phi, theta;	   DBL r0;t     r0 = Image->Gradient.x;L  ,   /* Determine its angle from the x-axis. */   len = sqrt(x*x + z*z);   if (len == 0.0)*
     return 0;e   else t     {      if (z == 0.0)A       if (x > 0)         theta = 0.0;
       else         theta = M_PI; 	     else         {l       theta = acos(x / len);.       if (z < 0.0) theta = 2.0 * M_PI - theta;       }a     }t   theta = 0.0 - theta;  R   /* Now rotate about the y-axis to get the point (x, y, z) into the x-y plane. */   x = len - r0;b   len = sqrt(x * x + y * y);   phi = acos(-x / len);3&   if (y > 0.0) phi = 2.0 * M_PI - phi;  -   /* Determine the parametric coordinates. */r   theta /= 2.0 * M_PI;   phi /= 2.0 * M_PI;   *u = (-theta * Image->width);d   *v = (phi * Image->height);    return 1;m   }   N /* Map a point (x, y, z) on a sphere of radius 1 to a 2-d image. (Or is it the    other way around?) */5 static int spherical_image_map (x, y, z, Image, u, v)O DBL x, y, z;
 IMAGE *Image;t DBL *u, *v;o   {    DBL len, phi, theta;  4   /* Make sure this vector is on the unit sphere. */   len = sqrt(x*x + y*y + z*z);   if (len == 0.0)o
     return 0;    else c     {.
     x /= len;;
     y /= len;b
     z /= len;p     } /   /* Determine its angle from the x-z plane. */&>     phi = 0.5 + asin(y) / M_PI; /* This will be from 0 to 1 */  F   /* Determine its angle from the point (1, 0, 0) in the x-z plane. */   len = sqrt(x*x + z*z);   if (len == 0.0)      {tM     /* This point is at one of the poles. Any value of xcoord will be ok...*/t     theta = 0;     }w   else b     {      if (z == 0.0)l       if (x > 0)         theta = 0.0;
       else         theta = M_PI;t	     else P       {u       theta = acos(x / len);.       if (z < 0.0) theta = 2.0 * M_PI - theta;       } 7     theta /= 2.0 * M_PI; /* This will be from 0 to 1 */l     }    *u = (theta * Image->width);   *v = (phi * Image->height);    return 1;;   }P   /*M    2-D to 3-D Procedural Texture Mapping of a Bitmapped Image onto an Object:0 	   N    Simplistic planar method of object image projection devised by DKB and AAC.  2    1. Transform texture in 3-D space if requested.J    2. Determine local object 2-d coords from 3-d coords by <X Y Z> triple.L    3. Return pixel color value at that position on the 2-d plane of "Image".N    3. Map colour value in Image [0..255] to a more normal colour range [0..1]. */  I /* Return 0 if there is no color at this point (i.e. invisible), return 1o!    if a good mapping is found. */t1 static int planar_image_map(x, y, z, Image, u, v)m DBL x, y, z;
 IMAGE *Image;  DBL *u, *v;    {  i"   if (Image -> Gradient.x != 0.0)      {t     if ((Image->Once_Flag) &&M       ((x < 0.0) || (x > 1.0)))u       return 0;       if (Image -> Gradient.x > 0)1       *u = fmod (x * Image->width, Image->width);&     else3       *v = fmod (x * Image->height, Image->height);i     }t"   if (Image -> Gradient.y != 0.0)      {T     if ((Image->Once_Flag) &&t       ((y < 0.0) || (y > 1.0)))T       return 0;E      if (Image -> Gradient.y > 0)1       *u = fmod (y * Image->width, Image->width);      else3       *v = fmod (y * Image->height, Image->height);      }P"   if (Image -> Gradient.z != 0.0)      {P     if ((Image->Once_Flag) &&F       ((z < 0.0) || (z > 1.0)))        return 0;+      if (Image -> Gradient.z > 0)1       *u = fmod (z * Image->width, Image->width);u     else3       *v = fmod (z * Image->height, Image->height);a     }a   return 1;    }NF /* Map returns 1 if no color found (invisible) or 0 if color found */ 0 int map (x, y, z, TPattern, Image, xcoor, ycoor) DBL x, y, z; TPATTERN *TPattern;;
 IMAGE *Image;_ DBL *xcoor, *ycoor;r   {y9   /* determine local object 2-d coords from 3-d coords */l5   /* "unwrap" object 2-d coord onto flat 2-d plane */l:   /* return pixel color value at that posn on 2-d plane */  A   /* This causes problems so let's do without it for this releaseg#    if (TPattern->Turbulence != 0.0)n      {B       DTurbulence (&TextureTurbulence, x, y, z,TPattern->Octaves);6       x += TextureTurbulence.x * TPattern->Turbulence;6       y += TextureTurbulence.y * TPattern->Turbulence;6       z += TextureTurbulence.z * TPattern->Turbulence;      }    */   *   /* Now determine which mapper to use. */   switch (Image->Map_Type) o   {(   case PLANAR_MAP:9     if (!planar_image_map(x, y, z, Image, xcoor, ycoor)) l       return(1);
     break;   case SPHERICAL_MAP:B;     if (!spherical_image_map(x, y, z,Image, xcoor, ycoor)) l       return(1);
     break;   case CYLINDRICAL_MAP: =     if (!cylindrical_image_map(x, y, z,Image, xcoor, ycoor)) i       return(1);
     break;   case TORUS_MAP:_7     if (!torus_image_map(x, y, z,Image, xcoor, ycoor)) f       return(1);
     break;
   default:8     if (!planar_image_map(x, y, z,Image, xcoor, ycoor))        return(1);
     break;   }   /   /* Now make sure the point is on the image */1   *ycoor += Small_Tolerance;   *xcoor += Small_Tolerance;C   /* Compensate for y coordinates on the images being upsidedown */2(   *ycoor = (DBL)Image->iheight - *ycoor;     if (*xcoor < 0.0)o!     *xcoor +=(DBL) Image->iwidth;x'   else if (*xcoor >=(DBL)Image->iwidth)o!     *xcoor -= (DBL)Image->iwidth;o     if (*ycoor < 0.0)="     *ycoor += (DBL)Image->iheight;)   else if (*ycoor >= (DBL)Image->iheight) "     *ycoor -= (DBL)Image->iheight;     if (Options & DEBUGGING)t     printf ("\nmap %g %g %g xcoor %g ycoor %g ih %d iw %d\n", x, y, z, *xcoor, *ycoor,Image->iheight,Image->iwidth);  '   if ((*xcoor >= (DBL)Image->iwidth) || &     (*ycoor >= (DBL)Image->iheight) ||&     (*xcoor < 0.0) || (*ycoor < 0.0))      {r.     printf ("\nPicture index out of range\n");     close_all();
     exit (1);l     }m   return(0);       }a  @ static void no_interpolation(Image, xcoor, ycoor, colour, index) IMAGE *Image;      DBL xcoor, ycoor;. COLOUR *colour;  int *index;m   {      struct Image_Line *line;   int iycoor, ixcoor;(   IMAGE_COLOUR *map_colour;      if (xcoor < 0.0)      xcoor += (DBL)Image->iwidth;'   else if (xcoor >= (DBL)Image->iwidth)e      xcoor -= (DBL)Image->iwidth;   if (ycoor < 0.0)!     ycoor += (DBL)Image->iheight;1(   else if (ycoor >=(DBL) Image->iheight)"     ycoor -= (DBL) Image->iheight;     iycoor=(int)ycoor;   ixcoor=(int)xcoor;!   if (Image->Colour_Map == NULL) l     { *     line = &Image->data.rgb_lines[iycoor];3     colour -> Red += (DBL) line->red[ixcoor]/255.0;y7     colour -> Green += (DBL) line->green[ixcoor]/255.0;m5     colour -> Blue += (DBL) line->blue[ixcoor]/255.0;_     *index = -1;     }    else u     {   3     *index = Image->data.map_lines[iycoor][ixcoor];o,     map_colour = &Image->Colour_Map[*index];S     /*printf ("icat index %d xc %d yc %d  CLR %d %d %d %d\n",*index,ixcoor,iycoor, rO     map_colour->Red,map_colour->Green,map_colour->Blue,map_colour->Filter ); */c3     colour -> Red   += (DBL) map_colour->Red/255.0;p5     colour -> Green += (DBL) map_colour->Green/255.0; 4     colour -> Blue  += (DBL) map_colour->Blue/255.0;7     colour -> Filter += (DBL) map_colour->Filter/255.0;m     }y       if (Options & DEBUGGING)R       printf ("\n no_interpolation index %d xc %d yc %d \n",*index,ixcoor,iycoor);   }(  6 /* Interpolate color and filter values when mapping */  6 static void Interp(Image, xcoor, ycoor, colour, index) IMAGE *Image;      DBL xcoor, ycoor;  COLOUR *colour;z int *index;e   {  0   int iycoor, ixcoor,i;e   int Corners_Index[4];    DBL Index_Crn[4];    COLOUR Corner_Colour[4];   DBL Red_Crn[4];1   DBL Green_Crn[4];a   DBL Blue_Crn[4];   DBL Filter_Crn[4];   DBL val1, val2, val3,val4;     iycoor=(int)ycoor;   ixcoor=(int)xcoor;   for(i=0;i<4;i++)     {./     Make_Colour(&Corner_Colour[i],0.0,0.0,0.0);a!     Corner_Colour[i].Filter=0.0; l     } N   /* OK, now that you have the corners, what are you going to do with them? */)   if(Image->Interpolation_Type==BILINEAR)      {hZ     no_interpolation(Image,(DBL)ixcoor+1,(DBL)iycoor,&Corner_Colour[0],&Corners_Index[0]);X     no_interpolation(Image,(DBL)ixcoor,(DBL)iycoor,&Corner_Colour[1],&Corners_Index[1]);\     no_interpolation(Image,(DBL)ixcoor+1,(DBL)iycoor-1,&Corner_Colour[2],&Corners_Index[2]);Z     no_interpolation(Image,(DBL)ixcoor,(DBL)iycoor-1,&Corner_Colour[3],&Corners_Index[3]);     for(i=0;i<4;i++)       { (       Red_Crn[i] = Corner_Colour[i].Red;,       Green_Crn[i] = Corner_Colour[i].Green;*       Blue_Crn[i] = Corner_Colour[i].Blue;.       Filter_Crn[i] = Corner_Colour[i].Filter;S       /* printf("Crn %d = %lf %lf %lf\n",i,Red_Crn[i],Blue_Crn[i],Green_Crn[i]); */-       }e  )     val1 = bilinear(Red_Crn,xcoor,ycoor); +     val2 = bilinear(Green_Crn,xcoor,ycoor);;*     val3 = bilinear(Blue_Crn,xcoor,ycoor);,     val4 = bilinear(Filter_Crn,xcoor,ycoor);     }i0   if(Image->Interpolation_Type==NORMALIZED_DIST)     {*Z     no_interpolation(Image,(DBL)ixcoor,(DBL)iycoor-1,&Corner_Colour[0],&Corners_Index[0]);\     no_interpolation(Image,(DBL)ixcoor+1,(DBL)iycoor-1,&Corner_Colour[1],&Corners_Index[1]);X     no_interpolation(Image,(DBL)ixcoor,(DBL)iycoor,&Corner_Colour[2],&Corners_Index[2]);Z     no_interpolation(Image,(DBL)ixcoor+1,(DBL)iycoor,&Corner_Colour[3],&Corners_Index[3]);     for(i=0;i<4;i++)       {t(       Red_Crn[i] = Corner_Colour[i].Red;,       Green_Crn[i] = Corner_Colour[i].Green;*       Blue_Crn[i] = Corner_Colour[i].Blue;.       Filter_Crn[i] = Corner_Colour[i].Filter;S       /* printf("Crn %d = %lf %lf %lf\n",i,Red_Crn[i],Blue_Crn[i],Green_Crn[i]); */a       }   *     val1 = norm_dist(Red_Crn,xcoor,ycoor);,     val2 = norm_dist(Green_Crn,xcoor,ycoor);+     val3 = norm_dist(Blue_Crn,xcoor,ycoor); -     val4 = norm_dist(Filter_Crn,xcoor,ycoor);      }      colour->Red   += val1;   colour->Green += val2;   colour->Blue  += val3;   colour->Filter += val4;t8   /* printf("Final = %lf %lf %lf\n",val1,val2,val3);  */0   /* use bilinear for index try average later */   for(i=0;i<4;i++)*     Index_Crn[i] = (DBL) Corners_Index[i];)   if(Image->Interpolation_Type==BILINEAR)h     {v8     *index = (int)(bilinear(Index_Crn,xcoor,ycoor)+0.5);     }-0   if(Image->Interpolation_Type==NORMALIZED_DIST)     { 9     *index = (int)(norm_dist(Index_Crn,xcoor,ycoor)+0.5);      }i   }v  A /* These interpolation techniques are taken from an article by */s= /* Girish T. Hagan in the C Programmer's Journal V 9 No. 8 */y* /* They were adapted for POV-Ray by CdW */  " static DBL bilinear (corners, x,y) DBL *corners, x,y;       {r
   DBL p,q;   DBL val = 0.0;     p = x - (int) x;   q = y - (int) y;   if ((p==0.0) && (q==0.0))r&     return(*corners); /* upper left */  4   val = (p*q* *corners) + (q*(1-p)* *(corners+1)) + 8   (p*(1-q)* *(corners+2)) + ((1-p)*(1-q)* *(corners+3));   return(val);   }        #define MAX_PTS 4a2 #define PYTHAGOREAN_SQ(a,b)  ( (a)*(a) + (b)*(b) )  ! static DBL norm_dist(corners,x,y)u DBL *corners,x,y;    {f   register int i;.  
   DBL p,q;   DBL wts[MAX_PTS];>   DBL sum_inv_wts = 0.0;   DBL sum_I  = 0.0;o     p = x - (int) x;   q = y - (int) y;     if( (p==0.0) && (q==0.0) )&     return(*corners); /* upper left */     wts[0] = PYTHAGOREAN_SQ(p,q);1!   wts[1] = PYTHAGOREAN_SQ(1-p,q);m!   wts[2] = PYTHAGOREAN_SQ(p,1-q);f#   wts[3] = PYTHAGOREAN_SQ(1-p,1-q);      for(i=0; i<MAX_PTS; i++)     {e     sum_inv_wts += 1/wts[i];!     sum_I += *(corners+i)/wts[i];0     }      return( sum_I /sum_inv_wts );F   }    IMAGE *Copy_Image (Old)  IMAGE *Old;n   {    return (Old);G   }n   IMAGE *Create_Image ()   {I   IMAGE *Image;e  7   if ((Image = (IMAGE *)malloc(sizeof(IMAGE))) == NULL)m     MAError("image file");   Image->File_Type = 0;t   Image->Map_Type = PLANAR_MAP;l/   Image->Interpolation_Type = NO_INTERPOLATION;t   Image->Once_Flag = FALSE;B    Image->Use_Colour_Flag= FALSE;1   Make_Vector (&Image->Gradient, 1.0, -1.0, 0.0);t   return (Image);    }o   void Destroy_Image (Image)
 IMAGE *Image;t   {c   }o