M /****************************************************************************  *                   lighting.c * N *  This module calculates lighting properties like ambient, diffuse, specular, *  reflection, refraction, etc.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment K *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file D *  named POVLEGAL.DOC which should be distributed with this file. IfL *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"    extern int Trace_Level;  extern FRAME Frame;  extern OBJECT *Root_Object;  extern unsigned int Options; extern int Use_Slabs; # extern unsigned long Quality_Flags;  extern int Shadow_Test_Flag;G extern long Shadow_Ray_Tests, Shadow_Rays_Succeeded, Shadow_Cache_Hits; 9 extern long Reflected_Rays_Traced, Refracted_Rays_Traced; $ extern long Transmitted_Rays_Traced;   extern short *hashTable;" extern unsigned short crctab[256];_ #define rand3d(a,b) crctab[(int)(hashTable[(int)(hashTable[(int)((a)&0xfff)]^(b))&0xfff])&0xff]    #define COORDINATE_LIMIT 1.0e17  #define BLACK_LEVEL 0.003   M /* "Small_Tolerance" is just too tight for higher order polynomial equations. J    this value should probably be a variable of some sort, but for now justJ    use a reasonably small value.  If people render real small objects realJ    close to each other then there may be some shading problems.  OtherwiseC    having SHADOW_TOLERANCE as large as this won't affect images. */  #define SHADOW_TOLERANCE 1.0e-3   8 static void do_light PARAMS((LIGHT_SOURCE *Light_Source,? DBL *Light_Source_Depth, RAY *Light_Source_Ray, VECTOR *IPoint,  COLOUR *Light_Colour)); @ static int do_blocking PARAMS((INTERSECTION *Local_Intersection,, COLOUR *Light_Colour, ISTACK *Local_Stack));C static void do_phong PARAMS((FINISH *Finish, RAY *Light_Source_Ray, H VECTOR *Eye, VECTOR *Layer_Normal, COLOUR *Colour, COLOUR *Light_Colour, COLOUR *Layer_Pigment_Colour)); F static void do_specular PARAMS((FINISH *Finish, RAY *Light_Source_Ray,I VECTOR *REye, VECTOR *Layer_Normal, COLOUR *Colour, COLOUR *Light_Colour,  COLOUR *Layer_Pigment_Colour)); E static void do_diffuse PARAMS((FINISH *Finish, RAY *Light_Source_Ray, ; VECTOR *Layer_Normal, COLOUR *Colour, COLOUR *Light_Colour, 0 COLOUR *Layer_Pigment_Colour, DBL Attenuation));@ static void Block_Area_Light PARAMS((LIGHT_SOURCE *Light_Source,B DBL Light_Source_Depth, RAY *Light_Source_Ray_Ptr, VECTOR *IPoint,B COLOUR *Light_Colour, int u1, int v1, int u2, int v2, int Level));A static void Block_Point_Light PARAMS((LIGHT_SOURCE *Light_Source, J DBL Light_Source_Depth, RAY *Light_Source_Ray_Ptr, COLOUR *Light_Colour));  d static void Block_Point_Light (Light_Source, Light_Source_Depth, Light_Source_Ray_Ptr, Light_Colour) LIGHT_SOURCE *Light_Source;  DBL Light_Source_Depth;  RAY *Light_Source_Ray_Ptr; COLOUR *Light_Colour;    {    OBJECT *Blocking_Object;/   int Quit_Looking, Not_Found_Shadow, Cache_Me; 9   INTERSECTION *Local_Intersection, Bounded_Intersection;    ISTACK *Local_Stack;   RAY Local_Ray;   RAY Light_Source_Ray;   +   Light_Source_Ray = *Light_Source_Ray_Ptr;      Local_Stack = open_istack ();    Quit_Looking = FALSE;   $   /* Test the cached object first */F   /* Made changes so that semi-transparent objects never get cached */2   if (Light_Source->Shadow_Cached_Object != NULL)      {      Shadow_Ray_Tests++;   U     if (Ray_In_Bounds (&Light_Source_Ray, Light_Source->Shadow_Cached_Object->Bound))        { a       if (All_Intersections (Light_Source->Shadow_Cached_Object, &Light_Source_Ray, Local_Stack)) C         while ((Local_Intersection=pop_entry(Local_Stack)) != NULL)            { ?           if ((!Local_Intersection->Object->No_Shadow_Flag) &&  P             (Local_Intersection->Depth < Light_Source_Depth-Small_Tolerance) && ;             (Local_Intersection->Depth > SHADOW_TOLERANCE)) K             if (do_blocking(Local_Intersection, Light_Colour, Local_Stack))                { "               Quit_Looking = TRUE;"               Shadow_Cache_Hits++;               break;               }            }        }      }      if (Quit_Looking)      {      close_istack (Local_Stack);      return;      }      Not_Found_Shadow = TRUE;       Cache_Me = FALSE;    if (!Use_Slabs)      { )     for (Blocking_Object = Frame.Objects;      Blocking_Object != NULL;/     Blocking_Object = Blocking_Object->Sibling)        { @       if (Blocking_Object == Light_Source->Shadow_Cached_Object)         continue;          Shadow_Ray_Tests++;   E       if (!Ray_In_Bounds (&Light_Source_Ray, Blocking_Object->Bound))          continue;   O       if (!All_Intersections (Blocking_Object, &Light_Source_Ray, Local_Stack))          continue;   C       while ((Local_Intersection = pop_entry(Local_Stack)) != NULL) =         if ((!Local_Intersection->Object->No_Shadow_Flag) &&  N           (Local_Intersection->Depth < Light_Source_Depth-Small_Tolerance) && 9           (Local_Intersection->Depth > SHADOW_TOLERANCE))            { I           if (do_blocking(Local_Intersection, Light_Colour, Local_Stack)) 
             { (             Cache_Me = Not_Found_Shadow;              Quit_Looking = TRUE;#             break; /* from while */ 
             } #           Not_Found_Shadow = FALSE;            }        if (Quit_Looking)          break; /* from for */        }      } 5   else   /* Use bounding slabs to look for shadows */      { !     Local_Ray = Light_Source_Ray;      while (!Quit_Looking)        {        Shadow_Ray_Tests++; -       Local_Ray.Quadric_Constants_Cached = 0; 6       Bounded_Intersection.Depth = Light_Source_Depth;J       if (Bounds_Intersect(Root_Object, &Local_Ray, &Bounded_Intersection,         &Blocking_Object))  	         { =         if (Bounded_Intersection.Depth > Light_Source_Depth)  8           break; /* Intersection was beyond the light */  ;         if (!(Bounded_Intersection.Object->No_Shadow_Flag)) D           if (Blocking_Object != Light_Source->Shadow_Cached_Object)
             { $             Shadow_Rays_Succeeded++;C             Filter_Shadow_Ray(&Bounded_Intersection, Light_Colour); :             if ((fabs(Light_Colour->Red) < BLACK_LEVEL) &&:               (fabs(Light_Colour->Green) < BLACK_LEVEL) &&7               (fabs(Light_Colour->Blue) < BLACK_LEVEL))                { *               Cache_Me = Not_Found_Shadow;"               Quit_Looking = TRUE;%               break; /* from while */                } 
             } B         /* Move the ray to the point of intersection, plus some */9         Light_Source_Depth -= Bounded_Intersection.Depth; 8         Local_Ray.Initial = Bounded_Intersection.IPoint;!         Not_Found_Shadow = FALSE; 	         } =       else /* No intersections in the direction of the ray */ 	         {          break;	         }        } /*endwhile*/     } /*endelse*/    if (Cache_Me) 9     Light_Source->Shadow_Cached_Object = Blocking_Object;    close_istack (Local_Stack);    }     ? static void Block_Area_Light (Light_Source, Light_Source_Depth, A Light_Source_Ray_Ptr,IPoint, Light_Colour, u1, v1, u2, v2, Level)  LIGHT_SOURCE *Light_Source;  DBL Light_Source_Depth;  RAY *Light_Source_Ray_Ptr; VECTOR *IPoint;  COLOUR *Light_Colour;  int u1, v1, u2, v2, Level;   { (   COLOUR Sample_Colour[4], Dummy_Colour;)   VECTOR Center_Save, NewAxis1, NewAxis2;*1   int i, j, u, v, New_u1, New_v1, New_u2, New_v2;i  &   DBL Jitter_u, Jitter_v, ScaleFactor;   RAY Light_Source_Ray;t  +   Light_Source_Ray = *Light_Source_Ray_Ptr;,     /* First call, initialize */0   if (u1 == 0 && v1 == 0 && u2 == 0 && v2 == 0)      {o@     /* Flag uncalculated points with a negative value for Red */3     for (i = 0; i < Light_Source->Area_Size1; i++) i       {d4       for (j = 0; j < Light_Source->Area_Size2; j++)2         Light_Source->Light_Grid[i][j].Red = -1.0;       }a       u1 = 0;e     v1 = 0;R&     u2 = Light_Source->Area_Size1 - 1;&     v2 = Light_Source->Area_Size2 - 1;     }h  D   /* Save the light source center since we'll be fiddling with it */#   Center_Save=Light_Source->Center;O  -   /* Sample the four corners of the region */t   for (i = 0; i < 4; i++)      {y     switch (i) e     {p     case 0:        u = u1; v = v1; break;     case 1:        u = u2; v = v1; break;     case 2:        u = u1; v = v2; break;     case 3:        u = u2; v = v2; break;     }e  4     if (Light_Source -> Light_Grid[u][v].Red >= 0.0)9       /* We've already calculated this point, reuse it */s6       Sample_Colour[i]=Light_Source->Light_Grid[u][v];	     else *       {*       Jitter_u = (DBL)u;       Jitter_v = (DBL)v;  "       if (Light_Source -> Jitter) 	         {l1         Jitter_u += (rand() % 4096)/4096.0 - 0.5;t1         Jitter_v += (rand() % 4096)/4096.0 - 0.5;a
         /*(   Not sure if    jx = IPoint->x + 100*u;'   this works    jy = IPoint->y + 100*v;y   yet >         Jitter_u += ((rand3d(jx, jy) & 0x7FFF)/32768.0) - 0.5;D         Jitter_v += ((rand3d(jx+10, jy+10) & 0x7FFF)/32768.0) - 0.5; */	         }n  *       if (Light_Source -> Area_Size1 > 1) 	         {dI         ScaleFactor = Jitter_u/(DBL)(Light_Source->Area_Size1 - 1) - 0.5;(;         VScale (NewAxis1, Light_Source->Axis1, ScaleFactor)n           } 
       else/         Make_Vector (&NewAxis1, 0.0, 0.0, 0.0);r  *       if (Light_Source -> Area_Size2 > 1) 	         { I         ScaleFactor = Jitter_v/(DBL)(Light_Source->Area_Size2 - 1) - 0.5;u;         VScale (NewAxis2, Light_Source->Axis2, ScaleFactor)h	         } 
       else/         Make_Vector (&NewAxis2, 0.0, 0.0, 0.0);D  '       Light_Source->Center=Center_Save;iC       VAdd  (Light_Source->Center, Light_Source->Center, NewAxis1);PC       VAdd  (Light_Source->Center, Light_Source->Center, NewAxis2);h  ?       /* Recalculate the light source ray but not the colour */tE       do_light (Light_Source, &Light_Source_Depth, &Light_Source_Ray,o         IPoint, &Dummy_Colour);t  &       Sample_Colour[i]= *Light_Colour;  :       Block_Point_Light (Light_Source, Light_Source_Depth,.         &Light_Source_Ray, &Sample_Colour[i]);  6       Light_Source->Light_Grid[u][v]=Sample_Colour[i];       }h     }L  #   Light_Source->Center=Center_Save;*  Q   if ( (u2 - u1 > 1 || v2 - v1 > 1) && (Level < Light_Source -> Adaptive_Level || C     Colour_Distance (&Sample_Colour[0], &Sample_Colour[1]) > 0.1 ||yC     Colour_Distance (&Sample_Colour[1], &Sample_Colour[3]) > 0.1 ||OC     Colour_Distance (&Sample_Colour[3], &Sample_Colour[2]) > 0.1 ||LC     Colour_Distance (&Sample_Colour[2], &Sample_Colour[0]) > 0.1) )      {S     for (i = 0; i < 4; i++)        {*       switch (i) 1       {        case 0:          New_u1 = u1;         New_v1 = v1;,         New_u2 = (int)floor ((u1 + u2)/2.0);,         New_v2 = (int)floor ((v1 + v2)/2.0);         break;         case 1: ,         New_u1 = (int)ceil  ((u1 + u2)/2.0);         New_v1 = v1;         New_u2 = u2;,         New_v2 = (int)floor ((v1 + v2)/2.0);         break;         case 2:          New_u1 = u1;,         New_v1 = (int)ceil  ((v1 + v2)/2.0);,         New_u2 = (int)floor ((u1 + u2)/2.0);         New_v2 = v2;         break;         case 3: +         New_u1 = (int)ceil ((u1 + u2)/2.0); +         New_v1 = (int)ceil ((v1 + v2)/2.0);y         New_u2 = u2;         New_v2 = v2;         break;       }t  ?       /* Recalculate the light source ray but not the colour */dE       do_light (Light_Source, &Light_Source_Depth, &Light_Source_Ray,i         IPoint, &Dummy_Colour);!  &       Sample_Colour[i]= *Light_Colour;  9       Block_Area_Light (Light_Source, Light_Source_Depth,h"         &Light_Source_Ray, IPoint,         &Sample_Colour[i],1         New_u1, New_v1, New_u2, New_v2, Level+1);r       }o     }c  &   /* Add up the light contributions */,   Make_Colour (Light_Colour, 0.0, 0.0, 0.0);     for (i = 0; i < 4; i++)      {>>     Scale_Colour (&Sample_Colour[i], &Sample_Colour[i], 0.25);?     Add_Colour (Light_Colour, Light_Colour, &Sample_Colour[i]);l     }e   }-  ^ static void do_light(Light_Source, Light_Source_Depth, Light_Source_Ray, IPoint, Light_Colour) LIGHT_SOURCE *Light_Source;  DBL *Light_Source_Depth; RAY *Light_Source_Ray; VECTOR *IPoint;; COLOUR *Light_Colour;    {    DBL Attenuation = 1.0;  $   /* Get the light source colour. */'   *Light_Colour = Light_Source->Colour;   &   Light_Source_Ray->Initial = *IPoint;5   Light_Source_Ray->Quadric_Constants_Cached = FALSE;   $   VSub (Light_Source_Ray->Direction,     Light_Source->Center,O
     *IPoint);   =   VLength (*Light_Source_Depth, Light_Source_Ray->Direction);   C   VScale (Light_Source_Ray->Direction, Light_Source_Ray->Direction,t     1.0/(*Light_Source_Depth));+  @   Attenuation = Attenuate_Light(Light_Source, Light_Source_Ray);  .   /* Now scale the color by the attenuation */%   Light_Colour->Red   *= Attenuation;r%   Light_Colour->Green *= Attenuation;e%   Light_Colour->Blue  *= Attenuation;=    	   return;l   }k  E static int do_blocking(Local_Intersection, Light_Colour, Local_Stack)&! INTERSECTION *Local_Intersection;D COLOUR *Light_Colour;t ISTACK *Local_Stack;   {    Shadow_Rays_Succeeded++;  7   Filter_Shadow_Ray (Local_Intersection, Light_Colour);b  1   if ((fabs(Light_Colour->Red) < BLACK_LEVEL) && )1     (fabs(Light_Colour->Green) < BLACK_LEVEL) && d.     (fabs(Light_Colour->Blue) < BLACK_LEVEL))      { A     while ((Local_Intersection = pop_entry(Local_Stack)) != NULL)w       {        }      return(TRUE);t     }g   return(FALSE);   }r  m static void do_phong(Finish, Light_Source_Ray, Eye, Layer_Normal, Colour, Light_Colour, Layer_Pigment_Colour)h FINISH *Finish;  RAY *Light_Source_Ray; VECTOR *Layer_Normal, *Eye;T5 COLOUR *Colour, *Light_Colour, *Layer_Pigment_Colour;    { 7   DBL Cos_Angle_Of_Incidence, Normal_Length, Intensity; <   VECTOR Local_Normal, Normal_Projection, Reflect_Direction;  4   VDot(Cos_Angle_Of_Incidence, *Eye, *Layer_Normal);  #   if (Cos_Angle_Of_Incidence < 0.0)t     {_!     Local_Normal = *Layer_Normal;s5     Cos_Angle_Of_Incidence = -Cos_Angle_Of_Incidence;_     }c   else     {_/     VScale (Local_Normal, *Layer_Normal, -1.0);L     }u  C   VScale (Normal_Projection, Local_Normal, Cos_Angle_Of_Incidence);c5   VScale (Normal_Projection, Normal_Projection, 2.0);e4   VAdd (Reflect_Direction, *Eye, Normal_Projection);  P   VDot (Cos_Angle_Of_Incidence, Reflect_Direction, Light_Source_Ray->Direction);7   VLength (Normal_Length, Light_Source_Ray->Direction);E     if (Normal_Length == 0.0) !     Cos_Angle_Of_Incidence = 0.0;    else  ,     Cos_Angle_Of_Incidence /= Normal_Length;  #   if (Cos_Angle_Of_Incidence < 0.0)      Cos_Angle_Of_Incidence = 0;       if (Finish->Phong_Size != 1.0)@     Intensity = pow(Cos_Angle_Of_Incidence, Finish->Phong_Size);   else'     Intensity = Cos_Angle_Of_Incidence;c     Intensity *= Finish->Phong;h     if (Finish->Metallic_Flag)       { O     Colour->Red+=Intensity*(Layer_Pigment_Colour->Red)*(Light_Colour->Red);     Q     Colour->Green+=Intensity*(Layer_Pigment_Colour->Green)*(Light_Colour->Green);eP     Colour->Blue+=Intensity*(Layer_Pigment_Colour->Blue)*(Light_Colour->Blue);       }t   else l     {a/     Colour->Red+=Intensity*(Light_Colour->Red);_3     Colour->Green+=Intensity*(Light_Colour->Green);L3     Colour->Blue+=Intensity*(Light_Colour->Blue);  e     }    }   q static void do_specular(Finish, Light_Source_Ray, REye, Layer_Normal, Colour, Light_Colour, Layer_Pigment_Colour)o FINISH *Finish;l RAY *Light_Source_Ray; VECTOR *Layer_Normal, *REye;5 COLOUR *Colour, *Light_Colour, *Layer_Pigment_Colour;    {rG   DBL Cos_Angle_Of_Incidence, Normal_Length, Intensity, Halfway_Length;y   VECTOR Halfway;y  6   VHalf (Halfway, *REye, Light_Source_Ray->Direction);)   VLength (Normal_Length, *Layer_Normal); $   VLength (Halfway_Length, Halfway);8   VDot (Cos_Angle_Of_Incidence, Halfway, *Layer_Normal);  4   if (Normal_Length == 0.0 || Halfway_Length == 0.0)!     Cos_Angle_Of_Incidence = 0.0;    else?     Cos_Angle_Of_Incidence /= (Normal_Length * Halfway_Length);   #   if (Cos_Angle_Of_Incidence < 0.0)_!     Cos_Angle_Of_Incidence = 0.0;A       if (Finish->Roughness != 1.0)h?     Intensity = pow(Cos_Angle_Of_Incidence, Finish->Roughness);r   else'     Intensity = Cos_Angle_Of_Incidence;o      Intensity *= Finish->Specular;   if (Finish->Metallic_Flag)       {hO     Colour->Red+=Intensity*(Layer_Pigment_Colour->Red)*(Light_Colour->Red);     Q     Colour->Green+=Intensity*(Layer_Pigment_Colour->Green)*(Light_Colour->Green); P     Colour->Blue+=Intensity*(Layer_Pigment_Colour->Blue)*(Light_Colour->Blue);       }    else W     {r/     Colour->Red+=Intensity*(Light_Colour->Red);a3     Colour->Green+=Intensity*(Light_Colour->Green);l1     Colour->Blue+=Intensity*(Light_Colour->Blue);t     }(   };  w static void do_diffuse(Finish, Light_Source_Ray, Layer_Normal, Colour, Light_Colour, Layer_Pigment_Colour, Attenuation)  FINISH *Finish;0 RAY *Light_Source_Ray; VECTOR *Layer_Normal; 5 COLOUR *Colour, *Light_Colour, *Layer_Pigment_Colour;0 DBL Attenuation;   {i(   DBL Cos_Angle_Of_Incidence, Intensity;  L   VDot (Cos_Angle_Of_Incidence, *Layer_Normal, Light_Source_Ray->Direction);#   if (Cos_Angle_Of_Incidence < 0.0)o5     Cos_Angle_Of_Incidence = -Cos_Angle_Of_Incidence;o      if (Finish->Brilliance != 1.0)@     Intensity = pow(Cos_Angle_Of_Incidence, Finish->Brilliance);   else'     Intensity = Cos_Angle_Of_Incidence;   -   Intensity *= Finish->Diffuse * Attenuation;      if (Finish->Crand > 0.0)@     Intensity -= ((rand()&0x7FFF)/(DBL) 0x7FFF) * Finish->Crand;  O   Colour->Red += Intensity * (Layer_Pigment_Colour->Red) * (Light_Colour->Red);eU   Colour->Green += Intensity * (Layer_Pigment_Colour->Green) * (Light_Colour->Green); R   Colour->Blue += Intensity * (Layer_Pigment_Colour->Blue) * (Light_Colour->Blue);	   return;,   }x  G /* Given a 3d point and a pigment, accumulate colour from that layer */h! /* Formerly called "Colour_At" */s* void Add_Pigment (Colour, Pigment, IPoint) COLOUR *Colour;e PIGMENT *Pigment;t VECTOR *IPoint;R   {    register DBL x, y, z;l   VECTOR TPoint,PTurbulence;     if (Pigment->Trans != NULL) 5     MInvTransPoint (&TPoint, IPoint, Pigment->Trans);    else u     TPoint = *IPoint;[     x = TPoint.x;_   y = TPoint.y;d   z = TPoint.z;o%   if(Pigment->Type != WOOD_PIGMENT &&r&     Pigment->Type != MARBLE_PIGMENT &&"     Pigment->Type != NO_PIGMENT &&&     Pigment->Type != COLOUR_PIGMENT &&=     /*      Pigment->Type != SPOTTED_PIGMENT && */ /*maybe?*/y     Pigment->Flags & HAS_TURB)     {]'     DTurbulence (&PTurbulence, x, y, z,r7       Pigment->omega,Pigment->lambda,Pigment->Octaves);L/     x += PTurbulence.x * Pigment->Turbulence.x;_/     y += PTurbulence.y * Pigment->Turbulence.y; /     z += PTurbulence.z * Pigment->Turbulence.z;      }a       if (x > COORDINATE_LIMIT)      x = COORDINATE_LIMIT;e   else     if (x < -COORDINATE_LIMIT)       x = -COORDINATE_LIMIT;     if (y > COORDINATE_LIMIT)      y = COORDINATE_LIMIT;1   else     if (y < -COORDINATE_LIMIT)       y = -COORDINATE_LIMIT;     if (z > COORDINATE_LIMIT)o     z = COORDINATE_LIMIT;    else     if (z < -COORDINATE_LIMIT)       z = -COORDINATE_LIMIT;     switch (Pigment->Type)     {_   case NO_PIGMENT:B     /* No colouring pigment has been specified - make it black. */(     Make_Colour (Colour, 0.0, 0.0, 0.0);     Colour -> Filter  = 0.0;
     break;     case COLOUR_PIGMENT:+     Colour -> Red += Pigment->Colour1->Red; /     Colour -> Green += Pigment->Colour1->Green;a-     Colour -> Blue += Pigment->Colour1->Blue;_1     Colour -> Filter += Pigment->Colour1->Filter; 
     break;     case BOZO_PIGMENT:  $     bozo (x, y, z, Pigment, Colour);
     break;     case MARBLE_PIGMENT:&     marble (x, y, z, Pigment, Colour);
     break;     case WOOD_PIGMENT:$     wood (x, y, z, Pigment, Colour);
     break;     case CHECKER_PIGMENT:c'     checker (x, y, z, Pigment, Colour);/
     break;     case SPOTTED_PIGMENT:,'     spotted (x, y, z, Pigment, Colour); 
     break;     case AGATE_PIGMENT:i%     agate (x, y, z, Pigment, Colour);o
     break;     case GRANITE_PIGMENT:l'     granite (x, y, z, Pigment, Colour);i
     break;     case GRADIENT_PIGMENT:(     gradient (x, y, z, Pigment, Colour);
     break;     case HEXAGON_PIGMENT:L'     hexagon (x, y, z, Pigment, Colour);;
     break;     case RADIAL_PIGMENT:&     radial (x, y, z, Pigment, Colour);
     break;     case MANDEL_PIGMENT:&     mandel (x, y, z, Pigment, Colour);
     break;     case IMAGE_MAP_PIGMENT:;)     image_map (x, y, z, Pigment, Colour);h
     break;     case ONION_PIGMENT:R%     onion (x, y, z, Pigment, Colour);r
     break;     case LEOPARD_PIGMENT:_'     leopard (x, y, z, Pigment, Colour);)
     break;     case PAINTED1_PIGMENT:(     painted1 (x, y, z, Pigment, Colour);
     break;     case PAINTED2_PIGMENT:(     painted2 (x, y, z, Pigment, Colour);
     break;     case PAINTED3_PIGMENT:(     painted3 (x, y, z, Pigment, Colour);
     break;   }n   }     2 void Perturb_Normal(Layer_Normal, Tnormal, IPoint) VECTOR *Layer_Normal, *IPoint; TNORMAL *Tnormal;c   {d   register DBL x, y, z;t   VECTOR TPoint,NTurbulence;     if (Tnormal->Trans != NULL) 5     MInvTransPoint (&TPoint, IPoint, Tnormal->Trans);    else w     TPoint = *IPoint;      x = TPoint.x;L   y = TPoint.y;,   z = TPoint.z;      if(Tnormal->Flags & HAS_TURB)B     {V'     DTurbulence (&NTurbulence, x, y, z,<7       Tnormal->omega,Tnormal->lambda,Tnormal->Octaves);_/     x += NTurbulence.x * Tnormal->Turbulence.x;=/     y += NTurbulence.y * Tnormal->Turbulence.y; /     z += NTurbulence.z * Tnormal->Turbulence.z;;     }        switch (Tnormal->Type) L   {S     case WAVES: +     waves (x, y, z, Tnormal, Layer_Normal);n
     break;     case RIPPLES: -     ripples (x, y, z, Tnormal, Layer_Normal);e
     break;     case WRINKLES: ,.     wrinkles (x, y, z, Tnormal, Layer_Normal);
     break;     case BUMPS: +     bumps (x, y, z, Tnormal, Layer_Normal);j
     break;     case DENTS: +     dents (x, y, z, Tnormal, Layer_Normal);o     break; f     case BUMPY1: d,     bumpy1 (x, y, z, Tnormal, Layer_Normal);
     break;     case BUMPY2: c,     bumpy2 (x, y, z, Tnormal, Layer_Normal);
     break;     case BUMPY3: _,     bumpy3 (x, y, z, Tnormal, Layer_Normal);
     break;     case BUMP_MAP: r.     bump_map (x, y, z, Tnormal, Layer_Normal);
     break;   }a	   return;n   })  c void Diffuse (Finish, IPoint, Eye, Layer_Normal, Layer_Pigment_Colour, Colour, Attenuation, Object)e FINISH *Finish;c VECTOR *IPoint, *Layer_Normal; COLOUR *Layer_Pigment_Colour;> COLOUR *Colour;  RAY    *Eye; DBL    Attenuation;_ OBJECT *Object;e   {0+   DBL Light_Source_Depth, Cos_Shadow_Angle;o   RAY Light_Source_Ray;_   LIGHT_SOURCE *Light_Source;    VECTOR REye;   COLOUR Light_Colour;  V   if ((Finish->Diffuse == 0.0) && (Finish->Specular == 0.0) && (Finish->Phong == 0.0))     return;      if (Finish->Specular != 0.0)     {      REye.x = -Eye->Direction.x;      REye.y = -Eye->Direction.y;      REye.z = -Eye->Direction.z;a     }m  ,   for (Light_Source = Frame.Light_Sources ;    Light_Source != NULL;(1   Light_Source = Light_Source->Next_Light_Source)e     {o      /* Get a colour and a ray */  6     do_light(Light_Source,       &Light_Source_Depth, !       &Light_Source_Ray,  IPoint,y       &Light_Colour);   E     /* Don't calculate spotlights when outside of the light's cone */n0     if (fabs(Light_Colour.Red) < BLACK_LEVEL && 0       fabs(Light_Colour.Green) < BLACK_LEVEL && ,       fabs(Light_Colour.Blue) < BLACK_LEVEL)       continue;o  :     /* See if light on far side of surface from camera. */  ,     if (!(Object->Type & DOUBLE_ILLUMINATE))       {_G        VDot(Cos_Shadow_Angle,*Layer_Normal,Light_Source_Ray.Direction);a"        if (Cos_Shadow_Angle < 0.0)          continue;       }g  F     /* If light source was not blocked by any intervening object, thenI       calculate it's contribution to the object's overall illumination */,       Shadow_Test_Flag = TRUE;!     if (Quality_Flags & Q_SHADOW)        { G       if ((Light_Source->Area_Light) && (Quality_Flags & Q_AREA_LIGHT))r;         Block_Area_Light (Light_Source, Light_Source_Depth,e$           &Light_Source_Ray, IPoint,(           &Light_Colour, 0, 0, 0, 0, 0);
       else<         Block_Point_Light (Light_Source, Light_Source_Depth,,           &Light_Source_Ray, &Light_Colour);       }s     Shadow_Test_Flag = FALSE;(  1     if (fabs(Light_Colour.Red)  > BLACK_LEVEL || t0       fabs(Light_Colour.Green) > BLACK_LEVEL || -       fabs(Light_Colour.Blue) > BLACK_LEVEL) _       {o       if (Finish->Phong > 0.0) )s         do_phong(Finish,&Light_Source_Ray,&Eye->Direction,Layer_Normal,Colour,&Light_Colour, Layer_Pigment_Colour);o  "       if (Finish->Specular > 0.0) l         do_specular(Finish,&Light_Source_Ray,&REye,Layer_Normal,Colour,&Light_Colour, Layer_Pigment_Colour);  !       if (Finish->Diffuse > 0.0) uq         do_diffuse(Finish,&Light_Source_Ray,Layer_Normal,Colour,&Light_Colour,Layer_Pigment_Colour, Attenuation);h       }L     }u	   return;E   }*  < void Reflect (Reflection, IPoint, Ray, Layer_Normal, Colour) DBL Reflection;u VECTOR *IPoint;B	 RAY *Ray;_ VECTOR *Layer_Normal;; COLOUR *Colour;n   {f   RAY New_Ray;   COLOUR Temp_Colour;_   VECTOR Local_Normal;   VECTOR Normal_Projection;o   VECTOR Surface_Offset;    register DBL Normal_Component;     if (Reflection != 0.0)     {      Reflected_Rays_Traced++;=     VDot (Normal_Component, Ray -> Direction, *Layer_Normal);n      if (Normal_Component < 0.0)        {-#       Local_Normal = *Layer_Normal;i       Normal_Component *= -1.0;=       }&     else1       VScale (Local_Normal, *Layer_Normal, -1.0);t  ?     VScale (Normal_Projection, Local_Normal, Normal_Component);o7     VScale (Normal_Projection, Normal_Projection, 2.0);(B     VAdd (New_Ray.Direction, Ray -> Direction, Normal_Projection);     New_Ray.Initial = *IPoint;       /* ARE 08/25/91 */  F     VScale(Surface_Offset, New_Ray.Direction, 2.0 * Small_Tolerance); F     VAdd(New_Ray.Initial, New_Ray.Initial, Surface_Offset);             (     Copy_Ray_Containers (&New_Ray, Ray);     Trace_Level++;.     Make_Colour (&Temp_Colour, 0.0, 0.0, 0.0);-     New_Ray.Quadric_Constants_Cached = FALSE; #     Trace (&New_Ray, &Temp_Colour);,     Trace_Level--;  6     Colour -> Red   += Temp_Colour.Red   * Reflection;6     Colour -> Green += Temp_Colour.Green * Reflection;6     Colour -> Blue  += Temp_Colour.Blue  * Reflection;       }n   }p  7 void Refract (Texture, IPoint, Ray, Top_Normal, Colour)  TEXTURE *Texture;- VECTOR *IPoint;P	 RAY *Ray;/ VECTOR *Top_Normal;m COLOUR *Colour;T   {    RAY New_Ray;   COLOUR Temp_Colour;x   VECTOR Local_Normal;   VECTOR Ray_Direction;g*   register DBL Normal_Component, Temp_IOR;   DBL temp, ior;   /*   int inside; */n     if (Top_Normal == NULL)      {      New_Ray.Initial = *IPoint;'     New_Ray.Direction = Ray->Direction;A  (     Copy_Ray_Containers (&New_Ray, Ray);     Trace_Level++;     Transmitted_Rays_Traced++;.     Make_Colour (&Temp_Colour, 0.0, 0.0, 0.0);-     New_Ray.Quadric_Constants_Cached = FALSE;C#     Trace (&New_Ray, &Temp_Colour);T     Trace_Level--;'     (Colour -> Red) += Temp_Colour.Red;L+     (Colour -> Green) += Temp_Colour.Green;))     (Colour -> Blue) += Temp_Colour.Blue;(     }-   else       {      Refracted_Rays_Traced++;;     VDot (Normal_Component, Ray -> Direction, *Top_Normal);a      if (Normal_Component <= 0.0)       {o'       Local_Normal.x = Top_Normal -> x;e'       Local_Normal.y = Top_Normal -> y;g'       Local_Normal.z = Top_Normal -> z;        Normal_Component *= -1.0;        /*     inside = FALSE;*/       }_     else       {t/       VScale (Local_Normal, *Top_Normal, -1.0);        /*     inside = TRUE;*/(       }P    (     Copy_Ray_Containers (&New_Ray, Ray);  &     if (Ray -> Containing_Index == -1)       { 3       /* The ray is entering from the atmosphere */P$       Ray_Enter (&New_Ray, Texture);J       ior = (Frame.Atmosphere_IOR)/(Texture->Finish->Index_Of_Refraction);       }O else   {T-   /* The ray is currently inside an object */ I   if (New_Ray.Containing_Textures [New_Ray.Containing_Index] == Texture)       /*         if (inside) */G     { /     /* The ray is leaving the current object */a     Ray_Exit (&New_Ray);'     if (New_Ray.Containing_Index == -1)o2       /* The ray is leaving into the atmosphere */$     Temp_IOR = Frame.Atmosphere_IOR;     else2       /* The ray is leaving into another object */D       Temp_IOR = New_Ray.Containing_IORs [New_Ray.Containing_Index];  ;     ior =  (Texture->Finish->Index_Of_Refraction)/Temp_IOR;      }g     else       {m,       /* The ray is entering a new object */D       Temp_IOR = New_Ray.Containing_IORs [New_Ray.Containing_Index];$       Ray_Enter (&New_Ray, Texture);  ?       ior =  Temp_IOR / (Texture->Finish->Index_Of_Refraction);a       },     }P  G   temp = 1.0 + ior * ior * (Normal_Component * Normal_Component - 1.0);y   if (temp < 0.0)        {r:     Reflect ((1.0 - Texture->Finish->Reflection), IPoint,      Ray, Top_Normal, Colour);n     return;o     }u  +   temp = ior*Normal_Component - sqrt(temp);R,   VScale (Local_Normal, Local_Normal, temp);.   VScale (Ray_Direction, Ray->Direction, ior);8   VAdd (New_Ray.Direction, Local_Normal, Ray_Direction);4   VNormalize (New_Ray.Direction, New_Ray.Direction);     New_Ray.Initial = *IPoint;   Trace_Level++;,   Make_Colour (&Temp_Colour, 0.0, 0.0, 0.0);+   New_Ray.Quadric_Constants_Cached = FALSE;   !   Trace (&New_Ray, &Temp_Colour);a   Trace_Level--;  &   (Colour -> Red) += (Temp_Colour.Red)&     * (Texture -> Finish->Refraction);*   (Colour -> Green) += (Temp_Colour.Green)&     * (Texture -> Finish->Refraction);(   (Colour -> Blue) += (Temp_Colour.Blue)&     * (Texture -> Finish->Refraction);   }x },  5 void Fog (Distance, Fog_Colour, Fog_Distance, Colour)S DBL Distance, Fog_Distance;r COLOUR *Fog_Colour, *Colour;   { %   DBL Fog_Factor, Fog_Factor_Inverse;   1   Fog_Factor = exp(-1.0 * Distance/Fog_Distance);S(   Fog_Factor_Inverse = 1.0 - Fog_Factor;L   Colour->Red = Colour->Red*Fog_Factor + Fog_Colour->Red*Fog_Factor_Inverse;R   Colour->Green = Colour->Green*Fog_Factor + Fog_Colour->Green*Fog_Factor_Inverse;O   Colour->Blue = Colour->Blue*Fog_Factor + Fog_Colour->Blue*Fog_Factor_Inverse;    }a  x void Compute_Reflected_Colour (Ray, Finish, Ray_Intersection, Layer_Pigment_Colour, Filter_Colour, Colour, Layer_Normal)	 RAY *Ray;  FINISH *Finish;  INTERSECTION *Ray_Intersection;  COLOUR *Layer_Pigment_Colour;  COLOUR *Filter_Colour; COLOUR *Colour;C VECTOR *Layer_Normal;e   {    DBL Attenuation, Ambient;i   COLOUR Emitted_Colour;  H   /* This variable keeps track of how much colour comes from the surface:       of the object and how much is transmited through. *//   Make_Colour (&Emitted_Colour, 0.0, 0.0, 0.0);O  &   if (Quality_Flags & Q_FULL_AMBIENT)      {g'     Layer_Pigment_Colour->Filter = 0.0;.  G     Colour->Red   += Layer_Pigment_Colour->Red * Filter_Colour->Filter; I     Colour->Green += Layer_Pigment_Colour->Green * Filter_Colour->Filter; H     Colour->Blue  += Layer_Pigment_Colour->Blue * Filter_Colour->Filter;     return;t     }   M   Attenuation = Filter_Colour->Filter * (1.0 - Layer_Pigment_Colour->Filter);-  5   if ((Ambient = Finish->Ambient*Attenuation) != 0.0)a     { >     Emitted_Colour.Red += Layer_Pigment_Colour->Red * Ambient;B     Emitted_Colour.Green += Layer_Pigment_Colour->Green * Ambient;@     Emitted_Colour.Blue += Layer_Pigment_Colour->Blue * Ambient;     }g  2   Diffuse (Finish, &Ray_Intersection->IPoint, Ray,F     Layer_Normal, Layer_Pigment_Colour, &Emitted_Colour, Attenuation,      Ray_Intersection->Object);  &   Colour->Red   += Emitted_Colour.Red;(   Colour->Green += Emitted_Colour.Green;'   Colour->Blue  += Emitted_Colour.Blue;_      if (Quality_Flags & Q_REFLECT)B     Reflect (Finish->Reflection, &Ray_Intersection -> IPoint, Ray,       Layer_Normal, Colour);     }   H /* Given an intersection point, a ray, & a shadow flag, add that point's-   color to the given colour and return it. */i  > void Determine_Apparent_Colour (Ray_Intersection, Colour, Ray) INTERSECTION *Ray_Intersection;g COLOUR *Colour;i	 RAY *Ray;a   {F?   COLOUR Layer_Pigment_Colour, Refracted_Colour, Filter_Colour;i   TEXTURE *Layer, *Texture;    FINISH *Finish;I.   VECTOR Layer_Normal, Raw_Normal, Top_Normal;   DBL Normal_Direction;c   int layer_number;S  . #define QColour Texture->Pigment->Quick_Colour  %   /* Get the normal to the surface */d   if (Ray_Intersection->NFlag),      Raw_Normal = Ray_Intersection->INormal;   elseO      Normal (&Raw_Normal, Ray_Intersection->Object, &Ray_Intersection->IPoint);E  2   /* Now, we perform the lighting calculations. */  ?   /* We assume here that Post_Process has propagated all parentlF    textures to the object itself and that everything has some texture.J    Redirrect to the proper texture if its a material or checker texture */  3   for (Texture = Ray_Intersection->Object->Texture;     Texture->Type != PNF_TEXTURE;)     switch (Texture->Type)     {_     case TILE_TEXTURE:L       Texture = tiles_texture(&Ray_Intersection->IPoint,((TILES *)Texture));       break;     case MAT_TEXTURE: N       Texture = material_map(&Ray_Intersection->IPoint,((MATERIAL *)Texture));       break;     default:?       fprintf(stderr, "Bad texture type: %d\n", Texture->Type);        close_all();         exit(1);     };  4   Make_ColourA (&Filter_Colour, 1.0, 1.0, 1.0, 1.0);(   for (layer_number=1 , Layer = Texture;@   (Layer != NULL) && (fabs(Filter_Colour.Filter) > BLACK_LEVEL);,   layer_number++, Layer = Layer->Next_Layer)     {e7     Make_Colour (&Layer_Pigment_Colour, 0.0, 0.0, 0.0);i!     if (Quality_Flags & Q_QUICKC) %       Layer_Pigment_Colour = QColour;_     elseU       Add_Pigment (&Layer_Pigment_Colour, Layer->Pigment, &Ray_Intersection->IPoint);o       Layer_Normal = Raw_Normal;A     if ((Quality_Flags & Q_NORMAL) && (Texture->Tnormal != NULL))t6       Perturb_Normal (&Layer_Normal, Texture->Tnormal,#         &Ray_Intersection->IPoint);a  @     /* If the surface normal points away, flip its direction. */:     VDot (Normal_Direction, Layer_Normal, Ray->Direction);      if (Normal_Direction > 0.0)        {,$       VScaleEq (Layer_Normal, -1.0);       }e     if (layer_number == 1)        Top_Normal = Layer_Normal;  "     Compute_Reflected_Colour (Ray,       Layer->Finish,       Ray_Intersection,-       &Layer_Pigment_Colour,       &Filter_Colour,r       Colour, &Layer_Normal);*  4     Filter_Colour.Red   *= Layer_Pigment_Colour.Red;6     Filter_Colour.Green *= Layer_Pigment_Colour.Green;5     Filter_Colour.Blue  *= Layer_Pigment_Colour.Blue;E8     Filter_Colour.Filter *= Layer_Pigment_Colour.Filter;     }T     Finish = Texture->Finish;R  P   if ((fabs(Filter_Colour.Filter) > BLACK_LEVEL) && (Quality_Flags & Q_REFRACT))     {p3     Make_Colour (&Refracted_Colour, 0.0, 0.0, 0.0);;  !     if (Finish->Refraction > 0.0) 9       Refract (Texture, &Ray_Intersection -> IPoint, Ray, (         &Top_Normal, &Refracted_Colour);     else7       Refract (Texture, &Ray_Intersection->IPoint, Ray,e!         NULL, &Refracted_Colour);,  S     Colour->Red += Filter_Colour.Red * Refracted_Colour.Red * Filter_Colour.Filter;&Y     Colour->Green += Filter_Colour.Green * Refracted_Colour.Green * Filter_Colour.Filter;>V     Colour->Blue += Filter_Colour.Blue * Refracted_Colour.Blue * Filter_Colour.Filter;     }       if (Frame.Fog_Distance != 0.0)H     Fog (Ray_Intersection->Depth, &Frame.Fog_Colour, Frame.Fog_Distance,       Colour);   }   1 void Filter_Shadow_Ray (Ray_Intersection, Colour)  INTERSECTION *Ray_Intersection;> COLOUR *Colour;_   {l-   COLOUR Layer_Pigment_Colour, Filter_Colour;*   TEXTURE *Layer, *Texture;    FINISH *Finish;_   int layer_number;   . #define QColour Texture->Pigment->Quick_Colour  "   if (!(Quality_Flags & Q_SHADOW))     return;o  2   /* Now, we perform the lighting calculations. */  ?   /* We assume here that Post_Process has propagated all parent F    textures to the object itself and that everything has some texture.J    Redirrect to the proper texture if its a material or checker texture */  3   for (Texture = Ray_Intersection->Object->Texture;     Texture->Type != PNF_TEXTURE;)     switch (Texture->Type)     {r     case TILE_TEXTURE:L       Texture = tiles_texture(&Ray_Intersection->IPoint,((TILES *)Texture));       break;     case MAT_TEXTURE:oN       Texture = material_map(&Ray_Intersection->IPoint,((MATERIAL *)Texture));       break;     default:?       fprintf(stderr, "Bad texture type: %d\n", Texture->Type);/       close_all(); w       exit(1);     };  4   Make_ColourA (&Filter_Colour, 1.0, 1.0, 1.0, 1.0);(   for (layer_number=1 , Layer = Texture;@   (Layer != NULL) && (fabs(Filter_Colour.Filter) > BLACK_LEVEL);,   layer_number++, Layer = Layer->Next_Layer)     {t!     if (Quality_Flags & Q_QUICKC)e%       Layer_Pigment_Colour = QColour;O     else       {h9       Make_Colour (&Layer_Pigment_Colour, 0.0, 0.0, 0.0);+U       Add_Pigment (&Layer_Pigment_Colour, Layer->Pigment, &Ray_Intersection->IPoint);r       }l  4     Filter_Colour.Red   *= Layer_Pigment_Colour.Red;6     Filter_Colour.Green *= Layer_Pigment_Colour.Green;5     Filter_Colour.Blue  *= Layer_Pigment_Colour.Blue;a8     Filter_Colour.Filter *= Layer_Pigment_Colour.Filter;     }e     Finish = Texture->Finish;i  G   /* For shadow rays, we have the filter colour now - time to return */w0   if (fabs(Filter_Colour.Filter) < BLACK_LEVEL)      {_(     Make_Colour (Colour, 0.0, 0.0, 0.0);     return;      }a      if (Finish->Refraction > 0.0)      {rQ     Colour->Red *= Filter_Colour.Red * Finish->Refraction * Filter_Colour.Filter;uU     Colour->Green *= Filter_Colour.Green * Finish->Refraction * Filter_Colour.Filter;eS     Colour->Blue *= Filter_Colour.Blue * Finish->Refraction * Filter_Colour.Filter;      }T   else       {><     Colour->Red *= Filter_Colour.Red * Filter_Colour.Filter;@     Colour->Green *= Filter_Colour.Green * Filter_Colour.Filter;>     Colour->Blue *= Filter_Colour.Blue * Filter_Colour.Filter;     }t	   return;.     }t