M /****************************************************************************  *                matrices.c  * 8 *  This module contains code to manipulate 4x4 matrices. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"    void MZero (result)  MATRIX *result;    { 3   /* Initialize the matrix to the following values:     0.0   0.0   0.0   0.0    0.0   0.0   0.0   0.0    0.0   0.0   0.0   0.0    0.0   0.0   0.0   0.0 */   register int i, j;     for (i = 0 ; i < 4 ; i++)      for (j = 0 ; j < 4 ; j++)      (*result)[i][j] = 0.0;   }    void MIdentity (result)  MATRIX *result;    { 3   /* Initialize the matrix to the following values:     1.0   0.0   0.0   0.0    0.0   1.0   0.0   0.0    0.0   0.0   1.0   0.0    0.0   0.0   0.0   1.0 */   register int i, j;     for (i = 0 ; i < 4 ; i++)      for (j = 0 ; j < 4 ; j++)      if (i == j)        (*result)[i][j] = 1.0;     else       (*result)[i][j] = 0.0;   }   & void MTimes (result, matrix1, matrix2)# MATRIX *result, *matrix1, *matrix2;    {    register int i, j, k;    MATRIX temp_matrix;      for (i = 0 ; i < 4 ; i++)      for (j = 0 ; j < 4 ; j++)      {      temp_matrix[i][j] = 0.0;     for (k = 0 ; k < 4 ; k++) ?       temp_matrix[i][j] += (*matrix1)[i][k] * (*matrix2)[k][j];      }      for (i = 0 ; i < 4 ; i++)      for (j = 0 ; j < 4 ; j++) (     (*result)[i][j] = temp_matrix[i][j];   }   M /*  AAC - These are not used, so they are commented out to save code space...   $ void MAdd (result, matrix1, matrix2)&    MATRIX *result, *matrix1, *matrix2;    {    register int i, j;       for (i = 0 ; i < 4 ; i++)       for (j = 0 ; j < 4 ; j++) ?          (*result)[i][j] = (*matrix1)[i][j] + (*matrix2)[i][j];     }  $ void MSub (result, matrix1, matrix2)&    MATRIX *result, *matrix1, *matrix2;    {    register int i, j;       for (i = 0 ; i < 4 ; i++)       for (j = 0 ; j < 4 ; j++) ?          (*result)[i][j] = (*matrix1)[i][j] - (*matrix2)[i][j];     }  % void MScale (result, matrix1, amount)  MATRIX *result, *matrix1;  DBL amount;  {     register int i, j;       for (i = 0 ; i < 4 ; i++)       for (j = 0 ; j < 4 ; j++)  	 if (amount == 1.0)6 	    (*result)[i][j] = (*matrix1)[i][j]; * just copy * 	 else8             (*result)[i][j] = (*matrix1)[i][j] * amount;
    return; }  ... up to here! */  ! void MTranspose (result, matrix1)  MATRIX *result, *matrix1;    {    register int i, j;   MATRIX temp_matrix;      for (i = 0 ; i < 4 ; i++)      for (j = 0 ; j < 4 ; j++) )     temp_matrix[i][j] = (*matrix1)[j][i];      for (i = 0 ; i < 4 ; i++)      for (j = 0 ; j < 4 ; j++) (     (*result)[i][j] = temp_matrix[i][j];   }     , void MTransPoint (result, vector, transform) VECTOR *result, *vector; TRANSFORM *transform;    {    register int i;    DBL answer_array[4];   MATRIX *matrix;   *   matrix = (MATRIX *) transform -> matrix;     for (i = 0 ; i < 4 ; i++) 3     answer_array[i] = vector -> x * (*matrix)[0][i] #     + vector -> y * (*matrix)[1][i] #     + vector -> z * (*matrix)[2][i]      + (*matrix)[3][i];  !   result -> x  = answer_array[0]; !   result -> y  = answer_array[1]; !   result -> z  = answer_array[2];    }   / void MInvTransPoint (result, vector, transform)  VECTOR *result, *vector; TRANSFORM *transform;    {    register int i;    DBL answer_array[4];   MATRIX *matrix;   +   matrix = (MATRIX *) transform -> inverse;      for (i = 0 ; i < 4 ; i++) 3     answer_array[i] = vector -> x * (*matrix)[0][i] #     + vector -> y * (*matrix)[1][i] #     + vector -> z * (*matrix)[2][i]      + (*matrix)[3][i];  !   result -> x  = answer_array[0]; !   result -> y  = answer_array[1]; !   result -> z  = answer_array[2];    }   0 void MTransDirection (result, vector, transform) VECTOR *result, *vector; TRANSFORM *transform;    {    register int i;    DBL answer_array[4];   MATRIX *matrix;   *   matrix = (MATRIX *) transform -> matrix;     for (i = 0 ; i < 4 ; i++) 3     answer_array[i] = vector -> x * (*matrix)[0][i] #     + vector -> y * (*matrix)[1][i] $     + vector -> z * (*matrix)[2][i];  !   result -> x  = answer_array[0]; !   result -> y  = answer_array[1]; !   result -> z  = answer_array[2];    }   3 void MInvTransDirection (result, vector, transform)  VECTOR *result, *vector; TRANSFORM *transform;    {    register int i;    DBL answer_array[4];   MATRIX *matrix;   +   matrix = (MATRIX *) transform -> inverse;      for (i = 0 ; i < 4 ; i++) 3     answer_array[i] = vector -> x * (*matrix)[0][i] #     + vector -> y * (*matrix)[1][i] $     + vector -> z * (*matrix)[2][i];  !   result -> x  = answer_array[0]; !   result -> y  = answer_array[1]; !   result -> z  = answer_array[2];    }   - void MTransNormal (result, vector, transform)  VECTOR *result, *vector; TRANSFORM *transform;    {    register int i;    DBL answer_array[3];   MATRIX *matrix;   +   matrix = (MATRIX *) transform -> inverse;      for (i = 0 ; i < 3 ; i++) 3     answer_array[i] = vector -> x * (*matrix)[i][0] #     + vector -> y * (*matrix)[i][1] $     + vector -> z * (*matrix)[i][2];  !   result -> x  = answer_array[0]; !   result -> y  = answer_array[1]; !   result -> z  = answer_array[2];    }   0 void MInvTransNormal (result, vector, transform) VECTOR *result, *vector; TRANSFORM *transform;    {    register int i;    DBL answer_array[3];   MATRIX *matrix;   *   matrix = (MATRIX *) transform -> matrix;     for (i = 0 ; i < 3 ; i++) 3     answer_array[i] = vector -> x * (*matrix)[i][0] #     + vector -> y * (*matrix)[i][1] $     + vector -> z * (*matrix)[i][2];  !   result -> x  = answer_array[0]; !   result -> y  = answer_array[1]; !   result -> z  = answer_array[2];    }   / void Compute_Scaling_Transform (result, vector)  TRANSFORM *result; VECTOR *vector;    { )   MIdentity ((MATRIX *)result -> matrix); )   (result -> matrix)[0][0] = vector -> x; )   (result -> matrix)[1][1] = vector -> y; )   (result -> matrix)[2][2] = vector -> z;   *   MIdentity ((MATRIX *)result -> inverse);0   (result -> inverse)[0][0] = 1.0 / vector -> x;/   (result -> inverse)[1][1]= 1.0 / vector -> y; 0   (result -> inverse)[2][2] = 1.0 / vector -> z;   }   3 /* AAC - This is not used, so it's commented out...   ) void Compute_Inversion_Transform (result)     TRANSFORM *result;     {*    MIdentity ((MATRIX *)result -> matrix);#    (result -> matrix)[0][0] = -1.0; #    (result -> matrix)[1][1] = -1.0; #    (result -> matrix)[2][2] = -1.0; #    (result -> matrix)[3][3] = -1.0;     $    (result -> inverse)[0][0] = -1.0;$    (result -> inverse)[1][1] = -1.0;$    (result -> inverse)[2][2] = -1.0;$    (result -> inverse)[3][3] = -1.0;    } ... up to here! */  6 void Compute_Translation_Transform (transform, vector) TRANSFORM *transform;  VECTOR *vector;    { ,   MIdentity ((MATRIX *)transform -> matrix);,   (transform -> matrix)[3][0] = vector -> x;,   (transform -> matrix)[3][1] = vector -> y;,   (transform -> matrix)[3][2] = vector -> z;  -   MIdentity ((MATRIX *)transform -> inverse); 3   (transform -> inverse)[3][0] = 0.0 - vector -> x; 3   (transform -> inverse)[3][1] = 0.0 - vector -> y;*3   (transform -> inverse)[3][2] = 0.0 - vector -> z;*   }   3 void Compute_Rotation_Transform (transform, vector)  TRANSFORM *transform;m VECTOR *vector;f   {e   MATRIX Matrix;   VECTOR Radian_Vector;t2   register DBL cosx, cosy, cosz, sinx, siny, sinz;  .   VScale (Radian_Vector, *vector, M_PI/180.0);,   MIdentity ((MATRIX *)transform -> matrix);   cosx = cos (Radian_Vector.x);m   sinx = sin (Radian_Vector.x);-   cosy = cos (Radian_Vector.y);l   siny = sin (Radian_Vector.y);p   cosz = cos (Radian_Vector.z);    sinz = sin (Radian_Vector.z);y  &   (transform -> matrix) [1][1] = cosx;&   (transform -> matrix) [2][2] = cosx;&   (transform -> matrix) [1][2] = sinx;,   (transform -> matrix) [2][1] = 0.0 - sinx;M   MTranspose ((MATRIX *)transform -> inverse, (MATRIX *)transform -> matrix);m     MIdentity ((MATRIX *)Matrix);e   Matrix [0][0] = cosy;l   Matrix [2][2] = cosy;m   Matrix [0][2] = 0.0 - siny;    Matrix [2][0] = siny;nZ   MTimes ((MATRIX *)transform -> matrix, (MATRIX *)transform -> matrix, (MATRIX *)Matrix);2   MTranspose ((MATRIX *)Matrix, (MATRIX *)Matrix);\   MTimes ((MATRIX *)transform -> inverse, (MATRIX *)Matrix, (MATRIX *)transform -> inverse);     MIdentity ((MATRIX *)Matrix);.   Matrix [0][0] = cosz;    Matrix [1][1] = cosz;    Matrix [0][1] = sinz;R   Matrix [1][0] = 0.0 - sinz;lZ   MTimes ((MATRIX *)transform -> matrix, (MATRIX *)transform -> matrix, (MATRIX *)Matrix);2   MTranspose ((MATRIX *)Matrix, (MATRIX *)Matrix);\   MTimes ((MATRIX *)transform -> inverse, (MATRIX *)Matrix, (MATRIX *)transform -> inverse);   }e  2 /* AAC - This is not used so it's commented out...  ; void Compute_Look_At_Transform (result, Look_At, Up, Right)w    TRANSFORM *result;0     VECTOR *Look_At, *Up, *Right;    {+    MIdentity ((MATRIX *)result -> inverse);0'    (result -> matrix)[0][0] = Right->x; '    (result -> matrix)[0][1] = Right->y;j'    (result -> matrix)[0][2] = Right->z;e$    (result -> matrix)[1][0] = Up->x;$    (result -> matrix)[1][1] = Up->y;$    (result -> matrix)[1][2] = Up->z;)    (result -> matrix)[2][0] = Look_At->x;i)    (result -> matrix)[2][1] = Look_At->y; )    (result -> matrix)[2][2] = Look_At->z;=  *    MIdentity ((MATRIX *)result -> matrix);K    MTranspose ((MATRIX *)result -> matrix, (MATRIX *)result -> inverse);   i    }   ... up to here! */  ; void Compose_Transforms (Original_Transform, New_Transform)<. TRANSFORM *Original_Transform, *New_Transform;   { 1   MTimes ((MATRIX *)Original_Transform -> matrix,o+     (MATRIX *)Original_Transform -> matrix,d'     (MATRIX *)New_Transform -> matrix);r  2   MTimes ((MATRIX *)Original_Transform -> inverse,'     (MATRIX *)New_Transform -> inverse, -     (MATRIX *)Original_Transform -> inverse);i   }=  3 /* Rotation about an arbitrary axis - formula from:u:       "Computational Geometry for Design and Manufacture",       Faux & PrattD    Note that the angles for this transform are specified in radians. */: void Compute_Axis_Rotation_Transform (transform, V, angle) TRANSFORM *transform; 
 VECTOR *V;
 DBL angle;   {1   DBL l, cosx, sinx;     VLength(l, *V);    VInverseScaleEq(*V, l);n      MIdentity(&transform->matrix);   cosx = cos(angle);   sinx = sin(angle);E   transform->matrix[0][0] = V->x * V->x + cosx * (1.0 - V->x * V->x);*E   transform->matrix[0][1] = V->x * V->y * (1.0 - cosx) + V->z * sinx;rE   transform->matrix[0][2] = V->x * V->z * (1.0 - cosx) - V->y * sinx;AE   transform->matrix[1][0] = V->x * V->y * (1.0 - cosx) - V->z * sinx;rE   transform->matrix[1][1] = V->y * V->y + cosx * (1.0 - V->y * V->y); E   transform->matrix[1][2] = V->y * V->z * (1.0 - cosx) + V->x * sinx; E   transform->matrix[2][0] = V->x * V->z * (1.0 - cosx) + V->y * sinx;jE   transform->matrix[2][1] = V->y * V->z * (1.0 - cosx) - V->x * sinx;uE   transform->matrix[2][2] = V->z * V->z + cosx * (1.0 - V->z * V->z);n9   MTranspose(&transform->inverse, &transform->matrix);       }f  A /* Given a point and a direction and a radius, find the transform :    that brings these into a canonical coordinate system */ void? Compute_Coordinate_Transform(trans, origin, up, radius, length)  TRANSFORM *trans;a VECTOR *origin;  VECTOR *up;  DBL radius;a DBL length;u   {    TRANSFORM trans2;    VECTOR tmpv;  -   Make_Vector(&tmpv, radius, radius, length);R*   Compute_Scaling_Transform(trans, &tmpv);   if (fabs(up->z) == 1.0) %     Make_Vector(&tmpv, 1.0, 0.0, 0.0)  else(   Make_Vector(&tmpv, -up->y, up->x, 0.0)A     Compute_Axis_Rotation_Transform(&trans2, &tmpv, acos(up->z)); # Compose_Transforms(trans, &trans2); / Compute_Translation_Transform(&trans2, origin);[# Compose_Transforms(trans, &trans2);e }t   TRANSFORM *Create_Transform()u {- TRANSFORM *New;a  > if ((New = (TRANSFORM *) malloc (sizeof (TRANSFORM))) == NULL) MAError ("transform");  . MIdentity ((MATRIX *) &(New -> matrix[0][0]));/ MIdentity ((MATRIX *) &(New -> inverse[0][0]));r
 return (New);A }X   TRANSFORM *Copy_Transform (Old)  TRANSFORM *Old;i {  TRANSFORM *New;i if (Old != NULL)   {r   New  = Create_Transform ();r   *New = *Old;   }t else New = NULL;
 return (New);  }t   VECTOR *Create_Vector () {  VECTOR *New;  8 if ((New = (VECTOR *) malloc (sizeof (VECTOR))) == NULL) MAError ("vector");r  ! Make_Vector (New, 0.0, 0.0, 0.0);t  
 return (New);o }t   VECTOR *Copy_Vector (Old)v VECTOR *Old; {  VECTOR *New; if (Old != NULL)   {    New  = Create_Vector ();   *New = *Old;   }  else New = NULL;
 return (New);i }r   DBL *Create_Float () {4 DBL *New_Float;w  8 if ((New_Float = (DBL *) malloc (sizeof (DBL))) == NULL) MAError ("float");   *New_Float = 0.0;  return (New_Float);  }e   DBL *Copy_Float (Old)[	 DBL *Old;u {-	 DBL *New;e if (Old)   {    New  = Create_Float ();[   *New = *Old;   }r else New = NULL;
 return (New);o }   int_Light (Light_Source, Light_Source_Depth,,           &Light_Source_Ray, &Light_Colour);       }s     Shadow_Test_Flag = FALSE;(  1     if (fabs(Light_Colour.Red)  > BLACK_LEVEL || t0       fabs(Light_Colour.Green) > BLACK_LEVEL || -       fabs(Light_Colour.Blue) > BLACK_LEVEL) _       {o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     