M /****************************************************************************  *                parse.c * C *  This module implements a parser for the scene description files.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"  #include "parse.h"  I /* This file implements a simple recursive-descent parser for reading the  input file.  */    extern DBL Max_Trace_Level;  extern char VerboseFormat; extern unsigned int Options; extern int Use_Slabs; - extern char Stat_File_Name[FILE_NAME_LENGTH];   5 extern struct Reserved_Word_Struct Reserved_Words [];  extern DBL Antialias_Threshold;   ! extern struct Token_Struct Token; % extern char String[MAX_STRING_INDEX];   ' extern COLOUR_MAP_ENTRY *Build_Entries;  extern FRAME Frame;  extern DBL Clock_Value;  extern char **Symbol_Table;  extern int Max_Intersections;  extern DBL Language_Version;( extern METHODS Csg_Height_Field_Methods;! extern METHODS CSG_Union_Methods;   7 static void Parse_Image_Map PARAMS((PIGMENT *Pigment)); 6 static void Parse_Bump_Map PARAMS((TNORMAL *Tnormal));: static void Parse_Pigment PARAMS((PIGMENT **Pigment_Ptr));: static void Parse_Tnormal PARAMS((TNORMAL **Tnormal_Ptr));7 static void Parse_Finish PARAMS((FINISH **Finish_Ptr)); - static TEXTURE *Parse_Texture PARAMS((void)); & static void Token_Init PARAMS((void));& static void Frame_Init PARAMS((void));: static void Parse_Coeffs PARAMS((int order, DBL *Coeffs));. static IMAGE *Parse_Image PARAMS((int Legal));1 static TRANSFORM *Parse_Transform PARAMS((void)); 7 static void Parse_Object_Mods PARAMS((OBJECT *Object)); 2 static OBJECT *Parse_Bicubic_Patch PARAMS((void));) static OBJECT *Parse_Blob PARAMS((void)); ( static OBJECT *Parse_Box PARAMS((void));) static OBJECT *Parse_Cone PARAMS((void)); - static OBJECT *Parse_Cylinder PARAMS((void)); ) static OBJECT *Parse_Disc PARAMS((void)); 1 static OBJECT *Parse_Height_Field PARAMS((void)); * static OBJECT *Parse_Plane PARAMS((void));. static OBJECT *Parse_Poly PARAMS((int order));, static OBJECT *Parse_Quadric PARAMS((void));4 static OBJECT *Parse_Smooth_Triangle PARAMS((void));+ static OBJECT *Parse_Sphere PARAMS((void)); * static OBJECT *Parse_Torus PARAMS((void));- static OBJECT *Parse_Triangle PARAMS((void)); 0 static OBJECT *Parse_CSG PARAMS((int CSG_Type));1 static OBJECT *Parse_Light_Source PARAMS((void)); + static OBJECT *Parse_Object PARAMS((void)); % static void Parse_Fog PARAMS((void)); ' static void Parse_Frame PARAMS((void)); 7 static void Parse_Camera PARAMS((CAMERA **Camera_Ptr)); ) static void Parse_Declare PARAMS((void)); V static void Link PARAMS((OBJECT *New_Object,OBJECT **Field,OBJECT **Old_Object_List));P static void Link_Textures PARAMS((TEXTURE **Old_Texture, TEXTURE *New_Texture));7 static char *Get_Token_String PARAMS((TOKEN Token_Id)); ' static void Where_Error PARAMS((void)); ) static int Test_Redefine PARAMS((int a)); / static OBJECT *Parse_Bound_Clip PARAMS((void)); ) static void Found_Instead PARAMS((void)); 4 /*static void Parse_Warn PARAMS((TOKEN Token_Id));*/< static void Warn_State PARAMS((TOKEN Token_Id, TOKEN Type));B static void Post_Process PARAMS((OBJECT *Object, OBJECT *Parent));- static void Destroy_Constants PARAMS((void)); . static OBJECT *Parse_Object_Id PARAMS((void));3 static void Link_To_Frame PARAMS((OBJECT *Object));   7 extern struct Constant_Struct Constants[MAX_CONSTANTS];    int Number_Of_Constants;
 int Previous;  short Have_Vector; short Not_In_Default;    TOKEN *Brace_Stack;  int Brace_Index;   TEXTURE *Default_Texture;  CAMERA *Default_Camera;    /* Parse the file. */ 
 void Parse ()    {     Build_Entries  = NULL; K    if ((Brace_Stack = (TOKEN *) malloc(MAX_BRACES*sizeof (TOKEN))) == NULL)       MAError ("brace stack");     Brace_Index = 0;     Token_Init (); $    Default_Camera = Create_Camera();*    Default_Texture = Create_PNF_Texture();/    Default_Texture->Pigment = Create_Pigment(); #    Default_Texture->Tnormal = NULL; .    Default_Texture->Finish  = Create_Finish();    Not_In_Default = TRUE;     Frame_Init ();     Parse_Frame ();    if (Frame.Objects==NULL) "      Error("No objects in scene");    Destroy_Constants ();%    Destroy_Textures(Default_Texture); "    Destroy_Camera(Default_Camera);    if (Build_Entries != NULL)       free (Build_Entries);    free (Brace_Stack);   }    static void Token_Init ()    {     Number_Of_Constants = 0;    }   7 /* Set up the fields in the frame to default values. */  static void Frame_Init ()   { .    Frame.Camera = Copy_Camera(Default_Camera);    Frame.Light_Sources = NULL;    Frame.Objects = NULL;    Frame.Atmosphere_IOR = 1.0;3    Frame.Antialias_Threshold = Antialias_Threshold;     Frame.Fog_Distance = 0.0;4    Make_Colour (&(Frame.Fog_Colour), 0.0, 0.0, 0.0);   }    void Parse_Begin ()    {     char *front;   -    Brace_Stack[++Brace_Index]=Token.Token_Id;     Get_Token ();  *    if (Token.Token_Id == LEFT_CURLY_TOKEN)      return;      Where_Error ();  7    front = Get_Token_String (Brace_Stack[Brace_Index]); 3    fprintf (stderr, "Missing { after %s, ", front);     Found_Instead ();    exit (1);   }    void Parse_End ()    {     char *front;       Get_Token ();  +    if (Token.Token_Id == RIGHT_CURLY_TOKEN)       {       Brace_Index--;
       return;       }      Where_Error ();  7    front = Get_Token_String (Brace_Stack[Brace_Index]); 3    fprintf (stderr, "No matching } in %s,", front);     Found_Instead ();    exit (1);   }   ! static OBJECT *Parse_Object_Id ()    {     OBJECT *Object;     	    EXPECT       CASE (OBJECT_ID_TOKEN) 1        Warn_State(OBJECT_ID_TOKEN, OBJECT_TOKEN); <        Object = Copy_Object((OBJECT *) Token.Constant_Data);"        Parse_Object_Mods (Object);        EXIT 
      END_CASE         OTHERWISE        Object = NULL;         UNGET        EXIT 
      END_CASE 
    END_EXPECT       return (Object);    }    void Parse_Comma ()    {     Get_Token(); %    if (Token.Token_Id != COMMA_TOKEN)       {       UNGET;      }   }   ' static void Parse_Coeffs(order, Coeffs)    int order;   DBL *Coeffs;   { 	    int i;   	    EXPECT       CASE (LEFT_ANGLE_TOKEN)!        Coeffs[0] = Parse_Float(); /        for (i = 1; i < term_counts(order); i++) 
          {           Parse_Comma();$           Coeffs[i] = Parse_Float();
          }        GET (RIGHT_ANGLE_TOKEN);         EXIT 
      END_CASE         OTHERWISE&        Parse_Error (LEFT_ANGLE_TOKEN);
      END_CASE 
    END_EXPECT    }    static IMAGE *Parse_Image (Legal)   int Legal;   {     IMAGE *Image;    VECTOR Local_Vector;       Image = Create_Image ();       if (Legal & GRAD_FILE)       {       EXPECT         CASE_VECTOR P           Warn("Should use map_type keyword and/or eliminate orientation.",1.5);           Have_Vector = FALSE;-           Parse_Vector_Float (&Local_Vector);            if (Have_Vector)+             Image->Gradient = Local_Vector;            else2             Image->Map_Type = (int)Local_Vector.x;         END_CASE           OTHERWISE            UNGET            EXIT         END_CASE       END_EXPECT      }  	    EXPECT*      CASE (IFF_TOKEN)*#        Image->File_Type = IFF_FILE;         GET (STRING_TOKEN);2        Read_Iff_Image (Image, Token.Token_String);        EXIT 
      END_CASEe        CASE (GIF_TOKEN)a#        Image->File_Type = GIF_FILE;f        GET (STRING_TOKEN);1        Read_Gif_Image(Image, Token.Token_String);-        EXIT 
      END_CASEo        CASE (POT_TOKEN)d#        Image->File_Type = POT_FILE;t        GET (STRING_TOKEN);1        Read_Gif_Image(Image, Token.Token_String);         EXITe
      END_CASEy        CASE (DUMP_TOKEN)$        Image->File_Type = DUMP_FILE;        GET (STRING_TOKEN);2        Read_Dump_Image(Image, Token.Token_String);        EXITu
      END_CASEi        CASE (TGA_TOKEN) #        Image->File_Type = TGA_FILE;a        GET (STRING_TOKEN);3        Read_Targa_Image(Image, Token.Token_String);G        EXITo
      END_CASEm        OTHERWISE)        Parse_Error_Str ("map file spec"); 
      END_CASEr
    END_EXPECTt  #    if (!(Image->File_Type & Legal)) ,      Error ("File type not supported here");    return (Image);   }0  % static void Parse_Image_Map (Pigment)o   PIGMENT *Pigment;*   {*    int reg;*  %    Pigment->Type = IMAGE_MAP_PIGMENT;*      Parse_Begin ();  -    Pigment->Image = Parse_Image (IMAGE_FILE);o*    Pigment->Image->Use_Colour_Flag = TRUE;  8    EXPECT                   /* Look for image_attribs */      CASE (ONCE_TOKEN)&        Pigment->Image->Once_Flag=TRUE;
      END_CASEa        CASE (INTERPOLATE_TOKEN) ?        Pigment->Image->Interpolation_Type = (int)Parse_Float();T
      END_CASEs        CASE (MAP_TYPE_TOKEN)7        Pigment->Image->Map_Type = (int) Parse_Float ();e
      END_CASE_        CASE (USE_COLOUR_TOKEN).        Pigment->Image->Use_Colour_Flag = TRUE;
      END_CASEs        CASE (USE_INDEX_TOKEN)n/        Pigment->Image->Use_Colour_Flag = FALSE; 
      END_CASEI        CASE (ALPHA_TOKEN)LE        Warn("Keyword ALPHA discontinued.  Use FILTER instead.",1.55);O	          n      CASE (FILTER_TOKEN)
        EXPECT           CASE (ALL_TOKEN)             {             DBL filter;O#             filter = Parse_Float();iI             for (reg = 0 ; reg < Pigment->Image->Colour_Map_Size ; reg++)N4               Pigment->Image->Colour_Map[reg].Filter5                   = (unsigned short) (filter *255.0);r            }            EXIT           END_CASEv            OTHERWISE            UNGET-            reg = (int)(Parse_Float() + 0.01);d2            if (Pigment->Image->Colour_Map == NULL)I              Error ("Can't apply FILTER to a non colour-mapped image\n");vE            if ((reg < 0) || (reg >= Pigment->Image->Colour_Map_Size))BD              Error ("FILTER colour register value out of range.\n");              Parse_Comma();P1            Pigment->Image->Colour_Map[reg].Filtero=                   = (unsigned short) (255.0 * Parse_Float());O            EXIT           END_CASEt          END_EXPECTi
      END_CASES        OTHERWISE        UNGET        EXIT(
      END_CASEc
    END_EXPECTP      Parse_End (); };  $ static void Parse_Bump_Map (Tnormal)   TNORMAL *Tnormal;    {e    Tnormal->Type = BUMP_MAP;      Parse_Begin ();  .    Tnormal->Image = Parse_Image (NORMAL_FILE);  *    Tnormal->Image->Use_Colour_Flag = TRUE;  	    EXPECT(      CASE (ONCE_TOKEN)&        Tnormal->Image->Once_Flag=TRUE;
      END_CASEe        CASE (MAP_TYPE_TOKEN)7        Tnormal->Image->Map_Type = (int) Parse_Float ();i
      END_CASEA        CASE (INTERPOLATE_TOKEN)r?        Tnormal->Image->Interpolation_Type = (int)Parse_Float();a
      END_CASEt        CASE (BUMP_SIZE_TOKEN)((        Tnormal->Amount = Parse_Float ();
      END_CASEE        CASE (USE_COLOUR_TOKEN).        Tnormal->Image->Use_Colour_Flag = TRUE;
      END_CASE,        CASE (USE_INDEX_TOKEN)c/        Tnormal->Image->Use_Colour_Flag = FALSE; 
      END_CASEh        OTHERWISE        UNGET        EXITe
      END_CASEi
    END_EXPECTc    Parse_End (); }C  ' static void Parse_Pigment (Pigment_Ptr)t   PIGMENT **Pigment_Ptr;   {v    PIGMENT *New;    VECTOR Local_Vector;       Parse_Begin ();  0    EXPECT            /* Look for [pigment_id] */      CASE (PIGMENT_ID_TOKEN)%        Destroy_Pigment(*Pigment_Ptr);eE        *Pigment_Ptr = Copy_Pigment ((PIGMENT *) Token.Constant_Data);(        EXITt
      END_CASE_        OTHERWISE        UNGET        EXITr
      END_CASEr%    END_EXPECT    /* End pigment_id */u      New = *Pigment_Ptr;  	    EXPECTr      CASE (AGATE_TOKEN)_!        New->Type = AGATE_PIGMENT;         EXITn
      END_CASE         CASE (BOZO_TOKEN)         New->Type = BOZO_PIGMENT;        EXITo
      END_CASE         CASE (GRANITE_TOKEN) #        New->Type = GRANITE_PIGMENT;l        EXIT*
      END_CASE)        CASE (LEOPARD_TOKEN)a#        New->Type = LEOPARD_PIGMENT;         EXIT)
      END_CASEC        CASE (MARBLE_TOKEN)"        New->Type = MARBLE_PIGMENT;        EXITu
      END_CASEm        CASE (MANDEL_TOKEN)"        New->Type = MANDEL_PIGMENT;,        New->Iterations = (int)Parse_Float();        EXITe
      END_CASE         CASE (ONION_TOKEN)e!        New->Type = ONION_PIGMENT;U        EXITr
      END_CASEi        CASE (PAINTED1_TOKEN)$        New->Type = PAINTED1_PIGMENT;        EXITD
      END_CASEe        CASE (PAINTED2_TOKEN)$        New->Type = PAINTED2_PIGMENT;        EXITe
      END_CASE;        CASE (PAINTED3_TOKEN)$        New->Type = PAINTED2_PIGMENT;        EXIT 
      END_CASEi        CASE (SPOTTED_TOKEN)v#        New->Type = SPOTTED_PIGMENT;)        EXITa
      END_CASEy        CASE (WOOD_TOKEN)         New->Type = WOOD_PIGMENT;        EXITs
      END_CASEa        CASE (GRADIENT_TOKEN)$        New->Type = GRADIENT_PIGMENT;.        Parse_Vector (&(New->Colour_Gradient));        EXITr
      END_CASE,        CASE (RADIAL_TOKEN)"        New->Type = RADIAL_PIGMENT;
      END_CASEa        CASE (COLOUR_TOKEN)"        New->Type = COLOUR_PIGMENT;'        New->Colour1 = Create_Colour (); #        Parse_Colour (New->Colour1); )        New->Quick_Colour = *New->Colour1;a        EXIT 
      END_CASEe  J      CASE5 (COLOUR_ID_TOKEN, RGB_TOKEN, RGBF_TOKEN, RED_TOKEN, BLUE_TOKEN)3      CASE3 (GREEN_TOKEN, ALPHA_TOKEN, FILTER_TOKEN)G        UNGET"        New->Type = COLOUR_PIGMENT;'        New->Colour1 = Create_Colour (); #        Parse_Colour (New->Colour1);r)        New->Quick_Colour = *New->Colour1;e        EXITI
      END_CASEr        CASE (CHECKER_TOKEN)i#        New->Type = CHECKER_PIGMENT;;.        New->Colour_Map = Parse_Colour_List(2);        EXIT 
      END_CASEO        CASE (HEXAGON_TOKEN) #        New->Type = HEXAGON_PIGMENT;_.        New->Colour_Map = Parse_Colour_List(3);        EXITO
      END_CASE)        CASE (IMAGE_MAP_TOKEN)P        Parse_Image_Map (New);         EXIT 
      END_CASE         OTHERWISE        UNGET        EXITU
      END_CASEI.    END_EXPECT     /* Concludes pigment_body */  1    EXPECT         /* Look for pigment_modifier */t      CASE (TURBULENCE_TOKEN).        Parse_Vector_Float(&(New->Turbulence));D        if ((New->Turbulence.x !=0.0) || (New->Turbulence.y !=0.0) ||%            (New->Turbulence.z !=0.0))P!           New->Flags |= HAS_TURB; 
      END_CASE]        CASE (COLOUR_MAP_TOKEN)*        if (New->Type == CHECKER_PIGMENT ||*            New->Type == HEXAGON_PIGMENT ||)            New->Type == COLOUR_PIGMENT || *            New->Type == IMAGE_MAP_PIGMENT)B          Warn ("Cannot use color map with this pigment type",1.5);-        New->Colour_Map = Parse_Colour_Map ();t
      END_CASEe        CASE (QUICK_COLOUR_TOKEN))        Parse_Colour (&New->Quick_Colour); 
      END_CASEC        CASE (OCTAVES_TOKEN)g)        New->Octaves = (int)Parse_Float();           if(New->Octaves < 1)n             New->Octaves = 1;n9          if(New->Octaves > 10)  /* Avoid DOMAIN errors */              New->Octaves = 10;
      END_CASEc        CASE (OMEGA_TOKEN)V"        New->omega = Parse_Float();
      END_CASE         CASE (LAMBDA_TOKEN)#        New->lambda = Parse_Float();.
      END_CASE_        CASE (FREQUENCY_TOKEN) &        New->Frequency = Parse_Float();
      END_CASEN        CASE (PHASE_TOKEN)C"        New->Phase = Parse_Float();
      END_CASE         CASE (AGATE_TURB_TOKEN):        if (Not_In_Default && (New->Type != AGATE_PIGMENT))=           Warn("Attempt to use agate_turb on non-agate",1.9); -        New->Agate_Turb_Scale = Parse_Float();I
      END_CASE         CASE (TRANSLATE_TOKEN)T$        Parse_Vector (&Local_Vector);.        Translate_Pigment (New, &Local_Vector);
      END_CASE_        CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);+        Rotate_Pigment (New, &Local_Vector);C
      END_CASES        CASE (SCALE_TOKEN)e*        Parse_Scale_Vector (&Local_Vector);*        Scale_Pigment (New, &Local_Vector);
      END_CASE;        CASE (TRANSFORM_TOKEN)         GET(TRANSFORM_ID_TOKEN)A        Transform_Pigment (New, (TRANSFORM *)Token.Constant_Data);R
      END_CASE(        OTHERWISE        UNGET        EXIT 
      END_CASE 
    END_EXPECT   3    if (Not_In_Default && (New->Type == NO_PIGMENT))S:      Warn("Pigment type unspecified or not 1st item",1.7);      Parse_End ();   }t  ' static void Parse_Tnormal (Tnormal_Ptr)0   TNORMAL **Tnormal_Ptr;   {     TNORMAL *New;    VECTOR Local_Vector;i      Parse_Begin ();  0    EXPECT            /* Look for [tnormal_id] */      CASE (TNORMAL_ID_TOKEN)%        Destroy_Tnormal(*Tnormal_Ptr);UE        *Tnormal_Ptr = Copy_Tnormal ((TNORMAL *) Token.Constant_Data);_        EXIT 
      END_CASEO        OTHERWISE        UNGET        EXIT 
      END_CASE '    END_EXPECT    /* End [tnormal_id] */P      if (*Tnormal_Ptr == NULL),      if ((Default_Texture->Tnormal) != NULL)@        *Tnormal_Ptr = Copy_Tnormal ((Default_Texture->Tnormal));	      else (        *Tnormal_Ptr = Create_Tnormal ();      New = *Tnormal_Ptr;      EXPECT  /* [tnormal_body] */       CASE (BUMPS_TOKEN)         New->Type = BUMPS;P$        New->Amount = Parse_Float ();        EXITC
      END_CASES        CASE (BUMPY1_TOKEN)        New->Type = BUMPY1;$        New->Amount = Parse_Float ();        EXITC
      END_CASEE        CASE (BUMPY2_TOKEN)        New->Type = BUMPY2;$        New->Amount = Parse_Float ();        EXIT=
      END_CASEi        CASE (BUMPY3_TOKEN)        New->Type = BUMPY3;$        New->Amount = Parse_Float ();        EXIT>
      END_CASE.        CASE (DENTS_TOKEN)         New->Type = DENTS;5$        New->Amount = Parse_Float ();        EXITD
      END_CASE         CASE (RIPPLES_TOKEN)T        New->Type = RIPPLES;e$        New->Amount = Parse_Float ();        EXITC
      END_CASEL        CASE (WAVES_TOKEN)n        New->Type = WAVES;l$        New->Amount = Parse_Float ();        EXIT 
      END_CASE-        CASE (WRINKLES_TOKEN)        New->Type = WRINKLES;$        New->Amount = Parse_Float ();        EXITP
      END_CASE         CASE (BUMP_MAP_TOKEN)        Parse_Bump_Map (New);        EXITu
      END_CASE(        OTHERWISE6        if (Not_In_Default && (New->Type == NO_NORMAL))(          Parse_Error_Str("normal body");        UNGET        EXITI
      END_CASES*    END_EXPECT    /* End of tnormal_body */  ,    EXPECT        /* Look for tnormal_mods */        CASE (TURBULENCE_TOKEN).        Parse_Vector_Float(&(New->Turbulence));D        if ((New->Turbulence.x !=0.0) || (New->Turbulence.y !=0.0) ||%            (New->Turbulence.z !=0.0))S!           New->Flags |= HAS_TURB;g
      END_CASEU        CASE (OCTAVES_TOKEN)S)        New->Octaves = (int)Parse_Float();M
      END_CASE         CASE (OMEGA_TOKEN)C"        New->omega = Parse_Float();
      END_CASEm        CASE (LAMBDA_TOKEN)#        New->lambda = Parse_Float();S
      END_CASE         CASE (FREQUENCY_TOKEN)m9        if (!(New->Type == RIPPLES || New->Type == WAVES))U%          if (Language_Version >= 1.5)->            Warn ("Cannot use frequency with this normal",1.5);&        New->Frequency = Parse_Float();
      END_CASEE        CASE (PHASE_TOKEN)O9        if (!(New->Type == RIPPLES || New->Type == WAVES))D%          if (Language_Version >= 1.5)c;             Warn ("Cannot use phase with this normal",1.5); "        New->Phase = Parse_Float();
      END_CASE         CASE (TRANSLATE_TOKEN) $        Parse_Vector (&Local_Vector);.        Translate_Tnormal (New, &Local_Vector);
      END_CASE_        CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);+        Rotate_Tnormal (New, &Local_Vector); 
      END_CASE         CASE (SCALE_TOKEN) *        Parse_Scale_Vector (&Local_Vector);*        Scale_Tnormal (New, &Local_Vector);
      END_CASES        CASE (TRANSFORM_TOKEN)y        GET(TRANSFORM_ID_TOKEN)A        Transform_Tnormal (New, (TRANSFORM *)Token.Constant_Data);Z
      END_CASE         OTHERWISE        UNGET        EXITE
      END_CASE *    END_EXPECT    /* End of tnormal_mods */      Parse_End ();   }C  % static void Parse_Finish (Finish_Ptr)L   FINISH **Finish_Ptr;   {)    FINISH *New;       Parse_Begin ();  5    EXPECT        /* Look for zero or one finish_id */       CASE (FINISH_ID_TOKEN)N#        Destroy_Finish(*Finish_Ptr);_B        *Finish_Ptr = Copy_Finish ((FINISH *) Token.Constant_Data);        EXITS
      END_CASE         OTHERWISE        UNGET        EXITE
      END_CASEI$    END_EXPECT    /* End finish_id */      New = *Finish_Ptr;y  8    EXPECT        /* Look for zero or more finish_body */      CASE (AMBIENT_TOKEN) %        New->Ambient = Parse_Float (); 
      END_CASED        CASE (BRILLIANCE_TOKEN)(        New->Brilliance = Parse_Float ();
      END_CASE         CASE (DIFFUSE_TOKEN)S%        New->Diffuse = Parse_Float ();T
      END_CASE         CASE (REFLECTION_TOKEN)(        New->Reflection = Parse_Float ();
      END_CASE         CASE (REFRACTION_TOKEN)(        New->Refraction = Parse_Float ();
      END_CASEM        CASE (IOR_TOKEN) 1        New->Index_Of_Refraction = Parse_Float ();C
      END_CASES        CASE (PHONG_TOKEN)w#        New->Phong = Parse_Float ();S
      END_CASE         CASE (PHONG_SIZE_TOKEN)(        New->Phong_Size = Parse_Float ();! /*     if (New->Phong_Size < 1.0)l!            New->Phong_Size = 1.0;u!        if (New->Phong_Size > 100) $            New->Phong_Size = 100; */
      END_CASE,        CASE (SPECULAR_TOKEN)&        New->Specular = Parse_Float ();
      END_CASE         CASE (ROUGHNESS_TOKEN) '        New->Roughness = Parse_Float ();N  /*     if (New->Roughness > 1.0)             New->Roughness = 1.0;"        if (New->Roughness < 0.001)&            New->Roughness = 0.001;  */;        New->Roughness = 1.0/New->Roughness; /* CEY 12/92 */G
      END_CASEN        CASE (METALLIC_TOKEN)!        New->Metallic_Flag = TRUE;S
      END_CASE         CASE (CRAND_TOKEN)w"        New->Crand = Parse_Float();
      END_CASE=        OTHERWISE        UNGET        EXITD
      END_CASEC)    END_EXPECT    /* End of finish_body */M  +    EXPECT        /* Look for finish_mods */    /*   CASE none implemented      END_CASE     */        OTHERWISE        UNGET        EXITd
      END_CASEC)    END_EXPECT    /* End of finish_mods */       Parse_End ();   }E  S #define ADD_TNORMAL if (Tnormal == NULL) {if ((Default_Texture->Tnormal) != NULL) \)X  Tnormal = Copy_Tnormal ((Default_Texture->Tnormal)); else Tnormal = Create_Tnormal ();\  Texture->Tnormal=Tnormal;};   static TEXTURE *Parse_Texture ()    {     VECTOR Local_Vector;_$    TEXTURE *Texture, *Local_Texture;    PIGMENT *Pigment;    TNORMAL *Tnormal;    FINISH *Finish;      Parse_Begin ();  :    EXPECT                      /* Look for texture_body */      CASE (TILES_TOKEN)         Parse_Begin ();  4        Texture = (TEXTURE *)Create_Tiles_Texture ();  
        EXPECT           CASE (TEXTURE_TOKEN)k,            Local_Texture = Parse_Texture ();E            Link_Textures(&(((TILES *)Texture)->Tile1),Local_Texture);-          END_CASE             OTHERWISE            UNGET            EXIT)          END_CASEr        END_EXPECT           GET (TILE2_TOKEN);D  
        EXPECTS          CASE (TEXTURE_TOKEN)m,            Local_Texture = Parse_Texture ();E            Link_Textures(&(((TILES *)Texture)->Tile2),Local_Texture);_          END_CASEU            OTHERWISE            UNGET            EXIT           END_CASEC        END_EXPECT         Parse_End ();        EXIT 
      END_CASE         CASE (MATERIAL_MAP_TOKEN)        Parse_Begin ();  7        Texture = (TEXTURE *)Create_Material_Texture ();o  A        ((MATERIAL *)Texture)->Image = Parse_Image(MATERIAL_FILE);P=        ((MATERIAL *)Texture)->Image->Use_Colour_Flag = FALSE;   
        EXPECTo          CASE (ONCE_TOKEN)8            ((MATERIAL *)Texture)->Image->Once_Flag=TRUE;          END_CASEO  !          CASE (INTERPOLATE_TOKEN)tO            ((MATERIAL *)Texture)->Image->Interpolation_Type=(int)Parse_Float();S          END_CASE             CASE (MAP_TYPE_TOKEN)I            ((MATERIAL *)Texture)->Image->Map_Type = (int) Parse_Float ();           END_CASE             OTHERWISE            UNGET            EXIT(          END_CASEo        END_EXPECTR  >        GET (TEXTURE_TOKEN)                /* First material */K        ((MATERIAL *)Texture)->Materials = Local_Texture = Parse_Texture ();M,        ((MATERIAL *)Texture)->Num_Of_Mats++;  D        EXPECT                             /* Subsequent materials */          CASE (TEXTURE_TOKEN)*;            Local_Texture->Next_Material = Parse_Texture ();i8            Local_Texture = Local_Texture->Next_Material;0            ((MATERIAL *)Texture)->Num_Of_Mats++;          END_CASEl            OTHERWISE            UNGET            EXITO          END_CASEa        END_EXPECTE        Parse_End ();        EXITI
      END_CASET             CASE (TEXTURE_ID_TOKEN)@        Texture = Copy_Textures((TEXTURE *) Token.Constant_Data);        EXITe
      END_CASET        OTHERWISE        UNGET1        Texture = Copy_Textures (Default_Texture);         EXIT 
      END_CASEt
    END_EXPECTm    ;    /* Look for [pnf_texture] */E$    if (Texture->Type == PNF_TEXTURE)      {(        EXPECT   /* Look for [pnf_ids] */           CASE (PIGMENT_ID_TOKEN)-            Destroy_Pigment(Texture->Pigment);YM            Texture->Pigment = Copy_Pigment ((PIGMENT *) Token.Constant_Data);           END_CASEC             CASE (TNORMAL_ID_TOKEN)-            Destroy_Tnormal(Texture->Tnormal);PM            Texture->Tnormal = Copy_Tnormal ((TNORMAL *) Token.Constant_Data);           END_CASE;            CASE (FINISH_ID_TOKEN)(+            Destroy_Finish(Texture->Finish); J            Texture->Finish = Copy_Finish ((FINISH *) Token.Constant_Data);          END_CASE             OTHERWISE            UNGET            EXIT>          END_CASE         END_EXPECTP  "        Pigment = Texture->Pigment;"        Tnormal = Texture->Tnormal;!        Finish  = Texture->Finish;N  
        EXPECTe          CASE (PIGMENT_TOKEN)E1            Parse_Pigment ( &(Texture->Pigment) );>          END_CASE             CASE (TNORMAL_TOKEN);1            Parse_Tnormal ( &(Texture->Tnormal) );A          END_CASEr            CASE (FINISH_TOKEN)/            Parse_Finish ( &(Texture->Finish) );t          END_CASE-  H /***********************************************************************   PIGMENT STUFF OUTSIDE PIGMENT{}H ***********************************************************************/          CASE (AGATE_TOKEN)T@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           )            Pigment->Type = AGATE_PIGMENT;w          END_CASE0            CASE (BOZO_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           (            Pigment->Type = BOZO_PIGMENT;          END_CASEr            CASE (GRANITE_TOKEN) @            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           +            Pigment->Type = GRANITE_PIGMENT;N          END_CASEF            CASE (LEOPARD_TOKEN)C@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           +            Pigment->Type = LEOPARD_PIGMENT;o          END_CASE             CASE (MARBLE_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           *            Pigment->Type = MARBLE_PIGMENT;          END_CASEe            CASE (MANDEL_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           *            Pigment->Type = MANDEL_PIGMENT;4            Pigment->Iterations = (int)Parse_Float();          END_CASET            CASE (ONION_TOKEN)o@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           )            Pigment->Type = ONION_PIGMENT;           END_CASEo            CASE (PAINTED1_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           ,            Pigment->Type = PAINTED1_PIGMENT;          END_CASEm            CASE (PAINTED2_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           ,            Pigment->Type = PAINTED2_PIGMENT;          END_CASED            CASE (PAINTED3_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           ,            Pigment->Type = PAINTED2_PIGMENT;          END_CASEv            CASE (SPOTTED_TOKEN) @            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           +            Pigment->Type = SPOTTED_PIGMENT;f          END_CASEC            CASE (WOOD_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           (            Pigment->Type = WOOD_PIGMENT;          END_CASE             CASE (GRADIENT_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           ,            Pigment->Type = GRADIENT_PIGMENT;6            Parse_Vector (&(Pigment->Colour_Gradient));          END_CASE             CASE (COLOUR_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           *            Pigment->Type = COLOUR_PIGMENT;/            Pigment->Colour1 = Create_Colour (); +            Parse_Colour (Pigment->Colour1); 5            Pigment->Quick_Colour = *Pigment->Colour1;t          END_CASE   N          CASE5 (COLOUR_ID_TOKEN, RGB_TOKEN, RGBF_TOKEN, RED_TOKEN, BLUE_TOKEN)7          CASE3 (GREEN_TOKEN, ALPHA_TOKEN, FILTER_TOKEN)R@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);                       UNGET*            Pigment->Type = COLOUR_PIGMENT;/            Pigment->Colour1 = Create_Colour ();_+            Parse_Colour (Pigment->Colour1);_5            Pigment->Quick_Colour = *Pigment->Colour1;           END_CASEe            CASE (CHECKER_TOKEN)i@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           +            Pigment->Type = CHECKER_PIGMENT;S6            Pigment->Colour_Map = Parse_Colour_List(2);          END_CASEN            CASE (HEXAGON_TOKEN))@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           +            Pigment->Type = HEXAGON_PIGMENT; 6            Pigment->Colour_Map = Parse_Colour_List(3);          END_CASEN            CASE (IMAGE_MAP_TOKEN) @            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           %            Parse_Image_Map (Pigment);a          END_CASE=             CASE (TURBULENCE_TOKEN)6            Parse_Vector_Float(&(Pigment->Turbulence));/            if ((Pigment->Turbulence.x !=0.0) ||n/                (Pigment->Turbulence.y !=0.0) ||E-                (Pigment->Turbulence.z !=0.0)) (              Pigment->Flags |= HAS_TURB;          END_CASEs             CASE (COLOUR_MAP_TOKEN)5            Warn_State(Token.Token_Id, PIGMENT_TOKEN);u2            if (Pigment->Type == CHECKER_PIGMENT ||2                Pigment->Type == HEXAGON_PIGMENT ||1                Pigment->Type == COLOUR_PIGMENT || 2                Pigment->Type == IMAGE_MAP_PIGMENT)F              Warn ("Cannot use color map with this pigment type",1.5);5            Pigment->Colour_Map = Parse_Colour_Map ();e          END_CASEP  "          CASE (QUICK_COLOUR_TOKEN)@            Warn_State(Token.Token_Id, PIGMENT_TOKEN);           1            Parse_Colour (&Pigment->Quick_Colour);(          END_CASE             CASE (OCTAVES_TOKEN) 1            Pigment->Octaves = (int)Parse_Float(); %              if(Pigment->Octaves < 1)-%                 Pigment->Octaves = 1;CA              if(Pigment->Octaves > 10)  /* Avoid DOMAIN errors */ &                 Pigment->Octaves = 10;          END_CASEE            CASE (OMEGA_TOKEN) *            Pigment->omega = Parse_Float();          END_CASEe            CASE (LAMBDA_TOKEN)+            Pigment->lambda = Parse_Float();           END_CASE   H /*********************************************************************** TNORMAL STUFF OUTSIDE NORMAL{}H ***********************************************************************/          CASE (BUMPS_TOKEN) @            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL!            Tnormal->Type = BUMPS; ,            Tnormal->Amount = Parse_Float ();          END_CASE             CASE (BUMPY1_TOKEN)@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL"            Tnormal->Type = BUMPY1;,            Tnormal->Amount = Parse_Float ();          END_CASEt            CASE (BUMPY2_TOKEN)@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL"            Tnormal->Type = BUMPY2;,            Tnormal->Amount = Parse_Float ();          END_CASE(            CASE (BUMPY3_TOKEN)@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL"            Tnormal->Type = BUMPY3;,            Tnormal->Amount = Parse_Float ();          END_CASEM            CASE (DENTS_TOKEN) @            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL!            Tnormal->Type = DENTS;s,            Tnormal->Amount = Parse_Float ();          END_CASEt            CASE (RIPPLES_TOKEN)e@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL#            Tnormal->Type = RIPPLES; ,            Tnormal->Amount = Parse_Float ();          END_CASE             CASE (WAVES_TOKEN)O@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL!            Tnormal->Type = WAVES; ,            Tnormal->Amount = Parse_Float ();          END_CASE             CASE (WRINKLES_TOKEN)@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL$            Tnormal->Type = WRINKLES;,            Tnormal->Amount = Parse_Float ();          END_CASEt            CASE (BUMP_MAP_TOKEN)@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMAL$            Parse_Bump_Map (Tnormal);          END_CASEm            CASE (FREQUENCY_TOKEN)T@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMALE            if (!(Tnormal->Type == RIPPLES || Tnormal->Type == WAVES))n)              if (Language_Version >= 1.5)iB                Warn ("Cannot use frequency with this normal",1.5);.            Tnormal->Frequency = Parse_Float();          END_CASE             CASE (PHASE_TOKEN)P@            Warn_State(Token.Token_Id, TNORMAL_TOKEN);                       ADD_TNORMALE            if (!(Tnormal->Type == RIPPLES || Tnormal->Type == WAVES))P)              if (Language_Version >= 1.5) >                Warn ("Cannot use phase with this normal",1.5);*            Tnormal->Phase = Parse_Float();          END_CASE     H /*********************************************************************** FINISH STUFF OUTSIDE FINISH{}*H ***********************************************************************/          CASE (AMBIENT_TOKEN)*?            Warn_State(Token.Token_Id, FINISH_TOKEN);            ,            Finish->Ambient = Parse_Float ();          END_CASE              CASE (BRILLIANCE_TOKEN)?            Warn_State(Token.Token_Id, FINISH_TOKEN);            /            Finish->Brilliance = Parse_Float ();o          END_CASEE            CASE (DIFFUSE_TOKEN)t?            Warn_State(Token.Token_Id, FINISH_TOKEN);           I,            Finish->Diffuse = Parse_Float ();          END_CASE              CASE (REFLECTION_TOKEN)?            Warn_State(Token.Token_Id, FINISH_TOKEN);           D/            Finish->Reflection = Parse_Float ();I          END_CASE              CASE (REFRACTION_TOKEN)?            Warn_State(Token.Token_Id, FINISH_TOKEN);           )/            Finish->Refraction = Parse_Float ();O          END_CASE             CASE (IOR_TOKEN)L?            Warn_State(Token.Token_Id, FINISH_TOKEN);            8            Finish->Index_Of_Refraction = Parse_Float ();          END_CASEg            CASE (PHONG_TOKEN) ?            Warn_State(Token.Token_Id, FINISH_TOKEN);           C*            Finish->Phong = Parse_Float ();          END_CASEe             CASE (PHONG_SIZE_TOKEN)?            Warn_State(Token.Token_Id, FINISH_TOKEN);           o/            Finish->Phong_Size = Parse_Float ();r(     /*     if (Finish->Phong_Size < 1.0)(                Finish->Phong_Size = 1.0;(            if (Finish->Phong_Size > 100)+                Finish->Phong_Size = 100; */t          END_CASEI            CASE (SPECULAR_TOKEN)?            Warn_State(Token.Token_Id, FINISH_TOKEN);            -            Finish->Specular = Parse_Float ();(          END_CASEM            CASE (ROUGHNESS_TOKEN)P?            Warn_State(Token.Token_Id, FINISH_TOKEN);           C.            Finish->Roughness = Parse_Float ();'     /*     if (Finish->Roughness > 1.0) '                Finish->Roughness = 1.0;f)            if (Finish->Roughness < 0.001)_-                Finish->Roughness = 0.001;  */IE            Finish->Roughness = 1.0/Finish->Roughness; /* CEY 12/92 */           END_CASE             CASE (METALLIC_TOKEN)?            Warn_State(Token.Token_Id, FINISH_TOKEN);            (            Finish->Metallic_Flag = TRUE;          END_CASEc            CASE (CRAND_TOKEN))?            Warn_State(Token.Token_Id, FINISH_TOKEN);            )            Finish->Crand = Parse_Float();           END_CASE             CASE_FLOATU)            Finish->Crand = Parse_Float();rP            Warn("Should use crand keyword in finish statement.",1.5);                     END_CASEi            CASE (TRANSLATE_TOKEN) (            Parse_Vector (&Local_Vector);7            Translate_Textures (Texture, &Local_Vector);(          END_CASET            CASE (ROTATE_TOKEN)(            Parse_Vector (&Local_Vector);4            Rotate_Textures (Texture, &Local_Vector);          END_CASE;            CASE (SCALE_TOKEN) .            Parse_Scale_Vector (&Local_Vector);3            Scale_Textures (Texture, &Local_Vector);*          END_CASE             CASE (TRANSFORM_TOKEN) "            GET(TRANSFORM_ID_TOKEN)J            Transform_Textures (Texture, (TRANSFORM *)Token.Constant_Data);          END_CASE              CASE (TEXTURE_ID_TOKEN)E            Warn("Texture identifier overwriting previous values.",0); %            Destroy_Textures(Texture);ID            Texture = Copy_Textures((TEXTURE *) Token.Constant_Data);&            Pigment = Texture->Pigment;&            Tnormal = Texture->Tnormal;%            Finish  = Texture->Finish;           END_CASEe            OTHERWISE            UNGET            EXITI          END_CASEaI /***********************************************************************/V          END_EXPECT-  F        if (Not_In_Default && (Texture->Pigment->Type == NO_PIGMENT) &&%            !(Language_Version < 1.5))E'          Parse_Error(PIGMENT_ID_TOKEN);=        }  0    EXPECT            /* Look for texture_mods */      CASE (TRANSLATE_TOKEN)U$        Parse_Vector (&Local_Vector);3        Translate_Textures (Texture, &Local_Vector);t
      END_CASEE        CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);0        Rotate_Textures (Texture, &Local_Vector);
      END_CASE         CASE (SCALE_TOKEN)_*        Parse_Scale_Vector (&Local_Vector);/        Scale_Textures (Texture, &Local_Vector);P
      END_CASEM        CASE (TRANSFORM_TOKEN)         GET(TRANSFORM_ID_TOKEN)F        Transform_Textures (Texture, (TRANSFORM *)Token.Constant_Data);
      END_CASE         OTHERWISE        UNGET        EXITu
      END_CASEE)    END_EXPECT        /* End of texture */       Parse_End ();    return (Texture);   })   static OBJECT *Parse_Bound_Clip ()1   {     VECTOR Local_Vector;t"    OBJECT *First, *Current, *Prev;      First = Prev = NULL;M  .    while ((Current = Parse_Object ()) != NULL)      {9       if (Current->Type & (TEXTURED_OBJECT+PATCH_OBJECT)) <         Error ("Illegal texture or patch in clip or bound");       if (First == NULL)         First = Current;       if (Prev != NULL)           Prev->Sibling = Current;       Prev = Current;*      }  	    EXPECT*      CASE (TRANSLATE_TOKEN) $        Parse_Vector (&Local_Vector);        for (Current = First;             Current != NULL;'             Current = Current->Sibling)e3          Translate_Object (Current, &Local_Vector);D
      END_CASE         CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);        for (Current = First;             Current != NULL;'             Current = Current->Sibling)N0          Rotate_Object (Current, &Local_Vector);
      END_CASEm        CASE (SCALE_TOKEN) *        Parse_Scale_Vector (&Local_Vector);        for (Current = First;             Current != NULL;'             Current = Current->Sibling) /          Scale_Object (Current, &Local_Vector);m
      END_CASEY        CASE (TRANSFORM_TOKEN)=        GET(TRANSFORM_ID_TOKEN)        for (Current = First;             Current != NULL;'             Current = Current->Sibling) D        Transform_Object (Current, (TRANSFORM *)Token.Constant_Data);
      END_CASEu        OTHERWISE        UNGET        EXIT 
      END_CASEN
    END_EXPECT       return (First);   }e  & static void Parse_Object_Mods (Object)   OBJECT *Object;    {     VECTOR Local_Vector;     TEXTURE *Local_Texture;    OBJECT *Temp1_Object;    OBJECT *Temp2_Object;    COLOUR Local_Colour;     DBL Temp_Water_Level;  	    EXPECT_      CASE (COLOUR_TOKEN)$        Parse_Colour (&Local_Colour);"        if (Language_Version < 1.5)&          if (Object->Texture != NULL) 4            if (Object->Texture->Type == PNF_TEXTURE)              {D               Object->Texture->Pigment->Quick_Colour = Local_Colour;.               break;  /* acts like END_CASE */              }C        Warn("Quick color belongs in texture.  Color ignored.",0.0); 
      END_CASEo        CASE (TRANSLATE_TOKEN) $        Parse_Vector (&Local_Vector);0        Translate_Object (Object, &Local_Vector);
      END_CASEr        CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);-        Rotate_Object (Object, &Local_Vector);_
      END_CASE         CASE (SCALE_TOKEN) *        Parse_Scale_Vector (&Local_Vector);,        Scale_Object (Object, &Local_Vector);
      END_CASEW        CASE (TRANSFORM_TOKEN)A        GET(TRANSFORM_ID_TOKEN)C        Transform_Object (Object, (TRANSFORM *)Token.Constant_Data);y
      END_CASE         CASE (BOUNDED_BY_TOKEN)        Parse_Begin ();!        if (Object->Bound != NULL) +          if (Object->Clip == Object->Bound)eF            Error ("Cannot add bounds after linking bounds and clips");  
        EXPECT_           CASE (CLIPPED_BY_TOKEN)%            if (Object->Bound != NULL) >              Error ("Cannot link clips with previous bounds");(            Object->Bound = Object->Clip;            EXIT           END_CASEt            OTHERWISE            UNGET=            Temp1_Object = Temp2_Object = Parse_Bound_Clip (); 0            while (Temp2_Object->Sibling != NULL)2              Temp2_Object = Temp2_Object->Sibling;1            Temp2_Object->Sibling = Object->Bound;*(            Object->Bound = Temp1_Object;            EXIT           END_CASE(        END_EXPECTI        ;        Parse_End ();
      END_CASEe        CASE (CLIPPED_BY_TOKEN)        Parse_Begin ();         if (Object->Clip != NULL)+          if (Object->Clip == Object->Bound) E            Error ("Cannot add clips after linking bounds and clips");C  
        EXPECTC           CASE (BOUNDED_BY_TOKEN)$            if (Object->Clip != NULL)>              Error ("Cannot link bounds with previous clips");(            Object->Clip = Object->Bound;            EXIT           END_CASEe            OTHERWISE            UNGET=            Temp1_Object = Temp2_Object = Parse_Bound_Clip ();C0            while (Temp2_Object->Sibling != NULL)2              Temp2_Object = Temp2_Object->Sibling;0            Temp2_Object->Sibling = Object->Clip;'            Object->Clip = Temp1_Object;             EXIT           END_CASEo        END_EXPECTH          Parse_End ();
      END_CASE-        CASE (TEXTURE_TOKEN)F'        Object->Type |= TEXTURED_OBJECT;C(        Local_Texture = Parse_Texture ();8        Link_Textures(&(Object->Texture), Local_Texture);
      END_CASEr  7      CASE3 (PIGMENT_TOKEN, TNORMAL_TOKEN, FINISH_TOKEN)Z'        Object->Type |= TEXTURED_OBJECT;e#        if (Object->Texture == NULL) :          Object->Texture = Copy_Textures(Default_Texture);        elseg2          if (Object->Texture->Type != PNF_TEXTURE)M            Link_Textures(&(Object->Texture), Copy_Textures(Default_Texture));         UNGET
        EXPECTI          CASE (PIGMENT_TOKEN)E9            Parse_Pigment ( &(Object->Texture->Pigment) );           END_CASE             CASE (TNORMAL_TOKEN))9            Parse_Tnormal ( &(Object->Texture->Tnormal) );           END_CASEt            CASE (FINISH_TOKEN)7            Parse_Finish ( &(Object->Texture->Finish) );(          END_CASEF            OTHERWISE            UNGET            EXITs          END_CASE         END_EXPECTe
      END_CASE         CASE (INVERSE_TOKEN)s'        if (Object->Type & PATCH_OBJECT)e3          Warn ("Cannot invert a patch object",0.0);         Invert_Object (Object);
      END_CASE         CASE (STURM_TOKEN)o-        if (!(Object->Type & STURM_OK_OBJECT))F)          Error ("Cannot use STRUM here");C,        ((POLY *) Object)->Sturm_Flag = TRUE;
      END_CASEo        CASE (WATER_LEVEL_TOKEN) 3        if (!(Object->Type & WATER_LEVEL_OK_OBJECT)) /          Error ("Cannot use WATER_LEVEL here"); (        Temp_Water_Level = Parse_Float();"        if (Language_Version < 2.0)"          Temp_Water_Level /=256.0;Y        ((HEIGHT_FIELD *) Object)->bounding_box->bounds[0].y = 65536.0 * Temp_Water_Level;_
      END_CASE         CASE (SMOOTH_TOKEN).        if (!(Object->Type & SMOOTH_OK_OBJECT))*          Error ("Cannot use SMOOTH here");2        ((HEIGHT_FIELD *) Object)->Smoothed = TRUE;)        Object->Type |= DOUBLE_ILLUMINATE;S
      END_CASEC        CASE (NO_SHADOW_TOKEN)P%        Object->No_Shadow_Flag = TRUE; 
      END_CASEx        CASE (LIGHT_SOURCE_TOKEN)>        Error("Light source must be defined using new syntax");
      END_CASEM        OTHERWISE        UNGET        EXITx
      END_CASEM
    END_EXPECTn      if (Object->Bound != NULL)       {C       Object->Bounds.Lower_Left = Object->Bound->Bounds.Lower_Left;n@       Object->Bounds.Lengths    = Object->Bound->Bounds.Lengths;      }    Parse_End ();   }r   static OBJECT *Parse_Sphere ();   {     SPHERE *Object;      Parse_Begin ();  7    if ( (Object = (SPHERE *)Parse_Object_Id()) != NULL)u!       return ((OBJECT *) Object);            Object = Create_Sphere();  6    Parse_Vector(&(Object -> Center));   Parse_Comma();$    Object -> Radius = Parse_Float();B    Object -> Radius_Squared = Object -> Radius * Object -> Radius;5    Object -> Inverse_Radius = 1.0 / Object -> Radius;   *    Make_Vector(&Object->Bounds.Lower_Left,* 	       Object->Center.x - Object->Radius,* 	       Object->Center.y - Object->Radius,+ 	       Object->Center.z - Object->Radius);c'    Make_Vector(&Object->Bounds.Lengths,x 	       2.0 * Object->Radius,t 	       2.0 * Object->Radius,R 	       2.0 * Object->Radius);  )    Parse_Object_Mods ((OBJECT *) Object);e      return ((OBJECT *) Object);   }    static OBJECT *Parse_Plane ()   {e    PLANE *Object;a      Parse_Begin ();  6    if ( (Object = (PLANE *)Parse_Object_Id()) != NULL)!       return ((OBJECT *) Object);            Object = Create_Plane();s  =    Parse_Vector(&(Object -> Normal_Vector));   Parse_Comma();E<    VNormalize(Object->Normal_Vector, Object->Normal_Vector);%    Object->Distance = -Parse_Float();f  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }s   static OBJECT *Parse_Height_Field ()e   {t    HEIGHT_FIELD *Object;    VECTOR Local_Vector;P    IMAGE *Image;      Parse_Begin ();  =    if ( (Object = (HEIGHT_FIELD *)Parse_Object_Id()) != NULL)E!       return ((OBJECT *) Object);r       "    Object = Create_Height_Field();  !    Image = Parse_Image (HF_FILE); "    Image->Use_Colour_Flag = FALSE;  +    Object->bounding_box->bounds[0].x = 1.0; +    Object->bounding_box->bounds[0].y = 0.0; +    Object->bounding_box->bounds[0].z = 1.0;o$    if (Image->File_Type == POT_FILE)      {C       Object->bounding_box->bounds[1].x = Image -> width/2.0 - 2.0;iP       Make_Vector(&Local_Vector,2.0/Image->width,1.0/65536.0,1.0/Image->height);      }    elseE      {?       Object->bounding_box->bounds[1].x = Image -> width - 2.0; T       Make_Vector(&Local_Vector,1.0/(Image->width),1.0/65536.0,1.0/(Image->height));      }/    Object->bounding_box->bounds[1].y = 65536.0;C=    Object->bounding_box->bounds[1].z = Image -> height - 2.0; :    Compute_Scaling_Transform(Object->Trans,&Local_Vector);  (    Parse_Object_Mods ((OBJECT *)Object);  "    Find_Hf_Min_Max(Object, Image);      return ((OBJECT *) Object);   }T   static OBJECT *Parse_Triangle ()M   {O    TRIANGLE *Object;      Parse_Begin ();  9    if ( (Object = (TRIANGLE *)Parse_Object_Id()) != NULL) !       return ((OBJECT *) Object);            Object = Create_Triangle();  0    Parse_Vector (&Object->P1);    Parse_Comma();0    Parse_Vector (&Object->P2);    Parse_Comma();    Parse_Vector (&Object->P3);(    if (!Compute_Triangle (Object,FALSE))J      fprintf (stdout, "Degenerate triangle on line %d.  Please remove.\n",%               Token.Token_Line_No+1);   (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }_   static  OBJECT *Parse_Smooth_Triangle ()   {     SMOOTH_TRIANGLE *Object;)K    short degen;                                                   /* LSK */eK    DBL vlen;                                                      /* LSK */c      degen=FALSE;l      Parse_Begin ();  @    if ( (Object = (SMOOTH_TRIANGLE *)Parse_Object_Id()) != NULL)!       return ((OBJECT *) Object);o  %    Object = Create_Smooth_Triangle();   0    Parse_Vector (&Object->P1);    Parse_Comma();0    Parse_Vector (&Object->N1);    Parse_Comma();  J    VLength(vlen,Object->N1);                                     /* LSK */J    if (vlen<1E-09)                                               /* LSK */J      degen=TRUE;                                                 /* LSK */J    else                                                          /* LSK */)      VNormalize (Object->N1, Object->N1);   0    Parse_Vector (&Object->P2);    Parse_Comma();0    Parse_Vector (&Object->N2);    Parse_Comma();  J    VLength(vlen,Object->N2);                                     /* LSK */J    if (vlen<1E-09)                                               /* LSK */J      degen=TRUE;                                                 /* LSK */J    else                                                          /* LSK */)      VNormalize (Object->N2, Object->N2);   0    Parse_Vector (&Object->P3);    Parse_Comma();    Parse_Vector (&Object->N3);  J    VLength(vlen,Object->N3);                                     /* LSK */J    if (vlen<1E-09)                                               /* LSK */J      degen=TRUE;                                                 /* LSK */J    else                                                          /* LSK */)      VNormalize (Object->N3, Object->N3);C  J    if (!degen) {                                                 /* LSK */J      degen=!Compute_Triangle ((TRIANGLE *) Object,TRUE);         /* LSK */    }  J    if (degen)                                                    /* LSK */J      fprintf (stdout, "Degenerate triangle on line %d.  Please remove.\n",%               Token.Token_Line_No+1);   (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);  }   static OBJECT *Parse_Quadric ()   {     QUADRIC *Object;       Parse_Begin ();  8    if ( (Object = (QUADRIC *)Parse_Object_Id()) != NULL)!       return ((OBJECT *) Object);e           Object = Create_Quadric();   >    Parse_Vector(&(Object -> Square_Terms));     Parse_Comma();>    Parse_Vector(&(Object -> Mixed_Terms));      Parse_Comma();>    Parse_Vector(&(Object -> Terms));            Parse_Comma();&    Object -> Constant = Parse_Float();#    Object -> Non_Zero_Square_Term =j)      !( (Object -> Square_Terms.x == 0.0)l)      && (Object -> Square_Terms.y == 0.0)e)      && (Object -> Square_Terms.z == 0.0) (      && (Object -> Mixed_Terms.x == 0.0)(      && (Object -> Mixed_Terms.y == 0.0)*      && (Object -> Mixed_Terms.z == 0.0));  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }e   static OBJECT *Parse_Box ()   {-    BOX *Object;     DBL temp;      Parse_Begin ();  4    if ( (Object = (BOX *)Parse_Object_Id()) != NULL)!       return ((OBJECT *) Object);            Object = Create_Box();   9    Parse_Vector(&(Object->bounds[0]));     Parse_Comma();E&    Parse_Vector(&(Object->bounds[1]));  4     if (Object->bounds[0].x > Object->bounds[1].x) {"        temp = Object->bounds[0].x;1        Object->bounds[0].x = Object->bounds[1].x;("        Object->bounds[1].x = temp;        }4     if (Object->bounds[0].y > Object->bounds[1].y) {"        temp = Object->bounds[0].y;1        Object->bounds[0].y = Object->bounds[1].y;K"        Object->bounds[1].y = temp;        }4     if (Object->bounds[0].z > Object->bounds[1].z) {"        temp = Object->bounds[0].z;1        Object->bounds[0].z = Object->bounds[1].z; "        Object->bounds[1].z = temp;        }  1    Object->Bounds.Lower_Left = Object->bounds[0];OE    VSub(Object->Bounds.Lengths, Object->bounds[1],Object->bounds[0]);K  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }     A   static OBJECT *Parse_Disc ()a   {e    DISC *Object;    DBL tmpf;    VECTOR lengths;      Parse_Begin ();  5    if ( (Object = (DISC *)Parse_Object_Id()) != NULL)n!       return ((OBJECT *) Object);e           Object = Create_Disc();  3    Parse_Vector(&(Object->center)); Parse_Comma ();M3    Parse_Vector(&(Object->normal)); Parse_Comma ();h.    VNormalize(Object->normal, Object->normal);  (    tmpf = Parse_Float(); Parse_Comma ();"    Object->oradius2 = tmpf * tmpf;  	    EXPECTW      CASE_FLOATO        tmpf = Parse_Float();&        Object->iradius2 = tmpf * tmpf;
      END_CASE         OTHERWISE        UNGET        EXITn
      END_CASE 
    END_EXPECT   9    /* Calculate info needed for ray-disc intersections */ .    VDot(tmpf, Object->center, Object->normal);    Object->d = -tmpf;o      /* Calculate the bounds */B!    tmpf = sqrt(Object->oradius2);o+    Make_Vector(&lengths, tmpf, tmpf, tmpf);h<    VSub(Object->Bounds.Lower_Left, Object->center, lengths);0    VScale(Object->Bounds.Lengths, lengths, 2.0);  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }O   static OBJECT *Parse_Cylinder ()    {a    CONE *Object;      Parse_Begin ();  5    if ( (Object = (CONE *)Parse_Object_Id()) != NULL)s!       return ((OBJECT *) Object);a           Object = Create_Cylinder();  2    Parse_Vector(&(Object->apex));  Parse_Comma ();2    Parse_Vector(&(Object->base));  Parse_Comma ();'    Object->apex_radius = Parse_Float();,-    Object->base_radius = Object->apex_radius;   	    EXPECT>      CASE(OPEN_TOKEN)u        Object->closed = 0;        EXITt
      END_CASE.      e      OTHERWISE        UNGET        EXITR
      END_CASE 
    END_EXPECT;  +    Compute_Cylinder_Data((OBJECT *)Object);   (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }P   static OBJECT *Parse_Cone ()(   {     CONE *Object;      Parse_Begin ();  5    if ( (Object = (CONE *)Parse_Object_Id()) != NULL) !       return ((OBJECT *) Object);            Object = Create_Cone();  2    Parse_Vector(&(Object->apex));  Parse_Comma ();8    Object->apex_radius = Parse_Float();  Parse_Comma ();  2    Parse_Vector(&(Object->base));  Parse_Comma ();'    Object->base_radius = Parse_Float();      	    EXPECTE      CASE(OPEN_TOKEN)(        Object->closed = 0;        EXITC
      END_CASEr      I      OTHERWISE        UNGET        EXIT 
      END_CASEI
    END_EXPECTs  -    /* Compute run-time values for the cone */)'    Compute_Cone_Data((OBJECT *)Object);i  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }S   static OBJECT *Parse_Blob ()u   {]    BLOB *Object;    DBL threshold;b    int npoints; 0    blobstackptr blob_components, blob_component;      Parse_Begin ();  5    if ( (Object = (BLOB *)Parse_Object_Id()) != NULL)1!       return ((OBJECT *) Object);            Object = Create_Blob();      blob_components = NULL;    npoints = 0;     threshold = 1.0;   	    EXPECT>      CASE (THRESHOLD_TOKEN)m!        threshold = Parse_Float();c
      END_CASEo        CASE (COMPONENT_TOKEN)0O        blob_component = (blobstackptr) malloc(sizeof(struct blob_list_struct)); "        if (blob_component == NULL)$           MAError("blob component");E        blob_component->elem.coeffs[2] = Parse_Float(); Parse_Comma();sE        blob_component->elem.radius2   = Parse_Float(); Parse_Comma(); /        Parse_Vector(&blob_component->elem.pos);s.        blob_component->next = blob_components;(        blob_components = blob_component;        npoints++;t
      END_CASE         OTHERWISE        UNGET        EXIT 
      END_CASEa
    END_EXPECT   )    /* Finally, process the information */m<    MakeBlob(Object, threshold, blob_components, npoints, 0);  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }t   static OBJECT *Parse_Torus ()   {     POLY *Object;!    DBL iradius, oradius, *Coeffs;+      Parse_Begin ();  5    if ( (Object = (POLY *)Parse_Object_Id()) != NULL)t!       return ((OBJECT *) Object);m           Object = Create_Poly(4);A      /* Read in the two radii */,    iradius = Parse_Float(); /* Big radius */    Parse_Comma();L/    oradius = Parse_Float(); /* Little radius */   A    /* Build the coefficients of a torus lying in the x-z plane */i    Coeffs = Object->Coeffs;E    Coeffs[ 0] =  1.0;=    Coeffs[ 4] =  2.0;O    Coeffs[ 7] =  2.0; ?    Coeffs[ 9] = -2.0 * (iradius * iradius + oradius * oradius);>    Coeffs[20] =  1.0;     Coeffs[23] =  2.0;t?    Coeffs[25] =  2.0 * (iradius * iradius - oradius * oradius);     Coeffs[30] =  1.0; ?    Coeffs[32] = -2.0 * (iradius * iradius + oradius * oradius); 9    Coeffs[34] = (iradius * iradius - oradius * oradius) * 1 	        (iradius * iradius - oradius * oradius);   @    Make_Vector(&Object->Bounds.Lower_Left, -(iradius + oradius),' 	       -iradius, -(iradius + oradius)) B    Make_Vector(&Object->Bounds.Lengths, 2.0 * (iradius + oradius),2 	       2.0 * iradius, 2.0 * (iradius + oradius));  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }    static OBJECT *Parse_Poly (order)   int order;   {g    POLY *Object;      Parse_Begin ();  5    if ( (Object = (POLY *)Parse_Object_Id()) != NULL) !       return ((OBJECT *) Object);/           if (order == 0)      {5       order = (int)Parse_Float();      Parse_Comma();a)       if (order < 2 || order > MAX_ORDER);/         Error("Order of poly is out of range");       }      Object = Create_Poly(order);E  5    Parse_Coeffs(Object->Order, &(Object->Coeffs[0]));   (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }e   static OBJECT *Parse_Bicubic_Patch ()   {     BICUBIC_PATCH *Object;     int i, j;      Parse_Begin ();  >    if ( (Object = (BICUBIC_PATCH *)Parse_Object_Id()) != NULL)!       return ((OBJECT *) Object);_       #    Object = Create_Bicubic_Patch();/  	    EXPECT}      CASE_FLOAT ?        Warn("Should use keywords for bicubic parameters.",1.5); /        Object->Patch_Type = (int)Parse_Float();.%        if (Object->Patch_Type == 2 ||e#            Object->Patch_Type == 3)c2            Object->Flatness_Value = Parse_Float();
          else (            Object->Flatness_Value = 0.1;,        Object->U_Steps = (int)Parse_Float();,        Object->V_Steps = (int)Parse_Float();        EXIT       END_CASE                      CASE (TYPE_TOKEN)/        Object->Patch_Type = (int)Parse_Float();a
      END_CASE         CASE (FLATNESS_TOKEN).        Object->Flatness_Value = Parse_Float();
      END_CASEo        CASE (V_STEPS_TOKEN) ,        Object->V_Steps = (int)Parse_Float();
      END_CASE         CASE (U_STEPS_TOKEN)r,        Object->U_Steps = (int)Parse_Float();
      END_CASEj        OTHERWISE        UNGET        EXITc
      END_CASEm
    END_EXPECT       if (Object->Patch_Type > 1)      {       Object->Patch_Type = 1;=@       Warn("Patch type no longer supported. Using type 1.",0.0);      }  I    if ((Object->Patch_Type < 0) || (Object->Patch_Type > MAX_PATCH_TYPE))T+      Error("Undefined bicubic patch type");L      Parse_Comma();g    for (i=0;i<4;i++)      for (j=0;j<4;j++)        {8         Parse_Vector(&(Object -> Control_Points[i][j]));         if (!((i==3)&&(j==3)))           Parse_Comma();	        };rB    Precompute_Patch_Values(Object); /* interpolated mesh coords */  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }    static OBJECT *Parse_CSG (CSG_Type)   int CSG_Type;c   {u    CSG *Object;     OBJECT *Local;b    int Object_Count = 0;      Parse_Begin ();  4    if ( (Object = (CSG *)Parse_Object_Id()) != NULL)!       return ((OBJECT *) Object);O       !    if (CSG_Type & CSG_UNION_TYPE)f"      Object = Create_CSG_Union ();    else{#      if (CSG_Type & CSG_MERGE_TYPE) $        Object = Create_CSG_Merge ();	      else +        Object = Create_CSG_Intersection ();}      Object->Children = NULL;t  ,    while ((Local = Parse_Object ()) != NULL)      {M       if ((CSG_Type & CSG_INTERSECTION_TYPE) && (Local->Type & PATCH_OBJECT))t?         Warn ("Patch objects not allowed in intersection",0.0);T       Object_Count++; A       if ((CSG_Type & CSG_DIFFERENCE_TYPE) && (Object_Count > 1))n         Invert_Object (Local);6       Object->Type |=  (Local->Type & CHILDREN_FLAGS);%       Local->Type |= IS_CHILD_OBJECT;D6       Link(Local, &Local->Sibling, &Object->Children);      };   7    if ((Object_Count < 2) && (Language_Version >= 1.5))m8      Warn ("Should have at least 2 objects in csg",1.5);(    Compute_CSG_Bounds((OBJECT *)Object);  (    Parse_Object_Mods ((OBJECT *)Object);      return ((OBJECT *) Object);   }    static OBJECT *Parse_Light_Source ()    {C    VECTOR Local_Vector;     LIGHT_SOURCE *Object;      Parse_Begin ();  =    if ( (Object = (LIGHT_SOURCE *)Parse_Object_Id()) != NULL)s!       return ((OBJECT *) Object);        #    Object = Create_Light_Source ();   !    Parse_Vector(&Object->Center);       GET (COLOUR_TOKEN)o  "    Parse_Colour (&Object->Colour);  	    EXPECTV      CASE (LOOKS_LIKE_TOKEN)$        if (Object->Children != NULL)?          Error("Only one looks_like allowed per light_source");O        Parse_Begin ();*        Object->Type &= ~(int)PATCH_OBJECT;8        if ((Object->Children = Parse_Object ()) == NULL)$          Parse_Error_Str ("object");<        Translate_Object (Object->Children, &Object->Center);,        Parse_Object_Mods (Object->Children);/        Object->Children->No_Shadow_Flag = TRUE;m%        Object->No_Shadow_Flag = TRUE;)A        Object->Type |= (Object->Children->Type & CHILDREN_FLAGS);j
      END_CASEs        CASE (SPOTLIGHT_TOKEN)E(        Object->Light_Type = SPOT_SOURCE;
      END_CASE;        CASE (POINT_AT_TOKEN)-        if (Object->Light_Type == SPOT_SOURCE)E*          Parse_Vector(&Object->Points_At);        elseeC          Error("Spotlight param illegal in standard light source");;
      END_CASE(        CASE (TIGHTNESS_TOKEN)t-        if (Object->Light_Type == SPOT_SOURCE)c'          Object->Coeff = Parse_Float();c        elseaC          Error("Spotlight param illegal in standard light source"); 
      END_CASEr        CASE (RADIUS_TOKEN)-        if (Object->Light_Type == SPOT_SOURCE)c<          Object->Radius = cos(Parse_Float() * M_PI / 180.0);        elsetC          Error("Spotlight param illegal in standard light source"); 
      END_CASEE        CASE (FALLOFF_TOKEN) -        if (Object->Light_Type == SPOT_SOURCE)C=          Object->Falloff = cos(Parse_Float() * M_PI / 180.0);E        elseEC          Error("Spotlight param illegal in standard light source");u
      END_CASEB        CASE (AREA_LIGHT_TOKEN)#        Object -> Area_Light = TRUE;t9        Parse_Vector (&(Object -> Axis1)); Parse_Comma ();b9        Parse_Vector (&(Object -> Axis2)); Parse_Comma ();oA        Object -> Area_Size1 = (int)Parse_Float(); Parse_Comma ();e1        Object -> Area_Size2 = (int)Parse_Float();tF        Object -> Light_Grid = Create_Light_Grid (Object -> Area_Size1,"             Object -> Area_Size2);
      END_CASEn        CASE (JITTER_TOKEN)        Object -> Jitter = TRUE;T
      END_CASEm        CASE (TRACK_TOKEN)F        Object -> Track = TRUE;
      END_CASET        CASE (ADAPTIVE_TOKEN)5        Object -> Adaptive_Level = (int)Parse_Float();t
      END_CASE         CASE (TRANSLATE_TOKEN) $        Parse_Vector (&Local_Vector);:        Translate_Object ((OBJECT *)Object, &Local_Vector);
      END_CASEo        CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);7        Rotate_Object ((OBJECT *)Object, &Local_Vector);_
      END_CASE         CASE (SCALE_TOKEN)b*        Parse_Scale_Vector (&Local_Vector);6        Scale_Object ((OBJECT *)Object, &Local_Vector);
      END_CASE         CASE (TRANSFORM_TOKEN)         GET(TRANSFORM_ID_TOKEN)M        Transform_Object ((OBJECT *)Object, (TRANSFORM *)Token.Constant_Data); 
      END_CASEo        OTHERWISE        UNGET        EXIT*
      END_CASEt
    END_EXPECTE      Parse_End ();      return ((OBJECT *)Object);a   }      static OBJECT *Parse_Object ()(   {     OBJECT *Object = NULL;a  	    EXPECT(      CASE (SPHERE_TOKEN)         Object = Parse_Sphere ();        EXITa
      END_CASE         CASE (PLANE_TOKEN)         Object = Parse_Plane ();*        EXIT/
      END_CASEa        CASE (CONE_TOKEN)        Object = Parse_Cone ();        EXITh
      END_CASEo        CASE (CYLINDER_TOKEN)"        Object = Parse_Cylinder ();        EXIT0
      END_CASEC        CASE (DISC_TOKEN)        Object = Parse_Disc ();        EXITd
      END_CASE         CASE (QUADRIC_TOKEN)f!        Object = Parse_Quadric ();0        EXIT[
      END_CASEr        CASE (CUBIC_TOKEN)         Object = Parse_Poly (3);         EXIT2
      END_CASEd        CASE (QUARTIC_TOKEN)d        Object = Parse_Poly (4);*        EXITa
      END_CASE         CASE (POLY_TOKEN)        Object = Parse_Poly (0);         EXIT&
      END_CASEL        CASE (TORUS_TOKEN)i        Object = Parse_Torus ();         EXIT 
      END_CASE&        CASE (OBJECT_ID_TOKEN)i<        Object = Copy_Object((OBJECT *) Token.Constant_Data);        EXIT 
      END_CASEo        CASE (UNION_TOKEN) +        Object = Parse_CSG (CSG_UNION_TYPE);         EXIT_
      END_CASE         CASE (COMPOSITE_TOKEN)c2        Warn("Use union instead of composite",1.5);+        Object = Parse_CSG (CSG_UNION_TYPE);(        EXITj
      END_CASE         CASE (MERGE_TOKEN) +        Object = Parse_CSG (CSG_MERGE_TYPE);C        EXIT 
      END_CASE         CASE (INTERSECTION_TOKEN)2        Object = Parse_CSG (CSG_INTERSECTION_TYPE);        EXITa
      END_CASEE        CASE (DIFFERENCE_TOKEN)F        Object = Parse_CSG (CSG_DIFFERENCE_TYPE+CSG_INTERSECTION_TYPE);        EXIT(
      END_CASEt        CASE (BICUBIC_PATCH_TOKEN)i'        Object = Parse_Bicubic_Patch ();b        EXITt
      END_CASEr        CASE (TRIANGLE_TOKEN)"        Object = Parse_Triangle ();        EXIT 
      END_CASEO  !      CASE (SMOOTH_TRIANGLE_TOKEN) )        Object = Parse_Smooth_Triangle ();         EXIT 
      END_CASES        CASE (HEIGHT_FIELD_TOKEN)&        Object = Parse_Height_Field ();        EXITr
      END_CASE         CASE (BOX_TOKEN)p        Object = Parse_Box ();P        EXIT3
      END_CASEO        CASE (BLOB_TOKEN)        Object = Parse_Blob ();        EXITc
      END_CASEu        CASE (LIGHT_SOURCE_TOKEN)&        Object = Parse_Light_Source ();        EXITa
      END_CASE         CASE (OBJECT_TOKEN)        Parse_Begin ();         Object = Parse_Object ();        if (!Object)F$          Parse_Error_Str ("object");,        Parse_Object_Mods ((OBJECT *)Object);        EXITa
      END_CASEC        OTHERWISE        UNGET        EXITj
      END_CASE(
    END_EXPECT(      return ((OBJECT *) Object);   }S   static void Parse_Fog ()   {=    Parse_Begin ();  	    EXPECTS      CASE (COLOUR_TOKEN)(        Parse_Colour (&Frame.Fog_Colour);
      END_CASE         CASE (DISTANCE_TOKEN)+        Frame.Fog_Distance = Parse_Float (); 
      END_CASEy        CASE_FLOATt0        Warn("Should use distance keyword.",1.5);+        Frame.Fog_Distance = Parse_Float ();X
      END_CASE         OTHERWISE        UNGET        EXIT 
      END_CASEa
    END_EXPECT=    Parse_End ();   }=   static void Parse_Frame ()   {_    OBJECT *Object;    TEXTURE *Local_Texture;    PIGMENT *Local_Pigment;    TNORMAL *Local_Tnormal;    FINISH  *Local_Finish;c  	    EXPECTc      CASE (FOG_TOKEN)h        Parse_Fog();e
      END_CASEO        CASE (BACKGROUND_TOKEN)        Parse_Begin();         GET (COLOUR_TOKEN)S/        Parse_Colour (&Frame.Background_Colour);e        Parse_End();l
      END_CASEc        CASE (CAMERA_TOKEN)$        Parse_Camera (&Frame.Camera);
      END_CASE         CASE (DECLARE_TOKEN)C        Parse_Declare ();
      END_CASE   !      CASE (MAX_TRACE_LEVEL_TOKEN)e(        Max_Trace_Level = Parse_Float ();
      END_CASEY        CASE (VERSION_TOKEN)C)        Language_Version = Parse_Float ();r
      END_CASEe        CASE (MAX_INTERSECTIONS) /        Max_Intersections = (int)Parse_Float ();=
      END_CASE         CASE (DEFAULT_TOKEN)E        Not_In_Default = FALSE;        Parse_Begin(); 
        EXPECTo          CASE (TEXTURE_TOKEN)i+            Local_Texture = Default_Texture;(-            Default_Texture = Parse_Texture();n4            if (Default_Texture->Type != PNF_TEXTURE)F              Error("Default texture cannot be material map or tiles");3            if (Default_Texture->Next_Layer != NULL)t8              Error("Default texture cannot be layered");+            Destroy_Textures(Local_Texture);h          END_CASEc            CASE (PIGMENT_TOKEN)BD            Local_Pigment = Copy_Pigment((Default_Texture->Pigment));*            Parse_Pigment (&Local_Pigment);5            Destroy_Pigment(Default_Texture->Pigment);o4            Default_Texture->Pigment = Local_Pigment;          END_CASEO            CASE (TNORMAL_TOKEN)eD            Local_Tnormal = Copy_Tnormal((Default_Texture->Tnormal));*            Parse_Tnormal (&Local_Tnormal);5            Destroy_Tnormal(Default_Texture->Tnormal); 4            Default_Texture->Tnormal = Local_Tnormal;          END_CASEE            CASE (FINISH_TOKEN)A            Local_Finish = Copy_Finish((Default_Texture->Finish));r(            Parse_Finish (&Local_Finish);3            Destroy_Finish(Default_Texture->Finish);>2            Default_Texture->Finish = Local_Finish;          END_CASE"            CASE (CAMERA_TOKEN)*            Parse_Camera (&Default_Camera);          END_CASEe            OTHERWISE            UNGET            EXIT           END_CASEc        END_EXPECT         Parse_End();-        Not_In_Default = TRUE;e
      END_CASEG        CASE (END_OF_FILE_TOKEN)         EXITK
      END_CASEj        OTHERWISE        UNGET        Object = Parse_Object();T        if (Object == NULL)1          Parse_Error_Str ("object or directive");o#        Post_Process (Object, NULL);         Link_To_Frame (Object);
      END_CASEd
    END_EXPECTe   }   % static void Parse_Camera (Camera_Ptr)K   CAMERA **Camera_Ptr;   {t$    VECTOR Local_Vector, Temp_Vector;=    DBL Direction_Length, Up_Length, Right_Length, Handedness;i    CAMERA *New;       Parse_Begin ();  	    EXPECTE      CASE (CAMERA_ID_TOKEN)_#        Destroy_Camera(*Camera_Ptr); B        *Camera_Ptr = Copy_Camera ((CAMERA *) Token.Constant_Data);        EXIT 
      END_CASE         OTHERWISE        UNGET        EXITr
      END_CASE)
    END_EXPECTS      New = *Camera_Ptr;T  	    EXPECT       CASE (LOCATION_TOKEN)&        Parse_Vector(&(New->Location));
      END_CASEt        CASE (DIRECTION_TOKEN)s'        Parse_Vector(&(New->Direction));a
      END_CASEi        CASE (UP_TOKEN)         Parse_Vector(&(New->Up));
      END_CASEj        CASE (RIGHT_TOKEN) #        Parse_Vector(&(New->Right));1
      END_CASE         CASE (SKY_TOKEN) !        Parse_Vector(&(New->Sky));)
      END_CASEc        CASE (LOOK_AT_TOKEN)F2        VLength (Direction_Length, New->Direction);+        VLength (Up_Length,        New->Up);g.        VLength (Right_Length,     New->Right);;        VCross  (Temp_Vector,      New->Direction, New->Up); =        VDot    (Handedness,       Temp_Vector,   New->Right);D  &        Parse_Vector (&New->Direction);  B        VSub       (New->Direction, New->Direction, New->Location);3        VNormalize (New->Direction, New->Direction);)=        VCross     (New->Right,     New->Direction, New->Sky);e/        VNormalize (New->Right,     New->Right); C        VCross     (New->Up,        New->Right,     New->Direction);TE        VScale     (New->Direction, New->Direction, Direction_Length);O          if (Handedness >= 0.0) 6          VScale (New->Right, New->Right, Right_Length)        else 8          VScale (New->Right, New->Right, -Right_Length);  ,        VScale (New->Up, New->Up, Up_Length);
      END_CASE         CASE (TRANSLATE_TOKEN) $        Parse_Vector (&Local_Vector);-        Translate_Camera (New, &Local_Vector);E
      END_CASE         CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);*        Rotate_Camera (New, &Local_Vector);
      END_CASE         CASE (SCALE_TOKEN)a*        Parse_Scale_Vector (&Local_Vector);)        Scale_Camera (New, &Local_Vector);)
      END_CASE         CASE (TRANSFORM_TOKEN)a        GET(TRANSFORM_ID_TOKEN)@        Transform_Camera (New, (TRANSFORM *)Token.Constant_Data);
      END_CASE         OTHERWISE        UNGET        EXITo
      END_CASEE
    END_EXPECTC    Parse_End ();   }N   static TRANSFORM *Parse_Transform ()r   {     TRANSFORM *New, Local_Trans;     VECTOR Local_Vector;       Parse_Begin ();    New = Create_Transform ();S  	    EXPECTS      CASE(TRANSFORM_ID_TOKEN)cB        Compose_Transforms (New, (TRANSFORM *)Token.Constant_Data);        EXIT 
      END_CASE         CASE (TRANSLATE_TOKEN) $        Parse_Vector (&Local_Vector);B        Compute_Translation_Transform(&Local_Trans, &Local_Vector);.        Compose_Transforms (New, &Local_Trans);
      END_CASE         CASE (ROTATE_TOKEN)$        Parse_Vector (&Local_Vector);?        Compute_Rotation_Transform(&Local_Trans, &Local_Vector);S.        Compose_Transforms (New, &Local_Trans);
      END_CASEk        CASE (SCALE_TOKEN)E*        Parse_Scale_Vector (&Local_Vector);>        Compute_Scaling_Transform(&Local_Trans, &Local_Vector);.        Compose_Transforms (New, &Local_Trans);
      END_CASEU        OTHERWISE        UNGET        EXITO
      END_CASES
    END_EXPECTP      Parse_End ();    return (New);   }C   static void Parse_Declare ()   {a   VECTOR Local_Vector;   COLOUR *Local_Colour;D   PIGMENT *Local_Pigment;E   TNORMAL *Local_Tnormal;    FINISH *Local_Finish;T   TEXTURE *Local_Texture;    COLOUR_MAP *Local_Colour_Map;E   TRANSFORM *Local_Trans;    OBJECT *Local_Object;_   CAMERA *Local_Camera;E  '   struct Constant_Struct *Constant_Ptr;S     EXPECT     CASE (IDENTIFIER_TOKEN) 1       if (++Number_Of_Constants >= MAX_CONSTANTS)S2         Error ("Too many constants \"DECLARED\"");
       else9         Constant_Ptr = &(Constants[Number_Of_Constants]);A
       EXIT     END_CASE  N     CASE4 (COLOUR_ID_TOKEN, VECTOR_ID_TOKEN, FLOAT_ID_TOKEN, PIGMENT_ID_TOKEN)P     CASE4 (TNORMAL_ID_TOKEN, FINISH_ID_TOKEN, TEXTURE_ID_TOKEN, OBJECT_ID_TOKEN)D     CASE3 (COLOUR_MAP_ID_TOKEN, TRANSFORM_ID_TOKEN, CAMERA_ID_TOKEN)8       Constant_Ptr = &(Constants[Token.Constant_Index]);
       EXIT     END_CASE  
     OTHERWISEC$       Parse_Error(IDENTIFIER_TOKEN);     END_CASE   END_EXPECT     Previous = Token.Token_Id;     GET (EQUALS_TOKEN);O     EXPECT     CASE (COLOUR_TOKEN) )       if (Test_Redefine(COLOUR_ID_TOKEN)) >         Destroy_Colour((COLOUR *)Constant_Ptr->Constant_Data);%       Local_Colour = Create_Colour();E"       Parse_Colour (Local_Colour);<       Constant_Ptr -> Constant_Data = (char *) Local_Colour;6       Constant_Ptr -> Constant_Type = COLOUR_CONSTANT;
       EXIT     END_CASE       CASE_VECTORE       Have_Vector = FALSE;)       Parse_Vector_Float (&Local_Vector);r       if (Have_Vector)	         {S,          if (Test_Redefine(VECTOR_ID_TOKEN))A            Destroy_Vector((VECTOR *)Constant_Ptr->Constant_Data);l9          Constant_Ptr -> Constant_Type = VECTOR_CONSTANT; B          Constant_Ptr -> Constant_Data = (char *) Create_Vector();C          *((VECTOR *)Constant_Ptr -> Constant_Data) = Local_Vector; 	         } 
       else	         { +          if (Test_Redefine(FLOAT_ID_TOKEN)) =            Destroy_Float((DBL *)Constant_Ptr->Constant_Data);S8          Constant_Ptr -> Constant_Type = FLOAT_CONSTANT;A          Constant_Ptr -> Constant_Data = (char *) Create_Float();)C          *((DBL *) Constant_Ptr -> Constant_Data) = Local_Vector.x;l	         }.
       EXIT     END_CASE       CASE (PIGMENT_TOKEN)*       if (Test_Redefine(PIGMENT_ID_TOKEN))@         Destroy_Pigment((PIGMENT *)Constant_Ptr->Constant_Data);?       Local_Pigment = Copy_Pigment((Default_Texture->Pigment));X%       Parse_Pigment (&Local_Pigment);L7       Constant_Ptr -> Constant_Type = PIGMENT_CONSTANT;I<       Constant_Ptr -> Constant_Data = (char *)Local_Pigment;
       EXIT     END_CASE       CASE (TNORMAL_TOKEN)*       if (Test_Redefine(TNORMAL_ID_TOKEN))@         Destroy_Tnormal((TNORMAL *)Constant_Ptr->Constant_Data);?       Local_Tnormal = Copy_Tnormal((Default_Texture->Tnormal));X%       Parse_Tnormal (&Local_Tnormal);=7       Constant_Ptr -> Constant_Type = TNORMAL_CONSTANT;x=       Constant_Ptr -> Constant_Data = (char *) Local_Tnormal; 
       EXIT     END_CASE       CASE (FINISH_TOKEN)l)       if (Test_Redefine(FINISH_ID_TOKEN))x>         Destroy_Finish((FINISH *)Constant_Ptr->Constant_Data);<       Local_Finish = Copy_Finish((Default_Texture->Finish));#       Parse_Finish (&Local_Finish);C6       Constant_Ptr -> Constant_Type = FINISH_CONSTANT;<       Constant_Ptr -> Constant_Data = (char *) Local_Finish;
       EXIT     END_CASE       CASE (CAMERA_TOKEN)T)       if (Test_Redefine(CAMERA_ID_TOKEN))u>         Destroy_Camera((CAMERA *)Constant_Ptr->Constant_Data);1       Local_Camera = Copy_Camera(Default_Camera);_#       Parse_Camera (&Local_Camera); 6       Constant_Ptr -> Constant_Type = CAMERA_CONSTANT;<       Constant_Ptr -> Constant_Data = (char *) Local_Camera;
       EXIT     END_CASE       CASE (TEXTURE_TOKEN)*       if (Test_Redefine(TEXTURE_ID_TOKEN))A         Destroy_Textures((TEXTURE *)Constant_Ptr->Constant_Data); '       Local_Texture = Parse_Texture (); 7       Constant_Ptr -> Constant_Type = TEXTURE_CONSTANT;f+       Constant_Ptr -> Constant_Data = NULL; N       Link_Textures((TEXTURE **) &Constant_Ptr->Constant_Data, Local_Texture);       EXPECT         CASE (TEXTURE_TOKEN)+           Local_Texture = Parse_Texture (); R           Link_Textures((TEXTURE **) &Constant_Ptr->Constant_Data, Local_Texture);         END_CASE           OTHERWISEO           UNGET            EXIT         END_CASE       END_EXPECT
       EXIT     END_CASE       CASE (COLOUR_MAP_TOKEN)c-       if (Test_Redefine(COLOUR_MAP_ID_TOKEN))rF         Destroy_Colour_Map((COLOUR_MAP *)Constant_Ptr->Constant_Data);-       Local_Colour_Map = Parse_Colour_Map (); :       Constant_Ptr -> Constant_Type = COLOUR_MAP_CONSTANT;@       Constant_Ptr -> Constant_Data = (char *) Local_Colour_Map;
       EXIT     END_CASE       CASE (TRANSFORM_TOKEN),       if (Test_Redefine(TRANSFORM_ID_TOKEN))D         Destroy_Transform((TRANSFORM *)Constant_Ptr->Constant_Data);'       Local_Trans = Parse_Transform ();R9       Constant_Ptr -> Constant_Type = TRANSFORM_CONSTANT; ;       Constant_Ptr -> Constant_Data = (char *) Local_Trans; 
       EXIT     END_CASE  
     OTHERWISE        UNGET )       if (Test_Redefine(OBJECT_ID_TOKEN))(>         Destroy_Object((OBJECT *)Constant_Ptr->Constant_Data);%       Local_Object = Parse_Object ();n6       Constant_Ptr -> Constant_Type = OBJECT_CONSTANT;<       Constant_Ptr -> Constant_Data = (char *) Local_Object;
       EXIT     END_CASE     END_EXPECT   }   5 static void Link (New_Object, Field, Old_Object_List)(1   OBJECT *New_Object, **Field, **Old_Object_List;T   {N   *Field = *Old_Object_List;    *Old_Object_List = New_Object;   }h  6 static void Link_Textures (Old_Textures, New_Textures)   TEXTURE **Old_Textures;    TEXTURE  *New_Textures;    {D    TEXTURE *Layer;      for (Layer = New_Textures ;#         Layer->Next_Layer != NULL ; "         Layer = Layer->Next_Layer)      {}V*         Layer->Next_Layer = *Old_Textures;%         *Old_Textures = New_Textures;>   }t   static! char *Get_Token_String (Token_Id)w   TOKEN Token_Id;i   {o   register int i;   $   for (i = 0 ; i < LAST_TOKEN ; i++)4      if (Reserved_Words[i].Token_Number == Token_Id).         return (Reserved_Words[i].Token_Name);   return ("");   }o   static void Where_Error ()    {HB   fprintf (stderr, "\nError in file %s line %d\n", Token.Filename,H                                                  Token.Token_Line_No+1);   }    static int Test_Redefine(a)U   int a;   {    char *old, *new;  #   if (Previous == IDENTIFIER_TOKEN)e     return (FALSE);r   if (Previous != a)'     {old = Get_Token_String (Previous);S       new = Get_Token_String (a);      Where_Error ();B      fprintf (stderr, "Attempted to redefine %s as %s", old, new);      exit (1);     }E   return (TRUE);   }S   void Parse_Error (Token_Id)    TOKEN Token_Id;N   {L   char *expected;   )   expected = Get_Token_String (Token_Id);    Parse_Error_Str(expected);   }    void Parse_Error_Str (str)   char *str;   {n    Where_Error ();,    fprintf (stderr, "%s expected but", str);    Found_Instead ();    exit (1);   }P   static void Found_Instead ()   {R   char *found;  )   if (Token.Token_Id == IDENTIFIER_TOKEN)      fprintf (stderr,J       " undeclared identifier '%s' found instead.\n", Token.Token_String);   else    {.     found = Get_Token_String (Token.Token_Id);4     fprintf (stderr, " %s found instead.\n", found);    }   }  /*! static void Parse_Warn (Token_Id)P   TOKEN Token_Id;_   {r   char *expected;T  D   fprintf (stderr, "\nWarning in file %s line %d\n", Token.Filename,J                                                    Token.Token_Line_No+1);)   expected = Get_Token_String (Token_Id);m0   fprintf (stderr, "%s expected but", expected);   Found_Instead ();T   }o */& static void Warn_State (Token_Id,Type)   TOKEN Token_Id, Type;    {    char *found;   char *should;r     if (Language_Version < 1.5)o      return;  D   fprintf (stderr, "\nWarning in file %s line %d\n", Token.Filename,J                                                    Token.Token_Line_No+1);&   found = Get_Token_String (Token_Id);#   should = Get_Token_String (Type);_M   fprintf (stderr, "Found %s that should be in %s statement", found, should);L   }P   void Warn (str,Level)l   char *str;   DBL Level;   {h   if (Language_Version < Level)      return;o     D   fprintf (stdout, "\nWarning in file %s line %d\n", Token.Filename,J                                                    Token.Token_Line_No+1);   fputs (str, stdout);   }    void Error (str)   char *str;   {X   Where_Error ();    fputs (str, stderr);   exit (1);E   };   void MAError (str)   char *str;   {n   Where_Error ();n@   fprintf (stderr, "Out of memory.  Cannot allocate %s.\n",str);   exit (1);O   }F  ) /* Write a token out to the token file */T  & void Write_Token (Token_Id, Data_File)   TOKEN Token_Id;_   DATA_FILE *Data_File;_     {T    Token.Token_Id = Token_Id;A0    Token.Token_Line_No = Data_File->Line_Number;(    Token.Filename = Data_File->Filename;    Token.Token_String = String;_    Token.Constant_Data = NULL;B    Token.Constant_Index = (int) Token.Token_Id - (int) LAST_TOKEN;  !    if (Token.Constant_Index >= 0)O6      {if (Token.Constant_Index <= Number_Of_Constants)M         {Token.Constant_Data = Constants[Token.Constant_Index].Constant_Data;o?          switch (Constants[Token.Constant_Index].Constant_Type) 8            {CASEID(COLOUR_CONSTANT,     COLOUR_ID_TOKEN)8             CASEID(VECTOR_CONSTANT,     VECTOR_ID_TOKEN)7             CASEID(FLOAT_CONSTANT,      FLOAT_ID_TOKEN)o9             CASEID(PIGMENT_CONSTANT,    PIGMENT_ID_TOKEN) 9             CASEID(TNORMAL_CONSTANT,    TNORMAL_ID_TOKEN)V8             CASEID(FINISH_CONSTANT,     FINISH_ID_TOKEN)9             CASEID(TEXTURE_CONSTANT,    TEXTURE_ID_TOKEN)n8             CASEID(OBJECT_CONSTANT,     OBJECT_ID_TOKEN)<             CASEID(COLOUR_MAP_CONSTANT, COLOUR_MAP_ID_TOKEN);             CASEID(TRANSFORM_CONSTANT,  TRANSFORM_ID_TOKEN) 8             CASEID(CAMERA_CONSTANT,     CAMERA_ID_TOKEN)            }	         }y-       else Token.Token_Id = IDENTIFIER_TOKEN;       }   }n  ( static void Post_Process (Object,Parent)   OBJECT *Object, *Parent;   {a    OBJECT *Sib;a      if (Object == NULL)      return;      if (Parent != NULL)      {"       if (Object->Texture == NULL)*         Object->Texture = Parent->Texture; /*
       else$         if (Parent->Texture != NULL);           {Local_Texture = Copy_Textures (Parent->Texture);a=            Link_Textures (&(Object->Texture), Local_Texture);a           }&J */ /* Removed for backward compat with 1.0.  May put back in. CEY 12/92 */7       Object->No_Shadow_Flag |= Parent->No_Shadow_Flag;n      }       &    if (     (Object->Texture == NULL) -         && !(Object->Type & TEXTURED_OBJECT)  1         && !(Object->Type & LIGHT_SOURCE_OBJECT))t6      Object->Texture = Copy_Textures(Default_Texture);  &    if (Object->Type & COMPOUND_OBJECT)      {-       if (Object->Type & LIGHT_SOURCE_OBJECT) 	         {OK          ((LIGHT_SOURCE *)Object)->Next_Light_Source = Frame.Light_Sources; 6          Frame.Light_Sources = (LIGHT_SOURCE *)Object;	         }d+       for (Sib = ((CSG *)Object)->Children;i            Sib != NULL;-            Sib = Sib->Sibling)"         Post_Process(Sib, Object);      }    else       {"       if (Object->Texture == NULL)9         Object->Texture = Copy_Textures(Default_Texture);P0       if (Object->Texture->Type == PNF_TEXTURE) -         if (Object->Texture->Tnormal != NULL)T,           Object->Type |= DOUBLE_ILLUMINATE;      }#    Post_Textures (Object->Texture);-0    if ((Object->Type & WATER_LEVEL_OK_OBJECT) &&(        (Object->Type & IS_CHILD_OBJECT))1      Object->Methods = &Csg_Height_Field_Methods;    }E    static void Destroy_Constants ()   {a	    int i;c
    char *Ptr;m  +    for (i=1; i <= Number_Of_Constants; i++)T      {'       Ptr = Constants[i].Constant_Data;K)       switch (Constants[i].Constant_Type)o	         {>          case COLOUR_CONSTANT:)            Destroy_Colour((COLOUR *)Ptr);P            break;           case VECTOR_CONSTANT:)            Destroy_Vector((VECTOR *)Ptr);i            break;E          case FLOAT_CONSTANT:t%            Destroy_Float((DBL *)Ptr);             break;E          case PIGMENT_CONSTANT:s+            Destroy_Pigment((PIGMENT *)Ptr);U            break;r          case TNORMAL_CONSTANT: +            Destroy_Tnormal((TNORMAL *)Ptr);             break;           case FINISH_CONSTANT:)            Destroy_Finish((FINISH *)Ptr);             break;K          case TEXTURE_CONSTANT:O,            Destroy_Textures((TEXTURE *)Ptr);            break;t          case OBJECT_CONSTANT:)            Destroy_Object((OBJECT *)Ptr);             break; "          case COLOUR_MAP_CONSTANT:1            Destroy_Colour_Map((COLOUR_MAP *)Ptr);c            break; !          case TRANSFORM_CONSTANT:R/            Destroy_Transform((TRANSFORM *)Ptr);_            break;           case CAMERA_CONSTANT:)            Destroy_Camera((CAMERA *)Ptr);r            break;r	         }       }   }r  " static void Link_To_Frame (Object)  OBJECT *Object;  {   OBJECT *This_Sib, *Next_Sib;   0   if ((Object->Methods != &CSG_Union_Methods) ||        (Object->Bound != NULL) ||       (Object->Clip != NULL) ||        (!Use_Slabs))T     {t:      Link(Object, &(Object -> Sibling), &(Frame.Objects));      return;     }P   ,   for (This_Sib = ((CSG *)Object)->Children;        This_Sib != NULL;        This_Sib = Next_Sib)         {I         Next_Sib = This_Sib->Sibling; /*L2F changes Sibling so save it */d!         Link_To_Frame (This_Sib);t        }   Object->Texture = NULL;    Object->Sibling = NULL;;#   ((CSG *)Object)->Children = NULL;    Destroy_Object (Object);  }