M /****************************************************************************  *                   povproto.h * K *  This module defines the prototypes for all system-independent functions.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/  2 /* Prototypes for functions defined in povray.c */ void usage PARAMS((void)); void init_vars PARAMS((void)); void close_all PARAMS((void));! void get_defaults PARAMS((void)); , void read_options PARAMS((char *File_Name));0 void parse_option PARAMS((char *Option_String));" void Print_Options PARAMS((void));/ void parse_file_name PARAMS((char *File_Name));   void print_stats PARAMS((void));7 FILE *Locate_File PARAMS((char *filename, char *mode)); " void print_credits PARAMS((void));  2 /* Prototypes for functions defined in render.c */H void Create_Ray PARAMS((RAY *ray, int width, int height, DBL x, DBL y));N void Supersample PARAMS((COLOUR *result, int x, int y, int Width,int Height));' void Read_Rendered_Part PARAMS((void)); " void Start_Tracing PARAMS((void));( void Initialize_Renderer PARAMS((void));. void Trace PARAMS((RAY *Ray, COLOUR *Colour));- void Check_User_Abort PARAMS((int Do_Stats));   1 /* Prototypes for functions defined in bound.c */ 0 void Destroy_Composite PARAMS((OBJECT *Object));0 void BuildBoundingSlabs PARAMS((OBJECT **Root));; void recompute_bbox PARAMS((BBOX *bbox, TRANSFORM *trans)); C void Recompute_Inverse_BBox PARAMS((BBOX *bbox, TRANSFORM *trans)); m int Bounds_Intersect PARAMS((OBJECT *Root, RAY *ray, INTERSECTION *Best_Intersection, OBJECT **Best_Object));   4 /* Prototypes for functions defined in tokenize.c */3 void Initialize_Tokenizer PARAMS((char *filename)); ( void Terminate_Tokenizer PARAMS((void)); void Get_Token PARAMS((void));  void Unget_Token PARAMS((void));/ int Skip_Spaces PARAMS((DATA_FILE *Data_File)); 4 int Parse_C_Comments PARAMS((DATA_FILE *Data_File));! void Begin_String PARAMS((void)); ; void Stuff_Character PARAMS((int c, DATA_FILE *Data_File)); / void End_String PARAMS((DATA_FILE *Data_File)); . int Read_Float PARAMS((DATA_FILE *Data_File));1 void Parse_String PARAMS((DATA_FILE *Data_File)); / int Read_Symbol PARAMS((DATA_FILE *Data_File)); ! int Find_Reserved PARAMS((void));  int Find_Symbol PARAMS((void)); ; void Token_Error PARAMS((DATA_FILE *Data_File, char *str));   1 /* Prototypes for functions defined in parse.c */ * void Parse_Error PARAMS((TOKEN Token_Id));) void Parse_Error_Str PARAMS((char *str));   void Parse_Begin PARAMS((void)); void Parse_End PARAMS((void));+ void Parse_Colour PARAMS((COLOUR *Colour)); , COLOUR_MAP *Parse_Colour_Map PARAMS((void));5 COLOUR_MAP *Parse_Colour_List PARAMS((int MinCount));   void Parse_Comma PARAMS((void)); DBL Parse_Float PARAMS((void)); + void Parse_Vector PARAMS((VECTOR *Vector)); 1 void Parse_Vector_Float PARAMS((VECTOR *Vector)); + void Parse_Vector PARAMS((VECTOR *Vector)); 1 void Parse_Scale_Vector PARAMS((VECTOR *Vector));  void Parse PARAMS((void));@ void Write_Token PARAMS((TOKEN Token_Id, DATA_FILE *Data_File)); void Error PARAMS((char *str)); ! void MAError PARAMS((char *str)); ) void Warn PARAMS((char *str, DBL Level));   3 /* Prototypes for functions defined in objects.c */ T int Intersection PARAMS((INTERSECTION *Ray_Intersection, OBJECT *Object, RAY *Ray));5 int Ray_In_Bounds PARAMS((RAY *Ray, OBJECT *Bounds)); 9 int Point_In_Clip PARAMS((VECTOR *IPoint, OBJECT *Clip)); . OBJECT *Copy_Bound_Clip PARAMS((OBJECT *Old));* OBJECT *Copy_Object PARAMS((OBJECT *Old));? void Translate_Object PARAMS((OBJECT *Object, VECTOR *Vector)); < void Rotate_Object PARAMS((OBJECT *Object, VECTOR *Vector));; void Scale_Object PARAMS((OBJECT *Object, VECTOR *Vector)); A void Transform_Object PARAMS((OBJECT *Object, TRANSFORM *Trans)); ; int Inside_Object PARAMS((VECTOR *IPoint, OBJECT *Vector)); , void Invert_Object PARAMS((OBJECT *Object));- void Destroy_Object PARAMS((OBJECT *Object)); " void create_istack PARAMS((void));# ISTACK *open_istack PARAMS((void)); ) void close_istack PARAMS((ISTACK *istk)); % void incstack PARAMS((ISTACK *istk));   3 /* Prototypes for functions defined in spheres.c */ U int All_Sphere_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack)); X int All_Ellipsoid_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));R int Intersect_Sphere PARAMS((RAY *Ray, SPHERE *Sphere, DBL *Depth1, DBL *Depth2));; int Inside_Sphere PARAMS((VECTOR *IPoint, OBJECT *Object)); > int Inside_Ellipsoid PARAMS((VECTOR *IPoint, OBJECT *Object));L void Sphere_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));O void Ellipsoid_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint)); + void *Copy_Sphere PARAMS((OBJECT *Object)); ? void Translate_Sphere PARAMS((OBJECT *Object, VECTOR *Vector)); < void Rotate_Sphere PARAMS((OBJECT *Object, VECTOR *Vector));; void Scale_Sphere PARAMS((OBJECT *Object, VECTOR *Vector)); A void Transform_Sphere PARAMS((OBJECT *Object, TRANSFORM *Trans)); , void Invert_Sphere PARAMS((OBJECT *Object));- void Destroy_Sphere PARAMS((OBJECT *Object)); % SPHERE *Create_Sphere PARAMS((void));   4 /* Prototypes for functions defined in quadrics.c */V int All_Quadric_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));U int Intersect_Quadric PARAMS((RAY *Ray, QUADRIC *Quadric, DBL *Depth1, DBL *Depth2)); < int Inside_Quadric PARAMS((VECTOR *IPoint, OBJECT *Object));M void Quadric_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint)); , void *Copy_Quadric PARAMS((OBJECT *Object));B void Quadric_To_Matrix PARAMS((QUADRIC *Quadric, MATRIX *Matrix));B void Matrix_To_Quadric PARAMS((MATRIX *Matrix, QUADRIC *Quadric));@ void Translate_Quadric PARAMS((OBJECT *Object, VECTOR *Vector));= void Rotate_Quadric PARAMS((OBJECT *Object, VECTOR *Vector)); < void Scale_Quadric PARAMS((OBJECT *Object, VECTOR *Vector));B void Transform_Quadric PARAMS((OBJECT *Object, TRANSFORM *Trans));- void Invert_Quadric PARAMS((OBJECT *Object)); . void Destroy_Quadric PARAMS((OBJECT *Object));' QUADRIC *Create_Quadric PARAMS((void));   0 /* Prototypes for functions defined in poly.c */S int All_Poly_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack)); 9 int Inside_Poly PARAMS((VECTOR *IPoint, OBJECT *Object)); J void Poly_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));) void *Copy_Poly PARAMS((OBJECT *Object)); = void Translate_Poly PARAMS((OBJECT *Object, VECTOR *Vector)); : void Rotate_Poly PARAMS((OBJECT *Object, VECTOR *Vector));9 void Scale_Poly PARAMS((OBJECT *Object, VECTOR *Vector)); ? void Transform_Poly PARAMS((OBJECT *Object, TRANSFORM *Trans)); * void Invert_Poly PARAMS((OBJECT *Object));+ void Destroy_Poly PARAMS((OBJECT *Object)); & POLY *Create_Poly PARAMS((int Order));  2 /* Prototypes for functions defined in bezier.c */< void Precompute_Patch_Values PARAMS((BICUBIC_PATCH *Shape));\ int All_Bicubic_Patch_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));B int Inside_Bicubic_Patch PARAMS((VECTOR *IPoint, OBJECT *Object));S void Bicubic_Patch_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint)); 2 void *Copy_Bicubic_Patch PARAMS((OBJECT *Object));F void Translate_Bicubic_Patch PARAMS((OBJECT *Object, VECTOR *Vector));C void Rotate_Bicubic_Patch PARAMS((OBJECT *Object, VECTOR *Vector));uB void Scale_Bicubic_Patch PARAMS((OBJECT *Object, VECTOR *Vector));H void Transform_Bicubic_Patch PARAMS((OBJECT *Object, TRANSFORM *Trans));3 void Invert_Bicubic_Patch PARAMS((OBJECT *Object));-3 BICUBIC_PATCH *Create_Bicubic_Patch PARAMS((void));i4 void Destroy_Bicubic_Patch PARAMS((OBJECT *Object));  1 /* Prototypes for functions defined in boxes.c */hR int All_Box_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));J int Intersect_Boxx PARAMS((RAY *Ray, BOX *box, DBL *Depth1, DBL *Depth2));7 int Inside_Box PARAMS((VECTOR *point, OBJECT *Object));bI void Box_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint)); ( void *Copy_Box PARAMS((OBJECT *Object));< void Translate_Box PARAMS((OBJECT *Object, VECTOR *Vector));9 void Rotate_Box PARAMS((OBJECT *Object, VECTOR *Vector));b8 void Scale_Box PARAMS((OBJECT *Object, VECTOR *Vector));> void Transform_Box PARAMS((OBJECT *Object, TRANSFORM *Trans));) void Invert_Box PARAMS((OBJECT *Object));2 BOX *Create_Box PARAMS((void));B* void Destroy_Box PARAMS((OBJECT *Object));  0 /* Prototypes for functions defined in blob.c */; void Set_Blob_Solver PARAMS((OBJECT *obj, int Sturm_Flag));.S int All_Blob_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));M& void BlobDelete PARAMS((OBJECT *obj));8 int Inside_Blob PARAMS((VECTOR *point, OBJECT *Object));J void Blob_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));) void *Copy_Blob PARAMS((OBJECT *Object));l= void Translate_Blob PARAMS((OBJECT *Object, VECTOR *Vector)); : void Rotate_Blob PARAMS((OBJECT *Object, VECTOR *Vector));9 void Scale_Blob PARAMS((OBJECT *Object, VECTOR *Vector));n* void Invert_Blob PARAMS((OBJECT *Object));? void Transform_Blob PARAMS((OBJECT *Object, TRANSFORM *Trans));C! BLOB *Create_Blob PARAMS((void));d+ void Destroy_Blob PARAMS((OBJECT *Object));AH void MakeBlob PARAMS((BLOB *blob, DBL threshold, blobstackptr bloblist, /                       int npoints, int sflag));L  1 /* Prototypes for functions defined in cones.c */SS int All_Cone_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));e8 int Inside_Cone PARAMS((VECTOR *point, OBJECT *Object));J void Cone_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));) void *Copy_Cone PARAMS((OBJECT *Object));B= void Translate_Cone PARAMS((OBJECT *Object, VECTOR *Vector));J: void Rotate_Cone PARAMS((OBJECT *Object, VECTOR *Vector));9 void Scale_Cone PARAMS((OBJECT *Object, VECTOR *Vector));n? void Transform_Cone PARAMS((OBJECT *Object, TRANSFORM *Trans));)* void Invert_Cone PARAMS((OBJECT *Object));! CONE *Create_Cone PARAMS((void));o% CONE *Create_Cylinder PARAMS((void));p0 void Compute_Cone_Data PARAMS((OBJECT *Object));4 void Compute_Cylinder_Data PARAMS((OBJECT *Object));+ void Destroy_Cone PARAMS((OBJECT *Object));t  1 /* Prototypes for functions defined in cones.c */SS int All_Disc_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));;> int Intersect_Disc PARAMS((RAY *Ray, DISC *Disc, DBL *Depth));8 int Inside_Disc PARAMS((VECTOR *point, OBJECT *Object));J void Disc_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));) void *Copy_Disc PARAMS((OBJECT *Object));P= void Translate_Disc PARAMS((OBJECT *Object, VECTOR *Vector));r: void Rotate_Disc PARAMS((OBJECT *Object, VECTOR *Vector));9 void Scale_Disc PARAMS((OBJECT *Object, VECTOR *Vector));d? void Transform_Disc PARAMS((OBJECT *Object, TRANSFORM *Trans));O* void Invert_Disc PARAMS((OBJECT *Object));! DISC *Create_Disc PARAMS((void));S+ void Destroy_Disc PARAMS((OBJECT *Object));v  2 /* Prototypes for functions defined in hfield.c */C void Find_Hf_Min_Max PARAMS((HEIGHT_FIELD *H_Field, IMAGE *Image));TQ int Intersect_Sub_Block PARAMS((HF_BLOCK *Block, RAY *Ray, HEIGHT_FIELD *H_Field,o 	VECTOR *start, VECTOR *end));\ int Intersect_Hf_Node PARAMS((RAY *Ray, HEIGHT_FIELD *H_Field, VECTOR *start, VECTOR *end));S int Intersect_Box PARAMS((HEIGHT_FIELD *H_Field,RAY *Ray,DBL *depth1,DBL *depth2));(; DBL Get_Height PARAMS((int x,int y,HEIGHT_FIELD *H_Field));ea int Intersect_Pixel PARAMS((int x,int z,RAY *Ray,HEIGHT_FIELD *H_Field,DBL height1,DBL height2));aV int All_HeightFld_Intersections PARAMS((OBJECT *Object,RAY *Ray,ISTACK *Depth_Stack));Z int All_Csg_HeightFld_Intersections PARAMS((OBJECT *Object,RAY *Ray,ISTACK *Depth_Stack));L int Intersect_HeightFld PARAMS((RAY *Ray,HEIGHT_FIELD *H_Field,DBL *Depth));= int Inside_HeightFld PARAMS((VECTOR *IPoint,OBJECT *Object));,M void HeightFld_Normal PARAMS((VECTOR *Result,OBJECT *Object,VECTOR *IPoint)); . void *Copy_HeightFld PARAMS((OBJECT *Object));A void Translate_HeightFld PARAMS((OBJECT *Object,VECTOR *Vector));E> void Rotate_HeightFld PARAMS((OBJECT *Object,VECTOR *Vector));= void Scale_HeightFld PARAMS((OBJECT *Object,VECTOR *Vector));kC void Transform_HeightFld PARAMS((OBJECT *Object,TRANSFORM *Trans));t0 void Destroy_HeightFld PARAMS((OBJECT *Object));/ void Invert_HeightFld PARAMS((OBJECT *Object)); 1 HEIGHT_FIELD *Create_Height_Field PARAMS((void));o  4 /* Prototypes for functions defined in triangle.c */> void Find_Triangle_Dominant_Axis PARAMS((TRIANGLE *Triangle));? int Compute_Triangle  PARAMS((TRIANGLE *Triangle, int Smooth));*B void Compute_Smooth_Triangle  PARAMS((SMOOTH_TRIANGLE *Triangle));X int All_Triangle_Intersections  PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));K int Intersect_Triangle  PARAMS((RAY *Ray, TRIANGLE *Triangle, DBL *Depth));V> int Inside_Triangle  PARAMS((VECTOR *IPoint, OBJECT *Object));O void Triangle_Normal  PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint)); . void *Copy_Triangle  PARAMS((OBJECT *Object));B void Translate_Triangle  PARAMS((OBJECT *Object, VECTOR *Vector));? void Rotate_Triangle  PARAMS((OBJECT *Object, VECTOR *Vector));t> void Scale_Triangle  PARAMS((OBJECT *Object, VECTOR *Vector));D void Transform_Triangle  PARAMS((OBJECT *Object, TRANSFORM *Trans));) TRIANGLE *Create_Triangle PARAMS((void));*/ void Invert_Triangle  PARAMS((OBJECT *Object));oV void Smooth_Triangle_Normal  PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));4 void *Copy_Smooth_Triangle PARAMS((OBJECT *Object));I void Translate_Smooth_Triangle  PARAMS((OBJECT *Object, VECTOR *Vector)); F void Rotate_Smooth_Triangle  PARAMS((OBJECT *Object, VECTOR *Vector));E void Scale_Smooth_Triangle  PARAMS((OBJECT *Object, VECTOR *Vector));*K void Transform_Smooth_Triangle  PARAMS((OBJECT *Object, TRANSFORM *Trans));C6 void Invert_Smooth_Triangle  PARAMS((OBJECT *Object));7 SMOOTH_TRIANGLE *Create_Smooth_Triangle PARAMS((void));Q0 void Destroy_Triangle  PARAMS((OBJECT *Object));  0 /* Prototypes for functions defined in vect.c */- int solve_quadratic PARAMS((DBL *x, DBL *y));O) int solve_cubic PARAMS((DBL *x, DBL *y));a+ int solve_quartic PARAMS((DBL *x, DBL *y));); int polysolve PARAMS((int order, DBL *Coeffs, DBL *roots));r  4 /* Prototypes for functions defined in lighting.c */L void Add_Pigment PARAMS((COLOUR *Colour, PIGMENT *Pigment, VECTOR *IPoint));U void Perturb_Normal PARAMS((VECTOR *Layer_Normal, TNORMAL *Tnormal, VECTOR *IPoint)); U void Diffuse PARAMS((FINISH *Finish, VECTOR *IPoint, RAY *Eye, VECTOR *Layer_Normal,  H  COLOUR *Layer_Colour, COLOUR *Colour,DBL Attenuation, OBJECT *Object));f void Reflect PARAMS((DBL Reflection, VECTOR *IPoint, RAY *Ray, VECTOR *Layer_Normal, COLOUR *Colour));h void Refract PARAMS((TEXTURE *Texture, VECTOR *IPoint, RAY *Ray, VECTOR *Layer_Normal, COLOUR *Colour));V void Fog PARAMS((DBL Distance, COLOUR *Fog_Colour, DBL Fog_Distance, COLOUR *Colour));A void Compute_Reflected_Colour PARAMS ((RAY *Ray, FINISH *Finish,\et  INTERSECTION *Ray_Intersection, COLOUR *Layer_Colour, COLOUR *Filter_Colour,COLOUR *Colour, VECTOR *Layer_Normal));c void Determine_Apparent_Colour PARAMS ((INTERSECTION *Ray_Intersection, COLOUR *Colour, RAY *Ray));KQ void Filter_Shadow_Ray PARAMS ((INTERSECTION *Ray_Intersection, COLOUR *Colour));;  1 /* Prototypes for functions defined in point.c */B[ int All_Light_Source_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));a@ int Inside_Light_Source PARAMS((VECTOR *point, OBJECT *Object));R void Light_Source_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));1 void *Copy_Light_Source PARAMS((OBJECT *Object)); E void Translate_Light_Source PARAMS((OBJECT *Object, VECTOR *Vector));;B void Rotate_Light_Source PARAMS((OBJECT *Object, VECTOR *Vector));A void Scale_Light_Source PARAMS((OBJECT *Object, VECTOR *Vector));hG void Transform_Light_Source PARAMS((OBJECT *Object, TRANSFORM *Trans));s2 void Invert_Light_Source PARAMS((OBJECT *Object));3 void Destroy_Light_Source PARAMS((OBJECT *Object));_1 LIGHT_SOURCE *Create_Light_Source PARAMS((void));DP DBL Attenuate_Light PARAMS((LIGHT_SOURCE *Light_Source, RAY *Light_Source_Ray));: COLOUR **Create_Light_Grid PARAMS((int Size1, int Size2));  3 /* Prototypes for functions defined in texture.c */aI void Compute_Colour PARAMS((COLOUR *Colour,PIGMENT *Pigment, DBL value));B% void Initialize_Noise PARAMS((void));S% void InitTextureTable PARAMS((void));  void InitRTable PARAMS((void));R int R PARAMS((VECTOR *v));) int Crc16 PARAMS((char *buf, int count));T( DBL Noise PARAMS((DBL x, DBL y, DBL z));: void DNoise PARAMS((VECTOR *result, DBL x, DBL y, DBL z));Q DBL Turbulence PARAMS((DBL x, DBL y, DBL z, DBL omega, DBL lambda, int octaves)); c void DTurbulence PARAMS((VECTOR *result, DBL x, DBL y, DBL z, DBL omega, DBL lambda, int octaves));)" DBL cycloidal PARAMS((DBL value));& DBL Triangle_Wave PARAMS((DBL value));D void Translate_Textures PARAMS((TEXTURE *Textures, VECTOR *Vector));A void Rotate_Textures PARAMS((TEXTURE *Textures, VECTOR *Vector));e@ void Scale_Textures PARAMS((TEXTURE *Textures, VECTOR *Vector));F void Transform_Textures PARAMS((TEXTURE *Textures, TRANSFORM *Trans));2 void Destroy_Textures PARAMS((TEXTURE *Textures));/ void Post_Textures PARAMS((TEXTURE *Textures));d% FINISH *Create_Finish PARAMS((void)); * FINISH *Copy_Finish PARAMS((FINISH *Old));+ TEXTURE *Create_PNF_Texture PARAMS((void));T+ TILES *Create_Tiles_Texture PARAMS((void));b1 MATERIAL *Create_Material_Texture PARAMS((void)); 3 TEXTURE *Copy_Textures PARAMS((TEXTURE *Textures));e' TEXTURE *Create_Texture PARAMS((void));n/ TEXTURE *Copy_Materials PARAMS((TEXTURE *Old));R  3 /* Prototypes for functions defined in pigment.c */SK void agate PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));OJ void bozo PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));K void brick PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));_M void checker PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));*N void gradient PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));M void granite PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));AL void marble PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));L void mandel PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));L void radial PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));M void spotted PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));*J void wood PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));a void leopard PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));   /* SWT 7/18/91 */(K void onion PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));BM void hexagon PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));r' PIGMENT *Create_Pigment PARAMS((void));,- PIGMENT *Copy_Pigment PARAMS((PIGMENT *Old));EB void Translate_Pigment PARAMS((PIGMENT *Pigment, VECTOR *Vector));? void Rotate_Pigment PARAMS((PIGMENT *Pigment, VECTOR *Vector));j> void Scale_Pigment PARAMS((PIGMENT *Pigment, VECTOR *Vector));D void Transform_Pigment PARAMS((PIGMENT *Pigment, TRANSFORM *Trans));0 void Destroy_Pigment PARAMS((PIGMENT *Pigment));- void Post_Pigment PARAMS((PIGMENT *Pigment));_  2 /* Prototypes for functions defined in normal.c */M void ripples PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *Vector));RK void waves PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *Vector));AK void bumps PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal));gK void dents PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal));(N void wrinkles PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal));' TNORMAL *Create_Tnormal PARAMS((void));b- TNORMAL *Copy_Tnormal PARAMS((TNORMAL *Old));sB void Translate_Tnormal PARAMS((TNORMAL *Tnormal, VECTOR *Vector));? void Rotate_Tnormal PARAMS((TNORMAL *Tnormal, VECTOR *Vector));L> void Scale_Tnormal PARAMS((TNORMAL *Tnormal, VECTOR *Vector));D void Transform_Tnormal PARAMS((TNORMAL *Tnormal, TRANSFORM *Trans));0 void Destroy_Tnormal PARAMS((TNORMAL *Tnormal));- void Post_Tnormal PARAMS((TNORMAL *Tnormal));e  3 /* Prototypes for functions defined in txttest.c */o_ void painted1 PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour)); /* CdW 7/2/91 */ _ void painted2 PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour)); /* CdW 7/2/91 */ _ void painted3 PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour)); /* CdW 7/2/91 */ \ void bumpy1 PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal)); /* CdW 7/2/91*/\ void bumpy2 PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal)); /* CdW 7/2/91*/\ void bumpy3 PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal)); /* CdW 7/2/91*/  1 /* Prototypes for functions defined in image.c */oO void image_map PARAMS((DBL x, DBL y, DBL z, PIGMENT *Pigment, COLOUR *colour));gB TEXTURE *material_map PARAMS((VECTOR *IPoint, MATERIAL *Texture));@ TEXTURE *tiles_texture PARAMS((VECTOR *IPoint, TILES *Texture));] void bump_map PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal));/* CdW 7/8/91*/MO void gouge_map PARAMS((DBL x, DBL y, DBL z, TNORMAL *Tnormal, VECTOR *normal));cY int map PARAMS((DBL x,DBL y,DBL z, TPATTERN *Turb ,IMAGE *Image,DBL *xcoor, DBL *ycoor));l( IMAGE *Copy_Image PARAMS ((IMAGE *Old));$ IMAGE *Create_Image PARAMS ((void));+ void Destroy_Image PARAMS ((IMAGE *Image));*  / /* Prototypes for functions defined in csg.c */gX int All_CSG_Union_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));X int All_CSG_Merge_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));] int All_CSG_Intersect_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack)); l= int Inside_CSG_Union PARAMS((VECTOR *point, OBJECT *Object));_D int Inside_CSG_Intersection PARAMS((VECTOR *point, OBJECT *Object));( void *Copy_CSG PARAMS((OBJECT *Object));< void Translate_CSG PARAMS((OBJECT *Object, VECTOR *Vector));9 void Rotate_CSG PARAMS((OBJECT *Object, VECTOR *Vector));S8 void Scale_CSG PARAMS((OBJECT *Object, VECTOR *Vector));> void Transform_CSG PARAMS((OBJECT *Object, TRANSFORM *Trans));* void Destroy_CSG PARAMS((OBJECT *Object));/ void Invert_CSG_Union PARAMS((OBJECT *Object));_6 void Invert_CSG_Intersection PARAMS((OBJECT *Object));% CSG *Create_CSG_Union PARAMS((void));r% CSG *Create_CSG_Merge PARAMS((void)); , CSG *Create_CSG_Intersection PARAMS((void));1 void Compute_CSG_Bounds PARAMS((OBJECT *Object));o  2 /* Prototypes for functions defined in colour.c */% COLOUR *Create_Colour PARAMS((void));f* COLOUR *Copy_Colour PARAMS((COLOUR *Old));= COLOUR_MAP_ENTRY *Create_CMap_Entries PARAMS((int Map_Size));UQ COLOUR_MAP_ENTRY *Copy_CMap_Entries PARAMS((COLOUR_MAP_ENTRY *Old,int Map_Size));V- COLOUR_MAP *Create_Colour_Map PARAMS((void));C6 COLOUR_MAP *Copy_Colour_Map PARAMS((COLOUR_MAP *Old));? DBL Colour_Distance PARAMS((COLOUR *colour1, COLOUR *colour2));;K void Add_Colour PARAMS((COLOUR *result, COLOUR *colour1, COLOUR *colour2)); G void Scale_Colour PARAMS((COLOUR *result, COLOUR *colour, DBL factor));s: void Clip_Colour PARAMS((COLOUR *result, COLOUR *colour));3 void Destroy_Colour_Map PARAMS((COLOUR_MAP *CMap));N  2 /* Prototypes for functions defined in camera.c */; void Translate_Camera PARAMS((CAMERA *Cm, VECTOR *Vector));d8 void Rotate_Camera PARAMS((CAMERA *Cm, VECTOR *Vector));7 void Scale_Camera PARAMS((CAMERA *Cm, VECTOR *Vector));e= void Transform_Camera PARAMS((CAMERA *Cm, TRANSFORM *Trans));J* CAMERA *Copy_Camera PARAMS((CAMERA *Old));% CAMERA *Create_Camera PARAMS((void));T  / /* Prototypes for functions defined in ray.c */m void Make_Ray PARAMS((RAY *r)); 2 void Initialize_Ray_Containers PARAMS((RAY *Ray));B void Copy_Ray_Containers PARAMS((RAY *Dest_Ray, RAY *Source_Ray));4 void Ray_Enter PARAMS((RAY *ray, TEXTURE *texture));! void Ray_Exit PARAMS((RAY *ray));V  2 /* Prototypes for functions defined in planes.c */T int All_Plane_Intersections PARAMS((OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack));A int Intersect_Plane PARAMS((RAY *Ray, PLANE *Plane, DBL *Depth));d9 int Inside_Plane PARAMS((VECTOR *point, OBJECT *Object));RK void Plane_Normal PARAMS((VECTOR *Result, OBJECT *Object, VECTOR *IPoint));O* void *Copy_Plane PARAMS((OBJECT *Object));> void Translate_Plane PARAMS((OBJECT *Object, VECTOR *Vector));; void Rotate_Plane PARAMS((OBJECT *Object, VECTOR *Vector));m: void Scale_Plane PARAMS((OBJECT *Object, VECTOR *Vector));@ void Transform_Plane PARAMS((OBJECT *Object, TRANSFORM *Trans));+ void Invert_Plane PARAMS((OBJECT *Object));(, void Destroy_Plane PARAMS((OBJECT *Object));# PLANE *Create_Plane PARAMS((void));B  / /* Prototypes for functions defined in iff.c */  void iff_error PARAMS((void));  int read_byte PARAMS((FILE *f));  int read_word PARAMS((FILE *f));! long read_long PARAMS((FILE *f));d> void Read_Chunk_Header PARAMS((FILE *f, CHUNK_HEADER *dest)); ; void Read_Iff_Image PARAMS((IMAGE *Image, char *filename));a  / /* Prototypes for functions defined in gif.c */d: int out_line PARAMS((unsigned char *pixels, int linelen)); int get_byte PARAMS((void));; void Read_Gif_Image PARAMS((IMAGE *Image, char *filename));e  4 /* Prototypes for functions defined in gifdecod.c */( void cleanup_gif_decoder PARAMS((void));F WORD init_exp PARAMS((int i_size));   /* changed param to int to avoid" 					 problems with 32bit int ANSI 					 compilers. */H" WORD get_next_code PARAMS((void));; WORD decoder PARAMS((int i_linewidth)); /* same as above */_  b /* Prototypes for machine specific functions defined in "computer".c (ibm.c amiga.c unix.c etc.)*/% void display_finished PARAMS((void));t2 void display_init PARAMS((int width, int height));" void display_close PARAMS((void));e void display_plot PARAMS((int x, int y, unsigned char Red, unsigned char Green, unsigned char Blue));a  4 /* Prototypes for functions defined in matrices.c */$ void MZero PARAMS((MATRIX *result));( void MIdentity PARAMS((MATRIX *result));G void MTimes PARAMS((MATRIX *result, MATRIX *matrix1, MATRIX *matrix2));RE void MAdd PARAMS((MATRIX *result, MATRIX *matrix1, MATRIX *matrix2));tE void MSub PARAMS((MATRIX *result, MATRIX *matrix1, MATRIX *matrix2));TB void MScale PARAMS((MATRIX *result, MATRIX *matrix1, DBL amount));: void MTranspose PARAMS((MATRIX *result, MATRIX *matrix1));L void MTransPoint PARAMS((VECTOR *result, VECTOR *vector, TRANSFORM *trans));O void MInvTransPoint PARAMS((VECTOR *result, VECTOR *vector, TRANSFORM *trans));BP void MTransDirection PARAMS((VECTOR *result, VECTOR *vector, TRANSFORM *trans));S void MInvTransDirection PARAMS((VECTOR *result, VECTOR *vector, TRANSFORM *trans)); M void MTransNormal PARAMS((VECTOR *result, VECTOR *vector, TRANSFORM *trans));DP void MInvTransNormal PARAMS((VECTOR *result, VECTOR *vector, TRANSFORM *trans));K void Compute_Scaling_Transform PARAMS((TRANSFORM *result, VECTOR *vector));M= void Compute_Inversion_Transform PARAMS((TRANSFORM *result));IR void Compute_Translation_Transform PARAMS((TRANSFORM *transform, VECTOR *vector));O void Compute_Rotation_Transform PARAMS((TRANSFORM *transform, VECTOR *vector));tj void Compute_Look_At_Transform PARAMS((TRANSFORM *transform, VECTOR *Look_At, VECTOR *Up, VECTOR *Right));Z void Compose_Transforms PARAMS((TRANSFORM *Original_Transform, TRANSFORM *New_Transform));Z void Compute_Axis_Rotation_Transform PARAMS((TRANSFORM *transform, VECTOR *V, DBL angle));i void Compute_Coordinate_Transform PARAMS((TRANSFORM *trans, VECTOR *origin, VECTOR *up, DBL r, DBL len));l+ TRANSFORM *Create_Transform PARAMS((void));x3 TRANSFORM *Copy_Transform PARAMS((TRANSFORM *Old)); % VECTOR *Create_Vector PARAMS((void)); * VECTOR *Copy_Vector PARAMS((VECTOR *Old));! DBL *Create_Float PARAMS((void));N# DBL *Copy_Float PARAMS((DBL *Old));o  0 /* Prototypes for functions defined in dump.c */1 FILE_HANDLE *Get_Dump_File_Handle PARAMS((void));A, char *Default_Dump_File_Name PARAMS((void));; int Open_Dump_File PARAMS((FILE_HANDLE *handle, char *name,rP                            int *width, int *height, int buffer_size, int mode));W void Write_Dump_Line PARAMS((FILE_HANDLE *handle, COLOUR *line_data, int line_number));oV int Read_Dump_Line PARAMS((FILE_HANDLE *handle, COLOUR *line_data, int *line_number));^ int Read_Dump_Int_Line PARAMS((FILE_HANDLE *handle, IMAGE_LINE *line_data, int *line_number));< void Read_Dump_Image PARAMS((IMAGE *Image, char *filename));3 void Close_Dump_File PARAMS((FILE_HANDLE *handle));*  1 /* Prototypes for functions defined in targa.c */T2 FILE_HANDLE *Get_Targa_File_Handle PARAMS((void));- char *Default_Targa_File_Name PARAMS((void));*< int Open_Targa_File PARAMS((FILE_HANDLE *handle, char *name,P                            int *width, int *height, int buffer_size, int mode));X void Write_Targa_Line PARAMS((FILE_HANDLE *handle, COLOUR *line_data, int line_number));W int Read_Targa_Line PARAMS((FILE_HANDLE *handle, COLOUR *line_data, int *line_number));14 void Close_Targa_File PARAMS((FILE_HANDLE *handle));= void Read_Targa_Image PARAMS((IMAGE *Image, char *filename));t  / /* Prototypes for functions defined in Raw.c */(0 FILE_HANDLE *Get_Raw_File_Handle PARAMS((void));+ char *Default_Raw_File_Name PARAMS((void));t: int Open_Raw_File PARAMS((FILE_HANDLE *handle, char *name,P                            int *width, int *height, int buffer_size, int mode));V void Write_Raw_Line PARAMS((FILE_HANDLE *handle, COLOUR *line_data, int line_number));U int Read_Raw_Line PARAMS((FILE_HANDLE *handle, COLOUR *line_data, int *line_number));;2 void Close_Raw_File PARAMS((FILE_HANDLE *handle));   * (Block_Size*(iz+1) - sz);           else  0             tfar = Gdx * (sz - Block_Size*(iz));           }l
         else                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                