M /****************************************************************************  *                spheres.c * / *  This module implements the sphere primitive.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"    #ifndef Sphere_Tolerance #define Sphere_Tolerance 1.0e-8  #endif   METHODS Sphere_Methods =   {    All_Sphere_Intersections,    Inside_Sphere, Sphere_Normal,    Copy_Sphere,"   Translate_Sphere, Rotate_Sphere,0   Scale_Sphere, Transform_Sphere, Invert_Sphere,   Destroy_Sphere };   METHODS Ellipsoid_Methods =    {    All_Ellipsoid_Intersections,%   Inside_Ellipsoid, Ellipsoid_Normal,    Copy_Sphere,"   Translate_Sphere, Rotate_Sphere,0   Scale_Sphere, Transform_Sphere, Invert_Sphere,   Destroy_Sphere };   extern RAY *CM_Ray; 9 extern long Ray_Sphere_Tests, Ray_Sphere_Tests_Succeeded;   7 int All_Sphere_Intersections (Object, Ray, Depth_Stack)  OBJECT *Object; 	 RAY *Ray;  ISTACK *Depth_Stack;   {    DBL Depth1, Depth2;    VECTOR IPoint;"   register int Intersection_Found;     Intersection_Found = FALSE;   A   if (Intersect_Sphere (Ray, (SPHERE*) Object, &Depth1, &Depth2))      { ,     VScale (IPoint, Ray->Direction, Depth1);"     VAddEq (IPoint, Ray->Initial);  .     if (Point_In_Clip (&IPoint, Object->Clip))       { 3       push_entry(Depth1,IPoint,Object,Depth_Stack);         Intersection_Found = TRUE;       }        if (Depth2 != Depth1)        { .       VScale (IPoint, Ray->Direction, Depth2);$       VAddEq (IPoint, Ray->Initial);  0       if (Point_In_Clip (&IPoint, Object->Clip))	         { 5         push_entry(Depth2,IPoint,Object,Depth_Stack); "         Intersection_Found = TRUE;	         }        }      }    return (Intersection_Found);   }   : int All_Ellipsoid_Intersections (Object, Ray, Depth_Stack) OBJECT *Object; 	 RAY *Ray;  ISTACK *Depth_Stack;   {    DBL Depth1, Depth2, len;   VECTOR IPoint, dv;"   register int Intersection_Found;   RAY New_Ray;  1   /* Transform the ray into the sphere's space */ M   MInvTransPoint(&New_Ray.Initial, &Ray->Initial, ((SPHERE *)Object)->Trans); U   MInvTransDirection(&New_Ray.Direction, &Ray->Direction, ((SPHERE *)Object)->Trans);   2   VDot(len, New_Ray.Direction, New_Ray.Direction);   if (len == 0.0) 
     return 0;    len = 1.0 / sqrt(len);#   VScaleEq(New_Ray.Direction, len);      Intersection_Found = FALSE;   F   if (Intersect_Sphere (&New_Ray, (SPHERE*) Object, &Depth1, &Depth2))     { /     VScale (IPoint, New_Ray.Direction, Depth1); %     VAddEq (IPoint, New_Ray.Initial); *     if (((SPHERE *)Object)->Trans != NULL)?       MTransPoint(&IPoint, &IPoint, ((SPHERE *)Object)->Trans);   #     VSub(dv, IPoint, Ray->Initial);      VLength(len, dv);   .     if (Point_In_Clip (&IPoint, Object->Clip))       { 0       push_entry(len,IPoint,Object,Depth_Stack);        Intersection_Found = TRUE;       }        if (Depth2 != Depth1)        { 1       VScale (IPoint, New_Ray.Direction, Depth2); '       VAddEq (IPoint, New_Ray.Initial); ,       if (((SPHERE *)Object)->Trans != NULL)A         MTransPoint(&IPoint, &IPoint, ((SPHERE *)Object)->Trans);   %       VSub(dv, IPoint, Ray->Initial);        VLength(len, dv);   0       if (Point_In_Clip (&IPoint, Object->Clip))	         { 2         push_entry(len,IPoint,Object,Depth_Stack);"         Intersection_Found = TRUE;	         }        }      }    return (Intersection_Found);   }   2 int Intersect_Sphere (Ray, Sphere, Depth1, Depth2)	 RAY *Ray;  SPHERE *Sphere;  DBL *Depth1, *Depth2;    {    VECTOR Origin_To_Center;F   DBL OCSquared, t_Closest_Approach, Half_Chord, t_Half_Chord_Squared;   short inside;      Ray_Sphere_Tests++;    if (Ray == CM_Ray)       {      if (!Sphere->CMCached)         { :       VSub (Sphere->CMOtoC, Sphere->Center, Ray->Initial);A       VDot (Sphere->CMOCSquared, Sphere->CMOtoC, Sphere->CMOtoC); H       Sphere->CMinside = (Sphere->CMOCSquared < Sphere->Radius_Squared);       Sphere->CMCached = TRUE;       } >     VDot (t_Closest_Approach, Sphere->CMOtoC, Ray->Direction);E     if (!Sphere->CMinside && (t_Closest_Approach < Sphere_Tolerance))        return (FALSE);       I     t_Half_Chord_Squared = Sphere->Radius_Squared - Sphere->CMOCSquared + .     (t_Closest_Approach * t_Closest_Approach);     }    else       { :     VSub (Origin_To_Center, Sphere->Center, Ray->Initial);9     VDot (OCSquared, Origin_To_Center, Origin_To_Center); 2     inside = (OCSquared < Sphere->Radius_Squared);@     VDot (t_Closest_Approach, Origin_To_Center, Ray->Direction);;     if (!inside && (t_Closest_Approach < Sphere_Tolerance))        return (FALSE);   ?     t_Half_Chord_Squared = Sphere->Radius_Squared - OCSquared + .     (t_Closest_Approach * t_Closest_Approach);     }   .   if (t_Half_Chord_Squared < Sphere_Tolerance)     return (FALSE);   +   Half_Chord = sqrt (t_Half_Chord_Squared); ,   *Depth1 = t_Closest_Approach + Half_Chord;,   *Depth2 = t_Closest_Approach - Half_Chord;  ?   if ((*Depth1 < Sphere_Tolerance) || (*Depth1 > Max_Distance)) A     if ((*Depth2 < Sphere_Tolerance) || (*Depth2 > Max_Distance))        return (FALSE);      else       *Depth1 = *Depth2;   elseA     if ((*Depth2 < Sphere_Tolerance) || (*Depth2 > Max_Distance))        *Depth2 = *Depth1;     Ray_Sphere_Tests_Succeeded++;    return (TRUE);   }   " int Inside_Sphere (IPoint, Object) VECTOR *IPoint;  OBJECT *Object;    {    VECTOR Origin_To_Center;   DBL OCSquared;  ?   VSub (Origin_To_Center, ((SPHERE *)Object)->Center, *IPoint); 7   VDot (OCSquared, Origin_To_Center, Origin_To_Center);   #   if (((SPHERE *)Object)->Inverted) O     return (OCSquared - ((SPHERE *)Object)->Radius_Squared > Sphere_Tolerance);    elseO     return (OCSquared - ((SPHERE *)Object)->Radius_Squared < Sphere_Tolerance);    }   % int Inside_Ellipsoid (IPoint, Object)  VECTOR *IPoint;  OBJECT *Object;    {    VECTOR Origin_To_Center;   DBL OCSquared;   VECTOR New_Point;   3   /* Transform the point into the sphere's space */ @   MInvTransPoint(&New_Point, IPoint, ((SPHERE *)Object)->Trans);A   VSub (Origin_To_Center, ((SPHERE *)Object)->Center, New_Point); 7   VDot (OCSquared, Origin_To_Center, Origin_To_Center);   #   if (((SPHERE *)Object)->Inverted) O     return (OCSquared - ((SPHERE *)Object)->Radius_Squared > Sphere_Tolerance);    elseO     return (OCSquared - ((SPHERE *)Object)->Radius_Squared < Sphere_Tolerance);    }   + void Sphere_Normal (Result, Object, IPoint)  OBJECT *Object;  VECTOR *Result, *IPoint;   { 6   VSub (*Result, *IPoint, ((SPHERE *)Object)->Center);9   VScaleEq (*Result, ((SPHERE *)Object)->Inverse_Radius);    }   . void Ellipsoid_Normal (Result, Object, IPoint) OBJECT *Object;  VECTOR *Result, *IPoint;   {    VECTOR New_Point;   3   /* Transform the point into the sphere's space */ @   MInvTransPoint(&New_Point, IPoint, ((SPHERE *)Object)->Trans);  8   VSub (*Result, New_Point, ((SPHERE *)Object)->Center);9   VScaleEq (*Result, ((SPHERE *)Object)->Inverse_Radius);   :   MTransNormal(Result, Result, ((SPHERE *)Object)->Trans);   VNormalize(*Result, *Result);    }    void *Copy_Sphere (Object) OBJECT *Object;*   {*   SPHERE *New;     New = Create_Sphere ();*   *New = *((SPHERE *) Object);  9   New->Trans = Copy_Transform(((SPHERE *)Object)->Trans);e   return (New);    }o  & void Translate_Sphere (Object, Vector) OBJECT *Object;s VECTOR *Vector;e   {-   TRANSFORM Trans;  (   if (((SPHERE *)Object)->Trans == NULL)     {-2     VAddEq (((SPHERE *) Object)->Center, *Vector);/     VAddEq(Object->Bounds.Lower_Left, *Vector);t     }a   else     {h2     Compute_Translation_Transform(&Trans, Vector);%     Transform_Sphere(Object, &Trans);i     }s   }r  # void Rotate_Sphere (Object, Vector)s OBJECT *Object;  VECTOR *Vector;    {m   TRANSFORM Trans;%   SPHERE *Sphere = (SPHERE *) Object;   .   Compute_Rotation_Transform (&Trans, Vector);     if (Sphere->Trans == NULL)     {a:     MTransPoint(&Sphere->Center, &Sphere->Center, &Trans);+     Make_Vector(&Sphere->Bounds.Lower_Left,f(       Sphere->Center.x - Sphere->Radius,(       Sphere->Center.y - Sphere->Radius,)       Sphere->Center.z - Sphere->Radius);i(     Make_Vector(&Sphere->Bounds.Lengths,       2.0 * Sphere->Radius,n       2.0 * Sphere->Radius,C       2.0 * Sphere->Radius);     }*   else     {*&     Transform_Sphere (Object, &Trans);     }u   }r  " void Scale_Sphere (Object, Vector) OBJECT *Object;  VECTOR *Vector;l   {e%   SPHERE *Sphere = (SPHERE *) Object;d   TRANSFORM Trans;  ;   if ((Vector->x != Vector->y) || (Vector->x != Vector->z)),     if (Sphere->Trans == NULL)       {l+       Sphere->Methods = &Ellipsoid_Methods;r)       Sphere->Trans = Create_Transform();p       }      if (Sphere->Trans == NULL)     { )     VScaleEq (Sphere->Center, Vector->x);p      Sphere->Radius *= Vector->x;=     Sphere->Radius_Squared = Sphere->Radius * Sphere->Radius;n2     Sphere->Inverse_Radius = 1.0 / Sphere->Radius;+     Make_Vector(&Sphere->Bounds.Lower_Left,e(       Sphere->Center.x - Sphere->Radius,(       Sphere->Center.y - Sphere->Radius,)       Sphere->Center.z - Sphere->Radius); (     Make_Vector(&Sphere->Bounds.Lengths,       2.0 * Sphere->Radius,        2.0 * Sphere->Radius,n       2.0 * Sphere->Radius);     }    else     {c.     Compute_Scaling_Transform(&Trans, Vector);%     Transform_Sphere(Object, &Trans);D     }n   }t   void Invert_Sphere (Object)I OBJECT *Object;f   {n(   ((SPHERE *) Object)->Inverted ^= TRUE;   }    SPHERE *Create_Sphere ()   {c   SPHERE *New;  :   if ((New = (SPHERE *) malloc (sizeof (SPHERE))) == NULL)     MAError ("sphere");   9   INIT_OBJECT_FIELDS(New, SPHERE_OBJECT, &Sphere_Methods)P0     Make_Vector (&(New->Center), 0.0, 0.0, 0.0);   New->Radius = 1.0;   New->Radius_Squared = 1.0;   New->Inverse_Radius = 1.0;   New->CMCached = FALSE;   New->Trans = NULL;   New->Inverted = FALSE;G   /* CMOtoC, CMOtoCSquared and CMinside are only valid when CMCached */    return (New);t   }c  % void Transform_Sphere (Object, Trans)* OBJECT *Object;  TRANSFORM *Trans;t   {e$   SPHERE *Sphere = (SPHERE *)Object;     if (Sphere->Trans == NULL)     { )     Sphere->Methods = &Ellipsoid_Methods;s'     Sphere->Trans = Create_Transform();a     }-  +   Compose_Transforms(Sphere->Trans, Trans);r  )   Make_Vector(&Sphere->Bounds.Lower_Left,i&     Sphere->Center.x - Sphere->Radius,&     Sphere->Center.y - Sphere->Radius,'     Sphere->Center.z - Sphere->Radius); &   Make_Vector(&Sphere->Bounds.Lengths,     2.0 * Sphere->Radius,      2.0 * Sphere->Radius,E     2.0 * Sphere->Radius);  1   recompute_bbox(&Object->Bounds, Sphere->Trans);    }    void Destroy_Sphere (Object) OBJECT *Object;    {d/   Destroy_Transform(((SPHERE *)Object)->Trans);*   free (Object);   }) 4              G          X_DISPLAY_CLOSE 4                {#   `       X_DISPLAY_CLOSE 4                @          X_DISPLAY_CLOSE 4              G          X_DISPLAY_PLOT  4                {#   0       X_DISPLAY_PLOT  4                @          X_DISPLAY_PLOT : 
 :         = * "   !        VAXDEC C T1.3-019A 
  = 
                   4               4  =     display_fi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                