M /****************************************************************************  *                texture.c * K *  This module implements texturing functions such as noise, turbulence and K *  texture transformation functions. The actual texture routines are in the  *  files pigment.c & normal.c.E *  The noise function used here is the one described by Ken Perlin in @ *  "Hypertexture", SIGGRAPH '89 Conference Proceedings page 253. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   /*E    Some texture ideas garnered from SIGGRAPH '85 Volume 19 Number 3,  (    "An Image Synthesizer" By Ken Perlin.I    Further Ideas Garnered from "The RenderMan Companion" (Addison Wesley)  */   #include "frame.h" #include "vector.h"  #include "povproto.h"  #include "texture.h"   DBL *sintab; DBL frequency[NUMBER_OF_WAVES]; % VECTOR Wave_Sources[NUMBER_OF_WAVES];  DBL *RTable; short *hashTable;    unsigned short crctab[256] =   { A   0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241, A   0xc601, 0x06c0, 0x0780, 0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440, A   0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1, 0xce81, 0x0e40, A   0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841, A   0xd801, 0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40, A   0x1e00, 0xdec1, 0xdf81, 0x1f40, 0xdd01, 0x1dc0, 0x1c80, 0xdc41, A   0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680, 0xd641, A   0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040, A   0xf001, 0x30c0, 0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240, A   0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501, 0x35c0, 0x3480, 0xf441, A   0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41, A   0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840, A   0x2800, 0xe8c1, 0xe981, 0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41, A   0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1, 0xec81, 0x2c40, A   0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640, A   0x2200, 0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041, A   0xa001, 0x60c0, 0x6180, 0xa141, 0x6300, 0xa3c1, 0xa281, 0x6240, A   0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480, 0xa441, A   0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41, A   0xaa01, 0x6ac0, 0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840, A   0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01, 0x7bc0, 0x7a80, 0xba41, A   0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40, A   0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640, A   0x7200, 0xb2c1, 0xb381, 0x7340, 0xb101, 0x71c0, 0x7080, 0xb041, A   0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0, 0x5280, 0x9241, A   0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440, A   0x9c01, 0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40, A   0x5a00, 0x9ac1, 0x9b81, 0x5b40, 0x9901, 0x59c0, 0x5880, 0x9841, A   0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81, 0x4a40, A   0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41, A   0x4400, 0x84c1, 0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641, @   0x8201, 0x42c0, 0x4380, 0x8341, 0x4100, 0x81c1, 0x8081, 0x4040   };  , void Compute_Colour (Colour, Pigment, value) COLOUR *Colour;  PIGMENT *Pigment; 
 DBL value;   { /   COLOUR_MAP *Colour_Map = Pigment->Colour_Map; 3   int max_colors = Colour_Map->Number_Of_Entries-1;    COLOUR_MAP_ENTRY *Cur, *Prev;    register DBL fraction;  D   value = fmod(value * Pigment->Frequency + Pigment->Phase,1.00001);9   if (value < 0.0)         /* allow negative Frequency */      value -=floor(value);   '   /* if greater than last, use last. */ @   if (value >= Colour_Map->Colour_Map_Entries[max_colors].value)     { @     *Colour = Colour_Map->Colour_Map_Entries[max_colors].Colour;     return;      }   4   Prev = Cur = &(Colour_Map->Colour_Map_Entries[0]);   while (value >= Cur->value)      Prev = Cur++;   -   /* if stopped on first entry, use first. */    if (Prev == Cur)     {      *Colour = Cur->Colour;     return;      }   @   fraction = (value - Prev->value) / (Cur->value - Prev->value);Y   Colour->Red   = Prev->Colour.Red   + fraction * (Cur->Colour.Red   - Prev->Colour.Red); [   Colour->Green = Prev->Colour.Green + fraction * (Cur->Colour.Green - Prev->Colour.Green); Z   Colour->Blue  = Prev->Colour.Blue  + fraction * (Cur->Colour.Blue  - Prev->Colour.Blue);_   Colour->Filter = Prev->Colour.Filter + fraction * (Cur->Colour.Filter - Prev->Colour.Filter);   	   return;    }    void Initialize_Noise ()   {    register int i = 0;    VECTOR point;      InitRTable();   B   if ((sintab = (DBL *)malloc(SINTABSIZE * sizeof(DBL))) == NULL)      MAError ("sine table");   $   for (i = 0 ; i < SINTABSIZE ; i++)?     sintab[i] = sin(i/(DBL)SINTABSIZE * (3.14159265359 * 2.0));   )   for (i = 0 ; i < NUMBER_OF_WAVES ; i++)      { '     DNoise (&point, (DBL) i, 0.0, 0.0); (     VNormalize (Wave_Sources[i], point);:     frequency[i] = (rand() & RNDMASK) / RNDDIVISOR + 0.01;     }    }    void InitTextureTable()    {    int i, j, temp;      srand(0);   J   if ((hashTable = (short int *) malloc(4096*sizeof(short int))) == NULL)      MAError ("hash table");      for (i = 0; i < 4096; i++)     hashTable[i] = i;    for (i = 4095; i >= 0; i--)      {      j = rand() % 4096;     temp = hashTable[i];      hashTable[i] = hashTable[j];     hashTable[j] = temp;     }    }   K /* modified by AAC to work properly with little bitty integers (16 bits) */    void InitRTable()    {    int i;   VECTOR rp;     InitTextureTable();   ?   if ((RTable = (DBL *)malloc(MAXSIZE * sizeof(DBL))) == NULL)       MAError ("RTable");      for (i = 0; i < MAXSIZE; i++)      {       rp.x = rp.y = rp.z = (DBL)i;8     RTable[i] = (unsigned int) R(&rp) * REALSCALE - 1.0;     }    }    int R(v)
 VECTOR *v;   {    v->x *= .12345;    v->y *= .12345;    v->z *= .12345;   -   return (Crc16((char *) v, sizeof(VECTOR)));    }    /*C  * Note that passing a VECTOR array to Crc16 and interpreting it as F  * an array of chars means that machines with different floating-pointA  * representation schemes will evaluate Noise(point) differently.   */    int Crc16(buf, count)  register char *buf;  register int  count;   { "   register unsigned short crc = 0;     while (count--) @     crc = (crc >> 8) ^ crctab[ (unsigned char) (crc ^ *buf++) ];     return ((int) crc);    }      /*J         Robert's Skinner's Perlin-style "Noise" function - modified by AACK         to ensure uniformly distributed clamped values between 0 and 1.0...  */     DBL Noise(x, y, z) DBL x, y, z;   { 
   DBL *mp;   long ix, iy, iz, jx, jy, jz;1   int ixiy_hash, ixjy_hash, jxiy_hash, jxjy_hash;      DBL sx, sy, sz, tx, ty, tz; 
   DBL sum;  A   DBL x_ix, x_jx, y_iy, y_jy, z_iz, z_jz, txty, sxty, txsy, sxsy;      Calls_To_Noise++;   \   /*setup_lattice(&x, &y, &z, &ix, &iy, &iz, &jx, &jy, &jz, &sx, &sy, &sz, &tx, &ty, &tz);*/   x -= MINX;   y -= MINY;   z -= MINZ;  -   /* its equivalent integer lattice point. */ +   ix = (long)x; iy = (long)y; iz = (long)z; (   jx = ix + 1; jy = iy + 1; jz = iz + 1;  @   sx = SCURVE(x - ix); sy = SCURVE(y - iy); sz = SCURVE(z - iz);  )   /* the complement values of sx,sy,sz */*.   tx = 1.0 - sx; ty = 1.0 - sy; tz = 1.0 - sz;     /*     *  interpolate!t     */   x_ix = x - ix;   x_jx = x - jx;   y_iy = y - iy;   y_jy = y - jy;   z_iz = z - iz;   z_jz = z - jz;   txty = tx * ty;t   sxty = sx * ty;s   txsy = tx * sy;l   sxsy = sx * sy;a    ixiy_hash = Hash2d ( ix, iy );    jxiy_hash = Hash2d ( jx, iy );    ixjy_hash = Hash2d ( ix, jy );    jxjy_hash = Hash2d ( jx, jy );  4   mp = &RTable[(int) Hash1d(ixiy_hash, iz ) & 0xFF];1   sum = INCRSUMP(mp,(txty*tz), x_ix, y_iy, z_iz);-  5   mp = &RTable[(int) Hash1d( jxiy_hash, iz ) & 0xFF];-2   sum += INCRSUMP(mp,(sxty*tz), x_jx, y_iy, z_iz);  5   mp = &RTable[(int) Hash1d( ixjy_hash, iz ) & 0xFF];t2   sum += INCRSUMP(mp,(txsy*tz), x_ix, y_jy, z_iz);  5   mp = &RTable[(int) Hash1d( jxjy_hash, iz ) & 0xFF];r2   sum += INCRSUMP(mp,(sxsy*tz), x_jx, y_jy, z_iz);  5   mp = &RTable[(int) Hash1d( ixiy_hash, jz ) & 0xFF];E2   sum += INCRSUMP(mp,(txty*sz), x_ix, y_iy, z_jz);  5   mp = &RTable[(int) Hash1d( jxiy_hash, jz ) & 0xFF];l2   sum += INCRSUMP(mp,(sxty*sz), x_jx, y_iy, z_jz);  5   mp = &RTable[(int) Hash1d( ixjy_hash, jz ) & 0xFF];F2   sum += INCRSUMP(mp,(txsy*sz), x_ix, y_jy, z_jz);  5   mp = &RTable[(int) Hash1d( jxjy_hash, jz ) & 0xFF];D2   sum += INCRSUMP(mp,(sxsy*sz), x_jx, y_jy, z_jz);  C   sum = sum + 0.5;          /* range at this point -0.5 - 0.5... */a     if (sum < 0.0)     sum = 0.0;   if (sum > 1.0)     sum = 1.0;     return (sum);*   }*     /*'        Vector-valued version of "Noise"  */   void DNoise(result, x, y, z) VECTOR *result;" DBL x, y, z;   {r
   DBL *mp;   long ix, iy, iz, jx, jy, jz;1   int ixiy_hash, ixjy_hash, jxiy_hash, jxjy_hash;/   DBL px, py, pz, s;   DBL sx, sy, sz, tx, ty, tz;e   DBL txty, sxty, txsy, sxsy;r     Calls_To_DNoise++;  \   /*setup_lattice(&x, &y, &z, &ix, &iy, &iz, &jx, &jy, &jz, &sx, &sy, &sz, &tx, &ty, &tz);*/   x -= MINX;   y -= MINY;   z -= MINZ;  -   /* its equivalent integer lattice point. */x+   ix = (long)x; iy = (long)y; iz = (long)z;7(   jx = ix + 1; jy = iy + 1; jz = iz + 1;  @   sx = SCURVE(x - ix); sy = SCURVE(y - iy); sz = SCURVE(z - iz);  )   /* the complement values of sx,sy,sz */ .   tx = 1.0 - sx; ty = 1.0 - sy; tz = 1.0 - sz;     /*     *  interpolate!x     */   txty = tx * ty;x   sxty = sx * ty;0   txsy = tx * sy;x   sxsy = sx * sy;x    ixiy_hash = Hash2d ( ix, iy );    jxiy_hash = Hash2d ( jx, iy );    ixjy_hash = Hash2d ( ix, jy );    jxjy_hash = Hash2d ( jx, jy );  5   mp = &RTable[(int) Hash1d( ixiy_hash, iz ) & 0xFF];2$   px = x-ix;  py = y-iy;  pz = z-iz;   s = txty*tz;&   result->x = INCRSUMP(mp,s,px,py,pz);
   mp += 4;&   result->y = INCRSUMP(mp,s,px,py,pz);
   mp += 4;&   result->z = INCRSUMP(mp,s,px,py,pz);  5   mp = &RTable[(int) Hash1d( jxiy_hash, iz ) & 0xFF];b   px = x-jx;   s = sxty*tz;'   result->x += INCRSUMP(mp,s,px,py,pz); 
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz);x
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);3  5   mp = &RTable[(int) Hash1d( jxjy_hash, iz ) & 0xFF];x   py = y-jy;   s = sxsy*tz;'   result->x += INCRSUMP(mp,s,px,py,pz);1
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz); 
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);0  5   mp = &RTable[(int) Hash1d( ixjy_hash, iz ) & 0xFF];9   px = x-ix;   s = txsy*tz;'   result->x += INCRSUMP(mp,s,px,py,pz); 
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz);x
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);5  5   mp = &RTable[(int) Hash1d( ixjy_hash, jz ) & 0xFF];x   pz = z-jz;   s = txsy*sz;'   result->x += INCRSUMP(mp,s,px,py,pz);1
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz); 
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);1  5   mp = &RTable[(int) Hash1d( jxjy_hash, jz ) & 0xFF];f   px = x-jx;   s = sxsy*sz;'   result->x += INCRSUMP(mp,s,px,py,pz); 
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz);x
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);f  5   mp = &RTable[(int) Hash1d( jxiy_hash, jz ) & 0xFF];x   py = y-iy;   s = sxty*sz;'   result->x += INCRSUMP(mp,s,px,py,pz);0
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz);;
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);O  5   mp = &RTable[(int) Hash1d( ixiy_hash, jz ) & 0xFF];O   px = x-ix;   s = txty*sz;'   result->x += INCRSUMP(mp,s,px,py,pz);a
   mp += 4;'   result->y += INCRSUMP(mp,s,px,py,pz);r
   mp += 4;'   result->z += INCRSUMP(mp,s,px,py,pz);e   }g  0 DBL Turbulence (x, y, z, omega, lambda, octaves) DBL x, y, z,omega, lambda; int octaves;   {*   int i;'   DBL l, o, value, tempx, tempy, tempz;h     value = Noise(x, y, z);(
   l = lambda;_   o = omega;    for (i = 2; i <= octaves; i++)     {      tempx = l * x;     tempy = l * y;     tempz = l * z;,     value += o * Noise(tempx, tempy, tempz);     if (i < octaves)       {;       l *= lambda;       o *= omega;r       }+     }    return (value);r   }t  : void DTurbulence (result, x, y, z, omega, lambda, octaves) VECTOR  *result; DBL x, y, z, omega, lambda;n int octaves;   {a   int i;   DBL l, o;e   VECTOR value, temp;e     result -> x = 0.0;   result -> y = 0.0;   result -> z = 0.0;  $   value.x = value.y = value.z = 0.0;     DNoise(result, x,y,z);  
   l = lambda;e   o = omega;    for (i = 2; i <= octaves; i++)     {      temp.x = l * x;o     temp.y = l * y;l     temp.z = l * z;>  +     DNoise(&value, temp.x, temp.y, temp.z);>     result->x += o * value.x;l     result->y += o * value.y;o     result->z += o * value.z;      if (i < octaves)       {p       l *= lambda;       o *= omega;n       }L     }o   }T   DBL cycloidal (value) 
 DBL value;   {o   register int indx;     if (value >= 0.0)A     { 7     indx = (int)((value - floor (value)) * SINTABSIZE);3     return (sintab [indx]);;     }M   else     {iE     indx = (int)((0.0 - (value + floor (0.0 - value))) * SINTABSIZE);(!     return (0.0 - sintab [indx]);e     }=   }d   DBL Triangle_Wave (value)0
 DBL value;   {    register DBL offset,temp1;  2   if (value >= 0.0) offset = value - floor(value);   else (     {n&     temp1 = -1.0 - floor(fabs(value));     offset = value - temp1;b     } 3   if (offset >= 0.5) return (2.0 * (1.0 - offset));    else return (2.0 * offset);    }   ,   void Translate_Textures (Textures, Vector)     TEXTURE *Textures; VECTOR *Vector;    {h   TRANSFORM Trans;  1   Compute_Translation_Transform (&Trans, Vector);h(   Transform_Textures (Textures, &Trans);   }i  ' void Rotate_Textures (Textures, Vector)  TEXTURE *Textures; VECTOR *Vector;l   {D   TRANSFORM Trans;  .   Compute_Rotation_Transform (&Trans, Vector);(   Transform_Textures (Textures, &Trans);   }   & void Scale_Textures (Textures, Vector) TEXTURE *Textures; VECTOR *Vector;C   {    TRANSFORM Trans;  -   Compute_Scaling_Transform (&Trans, Vector); (   Transform_Textures (Textures, &Trans);   }u  ) void Transform_Textures (Textures, Trans)  TEXTURE *Textures; TRANSFORM *Trans;r   {o   TEXTURE *Layer, *Material;     for (Layer = Textures;   Layer != NULL;   Layer = Layer->Next_Layer)     switch (Layer->Type)     {u     case PNF_TEXTURE:e0       Transform_Pigment (Layer->Pigment, Trans);0       Transform_Tnormal (Layer->Tnormal, Trans);       break;       case TILE_TEXTURE:*       if (((TILES *)Layer)->Trans == NULL)6         ((TILES *)Layer)->Trans = Create_Transform ();:       Compose_Transforms (((TILES *)Layer)->Trans, Trans);:       Transform_Textures (((TILES *)Layer)->Tile1, Trans);:       Transform_Textures (((TILES *)Layer)->Tile2, Trans);       break;       case MAT_TEXTURE:B-       if (((MATERIAL *)Layer)->Trans == NULL)x9         ((MATERIAL *)Layer)->Trans = Create_Transform (); =       Compose_Transforms (((MATERIAL *)Layer)->Trans, Trans);_5       for (Material = ((MATERIAL *)Layer)->Materials;+       Material != NULL;x)       Material = Material->Next_Material),-         Transform_Textures (Material, Trans);        break;     };   }    FINISH *Create_Finish ()   {    FINISH *New;  :   if ((New = (FINISH *) malloc (sizeof (FINISH))) == NULL)     MAError ("finish");      New->Reflection = 0.0;   New->Ambient    = 0.1;   New->Diffuse    = 0.6;   New->Brilliance = 1.0;!   New->Index_Of_Refraction = 1.0;    New->Refraction = 0.0;   New->Specular   = 0.0;-   New->Roughness  = 1.0/0.05; /* CEY 12/92 */y   New->Phong      = 0.0;   New->Phong_Size = 40.0;z   New->Crand = 0.0;    New->Metallic_Flag = FALSE;y     return (New);y   }    FINISH *Copy_Finish (Old)( FINISH *Old;   {h   FINISH *New;     if (Old != NULL)     {d     New  = Create_Finish ();     *New = *Old;     }=   else     New = NULL;y   return (New);F   }    TEXTURE *Create_PNF_Texture ()   {,   TEXTURE *New;=  <   if ((New = (TEXTURE *) malloc (sizeof (TEXTURE))) == NULL)     MAError ("texture");     New->Type    = PNF_TEXTURE;)   New->Flags   = NO_FLAGS;   New->Pigment = NULL;   New->Tnormal = NULL;   New->Finish  = NULL;   New->Next_Layer = NULL;h   New->Next_Material = NULL;     return (New);    }    TILES *Create_Tiles_Texture ()   {s
   TILES *New;   8   if ((New = (TILES *) malloc (sizeof (TILES))) == NULL)      MAError ("checker texture");     New->Type  = TILE_TEXTURE;   New->Flags = NO_FLAGS;   New->Tile1 = NULL;   New->Tile2 = NULL;   New->Trans  = NULL;    New->Next_Layer = NULL;C   New->Next_Material = NULL;     return (New);&   }e  $ MATERIAL *Create_Material_Texture ()   {u   MATERIAL *New;  >   if ((New = (MATERIAL *) malloc (sizeof (MATERIAL))) == NULL)!     MAError ("material texture");      New->Type      = MAT_TEXTURE;    New->Flags     = NO_FLAGS;   New->Materials = NULL;   New->Num_Of_Mats = 0;-   New->Trans  = NULL;e   New->Next_Layer = NULL;t   New->Next_Material = NULL;     return (New);    }   ! TEXTURE *Copy_Textures (Textures)  TEXTURE *Textures;   {h*   TEXTURE *New, *First, *Previous, *Layer;     Previous = First = NULL;     for (Layer = Textures;   Layer != NULL;   Layer = Layer->Next_Layer)     {x     switch (Layer->Type)     {,     case PNF_TEXTURE:x"       New = Create_PNF_Texture ();3       New->Pigment = Copy_Pigment (Layer->Pigment);a3       New->Tnormal = Copy_Tnormal (Layer->Tnormal);(2       New->Finish  = Copy_Finish  (Layer->Finish);       break;       case TILE_TEXTURE:0       New = (TEXTURE *) Create_Tiles_Texture ();F       ((TILES *)New)->Tile1 = Copy_Textures (((TILES *)Layer)->Tile1);F       ((TILES *)New)->Tile2 = Copy_Textures (((TILES *)Layer)->Tile2);G       ((TILES *)New)->Trans = Copy_Transform (((TILES *)Layer)->Trans);i       break;       case MAT_TEXTURE: 3       New = (TEXTURE *) Create_Material_Texture ();dU       ((MATERIAL *)New)->Materials = Copy_Materials (((MATERIAL *)Layer)->Materials);yM       ((MATERIAL *)New)->Trans = Copy_Transform (((MATERIAL *)Layer)->Trans); I       ((MATERIAL *)New)->Image = Copy_Image (((MATERIAL *)Layer)->Image); J       ((MATERIAL *)New)->Num_Of_Mats = (((MATERIAL *)Layer)->Num_Of_Mats);       break;     }        if (First == NULL)       First = New;     if (Previous != NULL)e!       Previous->Next_Layer = New;x     Previous = New;t     }I   return (First);p   }    TEXTURE *Copy_Materials (Old)j
 TEXTURE *Old;0   {x-   TEXTURE *New, *First, *Previous, *Material;I     Previous = First = NULL;     for (Material = Old;   Material != NULL; %   Material = Material->Next_Material)p     {y#     New = Copy_Textures (Material);(       if (First == NULL)       First = New;       if (Previous != NULL)C$       Previous->Next_Material = New;       Previous = New;p     }y   return (First);    }u    void Destroy_Textures (Textures) TEXTURE *Textures;   {s   TEXTURE *Layer=Textures;   TEXTURE *Mats;   TEXTURE *Temp;     while (Layer != NULL)p     {)      Mats = Layer->Next_Material;     while (Mats != NULL)       { !       Temp = Mats->Next_Material;p!       Mats->Next_Material = NULL;(       Destroy_Textures (Mats);       Mats = Temp;       }e     switch (Layer->Type)     {)     case PNF_TEXTURE:t'       Destroy_Pigment (Layer->Pigment); '       Destroy_Tnormal (Layer->Tnormal);)%       Destroy_Finish (Layer->Finish);_       break;       case TILE_TEXTURE:2       Destroy_Transform (((TILES *)Layer)->Trans);1       Destroy_Textures (((TILES *)Layer)->Tile1);)1       Destroy_Textures (((TILES *)Layer)->Tile2);p       break;       case MAT_TEXTURE:i5       Destroy_Transform (((MATERIAL *)Layer)->Trans); 8       Destroy_Textures (((MATERIAL *)Layer)->Materials);1       Destroy_Image (((MATERIAL *)Layer)->Image);e       break;     }p     Temp = Layer->Next_Layer;b     free (Layer);e     Layer = Temp;)     },   }  m   void Post_Textures (Textures)  TEXTURE *Textures;   {u   TEXTURE *Layer, *Material;     if (Textures == NULL)      return;      for (Layer = Textures;   Layer != NULL;   Layer = Layer->Next_Layer)     {p&     if (!((Layer->Flags) & POST_DONE))       switch (Layer->Type)       {        case PNF_TEXTURE: &         Post_Pigment (Layer->Pigment);&         Post_Tnormal (Layer->Tnormal);         break;         case TILE_TEXTURE:0         Post_Textures (((TILES *)Layer)->Tile1);0         Post_Textures (((TILES *)Layer)->Tile2);         break;         case MAT_TEXTURE: 7         for (Material = ((MATERIAL *)Layer)->Materials;          Material != NULL;u+         Material = Material->Next_Material)z"           Post_Textures(Material);         break;       }s     } 	   return;    }x  