M /****************************************************************************  *                triangle.c  * H *  This module implements primitives for triangles and smooth triangles. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "vector.h"  #include "povproto.h"    METHODS Triangle_Methods =     {    All_Triangle_Intersections, #   Inside_Triangle, Triangle_Normal,    Copy_Triangle,&   Translate_Triangle, Rotate_Triangle,G   Scale_Triangle, Transform_Triangle, Invert_Triangle, Destroy_Triangle    };  " METHODS Smooth_Triangle_Methods =    {    All_Triangle_Intersections, *   Inside_Triangle, Smooth_Triangle_Normal,   Copy_Smooth_Triangle, 4   Translate_Smooth_Triangle, Rotate_Smooth_Triangle,4   Scale_Smooth_Triangle, Transform_Smooth_Triangle, *   Invert_Smooth_Triangle, Destroy_Triangle   };   extern RAY *CM_Ray; = extern long Ray_Triangle_Tests, Ray_Triangle_Tests_Succeeded;   3 #define max3(x,y,z) ((x>y)?((x>z)?1:3):((y>z)?2:3))   G #define MAX3(x,y,z) (((x)>(y))?(((x)>(z))?(x):(z)):(((y)>(z))?(y):(z))) G #define MIN3(x,y,z) (((x)<(y))?(((x)<(z))?(x):(z)):(((y)<(z))?(y):(z)))   * void Find_Triangle_Dominant_Axis(Triangle) TRIANGLE *Triangle;    {    DBL x, y, z;  &   x = fabs(Triangle->Normal_Vector.x);'   y = fabs (Triangle->Normal_Vector.y); '   z = fabs (Triangle->Normal_Vector.z);    switch (max3(x, y, z))     { 
   case 1: %     Triangle->Dominant_Axis = X_AXIS; 
     break;
   case 2: %     Triangle->Dominant_Axis = Y_AXIS; 
     break;
   case 3: %     Triangle->Dominant_Axis = Z_AXIS; 
     break;   }    }   ' void Compute_Smooth_Triangle (Triangle)  SMOOTH_TRIANGLE *Triangle;   { #   VECTOR P3MinusP2, VTemp1, VTemp2; "   DBL x, y, z, uDenominator, Proj;  /   VSub (P3MinusP2, Triangle->P3, Triangle->P2);    x = fabs (P3MinusP2.x);    y = fabs (P3MinusP2.y);    z = fabs (P3MinusP2.z);      switch (max3 (x, y, z))    {    case 1:        Triangle->vAxis = X_AXIS; &     Triangle->BaseDelta = P3MinusP2.x;
     break;     case 2:        Triangle->vAxis = Y_AXIS; &     Triangle->BaseDelta = P3MinusP2.y;
     break;     case 3:        Triangle->vAxis = Z_AXIS; &     Triangle->BaseDelta = P3MinusP2.z;
     break;   }     ,   VSub (VTemp1, Triangle->P2, Triangle->P3);   VNormalize (VTemp1, VTemp1);,   VSub (VTemp2, Triangle->P1, Triangle->P3);   VDot (Proj, VTemp2, VTemp1);   VScaleEq (VTemp1, Proj);(   VSub (Triangle->Perp, VTemp1, VTemp2);.   VNormalize (Triangle->Perp, Triangle->Perp);.   VDot (uDenominator, VTemp2, Triangle->Perp);2   VInverseScaleEq (Triangle->Perp, -uDenominator);   }   & int Compute_Triangle (Triangle,Smooth) TRIANGLE *Triangle;  int Smooth;    {    VECTOR V1, V2, Temp;   DBL Length, T1, T2, T3;   (   VSub (V1, Triangle->P1, Triangle->P2);(   VSub (V2, Triangle->P3, Triangle->P2);+   VCross (Triangle->Normal_Vector, V1, V2); ,   VLength (Length, Triangle->Normal_Vector);;   /* Set up a flag so we can ignore degenerate triangles */    if (Length < 1.0e-9)     { %     Triangle->Degenerate_Flag = TRUE;      return (0);      }   $   /* Normalize the normal vector. */4   VInverseScaleEq (Triangle->Normal_Vector, Length);  C   VDot (Triangle->Distance, Triangle->Normal_Vector, Triangle->P1);    Triangle->Distance *= -1.0; (   Find_Triangle_Dominant_Axis(Triangle);  #   switch (Triangle->Dominant_Axis)     {    case X_AXIS:M     if ((Triangle->P2.y - Triangle->P3.y)*(Triangle->P2.z - Triangle->P1.z) < K       (Triangle->P2.z - Triangle->P3.z)*(Triangle->P2.y - Triangle->P1.y))         {        Temp = Triangle->P2;"       Triangle->P2 = Triangle->P1;       Triangle->P1 = Temp;       if (Smooth) 	         { 2         Temp = ((SMOOTH_TRIANGLE *) Triangle)->N2;P         ((SMOOTH_TRIANGLE *) Triangle)->N2 = ((SMOOTH_TRIANGLE *) Triangle)->N1;2         ((SMOOTH_TRIANGLE *) Triangle)->N1 = Temp;	         }        } 
     break;     case Y_AXIS:M     if ((Triangle->P2.x - Triangle->P3.x)*(Triangle->P2.z - Triangle->P1.z) < K       (Triangle->P2.z - Triangle->P3.z)*(Triangle->P2.x - Triangle->P1.x))         {        Temp = Triangle->P2;"       Triangle->P2 = Triangle->P1;       Triangle->P1 = Temp;       if (Smooth) 	         { 2         Temp = ((SMOOTH_TRIANGLE *) Triangle)->N2;P         ((SMOOTH_TRIANGLE *) Triangle)->N2 = ((SMOOTH_TRIANGLE *) Triangle)->N1;2         ((SMOOTH_TRIANGLE *) Triangle)->N1 = Temp;	         }        } 
     break;     case Z_AXIS:M     if ((Triangle->P2.x - Triangle->P3.x)*(Triangle->P2.y - Triangle->P1.y) < K       (Triangle->P2.y - Triangle->P3.y)*(Triangle->P2.x - Triangle->P1.x))         {        Temp = Triangle->P2;"       Triangle->P2 = Triangle->P1;       Triangle->P1 = Temp;       if (Smooth) 	         { 2         Temp = ((SMOOTH_TRIANGLE *) Triangle)->N2;P         ((SMOOTH_TRIANGLE *) Triangle)->N2 = ((SMOOTH_TRIANGLE *) Triangle)->N1;2         ((SMOOTH_TRIANGLE *) Triangle)->N1 = Temp;	         }        } 
     break;   }   
   if (Smooth) :     Compute_Smooth_Triangle((SMOOTH_TRIANGLE *) Triangle);  8   /* Build the bounding information from the vertices */'   /* Use temps so macro not too big. */ <   T1 = MIN3(Triangle->P1.x, Triangle->P2.x, Triangle->P3.x);<   T2 = MIN3(Triangle->P1.y, Triangle->P2.y, Triangle->P3.y);<   T3 = MIN3(Triangle->P1.z, Triangle->P2.z, Triangle->P3.z);5   Make_Vector(&Triangle->Bounds.Lower_Left,T1,T2,T3);   <   T1 = MAX3(Triangle->P1.x, Triangle->P2.x, Triangle->P3.x);<   T2 = MAX3(Triangle->P1.y, Triangle->P2.y, Triangle->P3.y);<   T3 = MAX3(Triangle->P1.z, Triangle->P2.z, Triangle->P3.z);2   Make_Vector(&Triangle->Bounds.Lengths,T1,T2,T3);  :   VSub(Triangle->Bounds.Lengths, Triangle->Bounds.Lengths,!     Triangle->Bounds.Lower_Left); (   Triangle->Bounds.Lengths.x += EPSILON;(   Triangle->Bounds.Lengths.y += EPSILON;(   Triangle->Bounds.Lengths.z += EPSILON;
   return (1);    }   9 int All_Triangle_Intersections (Object, Ray, Depth_Stack)  OBJECT *Object; 	 RAY *Ray;  ISTACK *Depth_Stack;   {    DBL Depth;   VECTOR IPoint;  ;   if (Intersect_Triangle (Ray, (TRIANGLE *)Object, &Depth))      { -     VScale (IPoint, Ray -> Direction, Depth); $     VAddEq (IPoint, Ray -> Initial);,     if (Point_In_Clip(&IPoint,Object->Clip))       { 2       push_entry(Depth,IPoint,Object,Depth_Stack);       return (TRUE);       }      }    return (FALSE);    }   - int Intersect_Triangle (Ray, Triangle, Depth) 	 RAY *Ray;  TRIANGLE *Triangle;  DBL *Depth;    { *   DBL NormalDotOrigin, NormalDotDirection;   DBL s, t;      Ray_Triangle_Tests++;    if(Triangle->Degenerate_Flag)      return(FALSE);     if (Ray == CM_Ray)       {      if (!Triangle->CMCached)         { N       VDot (Triangle->CMNormDotOrigin, Triangle->Normal_Vector, Ray->Initial);6       Triangle->CMNormDotOrigin += Triangle->Distance;(       Triangle->CMNormDotOrigin *= -1.0;        Triangle->CMCached = TRUE;       }   G     VDot (NormalDotDirection, Triangle->Normal_Vector, Ray->Direction); 1     if ((NormalDotDirection < Small_Tolerance) && .       (NormalDotDirection > -Small_Tolerance))       return (FALSE);   <     *Depth = Triangle->CMNormDotOrigin / NormalDotDirection;     }    else *     {*B     VDot (NormalDotOrigin, Triangle->Normal_Vector, Ray->Initial);*     NormalDotOrigin += Triangle->Distance;     NormalDotOrigin *= -1.0;  G     VDot (NormalDotDirection, Triangle->Normal_Vector, Ray->Direction);a1     if ((NormalDotDirection < Small_Tolerance) && .       (NormalDotDirection > -Small_Tolerance))       return (FALSE);-  2     *Depth = NormalDotOrigin / NormalDotDirection;     }e  <   if ((*Depth < Small_Tolerance) || (*Depth > Max_Distance))     return (FALSE);o  #   switch (Triangle->Dominant_Axis) t   {V   case X_AXIS:3     s = Ray->Initial.y + *Depth * Ray->Direction.y;t3     t = Ray->Initial.z + *Depth * Ray->Direction.z;d  @     if ((Triangle->P2.y - s)*(Triangle->P2.z - Triangle->P1.z) <=       (Triangle->P2.z - t)*(Triangle->P2.y - Triangle->P1.y))e       return (FALSE);i  @     if ((Triangle->P3.y - s)*(Triangle->P3.z - Triangle->P2.z) <=       (Triangle->P3.z - t)*(Triangle->P3.y - Triangle->P2.y))l       return (FALSE);i  @     if ((Triangle->P1.y - s)*(Triangle->P1.z - Triangle->P3.z) <=       (Triangle->P1.z - t)*(Triangle->P1.y - Triangle->P3.y))e       return (FALSE);B  #     Ray_Triangle_Tests_Succeeded++;*     return (TRUE);     case Y_AXIS:3     s = Ray->Initial.x + *Depth * Ray->Direction.x; 3     t = Ray->Initial.z + *Depth * Ray->Direction.z;D  @     if ((Triangle->P2.x - s)*(Triangle->P2.z - Triangle->P1.z) <=       (Triangle->P2.z - t)*(Triangle->P2.x - Triangle->P1.x))r       return (FALSE);,  @     if ((Triangle->P3.x - s)*(Triangle->P3.z - Triangle->P2.z) <=       (Triangle->P3.z - t)*(Triangle->P3.x - Triangle->P2.x))_       return (FALSE);   @     if ((Triangle->P1.x - s)*(Triangle->P1.z - Triangle->P3.z) <=       (Triangle->P1.z - t)*(Triangle->P1.x - Triangle->P3.x))l       return (FALSE);s  #     Ray_Triangle_Tests_Succeeded++;_     return (TRUE);     case Z_AXIS:3     s = Ray->Initial.x + *Depth * Ray->Direction.x;a3     t = Ray->Initial.y + *Depth * Ray->Direction.y;(  @     if ((Triangle->P2.x - s)*(Triangle->P2.y - Triangle->P1.y) <=       (Triangle->P2.y - t)*(Triangle->P2.x - Triangle->P1.x))x       return (FALSE);z  @     if ((Triangle->P3.x - s)*(Triangle->P3.y - Triangle->P2.y) <=       (Triangle->P3.y - t)*(Triangle->P3.x - Triangle->P2.x))i       return (FALSE);;  @     if ((Triangle->P1.x - s)*(Triangle->P1.y - Triangle->P3.y) <=       (Triangle->P1.y - t)*(Triangle->P1.x - Triangle->P3.x))        return (FALSE);A  #     Ray_Triangle_Tests_Succeeded++;      return (TRUE);   }i   return (FALSE);r   }   $ int Inside_Triangle (IPoint, Object) VECTOR *IPoint;r OBJECT *Object;    {d   return (FALSE);a   }(  - void Triangle_Normal (Result, Object, IPoint)E OBJECT *Object;T VECTOR *Result, *IPoint;   {u0   *Result = ((TRIANGLE *)Object)->Normal_Vector;   }T   void *Copy_Triangle (Object) OBJECT *Object;    {(   TRIANGLE *New;     New = Create_Triangle ();w    *New = * ((TRIANGLE *)Object);     return (New);g   }A  ( void Translate_Triangle (Object, Vector) OBJECT *Object;r VECTOR *Vector;    { +   TRIANGLE *Triangle = (TRIANGLE *) Object;a   VECTOR Translation;   '   if(Triangle->Degenerate_Flag) return;A  <   VEvaluate (Translation, Triangle->Normal_Vector, *Vector);F   Triangle->Distance -= Translation.x + Translation.y + Translation.z;    VAddEq (Triangle->P1, *Vector)"     VAddEq (Triangle->P2, *Vector)$       VAddEq (Triangle->P3, *Vector)  $         /* Recalculate the bounds */3         VAddEq(Object->Bounds.Lower_Left, *Vector);a   }>  % void Rotate_Triangle (Object, Vector)a OBJECT *Object;I VECTOR *Vector;i   {-   TRANSFORM Trans;  3   if(((TRIANGLE *)Object)->Degenerate_Flag) return;A  .   Compute_Rotation_Transform (&Trans, Vector);&   Transform_Triangle (Object, &Trans);   }S  $ void Scale_Triangle (Object, Vector) OBJECT *Object;e VECTOR *Vector;2   { +   TRIANGLE *Triangle = (TRIANGLE *) Object;    DBL Length,T1,T2,T3;  '   if(Triangle->Degenerate_Flag) return;e  D   Triangle->Normal_Vector.x = Triangle->Normal_Vector.x / Vector->x;D   Triangle->Normal_Vector.y = Triangle->Normal_Vector.y / Vector->y;D   Triangle->Normal_Vector.z = Triangle->Normal_Vector.z / Vector->z;  +   VLength(Length, Triangle->Normal_Vector); 4   VInverseScaleEq (Triangle->Normal_Vector, Length);   Triangle->Distance /= Length;l  &   VEvaluateEq (Triangle->P1, *Vector);&   VEvaluateEq (Triangle->P2, *Vector);&   VEvaluateEq (Triangle->P3, *Vector);     /* Recompute the bounds */'   /* Use temps so macro not too big. */r<   T1 = MIN3(Triangle->P1.x, Triangle->P2.x, Triangle->P3.x);<   T2 = MIN3(Triangle->P1.y, Triangle->P2.y, Triangle->P3.y);<   T3 = MIN3(Triangle->P1.z, Triangle->P2.z, Triangle->P3.z);5   Make_Vector(&Triangle->Bounds.Lower_Left,T1,T2,T3);   <   T1 = MAX3(Triangle->P1.x, Triangle->P2.x, Triangle->P3.x);<   T2 = MAX3(Triangle->P1.y, Triangle->P2.y, Triangle->P3.y);<   T3 = MAX3(Triangle->P1.z, Triangle->P2.z, Triangle->P3.z);2   Make_Vector(&Triangle->Bounds.Lengths,T1,T2,T3);  :   VSub(Triangle->Bounds.Lengths, Triangle->Bounds.Lengths,!     Triangle->Bounds.Lower_Left); (   Triangle->Bounds.Lengths.x += EPSILON;(   Triangle->Bounds.Lengths.y += EPSILON;(   Triangle->Bounds.Lengths.z += EPSILON;   }   ' void Transform_Triangle (Object, Trans)a OBJECT *Object;  TRANSFORM *Trans;    {i+   TRIANGLE *Triangle = (TRIANGLE *) Object;N  '   if(Triangle->Degenerate_Flag) return;>  (   MTransPoint (&Triangle->Normal_Vector,%     &Triangle->Normal_Vector, Trans);P4   MTransPoint (&Triangle->P1, &Triangle->P1, Trans);4   MTransPoint (&Triangle->P2, &Triangle->P2, Trans);4   MTransPoint (&Triangle->P3, &Triangle->P3, Trans);$   Compute_Triangle (Triangle,FALSE);   }-   TRIANGLE *Create_Triangle();   {    TRIANGLE *New;  >   if ((New = (TRIANGLE *) malloc (sizeof (TRIANGLE))) == NULL)     MAError ("triangle");i  ;   INIT_OBJECT_FIELDS(New,TRIANGLE_OBJECT,&Triangle_Methods)O  9     Make_Vector (&(New -> Normal_Vector), 0.0, 1.0, 0.0);    New -> Distance = 0.0;   New -> CMNormDotOrigin = 0.0;l   New -> CMCached = FALSE;,   Make_Vector (&(New -> P1), 0.0, 0.0, 0.0);,   Make_Vector (&(New -> P2), 1.0, 0.0, 0.0);,   Make_Vector (&(New -> P3), 0.0, 1.0, 0.0);!   New -> Degenerate_Flag = FALSE;2  >   /* NOTE: Dominant_Axis is computed when Parse_Triangle calls@    Compute_Triangle.  vAxis is used only for smooth triangles */       return (New);o   }e   void Invert_Triangle (Object)a OBJECT *Object;g   {2	   return;e   }x  > /* Calculate the Phong-interpolated vector within the triangle>    at the given intersection point. The math for this is a bit    bizarre:T       -         P1     |        /|\ \     |       / |Perp\     |      /  V  \   \     |     /   |    \   \   u |    /____|_____PI___\     |   /     |       \    \     -  P2-----|--------|----P3!               Pbase    PIntersectL         |-------------------|(                        v  A    Triangle->Perp is a unit vector from P1 to Pbase. We calculate   1    u = (PI - P1) DOT Perp / ((P3 - P1) DOT Perp).E  O    We then calculate where the line from P1 to PI intersects the line P2 to P3:     PIntersect = (PI - P1)/u.  M    We really only need one coordinate of PIntersect.  We then calculate v as:I  &       v = PIntersect.x / (P3.x - P2.x)&  or   v = PIntersect.y / (P3.y - P2.y)&  or   v = PIntersect.z / (P3.z - P2.z)  @    depending on which calculation will give us the best answers.  D    Once we have u and v, we can perform the normal interpolation as:        NTemp1 = N1 + u(N2 - N1);      NTemp2 = N1 + u(N3 - N1);5      Result = normalize (NTemp1 + v(NTemp2 - NTemp1))n  G    As always, any values which are constant for the triangle are cached     in the triangle.( */  4 void Smooth_Triangle_Normal (Result, Object, IPoint) OBJECT *Object;a VECTOR *Result, *IPoint;   {l9   SMOOTH_TRIANGLE *Triangle = (SMOOTH_TRIANGLE *) Object; #   VECTOR PIMinusP1, NTemp1, NTemp2;    DBL u = 0.0, v = 0.0;r  *   VSub (PIMinusP1, *IPoint, Triangle->P1);&   VDot (u, PIMinusP1, Triangle->Perp);   if (u < 1.0e-9)      {r     *Result = Triangle->N1;r     return;      }(  L   /* BaseDelta contains P3.x-P2.x,  P3.y-P2.y, or P3.z-P2.z depending on the       value of vAxis. */     switch (Triangle->vAxis) N   {_   case X_AXIS:  P     v = (PIMinusP1.x/u + Triangle->P1.x - Triangle->P2.x) / Triangle->BaseDelta;
     break;     case Y_AXIS:  P     v = (PIMinusP1.y/u + Triangle->P1.y - Triangle->P2.y) / Triangle->BaseDelta;
     break;     case Z_AXIS:  O     v = (PIMinusP1.z/u + Triangle->P1.z - Triangle->P2.z)/ Triangle->BaseDelta;n
     break;   }t  ,   VSub (NTemp1, Triangle->N2, Triangle->N1);   VScaleEq (NTemp1, u);e    VAddEq (NTemp1, Triangle->N1);,   VSub (NTemp2, Triangle->N3, Triangle->N1);   VScaleEq (NTemp2, u);i    VAddEq (NTemp2, Triangle->N1);!   VSub (*Result, NTemp2, NTemp1);    VScaleEq (*Result, v);   VAddEq (*Result, NTemp1);     VNormalize (*Result, *Result);   }T  # void *Copy_Smooth_Triangle (Object)i OBJECT *Object;    {e   SMOOTH_TRIANGLE *New;(  "   New = Create_Smooth_Triangle ();'   *New = * ((SMOOTH_TRIANGLE *)Object);      return (New);y   }i  / void Translate_Smooth_Triangle (Object, Vector)T OBJECT *Object;) VECTOR *Vector;-   {n9   SMOOTH_TRIANGLE *Triangle = (SMOOTH_TRIANGLE *) Object;T   VECTOR Translation;   '   if(Triangle->Degenerate_Flag) return;S  <   VEvaluate (Translation, Triangle->Normal_Vector, *Vector);F   Triangle->Distance -= Translation.x + Translation.y + Translation.z;    VAddEq (Triangle->P1, *Vector)"     VAddEq (Triangle->P2, *Vector)$       VAddEq (Triangle->P3, *Vector)6         Compute_Triangle ((TRIANGLE *) Triangle,TRUE);   }(  , void Rotate_Smooth_Triangle (Object, Vector) OBJECT *Object;l VECTOR *Vector;    {n   TRANSFORM Trans;  :   if(((SMOOTH_TRIANGLE *)Object)->Degenerate_Flag) return;  .   Compute_Rotation_Transform (&Trans, Vector);-   Transform_Smooth_Triangle (Object, &Trans);e   }x  + void Scale_Smooth_Triangle (Object, Vector)  OBJECT *Object;T VECTOR *Vector;_   { 9   SMOOTH_TRIANGLE *Triangle = (SMOOTH_TRIANGLE *) Object;*
   DBL Length;r  '   if(Triangle->Degenerate_Flag) return;   D   Triangle->Normal_Vector.x = Triangle->Normal_Vector.x / Vector->x;D   Triangle->Normal_Vector.y = Triangle->Normal_Vector.y / Vector->y;D   Triangle->Normal_Vector.z = Triangle->Normal_Vector.z / Vector->z;  +   VLength(Length, Triangle->Normal_Vector);l3   VScaleEq (Triangle->Normal_Vector, 1.0 / Length);    Triangle->Distance /= Length;i  &   VEvaluateEq (Triangle->P1, *Vector);&   VEvaluateEq (Triangle->P2, *Vector);&   VEvaluateEq (Triangle->P3, *Vector);0   Compute_Triangle ((TRIANGLE *) Triangle,TRUE);   }+  . void Transform_Smooth_Triangle (Object, Trans) OBJECT *Object;e TRANSFORM *Trans;O   {)9   SMOOTH_TRIANGLE *Triangle = (SMOOTH_TRIANGLE *) Object;)  '   if(Triangle->Degenerate_Flag) return;b  (   MTransPoint (&Triangle->Normal_Vector,%     &Triangle->Normal_Vector, Trans);A4   MTransPoint (&Triangle->P1, &Triangle->P1, Trans);4   MTransPoint (&Triangle->P2, &Triangle->P2, Trans);4   MTransPoint (&Triangle->P3, &Triangle->P3, Trans);4   MTransPoint (&Triangle->N1, &Triangle->N1, Trans);4   MTransPoint (&Triangle->N2, &Triangle->N2, Trans);4   MTransPoint (&Triangle->N3, &Triangle->N3, Trans);0   Compute_Triangle ((TRIANGLE *) Triangle,TRUE);   }g  $ void Invert_Smooth_Triangle (Object) OBJECT *Object;g   {o	   return;,   }t  ) SMOOTH_TRIANGLE *Create_Smooth_Triangle()    {l   SMOOTH_TRIANGLE *New;   L   if ((New = (SMOOTH_TRIANGLE *) malloc (sizeof (SMOOTH_TRIANGLE))) == NULL)      MAError ("smooth triangle");  I   INIT_OBJECT_FIELDS(New,SMOOTH_TRIANGLE_OBJECT,&Smooth_Triangle_Methods)V  7     Make_Vector (&(New->Normal_Vector), 0.0, 1.0, 0.0);B   New->Distance = 0.0;   New -> CMNormDotOrigin = 0.0;;   New -> CMCached = FALSE;,   Make_Vector (&(New -> P1), 0.0, 0.0, 0.0);,   Make_Vector (&(New -> P2), 1.0, 0.0, 0.0);,   Make_Vector (&(New -> P3), 0.0, 1.0, 0.0);,   Make_Vector (&(New -> N1), 0.0, 1.0, 0.0);,   Make_Vector (&(New -> N2), 0.0, 1.0, 0.0);,   Make_Vector (&(New -> N3), 0.0, 1.0, 0.0);   New -> BaseDelta = 0.0;t!   New -> Degenerate_Flag = FALSE;m  I   /* NOTE: Dominant_Axis and vAxis are computed when Parse_Triangle callso    Compute_Triangle.  */     return (New);    }a   void Destroy_Triangle (Object) OBJECT *Object;    {r   free (Object);   }h