M /****************************************************************************  *                vect.c  * E *  This file was written by Alexander Enzmann.  He wrote the code for F *  4th-6th order shapes and generously provided us these enhancements. * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment L *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file E *  named POVLEGAL.DOC which should be distributed with this file. If  L *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/   #include "frame.h" #include "povproto.h"  #include "vector.h"   
 #ifdef ABS
 #undef ABS #endif  
 #ifdef MAX
 #undef MAX #endif   extern int Shadow_Test_Flag; #undef EPSILON #define EPSILON 1.0e-10  #define COEFF_LIMIT 1.0e-20   2 /*                  WARNING     WARNING    WARNING  L    The following three constants have been defined so that quartic equationsJ    will properly render on fpu/compiler combinations that only have 64 bitB    IEEE precision.  Do not arbitrarily change any of these values.  K    If you have a machine with a proper fpu/compiler combo - like a Mac with F    a 68881, then use the native floating format (96 bits) and tune theH    values for a little less tolerance: something like: factor1 = 1.0e15,(    factor2 = -1.0e-7, factor3 = 1.0e-10.  *    The meaning of the three constants are:E       factor1 - the magnitude of difference between coefficients in a G                 quartic equation at which the Sturmian root solver will 7 		kick in.  The Sturm solver is quite a bit slower than 9 		the algebraic solver, so the bigger this is, the faster 9 		the root solving will go.  The algebraic solver is less : 		accurate so the bigger this is, the more likely you will 		get bad roots.  K       factor2 - Tolerance value that defines how close the quartic equation ; 		is to being a square of a quadratic.  The closer this can 9 		get to zero before roots disappear, the less the chance  		you will get spurious roots.  L       factor3 - Similar to factor2 at a later stage of the algebraic solver. */ #define FUDGE_FACTOR1 1.0e12 #define FUDGE_FACTOR2 -1.0e-5  #define FUDGE_FACTOR3 1.0e-7  , #define ABS(x) ((x) < 0.0 ? (0.0 - x) : (x)) #define MAX(x,y) (x<y?y:x)/ #define TWO_PI 6.283185207179586476925286766560 * #define TWO_PI_3  2.0943951023931954923084* #define TWO_PI_43 4.1887902047863909846168 #define MAX_ITERATIONS 50  #define MAXPOW 32      typedef struct p {
   int ord;   DBL coef[MAX_ORDER+1];   }  polynomial;   F static int modp PARAMS((polynomial *u, polynomial *v, polynomial *r));H int regula_falsa PARAMS((int order, DBL *coef, DBL a, DBL b, DBL *val));j static int sbisect PARAMS((int np, polynomial *sseq, DBL min, DBL max, int atmin, int atmax, DBL *roots));9 int numchanges PARAMS((int np, polynomial *sseq, DBL a)); 1 DBL polyeval PARAMS((DBL x, int n, DBL *Coeffs)); 3 int buildsturm PARAMS((int ord, polynomial *sseq)); M int visible_roots PARAMS((int np, polynomial *sseq, int *atneg, int *atpos)); 4 static int difficult_coeffs PARAMS((int n, DBL *x));   /*  * modp   *>  *   calculates the modulus of u(x) / v(x) leaving it in r, it$  *  returns 0 if r(x) is a constant.=  *  note: this function assumes the leading coefficient of v    *   is 1 or -1   */  static int modp(u, v, r) polynomial   *u, *v, *r;   {    int    i, k, j;    for (i=0;i<u->ord;i++)     r[i] = u[i];     if (v->coef[v->ord] < 0.0)       { 1     for (k = u->ord - v->ord - 1; k >= 0; k -= 2)        r->coef[k] = -r->coef[k]; *     for (k = u->ord - v->ord; k >= 0; k--)+       for (j = v->ord + k - 1; j >= k; j--) F       r->coef[j] = -r->coef[j] - r->coef[v->ord + k] * v->coef[j - k];     }    else       { *     for (k = u->ord - v->ord; k >= 0; k--)+       for (j = v->ord + k - 1; j >= k; j--) 9       r->coef[j] -= r->coef[v->ord + k] * v->coef[j - k];      }      k = v->ord - 1; 3   while (k >= 0 && fabs(r->coef[k]) < COEFF_LIMIT)       {      r->coef[k] = 0.0;      k--;     }    r->ord = (k < 0) ? 0 : k;    return(r->ord);    }   2 /* Build the sturmian sequence for a polynomial */ int buildsturm(ord, sseq) 
 int      ord;  polynomial   *sseq;    {    int i;   DBL f, *fp, *fc;   polynomial *sp;      sseq[0].ord = ord;   sseq[1].ord = ord - 1;  G   /* calculate the derivative and normalize the leading coefficient. */ $   f = fabs(sseq[0].coef[ord] * ord);   fp = sseq[1].coef;   fc = sseq[0].coef + 1;   for (i = 1; i <= ord; i++)     *fp++ = *fc++ * i / f;  0   /* construct the rest of the Sturm sequence */5   for (sp = sseq + 2;modp(sp - 2, sp - 1, sp); sp++)       { (     /* reverse the sign and normalize */!     f = -fabs(sp->coef[sp->ord]); 7     for (fp = &sp->coef[sp->ord]; fp >= sp->coef; fp--)        *fp /= f;      } 6   sp->coef[0] = -sp->coef[0];   /* reverse the sign */   return(sp - sseq);   }   7 /* Find out how many visible intersections there are */ ) int visible_roots(np, sseq, atzer, atpos)  int np;  polynomial *sseq;  int *atzer, *atpos;    {    int atposinf, atzero;    polynomial *s;   DBL f, lf;     atposinf = atzero = 0;#   /* changes at positve infinity */ !   lf = sseq[0].coef[sseq[0].ord]; *   for (s = sseq + 1; s <= sseq + np; s++)      {      f = s->coef[s->ord];      if (lf == 0.0 || lf * f < 0)       atposinf++;      lf = f;      }      /* Changes at zero */    lf = sseq[0].coef[0]; (   for (s = sseq+1; s <= sseq + np; s++)      {      f = s->coef[0];       if (lf == 0.0 || lf * f < 0)       atzero++;      lf = f;      }      *atzer = atzero;   *atpos = atposinf;   return(atzero - atposinf);   }    /*
  * numchanges   *?  *   return the number of sign changes in the Sturm sequence in   * sseq at the value a.   */  int numchanges(np, sseq, a)  int      np; polynomial   *sseq;  DBL   a;     {    int      changes;    DBL   f, lf;   polynomial   *s;   changes = 0;   COOPERATE .   lf = polyeval(a, sseq[0].ord, sseq[0].coef);*   for (s = sseq + 1; s <= sseq + np; s++)      { %     f = polyeval(a, s->ord, s->coef);       if (lf == 0.0 || lf * f < 0)       changes++;     lf = f;      }    return(changes);   }    /*
  * sbisect  *D  *   uses a bisection based on the sturm sequence for the polynomial?  * described in sseq to isolate intervals in which roots occur, C  * the roots are returned in the roots array in order of magnitude.   G Note: This routine has one severe bug: When the interval containing the H       root [min, max] has a root at one of its endpoints, as well as oneK       within the interval, the root at the endpoint will be returned rather        than the one inside.    */ 
 static int< sbisect(np, sseq, min_value, max_value, atmin, atmax, roots) int np;  polynomial *sseq;  DBL min_value, max_value;  int atmin, atmax;  DBL *roots;    {    DBL  mid;    int  n1, n2, its, atmid;     if ((atmin - atmax) == 1)      { 9     /* first try using regula-falsa to find the root.  */ I     if (regula_falsa(sseq->ord, sseq->coef, min_value, max_value, roots))        return 1; 	     else         { 4       /* That failed, so now find it by bisection */3         for (its = 0; its < MAX_ITERATIONS; its++)  	         { *         mid = (min_value + max_value) / 2;*         atmid = numchanges(np, sseq, mid);!         if (fabs(mid) > EPSILON)             { =           if (fabs((max_value - min_value) / mid) < EPSILON)  
             {*             roots[0] = mid;*             return 1;*
             }            } 8         else if (fabs(max_value - min_value) < EPSILON)            {t           roots[0] = mid;d           return 1;s           }s&         else if ((atmin - atmid) == 0)           min_value = mid;         else           max_value = mid;	         }-=       /* Bisection took too long - just return what we got */-       roots[0] = mid;o       return 1;        }s     }u  1   /* There is more than one root in the interval. %       Bisect to find new intervals */t-   for (its = 0; its < MAX_ITERATIONS; its++) a     {r&     mid = (min_value + max_value) / 2;&     atmid = numchanges(np, sseq, mid);     n1 = atmin - atmid;m     n2 = atmid - atmax;u     if (n1 != 0 && n2 != 0)        { B       n1 = sbisect(np, sseq, min_value, mid, atmin, atmid, roots);G       n2 = sbisect(np, sseq, mid, max_value, atmid, atmax, &roots[n1]);c       return n1 + n2;m       }t     if (n1 == 0)       min_value = mid;     else       max_value = mid;     }t  :   /* Took too long to bisect.  Just return what we got. */   roots[0] = mid;d   return 1;    }a   DBL polyeval(x, n, Coeffs) DBL x, *Coeffs;  int n;   {i   register int i;*
   DBL val;   val = Coeffs[n];1   for (i=n-1;i>=0;i--) val = val * x + Coeffs[i];r
   return val;e   }p  . /* Close in on a root by using regula-falsa */( int regula_falsa(order, coef, a, b, val)
 int order;
 DBL *coef; DBL a, b, *val;u   {E
   int its;   DBL fa, fb, x, fx, lfx;n      fa = polyeval(a, order, coef);    fb = polyeval(b, order, coef);     if (fa * fb > 0.0)
     return 0;n     if (fabs(fa) < COEFF_LIMIT)      {t
     *val = a;r
     return 1;n     }m     if (fabs(fb) < COEFF_LIMIT)      { 
     *val = b;o
     return 1;t     }c     lfx = fa;e     COOPERATE -   for (its = 0; its < MAX_ITERATIONS; its++) e     { &     x = (fb * a - fa * b) / (fb - fa);"     fx = polyeval(x, order, coef);       if (fabs(x) > EPSILON)         {s"       if (fabs(fx / x) < EPSILON) 	         {          *val = x;7         return 1;.	         }m       } !     else if (fabs(fx) < EPSILON) t       {        *val = x;e       return 1;f       }i       if (fa < 0)        if (fx < 0)        {h       a = x;       fa = fx;       if ((lfx * fx) > 0)r         fb /= 2;       }        else r       {r       b = x;       fb = fx;       if ((lfx * fx) > 0)w         fa /= 2;       }e     else if (fx < 0) s       {g       b = x;       fb = fx;       if ((lfx * fx) > 0)          fa /= 2;       }a	     else f       {c       a = x;       fa = fx;       if ((lfx * fx) > 0)u         fb /= 2;       }a     if (fabs(b-a) < EPSILON) d       { -       /* Check for underflow in the domain */o       *val = x;t       return 1;f       } 
     lfx = fx;f     }g   return 0;.   }    /*     Solve the quadratic equation:)       		x[0] * x^2 + x[1] * x + x[2] = 0.   C    The value returned by this function is the number of real roots.)3    The roots themselves are returned in y[0], y[1].7 */ int solve_quadratic(x, y)3 DBL *x, *y;2   {    DBL d, t, a, b, c;   a = x[0];9   b = -x[1];   c = x[2];O   if (a == 0.0)      {      if (b == 0.0)t       return 0;      y[0] = c / b;R
     return 1;y     }    d = b * b - 4.0 * a * c;   if (d < 0.0)
     return 0;o"   else if (fabs(d) < COEFF_LIMIT)      {t     y[0] = 0.5 * b / a; 
     return 1;)     }t   d = sqrt(d);   t = 2.0 * a;   y[0] = (b + d) / t;n   y[1] = (b - d) / t;n   return 2;*   })   /*    Solve the cubic equation:  4       x[0] * x^3 + x[1] * x^2 + x[2] * x + x[3] = 0.  E    The result of this function is an integer that tells how many real)D    roots exist.  Determination of how many are distinct is up to theD    process that calls this routine.  The roots that exist are stored    in (y[0], y[1], y[2]).u  I    Note: this function relies very heavily on trigonometric functions andsK    the square root function.  If an alternative solution is found that does :    not rely on transcendentals this code will be replaced. */ int solve_cubic(x, y)  DBL *x, *y;    { %   DBL Q, R, Q3, R2, sQ, d, an, theta;    DBL A2, a0, a1, a2, a3;)   a0 = x[0];2   if (a0 == 0.0) return solve_quadratic(&x[1], y);   else if (a0 != 1.0)      {      a1 = x[1] / a0;      a2 = x[2] / a0;      a3 = x[3] / a0;      };   else j     {      a1 = x[1];     a2 = x[2];     a3 = x[3];     }>   A2 = a1 * a1;    Q = (A2 - 3.0 * a2) / 9.0;9   R = (2.0 * A2 * a1 - 9.0 * a1 * a2 + 27.0 * a3) / 54.0;    Q3 = Q * Q * Q; 
   R2 = R * R;[   d = Q3 - R2;   an = a1 / 3.0;   if (d >= 0.0)      {      /* Three real roots. */      d = R / sqrt(Q3);      theta = acos(d) / 3.0;     sQ = -2.0 * sqrt(Q);      y[0] = sQ * cos(theta) - an;+     y[1] = sQ * cos(theta + TWO_PI_3) - an;t,     y[2] = sQ * cos(theta + TWO_PI_43) - an;
     return 3;      }    else o     {o0     sQ = pow(sqrt(R2 - Q3) + ABS(R), 1.0 / 3.0);     if (R < 0)        y[0] = (sQ + Q / sQ) - an;     else!       y[0] = -(sQ + Q / sQ) - an;e
     return 1;      }z   }   @ /* Test to see if any coeffs are more than 6 orders of magnitude    larger than the smallest */
 static int difficult_coeffs(n, x) int n; DBL *x;    {    int i, flag = 0;   DBL t, biggest;t     biggest = fabs(x[0]);    for (i=1;i<=n;i++) -     {-     t = fabs(x[i]);      if (t > biggest)       biggest = t;     }   5   /* Everything is zero no sense in doing any more */p   if (biggest == 0.0) return 0;      for (i=0;i<=n;i++)     if (x[i] != 0.0)0       if (fabs(biggest / x[i]) > FUDGE_FACTOR1)        {        x[i] = 0.0;        flag = 1;r       }t     return flag;   }l   #ifdef TEST_SOLVER3 /* The old way of solving quartics algebraically */ K /* This is an adaptation of the method of Lodovico Ferrari (Circa 1731). */  int solve_quartic(x, results)a DBL *x, *results;i   {*   DBL cubic[4], roots[3];q    DBL a0, a1, y, d1, x1, t1, t2;%   DBL c0, c1, c2, c3, c4, d2, q1, q2;-   int i;  ;   /* Figure out the size difference between coefficients */    if (difficult_coeffs(4, x))      {o!     if (fabs(x[0]) < COEFF_LIMIT)o#       if (fabs(x[1]) < COEFF_LIMIT) /         return solve_quadratic(&x[2], results);|
       else+         return solve_cubic(&x[1], results);      else&       return polysolve(4, x, results);     }      c0 = x[0];   if (fabs(c0) < COEFF_LIMIT) '     return solve_cubic(&x[1], results); %   else if (fabs(x[4]) < COEFF_LIMIT) e     {*#     return solve_cubic(x, results);      };   else if (c0 != 1.0)      {;     c1 = x[1] / c0;c     c2 = x[2] / c0;l     c3 = x[3] / c0;;     c4 = x[4] / c0;O     }    else p     {(     c1 = x[1];     c2 = x[2];     c3 = x[3];     c4 = x[4];     }+  7     /* The first step is to take the original equation:(  # 	 x^4 + b*x^3 + c*x^2 + d*x + e = 0+         and rewrite it as:  ! 	 x^4 + b*x^3 = -c*x^2 - d*x - e,e  D       adding (b*x/2)^2 + (x^2 + b*x/2)y + y^2/4 to each side gives a        perfect square on the lhs:  G 	 (x^2 + b*x/2 + y/2)^2 = (b^2/4 - c + y)x^2 + (b*y/2 - d)x + y^2/4 - es  L       By choosing the appropriate value for y, the rhs can be made a perfectN       square also.  This value is found when the rhs is treated as a quadraticE       in x with the discriminant equal to 0.  This will be true when:n  9 	 (b*y/2 - d)^2 - 4.0 * (b^2/4 - c*y)*(y^2/4 - e) = 0, or   8 	 y^3 - c*y^2 + (b*d - 4*e)*y - b^2*e + 4*c*e - d^2 = 0.  ?       This is called the resolvent of the quartic equation.  */l       a0 = 4.0 * c4;   cubic[0] = 1.0;    cubic[1] = -1.0 * c2;n   cubic[2] = c1 * c3 - a0;.   cubic[3] = a0 * c2 - c1 * c1 * c4 - c3 * c3;(   i = solve_cubic(&cubic[0], &roots[0]);   if (i > 0)     y = roots[0];    else
     return 0;m  B   /* What we are left with is a quadratic squared on the lhs and aF       linear term on the right.  The linear term has one of two signs,G       take each and add it to the lhs.  The form of the quartic is now:e  C 	 a' = b^2/4 - c + y,    b' = b*y/2 - d, (from rhs quadritic above)d  : 	 (x^2 + b*x/2 + y/2) = +sqrt(a'*(x + 1/2 * b'/a')^2), and6 	 (x^2 + b*x/2 + y/2) = -sqrt(a'*(x + 1/2 * b'/a')^2).  E       By taking the linear term from each of the right hand sides and I       adding to the appropriate part of the left hand side, two quadratic G       formulas are created.  By solving each of these the four roots ofe!       the quartic are determined.     */a   i = 0;   a0 = c1 / 2.0;   a1 = y / 2.0;      t1 = a0 * a0 - c2 + y;   if (t1 < 0.0)      {-     if (t1 > FUDGE_FACTOR2)        t1 = 0.0;m	     else         { C       /* First Special case, a' < 0 means all roots are complex. */l         return 0;        }i     }s   if (t1 < FUDGE_FACTOR3)      {RE     /* Second special case, the "x" term on the right hand side abovet 	 has vanished.  In this case:- 		(x^2 + b*x/2 + y/2) = +sqrt(y^2/4 - e), andm- 		(x^2 + b*x/2 + y/2) = -sqrt(y^2/4 - e).  */      t2 = a1 * a1 - c4;     if (t2 < 0.0)        {i       return 0;        }e
     x1 = 0.0;d     d1 = sqrt(t2);     }&   else )     {      x1 = sqrt(t1);"     d1 = 0.5 * (a0 * y - c3) / x1;     } !   /* Solve the first quadratic */      q1 = -a0 - x1;   q2 = a1 + d1;    d2 = q1 * q1 - 4.0 * q2;   if (d2 >= 0.0) ]     {d     d2 = sqrt(d2);!     results[0] = 0.5 * (q1 + d2); !     results[1] = 0.5 * (q1 - d2);t
     i = 2;     }a"   /* Solve the second quadratic */   q1 = q1 + x1 + x1;   q2 = a1 - d1;    d2 = q1 * q1 - 4.0 * q2;   if (d2 >= 0.0) y     {r     d2 = sqrt(d2);#     results[i++] = 0.5 * (q1 + d2); #     results[i++] = 0.5 * (q1 - d2);l     }E   return i;    }  #else G   /* Solve a quartic using the method of Francois Vieta (Circa 1735) */r   int;   solve_quartic(x, results)      DBL *x, *results;s     {C     DBL cubic[4], roots[3];l(     DBL c12, z, p, q, q1, q2, r, d1, d2;     DBL c0, c1, c2, c3, c4; 
     int i;  =     /* Figure out the size difference between coefficients */o      if (difficult_coeffs(4, x))        { #       if (fabs(x[0]) < COEFF_LIMIT)f%         if (fabs(x[1]) < COEFF_LIMIT)o1           return solve_quadratic(&x[2], results);          else-           return solve_cubic(&x[1], results);7
       else(         return polysolve(4, x, results);       }x  1     /* See if the high order term has vanished */u     c0 = x[0];     if (fabs(c0) < COEFF_LIMIT)x)       return solve_cubic(&x[1], results);f  /     /* See if the constant term has vanished */ !     if (fabs(x[4]) < COEFF_LIMIT) %       return solve_cubic(x, results);x  @     /* Make sure the quartic has a leading coefficient of 1.0 */     if (c0 != 1.0)         {=       c1 = x[1] / c0;f       c2 = x[2] / c0;        c3 = x[3] / c0;f       c4 = x[4] / c0;;       }a	     else         {x       c1 = x[1];       c2 = x[2];       c3 = x[3];       c4 = x[4];       }   '       /* Compute the cubic resolvant */n       c12 = c1 * c1;     p = -0.375 * c12 + c2;.     q = 0.125 * c12 * c1 - 0.5 * c1 * c2 + c3;J     r = -0.01171875 * c12 * c12 + 0.0625 * c12 * c2 - 0.25 * c1 * c3 + c4;       cubic[0] = 1.0;t     cubic[1] = -0.5 * p;     cubic[2] = -r;+     cubic[3] = 0.5 * r * p - 0.125 * q * q;i"     i = solve_cubic(cubic, roots);     if (i > 0)       z = roots[0];      else       return 0;9       d1 = 2.0 * z - p;]       if (d1 < 0.0)        {        if (d1 > -EPSILON)         d1 = 0.0;=
       else         return 0;        }      if (d1 < EPSILON)        {)       d2 = z * z - r;e       if (d2 < 0.0)L         return 0;        d2 = sqrt(d2);       }n	     else t       {q       d1 = sqrt(d1);       d2 = 0.5 * q / d1;       }(  :       /* Set up useful values for the quadratic factors */       q1 = d1 * d1;*     q2 = -0.25 * c1;
     i = 0;  #     /* Solve the first quadratic */n     p = q1 - 4.0 * (z - d2);     if (p == 0)o$       results[i++] = -0.5 * d1 - q2;     else if (p > 0)        {o       p = sqrt(p);*       results[i++] = -0.5 * (d1 + p) + q2;*       results[i++] = -0.5 * (d1 - p) + q2;       }r$     /* Solve the second quadratic */     p = q1 - 4.0 * (z + d2);     if (p == 0)a#       results[i++] = 0.5 * d1 - q2;d     else if (p > 0)        {n       p = sqrt(p);)       results[i++] = 0.5 * (d1 + p) + q2;B)       results[i++] = 0.5 * (d1 - p) + q2;,       }a
     return i;0     }2 #endif  @ /* Root solver based on the Sturm sequences for a polynomial. */# int polysolve(order, Coeffs, roots)=
 int order; DBL *Coeffs, *roots;   {    polynomial sseq[MAX_ORDER+1];j   DBL min_value, max_value; "   int i, nroots, np, atmin, atmax;  7   /* Put the coefficients into the top of the stack. */*   for (i=0;i<=order;i++)&     sseq[0].coef[order-i] = Coeffs[i];      /* Build the Sturm sequence */#   np = buildsturm(order, &sseq[0]);   -   /* Get the total number of visible roots */t>   if ((nroots = visible_roots(np, sseq, &atmin, &atmax)) == 0)
     return 0;o     /* Bracket the roots */    min_value = 0.0;   max_value = Max_Distance;o  *   atmin = numchanges(np, sseq, min_value);*   atmax = numchanges(np, sseq, max_value);   nroots = atmin - atmax;;   if (nroots == 0) return 0;     /* perform the bisection. */F   return sbisect(np, sseq, min_value, max_value, atmin, atmax, roots);   }s  H #ifdef TEST     /* This is not used anywhere or tested.  Interesting? */   #define MAX_POLYGON_SIDES 8_H #define Crossing_Point(x1, y1, x2, y2) (x1 - y1 * (x2 - x1) / (y2 - y1))  T /* See if "Ray" intersects the polygon defined by the coordinate list "vertices". */P int Intersect_Polygon(Ray, vertex_count, vertices, n, d, Depth, Intersect_Point)	 RAY *Ray;n int vertex_count;i' VECTOR *vertices, *n, *Intersect_Point;= DBL d, *Depth;   {!   DBL s, t, x, y, z;(   int Sign_Holder, Next_Sign, Crossings;"   int i, this_vertex, next_vertex;  '   static DBL temp_x[MAX_POLYGON_SIDES],i   temp_y[MAX_POLYGON_SIDES];  :   /* Calculate the point of intersection and the depth. */   VDot(s, Ray->Direction, *n);   if (s == 0.0)1
     return 0;v   VDot(t, Ray->Initial, *n);   *Depth = 0.0 - (d + t) / s;[   if (*Depth < Small_Tolerance)d
     return 0; 3   VScale(*Intersect_Point, Ray->Direction, *Depth); 9   VAdd(*Intersect_Point, *Intersect_Point, Ray->Initial);   A   /* Map the intersection point and the triangle onto a plane. */M.   x = ABS(n->x); y = ABS(n->y); z = ABS(n->z);
   if (x>y)     if (x>z)#       for (i=0;i<vertex_count;i++)       {n3     temp_x[i] = vertices[i].y - Intersect_Point->y;n3     temp_y[i] = vertices[i].z - Intersect_Point->z;      }s   else!     for (i=0;i<vertex_count;i++) c     { 3     temp_x[i] = vertices[i].x - Intersect_Point->x; 3     temp_y[i] = vertices[i].y - Intersect_Point->y;      }    else if (y>z) !     for (i=0;i<vertex_count;i++) x     {03     temp_x[i] = vertices[i].x - Intersect_Point->x; 3     temp_y[i] = vertices[i].z - Intersect_Point->z;      }x   else!     for (i=0;i<vertex_count;i++) f     {e3     temp_x[i] = vertices[i].x - Intersect_Point->x; 3     temp_y[i] = vertices[i].y - Intersect_Point->y;      }       /* Determine crossing count */   Crossings = 0;&   if (temp_y[0] < 0) Sign_Holder = -1;   else Sign_Holder = 1;e  !     for (i=0;i<vertex_count;i++) ^     {2@     /* Start of winding tests, test the segment from v1 to v2 */     this_vertex = i;)     next_vertex = (i + 1) % vertex_count;q0     if (temp_y[next_vertex] < 0) Next_Sign = -1;     else Next_Sign = 1; "     if (Sign_Holder != Next_Sign)        {s%       if (temp_x[this_vertex] > 0.0)  	         {2&         if (temp_x[next_vertex] > 0.0)           Crossings++;I         else if (Crossing_Point(temp_x[this_vertex], temp_y[this_vertex],r:           temp_x[next_vertex], temp_y[next_vertex]) > 0.0)           Crossings++;	         }[*       else if (temp_x[next_vertex] > 0.0) 	         { D         if (Crossing_Point(temp_x[this_vertex], temp_y[this_vertex],:           temp_x[next_vertex], temp_y[next_vertex]) > 0.0)           Crossings++;	         }n       Sign_Holder = Next_Sign;       }r     }T  @   return (Crossings&1); /* Inside only if # of crossings odd. */   }h  : /* Translate screen coordinates into world coordinates. */; void World_Coordinate (Viewpoint, Ray, width, height, x, y)x VIEWPOINT *Viewpoint; 	 RAY *Ray;a int width, height;	 DBL x, y;2   {s   DBL scalex, scaley;)   VECTOR V1, V2;  =   /* Convert the X Coordinate to be a DBL from -0.5 to 0.5 */ /   scalex = (x - (DBL)width / 2.0) / (DBL)width; =   /* Convert the Y Coordinate to be a DBL from -0.5 to 0.5 */aG   scaley = (((DBL)(height - 1) - y) - (DBL)height / 2.0) / (DBL)height;aD   /* Compute the direction of the screen point from the viewpoint */%   VScale (V1, Viewpoint->Up, scaley);((   VScale (V2, Viewpoint->Right, scalex);    VAdd (Ray->Direction, V1, V2);>   VAdd (Ray->Direction, Ray->Direction, Viewpoint->Direction);.   VNormalize (Ray->Direction, Ray->Direction);   }3B /* Uncomment these two declarations if your compiler needs them */A /* They give Microsoft C an out of macro expansion space error */2N /* void show_univariate_poly PARAMS((char *label, int order,DBL *Coeffs));  */G /* void show_points PARAMS((char *label,int count,DBL *point_list);  */   / void show_univariate_poly(label, order, Coeffs)l char *label;
 int order; DBL *Coeffs;   {5   int i;   printf("%s", label);   for (i=0;i<=order;i++) c     { -     printf("%.2lf x^%d", Coeffs[i], order-i);      if (i==order) printf("\n");]     else printf(" + ");2     }    }t  ,   void show_points(label, count, point_list)     char *label;
 int count; DBL *point_list;   {n   int i;   printf("%s", label);   for (i=0;i<count;i++)      { !     printf("%lf", point_list[i]); #     if (i==(count-1)) printf("\n");t     else printf(", ");     }    }t   #endif