M /****************************************************************************  *                xwind.c * M *  This file contains the XWindows code for the display-as-you-trace feature.  * ' *  from Persistence of Vision Raytracer , *  Copyright 1993 Persistence of Vision TeamL *---------------------------------------------------------------------------I *  NOTICE: This source code file is provided so that users may experiment K *  with enhancements to POV-Ray and to port the software to platforms other J *  than those supported by the POV-Ray Team.  There are strict rules underG *  which you are permitted to use this file.  The rules are in the file D *  named POVLEGAL.DOC which should be distributed with this file. IfL *  POVLEGAL.DOC is not available or for more info please contact the POV-RayM *  Team Coordinator by leaving a message in CompuServe's Graphics Developer's D *  Forum.  The latest version of POV-Ray may be found there as well. * B * This program is based on the popular DKB raytracer version 2.12.3 * DKBTrace was originally written by David K. Buck. I * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  * N *****************************************************************************/  P /******************************************************************************/P /*                                                                            */P /* X Windows code for POV-Ray.                                                */P /* Written by Christopher J. Cason.                                           */P /* CIS 100032,1644                                                            */P /* Internet 100032.1644@compuserve.com                                        */P /*                                                                            */P /******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /* Original IBM VGA "colour" output routines for MS/DOS by Aaron A. Collins.  */P /*                                                                            */P /* Converted for X Windows and arbitrary #of colours by Christopher J. Cason. */P /*                                                                            */P /* This will deliver approximate colorings using HSV values for the selection.*/P /* The palette map is divided into 4 parts - upper and lower half generated   */P /* with full and half "value" (intensity), respectively.  These halves are    */P /* further halved by full and half saturation values of each range (pastels). */P /* There are three constant colors, black, white, and grey.  They are used    */P /* when the saturation is low enough that the hue becomes undefined, and which*/P /* one is selected is based on a simple range map of "value".  Usage of the   */P /* palette is accomplished by converting the requested color RGB into an HSV  */P /* value.  If the saturation is too low (< .25) then black, white or grey is  */P /* selected.  If there is enough saturation to consider looking at the hue,   */P /* then the hue range of 1-63 is scaled into one of the 4 palette quadrants   */P /* based on its "value" and "saturation" characteristics.                     */P /*                                                                            */P /******************************************************************************/  P /******************************************************************************/P /*                                                                            */P /* define X_GETS_ARGS if you want to use X options such as '-display xxx:n.n' */P /*                                                                            */P /******************************************************************************/   #define DBL             double! #define NAME            "POV-Ray"    #include <stdio.h> #include <math.h>  #include <x11/xlib.h>  #include <x11/xutil.h> #include <x11/stringdefs.h>  #include <x11/intrinsic.h> #include <x11/shell.h> #include "config.h"    #define MIN_COLOURS     128  #define MAX_COLOURS     256   / #define min(x,y)        ((x) < (y) ? (x) : (y)) / #define max(x,y)        ((x) > (y) ? (x) : (y))   P char                    filename [192] ;              /* don't really need it */P unsigned                gWidth ;                      /* +wxxx                */P unsigned                gHeight ;                     /* +hyyy                */P unsigned                gScreenNumber ;               /* screen number        */P unsigned                nColours ;                    /* colours available    */P unsigned                quarterPalette ;              /* 1/4 of nColours      */P unsigned                CooperationLevel = 5 ;        /* for message loop     */P unsigned                screenWidth ;                 /* of root screen       */P unsigned                screenHeight ;                /* ditto                */P unsigned long           gColours [MAX_COLOURS] ;      /* colour lookup        */> int			gDepth ;                      /* default screen depth */P GC                      gGc ;                         /* graphics context     */P Screen                  *gScreen ;                    /* the X screen         */P XImage                  *gXimage = NULL ;             /* to buffer the trace  */P Widget                  gParent ;                     /* parent widget        */P Widget                  gPopupwindow ;                /* trace displayed here */P Window                  gWindow ;                     /* child of gPopupWin.. */P Display                 *gDisplay ;                   /* X display connection */P Colormap                gColourmap ;                  /* the colourmap        */P XtAppContext            gAppcontext ;                 /* application context  */  P /* in POVRAY.C                                                                */2 unsigned alt_main (unsigned argc, char *argv []) ;  P /******************************************************************************/P /*                                                                            */P /* set a pixel in an XImage                                                   */P /*                                                                            */P /******************************************************************************/  n void SetPixel (Display *display, XImage *ximage, Window window, GC gc, unsigned x, unsigned y, unsigned index) { #   static unsigned       lastY = 0 ;      if (lastY > y) lastY = y ;   if (y != lastY)    { P     /* for efficiency, only display the pixels after a full line is buffered  */L     XPutImage (display, window, gc, ximage, 0, lastY, 0, lastY, gWidth, 1) ;     lastY = y ;    } .   XPutPixel (ximage, x, y, gColours [index]) ; }   P /******************************************************************************/P /*                                                                            */P /* create an XImage                                                           */P /*                                                                            */P /******************************************************************************/  7 XImage *CreateXImage (Display *display, Visual *visual, F                       unsigned depth, unsigned width, unsigned height) {    unsigned    format ;   unsigned    number_of_bytes ;    XImage      *ximage ;   ,   format = depth == 1 ? XYBitmap : ZPixmap ;  8   ximage = XCreateImage (display, visual, depth, format,K                          0, NULL, width, height, XBitmapPad (display), 0) ;   %   if (ximage == NULL) return (NULL) ;   =   number_of_bytes = ximage->bytes_per_line * ximage->height ; H   if ((ximage->data = malloc (number_of_bytes)) == NULL) return (NULL) ;   return (ximage) ;  }   P /******************************************************************************/P /*                                                                            */P /* create an XImage to be compatible with the supplied widget                 */P /*                                                                            */P /******************************************************************************/  O XImage *CreateXImageFromWidget (Widget widget, unsigned width, unsigned height)  {    unsigned    depth ;    XImage      *ximage ;    Visual      *visual ;    Display     *display ;  F   XtVaGetValues (widget, XtNdepth, &depth, XtNvisual, &visual, NULL) ;    display = XtDisplay (widget) ;A   ximage = CreateXImage (display, visual, depth, width, height) ;    return (ximage) ;  }   P /******************************************************************************/P /*                                                                            */P /* make an XImage given a widget, width and height                            */P /*                                                                            */P /******************************************************************************/  B XImage *MakeImage (Widget widget, unsigned width, unsigned height) {    unsigned              x ;    unsigned              y ; !   XImage                *ximage ;   H   if ((ximage = CreateXImageFromWidget (widget, width, height)) != NULL)   { !     for (x = 0 ; x < width ; x++) $       for (y = 0 ; y < height ; y++)0         XPutPixel (ximage, x, y, gColours [0]) ;   }      return (ximage) ;  }   P /******************************************************************************/P /*                                                                            */P /* redraw the traced data using the XImage                                    */P /*                                                                            */P /******************************************************************************/  ) void processExpose (XExposeEvent *expose)  { ;   if (gXimage == NULL || (void *) gWindow == NULL) return ; -   XPutImage (gDisplay, gWindow, gGc, gXimage, "              expose->x, expose->y,"              expose->x, expose->y,-              expose->width, expose->height) ;  }   P /******************************************************************************/P /*                                                                            */P /* this is called by the COOPERATE macro from within POVRAY                   */P /*                                                                            */P /******************************************************************************/   void XTraceEventHandler (void) {    XEvent                event ; 1   static unsigned       cooperationCounter = 10 ;   =   if (CooperationLevel < 10 && --cooperationCounter) return ; .   cooperationCounter = 11 - CooperationLevel ;     if (CooperationLevel > 5)    { +     /* loop until all messages retrieved */ &     while (XtAppPending (gAppcontext))     { ,       XtAppNextEvent (gAppcontext, &event) ;B       if (event.type == Expose && event.xexpose.window == gWindow)       { F         if (event.xexpose.count == 0) processExpose (&event.xexpose) ;         return ;       }         XtDispatchEvent (&event) ;     }    }    else   {      /* only process 1 event */#     if (XtAppPending (gAppcontext))      { ,       XtAppNextEvent (gAppcontext, &event) ;B       if (event.type == Expose && event.xexpose.window == gWindow)       { F         if (event.xexpose.count == 0) processExpose (&event.xexpose) ;         return ;       }         XtDispatchEvent (&event) ;     }    }  }   P /******************************************************************************/P /*                                                                            */P /* called if the user closes the popup window during a trace                  */P /*                                                                            */P /******************************************************************************/    void destroyProc (Widget widget) {    XDestroyImage (gXimage) ;    XFreeGC (gDisplay, gGc) ;    gPopupwindow = NULL ;  }   P /******************************************************************************/P /*                                                                            */P /* create a popup window, centered on the screen                              */P /*                                                                            */P /******************************************************************************/  m Widget CreatePopupWindow (Widget parent, char *name, unsigned width, unsigned height, void (*destroyProc) ())  {    int         n ;    unsigned    x = 0 ;    unsigned    y = 0 ;    Arg         args [8] ;   Widget      window ;  	   n = 0 ;    if (width < screenWidth)%     x = screenWidth / 2 - width / 2 ;    if (height < screenHeight)'     y = screenHeight / 2 - height / 2 ; .   XtSetArg (args [n], XtNwidth, width) ; n++ ;0   XtSetArg (args [n], XtNheight, height) ; n++ ;&   XtSetArg (args [n], XtNx, x) ; n++ ;&   XtSetArg (args [n], XtNy, y) ; n++ ;Q   window = XtCreatePopupShell (name, topLevelShellWidgetClass, parent, args, n) ; C   XtAddCallback (window, XtNdestroyCallback, destroyProc, window) ;    return (window) ;  }   P /******************************************************************************/P /*                                                                            */P /* allocate a colour based on the RGB values and place it at index            */P /*                                                                            */P /******************************************************************************/  N void set_palette (unsigned index, unsigned red, unsigned green, unsigned blue) {    XColor      colour ;  #   colour.pixel = gColours [index] ; +   colour.flags = DoRed | DoGreen | DoBlue ; $   colour.red = (65535 * red) / 256 ;&   colour.blue = (65535 * blue) / 256 ;(   colour.green = (65535 * green) / 256 ;/   XStoreColor (gDisplay, gColourmap, &colour) ;  }   P /******************************************************************************/P /*                                                                            */P /* Conversion from Hue, Saturation, Value to Red, Green, and Blue and back    */P /* From "Computer Graphics", Donald Hearn & M. Pauline Baker, p. 304          */P /* Extracted from the POV machine specific file IBM.C and modified for X      */P /*                                                                            */P /* See the start of this file for information as to how this code works       */P /*                                                                            */P /******************************************************************************/  N void hsv_to_rgb (DBL hue, DBL s, DBL v, unsigned *r, unsigned *g, unsigned *b) {    DBL         i ;    DBL         f ;    DBL         p1 ;   DBL         p2 ;   DBL         p3 ;   DBL         xh ;   DBL         nr ;   DBL         ng ;   DBL         nb ;     if (hue == 360.0) hue = 0.0 ;   A   xh = hue / 60.0 ;               /* convert hue to be in 0..6 */ A   i = floor (xh) ;                /* i = greatest integer <= h */ A   f = xh - i ;                    /* f = fractional part of h  */    p1 = v * (1 - s) ;   p2 = v * (1 - (s * f)) ;    p3 = v * (1 - (s * (1 - f))) ;     switch ((int) i)   {      case 0 :          nr = v ;           ng = p3 ;          nb = p1 ;          break ;       case 1 :          nr = p2 ;          ng = v ;           nb = p1 ;          break ;       case 2 :          nr = p1 ;          ng = v ;           nb = p3 ;          break ;       case 3 :          nr = p1 ;          ng = p2 ;          nb = v ;           break ;       case 4 :          nr = p3 ;          ng = p1 ;          nb = v ;           break ;       case 5 :          nr = v ;           ng = p1 ;          nb = p2 ;          break ;  
     default :           nr = ng = nb = 0 ;    }     *r = (unsigned) (nr * 255.0) ;    *g = (unsigned) (ng * 255.0) ;    *b = (unsigned) (nb * 255.0) ; }   L void rgb_to_hsv (unsigned r, unsigned g, unsigned b, DBL *h, DBL *s, DBL *v) {*   DBL         m ;*   DBL         r1 ;   DBL         g1 ;   DBL         b1 ;   DBL         nr ;   DBL         ng ;   DBL         nb ;   DBL         nh = 0.0 ;   DBL         ns = 0.0 ;   DBL         nv ;     nr = (DBL) r / 255.0 ;   ng = (DBL) g / 255.0 ;   nb = (DBL) b / 255.0 ;     nv = max (nr, max (ng, nb)) ;T   m = min (nr, min (ng, nb)) ;  %   if (nv != 0.0) ns = (nv - m) / nv ;n     if (ns == 0.0)   { (     /* hue undefined if no saturation */     *h = 0.0 ;     *s = 0.0 ;
     *v = nv ;h     return ;   }s  D   r1 = (nv - nr) / (nv - m) ;     /* distance of color from red   */D   g1 = (nv - ng) / (nv - m) ;     /* distance of color from green */D   b1 = (nv - nb) / (nv - m) ;     /* distance of color from blue  */     if (nv == nr)    {      if (m == ng)       nh = 5.0 + b1 ;S     else       nh = 1.0 - g1 ;F   }      if (nv == ng)    {V     if (m == nb)       nh = 1.0 + r1 ;h     else       nh = 3.0 - b1 ;r   }r     if (nv == nb)1   {      if (m == nr)       nh = 3.0 + g1 ;K     else       nh = 5.0 - r1 ;    }w  E   *h = nh * 60.0 ;                /* return h converted to degrees */*   *s = ns ;*   *v = nv ;* }*  P /******************************************************************************/P /*                                                                            */P /* set up the X palette                                                       */P /* try to allocate at least as many colours as MIN_COLOURS                    */P /* exit with an error if we cannot get at least this many                     */P /* divide the available colour up into four quadrants, and divide each        */P /* quadrant up into specific hues from 0 to 359 degrees                       */P /*                                                                            */P /******************************************************************************/   void palette_init (void) {    unsigned    m ;    unsigned    r ;    unsigned    g ;    unsigned    b ;O   DBL         hue ;u   DBL         sat ;r   DBL         val ;o  E   for (nColours = MAX_COLOURS ; nColours >= MIN_COLOURS ; nColours--) T     if (XAllocColorCells (gDisplay, gColourmap, False, NULL, 0, gColours, nColours))
       break ;    if (nColours < MIN_COLOURS)    { G     printf ("failed to allocate colour cells needed for display\r\n") ;a     exit (1) ;   }V  !   quarterPalette = nColours / 4 ;p  0   /* for the first quarter of the palette ... */(   for (m = 1 ; m < quarterPalette ; m++)   {l     /* normalise to 360 */6     hue = 360.0 * ((DBL) (m)) / (DBL) quarterPalette ;,     hsv_to_rgb (hue, 0.5, 0.5, &r, &g, &b) ;     set_palette (m, r, g, b) ;  6     hue = 360.0 * ((DBL) (m)) / (DBL) quarterPalette ;,     hsv_to_rgb (hue, 1.0, 0.5, &r, &g, &b) ;/     set_palette (m + quarterPalette, r, g, b) ;e  6     hue = 360.0 * ((DBL) (m)) / (DBL) quarterPalette ;,     hsv_to_rgb (hue, 0.5, 1.0, &r, &g, &b) ;3     set_palette (m + quarterPalette * 2, r, g, b) ;e  6     hue = 360.0 * ((DBL) (m)) / (DBL) quarterPalette ;,     hsv_to_rgb (hue, 1.0, 1.0, &r, &g, &b) ;3     set_palette (m + quarterPalette * 3, r, g, b) ;*   }   F   set_palette (0, 0, 0, 0) ;                        /* black        */F   set_palette (quarterPalette, 255, 255, 255) ;     /* white        */F   set_palette (quarterPalette * 2, 128, 128, 128) ; /* dark grey    */F   set_palette (quarterPalette * 3, 192, 192, 192) ; /* light grey   */ }*  P /******************************************************************************/P /*                                                                            */P /* display code called directly by POV-Ray via [machine-name].C               */P /*                                                                            */P /******************************************************************************/   void x_display_finished () {n }B  5 void x_display_init (unsigned width, unsigned height)  {i   unsigned              n ;a   unsigned              y = 0 ;i   unsigned              x = 0 ;1   unsigned long         white ;n   unsigned long         black ;>#   Arg                   args [20] ;_  "   gDisplay = XtDisplay (gParent) ;    gScreen = XtScreen (gParent) ;3   gScreenNumber = XScreenNumberOfScreen (gScreen) ;(2   gColourmap = DefaultColormapOfScreen (gScreen) ;+   gDepth = DefaultDepthOfScreen (gScreen) ;e8   screenWidth = DisplayWidth (gDisplay, gScreenNumber) ;:   screenHeight = DisplayHeight (gDisplay, gScreenNumber) ;  0   white = WhitePixel (gDisplay, gScreenNumber) ;0   black = BlackPixel (gDisplay, gScreenNumber) ;  	   n = 0 ;r$   x = screenWidth / 2 - gWidth / 2 ;&   y = screenHeight / 2 - gHeight / 2 ;&   XtSetArg (args [n], XtNx, x) ; n++ ;&   XtSetArg (args [n], XtNy, y) ; n++ ;"   XtSetValues (gParent, args, n) ;     gWidth = width ;   gHeight = height ;P   gPopupwindow = CreatePopupWindow (gParent, NAME, width, height, destroyProc) ;  "   XtRealizeWidget (gPopupwindow) ;   XtMapWidget (gPopupwindow) ;  k   gWindow = XCreateSimpleWindow (gDisplay, XtWindow (gPopupwindow), 0, 0, width, height, 0, white, black) ;p3   XSetWindowBackground (gDisplay, gWindow, black) ;f"   XMapWindow (gDisplay, gWindow) ;.   XtPopup (gPopupwindow, XtGrabNonexclusive) ;     if (gDepth != 24)e     palette_init () ;c  1   gGc = XCreateGC (gDisplay, gWindow, 0L, NULL) ; 5   gXimage = MakeImage (gPopupwindow, width, height) ;*  ?   /* draw a rectangle into the XImage to show trace progress */      for (x = 0 ; x < width ; x++)    {i&     XPutPixel (gXimage, x, 0, white) ;/     XPutPixel (gXimage, x, height - 1, white) ;    }       for (y = 0 ; y < height ; y++)   {c&     XPutPixel (gXimage, 0, y, white) ;.     XPutPixel (gXimage, width - 1, y, white) ;   }n  2   XSelectInput (gDisplay, gWindow, ExposureMask) ; }    void x_display_close ()  {    if (gPopupwindow) $     XtDestroyWidget (gPopupwindow) ; }p  M void x_display_plot (unsigned x, unsigned y, char Red, char Green, char Blue)  {    static int lastY = 0;n   unsigned    colour ;   DBL         h ;;   DBL         s ;*   DBL         v ;*   char *offset;*   int  *ptr, pixel;*  $   if (gPopupwindow == NULL) return ;     if (gDepth == 24)      {         if (lastY > y) lastY = y ;       if (y != lastY) 	         { \           XPutImage (gDisplay, gWindow, gGc, gXimage, 0, lastY, 0, lastY, gWidth, gHeight) ;           lastY = y ;*	         }*L       offset  = gXimage->data + ( (gXimage->bytes_per_line * y) + (4 * x) );,       pixel  =  ((Blue  << 16) & 0xFF0000) | 		((Green << 8)  & 0x00ff00) | 		(Red          & 0x0000FF);       ptr = (int *)offset;       *ptr++ = pixel;l       * /*    XPutPixel (gXimage, x, y, pixel); */  
       return;p     }   N   rgb_to_hsv ((unsigned) Red, (unsigned) Green, (unsigned) Blue, &h, &s, &v) ;  K   if (s < 0.20)         /* black or white if no saturation of colour ... */g   {      if (v < 0.25))4       colour = 0 ;                  /* black      */     else if (v > 0.8)*4       colour = quarterPalette ;     /* white      */     else if (v > 0.5) 4       colour = quarterPalette * 3 ; /* light grey */     else4       colour = quarterPalette * 2 ; /* dark grey  */   }    else   { <     colour = (unsigned) ((DBL) quarterPalette * h / 360.0) ;       if (colour == 0)M       colour = 1 ;                   /* avoid black, white or grey         */y        if (colour > quarterPalette)M       colour = quarterPalette ;      /* avoid same                         */t       if (v > 0.50)bM       colour += quarterPalette * 2 ; /* colours 128-255 for high intensity */Z  M     if (s > 0.50)                    /* more than half saturated ?         */ M       colour += quarterPalette ;     /* colour range 64-128 or 192-255     */e   }U  P   /* only displays after a full line is received (the Y co-ordinate changes)  */<   SetPixel (gDisplay, gXimage, gWindow, gGc, x, y, colour) ; }r  P /******************************************************************************/P /*                                                                            */P /* our main routine. when XWIND is linked in this is main () for POV-Ray      */P /*                                                                            */P /******************************************************************************/  " int main (int argc, char *argv []) {I   unsigned              n ;(#   int                   count = 0 ;e#   Arg                   args [20] ;   3   strncpy (filename, argv [0], sizeof (filename)) ;   	   n = 0 ;d:   XtSetArg (args [n], XtNmappedWhenManaged, False) ; n++ ;9   XtSetArg (args [n], XtNallowShellResize, False) ; n++ ; +   XtSetArg (args [n], XtNwidth, 10) ; n++ ;,,   XtSetArg (args [n], XtNheight, 10) ; n++ ;  P /* define X_GETS_ARGS if you want to use X options such as '-display xxx:n.n' */   #ifdef X_GETS_ARGSW   gParent = XtAppInitialize (&gAppcontext, NAME, NULL, 0, &argc, argv, NULL, args, n) ;g #elsetX   gParent = XtAppInitialize (&gAppcontext, NAME, NULL, 0, &count, NULL, NULL, args, n) ; #endif     /* call POV-Ray ! */   alt_main (argc, argv) ;*   return (0) ; }*