) /* qi_query - module for query command */ % /* Bruce Tanner - Cerritos College */     P /* 1993/09/14 - JLW@psulias.psu.edu fixed misextracted ATTR byte in display_id()N                                     that caused sequence numbers to spill over@                                     into ATTR                 */    #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <ctype.h> #include <ssdef.h> #include <descrip.h> #include <psldef.h>  #include <starlet.h> #include <str$routines.h>  #include <lib$routines.h>  #define define_field_attributes  #include "qi.h"      typedef struct rstruct {     int element;     int field;     unsigned long int id; 	 } Result;   1 extern void respond(context *, int, char *, ...); + extern void swrite(context *, char *, ...); + extern char *new_string(context *, char *); ? extern Arg *make_arg(context *, char *, int, char *, int, int);  extern void free_args(Arg *); / extern void qilog(context *, int, char *, ...); 0 extern void *my_realloc(context *, void *, int);& extern void *check(context *, void *);# extern char *lc(context *, char *);  extern void chop(char *);  extern int is_local(context *); ) extern Arg *parse_cmd(char *, context *); * extern char *soundex(char *, char *, int);  extern void crypt_start(char *);% extern char *decrypt(char *, char *); = extern void init_dsc(struct dsc$descriptor_s *, char *, int); & extern int strcasecmp(char *, char *);, extern int strncasecmp(char *, char *, int);   int get_rec(struct RAB *);     /* get field given id */G char *get_field(context *ctx, int id, char *field, int seq, int unlock)  {      int status;   P     sprintf(ctx->dat_key, "%0*d%s%0*d", ctx->id_size, id, field, SEQ_SIZE, seq);&     ctx->datrab.rab$b_rac = RAB$C_KEY;(     ctx->datrab.rab$b_krf = PRIMARY_KEY;9     ctx->datrab.rab$l_rop = 0;          /* exact match */ 1     ctx->datrab.rab$b_ksz = strlen(ctx->dat_key);      if (DEBUG)9         swrite(ctx, "get_field lookup %s", ctx->dat_key);   #     status = get_rec(&ctx->datrab);      if (unlock) "         sys$release(&ctx->datrab);     if ((status & 1) == 0) {         if (DEBUG)J             swrite(ctx, "get_field doesn't find field %s, status %d (%X)",*                    field, status, status);         return NULL;     } M     ctx->dat_record[ctx->datrab.rab$w_rsz] = '\0';  /* terminate string */    G     if (strncmp(ctx->dat_key, ctx->dat_record, strlen(ctx->dat_key))) {          if (DEBUG)D             swrite(ctx, "get field finds wrong record %s status %X",,                    ctx->dat_record, status);         return NULL;     }      if (DEBUG)=         if (ctx->fields[atoi(field)].attrib & ATTR_ENCRYPTED) E             swrite(ctx, "get_field finds encrypted field %s", field);          elseF             swrite(ctx, "get_field finds field %s value %s status %X",3                    field, ctx->dat_record, status); +     return (ctx->dat_record + DAT_OH_SIZE);  }     . /* get field given another field/value pair */R char *get_value(context *ctx, char *key, char *in_field, char *out_field, int seq) { 
     char *cp;      int status, id;   &     ctx->idxrab.rab$b_rac = RAB$C_KEY;;     ctx->idxrab.rab$l_rop = 0;            /* exact match */ @     ctx->idxrab.rab$b_ksz = ctx->keyword_size + ctx->field_size;3     chop(key);          /* strip trailing spaces */ R     sprintf(ctx->idx_key, "%-*s%s", ctx->keyword_size, cp=lc(ctx, key), in_field);
     free(cp);        if (DEBUG)9         swrite(ctx, "get_value lookup %s", ctx->idx_key); #     status = get_rec(&ctx->idxrab);      sys$release(&ctx->idxrab);     if ((status & 1) == 0) {         if (DEBUG)[             swrite(ctx, "get_value doesn't find key %s status = %d", ctx->idx_key, status);          return NULL;     }      if (DEBUG)B         swrite(ctx, "get_value finds record %s", ctx->idx_record);E     id = atoi(ctx->idx_record + ctx->keyword_size + ctx->field_size); )     if (strcmp(out_field, ID_FIELD) == 0) G         return (ctx->idx_record + ctx->keyword_size + ctx->field_size);      else8         return get_field(ctx, id, out_field, seq, True); }     + /* find index that exactly matches query */ 4 int find_exact(context *ctx, char *query, int field) { 
     char *cp;      int status;   &     ctx->idxrab.rab$b_rac = RAB$C_KEY;B     ctx->idxrab.rab$l_rop = 0;            /* set up exact match */@     ctx->idxrab.rab$b_ksz = ctx->keyword_size + ctx->field_size;;     chop(query);                /* strip trailing spaces */ O     if (field == atoi(SOUNDEX_FIELD))         /* soundex field means convert */ N         soundex(query, query, SOUNDEX_SIZE);  /* and store soundex in query */  X     sprintf(ctx->idx_key, "%-*s%0*d", ctx->keyword_size, query, ctx->field_size, field);  #     status = get_rec(&ctx->idxrab);      sys$release(&ctx->idxrab);     if (DEBUG)=         swrite(ctx, "exact match returns status %d", status);      return (status & 1); }     2 /* find index that starts with the query string */5 int find_approx(context *ctx, char *query, int field)  {      int status; 
     char *cp;   &     ctx->idxrab.rab$b_rac = RAB$C_KEY;Q     ctx->idxrab.rab$l_rop = RAB$M_KGE;     /* set up approximate generic match */ @     ctx->idxrab.rab$b_ksz = strlen(query); /* actual key size */<     sprintf(ctx->idx_key, "%-*s", ctx->keyword_size, query);  =     if (strlen(query) == 0)   /* special case of query '*' */ O         ctx->idxrab.rab$b_ksz = 1; /* idx_key is spaces, make legal key size */   #     status = get_rec(&ctx->idxrab);      sys$release(&ctx->idxrab);     if ((status & 1) == 0) {         if (DEBUG)A             swrite(ctx,"approx match returns status %d", status);          return (status & 1);     } D     /* this should always find something, is it the right record? */%     status = ((strlen(query) == 0) || E               (strncmp(ctx->idx_record, query, strlen(query)) == 0));      if (DEBUG);         swrite(ctx, "approx match finds %s and returns %d", )                 ctx->idx_record, status);      return status; }                 /* find soundex match */7 int find_soundex(context *ctx, char *query, int *field)  {      int status;   8     /* ensure only name field is searched for soundex */%     if (*field != atoi(NAME_FIELD)) {          if (DEBUG)B             swrite(ctx, "soundex match rejects field %d", *field);         return 0;      }   !     *field = atoi(SOUNDEX_FIELD); &     ctx->idxrab.rab$b_rac = RAB$C_KEY;B     ctx->idxrab.rab$l_rop = 0;            /* set up exact match */@     ctx->idxrab.rab$b_ksz = ctx->keyword_size + ctx->field_size;6     sprintf(ctx->idx_key, "%-*s%s", ctx->keyword_size,0             soundex(query, query, SOUNDEX_SIZE),             SOUNDEX_FIELD);   #     status = get_rec(&ctx->idxrab);      sys$release(&ctx->idxrab);     if (DEBUG)?         swrite(ctx, "soundex match returns status %d", status);      return (status & 1); }     * /* build result[] from matches to query */; int find(context *ctx, Arg *arg, Result **result, int size)  {      int status, field;>     char *cp, query[DATA_SIZE + 1], wild_query[DATA_SIZE + 1];E     char found_keyword[DATA_SIZE + 1], found_id[20], found_field[20];      Result *rptr, *pptr;0     struct dsc$descriptor_s wild_dsc, found_dsc;   -     /* find() only works on indexed fields */ =     if ((ctx->fields[arg->field].attrib & ATTR_INDEXED) == 0)          return size;  :     /* find() only works when there's something to find */&     if ((arg->type & TYPE_VALUE) == 0)         return size;       if (DEBUG)C         swrite(ctx, "Find %s in field %d", arg->value, arg->field);   :     init_dsc(&wild_dsc, wild_query, sizeof(wild_query)-1);A     init_dsc(&found_dsc, found_keyword, sizeof(found_keyword)-1); *     strcpy(query, cp=lc(ctx, arg->value));
     free(cp);      wild_query[0] = '\0';      field = arg->field;   I     for (cp = query; *cp; cp++)              /* convert all '?' to '%' */ H         if (*cp == '?')                      /* STR$WILDCARD uses '%' */             *cp = '%';R     if ((cp = strchr(query, '*')) || (cp = strchr(query, '%'))) {  /* wildcard? */P         strcpy(wild_query, query);           /* make a copy with the wildcard */K         *cp = '\0';                          /* truncate at the wildcard */ M         if (!find_approx(ctx, query, field)) /* try to find the first part */ ;             return size;                     /* no match */      }      elseP         if (!find_exact(ctx, query, field))     /* no wildcard, find the item */P         /* no exact match, try other matches, depending on APPROX and SOUNDEX */=             if ((APPROX && !find_approx(ctx, query, field)) & ?                 (SOUNDEX && !find_soundex(ctx, query, &field))) 7                 return size;             /* no match */      &     ctx->idxrab.rab$b_rac = RAB$C_SEQ;;     status = RMS$_NORMAL;   /* make error checking happy */      do {"         sys$release(&ctx->idxrab);C         strncpy(found_keyword, ctx->idx_record, ctx->keyword_size); 0         found_keyword[ctx->keyword_size] = '\0';         chop(found_keyword);C         if ((ctx->idxrab.rab$l_rop == 0) &&   /* if exact match, */ @             strcmp(found_keyword, query)) /* do exact compare */"             break;  /* no match */L         if ((ctx->idxrab.rab$l_rop == RAB$M_KGE) &&   /* if approx match, */N             strncmp(found_keyword, query, strlen(query))) /* approx compare */"             break;  /* no match */<         if (strlen(wild_query)) {   /* if wildcard match, */C             found_dsc.dsc$w_length = (short) strlen(found_keyword); ?             wild_dsc.dsc$w_length = (short) strlen(wild_query); W             if ((str$match_wild(&found_dsc, &wild_dsc) & 1) == 0) {  /* wild compare */                  if (DEBUG)>                     swrite(ctx, "reject %s", ctx->idx_record);4                 continue;  /* no match, try again */
             } 	         } =         sprintf(found_field, "%0*d", ctx->field_size, field); \         if (strncmp(found_field, ctx->idx_record + ctx->keyword_size, ctx->field_size) != 0)C             continue;  /* this isn't the field we're looking for */ ?         strncpy(found_id, ctx->idx_record + ctx->keyword_size + /                 ctx->field_size, ctx->id_size); &         found_id[ctx->id_size] = '\0';         if (DEBUG)5             swrite(ctx, "found %s", ctx->idx_record); ^         *result = (Result *) my_realloc(ctx, (Result *) *result, (size + 1) * sizeof(Result));,         (*result)[size].id = atoi(found_id);2         (*result)[size].field = atoi(found_field);/         (*result)[size].element = arg->element;          size++; C     } while (((status = get_rec(&ctx->idxrab)) & 1) == SS$_NORMAL);   4     if ((status != RMS$_EOF) && ((status & 1) == 0))V         qilog(ctx, True, "Find %s status = %d (%X)", ctx->idx_record, status, status);       return size; }     G /* this routine makes sure that each result element has a corresponding G    query element.  It is much too easy for "query a* foo" to match "a*" .    in two (or more) fields and none for "foo". */R int validate_match(context *ctx, Result *results, int end, int matched, Arg *list) { 
     Arg *ptr;      int ind;  B     /* look for an indexed query without a corresponding result */L     for (ptr = list; ptr && NotRet(ptr); ptr = ptr->next)  /* all queries */S         if (ctx->fields[ptr->field].attrib & ATTR_INDEXED) {  /* this is indexed */ 7             for (ind = end - matched; ind < end; ind++) 9                 if (results[ind].element == ptr->element) B                     break;       /* a result matched this query */:             if (ind == end)      /* didn't find a match */5                 return False;    /* for this query */ 	         }      return True; }     ) /* see if a query field matches the id */ * int lookup(context *ctx, int id, Arg *arg) {      int status; 8     char *cp, value[DATA_SIZE + 1], data[DATA_SIZE + 1];0     struct dsc$descriptor_s value_dsc, data_dsc;       if (DEBUG)%         swrite(ctx, "lookup %d", id);        /* anything to look for? */ &     if ((arg->type & TYPE_VALUE) == 0)0         return False;  /* no, return no match */  1     init_dsc(&value_dsc, value, sizeof(value)-1); .     init_dsc(&data_dsc, data, sizeof(data)-1);  %     /* first, read the data record */ &     ctx->datrab.rab$b_rac = RAB$C_KEY;(     ctx->datrab.rab$b_krf = PRIMARY_KEY;S     ctx->datrab.rab$b_ksz = ctx->id_size + ctx->field_size;  /* partial key size */ Q     ctx->datrab.rab$l_rop = RAB$M_KGE;             /* find any sequence number */ U     sprintf(ctx->dat_key, "%0*d%0*d", ctx->id_size, id, ctx->field_size, arg->field); 2     while ((status = get_rec(&ctx->datrab)) & 1) {"         sys$release(&ctx->datrab);*         ctx->datrab.rab$b_rac = RAB$C_SEQ;S         if (strncmp(ctx->dat_key, ctx->dat_record, ctx->id_size + ctx->field_size)) Q             break;                            /* finished with this id/field */   Q         ctx->dat_record[ctx->datrab.rab$w_rsz] = '\0';  /* terminate string */    @         strcpy(data, cp=lc(ctx, ctx->dat_record + DAT_OH_SIZE));         free(cp); 5         data_dsc.dsc$w_length = (short) strlen(data);          if (DEBUG)@             if (ctx->fields[arg->field].attrib & ATTR_ENCRYPTED)E                 swrite(ctx, "lookup encrypted field %d", arg->field);              else:                 swrite(ctx, "Lookup %s", ctx->dat_record);N         /* force case for compare; there's no case-blind flag to match_wild */"         if (ctx->mode & WILD_MODE);             sprintf(value, "*%s*", cp=lc(ctx, arg->value));          else2             strcpy(value, cp=lc(ctx, arg->value));         free(cp); 7         value_dsc.dsc$w_length = (short) strlen(value); 6         if (str$match_wild(&data_dsc, &value_dsc) & 1)8             return True;  /* one match is good enough */     } 4     if ((status != RMS$_EOF) && ((status & 1) == 0))X         qilog(ctx, True, "Lookup %s status = %d (%X)", ctx->dat_record, status, status);       return False;  }            6 /* find the non-indexed query fields in the data file      and see if id will match them  */ 5 int find_non_indexed(context *ctx, int id, Arg *list)  { 
     Arg *ptr;   ;     for (ptr = list; ptr && NotRet(ptr); ptr = ptr->next) { :         if (ctx->fields[ptr->field].attrib & ATTR_INDEXED)H             continue;                   /* already did indexed fields */"         if (!lookup(ctx, id, ptr))@             return False;               /* no match, you lose */     } @     return True;                        /* all fields matched */ }     4 /* can the current login update field of user id? *// /* field -1 means ignore the field attribute */ / int can_update(context *ctx, int field, int id)  { #     char proxy[DATA_SIZE + 1], *cp;      int ind;  9     /* if not login mode, don't look for hero or proxy */ &     if (ctx->login_mode != MODE_LOGIN)1         return False;        /* not login mode */   4     /* in login mode, hero has priority over self */;     if (get_field(ctx, ctx->login_id, HERO_FIELD, 0, True)) .         return True;        /* OK to update */  7     if (ctx->login_id == id)    /* now test for self */ P         return ((field == -1) ? True : ctx->fields[field].attrib & ATTR_CHANGE);  N     if (cp = get_field(ctx, id, PROXY_FIELD, 0, True))  /* get proxy for id */         strcpy(proxy, cp);     elseJ         return False;   /* No proxy, don't bother checking proxies held */  )     for (ind = 0; ind < MAX_SEQ; ind++) { S         if ((cp = get_field(ctx, ctx->login_id, HOLDING_FIELD, ind, True)) == NULL)              break;E         if (strcasecmp(proxy, cp) == 0)  /* holding a proxy owner? */ T             return ((field == -1) ? True : ctx->fields[field].attrib & ATTR_CHANGE);     }   &     return False;   /* Can't update */ }      int is_hero(context *ctx)  { 0     /* if not login mode, don't look for hero */&     if (ctx->login_mode != MODE_LOGIN)1         return False;        /* not login mode */        /* return hero status */H     return (get_field(ctx, ctx->login_id, HERO_FIELD, 0, True) != NULL); }     ) int compare(const void *a, const void *b)  { ;     if (((Result *) a)->id < ((Result *) b)->id) return -1; :     if (((Result *) a)->id > ((Result *) b)->id) return 1;A     if (((Result *) a)->field < ((Result *) b)->field) return -1; @     if (((Result *) a)->field > ((Result *) b)->field) return 1;
     return 0;* }     5 /* display the requested fields associated with id */A; void display_id(context *ctx, int id, Arg *list, int match)  {t
     Arg *ptr;e0     int request[MAX_FIELD], use_defaults = True;8     int max, ind, status, num, seq, attrib, proxy_owner;(     char data[DATA_SIZE + 1], field[20];  B /* first we need to know whether there are any requested fields */  )     for (ind = 0; ind < MAX_FIELD; ind++)i         request[ind] = False;u,     for (ptr = list; ptr; ptr = ptr->next) {$         if (ptr->type & TYPE_RETURN)!             use_defaults = False;;4         else if (strcasecmp(ptr->value, "all") == 0)1             for (ind = 0; ind < MAX_FIELD; ind++).C                 request[ind] = True;    /* mark all as requested */s         else if (!use_defaults)n!             if (ptr->field == -1)nT                 respond(ctx, RESP_ONCE, "507:Field %s does not exist.", ptr->value);             else+                 request[ptr->field] = True;i
     }        i  : /* if use_defaults = true, the Default fields will be used5    otherwise, request[] contains the fields requestedo */  )     /* are we a hero or a proxy owner? */ *     proxy_owner = can_update(ctx, -1, id);  &     /* find the max field name size */2     for (ind = 0, max = 0; ind < MAX_FIELD; ind++)K         if (ctx->fields[ind].name && (strlen(ctx->fields[ind].name) > max))*0             max = strlen(ctx->fields[ind].name);  &     ctx->datrab.rab$b_rac = RAB$C_KEY;(     ctx->datrab.rab$b_krf = PRIMARY_KEY;N     ctx->datrab.rab$b_ksz = ctx->id_size;               /* partial key size */I     ctx->datrab.rab$l_rop = RAB$M_KGE;             /* find all records */,4     sprintf(ctx->dat_key, "%0*d", ctx->id_size, id);2     while ((status = get_rec(&ctx->datrab)) & 1) {"         sys$release(&ctx->datrab);Q         ctx->dat_record[ctx->datrab.rab$w_rsz] = '\0';  /* terminate string */    *         ctx->datrab.rab$b_rac = RAB$C_SEQ;A         if (strncmp(ctx->dat_key, ctx->dat_record, ctx->id_size)) K             break;                            /* finished with this id */  EH         strncpy(field, ctx->dat_record + ctx->id_size, ctx->field_size);&         field[ctx->field_size] = '\0';         num = atoi(field);S         strncpy(field, ctx->dat_record + ctx->id_size + ctx->field_size, SEQ_SIZE);          field[SEQ_SIZE] = '\0';k         seq = atoi(field);_         strncpy(field, ctx->dat_record + ctx->id_size + ctx->field_size + SEQ_SIZE, ATTR_SIZE);s          field[ATTR_SIZE] = '\0';         attrib = atoi(field); 5         if (ctx->fields[num].attrib & ATTR_ENCRYPTED)f(             strcpy(data, "(Encrypted)");         else8             strcpy(data, ctx->dat_record + DAT_OH_SIZE);  +         /* if we want to display this fieldf            AND1            we're authorized to display this field !            then display the fieldu
         */         if (              (.               /* this field is requested OR */               request[num] ||xH               /* no fields were requested and this field is a default */,               /* (Default implies Public) */H               (use_defaults && (ctx->fields[num].attrib & ATTR_DEFAULT))              );              /* (this is a field we want to look at) AND */               &&               (.               /* the field def is public OR */               (s9                (ctx->fields[num].attrib & ATTR_PUBLIC) &&(>                ((attrib & FIELD_ATTR_MASK) == FIELD_ATTR_NONE)               ) ||*               /* the field is public OR */               ((>                (attrib & FIELD_ATTR_MASK) == FIELD_ATTR_PUBLIC               ) ||M               /* the field def is local and requested from a local host OR */                (                 (<                 (ctx->fields[num].attrib & ATTR_LOCALPUB) &&?                 ((attrib & FIELD_ATTR_MASK) == FIELD_ATTR_NONE)f                ) &&D                (is_local(ctx))               ) ||I               /* the field is local and requested from a local host OR */x               (s                (>                 (attrib & FIELD_ATTR_MASK) == FIELD_ATTR_LOCAL                ) &&e                (is_local(ctx))               ) ||4               /* the field can't be suppressed OR */               ( 6                ctx->fields[num].attrib & ATTR_FORCEPUB               ) ||8               /* this is the requestor's own entry OR */&               (id == ctx->login_id) ||4               /* the requestor is the proxy owner */               proxy_owner               )            ) {A             respond(ctx, RESP_MULT, "200:%d:%*s: %s", match, max,y<                     seq ? "" : ctx->fields[num].name, data);	         }tW /* this could be considered a privacy hole if you can tell that a field instance existsw *       else if (DEBUG)tT *           swrite(ctx, "Failed display check for field %s", ctx->fields[num].name); */     }q4     if ((status != RMS$_EOF) && ((status & 1) == 0))\         qilog(ctx, True, "Display_id %s status = %d (%X)", ctx->dat_record, status, status);   }        /*E    given an array of indexed fields that match indexed part of query, @    return the count of actual matches with the list in results[] */? int resolve(context *ctx, Result *results, int size, Arg *list)f {t
     Arg *ptr;0(     int ind, iq = 0, matches, count = 0;  F     qsort(results, size, sizeof(Result), compare); /* sort the hits */;     for (ptr = list; ptr && NotRet(ptr); ptr = ptr->next) {c:         if (ctx->fields[ptr->field].attrib & ATTR_INDEXED):             iq++;  /* Get count of indexed queries (iq) */     })       if (DEBUG)(         for (ind = 0; ind < size; ind++)<             swrite(ctx, "Resolve element %d field %d id %d",O                     results[ind].element, results[ind].field, results[ind].id);e  2     /* find sequences of 'iq' matches of one id */9     for (ind = 1, matches = 1; ind < (size + 1); ind++) { C         if ((ind < size) && (results[ind-1].id == results[ind].id))*             matches++;         else {G             if ((matches >= iq) &&          /* if everything matches */eC                 validate_match(ctx, results, ind, matches, list) &&tA                 find_non_indexed(ctx, results[ind-1].id, list)) {u                 if (DEBUG)E                     swrite(ctx, "%d matches for %d clauses: id = %d",L;                            matches, iq, results[ind-1].id);.E                 results[count++] = results[ind-1];  /* save the id */$
             }y             matches = 1;	         }i     }-     return count;  }-     /*"    return number of indexed fields9    ensure that all fields exist and have lookup attributet */, int validate_fields(context *ctx, Arg *list) {>!     int highest = 0, indexed = 0;w     Arg *ptr, *new;t
     char *cp;u  ;     for (ptr = list; ptr && NotRet(ptr); ptr = ptr->next) {s.         if (ptr->name && (ptr->field == -1)) {A             respond(ctx, RESP_ONCE, "507:Field does not exist.");i+             return 0;   /* force failure */d	         }_N         if (ptr->field == -1) {          /* null field name is 'name' field */C             ptr->field = atoi(NAME_FIELD);  /* so use name field */oF             ptr->name = new_string(ctx, ctx->fields[ptr->field].name);	         }a  +         /* mirror the code in qi_build.c */ K         if ((ptr->field == atoi(NAME_FIELD)) && (ptr->type & TYPE_VALUE)) {   , /*   get_token has already removed the comma)  *          cp = strchr(ptr->value, ',');i%  *          if (cp) strcpy(cp, cp+1);u  */g  
 #if NAME_HACK *             cp = strchr(ptr->value, '\'');C             if (cp) strcpy(cp, cp+1);  /* squeeze out apostrophe */o  H /* now that hyphenated names are indexed both ways, this isn't necessary)  *          cp = strchr(ptr->value, '-');d  *          if (cp) {r  *              *cp = '\0'; M  *              new = make_arg(ctx, ptr->name, ptr->field, cp + 1, ptr->type,$1  *                             ptr->element + 1);f&  *              new->next = ptr->next;   *              ptr->next = new;
  *          }c  */l #endif	         } :         if (ctx->fields[ptr->field].attrib & ATTR_INDEXED)             indexed++;B         if ((ctx->fields[ptr->field].attrib & ATTR_LOOKUP) == 0) {Y             respond(ctx, RESP_ONCE, "504:Not authorized for requested search criteria."); +             return 0;   /* force failure */ 	         }x     },     return indexed;* }     & int query_cmd(char *cmd, context *ctx) { ,     int status, ind, iq = 0, hits, size = 0;     Arg *list, *listp, *nick;(     Result *results = NULL;q  G     list = parse_cmd(cmd, ctx);       /* build query struct from cmd */e  (     if (validate_fields(ctx, list) == 0)B         respond(ctx, RESP_ONCE, "515:No indexed field in query.");
     else {I         for (listp = list; listp && NotRet(listp); listp = listp->next) {eD             if ((ctx->fields[listp->field].attrib & ATTR_INDEXED) &&*                 strcmp(listp->value, "*"))K                 iq++;  /* Get count of indexed non-wildcard clauses (iq) */r	         }pI         for (listp = list; listp && NotRet(listp); listp = listp->next) {)H             /* if there are other indexed clauses, don't do wildcards */?             if ((iq > 0) && (strcmp(listp->value, "*") == 0)) { P                 if (listp->prev == (Arg *)0)  /* remove this clause from list */'                     list = listp->next;                  else {4                     listp->prev->next = listp->next;$                     if (listp->next)8                         listp->next->prev = listp->prev;                 } 3                 if (listp->name) free(listp->name);15                 if (listp->value) free(listp->value);U                 free(listp);8                 continue;  /* *listp is gone, skip it */
             }tW             size = find(ctx, listp, &results, size);  /* record ids that match query */i3             if (listp->field == atoi(NAME_FIELD)) {cG                 nick = make_arg(ctx, listp->name, atoi(NICKNAME_FIELD),oK                                 listp->value, listp->type, listp->element);_7                 size = find(ctx, nick, &results, size);                  free(nick);z
             }o	         }>     }]*     if (size == 0)  /* no index matches */<         respond(ctx, RESP_ONCE, "501:No matches to query.");
     else {1         hits = resolve(ctx, results, size, list);f         if (hits == 0)@             respond(ctx, RESP_ONCE, "501:No matches to query.");&         else if (hits > MAX_RECORDS) {F             respond(ctx, RESP_ONCE, "502:Too many matches to query.");=             qilog(ctx, False, "Too many matches (%d)", hits); 	         })         else {I             respond(ctx, RESP_MULT,"102:There %s %d %s to your request.",oM                 hits>1 ? "were" : "was", hits, hits>1 ? "matches" : "match");a,             for (ind = 0; ind < hits; ind++)>                 display_id(ctx, results[ind].id, list, ind+1);C             qilog(ctx, False, "Returned %d out of %d", hits, size);a/             respond(ctx, RESP_MULT, "200:Ok.");i	         }      }s       free_args(list);     free(results);     return True; }d    2 void delete_index(context *ctx, int id, int field) {s     int status;p  P     sprintf(ctx->idx_key, "%0*d%0*d", ctx->id_size, id, ctx->field_size, field);*     ctx->idxrab.rab$b_krf = SECONDARY_KEY;&     ctx->idxrab.rab$b_rac = RAB$C_KEY;B     ctx->idxrab.rab$l_rop = 0;            /* set up exact match */*     ctx->idxrab.rab$b_ksz = IDX_KEY2_SIZE;2     while ((status = get_rec(&ctx->idxrab)) & 1) {*         status = sys$delete(&ctx->idxrab);         if (DEBUG)             if (status & 1)*A                 swrite(ctx, "deleted index %s, status = %d (%X)",a8                        ctx->idx_record, status, status);             elseJ                 swrite(ctx, "could not delete index %s, status = %d (%X)",5                        ctx->idx_key, status, status);)     };     sys$release(&ctx->idxrab);=     ctx->idxrab.rab$b_krf = PRIMARY_KEY;  /* reset the krf */_ }U    2 void delete_field(context *ctx, int id, int field) {      int status;a     char seq[SEQ_SIZE + 1];-  &     ctx->datrab.rab$l_rop = RAB$M_KGE;&     ctx->datrab.rab$b_rac = RAB$C_KEY;(     ctx->datrab.rab$b_krf = PRIMARY_KEY;P     sprintf(ctx->dat_key, "%0*d%0*d", ctx->id_size, id, ctx->field_size, field);I     ctx->datrab.rab$b_ksz = strlen(ctx->dat_key);  /* partial key size */a  2     while ((status = get_rec(&ctx->datrab)) & 1) {Q         ctx->dat_record[ctx->datrab.rab$w_rsz] = '\0';  /* terminate string */   ,*         ctx->datrab.rab$b_rac = RAB$C_SEQ;J         if (strncmp(ctx->dat_record, ctx->dat_key, ctx->datrab.rab$b_ksz))             break;Q         strncmp(seq, ctx->dat_record + ctx->id_size + ctx->field_size, SEQ_SIZE);d         if (DEBUG);             if (ctx->fields[field].attrib & ATTR_ENCRYPTED)fN                 swrite(ctx, "delete/get encrypted field %d, status = %d (%X)",.                        field, status, status);             elseD                 swrite(ctx, "delete/get field %s, status = %d (%X)",8                        ctx->dat_record, status, status);*         status = sys$delete(&ctx->datrab);         if (DEBUG)K             swrite(ctx, "deleted field, status = %d (%X)", status, status);      }      sys$release(&ctx->datrab); }>    * /* delete the records for a specific ID */& int delete_entry(context *ctx, int id) {/     char field[20], *cp;     int status;   *     /* authorized to delete this entry? */      if (can_update(ctx, -1, id))(         /* we can delete this entry */ ;
     else {L         respond(ctx, RESP_ONCE, "510:Not authorized to delete this entry.");         return False;c     }e     if (DEBUG)(         swrite(ctx, "delete id %d", id);       /* delete data fields */&     ctx->datrab.rab$l_rop = RAB$M_KGE;&     ctx->datrab.rab$b_rac = RAB$C_KEY;(     ctx->datrab.rab$b_krf = PRIMARY_KEY;4     sprintf(ctx->dat_key, "%0*d", ctx->id_size, id);I     ctx->datrab.rab$b_ksz = strlen(ctx->dat_key);  /* partial key size */c  2     while ((status = get_rec(&ctx->datrab)) & 1) {*         ctx->datrab.rab$b_rac = RAB$C_SEQ;Q         ctx->dat_record[ctx->datrab.rab$w_rsz] = '\0';  /* terminate string */   -J         if (strncmp(ctx->dat_record, ctx->dat_key, ctx->datrab.rab$b_ksz))             break;H         strncpy(field, ctx->dat_record + ctx->id_size, ctx->field_size);*         status = sys$delete(&ctx->datrab);$         if ((DEBUG) && (status & 1))A             if (ctx->fields[atoi(field)].attrib & ATTR_ENCRYPTED)tK                 swrite(ctx, "deleted encrypted field %s, status = %d (%X)", .                        field, status, status);             elseA                 swrite(ctx, "deleted field %s, status = %d (%X)",'8                        ctx->dat_record, status, status);     }I     sys$release(&ctx->datrab);4     if ((status != RMS$_EOF) && ((status & 1) == 0))^         qilog(ctx, True, "Delete_entry %s status = %d (%X)", ctx->dat_record, status, status);       /* delete index records */*     ctx->idxrab.rab$b_krf = SECONDARY_KEY;&     ctx->idxrab.rab$l_rop = RAB$M_KGE;&     ctx->idxrab.rab$b_rac = RAB$C_KEY;4     sprintf(ctx->idx_key, "%0*d", ctx->id_size, id);I     ctx->idxrab.rab$b_ksz = strlen(ctx->idx_key);  /* partial key size */p  2     while ((status = get_rec(&ctx->idxrab)) & 1) {*         ctx->idxrab.rab$b_rac = RAB$C_SEQ;Q         ctx->idx_record[ctx->idxrab.rab$w_rsz] = '\0';  /* terminate string */   dJ         if (strncmp(ctx->idx_record + ctx->keyword_size + ctx->field_size,1             ctx->idx_key, ctx->idxrab.rab$b_ksz))*             break;*         status = sys$delete(&ctx->idxrab);$         if ((DEBUG) && (status & 1))=             swrite(ctx, "deleted index %s, status = %d (%X)",x4                    ctx->idx_record, status, status);     }/     sys$release(&ctx->idxrab);4     if ((status != RMS$_EOF) && ((status & 1) == 0))`         qilog(ctx, True, "Delete_entry 2 %s status = %d (%X)", ctx->idx_record, status, status);  =     ctx->idxrab.rab$b_krf = PRIMARY_KEY;  /* reset the krf */        return True; }*     /* decrypt field */-3 char *decrypt_field(context *ctx, int id, Arg *ptr)l {)=     /* if we're going to do multi-record encrypted fields, */ 7     /* value[] will need to be allocated dynamically */(     char *cp, *pwd, *value;;  E     value = (char *) check(ctx, calloc(DATA_SIZE + 1, sizeof(char)));   M     if ((ctx->interactive) ||      /* interactive mode can't do encryption */ C         ((ctx->fields[ptr->field].attrib & ATTR_ENCRYPTED) == 0)) {,F         strcpy(value, ptr->value); /* pretend that it was decrypted */         return value;r     }e  <     /* at this point our password field is likely deleted */(     /* so rely on a prior crypt_start */     decrypt(value, ptr->value);   ,     /* new passwords mean new crypto keys */F     if ((ptr->field == atoi(PASSWORD_FIELD)) && (id == ctx->login_id))<         crypt_start(value);  /* remember our new password */       return value;I };     /* add field value */e. void add_field(context *ctx, int id, Arg *ptr) {      int status, seq = 0;)     char *cp, *cp2, value[MAX_INPUT + 1];   2     strcpy(value, cp=decrypt_field(ctx, id, ptr));
     free(cp);"/     for (cp = cp2 = value; cp2; cp = cp2 + 2) { $         if (cp2 = strstr(cp, "\\n"))             *cp2 = '\0';6         sprintf(ctx->dat_record, "%0*d%0*d%0*d%0*d%s",O                 ctx->id_size, id, ctx->field_size, ptr->field, SEQ_SIZE, seq++, 3                 ATTR_SIZE, FIELD_ATTR_CHANGED, cp);;  8         ctx->datrab.rab$w_rsz = strlen(ctx->dat_record);>         if ((status = sys$put(&ctx->datrab)) != RMS$_NORMAL) {T             respond(ctx, RESP_ONCE, "500:Add field failed with status %d.", status);Q             qilog(ctx, True, "Add %s failed status %d", ctx->dat_record, status); 	         };         else             if (DEBUG)D                 if (ctx->fields[ptr->field].attrib & ATTR_ENCRYPTED)K                     swrite(ctx, "Add encrypted field %d, status = %d (%X)",%7                            ptr->field, status, status);t                 elseA                     swrite(ctx, "Add field %s, status = %d (%X)",a<                            ctx->dat_record, status, status);"         sys$release(&ctx->datrab);     }( }n     /* write an index record */,< void write_index(context *ctx, char *str, int id, int field) {*     int status;i  %     if (strlen(str) >= MIN_KEYWORD) {a2         sprintf(ctx->idx_record, "%-*.*s%0*d%0*d",:                 ctx->keyword_size, ctx->keyword_size, str,:                 ctx->field_size, field, ctx->id_size, id);         if (DEBUG)@             swrite(ctx, "Add index record %s", ctx->idx_record);8         ctx->idxrab.rab$w_rsz = strlen(ctx->idx_record);:         if (((status = sys$put(&ctx->idxrab)) & 1) == 0) {T             respond(ctx, RESP_ONCE, "500:Add index failed with status %d.", status);Q             qilog(ctx, True, "Add %s failed status %d", ctx->idx_record, status); 	         }t"         sys$release(&ctx->idxrab);     }  }*     /* add field index */ . void add_index(context *ctx, int id, Arg *ptr) { :     char *cp, *cp2, *cp3, *cp4, *cp5, data[DATA_SIZE + 2];     int line = 0;        strcpy(data, ptr->value); L     for (cp = cp2 = data; cp2; cp = cp2 + 2) {  /* for each line of index */         line++;w$         if (cp2 = strstr(cp, "\\n"))             *cp2 = '\0';         strcpy(data, cp);   <         /* special hack to omit indexing the email domain */K         if ((ptr->field == atoi(EMAIL_FIELD)) && (cp3 = strchr(data, '@'))))             *cp3 = '\0';  *         /* only index the primary alias */<         if ((line > 1) && (ptr->field == atoi(ALIAS_FIELD)))             return;R  S         for (cp3 = data; *cp3; cp3++) {    /* apply any special editing to names */ D             if (*cp3 == ',') strcpy(cp3, cp3+1); /* remove commas */
 #if NAME_HACK L             if (ptr->field == atoi(NAME_FIELD)) { /* only edit name field */O /*              if (*cp3 == '-')  *cp3 = ' '; /* index both hyphenated names */ R                 if (*cp3 == '\'') strcpy(cp3, cp3+1); /* squeeze out apostrophe */L                 if (*cp3 == '/')  *cp3 = ' '; /* index both slashed names */
             }  #endifL             *cp3 = _tolower(*cp3);        /* indexes are always lowercase */	         }e  D         strcat(data, " ");              /* line ends with a space */         cp3 = data;LE         while(cp4 = strchr(cp3, ' ')) {  /* for each word of index */(             *cp4 = '\0';3             write_index(ctx, cp3, id, ptr->field); s
 #if NAME_HACK 3             if ((ptr->field == atoi(NAME_FIELD)) &&A*                 (cp5 = strchr(cp, '-'))) {                 *cp5 = '\0';5                 write_index(ctx, cp, id, ptr->field);|:                 write_index(ctx, cp5 + 1, id, ptr->field);
             }_ #endif             cp3 = cp4 + 1;	         }      }p }(    " /* make soundex entry for field */1 void make_soundex(context *ctx, int id, Arg *ptr)n {.L     char newrec[DATA_SIZE + 1], data[DATA_SIZE + 2], dest[SOUNDEX_SIZE + 1];?     Arg soundex_arg = { 0, TYPE_NAME | TYPE_EQUAL | TYPE_VALUE, >                         NULL, 0, NULL, (Arg *) 0, (Arg *) 0 };     char *cp, *cp2, *cp3;        soundex_arg.value = newrec;      strcpy(data, ptr->value);i      for (cp = data; *cp; cp++) {E         if (iscntrl(*cp))  *cp = ' ';    /* convert tabs to spaces */v=         if (*cp == ',') strcpy(cp, cp+1); /* remove commas */ + #if NAME_HACK  /* assume NAME_FIELD here */tE /*      if (*cp == '-')  *cp = ' '; /* index both hyphenated names */tG         if (*cp == '\'') strcpy(cp, cp+1); /* squeeze out apostrophe */n #endif         *cp = _tolower(*cp);     }u      while ((strlen(data) > 0) &&)            (data[strlen(data)-1] == ' '))pE         data[strlen(data)-1] = '\0';     /* remove trailing blanks */N  E     strcat(data, " ");                   /* line ends with a space */)A     strncpy(newrec, "", sizeof(newrec)); /* init soundex value */      cp = data;A     while(cp2 = strchr(cp, ' ')) {  /* break at space boundary */[         *cp2 = '\0';(         if (strlen(cp) >= MIN_KEYWORD) {<             strcat(newrec, soundex(dest, cp, SOUNDEX_SIZE));              strcat(newrec, " ");	         } 
 #if NAME_HACKs/         if ((ptr->field == atoi(NAME_FIELD)) && &             (cp3 = strchr(cp, '-'))) {             *cp3 = '\0';,             if (strlen(cp) >= MIN_KEYWORD) {@                 strcat(newrec, soundex(dest, cp, SOUNDEX_SIZE));$                 strcat(newrec, " ");
             }n-             if (strlen(cp3) >= MIN_KEYWORD) { A                 strcat(newrec, soundex(dest, cp3, SOUNDEX_SIZE));"$                 strcat(newrec, " ");
             }n	         }  #endif         cp = cp2 + 1;]     }l  ,     soundex_arg.field = atoi(SOUNDEX_FIELD);  ?     if (ctx->fields[atoi(SOUNDEX_FIELD)].attrib & ATTR_INDEXED)-)         add_index(ctx, id, &soundex_arg);s%     add_field(ctx, id, &soundex_arg);a }l    4 /* check to see if this field will be a duplicate */( int is_duplicate(context *ctx, Arg *ptr) {04     char *cp, *cp2, *cp3, *cp4, data[DATA_SIZE + 2];     int  status;  <     if ((ctx->fields[ptr->field].attrib & ATTR_UNIQUE) == 0)I         return False;   /* No Unique attribute, say it's not duplicate */x  ?     if ((ctx->fields[ptr->field].attrib & ATTR_INDEXED) == 0) { Q         respond(ctx, RESP_ONCE, "500:Unique field %s is not Indexed", ptr->name); 3         return True;    /* Not Indexed, fail now */e     }*       strcpy(data, ptr->value);tL     for (cp = cp2 = data; cp2; cp = cp2 + 2) {  /* for each line of index */$         if (cp2 = strstr(cp, "\\n"))             *cp2 = '\0';         strcpy(data, cp);A  Q         for (cp3 = data; *cp3; cp3++) {  /* apply any special editing to names */-D             if (*cp3 == ',') strcpy(cp3, cp3+1); /* remove commas */K             *cp3 = _tolower(*cp3);       /* indexes are always lowercase */c	         })  E         strcat(data, " ");               /* line ends with a space */x         cp3 = data;n*         ctx->idxrab.rab$b_rac = RAB$C_KEY;?         ctx->idxrab.rab$l_rop = 0;            /* exact match */ D         ctx->idxrab.rab$b_ksz = ctx->keyword_size + ctx->field_size;E         while(cp4 = strchr(cp3, ' ')) {  /* for each word of index */              *cp4 = '\0';-             if (strlen(cp3) >= MIN_KEYWORD) { 3                 sprintf(ctx->idx_key, "%-*.*s%0*d",eB                         ctx->keyword_size, ctx->keyword_size, cp3,5                         ctx->field_size, ptr->field);=P                 status = get_rec(&ctx->idxrab);  /* will this be a duplicate? */                 if (DEBUG)A                     swrite(ctx, "Dup check of %s return %d (%X)",i9                            ctx->idx_key, status, status); *                 if (status == RMS$_NORMAL)8                     return True;         /* Duplicate */,                 else if (status != RMS$_RNF)V                     qilog(ctx, True, "Is_duplicate status = %d (%X)", status, status);
             }R             cp3 = cp4 + 1;	         }y     } ,     return False;   /* no duplicate found */ }R     /* modify one field */: int modify_field(context *ctx, int id, Arg *ptr, int type) {R1     int index, ind, count, seq, int_attr, status;""     char char_attr[ATTR_SIZE + 1];  )     /* we need at least "... field = " */r(     if ((ptr->type & TYPE_EQUAL) == 0) {5         respond(ctx, RESP_ONCE, "500:Syntax error.");          return False;e     }e  *     /* authorized to change this field? */(     if (can_update(ctx, ptr->field, id))(         /* we can change this entry */ ;
     else {H         respond(ctx, RESP_ONCE, "505:%s:you may not change this field.",-                ctx->fields[ptr->field].name);          return False; 	         };     if (DEBUG)9         swrite(ctx, "modify type %d field %d (%s) to %s",->            ptr->type, ptr->field, ptr->name ? ptr->name : "", )            ptr->value ? ptr->value : "");        /* is the field defined? */a     if (ptr->field == -1) {l?         respond(ctx, RESP_ONCE, "507:Field %s does not exist.", 3                ptr->name ? ptr->name : ptr->value);r         return False;r     }h  &     /* if this is a SET, do it here */     if (type == TYPE_SET) {cI         for (index = 0, count = 0; index < MAX_FIELD_ATTRIBUTES; index++)              if (ptr->value && E                 strncasecmp(ptr->value, field_attributes[index].name,n7                             strlen(ptr->value)) == 0) {)                 count++;                 ind = index;
             }          if (count != 1) {(G             respond(ctx, RESP_ONCE, "507:Attribute %s does not exist.",r1                    ptr->value ? ptr->value : "");s             return False;(	         }N         count = 0;-         for (seq = 0; seq < MAX_SEQ; seq++) {DA             status = RMS$_RNF; /* default status for get_field */qB             if (get_field(ctx, id, ctx->fields[ptr->field].number,J                           seq, False) == NULL)   /* get and lock record */@                 break;  /* no more instances of this id/field */J             strncpy(char_attr, ctx->dat_record + DAT_KEY_SIZE, ATTR_SIZE);Z             int_attr = atoi(char_attr) & ~field_attributes[ind].mask;  /* mask off bits */@             if (field_attributes[ind].value != FIELD_ATTR_CLEAR)c                 int_attr |= field_attributes[ind].value | FIELD_ATTR_CHANGED;  /* set new attrib */l<             sprintf(char_attr, "%0*d", ATTR_SIZE, int_attr);J             strncpy(ctx->dat_record + DAT_KEY_SIZE, char_attr, ATTR_SIZE);8             if ((status = sys$update(&ctx->datrab)) & 1)                 count++;             if (DEBUG)M                 swrite(ctx, "Update field attributes to %s status = %d (%X)", 8                        ctx->dat_record, status, status);	         } "         sys$release(&ctx->datrab);/         return (count && (status == RMS$_RNF));      }   ?     /* if the field is NAME field, and it has no value, fail */x+     if ((ptr->field == atoi(NAME_FIELD)) && +         (((ptr->type & TYPE_VALUE) == 0) ||t'           (strlen(ptr->value) == 0))) { R         respond(ctx, RESP_ONCE, "500:Cannot delete required field %s", ptr->name);         return False;a     }   7     /* don't duplicate a field that should be unique */$!     if (is_duplicate(ctx, ptr)) {k@         respond(ctx, RESP_ONCE, "509:Duplicate unique record.");         return False;      }r  1     /* if the field is indexed, remove indexes */A6     if (ctx->fields[ptr->field].attrib & ATTR_INDEXED)*         delete_index(ctx, id, ptr->field);  (     /* if the field exists, remove it */&     delete_field(ctx, id, ptr->field);  =     /* if the field is the name field, delete soundex also */ )     if (ptr->field == atoi(NAME_FIELD)) {)C         if (ctx->fields[atoi(SOUNDEX_FIELD)].attrib & ATTR_INDEXED)t7             delete_index(ctx, id, atoi(SOUNDEX_FIELD));A3         delete_field(ctx, id, atoi(SOUNDEX_FIELD));a     }c  %     /* add new field and its index */;9     if ((ptr->type & TYPE_VALUE) && strlen(ptr->value)) {-:         if (ctx->fields[ptr->field].attrib & ATTR_INDEXED)$             add_index(ctx, id, ptr);          add_field(ctx, id, ptr);     }l  8     /* if the field is the name field, create soundex */'     if (ptr->field == atoi(NAME_FIELD)) #         make_soundex(ctx, id, ptr);x  7     /* if the field is our alias, change login_alias */ C     if ((id == ctx->login_id) && (ptr->field == atoi(ALIAS_FIELD)))(-         strcpy(ctx->login_alias, ptr->value);        return True; }e    P /* change the field(s) or change the field attributes given for a specific ID */< int modify_fields(context *ctx, int id, Arg *list, int type) {c
     Arg *ptr;t     int count = 0;       if (DEBUG)(         swrite(ctx, "modify id %d", id);  /     /* skip to the good part of the arg list */)B     for (ptr = list; ptr && (ptr->type != type); ptr = ptr->next);  /     for (ptr = ptr->next; ptr; ptr = ptr->next)h/         if (modify_field(ctx, id, ptr, type)) {              count++;B             respond(ctx, RESP_MULT, "200:%s changed.", ptr->name);	         }.     return count;G }     0 /* delete entry; almost the same as query_cmd */' int delete_cmd(char *cmd, context *ctx)t {d/     int status, ind, hits, size = 0, count = 0;a     Arg *list, *listp, *nick;e     Result *results = NULL;   C     list = parse_cmd(cmd, ctx);       /* build arg list from cmd */a  (     if (validate_fields(ctx, list) == 0)C         respond(ctx, RESP_ONCE, "515:No indexed field in delete."); 
     else {I         for (listp = list; listp && NotRet(listp); listp = listp->next) {aY             size = find(ctx, listp, &results, size);    /* record ids that match query */s3             if (listp->field == atoi(NAME_FIELD)) {(G                 nick = make_arg(ctx, listp->name, atoi(NICKNAME_FIELD),YK                                 listp->value, listp->type, listp->element);(7                 size = find(ctx, nick, &results, size);                  free(nick); 
             }d	         }d     }a*     if (size == 0)  /* no index matches */<         respond(ctx, RESP_ONCE, "501:No matches to query.");
     else {1         hits = resolve(ctx, results, size, list);          if (hits == 0)@             respond(ctx, RESP_ONCE, "501:No matches to query.");&         else if (hits > MAX_DELETES) {X             respond(ctx, RESP_ONCE, "518:Too many entries selected by delete command.");>             qilog(ctx, False, "Too many selected (%d)", hits);	         }_         else {,             for (ind = 0; ind < hits; ind++)@                 if (delete_entry(ctx, results[ind].id)) count++;E             respond(ctx, RESP_MULT, "200:%d entries deleted", count);i	         }t     }a       free_args(list);     free(results);     return True; }n    2 /* change command; almost the same as query_cmd */' int change_cmd(char *cmd, context *ctx). {$/     int status, ind, hits, size = 0, count = 0;s     Arg *list, *listp, *nick;      Result *results = NULL;   C     list = parse_cmd(cmd, ctx);       /* build arg list from cmd */ (     if (validate_fields(ctx, list) == 0)B         respond(ctx, RESP_ONCE, "515:No indexed field in query.");
     else {I         for (listp = list; listp && NotRet(listp); listp = listp->next) {%W             size = find(ctx, listp, &results, size);  /* record ids that match query */s3             if (listp->field == atoi(NAME_FIELD)) {tG                 nick = make_arg(ctx, listp->name, atoi(NICKNAME_FIELD), K                                 listp->value, listp->type, listp->element);l7                 size = find(ctx, nick, &results, size);d                 free(nick);a
             } 	         }_     }1*     if (size == 0)  /* no index matches */<         respond(ctx, RESP_ONCE, "501:No matches to query.");$     else if ((listp == (Arg *) 0) ||9              (listp->type & (TYPE_MAKE | TYPE_SET) == 0))eC        respond(ctx, RESP_ONCE, "525:Make or Set clause not found");e
     else {1         hits = resolve(ctx, results, size, list);/         if (hits == 0)@             respond(ctx, RESP_ONCE, "501:No matches to query.");&         else if (hits > MAX_CHANGES) {X             respond(ctx, RESP_ONCE, "518:Too many entries selected by change command.");>             qilog(ctx, False, "Too many selected (%d)", hits);	         }d         else {,             for (ind = 0; ind < hits; ind++)P                 count += modify_fields(ctx, results[ind].id, list, listp->type);I             respond(ctx, RESP_MULT, "200:%d entries/%d fields modified", c!                     hits, count); 	         }      }        free_args(list);     free(results);     return True; }t    ) /* select alias and initialize next_id */ ' int select_cmd(char *cmd, context *ctx)p {>     int id;Z     char *cp, field_str[10];     Arg *list, arg;H  G     list = parse_cmd(cmd, ctx);       /* build query struct from cmd */ M     if ((list == NULL) || (list->next) || ((list->type & TYPE_VALUE) == 0)) {n         free_args(list);4         respond(ctx, RESP_ONCE, "599:Syntax error");         return True;     }eP     if (list->field == -1) {       /* "select nnnn" means select arbitrary ID */%         if (!isdigit(*list->value)) {d             free_args(list);8             respond(ctx, RESP_ONCE, "599:Syntax error");             return True;	         } )         ctx->next_id = atoi(list->value);u         free_args(list);D         respond(ctx, RESP_MULT, "200:ID %d selected", ctx->next_id);         return True;     }xI     /* here if "select field=value"  field must be unique (like alias) */ ?     if ((ctx->fields[list->field].attrib & ATTR_UNIQUE) == 0) {t         free_args(list);J         respond(ctx, RESP_ONCE, "500:Field must be configured as unique");         return True;     }"G     if (ctx->next_id > 0) {               /* next_id already set up? */tL         respond(ctx, RESP_MULT, "200:ID %d already selected", ctx->next_id);         return True;     } ,     sprintf(field_str, "%02d", list->field);M     if ((cp = get_value(ctx, list->value, field_str, ID_FIELD, 0)) == NULL) {s         free_args(list);E         respond(ctx, RESP_ONCE, "500:%s does not exist", list->name);s         return True;     }      id = atoi(cp);D     if ((cp = get_field(ctx, id, CONTROL_FIELD, 0, True)) == NULL) {         free_args(list);D         respond(ctx, RESP_ONCE, "500:Control field does not exist");         return True;     }      ctx->next_id = atoi(cp);$     arg.field = atoi(CONTROL_FIELD);<     arg.name = new_string(ctx, ctx->fields[arg.field].name);'     arg.type = TYPE_EQUAL | TYPE_VALUE;c0     arg.value = (char *) check(ctx, malloc(20));/     sprintf(arg.value, "%d", ctx->next_id + 1);;K     modify_field(ctx, id, &arg, TYPE_MAKE);  /* update the control field */e     free_args(list);@     respond(ctx, RESP_MULT, "200:ID %d selected", ctx->next_id);     return True; }3     /* create an entry */ $ int add_cmd(char *cmd, context *ctx) {l     char *cp, sel_cmd[50];     Arg *list, *ptr;  L     if (ctx->next_id == -1) {             /* is there an ID ready to use? */ #ifdef DEFAULT_SELECT*2         if (ctx->fields[atoi(ALIAS_FIELD)].name) {b             sprintf(sel_cmd, "select %s=%s", ctx->fields[atoi(ALIAS_FIELD)].name, DEFAULT_SELECT);H             select_cmd(sel_cmd, ctx);     /* select the default entry */	         }d #else*9         respond(ctx, RESP_ONCE, "477:No entry selected");* #endifA         if (ctx->next_id == -1)            /* it didn't exist? */*             return True;     }   E     list = parse_cmd(cmd, ctx);       /* build add struct from cmd */a*     for (ptr = list; ptr; ptr = ptr->next)<         if (modify_field(ctx, ctx->next_id, ptr, TYPE_MAKE))@             respond(ctx, RESP_MULT, "200:%s added.", ptr->name);'     respond(ctx, RESP_MULT, "200:Ok.");        ctx->next_id = -1;     free_args(list);     return True; }i     void db_open(context *ctx) {>     ctx->idxfab = cc$rms_fab; >     ctx->idxfab.fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_DEL;'     ctx->idxfab.fab$l_fna = INDEX_NAME;,/     ctx->idxfab.fab$b_fns = strlen(INDEX_NAME);eV     ctx->idxfab.fab$b_shr = FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD | FAB$M_SHRDEL; #if EXEC_LOGICALS(,     ctx->idxfab.fab$v_lnm_mode = PSL$C_EXEC; #endif2     ctx->idxfab.fab$l_xab = (void *) &ctx->idxxab;       ctx->idxrab = cc$rms_rab;_)     ctx->idxrab.rab$l_fab = &ctx->idxfab; )     ctx->idxrab.rab$l_kbf = ctx->idx_key; )     ctx->idxrab.rab$b_ksz = IDX_KEY_SIZE; &     ctx->idxrab.rab$b_rac = RAB$C_KEY;,     ctx->idxrab.rab$w_usz = IDX_RECORD_SIZE;,     ctx->idxrab.rab$l_ubf = ctx->idx_record;        ctx->idxxab = cc$rms_xabkey;3     ctx->idxxab.xab$l_nxt = (void *) &ctx->idxxab2;t!     ctx->idxxab2 = cc$rms_xabkey;'+     ctx->idxxab2.xab$b_ref = SECONDARY_KEY;        ctx->datfab = cc$rms_fab;eJ     ctx->datfab.fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_UPD | FAB$M_DEL;&     ctx->datfab.fab$l_fna = DATA_NAME;.     ctx->datfab.fab$b_fns = strlen(DATA_NAME);V     ctx->datfab.fab$b_shr = FAB$M_SHRGET | FAB$M_SHRPUT | FAB$M_SHRUPD | FAB$M_SHRDEL; #if EXEC_LOGICALS ,     ctx->datfab.fab$v_lnm_mode = PSL$C_EXEC; #endif       ctx->datrab = cc$rms_rab;c)     ctx->datrab.rab$l_fab = &ctx->datfab;d)     ctx->datrab.rab$l_kbf = ctx->dat_key; )     ctx->datrab.rab$b_ksz = DAT_KEY_SIZE; &     ctx->datrab.rab$b_rac = RAB$C_KEY;(     ctx->datrab.rab$b_krf = PRIMARY_KEY;,     ctx->datrab.rab$w_usz = DAT_RECORD_SIZE;,     ctx->datrab.rab$l_ubf = ctx->dat_record;  F     if (((ctx->db_status = sys$open(&ctx->idxfab)) & 7) != SS$_NORMAL)         return;H  )     /* get field sizes from index info */E+     ctx->id_size = ctx->idxxab2.xab$b_siz0;).     ctx->field_size = ctx->idxxab2.xab$b_siz1;P     ctx->keyword_size = ctx->idxxab.xab$b_siz0 - ctx->id_size - ctx->field_size;     if (DEBUG)2         if ((ctx->keyword_size != KEYWORD_SIZE) ||I             (ctx->field_size != FIELD_SIZE) || (ctx->id_size != ID_SIZE)),R             swrite(ctx, "Field sizes: Keyword = %d/%d, ID = %d/%d, Field = %d/%d",3                    KEYWORD_SIZE, ctx->keyword_size, G                    ID_SIZE, ctx->id_size, FIELD_SIZE, ctx->field_size);d  I     if (((ctx->db_status = sys$connect(&ctx->idxrab)) & 7) != SS$_NORMAL)o         return;   -     if (ctx->idxfab.fab$b_org != FAB$C_IDX) {e         ctx->db_status = 0;b         return;      }d  F     if (((ctx->db_status = sys$open(&ctx->datfab)) & 7) != SS$_NORMAL)         return;   I     if (((ctx->db_status = sys$connect(&ctx->datrab)) & 7) != SS$_NORMAL)          return;n  -     if (ctx->datfab.fab$b_org != FAB$C_IDX) {p         ctx->db_status = 0;i         return;a     }  }R     void db_close(context *ctx)n {t     sys$close(&ctx->idxfab);     sys$close(&ctx->datfab); }     2 /* wrapper for sys$get to handle locked records */ int get_rec(struct RAB *rab) {a     int status;c8     float delay = 0.1;  /* 100 ms delay between tries */  /     while ((status = sys$get(rab)) == RMS$_RLK)          lib$wait(&delay);      return status; }   