N /****************************************************************************/ /*									    */ 0 /*  FACILITY:	Generic Support Library					    */ /*									    */ D /*  MODULE:	Command Line Keyword and Option Processing Header	    */ /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This header contains definitions used in the processing of */N /*  program command line arguments, given a dispatch table of keywords and  */ /*  handlers.								    */  /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ / /*  V0.2-00 23-SEP-1994 Steve Branam					    */  /*									    */ - /*	Addded keyword translation code.				    */  /*									    */ N /****************************************************************************/   #ifndef __CMDOPT_H #define __CMDOPT_H   #ifdef VAXC K #define CMDLINE_OPTION_SWITCH	    '/'	    /* VMS option switch char.	    */  #else L #define CMDLINE_OPTION_SWITCH	    '-'	    /* Non-VMS option switch char.  */ #endifN #define CMDLINE_OPTION_SEPARATOR    '='	    /* Separates option from value. */M #define CMDLINE_OPTION_COMMENT	    '!'	    /* Rest of option is comment.   */ N #define CMDLINE_OPTVAL_SEPARATOR    ','	    /* Separates values in list.    */J #define CMDLINE_HELP_SWITCH	    '#'	    /* Switch char to show help.    */N #define KEYWORD_LIST_SEPARATOR      ','	    /* Separates values in list.    */  ! #define max(x, y) (x > y ? x : y)    /*									    */ N /* Keyword definition object. Keyword dispatch tables are composed of these */ /* objects.								    */  /*									    */    typedef struct {6     char    *keyword;			    /* Keyword string.		    */<     int	    minlen;			    /* Minimum required command	    */( 					    /* line argument length.	    */=     int	    (*handler)();		    /* Keyword handler ptr.	    */ 3     int	    code;			    /* Translation code.	    */  } KEYWORD_DEFINITION;    /*									    */ = /* Keyword definition object member access routines.			    */  /*									    */   ' #define kwdef_keyword(d) ((d)->keyword) % #define kwdef_minlen(d) ((d)->minlen) ' #define kwdef_handler(d) ((d)->handler) ! #define kwdef_code(d) ((d)->code) 2 #define set_kwdef_keyword(d, s) ((d)->keyword = s)0 #define set_kwdef_minlen(d, x) ((d)->minlen = x)2 #define set_kwdef_handler(d, h) ((d)->handler = h), #define set_kwdef_code(d, x) ((d)->code = x)   /*									    */ $ /* Forward declarations.						    */ /*									    */    int ustrncmp();  int process_options(); int process_keyword(); int process_options_file();  int translate_keyword();   #endif /* #ifndef __CMDOPT_H */ 