N /****************************************************************************/ /*									    */ 0 /*  FACILITY:	Generic Support Library					    */ /*									    */ ' /*  MODULE:	List Management						    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ M /*  DESCRIPTION: This module contains routines to manage doubly-linked	    */ N /*  lists of application objects. It supports addition of entries to and    */N /*  removal of entries from lists, for both ordered and unordered lists, as */' /*  well as list searching.						    */  /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include <stdio.h> #include "list.h"   N /*************************************************************************++*/ void *insert_list_entry(> /* Adds an item to a list at a given insertion point.			    */       LIST    *aList, % 	    /* (MODIFY, BY ADDR):					    */ G 	    /* List to which item is to be added. The list pointers may be  */ @ 	    /* updated, and the item count will be incremented.		    */       LIST_ENTRY_HDR 	    *aPrevious,% 	    /* (MODIFY, BY ADDR):					    */ G 	    /* Insertion point in list. Item is added following this one,   */ G 	    /* linked through flink field; if NULL ptr is passed here, item */ + 	    /* is added at head of list.				    */        LIST_ENTRY_HDR 	    *aItem % 	    /* (MODIFY, BY ADDR):					    */ G 	    /* Item to be added. It is linked to aPrevious through blink    */ G 	    /* field; if no aPrevious item is specified, blink is NULL.	    */   0 )	/* Returns aItem, ptr to added item.				    */G 	/*****************************************************************--*/    {      if (aPrevious == NULL) {   	/*+								    */G 	/*  Item is to be added at head of list. First, link it to first    */ G 	/*  entry and clear its backlink. Next, if list is empty, make item */ G 	/*  last; otherwise, link the first entry back to it. Finally, make */  	/*  item first.							    */  	/*-								    */ 	 # 					    /* Set item links.		    */ + 	set_entry_flink(aItem, list_first(aList));  	set_entry_blink(aItem, NULL);B 	if (isempty_list(aList)) {	    /* Empty list, item is last.    */! 	    set_list_last(aList, aItem);  	}, 	else {				    /* Link first to item.	    *// 	    set_entry_blink(list_first(aList), aItem);  	}< 	set_list_first(aList, aItem);	    /* Item is first.		    */     } 
     else {   	/*+								    */G 	/*  Item is to be added following an existing entry.  First, link   */ E 	/*  it to existing entries forward and back (aPrevious is the	    */ G 	/*  previous entry, and its forward link points to the next entry). */ G 	/*  Next, if previous entry is currently last, make this item last; */ G 	/*  otherwise, link the next entry back to this item.  Finally,	    */ 6 	/*  link previous entry forward to this one.			    */ 	/*-								    */  # 					    /* Set item links.		    */ 0 	set_entry_flink(aItem, entry_flink(aPrevious));# 	set_entry_blink(aItem, aPrevious); F 	if (islast_entry(aPrevious)) {	    /* Previous entry used to be    */A 	    set_list_last(aList, aItem);    /* last, now item is.	    */  	}0 	else {				    /* Link next back to item.	    */4 	    set_entry_blink(entry_flink(aPrevious), aItem); 	}G 	set_entry_flink(aPrevious, aItem);  /* Link prev forward to item.   */      } ?     inc_list_entries(aList);		    /* Update entry count.	    */      return aItem;  }   N /*************************************************************************++*/ void *insert_ordered_entry( K /* Adds an item to a list according to the list order specified by a	    */ # /* comparator routine.							    */        LIST    *aList, % 	    /* (MODIFY, BY ADDR):					    */ G 	    /* List to which item is to be added. The list pointers may be  */ @ 	    /* updated, and the item count will be incremented.		    */       LIST_ENTRY_HDR 	    *aItem,% 	    /* (MODIFY, BY ADDR):					    */ F 	    /* Item to be added. Its links will be updated to point to	    */& 	    /* other list entries.					    */       int	    (* aComparator)() $ 	    /* (EXEC, BY ADDR):						    */G 	    /* Routine that compares item to existing items in list. The    */ : 	    /* routine must have the following interface:		    */ 	    /*								    */ 4 	    /*	    int comparator(listitem, aItem)			    */ 	    /*								    */ G 	    /* where listitem is a ptr to an item from the list, and aItem  */ G 	    /* is the item being added here. The comparator returns 0 if    */ F 	    /* they are equal, less than 0 if list_item should precede	    */G 	    /* aItem in the list, and greater than 0 if list_item should    */ + 	    /* follow aItem in the list.				    */  	       0 )	/* Returns aItem, ptr to added item.				    */G 	/*****************************************************************--*/    { 6     LIST_ENTRY_HDR			    /* Current record ptr.	    */ 	    *listitem;        /*+									    */M     /*	If the list is empty, just put this item at the front. Otherwise,   */ I     /*	search for appropriate insertion point using the comparator	    */ J     /*	routine. If the end of the list is reached without finding a	    */M     /*	greater entry, this item should be last, so append it to the list.  */ L     /*	Otherwise, insert it in the list in front of the greater item.	    */     /*-									    */       if (isempty_list(aList)) {" 	prepend_list_entry(aList, aItem);     }      else {				  < 	for (listitem = list_first(aList);  /* Search list.		    */> 	    listitem != NULL && (*aComparator)(listitem, aItem) < 0; ' 	    listitem = entry_flink(listitem)); 6 	if (listitem == NULL) {		    /* None greater.		    */% 	    append_list_entry(aList, aItem);  	}- 	else {				    /* Found greater entry.	    */ < 	    insert_list_entry(aList, entry_blink(listitem), aItem); 	}     }      return aItem;  }          N /*************************************************************************++*/ void *remove_list_entry(+ /* Removes an item from a list.						    */        LIST    *aList, $ 	    /* (MODIFY, BY ADDR)					    */G 	    /* List from which item is to be removed. The list pointers may */ B 	    /* be updated, and the item count will be decremented.	    */       LIST_ENTRY_HDR 	    *aItem $ 	    /* (MODIFY, BY ADDR)					    */& 	    /* Item to be removed.					    */  2 )	/* Returns aItem, ptr to removed item.				    */G 	/*****************************************************************--*/    {      /*+									    */M     /*	First break and reform links in front of item. If item is the first */ M     /*	entry, make the next first; otherwise, link previous entry forward  */ M     /*	to next one. Next break and reform links following entry. If item   */ M     /*	is the last entry, make the previous one last; otherwise, link next */ M     /*	entry back to previous one. Finally, stomp the links in item so	    */ M     /*	they can't accidentally be followed and update the entry count.	    */      /*-									    */  @     if (aItem == NULL) {		    /* Unspecified entry cannot be  */( 	return NULL;			    /* removed.			    */     } E     if (isfirst_entry(aItem)) {		    /* Make next entry first?	    */ + 	set_list_first(aList, entry_flink(aItem));      } 4     else {				    /* Or link previous to next.    */9 	set_entry_flink(entry_blink(aItem), entry_flink(aItem));      } F     if (islast_entry(aItem)) {		    /* Make previous entry last?    */* 	set_list_last(aList, entry_blink(aItem));     } 4     else {				    /* Or link next to previous.    */9 	set_entry_blink(entry_flink(aItem), entry_blink(aItem));      } H     set_entry_flink(aItem, NULL);	    /* Stomp links in this entry.   */!     set_entry_blink(aItem, NULL); ?     dec_list_entries(aList);		    /* Update entry count.	    */      return aItem;  }   N /*************************************************************************++*/  LIST_ENTRY_HDR *find_list_entry(H /* Searches for an item in a list without regard to any ordering.	    */       LIST    *aList,*$ 	    /* (READ, BY ADDR):						    */# 	    /* List to search.						    */*       LIST_ENTRY_HDR 	    *aItem,$ 	    /* (READ, BY ADDR): 					    */G 	    /* Item containing information be located. Note that any item   */ A 	    /* that meets the comparison will satisfy the search.	    */l       int	    (* aComparator)()p$ 	    /* (EXEC, BY ADDR):						    */G 	    /* Routine that compares item to existing items in list. See    */eG 	    /* the aComparator parameter of routine insert_ordered_entry    */ % 	    /* for a description.					    */Y  F )	/* Returns ptr to found entry if found, or NULL if not found.	    */G 	/*****************************************************************--*/	   { 6     LIST_ENTRY_HDR			    /* Current record ptr.	    */ 	    *listitem;*7     int	    cmpstat;			    /* Comparison status.	    */*       /*+									    */M     /*	If the list is empty, matching item cannot be in it. Otherwise,	    */*M     /*	scan list for matching item. If end of list found, entry is not in  */i     /*	it.								    */     /*-									    */  + 					    /* Ignore missing item, and	    */ + 					    /* don't search empty list.	    */e/     if (aItem == NULL || isempty_list(aList)) {I     	return NULL;*     }u     else {				   ,C 	for (listitem = list_first(aList);  /* Scan list for match.	    */d 	    listitem != NULL &&7 	    (cmpstat = (*aComparator)(listitem, aItem)) != 0; e( 	    listitem = entry_flink(listitem)) { 	} 	if (cmpstat == 0) {< 	    return listitem;		    /* Entry found, return it.	    */ 	} 	else { 2 	    return NULL;		    /* Entry not found.		    */ 	}     }  }          N /*************************************************************************++*/# LIST_ENTRY_HDR *find_ordered_entry( N /* Searches for an item in an ordered list according to the order specified */' /* by a comparator routine.						    */	       LIST    *aList,t$ 	    /* (READ, BY ADDR):						    */# 	    /* List to search.						    */c       LIST_ENTRY_HDR 	    *aItem,$ 	    /* (READ, BY ADDR): 					    */G 	    /* Item containing information be located. Note that any item   */.A 	    /* that meets the comparison will satisfy the search.	    */	       int	    (* aComparator)() $ 	    /* (EXEC, BY ADDR):						    */G 	    /* Routine that compares item to existing items in list. See    */sG 	    /* the aComparator parameter of routine insert_ordered_entry    */f% 	    /* for a description.					    */i  F )	/* Returns ptr to found entry if found, or NULL if not found.	    */G 	/*****************************************************************--*/e   {t6     LIST_ENTRY_HDR			    /* Current record ptr.	    */ 	    *listitem;i7     int	    cmpstat;			    /* Comparison status.	    */        /*+									    */M     /*	If the list is empty, matching item cannot be in it. Otherwise,	    */ M     /*	scan list for matching item or next greater one.  If end of list or */a8     /*	greater entry found, entry is not in it.			    */     /*-									    */  + 					    /* Ignore missing item, and	    */ + 					    /* don't search empty list.	    */ /     if (aItem == NULL || isempty_list(aList)) { 
 	return NULL;i     }s     else {				    C 	for (listitem = list_first(aList);  /* Scan list for match.	    */I 	    listitem != NULL &&6 	    (cmpstat = (*aComparator)(listitem, aItem)) < 0; ( 	    listitem = entry_flink(listitem)) { 	} 	if (cmpstat == 0) {< 	    return listitem;		    /* Entry found, return it.	    */ 	} 	else { 2 	    return NULL;		    /* Entry not found.		    */ 	}     }. }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          