N /****************************************************************************/ /*									    */ 0 /*  FACILITY:	Generic Support Library					    */ /*									    */ ' /*  MODULE:	List Management						    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This header file contains all type definitions for the	    */L /*  generic list object types used by Routine Analyzer. Member access	    */N /*  routines (get/set values) and a number of object management routines    */. /*  are implemented here as macros.					    */ /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/  N /****************************************************************************/ /*									    */ ! /* List object type.							    */  /*									    */ N /****************************************************************************/   typedef struct {=     long    entries;			    /* Number of items in list.	    */ A     struct list_entry_hdr		    /* Ptr to first item in list.   */  	    *head; A     struct list_entry_hdr		    /* Ptr to last item in list.    */  	    *tail;  } LIST;    /*									    */ 1 /* List object member access routines.					    */  /*									    */   & #define list_entries(l) ((l)->entries)! #define list_first(l) ((l)->head)   #define list_last(l) ((l)->tail), #define inc_list_entries(l) ((l)->entries++), #define dec_list_entries(l) ((l)->entries--), #define set_list_first(l, p) ((l)->head = p)+ #define set_list_last(l, p) ((l)->tail = p)    /*									    */ . /* List object management routines.					    */ /*									    */   G #define append_list_entry(l, e) insert_list_entry((l), list_last(l), e) @ #define prepend_list_entry(l, e) insert_list_entry((l), NULL, e)[ #define copy_list(s, d) ((d)->head=(s)->head,(d)->tail=(s)->tail,(d)->entries=(s)->entries) E #define init_list(l) ((l)->head=NULL, (l)->tail=NULL, (l)->entries=0) + #define isempty_list(l) ((l)->head == NULL)    /*									    */ 9 /* Treat a list as a stack: last-in, first-out.				    */  /*									    */   0 #define push_entry(s, e) append_list_entry(s, e)7 #define pop_entry(s) remove_list_entry(s, list_last(s))    /*									    */ 9 /* Treat a list as a queue: first-in, first-out.			    */  /*									    */   3 #define enqueue_entry(s, e) append_list_entry(s, e) < #define dequeue_entry(s) remove_list_entry(s, list_first(s))  N /****************************************************************************/ /*									    */ N /* List entry header object. Application list entry objects are expected to */H /* define the following as the first element of their structures:	    */ /*									    */ ) /*	LIST_ENTRY_HDR   entry_hdr;					    */  /*									    */ N /****************************************************************************/   typedef struct list_entry_hdr { A     struct list_entry_hdr		    /* Ptr to next record in list.  */  	    *flink;@     struct list_entry_hdr		    /* Ptr to previous record.	    */ 	    *blink; } LIST_ENTRY_HDR;    /*									    */ 8 /* Entry header object member access routines.				    */ /*									    */   # #define entry_blink(e) ((e)->blink) # #define entry_flink(e) ((e)->flink) K #define next_entry(e) ((e) == NULL ? NULL : entry_flink(&((e)->entry_hdr))) K #define prev_entry(e) ((e) == NULL ? NULL : entry_blink(&((e)->entry_hdr))) , #define set_entry_flink(e, p) (e->flink = p), #define set_entry_blink(e, p) (e->blink = p)   /*									    */ 5 /* Entry header object management routines.				    */  /*									    */   1 #define isfirst_entry(e) (entry_blink(e) == NULL) 0 #define islast_entry(e) (entry_flink(e) == NULL)2 #define isbegin_of_list(e) (prev_entry(e) == NULL)0 #define isend_of_list(e) (next_entry(e) == NULL)  