N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ + /*  MODULE:	List File Management					    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ J /*  DESCRIPTION: This module contains list file management routines	    */% /*  for Routine Analyzer.						    */  /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include "ranalyzer.h"  N /*************************************************************************++*/ void new_list_line( 1 /* Starts a new line in the list file.					    */        SOURCEFILE 	    *aSourceRecord   		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (list_enabled()) { D 	fprintf(list_file(), LIST_LINE_NUMBER, source_line(aSourceRecord));     }  }   N /*************************************************************************++*/ void list_char( N /* Writes a character to the listing file and maintains the line character  */ /* count.								    */        char    vChar # 	    /* (READ, BY VAL):						    */ % 	    /* Character to list.					    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      /*+									    */M     /*	If a listing file is being written, write the character to it. If   */ M     /*	it is a tab, compute the next tab position. If it is a newline,	    */ M     /*	reset the column position. Otherwise, just increment the column.    */      /*-									    */       if (list_enabled()) {  	fputc(vChar, list_file());  	if (vChar == '\t') { B 	    set_list_column(((list_column() / TAB_SIZE) + 1) * TAB_SIZE); 	} 	else if (vChar == '\n') { 	    set_list_column(0); 	} 	else {  	    inc_list_column();  	}     }  }   N /*************************************************************************++*/ void restore_list_column( N /* Prints blanks out to the current listing column, restoring the column    */7 /* position after a message has been printed.				    */   !     /* No arguments.							    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { 5     int	    count;			    /* Character counter.	    */        /*+									    */M     /*	Write the listing file line number spacing margin. Next write a	    */ M     /*	sufficient number of tabs to position it before the current column  */ M     /*	position. Then write the remaining number of blanks to go from the  */ 1     /*	tab stop to the column position.				    */      /*-									    */  0     fprintf(list_file(), LIST_LINE_SPACER, ' ');@     for (count = list_column() / TAB_SIZE; count > 0; count--) { 	fputc('\t', list_file());     } @     for (count = list_column() % TAB_SIZE; count > 0; count--) { 	fputc(' ', list_file());      }  }   N /*************************************************************************++*/ void list_file_begin( M /* Writes status messages indicating that analysis of a source file is	    */  /* beginning.								    */        SOURCEFILE	*aSourceFile,  		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */        char	*aLangName   		/* (READ, BY ADDR):					    */) 		/* Source file language name.				    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (list_enabled()) { C 	fprintf(list_file(), "FILE %s analysis started, language is %s\n", * 	    source_name(aSourceFile), aLangName);     }      if (log_enabled()) {5 	printf("FILE %s analysis started, language is %s\n", * 	    source_name(aSourceFile), aLangName);     }  }   N /*************************************************************************++*/ void list_file_end( M /* Writes status messages indicating that analysis of a source file is	    */  /* complete.								    */       SOURCEFILE	*aSourceFile   		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (list_enabled()) { 6 	fprintf(list_file(), "\nFILE %s analysis complete\n", 	    source_name(aSourceFile));  	fprintf(list_file(), A 	    "     %ld lines, %ld routines (avg len %ld), %ld calls\n\n", = 	    source_lines(aSourceFile), source_routines(aSourceFile), < 	    source_avglen(aSourceFile), source_calls(aSourceFile));     }      if (log_full_enabled()) { A 	printf("FILE %s analysis complete\n", source_name(aSourceFile)); D 	printf("     %ld lines, %ld routines (avg len %ld), %ld calls\n\n",= 	    source_lines(aSourceFile), source_routines(aSourceFile), < 	    source_avglen(aSourceFile), source_calls(aSourceFile));     }  }   N /*************************************************************************++*/ void list_product_begin(N /* Writes status messages indicating that analysis of a product file is	    */ /* beginning.								    */        char    *aProductName   		/* (READ, BY ADDR):					    */( 		/* Product file name string.				    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (list_enabled()) { C 	fprintf(list_file(), "%s %s\n", PROGRAM_IDENT, PROGRAM_COPYRIGHT); I 	fprintf(list_file(), "\nPRODUCT %s analysis started\n\n", aProductName);      }      if (log_enabled()) {5 	printf("%s %s\n", PROGRAM_IDENT, PROGRAM_COPYRIGHT); /         printf("PRODUCT %s\n", product_name()); C 	printf("        (in file %s) analysis started\n\n", aProductName);      }  }   N /*************************************************************************++*/ void list_analysis_complete(N /* Writes status messages indicating that analysis of all source files is   */ /* complete.								    */       char    *aProductName   		/* (READ, BY ADDR):					    */( 		/* Product file name string.				    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (list_enabled()) { I 	fprintf(list_file(), "\nPRODUCT %s all source file analysis complete\n",  	    aProductName);  	fprintf(list_file(), N     "        %ld files, %ld lines, %ld routines (avg len %ld), %ld calls\n\n",D 	    total_files(), total_lines(), total_routines(), total_avglen(), 	    total_calls());     }      if (log_full_enabled()) { ; 	printf("\nPRODUCT %s all source file analysis complete\n",  	    aProductName);  	printf(N     "        %ld files, %ld lines, %ld routines (avg len %ld), %ld calls\n\n",D 	    total_files(), total_lines(), total_routines(), total_avglen(), 	    total_calls());     }  }   N /*************************************************************************++*/ void list_product_end(L /* Writes status messages indicating that analysis and reporting of a	    */$ /* product is complete.							    */       char    *aProductName   		/* (READ, BY ADDR):					    */( 		/* Product file name string.				    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (list_enabled()) {  	fprintf(list_file(), I 	    "\nPRODUCT %s all analysis and reporting complete\n", aProductName);      }      if (log_full_enabled()) { ; 	printf("PRODUCT %s all analysis and reporting complete\n",  	aProductName);      }  }   N /*************************************************************************++*/ void list_def_begin(K /* Writes status messages indicating that the beginning of a routine	    */ ) /* definition has been found.						    */        SOURCEFILE	*aSourceFile,  		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */*       DEFINITION	*aRoutineDef	  		/* (READ, BY ADDR):					    */) 		/* Routine definition record.				    */*  ! )	/* No return value.						    */ G 	/*****************************************************************--*/r   {u     if (list_enabled()) {i; 	fprintf(list_file(), "\nBEGIN %s in %s at line %ld/%ld\n", 5 	    def_name(aRoutineDef), source_name(aSourceFile),a7 	    def_begin(aRoutineDef), source_line(aSourceFile));  	restore_list_column();      }E     if (log_def_enabled()) {> 	printf("BEGIN %s in %s at line %ld\n", def_name(aRoutineDef),9 	    source_name(aSourceFile), source_line(aSourceFile));      }	 }   N /*************************************************************************++*/ void list_def_end(N /* Writes status messages indicating that the end of a routine definition   */ /* has been found.							    */        SOURCEFILE	*aSourceFile,  		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */)       DEFINITION	*aRoutineDefi  		/* (READ, BY ADDR):					    */) 		/* Routine definition record.				    */*  ! )	/* No return value.						    */*G 	/*****************************************************************--*/_   {)     if (list_enabled()) {l 	fprintf(list_file(), > 	    "\nEND %s in %s at line %ld\n    %ld lines, %ld calls\n",5 	    def_name(aRoutineDef), source_name(aSourceFile), 7 	    source_line(aSourceFile), def_length(aRoutineDef),a! 	    def_num_calls(aRoutineDef));  	restore_list_column();      }R4     if (log_def_enabled() && !log_brief_enabled()) {E 	printf("END   %s in %s at line %ld\n      %ld lines, %ld calls\n\n",*5 	    def_name(aRoutineDef), source_name(aSourceFile), 7 	    source_line(aSourceFile), def_length(aRoutineDef),e! 	    def_num_calls(aRoutineDef));      }  }   N /*************************************************************************++*/ void list_ref(N /* Writes status messages indicating that a routine reference (call) has    */ /* been found.								    */       SOURCEFILE	*aSourceFile,  		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */1       REFERENCE	*aRoutineRef  		/* (READ, BY ADDR):					    */( 		/* Routine reference record.				    */  ! )	/* No return value.						    */*G 	/*****************************************************************--*/r   {e     if (list_enabled()) {lF 	fprintf(list_file(), "\nCALL %s in %s at line %ld, line %ld of %s\n",5 	    ref_name(aRoutineRef), source_name(aSourceFile), 7 	    source_line(aSourceFile), ref_offset(aRoutineRef),e( 	    def_name(ref_caller(aRoutineRef))); 	restore_list_column();*     }*     if (log_ref_enabled()) {7 	printf("CALL  %s in %s at line %ld, line %ld of %s\n",	5 	    ref_name(aRoutineRef), source_name(aSourceFile), 7 	    source_line(aSourceFile), ref_offset(aRoutineRef),u( 	    def_name(ref_caller(aRoutineRef)));     }l }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 