N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ 5 /*  MODULE:	Object Management Support Header			    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This header file contains all type definitions for the	    */N /*  object types used by Routine Analyzer. Member access routines (get/set  */N /*  values) and a number of object management routines are implemented here */ /*  as macros.								    */ /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ P /*  V0.1-01 09-JAN-1994 Steve Branam                                        */  N /*                                                                          */N /*      Replace LANGUAGE_C with LANGUAGE_CC to avoid conflict with Unix     */N /*      C compiler predefined symbol.                                       */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #ifndef __OBJECTS_H  #define __OBJECTS_H    /*									    */ $ /* String object names.							    */ /*									    */   % #define OBJ_NAME_FILENAME	"File name" 3 #define OBJ_NAME_LANG_EXT	"Language file extension" + #define OBJ_NAME_ROUTINENAME	"Routine name" , #define OBJ_NAME_AUTHORNAME	"Program author"  N /****************************************************************************/ /*									    */ " /* LIST ENTRY OBJECTS							    */ /*									    */ C /*	This general class of objects can be strung together on a	    */ I /*	doubly-linked list. There are several specific subtypes in this	    */  /*	general class:							    */ /*									    */ ) /*	Language Translation Record					    */  /*									    */ I /*	    Contains all the information for a file extension-to-language   */  /*	    translation.						    */  /*									    */ ! /*	Source File Record						    */  /*									    */ D /*	    Contains all the information for a single source file.	    */ /*									    */ ' /*	Routine Definition Record					    */  /*									    */ I /*	    Contains all the information for the definition of a single	    */  /*	    routine.							    */ /*									    */ & /*	Routine Reference Record					    */ /*									    */ I /*	    Contains all the information for a given reference (call) to    */  /*	    a routine.							    */ /*									    */ N /****************************************************************************/  N /****************************************************************************/ /*									    */ 5 /* Language translation record object type.				    */  /*									    */ N /****************************************************************************/  1 #define OBJ_NAME_LANGTRANS	"LANGUAGE_TRANSLATION"   8 typedef enum {				    /* List of known languages.	    */     LANGUAGE_UNKNOWN,      LANGUAGE_TEXT,     LANGUAGE_DCL,      LANGUAGE_BLISS,      LANGUAGE_CC  } SOURCE_LANGUAGE;  " typedef struct lang_trans_record {1     LIST_ENTRY_HDR			    /* List linkage.		    */  	    entry_hdr; 9     char    *fext;			    /* File extension string.	    */ 3     SOURCE_LANGUAGE			    /* Language code.		    */ 
 	    code; } LANGUAGE_TRANSLATION;    /*									    */ 9 /* Language translation member access routines.				    */  /*									    */     #define lang_fext(l) ((l)->fext)  #define lang_code(l) ((l)->code)+ #define set_lang_fext(l, s) ((l)->fext = s) + #define set_lang_code(l, x) ((l)->code = x)    /*									    */ 6 /* Language translation management routines.				    */ /*									    */   9 #define add_lang(l) (enqueue_entry(global_langlist(), l)) 8 #define remove_lang() (dequeue_entry(global_langlist()))  N /****************************************************************************/ /*									    */ - /* Source file record object type.					    */  /*									    */ N /****************************************************************************/  ( #define OBJ_NAME_SOURCEFILE	"SOURCEFILE"   typedef struct source_record {1     LIST_ENTRY_HDR			    /* List linkage.		    */  	    entry_hdr; 9     int	    seqnum;			    /* File sequence number.	    */ .     char    *name;			    /* File name.		    */=     char    *author;			    /* Program author, that's me!   */ :     int	    tabsize;			    /* Source text tab size.	    */9     long    lines;			    /* Total number of lines.	    */ >     long    comments;			    /* Number comment-only lines.   */@     long    statements;			    /* Number statement-only lines. */8     long    mixed;			    /* Number mixed comment/	    */$ 					    /* statement lines.		    */>     long    routines;			    /* Number routines defined.	    */=     long    rlength;			    /* Length of all routine defs.  */ ;     long    calls;			    /* Number of routine calls made */ ! 					    /* in this file.		    */ =     LIST    reflist;			    /* List of routines defined in  */ ( 					    /* this file, treated as	    */ 					    /* callers.			    */ @     int	    byfilefile;			    /* By-file report file number   */  					    /* for linking.		    */
 } SOURCEFILE;    /*									    */ 7 /* Source file record member access routines.				    */  /*									    */   ' #define source_seq(src) ((src)->seqnum) & #define source_name(src) ((src)->name)( #define source_lines(src) ((src)->lines), #define source_tabsize(src) ((src)->tabsize)+ #define source_line(src) ((src)->lines + 1) . #define source_comments(src) ((src)->comments)2 #define source_statements(src) ((src)->statements)( #define source_mixed(src) ((src)->mixed)W #define source_empty(src) ((src)->lines-(src)->mixed-(src)->comments-(src)->statements) . #define source_routines(src) ((src)->routines), #define source_rlength(src) ((src)->rlength)p #define source_avglen(src) (source_routines(src)==0?0:((source_rlength(src) * 10)/source_routines(src) + 5)/ 10)( #define source_calls(src) ((src)->calls)- #define source_reflist(src) (&(src)->reflist) 2 #define source_byfilefile(src) ((src)->byfilefile)= #define set_source_byfilefile(src, f) ((src)->byfilefile = f) C #define inc_source_comments(src) ((src)->lines++,(src)->comments++) G #define inc_source_statements(src) ((src)->lines++,(src)->statements++) = #define inc_source_mixed(src) ((src)->lines++,(src)->mixed++) . #define inc_source_empty(src) ((src)->lines++)4 #define inc_source_routines(src) ((src)->routines++)8 #define inc_source_rlength(src, x) ((src)->rlength += x)4 #define inc_source_calls(src, x) ((src)->calls += x)   /*									    */ 4 /* Source file record management routines.				    */ /*									    */   P #define add_srcref(s,r) (insert_ordered_entry(&(s)->reflist, r, compare_caller))  N /****************************************************************************/ /*									    */ 3 /* Routine definition record object type.				    */  /*									    */ N /****************************************************************************/   typedef enum {     NOT_YET_EVALUATED,     TREE_REQUIRED,     TREE_NOT_REQUIRED  } TREE_REQ;   ( #define OBJ_NAME_DEFINITION	"DEFINITION"  " typedef struct definition_record {1     LIST_ENTRY_HDR			    /* List linkage.		    */  	    entry_hdr; 1     char    *name;			    /* Routine name.		    */      struct source_record6 	    *source;			    /* Ptr to source file record.   */D     struct definition_record		    /* Ptr to root of call tree.    */ 	    *rootdef;;     long    begin;			    /* Beginning line in source.    */ 7     long    end;			    /* Ending line in source.	    */ :     LIST    refs;			    /* List of referenced routines. */8     LIST    callers;			    /* List of referencing	    */ 					    /* routines.		    */ 6     TREE_REQ				    /* Call tree required flag.	    */ 	    needs_tree;>     int	    treesize;			    /* Number of nodes in tree.	    */>     int	    xreffile;			    /* Xref report file number for  */ 					    /* linking.			    */ 
 } DEFINITION;*   /*									    */*= /* Routine definition record member access routines.			    */	 /*									    */I  # #define def_name(def) ((def)->name)	' #define def_source(def) ((def)->source)m& #define def_root(def) ((def)->rootdef)% #define def_begin(def) ((def)->begin)w! #define def_end(def) ((def)->end) ; #define def_length(def) (def_end(def) - def_begin(def) + 1)/$ #define def_refs(def) (&(def)->refs)* #define def_callers(def) (&(def)->callers)2 #define def_tree_required(def) ((def)->needs_tree), #define def_tree_size(def) ((def)->treesize)+ #define def_xreffile(def) ((def)->xreffile)n2 #define set_def_source(def, s) ((def)->source = s)1 #define set_def_root(def, x) ((def)->rootdef = x)O0 #define set_def_begin(def, x) ((def)->begin = x), #define set_def_end(def, x) ((def)->end = x)8 #define set_def_tree_req(def, x) ((def)->needs_tree = x)7 #define set_def_tree_size(def, x) ((def)->treesize = x)l6 #define set_def_xreffile(def, f) ((def)->xreffile = f)< #define def_num_callers(def) (list_entries(&(def)->callers))7 #define def_num_calls(def) (list_entries(&(def)->refs))1   /*									    */ : /* Routine definition record management routines.			    */ /*									    */	  8 #define add_ref(d, r) (append_list_entry(&(d)->refs, r))2 #define push_ref(d, r) (push_entry(&(d)->refs, r))* #define pop_ref(d) (pop_entry(&(d)->refs))P #define add_caller(d,r) (insert_ordered_entry(&(d)->callers, r, compare_caller))C #define find_ref(d,r) (find_list_entry(&(d)->refs, r, compare_ref))nQ #define find_caller(d,r) (find_list_entry(&(d)->callers, r, compare_caller_name))P6 #define isdefined_routine(def) ((def)->source != NULL)s #define isalready_expanded(def, root) (!tree_inline_disabled() && isdefined_routine(def) && (def)->rootdef == root)   N /****************************************************************************/ /*									    */e2 /* Routine reference record object type.				    */ /*									    */ N /****************************************************************************/  & #define OBJ_NAME_REFERENCE	"REFERENCE"  ! typedef struct reference_record {*1     LIST_ENTRY_HDR			    /* List linkage.		    */  	    entry_hdr;iD     struct definition_record		    /* Ptr to routine definition    */* 	    *definition;		    /* record.			    */:     long    line;			    /* Line in source where called. */D     struct definition_record		    /* Ptr to routine definition    *// 	    *caller;			    /* record of caller.	    */	 } REFERENCE;   /*									    */i< /* Routine reference record member access routines.			    */ /*									    */m  - #define ref_definition(ref) (ref->definition) 5 #define ref_name(ref) (def_name(ref_definition(ref)))*! #define ref_line(ref) (ref->line)*% #define ref_caller(ref) (ref->caller)*H #define ref_offset(ref) (ref_line(ref) - def_begin(ref_caller(ref)) + 1)   /*									    */ 9 /* Routine reference record management routines.			    */* /*									    */*  @ #define isrecursive_ref(ref, root) (find_ref(root, ref) != NULL)  N /****************************************************************************/ /*									    */o# /* Forward references.							    */K /*									    */EN /****************************************************************************/   REFERENCE *find_ref_in_tree(); int compare_ref(); int compare_file();i int compare_caller();  char *def_ident();    #endif /* #ifndef __OBJECTS_H */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              