N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ ( /*  MODULE:	Report Generation					    */ /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This module contains the routines for generating Routine   */7 /*  Analyzer reports, for all output formats.				    */  /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include <stdio.h> #include <ctype.h> #include "ranalyzer.h" #include "reports.h"  ' extern GLOBAL_DATABASE gGlobalDatabase;   . int tree_greater_than(){return 1;} /* dummy */    D /* dummy routines for currently unimplemented report formats		    */   void rpt_defined_rtf_hdr(){} void rpt_defined_rtf_entry(){} void rpt_defined_rtf_end(){}  void rpt_defined_winhelp_hdr(){}" void rpt_defined_winhelp_entry(){}  void rpt_defined_winhelp_end(){}  void rpt_defined_vmshelp_hdr(){}" void rpt_defined_vmshelp_entry(){}  void rpt_defined_vmshelp_end(){}   void rpt_undefined_rtf_hdr(){}  void rpt_undefined_rtf_entry(){} void rpt_undefined_rtf_end(){}" void rpt_undefined_winhelp_hdr(){}$ void rpt_undefined_winhelp_entry(){}" void rpt_undefined_winhelp_end(){}" void rpt_undefined_vmshelp_hdr(){}$ void rpt_undefined_vmshelp_entry(){}" void rpt_undefined_vmshelp_end(){}   void rpt_calls_rtf_hdr(){} void rpt_calls_rtf_entry(){} void rpt_calls_rtf_end(){} void rpt_calls_winhelp_hdr(){}  void rpt_calls_winhelp_entry(){} void rpt_calls_winhelp_end(){} void rpt_calls_vmshelp_hdr(){}  void rpt_calls_vmshelp_entry(){} void rpt_calls_vmshelp_end(){}   void rpt_xref_rtf_hdr(){}  void rpt_xref_rtf_entry(){}  void rpt_xref_rtf_end(){}  void rpt_xref_winhelp_hdr(){}  void rpt_xref_winhelp_entry(){}  void rpt_xref_winhelp_end(){}  void rpt_xref_vmshelp_hdr(){}  void rpt_xref_vmshelp_entry(){}  void rpt_xref_vmshelp_end(){}    void rpt_tree_rtf_hdr(){}  void rpt_tree_rtf_entry(){}  void rpt_tree_rtf_end(){}  void rpt_tree_winhelp_hdr(){}  void rpt_tree_winhelp_entry(){}  void rpt_tree_winhelp_end(){}  void rpt_tree_vmshelp_hdr(){}  void rpt_tree_vmshelp_entry(){}  void rpt_tree_vmshelp_end(){}    void rpt_byfile_text_hdr(){} void rpt_byfile_text_entry(){} void rpt_byfile_text_end(){} void rpt_byfile_rtf_hdr(){}  void rpt_byfile_rtf_entry(){}  void rpt_byfile_rtf_end(){}  void rpt_byfile_winhelp_hdr(){} ! void rpt_byfile_winhelp_entry(){}  void rpt_byfile_winhelp_end(){}  void rpt_byfile_vmshelp_hdr(){} ! void rpt_byfile_vmshelp_entry(){}  void rpt_byfile_vmshelp_end(){}    void rpt_file_text_hdr(){} void rpt_file_text_entry(){} void rpt_file_text_end(){} void rpt_file_rtf_hdr(){}  void rpt_file_rtf_entry(){}  void rpt_file_rtf_end(){}  void rpt_file_winhelp_hdr(){}  void rpt_file_winhelp_entry(){}  void rpt_file_winhelp_end(){}  void rpt_file_vmshelp_hdr(){}  void rpt_file_vmshelp_entry(){}  void rpt_file_vmshelp_end(){}    void rpt_source_text_hdr(){} void rpt_source_text_entry(){} void rpt_source_text_end(){} void rpt_source_rtf_hdr(){}  void rpt_source_rtf_entry(){}  void rpt_source_rtf_end(){}  void rpt_source_winhelp_hdr(){} ! void rpt_source_winhelp_entry(){}  void rpt_source_winhelp_end(){}  void rpt_source_vmshelp_hdr(){} ! void rpt_source_vmshelp_entry(){}  void rpt_source_vmshelp_end(){}    /*									    */ 5 /* Formatter routines forward declarations.				    */  /*									    */    void rpt_defined_text_hdr(); void rpt_defined_text_entry(); void rpt_defined_text_end(); void rpt_defined_sdml_hdr(); void rpt_defined_sdml_entry(); void rpt_defined_sdml_end(); void rpt_defined_html_hdr(); void rpt_defined_html_entry(); void rpt_defined_html_end(); void rpt_defined_rtf_hdr();  void rpt_defined_rtf_entry();  void rpt_defined_rtf_end();  void rpt_defined_winhelp_hdr(); ! void rpt_defined_winhelp_entry();  void rpt_defined_winhelp_end();  void rpt_defined_vmshelp_hdr(); ! void rpt_defined_vmshelp_entry();  void rpt_defined_vmshelp_end();    void rpt_undefined_text_hdr();  void rpt_undefined_text_entry(); void rpt_undefined_text_end(); void rpt_undefined_sdml_hdr();  void rpt_undefined_sdml_entry(); void rpt_undefined_sdml_end(); void rpt_undefined_html_hdr();  void rpt_undefined_html_entry(); void rpt_undefined_html_end(); void rpt_undefined_rtf_hdr();  void rpt_undefined_rtf_entry();  void rpt_undefined_rtf_end(); ! void rpt_undefined_winhelp_hdr(); # void rpt_undefined_winhelp_entry(); ! void rpt_undefined_winhelp_end(); ! void rpt_undefined_vmshelp_hdr(); # void rpt_undefined_vmshelp_entry(); ! void rpt_undefined_vmshelp_end();    void rpt_calls_text_hdr(); void rpt_calls_text_entry(); void rpt_calls_text_end(); void rpt_calls_sdml_hdr(); void rpt_calls_sdml_entry(); void rpt_calls_sdml_end(); void rpt_calls_html_hdr(); void rpt_calls_html_entry(); void rpt_calls_html_end(); void rpt_calls_rtf_hdr();  void rpt_calls_rtf_entry();  void rpt_calls_rtf_end();  void rpt_calls_winhelp_hdr();  void rpt_calls_winhelp_entry();  void rpt_calls_winhelp_end();  void rpt_calls_vmshelp_hdr();  void rpt_calls_vmshelp_entry();  void rpt_calls_vmshelp_end();    void rpt_xref_text_hdr();  void rpt_xref_text_entry();  void rpt_xref_text_end();  void rpt_xref_sdml_hdr();  void rpt_xref_sdml_entry();  void rpt_xref_sdml_end();  void rpt_xref_html_hdr();  void rpt_xref_html_entry();  void rpt_xref_html_end();  void rpt_xref_rtf_hdr(); void rpt_xref_rtf_entry(); void rpt_xref_rtf_end(); void rpt_xref_winhelp_hdr(); void rpt_xref_winhelp_entry(); void rpt_xref_winhelp_end(); void rpt_xref_vmshelp_hdr(); void rpt_xref_vmshelp_entry(); void rpt_xref_vmshelp_end();   void rpt_tree_text_hdr();  void rpt_tree_text_entry();  void rpt_tree_text_end();  void rpt_tree_sdml_hdr();  void rpt_tree_sdml_entry();  void rpt_tree_sdml_end();  void rpt_tree_html_hdr();  void rpt_tree_html_entry();  void rpt_tree_html_end();  void rpt_tree_rtf_hdr(); void rpt_tree_rtf_entry(); void rpt_tree_rtf_end(); void rpt_tree_winhelp_hdr(); void rpt_tree_winhelp_entry(); void rpt_tree_winhelp_end(); void rpt_tree_vmshelp_hdr(); void rpt_tree_vmshelp_entry(); void rpt_tree_vmshelp_end();   void rpt_byfile_text_hdr();  void rpt_byfile_text_entry();  void rpt_byfile_text_end();  void rpt_byfile_sdml_hdr();  void rpt_byfile_sdml_entry();  void rpt_byfile_sdml_end();  void rpt_byfile_html_hdr();  void rpt_byfile_html_entry();  void rpt_byfile_html_end();  void rpt_byfile_rtf_hdr(); void rpt_byfile_rtf_entry(); void rpt_byfile_rtf_end(); void rpt_byfile_winhelp_hdr();  void rpt_byfile_winhelp_entry(); void rpt_byfile_winhelp_end(); void rpt_byfile_vmshelp_hdr();  void rpt_byfile_vmshelp_entry(); void rpt_byfile_vmshelp_end();   void rpt_file_text_hdr();  void rpt_file_text_entry();  void rpt_file_text_end();  void rpt_file_sdml_hdr();  void rpt_file_sdml_entry();  void rpt_file_sdml_end();  void rpt_file_html_hdr();  void rpt_file_html_entry();  void rpt_file_html_end();  void rpt_file_rtf_hdr(); void rpt_file_rtf_entry(); void rpt_file_rtf_end(); void rpt_file_winhelp_hdr(); void rpt_file_winhelp_entry(); void rpt_file_winhelp_end(); void rpt_file_vmshelp_hdr(); void rpt_file_vmshelp_entry(); void rpt_file_vmshelp_end();   void rpt_source_text_hdr();  void rpt_source_text_entry();  void rpt_source_text_end();  void rpt_source_sdml_hdr();  void rpt_source_sdml_entry();  void rpt_source_sdml_end();  void rpt_source_html_hdr();  void rpt_source_html_entry();  void rpt_source_html_end();  void rpt_source_rtf_hdr(); void rpt_source_rtf_entry(); void rpt_source_rtf_end(); void rpt_source_winhelp_hdr();  void rpt_source_winhelp_entry(); void rpt_source_winhelp_end(); void rpt_source_vmshelp_hdr();  void rpt_source_vmshelp_entry(); void rpt_source_vmshelp_end();   /*									    */*0 /* Report formatting dispatch tables.					    */ /*									    */   7 #define report_hdr_routine(t) ((t)[report_format()][0]) 9 #define report_entry_routine(t) ((t)[report_format()][1]) 7 #define report_end_routine(t) ((t)[report_format()][2]),   typedef void (*FORMATTER)();  . static FORMATTER rpt_defined_routines[][3] = {I     {rpt_defined_text_hdr, rpt_defined_text_entry, rpt_defined_text_end},nI     {rpt_defined_sdml_hdr, rpt_defined_sdml_entry, rpt_defined_sdml_end},*I     {rpt_defined_html_hdr, rpt_defined_html_entry, rpt_defined_html_end},*H     {rpt_defined_rtf_hdr,  rpt_defined_rtf_entry,  rpt_defined_rtf_end},R     {rpt_defined_winhelp_hdr, rpt_defined_winhelp_entry, rpt_defined_winhelp_end},Q     {rpt_defined_vmshelp_hdr, rpt_defined_vmshelp_entry, rpt_defined_vmshelp_end}> };  0 static FORMATTER rpt_undefined_routines[][3] = {O     {rpt_undefined_text_hdr, rpt_undefined_text_entry, rpt_undefined_text_end}, O     {rpt_undefined_sdml_hdr, rpt_undefined_sdml_entry, rpt_undefined_sdml_end},oO     {rpt_undefined_html_hdr, rpt_undefined_html_entry, rpt_undefined_html_end},eN     {rpt_undefined_rtf_hdr,  rpt_undefined_rtf_entry,  rpt_undefined_rtf_end},X     {rpt_undefined_winhelp_hdr, rpt_undefined_winhelp_entry, rpt_undefined_winhelp_end},W     {rpt_undefined_vmshelp_hdr, rpt_undefined_vmshelp_entry, rpt_undefined_vmshelp_end}u };  , static FORMATTER rpt_calls_routines[][3] = {C     {rpt_calls_text_hdr, rpt_calls_text_entry, rpt_calls_text_end},tC     {rpt_calls_sdml_hdr, rpt_calls_sdml_entry, rpt_calls_sdml_end},pC     {rpt_calls_html_hdr, rpt_calls_html_entry, rpt_calls_html_end},sB     {rpt_calls_rtf_hdr,  rpt_calls_rtf_entry,  rpt_calls_rtf_end},L     {rpt_calls_winhelp_hdr, rpt_calls_winhelp_entry, rpt_calls_winhelp_end},K     {rpt_calls_vmshelp_hdr, rpt_calls_vmshelp_entry, rpt_calls_vmshelp_end}h };  + static FORMATTER rpt_xref_routines[][3] = {c@     {rpt_xref_text_hdr, rpt_xref_text_entry, rpt_xref_text_end},@     {rpt_xref_sdml_hdr, rpt_xref_sdml_entry, rpt_xref_sdml_end},@     {rpt_xref_html_hdr, rpt_xref_html_entry, rpt_xref_html_end},?     {rpt_xref_rtf_hdr,  rpt_xref_rtf_entry,  rpt_xref_rtf_end},nI     {rpt_xref_winhelp_hdr, rpt_xref_winhelp_entry, rpt_xref_winhelp_end},dH     {rpt_xref_vmshelp_hdr, rpt_xref_vmshelp_entry, rpt_xref_vmshelp_end} };  + static FORMATTER rpt_tree_routines[][3] = {r@     {rpt_tree_text_hdr, rpt_tree_text_entry, rpt_tree_text_end},@     {rpt_tree_sdml_hdr, rpt_tree_sdml_entry, rpt_tree_sdml_end},@     {rpt_tree_html_hdr, rpt_tree_html_entry, rpt_tree_html_end},?     {rpt_tree_rtf_hdr,  rpt_tree_rtf_entry,  rpt_tree_rtf_end},_I     {rpt_tree_winhelp_hdr, rpt_tree_winhelp_entry, rpt_tree_winhelp_end},{H     {rpt_tree_vmshelp_hdr, rpt_tree_vmshelp_entry, rpt_tree_vmshelp_end} };  - static FORMATTER rpt_byfile_routines[][3] = {hF     {rpt_byfile_text_hdr, rpt_byfile_text_entry, rpt_byfile_text_end},F     {rpt_byfile_sdml_hdr, rpt_byfile_sdml_entry, rpt_byfile_sdml_end},F     {rpt_byfile_html_hdr, rpt_byfile_html_entry, rpt_byfile_html_end},E     {rpt_byfile_rtf_hdr,  rpt_byfile_rtf_entry,  rpt_byfile_rtf_end}, O     {rpt_byfile_winhelp_hdr, rpt_byfile_winhelp_entry, rpt_byfile_winhelp_end},mN     {rpt_byfile_vmshelp_hdr, rpt_byfile_vmshelp_entry, rpt_byfile_vmshelp_end} };  + static FORMATTER rpt_file_routines[][3] = {e@     {rpt_file_text_hdr, rpt_file_text_entry, rpt_file_text_end},@     {rpt_file_sdml_hdr, rpt_file_sdml_entry, rpt_file_sdml_end},@     {rpt_file_html_hdr, rpt_file_html_entry, rpt_file_html_end},?     {rpt_file_rtf_hdr,  rpt_file_rtf_entry,  rpt_file_rtf_end},lI     {rpt_file_winhelp_hdr, rpt_file_winhelp_entry, rpt_file_winhelp_end},rH     {rpt_file_vmshelp_hdr, rpt_file_vmshelp_entry, rpt_file_vmshelp_end} };  - static FORMATTER rpt_source_routines[][3] = {rF     {rpt_source_text_hdr, rpt_source_text_entry, rpt_source_text_end},F     {rpt_source_sdml_hdr, rpt_source_sdml_entry, rpt_source_sdml_end},F     {rpt_source_html_hdr, rpt_source_html_entry, rpt_source_html_end},E     {rpt_source_rtf_hdr,  rpt_source_rtf_entry,  rpt_source_rtf_end},rO     {rpt_source_winhelp_hdr, rpt_source_winhelp_entry, rpt_source_winhelp_end},pN     {rpt_source_vmshelp_hdr, rpt_source_vmshelp_entry, rpt_source_vmshelp_end} };  N /*************************************************************************++*/ int tree_size(K /* Computes the size (number of nodes) of a routine's call tree. The	    */uL /* current implementation is only an approximation, showing a minimal	    */N /* tree size, since it only looks down one level; deep trees will throw it  */ /* off.									    */       DEFINITION
 	    *aDef' 	    /* (MODIFY, BY ADDR):  					    */oG 	    /* Definition to check. The tree size will be cached in this    */t 	    /* definition.						    */d  % )	/* Returns size of tree.					    */uG 	/*****************************************************************--*/u   {n1     int	    nodes;			    /* Node counter.		    */o7     REFERENCE				    /* Current reference entry.     */o
 	    *called;m6     DEFINITION				    /* Definition for current	    *// 	    *curdef;			    /* reference entry.		    */c  H     if (def_tree_size(aDef) != 0) {	    /* Already been computed.	    */ 	return def_tree_size(aDef);     }tD     else if (!needs_tree(aDef)) {	    /* No tree for routine.	    */
 	return 0;     }d2     else {				    /* Check called routines.	    */5 	for (nodes = 0, called = list_first(def_refs(aDef));s= 	     called != NULL; nodes++, called = next_entry(called)) {e. 	    if (needs_tree(ref_definition(called))) {1 		nodes += def_num_calls(ref_definition(called));  	    } 	}  	set_def_tree_size(aDef, nodes); 	return nodes;     }_ }l  N /*************************************************************************++*/ int fold_string(L /* Folds a string at the non-alphanumeric nearest the right margin. A	    */L /* whitespace is removed; anything else is left in front of the fold.	    */       char    *aSrc,% 	    /* (READ, BY ADDR):  					    */e- 	    /* Source string to be folded.				    */o       int	    vPos,)# 	    /* (READ, BY VAL):						    */rG 	    /* Position in source string where characters should be copied  */rG 	    /* from. When repeatedly folding a long string, this should	    */tG 	    /* be the return value from a previous call to fold_string. It  */d> 	    /* is assumed to be less than the length of aSrc.		    */       char    *aPrefix,o# 	    /* (READ, BY VAL):						    */tC 	    /* Optional prefix string to be written to aDest before	    */_G 	    /* characters from aSrc. Must be shorter than vLength, or it    */ G 	    /* will be ignored. If NULL ptr is passed, no prefix is used.   */b       char    *aDest,d$ 	    /* (WRITE, BY ADDR):					    */G 	    /* Destination buffer into which string is to be folded. It is  */(B 	    /* assumed to be at least vLength + 1 characters long.	    */       int	    vLength;# 	    /* (READ, BY VAL):						    */oA 	    /* Maximum length of string to be written into aDest.	    */r  H )	/* Returns position in aStr where copying stopped. It will be equal */G 	/* to the length of aSrc when all characters have been copied from  */oG 	/* aSrc.  This may be used as the vPos value on a successive call   */l 	/* to fold_string.						    */)G 	/*****************************************************************--*/l   {_;     int	    curlen = 0;			    /* Length accumulator.	    */ <     int	    remlen;			    /* Remaining length of string.  */:     int	    fold;			    /* Point at which to fold it.   */>     int	    spaceflag = 0;		    /* Flag: fold at space.	    */  B     if (aPrefix != NULL && (curlen = strlen(aPrefix)) < vLength) {: 	strcpy(aDest, aPrefix);		    /* Copy prefix first.	    */     }_  !     remlen = strlen(&aSrc[vPos]);eL     if (curlen + remlen <= vLength) {	    /* Remainder of string fits	    */@ 	strcpy(&aDest[curlen], &aSrc[vPos]);/* without folding.		    */ 	return vPos + remlen;     }t4     else {				    /* Need to fold it, find fold   */ 					    /* point.			    */t) 	for (fold = vPos + vLength - curlen - 1;h( 	    fold > vPos && isalnum(aSrc[fold]);
 	    fold--);u< 	if (fold == vPos) {		    /* Fold point not found, fold   */A 	    fold = vPos + vLength - 1;	    /* it at right margin.	    */h 	}/ 	else if (!(spaceflag = isspace(aSrc[fold]))) {o+ 					    /* Folding at non-alphanum,	    */ 5 	    fold++;			    /* non-space, fold after it.    */] 	}+ 					    /* Copy folded part of string.  */A3 	strncpy(&aDest[curlen], &aSrc[vPos], fold - vPos);t 	aDest[fold - vPos] = '\0';r9 	if (spaceflag) {		    /* Remove whitespace at fold.   */d 	    fold++; 	}6 	return fold;			    /* Next fold will start after   */"     }					    /* this one.		    */ }n  N /*************************************************************************++*/ char *report_filext(N /* Returns the file extension string to be used for report files, based on  */2 /* the type of report output requested.					    */  !     /* No arguments.							    */t  8 )	/* Returns ptr to file name extension string.			    */G 	/*****************************************************************--*/m   {,4     if (rpt_sdml_enabled())	return OUTFILE_EXT_SDML;4     if (rpt_html_enabled())	return OUTFILE_EXT_HTML;2     if (rpt_rtf_enabled())	return OUTFILE_EXT_RTF;:     if (rpt_winhelp_enabled())	return OUTFILE_EXT_WINHELP;:     if (rpt_vmshelp_enabled())	return OUTFILE_EXT_VMSHELP;B     return OUTFILE_EXT_TEXT;		    /* Default output format.	    */ }_  N /*************************************************************************++*/ SOURCEFILE *next_defining_file(_C /* Returns next source file containing routine definitions.		    */_       SOURCEFILE 	    *aSourceFiles% 	    /* (READ, BY ADDR):  					    */t( 	    /* Source file to check.					    */  A )	/* Returns ptr to source file, or NULL if one not found.	    */ G 	/*****************************************************************--*/,   { 8     SOURCEFILE				    /* Current file being checked.  */ 	    *curfile; 	    tM     for (curfile = next_entry(aSourceFile); /* Scan rest of file list.	    */x 	curfile != NULL;e! 	curfile = next_entry(curfile)) {p% 	if (source_routines(curfile) > 0) {  < 	    return curfile;		    /* Found another with defs.	    */ 	}     }t3     return NULL;			    /* No more with defs.	    */} }   N /*************************************************************************++*/ SOURCEFILE *prev_defining_file(hG /* Returns previous source file containing routine definitions.		    */s       SOURCEFILE 	    *aSourceFilep% 	    /* (READ, BY ADDR):  					    */ ( 	    /* Source file to check.					    */  A )	/* Returns ptr to source file, or NULL if one not found.	    */rG 	/*****************************************************************--*/_   {n8     SOURCEFILE				    /* Current file being checked.  */ 	    *curfile; 	     K     for (curfile = prev_entry(aSourceFile); /* Scan prior file list.	    */  	curfile != NULL;r! 	curfile = prev_entry(curfile)) {r% 	if (source_routines(curfile) > 0) { r< 	    return curfile;		    /* Found another with defs.	    */ 	}     },4     return NULL;			    /* No prior with defs.	    */ }i  N /*************************************************************************++*/ int isfirst_in_file(N /* Determines whether a definition entry is the first one in its source	    */L /* file, assuming the definitions are currently sorted in file order.	    */       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */t' 	    /* Definition to check.					    */f  A )	/* Returns flag indicating whether definition is first:		    */_/ 	/*  1 - Definition is first in file.				    */_2 	/*  0 - Definition is not first in file.			    */G 	/*****************************************************************--*/f   {i1     DEFINITION				    /* Ptr to prev def.		    */_ 	    *prevdef;  /     if ((prevdef = prev_entry(aDef)) != NULL) {t2 	return (def_source(aDef) != def_source(prevdef));     }c
     return 1;_ }r  N /*************************************************************************++*/ int islast_in_file(eM /* Determines whether a definition entry is the last one in its source	    */ L /* file, assuming the definitions are currently sorted in file order.	    */       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */}' 	    /* Definition to check.					    */c  @ )	/* Returns flag indicating whether definition is last:		    *// 	/*  1 - Definition is lasst in file.				    */*2 	/*  0 - Definition is not last in file.				    */G 	/*****************************************************************--*/t   {s1     DEFINITION				    /* Ptr to next def.		    */* 	    *nextdef;  /     if ((nextdef = next_entry(aDef)) != NULL) {o2 	return (def_source(aDef) != def_source(nextdef));     }D
     return 1;D },  N /*************************************************************************++*/ DEFINITION *next_tree(; /* Returns next definition that needs a call tree.			    */        DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */*' 	    /* Definition to check.					    */   > )	/* Returns ptr to definition, or NULL if none found.		    */G 	/*****************************************************************--*/o   {r8     DEFINITION				    /* Current def being checked.   */
 	    *curdef;e 	    sH     for (curdef = next_entry(aDef);	    /* Scan rest of def list.	    */ 	curdef != NULL; 	curdef = next_entry(curdef)) {  	if (needs_tree(curdef)) { 	; 	    return curdef;		    /* Found another needing tree.  */  	}     } 6     return NULL;			    /* No more needing tree.	    */ }s  N /*************************************************************************++*/ DEFINITION *prev_tree(? /* Returns previous definition that needs a call tree.			    */}       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */ ' 	    /* Definition to check.					    */*  > )	/* Returns ptr to definition, or NULL if none found.		    */G 	/*****************************************************************--*/i   {c8     DEFINITION				    /* Current def being checked.   */
 	    *curdef;h 	    aF     for (curdef = prev_entry(aDef);	    /* Scan prior def list.	    */ 	curdef != NULL; 	curdef = prev_entry(curdef)) {  	if (needs_tree(curdef)) {  ; 	    return curdef;		    /* Found another needing tree.  */c 	}     } 7     return NULL;			    /* No prior needing tree.	    */  }u  N /*************************************************************************++*/ DEFINITION *next_defined(e: /* Returns next definition for a defined routine.			    */       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */t' 	    /* Definition to check.					    */_  > )	/* Returns ptr to definition, or NULL if none found.		    */G 	/*****************************************************************--*/e   {*8     DEFINITION				    /* Current def being checked.   */
 	    *curdef;  	    tH     for (curdef = next_entry(aDef);	    /* Scan rest of def list.	    */ 	curdef != NULL; 	curdef = next_entry(curdef)) { " 	if (isdefined_routine(curdef)) { : 	    return curdef;		    /* Found another defined one.  */ 	}     }n+     return NULL;			    /* No more.			    */  }a  N /*************************************************************************++*/ DEFINITION *prev_defined(d= /* Returns previous definition of a defined routine.			    */s       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */*' 	    /* Definition to check.					    */*  > )	/* Returns ptr to definition, or NULL if none found.		    */G 	/*****************************************************************--*/n   {/8     DEFINITION				    /* Current def being checked.   */
 	    *curdef;  	    aF     for (curdef = prev_entry(aDef);	    /* Scan prior def list.	    */ 	curdef != NULL; 	curdef = prev_entry(curdef)) {D" 	if (isdefined_routine(curdef)) { ; 	    return curdef;		    /* Found another defined one.   */  	}     }n/     return NULL;			    /* No prior one.		    */g }t  N /*************************************************************************++*/ DEFINITION *next_undefined( = /* Returns next definition for an undefined routine.			    */o       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */ ' 	    /* Definition to check.					    */-  > )	/* Returns ptr to definition, or NULL if none found.		    */G 	/*****************************************************************--*/    { 8     DEFINITION				    /* Current def being checked.   */
 	    *curdef;p 	     H     for (curdef = next_entry(aDef);	    /* Scan rest of def list.	    */ 	curdef != NULL; 	curdef = next_entry(curdef)) {D# 	if (!isdefined_routine(curdef)) { ); 	    return curdef;		    /* Found another undefined one. */e 	}     }p+     return NULL;			    /* No more.			    */  }d  N /*************************************************************************++*/ DEFINITION *prev_undefined(*@ /* Returns previous definition of an undefined routine.			    */       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */f' 	    /* Definition to check.					    */   > )	/* Returns ptr to definition, or NULL if none found.		    */G 	/*****************************************************************--*/*   {*8     DEFINITION				    /* Current def being checked.   */
 	    *curdef;_ 	    aF     for (curdef = prev_entry(aDef);	    /* Scan prior def list.	    */ 	curdef != NULL; 	curdef = prev_entry(curdef)) {U# 	if (!isdefined_routine(curdef)) { n; 	    return curdef;		    /* Found another undefined one. */b 	}     }r/     return NULL;			    /* No prior one.		    */X }	  N /*************************************************************************++*/ int separate_tree(N /* Determines whether or not the user has requested a separate call tree    */ /* for a routine.							    */       DEFINITION
 	    *aDef% 	    /* (READ, BY ADDR):  					    */ . 	    /* Routine definition to check.				    */  % )	/* Returns status flag:						    */rB 	/*  1 - User has requested separate tree for this routine.	    */F 	/*  0 - User has not requested separate tree for this routine.	    */G 	/*****************************************************************--*/    {i;     char    **rlist;			    /* Routine name list ptr.	    */*  0     if ((rlist = separate_list()) == NULL) {    2 	return 0;			    /* No list to worry about.	    */     } 4     else {				    /* Otherwise, check each name   */2 	while (*rlist != NULL) {	    /* in list.			    */1 	    if (strcmp(*rlist++, def_name(aDef)) == 0) {*3 		return 1;		    /* Found it, separate tree.	    */E 	    } 	}2 	return 0;			    /* Routine is not in list.	    */     }i }d  N /*************************************************************************++*/ int needs_tree( N /* Determines whether or not a routine definition needs a separate call	    */F /* tree. See the description of report_call_trees for details.		    */       DEFINITION
 	    *aDef% 	    /* (MODIFY, BY ADDR):					    */eG 	    /* Routine definition entry to check. If the routine has not    */e9 	    /* already been checked, the results of the			    */r8 	    /* evalution are cached in the definition.			    */  B )	/* Returns flag indicating whether or not tree is needed:	    */+ 	/*  1	- Separate tree is needed.				    */uE 	/*  0	- Separate tree is not needed, routine should be expanded   */* 	/*	  in callers.						    */*G 	/*****************************************************************--*/    {i6     int	    status;			    /* Evaluation status.	    */7     DEFINITION				    /* Current definition ptr.	    */o
 	    *curdef;        curdef = next_entry(aDef);7     if (def_tree_required(aDef) != NOT_YET_EVALUATED) {h3 	return (def_tree_required(aDef) == TREE_REQUIRED);h     }nN     else if (def_num_calls(aDef) == 0) {    /* Does not call anything, no   */1 	status = 0;			    /* tree to worry about.	    */*     }*M     else if (tree_inline_disabled()) {	    /* User says separate tree for  */I+ 	status = 1;			    /* all routines.		    */*     };I     else if (separate_tree(aDef)) {	    /* User says make this one	    */D' 	status = 1;			    /* separate.		    */      }1$     else if (!isend_of_list(aDef) &&6 	     strcmp(def_name(aDef), def_name(curdef)) == 0) {5 	status = 1;			    /* Multiply-defined routine,    */t8 	curdef = aDef;			    /* all versions of it need a    */+ 	for (curdef = aDef;		    /* tree.			    */eE 	    curdef != NULL && strcmp(def_name(aDef), def_name(curdef)) == 0; # 	    curdef = next_entry(curdef)) {h- 	    set_def_tree_req(curdef, TREE_REQUIRED);g 	}     }f-     else if (def_num_callers(aDef) >= 1 &&   s. 	    def_num_callers(aDef) <= max_callers()) {5 	status = 0;			    /* Too few callers for separate */*     }					    /* tree.			    */*7     else if (!tree_greater_than(aDef, MIN_TREE_SIZE)) {t. 	status = 0;			    /* Tree is trivial.		    */     }x
     else {4 	status = 1;			    /* Generate separate tree!	    */     }e:     if (status) {			    /* Cache evaluation result.	    */' 	set_def_tree_req(aDef, TREE_REQUIRED);*     }*
     else {+ 	set_def_tree_req(aDef, TREE_NOT_REQUIRED);t     }d     return status; }   N /*************************************************************************++*/ void report_defined(G /* Reports the defined routines in alphabetical order to a file.	    *//       char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */r  ! )	/* No return value.						    */uG 	/*****************************************************************--*/e   {t@     void    (*report_hdr)();		    /* Ptr to report header	    */ 					    /* routine.			    */rF     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to report end routine.   */7     FILE    *rptfile;			    /* Report file ptr.		    */*6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef;e:     long    total;			    /* Total defined routines.	    */       /*+									    */M     /*	Select appropriate set of output formatter routines. Then open file */iM     /*	and write report header. Next, for each defined routine (i.e. each  */*M     /*	routine for which the source file is known), write a report line.   */i=     /*	Finally, write report trailer and close file.			    */v     /*-									    */     <     report_hdr   = report_hdr_routine(rpt_defined_routines);>     report_entry = report_entry_routine(rpt_defined_routines);<     report_end   = report_end_routine(rpt_defined_routines);  4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);*     }E
     else { 	if (list_enabled()) {C 	    fprintf(list_file(), "\nREPORT Defined routines in file %s\n", 
 		aFileName);/ 	} 	if (log_enabled()) { ? 	    printf("REPORT Defined routines in file %s\n", aFileName);r 	}6 	(*report_hdr)(rptfile);		    /* Write header.		    */G 	for (total = 0, curdef = list_first(global_deflist()); curdef != NULL;E# 	    curdef = next_entry(curdef)) {c% 	    if (isdefined_routine(curdef)) { $ 					    /* Write entry line.	    */ 		if (trace_rpt_enabled()) {9 		    printf("TRACE: Report defined routine %s @ %lxh\n",  			def_name(curdef), curdef);  		}r0 		(*report_entry)(rptfile, curdef, (total == 0), 		    islast_defined(curdef));
 		total++; 	    }$ 	    else if (trace_rpt_enabled()) {	 		printf(*B 		"TRACE: Report defined, skipping undefined routine %s @ %lxh\n",  		    def_name(curdef), curdef); 	    } 	}= 	(*report_end)(rptfile, total);	    /* Write trailer.		    */R 	fclose(rptfile);	 	if (list_enabled()) {B 	    fprintf(list_file(), "       %ld Defined routines\n", total); 	} 	if (log_full_enabled()) {6 	    printf("       %ld Defined routines\n\n", total); 	}     }  }/  N /*************************************************************************++*/ void report_undefined(I /* Reports the undefined routines in alphabetical order to a file.	    */        char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */e  ! )	/* No return value.						    */NG 	/*****************************************************************--*/*   {*@     void    (*report_hdr)();		    /* Ptr to report header	    */ 					    /* routine.			    */iF     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to report end routine.   */7     FILE    *rptfile;			    /* Report file ptr.		    */n6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef;*;     long    total;			    /* Total undefined routines.    */f       /*+									    */M     /*	Select appropriate set of output formatter routines. Then open file */ M     /*	and write report header. Next, for each undefined routine (i.e.	    */eK     /*	each routine for which the source file is not known), write a	    */nI     /*	report line.  Finally, write report trailer and close file.	    */*     /*-									    */  >     report_hdr   = report_hdr_routine(rpt_undefined_routines);@     report_entry = report_entry_routine(rpt_undefined_routines);>     report_end   = report_end_routine(rpt_undefined_routines);  4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);      }*
     else { 	if (list_enabled()) {D 	    fprintf(list_file(), "\nREPORT External routines in file %s\n",
 		aFileName);e 	} 	if (log_enabled()) { @ 	    printf("REPORT External routines in file %s\n", aFileName); 	}6 	(*report_hdr)(rptfile);		    /* Write header.		    */G 	for (total = 0, curdef = list_first(global_deflist()); curdef != NULL;o# 	    curdef = next_entry(curdef)) { & 	    if (!isdefined_routine(curdef)) {$ 					    /* Write entry line.	    */ 		if (trace_rpt_enabled()) {: 		    printf("TRACE: Report external routine %s @ %lxh\n", 			def_name(curdef), curdef);  		}e0 		(*report_entry)(rptfile, curdef, (total == 0),  		    islast_undefined(curdef));
 		total++; 	    }$ 	    else if (trace_rpt_enabled()) {	 		printf( A 		"TRACE: Report external, skipping defined routine %s @ %lxh\n",   		    def_name(curdef), curdef); 	    } 	}= 	(*report_end)(rptfile, total);	    /* Write trailer.		    */a 	fclose(rptfile);r 	if (list_enabled()) {C 	    fprintf(list_file(), "       %ld External routines\n", total);i 	} 	if (log_full_enabled()) {7 	    printf("       %ld External routines\n\n", total);t 	}     }= }L  N /*************************************************************************++*/ void report_calls(N /* Reports the calls and callers of the defined routines in alphabetical    */  /* order to a file.							    */       char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */n  ! )	/* No return value.						    */*G 	/*****************************************************************--*//   { A     void    (*report_hdr)();		    /* Ptr to section header	    */d 					    /* routine.			    */eF     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to section end routine.  */7     FILE    *rptfile;			    /* Report file ptr.		    */o6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef; 2     REFERENCE				    /* Current caller ref.	    */
 	    *caller;r2     REFERENCE				    /* Current called ref.	    */
 	    *called;S:     long    total;			    /* Total defined routines.	    */       /*+									    */M     /*	Select appropriate set of output formatter routines and open file.  */*H     /*	For each defined routine, write a header section. For each	    */M     /*	reference and caller in a routine definition, write a report line   */ I     /*	(they are output in side-by-side pairs until both lists are	    */_I     /*	exhausted, although there is no relationship implied by the	    */eM     /*	pairing). Then write a trailer section for the defined routine.	    */D(     /*	Last, close the file.						    */     /*-									    */  :     report_hdr   = report_hdr_routine(rpt_calls_routines);<     report_entry = report_entry_routine(rpt_calls_routines);:     report_end   = report_end_routine(rpt_calls_routines);  4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);l     }f
     else { 	if (list_enabled()) { 	    fprintf(list_file(),s8 		"\nREPORT Defined routine calls/callers in file %s\n",
 		aFileName);  	} 	if (log_enabled()) {d@ 	    printf("REPORT Defined routine calls/callers in file %s\n",
 		aFileName);r 	}G 	for (total = 0, curdef = list_first(global_deflist()); curdef != NULL;)# 	    curdef = next_entry(curdef)) {R% 	    if (isdefined_routine(curdef)) { ( 					    /* Write header section.	    */ 		if (trace_rpt_enabled()) {
 		    printf(a9 			"TRACE: Report calls/callers for routine %s @ %lxh\n",	 			def_name(curdef), curdef);l 		} ! 		(*report_hdr)(rptfile, curdef);S- 		for (called = list_first(def_refs(curdef)),.0 		     caller = list_first(def_callers(curdef));( 		     called != NULL || caller != NULL;B 		     caller = next_entry(caller), called = next_entry(called)) {+ 					    /* Write calls/caller line.	    */ / 		    (*report_entry)(rptfile, called, caller);)* 		}			    /* Write trailer section.	    */! 		(*report_end)(rptfile, curdef);*
 		total++; 	    }$ 	    else if (trace_rpt_enabled()) {	 		printf(sF 	"TRACE: Report calls/callers, skipping external routine %s @ %lxh\n",  		    def_name(curdef), curdef); 	    } 	} 	fclose(rptfile);e 	if (list_enabled()) {B 	    fprintf(list_file(), "       %ld Defined routines\n", total); 	} 	if (log_full_enabled()) {6 	    printf("       %ld Defined routines\n\n", total); 	}     }P }t  N /*************************************************************************++*/ void report_xrefs(N /* Reports caller cross references for all routines (defined and undefined) */. /* in alphabetical order to a file.					    */       char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */   ! )	/* No return value.						    */sG 	/*****************************************************************--*/u   {m     void report_tree();   @     void    (*report_hdr)();		    /* Ptr to report header	    */ 					    /* routine.			    */uF     void    (*report_entry)();		    /* Ptr to report line routine.  */J     void    (*report_entry_tree)();	    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to report end routine.   */H     void    (*report_end_tree)();	    /* Ptr to report end routine.   */7     FILE    *rptfile;			    /* Report file ptr.		    */;6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef;R8     DEFINITION				    /* Temporary def to hold call   */& 	    *treedef;			    /* tree.			    */7     REFERENCE				    /* Temporary ref to current	    */ * 	    *curref;			    /* definition.		    */:     long    total;			    /* Total defined routines.	    */A     int	    xreffile = 0;		    /* Xref report file number.	    */e       /*+									    */M     /*	Select appropriate set of output formatter routines. Then open file */eM     /*	and write report header. Next, for each routine, write a report	    */rC     /*	line.  Finally, write report trailer and close file.		    */p     /*									    */@  9     report_hdr   = report_hdr_routine(rpt_xref_routines);e;     report_entry = report_entry_routine(rpt_xref_routines);r@     report_entry_tree = report_entry_routine(rpt_tree_routines);<     report_end_tree = report_end_routine(rpt_tree_routines);9     report_end   = report_end_routine(rpt_xref_routines);   4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);l     }e
     else { 	if (list_enabled()) { 	    fprintf(list_file(),_2 		"\nREPORT Caller cross references in file %s\n",
 		aFileName);; 	} 	if (log_enabled()) {*F 	    printf("REPORT Caller cross references in file %s\n", aFileName); 	}6 	(*report_hdr)(rptfile);		    /* Write header.		    */7 	for (total = 0, curdef = list_first(global_deflist());i 	    curdef != NULL;# 	    curdef = next_entry(curdef)) {tB 	    if (rpt_html_enabled() && def_xreffile(curdef) != xreffile) {= 		xreffile = rpt_html_continue(&rptfile, CALLER_XREF_SECTION,*, 				curdef, xreffile, def_xreffile(curdef)); 	    }$ 					    /* Write entry line.	    */ 	    if (trace_rpt_enabled()) { = 		printf("TRACE: Report caller xref for routine %s @ %lxh\n",   		    def_name(curdef), curdef); 	    }E 	    (*report_entry)(rptfile, curdef, !total, isend_of_list(curdef));r  & 	    if (def_num_calls(curdef) != 0) {  I 	    /******* The following code adapted from report_call_trees ********/n  % 		curref  = new_ref(0, curdef, NULL);	 		if (trace_rpt_enabled()) {? 		    printf("TRACE: Report call tree for routine %s @ %lxh\n",* 			def_name(curdef), curdef);  		}a. 		(*report_entry_tree)(rptfile, curref, 0, 0); 		free_ref(curref); 	 					      		/*+							    */@ 		/* Generate the subtree. Create a temporary def to serve as */> 		/* the tree root and set its tree root to the current	    */@ 		/* definition as a context value. This is used in detection */@ 		/* of duplicate and recursive expansions. Use the ref list  */@ 		/* of this tree to build a stack of caller refs. Push a ref */@ 		/* for the current routine to this stack, reflecting the    */@ 		/* fact that it is the first caller, then report the tree.  */@ 		/* Then pop the reference and free the root definition.	    */ 		/*-							    */  : 		treedef = new_def(def_name(curdef), def_source(curdef));  		set_def_root(treedef, curdef);. 		push_ref(treedef, new_ref(0, curdef, NULL));> 		report_tree(rptfile, report_entry_tree, curdef, 1, treedef); 		free_ref(pop_ref(treedef));U 		free_def(treedef);) 					    /* Write trailer section.	    */o7 		(*report_end_tree)(rptfile, curdef, (total == 0), 1);	  I 	    /****** The preceding code adapted from report_call_trees *********/    	    }
 	    total++;d 	}= 	(*report_end)(rptfile, total);	    /* Write trailer.		    */0 	fclose(rptfile);d 	if (list_enabled()) {: 	    fprintf(list_file(), "       %ld Routines\n", total); 	} 	if (log_full_enabled()) {. 	    printf("       %ld Routines\n\n", total); 	}     }e }   N /*************************************************************************++*/ void report_tree()M /* Recursively reports one line for each routine in the call tree. The	    */iN /* recursion is depth first (i.e. expanding each referenced routine before  */J /* showing the next at the same level). The recursion nesting level	    */= /* controls indentation of the called routine names.			    */a       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */h       void    (*aReportEntry)(),$ 	    /* (EXEC, BY ADDR):						    */0 	    /* Report line formatter routine.				    */       DEFINITION 	    *aDef,*% 	    /* (MODIFY, BY ADDR):					    */*G 	    /* Routine definition entry to report. The tree root for the    */t5 	    /* definition will be set to aTreeRoot.			    */           int	    vLevel,	# 	    /* (READ, BY VAL):						    *//A 	    /* Recursion nesting level. Level 0 is the top level.	    */        DEFINITION 	    *aTreeRootR% 	    /* (MODIFY, BY ADDR):					    */NF 	    /* Routine definition entry that acts as root of this call	    */G 	    /* tree.  References to the routines in the call tree will be   */ F 	    /* added to this definition. Its root field is used as the	    */7 	    /* context value for this tree expansion.			    */      ! )	/* No return value.						    */uG 	/*****************************************************************--*/,   {e7     REFERENCE				    /* Current reference entry.     */c
 	    *called;i6     DEFINITION				    /* Definition for current	    *// 	    *curdef;			    /* reference entry.		    */a=     int	    expanded;			    /* Flag indicating routine	    */ + 					    /* has already been reported.   */ ?     int	    recursive;			    /* Flag indicating routine is   */L& 					    /* called recursively.	    */=     char    errmsg[256];		    /* Error message buffer.	    */a       /*+									    */M     /*	For each referenced routine, report the routine. If the routine has */nM     /*	not already been expanded in this tree, is defined, and does not    */NM     /*	have a separate tree (and we have not exceeded max tree depth),	    */ 2     /*	generate its subtree recursively.				    */     /*-									    */  -     for (called = list_first(def_refs(aDef));,0 	 called != NULL; called = next_entry(called)) { 	 + 					    /* Get current def ptr and find */f) 					    /* out expanded/recursive	    */ ; 	curdef    = ref_definition(called); /* conditions.		    */ 0 	recursive = isrecursive_ref(called, aTreeRoot);2 	expanded  = (!recursive && !needs_tree(curdef) &&7 		    isalready_expanded(curdef, def_root(aTreeRoot)));n  @ 	(*aReportEntry)(aRptFile, called, vLevel, expanded, recursive);  + 					    /* Mark def as part of tree.    */h+ 	set_def_root(curdef, def_root(aTreeRoot));f 	t 	if (!expanded && !recursive &&e8 	    isdefined_routine(curdef) && !needs_tree(curdef)) {% 	    if (vLevel < max_tree_depth()) {e   		/*+							    */@ 		/*  A subtree needs to be generated. Push a reference to    */@ 		/*  the current routine to the call stack for recursion	    */@ 		/*  detection at lower levels, do the lower level subtree,  *// 		/*  and discard the added reference.			    */_ 		/*-							    */  0 		push_ref(aTreeRoot, new_ref(0, curdef, NULL));9 		report_tree(aRptFile, aReportEntry, curdef, vLevel + 1,  		    aTreeRoot);( 		free_ref(pop_ref(aTreeRoot));{ 	    }) 	    else if (vLevel == MAX_TREE_DEPTH) {t 		sprintf(errmsg,}G 	    "\nWARNING: %s tree depth exceeds %d levels, halting expansion\n",n+ 		    def_name(aTreeRoot), MAX_TREE_DEPTH);* 		fputs(errmsg, aRptFile); 		if (list_enabled()) {*! 		    fputs(errmsg, list_file());p 		}c 		puts(errmsg);e 		break; 	    } 	}     }d }d   #if 0dN /*************************************************************************++*/ void report_call_trees(	N /* Reports the call trees for the defined routines in alphabetical order to */M /* a file. The report attempts to minimize the number of trivial trees	    */*I /* generated and maximize tree depth, while limiting the amount of	    */ N /* repetitive subtree expansion. To meet this goal, a separate call tree    */9 /* will not be generated in the following cases:			    */  /*									    */eI /*	1) a routine that calls no other routines (this eliminates empty    */e /*	   call trees);							    */r /*									    */oI /*	2) a routine that calls one or more other routines, but is called   */EI /*	   from only 1-x other routines, where x is a user-settable limit   */CI /*	   (this eliminates low-usage routines that can be better shown	    */o. /*	   as subtrees of their callers);				    */ /*									    */ I /*	3) a routine that is called from more than x other routines, but    */ D /*	   that has a total tree expansion of only 1-4 nodes (this	    */I /*	   eliminates very simple call trees that can be easily shown as    */ , /*	   subtrees of their callers).					    */ /*									    */fN /* In these cases, any call relationships will be shown in the call trees   */N /* of any caller. There is one special exception to cases 2 and 3, where a  */I /* routine is multiply-defined. This indicates multiple, alternate	    */hK /* implementations of the same routine, possibly with different call	    */rN /* structures. Until the product is linked, it cannot be determined which   */N /* version of the routine will be called; therefore a separate tree will be */7 /* generated for each version of the routine.				    */  /*									    */eJ /* In all other cases, a separate call tree will be generated for a	    */N /* routine. Specifically, this means routines that are not called from any  */N /* other, and frequently-used routines with complex call trees. There are   */M /* also two user-selectable overrides to this behavior. The "separate"	    */nN /* option allows the user to specify a file containing a list of routine    */N /* names for which separate trees must be generated if they call anything.  */N /* The "noinline" option forces separate trees for all routines that call   */ /* anything.								    */       char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */c  ! )	/* No return value.						    */nG 	/*****************************************************************--*/r   {lA     void    (*report_hdr)();		    /* Ptr to section header	    */; 					    /* routine.			    */rF     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to section end routine.  */7     FILE    *rptfile;			    /* Report file ptr.		    */e6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef;a8     DEFINITION				    /* Temporary def to hold call   */& 	    *treedef;			    /* tree.			    */=     int	    lastdef;			    /* Flag indicating last def	    */	+ 					    /* with separate call tree.     */t7     REFERENCE				    /* Temporary ref to current	    */s* 	    *curref;			    /* definition.		    */:     long    total;			    /* Total defined routines.	    */A     int	    treefile = 0;		    /* Tree report file number.	    */        /*+									    */M     /*	Select appropriate set of output formatter routines and open file.  */aM     /*	For each defined routine that warrants a separate call tree, write  */eM     /*	a header section. Then do a depth-first recursive traversal of the  */	L     /*	routine references and write a report line for each reference.	    */M     /*	Then write a trailer section for the defined routine.  Last, close  */)     /*	the file.							    */r     /*-									    */  9     report_hdr   = report_hdr_routine(rpt_tree_routines);f;     report_entry = report_entry_routine(rpt_tree_routines);d9     report_end   = report_end_routine(rpt_tree_routines);T  4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);      }i
     else { 	if (list_enabled()) { 	    fprintf(list_file(),{5 		"\nREPORT Defined routine call trees in file %s\n",t
 		aFileName);l 	} 	if (log_enabled()) {p= 	    printf("REPORT Defined routine call trees in file %s\n",*
 		aFileName);* 	}G 	for (total = 0, curdef = list_first(global_deflist()); curdef != NULL;)# 	    curdef = next_entry(curdef)) { E 	    if (needs_tree(curdef)) {	    /* If routine needs tree, write */ + 					    /* header section and toplevel  */e 					    /* line.			    */? 		if (rpt_html_enabled() && def_treefile(curdef) != treefile) { ? 		    treefile = rpt_html_continue(&rptfile, CALL_TREE_SECTION, 0 				    curdef, treefile, def_treefile(curdef)); 		}/  		lastdef = islast_tree(curdef);8 		(*report_hdr)(rptfile, curdef, (total == 0), lastdef);% 		curref  = new_ref(0, curdef, NULL);  		if (trace_rpt_enabled()) {? 		    printf("TRACE: Report call tree for routine %s @ %lxh\n",, 			def_name(curdef), curdef);  		}n) 		(*report_entry)(rptfile, curref, 0, 0);  		free_ref(curref);/	 					    n 		/*+							    */@ 		/* Generate the subtree. Create a temporary def to serve as */> 		/* the tree root and set its tree root to the current	    */@ 		/* definition as a context value. This is used in detection */@ 		/* of duplicate and recursive expansions. Use the ref list  */@ 		/* of this tree to build a stack of caller refs. Push a ref */@ 		/* for the current routine to this stack, reflecting the    */@ 		/* fact that it is the first caller, then report the tree.  */@ 		/* Then pop the reference and free the root definition.	    */ 		/*-							    */  : 		treedef = new_def(def_name(curdef), def_source(curdef));  		set_def_root(treedef, curdef);. 		push_ref(treedef, new_ref(0, curdef, NULL));9 		report_tree(rptfile, report_entry, curdef, 1, treedef);  		free_ref(pop_ref(treedef));f 		free_def(treedef);) 					    /* Write trailer section.	    */a8 		(*report_end)(rptfile, curdef, (total == 0), lastdef);
 		total++; 	    }$ 	    else if (trace_rpt_enabled()) {A 		printf("TRACE: Report call tree, skipping routine %s @ %lxh\n",   		    def_name(curdef), curdef); 	    }   	} 	fclose(rptfile);	 	if (list_enabled()) {A 	    fprintf(list_file(), "       %ld Trees generated\n", total);  	} 	if (log_full_enabled()) {5 	    printf("       %ld Trees generated\n\n", total);h 	}     }a }t #endif  N /*************************************************************************++*/ void report_by_file(N /* Reports the defined routines in the order in which they occurred in the  */N /* source files to a file. The files themselves are ordered alphabetically. */N /* Since this report is driven by the list of defined routines, if a file   */H /* contains no routine definitions, it will not be reported here.	    */       char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */e  ! )	/* No return value.						    */lG 	/*****************************************************************--*/o   {eA     void    (*report_hdr)();		    /* Ptr to section header	    */x 					    /* routine.			    */iF     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to section end routine.  */7     FILE    *rptfile;			    /* Report file ptr.		    */o6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef;l3     SOURCEFILE				    /* Current file entry.	    */c 	    *curfile;:     long    total;			    /* Total defined routines.	    */<     int	    totfiles;			    /* Total number of files.	    */>     int	    lastfile;			    /* Flag indicating last file    */ 					    /* with defs.		    */F     int	    byfilefile = 0;		    /* By-file report file number.	    */       /*+									    */M     /*	Select appropriate set of output formatter routines and open file.  */*M     /*	For each source file, write a header section. For each routine in   */tM     /*	that file, write a report list. Then write a trailer section for    */ 1     /*	the file. Last, close the file.					    */*     /*-									    */  ;     report_hdr   = report_hdr_routine(rpt_byfile_routines); =     report_entry = report_entry_routine(rpt_byfile_routines);p;     report_end   = report_end_routine(rpt_byfile_routines);   4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);l     }a
     else { 	if (list_enabled()) { 	    fprintf(list_file(), 2 		"\nREPORT Routines by source file in file %s\n",
 		aFileName);  	} 	if (log_enabled()) {aF 	    printf("REPORT Routines by source file in file %s\n", aFileName); 	}& 					    /* Skip past undefined	    */ 					    /* routines.		    */ , 	for (curdef = list_first(global_deflist());2 	    curdef != NULL && !isdefined_routine(curdef);# 	    curdef = next_entry(curdef)) {r 	    if (trace_rpt_enabled()) { 	 		printf(l> 		"TRACE: Report file, skipping external routine %s @ %lxh\n",  		    def_name(curdef), curdef); 	    } 	}+ 					    /* Report each file's routines. */o 	for (total = totfiles = 0,*7 		curdef != NULL ? curfile = def_source(curdef) : NULL;s 	    curdef != NULL;< 	    curdef != NULL ? curfile = def_source(curdef) : NULL) {. 	    lastfile = islast_defining_file(curfile); 	    n 	    if (rpt_html_enabled()n0 		&& source_byfilefile(curfile) != byfilefile) {* 		byfilefile = rpt_html_continue(&rptfile,2 				ROUTINES_BY_FILE_SECTION, curfile, byfilefile,  				source_byfilefile(curfile)); 	    }( 					    /* Write header section.	    */@ 	    (*report_hdr)(rptfile, curfile, (totfiles == 0), lastfile); 	    if (trace_rpt_enabled()) {n6 		printf("TRACE: Report routines in file %s @ %lxh\n",% 		    source_name(curfile), curfile);u 	    }	 	    do {*$ 					    /* Write entry line.	    */ 		if (trace_rpt_enabled()) {9 		    printf("TRACE: Report file %s routine %s @ %lxh\n",a5 			source_name(def_source(curdef)), def_name(curdef),  			curdef);y 		} ; 		(*report_entry)(rptfile, curdef, isfirst_in_file(curdef),  		    islast_in_file(curdef));
 		total++; 		curdef = next_entry(curdef);? 	    } while (curdef != NULL && def_source(curdef) == curfile);   ) 					    /* Write trailer section.	    */b@ 	    (*report_end)(rptfile, curfile, (totfiles == 0), lastfile); 	    totfiles++; 	} 	fclose(rptfile);t 	if (list_enabled()) {F 	    fprintf(list_file(), "       %ld Defined routines in %d files\n", 		total, totfiles);t 	} 	if (log_full_enabled()) {A 	    printf("       %ld Defined routines in %d files\n\n", total,* 		totfiles); 	}     }* }*  N /*************************************************************************++*/ void report_files(D /* Reports the source files in alphabetical order to a file.		    */       char    *aFileName$ 	    /* (READ, BY ADDR):						    */+ 	    /* Report output file name.					    */e  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {I@     void    (*report_hdr)();		    /* Ptr to report header	    */ 					    /* routine.			    */	F     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to report end routine.   */7     FILE    *rptfile;			    /* Report file ptr.		    */ 3     SOURCEFILE				    /* Current file entry.	    */s 	    *curfile;:     int	    total;			    /* Total defined routines.	    */       /*+									    */M     /*	Select appropriate set of output formatter routines. Open file and  */aM     /*	write a header section. For each source file, write a report line.  */e?     /*	Then write a trailer section and close the file.		    */s     /*-									    */  9     report_hdr   = report_hdr_routine(rpt_file_routines);	;     report_entry = report_entry_routine(rpt_file_routines);o9     report_end   = report_end_routine(rpt_file_routines);   4     if ((rptfile = fopen(aFileName, "w")) == NULL) {C 	printf("ERROR: Unable to open %s for report output\n", aFileName);p     }r
     else { 	if (list_enabled()) { 	    fprintf(list_file(),i3 		"\nREPORT Source files in file %s\n", aFileName);= 	} 	if (log_enabled()) {n; 	    printf("REPORT Source files in file %s\n", aFileName);  	}  6 	(*report_hdr)(rptfile);		    /* Write header.		    */9 	for (total = 0, curfile = list_first(global_filelist());F 	    curfile != NULL;g% 	    curfile = next_entry(curfile)) {i$ 					    /* Write entry line.	    */ 	    if (trace_rpt_enabled()) { 1 		printf("TRACE: Report source file %s @ %lxh\n",!% 		    source_name(curfile), curfile);e 	    }@ 	    (*report_entry)(rptfile, curfile, isbegin_of_list(curfile), 		isend_of_list(curfile));
 	    total++;e 	}= 	(*report_end)(rptfile, total);	    /* Write trailer.		    */_ 	fclose(rptfile);  	if (list_enabled()) {6 	    fprintf(list_file(), "       %d files\n", total); 	} 	if (log_full_enabled()) {* 	    printf("       %d files\n\n", total); 	}     }; }	  N /*************************************************************************++*/ void report_source(rK /* Reports annotated source files with line numbers. The sources are	    */%* /* reported in separate files.						    */       char    *aFileName$ 	    /* (READ, BY ADDR):						    */7 	    /* Report output file name format string.			    */u  ! )	/* No return value.						    */eG 	/*****************************************************************--*/	   {fA     void    (*report_hdr)();		    /* Ptr to section header	    */u 					    /* routine.			    */sF     void    (*report_entry)();		    /* Ptr to report line routine.  */D     void    (*report_end)();		    /* Ptr to section end routine.  */N     char    rptname[MAX_FILE_NAME + 1];	    /* Report file name prefix.	    */N     char    outputname[MAX_FILE_NAME + 1];  /* Report file name buffer.	    */I     char    srcline[MAX_FILE_NAME * 2];	    /* Source line buffer.	    */e7     FILE    *rptfile;			    /* Report file ptr.		    */c7     FILE    *srcfile;			    /* Source file ptr.		    */e6     DEFINITION				    /* Current routine entry.	    */
 	    *curdef; 3     SOURCEFILE				    /* Current file entry.	    */t 	    *curfile;:     long    line;			    /* Current line number in file. */6     long    total;			    /* Total source lines.	    */<     int	    totfiles;			    /* Total number of files.	    */       /*+									    */L     /*	Select appropriate set of output formatter routines.  For each	    */J     /*	source file, open source and report files and write a header	    */M     /*	section.  Write each line in the file, merging with the routine	    */*M     /*	definitions.  Then write a trailer section for the file and close   */r.     /*	the source and report files.					    */     /*-									    */  ;     report_hdr   = report_hdr_routine(rpt_source_routines);e=     report_entry = report_entry_routine(rpt_source_routines); ;     report_end   = report_end_routine(rpt_source_routines);n       if (list_enabled()) { 9 	fputs("\nREPORT Annotated source files\n", list_file());a     }      if (log_enabled()) {' 	puts("REPORT Annotated source files");	     }*& 					    /* Skip past undefined	    */ 					    /* routines.		    */*/     for (curdef = list_first(global_deflist()); . 	curdef != NULL && !isdefined_routine(curdef); 	curdef = next_entry(curdef)) {o 	if (trace_rpt_enabled()) {  	    printf(D 	    "TRACE: Report sources, skipping external routine %s @ %lxh\n", 		def_name(curdef), curdef); 	}     } + 					    /* Report each file's contents. */eG     for (total = totfiles = 0, curfile = list_first(global_filelist()); 2 	curfile != NULL; curfile = next_entry(curfile)) {  
 	line = 0;2 	sprintf(rptname, aFileName, source_seq(curfile));< 	if ((srcfile = fopen(source_name(curfile), "r")) == NULL) {3 	    printf("ERROR: Unable to open %s for input\n",  		source_name(curfile)); 	}C 	else if ((rptfile = fopen(make_filename(outfile_prefix(), rptname, 7 	        report_filext(), outputname), "w")) == NULL) {	E 	    printf("ERROR: Unable to open %s for report output\n", rptname);o 	}. 	else {				    /* Write header section.	    */5 	    (*report_hdr)(rptfile, curfile, (totfiles == 0),  		isend_of_list(curfile)); 	    if (trace_rpt_enabled()) { > 		printf("TRACE: Report annotated source in file %s @ %lxh\n",% 		    source_name(curfile), curfile);r 	    }+ 					    /* Report lines through last    */e* 					    /* routine defined in this	    */ 					    /* file.			    */> 	    while (curdef != NULL && def_source(curdef) == curfile) {" 		while (line < def_end(curdef)) {$ 					    /* Copy source line.	    *// 		    fgets(srcline, sizeof(srcline), srcfile); 7 		    (*report_entry)(rptfile, curdef, srcline, ++line,R 			source_tabsize(curfile)); 		    total++; 		}l 		curdef = next_entry(curdef); 	    }' 					    /* Report rest of file.	    */ ? 	    while (fgets(srcline, sizeof(srcline), srcfile) != NULL) { 1 		(*report_entry)(rptfile, NULL, srcline, ++line,= 		    source_tabsize(curfile)); 
 		total++; 	    }) 					    /* Write trailer section.	    */ 5 	    (*report_end)(rptfile, curfile, (totfiles == 0),  		isend_of_list(curfile)); 	    totfiles++; 	    fclose(srcfile);l 	    fclose(rptfile);c 	}     }d     if (list_enabled()) {/7 	fprintf(list_file(), "       %ld Lines in %d files\n",s 	    total, totfiles);     }i     if (log_full_enabled()) {s= 	printf("       %ld Lines in %d files\n\n", total, totfiles);r     }e }:  