N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ 5 /*  MODULE:	HTML Report Formatting Routines				    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This module contains the routines for generating Routine   */N /*  Analyzer reports in HTML format, suitable for viewing with a World-Wide */ /*  Web browser.							    */  /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include <stdio.h> #include "ranalyzer.h" #include "reports.h"  @ #define calls_link_suffix()	(rpt_source_enabled()	? "</A>" : "")> #define xref_link_suffix()	(rpt_xrefs_enabled()	? "</A>" : "")A #define byfile_link_suffix()	(rpt_byfile_enabled()	? "</A>" : "") A #define source_link_suffix()	(rpt_source_enabled()	? "</A>" : "")   + 					/* Section navigation hyperlink	    */  					/* information.			    */ # static HTML_SECTION mSections[] = { >     {NULL, "table_of_contents", NULL, NULL, NULL, NULL, NULL},0     {HTML_SECTION_FILES, "source_files_section", 	OUTFILE_SUFFIX_FILES, NULL, 	OUTFILE_SUFFIX_BYFILE, NULL,  	"file", NULL}, 5     {HTML_SECTION_BYFILE, "routines_by_file_section", 2 	OUTFILE_SUFFIX_BYFILE, OUTFILE_SUFFIX_MOREBYFILE,. 	OUTFILE_SUFFIX_DEFLIST, OUTFILE_SUFFIX_FILES, 	"file", "routine", "f"}, 6     {HTML_SECTION_DEFINED, "defined_routines_section", 	OUTFILE_SUFFIX_DEFLIST, NULL, 	OUTFILE_SUFFIX_UNDEFLIST,/ 	OUTFILE_SUFFIX_BYFILE, "routine", NULL, NULL}, :     {HTML_SECTION_UNDEFINED, "undefined_routines_section",  	OUTFILE_SUFFIX_UNDEFLIST, NULL,. 	OUTFILE_SUFFIX_CALLS, OUTFILE_SUFFIX_DEFLIST, 	"routine", NULL, NULL},1     {HTML_SECTION_CALLS, "routine_calls_section",  	OUTFILE_SUFFIX_CALLS, NULL,/ 	OUTFILE_SUFFIX_XREF, OUTFILE_SUFFIX_UNDEFLIST,  	"routine", NULL, "c"}, .     {HTML_SECTION_XREF, "caller_xref_section",. 	OUTFILE_SUFFIX_XREF, OUTFILE_SUFFIX_MOREXREF,0 	OUTFILE_SUFFIX_CALLTREES, OUTFILE_SUFFIX_CALLS, 	"routine", NULL, "x"}, 6     {HTML_SECTION_TREES, "routine_call_trees_section",4 	OUTFILE_SUFFIX_CALLTREES, OUTFILE_SUFFIX_MORETREES, 	OUTFILE_SUFFIX_FIRSTSOURCE,) 	OUTFILE_SUFFIX_XREF, "tree", NULL, "t"}, 0     {HTML_SECTION_SOURCE, "source_code_section",3 	OUTFILE_SUFFIX_FIRSTSOURCE, OUTFILE_SUFFIX_SOURCE,   	NULL, OUTFILE_SUFFIX_CALLTREES, 	"file", NULL, "s"}  };  N /*************************************************************************++*/ void assign_xreffiles(A /* Assigns the Xref file numbers for routine definitions.		    */   !     /* No arguments.							    */   & )	/* No return value.      					    */G 	/*****************************************************************--*/    { 7     int	    xreffile;			    /* Xref file number.	    */ ;     int	    lines;			    /* Number of lines of def/refs. */ 8     DEFINITION				    /* Current definition entry.    */
 	    *curdef;  	     E     for (xreffile = lines = 0, curdef = list_first(global_deflist());  	curdef != NULL; 	curdef = next_entry(curdef)) { $ 	set_def_xreffile(curdef, xreffile);> 	lines += def_num_callers(curdef) + def_num_calls(curdef) + 5; 	if (lines > max_html_xref()) {  	    lines = 0;  	    xreffile++; 	}     }  }   N /*************************************************************************++*/ void assign_byfilefiles(D /* Assigns the by-file file numbers for routine definitions.		    */  !     /* No arguments.							    */   & )	/* No return value.      					    */G 	/*****************************************************************--*/    { <     int	    byfilefile;			    /* By-file file number.	    */;     int	    lines;			    /* Number of lines of def/refs. */ 3     SOURCEFILE				    /* Current file entry.	    */  	    *curfile; 	     I     for (byfilefile = lines = 0, curfile = list_first(global_filelist());  	curfile != NULL; ! 	curfile = next_entry(curfile)) { , 	set_source_byfilefile(curfile, byfilefile);( 	lines += source_routines(curfile) + 10;! 	if (lines > max_html_byfile()) {  	    lines = 0;  	    byfilefile++; 	}     }  }   N /*************************************************************************++*/ char *link_url( / /* Formats an HTML link URL portion.					    */        char    *aFileName% 	    /* (READ, BY ADDR):  					    */ + 	    /* Report file name portion.				    */   H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */ / 	/* must be read from it immediately.				    */ G 	/*****************************************************************--*/    { + 					    /* Trace name string buffer.    */ +     static char	strbuf[MAX_FILE_NAME + 60];        if (url_prefix()) { G 	sprintf(strbuf, "%s%s%s%s", url_prefix(), outfile_prefix(), aFileName,  	    OUTFILE_EXT_HTML);      } 
     else {7 	sprintf(strbuf, "%s%s%s", outfile_prefix(), aFileName,  	    OUTFILE_EXT_HTML);      }      return strbuf; }    #if 1 % #define tree_link(d,f) xref_link(d,f)  #else N /*************************************************************************++*/ char *tree_link(F /* Formats a hyperlink to a routine's call tree if one exists.		    */       DEFINITION 	    *aDef, $ 	    /* (READ, BY ADDR):						    */5 	    /* Routine definition entry to link to.			    */        int	    vSameFile $ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */   H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */ / 	/* must be read from it immediately.				    */ G 	/*****************************************************************--*/    { I     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */ N     char    outputname[MAX_FILE_NAME + 1];  /* Report file name buffer.	    */  G     if (!rpt_trees_enabled()) {		    /* Linking is valid only if	    */ - 	return "";			    /* report generated.	    */      } 
     else { 	if (!vSameFile) { 	    if (def_treefile(aDef)) {/ 		sprintf(outputname, OUTFILE_SUFFIX_MORETREES,  		    def_treefile(aDef)); 	    } 	    else { / 		strcpy(outputname, OUTFILE_SUFFIX_CALLTREES);  	    } 	}/     					    /* If routine needs a separate  */ + 					    /* tree or is expanded within   */ + 					    /* some other tree, make link.  */ 2 	if (needs_tree(aDef) || def_root(aDef) != NULL) {0 	    sprintf(link, "<A HREF=\"%s#t%lx\">%s</A>",* 		(vSameFile ? "" : link_url(outputname)),
 #if 0	    - 		(needs_tree(aDef) ? aDef : def_root(aDef)), ( 		(needs_tree(aDef) ? "Tree" : "Root")); #else  		aDef, "Tree"); #endif 	    return link;  	}1 	else {				    /* Otherwise, no tree exists.   */  	    return "No tree"; 	}     }  }  #endif  N /*************************************************************************++*/ char *source_link_prefix( H /* Formats the prefix for a hyperlink to a routine's source code.	    */       DEFINITION 	    *aDef, $ 	    /* (READ, BY ADDR):						    */5 	    /* Routine definition entry to link to.			    */        int	    vSameFile $ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */   H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */ / 	/* must be read from it immediately.				    */ G 	/*****************************************************************--*/    { I     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */ G     char    linkname[MAX_FILE_NAME + 1];    /* Source file name.	    */   G     if (!rpt_source_enabled()) {	    /* Linking is valid only if	    */ - 	return "";			    /* report generated.	    */      } 
     else { 	if (!vSameFile) {- 	    sprintf(linkname, OUTFILE_SUFFIX_SOURCE,*  		source_seq(def_source(aDef))); 	}& 	sprintf(link, "<A HREF=\"%s#d%lx\">",2 	    (vSameFile ? "" : link_url(linkname)), aDef);
 	return link;T     }r }o  N /*************************************************************************++*/ char *source_link(; /* Formats a hyperlink to a routine's source code.			    */A       DEFINITION 	    *aDef,*$ 	    /* (READ, BY ADDR):						    */5 	    /* Routine definition entry to link to.			    */z       int	    vSameFile,$ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */S  H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */	/ 	/* must be read from it immediately.				    */*G 	/*****************************************************************--*/e   {aI     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */n  G     if (!rpt_source_enabled()) {	    /* Linking is valid only if	    */<- 	return "";			    /* report generated.	    */y     }a'     else if (isdefined_routine(aDef)) {nA 	sprintf(link, "%sSource%s", source_link_prefix(aDef, vSameFile),  	    source_link_suffix()); 
 	return link;t     } 
     else { 	return "No source";     }  }   N /*************************************************************************++*/ char *sourcefile_link_prefix( F /* Formats the prefix for a hyperlink to a file's source code.		    */       SOURCEFILE 	    *aSourceFileu$ 	    /* (READ, BY ADDR):						    *// 	    /* Source file entry to link to.				    */S  H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */L/ 	/* must be read from it immediately.				    */YG 	/*****************************************************************--*/o   {sI     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */EG     char    linkname[MAX_FILE_NAME + 1];    /* Source file name.	    */t  G     if (!rpt_source_enabled()) {	    /* Linking is valid only if	    */U- 	return "";			    /* report generated.	    */}     } 
     else {C 	sprintf(linkname, OUTFILE_SUFFIX_SOURCE, source_seq(aSourceFile));MC 	sprintf(link, "<A HREF=\"%s\">", link_url(linkname), aSourceFile);"
 	return link;      }M }E  N /*************************************************************************++*/ char *calls_link_prefix(J /* Formats the prefix for a hyperlink to a routine's calls/callers.	    */       DEFINITION 	    *aDef,i$ 	    /* (READ, BY ADDR):						    */5 	    /* Routine definition entry to link to.			    */        int	    vSameFile $ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */s  H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */*/ 	/* must be read from it immediately.				    */*G 	/*****************************************************************--*/    { I     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */N  G     if (!rpt_calls_enabled()) {		    /* Linking is valid only if	    */ - 	return "";			    /* report generated.	    */a     }s
     else {& 	sprintf(link, "<A HREF=\"%s#c%lx\">",> 	    (vSameFile ? "" : link_url(OUTFILE_SUFFIX_CALLS)), aDef);
 	return link;      }u }a  N /*************************************************************************++*/ char *xref_link_prefix(*C /* Formats the prefix for a hyperlink to a routine's caller		    */*! /* cross-references.							    */*       DEFINITION 	    *aDef,r$ 	    /* (READ, BY ADDR):						    */5 	    /* Routine definition entry to link to.			    */l       int	    vSameFile*$ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */-  H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */u/ 	/* must be read from it immediately.				    */cG 	/*****************************************************************--*/n   {nI     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */oN     char    outputname[MAX_FILE_NAME + 1];  /* Report file name buffer.	    */  G     if (!rpt_xrefs_enabled()) {		    /* Linking is valid only if	    */*- 	return "";			    /* report generated.	    */h     }k
     else { 	if (!vSameFile) { 	    if (def_xreffile(aDef)) {. 		sprintf(outputname, OUTFILE_SUFFIX_MOREXREF, 		    def_xreffile(aDef)); 	    } 	    else { * 		strcpy(outputname, OUTFILE_SUFFIX_XREF); 	    } 	}& 	sprintf(link, "<A HREF=\"%s#x%lx\">",4 	    (vSameFile ? "" : link_url(outputname)), aDef);
 	return link;t     }d }o  N /*************************************************************************++*/ char *xref_link(F /* Formats a hyperlink to a routine's caller cross-references.		    */       DEFINITION 	    *aDef, $ 	    /* (READ, BY ADDR):						    */5 	    /* Routine definition entry to link to.			    */a       int	    vSameFileM$ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */   H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */*/ 	/* must be read from it immediately.				    */hG 	/*****************************************************************--*/N   { I     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */e  G     if (!rpt_xrefs_enabled()) {		    /* Linking is valid only if	    */)- 	return "";			    /* report generated.	    */      } 
     else {= 	sprintf(link, "%sGoto%s", xref_link_prefix(aDef, vSameFile),N 	    xref_link_suffix());e
 	return link;s     }s }i  N /*************************************************************************++*/ char *byfile_link_prefix(*I /* Formats the prefix for a hyperlink to a file's routine listing.	    */        SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */) 	    /* File entry to link to.					    */R       int	    vSameFile $ 	    /* (READ, BY VAL):  					    */G 	    /* Flag indicating whether this is link within same HTML file.  */e  H )	/* Returns formatted string ptr.  WARNING: The returned ptr is the  */G 	/* address of a statically-defined string buffer, so the string	    */_/ 	/* must be read from it immediately.				    */oG 	/*****************************************************************--*/u   {nI     static char	link[MAX_FILE_NAME + 64];   /* Link string buffer.	    */   G     if (!rpt_byfile_enabled()) {	    /* Linking is valid only if	    */f- 	return "";			    /* report generated.	    */t     }s
     else {& 	sprintf(link, "<A HREF=\"%s#f%lx\">",F 	    (vSameFile ? "" : link_url(OUTFILE_SUFFIX_BYFILE)), aSourceFile);
 	return link;"     }t };  N /*************************************************************************++*/ void rpt_html_section_nav(N /* Writes a set of common HTML section navigation links to the report file. */L /* These links go to the table of contents, and the next and previous	    */ /* sections.								    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */o       HTML_SECTION_TYPE  	    vSection,$ 	    /* (READ, BY VAL):  					    */+ 	    /* Section number to write.					    */d       int	    vLasti# 	    /* (READ, BY VAL):						    */ > 	    /* Flag indicating this is last entry in section.		    */  & )	/* No return value.      					    */G 	/*****************************************************************--*/a   {	E     char    fname[MAX_FILE_NAME + 1];	    /* File name buffer.	    */*  >     fprintf(aRptFile, "Go to: <A HREF=\"%s#%s\">Contents</a>",  	link_url(OUTFILE_SUFFIX_FILES),* 	section_anchor(mSections, MAIN_SECTION));:     if (section_nextsuffix(mSections, vSection) != NULL) {7 	fprintf(aRptFile, "; <A HREF=\"%s\">Next section</a>", 8 	    link_url(section_nextsuffix(mSections, vSection)));     }l:     if (section_prevsuffix(mSections, vSection) != NULL) {; 	fprintf(aRptFile, "; <A HREF=\"%s\">Previous section</a>",d8 	    link_url(section_prevsuffix(mSections, vSection)));     }t }   N /*************************************************************************++*/ void rpt_html_section_title(; /* Writes a common HTML section title report file.			    */	       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        char    *aSubTitle% 	    /* (READ, BY ADDR):  					    */ G 	    /* Optional subtitle string to add to title. If NULL is passed, */ 2 	    /* only main title will be written.				    */  & )	/* No return value.      					    */G 	/*****************************************************************--*/    {f     fprintf(aRptFile, @ 	"<TITLE>%s Source File Analysis%s%s</TITLE>\n", product_name()," 	(aSubTitle == NULL ? "" : " - "),' 	(aSubTitle == NULL ? "" : aSubTitle));i }	  N /*************************************************************************++*/ void rpt_html_section_hdr(N /* Writes a common HTML section header to the report file. This includes a  */M /* title, a level-one header, and optionally navigation links to other	    */_ /* sections.								    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       HTML_SECTION_TYPEe
 	    vSectionx$ 	    /* (READ, BY VAL):  					    */+ 	    /* Section number to write.					    */O  & )	/* No return value.      					    */G 	/*****************************************************************--*/S   {	7     FILE    *dscfile;			    /* Description file.	    */t=     char    dscbuf[256];		    /* Description file line	    */, 					    /* buffer.			    */     %     rpt_html_section_title(aRptFile, /H 	(ismain_section(vSection) ? NULL : section_name(mSections, vSection)));  D     if (ismain_section(vSection)) {	    /* Write main header.	    */8 	fprintf(aRptFile, "<H1>%s Source File Analysis</H1>\n", 	    product_name());   % 	if (product_description() != NULL) { A 	    if ((dscfile = fopen(product_description(), "r")) != NULL) {a: 		while (fgets(dscbuf, sizeof(dscbuf), dscfile) != NULL) { 		    fputs(dscbuf, aRptFile); 		}e 		fclose(dscfile); 	    } 	    else {i	 		printf(n@ 		    "WARNING: Unable to open description file %s for input\n", 		    product_description());* 	    } 	}  5 	fputs("<A NAME=\"table_of_contents\">\n", aRptFile);s, 	fputs("<H2>Contents</H2></A>\n", aRptFile);? 	fputs("The following sections contain information that was\n",, 	    aRptFile); = 	fputs("generated by automated analysis of the\n", aRptFile); < 	fprintf(aRptFile, "%s source files.<P>\n", product_name());   	fputs("<UL>\n", aRptFile);  	if (rpt_files_enabled())MG 	    fputs("<LI> <A HREF=\"#source_files_section\">Source Files</A>\n",  		aRptFile); 	if (rpt_byfile_enabled())L 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">Defined Routines By File</A>\n",# 		link_url(OUTFILE_SUFFIX_BYFILE));* 	if (rpt_defined_enabled())*Q 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">Defined Routines Alphabetical</A>\n", $ 		link_url(OUTFILE_SUFFIX_DEFLIST)); 	if (rpt_undefined_enabled())kR 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">External Routines Alphabetical</A>\n",& 		link_url(OUTFILE_SUFFIX_UNDEFLIST)); 	if (rpt_calls_enabled())lR 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">Defined Routines Calls/Callers</A>\n"," 		link_url(OUTFILE_SUFFIX_CALLS)); 	if (rpt_xrefs_enabled())*J 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">Caller Cross Reference</A>\n",! 		link_url(OUTFILE_SUFFIX_XREF));c 	if (rpt_trees_enabled())*F 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">Routine Call Trees</A>\n",& 		link_url(OUTFILE_SUFFIX_CALLTREES)); 	if (rpt_source_enabled())? 	    fprintf(aRptFile, "<LI> <A HREF=\"%s\">Source Code</A>\n",g( 		link_url(OUTFILE_SUFFIX_FIRSTSOURCE)); 	fputs("</UL>\n", aRptFile);  L 	fputs("For information on the software used to generate this\n", aRptFile);G 	fputs("analysis, contact Steve Branam, Network Products\n", aRptFile);eD 	fputs("Support Group, Digital Equipment Corporation,\n", aRptFile);- 	fputs("Littleton, MA, USA.<P>\n", aRptFile); % 	fputs("\n<HR>\n<HR>\n\n", aRptFile);      }n1     else {				    /* Write section header.	    */X' 	fprintf(aRptFile, "<A NAME=\"%s\">\n",f* 	    section_anchor(mSections, vSection));' 	fprintf(aRptFile, "<H1>%s</H1></a>\n",*( 	    section_name(mSections, vSection));- 	rpt_html_section_nav(aRptFile, vSection, 0);  	fputs("</A>.<P>\n", aRptFile);	     }( }p  N /*************************************************************************++*/ void rpt_html_subsection_hdr(SJ /* Writes a common HTML subsection header to the report file.  This	    */G /* includes navigation links to other sections and subsections.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */o       HTML_SECTION_TYPEr 	    vSection,$ 	    /* (READ, BY VAL):  					    */+ 	    /* Section number to write.					    */n       void    *aNext,i$ 	    /* (READ, BY ADDR):						    */6 	    /* Next subsection object (of any type).			    */       void    *aPrev,s$ 	    /* (READ, BY ADDR):						    */9 	    /* Previous subsection object (of any type).		    */        char    *aFileSuffix,f$ 	    /* (READ, BY ADDR):						    */G 	    /* Optional filename suffix for linking across continuation	    *//G 	    /* files. If NULL is passed, next/prev links will be within	    */ G 	    /* current file. Otherwise, next or prev link (whichever one is */ 2 	    /* NULL) is within a different file.			    */       int	    vFileNumber)# 	    /* (READ, BY VAL):						    */eA 	    /* File number for linking across continuation files.	    */kG 	    /* If this is zero and aFileSuffix is non-NULL, the file name   */ G 	    /* will come from the mSections table. If it is non-zero and    */*G 	    /* aFileSuffix is non-NULL, aFileSuffix will be used with the   */ + 	    /* number to form the name.					    */   & )	/* No return value.      					    */G 	/*****************************************************************--*/    { E     char    fname[MAX_FILE_NAME + 1];	    /* File name buffer.	    */   >     rpt_html_section_nav(aRptFile, vSection, (aNext == NULL));     if (aFileSuffix != NULL) { 	if (vFileNumber) {t. 	    sprintf(fname, aFileSuffix, vFileNumber); 	} 	else {i8 	    strcpy(fname, section_suffix(mSections, vSection)); 	}     }yB     fprintf(aRptFile, "; <A HREF=\"%s\">Beginning of section</a>",0 	link_url(section_suffix(mSections, vSection)));       if (aNext != NULL) {C 	fprintf(aRptFile, "; <A HREF=\"%s#%s%lx\">Next %s in section</a>",k2 	    (aFileSuffix != NULL ? link_url(fname) : ""),3 	    section_subanchor(mSections, vSection), aNext,f* 	    section_objstr(mSections, vSection));     }"       if (aPrev != NULL) {G 	fprintf(aRptFile, "; <A HREF=\"%s#%s%lx\">Previous %s in section</a>",*2 	    (aFileSuffix != NULL ? link_url(fname) : ""),3 	    section_subanchor(mSections, vSection), aPrev,f* 	    section_objstr(mSections, vSection));     }      fputs(".<P>\n", aRptFile); }t  N /*************************************************************************++*/ int rpt_html_continue(N /* Continues an HTML report in a new output file, adding links between the  */N /* files.                                                                   */       FILE    **aRptFile,/' 	    /* (MODIFY, BY ADDR):  					    */ G 	    /* Report file ptr. The current file will be linked and closed  */dG 	    /* through this ptr, and the new file will be opened through    */ ? 	    /* it, leaving it set to the new file information.		    */*          HTML_SECTION_TYPE  	    vSection,$ 	    /* (READ, BY VAL):  					    */0 	    /* Section number being reported.				    */       void    *aCurrent,$ 	    /* (READ, BY ADDR):						    */F 	    /* Current subsection object (of any type) to be reported.	    */       int	    vCurFileNumber,)# 	    /* (READ, BY VAL):						    */s2 	    /* Current file number being ended.				    */          int	    vNextFileNumberl# 	    /* (READ, BY VAL):						    */s1 	    /* Next file number to be started.				    */E  H )	/* Returns vNextFileNumber, next file number started if successful, */+ 	/* or 0 if continuation failed.					    */*G 	/*****************************************************************--*/h   {eN     char    rptname[MAX_FILE_NAME + 1];	    /* Report file name prefix.	    */N     char    outputname[MAX_FILE_NAME + 1];  /* Report file name buffer.	    */  + 					    /* Write ending link to next    */ ) 					    /* object and close file.	    */R@     rpt_html_subsection_hdr(*aRptFile, vSection, aCurrent, NULL,; 	section_moresuffix(mSections, vSection), vNextFileNumber);t     fclose(*aRptFile);  # 					    /* Open next file.		    */*O     sprintf(rptname, section_moresuffix(mSections, vSection), vNextFileNumber);iC     if ((*aRptFile = fopen(make_filename(outfile_prefix(), rptname,u/ 	report_filext(), outputname), "w")) == NULL) {(A 	printf("ERROR: Unable to open %s for report output\n", rptname);*
 	return 0;     }*
     else { 	if (log_enabled()) {/I 	    printf("       Continuing report section in file %s\n", outputname);  	}+ 					    /* Write HTML title, starting   */e+ 					    /* link to previous object.	    */ F 	rpt_html_section_title(*aRptFile, section_name(mSections, vSection));3 	rpt_html_subsection_hdr(*aRptFile, vSection, NULL,o. 	    entry_blink((LIST_ENTRY_HDR *) aCurrent),> 	    section_moresuffix(mSections, vSection), vCurFileNumber); 	return vNextFileNumber;     }u }r  N /*************************************************************************++*/ void rpt_defined_html_hdr(D /* Writes HTML-formatted report header for defined routines.		    */       FILE    *aRptFile $ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   ! )	/* No return value.						    */(G 	/*****************************************************************--*/    {f=     rpt_html_section_hdr(aRptFile, DEFINED_ROUTINES_SECTION);      fputs("<PRE>\n", aRptFile); 
     fputs(M "========================================================================\n",  	aRptFile);l
     fputs(L "                                                           #      Times\n", 	aRptFile);N
     fputs(M "Routine                                     Line  Length   Calls  Called\n",r 	aRptFile); 
     fputs(M "------------------------------------------------------------------------\n",  	aRptFile);  }u  N /*************************************************************************++*/ void rpt_defined_html_entry(E /* Writes HTML-formatted routine entry for a defined routine.		    */f       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */f       DEFINITION 	    *aDef, $ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */          int	    vFirst,t# 	    /* (READ, BY VAL):						    */FD 	    /* Flag indicating whether this is first entry in table.	    */       int	    vLastE# 	    /* (READ, BY VAL):						    */ C 	    /* Flag indicating whether this is last entry in table.	    */a     ! )	/* No return value.						    */LG 	/*****************************************************************--*/R   {%N     char    fullname[MAX_ROUTINE_IDENT + 1];/* Routine fullname buffer.	    */+ 					    /* Routine name folding buffer. */a4     char    rname[RPT_HTML_ROUTINE_MEDIUM_LEN + 1]; 7     int	    pos;			    /* Pos in routine name to	    */r 					    /* print.			    */r  &     strcpy(fullname, def_ident(aDef));+ 					    /* Get first part of rout name. */SM     pos = fold_string(fullname, 0, NULL, rname, RPT_HTML_ROUTINE_MEDIUM_LEN);F	 					    t'     fprintf(aRptFile, "%-40s ", rname);E #if 0_&     fprintf(aRptFile,"%s%7ld%s %7ld ",D 	source_link_prefix(aDef, 0), def_begin(aDef), source_link_suffix(), 	def_length(aDef));I #elseSF     fprintf(aRptFile,"%7ld %7ld ", def_begin(aDef), def_length(aDef)); #endif+     fprintf(aRptFile,"%s%7ld%s %s%7ld%s\n",s= 	(vLast ? "<A NAME=\"defined_routines_section_last\">" : ""),)G 	def_num_calls(aDef), (vLast ? "</A>" : ""), xref_link_prefix(aDef, 0), , 	def_num_callers(aDef), xref_link_suffix()); 	f$     while (pos < strlen(fullname)) {. 	pos = fold_string(fullname, pos, "  ", rname," 	    RPT_HTML_ROUTINE_MEDIUM_LEN);" 	fprintf(aRptFile, "%s\n", rname);     }i },  N /*************************************************************************++*/ void rpt_defined_html_end(A /* Writes HTML-formatted report end for defined routines.		    */	       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        long    vTotalDefu# 	    /* (READ, BY VAL):						    */T2 	    /* Total number of defined routines.			    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/t   {u
     fputs(N "-------------------------------------------------------------------------\n", 	aRptFile);A:     fprintf(aRptFile, "TOTAL: %ld routines\n", vTotalDef);
     fputs(N "=========================================================================\n", 	aRptFile);t,     fputs("</PRE>\n<HR>\n<HR>\n", aRptFile); }R  N /*************************************************************************++*/ void rpt_undefined_html_hdr(F /* Writes HTML-formatted report header for undefined routines.		    */       FILE    *aRptFileo$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { ?     rpt_html_section_hdr(aRptFile, UNDEFINED_ROUTINES_SECTION);      fputs("<PRE>\n", aRptFile);c
     fputs(5 "================================================\n",S 	aRptFile);N
     fputs(4 "                                          Times\n", 	aRptFile);n
     fputs(5 "Routine                                   Called\n",l 	aRptFile);h
     fputs(5 "------------------------------------------------\n",  	aRptFile);  }   N /*************************************************************************++*/ void rpt_undefined_html_entry(G /* Writes HTML-formatted routine entry for a undefined routine.		    */n       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */i       DEFINITION 	    *aDef, $ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */          int	    vFirst, # 	    /* (READ, BY VAL):						    */uD 	    /* Flag indicating whether this is first entry in table.	    */       int	    vLasts# 	    /* (READ, BY VAL):						    */ C 	    /* Flag indicating whether this is last entry in table.	    */h  ! )	/* No return value.						    */ G 	/*****************************************************************--*/{   {rN     char    fullname[MAX_ROUTINE_IDENT + 1];/* Routine fullname buffer.	    */+ 					    /* Routine name folding buffer. */ 4     char    rname[RPT_HTML_ROUTINE_MEDIUM_LEN + 1]; 7     int	    pos;			    /* Pos in routine name to	    */( 					    /* print.			    */*  %     strcpy(fullname, def_name(aDef));*+ 					    /* Get first part of rout name. */tM     pos = fold_string(fullname, 0, NULL, rname, RPT_HTML_ROUTINE_MEDIUM_LEN);t	 					    /,     fprintf(aRptFile,"%s%-40s%s %s%7ld%s\n",? 	(vLast ? "<A NAME=\"undefined_routines_section_last\">" : ""), 9 	rname, (vLast ? "</A>" : ""), xref_link_prefix(aDef, 0), , 	def_num_callers(aDef), xref_link_suffix()); 	*$     while (pos < strlen(fullname)) {. 	pos = fold_string(fullname, pos, "  ", rname," 	    RPT_HTML_ROUTINE_MEDIUM_LEN);" 	fprintf(aRptFile, "%s\n", rname);     }N }P  N /*************************************************************************++*/ void rpt_undefined_html_end(C /* Writes HTML-formatted report end for undefined routines.		    */u       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       long    vTotalUndefm# 	    /* (READ, BY VAL):						    */ 4 	    /* Total number of undefined routines.			    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/s   {d
     fputs(5 "------------------------------------------------\n",/ 	aRptFile);*<     fprintf(aRptFile, "TOTAL: %ld routines\n", vTotalUndef);
     fputs(5 "================================================\n",r 	aRptFile); ,     fputs("</PRE>\n<HR>\n<HR>\n", aRptFile); }p  N /*************************************************************************++*/ void rpt_calls_html_hdr(N /* Writes HTML-formatted report header for defined routine calls/callers    */ /* table.								    */i       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */n       DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/)   {r:     rpt_html_section_hdr(aRptFile, CALLS_CALLERS_SECTION);      fputs("<HR>\n\n", aRptFile);       fprintf(aRptFile,u<     "<TABLE>(%s Calls/Caller Routines)\n", def_ident(aDef));7     fputs("<TABLE_ATTRIBUTES>(MULTIPAGE)\n", aRptFile);t5     fputs("<TABLE_SETUP>(4\\20\\5\\20)\n", aRptFile);;G     fputs("<TABLE_HEADS>(Calls Routine\\Line\\Caller Routine\\Line)\n",( 	aRptFile);R }   N /*************************************************************************++*/ void rpt_calls_html_entry(I /* Writes HTML-formatted calls/caller entry for a defined routine.	    */*       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */F  
     REFERENCEA 	    *aCalled,$ 	    /* (READ, BY ADDR):						    */G 	    /* Called routine reference entry to report. If NULL is passed, */ 2 	    /* only a caller is being reported.				    */     
     REFERENCE 
 	    *aCallert$ 	    /* (READ, BY ADDR):						    */G 	    /* Caller routine reference entry to report. If NULL is passed, */=9 	    /* only a called routine is being reported.			    */=     ! )	/* No return value.						    */ G 	/*****************************************************************--*/p   {)&     fprintf(aRptFile, "<TABLE_ROW>(");     if (aCalled == NULL) { 	fprintf(aRptFile, "\\\\");a     })
     else {B 	fprintf(aRptFile, "%s\\%ld\\", def_name(ref_definition(aCalled)), 	    ref_offset(aCalled));     }      if (aCaller == NULL) { 	fprintf(aRptFile, "\\)\n");     }*
     else {? 	fprintf(aRptFile, "%s\\%ld)\n", def_name(ref_caller(aCaller)),e 	    ref_offset(aCaller));     }f }   N /*************************************************************************++*/ void rpt_calls_html_end(K /* Writes HTML-formatted report end for defined routine calls/caller	    */	 /* table.								    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */lG 	/*****************************************************************--*/*   {*6     fputs("<TABLE_ROW>(<SPAN>(4)<RULE>)\n", aRptFile);M     fprintf(aRptFile, "<TABLE_ROW>(<EMPHASIS>(TOTAL CALLS: %ld\\BOLD)\\\\\n",	 	def_num_calls(aDef));N     fprintf(aRptFile, "            <EMPHASIS>(TOTAL CALLERS: %ld\\BOLD)\\)\n", 	def_num_callers(aDef));&     fputs("<ENDTABLE>\n\n", aRptFile); }.  N /*************************************************************************++*/ void rpt_xref_html_hdr( C /* Writes HTML-formatted report header for cross reference.		    */F       FILE    *aRptFile($ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */f  ! )	/* No return value.						    */fG 	/*****************************************************************--*/d   {g8     rpt_html_section_hdr(aRptFile, CALLER_XREF_SECTION);      fputs("<HR>\n\n", aRptFile); }<  N /*************************************************************************++*/ void rpt_xref_html_entry(eG /* Writes HTML-formatted cross-reference sections for a routine.	    */l       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */F       DEFINITION 	    *aDef,,$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */       int	    vFirst,W# 	    /* (READ, BY VAL):						    */eB 	    /* Flag indicating this is first entry being reported.	    */       int	    vLast # 	    /* (READ, BY VAL):						    */pA 	    /* Flag indicating this is last entry being reported.	    */B     ! )	/* No return value.						    */rG 	/*****************************************************************--*/*   {*2     REFERENCE				    /* Current caller ref.	    */
 	    *caller;uN     char    fullname[MAX_ROUTINE_IDENT + 1];/* Routine fullname buffer.	    */+ 					    /* Routine name folding buffer. */i2     char    rname[RPT_HTML_ROUTINE_WIDE_LEN + 1]; :     int	    rpos;			    /* Pos in routine name to print.*/  N     fprintf(aRptFile, "<H2><A NAME=\"x%lx\">%s</A> - ", aDef, def_name(aDef));"     if (isdefined_routine(aDef)) {9 	fprintf(aRptFile, "%s%s%s", source_link_prefix(aDef, 0),u: 	    source_name(def_source(aDef)), source_link_suffix());     }f
     else { 	fputs("External", aRptFile);F     } (     fputs("</H2><H3>Callers", aRptFile);%     if (def_num_callers(aDef) == 0) { / 	fputs(": No callers</H3>\n<PRE>\n", aRptFile);      }/
     else {# 	fputs("</H3>\n<PRE>\n", aRptFile);*$ 	fprintf(aRptFile, "%ld caller%s\n",E 	    def_num_callers(aDef), (def_num_callers(aDef) == 1 ? "" : "s"));>  + 					    /* Write entry for each caller. */=- 	for (caller = list_first(def_callers(aDef));) 	    caller != NULL;# 	    caller = next_entry(caller)) {T5 	    strcpy(fullname, def_ident(ref_caller(caller)));  	     ( 						/* Get first part of rout name. */1 	    rpos = fold_string(fullname, 0, NULL, rname,- 		RPT_HTML_ROUTINE_WIDE_LEN); 5 	    fprintf(aRptFile, "%5c+ %-48s %s\n", ' ', rname,* 		xref_link(ref_caller(caller),rA 		    (def_xreffile(aDef) == def_xreffile(ref_caller(caller)))));rK 	    while (rpos < strlen(fullname)) {   /* Write rest of routine name.  */D3 		rpos = fold_string(fullname, rpos, "    ", rname, ! 		    RPT_HTML_ROUTINE_WIDE_LEN);E+ 		fprintf(aRptFile, "%5c%s\n", ' ', rname);R 	    } 	}     } "     if (isdefined_routine(aDef)) {( 	fputs("</PRE><H3>Call Tree", aRptFile);  	if (def_num_calls(aDef) == 0) {# 	    fputs(": No calls", aRptFile);h 	} 	fputs("</H3>\n", aRptFile);     } #     if (def_num_calls(aDef) != 0) {) 	fputs("<PRE>\n", aRptFile);     }n
     else { 	fputs("<HR>\n", aRptFile);      }  }*  N /*************************************************************************++*/ void rpt_xref_html_end( G /* Writes HTML-formatted report end for caller cross-reference.		    */r       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */	       long    vTotalDefm# 	    /* (READ, BY VAL):						    */ + 	    /* Total number of routines.				    */*  ! )	/* No return value.						    */nG 	/*****************************************************************--*/E   {UN     fputs("----------------------------------------------------\n", aRptFile);:     fprintf(aRptFile, "TOTAL: %ld routines\n", vTotalDef);N     fputs("====================================================\n", aRptFile);,     fputs("</PRE>\n<HR>\n<HR>\n", aRptFile); }u  N /*************************************************************************++*/ void rpt_tree_html_hdr(pL /* Writes HTML-formatted report header for defined routine call tree.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */s       DEFINITION 	    *aDef,F$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */          int	    vFirst, # 	    /* (READ, BY VAL):						    */); 	    /* Flag indicating whether this is first tree.		    */	       int	    vLastu# 	    /* (READ, BY VAL):						    */*: 	    /* Flag indicating whether this is last tree.		    */     ! )	/* No return value.						    */-G 	/*****************************************************************--*/L   {      if (vFirst) {U4 	rpt_html_section_hdr(aRptFile, CALL_TREES_SECTION); 	fputs("<HR>\n\n", aRptFile);)     }   I     fprintf(aRptFile, "<H2><A NAME=\"t%lx\">%s</a> %sCall Tree%s</H2>\n",* 	aDef, def_ident(aDef),*? 	(vLast ? "<A NAME=\"routine_call_trees_section_last\">" : ""),f 	(vLast ? "</A>" : ""));9     rpt_html_subsection_hdr(aRptFile, CALL_TREES_SECTION,*" 	(vLast ? NULL : next_tree(aDef)),- 	(vFirst ? NULL : prev_tree(aDef)), NULL, 0);o     fputs("<PRE>\n", aRptFile);l }	  N /*************************************************************************++*/ void rpt_tree_html_entry(yF /* Writes HTML-formatted call tree line for a defined routine.		    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */N  
     REFERENCER 	    *aRef,i$ 	    /* (READ, BY ADDR):						    */F 	    /* Reference to routine definition entry to report.       	    */       int	    vLevel,)# 	    /* (READ, BY VAL):						    */E9 	    /* Nesting level, used to space indentation.		    */>       int	    vExpanded,# 	    /* (READ, BY VAL):						    */ F 	    /* Flag indicating whether or not routine has already been	    */- 	    /* expanded in this call tree.				    */i       int	    vRecursive# 	    /* (READ, BY VAL):						    */ @ 	    /* Flag indicating whether or not routine is called		    */  	    /* recursively.						    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*//   {l6     int	    lcount;			    /* Level print count.	    */  1     for (lcount = vLevel; lcount > 1; lcount--) {  	fputs("|   ", aRptFile);      }l     if (lcount > 0) { ? 	fprintf(aRptFile, "%c   ", (isend_of_list(aRef) ? '+' : '|'));o     }N     if (vLevel == 0) { #if 0y 	fprintf(aRptFile,"%s%s%s: ",r1 	    source_link_prefix(ref_definition(aRef), 0), ; 	    def_name(ref_definition(aRef)), source_link_suffix());*( 	fprintf(aRptFile, "%s%ld caller%s%s\n",/ 	    xref_link_prefix(ref_definition(aRef), 0), + 	    def_num_callers(ref_definition(aRef)),e= 	    (def_num_callers(ref_definition(aRef)) == 1 ? "" : "s"),l 	    xref_link_suffix());l #else : 	fprintf(aRptFile,"%s\n", def_name(ref_definition(aRef))); #endif     } + 					    /* If routine is not going to   */f+ 					    /* be expanded here, add an	    */(G     else if (vExpanded || vRecursive ||	    /* explanation code.	    */*, 	!isdefined_routine(ref_definition(aRef))) {! 	fprintf(aRptFile, "%s (%s%s%s)",d$ 	    def_name(ref_definition(aRef)),$ 	    (vExpanded ? "Duplicate" : ""),% 	    (vRecursive ? "Recursive" : ""),RC 	    (!isdefined_routine(ref_definition(aRef)) ? "External" : ""));d     }l #if 0 + 					    /* Separate tree gets link.	    */RK     else if (needs_tree(ref_definition(aRef)) && !tree_inline_disabled()) { ) 	fprintf(aRptFile, "%s %s(Separate)%s\n",l$ 	    def_name(ref_definition(aRef)),D 	    xref_link_prefix(ref_definition(aRef), 0), xref_link_suffix());     }R #else"H     else if (needs_tree(ref_definition(aRef)) && !tree_inline_disabled() 	|| vLevel == max_tree_depth()2 	    && def_num_calls(ref_definition(aRef)) > 0) {D 	fprintf(aRptFile, "%s (Separate)", def_name(ref_definition(aRef)));     }< #endif #if 0 6     else if (def_root(ref_definition(aRef)) == NULL) {+ 					    /* This is the first inline	    */d+ 					    /* expansion of a routine, make */d! 					    /* it an anchor.		    */	C 	fprintf(aRptFile, "<A NAME=\"t%lx\">%s</a>", ref_definition(aRef), % 	    def_name(ref_definition(aRef)));      }b #endif4     else {				    /* Otherwise, format plain.	    */9 	fprintf(aRptFile, "%s", def_name(ref_definition(aRef)));*     }d     if (vLevel > 0) {c@ 	fprintf(aRptFile, " %s\n", xref_link(ref_definition(aRef), 0));     }; }<  N /*************************************************************************++*/ void rpt_tree_html_end(yJ /* Writes HTML-formatted section end for defined routine call tree.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */F       DEFINITION 	    *aDef,,$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */       int	    vFirst,W# 	    /* (READ, BY VAL):						    */e; 	    /* Flag indicating whether this is first tree.		    */	       int	    vLast # 	    /* (READ, BY VAL):						    */ : 	    /* Flag indicating whether this is last tree.		    */     ! )	/* No return value.						    */eG 	/*****************************************************************--*/*   {*%     fputs("END OF TREE\n", aRptFile); (     fputs("</PRE>\n<HR>\n\n", aRptFile); }   N /*************************************************************************++*/ void rpt_byfile_html_hdr(gN /* Writes HTML-formatted report header for defined routines by file table.  */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */       int	    vFirst,f# 	    /* (READ, BY VAL):						    */x< 	    /* Flag indicating whether this is first table.		    */       int	    vLast_# 	    /* (READ, BY VAL):						    */ ; 	    /* Flag indicating whether this is last table.		    */f     ! )	/* No return value.						    */nG 	/*****************************************************************--*/e   {e     if (vFirst) {): 	rpt_html_section_hdr(aRptFile, ROUTINES_BY_FILE_SECTION); 	fputs("<HR>\n\n", aRptFile);D     }   H     fprintf(aRptFile, "<H2><A NAME=\"f%lx\">%s</a> %sRoutines%s</H2>\n",' 	aSourceFile, source_name(aSourceFile), = 	(vLast ? "<A NAME=\"routines_by_file_section_last\">" : ""),d 	(vLast ? "</A>" : ""));?     rpt_html_subsection_hdr(aRptFile, ROUTINES_BY_FILE_SECTION,"2 	(vLast ? NULL : next_defining_file(aSourceFile)),= 	(vFirst ? NULL : prev_defining_file(aSourceFile)), NULL, 0);l     fputs("<PRE>\n", aRptFile);sF     fputs("=======================================================\n", 	aRptFile);lE     fputs("                                          #      Times\n",i 	aRptFile); F     fputs("Routine                    Line  Length   Calls  Called\n", 	aRptFile);uF     fputs("-------------------------------------------------------\n", 	aRptFile);  }c  N /*************************************************************************++*/ void rpt_byfile_html_entry(EE /* Writes HTML-formatted entry for a defined routine by file.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */T       DEFINITION 	    *aDef,l$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */       int	    vFirst, # 	    /* (READ, BY VAL):						    */*D 	    /* Flag indicating whether this is first entry in table.	    */       int	    vLast # 	    /* (READ, BY VAL):						    */nC 	    /* Flag indicating whether this is last entry in table.	    */*     ! )	/* No return value.						    */(G 	/*****************************************************************--*/    {t;     char    anchor[32]; 		    /* Anchor name buffer.	    */=+ 					    /* Routine name folding buffer. */=0     char    rname[RPT_HTML_FILE_FIELD_LEN + 1]; 7     int	    pos;			    /* Pos in routine name to	    */* 					    /* print.			    */*  2     if (vLast) {			    /* Form anchor name.	    */= 	sprintf(anchor, "<A NAME=\"f%lx_last\">", def_source(aDef));/     } + 					    /* Get first part of rout name. */	5     pos = fold_string(def_name(aDef), 0, NULL, rname,b 	RPT_HTML_ROUTINE_FIELD_LEN);I #if 0					    &     fprintf(aRptFile, "%s%-23s%s %s ",5 	(vLast ? anchor : ""), rname, (vLast ? "</A>" : ""),  	tree_link(aDef, 0));t #else #     fprintf(aRptFile, "%s%-23s%s ", 6 	(vLast ? anchor : ""), rname, (vLast ? "</A>" : "")); #endif&     fprintf(aRptFile,"%s%7ld%s %7ld ",D 	source_link_prefix(aDef, 0), def_begin(aDef), source_link_suffix(), 	def_length(aDef));u!     fprintf(aRptFile,"%s%7ld%s ",*G 	calls_link_prefix(aDef, 0), def_num_calls(aDef), calls_link_suffix());f"     fprintf(aRptFile,"%s%7ld%s\n",G 	xref_link_prefix(aDef, 0), def_num_callers(aDef), xref_link_suffix());  	 *     while (pos < strlen(def_name(aDef))) {4 	pos = fold_string(def_name(aDef), pos, "  ", rname,! 	    RPT_HTML_ROUTINE_FIELD_LEN);r" 	fprintf(aRptFile, "%s\n", rname);     }A }:  N /*************************************************************************++*/ void rpt_byfile_html_end(rM /* Writes HTML-formatted report end for defined routine by file table.	    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */r       SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */          int	    vFirst,b# 	    /* (READ, BY VAL):						    */E< 	    /* Flag indicating whether this is first table.		    */       int	    vLastr# 	    /* (READ, BY VAL):						    */ ; 	    /* Flag indicating whether this is last table.		    */	     ! )	/* No return value.						    */oG 	/*****************************************************************--*/    {	F     fputs("-------------------------------------------------------\n", 	aRptFile); B     fprintf(aRptFile, "TOTAL: %5ld ROUTINES           %7ld AVG\n",; 	source_routines(aSourceFile), source_avglen(aSourceFile));cF     fputs("=======================================================\n", 	aRptFile);	E     fprintf(aRptFile, "</PRE>\n<HR>\n%s\n", (vLast ? "<HR>\n" : ""));* }*  N /*************************************************************************++*/ void rpt_file_html_hdr(o@ /* Writes HTML-formatted report header for source files.		    */       FILE    *aRptFile>$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */)  ! )	/* No return value.						    */:G 	/*****************************************************************--*/e   {i     /*+									    */M     /*	This file is the main analysis HTML file, so first write the main   */(9     /*	document header, then the section header.			    */t     /*-									    */  5     rpt_html_section_hdr(aRptFile, MAIN_SECTION);     =     rpt_html_section_hdr(aRptFile, SOURCE_FILES_SECTION);    a          fputs("<PRE>\n", aRptFile); 
     fputs(T "===============================================================================\n", 	aRptFile);x
     fputs(P "                                 Com-    State-   Rou-              Avg   #\n", 	aRptFile);r
     fputs(T "File                      Lines  mented    ment   tines  Length     Len   Calls\n", 	aRptFile); 
     fputs(T "-------------------------------------------------------------------------------\n", 	aRptFile);l }i  N /*************************************************************************++*/ void rpt_file_html_entry(l5 /* Writes HTML-formatted source file entry.				    */%       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */s       SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */       int	    vFirst,a# 	    /* (READ, BY VAL):						    */(D 	    /* Flag indicating whether this is first entry in table.	    */       int	    vLast(# 	    /* (READ, BY VAL):						    */	C 	    /* Flag indicating whether this is last entry in table.	    */r     ! )	/* No return value.						    */rG 	/*****************************************************************--*/a   { + 					    /* File name folding buffer.    */ 0     char    fname[RPT_HTML_FILE_FIELD_LEN + 1]; 9     int	    pos;			    /* Pos in file name to print.   */i       /*+									    */M     /*	The file name may have to be folded over multiple lines. Embed a    */)M     /*	hyperlink to the routines table for this file, and an anchor to the */*;     /*	line if it is the last entry in this table.			    */L     /*-									    */  + 					    /* Get first part of file name. */E?     pos = fold_string(source_name(aSourceFile), 0, NULL, fname,o 	RPT_HTML_FILE_FIELD_LEN);  6     fprintf(aRptFile, "%s%-23s%s %s%7ld%s %7ld %7ld ",9 	(vLast ? "<A NAME=\"source_files_section_last\">" : ""),iC 	fname, (vLast ? "</A>" : ""), sourcefile_link_prefix(aSourceFile),B1 	source_lines(aSourceFile), source_link_suffix(),e: 	source_comments(aSourceFile) + source_mixed(aSourceFile),= 	source_statements(aSourceFile) + source_mixed(aSourceFile)); 2     fprintf(aRptFile, "%s%7ld%s %7ld %7ld %7ld\n",G 	(source_routines(aSourceFile) > 0 ? byfile_link_prefix(aSourceFile, 0)* 	    : ""),* 	source_routines(aSourceFile),@ 	(source_routines(aSourceFile) > 0 ? byfile_link_suffix() : ""), 	source_rlength(aSourceFile),*8 	source_avglen(aSourceFile), source_calls(aSourceFile));  4     while (pos < strlen(source_name(aSourceFile))) {> 	pos = fold_string(source_name(aSourceFile), pos, "  ", fname, 	    RPT_HTML_FILE_FIELD_LEN);" 	fprintf(aRptFile, "%s\n", fname);     }b }p  N /*************************************************************************++*/ void rpt_file_html_end(/> /* Writes HTML-formatted report end for source files.			    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        long    vTotalFiles # 	    /* (READ, BY VAL):						    */ / 	    /* Total number of source files.				    */n  ! )	/* No return value.						    */*G 	/*****************************************************************--*/F   { 
     fputs(T "-------------------------------------------------------------------------------\n", 	aRptFile);p 	t     fprintf(aRptFile,E@     "TOTAL: %7ld files    %7ld %7ld %7ld %7ld %7ld %7ld %7ld\n", 	vTotalFiles, total_lines(), AF 	total_comments() + total_mixed(), total_statements() + total_mixed(),C 	total_routines(), total_rlength(), total_avglen(), total_calls());( 	s
     fputs(T "===============================================================================\n", 	aRptFile); .     fputs("</PRE>\n<HR>\n<HR>\n\n", aRptFile); }=  N /*************************************************************************++*/ void rpt_source_html_hdr( H /* Writes HTML-formatted report header for annotated source file.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */a       SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */       int	    vFirst,a# 	    /* (READ, BY VAL):						    */i< 	    /* Flag indicating whether this is first table.		    */       int	    vLast/# 	    /* (READ, BY VAL):						    */b; 	    /* Flag indicating whether this is last table.		    */R     ! )	/* No return value.						    */nG 	/*****************************************************************--*/R   {B7     REFERENCE				    /* Current routine reference.   */s
 	    *curref;        if (vFirst) { 5 	rpt_html_section_hdr(aRptFile, SOURCE_CODE_SECTION);  	fputs("<HR>\n\n", aRptFile);      }   ?     rpt_html_section_title(aRptFile, source_name(aSourceFile));*G     fprintf(aRptFile, "<H2><A NAME=\"s%lx\">%s</a> Source Code</H2>\n",*( 	aSourceFile, source_name(aSourceFile));:     rpt_html_subsection_hdr(aRptFile, SOURCE_CODE_SECTION,* 	(vLast ? NULL : next_entry(aSourceFile)),B 	(vFirst ? NULL : prev_entry(aSourceFile)), OUTFILE_SUFFIX_SOURCE, 	source_seq(aSourceFile));
     fputs(X "<H3><A NAME=\"routines_in_this_file\">Routines In This File (Alphabetical)</a></H3>\n", 	aRptFile);s          fputs("<PRE>\n", aRptFile); ,     if (source_routines(aSourceFile) == 0) { 	fputs("   None.\n", aRptFile);a     }R
     else {- 	fputs(" Line Name\n----- ----\n", aRptFile);R7 	for (curref = list_first(source_reflist(aSourceFile));( 	    curref != NULL;# 	    curref = next_entry(curref)) { & 	    fprintf(aRptFile, "%5d %s%s%s\n",$ 		def_begin(ref_definition(curref)),0 		source_link_prefix(ref_definition(curref), 1),: 		def_name(ref_definition(curref)), source_link_suffix()); 	} 	fputs("</PRE>\n", aRptFile);f     }      D     fputs("<HR>\n<PRE>BEGINNING OF FILE\n</PRE>\n<HR>\n", aRptFile);     fputs("<PRE>\n", aRptFile);  }p  N /*************************************************************************++*/ void rpt_source_html_entry( D /* Writes HTML-formatted entry for an annotated source line.		    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       DEFINITION 	    *aDef,*$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */       char    *aSrcLine,$ 	    /* (READ, BY ADDR):						    */, 	    /* Source file line contents.				    */       int	    vLine # 	    /* (READ, BY VAL):						    */*+ 	    /* Source file line number.					    */      ! )	/* No return value.						    */ G 	/*****************************************************************--*//   {A8     DEFINITION				    /* Next definition in file.	    */ 	    *nextdef; 	     3     if (aDef != NULL && def_begin(aDef) == vLine) {	F 	fprintf(aRptFile, "</PRE><HR>\n<A NAME=\"d%lx\">ROUTINE</A> ", aDef);' 	fprintf(aRptFile, "%s%s%s. Go to: \n",oD 	    xref_link_prefix(aDef, 0), def_name(aDef), xref_link_suffix());, 	if ((nextdef = next_entry(aDef)) != NULL) {4 	    fprintf(aRptFile, "%sNext routine in file%s; ",8 		source_link_prefix(nextdef, 1), source_link_suffix()); 	} #if 0u 	fprintf(aRptFile,T "%s; %s; <A HREF=\"#routines_in_this_file\">Routines in this file</A>.<P>\n<PRE>\n",- 	    xref_link(aDef, 0), tree_link(aDef, 0));t #elsei 	fputs(EL "<A HREF=\"#routines_in_this_file\">Routines in this file</A>.<P>\n<PRE>\n", 	    aRptFile);* #endif     }*&     fprintf(aRptFile, "%6d: ", vLine);+     for (; *aSrcLine != '\0'; aSrcLine++) {r 	switch (*aSrcLine) { * 	case '>': fputs("&gt;", aRptFile); break;* 	case '<': fputs("&lt;", aRptFile); break;+ 	case '&': fputs("&amp;", aRptFile); break;*% 	default: fputc(*aSrcLine, aRptFile);* 	}     }*1     if (aDef != NULL && def_end(aDef) == vLine) {e 	fprintf(aRptFile,F 	"</PRE>\nEND %s. Go to: %sBeginning of routine%s.<P>\n<HR>\n<PRE>\n",H 	    def_name(aDef), source_link_prefix(aDef, 1), source_link_suffix());     }  }*  N /*************************************************************************++*/ void rpt_source_html_end(,F /* Writes HTML-formatted report end for annotated source file.		    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */          int	    vFirst, # 	    /* (READ, BY VAL):						    */a< 	    /* Flag indicating whether this is first table.		    */       int	    vLast-# 	    /* (READ, BY VAL):						    */l; 	    /* Flag indicating whether this is last table.		    */*     ! )	/* No return value.						    */tG 	/*****************************************************************--*/    { -     fputs("<HR>\nEND OF FILE\n\n", aRptFile); >     fprintf(aRptFile, "TOTAL: %ld routines, %ld Avg Length\n",; 	source_routines(aSourceFile), source_avglen(aSourceFile));DE     fprintf(aRptFile, "</PRE>\n<HR>\n%s\n", (vLast ? "<HR>\n" : "")); :     rpt_html_subsection_hdr(aRptFile, SOURCE_CODE_SECTION,* 	(vLast ? NULL : next_entry(aSourceFile)),B 	(vFirst ? NULL : prev_entry(aSourceFile)), OUTFILE_SUFFIX_SOURCE, 	source_seq(aSourceFile)); }c  