N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ 5 /*  MODULE:	SDML Report Formatting Routines				    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This module contains the routines for generating Routine   */N /*  Analyzer reports in SDML format, suitable for input to VAX DOCUMENT.    */ /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include <stdio.h> #include "ranalyzer.h"  ? #define MAX_VALID_BREAK	    60			/* Lines between breaks.    */   < static int mLastValidBreak;			/* Last source break line.  */  N /*************************************************************************++*/ void rpt_defined_sdml_hdr(D /* Writes SDML-formatted report header for defined routines.		    */       FILE    *aRptFile $ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { X     fputs("<TABLE>(Defined Routines Alphabetical\\defined_routines_table)\n", aRptFile);=     fputs("<TABLE_ATTRIBUTES>(MULTIPAGE\\WIDE)\n", aRptFile); ;     fputs("<TABLE_SETUP>(6\\20\\20\\7\\5\\5)\n", aRptFile); 
     fputs(Q "<TABLE_HEADS>(Routine\\Defined In File\\Line\\Length\\# Calls\\Times Called)\n",  	aRptFile);  }   N /*************************************************************************++*/ void rpt_defined_sdml_entry(E /* Writes SDML-formatted routine entry for a defined routine.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { B     fprintf(aRptFile, "<TABLE_ROW>(%s\\%s\\%ld\\%ld\\%ld\\%ld)\n",@ 	def_name(aDef), source_name(def_source(aDef)), def_begin(aDef),? 	def_length(aDef), def_num_calls(aDef), def_num_callers(aDef));  }   N /*************************************************************************++*/ void rpt_defined_sdml_end(A /* Writes SDML-formatted report end for defined routines.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        long    vTotalDef # 	    /* (READ, BY VAL):						    */ 2 	    /* Total number of defined routines.			    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { 6     fputs("<TABLE_ROW>(<SPAN>(6)<RULE>)\n", aRptFile);N     fprintf(aRptFile, "<TABLE_ROW>(<EMPHASIS>(TOTAL ROUTINES: %ld\\BOLD)\\\n", 	vTotalDef);O     fprintf(aRptFile, "            <EMPHASIS>(TOTAL DEF LINES: %ld\\BOLD)\\\n",  	total_rlength());D     fprintf(aRptFile, "            <EMPHASIS>(AVG LEN:\\BOLD)\\\n");A     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\\)\n",  	total_avglen()); $     fputs("<ENDTABLE>\n", aRptFile); }   N /*************************************************************************++*/ void rpt_undefined_sdml_hdr(F /* Writes SDML-formatted report header for undefined routines.		    */       FILE    *aRptFile $ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { Z     fputs("<TABLE>(External Routines Alphabetical\\external_routines_table)\n", aRptFile);7     fputs("<TABLE_ATTRIBUTES>(MULTIPAGE)\n", aRptFile); .     fputs("<TABLE_SETUP>(2\\20)\n", aRptFile);>     fputs("<TABLE_HEADS>(Routine\\Times Called)\n", aRptFile); }   N /*************************************************************************++*/ void rpt_undefined_sdml_entry(G /* Writes SDML-formatted routine entry for a undefined routine.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { /     fprintf(aRptFile, "<TABLE_ROW>(%s\\%ld)\n", ( 	def_name(aDef), def_num_callers(aDef)); }   N /*************************************************************************++*/ void rpt_undefined_sdml_end(C /* Writes SDML-formatted report end for undefined routines.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        long    vTotalUndef # 	    /* (READ, BY VAL):						    */ 4 	    /* Total number of undefined routines.			    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { 6     fputs("<TABLE_ROW>(<SPAN>(2)<RULE>)\n", aRptFile);O     fprintf(aRptFile, "<TABLE_ROW>(<EMPHASIS>(TOTAL ROUTINES: %ld\\BOLD)\\)\n",  	vTotalUndef);$     fputs("<ENDTABLE>\n", aRptFile); }   N /*************************************************************************++*/ void rpt_calls_sdml_hdr(N /* Writes SDML-formatted report header for defined routine calls/callers    */ /* table.								    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      fprintf(aRptFile, <     "<TABLE>(%s Calls/Caller Routines)\n", def_ident(aDef));7     fputs("<TABLE_ATTRIBUTES>(MULTIPAGE)\n", aRptFile); 5     fputs("<TABLE_SETUP>(4\\20\\5\\20)\n", aRptFile); G     fputs("<TABLE_HEADS>(Calls Routine\\Line\\Caller Routine\\Line)\n",  	aRptFile);  }   N /*************************************************************************++*/ void rpt_calls_sdml_entry(I /* Writes SDML-formatted calls/caller entry for a defined routine.	    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   
     REFERENCE  	    *aCalled,$ 	    /* (READ, BY ADDR):						    */G 	    /* Called routine reference entry to report. If NULL is passed, */ 2 	    /* only a caller is being reported.				    */     
     REFERENCE 
 	    *aCaller $ 	    /* (READ, BY ADDR):						    */G 	    /* Caller routine reference entry to report. If NULL is passed, */ 9 	    /* only a called routine is being reported.			    */      ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { &     fprintf(aRptFile, "<TABLE_ROW>(");     if (aCalled == NULL) { 	fprintf(aRptFile, "\\\\");      } 
     else {B 	fprintf(aRptFile, "%s\\%ld\\", def_name(ref_definition(aCalled)), 	    ref_offset(aCalled));     }      if (aCaller == NULL) { 	fprintf(aRptFile, "\\)\n");     } 
     else {? 	fprintf(aRptFile, "%s\\%ld)\n", def_name(ref_caller(aCaller)),  	    ref_offset(aCaller));     }  }   N /*************************************************************************++*/ void rpt_calls_sdml_end(K /* Writes SDML-formatted report end for defined routine calls/caller	    */  /* table.								    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */*G 	/*****************************************************************--*/n   {r6     fputs("<TABLE_ROW>(<SPAN>(4)<RULE>)\n", aRptFile);M     fprintf(aRptFile, "<TABLE_ROW>(<EMPHASIS>(TOTAL CALLS: %ld\\BOLD)\\\\\n",  	def_num_calls(aDef));N     fprintf(aRptFile, "            <EMPHASIS>(TOTAL CALLERS: %ld\\BOLD)\\)\n", 	def_num_callers(aDef));&     fputs("<ENDTABLE>\n\n", aRptFile); }s  N /*************************************************************************++*/ void rpt_xref_sdml_hdr(/C /* Writes SDML-formatted report header for cross reference.		    */        FILE    *aRptFileG$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*  ! )	/* No return value.						    */*G 	/*****************************************************************--*/u   {a }y  N /*************************************************************************++*/ void rpt_xref_sdml_entry(*G /* Writes SDML-formatted cross-reference sections for a routine.	    */*       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */	       DEFINITION 	    *aDef, $ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */       int	    vFirst# 	    /* (READ, BY VAL):						    */*B 	    /* Flag indicating this is first entry being reported.	    */     ! )	/* No return value.						    */hG 	/*****************************************************************--*/B   {(2     REFERENCE				    /* Current caller ref.	    */
 	    *caller;0N     char    fullname[MAX_ROUTINE_IDENT + 1];/* Routine fullname buffer.	    */+ 					    /* Routine name folding buffer. */a2     char    rname[RPT_HTML_ROUTINE_WIDE_LEN + 1]; :     int	    rpos;			    /* Pos in routine name to print.*/  I     fprintf(aRptFile, "<FIGURE>(%s Cross Reference)\n", def_ident(aDef));	 #if 0 9     fputs("<FIGURE_ATTRIBUTES>(KEEP\\WIDE)\n", aRptFile); 
 #endif    6     fputs("<FIGURE_ATTRIBUTES>(MULTIPAGE)", aRptFile);*     fputs("<LINE_ART>(WIDE)\n", aRptFile);      fputs("CALLERS:", aRptFile);%     if (def_num_callers(aDef) == 0) { " 	fputs(" No callers\n", aRptFile);     }*
     else {0 	fprintf(aRptFile, "\n\n%3c%ld caller%s\n", ' ',E 	    def_num_callers(aDef), (def_num_callers(aDef) == 1 ? "" : "s"));l  + 					    /* Write entry for each caller. */d- 	for (caller = list_first(def_callers(aDef));( 	    caller != NULL;# 	    caller = next_entry(caller)) { 5 	    strcpy(fullname, def_ident(ref_caller(caller)));* 	    *+ 					    /* Get first part of rout name. */*1 	    rpos = fold_string(fullname, 0, NULL, rname,n 		RPT_HTML_ROUTINE_WIDE_LEN);p3 	    fprintf(aRptFile, "%8c+ %-48s\n", ' ', rname); H 	    while (rpos < strlen(fullname)) {/* Write rest of routine name.  */3 		rpos = fold_string(fullname, rpos, "    ", rname, ! 		    RPT_HTML_ROUTINE_WIDE_LEN);	+ 		fprintf(aRptFile, "%8c%s\n", ' ', rname);  	    } 	}     }*"     if (isdefined_routine(aDef)) {! 	fputs("\nCALL TREE:", aRptFile);<  	if (def_num_calls(aDef) == 0) {$ 	    fputs(" No calls\n", aRptFile); 	} 	else {S 	    fputs("\n\n", aRptFile);\ 	}     }a#     if (def_num_calls(aDef) == 0) { $ 	fputs("<ENDLINE_ART>\n", aRptFile);$ 	fputs("<ENDFIGURE>\n\n", aRptFile);     }(         - #if 0					    /* Write section header.	    */ F     fprintf(aRptFile, "<TABLE>(%s Callers\\WIDE)\n", def_ident(aDef));.     fputs("<TABLE_SETUP>(2\\20)\n", aRptFile);9     fputs("<TABLE_HEADS>(Routine\\Callers)\n", aRptFile);*%     if (def_num_callers(aDef) == 0) {tG 	fprintf(aRptFile, "<TABLE_ROW>(%s\\- No callers)\n", def_ident(aDef));d     }e4     else {				    /* Write entry for each caller. */: 	fprintf(aRptFile, "<TABLE_ROW>(%s\\<LIST>(UNNUMBERED)\n", 	    def_ident(aDef));- 	for (caller = list_first(def_callers(aDef));* 	    caller != NULL;# 	    caller = next_entry(caller)) {-B 	    fprintf(aRptFile, "<LE>%s\n", def_ident(ref_caller(caller))); 	}! 	fputs("<ENDLIST>)\n", aRptFile);      }<$     fputs("<ENDTABLE>\n", aRptFile); #endif }   N /*************************************************************************++*/ void rpt_xref_sdml_end( G /* Writes SDML-formatted report end for caller cross-reference.		    */*       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */E       long    vTotalDefR# 	    /* (READ, BY VAL):						    */e+ 	    /* Total number of routines.				    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {t }	  N /*************************************************************************++*/ void rpt_tree_sdml_hdr(*L /* Writes SDML-formatted report header for defined routine call tree.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */r       DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    *//G 	/*****************************************************************--*/T   {n }   N /*************************************************************************++*/ void rpt_tree_sdml_entry(nF /* Writes SDML-formatted call tree line for a defined routine.		    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */S  
     REFERENCES 	    *aRef,\$ 	    /* (READ, BY ADDR):						    */F 	    /* Reference to routine definition entry to report.       	    */       int	    vLevel,*# 	    /* (READ, BY VAL):						    */(9 	    /* Nesting level, used to space indentation.		    */e       int	    vExpanded,# 	    /* (READ, BY VAL):						    */aF 	    /* Flag indicating whether or not routine has already been	    */- 	    /* expanded in this call tree.				    */E       int	    vRecursive# 	    /* (READ, BY VAL):						    */ @ 	    /* Flag indicating whether or not routine is called		    */  	    /* recursively.						    */  ! )	/* No return value.						    */*G 	/*****************************************************************--*/    {/6     int	    lcount;			    /* Level print count.	    */       fputs("   ", aRptFile);p1     for (lcount = vLevel; lcount > 1; lcount--) {, 	fputs("|   ", aRptFile);A     }D     if (lcount > 0) {\ 	if (isend_of_list(aRef)) {a 	    fputs("+   ", aRptFile);* 	} 	else {* 	    fputs("|   ", aRptFile);* 	}     }*     if (vLevel == 0) {; 	fprintf(aRptFile, "%s\n", def_name(ref_definition(aRef)));      } + 					    /* If routine is not going to   */ + 					    /* be expanded here, format it  */e( 					    /* in italics and add an	    */G     else if (vExpanded || vRecursive ||	    /* explanation code.	    */	A 	(needs_tree(ref_definition(aRef)) && !tree_inline_disabled()) || , 	!isdefined_routine(ref_definition(aRef))) {9 	fprintf(aRptFile, "<EMPHASIS>(%s\\italic) (%s%s%s%s)\n", $ 	    def_name(ref_definition(aRef)),$ 	    (vExpanded ? "Duplicate" : ""),% 	    (vRecursive ? "Recursive" : ""), C 	    (needs_tree(ref_definition(aRef)) && !vRecursive && !vExpanded 0 		&& !tree_inline_disabled() ? "Separate" : ""),C 	    (!isdefined_routine(ref_definition(aRef)) ? "External" : ""));(     }eN     else if (vLevel == max_tree_depth()	    /* Reached expansion limit?	    */. 	&& def_num_calls(ref_definition(aRef)) > 0) {9 	fprintf(aRptFile, "<EMPHASIS>(%s\\italic) (Separate)\n",e% 	    def_name(ref_definition(aRef)));{     }n4     else {				    /* Otherwise, format plain.	    */; 	fprintf(aRptFile, "%s\n", def_name(ref_definition(aRef)));r     }e }C  N /*************************************************************************++*/ void rpt_tree_sdml_end(dJ /* Writes SDML-formatted section end for defined routine call tree.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */t       DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */	G 	/*****************************************************************--*/*   {*(     fputs("   END OF TREE\n", aRptFile);'     fputs("<ENDLINE_ART>\n", aRptFile);R'     fputs("<ENDFIGURE>\n\n", aRptFile);e }<  N /*************************************************************************++*/ void rpt_byfile_sdml_hdr( N /* Writes SDML-formatted report header for defined routines by file table.  */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */r       SOURCEFILE 	    *aSourceFiler$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */     ! )	/* No return value.						    */oG 	/*****************************************************************--*/e   {	J     fprintf(aRptFile, "<TABLE>(%s Routines)\n", source_name(aSourceFile));7     fputs("<TABLE_ATTRIBUTES>(MULTIPAGE)\n", aRptFile);*7     fputs("<TABLE_SETUP>(5\\20\\7\\5\\5)\n", aRptFile);dJ     fputs("<TABLE_HEADS>(Routine\\Line\\Length\\# Calls\\Times Called)\n", 	aRptFile);  }I  N /*************************************************************************++*/ void rpt_byfile_sdml_entry( E /* Writes SDML-formatted entry for a defined routine by file.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */*G 	/*****************************************************************--*/    {lN     fprintf(aRptFile, "<TABLE_ROW>(%s\\%ld\\%ld\\%ld\\%ld)\n", def_name(aDef),8 	def_begin(aDef), def_length(aDef), def_num_calls(aDef), 	def_num_callers(aDef)); }W  N /*************************************************************************++*/ void rpt_byfile_sdml_end((M /* Writes SDML-formatted report end for defined routine by file table.	    */E       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */\       SOURCEFILE 	    *aSourceFile $ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */     ! )	/* No return value.						    */"G 	/*****************************************************************--*/s   {)6     fputs("<TABLE_ROW>(<SPAN>(5)<RULE>)\n", aRptFile);P     fprintf(aRptFile, "<TABLE_ROW>(<EMPHASIS>(TOTAL: %ld ROUTINES\\BOLD)\\\\\n", 	source_routines(aSourceFile));)E     fprintf(aRptFile, "            <EMPHASIS>(%ld AVG\\BOLD)\\\\)\n",	 	source_avglen(aSourceFile));t&     fputs("<ENDTABLE>\n\n", aRptFile); }e  N /*************************************************************************++*/ void rpt_file_sdml_hdr( @ /* Writes SDML-formatted report header for source files.		    */       FILE    *aRptFileg$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */'  ! )	/* No return value.						    */ G 	/*****************************************************************--*/d   {mP     fputs("<TABLE>(Source Files Alphabetical\\source_files_table)\n", aRptFile);=     fputs("<TABLE_ATTRIBUTES>(MULTIPAGE\\WIDE)\n", aRptFile); @     fputs("<TABLE_SETUP>(8\\20\\6\\5\\6\\4\\6\\4)\n", aRptFile);
     fputs(_ "<TABLE_HEADS>(File\\Lines\\Com- mented\\State- ment\\Rou- tines\\Length\\Avg Len\\# Calls)\n",< 	aRptFile);l }\  N /*************************************************************************++*/ void rpt_file_sdml_entry(e5 /* Writes SDML-formatted source file entry.				    */f       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */f       SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */     ! )	/* No return value.						    */=G 	/*****************************************************************--*/>   {,M     fprintf(aRptFile, "<TABLE_ROW>(%s\\%ld\\%ld\\%ld\\%ld\\%ld\\%ld\\%ld)\n",<5 	source_name(aSourceFile), source_lines(aSourceFile),*: 	source_comments(aSourceFile) + source_mixed(aSourceFile),< 	source_statements(aSourceFile) + source_mixed(aSourceFile),; 	source_routines(aSourceFile), source_rlength(aSourceFile), 8 	source_avglen(aSourceFile), source_calls(aSourceFile)); }   N /*************************************************************************++*/ void rpt_file_sdml_end()> /* Writes SDML-formatted report end for source files.			    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       long    vTotalFiles*# 	    /* (READ, BY VAL):						    */*/ 	    /* Total number of source files.				    */f  ! )	/* No return value.						    */uG 	/*****************************************************************--*/:   {	6     fputs("<TABLE_ROW>(<SPAN>(8)<RULE>)\n", aRptFile);K     fprintf(aRptFile, "<TABLE_ROW>(<EMPHASIS>(TOTAL: %ld files\\BOLD)\\\n",  	vTotalFiles);>     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\n", 	total_lines());>     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\n",# 	total_comments() + total_mixed());*>     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\n",% 	total_statements() + total_mixed());e>     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\n", 	total_routines());l>     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\n", 	total_rlength());>     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD)\\\n", 	total_avglen());	=     fprintf(aRptFile, "            <EMPHASIS>(%ld\\BOLD))\n",. 	total_calls());$     fputs("<ENDTABLE>\n", aRptFile); }A  N /*************************************************************************++*/ void rpt_source_sdml_hdr(/H /* Writes SDML-formatted report header for annotated source file.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */	       SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */       int	    vFirst,*# 	    /* (READ, BY VAL):						    */*< 	    /* Flag indicating whether this is first table.		    */       int	    vLasti# 	    /* (READ, BY VAL):						    */a; 	    /* Flag indicating whether this is last table.		    */,     ! )	/* No return value.						    */ G 	/*****************************************************************--*/F   {*7     REFERENCE				    /* Current routine reference.   */*
 	    *curref;l       mLastValidBreak = 0;>     fprintf(aRptFile, "<DEFINE_SYMBOL>(source_%d_name\\%s)\n",4 	source_seq(aSourceFile), source_name(aSourceFile));E     fprintf(aRptFile, "<FIGURE>(%s Source Code\\source_%d_figure)\n", 4 	source_name(aSourceFile), source_seq(aSourceFile));>     fputs("<FIGURE_ATTRIBUTES>(MULTIPAGE\\WIDE)\n", aRptFile);*     fputs("<LINE_ART>(WIDE)\n", aRptFile);@     fputs("ROUTINES IN THIS FILE (Alphabetical)\n\n", aRptFile);,     if (source_routines(aSourceFile) == 0) { 	fputs("   None.\n", aRptFile);a     }"
     else {- 	fputs(" Line Name\n----- ----\n", aRptFile);e7 	for (curref = list_first(source_reflist(aSourceFile));& 	    curref != NULL;# 	    curref = next_entry(curref)) {n" 	    fprintf(aRptFile, "%5d %s\n",$ 		def_begin(ref_definition(curref)),$ 		def_name(ref_definition(curref))); 	}     }n     /     fputs("\nBEGINNING OF FILE\n\n", aRptFile);e }   N /*************************************************************************++*/ void rpt_source_sdml_entry( D /* Writes SDML-formatted entry for an annotated source line.		    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       DEFINITION 	    *aDef,d$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */       char    *aSrcLine,$ 	    /* (READ, BY ADDR):						    */, 	    /* Source file line contents.				    */       int	    vLine,# 	    /* (READ, BY VAL):						    */ + 	    /* Source file line number.					    */n          int	    vTabSize# 	    /* (READ, BY VAL):						    */*( 	    /* Source text tab size.					    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/p   {)8     DEFINITION				    /* Next definition in file.	    */ 	    *nextdef;3     int	    column;			    /* Output column.		    */+9     int	    count;			    /* Tab expansion counter.	    */p 	    d3     if (aDef != NULL && def_begin(aDef) == vLine) {E$ 	fputs("<VALID_BREAK>\n", aRptFile); 	mLastValidBreak = vLine;o> 	fprintf(aRptFile, "\nBEGIN ROUTINE %s.\n\n", def_name(aDef));     } &     fprintf(aRptFile, "%6d: ", vLine);+ 					    /* Expand tabs on output since  */r+ 					    /* SDML treats TAB as a space.  */	5     for (column = 0; *aSrcLine != '\0'; aSrcLine++) {* 	if (*aSrcLine == '\t') {*/ 	    for (count = vTabSize - column % vTabSize;n 		count > 0; 		count--, column++) { 		fputc(' ', aRptFile);S 	    } 	} 	else if (*aSrcLine == '\f') {( 	    fputs("\n<VALID_BREAK>", aRptFile); 	    mLastValidBreak = vLine;i 	} 	else {g 	    switch (*aSrcLine) {n6 	    case '>': fputs("<LITERAL>(>)", aRptFile); break;6 	    case '<': fputs("<LITERAL>(<)", aRptFile); break;) 	    default: fputc(*aSrcLine, aRptFile);t 	    } 	    column++; 	}     }i1     if (aDef != NULL && def_end(aDef) == vLine) {A4 	fprintf(aRptFile, "\nEND %s.\n\n", def_name(aDef));     } 9     else if (vLine - mLastValidBreak > MAX_VALID_BREAK) { $ 	fputs("<VALID_BREAK>\n", aRptFile); 	mLastValidBreak = vLine;t     }e }t  N /*************************************************************************++*/ void rpt_source_sdml_end(*F /* Writes SDML-formatted report end for annotated source file.		    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       SOURCEFILE 	    *aSourceFile,$ 	    /* (READ, BY ADDR):						    */. 	    /* Source file entry to report.				    */          int	    vFirst,o# 	    /* (READ, BY VAL):						    */I< 	    /* Flag indicating whether this is first table.		    */       int	    vLast # 	    /* (READ, BY VAL):						    */ ; 	    /* Flag indicating whether this is last table.		    */	     ! )	/* No return value.						    */rG 	/*****************************************************************--*/*   {*)     fputs("\nEND OF FILE\n\n", aRptFile);*>     fprintf(aRptFile, "TOTAL: %ld routines, %ld Avg Length\n",; 	source_routines(aSourceFile), source_avglen(aSourceFile));%'     fputs("<ENDLINE_ART>\n", aRptFile);n'     fputs("<ENDFIGURE>\n\n", aRptFile);  }   