N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ 5 /*  MODULE:	Text Report Formatting Routines				    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This module contains the routines for generating Routine   */4 /*  Analyzer reports in plain text format.				    */ /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 24-AUG-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include <stdio.h> #include "ranalyzer.h"  N /*************************************************************************++*/ void rpt_defined_text_hdr(I /* Writes plain text formatted report header for defined routines.	    */        FILE    *aRptFile $ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { 7     fputs("Defined Routines Alphabetical\n", aRptFile); 7     fputs("-----------------------------\n", aRptFile); 
     fputs(N "Routine                   Defined In File      Line   Length Called Calls\n", 	aRptFile); 
     fputs(O "------------------------- -------------------- ------ ------ ------ ------\n",  	aRptFile);  }   N /*************************************************************************++*/ void rpt_defined_text_entry(J /* Writes plain text formatted routine entry for a defined routine.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { 8     fprintf(aRptFile, "%25s %20s %6ld %6ld %6ld %6ld\n",@ 	def_name(aDef), source_name(def_source(aDef)), def_begin(aDef),? 	def_length(aDef), def_num_calls(aDef), def_num_callers(aDef));  }   N /*************************************************************************++*/ void rpt_defined_text_end(G /* Writes plain text formatted report end for defined routines.		    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        long    vTotalDef # 	    /* (READ, BY VAL):						    */ 2 	    /* Total number of defined routines.			    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      fputs("\n", aRptFile);     fprintf(aRptFile, C 	"TOTAL ROUTINES: %6ld   TOTAL DEF LINES: %6ld AVG LENGTH: %6ld\n", - 	vTotalDef, total_rlength(), total_avglen());  }   N /*************************************************************************++*/ void rpt_undefined_text_hdr(K /* Writes plain text formatted report header for undefined routines.	    */        FILE    *aRptFile $ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { 9     fputs("Undefined Routines Alphabetical\n", aRptFile); 9     fputs("-------------------------------\n", aRptFile); :     fputs("Routine                   Called\n", aRptFile);:     fputs("------------------------- ------\n", aRptFile); }   N /*************************************************************************++*/ void rpt_undefined_text_entry(L /* Writes plain text formatted routine entry for a undefined routine.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { L     fprintf(aRptFile, "%25s %6ld\n", def_name(aDef), def_num_callers(aDef)); }   N /*************************************************************************++*/ void rpt_undefined_text_end(H /* Writes plain text formatted report end for undefined routines.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        long    vTotalUndef # 	    /* (READ, BY VAL):						    */ 4 	    /* Total number of undefined routines.			    */  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      fputs("\n", aRptFile);=     fprintf(aRptFile, "TOTAL ROUTINES: %6ld\n", vTotalUndef);  }   N /*************************************************************************++*/ void rpt_calls_text_hdr(G /* Writes plain text formatted report header for defined routine	    */ $ /* calls/callers table.							    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    { D     fprintf(aRptFile, "%s Calls/Caller Routines\n", def_name(aDef));2     fputs("------------------------\n", aRptFile);I     fputs("Calls Routine             Line   Caller Routine       Line\n",  	aRptFile); K     fputs("------------------------- ------ -------------------- ------\n",  	aRptFile);  }   N /*************************************************************************++*/ void rpt_calls_text_entry(I /* Writes plain text formatted routine entry for a defined routine	    */ # /* calls/caller entry.							    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   
     REFERENCE  	    *aCalled,$ 	    /* (READ, BY ADDR):						    */G 	    /* Called routine reference entry to report. If NULL is passed, */ 2 	    /* only a caller is being reported.				    */     
     REFERENCE 
 	    *aCaller $ 	    /* (READ, BY ADDR):						    */G 	    /* Caller routine reference entry to report. If NULL is passed, */ 9 	    /* only a called routine is being reported.			    */      ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      if (aCalled == NULL) {* 	fprintf(aRptFile, "%25c %6c ", ' ', ' ');     } 
     else {C 	fprintf(aRptFile, "%25s %6ld ", def_name(ref_definition(aCalled)),  	    ref_offset(aCalled));     }      if (aCaller == NULL) { 	fprintf(aRptFile, "\n");      } 
     else {@ 	fprintf(aRptFile, "%25s %6ld\n", def_name(ref_caller(aCaller)), 	    ref_offset(aCaller));     }  }   N /*************************************************************************++*/ void rpt_calls_text_end(N /* Writes plain text formatted report end for defined routine calls/caller  */ /* table.								    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */        DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {      fputs("\n", aRptFile);F     fprintf(aRptFile, "TOTAL CALLS: %6ld      ", def_num_calls(aDef));H     fprintf(aRptFile, "TOTAL CALLERS: %6ld\n\n", def_num_callers(aDef)); }   N /*************************************************************************++*/ void rpt_xref_text_hdr( H /* Writes plain text-formatted report header for cross reference.	    */       FILE    *aRptFile*$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */A  ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {	0     fputs("Caller Cross-Reference\n", aRptFile);0     fputs("----------------------\n", aRptFile);=     fputs("Routine                     Callers\n", aRptFile); M     fputs("--------------------------- -----------------------\n", aRptFile);/ }*  N /*************************************************************************++*/ void rpt_xref_text_entry(*M /* Writes plain text-formatted cross-reference sections for a routine.	    */        FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */_G 	/*****************************************************************--*/    { 2     REFERENCE				    /* Current caller ref.	    */
 	    *caller; ( 					    /* Write section header.	    */C     fprintf(aRptFile, "%25s  Total callers: %ld\n", def_name(aDef),* 	def_num_callers(aDef));  + 					    /* Write entry for each caller. */p0     for (caller = list_first(def_callers(aDef)); 	caller != NULL; 	caller = next_entry(caller)) {FC 	fprintf(aRptFile, "%25c %s\n", ' ', def_name(ref_caller(caller)));i     }n }   N /*************************************************************************++*/ void rpt_xref_text_end(-L /* Writes plain text-formatted report end for caller cross-reference.	    */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */d       long    vTotalDefI# 	    /* (READ, BY VAL):						    */D+ 	    /* Total number of routines.				    */   ! )	/* No return value.						    */ G 	/*****************************************************************--*/    {n<     fprintf(aRptFile, "\nTOTAL ROUTINES: %ld\n", vTotalDef); }e  N /*************************************************************************++*/ void rpt_tree_text_hdr((N /* Writes plain text formatted report header for defined routine call tree. */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */*       DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/o   { =     fprintf(aRptFile, "%25s - Call Tree\n", def_ident(aDef));e=     fprintf(aRptFile, "%25c - %25c - ---------\n", '-', '-');o }e  N /*************************************************************************++*/ void rpt_tree_text_entry(*K /* Writes plain text formatted call tree line for a defined routine.	    */t       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */   
     REFERENCE* 	    *aRef,*$ 	    /* (READ, BY ADDR):						    */F 	    /* Reference to routine definition entry to report.       	    */       int	    vLevel,d# 	    /* (READ, BY VAL):						    */ 9 	    /* Nesting level, used to space indentation.		    */        int	    vExpanded,# 	    /* (READ, BY VAL):						    */NF 	    /* Flag indicating whether or not routine has already been	    */- 	    /* expanded in this call tree.				    */(       int	    vRecursive# 	    /* (READ, BY VAL):						    */-@ 	    /* Flag indicating whether or not routine is called		    */  	    /* recursively.						    */  ! )	/* No return value.						    */-G 	/*****************************************************************--*/*   {*6     int	    lcount;			    /* Level print count.	    */  1     for (lcount = vLevel; lcount > 1; lcount--) {y 	fputs("|   ", aRptFile);      }      if (lcount > 0) {  	if (isend_of_list(aRef)) {	 	    fputs("+   ", aRptFile);i 	} 	else {p 	    fputs("|   ", aRptFile);  	}     }      if (vLevel == 0) {H 	fprintf(aRptFile, "%s: %ld caller%s\n", def_name(ref_definition(aRef)),+ 	    def_num_callers(ref_definition(aRef)), > 	    (def_num_callers(ref_definition(aRef)) == 1 ? "" : "s"));     }*
     else {B 	fprintf(aRptFile, "%s%s%s%s%s\n", def_name(ref_definition(aRef)),) 	    (needs_tree(ref_definition(aRef)) &&*0 		!tree_inline_disabled() ? " (Separate)" : ""),' 	    (vExpanded ? " (Duplicate)" : ""),l( 	    (vRecursive ? " (Recursive)" : ""),E 	    (isdefined_routine(ref_definition(aRef)) ? "" : " (External)"));	     }  }   N /*************************************************************************++*/ void rpt_tree_text_end(BN /* Writes plain text formatted section end for defined routine call tree.   */       FILE    *aRptFile,$ 	    /* (READ, BY ADDR):						    */= 	    /* Report output file. Must be opened by caller.		    */"       DEFINITION
 	    *aDef$ 	    /* (READ, BY ADDR):						    */4 	    /* Routine definition entry to report.			    */     ! )	/* No return value.						    */ G 	/*****************************************************************--*/r   {n%     fputs("END OF TREE\n", aRptFile);b }	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        