N /****************************************************************************/ /*									    */ ) /*  FACILITY:	Routine Analyzer					    */  /*									    */ - /*  MODULE:	Text Language "Parser"					    */  /*									    */ G /*  AUTHOR:	Steve Branam, Network Product Support Group, Digital	    */ 6 /*		Equipment Corporation, Littleton, MA, USA.		    */ /*									    */ N /*  DESCRIPTION: This module contains the dummy "parser" for text files. No */N /*  actual parsing is done, since there is no language structure, but the   */8 /*  normal source file management takes place.				    */ /*									    */ " /*  REVISION HISTORY:							    */ /*									    */ / /*  V0.1-00 27-SEP-1994 Steve Branam					    */  /*									    */   /*	Original version.						    */ /*									    */ N /****************************************************************************/   #include <stdio.h> #include <ctype.h> #include "ranalyzer.h" #include "parser.h"   N /*************************************************************************++*/ language_element text_parser( N /* "Parses" text source language statements. This is just a dummy parser,   */5 /* it does not recognize any actual syntax.				    */        FILE    *aSourceFile,   		/* (READ, BY ADDR):					    */@ 		/* Source file containing text. Must be opened by caller.   */       SOURCEFILE 	    *aSourceRecord,  		/* (READ, BY ADDR):					    */- 		/* Source file information record.			    */        char    *aElement,! 		/* (WRITE, BY ADDR):					    */ @ 		/* String buffer that will receive the recognized source    */! 		/* language element.					    */        long    *aSourceLine! 		/* (WRITE, BY ADDR):					    */ @ 		/* Buffer that will receive the line number of aElement.    */  F )	/* Returns one of the following values indicating the type of	    */* 	/* element output in aElement:					    */C 	/*      PARSE_ERROR	    - An error was detected in the input    */  	/*			      stream.				    */ @ 	/*	END_OF_SOURCE	    - The normal end of file was found.	    */G 	/*****************************************************************--*/    { 2     int	    ch;				    /* Input character.		    */       do { 	ch = fgetc(aSourceFile);  	list_char(ch);  	if (ch == '\n') {* 	    inc_source_statements(aSourceRecord);" 	    new_list_line(aSourceRecord); 	}     } while (ch != EOF);     return END_OF_SOURCE;  }   