I {************************************************************************  *									* H *  SD  =  Set Default.	A program to set the default disk and directory *G *  of a process.  SD also optionally may update the session prompt of	* E *  an interactive session to reflect the current default directory.	*  *									* H *  SD is stack-based, storing as many past directories as one requires	*B *  in one of two styles for recall.  Flexible options allow easy	*& *  configuration of the program.					* *									* ; *  See the DCL help file for details of command syntax. 		*  *									* B *  The program must be installed with SYSNAM privilege to allow 	*1 *  supervisor mode logical name definitions.				*  *									* I *.......................................................................* # *  Author:  Jonathan Ridler.						* + *	    Information Technology Services,				* ' *	    The University of Melbourne.				* + *	    E-mail:  jonathan@unimelb.edu.au				* I *.......................................................................*  *  History:								*' *	29-Nov-1994	JER	Original version.			* 6 *	05-Dec-1994	JER	Allow Help subtopic specification.	*- *	13-Feb-1995	JER	Cope with parser errors.		* ; *	23-Feb-1995	JER	Correct problem with Swap_With_Current. * 8 *	01-Mar-1995	JER	Fix handling underscore in diskname.	*7 *	09-Aug-1995	JER	Fix minor bug in Swap_With_Current.	* 9 *	27-Sep-1995	JER	Recognise and flag as unsupported the	* $ *				use of a node access string.		*1 *	27-Nov-1995	JER	Minor fix to character sets.		* 9 *	18-Jan-1996	JER	Handle empty directory as first entry	* ! *				logical name search list.		* - *	20-Feb-1996	JER	Implement Quiet option. 		* 9 *	11-Mar-1996	JER	Add shortcut operator ("`") for going	*  *				up directory tree.			* : *	13-Mar-1996	JER	Fix unnecessary msgs from first parse.	*; *	08-Jul-1996	JER	Handle empty wildcarded directory specs *  *				more neatly.				*; *	28-Aug-1996	JER	Eliminate version numbers from dirspec. * 7 *	16-Jan-1997	JER	Ensure dynamic stack re-size fails;	* # *				Implement 'G' (Get) option.		* > * v3.0	30-Jul-1998	JER	Prevent multiple sequential pushes of	*) *				the same directory onto the stack.	* I ************************************************************************}   ! [ INHERIT ('SYS$LIBRARY:STARLET', & 	   'SYS$LIBRARY:PASCAL$LIB_ROUTINES',& 	   'SYS$LIBRARY:PASCAL$LBR_ROUTINES',( 	   'SYS$LIBRARY:PASCAL$MTH_ROUTINES') ]  # PROGRAM Set_Default (OUTPUT,Data) ;    TYPE  D { Define stack style types: Absolute == Fixed; Relative == Sliding }  2 Stack_Type   = (Absolute,Fixed,Relative,Sliding) ;   Prompt_Style = (Centre,Left) ;   CONST    Null = ''(0) ;   Default_Stack_Size = 20 ; 5 Max_Stack_Size = 200 ;			{ Set Max_Digs accordingly } . Max_Digs = 3 ;				{ Digits in Max_Stack_Size } Initial_Tos = -9999 ;    Digits = ['0'..'9'] ;   ; Max_Prompt_Size     = 32 ;		{ Limit in DCL (OpenVMS v6.2) } ' Default_Prompt_Size = Max_Prompt_Size ;  Default_Head   = Null ;  Default_Tail   = ' ' ;  < Empty_Stack_Msg = '%SD-I-EMPTY, Directory stack is empty.' ;   TYPE   $UBYTE = [BYTE] 0..255 ;   $UWORD = [WORD] 0..65535 ;  < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;    VAR   / Quiet , 				{ Display new default directory ? } & Undo ,					{ Undo expansion errors ? }% Expanding ,				{ Expanding a spec ? } / Phantom_Dir ,				{ Directory does not exist ? } + Phantom_File ,				{ File does not exist ? } H Update_Prompt : BOOLEAN := FALSE ;	{ Make prompt reflect current dir ? }  ; Stack_Fixed : BOOLEAN := TRUE ; 	{ Stack style is FIXED ? }   ) Poppy , 				{ Stack slot number for Pop } . Poppy2 ,				{ Stack slot number for Pop too! }' Table , 				{ Symbol definition table }  Tos ,					{ Top-Of-Stack } Bos ,					{ Bottom-Of-Stack } + Tos_Vs ,				{ Top-Of-Stack	  Virtual slot } , Bos_Vs ,				{ Bottom-Of-Stack Virtual slot } Depth , 				{ Stack depth } I Max_Prompt_Size_User : INTEGER := 0 ;	{ Maximum prompt size set by user }   F Stack_Size : INTEGER := Default_Stack_Size ;	{ Number of stack slots }  G Stack_Style : Stack_Type := Absolute ;		{ Stack slot numbering scheme }   5 Tos_Str ,				  { Top-Of-Stack    number as a string } 5 Bos_Str ,				  { Bottom-Of-Stack number as a string } 7 Depth_Str ,				  { Depth-Of-Stack  number as a string } , Str_Poppy ,				  { Slot number as a string }J Str_Poppy2 : VARYING [4] OF CHAR := '' ;  { Slot number as a string too! }  D Prompt_Format : Prompt_Style ;		{ Where to squeeze prompt overflow }  % Prompt_Head ,					{ Start of prompt } < Prompt_Tail : VARYING [12] OF CHAR := '' ;	{ End	of prompt }  ' Symbol ,				{ Scratch symbol register } - Symbol2 ,				{ Scratch symbol register too! } 5 Search_Result , 			{ Filename returned from $SEARCH } ) Target_Dir ,				{ NEW default directory } & Default_Dir ,				{ Default directory }& Current_Dir ,				{ Current directory }# Cmd ,					{ Collapsed  input line } A Command : VARYING [255] OF CHAR := '' ; { Compressed input line }   5 Data : TEXT ;				{ File of directory specifications }     % [ASYNCHRONOUS] FUNCTION SYS$SETDDIR (  	New_Dir_Addr : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 2 	VAR Length_Addr : [VOLATILE] $UWORD := %IMMED 0 ; 	%STDESCR Cur_Dir_Addr :7 		PACKED ARRAY [$L3..$U3:INTEGER] OF CHAR := %IMMED 0 )  		: UNSIGNED ; EXTERNAL ;     P FUNCTION  Str_Compress (Source : [CLASS_S] PACKED ARRAY [L..U:INTEGER] OF CHAR ;$ 			VAR  Dest : VARYING [D] OF CHAR ;, 			Collapse : BOOLEAN := FALSE) : UNSIGNED ;  L { Compress a string by removing leading and trailing white space (blanks andL   tabs), and replacing multiple consecutive white space with a single blank./   If collapse is set, remove ALL white space. }   %   CONST  Blanks = [' ',''(9),''(0)] ;  	 Maxsize = 1024 ;F 	 Warn_Inpstrtru = UAND (LIB$_INPSTRTRU,%Xfffffff8) ;	{ Warning only }  !   VAR  S , J , K : INTEGER := 0 ;          Done : BOOLEAN := FALSE ;,        Spacer : VARYING [1] OF CHAR := ' ' ;5        Dstr, Sstr : VARYING [Maxsize] OF CHAR := '' ;      BEGIN 	{ Str_Compress } .   Str_Compress := SS$_NORMAL ;		{ Presume so }   S := LENGTH (Source) ;  %   IF S = 0  THEN			{ Nothing passed }       Dest := ''     ELSE 
      BEGIN      IF S > Maxsize  THEN  	BEGIN$ 	Sstr := SUBSTR (Source,1,Maxsize) ;& 	Str_Compress := INT(Warn_Inpstrtru) ; 	END
       ELSE 	Sstr := Source ;   %      IF Collapse  THEN	Spacer := '' ;   D      IF FIND_MEMBER (Source,Blanks) = 0  THEN		{ Nothing to change }
 	Dstr := Sstr 
       ELSE 	WHILE NOT Done	DO 	  BEGIN& 	  J := FIND_NONMEMBER (Sstr,Blanks) ; 	  IF J = 0  THEN  	     Done := TRUE 	   ELSE 	     BEGIN / 	     Sstr := SUBSTR (Sstr,J,Sstr.LENGTH-J+1) ; & 	     K := FIND_MEMBER (Sstr,Blanks) ; 	     IF K = 0  THEN 		BEGIN  		Dstr := Dstr + Sstr ;  		Done := TRUE ; 		END  	      ELSE  		BEGIN / 		Dstr := Dstr + SUBSTR (Sstr,1,K-1) + Spacer ; + 		Sstr := SUBSTR (Sstr,K,Sstr.LENGTH-K+1) ;  		END ;  	     END ;  	  END ; 	{ of While }        IF Dstr <> ''  THEN! 	IF Dstr[Dstr.LENGTH] = ' '  THEN * 	   Dstr:= SUBSTR (Dstr,1,Dstr.LENGTH-1) ;        IF Dstr.LENGTH <= D  THEN
 	Dest := Dstr 
       ELSE 	BEGIN 	Dest := SUBSTR (Dstr,1,D) ;! 	Str_Compress := LIB$_OUTSTRTRU ;  	END ;
      END ;   END ; 	{ of Str_Compress }     FUNCTION Get_Logical_Name ( < 		Lognam	: [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;# 		Default : VARYING [Sz1] OF CHAR ; & 		VAR Actual : VARYING [Sz2] OF CHAR ;< 		Table	: [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR := 				'LNM$FILE_DEV' ; 		Mode	: $UBYTE := PSL$C_USER ;  		Lnm_Index  : UNSIGNED := 0 		) : UNSIGNED ;  K { Get the translation of the logical name specified.  If it does not exist, M   use the default value if the index is zero, or flag a non-existant index. }      VAR Rst : UNSIGNED := 0 ; %       Attributes : LNM$TYPE := ZERO ; 3       Item_List  : Item_List_Template (4) := ZERO ;   "   BEGIN       { Get_Logical_Name }#   Item_List[1].Buffer_Length := 4 ; ,   Item_List[1].Item_Code     := LNM$_INDEX ;6   Item_List[1].Buffer_Addr   := IADDRESS (Lnm_Index) ;#   Item_List[1].Return_Addr   := 0 ;   3   Item_List[2].Buffer_Length := SIZE (Attributes) ; 1   Item_List[2].Item_Code     := LNM$_ATTRIBUTES ; 7   Item_List[2].Buffer_Addr   := IADDRESS (Attributes) ; #   Item_List[2].Return_Addr   := 0 ;   4   Item_List[3].Buffer_Length := SIZE (Actual.BODY) ;-   Item_List[3].Item_Code     := LNM$_STRING ; 8   Item_List[3].Buffer_Addr   := IADDRESS (Actual.BODY) ;:   Item_List[3].Return_Addr   := IADDRESS (Actual.LENGTH) ;  A   Item_List[4].Terminator    := 0 ;   { Terminate the item list }   1   Rst := $TRNLNM (Attr	 := %REF LNM$M_CASE_BLIND,  		  Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := %REF Mode, 		  Itmlst := Item_List) ;   Get_Logical_Name := Rst ;      IF Rst = SS$_NOLOGNAM  THEN       Actual := Default    ELSE C   IF (Rst = SS$_NORMAL) AND_THEN (NOT Attributes.LNM$V_EXISTS)	THEN P      Get_Logical_Name := SS$_VALNOTVALID       { Index not found - tell caller }    ELSE H   IF Rst = SS$_BUFFEROVF  THEN		     { Do nothing - caller must handle }    ELSE    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; %   END ;       { of Get_Logical_Name }      PROCEDURE Set_Logical_Name (< 		Lognam : [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;< 		Xlate  : [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR ;= 		Table  : [CLASS_S] PACKED ARRAY [L3..U3:INTEGER] OF CHAR :=  				'LNM$FILE_DEV' ;  		Mode   : $UBYTE := PSL$C_SUPER 		) ;   K { Define the logical name specified.  BEWARE!  SYSNAM privilege is REQUIRED #   for supervisor mode or greater. }      VAR Rst : UNSIGNED := 0 ; 2       Item_List : Item_List_Template (2) := ZERO ;  "   BEGIN       { Set_Logical_Name }$   Item_List[1].Buffer_Length := U2 ;-   Item_List[1].Item_Code     := LNM$_STRING ; 2   Item_List[1].Buffer_Addr   := IADDRESS (Xlate) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Terminator    := 0 ;   "   Rst := $CRELNM (Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := Mode,  		  Itmlst := Item_List) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; %   END ;       { of Set_Logical_Name }      PROCEDURE Get_Command ;   ' { Get the foreign command input line. }      VAR	Rst : UNSIGNED := 0 ;      BEGIN 	{ Get_Command }+   Rst := LIB$GET_FOREIGN (%DESCR Command) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;      { Compress it. }  /   Rst := Str_Compress (Command,Command,FALSE) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;      { One is both the same. }   ;   IF (Command.LENGTH > 0) AND_THEN (Command[1] = '/')  THEN       Command[1] := '\' ;     { ... and collapse it. }  *   Rst := Str_Compress (Command,Cmd,TRUE) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Get_Command }     . PROCEDURE Exit (Msg : VARYING [Len] OF CHAR) ;  # { Just a dinky shorthand routine. }      BEGIN 	{ Exit }    WRITELN (Msg) ; 	   $EXIT ;    END ; 	{ of Exit }    8 PROCEDURE Change_Prompt (BODY	 : VARYING [Len] OF CHAR ;! 			 Literal : BOOLEAN := FALSE) ;   M { Modify the session prompt.  Using LIB$DO_COMMAND to do this means that this M   routine terminates the program.  It must therefore be the last thing called ,   before the desired end of program logic. }     VAR	Rst : UNSIGNED := 0 ; & 	Max_Avail , Max_Div2 : INTEGER := 0 ;3 	Prompt : VARYING [Max_Prompt_Size] OF CHAR := '' ;      BEGIN 	{ Change_Prompt }   IF Prompt_Head = Null  THEN       Prompt_Head := '' ;O   Max_Avail := Max_Prompt_Size_User - Prompt_Head.LENGTH - Prompt_Tail.LENGTH ; &   Max_Div2  := (Max_Avail - 1) DIV 2 ;   IF Literal  THEN+      IF BODY.LENGTH > Max_Prompt_Size  THEN I 	Exit ('%SD-F-INTERROR, Bad prompt literal - notify Systems Programmer.') 
       ELSE 	Prompt := BODY     ELSE #   IF BODY.LENGTH <= Max_Avail  THEN /      Prompt := Prompt_Head + BODY + Prompt_Tail     ELSE !   IF Prompt_Format = Centre  THEN =      Prompt := Prompt_Head + SUBSTR (BODY,1,Max_Div2) + '*' + C 	       SUBSTR (BODY,BODY.LENGTH-Max_Div2+1,Max_Div2) + Prompt_Tail     ELSE    IF Prompt_Format = Left  THEN 
      BEGIN       Max_Avail := Max_Div2 * 2 ;"      Prompt := Prompt_Head + '*' +G 	       SUBSTR (BODY,BODY.LENGTH-Max_Avail+1,Max_Avail) + Prompt_Tail ; 
      END ;  N   Rst := LIB$DO_COMMAND ('$ SET PROMPT = "' + Prompt + '"') ;	{ Black Hole!! }   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Change_Prompt }     : PROCEDURE Set_New_Default (Dir	  : VARYING [Len] OF CHAR ;! 			   Notify : BOOLEAN := TRUE) ;   3 { Set new default directory and new default disk. }      VAR	Rst : UNSIGNED := 0 ;  	Colon : INTEGER := 0 ; ( 	Def_Dev : VARYING  [32] OF CHAR := '' ;( 	Def_Dir : VARYING [255] OF CHAR := '' ;     BEGIN 	{ Set_New_Default }   Colon := INDEX (Dir,':') ;   IF Colon = 0	THEN ?      Exit ('%SD-F-BADDIR, Directory specification is corrupt.')     ELSE 
      BEGIN?      IF Dir [Colon+1] = ":"  THEN	{ Double colon -> node name } C 	Exit ('%SD-F-NONODE, Node name specification is not supported.') ; &      Def_Dev := SUBSTR (Dir,1,Colon) ;7      Def_Dir := SUBSTR (Dir,Colon+1,Dir.LENGTH-Colon) ; 
      END ;  ?   Rst := SYS$SETDDIR (SUBSTR (Def_Dir.BODY,1,Def_Dir.LENGTH)) ;    IF NOT ODD (Rst)  THEN
      BEGIN*      IF Undo AND (Current_Dir <> '')  THEN3 	Set_New_Default (Current_Dir,FALSE) ;	{ Recurse! }       LIB$SIGNAL (Rst) ; 
      END ;  )   Set_Logical_Name ('SYS$DISK',Def_Dev) ;      IF Notify  THEN 
      BEGIN4      IF NOT Quiet  THEN  WRITELN (Def_Dev,Def_Dir) ;      IF Phantom_Dir  THEN 5 	WRITELN ('%SD-W-NODIR, Directory does not exist.') ; 
      END ;   END ; 	{ of Set_New_Default }     A PROCEDURE Parse_Filename (File_Spec    : VARYING [Len1] OF CHAR ; 7 			  Default_Spec : VARYING [Len2] OF CHAR := '[]*.*' ; ' 			  First_Parse  : BOOLEAN := FALSE) ;   1 { Perform basic RMS file specification parsing. }      VAR	Rst : UNSIGNED := 0 ; : 	Saved_Length ,			{ Length of useful saved $PARSE result }= 	Zap : INTEGER  := 0 ;		{ Offset for underscore in diskname } / 	Fab : FAB$TYPE := ZERO ;	{ File Access Block } - 	Nam : NAM$TYPE := ZERO ;	{ File Name Block } . 	Wild_Dir ,			{ Wildcard in directory spec ? }; 	Use_Saved : BOOLEAN := FALSE ;	{ Ignore $SEARCH result ? }  	Parse_Result , - 	Saved_Result : VARYING [255] OF CHAR := '' ;      BEGIN 	{ Parse_Filename } 2   Fab.FAB$B_BID := FAB$C_BID ;				{ FAB Block ID }6   Fab.FAB$B_BLN := FAB$C_BLN ;				{ FAB Block Length }E   Fab.FAB$L_FNA := IADDRESS (File_Spec.BODY) ;		{ Primary File Spec } 3   Fab.FAB$B_FNS := Len1 ;				{ 1ry File Spec Size } G   Fab.FAB$L_DNA := IADDRESS (Default_Spec.BODY) ;	{ Default File Spec } 3   Fab.FAB$B_DNS := Len2 ;				{ Def File Spec Size } ;   Fab.FAB$L_NAM := IADDRESS (Nam) ;			{ NAM Block Address }   2   Nam.NAM$B_BID := NAM$C_BID ;				{ NAM Block ID }6   Nam.NAM$B_BLN := NAM$C_BLN ;				{ NAM Block Length }J   Nam.NAM$L_ESA := IADDRESS (Parse_Result.BODY) ;	{ Expanded String Area }G   Nam.NAM$B_ESS := SIZE (Parse_Result.BODY) ;		{ Max Expand Strng Syz } K   Nam.NAM$L_RSA := IADDRESS (Search_Result.BODY) ;	{ Resultant Strng Area } H   Nam.NAM$B_RSS := SIZE (Search_Result.BODY) ;		{ Max Result Strng Syz }     Rst := $PARSE (Fab) ; (   IF ODD (Rst) OR (Rst = RMS$_DNF)  THEN
      BEGIN+      Parse_Result.LENGTH := Nam.NAM$B_ESL ; #      Saved_Result := Parse_Result ; 4      Saved_Length := Nam.NAM$B_DEV + Nam.NAM$B_DIR ;%      Wild_Dir := Nam.NAM$V_WILD_DIR ;       IF Rst = RMS$_DNF	THEN  	Search_Result := Parse_Result
       ELSE 	BEGIN 	Rst := $SEARCH (Fab) ; 8 	IF ODD (Rst) OR (Rst = RMS$_FNF) OR (Rst = RMS$_DNF) OR 	   (Rst = RMS$_PRV)  THEN	 	   BEGIN   I 	   { With logical name search-lists which have an empty target directory E 	     in the first directory in the list, the parse succeeds, but the H 	     search fails with RMS$_DNF.  In this case, use the original resultF 	     from the $PARSE because the $SEARCH will change the Parse_Result 	     again. }   	   IF Rst = RMS$_DNF  THEN  	      BEGIN 	      Use_Saved := TRUE ;& 	      Search_Result := Saved_Result ;9 	      IF Wild_Dir AND Undo AND (Current_Dir <> '')  THEN	 		 BEGIN( 		 Set_New_Default (Current_Dir,FALSE) ; 		 LIB$SIGNAL (Rst) ;* 		 END 	       ELSE9 		 Rst := RMS$_NORMAL ;	{ Prevent flagging no directory } 
 	      END	 	    ELSEr* 	   IF (Rst = RMS$_FNF) AND Wild_Dir  THEN; 	      Exit ('%SD-F-EMPTYWILDDIR, Cannot determine name ' +o% 		    'of empty wildcard directory.')o	 	    ELSE . 	      Search_Result.LENGTH := Nam.NAM$B_RSL ;# 	   IF Search_Result[1] = '_'  THEN	 	      BEGINI 	      Search_Result := SUBSTR (Search_Result,2,Search_Result.LENGTH-1) ;e 	      Zap := 1 ;s 	      END ; 	   ENDi 	 ELSE	 	   BEGIN ( 	   IF Undo AND (Current_Dir <> '') THEN, 	      Set_New_Default (Current_Dir,FALSE) ; 	   LIB$SIGNAL (Rst) ;	 	   END ;. 	END ;"      Target_Dir := Search_Result ;      IF Use_Saved  THENo( 	Target_Dir.LENGTH := Saved_Length - Zap
       ELSE; 	Target_Dir.LENGTH := Nam.NAM$B_DEV + Nam.NAM$B_DIR - Zap ; ;      Phantom_Dir  := (Rst = RMS$_DNF) AND NOT First_Parse ;.6      Phantom_File := (Rst = RMS$_FNF) OR Phantom_Dir ;2      IF (Rst = RMS$_PRV) AND NOT First_Parse  THENE 	WRITELN ('%SD-E-NOPRIV, Insufficient privilege or file protection ',	 		 'violation on directory.') ;b      END    ELSEC
      BEGIN      Phantom_Dir := FALSE ;gP      IF Undo AND (Current_Dir <> '') THEN  Set_New_Default (Current_Dir,FALSE) ;      IF Rst = RMS$_DNR	THENs 	$EXIT (Rst)
       ELSE 	LIB$SIGNAL (Rst) ; 
      END ;   END ; 	{ of Parse_Filename }      PROCEDURE Zip (Rst : UNSIGNED) ;  ) { Another very dinky shorthand routine. }n     BEGIN 	{ Zip }   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    END ; 	{ of Zip }	    7 PROCEDURE Get_Symbol (Cymbal : VARYING [Len] OF CHAR) ;	  + { Get the symbol definition if it exists. }      VAR	Rst : UNSIGNED := 0 ;s     BEGIN 	{ Get_Symbol }d7   Rst := LIB$GET_SYMBOL (Cymbal,%DESCR Symbol,,Table) ;	   IF NOT ODD (Rst)	THENl"      IF Rst = LIB$_NOSUCHSYM  THEN7 	Exit ('%SD-F-BADSTACK, Directory stack is corrupted.')s
       ELSE 	LIB$SIGNAL (Rst) ;t   END ; 	{ of Get_Symbol }    ; PROCEDURE Set_Symbol (Cymbal_Nam : VARYING [Len1] OF CHAR ;t. 		      Cymbal_Val : VARYING [Len2] OF CHAR) ;   { Define the symbol globally. }*     VAR	Rst : UNSIGNED := 0 ;Y     BEGIN 	{ Set_Symbol }SF   Rst := LIB$SET_SYMBOL (Cymbal_Nam,Cymbal_Val,LIB$K_CLI_GLOBAL_SYM) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;A   END ; 	{ of Set_Symbol }    8 PROCEDURE Get_Number (Source  : VARYING [Len1] OF CHAR ; 		      VAR Num : INTEGER ;_+ 		      Msg     : VARYING [Len2] OF CHAR) ;   * { From a string variable, read a number. }     BEGIN 	{ Get_Number }t&   READV (Source,Num,Error:=CONTINUE) ;   IF STATUSV <> 0  THENn      Exit (Msg) ;3   END ; 	{ of Get_Number }    ' FUNCTION Rs (Vsn : INTEGER) : INTEGER ;0  P { The left hemisphere of the brain of the stack - return the real slot number of?   a given virtual slot number.	Take stack style into account. }l     BEGIN 	{ Rs }    IF Stack_Fixed  THEN'      Rs := (Vsn - 1) REM Stack_Size + 1Y    ELSEY(      Rs := Vsn + Bos - 1 - (Stack_Size *? 		   ((Vsn > (Stack_Size - Bos + 1)) AND (Depth > 0))::INTEGER)U   END ; 	{ of Rs }    ' FUNCTION Vs (Rsn : INTEGER) : INTEGER ;1  J { The right hemisphere of the brain of the stack - return the virtual slotG   number of a given real slot number.  Take stack style into account. };     BEGIN 	{ Vs }e   IF Stack_Fixed  THENO      Vs := Rsn + (Depth - ((Rsn >= Bos) AND (Tos < Bos))::INTEGER) * Stack_Size[    ELSE P      Vs := Rsn - Bos + 1 + (Stack_Size * ((Rsn < Bos) AND (Depth > 0))::INTEGER)   END ; 	{ of Vs }    2 PROCEDURE Zero_Stack (Notify : BOOLEAN := FALSE) ;   { Reset the stack completely. }e     VAR	Rst : UNSIGNED := 0 ;, 	I : INTEGER := 0 ;x$ 	Str_I : VARYING [4] OF CHAR := '' ;     BEGIN 	{ Zero_Stack }t   FOR I := 1 TO Stack_Size  DO       BEGINT*       Str_I := DEC (I,Max_Digs,Max_Digs) ;D       Rst := LIB$DELETE_SYMBOL ('SD__'+Str_I,LIB$K_CLI_GLOBAL_SYM) ;       IF NOT ODD (Rst)	THEN 4 	 IF Rst <> LIB$_NOSUCHSYM  THEN  LIB$SIGNAL (Rst) ;       END ;   ;   Zip (LIB$DELETE_SYMBOL ('SD__TS',LIB$K_CLI_GLOBAL_SYM)) ; ;   Zip (LIB$DELETE_SYMBOL ('SD__BS',LIB$K_CLI_GLOBAL_SYM)) ; ;   Zip (LIB$DELETE_SYMBOL ('SD__SD',LIB$K_CLI_GLOBAL_SYM)) ;u;   Zip (LIB$DELETE_SYMBOL ('SD__SZ',LIB$K_CLI_GLOBAL_SYM)) ;l  C   IF Notify  THEN  Exit ('%SD-S-ZEROED, Directory stack zeroed.') ;    END ; 	{ of Zero_Stack }     PROCEDURE Get_Prompt_Specs ;  F { Get the user's specifications for the prompt changes.  If we are not'   interactive, ignore update request. }{  !   VAR	Rst , Mode : INTEGER := 0 ; # 	Iosb : Status_Block_Type := ZERO ; - 	Item_List : Item_List_Template (2) := ZERO ;'     BEGIN 	{ Get_Prompt_Specs }!#   Item_List[1].Buffer_Length := 4 ;	'   Item_List[1].Item_Code	:= JPI$_MODE ;r/   Item_List[1].Buffer_Addr	:= IADDRESS (Mode) ; !   Item_List[1].Return_Addr	:= 0 ;d  <   Item_List[2].Terminator	:= 0 ;	{ Terminate the item list }  '   Rst := $GETJPIW (Itmlst := Item_List,e 		   Iosb   := Iosb) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSEi   IF NOT ODD (Iosb[1])	THEN{      LIB$SIGNAL (Iosb[1])n    ELSE	"   IF Mode = JPI$K_INTERACTIVE	THEN
      BEGIN        { Header to the prompt? }  3      Get_Logical_Name (Lognam  := 'SD_PROMPT_HEAD',:! 		       Default := Default_Head,i" 		       Actual  := Prompt_Head) ;  #      IF Prompt_Head.LENGTH > 8	THEN > 	Exit ('%SD-F-BADHEAD, Prompt head definition is too long.') ;        { Trailer to the prompt? }U  3      Get_Logical_Name (Lognam  := 'SD_PROMPT_TAIL',A! 		       Default := Default_Tail,%" 		       Actual  := Prompt_Tail) ;  #      IF Prompt_Tail.LENGTH > 6	THEN:? 	Exit ('%SD-F-BADTRAIL, Prompt tail definition is too long.') ;V  M      { The prompt can be squeezed in the centre or at the left - which one? }a  5      Get_Logical_Name (Lognam  := 'SD_PROMPT_FORMAT',n 		       Default := 'LEFT',g 		       Actual  := Symbol) ;c  3      READV (Symbol,Prompt_Format,Error:=CONTINUE) ;L      IF STATUSV <> 0  THEN? 	Exit ('%SD-F-BADFORM, Prompt format definition is invalid.') ;t  %      IF (Prompt_Format <> Centre) AND  	(Prompt_Format <> Left)   THENK? 	Exit ('%SD-F-INVFORM, Prompt format definition is invalid.') ;e  +      { Determine the maximum prompt size. }S  7      Get_Logical_Name (Lognam  := 'SD_MAX_PROMPT_SIZE',C. 		       Default := DEC (Default_Prompt_Size), 		       Actual  := Symbol) ;c  -      Get_Number (Symbol,Max_Prompt_Size_User, 7 		 '%SD-F-BADPSIZE, Maximum prompt size is invalid.') ; %      IF (Max_Prompt_Size_User < 2) OR,/ 	(Max_Prompt_Size_User > Max_Prompt_Size)  THEN); 	Exit ('%SD-F-INVPSIZE, Maximum prompt size is invalid.') ;       END    ELSE			{ Don't do it }M
      BEGINK      WRITELN ('%SD-W-NOTINTER, Not interactive - update prompt ignored.') ;E      Update_Prompt := FALSE ; 
      END ;    END ; 	{ of Get_Prompt_Specs }     PROCEDURE Initialize_Stack ;  O { Find and validate all logical name definitions and set appropriate variables;E4   check the stack state, possibly initializing it. }  +   VAR	Rst , Stack_Size_Sym : INTEGER := 0 ;N     BEGIN 	{ Initialize_Stack }r  /   { Size of stack, i.e. number of real slots. }:  /   Get_Logical_Name (Lognam  := 'SD_STACK_SIZE', * 		    Default := DEC (Default_Stack_Size), 		    Actual  := Symbol) ;      Get_Number (Symbol,Stack_Size,; 	      '%SD-F-BADSIZE, Directory stack size is invalid.') ; ;   IF (Stack_Size < 2) OR (Stack_Size > Max_Stack_Size)	THENt?      Exit ('%SD-F-INVSIZE, Directory stack size is invalid.') ;   :   { Ensure consistency of stack size across invocations. }  P   Rst := LIB$GET_SYMBOL ('SD__SZ',%DESCR Symbol,,Table) ;     { Size last time }   IF NOT ODD (Rst)  THEN;      IF Rst = LIB$_NOSUCHSYM  THEN			      { Zeroed stack }R9 	Set_Symbol ('SD__SZ',DEC (Stack_Size,Max_Digs,Max_Digs))e
       ELSE 	LIB$SIGNAL (Rst)n    ELSE:
      BEGIN'      Get_Number (Symbol,Stack_Size_Sym,t> 		 '%SD-F-BADSYMSIZ, Directory stack pointer is corrupted.') ;*      IF Stack_Size_Sym <> Stack_Size  THEN 	BEGIN  - 	{ Warning required - ignore invalid value. }   I 	WRITELN ('%SD-E-NODYNSIZE, Dynamic re-sizing of stack not supported.') ;mE 	WRITELN ('%SD-I-STACKSIZE, Current stack size is ',Stack_Size_Sym:1,[ 		 ' slots.') ;:9 	Stack_Size := Stack_Size_Sym ;		{ Use valid value only }m 	END ;
      END ;     { Determine stack style. }  0   Get_Logical_Name (Lognam  := 'SD_STACK_STYLE', 		    Default := 'ABSOLUTE', 		    Actual  := Symbol) ;  .   READV (Symbol,Stack_Style,Error:=CONTINUE) ;   IF STATUSV <> 0  THEN(A      Exit ('%SD-F-BADSTYLE, Directory stack style is invalid.') ;[D   Stack_Fixed := (Stack_Style = Absolute) OR (Stack_Style = Fixed) ;  O   { Determine if we must undo changes to default disk and directory if an errorm3     occurs during expansion of the specification. }   2   Get_Logical_Name (Lognam  := 'SD_UNDO_IF_ERROR', 		    Default := 'TRUE', 		    Actual  := Symbol) ;  '   READV (Symbol,Undo,Error:=CONTINUE) ;o   IF STATUSV <> 0  THENoG      Exit ('%SD-F-BADLNM, Logical name is invalid: SD_UNDO_IF_ERROR') ;   ,   { Change and keep the prompt up-to-date? }  2   Get_Logical_Name (Lognam  := 'SD_UPDATE_PROMPT', 		    Default := 'FALSE',T 		    Actual  := Symbol) ;  0   READV (Symbol,Update_Prompt,Error:=CONTINUE) ;   IF STATUSV <> 0  THENFG      Exit ('%SD-F-BADLNM, Logical name is invalid: SD_UPDATE_PROMPT') ;E     IF Update_Prompt  THEN      Get_Prompt_Specs ;   N   { Determine if new directory names are to be displayed - the Quiet option? }  *   Get_Logical_Name (Lognam  := 'SD_QUIET', 		    Default := 'FALSE',S 		    Actual  := Symbol) ;  (   READV (Symbol,Quiet,Error:=CONTINUE) ;   IF STATUSV <> 0  THENO?      Exit ('%SD-F-BADLNM, Logical name is invalid: SD_QUIET') ;R  J   { Check the state of the stack - start with Top-Of-Stack.  If TOS is not8     defined, assume the stack needs to be initialized. }  9   Rst := LIB$GET_SYMBOL ('SD__TS',%DESCR Symbol,,Table) ;(   IF NOT ODD (Rst)  THEN"      IF Rst = LIB$_NOSUCHSYM  THEN 	Symbol := DEC (Initial_Tos)
       ELSE 	LIB$SIGNAL (Rst)N    ELSE (   IF Table <> LIB$K_CLI_GLOBAL_SYM  THENE      Exit ('%SD-F-BADTABLE, Directory stack symbol is not global.') ;r     Get_Number (Symbol,Tos,=? 	      '%SD-F-BADTOS, Directory stack pointer is corrupted.') ;      IF Tos = Initial_Tos	THEN)
      BEGIN      Tos := 0 ;       Tos_Str := '0' ;       END    ELSEf*   IF (Tos < 1) OR (Tos > Stack_Size)  THEN?      Exit ('%SD-F-INVTOS, Directory stack pointer is invalid.')     ELSE:
      BEGIN-      Tos_Str := DEC (Tos,Max_Digs,Max_Digs) ;N  (      Get_Symbol ('SD__BS') ;		{ Bottom }      Get_Number (Symbol,Bos,; 		 '%SD-F-BADBOS, Directory stack pointer is corrupted.') ;d-      Bos_Str := DEC (Bos,Max_Digs,Max_Digs) ;S  '      Get_Symbol ('SD__SD') ;		{ Depth }       Get_Number (Symbol,Depth,= 		 '%SD-F-BADDEPTH, Directory stack pointer is corrupted.') ; 1      Depth_Str := DEC (Depth,Max_Digs,Max_Digs) ; 
      END ;    END ; 	{ of Initialize_Stack }     PROCEDURE Push ;  I { Push the stack *pointers* to reflect a directory push onto the stack. }F     BEGIN 	{ Push }d   IF Tos = 0  THEN
      BEGIN      Tos := 1 ;       Bos := 1 ;       END    ELSE 
      BEGIN      Tos := Tos + 1 ;e      IF Tos > Stack_Size  THEN 	BEGIN 	Tos := 1 ;  	Depth := Depth + 1 ;  	END ;      IF Tos = Bos  THENs 	BEGIN 	Bos := Bos + 1 ;i& 	IF Bos > Stack_Size  THEN  Bos := 1 ; 	END ;
      END ;*   Tos_Str := DEC (Tos,Max_Digs,Max_Digs) ;*   Bos_Str := DEC (Bos,Max_Digs,Max_Digs) ;.   Depth_Str := DEC (Depth,Max_Digs,Max_Digs) ;   END ; 	{ of Push }     PROCEDURE Pop ;x  G { Pop the stack *pointers* to reflect a directory pop from the stack. }e     BEGIN 	{ Pop }5   IF Tos = Bos	THEN	{ Last in stack - re-initialize }U      Zero_Stack.    ELSEP
      BEGIN      Tos := Tos - 1 ;='      IF (Tos = 0) AND (Depth > 0)  THENH 	BEGIN 	Tos := Stack_Size ; 	Depth := Depth - 1 ;i 	END ;-      Tos_Str := DEC (Tos,Max_Digs,Max_Digs) ; -      Bos_Str := DEC (Bos,Max_Digs,Max_Digs) ; 1      Depth_Str := DEC (Depth,Max_Digs,Max_Digs) ;P
      END ;   END ; 	{ of Pop }m    4 PROCEDURE Push_Stack (Dir : VARYING [Len] OF CHAR) ;  H { Push the stack *symbols* to reflect a directory push onto the stack. }     BEGIN 	{ Push_Stack }+   Push ;#   Set_Symbol ('SD__'+Tos_Str,Dir) ;p!   Set_Symbol ('SD__TS',Tos_Str) ; !   Set_Symbol ('SD__BS',Bos_Str) ; #   Set_Symbol ('SD__SD',Depth_Str) ;    END ; 	{ of Push_Stack }    : FUNCTION Getuai (User : VARYING [Len] OF CHAR) : BOOLEAN ;  F { Get the required information for the particular user from the UAF. }     VAR	Rst : INTEGER := 0 ;2 	Def_Dev , Def_Dir : VARYING [255] OF CHAR := '' ;- 	Item_List : Item_List_Template (3) := ZERO ;[     BEGIN 	{ Getuai }o0   Item_List[1].Buffer_Length := SIZE (Def_Dir) ;-   Item_List[1].Item_Code     := UAI$_DEFDIR ; 9   Item_List[1].Buffer_Addr   := IADDRESS (Def_Dir.BODY) ;I#   Item_List[1].Return_Addr   := 0 ;V  0   Item_List[2].Buffer_Length := SIZE (Def_Dev) ;-   Item_List[2].Item_Code     := UAI$_DEFDEV ;l9   Item_List[2].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;t#   Item_List[2].Return_Addr   := 0 ;G  ?   Item_List[3].Terminator    := 0 ;	{ Terminate the item list }   A   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (User,1,User.LENGTH),  		  Itmlst := Item_List) ;     Getuai := ODD (Rst) ;:     IF NOT ODD (Rst)  THEN
      BEGIN      IF Rst = RMS$_RNF	THENS4 	Exit ('%SD-F-NOSUCHUSER, Username does not exist.')
       ELSE 	LIB$SIGNAL (Rst) ;G      END    ELSED
      BEGIN.      Def_Dir.LENGTH := INT (Def_Dir.BODY[1]) ;.      Def_Dev.LENGTH := INT (Def_Dev.BODY[1]) ;=      Def_Dir.BODY := SUBSTR (Def_Dir.BODY,2,Def_Dir.LENGTH) ;F=      Def_Dev.BODY := SUBSTR (Def_Dev.BODY,2,Def_Dev.LENGTH) ;e&      Target_Dir := Def_Dev + Def_Dir ;
      END ;   END ; 	{ of Getuai }     PROCEDURE Get_User_Dir ;  M { Determine the default disk and directory of the target user from the UAF. }   6   CONST Alpha_Plus = ['a'..'z','A'..'Z','_','-','$'] ;     VAR	Stop : INTEGER := 0 ;  	User ,t9 	Stub : VARYING [255] OF CHAR := '' ;	{ Save any extras }s     BEGIN 	{ Get_User_Dir } '   Stub := SUBSTR (Cmd,2,Cmd.LENGTH-1) ; 3   Stop := FIND_NONMEMBER (Stub,Alpha_Plus+Digits) ;I   IF Stop = 0  THENs      User := Stubn    ELSE 
      BEGIN%      User := SUBSTR (Stub,1,Stop-1) ; 4      Stub := SUBSTR (Stub,Stop,Stub.LENGTH-Stop+1) ;
      END ;   Getuai (User) ;r    Command := Target_Dir + Stub ;   Cmd := Command ;   END ; 	{ of Get_User_Dir }    & PROCEDURE Parse_Spec_And_Set_Default ;  9 { Parse the input specification and set default as we go.=;   Handle all shortcut characters except tilde ("~") here. }N     VARA  /   Braced , Brace_It , Done : BOOLEAN := FALSE ;_   Target : INTEGER := 0 ;e=   Spec , Stem , Root , Result : VARYING [255] OF CHAR := '' ;   '   BEGIN 	{ Parse_Spec_And_Set_Default }O   Root := Cmd ;i   Result := Current_Dir ;    Expanding := TRUE ;   F   { Replace all "`" characters with "-".  This allows us to go back upB     levels in the subdirectory tree without the need for braces. }     REPEAT      Target := INDEX (Root,'`') ;/     IF Target <> 0  THEN  Root[Target] := '-' ;    UNTIL Target = 0 ;     WHILE NOT Done  DO	     BEGINs      Target := INDEX (Root,',') ;     IF Target = 0  THENI        BEGIN        Stem := Root ;l        Done := TRUE ;a
        END	      ELSEa        BEGIN)        Stem := SUBSTR (Root,1,Target-1) ;$:        Root := SUBSTR (Root,Target+1,Root.LENGTH-Target) ;        END ;  *     IF Target = 1  THEN 				{ Comma ONLY })        Set_New_Default (Default_Dir,Done)d	      ELSEN        BEGIN2        Target := INDEX (Stem,':') ;			{ Device ? }        IF Target <> 0  THENT 	  BEGIN# 	  Spec := SUBSTR (Stem,1,Target) ;E6 	  Stem := SUBSTR (Stem,Target+1,Stem.LENGTH-Target) ; 	  END ;  :        Target := INDEX (Stem,';') ;			{ Version number ? }        IF Target <> 0  THENm8 	  Stem := SUBSTR (Stem,1,Target-1) ;		{ Get rid of it }          IF Stem <> ''  THEN 	  BEGIN. 	  Braced := INDEX (Stem,'[') <> 0 ;		{ [] ? } 	  Brace_It := (NOT Braced) ANDt 		      ((Stem[1] = '.') ORm 		       (Stem[1] = '-') ORC% 		       (Stem[1] = '^')) ;		{ MFD? }g* 	  IF Brace_It  THEN  Spec := Spec + '[' ;6 	  IF (Stem.LENGTH > 0) AND_THEN (Stem[1] = '^')  THEN= 	     Spec := Spec + '000000' + SUBSTR (Stem,2,Stem.LENGTH-1)D 	   ELSE 	     Spec := Spec + Stem ;D 	  IF Brace_It  THEN 	     Spec := Spec + ']*.*'* 	   ELSE 	  IF Braced  THEN 	     Spec := Spec + '*.*' ; 	  END 	ELSEt 	  Spec := Spec + '*.*' ;S%        Parse_Filename (Spec,Result) ;r        Result := Target_Dir ;T        Spec := '' ;r&        Set_New_Default (Result,Done) ;        END ;	     END ;    Expanding := FALSE ;*   END ; 	{ of Parse_Spec_And_Set_Default }    ! PROCEDURE Show_Stack_Attributes ;   ' { Display directory stack attributes. }e     VAR	I : INTEGER := 0 ;  "   BEGIN 	{ Show_Stack_Attributes }.   WRITELN ('SD Directory stack attributes:') ;   WRITELN ;H*   WRITELN ('Stack size:  ',Stack_Size:1) ;.   WRITELN ('Stack limit: ',Max_Stack_Size:1) ;   WRITEV (Symbol,Stack_Style) ;t%   Str_Compress (Symbol,Symbol,TRUE) ;i$   WRITELN ('Stack style: ',Symbol) ;   WRITE ('Stack usage: ') ;a   IF Tos = 0  THEN		{ Empty }a      WRITELN ('None.')    ELSE 
      BEGIN#      I := Vs (Tos) - Vs (Bos) + 1 ;l      WRITE (I:1,' slot') ;      IF I = 1 THEN 	BEGIN 	WRITELN ('.') ;& 	WRITELN ('Slot in use: ',Vs(Tos):1) ; 	END
       ELSE 	BEGIN 	WRITELN ('s.') ;'7 	WRITELN ('Slot range:  ',Vs(Bos):1,' to ',Vs(Tos):1) ;  	END ;
      END ;     WRITELN ;S   WRITEV (Symbol,Undo) ;%   Str_Compress (Symbol,Symbol,TRUE) ;(&   WRITELN ('Undo errors:   ',Symbol) ;   WRITEV (Symbol,Quiet) ; %   Str_Compress (Symbol,Symbol,TRUE) ;D&   WRITELN ('Quiet:         ',Symbol) ;!   WRITEV (Symbol,Update_Prompt) ; %   Str_Compress (Symbol,Symbol,TRUE) ; &   WRITELN ('Update Prompt: ',Symbol) ;   IF Update_Prompt  THEN
      BEGIN$      WRITEV (Symbol,Prompt_Format) ;(      Str_Compress (Symbol,Symbol,TRUE) ;)      WRITELN ('Prompt format: ',Symbol) ;s       WRITE ('Prompt head:   ') ;(      IF Prompt_Head = Default_Head  THEN 	WRITELN ('Default.')D
       ELSE 	WRITELN ('User specified.') ;       WRITE ('Prompt tail:   ') ;(      IF Prompt_Tail = Default_Tail  THEN 	WRITELN ('Default.') 
       ELSE 	WRITELN ('User specified.') ;;      WRITELN ('Max Prompt size: ',Max_Prompt_Size_User:1) ;I
      END ;	   $EXIT ;	%   END ; 	{ of Show_Stack_Attributes }A     PROCEDURE Stack_Typer ;l  : { Allow directory stack style to be verified or changed. }     BEGIN 	{ Stack_Typer }   IF Cmd.LENGTH = 2  THENl
      BEGIN"      WRITEV (Symbol,Stack_Style) ;(      Str_Compress (Symbol,Symbol,TRUE) ;?      Exit ('%SD-I-STYLE, Directory stack style is ' + Symbol) ;]      END    ELSE 
      BEGIN1      READV (Cmd[3],Stack_Style,Error:=CONTINUE) ;       IF STATUSV <> 0  THEN= 	Exit ('%SD-F-BADSTYLE, Directory stack style is invalid.') ;c"      WRITEV (Symbol,Stack_Style) ;(      Str_Compress (Symbol,Symbol,TRUE) ;1      Set_Logical_Name ('SD_STACK_STYLE',Symbol) ;R?      Exit ('%SD-S-STYLE, Directory stack style is ' + Symbol) ; 
      END ;   END ; 	{ of Stack_Typer }e     PROCEDURE Stack_Undoer ;  6 { Allow undo error option to be verified or changed. }     BEGIN 	{ Stack_Undoer }    IF Cmd.LENGTH > 2  THEN 
      BEGIN*      READV (Cmd[3],Undo,Error:=CONTINUE) ;      IF STATUSV <> 0  THEN@ 	Exit ('%SD-F-BADUNDO, Undo value must be "True" or "False".') ;      WRITEV (Symbol,Undo) ;1(      Str_Compress (Symbol,Symbol,TRUE) ;3      Set_Logical_Name ('SD_UNDO_IF_ERROR',Symbol) ;i
      END ;     IF Undo  THENcB      Exit ('%SD-I-UNDO, Errors during expansion will be undone.' )    ELSE J      Exit ('%SD-I-NOUNDO, Errors during expansion will not be undone.' ) ;   END ; 	{ of Stack_Undoer }     PROCEDURE List_Stack ;  M { Display the contents of the stack (if any) and the current default disk andi   directory. }  #   VAR	I , Sig_Digs : INTEGER := 0 ;y$ 	Str_I : VARYING [4] OF CHAR := '' ;     BEGIN 	{ List_Stack }I   IF Tos = 0  THEN			{ Empty }
      BEGIN      WRITELN (Current_Dir) ;      Exit (Empty_Stack_Msg) ;       END    ELSE(
      BEGIN2      Sig_Digs := TRUNC (MTH$ALOG10(Vs(Tos))) + 1 ;6      WRITELN (PAD('','-',Sig_Digs),'> ',Current_Dir) ;
      END ;  '   FOR I := Vs (Tos) DOWNTO Vs (Bos)  DO;       BEGIN .       Str_I := DEC (Rs(I),Max_Digs,Max_Digs) ;!       Get_Symbol ('SD__'+Str_I) ;_(       WRITELN (I:Sig_Digs,': ',Symbol) ;       END ;D	   $EXIT ;L   END ; 	{ of List_Stack }     PROCEDURE Read_File ;_  P { Load the stack with the contents of a disk file - one default spec per line. }     VAR	Count : INTEGER := 0 ;     BEGIN 	{ Read_File }   IF Cmd.LENGTH = 2  THENS      Symbol := 'SD_INPUT_FILE'    ELSE ,      Symbol := SUBSTR (Cmd,3,Cmd.LENGTH-2) ;   Parse_Filename (Symbol) ;t   IF Phantom_File  THEN:6      Exit ('%SD-F-FILNOTFOU, Input file not found.') ;  G   OPEN (Data,FILE_NAME:=Search_Result,HISTORY:=Old,SHARING:=READONLY) ;c   RESET (Data) ;E   WRITELN ('%SD-I-READING, Reading stack data from ',Search_Result) ;t     WHILE NOT EOF (Data)	DOD	     BEGIN      READLN (Data,Symbol) ;     Push_Stack (Symbol) ;]     Count := Count + 1 ;	     END ;e     CLOSE (Data) ;   IF Count = 1	THENI      Symbol := 'entry'    ELSE;      Symbol := 'entries' ;=   WRITELN ('%SD-I-LOADED,  Loaded ',Count:1,' ',Symbol,'.') ;{   END ; 	{ of Read_File }n     PROCEDURE Write_File ;  N { Dump the contents of the stack to a disk file - one default spec per line. }      VAR	I , Count : INTEGER := 0 ;$ 	Str_I : VARYING [4] OF CHAR := '' ;     BEGIN 	{ Write_File }t   IF Cmd.LENGTH = 2  THENH      Symbol := 'SD_OUTPUT_FILE'-    ELSE,,      Symbol := SUBSTR (Cmd,3,Cmd.LENGTH-2) ;   Parse_Filename (Symbol) ;U   IF Phantom_Dir  THEN:      Exit ('%SD-F-DIRNOTFOU, Output directory not found.')    ELSE 					{ Remove version }mI      Search_Result := SUBSTR (Search_Result,1,INDEX(Search_Result,';')) ;   5   OPEN (Data,FILE_NAME:=Search_Result,HISTORY:=NEW) ;o   REWRITE (Data) ;C   WRITELN ('%SD-I-WRITING, Writing stack data to ',Search_Result) ;   #   FOR I := Vs (Bos) TO Vs (Tos)  DO        BEGIN .       Str_I := DEC (Rs(I),Max_Digs,Max_Digs) ;!       Get_Symbol ('SD__'+Str_I) ;=       WRITELN (Data,Symbol) ;>       Count := Count + 1 ;       END ;o     CLOSE (Data) ;   IF Count = 1	THENI      Symbol := 'entry'    ELSE       Symbol := 'entries' ;=   WRITELN ('%SD-I-STORED,  Stored ',Count:1,' ',Symbol,'.') ;d   END ; 	{ of Write_File }     PROCEDURE Swap_Slots ;  F { Swap the contents of two slots with each other.  This is an on-stack<   manipulation ONLY - the current default is not affected. }  ;   VAR	Tmp : INTEGER := 3 ;			{ !!! Note initial value !!! }-# 	Str : VARYING [80] OF CHAR := '' ;l     BEGIN 	{ Swap_Slots }p   Bos_Vs := Vs (Bos) ;   Tos_Vs := Vs (Tos) ;  =   IF (Command.LENGTH < 5) OR			{ "/S" + digit + " " + digit }z#      (INDEX (Command,' ') = 0)	THEN	=        Exit ('%SD-F-INVSWAP, Directory number is invalid.') ;N  ,   Tmp := Tmp + (Command[3] = ' ')::INTEGER ;4   Str := SUBSTR (Command,Tmp,Command.LENGTH-Tmp+1) ;M   Get_Number (Str,Poppy,'%SD-F-BADSWAP, Directory number must be integer.') ;l/   IF (Poppy < Bos_Vs) OR (Poppy > Tos_Vs)  THENr;      Exit ('%SD-F-INVSWAP, Directory number is invalid.') ;}     Tmp := INDEX (Str,' ') ;   IF Tmp <> 0  THEN 
      BEGIN/      Str := SUBSTR (Str,Tmp+1,Str.LENGTH-Tmp) ;bP      Get_Number (Str,Poppy2,'%SD-F-BADSWAP, Directory number must be integer.');3      IF (Poppy2 < Bos_Vs) OR (Poppy2 > Tos_Vs)	THENS7 	Exit ('%SD-F-INVSWAP, Directory number is invalid.') ;-
      END ;  4   Str_Poppy  := DEC (Rs(Poppy) ,Max_Digs,Max_Digs) ;4   Str_Poppy2 := DEC (Rs(Poppy2),Max_Digs,Max_Digs) ;"   Get_Symbol ('SD__'+Str_Poppy2) ;   Symbol2 := Symbol ; !   Get_Symbol ('SD__'+Str_Poppy) ;a)   Set_Symbol ('SD__'+Str_Poppy,Symbol2) ;M)   Set_Symbol ('SD__'+Str_Poppy2,Symbol) ;    END ; 	{ of Swap_Slots }    , PROCEDURE Slot_To_Current (Swap : BOOLEAN) ;  L { Make the contents of a given slot the current default, and optionally swap8   the default being replaced into the slot being used. }  1   VAR	Position , Bos_Vs , Tos_Vs : INTEGER := 0 ;-     BEGIN 	{ Slot_To_Current }   Bos_Vs := Vs (Bos) ;   Tos_Vs := Vs (Tos) ;  4   IF Swap  THEN  Position := 2	ELSE  Position := 3 ;@   Get_Number (SUBSTR (Cmd,Position,Cmd.LENGTH-Position+1),Poppy,< 	      '%SD-F-BADSLOT, Directory number must be integer.') ;     IF Poppy < 0	THEN,1      IF ABS (Poppy) > (Tos_Vs - Bos_Vs + 1)  THEN=A 	Exit ('%SD-F-INVRELSLOT, Relative directory number is invalid.') 
       ELSE> 	Poppy := Tos_Vs + Poppy + 1	{ Make it a virtual slot number }    ELSE >   IF (Poppy = 0) OR (Poppy < Bos_Vs) OR (Poppy > Tos_Vs)  THEN;      Exit ('%SD-F-INVSLOT, Directory number is invalid.') ;E  2   Str_Poppy := DEC (Rs(Poppy),Max_Digs,Max_Digs) ;!   Get_Symbol ('SD__'+Str_Poppy) ;(   Parse_Filename (Symbol) ;t    Set_New_Default (Target_Dir) ;<   IF Swap  THEN  Set_Symbol ('SD__'+Str_Poppy,Current_Dir) ;6   IF Update_Prompt  THEN  Change_Prompt (Target_Dir) ;   END ; 	{ of Slot_To_Current }n     PROCEDURE Overwrite_Slot ;  N { Overwrite the contents of a given slot with the current default.  This is anE   on-stack manipulation ONLY - the current default is not affected. }      BEGIN 	{ Overwrite_Slot }O0   Get_Number (SUBSTR (Cmd,3,Cmd.LENGTH-2),Poppy,< 	      '%SD-F-BADSLOT, Directory number must be integer.') ;3   IF (Poppy < Vs (Bos)) OR (Poppy > Vs (Tos))  THEN ;      Exit ('%SD-F-INVSLOT, Directory number is invalid.') ;U  2   Str_Poppy := DEC (Rs(Poppy),Max_Digs,Max_Digs) ;-   Set_Symbol ('SD__'+Str_Poppy,Current_Dir) ;t   END ; 	{ of Overwrite_Slot }     PROCEDURE Pop_Stack ;f   { Pop the stack. }     VAR	I : INTEGER := 0 ;$ 	Str_I : VARYING [4] OF CHAR := '' ;     BEGIN 	{ Pop_Stack }   Bos_Vs := Vs (Bos) ;   Tos_Vs := Vs (Tos) ;  *   IF Cmd.LENGTH = 2  THEN		{ Pop the Top }      Poppy := Tos_Vs    ELSE 
      BEGIN3      Get_Number (SUBSTR (Cmd,3,Cmd.LENGTH-2),Poppy, 8 			 '%SD-F-BADPOP, Directory number must be integer.') ;      IF Cmd[2] = 'B'  THEN8 	Poppy := - ABS (Poppy) ;	{ In case they put "/B -n" ! }
      END ;  $   { Validate slot to which to pop. }     IF Poppy < 0	THEN 1      IF ABS (Poppy) > (Tos_Vs - Bos_Vs + 1)  THEN(@ 	Exit ('%SD-F-INVRELPOP, Relative directory number is invalid.')
       ELSE> 	Poppy := Tos_Vs + Poppy + 1	{ Make it a virtual slot number }    ELSE >   IF (Poppy = 0) OR (Poppy < Bos_Vs) OR (Poppy > Tos_Vs)  THEN:      Exit ('%SD-F-INVPOP, Directory number is invalid.') ;  )   { Set default to valid slot contents. }   2   Str_Poppy := DEC (Rs(Poppy),Max_Digs,Max_Digs) ;!   Get_Symbol ('SD__'+Str_Poppy) ;H   Parse_Filename (Symbol) ;     Set_New_Default (Target_Dir) ;     { Stack emptied?  Reset! }     IF Poppy = Bos_Vs  THEN,      Zero_Stack     ELSEm
      BEGIN  E      { Pop the *symbols* to reflect a directory pop from the stack. }r  %      FOR I := Tos_Vs DOWNTO Poppy  DOB 	 BEGIN * 	 Str_I := DEC (Rs(I),Max_Digs,Max_Digs) ;? 	 Zip (LIB$DELETE_SYMBOL ('SD__'+Str_I,LIB$K_CLI_GLOBAL_SYM)) ;	 	 Pop ;A 	 END ;i  $      Set_Symbol ('SD__TS',Tos_Str) ;$      Set_Symbol ('SD__BS',Bos_Str) ;&      Set_Symbol ('SD__SD',Depth_Str) ;
      END ;  6   IF Update_Prompt  THEN  Change_Prompt (Target_Dir) ;   END ; 	{ of Pop_Stack }p     PROCEDURE Give_Help ;   - { M'aidez!  Allow a subtopic specification. }   5   VAR	Spot  : INTEGER := 2 ;			{ Note initial value } % 	Topic : VARYING [80] OF CHAR := '' ;I     BEGIN 	{ Give_Help }   IF Cmd[1] = '\'  THENp      Spot := 3 ;  :   IF (Spot <= Cmd.LENGTH) AND_THEN (Cmd[Spot] <> '')  THEN;      Topic := SUBSTR (Command,Spot,Command.LENGTH-Spot+1) ;   @   Zip (LBR$OUTPUT_HELP (Output_Routine := %IMMED LIB$PUT_OUTPUT,# 			Line_Desc      := 'SD ' + Topic,C, 			Library_Name   := 'SYS_HELP:PUBHELP.HLB',- 			Input_Routine  := %IMMED LIB$GET_INPUT)) ;p   END ; 	{ of Give_Help }t     PROCEDURE Prompt_Handler ;  4 { Allow prompt updating to be verified or changed. }  (   VAR	B4 , Modified : BOOLEAN := FALSE ;     BEGIN 	{ Prompt_Handler }    IF Cmd.LENGTH > 2  THEND
      BEGIN      B4 := Update_Prompt ;3      READV (Cmd[3],Update_Prompt,Error:=CONTINUE) ;:      IF STATUSV <> 0  THENI 	Exit ('%SD-F-BADPVAL, Change prompt value must be "True" or "False".') ;   $      WRITEV (Symbol,Update_Prompt) ;(      Str_Compress (Symbol,Symbol,TRUE) ;3      Set_Logical_Name ('SD_UPDATE_PROMPT',Symbol) ;s&      Modified := Update_Prompt <> B4 ;
      END ;     IF Update_Prompt  THEN
      BEGIN8      WRITELN ('%SD-I-UPDATE, Prompt will be updated.') ;      Get_Prompt_Specs ; G      Change_Prompt (Current_Dir) ;	{ Update prompt now - just in case }       END    ELSEa
      BEGIN>      WRITELN ('%SD-I-NOUPDATE, Prompt will be not updated.') ;2      IF Modified  THEN	Change_Prompt ('$ ',TRUE) ;
      END ;   END ; 	{ of Prompt_Handler }     PROCEDURE Hush_Hush ;I  / { Allow quiet flag to be verified or changed. }m     BEGIN 	{ Hush_Hush }   IF Cmd.LENGTH > 2  THENL
      BEGIN+      READV (Cmd[3],Quiet,Error:=CONTINUE) ;I      IF STATUSV <> 0  THENA 	Exit ('%SD-F-BADPVAL, Quiet value must be "True" or "False".') ;t        WRITEV (Symbol,Quiet) ;(      Str_Compress (Symbol,Symbol,TRUE) ;+      Set_Logical_Name ('SD_QUIET',Symbol) ;A
      END ;     IF Quiet  THENO      WRITELN ('%SD-I-QUIET, New default directory name will not be displayed.')     ELSEsM      WRITELN ('%SD-I-NOISY, New default directory name will be displayed.') ;n   END ; 	{ of Hush_Hush },     PROCEDURE Display_Current_Dir ;L   { Show current directory }      BEGIN 	{ Display_Current_Dir }   WRITELN (Current_Dir) ;$   IF Phantom_Dir  THEN9      WRITELN ('%SD-W-NODIR, Directory does not exist.') ;S	   $EXIT ; #   END ; 	{ of Display_Current_Dir }     E { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *eC   * * * * * * * * * *	M A I N   P R O G R A M   * * * * * * * * * *.G   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }e     BEGIN	{ Set_Default }v  
 Get_Command ;  Initialize_Stack ;  0 Get_Logical_Name ('SYS$LOGIN',' ',Default_Dir) ;  ; Parse_Filename ('[]*.*',,TRUE) ;	{ Get current directory. }U Current_Dir := Target_Dir ;=  0 IF Cmd = ''  THEN		{ No parameter = SYS$LOGIN: }    BEGIN5    IF (Default_Dir = Current_Dir) AND NOT Quiet  THEN        Display_Current_DirI     ELSE       BEGIN %       Set_New_Default (Default_Dir) ;         Push_Stack (Current_Dir) ;:       IF Update_Prompt	THEN  Change_Prompt (Default_Dir) ;       END ;     END  ELSEU  IF Cmd[1] = '?'  THEN		{ HELP! }    Give_Help  ELSES@ IF Cmd[1] <> '\'  THEN		{ Directory Spec or shortcut character }    BEGIN6    IF Cmd[1] = '~'  THEN	{ Particular user's default }       Get_User_Dir ;    Parse_Spec_And_Set_Default ;t%    IF Target_Dir <> Current_Dir  THENn       BEGIN         Push_Stack (Current_Dir) ;9       IF Update_Prompt	THEN  Change_Prompt (Target_Dir) ;d       END ;     END  ELSE:  IF Cmd = '\'  THEN		{ "\" ONLY }    IF Tos = 0  THEN		{ Empty }       Exit (Empty_Stack_Msg)     ELSE       BEGINr#       WRITEV (Cmd,'\',Vs (Tos):1) ;        Slot_To_Current (TRUE) ;	       ENDd%  ELSE					{ A backslash command ... }h    CASE Cmd[2] OF ?      'A': Show_Stack_Attributes ;	{ List the stack attributes } ;      'C': Display_Current_Dir ; 	{ Show current directory }E0      'E': Stack_Undoer ;		{ Change undo action }      'H',				{ Help! }!      '?': Give_Help ;			{ Help! }O+      'L': List_Stack ;			{ List the stack };/      'Q': Hush_Hush ;			{ Change Quiet action }S*      'R': Read_File ;			{ Read from file }/      'T': Stack_Typer ; 		{ Change stack type }S=      'U': Prompt_Handler ;		{ Change prompt updating action }1
     OTHERWISEr!      IF Tos = 0  THEN			{ Empty }e 	Exit (Empty_Stack_Msg)N
       ELSE 	CASE Cmd[2] OF(1 	  'P',				{ "Pop" the stack  - absolute number } ; 	  'B': Pop_Stack ;		{ ... or go "Back" - relative number }tC 	  'G': Slot_To_Current (FALSE); { Set slot into current, no swap } I 	  '-': Slot_To_Current (TRUE) ; { Negative number - swap back nth slot }=9 	  'O': Overwrite_Slot ; 	{ Overwrite slot with current }t5 	  'S': Swap_Slots ;		{ Swap two slots on the stack }G' 	  'W': Write_File ;		{ Write to file }H. 	  'Z': Zero_Stack (TRUE) ;	{ Zero the stack } 	 OTHERWISE @ 	  IF Cmd[2] IN Digits  THEN	{ Swap current with slot on stack } 	     Slot_To_Current (TRUE) 	   ELSE0 	     Exit ('%SD-F-BADPARAM, Bad parameter - ' +: 		   'check HELP for correct syntax (or use "$ SD ?").') ; 	END ;	{ Case }     END ;	{ Case }+   END.	{ of it all }