P       SUBROUTINE QSORT (LIST,N)                                                 P C***********************************************************************        P C                                                                               P C   Author         : Curtis Rempel                                              P C   Language       : FORTRAN 77                                                 P C   System         : MTS - *FORTRANVS                                           P C   Written        : 87/02/27                                                   P C                                                                               G C   PARAMETERS     : LIST - an array of elements to be sorted           P C                  : N    - the number of elements in the array                 P C                                                                               = C   COMMENTS       : Allows sorting up to 1,000,000 elements. P C                                                                               P C                  : Uses a partitioning subroutine, PARTIT, to                 P C                    subdivide the list.                                        P C                                                                               P C***********************************************************************        P                                                                                        INTEGER*2 N   P       INTEGER*4  HEAD,TAIL,LHEAD,LTAIL,HHEAD,HTAIL,HEADS(20),TAILS(20),               *           NSTACK =                                                                      CHARACTER*13 LIST(*)P                                                                                 P       NSTACK = 0                                                                P                                                                                 P       HEAD = 1                                                                  P       TAIL = N                                                                  P                                                                                 P 10    IF (NSTACK .GT. 0) THEN                                                   P           HEAD = HEADS (NSTACK)                                                 P           TAIL = TAILS (NSTACK)                                                 P           NSTACK = NSTACK - 1                                                   P       END IF                                                                    P                                                                                 P 20    IF (HEAD .LT. TAIL) THEN                                                  P           CALL PARTIT (LIST,HEAD,TAIL,LHEAD,LTAIL,HHEAD,HTAIL)                  P           IF ( (LTAIL - LHEAD) .LT. (HTAIL - HHEAD) ) THEN                      P                IF (NSTACK .GE. 20) THEN                                         P                     WRITE (6,*) '** STACK OVERFLOW **'                          P                     STOP                                                        P                END IF                                                           P                NSTACK = NSTACK + 1                                              P                HEADS (NSTACK) = HHEAD                                           P                TAILS (NSTACK) = HTAIL                                           P                HEAD = LHEAD                                                     P                TAIL = LTAIL                                                     P           ELSE IF (NSTACK .GT. 20) THEN                                         P                     WRITE (6,*) '** STACK OVERFLOW **'                          P                     STOP                                                        P           ELSE                                                                  P                NSTACK = NSTACK + 1                                              P                HEADS (NSTACK) = LHEAD                                           P                TAILS (NSTACK) = LTAIL                                           P                HEAD = HHEAD                                                     P                TAIL = HTAIL                                                     P           END IF                                                                P                                                                                 P           GOTO 20                                                               P                                                                                 P       END IF                                                                    P                                                                                 P       IF (NSTACK .NE. 0) GOTO 10                                                P                                                                                 P       END                                                                       P                                                                                 P                                                                                 P       SUBROUTINE PARTIT (LIST,HEAD,TAIL,LHEAD,LTAIL,HHEAD,HTAIL)                P                                                                                 P       INTEGER*4  HEAD,TAIL,LHEAD,LTAIL,HHEAD,HTAIL                                     INTEGER*4  I,J1                                                   D       CHARACTER*13 PIVOT,LIST(*),TEMP                               P                                                                                 P       PIVOT = LIST ((HEAD+TAIL)/2)                                              P                                                                                 P       I = HEAD - 1                                                              P       J = TAIL + 1                                                              P                                                                                 P 10    I = I + 1                                                                 P       IF (LIST(I) .LT. PIVOT) GOTO 10                                           P                                                                                 P 20    J = J - 1                                                                 P       IF (LIST(J) .GT. PIVOT) GOTO 20                                           P                                                                                 P       IF (I .LT. J) THEN                                                        P           TEMP = LIST (I)                                                       P           LIST (I) = LIST (J)                                                   P           LIST (J) = TEMP                                                       P       END IF                                                                    P                                                                                 P       IF (I .LT. J) GOTO 10                                                     P                                                                                 P       LHEAD = HEAD                                                              P       HTAIL = TAIL                                                              P                                                                                 P       IF (I .EQ. J) THEN                                                        P           LTAIL = J - 1                                                         P           HHEAD = I + 1                                                         P       ELSE                                                                      P           LTAIL = J                                                             P           HHEAD = I                                                             P       END IF                                                                    P                                                                                 P       END                                                                       