  	OPTIONS		/EXTEND_SOURCE 
 	PROGRAM 	SHS  C++  C   C FACILITY:	OpenVMS/ DEC FORTRAN C A C 	SHS.FOR - Utility program to display processes information on  8 C		the local node, or remote notes which reside the same; C		local cluster.  All processes' information are displayed : C		provided with proper privileges and process name search C		string matching criteria. C		   ' C AUTHOR:  James Shen (jshen1@ford.com)  C	   Powertrain Operation  C	   Ford Motor Company  C	   1981 Front Wheel Drive  C	   Batavia, OH 45103 C  C CREATION DATE: Sept, 1995  C	     C MODIFIED BY: C  C        : VERSION% C 01    - X01		James shen	11-OCT-1995 : C	Add /[NO]INTERACTIVE, /[NO]BATCH, /[NO]NETWORK logic and< C	call to INIT_CLI to allow to be used as a foreign command. C  C	   C DISTRIBUTION AND COPYRIGHT C  C Copyright  1995 James Shen  C = C This program is free software; permission is granted to any G C individual or institution to use, copy, or redistribute this software F C as long as it is not sold for profit, provided this copyright notice C is retained. C 
 C DISCLAIMER:  C H C This program is provided "AS IS" and without any expressed or implied K C warranties whatsoever.  No warranties as to performance, merchantability, K C or fitness for a particular purpose exist.  In no event shall any person  J C or organization of people be held responsible for any direct, indirect, ; C consequential or inconsequential damages or lost profits.  C	 C--  	IMPLICIT	NONE  " CDEC$ OPTIONS/ALIGN=COMMON=NATURAL   	COMMON	//	LUN,CONTEXT' 	COMMON	/NODE_INFO/  NODENAME, NODE_LEN "         COMMON  /SORT_ORDER/ ORDER 	COMMON  /SORT_KEY/   KEY ! 	COMMON	/PAGE_INFO/  PAGE_PRESENT    CDEC$ END OPTIONS    	INCLUDE		'($PSCANDEF)'  	INCLUDE		'($SSDEF)' 	INCLUDE		'($SYIDEF)'  	INCLUDE		'($LNMDEF)'  	INCLUDE		'($PSLDEF)'  	INCLUDE		'($FORIOSDEF)' 	INCLUDE		'($JPIDEF)'  	INCLUDE		'($SYSSRVNAM)' 	INCLUDE		'SHSINC.FOR'	            STRUCTURE /UIC_RECORD/           UNION               MAP                  INTEGER*2 MEMBER                 INTEGER*2 GROUP               END MAP              MAP#                 INTEGER*4 UIC_VALUE               END MAP           END UNION          END STRUCTURE   (         RECORD /UIC_RECORD/ 	UIC, UIC_2  	RECORD /LNMITMLIST/	LNMLIST(4) # 	RECORD /PSCANITMLIST/	PSCANLIST(7)  	RECORD /JPIITMLIST/	JPILIST(2)  	RECORD /SYIITMLIST/	SYILIST(2)   	RECORD /IOSB/		SYISTAT, JPISTAT 	  	EXTERNAL	CLI$_ABSENT, 	2		CLI$_PRESENT,  	2		CLI$_NEGATED,  	2		CLI$_COMMA, . 	2		SHS_VERB     		! Name of the command table   	INTEGER*4	CLI$GET_VALUE,  	2		CLI$PRESENT, 	2		LIB$GET_LUN,   	2		LIB$STOP,  	2		OTS$CVT_TO_L,  	2		STR$UPCASE,  	2		INIT_CLI 	 A         INTEGER*4       KEY 	/SHS_NOKEY/		!default is no sort key 9 	INTEGER*4	ORDER   /SHS_ASCENDING/		!default is ascending  	INTEGER*4	LUN+ 	INTEGER*4	STATUS, RET_STATUS, IOSTATUS, I	  	INTEGER*4	RMS_STS, RMS_STV  	INTEGER*4	CONTEXT+ 	INTEGER*4	CSID	/-1/			!cluster id wildcard 5 	LOGICAL*4	PAGE_PRESENT 	/.FALSE./	!default is noPAGE ! 	LOGICAL*4	USER_PRESENT	/.FALSE./ ; 	LOGICAL*4	CLUSTER_PRESENT	/.FALSE./	!default is local node > 	LOGICAL*4	NODE_VALUE_PRESENT /.FALSE./	!default is local node 	LOGICAL*4	NOMORE_NODE9 	LOGICAL*4	EXTEND_PRESENT	/.FALSE./	!default is no extend 6 	LOGICAL*4	INTER_ABSENT, NETWORK_ABSENT, BATCH_ABSENT > 	DATA		INTER_ABSENT, NETWORK_ABSENT, BATCH_ABSENT /3*.FALSE./	8 	LOGICAL*4	INTER_PRESENT, NETWORK_PRESENT, BATCH_PRESENT1 	LOGICAL*4	GRP_OCTAL /.TRUE./, MEM_OCTAL /.TRUE./ 9 	LOGICAL*4	UIC_PRESENT /.FALSE./, GROUP_PRESENT /.FALSE./    	CHARACTER*65	UIC_INPUT  	INTEGER*2	UIC_INPUT_LENGTH  	CHARACTER*255	OUTPUT_DEV  	INTEGER*2	OUTPUT_DEV_LEN L         CHARACTER*16    SORT_INPUT                      !keyword for sort_byL         INTEGER*2       SORT_INPUT_LEN                  !return input length 	CHARACTER*15	INPUT_PRCNAM 	INTEGER*2	INPUT_PRCNAM_LEN  	CHARACTER*6	NODENAME  	INTEGER*2	NODE_LEN  	CHARACTER*12	USERNAME 	INTEGER*2	USER_LEN  	CHARACTER*(*)	TABNAM		 + 	PARAMETER	( TABNAM = 'LNM$PROCESS_TABLE' )  	BYTE		CLU_MEMBER_STATUS  " 	STATUS = INIT_CLI(SHS_VERB,'SHS')= 	IF (.NOT. STATUS ) CALL SYS$EXIT(%VAL(STATUS + '10000000'X))    C 0 C Check /INTERACTIVE present in the command line C $ 	STATUS = CLI$PRESENT('INTERACTIVE')( 	IF (STATUS .EQ. %LOC(CLI$_ABSENT)) THEN 	  INTER_ABSENT  = .TRUE.	  !           INTER_PRESENT = .FALSE. . 	ELSE IF (STATUS .EQ. %LOC(CLI$_NEGATED)) THEN!           INTER_PRESENT = .FALSE. . 	ELSE IF (STATUS .EQ. %LOC(CLI$_PRESENT)) THEN 	  INTER_PRESENT = .TRUE.  	ELSE  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C , C Check /NETWORK present in the command line C   	STATUS = CLI$PRESENT('NETWORK')) 	IF (STATUS .EQ. %LOC(CLI$_ABSENT))  THEN  	  NETWORK_ABSENT = .TRUE.#           NETWORK_PRESENT = .FALSE. . 	ELSE IF (STATUS .EQ. %LOC(CLI$_NEGATED)) THEN#           NETWORK_PRESENT = .FALSE. . 	ELSE IF (STATUS .EQ. %LOC(CLI$_PRESENT)) THEN 	  NETWORK_PRESENT = .TRUE.  	ELSE  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C * C Check /BATCH present in the command line C  	STATUS = CLI$PRESENT('BATCH')( 	IF (STATUS .EQ. %LOC(CLI$_ABSENT)) THEN 	  BATCH_ABSENT = .TRUE.!           BATCH_PRESENT = .FALSE. / 	ELSE IF (STATUS .EQ. %LOC(CLI$_NEGATED)) THEN  !           BATCH_PRESENT = .FALSE. . 	ELSE IF (STATUS .EQ. %LOC(CLI$_PRESENT)) THEN 	  BATCH_PRESENT = .TRUE.  	ELSE  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C : C Check /UIC present in the comand line, if do process it. C  	STATUS = CLI$PRESENT('UIC')* 	IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN= 	  STATUS = CLI$GET_VALUE('UIC', UIC_INPUT, UIC_INPUT_LENGTH) # 	  IF (STATUS .EQ. SS$_NORMAL) THEN 7 	    STATUS = STR$UPCASE( UIC_INPUT(:UIC_INPUT_LENGTH), # 	2			 UIC_INPUT(:UIC_INPUT_LENGTH)) 3 	    IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS))	   7 	    IF ( .NOT. INDEX(UIC_INPUT, '[')) THEN 		!identify : 	      STATUS = SYS$ASCTOID(UIC_INPUT(:UIC_INPUT_LENGTH),  	2			   UIC.UIC_VALUE,) ;               IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS))  	      UIC_PRESENT = .TRUE. @ 	    ELSE IF (INDEX(UIC_INPUT, ',') .EQ. 0)  THEN   	![identify]C               STATUS = SYS$ASCTOID(UIC_INPUT(2:UIC_INPUT_LENGTH-1),  	2			   UIC.UIC_VALUE,) 4 	      IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS)) 	      UIC_PRESENT = .TRUE.  	    ELSE 						![ident,ident] 	      I = 2E               DO WHILE (I .LT. INDEX(UIC_INPUT, ',') .AND. GRP_OCTAL) B 	        IF (UIC_INPUT(I:I) .GE. 'A' .AND. UIC_INPUT(I:I) .LE. 'Z'C 	2	  .OR. UIC_INPUT(I:I) .EQ. '$' .OR. UIC_INPUT(I:I) .EQ. '_')THEN %                   GRP_OCTAL = .FALSE.  	        END IF  	        I = I + 1
 	      END DO  	      C 6 C Check the value range, grp id should be in [1-37776] C  	      IF (GRP_OCTAL) THEN   	7                 STATUS =OTS$CVT_TO_L(UIC_INPUT(2:I-1),   	2			    UIC_2.GROUP,  	2			    %VAL(2),    !2-bytes $ 	2			    %VAL(1))	!ignore all blanks 	        IF (.NOT. STATUS) THEN : 		  TYPE *, '%SYSTEM-F-IVIDENT, invalid identifier format' 		  CALL LIB$STOP(%VAL(STATUS))  		END IF C		   8 C Group ID out off range - that is all we have to check.K C We do not _STRICTLY_ enforce that there has to be a rights identifier to  E C match the octal number been specified, since in some case a user's  L C identifier could be `[xxxxx,yyyyy]', and octal number xxxxx does not have $ C a rights identifier to match with. C		   D 	          IF (UIC_2.GROUP .EQ. 0 .OR. UIC_2.GROUP .GT. 16382) THEN & 		    CALL SYS$EXIT(%VAL(SS$_IVIDENT)) 	          END IF  	      ELSE D 	        STATUS = SYS$ASCTOID (UIC_INPUT(2:INDEX(UIC_INPUT, ',')-1), 	2			      UIC_2.UIC_VALUE,)6 	        IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS)) C		 : C Found Id, Still need to verify whether this is a grp id. C		 B 		IF(UIC_2.MEMBER .NE.'177777'O) CALL SYS$EXIT(%VAL(SS$_NOSUCHID))
 	      END IF   I 	      I = INDEX(UIC_INPUT(:UIC_INPUT_LENGTH),',') + 1    ! ptr to member ( 	      IF (UIC_INPUT(I:I) .EQ. '*') THEN/ 	        IF ( UIC_INPUT(I+1:I+1) .NE. ']') THEN $ 		  CALL SYS$EXIT(%VAL(SS$_IVIDENT)) 	        ELSE ! 	          GROUP_PRESENT = .TRUE.  		  MEM_OCTAL = .FALSE.                  END IF               ELSE  7 		DO WHILE ( I .LE. UIC_INPUT_LENGTH-1 .AND. MEM_OCTAL) D 	          IF (UIC_INPUT(I:I) .GE. 'A' .AND. UIC_INPUT(I:I) .LE. 'Z'% 	2	     .OR. UIC_INPUT(I:I) .EQ. '$'  * 	2	     .OR. UIC_INPUT(I:I) .EQ. '_') THEN(                      MEM_OCTAL = .FALSE. 	          END IF  	          I = I + 1 	        END DO                END IF  5 	      IF (MEM_OCTAL) THEN   		!check the value range `                 STATUS=OTS$CVT_TO_L(UIC_INPUT(INDEX(UIC_INPUT(:UIC_INPUT_LENGTH-1),',')+1:I-1),  	2			    UIC.MEMBER,% 	2			    %VAL(2),            !2-bytes % 	2			    %VAL(1))		!ignore all blanks  	        IF (.NOT. STATUS) THEN : 		  TYPE *, '%SYSTEM-F-IVIDENT, invalid identifier format' 		  CALL LIB$STOP(%VAL(STATUS))  		END IF C		 ( C Member Identifier cannot be '177777'O!M C Same token as stated above, We do not enforce there has to be an identifer  # C to match with the internal value.  C		 D 	        IF (UIC.MEMBER .EQ. (-1)) CALL SYS$EXIT(%VAL(SS$_IVIDENT))   	        UIC.GROUP = UIC_2.GROUP 		UIC_PRESENT = .TRUE.D 	      ELSE IF (.NOT. GROUP_PRESENT) THEN   	!alphanumeric identify S 	        STATUS = SYS$ASCTOID(UIC_INPUT(INDEX(UIC_INPUT,',')+1:UIC_INPUT_LENGTH-1),  	2			     UIC.UIC_VALUE,) 6 	        IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS)) C ? C Check grpid to see whether matches the grpid specified in UIC  C  		UIC.GROUP = UIC_2.GROUP 8 	        STATUS = SYS$IDTOASC( %VAL(UIC.UIC_VALUE),,,,,)6 	        IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS)) 		UIC_PRESENT = .TRUE.
 	      END IF  	    END IF / 	  ELSE IF (STATUS .EQ. %LOC(CLI$_ABSENT)) THEN  C	   C Get process owner's UIC value  C	     	    JPILIST(1).BUFLEN	= 4 	    JPILIST(1).CODE	= JPI$_UIC , 	    JPILIST(1).BUFADR	= %LOC(UIC.UIC_VALUE) 	    JPILIST(1).RETLENADR= 0 	    JPILIST(2).END_LIST	= 0   	    STATUS = SYS$GETJPIW(,,,  	2			 JPILIST, 	2			 JPISTAT,,) 	    IF (.NOT. STATUS) THEN " 	      CALL LIB$STOP(%VAL(STATUS))) 	    ELSE IF ( .NOT. JPISTAT.STATUS) THEN " 	      CALL LIB$STOP(%VAL(STATUS))             END IF 	    UIC_PRESENT = .TRUE.  	  ELSE   	    CALL LIB$STOP(%VAL(STATUS))	 	  END IF - 	ELSE IF (STATUS .NE. %LOC(CLI$_ABSENT)) THEN  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C + C Check /OUTPUT present in the command line  C  	STATUS = CLI$PRESENT('OUTPUT') ) 	IF ( STATUS .EQ. %LOC(CLI$_ABSENT)) THEN  	  CONTINUE / 	ELSE IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN # 	  STATUS = CLI$GET_VALUE('OUTPUT',  	2			OUTPUT_DEV, 	2			OUTPUT_DEV_LEN)+ 	  IF ( STATUS .EQ. %LOC(CLI$_ABSENT)) THEN 
 	    CONTINUE ) 	  ELSE IF ( STATUS .EQ. SS$_NORMAL) THEN ? 	    IF ( OUTPUT_DEV(1:OUTPUT_DEV_LEN) .EQ. 'SYS$OUTPUT' ) THEN  	      CONTINUE  	    ELSE  	( 	      ! define sys$output -> output_dev7 	      !*********************************************** 1 	      ! Construct & Initialize Lnm Item List 	   7 	      !*********************************************** ! 	      LNMLIST(1).BUFLEN    = 255 ) 	      LNMLIST(1).CODE      = LNM$_STRING @ 	      LNMLIST(1).BUFADR    = %LOC(OUTPUT_DEV(1:OUTPUT_DEV_LEN))&               LNMLIST(1).RETLENADR = 0&               LNMLIST(2).END_LIST  = 0   	      STATUS = SYS$CRELNM( ,  	2			   TABNAM,  	2			   'SYS$OUTPUT',  	2			   PSL$C_USER,  	2			   LNMLIST)  6 	      IF ( .NOT. STATUS) CALL LIB$STOP(%VAL(STATUS))	 	    END IF 	 	  END IF / 	ELSE IF ( STATUS .EQ. %LOC(CLI$_NEGATED)) THEN = 	  ! define sys$output -> NL: - user mode -\ SUPPRESS OUTPUT! < 	  ! define sys$input -> NL: - user mode  -/ SUPPRESS INPUT!3 	  !*********************************************** - 	  ! Construct & Initialize Lnm Item List 	   3 	  !*********************************************** $ 	  LNMLIST(1).BUFLEN    = LEN('NL:')% 	  LNMLIST(1).CODE      = LNM$_STRING % 	  LNMLIST(1).BUFADR    = %LOC('NL:') "        	  LNMLIST(1).RETLENADR = 0"        	  LNMLIST(2).END_LIST  = 0   	  STATUS = SYS$CRELNM( ,  	2			TABNAM, 	2			'SYS$OUTPUT', 	2			PSL$C_USER,
 	2			LNMLIST)   1 	  IF ( .NOT. STATUS) CALL LIB$STOP(%VAL(STATUS))    	  STATUS = SYS$CRELNM( ,  	2			TABNAM, 	2			'SYS$INPUT',  	2			PSL$C_USER,
 	2			LNMLIST)   1 	  IF ( .NOT. STATUS) CALL LIB$STOP(%VAL(STATUS))    	END IF    C	 C Open SYS$OUTPUT w/ LUN C	 	STATUS = LIB$GET_LUN(LUN)/ 	IF ( .NOT. STATUS) CALL LIB$STOP(%VAL(STATUS))    	OPEN(	UNIT = LUN, 	2	FILE = 'SYS$OUTPUT',  	2	STATUS = 'NEW', 	2	FORM = 'FORMATTED', 	2	ACCESS = 'SEQUENTIAL', % 	2	DEFAULTFILE = 'SYS$LOGIN:SHS.LIS', 
 	2	SHARED, 	2	IOSTAT = IOSTATUS )   	IF ( IOSTATUS .NE. 0) THEN % 	  CALL ERRSNS (, RMS_STS, RMS_STV,,) . 	  CALL LIB$STOP(%VAL(RMS_STS), %VAL(RMS_STV)) 	END IF    C	) C Check /PAGE present in the command line  C  	STATUS = CLI$PRESENT('PAGE') * 	IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN 	  PAGE_PRESENT = .TRUE.R 	ELSE IF ( STATUS .EQ. %LOC(CLI$_ABSENT) .OR. STATUS .EQ. %LOC(CLI$_NEGATED)) THEN 	  PAGE_PRESENT = .FALSE.  	ELSE  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C ) C Check /HELP present in the command line  C  	STATUS = CLI$PRESENT('HELP') * 	IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN2 	  CALL SHS_FIND_HELP ('SHS', 'SYS$LOGIN:SHS.HLB') 	  CALL  SYS$EXIT(%VAL(1))	    	END IF   7 	STATUS = CLI$GET_VALUE('INPUT_PRC_NAME', INPUT_PRCNAM,  	2	INPUT_PRCNAM_LEN)( 	IF (STATUS .EQ. %LOC(CLI$_ABSENT)) THEN 	    INPUT_PRCNAM = '**' 	ELSE IF (STATUS)  THEN > 	    INPUT_PRCNAM = '*'//INPUT_PRCNAM(1:INPUT_PRCNAM_LEN)//'*' 	ELSE   	    CALL LIB$STOP(%VAL(STATUS)) 	ENDIF   C , C Check /SORT_BY present in the command line C '         STATUS = CLI$PRESENT('SORT_BY') T         IF ( STATUS .EQ. %LOC(CLI$_ABSENT) .OR. STATUS .EQ. %LOC(CLI$_NEGATED)) THEN           KEY = SHS_NOKEY 6         ELSE IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN+           STATUS = CLI$GET_VALUE('SORT_BY', % 	2                        SORT_INPUT, ) 	2                        SORT_INPUT_LEN) !           IF ( .NOT. STATUS) THEN '             CALL LIB$STOP(%VAL(STATUS))            ELSEN             IF (INDEX('PROCESS_NAME',SORT_INPUT(:SORT_INPUT_LEN)) .EQ. 1) THEN                KEY = SHS_PROCNAMEI             ELSE IF (INDEX('IO',SORT_INPUT(:SORT_INPUT_LEN)) .EQ. 1) THEN                KEY = SHS_IOJ             ELSE IF (INDEX('CPU',SORT_INPUT(:SORT_INPUT_LEN)) .EQ. 1) THEN               KEY = SHS_CPU P             ELSE IF (INDEX('PAGEFAULT',SORT_INPUT(:SORT_INPUT_LEN)) .EQ. 1) THEN!               KEY = SHS_PAGEFAULT N             ELSE IF (INDEX('CURPRIO',SORT_INPUT(:SORT_INPUT_LEN)) .EQ. 1) THEN               KEY = SHS_CURPRIO              ELSE                KEY = SHS_PHYSICAL             END IF           END IF         ELSE%           CALL LIB$STOP(%VAL(STATUS))          END IF   C / C Check /DESCENDING present in the command line  C # 	STATUS = CLI$PRESENT('DESCENDING') * 	IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN 	  ORDER = SHS_DESCENDING . 	ELSE IF ( STATUS .EQ. %LOC(CLI$_ABSENT)) THEN 	  ORDER = SHS_ASCENDING 	ELSE  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C + C Check /EXTEND present in the command line  C &         STATUS = CLI$PRESENT('EXTEND')M 	IF ( STATUS .EQ. %LOC(CLI$_ABSENT) .OR. STATUS .EQ. %LOC(CLI$_NEGATED)) THEN  	  EXTEND_PRESENT = .FALSE. / 	ELSE IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN  	  EXTEND_PRESENT = .TRUE. 	ELSE  	  CALL LIB$STOP(%VAL(STATUS)) 	END IF    C , C Check /CLUSTER present in the command line C '         STATUS = CLI$PRESENT('CLUSTER') T         IF ( STATUS .EQ. %LOC(CLI$_ABSENT) .OR. STATUS .EQ. %LOC(CLI$_NEGATED)) THEN 	  CLUSTER_PRESENT = .FALSE./ 	ELSE IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THEN  C ? C /CLUSTER present, but is local node a part of local cluster?  ( C If not, then ignore /CLUSTER qualifier C 2           !**************************************** 	  ! Construct And Initialize Syi Itm List2           !***************************************!           SYILIST(1).BUFLEN   = 1 3           SYILIST(1).CODE     = SYI$_CLUSTER_MEMBER 7           SYILIST(1).BUFADR   = %LOC(CLU_MEMBER_STATUS) !           SYILIST(1).RETLENADR= 0  	  SYILIST(2).END_LIST = 0   	  STATUS = SYS$GETSYIW( ,,,
 	2			SYILIST,  	2			SYISTAT,,)  	  IF (.NOT. STATUS) THEN   	    CALL LIB$STOP(%VAL(STATUS))' 	  ELSE IF ( .NOT. SYISTAT.STATUS) THENN  	    CALL LIB$STOP(%VAL(STATUS))	 	  END IF     	  IF ( CLU_MEMBER_STATUS ) THEN 	    CLUSTER_PRESENT = .TRUE.t 	  ELSE  	    CLUSTER_PRESENT = .FALSE.	 	  END IFd
 	END IF	     Cs) C Check /USER present in the command lineA Cp$         STATUS = CLI$PRESENT('USER')0         IF (STATUS .EQ. %LOC(CLI$_PRESENT)) THEN 	  USER_PRESENT = .TRUE.)           STATUS = CLI$GET_VALUE( 'USER', # 	2                        USERNAME,p# 	2                        USER_LEN)	*           IF (STATUS .EQ. SS$_NORMAL) THEN
 	    CONTINUER0 	  ELSE IF ( STATUS .EQ. %LOC(CLI$_ABSENT)) THEN C  C get process owner's username CJ: 	    !****************************************************+ 	    ! Construct & Initialize Jpi Item List : 	    !**************************************************** 	    JPILIST(1).BUFLEN	= 12y$ 	    JPILIST(1).CODE	= JPI$_USERNAME' 	    JPILIST(1).BUFADR	= %LOC(USERNAME)a) 	    JPILIST(1).RETLENADR= %LOC(USER_LEN)o 	    JPILIST(2).END_LIST	= 0   	    STATUS = SYS$GETJPIW( ,,, 	2			 JPILIST, 	2			 JPISTAT,,) 	    IF ( .NOT. STATUS) THEN" 	      CALL LIB$STOP(%VAL(STATUS))) 	    ELSE IF ( .NOT. JPISTAT.STATUS) THENe" 	      CALL LIB$STOP(%VAL(STATUS))             END IF 	  ELSEt  	    CALL LIB$STOP(%VAL(STATUS))           END IF5         ELSE IF ( STATUS .NE. %LOC(CLI$_ABSENT)) THENn%           CALL LIB$STOP(%VAL(STATUS))          END IF   Ci) C Check /NODE present in the command linee Cn 	STATUS = CLI$PRESENT('NODE') ) 	IF ( STATUS .EQ. %LOC(CLI$_ABSENT)) THENL 	  NODE_VALUE_PRESENT = .FALSE.L/ 	ELSE IF ( STATUS .EQ. %LOC(CLI$_PRESENT)) THENEO 	  DO WHILE ( STATUS .EQ. %LOC(CLI$_PRESENT) .OR. STATUS .EQ. %LOC(CLI$_COMMA))_% 	    STATUS = CLI$GET_VALUE ( 'NODE',N 	2			     NODENAME,C 	2			     NODE_LEN)(- 	    IF ( STATUS .EQ. %LOC(CLI$_ABSENT)) THENL CEK C Same as /NOCLUSTER present in command line or /CLUSTER absent in command  ) C line. In both case, use the local node.N CO# 	      NODE_VALUE_PRESENT = .FALSE./M 	    ELSE IF ( STATUS .EQ. %LOC(CLI$_COMMA) .OR. STATUS .EQ. SS$_NORMAL) THEN " 	      NODE_VALUE_PRESENT = .TRUE. CE1 C Bypass if the node is not part of local cluster  C_;  	      !**************************************************N"  	      ! Initialize SYI item list: 	      !**************************************************%               SYILIST(1).BUFLEN   = 1R7               SYILIST(1).CODE     = SYI$_CLUSTER_MEMBER2;               SYILIST(1).BUFADR   = %LOC(CLU_MEMBER_STATUS)N%               SYILIST(1).RETLENADR= 0D 	      SYILIST(2).END_LIST = 0  '     	      RET_STATUS = SYS$GETSYIW( ,,T 	2			    	NODENAME(1:NODE_LEN),R 	2			    	SYILIST, 	2			    	SYISTAT,,)! 	      IF (.NOT. RET_STATUS) THENE2 	        IF ( RET_STATUS .EQ. SS$_NOSUCHNODE) THEN( 		  WRITE (LUN, 10) NODENAME(1:NODE_LEN)@ 10		  FORMAT (1X, / ,1X, '%SYSTEM-F-NOSUCHNODE, remote node /',  	2		A , '/ is unknown')R 		ELSE* 	          CALL LIB$STOP(%VAL(RET_STATUS)) 		END IF+ 	      ELSE IF ( .NOT. SYISTAT.STATUS) THEN , 	        CALL LIB$STOP(%VAL(SYISTAT.STATUS)) 	      ELSE ; 	        !*************************************************T 		! Initialize PSCAN item list4 		!*************************************************  		PSCANLIST(1).BUFLEN	= NODE_LEN% 		PSCANLIST(1).CODE	= PSCAN$_NODENAME	& 		PSCANLIST(1).BUFADR	= %LOC(NODENAME)% 		PSCANLIST(1).ITMFLAGS	= PSCAN$M_EQLH@ 		PSCANLIST(2).BUFLEN 	= LEN(INPUT_PRCNAM(1:INPUT_PRCNAM_LEN+2))& 		PSCANLIST(2).CODE   	= PSCAN$_PRCNAM+ 		PSCANLIST(2).BUFADR 	= %LOC(INPUT_PRCNAM)L* 		PSCANLIST(2).ITMFLAGS	= PSCAN$M_WILDCARDC 		IF (INTER_PRESENT .AND. NETWORK_PRESENT .AND. BATCH_PRESENT) THENN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE ;                   PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVEd4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE 7                   PSCANLIST(4).BUFADR   = JPI$K_NETWORKR4                   PSCANLIST(4).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(5).BUFLEN   = 05                   PSCANLIST(5).CODE     = PSCAN$_MODEN5                   PSCANLIST(5).BUFADR   = JPI$K_BATCHI+                   PSCANLIST(5).ITMFLAGS = 0  		  IF (USER_PRESENT) THEN& 		    PSCANLIST(6).BUFLEN   = USER_LEN+ 		    PSCANLIST(6).CODE	  = PSCAN$_USERNAMES, 		    PSCANLIST(6).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLT 		    PSCANLIST(7).END_LIST = 0N  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0I& 		    PSCANLIST(6).CODE	  = PSCAN$_GRP) 		    PSCANLIST(6).BUFADR   = UIC_2.GROUP)) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLi 		    PSCANLIST(7).END_LIST = 0  		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0 & 		    PSCANLIST(6).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(6).BUFADR   = UIC.UIC_VALUE.) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLW 		    PSCANLIST(7).END_LIST = 0( 		  ELSE 		    PSCANLIST(6).END_LIST = 0T
 		  END IF5  		ELSE IF (INTER_PRESENT .AND. NETWORK_PRESENT) THEND$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEI;                   PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVEU4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE 7                   PSCANLIST(4).BUFADR   = JPI$K_NETWORKS+                   PSCANLIST(4).ITMFLAGS = 0  		  IF (USER_PRESENT) THEN& 		    PSCANLIST(5).BUFLEN   = USER_LEN+ 		    PSCANLIST(5).CODE	  = PSCAN$_USERNAME., 		    PSCANLIST(5).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLH 		    PSCANLIST(6).END_LIST = 0)  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 02& 		    PSCANLIST(5).CODE	  = PSCAN$_GRP) 		    PSCANLIST(5).BUFADR   = UIC_2.GROUPS) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL' 		    PSCANLIST(6).END_LIST = 0U 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0A& 		    PSCANLIST(5).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(5).BUFADR   = UIC.UIC_VALUEE) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL, 		    PSCANLIST(6).END_LIST = 0] 		  ELSE 		    PSCANLIST(5).END_LIST = 0P
 		  END IF2 		ELSE IF (INTER_PRESENT .AND. BATCH_PRESENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEd;                   PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVEX4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODEI5                   PSCANLIST(4).BUFADR   = JPI$K_BATCH +                   PSCANLIST(4).ITMFLAGS = 01 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(5).BUFLEN   = USER_LEN+ 		    PSCANLIST(5).CODE	  = PSCAN$_USERNAMEH, 		    PSCANLIST(5).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(6).END_LIST = 02  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0 & 		    PSCANLIST(5).CODE	  = PSCAN$_GRP) 		    PSCANLIST(5).BUFADR   = UIC_2.GROUPL) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLt 		    PSCANLIST(6).END_LIST = 0t 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0i& 		    PSCANLIST(5).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(5).BUFADR   = UIC.UIC_VALUEs) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL] 		    PSCANLIST(6).END_LIST = 0t 		  ELSE 		    PSCANLIST(5).END_LIST = 0.
 		  END IF4 		ELSE IF (BATCH_PRESENT .AND. NETWORK_PRESENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE 5                   PSCANLIST(3).BUFADR   = JPI$K_BATCH,4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODEs7                   PSCANLIST(4).BUFADR   = JPI$K_NETWORKY+                   PSCANLIST(4).ITMFLAGS = 0  		  IF (USER_PRESENT) THEN& 		    PSCANLIST(5).BUFLEN   = USER_LEN+ 		    PSCANLIST(5).CODE	  = PSCAN$_USERNAMEH, 		    PSCANLIST(5).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL) 		    PSCANLIST(6).END_LIST = 0P  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0F& 		    PSCANLIST(5).CODE	  = PSCAN$_GRP) 		    PSCANLIST(5).BUFADR   = UIC_2.GROUP ) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLU 		    PSCANLIST(6).END_LIST = 0O 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0'& 		    PSCANLIST(5).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(5).BUFADR   = UIC.UIC_VALUEI) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLF 		    PSCANLIST(6).END_LIST = 0	 		  ELSE 		    PSCANLIST(5).END_LIST = 0T
 		  END IF 		ELSE IF (INTER_PRESENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEe;                   PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVE.+                   PSCANLIST(3).ITMFLAGS = 0T 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(4).BUFLEN   = USER_LEN+ 		    PSCANLIST(4).CODE	  = PSCAN$_USERNAME7, 		    PSCANLIST(4).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(5).END_LIST = 0   		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0V& 		    PSCANLIST(4).CODE	  = PSCAN$_GRP) 		    PSCANLIST(4).BUFADR   = UIC_2.GROUP() 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLi 		    PSCANLIST(5).END_LIST = 0S 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0	& 		    PSCANLIST(4).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(4).BUFADR   = UIC.UIC_VALUE ) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLd 		    PSCANLIST(5).END_LIST = 0U 		  ELSE 		    PSCANLIST(4).END_LIST = 0O
 		  END IF 		ELSE IF (BATCH_PRESENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEI5                   PSCANLIST(3).BUFADR   = JPI$K_BATCH	+                   PSCANLIST(3).ITMFLAGS = 0  		  IF (USER_PRESENT) THEN& 		    PSCANLIST(4).BUFLEN   = USER_LEN+ 		    PSCANLIST(4).CODE	  = PSCAN$_USERNAMEJ, 		    PSCANLIST(4).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL2 		    PSCANLIST(5).END_LIST = 0   		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0 & 		    PSCANLIST(4).CODE	  = PSCAN$_GRP) 		    PSCANLIST(4).BUFADR   = UIC_2.GROUP ) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLE 		    PSCANLIST(5).END_LIST = 0T 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0 & 		    PSCANLIST(4).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(4).BUFADR   = UIC.UIC_VALUEd) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(5).END_LIST = 0E 		  ELSE 		    PSCANLIST(4).END_LIST = 0 
 		  END IF  		ELSE IF (NETWORK_PRESENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE_7                   PSCANLIST(3).BUFADR   = JPI$K_NETWORKS+                   PSCANLIST(3).ITMFLAGS = 0U 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(4).BUFLEN   = USER_LEN+ 		    PSCANLIST(4).CODE	  = PSCAN$_USERNAME , 		    PSCANLIST(4).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLn 		    PSCANLIST(5).END_LIST = 0*  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0 & 		    PSCANLIST(4).CODE	  = PSCAN$_GRP) 		    PSCANLIST(4).BUFADR   = UIC_2.GROUP ) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(5).END_LIST = 0  		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0M& 		    PSCANLIST(4).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(4).BUFADR   = UIC.UIC_VALUE)) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL( 		    PSCANLIST(5).END_LIST = 0E 		  ELSE 		    PSCANLIST(4).END_LIST = 0G
 		  END IF8 		ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. NETWORK_ABSENT& 	2	     .AND. .NOT. BATCH_ABSENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEt5                   PSCANLIST(3).BUFADR   = JPI$K_OTHER*+                   PSCANLIST(3).ITMFLAGS = 0T 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(4).BUFLEN   = USER_LEN+ 		    PSCANLIST(4).CODE	  = PSCAN$_USERNAME , 		    PSCANLIST(4).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLM 		    PSCANLIST(5).END_LIST = 0P  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0L& 		    PSCANLIST(4).CODE	  = PSCAN$_GRP) 		    PSCANLIST(4).BUFADR   = UIC_2.GROUPU) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(5).END_LIST = 0( 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(4).BUFLEN   = 0S& 		    PSCANLIST(4).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(4).BUFADR   = UIC.UIC_VALUEU) 		    PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLA 		    PSCANLIST(5).END_LIST = 0D 		  ELSE 		    PSCANLIST(4).END_LIST = 0I
 		  END IF> 		ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. NETWORK_ABSENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEV5                   PSCANLIST(3).BUFADR   = JPI$K_OTHERt4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE%5                   PSCANLIST(4).BUFADR   = JPI$K_BATCHH+                   PSCANLIST(4).ITMFLAGS = 0L 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(5).BUFLEN   = USER_LEN+ 		    PSCANLIST(5).CODE	  = PSCAN$_USERNAMEH, 		    PSCANLIST(5).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLG 		    PSCANLIST(6).END_LIST = 0V  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0N& 		    PSCANLIST(5).CODE	  = PSCAN$_GRP) 		    PSCANLIST(5).BUFADR   = UIC_2.GROUPI) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(6).END_LIST = 0P 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0T& 		    PSCANLIST(5).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(5).BUFADR   = UIC.UIC_VALUES) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLA 		    PSCANLIST(6).END_LIST = 0T 		  ELSE 		    PSCANLIST(5).END_LIST = 0 
 		  END IF< 		ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. BATCH_ABSENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE 5                   PSCANLIST(3).BUFADR   = JPI$K_OTHERO4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE17                   PSCANLIST(4).BUFADR   = JPI$K_NETWORKE+                   PSCANLIST(4).ITMFLAGS = 0. 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(5).BUFLEN   = USER_LEN+ 		    PSCANLIST(5).CODE	  = PSCAN$_USERNAMEH, 		    PSCANLIST(5).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL_ 		    PSCANLIST(6).END_LIST = 0   		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0R& 		    PSCANLIST(5).CODE	  = PSCAN$_GRP) 		    PSCANLIST(5).BUFADR   = UIC_2.GROUP ) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(6).END_LIST = 0F 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0N& 		    PSCANLIST(5).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(5).BUFADR   = UIC.UIC_VALUEN) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLI 		    PSCANLIST(6).END_LIST = 0D 		  ELSE 		    PSCANLIST(5).END_LIST = 0$
 		  END IF> 		ELSE IF (.NOT. BATCH_ABSENT .AND. .NOT. NETWORK_ABSENT) THEN$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODEP5                   PSCANLIST(3).BUFADR   = JPI$K_OTHERO4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE.;                   PSCANLIST(4).BUFADR   = JPI$K_INTERACTIVEh+                   PSCANLIST(4).ITMFLAGS = 0  		  IF (USER_PRESENT) THEN& 		    PSCANLIST(5).BUFLEN   = USER_LEN+ 		    PSCANLIST(5).CODE	  = PSCAN$_USERNAMEE, 		    PSCANLIST(5).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLE 		    PSCANLIST(6).END_LIST = 0s  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0T& 		    PSCANLIST(5).CODE	  = PSCAN$_GRP) 		    PSCANLIST(5).BUFADR   = UIC_2.GROUPt) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL* 		    PSCANLIST(6).END_LIST = 0* 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(5).BUFLEN   = 0 & 		    PSCANLIST(5).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(5).BUFADR   = UIC.UIC_VALUE ) 		    PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLI 		    PSCANLIST(6).END_LIST = 0  		  ELSE 		    PSCANLIST(5).END_LIST = 0T
 		  END IF# 		ELSE IF (.NOT. INTER_ABSENT) THEN$$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE)5                   PSCANLIST(3).BUFADR   = JPI$K_OTHERC4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE 7                   PSCANLIST(4).BUFADR   = JPI$K_NETWORKQ4                   PSCANLIST(4).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(5).BUFLEN   = 05                   PSCANLIST(5).CODE     = PSCAN$_MODE 5                   PSCANLIST(5).BUFADR   = JPI$K_BATCH_+                   PSCANLIST(5).ITMFLAGS = 0A 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(6).BUFLEN   = USER_LEN+ 		    PSCANLIST(6).CODE	  = PSCAN$_USERNAME*, 		    PSCANLIST(6).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL* 		    PSCANLIST(7).END_LIST = 0*  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0E& 		    PSCANLIST(6).CODE	  = PSCAN$_GRP) 		    PSCANLIST(6).BUFADR   = UIC_2.GROUPN) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLA 		    PSCANLIST(7).END_LIST = 0L 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0 & 		    PSCANLIST(6).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(6).BUFADR   = UIC.UIC_VALUET) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLS 		    PSCANLIST(7).END_LIST = 0S 		  ELSE 		    PSCANLIST(6).END_LIST = 0T
 		  END IF# 		ELSE IF (.NOT. BATCH_ABSENT) THENL$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE 5                   PSCANLIST(3).BUFADR   = JPI$K_OTHERC4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE)7                   PSCANLIST(4).BUFADR   = JPI$K_NETWORKE4                   PSCANLIST(4).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(5).BUFLEN   = 05                   PSCANLIST(5).CODE     = PSCAN$_MODE ;                   PSCANLIST(5).BUFADR   = JPI$K_INTERACTIVE +                   PSCANLIST(5).ITMFLAGS = 0A 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(6).BUFLEN   = USER_LEN+ 		    PSCANLIST(6).CODE	  = PSCAN$_USERNAMED, 		    PSCANLIST(6).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(7).END_LIST = 0*  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0!& 		    PSCANLIST(6).CODE	  = PSCAN$_GRP) 		    PSCANLIST(6).BUFADR   = UIC_2.GROUP ) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(7).END_LIST = 0  		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0Y& 		    PSCANLIST(6).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(6).BUFADR   = UIC.UIC_VALUE$) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL) 		    PSCANLIST(7).END_LIST = 0	 		  ELSE 		    PSCANLIST(6).END_LIST = 0E
 		  END IF% 		ELSE IF (.NOT. NETWORK_ABSENT) THENH$ 	          PSCANLIST(3).BUFLEN   = 05                   PSCANLIST(3).CODE     = PSCAN$_MODE 5                   PSCANLIST(3).BUFADR   = JPI$K_OTHER 4                   PSCANLIST(3).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(4).BUFLEN   = 05                   PSCANLIST(4).CODE     = PSCAN$_MODE ;                   PSCANLIST(4).BUFADR   = JPI$K_INTERACTIVE*4                   PSCANLIST(4).ITMFLAGS = PSCAN$M_OR$ 	          PSCANLIST(5).BUFLEN   = 05                   PSCANLIST(5).CODE     = PSCAN$_MODE	5                   PSCANLIST(5).BUFADR   = JPI$K_BATCHM+                   PSCANLIST(5).ITMFLAGS = 0	 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(6).BUFLEN   = USER_LEN+ 		    PSCANLIST(6).CODE	  = PSCAN$_USERNAMES, 		    PSCANLIST(6).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLE 		    PSCANLIST(7).END_LIST = 0A  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0 & 		    PSCANLIST(6).CODE	  = PSCAN$_GRP) 		    PSCANLIST(6).BUFADR   = UIC_2.GROUPB) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		    PSCANLIST(7).END_LIST = 0$ 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(6).BUFLEN   = 0A& 		    PSCANLIST(6).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(6).BUFADR   = UIC.UIC_VALUEW) 		    PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLG 		    PSCANLIST(7).END_LIST = 0I 		  ELSE 		    PSCANLIST(6).END_LIST = 0L
 		  END IF 		ELSE 		  IF (USER_PRESENT) THEN& 		    PSCANLIST(3).BUFLEN   = USER_LEN+ 		    PSCANLIST(3).CODE	  = PSCAN$_USERNAME , 		    PSCANLIST(3).BUFADR   = %LOC(USERNAME)) 		    PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLD 		    PSCANLIST(4).END_LIST = 0A  		  ELSE IF (GROUP_PRESENT) THEN 		    PSCANLIST(3).BUFLEN   = 0S& 		    PSCANLIST(3).CODE	  = PSCAN$_GRP) 		    PSCANLIST(3).BUFADR   = UIC_2.GROUP ) 		    PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLS 		    PSCANLIST(4).END_LIST = 0S 		  ELSE IF (UIC_PRESENT) THEN 		    PSCANLIST(3).BUFLEN   = 0 & 		    PSCANLIST(3).CODE	  = PSCAN$_UIC+ 		    PSCANLIST(3).BUFADR   = UIC.UIC_VALUE ) 		    PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL( 		    PSCANLIST(4).END_LIST = 0A 		  ELSE 		    PSCANLIST(3).END_LIST = 0S
 		  END IF 		END IF 		2   	        RET_STATUS = SYS$PROCESS_SCAN( CONTEXT, 	2				     PSCANLIST)D  > 	        IF (.NOT. RET_STATUS) CALL LIB$STOP(%VAL(RET_STATUS))  +   	        IF ( .NOT. EXTEND_PRESENT) THEN	= 	          CALL GETJPI_BASIC	( 	        ELSE  		  CALL GETJPI_EXTEND 	        END IF) 	      END IF		_	 	    ELSEU" 	      CALL LIB$STOP(%VAL(STATUS)) 	    END IF$	 	  END DO  	ELSEC 	  CALL LIB$STOP(%VAL(STATUS)) 	END IF  	A  	IF ( CLUSTER_PRESENT ) THEN  		+ 	  !***************************************$/ 	  ! Construct And Initialize Syi Itm List	    G+ 	  !***************************************A-        	  SYILIST(1).BUFLEN   = LEN(NODENAME))& 	  SYILIST(1).CODE     = SYI$_NODENAME' 	  SYILIST(1).BUFADR   = %LOC(NODENAME)S' 	  SYILIST(1).RETLENADR= %LOC(NODE_LEN) !           SYILIST(2).END_LIST = 0E   	  NOMORE_NODE = .FALSE.    	  DO WHILE ( .NOT. NOMORE_NODE) 	    STATUS = SYS$GETSYIW( , 	2			  CSID,,		L 	2			  SYILIST,  	2			  SYISTAT,,)    	    IF ( .NOT. STATUS ) THENQ+ 	      IF (STATUS .NE. SS$_NOMORENODE) THENE$ 	        CALL LIB$STOP(%VAL(STATUS)) 	      ELSE  		NOMORE_NODE = .TRUE.
 	      END IF$) 	    ELSE IF ( .NOT. SYISTAT.STATUS) THEN_* 	      CALL LIB$STOP(%VAL(SYISTAT.STATUS))	 	    ELSE 2 	      !******************************************1 	      ! Construct And Initialize Pscan Item ListP2 	      !******************************************& 	      PSCANLIST(1).BUFLEN  = NODE_LEN- 	      PSCANLIST(1).CODE	   = PSCAN$_NODENAME , 	      PSCANLIST(1).BUFADR  = %LOC(NODENAME)) 	      PSCANLIST(1).ITMFLAGS= PSCAN$M_EQL E 	      PSCANLIST(2).BUFLEN  = LEN(INPUT_PRCNAM(1:INPUT_PRCNAM_LEN+2))S+ 	      PSCANLIST(2).CODE    = PSCAN$_PRCNAM 0 	      PSCANLIST(2).BUFADR  = %LOC(INPUT_PRCNAM). 	      PSCANLIST(2).ITMFLAGS= PSCAN$M_WILDCARD 		H 	      IF (INTER_PRESENT .AND. NETWORK_PRESENT .AND. BATCH_PRESENT) THEN" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODES9                 PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVE 2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE 5                 PSCANLIST(4).BUFADR   = JPI$K_NETWORKt2                 PSCANLIST(4).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(5).BUFLEN   = 03                 PSCANLIST(5).CODE     = PSCAN$_MODE 3                 PSCANLIST(5).BUFADR   = JPI$K_BATCHS)                 PSCANLIST(5).ITMFLAGS = 0S 		IF (USER_PRESENT) THEN* 	          PSCANLIST(6).BUFLEN  = USER_LEN1 	          PSCANLIST(6).CODE    = PSCAN$_USERNAMEP0 	          PSCANLIST(6).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(6).ITMFLAGS= PSCAN$M_EQLA# 	          PSCANLIST(7).END_LIST= 0( 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0L" 		  PSCANLIST(6).CODE	= PSCAN$_GRP' 		  PSCANLIST(6).BUFADR   = UIC_2.GROUPA' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(7).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0 " 		  PSCANLIST(6).CODE	= PSCAN$_UIC) 		  PSCANLIST(6).BUFADR   = UIC.UIC_VALUEA' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(7).END_LIST = 0E 		ELSE 		  PSCANLIST(6).END_LIST= 0 		END IF:  	      ELSE IF (INTER_PRESENT .AND. NETWORK_PRESENT) THEN" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODE 9                 PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVEI2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE)5                 PSCANLIST(4).BUFADR   = JPI$K_NETWORK.)                 PSCANLIST(4).ITMFLAGS = 0S 		IF (USER_PRESENT) THEN* 	          PSCANLIST(5).BUFLEN  = USER_LEN1 	          PSCANLIST(5).CODE    = PSCAN$_USERNAMEE0 	          PSCANLIST(5).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(5).ITMFLAGS= PSCAN$M_EQL$# 	          PSCANLIST(6).END_LIST= 0) 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0I" 		  PSCANLIST(5).CODE	= PSCAN$_GRP' 		  PSCANLIST(5).BUFADR   = UIC_2.GROUPL' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLE 		  PSCANLIST(6).END_LIST = 0D 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0Q" 		  PSCANLIST(5).CODE	= PSCAN$_UIC) 		  PSCANLIST(5).BUFADR   = UIC.UIC_VALUES' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL( 		  PSCANLIST(6).END_LIST = 0S 		ELSE 		  PSCANLIST(5).END_LIST= 0 		END IF7 	      ELSE IF (INTER_PRESENT .AND. BATCH_PRESENT) THENS" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODE(9                 PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVEI2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODEF3                 PSCANLIST(4).BUFADR   = JPI$K_BATCHT)                 PSCANLIST(4).ITMFLAGS = 0S 		IF (USER_PRESENT) THEN* 	          PSCANLIST(5).BUFLEN  = USER_LEN1 	          PSCANLIST(5).CODE    = PSCAN$_USERNAMEL0 	          PSCANLIST(5).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(5).ITMFLAGS= PSCAN$M_EQLC# 	          PSCANLIST(6).END_LIST= 0L 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0 " 		  PSCANLIST(5).CODE	= PSCAN$_GRP' 		  PSCANLIST(5).BUFADR   = UIC_2.GROUPH' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(6).END_LIST = 0G 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0S" 		  PSCANLIST(5).CODE	= PSCAN$_UIC) 		  PSCANLIST(5).BUFADR   = UIC.UIC_VALUEC' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(6).END_LIST = 0	 		ELSE 		  PSCANLIST(5).END_LIST= 0 		END IF9 	      ELSE IF (BATCH_PRESENT .AND. NETWORK_PRESENT) THEN	" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODE	3                 PSCANLIST(3).BUFADR   = JPI$K_BATCH32                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE 5                 PSCANLIST(4).BUFADR   = JPI$K_NETWORK )                 PSCANLIST(4).ITMFLAGS = 0N 		IF (USER_PRESENT) THEN* 	          PSCANLIST(5).BUFLEN  = USER_LEN1 	          PSCANLIST(5).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(5).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(5).ITMFLAGS= PSCAN$M_EQLS# 	          PSCANLIST(6).END_LIST= 0) 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0 " 		  PSCANLIST(5).CODE	= PSCAN$_GRP' 		  PSCANLIST(5).BUFADR   = UIC_2.GROUP ' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLS 		  PSCANLIST(6).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0 " 		  PSCANLIST(5).CODE	= PSCAN$_UIC) 		  PSCANLIST(5).BUFADR   = UIC.UIC_VALUE)' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL( 		  PSCANLIST(6).END_LIST = 0	 		ELSE 		  PSCANLIST(5).END_LIST= 0 		END IF# 	      ELSE IF (INTER_PRESENT) THENE" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODE 9                 PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVE$)                 PSCANLIST(3).ITMFLAGS = 0M 		IF (USER_PRESENT) THEN* 	          PSCANLIST(4).BUFLEN  = USER_LEN1 	          PSCANLIST(4).CODE    = PSCAN$_USERNAMEM0 	          PSCANLIST(4).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(4).ITMFLAGS= PSCAN$M_EQL # 	          PSCANLIST(5).END_LIST= 0E 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0 " 		  PSCANLIST(4).CODE	= PSCAN$_GRP' 		  PSCANLIST(4).BUFADR   = UIC_2.GROUPU' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLQ 		  PSCANLIST(5).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0E" 		  PSCANLIST(4).CODE	= PSCAN$_UIC) 		  PSCANLIST(4).BUFADR   = UIC.UIC_VALUE ' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLG 		  PSCANLIST(5).END_LIST = 0S 		ELSE 		  PSCANLIST(4).END_LIST= 0 		END IF# 	      ELSE IF (BATCH_PRESENT) THEN " 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODE03                 PSCANLIST(3).BUFADR   = JPI$K_BATCHD)                 PSCANLIST(3).ITMFLAGS = 0  		IF (USER_PRESENT) THEN* 	          PSCANLIST(4).BUFLEN  = USER_LEN1 	          PSCANLIST(4).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(4).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(4).ITMFLAGS= PSCAN$M_EQL # 	          PSCANLIST(5).END_LIST= 0G 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0 " 		  PSCANLIST(4).CODE	= PSCAN$_GRP' 		  PSCANLIST(4).BUFADR   = UIC_2.GROUPB' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL( 		  PSCANLIST(5).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0N" 		  PSCANLIST(4).CODE	= PSCAN$_UIC) 		  PSCANLIST(4).BUFADR   = UIC.UIC_VALUE ' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL	 		  PSCANLIST(5).END_LIST = 0A 		ELSE 		  PSCANLIST(4).END_LIST= 0 		END IF% 	      ELSE IF (NETWORK_PRESENT) THENL" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODE 5                 PSCANLIST(3).BUFADR   = JPI$K_NETWORK_)                 PSCANLIST(3).ITMFLAGS = 0  		IF (USER_PRESENT) THEN* 	          PSCANLIST(4).BUFLEN  = USER_LEN1 	          PSCANLIST(4).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(4).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(4).ITMFLAGS= PSCAN$M_EQL # 	          PSCANLIST(5).END_LIST= 0T 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0 " 		  PSCANLIST(4).CODE	= PSCAN$_GRP' 		  PSCANLIST(4).BUFADR   = UIC_2.GROUPS' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL) 		  PSCANLIST(5).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0T" 		  PSCANLIST(4).CODE	= PSCAN$_UIC) 		  PSCANLIST(4).BUFADR   = UIC.UIC_VALUEA' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(5).END_LIST = 0S 		ELSE 		  PSCANLIST(4).END_LIST= 0 		END IF= 	      ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. NETWORK_ABSENTS$ 	2	   .AND. .NOT. BATCH_ABSENT) THEN" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODEL3                 PSCANLIST(3).BUFADR   = JPI$K_OTHER )                 PSCANLIST(3).ITMFLAGS = 0L 		IF (USER_PRESENT) THEN* 	          PSCANLIST(4).BUFLEN  = USER_LEN1 	          PSCANLIST(4).CODE    = PSCAN$_USERNAMES0 	          PSCANLIST(4).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(4).ITMFLAGS= PSCAN$M_EQLL# 	          PSCANLIST(5).END_LIST= 0. 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0N" 		  PSCANLIST(4).CODE	= PSCAN$_GRP' 		  PSCANLIST(4).BUFADR   = UIC_2.GROUP ' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(5).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(4).BUFLEN   = 0U" 		  PSCANLIST(4).CODE	= PSCAN$_UIC) 		  PSCANLIST(4).BUFADR   = UIC.UIC_VALUE ' 		  PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLA 		  PSCANLIST(5).END_LIST = 0L 		ELSE 		  PSCANLIST(4).END_LIST= 0 		END IFC 	      ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. NETWORK_ABSENT) THEN " 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODEG3                 PSCANLIST(3).BUFADR   = JPI$K_OTHER	2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE.3                 PSCANLIST(4).BUFADR   = JPI$K_BATCH	)                 PSCANLIST(4).ITMFLAGS = 0  		IF (USER_PRESENT) THEN* 	          PSCANLIST(5).BUFLEN  = USER_LEN1 	          PSCANLIST(5).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(5).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(5).ITMFLAGS= PSCAN$M_EQL	# 	          PSCANLIST(6).END_LIST= 0  		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0 " 		  PSCANLIST(5).CODE	= PSCAN$_GRP' 		  PSCANLIST(5).BUFADR   = UIC_2.GROUPM' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLD 		  PSCANLIST(6).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0T" 		  PSCANLIST(5).CODE	= PSCAN$_UIC) 		  PSCANLIST(5).BUFADR   = UIC.UIC_VALUE ' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL_ 		  PSCANLIST(6).END_LIST = 0A 		ELSE 		  PSCANLIST(5).END_LIST= 0 		END IFA 	      ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. BATCH_ABSENT) THENA" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODEL3                 PSCANLIST(3).BUFADR   = JPI$K_OTHER 2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODES5                 PSCANLIST(4).BUFADR   = JPI$K_NETWORKS)                 PSCANLIST(4).ITMFLAGS = 0	 		IF (USER_PRESENT) THEN* 	          PSCANLIST(5).BUFLEN  = USER_LEN1 	          PSCANLIST(5).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(5).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(5).ITMFLAGS= PSCAN$M_EQL # 	          PSCANLIST(6).END_LIST= 0  		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0F" 		  PSCANLIST(5).CODE	= PSCAN$_GRP' 		  PSCANLIST(5).BUFADR   = UIC_2.GROUPA' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLS 		  PSCANLIST(6).END_LIST = 0N 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0I" 		  PSCANLIST(5).CODE	= PSCAN$_UIC) 		  PSCANLIST(5).BUFADR   = UIC.UIC_VALUE ' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL$ 		  PSCANLIST(6).END_LIST = 0A 		ELSE 		  PSCANLIST(5).END_LIST= 0 		END IFC 	      ELSE IF (.NOT. BATCH_ABSENT .AND. .NOT. NETWORK_ABSENT) THEN$" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODEL3                 PSCANLIST(3).BUFADR   = JPI$K_OTHER.2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE 9                 PSCANLIST(4).BUFADR   = JPI$K_INTERACTIVEH)                 PSCANLIST(4).ITMFLAGS = 0  		IF (USER_PRESENT) THEN* 	          PSCANLIST(5).BUFLEN  = USER_LEN1 	          PSCANLIST(5).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(5).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(5).ITMFLAGS= PSCAN$M_EQL(# 	          PSCANLIST(6).END_LIST= 0C 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0 " 		  PSCANLIST(5).CODE	= PSCAN$_GRP' 		  PSCANLIST(5).BUFADR   = UIC_2.GROUP ' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLA 		  PSCANLIST(6).END_LIST = 0S 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(5).BUFLEN   = 0 " 		  PSCANLIST(5).CODE	= PSCAN$_UIC) 		  PSCANLIST(5).BUFADR   = UIC.UIC_VALUEE' 		  PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL) 		  PSCANLIST(6).END_LIST = 0L 		ELSE 		  PSCANLIST(5).END_LIST= 0 		END IF( 	      ELSE IF (.NOT. INTER_ABSENT) THEN" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODET3                 PSCANLIST(3).BUFADR   = JPI$K_OTHER$2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE 5                 PSCANLIST(4).BUFADR   = JPI$K_NETWORKL2                 PSCANLIST(4).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(5).BUFLEN   = 03                 PSCANLIST(5).CODE     = PSCAN$_MODE)3                 PSCANLIST(5).BUFADR   = JPI$K_BATCH()                 PSCANLIST(5).ITMFLAGS = 0N 		IF (USER_PRESENT) THEN* 	          PSCANLIST(6).BUFLEN  = USER_LEN1 	          PSCANLIST(6).CODE    = PSCAN$_USERNAMEC0 	          PSCANLIST(6).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(6).ITMFLAGS= PSCAN$M_EQLE# 	          PSCANLIST(7).END_LIST= 0L 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0	" 		  PSCANLIST(6).CODE	= PSCAN$_GRP' 		  PSCANLIST(6).BUFADR   = UIC_2.GROUP$' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(7).END_LIST = 0  		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0 " 		  PSCANLIST(6).CODE	= PSCAN$_UIC) 		  PSCANLIST(6).BUFADR   = UIC.UIC_VALUEM' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLE 		  PSCANLIST(7).END_LIST = 0S 		ELSE 		  PSCANLIST(6).END_LIST= 0 		END IF( 	      ELSE IF (.NOT. BATCH_ABSENT) THEN" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODEB3                 PSCANLIST(3).BUFADR   = JPI$K_OTHER 2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODE	5                 PSCANLIST(4).BUFADR   = JPI$K_NETWORKU2                 PSCANLIST(4).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(5).BUFLEN   = 03                 PSCANLIST(5).CODE     = PSCAN$_MODE 9                 PSCANLIST(5).BUFADR   = JPI$K_INTERACTIVES)                 PSCANLIST(5).ITMFLAGS = 0L 		IF (USER_PRESENT) THEN* 	          PSCANLIST(6).BUFLEN  = USER_LEN1 	          PSCANLIST(6).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(6).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(6).ITMFLAGS= PSCAN$M_EQL # 	          PSCANLIST(7).END_LIST= 0P 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0N" 		  PSCANLIST(6).CODE	= PSCAN$_GRP' 		  PSCANLIST(6).BUFADR   = UIC_2.GROUP ' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLS 		  PSCANLIST(7).END_LIST = 0T 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0A" 		  PSCANLIST(6).CODE	= PSCAN$_UIC) 		  PSCANLIST(6).BUFADR   = UIC.UIC_VALUE*' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQLA 		  PSCANLIST(7).END_LIST = 0G 		ELSE 		  PSCANLIST(6).END_LIST= 0 		END IF* 	      ELSE IF (.NOT. NETWORK_ABSENT) THEN" 	        PSCANLIST(3).BUFLEN   = 03                 PSCANLIST(3).CODE     = PSCAN$_MODES3                 PSCANLIST(3).BUFADR   = JPI$K_OTHERS2                 PSCANLIST(3).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(4).BUFLEN   = 03                 PSCANLIST(4).CODE     = PSCAN$_MODEI9                 PSCANLIST(4).BUFADR   = JPI$K_INTERACTIVEQ2                 PSCANLIST(4).ITMFLAGS = PSCAN$M_OR" 	        PSCANLIST(5).BUFLEN   = 03                 PSCANLIST(5).CODE     = PSCAN$_MODE 3                 PSCANLIST(5).BUFADR   = JPI$K_BATCH )                 PSCANLIST(5).ITMFLAGS = 0  		IF (USER_PRESENT) THEN* 	          PSCANLIST(6).BUFLEN  = USER_LEN1 	          PSCANLIST(6).CODE    = PSCAN$_USERNAME*0 	          PSCANLIST(6).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(6).ITMFLAGS= PSCAN$M_EQLE# 	          PSCANLIST(7).END_LIST= 0I 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0S" 		  PSCANLIST(6).CODE	= PSCAN$_GRP' 		  PSCANLIST(6).BUFADR   = UIC_2.GROUP+' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL$ 		  PSCANLIST(7).END_LIST = 0U 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(6).BUFLEN   = 0A" 		  PSCANLIST(6).CODE	= PSCAN$_UIC) 		  PSCANLIST(6).BUFADR   = UIC.UIC_VALUEE' 		  PSCANLIST(6).ITMFLAGS = PSCAN$M_EQL  		  PSCANLIST(7).END_LIST = 0( 		ELSE 		  PSCANLIST(6).END_LIST= 0 		END IF 	      ELSED 		IF (USER_PRESENT) THEN* 	          PSCANLIST(3).BUFLEN  = USER_LEN1 	          PSCANLIST(3).CODE    = PSCAN$_USERNAME 0 	          PSCANLIST(3).BUFADR  = %LOC(USERNAME)- 	          PSCANLIST(3).ITMFLAGS= PSCAN$M_EQLR# 	          PSCANLIST(4).END_LIST= 0L 		ELSE IF (GROUP_PRESENT) THEN 		  PSCANLIST(3).BUFLEN   = 0 " 		  PSCANLIST(3).CODE	= PSCAN$_GRP' 		  PSCANLIST(3).BUFADR   = UIC_2.GROUPD' 		  PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLL 		  PSCANLIST(4).END_LIST = 0R 		ELSE IF (UIC_PRESENT) THEN 		  PSCANLIST(3).BUFLEN   = 0 " 		  PSCANLIST(3).CODE	= PSCAN$_UIC) 		  PSCANLIST(3).BUFADR   = UIC.UIC_VALUER' 		  PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL6 		  PSCANLIST(4).END_LIST = 0  		ELSE 		  PSCANLIST(3).END_LIST= 0 		END IF
 	      END IF   * 	      STATUS = SYS$PROCESS_SCAN( CONTEXT, 	2				 PSCANLIST)P  4 	      IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS)) 	)' 	      IF ( .NOT. EXTEND_PRESENT) THEN	) 	        CALL GETJPI_BASIC	C 	      ELSE  		CALL GETJPI_EXTEND 	      END IF	 	    END IFC	 	  END DO$ 	ELSE ' 	  IF ( .NOT. NODE_VALUE_PRESENT ) THEN  C H C /CLUSTER not present, or nor does /NODE, or nor does node value list, # C so get local nodename as default N CF: 	    !****************************************************1 	    ! Construct And Initialize Syi Itm List	     : 	    !****************************************************( 	    SYILIST(1).BUFLEN	  = LEN(NODENAME)& 	    SYILIST(1).CODE	  = SYI$_NODENAME) 	    SYILIST(1).BUFADR	  = %LOC(NODENAME)0+ 	    SYILIST(1).RETLENADR  = %LOC(NODE_LEN)A%             SYILIST(2).END_LIST   = 0B   	    STATUS = SYS$GETSYIW(,,,		  	2		       	SYILIST, 	2		       	SYISTAT,,)   	    IF ( .NOT. STATUS ) THENT" 	      CALL LIB$STOP(%VAL(STATUS))) 	    ELSE IF ( .NOT. SYISTAT.STATUS) THEN * 	      CALL LIB$STOP(%VAL(SYISTAT.STATUS))             END IF  / 	    !*****************************************6- 	    ! Construct & initialize Pscan Item List / 	    !*****************************************CD 	    PSCANLIST(1).BUFLEN   = LEN(INPUT_PRCNAM(1:INPUT_PRCNAM_LEN+2))* 	    PSCANLIST(1).CODE     = PSCAN$_PRCNAM/ 	    PSCANLIST(1).BUFADR   = %LOC(INPUT_PRCNAM) - 	    PSCANLIST(1).ITMFLAGS = PSCAN$M_WILDCARD)  F 	    IF (INTER_PRESENT .AND. NETWORK_PRESENT .AND. BATCH_PRESENT) THEN  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE(7               PSCANLIST(2).BUFADR   = JPI$K_INTERACTIVEA0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODEA3               PSCANLIST(3).BUFADR   = JPI$K_NETWORK 0               PSCANLIST(3).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(4).BUFLEN   = 01               PSCANLIST(4).CODE     = PSCAN$_MODE 1               PSCANLIST(4).BUFADR   = JPI$K_BATCH '               PSCANLIST(4).ITMFLAGS = 0F 	      IF (USER_PRESENT) THEN " 		PSCANLIST(5).BUFLEN   = USER_LEN) 		PSCANLIST(5).CODE     = PSCAN$_USERNAMEN( 		PSCANLIST(5).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLT 		PSCANLIST(6).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THENI 		PSCANLIST(5).BUFLEN   = 0S$ 		PSCANLIST(5).CODE     = PSCAN$_GRP% 		PSCANLIST(5).BUFADR   = UIC_2.GROUP)% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL( 		PSCANLIST(6).END_LIST = 0	! 	      ELSE IF (UIC_PRESENT) THENE 		PSCANLIST(5).BUFLEN   = 0S$ 		PSCANLIST(5).CODE     = PSCAN$_UIC' 		PSCANLIST(5).BUFADR   = UIC.UIC_VALUEB% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL( 		PSCANLIST(6).END_LIST = 0	 	      ELSE)# 		PSCANLIST(5).END_LIST = 0	       (
 	      END IF 8  	    ELSE IF (INTER_PRESENT .AND. NETWORK_PRESENT) THEN  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE 7               PSCANLIST(2).BUFADR   = JPI$K_INTERACTIVEP0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODE 3               PSCANLIST(3).BUFADR   = JPI$K_NETWORK '               PSCANLIST(3).ITMFLAGS = 0L 	      IF (USER_PRESENT) THENR" 		PSCANLIST(4).BUFLEN   = USER_LEN) 		PSCANLIST(4).CODE     = PSCAN$_USERNAMET( 		PSCANLIST(4).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0A# 	      ELSE IF (GROUP_PRESENT) THENT 		PSCANLIST(4).BUFLEN   = 0G$ 		PSCANLIST(4).CODE     = PSCAN$_GRP% 		PSCANLIST(4).BUFADR   = UIC_2.GROUPS% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLI 		PSCANLIST(5).END_LIST = 0I! 	      ELSE IF (UIC_PRESENT) THENS 		PSCANLIST(4).BUFLEN   = 0 $ 		PSCANLIST(4).CODE     = PSCAN$_UIC' 		PSCANLIST(4).BUFADR   = UIC.UIC_VALUEA% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL. 		PSCANLIST(5).END_LIST = 0I 	      ELSEA 		PSCANLIST(4).END_LIST = 0D
 	      END IFL5 	    ELSE IF (INTER_PRESENT .AND. BATCH_PRESENT) THEN   	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODES7               PSCANLIST(2).BUFADR   = JPI$K_INTERACTIVE)0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODE 1               PSCANLIST(3).BUFADR   = JPI$K_BATCHU'               PSCANLIST(3).ITMFLAGS = 0  	      IF (USER_PRESENT) THENC" 		PSCANLIST(4).BUFLEN   = USER_LEN) 		PSCANLIST(4).CODE     = PSCAN$_USERNAMEI( 		PSCANLIST(4).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLS 		PSCANLIST(5).END_LIST = 0F# 	      ELSE IF (GROUP_PRESENT) THEN) 		PSCANLIST(4).BUFLEN   = 0 $ 		PSCANLIST(4).CODE     = PSCAN$_GRP% 		PSCANLIST(4).BUFADR   = UIC_2.GROUPF% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLA 		PSCANLIST(5).END_LIST = 0D! 	      ELSE IF (UIC_PRESENT) THEN( 		PSCANLIST(4).BUFLEN   = 0	$ 		PSCANLIST(4).CODE     = PSCAN$_UIC' 		PSCANLIST(4).BUFADR   = UIC.UIC_VALUE % 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 00 	      ELSE  		PSCANLIST(4).END_LIST = 0S
 	      END IF 7 	    ELSE IF (BATCH_PRESENT .AND. NETWORK_PRESENT) THEN   	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE.1               PSCANLIST(2).BUFADR   = JPI$K_BATCH 0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODEI3               PSCANLIST(3).BUFADR   = JPI$K_NETWORK	'               PSCANLIST(3).ITMFLAGS = 0S 	      IF (USER_PRESENT) THENA" 		PSCANLIST(4).BUFLEN   = USER_LEN) 		PSCANLIST(4).CODE     = PSCAN$_USERNAME ( 		PSCANLIST(4).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0	# 	      ELSE IF (GROUP_PRESENT) THEN  		PSCANLIST(4).BUFLEN   = 0L$ 		PSCANLIST(4).CODE     = PSCAN$_GRP% 		PSCANLIST(4).BUFADR   = UIC_2.GROUPS% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0E! 	      ELSE IF (UIC_PRESENT) THEN= 		PSCANLIST(4).BUFLEN   = 0($ 		PSCANLIST(4).CODE     = PSCAN$_UIC' 		PSCANLIST(4).BUFADR   = UIC.UIC_VALUER% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLG 		PSCANLIST(5).END_LIST = 0H 	      ELSE  		PSCANLIST(4).END_LIST = 0L
 	      END IFP! 	    ELSE IF (INTER_PRESENT) THENM  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODES7               PSCANLIST(2).BUFADR   = JPI$K_INTERACTIVEL'               PSCANLIST(2).ITMFLAGS = 0( 	      IF (USER_PRESENT) THEN(" 		PSCANLIST(3).BUFLEN   = USER_LEN) 		PSCANLIST(3).CODE     = PSCAN$_USERNAME)( 		PSCANLIST(3).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(4).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THEN$ 		PSCANLIST(3).BUFLEN   = 0 $ 		PSCANLIST(3).CODE     = PSCAN$_GRP% 		PSCANLIST(3).BUFADR   = UIC_2.GROUP)% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL) 		PSCANLIST(4).END_LIST = 0 ! 	      ELSE IF (UIC_PRESENT) THEN. 		PSCANLIST(3).BUFLEN   = 0A$ 		PSCANLIST(3).CODE     = PSCAN$_UIC' 		PSCANLIST(3).BUFADR   = UIC.UIC_VALUE % 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(4).END_LIST = 0B 	      ELSE$ 		PSCANLIST(3).END_LIST = 0A
 	      END IFG! 	    ELSE IF (BATCH_PRESENT) THEN   	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODEE1               PSCANLIST(2).BUFADR   = JPI$K_BATCHN'               PSCANLIST(2).ITMFLAGS = 0S 	      IF (USER_PRESENT) THENT" 		PSCANLIST(3).BUFLEN   = USER_LEN) 		PSCANLIST(3).CODE     = PSCAN$_USERNAMEN( 		PSCANLIST(3).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL	 		PSCANLIST(4).END_LIST = 0A# 	      ELSE IF (GROUP_PRESENT) THEN  		PSCANLIST(3).BUFLEN   = 0H$ 		PSCANLIST(3).CODE     = PSCAN$_GRP% 		PSCANLIST(3).BUFADR   = UIC_2.GROUPS% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL	 		PSCANLIST(4).END_LIST = 0A! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(3).BUFLEN   = 0)$ 		PSCANLIST(3).CODE     = PSCAN$_UIC' 		PSCANLIST(3).BUFADR   = UIC.UIC_VALUEA% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLL 		PSCANLIST(4).END_LIST = 0A 	      ELSE  		PSCANLIST(3).END_LIST = 0 
 	      END IF(# 	    ELSE IF (NETWORK_PRESENT) THEN   	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE 3               PSCANLIST(2).BUFADR   = JPI$K_NETWORK '               PSCANLIST(2).ITMFLAGS = 0C 	      IF (USER_PRESENT) THEN)" 		PSCANLIST(3).BUFLEN   = USER_LEN) 		PSCANLIST(3).CODE     = PSCAN$_USERNAMER( 		PSCANLIST(3).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL. 		PSCANLIST(4).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THEN_ 		PSCANLIST(3).BUFLEN   = 0.$ 		PSCANLIST(3).CODE     = PSCAN$_GRP% 		PSCANLIST(3).BUFADR   = UIC_2.GROUP % 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(4).END_LIST = 0.! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(3).BUFLEN   = 0)$ 		PSCANLIST(3).CODE     = PSCAN$_UIC' 		PSCANLIST(3).BUFADR   = UIC.UIC_VALUE	% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLS 		PSCANLIST(4).END_LIST = 0_ 	      ELSES 		PSCANLIST(3).END_LIST = 0_
 	      END IFL; 	    ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. NETWORK_ABSENT	" 	2	 .AND. .NOT. BATCH_ABSENT) THEN  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE 1               PSCANLIST(2).BUFADR   = JPI$K_OTHER '               PSCANLIST(2).ITMFLAGS = 0E 	      IF (USER_PRESENT) THEN)" 		PSCANLIST(3).BUFLEN   = USER_LEN) 		PSCANLIST(3).CODE     = PSCAN$_USERNAMEA( 		PSCANLIST(3).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLE 		PSCANLIST(4).END_LIST = 0L# 	      ELSE IF (GROUP_PRESENT) THENE 		PSCANLIST(3).BUFLEN   = 0T$ 		PSCANLIST(3).CODE     = PSCAN$_GRP% 		PSCANLIST(3).BUFADR   = UIC_2.GROUP % 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLE 		PSCANLIST(4).END_LIST = 05! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(3).BUFLEN   = 0	$ 		PSCANLIST(3).CODE     = PSCAN$_UIC' 		PSCANLIST(3).BUFADR   = UIC.UIC_VALUEC% 		PSCANLIST(3).ITMFLAGS = PSCAN$M_EQLD 		PSCANLIST(4).END_LIST = 0L 	      ELSEG 		PSCANLIST(3).END_LIST = 0S
 	      END IF A 	    ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. NETWORK_ABSENT) THEN	  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODEA1               PSCANLIST(2).BUFADR   = JPI$K_OTHERE0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODE 1               PSCANLIST(3).BUFADR   = JPI$K_BATCHA'               PSCANLIST(3).ITMFLAGS = 0  	      IF (USER_PRESENT) THEN " 		PSCANLIST(4).BUFLEN   = USER_LEN) 		PSCANLIST(4).CODE     = PSCAN$_USERNAMEN( 		PSCANLIST(4).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THEN  		PSCANLIST(4).BUFLEN   = 0 $ 		PSCANLIST(4).CODE     = PSCAN$_GRP% 		PSCANLIST(4).BUFADR   = UIC_2.GROUP % 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLM 		PSCANLIST(5).END_LIST = 0U! 	      ELSE IF (UIC_PRESENT) THENP 		PSCANLIST(4).BUFLEN   = 0_$ 		PSCANLIST(4).CODE     = PSCAN$_UIC' 		PSCANLIST(4).BUFADR   = UIC.UIC_VALUE % 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLS 		PSCANLIST(5).END_LIST = 0S 	      ELSEF 		PSCANLIST(4).END_LIST = 0A
 	      END IFG? 	    ELSE IF (.NOT. INTER_ABSENT .AND. .NOT. BATCH_ABSENT) THENP  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE 1               PSCANLIST(2).BUFADR   = JPI$K_OTHERS0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODEE3               PSCANLIST(3).BUFADR   = JPI$K_NETWORK '               PSCANLIST(3).ITMFLAGS = 0A 	      IF (USER_PRESENT) THENL" 		PSCANLIST(4).BUFLEN   = USER_LEN) 		PSCANLIST(4).CODE     = PSCAN$_USERNAME_( 		PSCANLIST(4).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLS 		PSCANLIST(5).END_LIST = 0S# 	      ELSE IF (GROUP_PRESENT) THEN  		PSCANLIST(4).BUFLEN   = 0I$ 		PSCANLIST(4).CODE     = PSCAN$_GRP% 		PSCANLIST(4).BUFADR   = UIC_2.GROUPA% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0 ! 	      ELSE IF (UIC_PRESENT) THENS 		PSCANLIST(4).BUFLEN   = 0F$ 		PSCANLIST(4).CODE     = PSCAN$_UIC' 		PSCANLIST(4).BUFADR   = UIC.UIC_VALUEC% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0  	      ELSEM 		PSCANLIST(4).END_LIST = 0T
 	      END IF_A 	    ELSE IF (.NOT. BATCH_ABSENT .AND. .NOT. NETWORK_ABSENT) THENT  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODEL1               PSCANLIST(2).BUFADR   = JPI$K_OTHERM0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODED7               PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVEM'               PSCANLIST(3).ITMFLAGS = 0E 	      IF (USER_PRESENT) THENS" 		PSCANLIST(4).BUFLEN   = USER_LEN) 		PSCANLIST(4).CODE     = PSCAN$_USERNAMEB( 		PSCANLIST(4).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THENT 		PSCANLIST(4).BUFLEN   = 0S$ 		PSCANLIST(4).CODE     = PSCAN$_GRP% 		PSCANLIST(4).BUFADR   = UIC_2.GROUP % 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(5).END_LIST = 0B! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(4).BUFLEN   = 0 $ 		PSCANLIST(4).CODE     = PSCAN$_UIC' 		PSCANLIST(4).BUFADR   = UIC.UIC_VALUED% 		PSCANLIST(4).ITMFLAGS = PSCAN$M_EQLS 		PSCANLIST(5).END_LIST = 0N 	      ELSE  		PSCANLIST(4).END_LIST = 0M
 	      END IFF& 	    ELSE IF (.NOT. INTER_ABSENT) THEN  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE 1               PSCANLIST(2).BUFADR   = JPI$K_OTHER 0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODE 3               PSCANLIST(3).BUFADR   = JPI$K_NETWORK(0               PSCANLIST(3).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(4).BUFLEN   = 01               PSCANLIST(4).CODE     = PSCAN$_MODE 1               PSCANLIST(4).BUFADR   = JPI$K_BATCH '               PSCANLIST(4).ITMFLAGS = 0I 	      IF (USER_PRESENT) THENI" 		PSCANLIST(5).BUFLEN   = USER_LEN) 		PSCANLIST(5).CODE     = PSCAN$_USERNAME)( 		PSCANLIST(5).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLN 		PSCANLIST(6).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THEN$ 		PSCANLIST(5).BUFLEN   = 0L$ 		PSCANLIST(5).CODE     = PSCAN$_GRP% 		PSCANLIST(5).BUFADR   = UIC_2.GROUP$% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL0 		PSCANLIST(6).END_LIST = 0)! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(5).BUFLEN   = 0 $ 		PSCANLIST(5).CODE     = PSCAN$_UIC' 		PSCANLIST(5).BUFADR   = UIC.UIC_VALUE % 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(6).END_LIST = 0S 	      ELSE  		PSCANLIST(5).END_LIST = 0F
 	      END IFA& 	    ELSE IF (.NOT. BATCH_ABSENT) THEN  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODE 1               PSCANLIST(2).BUFADR   = JPI$K_OTHER 0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODEE3               PSCANLIST(3).BUFADR   = JPI$K_NETWORK 0               PSCANLIST(3).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(4).BUFLEN   = 01               PSCANLIST(4).CODE     = PSCAN$_MODES7               PSCANLIST(4).BUFADR   = JPI$K_INTERACTIVEA'               PSCANLIST(4).ITMFLAGS = 0C 	      IF (USER_PRESENT) THEN(" 		PSCANLIST(5).BUFLEN   = USER_LEN) 		PSCANLIST(5).CODE     = PSCAN$_USERNAMEA( 		PSCANLIST(5).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLS 		PSCANLIST(6).END_LIST = 0 # 	      ELSE IF (GROUP_PRESENT) THENR 		PSCANLIST(5).BUFLEN   = 0.$ 		PSCANLIST(5).CODE     = PSCAN$_GRP% 		PSCANLIST(5).BUFADR   = UIC_2.GROUP % 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL$ 		PSCANLIST(6).END_LIST = 04! 	      ELSE IF (UIC_PRESENT) THENE 		PSCANLIST(5).BUFLEN   = 0B$ 		PSCANLIST(5).CODE     = PSCAN$_UIC' 		PSCANLIST(5).BUFADR   = UIC.UIC_VALUEI% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(6).END_LIST = 0) 	      ELSER 		PSCANLIST(5).END_LIST = 0N
 	      END IF(( 	    ELSE IF (.NOT. NETWORK_ABSENT) THEN  	      PSCANLIST(2).BUFLEN   = 01               PSCANLIST(2).CODE     = PSCAN$_MODES1               PSCANLIST(2).BUFADR   = JPI$K_OTHER 0               PSCANLIST(2).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(3).BUFLEN   = 01               PSCANLIST(3).CODE     = PSCAN$_MODE.7               PSCANLIST(3).BUFADR   = JPI$K_INTERACTIVE 0               PSCANLIST(3).ITMFLAGS = PSCAN$M_OR  	      PSCANLIST(4).BUFLEN   = 01               PSCANLIST(4).CODE     = PSCAN$_MODE$1               PSCANLIST(4).BUFADR   = JPI$K_BATCH '               PSCANLIST(4).ITMFLAGS = 0N 	      IF (USER_PRESENT) THENt" 		PSCANLIST(5).BUFLEN   = USER_LEN) 		PSCANLIST(5).CODE     = PSCAN$_USERNAME*( 		PSCANLIST(5).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(6).END_LIST = 0*# 	      ELSE IF (GROUP_PRESENT) THENT 		PSCANLIST(5).BUFLEN   = 0 $ 		PSCANLIST(5).CODE     = PSCAN$_GRP% 		PSCANLIST(5).BUFADR   = UIC_2.GROUPA% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQL( 		PSCANLIST(6).END_LIST = 0S! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(5).BUFLEN   = 0 $ 		PSCANLIST(5).CODE     = PSCAN$_UIC' 		PSCANLIST(5).BUFADR   = UIC.UIC_VALUEC% 		PSCANLIST(5).ITMFLAGS = PSCAN$M_EQLF 		PSCANLIST(6).END_LIST = 0  	      ELSE  		PSCANLIST(5).END_LIST = 0)
 	      END IFN	 	    ELSE  	      IF (USER_PRESENT) THEN*" 		PSCANLIST(2).BUFLEN   = USER_LEN) 		PSCANLIST(2).CODE     = PSCAN$_USERNAME*( 		PSCANLIST(2).BUFADR   = %LOC(USERNAME)% 		PSCANLIST(2).ITMFLAGS = PSCAN$M_EQLN 		PSCANLIST(3).END_LIST = 0N# 	      ELSE IF (GROUP_PRESENT) THEN  		PSCANLIST(2).BUFLEN   = 0($ 		PSCANLIST(2).CODE     = PSCAN$_GRP% 		PSCANLIST(2).BUFADR   = UIC_2.GROUPT% 		PSCANLIST(2).ITMFLAGS = PSCAN$M_EQLB 		PSCANLIST(3).END_LIST = 0C! 	      ELSE IF (UIC_PRESENT) THEN  		PSCANLIST(2).BUFLEN   = 0A$ 		PSCANLIST(2).CODE     = PSCAN$_UIC' 		PSCANLIST(2).BUFADR   = UIC.UIC_VALUE % 		PSCANLIST(2).ITMFLAGS = PSCAN$M_EQL  		PSCANLIST(3).END_LIST = 00 	      ELSE  		PSCANLIST(2).END_LIST = 0A
 	      END IF  	    END IFL  ( 	    STATUS = SYS$PROCESS_SCAN( CONTEXT, 	2			       PSCANLIST)  2 	    IF (.NOT. STATUS) CALL LIB$STOP(%VAL(STATUS)) 	 ,             IF ( .NOT. EXTEND_PRESENT) THEN	 	      CALL GETJPI_BASIC	F
 	    ELSE  	      CALL GETJPI_EXTENDA 	    END IF		      F	 	  END IF  	END IFS 	END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        