 /*%  * Sun clock - astronomical routines.   */    #include "sunclock.h"   ? /*  JDATE  --  Convert internal GMT date and time to Julian day  	       and fraction.  */    long jdate(t)
 struct tm *t;  {  	long c, m, y;   	y = t->tm_year + 1900;  	m = t->tm_mon + 1;  	if (m > 2)  	   m = m - 3; 	else {  	   m = m + 9; 	   y--; 	}( 	c = y / 100L;		   /* Compute century */ 	y -= 100L * c; : 	return t->tm_mday + (c * 146097L) / 4 + (y * 1461L) / 4 +# 	    (m * 153L + 2) / 5 + 1721119L;  }   E /* JTIME --    Convert internal GMT  date  and	time  to  astronomical ? 	       Julian  time  (i.e.   Julian  date  plus  day fraction, " 	       expressed as a double).	*/   double jtime(t)
 struct tm *t;  {  	return (jdate(t) - 0.5) +   	   (((long) t->tm_sec) + 6 	     60L * (t->tm_min + 60L * t->tm_hour)) / 86400.0; }   0 /*  KEPLER  --	Solve the equation of Kepler.  */   double kepler(m, ecc) double m, ecc; {  	double e, delta;  #define EPSILON 1E-6   	e = m = dtr(m); 	do { ! 	   delta = e - ecc * sin(e) - m; $ 	   e -= delta / (1 - ecc * cos(e));  	} while (abs(delta) > EPSILON);
 	return e; }   D /*  SUNPOS  --	Calculate position of the Sun.	JD is the Julian  date8 		of  the  instant for which the position is desired and8 		APPARENT should be nonzero if  the  apparent  position8 		(corrected  for  nutation  and aberration) is desired.F                 The Sun's co-ordinates are returned  in  RA  and  DEC,8 		both  specified  in degrees (divide RA by 15 to obtain8 		hours).  The radius vector to the Sun in  astronomicalF                 units  is returned in RV and the Sun's longitude (true8 		or apparent, as desired) is  returned  as  degrees  in 		SLONG.	*/   ( sunpos(jd, apparent, ra, dec, rv, slong)
 double jd;
 int apparent;  double *ra, *dec, *rv, *slong; { 0 	double t, t2, t3, l, m, e, ea, v, theta, omega, 	       eps;  6 	/* Time, in Julian centuries of 36525 ephemeris days,3 	   measured from the epoch 1900 January 0.5 ET. */     	t = (jd - 2415020.0) / 36525.0; 	t2 = t * t;
 	t3 = t2 * t;   8 	/* Geometric mean longitude of the Sun, referred to the  	   mean equinox of the date. */  < 	l = fixangle(279.69668 + 36000.76892 * t + 0.0003025 * t2);  !         /* Sun's mean anomaly. */   F 	m = fixangle(358.47583 + 35999.04975*t - 0.000150*t2 - 0.0000033*t3);  0         /* Eccentricity of the Earth's orbit. */  3 	e = 0.01675104 - 0.0000418 * t - 0.000000126 * t2;    	/* Eccentric anomaly. */    	ea = kepler(m, e);    	/* True anomaly */   E 	v = fixangle(2 * rtd(atan(sqrt((1 + e) / (1 - e))  * tan(ea / 2))));   #         /* Sun's true longitude. */    	theta = l + v - m;   ! 	/* Obliquity of the ecliptic. */   F 	eps = 23.452294 - 0.0130125 * t - 0.00000164 * t2 + 0.000000503 * t3;  C         /* Corrections for Sun's apparent longitude, if desired. */    	if (apparent) {, 	   omega = fixangle(259.18 - 1934.142 * t);8 	   theta = theta - 0.00569 - 0.00479 * sin(dtr(omega));% 	   eps += 0.00256 * cos(dtr(omega));  	}  6         /* Return Sun's longitude and radius vector */   	*slong = theta;9 	*rv = (1.0000002 * (1 - e * e)) / (1 + e * cos(dtr(v)));   $ 	/* Determine solar co-ordinates. */   	*ra =H 	fixangle(rtd(atan2(cos(dtr(eps)) * sin(dtr(theta)), cos(dtr(theta)))));3 	*dec = rtd(asin(sin(dtr(eps)) * sin(dtr(theta))));  }   @ /*  GMST  --  Calculate Greenwich Mean Siderial Time for a given: 	      instant expressed as a Julian date and fraction.	*/   double gmst(jd)
 double jd; {  	double t, theta0;    6 	/* Time, in Julian centuries of 36525 ephemeris days,3 	   measured from the epoch 1900 January 0.5 ET. */   5 	t = ((floor(jd + 0.5) - 0.5) - 2415020.0) / 36525.0;   ; 	theta0 = 6.6460656 + 2400.051262 * t + 0.00002581 * t * t;   $ 	t = (jd + 0.5) - (floor(jd + 0.5));  $ 	theta0 += (t * 24.0) * 1.002737908;  3 	theta0 = (theta0 - 24.0 * (floor(theta0 / 24.0)));    	return theta0;  } 