 /**  * Sun clock.  X11 version by John Mackin.  *J  * This program was derived from, and is still in part identical with, theH  * Suntools Sun clock program whose author's comment appears immediately(  * below.  Please preserve both notices.  *I  * The X11R3/4 version of this program was written by John Mackin, at the G  * Basser Department of Computer Science, University of Sydney, Sydney, F  * New South Wales, Australia; <john@cs.su.oz.AU>.  This program, likeE  * the one it was derived from, is in the public domain: `Love is the   * law, love under will.'   */    /*  
 	Sun clock  = 	Designed and implemented by John Walker in November of 1988.   ! 	Version for the Sun Workstation.   G     The algorithm used to calculate the position of the Sun is given in      Chapter 18 of:  J     "Astronomical  Formulae for Calculators" by Jean Meeus, Third Edition,C     Richmond: Willmann-Bell, 1985.  This book can be obtained from:           Willmann-Bell        P.O. Box 35025         Richmond, VA  23235
        USA        Phone: (804) 320-7016        This program was written by:          John Walker        Autodesk, Inc.         2320 Marinship Way         Sausalito, CA  94965 
        USA        Fax:   (415) 389-9418&        Voice: (415) 332-2344 Ext. 2829+        Usenet: {sun,well,uunet}!acad!kelvin  	   or: kelvin@acad.uu.net  J     This  program is in the public domain: "Do what thou wilt shall be theJ     whole of the law".  I'd appreciate  receiving  any  bug  fixes  and/orJ     enhancements,  which  I'll  incorporate  in  future  versions  of  theI     program.  Please leave the original attribution information intact	so 6     that credit and blame may be properly apportioned.       Revision history:     	1.0  12/21/89  Initial version.1 	      8/24/89  Finally got around to submitting.        Modification history:   H         1.1  11/2/92   Updated by - Ed Smith (smith@spezko.enet.dec.com).                        - ported to OpenVMS AXPE                        - added window and icon title switches for VMS K                        - added zone and offset for GMT as switches for VMS   */     #define	FAILFONT	"fixed"   #define	VERSION		"1.1" #ifndef BIGFONT 9 #define BIGFONT "-Adobe-Helvetica-Bold-R-Normal--*-120-*" 1 /*#define BIGFONT "-*-*-Bold-R-Normal--*-140-*"*/  #endif #ifndef SMALLFONT J #define SMALLFONT "-Misc-Fixed-Bold-R-Normal--13-120-75-75-C-70-ISO8859-1"8 /*#define SMALLFONT "-*-Menu-Medium-R-Normal--*-100-*"*/ #endif     #include "sunclock.h"    struct sunclock { # 	int		s_width;	/* size of pixmap */  	int		s_height; * 	Window		s_window;	/* associated window */# 	Pixmap		s_pixmap;	/* and pixmap */  	int		s_flags;	/* see below */% 	int		s_noon;		/* position of noon */ 0 	short *		s_wtab1;	/* current width table (?) */1 	short *		s_wtab;		/* previous width table (?) */ . 	long		s_increm;	/* increment for fake time */4 	long		s_time;		/* time - real or fake, see flags */1 	GC		s_gc;		/* GC for writing text into window */ 8 	char *		(*s_tfunc)();	/* function to return the text */: 	char		s_text[80];	/* and the current text that's there */+ 	int		s_textx;	/* where to draw the text */ + 	int		s_texty;	/* where to draw the text */ < 	long		s_projtime;	/* last time we projected illumination */3 	int		s_timeout;	/* time until next image update */ > 	struct sunclock * s_next;	/* pointer to next clock context */ };   /*  * bits in s_flags  */   = #define	S_FAKE		01		/* date is fake, don't use actual time */ ; #define	S_ANIMATE	02		/* do animation based on increment */ 9 #define	S_DIRTY		04		/* pixmap -> window copy required */ 2 #define	S_ICON		010		/* this is the icon window */   char *				strrchr(); #ifndef VMS  long				time();  #endif  
 #ifdef VMS* char *                          Zone = "";G int                             Offset = 0, NORMAL_OFFSET, DST_OFFSET;   #endif   double				jtime(); double				gmst();  char *				salloc();  char *				bigtprint(); char *				smalltprint();& struct sunclock *		makeClockContext(); Bool				evpred();    char *				Wdayname[] = {7         "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"  }; char *				Monname[] = { 1 	"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", " 	"Aug", "Sep", "Oct", "Nov", "Dec" };  
 struct geom {  	int			mask;	 	int			x; 	 	int			y;  };  8 char *                          Icon_title = "SunClock";: char *                          Window_title = "SunClock"; char *				Name;  char *				Display_name = ""; Display *			dpy; int				scr;  unsigned long			Black; unsigned long			White; GC				GC_store;  GC				GC_invert; GC				GC_bigf; GC				GC_smallf; XFontStruct *			SmallFont; XFontStruct *			BigFont; Pixmap				Mappix;  Pixmap				Iconpix; Window				Icon;  Window				ClockWin;  struct sunclock *		Current;  int				Iconic = 0;! struct geom			Geom = { 0, 0, 0 }; % struct geom			Icongeom = { 0, 0, 0 };    main(argc, argv) int				argc; register char **		argv;  {  	char *			p;   	Name = *argv; #ifndef VMS  	if (p = strrchr(Name, '/'))
 		Name = ++p;  #else  	if (p = strrchr(Name, '<')) { 	    Name = ++p; 	    if (p = strchr(Name, '.'))  		*p = '\0';	 	} else { " 	    if (p = strrchr(Name, ']')) {
 		Name = ++p;  		if (p = strchr(Name, '.')) 		    *p = '\0'; 	    } 	} #endif 	parseArgs(argc, argv);   
 #ifdef VMS  F /* For VMS: offset from local time to GMT, use 4 and 5 for EDT/EST. */  3         if ((Offset < 1) || (Offset > 24)) usage();          NORMAL_OFFSET = Offset;           DST_OFFSET = Offset - 1;   #endif  )         dpy = XOpenDisplay(Display_name);  	if (dpy == (Display *)NULL) {A 		fprintf(stderr, "%s: can't open display `%s'\n", Display_name); 
 		exit(1); 	} 	scr = DefaultScreen(dpy);  
 	getColors();  	getFonts(); 	makePixmaps();  	makeWindows();  	makeGCs(ClockWin, Mappix);  	setAllHints(argc, argv);  	makeClockContexts();   + 	XSelectInput(dpy, ClockWin, ExposureMask); ' 	XSelectInput(dpy, Icon, ExposureMask);  	XMapWindow(dpy, ClockWin);   
 	eventLoop();    	/* F 	 * eventLoop() never returns, but one day it might, if someone adds a4 	 * menu for animation or such with a "quit" option. 	 */  
 	ByeBye();	 	exit(0);  }    parseArgs(argc, argv)  register int			argc; register char **		argv;  {  	while (--argc > 0) { 	 		++argv; ' 		if (strcmp(*argv, "-display") == 0) {  			needMore(argc, argv); 			Display_name = *++argv;
 			--argc;                 } + 		else if (strcmp(*argv, "-wtitle") == 0) {  			needMore(argc, argv); 			Window_title = *++argv;
 			--argc;                 } + 		else if (strcmp(*argv, "-ititle") == 0) {  			needMore(argc, argv); 			Icon_title = *++argv;
 			--argc;                 } 
 #ifdef VMS7                 else if (strcmp(*argv, "-zone") == 0) { -                         needMore(argc, argv); '                         Zone = *++argv; 7                         if (strlen(*argv) > 3) usage();                          --argc;                  } 9                 else if (strcmp(*argv, "-offset") == 0) { -                         needMore(argc, argv); /                         Offset = atoi(*++argv);                          --argc;                  }  #endif0         	else if (strcmp(*argv, "-iconic") == 0) 			Iconic++;- 		else if (strcmp(*argv, "-geometry") == 0) {  			needMore(argc, argv); 			getGeom(*++argv, &Geom); 
 			--argc; 		} 1 		else if (strcmp(*argv, "-icongeometry") == 0) {  			needMore(argc, argv); 			getGeom(*++argv, &Icongeom); 
 			--argc; 		} , 		else if (strcmp(*argv, "-version") == 0) {4 			fprintf(stderr, "%s: version %s patchlevel %d\n", 				Name, VERSION, PATCHLEVEL);  			exit(0);  		}  		else 			usage();  	} }    needMore(argc, argv) register int			argc; register char **		argv;  {  	if (argc == 1) { ; 		fprintf(stderr, "%s: option `%s' requires an argument\n",  			Name, *argv);
 		usage(); 	} }   
 getGeom(s, g)  register char *			s; register struct geom *		g; {  	register int		mask; 	unsigned int		width;  	unsigned int		height;  9 	mask = XParseGeometry(s, &g->x, &g->y, &width, &height);  	if (mask == 0) { ? 		fprintf(stderr, "%s: `%s' is a bad geometry specification\n",  			Name, s);
 		exit(1); 	}1 	if ((mask & WidthValue) || (mask & HeightValue))gI 		fprintf(stderr, "%s: warning: width/height in geometry `%s' ignored\n",  			Name, s); 	g->mask = mask; }m   /*  * Free resources.  */l   ByeBye() {s 	XFreeGC(dpy, GC_store); 	XFreeGC(dpy, GC_invert);s 	XFreeGC(dpy, GC_bigf);o 	XFreeGC(dpy, GC_smallf);e 	XFreeFont(dpy, BigFont);i 	XFreeFont(dpy, SmallFont);y 	XFreePixmap(dpy, Mappix); 	XFreePixmap(dpy, Iconpix);. 	XDestroyWindow(dpy, ClockWin);i 	XDestroyWindow(dpy, Icon);  	XCloseDisplay(dpy); }h   usage()  {e'         fprintf(stderr, " \n");         
 #ifdef VMS; 	fprintf(stderr, "Usage: %s -offset # [options]\n", Name); i         fprintf(stderr, " \n"); ]         fprintf(stderr, " -offset #             : [1mRequired[0m - # of hours from GMT\n"); M         fprintf(stderr, "                         eg: EST is 5, PST is 8\n");ia         fprintf(stderr, "[-zone aaa]            : Timezone, eg: EST, maximum of 3 characters\n");  #else27         fprintf(stderr, "Usage: %s [options]\n", Name);          fprintf(stderr, " \n");m #endifF         fprintf(stderr, "[-display dispname]    : Target display\n"); O         fprintf(stderr, "[-wtitle windowtitle]  : SunClock's window title\n"); 8G         fprintf(stderr, "[-geometry +x+y]       : Window geometry\n"); !R         fprintf(stderr, "[-version]             : Displays SunClock's version\n");J         fprintf(stderr, "[-iconic]              : Start up as an icon\n");C         fprintf(stderr, "[-ititle icontitle]    : Icon's title\n");nD         fprintf(stderr, "[-icongeometry +x+y]   : Icon geometry\n");         fprintf(stderr, " \n");o	 	exit(1);  }    /*C  * Set up stuff the window manager will want to know.  Must be doney0  * before mapping window, but after creating it.  */    setAllHints(argc, argv)t int				argc; char **				argv; {  	XClassHint		xch;/ 	XSizeHints		xsh;  	XWMHints		xwmh;   	xch.res_name = Name;  	xch.res_class = "Sunclock";$ 	XSetClassHint(dpy, ClockWin, &xch);) 	XStoreName(dpy, ClockWin, Window_title);   ( 	XSetCommand(dpy, ClockWin, argv, argc);  ) 	XSetIconName(dpy, ClockWin, Icon_title);d  ) 	xsh.flags = PSize | PMinSize | PMaxSize;.% 	if (Geom.mask & (XValue | YValue)) {- 		xsh.x = Geom.x;d 		xsh.y = Geom.y;  		xsh.flags |= USPosition; 	}= 	xsh.width = xsh.min_width = xsh.max_width = large_map_width;FA 	xsh.height = xsh.min_height = xsh.max_height = large_map_height;f& 	XSetNormalHints(dpy, ClockWin, &xsh);  5 	xwmh.flags = InputHint | StateHint | IconWindowHint;s) 	if (Icongeom.mask & (XValue | YValue)) {p 		xwmh.icon_x = Icongeom.x;o 		xwmh.icon_y = Icongeom.y;n! 		xwmh.flags |= IconPositionHint;i 	} 	xwmh.input = False;9 	xwmh.initial_state = Iconic ? IconicState : NormalState;o 	xwmh.icon_window = Icon;i# 	XSetWMHints(dpy, ClockWin, &xwmh);/ }r  
 makeWindows()e {) 	register int		ht; 	XSetWindowAttributes	xswa;  	register int		mask;  6 	ht = icon_map_height + SmallFont->max_bounds.ascent +( 	     SmallFont->max_bounds.descent + 2; 	xswa.background_pixel = White;t 	xswa.border_pixel = Black;;! 	xswa.backing_store = WhenMapped;r5 	mask = CWBackPixel | CWBorderPixel | CWBackingStore;t  7 	fixGeometry(&Geom, large_map_width, large_map_height);;D 	ClockWin = XCreateWindow(dpy, RootWindow(dpy, scr), Geom.x, Geom.y,> 			      large_map_width, large_map_height, 3, CopyFromParent,3 			      InputOutput, CopyFromParent, mask, &xswa);a  , 	fixGeometry(&Icongeom, icon_map_width, ht);H 	Icon = XCreateWindow(dpy, RootWindow(dpy, scr), Icongeom.x, Icongeom.y,; 			     icon_map_width, ht, 1, CopyFromParent, InputOutput, % 			     CopyFromParent, mask, &xswa);h   }    fixGeometry(g, w, h) register struct geom *		g; register int			w;) register int			h;f {S 	if (g->mask & XNegative) + 		g->x = DisplayWidth(dpy, scr) - w + g->x;  	if (g->mask & YNegative)E, 		g->y = DisplayHeight(dpy, scr) - h + g->y; }o  
 makeGCs(w, p)  register Window			w; register Pixmap			p; {h 	XGCValues		gcv;   	gcv.foreground = Black; 	gcv.background = White;A 	GC_store = XCreateGC(dpy, w, GCForeground | GCBackground, &gcv);, 	gcv.function = GXinvert; O 	GC_invert = XCreateGC(dpy, p, GCForeground | GCBackground | GCFunction, &gcv);    	gcv.font = BigFont->fid;,I 	GC_bigf = XCreateGC(dpy, w, GCForeground | GCBackground | GCFont, &gcv);h 	gcv.font = SmallFont->fid; K 	GC_smallf = XCreateGC(dpy, w, GCForeground | GCBackground | GCFont, &gcv);C }k   getColors()a {  	XColor			c; 	XColor			e; 	register Status		s;  G 	s = XAllocNamedColor(dpy, DefaultColormap(dpy, scr), "Black", &c, &e);e 	if (s != (Status)1) {A 		fprintf(stderr, "%s: warning: can't allocate color `Black'\n");r 		Black = BlackPixel(dpy, scr);x 	} 	else	 		Black = c.pixel;G 	s = XAllocNamedColor(dpy, DefaultColormap(dpy, scr), "White", &c, &e);i 	if (s != (Status)1) {8 		fprintf(stderr, "%s: can't allocate color `White'\n"); 		White = WhitePixel(dpy, scr);; 	} 	elsec 		White = c.pixel; }a  
 getFonts() { ( 	BigFont = XLoadQueryFont(dpy, BIGFONT);& 	if (BigFont == (XFontStruct *)NULL) {; 		fprintf(stderr, "%s: can't open font `%s', using `%s'\n",r 			Name, BIGFONT, FAILFONT);* 		BigFont = XLoadQueryFont(dpy, FAILFONT);' 		if (BigFont == (XFontStruct *)NULL) {m; 			fprintf(stderr, "%s: can't open font `%s', giving up\n",g 				Name, FAILFONT); 			exit(1);V 		}f 	}, 	SmallFont = XLoadQueryFont(dpy, SMALLFONT);( 	if (SmallFont == (XFontStruct *)NULL) {; 		fprintf(stderr, "%s: can't open font `%s', using `%s'\n",  			Name, SMALLFONT, FAILFONT);, 		SmallFont = XLoadQueryFont(dpy, FAILFONT);) 		if (SmallFont == (XFontStruct *)NULL) {i; 			fprintf(stderr, "%s: can't open font `%s', giving up\n",  				Name, FAILFONT); 			exit(1);n 		}; 	} }t  
 makePixmaps()o {(@ 	Mappix = XCreatePixmapFromBitmapData(dpy, RootWindow(dpy, scr),% 				 large_map_bits, large_map_width,o  				 large_map_height, 0, 1, 1);  A 	Iconpix = XCreatePixmapFromBitmapData(dpy, RootWindow(dpy, scr), # 				 icon_map_bits, icon_map_width,e 				 icon_map_height, 0, 1, 1);( }e   makeClockContexts()y {  	register struct sunclock * s;  J 	s = makeClockContext(large_map_width, large_map_height, ClockWin, Mappix, 			     GC_bigf, bigtprint, 70,e< 			     large_map_height - BigFont->max_bounds.descent - 1);
 	Current = s;+E 	s = makeClockContext(icon_map_width, icon_map_height, Icon, Iconpix,v" 			     GC_smallf, smalltprint, 6,< 			     icon_map_height + SmallFont->max_bounds.ascent + 1); 	Current->s_next = s;( 	s->s_flags |= S_ICON; 	s->s_next = Current;a };   struct sunclock * 6 makeClockContext(wid, ht, win, pix, gc, fun, txx, txy) int				wid;;
 int				ht; Window				win; Pixmap				pix;	 GC				gc;  char *				(*fun)();  int				txx;e int				txy;a {, 	register struct sunclock * s;  9 	s = (struct sunclock *)salloc(sizeof (struct sunclock));o 	s->s_width = wid; 	s->s_height = ht; 	s->s_window = win;) 	s->s_pixmap = pix;  	s->s_flags = S_DIRTY; 	s->s_noon = -1;; 	s->s_wtab = (short *)salloc((int)(ht * sizeof (short *))); < 	s->s_wtab1 = (short *)salloc((int)(ht * sizeof (short *))); 	s->s_increm = 0L; 	s->s_time = 0L; 	s->s_gc	= gc; 	s->s_tfunc = fun; 	s->s_timeout = 0; 	s->s_projtime = -1L;t 	s->s_text[0] = '\0';= 	s->s_textx = txx; 	s->s_texty = txy;   	return (s); }	   /*J  * Someone is sure to wonder why the event loop is coded this way, withoutG  * using select().  The answer is that this was developed on a System VvG  * kernel, which has select() but the call has bugs; so, I was inspired(H  * to make it portable to systems without select().  The slight delay inG  * expose event processing that results from using sleep(1) rather thanuE  * alarm() is a fine payoff for not having to worry about interruptedr  * system calls.  *H  * I've got to use XCheckIfEvent with a degenerate predicate rather thanJ  * XCheckMaskEvent with a mask of -1L because the latter won't collect allF  * types of events, notably ClientMessage and Selection events.  Sigh.  */	   eventLoop()g { 
 	XEvent			ev;    	for (;;) {e1 		if (XCheckIfEvent(dpy, &ev, evpred, (char *)0))s 			switch (ev.type) {t 		 			case Expose:b 				if (ev.xexpose.count == 0)! 					doExpose(ev.xexpose.window);(
 				break; 			} 		else { 			sleep(1); 			doTimeout();e 		}% 	} }i   Bool evpred(d, e, a)t register Display *		d; register XEvent *		e;m register char *			a; {e 	return (True);  }B   /*D  * Got an expose event for window w.  Do the right thing if it's not&  * currently the one we're displaying.  */r   doExpose(w)F register Window			w; {m 	if (w != Current->s_window) { 		Current = Current->s_next; 		if (w != Current->s_window) {k 			fprintf(stderr,: 				"%s: expose event for unknown window, id = 0x%08lx\n", 				w);p 			exit(1);  		}) 		setTimeout(Current); 	} 	updimage(Current);% 	Current->s_flags |= S_DIRTY;; 	showImage(Current); }r   doTimeout()  {  	if (QLength(dpy)). 		return;		/* ensure events processed first */! 	if (--Current->s_timeout <= 0) {( 		updimage(Current); 		showImage(Current);5 		setTimeout(Current); 	} }t  
 setTimeout(s)  register struct sunclock *	s;  {,
 	long			t;   	if (s->s_flags & S_ICON) {  		time(&t);t, 		s->s_timeout = 60 - localtime(&t)->tm_sec; 	} 	elset 		s->s_timeout = 1;f }    showImage(s) register struct sunclock *	s;  {g 	register char *		p; 	struct tm		lt;r 	register struct tm *	gmtp;u   	lt = *localtime(&s->s_time);  #ifndef VMSt 	gmtp = gmtime(&s->s_time);  #elsew 	gmtp = localtime(&s->s_time);
 #ifdef DST 	gmtp->tm_hour += DST_OFFSET;s #elsec  	gmtp->tm_hour += NORMAL_OFFSET; #endif 	if (gmtp->tm_hour > 23) { 	   gmtp->tm_hour -= 24; 	   gmtp->tm_mday++; 	} 	gmtp->tm_isdst = 1; #endif 	p = (*s->s_tfunc)(&lt, gmtp);   	if (s->s_flags & S_DIRTY) {; 		XCopyPlane(dpy, s->s_pixmap, s->s_window, GC_store, 0, 0, ( 			   s->s_width, s->s_height, 0, 0, 1); 		if (s->s_flags & S_ICON)3 			XClearArea(dpy, s->s_window, 0, s->s_height + 1,i 				   0, 0, False); 		s->s_flags &= ~S_DIRTY;a 	} 	strcpy(s->s_text, p);
 	showText(s);h }    showText(s)h register struct sunclock *	s;s {m8 	XDrawImageString(dpy, s->s_window, s->s_gc, s->s_textx,. 			 s->s_texty, s->s_text, strlen(s->s_text)); }n  	 /* --- */ 5 /*  UPDIMAGE  --  Update current displayed image.  */N   updimage(s)i register struct sunclock *	s;= {i 	register int		i;x
 	int			xl; 	struct tm *		ct;e
 	double			jt;  	double			sunra; 	double			sundec;  	double			sunrv; 	double			sunlong;
 	double			gt;n 	struct tm		lt;w 	short *			wtab_swap;F  ; 	/* If this is a full repaint of the window, force completeg 	   recalculation. */d   	if (s->s_noon < 0) {x 		s->s_projtime = 0;% 		for (i = 0; i < s->s_height; i++) {o 			s->s_wtab1[i] = -1; 		}) 	}   	if (s->s_flags & S_FAKE) {  		if (s->s_flags & S_ANIMATE)	 			s->s_time += s->s_increm; 		if (s->s_time < 0) 			s->s_time = 0;a 	} else  		time(&s->s_time);: 	lt = *localtime(&s->s_time);o   #ifndef VMSe 	ct = gmtime(&s->s_time);m #elser 	ct = localtime(&s->s_time);
 #ifdef DST 	ct->tm_hour += DST_OFFSET;  #elses 	ct->tm_hour += NORMAL_OFFSET; #endif 	if (ct->tm_hour > 23) { 	   ct->tm_hour -= 24; 	   ct->tm_mday++; 	} 	ct->tm_isdst = 1; #endif   	jt = jtime(ct);6 	sunpos(jt, False, &sunra, &sundec, &sunrv, &sunlong); 	gt = gmst(jt);   ? 	/* Projecting the illumination curve  for the current seasonal_F            instant is costly.  If we're running in real time, only  do! 	   it every PROJINT seconds.  */l   	if ((s->s_flags & S_FAKE) 	 || s->s_projtime < 0- 	 || (s->s_time - s->s_projtime) > PROJINT) {w8 		projillum(s->s_wtab, s->s_width, s->s_height, sundec); 		wtab_swap = s->s_wtab; 		s->s_wtab = s->s_wtab1;. 		s->s_wtab1 = wtab_swap;n 		s->s_projtime = s->s_time; 	}  1 	sunlong = fixangle(180.0 + (sunra - (gt * 15)));h% 	xl = sunlong * (s->s_width / 360.0);r  > 	/* If the subsolar point has moved at least one pixel, update* 	   the illuminated area on the screen.	*/  0 	if ((s->s_flags & S_FAKE) || s->s_noon != xl) {< 		moveterm(s->s_wtab1, xl, s->s_wtab, s->s_noon, s->s_width, 			 s->s_height, s->s_pixmap); 		s->s_noon = xl;; 		s->s_flags |= S_DIRTY; 	} }r  ; /*  PROJILLUM  --  Project illuminated area on the map.  */G  " projillum(wtab, xdots, ydots, dec) short *wtab; int xdots, ydots;t double dec;t {X1 	int i, ftf = True, ilon, ilat, lilon, lilat, xt;n' 	double m, x, y, z, th, lon, lat, s, c;d  , 	/* Clear unoccupied cells in width table */   	for (i = 0; i < ydots; i++) 		wtab[i] = -1;F  + 	/* Build transformation for declination */r   	s = sin(-dtr(dec)); 	c = cos(-dtr(dec));  2 	/* Increment over a semicircle of illumination */  + 	for (th = -(PI / 2); th <= PI / 2 + 0.001;f 	    th += PI / TERMINC) {  = 		/* Transform the point through the declination rotation. */r   		x = -s * sin(th);l 		y = cos(th); 		z = c * sin(th);  4 		/* Transform the resulting co-ordinate through the5 		   map projection to obtain screen co-ordinates. */&  4 		lon = (y == 0 && x == 0) ? 0.0 : rtd(atan2(y, x)); 		lat = rtd(asin(z));W  . 		ilat = ydots - (lat + 90) * (ydots / 180.0); 		ilon = lon * (xdots / 360.0);    		if (ftf) {  2 			/* First time.  Just save start co-ordinate. */   			lilon = ilon; 			lilat = ilat; 			ftf = False;t
 		} else {  4 			/* Trace out the line and set the width table. */   			if (lilat == ilat) { 4 				wtab[(ydots - 1) - ilat] = ilon == 0 ? 1 : ilon; 			} else {d3 				m = ((double) (ilon - lilon)) / (ilat - lilat);a8 				for (i = lilat; i != ilat; i += sgn(ilat - lilat)) {1 					xt = lilon + floor((m * (i - lilat)) + 0.5);t. 					wtab[(ydots - 1) - i] = xt == 0 ? 1 : xt; 				}t 			} 			lilon = ilon; 			lilat = ilat; 		}L 	}  : 	/* Now tweak the widths to generate full illumination for 	   the correct pole. */   	if (dec < 0.0) {r 		ilat = ydots - 1;n
 		lilat = -1;u	 	} else {	 		ilat = 0;T 		lilat = 1; 	}  - 	for (i = ilat; i != ydots / 2; i += lilat) {e 		if (wtab[i] != -1) { 			while (True) {, 				wtab[i] = xdots / 2; 				if (i == ilat) 					break;m 				i -= lilat;1 			}	 			break;X 		}e 	} }r  F /*  XSPAN  --  Complement a span of pixels.  Called with line in which? 	       pixels are contained, leftmost pixel in the  line,  andy> 	       the   number   of   pixels   to	 complement.   Handles8 	       wrap-around at the right edge of the screen.  */  # xspan(pline, leftp, npix, xdots, p)g register int			pline;> register int			leftp;; register int			npix; register int			xdots;m register Pixmap			p; {, 	leftp = leftp % xdots;    	if (leftp + npix > xdots) {? 		XDrawLine(dpy, p, GC_invert, leftp, pline, xdots - 1, pline);t( 		XDrawLine(dpy, p, GC_invert, 0, pline,* 			  (leftp + npix) - (xdots + 1), pline); 	} 	elsec, 		XDrawLine(dpy, p, GC_invert, leftp, pline,  			  leftp + (npix - 1), pline); }	  > /*  MOVETERM  --  Update illuminated portion of the globe.  */  7 moveterm(wtab, noon, otab, onoon, xdots, ydots, pixmap)= short *wtab, *otab;a int noon, onoon, xdots, ydots; Pixmap pixmap; {; 	int i, ol, oh, nl, nh;>   	for (i = 0; i < ydots; i++) {  4 		/* If line is off in new width table but is set in  		   the old table, clear it. */   		if (wtab[i] < 0) { 			if (otab[i] >= 0) {1 				xspan(i, ((onoon - otab[i]) + xdots) % xdots,;$ 				    otab[i] * 2, xdots, pixmap); 			}
 		} else {  6 			/* Line is on in new width table.  If it was off in+ 			   the old width table, just draw it. */x   			if (otab[i] < 0) { 0 				xspan(i, ((noon - wtab[i]) + xdots) % xdots,$ 				    wtab[i] * 2, xdots, pixmap); 			} else {h  4 				/* If both the old and new spans were the entire% 				   screen, they're equivalent. */h  5 				if (otab[i] == wtab[i] && wtab[i] == (xdots / 2))y 					continue;  4 				/* The line was on in both the old and new width4 				   tables.  We must adjust the difference in the 				   span.  */  . 				ol =  ((onoon - otab[i]) + xdots) % xdots;  				oh = (ol + otab[i] * 2) - 1;- 				nl =  ((noon - wtab[i]) + xdots) % xdots;r  				nh = (nl + wtab[i] * 2) - 1;  4 				/* If spans are disjoint, erase old span and set 				   new span. */a   				if (oh < nl || nh < ol) {v0 					xspan(i, ol, (oh - ol) + 1, xdots, pixmap);0 					xspan(i, nl, (nh - nl) + 1, xdots, pixmap); 				} else {0 					/* Clear portion(s) of old span that extend" 					   beyond end of new span. */ 					if (ol < nl) {x+ 						xspan(i, ol, nl - ol, xdots, pixmap);	 						ol = nl; 					} 					if (oh > nh) { / 						xspan(i, nh + 1, oh - nh, xdots, pixmap);e 						oh = nh; 					}2 					/* Extend existing (possibly trimmed) span to 					   correct new length. */ 					if (nl < ol) {i+ 						xspan(i, nl, ol - nl, xdots, pixmap);s 					} 					if (nh > oh) {F/ 						xspan(i, oh + 1, nh - oh, xdots, pixmap);w 					} 				}r 			} 		}n 		otab[i] = wtab[i]; 	} }t   char * salloc(nbytes) register int			nbytes; {v 	register char *		p; 	char *			malloc();	   	p = malloc((unsigned)nbytes); 	if (p == (char *)NULL) {m) 		fprintf(stderr, "%s: out of memory\n");Y
 		exit(1); 	} 	return (p); }o   char * bigtprint(ltp, gmtp) register struct tm *		ltp; register struct tm *		gmtp;- {r 	static char		s[80]; 	sprintf(s,eM 		"%02d:%02d:%02d %s %s %02d %s %02d     %02d:%02d:%02d UTC %s %02d %s %02d",t 		ltp->tm_hour, ltp->tm_min, 		ltp->tm_sec, #ifdef	NEW_CTIME 		ltp->tm_zone,  #elsei #ifndef VMS-  		tzname[ltp->tm_isdst],( #else_                 Zone,s #endif #endif' 		Wdayname[ltp->tm_wday], ltp->tm_mday,o+ 		Monname[ltp->tm_mon], ltp->tm_year % 100,m 		gmtp->tm_hour, gmtp->tm_min,7 		gmtp->tm_sec, Wdayname[gmtp->tm_wday], gmtp->tm_mday,t. 		Monname[gmtp->tm_mon], gmtp->tm_year % 100);   	return (s); }i   char * smalltprint(ltp, gmtp) register struct tm *		ltp; register struct tm *		gmtp;  {  	static char		s[80];  C 	sprintf(s, "%02d:%02d %s %02d %s %02d", ltp->tm_hour, ltp->tm_min, = 		Wdayname[ltp->tm_wday], ltp->tm_mday, Monname[ltp->tm_mon],  		ltp->tm_year % 100);   	return (s); }s