6 /* testvhist.c - Sample program using the VHist widget  O ******************************************************************************* G * VToolkit (1995) 	"If it doesn't use VToolkit, it isn't cool!"	      *  * (c) Steve Klein							      * O * Unpublished rights reserved under the copyright laws of the United States.  * O *******************************************************************************   : This program is an example of how to use the VHist widget.   MODIFICATION HISTORY:   9 11-Oct-1993 (sjk) More portability cleanup.  Thanks Bill!   P 03-Sep-1993 (sjk/nfc) Run through Motif porting tools, cleaned up, #...def MOTIF 	conditionals removed   ( 14-Nov-1991 (sjk) Use VtkCreateCallback.   06-Nov-1991 (sjk) More cleanup.    06-Feb-1991 (sjk) Reformat.   / 01-Jun-1990 (sjk) Add support for colored bars.   G 09-Apr-1990 (sjk) Add MOTIF support.  Use VtkUtil convenience routines.   : 05-Apr-1990 (sjk) Add support for VHistOrientationBestFit.  % 22-Feb-1990 (sjk) Clean up packaging.     12-Sep-1989 (sjk) Initial entry. */   #include <stdio.h> #include <stdlib.h>  #include "vtoolkit.h"  #include "vhist.h"  , #define minValue 	0			/* low end of range *// #define maxValue 	100			/* high end of range */    #define appName		"TestVHist"% #define appClass	"testvhist_defaults"   #define uidFile		"testvhist.uid"  ! static MrmHierarchy mrmHierarchy; 2 static int counter = 0;				/* iteration counter */: static int baseValue = 0;			/* initial "baseline" value */8 static int showLabels = 1;			/* show bar labels (T/F) *// static VHistBar barA[20];			/* array of bars */ I static int barCnt = XtNumber (barA) / 2;	/* number of bars being shown */    static Widget widgetA[32]; #define appW		widgetA[0] #define mainW		widgetA[1]  #define vHistW		widgetA[2]  ? static VHistGrid gridA[] = {			/* array of ten equally ...   */ 9     {0, 10, 3, 2, 0},				/*   spaced grid lines ...    */ 9     {0, 20, 2, 1, 1},				/*   initialized with a ...   */ 9     {0, 30, 3, 2, 2},				/*   variety of dash ...      */ 9     {0, 40, 2, 2, 3},				/*   patterns and colors      */      {0, 50, 4, 2, 4},      {0, 60, 2, 2, 5},      {0, 70, 3, 2, 6},      {0, 80, 2, 1, 7},      {0, 90, 3, 2, 8},      {0, 100, 7, 4, 9}, };  k static void TestAddBarCallback(Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP)  { P     /* Increment the bar count (if the array is big enough).  The VHistNbarCountJ      * resource will be updated the next time UpdateCallback is called. */  ,     if (barCnt != XtNumber (barA)) barCnt++; }   n static void TestRemoveBarCallback(Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP) { F     /* Decrement the bar count (but leave at least one).  The bar will@      * be removed the next time the UpdateCallback is called. */       if (barCnt != 1) barCnt--; }   j static void TestSelectCallback(Widget unused_w, Opaque unused_closure, VHistSelectCallbackStruct *cbDataP) { :     printf ("SelectCallback for bar #%d\n", cbDataP->bar); }   q static void TestSelectConfirmCallback(Widget unused_w, Opaque unused_closure, VHistSelectCallbackStruct *cbDataP)  { A     printf ("SelectConfirmCallback for bar #%d\n", cbDataP->bar);  }    static void SetGrids(void) { 
     int i;     VHistGrid *gridP;   O     /* Reformat the grid labels.  Alternate between the low and high labels. */   C     for (i = 0, gridP = gridA; i < XtNumber(gridA); i++, gridP++) { P 	gridP->mask = (VHistGridValueMask | VHistGridDashMask | VHistGridColoridxMask);  
 	if (i % 2) { 5 	    sprintf (gridP->highLabelP, "%d", gridP->value); + 	    gridP->mask |= VHistGridHighLabelMask; 	 	} else { 4 	    sprintf (gridP->lowLabelP, "%d", gridP->value);* 	    gridP->mask |= VHistGridLowLabelMask; 	}     }   6     /* Pass the new grid array to the VHist widget. */       XtVaSetValues (vHistW, 	VHistNgrids, 	 gridA,# 	VHistNgridCount, XtNumber (gridA),  	0); }   n static void TestShiftGridCallback(Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP) { 
     int i;     VHistGrid *gridP;   6     /* Add 5 to each grid's value, with wraparound. */  A     for (i = 0, gridP = gridA; i < XtNumber(gridA); i++, gridP++) > 	if ((gridP->value += 5) > maxValue) gridP->value -= maxValue;       SetGrids (); }   h static void TestOrientationCallback(Widget unused_w, int *valueP, XmToggleButtonCallbackStruct *cbDataP) { H     VtkChangeRadioResource (vHistW, valueP, cbDataP, VHistNorientation); }   k static void TestLabelsCallback(Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP)  { v     /* Toggle the value of the showLabels flag.  The widget will be updated the next time UpdateCallback is called. */       showLabels ^= 1; }   N static void UpdateCallback(XtPointer unused_closure, XtIntervalId *unused_idP) { 
     int i, r;      VHistBar *barP;   7     /* Every fifth iteration, change the base value. */        if (!(counter % 5)) { @ 	baseValue += (rand () % 11 - 5);	/* add or subtract a little */0 	if (baseValue < minValue) baseValue = minValue;0 	if (baseValue > maxValue) baseValue = maxValue;     }   M     /* Each time through, randomly adjust the bars' high values.  On average, 8      * only change a given bar's value half the time. */  7     for (i = 0, barP = barA; i < barCnt; i++, barP++) { I 	/* Set all the low values to the common base value.  The widget does not K          * require that all bars have the same base value, but it makes the )          * sample program look better. */   ' 	barP->mask     = VHistBarLowValueMask;  	barP->lowValue = baseValue;  ( 	barP->mask    |= VHistBarHighValueMask; 	r = rand () % 22;0 	if (r < 11) 			     barP->highValue += (r - 5);A 	if (barP->highValue < minValue)      barP->highValue = minValue; A 	else if (barP->highValue > maxValue) barP->highValue = maxValue;   (  	barP->mask    |= VHistBarColoridxMask;: 	barP->coloridx = (barP->highValue - barP->lowValue) / 10;  > 	/* Reformat the bar labels.  The widget will switch the bar's? 	 * high and low values if highValue is less than lowValue, but $ 	 * we need to switch the labels. */   	if (showLabels) {B 	    barP->mask |= (VHistBarLowLabelMask | VHistBarHighLabelMask);  , 	    if (barP->lowValue < barP->highValue) {4 		sprintf (barP->lowLabelP,  "%d", barP->lowValue);	5 		sprintf (barP->highLabelP, "%d", barP->highValue);	 
 	    } else { 5 		sprintf (barP->lowLabelP,  "%d", barP->highValue);	 4 		sprintf (barP->highLabelP, "%d", barP->lowValue);	 	    } 	}     }   D     /* Tell the VHist widget about the new bar values and labels. */       XtVaSetValues (vHistW, 	VHistNbars, 	barA,  	VHistNbarCount, barCnt, 	0);  3     counter++;					/* maintain iteration counter */ J     XtAddTimeOut (100, UpdateCallback, 0);	/* another update in 0.1 sec */ }   i static void TestQuitCallback(Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP)  { 
     exit (1);  }   + static MrmRegisterArg mrmRegisterArgs[] = { 8     {"TestAddBarCallback",		(char *)TestAddBarCallback},>     {"TestRemoveBarCallback",		(char *)TestRemoveBarCallback},8     {"TestSelectCallback",		(char *)TestSelectCallback},E     {"TestSelectConfirmCallback",	(char *)TestSelectConfirmCallback}, >     {"TestShiftGridCallback",		(char *)TestShiftGridCallback},B     {"TestOrientationCallback",		(char *)TestOrientationCallback},8     {"TestLabelsCallback",		(char *)TestLabelsCallback},5     {"TestQuitCallback",		(char *)TestQuitCallback}};    int main(int argc, char **argv)  {      VHistGrid *gridP;      VHistBar *barP; 
     int i;  9     srand (1);			/* initialize random number generator */   +     MrmInitialize ();		/* initialize MRM */ H     VHistInitializeForMRM();	/* tell MRM about the VHist widget class */  %     /* Initialize the application. */        if (!VtkInitialize (appName, appClass, &argc, argv, uidFile, mrmRegisterArgs, XtNumber (mrmRegisterArgs), &mrmHierarchy, &appW))
 	exit (0);  1     /* Fetch the application widget hierarchy. */   K     (void)VtkFetchWidget (mrmHierarchy, "testVHistMain", appW, widgetA, 0);   E     /* Allocate small buffers for the dynamic grid and bar labels. */   =     for (i=0, gridP=gridA; i<XtNumber(gridA); i++, gridP++) { : 	gridP->lowLabelP  = XtMalloc (8); *gridP->lowLabelP  = 0;: 	gridP->highLabelP = XtMalloc (8); *gridP->highLabelP = 0;     }   9     for (i=0, barP=barA; i<XtNumber(barA); i++, barP++) { 8 	barP->lowLabelP  = XtMalloc (8); *barP->lowLabelP  = 0;8 	barP->highLabelP = XtMalloc (8); *barP->highLabelP = 0;     }   @     SetGrids ();	    /* tell the VHist widget about the grids */  9     XtManageChild (mainW);			/* manage the main window */   I     /* Work around a (V2) toolkit bug that fails to properly position the @      * application shell based on the main window's position. */  $     XtVaSetValues (XtParent (mainW), 	XtNx, mainW->core.x,  	XtNy, mainW->core.y,  	0);  9     XtRealizeWidget (appW);			/* realize the hierarchy */ G     XtAddTimeOut (1000, UpdateCallback, 0);	/* schedule first update */   *     XtMainLoop ();				/* process events */ } 