+ /* vcolorizer.c - VColorizer sample program   O ******************************************************************************* G * VToolkit (1995) 	"If it doesn't use VToolkit, it isn't cool!"	      *  * (c) Steve Klein							      * O * Unpublished rights reserved under the copyright laws of the United States.  * O *******************************************************************************   B This program allows the user to colorize any window on the screen.  A Many thanks to Malcolm Forbes and Mark Pratt whose code and ideas @ were used in this example.  Any bugs you find are mine, however.  H To use VColorizer, first run the vcolorizer executable.  A color paletteM will appear on the screen.  Press MB1 over any color cell to pick up a color, H then drag the pointer to the window you want to colorize.  Releasing MB1W will colorize that window.  Clicking MB3 while MB1 is still down cancels the operation.   J You can use MB2 to colorize more than one window without going back to theL color palette for each window.  Using MB1, pick up a color from the palette.J Then, while still holding down MB1, click MB2 over each window you want to  colorize.  Finally, release MB1.  J Colorization effects made by this tool are not saved.  A future version ofE the VColorizer may be able to save color settings in a resource file.   l The VColorizer also includes VDragRoot functionality.  Press Shift/Control/MB3 (Shift/Control/MB2 for MOTIF)2 over any window on the screen and drag to move it.   MODIFICATION HISTORY:   9 11-Oct-1993 (sjk) More portability cleanup.  Thanks Bill!   f 06-Sep-1993 (sjk/nfc) Run through the MOTIF porting tools, functions changed to prototype definitions.   27-Mar-1992 (sjk) Cast.   + 14-Nov-1991 (sjk) Use VtkActivatepopupMenu.   [ 06-Nov-1991 (sjk) More colors and other cleanup.  Thanks to Dave Horner for the new colors!   J 16-Jul-1991 (sjk) Enable and disable root window grabs under user control.J     MOTIF properly shrink-wraps popup menu, conditionalize XUI workaround.  L 08-Aug-1990 (sjk) Partial implementation of application-local customization.F     By using Shift/Control/MB2, a popup menu can be activated allowing(     any color resource to be customized.  2 17-May-1990 (sjk) Include VDragRoot functionality.    15-May-1990 (sjk) Initial entry. */   #include <stdio.h> #include <stdlib.h>  #include "vtoolkit.h"  #include "vfake.h" #include "vdrag.h" #include <X11/cursorfont.h>   6 #define appName			"VColorizer - Drag'n'drop colorizer"' #define appClass		"vcolorizer_defaults"    #define PaletteButton		Button1" #define PalettePaintButton	Button2# #define PaletteCancelButton	Button3    #define defWidth		300  #define defHeight		220 #define PopupButton 		Button3  #define DragButton 		Button2" #define uidFile			"vcolorizer.uid"  9 static Widget wA[32];			/* CreateCallback widget array */  #define paletteW		wA[0]  #define colorNameW		wA[1]  #define colorColorW		wA[2] #define mainW			wA[3]  #define appW			wA[4] #define vRootW			wA[5] #define menuW			wA[6]    static char *colorNameA[] = {  "White", "Black", "Gray",  "Red",	 "Orange", 	 "Yellow",  "Green",
 "Aquamarine",  "Blue",  "Cyan",  "Turquoise",	 "Purple", 	 "Violet",    "Brown", "Tan", "Wheat",   "DarkSlateGray",
 "DimGray", "LightGray", "LightSlateGray",  "SlateGray",   "AntiqueWhite",  "FloralWhite",
 "GhostWhite",  "NavajoWhite",
 "WhiteSmoke",    "IndianRed", "MediumVioletRed", "PaleVioletRed", "VioletRed",   "DeepPink", 
 "HotPink", "LightPink", "Pink",   
 "DarkOrange",  "OrangeRed",   "GreenYellow", "LightGoldenrodYellow",  "LightYellow", "YellowGreen",
 "Thistle",   "DarkGoldenrod", "Gold",  "Goldenrod", "LightGoldenrod",  "MediumGoldenrod", "PaleGoldenrod",   "DarkGreen", "DarkOliveGreen",  "DarkSeaGreen",  "ForestGreen", "LawnGreen", "LightSeaGreen", "LimeGreen", "MediumForestGreen", "MediumSeaGreen",  "MediumSpringGreen", "PaleGreen", "SeaGreen",  "SpringGreen",   "AliceBlue",
 "BlueViolet",  "CadetBlue", "CornflowerBlue",  "DECWblue",  "DarkSlateBlue", "DeepSkyBlue",
 "DodgerBlue",  "LightBlue", "LightSkyBlue",  "LightSlateBlue",  "LightSteelBlue", 
 "MediumBlue",  "MediumSlateBlue", "MidnightBlue",  "NavyBlue", 
 "PowderBlue",  "RoyalBlue",
 "SkyBlue", "SlateBlue", "SteelBlue",   "MediumPurple",    "Azure", "Beige",	 "Bisque",  "BlanchedAlmond",  "Burlywood",
 "Chartreuse",  "Chocolate", "Coral", "Cornsilk",  "DarkKhaki",
 "DarkOrchid", 
 "DarkSalmon",  "DarkTurquoise",
 "DarkViolet",  "Firebrick", "Gainsboro", "Honeydew",  "Ivory", "Khaki", "Lavender",  "LavenderBlush", "LemonChiffon", 
 "LightCoral",  "LightCyan", "LightSalmon", "Linen",
 "Magenta",	 "Maroon",  "MediumAquamarine",  "MediumOrchid",  "MediumTurquoise", "MintCream", "MistyRose", "Moccasin",  "Navy", 
 "OldLace", "OliveDrab",	 "Orchid",  "PaleTurquoise",
 "PapayaWhip",  "PeachPuff", "Peru",  "Plum",  "RosyBrown", "SaddleBrown",	 "Salmon", 
 "SandyBrown",  "Seashell", 	 "Sienna",  "Snow", 	 "Tomato",    "ScreenBackground",  "BorderBackground",  "BorderBottomshadow",  "BorderTopshadow", "WindowBackground",  "WindowBottomshadow",  "WindowTopshadow", };  , static Widget cellWA[XtNumber (colorNameA)];L static XColor xcolorA[XtNumber (colorNameA)];		/* palette cell RGB colors */H static char *colorNamePA[XtNumber (colorNameA)];	/* name of each cell */J static XColor blackRGB, whiteRGB;			/* colors for the cursor background */ static Cursor paintCursor;! static MrmHierarchy mrmHierarchy;  static XrmDatabase database;9 static int currentColorIndex, rootGrabsEnabled, colorCnt; A static int paletteButtonIsActive, colorizeOnPaletteButtonRelease;   static Window popupTargetWindow;  static Widget popupTargetWidget;  W static void CreateCallback (Widget w, int *indexP, XmAnyCallbackStruct *unused_cbDataP)  {      wA[*indexP] = w; }   m static void SaveGeometryCallback(Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP)  { 
     int i;     char resourceNameA[64];   $     for (i = 0; i < colorCnt; i++) {+ 	sprintf (resourceNameA, "cellColor%d", i); B 	VtkSaveStringResource (&database, resourceNameA, colorNamePA[i]);     }   9     VtkSaveNumericResourceN (&database, mainW, XtNwidth); :     VtkSaveNumericResourceN (&database, mainW, XtNheight);4     VtkSaveNumericResourceN (&database, appW, XtNx);4     VtkSaveNumericResourceN (&database, appW, XtNy);  =     XrmPutFileDatabase (database, VtkGetDefaultsName (appW));  }   f static void QuitCallback (Widget unused_w, Opaque unused_closure, XmAnyCallbackStruct *unused_cbDataP) { 
     exit (0);  }   G static void ShufflePalette(int fromIndex, int toIndex, int shuffleFlag)  { 
     int i;     Pixel tempColor;     char *tempNameP;     XColor tempXColor;  2     tempColor  = XtBackground (cellWA[fromIndex]);(     tempNameP  = colorNamePA[fromIndex];$     tempXColor = xcolorA[fromIndex];       if (!shuffleFlag) { U 	XtVaSetValues (cellWA[fromIndex], XtNbackground, XtBackground (cellWA[toIndex]), 0); / 	colorNamePA[fromIndex] = colorNamePA[toIndex]; + 	xcolorA[fromIndex]     = xcolorA[toIndex];      } else { 	if (fromIndex > toIndex) , 	    for (i = fromIndex; i > toIndex; i--) {L 		XtVaSetValues (cellWA[i], XtNbackground, XtBackground (cellWA[i - 1]), 0);& 		colorNamePA[i] = colorNamePA[i - 1];" 		xcolorA[i]     = xcolorA[i - 1]; 	    } 	else , 	    for (i = fromIndex; i < toIndex; i++) {L 		XtVaSetValues (cellWA[i], XtNbackground, XtBackground (cellWA[i + 1]), 0);& 		colorNamePA[i] = colorNamePA[i + 1];" 		xcolorA[i]     = xcolorA[i + 1]; 	    }     }   A     XtVaSetValues (cellWA[toIndex], XtNbackground, tempColor, 0); %     colorNamePA[toIndex] = tempNameP; &     xcolorA[toIndex]     = tempXColor; }    static void UpdateDisplay(void)  { e     char *labelP = (char *)XmStringCreate (colorNamePA[currentColorIndex], XmSTRING_DEFAULT_CHARSET);   :     XtVaSetValues (colorNameW, XmNlabelString, labelP, 0);     XtFree (labelP);\     XtVaSetValues (colorColorW, XtNbackground, XtBackground (cellWA[currentColorIndex]), 0); }   K static Window GetSubwindow(Window window, int x, int y, Window avoidWindow)  { #     Window subwindow, newSubwindow;        subwindow = window;        while (subwindow) { * 	if (subwindow == avoidWindow) return (0);  Z 	XTranslateCoordinates (XtDisplay (appW), window, subwindow, x, y, &x, &y, &newSubwindow);   	window = subwindow; 	subwindow = newSubwindow;     }        return (window); }   N static void PopupCallback(Widget w, int *indexP, XmAnyCallbackStruct *cbDataP) { B     char *resourceNameP = (char *)VtkGetOneValue (w, XmNuserData);       if (popupTargetWindow) {. 	if (!strcmp (resourceNameP, XtNbackground)) {k 	    XSetWindowBackground (XtDisplay (appW), popupTargetWindow, 	XtBackground (cellWA[currentColorIndex]));   L             XClearArea (XtDisplay (appW), popupTargetWindow, 0, 0, 0, 0, 1);6 	} else if (!strcmp (resourceNameP, XtNborderColor)) {f 	    XSetWindowBorder (XtDisplay (appW), popupTargetWindow, XtBackground (cellWA[currentColorIndex])); 	}     } else {_ 	XtVaSetValues (popupTargetWidget, resourceNameP, XtBackground (cellWA[currentColorIndex]), 0);      }  }   3 static void RemoveAllMenuEntries(Widget popupMenuW)  { G     int numChildren = (int)VtkGetOneValue (popupMenuW, XmNnumChildren); K     Widget *childrenP = (Widget *)VtkGetOneValue (popupMenuW, XmNchildren);   A     if (numChildren) XtUnmanageChildren (childrenP, numChildren);  }   C static void AddMenuEntry(Widget popupMenuW, char *labelP, int slot)  { G     int numChildren = (int)VtkGetOneValue (popupMenuW, XmNnumChildren); K     Widget *childrenP = (Widget *)VtkGetOneValue (popupMenuW, XmNchildren);      MrmCode class;
     Widget w; N     char *xValueP = (char *)XmStringCreate (labelP, XmSTRING_DEFAULT_CHARSET);  q     if (numChildren <= slot) (void)MrmFetchWidget (mrmHierarchy, "vColorizerPopupEntry", popupMenuW, &w, &class);      else w = childrenP[slot];   G     XtVaSetValues (w, XmNlabelString, xValueP, XmNuserData, labelP, 0);      XtFree (xValueP);  }   ; static int LoadWindowMenu(Widget popupMenuW, Window window)  {      int cnt = 0;  5     AddMenuEntry (popupMenuW, XtNbackground,  cnt++); 5     AddMenuEntry (popupMenuW, XtNborderColor, cnt++);        popupTargetWindow = window;      popupTargetWidget = 0;       return (cnt);  }   ' static XrmQuark pixelResourceTypeQ = 0;   6 static int LoadWidgetMenu(Widget popupMenuW, Widget w) { F     CoreClassPart *coreClassP = (CoreClassPart *)w->core.widget_class;>     XtResource **resPP = (XtResource **)coreClassP->resources;+     int resCnt = coreClassP->num_resources;      int i, cnt;      XtResource *resP;   N     if (!pixelResourceTypeQ) pixelResourceTypeQ = XrmStringToQuark (XtRPixel);  4     for (i = 0, cnt = 0; i < resCnt; i++, resPP++) { 	resP = *resPP;   @         if ((XrmQuark)resP->resource_type == pixelResourceTypeQ)S 	    AddMenuEntry (popupMenuW, XrmQuarkToString ((int)resP->resource_name), cnt++);      }        popupTargetWindow = 0;     popupTargetWidget = w;       return (cnt);  }   p static void PopupButtonPressHandler(Widget w, XtPointer popupMenuOW, XEvent *eventOP, Boolean *unused_continueP) { ,     Widget popupMenuW = (Widget)popupMenuOW;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;      Window window;     Widget targetW;      int cnt;  &     /* Wrong modifiers?  Ignore it. */  S     if ((!(eventP->state & ShiftMask)) || (!(eventP->state & ControlMask))) return;   #     /* Wrong button?  Ignore it. */   .     if (eventP->button != PopupButton) return;  M     /* Determine the target window, but don't colorize within the palette. */   `     window = GetSubwindow (eventP->window, eventP->x_root, eventP->y_root, XtWindow (paletteW));       if (!window) { 	XBell (XtDisplay (appW), 0);  	return;     }        /* Load the popup menu. */  &     RemoveAllMenuEntries (popupMenuW);  j     if (targetW = XtWindowToWidget (XtDisplay (appW), window)) cnt = LoadWidgetMenu (popupMenuW, targetW);@     else 						       cnt = LoadWindowMenu (popupMenuW, window);  O     XtManageChildren ((Widget *)VtkGetOneValue (popupMenuW, XmNchildren), cnt);   8     VtkActivatePopupMenu (popupMenuW, (XEvent*) eventP); }   4 static void ColorizeBackground(XButtonEvent *eventP) {      Window window;     Widget widget;
     int i;  d     window = GetSubwindow (RootWindowOfScreen (XtScreen (appW)), eventP->x_root, eventP->y_root, 0);     if (!window) return;  9     widget = XtWindowToWidget (XtDisplay (appW), window); 2     if (widget && (XtParent (widget) == paletteW)): 	for (i = 0; i < colorCnt; i++) if (cellWA[i] == widget) {H 	    ShufflePalette (currentColorIndex, i, (eventP->state & ShiftMask)); 	    return; 	}  ^     XSetWindowBackground (XtDisplay (appW), window, XtBackground (cellWA[currentColorIndex]));  J     /* Clear the window and force exposure to apply the new background. */  9     XClearArea (XtDisplay (appW), window, 0, 0, 0, 0, 1);  }   o static void PaletteButtonReleaseHandler(Widget w, XtPointer indexO, XEvent *eventOP, Boolean *unused_continueP)  {      int index = (int)indexO;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;   '     if (!paletteButtonIsActive) return;   0     if (eventP->button != PaletteButton) return;  D     if (colorizeOnPaletteButtonRelease) ColorizeBackground (eventP);       paletteButtonIsActive = 0; }   u static void PaletteButtonPressHandler(Widget w, XtPointer unused_closure, XEvent *eventOP, Boolean *unused_continueP)  { 3     XButtonEvent *eventP = (XButtonEvent *)eventOP;      XColor *backP;        if (paletteButtonIsActive) {, 	if (eventP->button == PalettePaintButton) {! 	    ColorizeBackground (eventP); ( 	    colorizeOnPaletteButtonRelease = 0;  4 	} else if (eventP->button == PaletteCancelButton) {5 	    XUngrabPointer (XtDisplay (appW), eventP->time);  	    paletteButtonIsActive = 0;  	}   	return;     }   0     if (eventP->button != PaletteButton) return;  v     /* If there is a subwindow (widget), it must be a palette cell.  The cell's user data contains its color index. */  Z     if (eventP->subwindow && (w = XtWindowToWidget (XtDisplay (appW), eventP->subwindow))): 	currentColorIndex = (int)VtkGetOneValue (w, XmNuserData);  r     /* Pick an appropriate background color for the cursor.  Make sure it is not equal to the foreground color. */  N     if (xcolorA[currentColorIndex].pixel != whiteRGB.pixel) backP = &whiteRGB;%     else 						    backP = &blackRGB;   W     XRecolorCursor (XtDisplay (appW), paintCursor, backP, &xcolorA[currentColorIndex]);        UpdateDisplay ();        paletteButtonIsActive = 1;'     colorizeOnPaletteButtonRelease = 1;  }    static void CreatePalette(void)  { $     int i, ac, cellsHigh, cellsWide;     XColor dummy;      MrmCode class;     Arg args[16];      char resourceNameA[64];      char *colorNameP;        colorCnt = 0;   Y     XAllocNamedColor (XtDisplay (appW), appW->core.colormap, "white", &dummy, &whiteRGB); Y     XAllocNamedColor (XtDisplay (appW), appW->core.colormap, "black", &dummy, &blackRGB);   1     for (i = 0; i < XtNumber (colorNameA); i++) { + 	sprintf (resourceNameA, "cellColor%d", i); h 	if (!(colorNameP = (char *)VtkGetStringResource (database, resourceNameA))) colorNameP = colorNameA[i];  h 	if (XAllocNamedColor (XtDisplay (appW), appW->core.colormap, colorNameP, &dummy, &xcolorA[colorCnt])) {( 	    colorNamePA[colorCnt] = colorNameP; 	    colorCnt++; 	}     }        cellsHigh = colorCnt;      cellsWide = 1;  #     while (cellsHigh > cellsWide) { 
 	cellsWide++; 4 	cellsHigh = (colorCnt + cellsWide - 1) / cellsWide;     }   H     XtVaSetValues (paletteW, XmNfractionBase, cellsWide * cellsHigh, 0);  $     for (i = 0; i < colorCnt; i++) { 	ac = 0;C 	XtSetArg (args[ac], XtNbackground,	   xcolorA[i].pixel); 				ac++; K 	XtSetArg (args[ac], XmNleftPosition,   (i%cellsWide) * cellsHigh);			ac++; U 	XtSetArg (args[ac], XmNrightPosition,  (i%cellsWide) * cellsHigh + cellsHigh);	ac++; K 	XtSetArg (args[ac], XmNtopPosition,    (i/cellsWide) * cellsWide);			ac++; U 	XtSetArg (args[ac], XmNbottomPosition, (i/cellsWide) * cellsWide + cellsWide);	ac++; 9 	XtSetArg (args[ac], XmNuserData,          i);						ac++;   q         (void)MrmFetchWidgetOverride (mrmHierarchy, "vColorizerCell", paletteW, 0, args, ac, &cellWA[i], &class);      }*  1     XtManageChildren (cellWA, XtNumber (cellWA));* }* *" static void DisableRootGrabs(void) {i"     if (!rootGrabsEnabled) return;       VDragDisable (vRootW);       XUngrabButton (u% 	XtDisplay (vRootW),				/* display */i# 	PopupButton,					/* button_grab */*+ 	ShiftMask | ControlMask,			/* modifiers */*$ 	XtWindow (vRootW));				/* window */  Y     XtRemoveRawEventHandler (vRootW, ButtonPressMask, 0, PopupButtonPressHandler, menuW);r       rootGrabsEnabled = 0;  }   ! static void EnableRootGrabs(void)n {u     MrmCode class;  !     if (rootGrabsEnabled) return;t  L     /* Create a VFake widget and pass it the window ID of the root window on:      * the same screen as the application shell widget. */       if (!vRootW) {4 	vRootW = (Widget)VFakeCreate (appW, "vFake", 0, 0);S     	XtVaSetValues (vRootW, VFakeNwindow, RootWindowOfScreen (XtScreen (appW)), 0);a     	XtRealizeWidget (vRootW);     }d  B     VDragEnableGrab (vRootW, DragButton, ShiftMask | ControlMask);  ]     if (!menuW) MrmFetchWidget (mrmHierarchy, "vColorizerPopupMenu", vRootW, &menuW, &class);d       XGrabButton (i' 	XtDisplay (vRootW),						/* display */n% 	PopupButton,							/* button_grab */d- 	ShiftMask | ControlMask,					/* modifiers */b% 	XtWindow (vRootW),						/* window */  	1,								/* owner_events */nK 	(ButtonPressMask | ButtonMotionMask | ButtonReleaseMask),	/* event_mask */o( 	GrabModeAsync,							/* pointer_mode */) 	GrabModeAsync,							/* keyboard_mode */  	None,								/* confine_to */ 	0);								/* cursor */  V     XtAddRawEventHandler (vRootW, ButtonPressMask, 0, PopupButtonPressHandler, menuW);       rootGrabsEnabled = 1;r }9  Y static void RootCallback(Widget w, Opaque closure, XmToggleButtonCallbackStruct *cbDataP)r {n     int newValue;h       newValue = cbDataP->set;  %     if (newValue) EnableRootGrabs ();d     else	  DisableRootGrabs ();e }o o- static void EstablishOnePaletteGrab(Widget w)  {d     XGrabButton (a# 	XtDisplay (appW),				/* display */m% 	PaletteButton,					/* button_grab */m! 	AnyModifier,					/* modifiers */l 	XtWindow (w),					/* window */e 	0,						/* owner_events */o9 	(ButtonPressMask | ButtonReleaseMask),		/* event_mask */o& 	GrabModeAsync,					/* pointer_mode */' 	GrabModeAsync,					/* keyboard_mode */i 	None,						/* confine_to */ 	paintCursor);					/* cursor */   S     XtAddRawEventHandler (w, ButtonPressMask,   0, PaletteButtonPressHandler,   0);gS     XtAddRawEventHandler (w, ButtonReleaseMask, 0, PaletteButtonReleaseHandler, 0);	 }t 1+ static MrmRegisterArg mrmRegisterArgs[] = { 9     {"VColorizerCreateCallback",	(char *)CreateCallback},f8     {"VColorizerPopupCallback",		(char *)PopupCallback},6     {"VColorizerQuitCallback",		(char *)QuitCallback},6     {"VColorizerRootCallback",		(char *)RootCallback},E     {"VColorizerSaveGeometryCallback",	(char *)SaveGeometryCallback},      };   int main(int argc, char **argv)  {f     MrmCode class;       MrmInitialize ();f       if (!VtkInitialize (appName, appClass, &argc, argv, uidFile, mrmRegisterArgs, XtNumber (mrmRegisterArgs), &mrmHierarchy, &appW))
 	exit (0);  >     database = XrmGetFileDatabase (VtkGetDefaultsName (appW));  J     MrmFetchWidget (mrmHierarchy, "vColorizerMain", appW, &mainW, &class);       CreatePalette ();tK     UpdateDisplay ();	/* set initial values for colorName and colorColor */   I     /* If there was no resource file, set the default window geometry. */n  V     if (!database) XtVaSetValues (mainW, XtNwidth, defWidth, XtNheight, defHeight, 0);  J     /* Some versions of the toolkit need coaxing to propagate the size. */       XtVaSetValues (appW, 	XtNwidth, 	mainW->core.width,  	XtNheight, 	mainW->core.height, 	0);  9     /* Manage and realize the main window widget tree. */n       XtManageChild (mainW);     XtRealizeWidget (appW);r  -     /* Establish all passive button grabs. */n  D     paintCursor = XCreateFontCursor (XtDisplay (appW), XC_spraycan);  '     EstablishOnePaletteGrab (paletteW);D*     EstablishOnePaletteGrab (colorColorW);       XtMainLoop (); }l