/ /* vhist.c - VHist widget implementation module   O ******************************************************************************* G * VToolkit (1995) 	"If it doesn't use VToolkit, it isn't cool!"	      *  * (c) Steve Klein							      * O * Unpublished rights reserved under the copyright laws of the United States.  * O *******************************************************************************   ( This module implements the VHist widget.   MODIFICATION HISTORY:   : 03-Dec-1993 (sjk) Even more portability work.  Thanks Roy!  9 11-Oct-1993 (sjk) More portability cleanup.  Thanks Bill!   B 16-Sep-1993 (sjk) Bugfix typedef for ALPHA/OSF.  Thanks Jean-Paul!   14-Sep-1993 (sjk) Reapply bugfix from 17-Apr-1992 - typo in ComputeLeftRightLabelPosition, alignment VHistAlignmentRight option.  a 03-Sep-1993 (sjk/nfc) Run through the Motif porting tools, cleaned up, functions changed from old H 	declaration style to prototype style, #if... MOTIF conditional removed.  q 19-Mar-1992 (sjk) Bugfix - don't call CopyFonts in DoRealize.  Do call it in DoSetValues.  Conditionalize #pragma  	for VMS only.  a 06-Nov-1991 (sjk) Code cleanup for new baselevel.  Change default margin resource values to zero.  	Add VHistNunitType resource.   | 22-Oct-1991 (tmr) Modified to work with Motif font units and changed name of initialization routine to VHistInitializeForMRM 	when MOTIF is defined.   d 15-Oct-1991 (tmr) Fixed SetValues for left/right/top/bottom Margin Width(s) and Height(s) resources.  z 01-Jun-1990 (sjk) Add support for colored bars, colored grid lines,  VHistNuserData resource, per-bar and per-grid closureo 	(user-data).  Pass a copy of the VHistBar entry to callbacks (in the callback struct).  Add latent support for n 	stippled bars.  Significant code cleanup.  Incompatible user interface change due to the now-required passing9 	of a mask in both the VHistBar and VHistGrid structures.   P 14-May-1990 (sjk) Use portable VTK font routines, motivated by MOTIF BL1.1 port.  ( 20-Apr-1990 (sjk) More portability work.  E 10-Apr-1990 (sjk) Add MOTIF support.  Improve C-compiler portability.   5 05-Apr-1990 (sjk) Add VHistOrientationBestFit option.   8 22-Feb-1990 (sjk) Fix 8-bit character width calculation.  # 02-Jan-1990 (sjk) Select callbacks.     12-Sep-1989 (sjk) Initial entry. */   #include "vtoolkit.h"  #include "vhistp.h"   R #define OrientationVertical(w)		(w->actualOrientation == VHistOrientationVertical)  > static void CopyLabel(char **labelInfoLabelPP, char **labelPP) { ^     (*labelPP) = (*labelInfoLabelPP) = (char *)VtkRecloneString (*labelInfoLabelPP, *labelPP); }   C static void ComputeLabelWidth(VHistWidget w, LabelInfo *labelInfoP)  { K     labelInfoP->width = VtkComputeTextWidth (w->fontP, labelInfoP->labelP);  }   4 static void ComputeAllGridLabelWidths(VHistWidget w) { 
     int i;     GridInfo *gridInfoP;  N     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++) {1 	ComputeLabelWidth (w, &gridInfoP->lowLabelInfo); 2 	ComputeLabelWidth (w, &gridInfoP->highLabelInfo);     }  }   3 static void ComputeAllBarLabelWidths(VHistWidget w)  { 
     int i;     BarInfo *barInfoP;  J     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) {0 	ComputeLabelWidth (w, &barInfoP->lowLabelInfo);1 	ComputeLabelWidth (w, &barInfoP->highLabelInfo);      }  }   9 static Pixel ColoridxToColor(VHistWidget w, int coloridx)  { 0     if (!w->colorList) return ((Pixel)coloridx);Q     else 	       return (w->colorTableP[((unsigned int)coloridx % w->colorCnt)]);  }   ) static int ValueToY(VHistWidget w, int v)  { +     int vRange = w->maxValue - w->minValue;   s     return (w->insideBottomY - (((v - w->minValue) * (w->insideBottomY - w->insideTopY) + (vRange - 1)) / vRange));  }   \ static int ValuesToYs(VHistWidget w, int lowValue, int highValue, int *bottomYP, int *topYP) { ;     VtkMinMax (lowValue, highValue, &lowValue, &highValue);   @     if ((highValue < w->minValue) || (lowValue > w->maxValue)) { 	*bottomYP = (-1); 	*topYP    = (-1); 	return (0);     }   9     if (highValue > w->maxValue) highValue = w->maxValue; 9     if (lowValue  < w->minValue) lowValue  = w->minValue;   '     *bottomYP = ValueToY (w, lowValue); (     *topYP    = ValueToY (w, highValue);       return (1);  }   ) static int ValueToX(VHistWidget w, int v)  { +     int vRange = w->maxValue - w->minValue;   q     return (w->insideLeftX + (((v - w->minValue) * (w->insideRightX - w->insideLeftX) + (vRange - 1)) / vRange));  }   \ static int ValuesToXs(VHistWidget w, int lowValue, int highValue, int *leftXP, int *rightXP) { ;     VtkMinMax (lowValue, highValue, &lowValue, &highValue);   @     if ((highValue < w->minValue) || (lowValue > w->maxValue)) { 	*leftXP  = (-1);  	*rightXP = (-1);  	return (0);     }   9     if (highValue > w->maxValue) highValue = w->maxValue; 9     if (lowValue  < w->minValue) lowValue  = w->minValue;   &     *leftXP  = ValueToX (w, lowValue);'     *rightXP = ValueToX (w, highValue);        return (1);  }   t #define ConvertWidth(f, t)  w->f = XmConvertUnits ((struct _WidgetRec*)w, XmHORIZONTAL, w->unitType, w->t, XmPIXELS)t #define ConvertHeight(f, t) w->f = XmConvertUnits ((struct _WidgetRec*)w, XmVERTICAL,   w->unitType, w->t, XmPIXELS)  / static void ConvertFromFontUnits(VHistWidget w)  { 7     ConvertWidth (leftMarginWidth, 		leftMarginWidthU); 9     ConvertWidth (rightMarginWidth, 		rightMarginWidthU); ?     ConvertWidth (leftAxisMarginWidth, 		leftAxisMarginWidthU); @     ConvertWidth (rightAxisMarginWidth, 	rightAxisMarginWidthU);5     ConvertWidth (leftLabelWidth, 		leftLabelWidthU); 7     ConvertWidth (rightLabelWidth, 		rightLabelWidthU);   8     ConvertHeight (topMarginHeight, 		topMarginHeightU);>     ConvertHeight (bottomMarginHeight, 		bottomMarginHeightU);?     ConvertHeight (topAxisMarginHeight, 	topAxisMarginHeightU); E     ConvertHeight (bottomAxisMarginHeight, 	bottomAxisMarginHeightU); 6     ConvertHeight (topLabelHeight, 		topLabelHeightU);<     ConvertHeight (bottomLabelHeight, 		bottomLabelHeightU); }   / static void ComputeAxisPositions(VHistWidget w)  { g     w->totalLeftMarginWidth    = w->leftMarginWidth    + w->leftLabelWidth    + w->leftAxisMarginWidth; h     w->totalRightMarginWidth   = w->rightMarginWidth   + w->rightLabelWidth   + w->rightAxisMarginWidth;g     w->totalTopMarginHeight    = w->topMarginHeight    + w->topLabelHeight    + w->topAxisMarginHeight; j     w->totalBottomMarginHeight = w->bottomMarginHeight + w->bottomLabelHeight + w->bottomAxisMarginHeight;  D     w->insideLeftX = w->totalLeftMarginWidth + w->leftAxisThickness;  [     w->insideRightX = w->core.width - w->totalRightMarginWidth - w->rightAxisThickness - 1; P     if (w->insideRightX <= w->insideLeftX) w->insideRightX = w->insideLeftX + 1;  B     w->insideTopY = w->totalTopMarginHeight + w->topAxisThickness;  `     w->insideBottomY = w->core.height - w->totalBottomMarginHeight - w->bottomAxisThickness - 1;P     if (w->insideBottomY <= w->insideTopY) w->insideBottomY = w->insideTopY + 1;  )     w->leftLabelX   = w->leftMarginWidth; O     w->rightLabelX  = w->core.width - w->rightMarginWidth - w->rightLabelWidth; )     w->topLabelY    = w->topMarginHeight; M     w->bottomLabelY = w->core.height - w->bottomMarginHeight - w->charHeight;   +     w->horizontalAxisLength = w->core.width 2 	- w->totalLeftMarginWidth  - w->leftAxisThickness4 	- w->totalRightMarginWidth - w->rightAxisThickness;B     if (w->horizontalAxisLength <= 0) w->horizontalAxisLength = 1;  *     w->verticalAxisLength = w->core.height3 	- w->totalTopMarginHeight    - w->topAxisThickness 7 	- w->totalBottomMarginHeight - w->bottomAxisThickness; >     if (w->verticalAxisLength <= 0) w->verticalAxisLength = 1; }   9 static int ComputeBarWidth(VHistWidget w, int axisLength)  { 2     return ((axisLength * w->spacingDenominator) /T 	(w->barCnt * (w->spacingNumerator + w->spacingDenominator) + w->spacingNumerator)); }   6 static void ComputeVerticalBarPositions(VHistWidget w) {      BarInfo *barInfoP;(     int i, totalBarWidth, barSpacing, x;       if (!w->barCnt) return;   ?     w->barWidth = ComputeBarWidth (w, w->horizontalAxisLength);   ,     totalBarWidth = w->barWidth * w->barCnt;  M     barSpacing = (w->horizontalAxisLength - totalBarWidth) / (w->barCnt + 1);   6     x = w->totalLeftMarginWidth + w->leftAxisThickness+ 	+ (w->horizontalAxisLength - totalBarWidth % 	- barSpacing * (w->barCnt - 1)) / 2;   J     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) { 	barInfoP->x = x; ! 	x += (w->barWidth + barSpacing);      }  }   8 static void ComputeHorizontalBarPositions(VHistWidget w) {      BarInfo *barInfoP;(     int i, totalBarWidth, barSpacing, y;       if (!w->barCnt) return;   =     w->barWidth = ComputeBarWidth (w, w->verticalAxisLength);   ,     totalBarWidth = w->barWidth * w->barCnt;  K     barSpacing = (w->verticalAxisLength - totalBarWidth) / (w->barCnt + 1);   5     y = w->totalTopMarginHeight + w->topAxisThickness ) 	+ (w->verticalAxisLength - totalBarWidth % 	- barSpacing * (w->barCnt - 1)) / 2;   J     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) { 	barInfoP->y = y; ! 	y += (w->barWidth + barSpacing);      }  }   a static void ComputeLeftRightLabelPosition(VHistWidget w, int alignment, int x, int y, int width,  ( 			int thickness, LabelInfo *labelInfoP) { #     if (!labelInfoP->width) return;   A     if (alignment == VHistAlignmentLeft)       labelInfoP->x = x; ]     else if (alignment == VHistAlignmentRight) labelInfoP->x = x + width - labelInfoP->width; H     else 				       labelInfoP->x = x + (width - labelInfoP->width) / 2;  8     labelInfoP->y = y + (thickness - w->charHeight) / 2; }   L static void ComputeLeftGridLabelPosition(VHistWidget w, GridInfo *gridInfoP) { K     ComputeLeftRightLabelPosition (w, w->leftLabelAlignment, w->leftLabelX, ? 	gridInfoP->y, w->leftLabelWidth, 1, &gridInfoP->lowLabelInfo);  }   M static void ComputeRightGridLabelPosition(VHistWidget w, GridInfo *gridInfoP)  { M     ComputeLeftRightLabelPosition (w, w->rightLabelAlignment, w->rightLabelX, A 	gridInfoP->y, w->rightLabelWidth, 1, &gridInfoP->highLabelInfo);  }   I static void ComputeLeftBarLabelPosition(VHistWidget w, BarInfo *barInfoP)  { K     ComputeLeftRightLabelPosition (w, w->leftLabelAlignment, w->leftLabelX, G 	barInfoP->y, w->leftLabelWidth, w->barWidth, &barInfoP->lowLabelInfo);  }   J static void ComputeRightBarLabelPosition(VHistWidget w, BarInfo *barInfoP) { M     ComputeLeftRightLabelPosition (w, w->rightLabelAlignment, w->rightLabelX, I 	barInfoP->y, w->rightLabelWidth, w->barWidth, &barInfoP->highLabelInfo);  }   l static void ComputeTopBottomLabelPosition(VHistWidget w, int x, int y, int thickness, LabelInfo *labelInfoP) { #     if (!labelInfoP->width) return;   <     labelInfoP->x = x + (thickness - labelInfoP->width) / 2;     labelInfoP->y = y; }   K static void ComputeTopGridLabelPosition(VHistWidget w, GridInfo *gridInfoP)  { _     ComputeTopBottomLabelPosition (w, gridInfoP->x, w->topLabelY, 1, &gridInfoP->lowLabelInfo);  }   N static void ComputeBottomGridLabelPosition(VHistWidget w, GridInfo *gridInfoP) { c     ComputeTopBottomLabelPosition (w, gridInfoP->x, w->bottomLabelY, 1, &gridInfoP->highLabelInfo);  }   H static void ComputeTopBarLabelPosition(VHistWidget w, BarInfo *barInfoP) { h     ComputeTopBottomLabelPosition (w, barInfoP->x, w->topLabelY, w->barWidth, &barInfoP->highLabelInfo); }   K static void ComputeBottomBarLabelPosition(VHistWidget w, BarInfo *barInfoP)  { j     ComputeTopBottomLabelPosition (w, barInfoP->x, w->bottomLabelY, w->barWidth, &barInfoP->lowLabelInfo); }   3 static void ComputeActualOrientation(VHistWidget w)  { _     if (w->orientation != VHistOrientationBestFit)	      w->actualOrientation = w->orientation; n     else if (w->verticalAxisLength > w->horizontalAxisLength) w->actualOrientation = VHistOrientationVertical;G     else 						      w->actualOrientation = VHistOrientationHorizontal;  }   M static void ComputeHorizontalGridPosition(VHistWidget w, GridInfo *gridInfoP)  { 8     gridInfoP->y = ValueToY (w, gridInfoP->vGrid.value); }   K static void ComputeVerticalGridPosition(VHistWidget w, GridInfo *gridInfoP)  { 8     gridInfoP->x = ValueToX (w, gridInfoP->vGrid.value); }   6 static void ComputeAllVerticalPositions(VHistWidget w) { 
     int i;     BarInfo *barInfoP;     GridInfo *gridInfoP;  N     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++) {. 	ComputeHorizontalGridPosition (w, gridInfoP);. 	ComputeLeftGridLabelPosition  (w, gridInfoP);. 	ComputeRightGridLabelPosition (w, gridInfoP);     }   $     ComputeVerticalBarPositions (w);  J     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) {- 	ComputeTopBarLabelPosition    (w, barInfoP); .  	ComputeBottomBarLabelPosition (w, barInfoP);     }  }   8 static void ComputeAllHorizontalPositions(VHistWidget w) { 
     int i;     BarInfo *barInfoP;     GridInfo *gridInfoP;  N     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++) {/ 	ComputeVerticalGridPosition    (w, gridInfoP); / 	ComputeTopGridLabelPosition    (w, gridInfoP); / 	ComputeBottomGridLabelPosition (w, gridInfoP);      }   &     ComputeHorizontalBarPositions (w);  J     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) {, 	ComputeLeftBarLabelPosition  (w, barInfoP);, 	ComputeRightBarLabelPosition (w, barInfoP);     }  }   # static void DrawAxes(VHistWidget w)  {      if (w->leftAxisThickness) q         XFillRectangle (XtDisplay (w), XtWindow (w), w->normGC, w->totalLeftMarginWidth, w->totalTopMarginHeight, a 	    w->leftAxisThickness, w->topAxisThickness + w->verticalAxisLength + w->bottomAxisThickness);        if (w->rightAxisThickness)m         XFillRectangle (XtDisplay (w), XtWindow (w), w->normGC, w->insideRightX + 1, w->totalTopMarginHeight, b 	    w->rightAxisThickness, w->topAxisThickness + w->verticalAxisLength + w->bottomAxisThickness);       if (w->topAxisThickness)q         XFillRectangle (XtDisplay (w), XtWindow (w), w->normGC, w->totalLeftMarginWidth, w->totalTopMarginHeight, b 	    w->leftAxisThickness + w->horizontalAxisLength + w->rightAxisThickness, w->topAxisThickness);       if (w->bottomAxisThickness) n         XFillRectangle (XtDisplay (w), XtWindow (w), w->normGC, w->totalLeftMarginWidth, w->insideBottomY + 1,e 	    w->leftAxisThickness + w->horizontalAxisLength + w->rightAxisThickness, w->bottomAxisThickness);  }   ; static void DrawLabel(VHistWidget w, LabelInfo *labelInfoP)  { #     if (!labelInfoP->width) return;   {     XDrawString (XtDisplay (w), XtWindow (w), w->normGC, labelInfoP->x, labelInfoP->y + w->yFontAdjust, labelInfoP->labelP,  	strlen (labelInfoP->labelP)); }   = static void UndrawLabel(VHistWidget w, LabelInfo *labelInfoP)  { #     if (!labelInfoP->width) return;   p     XClearArea (XtDisplay (w), XtWindow (w), labelInfoP->x, labelInfoP->y, labelInfoP->width, w->charHeight, 0); }   ( static void DrawAllLabels(VHistWidget w) { 
     int i;     GridInfo *gridInfoP;     BarInfo *barInfoP;  N     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++) {) 	DrawLabel (w, &gridInfoP->lowLabelInfo); * 	DrawLabel (w, &gridInfoP->highLabelInfo);     }   J     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) {( 	DrawLabel (w, &barInfoP->lowLabelInfo);) 	DrawLabel (w, &barInfoP->highLabelInfo);      }  }   ] static int HorizontalGridIsVisible(VHistWidget w, GridInfo *gridInfoP, int topY, int bottomY)  { 4     if (!gridInfoP->vGrid.dashOn)  			   return (0);F     if ((gridInfoP->y < topY) || (gridInfoP->y > bottomY)) return (0);     return (1);  }   [ static int VerticalGridIsVisible(VHistWidget w, GridInfo *gridInfoP, int leftX, int rightX)  { 3     if (!gridInfoP->vGrid.dashOn) 			   return (0); F     if ((gridInfoP->x < leftX) || (gridInfoP->x > rightX)) return (0);     return (1);  }   < static int GridIsVisible(VHistWidget w, GridInfo *gridInfoP) { r     if (OrientationVertical (w)) return (HorizontalGridIsVisible (w, gridInfoP, w->insideLeftX, w->insideRightX));_     else 			 return (VerticalGridIsVisible   (w, gridInfoP, w->insideTopY,  w->insideBottomY));  }   I static void SetGridGC(VHistWidget w, GridInfo *gridInfoP, int dashOffset)  { )     int dashOn = gridInfoP->vGrid.dashOn;*+     int dashOff = gridInfoP->vGrid.dashOff;kA     Pixel color = ColoridxToColor (w, gridInfoP->vGrid.coloridx);        char dashList[2];   %     dashOffset %= (dashOn + dashOff);   n     if ((dashOn == w->gridGCDashOn) && (dashOff == w->gridGCDashOff) && (dashOffset == w->gridGCDashOffset) &&(       (color == w->gridGCColor)) return;       dashList[0] = dashOn;N     dashList[1] = dashOff;  C     XSetDashes (XtDisplay (w), w->gridGC, dashOffset, dashList, 2);p  5     XSetForeground (XtDisplay (w), w->gridGC, color);u  !     w->gridGCDashOn     = dashOn;e"     w->gridGCDashOff    = dashOff;%     w->gridGCDashOffset = dashOffset;p      w->gridGCColor      = color; }V tp static void DrawHorizontalGrid(VHistWidget w, GridInfo *gridInfoP, int leftX, int rightX, int topY, int bottomY) {oG     if (!HorizontalGridIsVisible (w, gridInfoP, topY, bottomY)) return;e  5     SetGridGC (w, gridInfoP, leftX - w->insideLeftX);   b     XDrawLine (XtDisplay (w), XtWindow (w), w->gridGC, leftX, gridInfoP->y, rightX, gridInfoP->y); }o  1 static void DrawAllHorizontalGrids(VHistWidget w)r {u
     int i;     GridInfo *gridInfoP;  L     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++)e 	DrawHorizontalGrid (w, gridInfoP, w->insideLeftX, w->insideRightX, w->insideTopY, w->insideBottomY);  }r  n static void DrawVerticalGrid(VHistWidget w, GridInfo *gridInfoP, int leftX, int rightX, int topY, int bottomY) { E     if (!VerticalGridIsVisible (w, gridInfoP, leftX, rightX)) return;   3     SetGridGC (w, gridInfoP, topY - w->insideTopY);   b     XDrawLine (XtDisplay (w), XtWindow (w), w->gridGC, gridInfoP->x, topY, gridInfoP->x, bottomY); }a  / static void DrawAllVerticalGrids(VHistWidget w)e {e
     int i;     GridInfo *gridInfoP;  L     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++)c 	DrawVerticalGrid (w, gridInfoP, w->insideLeftX, w->insideRightX, w->insideTopY, w->insideBottomY);  }A 16 static void SetBarGC(VHistWidget w, BarInfo *barInfoP) {y?     Pixel color = ColoridxToColor (w, barInfoP->vBar.coloridx);2  '     if (color == w->barGCColor) return;a  4     XSetForeground (XtDisplay (w), w->barGC, color);       w->barGCColor = color; }/  T static void DrawVerticalBar(VHistWidget w, BarInfo *barInfoP, int bottomY, int topY) {u     SetBarGC (w, barInfoP);t  o     XFillRectangle (XtDisplay (w), XtWindow (w), w->barGC, barInfoP->x, topY, w->barWidth, bottomY - topY + 1);a }P  . static void DrawAllVerticalBars(VHistWidget w) {b
     int i;     BarInfo *barInfoP;  H     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++)l 	if (ValuesToYs (w, barInfoP->vBar.lowValue, barInfoP->vBar.highValue, &barInfoP->bottomY, &barInfoP->topY))F 	    DrawVerticalBar (w, barInfoP, barInfoP->bottomY, barInfoP->topY); }   V static void DrawHorizontalBar(VHistWidget w, BarInfo *barInfoP, int leftX, int rightX) {e     SetBarGC (w, barInfoP);(  p     XFillRectangle (XtDisplay (w), XtWindow (w), w->barGC, leftX, barInfoP->y, rightX - leftX + 1, w->barWidth); }   0 static void DrawAllHorizontalBars(VHistWidget w) {I
     int i;     BarInfo *barInfoP;  H     for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++)s         if (ValuesToXs (w, barInfoP->vBar.lowValue, barInfoP->vBar.highValue, &barInfoP->leftX, &barInfoP->rightX))(H 	    DrawHorizontalBar (w, barInfoP, barInfoP->leftX, barInfoP->rightX); }b [J static void UndrawVerticalBar(VHistWidget w, int x, int bottomY, int topY) {d
     int i;     GridInfo *gridInfoP;  Z     XClearArea (XtDisplay (w), XtWindow (w), x, topY, w->barWidth, bottomY - topY + 1, 0);  L     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++)J 	DrawHorizontalGrid (w, gridInfoP, x, x + w->barWidth - 1, topY, bottomY); }   L static void UndrawHorizontalBar(VHistWidget w, int y, int leftX, int rightX) {w
     int i;     GridInfo *gridInfoP;  [     XClearArea (XtDisplay (w), XtWindow (w), leftX, y, rightX - leftX + 1, w->barWidth, 0);x  L     for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++)H 	DrawVerticalGrid (w, gridInfoP, leftX, rightX, y, y + w->barWidth - 1); }u YP static void AdjustVerticalBar(VHistWidget w, BarInfo *barInfoP, int oldColoridx) {      int bottomY, topY;  ^     if (!ValuesToYs (w, barInfoP->vBar.lowValue, barInfoP->vBar.highValue, &bottomY, &topY)) { 	if (barInfoP->bottomY != (-1)) K 	    UndrawVerticalBar (w, barInfoP->x, barInfoP->bottomY, barInfoP->topY);g     } else {B 	if ((barInfoP->bottomY != (-1)) && (bottomY < barInfoP->bottomY))v 	    UndrawVerticalBar (w, barInfoP->x, barInfoP->bottomY, (bottomY > barInfoP->topY ? bottomY + 1 : barInfoP->topY));  9 	if ((barInfoP->topY != (-1)) && (topY > barInfoP->topY))us 	    UndrawVerticalBar (w, barInfoP->x, (barInfoP->bottomY < topY ? barInfoP->bottomY : topY - 1), barInfoP->topY);w  V 	if (ColoridxToColor (w, oldColoridx) != ColoridxToColor (w, barInfoP->vBar.coloridx))2 	    DrawVerticalBar (w, barInfoP, bottomY, topY); 	else {e 	    if (topY < barInfoP->topY)w] 		DrawVerticalBar (w, barInfoP, (bottomY < barInfoP->topY ? bottomY : barInfoP->topY), topY);T     % 	    if (bottomY > barInfoP->bottomY)c` 		DrawVerticalBar (w, barInfoP, bottomY, (topY > barInfoP->bottomY ? topY : barInfoP->bottomY));	         }      }W       barInfoP->topY    = topY;r      barInfoP->bottomY = bottomY; }x aR static void AdjustHorizontalBar(VHistWidget w, BarInfo *barInfoP, int oldColoridx) {s     int leftX, rightX;  ^     if (!ValuesToXs (w, barInfoP->vBar.lowValue, barInfoP->vBar.highValue, &leftX, &rightX)) { 	if (barInfoP->leftX != (-1))pM 	    UndrawHorizontalBar (w, barInfoP->y, barInfoP->leftX, barInfoP->rightX);t     } else {< 	if ((barInfoP->leftX != (-1)) && (leftX > barInfoP->leftX))v 	    UndrawHorizontalBar (w, barInfoP->y, barInfoP->leftX, (leftX < barInfoP->rightX ? leftX - 1 : barInfoP->rightX));  ? 	if ((barInfoP->rightX != (-1)) && (rightX < barInfoP->rightX))ew 	    UndrawHorizontalBar (w, barInfoP->y, (barInfoP->leftX > rightX ? barInfoP->leftX : rightX + 1), barInfoP->rightX);i  V 	if (ColoridxToColor (w, oldColoridx) != ColoridxToColor (w, barInfoP->vBar.coloridx))4 	    DrawHorizontalBar (w, barInfoP, leftX, rightX);         else {# 	    if (rightX > barInfoP->rightX)wa 		DrawHorizontalBar (w, barInfoP, (leftX > barInfoP->rightX ? leftX : barInfoP->rightX), rightX);g     ! 	    if (leftX < barInfoP->leftX)e` 		DrawHorizontalBar (w, barInfoP, leftX, (rightX < barInfoP->leftX ? rightX : barInfoP->leftX));	         }      }-       barInfoP->leftX  = leftX;-     barInfoP->rightX = rightX; }i iL static int XYIsOverLabel(VHistWidget w, LabelInfo *labelInfoP, int x, int y) {i     if (labelInfoP->widthdJ       && (x >= labelInfoP->x) && (x < (labelInfoP->x + labelInfoP->width))G       && (y >= labelInfoP->y) && (y < (labelInfoP->y + w->charHeight)))  	return (1);       return (0);  }i  ) int VHistXYToBar(Widget ow, int x, int y)  { $     VHistWidget w = (VHistWidget)ow;     int bar;     BarInfo *barInfoP;        if (!w->barCnt) return (-1);  "     if (OrientationVertical (w)) {3 	if ((y > w->insideTopY) && (y < w->insideBottomY))eO 	    for (bar = 0, barInfoP = w->barInfosP; bar < w->barCnt; bar++, barInfoP++)-S 	        if ((x >= barInfoP->x) && (x < (barInfoP->x + w->barWidth))) return (bar);g     } else {3 	if ((x > w->insideLeftX) && (x < w->insideRightX))=O 	    for (bar = 0, barInfoP = w->barInfosP; bar < w->barCnt; bar++, barInfoP++)-S 	        if ((y >= barInfoP->y) && (y < (barInfoP->y + w->barWidth))) return (bar);-     }A  N     for (bar = 0, barInfoP = w->barInfosP; bar < w->barCnt; bar++, barInfoP++)k 	if (XYIsOverLabel (w, &barInfoP->lowLabelInfo, x, y) || XYIsOverLabel (w, &barInfoP->highLabelInfo, x, y))o 	    return (bar);  &     return (-1);				/* between bars */ }n  Q static void CallSelectCallbacks(VHistWidget w, XButtonEvent *eventP, int confirm)d { %     VHistSelectCallbackStruct cbData;   E     cbData.reason = (confirm ? VHistCRSelectConfirm : VHistCRSelect);-%     cbData.event  = (XEvent *)eventP;z     cbData.bar    = w->upBar;B  B     if (w->upBar != -1) cbData.vBar = w->barInfosP[w->upBar].vBar;#     else 		cbData.vBar.closure = 0;n  m     XtCallCallbacks ((Widget)w, (confirm ? VHistNselectConfirmCallback : VHistNselectCallback), &cbData);      }b  o static void ButtonPressHandler(Widget ow, XtPointer unused_closure, XEvent *eventOP, Boolean *unused_continueP)b {n$     VHistWidget w = (VHistWidget)ow;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;a       if (w->buttonIsDown) {+ 	w->buttonIsDown = 0;		/* chorded cancel */a 	return;     }g  F     /* If this is not a simple un-chorded Button1 event, ignore it. */       if ((eventP->button != Button1) || (eventP->state & (Button1Mask | Button2Mask | Button3Mask | Button4Mask | Button5Mask)))i 	return;       w->buttonIsDown = 1;  @     w->downBar = VHistXYToBar ((Widget)w, eventP->x, eventP->y);  z     /* If the ButtonPress came soon enough after the last ButtonRelease, and we're still over the same bar, and the widgetd      * does have at least one selectConfirm callback declared, then prime the doubleClick action. */  W     if ((eventP->time <= (w->upTime + w->doubleClickDelay)) && (w->downBar == w->upBar)tZ       && (XtHasCallbacks ((Widget)w, VHistNselectConfirmCallback) == XtCallbackHasSome)) { 	w->doubleClickIsPending = 1;  	return;     }x        w->doubleClickIsPending = 0; }n  q static void ButtonReleaseHandler(Widget ow, XtPointer unused_closure, XEvent *eventOP, Boolean *unused_continueP)o {w$     VHistWidget w = (VHistWidget)ow;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;o  !     if (!w->buttonIsDown) return;t       w->buttonIsDown = 0;  >     w->upBar = VHistXYToBar ((Widget)w, eventP->x, eventP->y);  "     if (w->doubleClickIsPending) {6 	w->upTime = 0;			/* don't want tripleClick problem */  E 	/* If the user didn't drag off bar, call SelectConfirm callbacks. */   @ 	if (w->upBar == w->downBar) CallSelectCallbacks (w, eventP, 1);     } else {? 	w->upTime = eventP->time;	/* to test against next Down time */   $ 	CallSelectCallbacks (w, eventP, 0);     }( }s d% static void CopyColors(VHistWidget w)p {LL     w->colorCnt = VtkCopyColors ((Widget) w, w->colorList, &w->colorTableP); }-  $ static void CopyFonts(VHistWidget w) {wV     if (!w->fontTableP) w->fontTableP = (XmFontList)VtkGetDefaultFontList ((Widget)w);  >     w->fontP = (XFontStruct *)VtkGetFirstFont (w->fontTableP);P     w->charHeight  = w->fontP->max_bounds.descent + w->fontP->max_bounds.ascent;1     w->yFontAdjust = w->fontP->max_bounds.ascent;o }m e> static void ApplyGridDefaults(VHistWidget w, VHistGrid *gridP) {bH     if (!(gridP->mask & VHistGridValueMask)) gridP->value = w->minValue;  y     if ((!(gridP->mask & VHistGridClosureMask)) || (!gridP->closure)) gridP->closure    = (Opaque)(++w->lastUsedClosure);,O     if (!(gridP->mask & VHistGridLowLabelMask)) 		      gridP->lowLabelP  = "";-P     if (!(gridP->mask & VHistGridHighLabelMask)) 		      gridP->highLabelP = "";  -     if (!(gridP->mask & VHistGridDashMask)) {  	gridP->dashOn  = 3; 	gridP->dashOff = 2;     }x  /     if (!(gridP->mask & VHistGridColoridxMask)) & 	if (w->colorCnt) gridP->coloridx = 0;) 	else 		 gridP->coloridx = w->foreground;  }   + static void ReallocGridInfos(VHistWidget w)w {o
     int i;     GridInfo *gridInfoP;  &     if (w->gridCnt > w->gridInfoCnt) {_ 	w->gridInfosP = (GridInfo *)XtRealloc ((char *)w->gridInfosP, w->gridCnt * sizeof (GridInfo));a     \ 	for (i = w->gridInfoCnt, gridInfoP = (&w->gridInfosP[i]); i < w->gridCnt; i++, gridInfoP++)[ 	    VtkSetFieldsToZero ((char*)&gridInfoP->beginZeroInit, (char*)&gridInfoP->endZeroInit);>      	w->gridInfoCnt = w->gridCnt;      }e }   $ static void CopyGrids(VHistWidget w) {e
     int i;     VHistGrid *gridP;r     GridInfo *gridInfoP;       ReallocGridInfos (w);t  j     for (i = 0, gridP = w->gridsP, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridP++, gridInfoP++) { 	gridInfoP->vGrid = (*gridP);o  * 	ApplyGridDefaults (w, &gridInfoP->vGrid);  K 	CopyLabel (&gridInfoP->lowLabelInfo.labelP,  &gridInfoP->vGrid.lowLabelP);PL 	CopyLabel (&gridInfoP->highLabelInfo.labelP, &gridInfoP->vGrid.highLabelP);     }o  "     w->gridsP = (VHistGrid *)(-1); }   ; static void ApplyBarDefaults(VHistWidget w, VHistBar *barP)  { r     if ((!(barP->mask & VHistBarClosureMask)) || (!barP->closure)) barP->closure = (Opaque)(++w->lastUsedClosure);  N     if (!(barP->mask & VHistBarLowValueMask))  barP->lowValue   = w->minValue;N     if (!(barP->mask & VHistBarHighValueMask)) barP->highValue  = w->maxValue;D     if (!(barP->mask & VHistBarStippledMask))  barP->stippled   = 0;E     if (!(barP->mask & VHistBarLowLabelMask))  barP->lowLabelP  = "";PE     if (!(barP->mask & VHistBarHighLabelMask)) barP->highLabelP = "";o  -     if (!(barP->mask & VHistBarColoridxMask))f% 	if (w->colorCnt) barP->coloridx = 0; & 	else 		 barP->coloridx = w->barColor; };  * static void ReallocBarInfos(VHistWidget w) {t
     int i;     BarInfo *barInfoP;  $     if (w->barCnt > w->barInfoCnt) {a         w->barInfosP = (BarInfo *)XtRealloc ((char *)w->barInfosP, w->barCnt * sizeof (BarInfo));i  ^         for (i = w->barInfoCnt, barInfoP = (&w->barInfosP[i]); i < w->barCnt; i++, barInfoP++)`             VtkSetFieldsToZero ((char*)&barInfoP->beginZeroInit, (char*)&barInfoP->endZeroInit);  "         w->barInfoCnt = w->barCnt;     }  }f  # static void CopyBars(VHistWidget w)R {a
     int i;     VHistBar *barP;,     BarInfo *barInfoP;       ReallocBarInfos (w);  c     for (i = 0, barP = w->barsP, barInfoP = w->barInfosP; i < w->barCnt; i++, barP++, barInfoP++) {n!         barInfoP->vBar = (*barP);n  ' 	ApplyBarDefaults (w, &barInfoP->vBar);,  H 	CopyLabel (&barInfoP->lowLabelInfo.labelP,  &barInfoP->vBar.lowLabelP);I 	CopyLabel (&barInfoP->highLabelInfo.labelP, &barInfoP->vBar.highLabelP);b     }i        w->barsP = (VHistBar *)(-1); }n )m static void DoInitialize(Widget unused_requestOW, Widget ow, ArgList unused_args, Cardinal *unused_num_argsP)g { $     VHistWidget w = (VHistWidget)ow;  J     VtkSetFieldsToZero ((char*)&w->beginZeroInit, (char*)&w->endZeroInit);.     w->gridGCDashOn = w->gridGCDashOff = (-1);       CopyColors (w);w     CopyFonts (w);     CopyBars (w);w     CopyGrids (w); }  w% static void RealizeGCs(VHistWidget w)L {t     XGCValues values;s       values.function   = GXcopy; &     values.foreground = w->foreground;1     values.background = w->core.background_pixel;d&     values.font       = w->fontP->fid;t     w->normGC = XCreateGC (XtDisplay (w), XtWindow (w), GCForeground | GCBackground | GCFunction | GCFont, &values);       values.function   = GXcopy;n     values.foreground = 0;1     values.background = w->core.background_pixel;h&     values.line_style = LineOnOffDash;y     w->gridGC = XCreateGC (XtDisplay (w), XtWindow (w), GCForeground | GCBackground | GCFunction | GCLineStyle, &values);s       values.function   = GXcopy;d     values.foreground = 0;1     values.background = w->core.background_pixel;Ij     w->barGC = XCreateGC (XtDisplay (w), XtWindow (w), GCForeground | GCBackground | GCFunction, &values); }o  ' static void RealizeGrabs(VHistWidget w)0 {a     XGrabButton (s! 	XtDisplay (w),					/* display */{ 	1,						/* button_grab */! 	AnyModifier,					/* modifiers */I 	XtWindow (w),					/* window */  	0,						/* owner_events */i9 	(ButtonPressMask | ButtonReleaseMask),		/* event_mask */t& 	GrabModeAsync,					/* pointer_mode */' 	GrabModeAsync,					/* keyboard_mode */i 	None,						/* confine_to */ 	None);						/* cursor */;  T     XtAddRawEventHandler ((Widget)w, ButtonPressMask,   0, ButtonPressHandler,   0);T     XtAddRawEventHandler ((Widget)w, ButtonReleaseMask, 0, ButtonReleaseHandler, 0); }   W static void DoRealize(Widget ow, XtValueMask *maskP, XSetWindowAttributes *attributesP)  {t$     VHistWidget w = (VHistWidget)ow;  -     if (!w->core.width)  w->core.width = 100;i.     if (!w->core.height) w->core.height = 100;       ConvertFromFontUnits (w);R"     ComputeAllGridLabelWidths (w);!     ComputeAllBarLabelWidths (w);-     ComputeAxisPositions (w);)!     ComputeActualOrientation (w);H  C     if (OrientationVertical (w)) ComputeAllVerticalPositions   (w);=/     else 			 ComputeAllHorizontalPositions (w);d  Q     XtCreateWindow ((Widget)w, InputOutput, CopyFromParent, *maskP, attributesP);d       RealizeGCs (w);s     RealizeGrabs (w);t }  sF static void DoExpose(Widget ow, XEvent *eventOP, Region unused_region) {r$     VHistWidget w = (VHistWidget)ow;3     XExposeEvent *eventP = (XExposeEvent *)eventOP;t  e     XClearArea (XtDisplay (w), XtWindow (w), eventP->x, eventP->y, eventP->width, eventP->height, 0);C       if (eventP->count) return;       DrawAxes (w);i     DrawAllLabels (w);  "     if (OrientationVertical (w)) { 	DrawAllHorizontalGrids (w); 	DrawAllVerticalBars    (w);     } else { 	DrawAllVerticalGrids  (w);  	DrawAllHorizontalBars (w);v     }w }i   static void DoResize(Widget ow)* {d$     VHistWidget w = (VHistWidget)ow;  #     if (!VtkIsRealized (w)) return;G       ComputeAxisPositions (w); !     ComputeActualOrientation (w);   C     if (OrientationVertical (w)) ComputeAllVerticalPositions   (w);)/     else 			 ComputeAllHorizontalPositions (w);i }X r9 static int RemoveGrid(VHistWidget w, GridInfo *gridInfoP)t {g.     UndrawLabel (w, &gridInfoP->lowLabelInfo);/     UndrawLabel (w, &gridInfoP->highLabelInfo);<  *     return (GridIsVisible (w, gridInfoP)); }i  K static int ChangeGrid(VHistWidget w, VHistGrid *gridP, GridInfo *gridInfoP)m { G     int oldPosition, oldVisibility, oldDashOn, oldDashOff, oldColoridx;iA     int newPosition, newVisibility, labelChanged, redrawWorkarea;G  <     if (OrientationVertical (w)) oldPosition = gridInfoP->y;(     else 			 oldPosition = gridInfoP->x;  1     oldVisibility = GridIsVisible (w, gridInfoP);g  *     oldDashOn   = gridInfoP->vGrid.dashOn;+     oldDashOff  = gridInfoP->vGrid.dashOff;V,     oldColoridx = gridInfoP->vGrid.coloridx;        gridInfoP->vGrid = (*gridP);-     ApplyGridDefaults (w, &gridInfoP->vGrid);n  "     if (OrientationVertical (w)) {. 	ComputeHorizontalGridPosition (w, gridInfoP); 	newPosition = gridInfoP->y;     } else {, 	ComputeVerticalGridPosition (w, gridInfoP); 	newPosition = gridInfoP->x;     }w  1     newVisibility = GridIsVisible (w, gridInfoP);a  >     if (oldVisibility && (!newVisibility)) redrawWorkarea = 1;C     else if ((!oldVisibility) && newVisibility) redrawWorkarea = 1;l0     else if (oldVisibility && newVisibility && (3       (oldDashOn   != gridInfoP->vGrid.dashOn)   ||F3       (oldDashOff  != gridInfoP->vGrid.dashOff)  ||b3       (oldColoridx != gridInfoP->vGrid.coloridx) || 8       (oldPosition != newPosition))) redrawWorkarea = 1;  W     labelChanged = strcmp (gridInfoP->vGrid.lowLabelP, gridInfoP->lowLabelInfo.labelP);t  `     if (labelChanged || (oldPosition != newPosition)) UndrawLabel (w, &gridInfoP->lowLabelInfo);       if (labelChanged) {)J 	CopyLabel (&gridInfoP->lowLabelInfo.labelP, &gridInfoP->vGrid.lowLabelP);1 	ComputeLabelWidth (w, &gridInfoP->lowLabelInfo);r     }a  7     if (labelChanged || (oldPosition != newPosition)) {o$ 	gridInfoP->lowLabelInfo.redraw = 1;  J 	if (OrientationVertical (w)) ComputeLeftGridLabelPosition (w, gridInfoP);9 	else 			     ComputeTopGridLabelPosition (w, gridInfoP);).     } else gridInfoP->lowLabelInfo.redraw = 0;  Y     labelChanged = strcmp (gridInfoP->vGrid.highLabelP, gridInfoP->highLabelInfo.labelP);(  a     if (labelChanged || (oldPosition != newPosition)) UndrawLabel (w, &gridInfoP->highLabelInfo);a       if (labelChanged) {,L 	CopyLabel (&gridInfoP->highLabelInfo.labelP, &gridInfoP->vGrid.highLabelP);2 	ComputeLabelWidth (w, &gridInfoP->highLabelInfo);     }   7     if (labelChanged || (oldPosition != newPosition)) {X% 	gridInfoP->highLabelInfo.redraw = 1;o  K 	if (OrientationVertical (w)) ComputeRightGridLabelPosition (w, gridInfoP);;< 	else 			     ComputeBottomGridLabelPosition (w, gridInfoP);/     } else gridInfoP->highLabelInfo.redraw = 0;i       return (redrawWorkarea); },  H static int AddGrid(VHistWidget w, VHistGrid *gridP, GridInfo *gridInfoP) {       gridInfoP->vGrid = (*gridP);-     ApplyGridDefaults (w, &gridInfoP->vGrid);h  N     CopyLabel (&gridInfoP->lowLabelInfo.labelP,  &gridInfoP->vGrid.lowLabelP);O     CopyLabel (&gridInfoP->highLabelInfo.labelP, &gridInfoP->vGrid.highLabelP);u  4     ComputeLabelWidth (w, &gridInfoP->lowLabelInfo);5     ComputeLabelWidth (w, &gridInfoP->highLabelInfo);p     (     gridInfoP->lowLabelInfo.redraw  = 1;(     gridInfoP->highLabelInfo.redraw = 1;  "     if (OrientationVertical (w)) {. 	ComputeHorizontalGridPosition (w, gridInfoP);. 	ComputeLeftGridLabelPosition  (w, gridInfoP);. 	ComputeRightGridLabelPosition (w, gridInfoP);     } else {/ 	ComputeVerticalGridPosition    (w, gridInfoP); / 	ComputeTopGridLabelPosition    (w, gridInfoP);t/ 	ComputeBottomGridLabelPosition (w, gridInfoP);o     }-  *     return (GridIsVisible (w, gridInfoP)); }i BD static void AddBar(VHistWidget w, VHistBar *barP, BarInfo *barInfoP) {-     barInfoP->vBar = (*barP);C*     ApplyBarDefaults (w, &barInfoP->vBar);  K     CopyLabel (&barInfoP->lowLabelInfo.labelP,  &barInfoP->vBar.lowLabelP);YL     CopyLabel (&barInfoP->highLabelInfo.labelP, &barInfoP->vBar.highLabelP);  3     ComputeLabelWidth (w, &barInfoP->lowLabelInfo);>4     ComputeLabelWidth (w, &barInfoP->highLabelInfo);  '     barInfoP->lowLabelInfo.redraw  = 1;t'     barInfoP->highLabelInfo.redraw = 1;a }f  G static void ChangeBar(VHistWidget w, VHistBar *barP, BarInfo *barInfoP)a {f.     int oldColoridx = barInfoP->vBar.coloridx;       barInfoP->vBar = (*barP);r*     ApplyBarDefaults (w, &barInfoP->vBar);  K     if (strcmp (barInfoP->vBar.lowLabelP, barInfoP->lowLabelInfo.labelP)) {v* 	UndrawLabel (w, &barInfoP->lowLabelInfo);G 	CopyLabel (&barInfoP->lowLabelInfo.labelP, &barInfoP->vBar.lowLabelP);P0 	ComputeLabelWidth (w, &barInfoP->lowLabelInfo);# 	barInfoP->lowLabelInfo.redraw = 1;bJ 	if (OrientationVertical (w)) ComputeBottomBarLabelPosition (w, barInfoP);: 	else 			     ComputeLeftBarLabelPosition   (w, barInfoP);-     } else barInfoP->lowLabelInfo.redraw = 0;<  M     if (strcmp (barInfoP->vBar.highLabelP, barInfoP->highLabelInfo.labelP)) {>+ 	UndrawLabel (w, &barInfoP->highLabelInfo);nI 	CopyLabel (&barInfoP->highLabelInfo.labelP, &barInfoP->vBar.highLabelP);(1 	ComputeLabelWidth (w, &barInfoP->highLabelInfo);r$ 	barInfoP->highLabelInfo.redraw = 1;I 	if (OrientationVertical (w)) ComputeTopBarLabelPosition   (w, barInfoP);I; 	else   			     ComputeRightBarLabelPosition (w, barInfoP);r.     } else barInfoP->highLabelInfo.redraw = 0;  P     if (OrientationVertical (w)) AdjustVerticalBar   (w, barInfoP, oldColoridx);<     else 			 AdjustHorizontalBar (w, barInfoP, oldColoridx); }f -$ #define Changed(f) (w->f != oldW->f)  y static Boolean DoSetValues(Widget oldOW, Widget unused_refOW, Widget ow, ArgList unused_args, Cardinal *unused_num_argsP)  {l*     VHistWidget oldW = (VHistWidget)oldOW;$     VHistWidget w = (VHistWidget)ow;       int redrawWorkarea, i;     VHistGrid *gridP;r     GridInfo *gridInfoP;     VHistBar *barP;X     BarInfo *barInfoP;       if (!VtkIsRealized (w)) { ) 	if (Changed (gridsP))     CopyGrids (w); ( 	if (Changed (barsP))      CopyBars (w);) 	if (Changed (fontTableP)) CopyFonts (w);  	return (0);     }p  "     if (Changed (orientation) 		||4       Changed (minValue)		|| Changed (maxValue)		 ||F       Changed (spacingDenominator) 	|| Changed (spacingNumerator) 	 ||D       Changed (leftMarginWidthU)	|| Changed (rightMarginWidthU)   ||E       Changed (topMarginHeightU) 	|| Changed (bottomMarginHeightU) ||nC       Changed (leftLabelWidthU)		|| Changed (rightLabelWidthU) 	 ||oD       Changed (topLabelHeightU)		|| Changed (bottomLabelHeightU)	 ||F       Changed (leftAxisThickness) 	|| Changed (rightAxisThickness)  ||E       Changed (topAxisThickness) 	|| Changed (bottomAxisThickness)) {e 	ConvertFromFontUnits (w); 	ComputeAxisPositions (w); 	ComputeActualOrientation (w);   	if (Changed (gridsP)) { 	    CopyGrids (w);a# 	    ComputeAllGridLabelWidths (w);e 	}   	if (Changed (barsP)) {H 	    CopyBars (w);" 	    ComputeAllBarLabelWidths (w); 	}  G         if (OrientationVertical (w)) ComputeAllVerticalPositions   (w); 8         else  			     ComputeAllHorizontalPositions (w);   	return (1);     }        redrawWorkarea = 0;a  0     if (Changed (gridsP) || Changed (gridCnt)) {[ 	for (i = w->gridCnt, gridInfoP = (&w->gridInfosP[i]); i < oldW->gridCnt; i++, gridInfoP++)t7 	    if (RemoveGrid (w, gridInfoP)) redrawWorkarea = 1;   c 	for (i = 0, gridP = w->gridsP, gridInfoP = w->gridInfosP; (i < w->gridCnt) && (i < oldW->gridCnt);i 	  i++, gridP++, gridInfoP++)n> 	    if (ChangeGrid (w, gridP, gridInfoP)) redrawWorkarea = 1;   	ReallocGridInfos (w);  } 	for (i = oldW->gridCnt, gridP = (&w->gridsP[i]), gridInfoP = (&w->gridInfosP[i]); i < w->gridCnt; i++, gridP++, gridInfoP++)b; 	    if (AddGrid (w, gridP, gridInfoP)) redrawWorkarea = 1;a  K 	for (i = 0, gridInfoP = w->gridInfosP; i < w->gridCnt; i++, gridInfoP++) {wR 	    if (gridInfoP->lowLabelInfo.redraw)  DrawLabel (w, &gridInfoP->lowLabelInfo);S 	    if (gridInfoP->highLabelInfo.redraw) DrawLabel (w, &gridInfoP->highLabelInfo);e 	}   	w->gridsP = (VHistGrid *)(-1);d     }e       if (Changed (barCnt)) {lH 	for (i = 0, barP = w->barsP, barInfoP = w->barInfosP; i < oldW->barCnt; 	  i++, barP++, barInfoP++) {i. 	    UndrawLabel (w, &barInfoP->lowLabelInfo);/ 	    UndrawLabel (w, &barInfoP->highLabelInfo);a 	}   	ReallocBarInfos (w);)   	if (OrientationVertical (w)) { % 	    ComputeVerticalBarPositions (w);s  d 	    for (i = 0, barP = w->barsP, barInfoP = w->barInfosP; i < w->barCnt; i++, barP++, barInfoP++) {$ 	        AddBar (w, barP, barInfoP);5 	        ComputeTopBarLabelPosition    (w, barInfoP);v5 	        ComputeBottomBarLabelPosition (w, barInfoP);s 	    }	 	} else { ' 	    ComputeHorizontalBarPositions (w);V  d 	    for (i = 0, barP = w->barsP, barInfoP = w->barInfosP; i < w->barCnt; i++, barP++, barInfoP++) {$ 	        AddBar (w, barP, barInfoP);4 	        ComputeLeftBarLabelPosition  (w, barInfoP);4 	        ComputeRightBarLabelPosition (w, barInfoP); 	    } 	}   	redrawWorkarea = 1;  G 	for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) { P 	    if (barInfoP->lowLabelInfo.redraw)  DrawLabel (w, &barInfoP->lowLabelInfo);Q 	    if (barInfoP->highLabelInfo.redraw) DrawLabel (w, &barInfoP->highLabelInfo);c 	}   	w->barsP = (VHistBar *)(-1);o!     } else if (Changed (barsP)) {>} 	for (i = 0, barP = w->barsP, barInfoP = w->barInfosP; i < w->barCnt; i++, barP++, barInfoP++) ChangeBar (w, barP, barInfoP);>  G 	for (i = 0, barInfoP = w->barInfosP; i < w->barCnt; i++, barInfoP++) {>P 	    if (barInfoP->lowLabelInfo.redraw) 	DrawLabel (w, &barInfoP->lowLabelInfo);Q 	    if (barInfoP->highLabelInfo.redraw) DrawLabel (w, &barInfoP->highLabelInfo);m 	}   	w->barsP = (VHistBar *)(-1);u     }m       if (redrawWorkarea) {>H 	XClearArea (XtDisplay (w), XtWindow (w), w->insideLeftX, w->insideTopY,T 	    w->insideRightX - w->insideLeftX + 1, w->insideBottomY - w->insideTopY + 1, 0);   	if (OrientationVertical (w)) {(  	    DrawAllHorizontalGrids (w);  	    DrawAllVerticalBars    (w);	 	} else {  	    DrawAllVerticalGrids  (w);M 	    DrawAllHorizontalBars (w);g 	}     }f       return (0);  }f  ' static void DoDestroy(Widget unused_ow)  {      /* to-be-supplied */ }  ;! extern void VtkUnitTypeDefault();e  h #define XY(n, c, r, t, f, dr, d)        {n, c, r, sizeof(t), XtOffset(VHistWidget, f), dr, (char *)(d)},K #define XX(n, c, r, t, f, d)            XY (n, c, r, t, f, XtRImmediate, d)(K #define XI(n, f, d)                     XX (n, XtCValue, XtRInt, int, f, d)g  ! static XtResource resources[] = {s  ' XI (VHistNbarCount,     		barCnt, 			0) > XI (VHistNbottomAxisMarginHeight,	bottomAxisMarginHeightU, 	0): XI (VHistNbottomAxisThickness,  	bottomAxisThickness, 		2): XI (VHistNbottomLabelHeight,     	bottomLabelHeightU, 		0)< XI (VHistNbottomMarginHeight,     	bottomMarginHeightU, 		0)9 XI (VHistNdoubleClickDelay,     	doubleClickDelay, 		250)-) XI (VHistNgridCount,     		gridCnt, 			0)g> XI (VHistNleftAxisMarginWidth,     	leftAxisMarginWidthU, 		0)8 XI (VHistNleftAxisThickness,    	leftAxisThickness, 		2)K XI (VHistNleftLabelAlignment,   	leftLabelAlignment, 		VHistAlignmentRight)p5 XI (VHistNleftLabelWidth,     		leftLabelWidthU, 		0)G7 XI (VHistNleftMarginWidth,     		leftMarginWidthU, 		0)(+ XI (VHistNmaxValue,     		maxValue, 			100)i) XI (VHistNminValue,     		minValue, 			1)!F XI (VHistNorientation,     		orientation, 			VHistOrientationVertical)@ XI (VHistNrightAxisMarginWidth,     	rightAxisMarginWidthU, 		0)9 XI (VHistNrightAxisThickness,   	rightAxisThickness, 		0)(K XI (VHistNrightLabelAlignment,  	rightLabelAlignment, 		VHistAlignmentLeft)(7 XI (VHistNrightLabelWidth,     		rightLabelWidthU, 		0) 8 XI (VHistNrightMarginWidth,     	rightMarginWidthU, 		0); XI (VHistNspacingDenominator,   	spacingDenominator, 		100)k8 XI (VHistNspacingNumerator,     	spacingNumerator, 		50); XI (VHistNtopAxisMarginHeight,  	topAxisMarginHeightU, 		0)e7 XI (VHistNtopAxisThickness,     	topAxisThickness, 		0)e5 XI (VHistNtopLabelHeight,     		topLabelHeightU, 		0)f7 XI (VHistNtopMarginHeight,     		topMarginHeightU, 		0)   o XY (VHistNbarColor,   		 XtCForeground, XtRPixel,     Pixel, 	      barColor,   XtRString, XtDefaultForeground)wc XY (VHistNfont, 		 XmCFontList,   XmRFontList,  struct _XmFontListRec*,   fontTableP, XtRString, 0)sq XY (VHistNforeground, 		 XtCForeground, XtRPixel,     Pixel,          foreground, XtRString, XtDefaultForeground)   o XY (VHistNselectCallback, 	 XtCValue,      XtRCallback,  XtCallbackList, selectCallback,        XtRCallback, 0) t XY (VHistNselectConfirmCallback, XtCValue,      XtRCallback,  XtCallbackList, selectConfirmCallback, XtRCallback, 0)  V XX (VHistNbars,     		 XtCValue,	XtRPointer,   VHistBar *,     barsP, 	 (VHistBar *)0)X XX (VHistNgrids,     		 XtCValue,	XtRPointer,   VHistGrid *,    gridsP,	 (VHistGrid *)0)_ XX (VHistNuserData,     	 XtCValue,      XtRPointer,   XtPointer,      userData,  (XtPointer)0)(  [ XX (VHistNcolorList,             XtCValue,      XtRPixmap,    Pixmap,         colorList, 0)   j XY (VHistNunitType,		 XmCUnitType,   XmRUnitType,  int,	      unitType,   XtRCallProc, VtkUnitTypeDefault) }; oF externaldef(vhistwidgetclassrec) VHistClassRec vhistwidgetclassrec = {     {/* core_class fields	*/0 	/* superclass		*/	(WidgetClass)&widgetClassRec, 	/* class_name	  	*/	"VHist", . 	/* widget_size	  	*/	sizeof (VHistWidgetRec),! 	/* class_initialize   	*/    	0,X 	/* class_part_initialize */	0,- 	/* class_inited       	*/	0,o" 	/* initialize	  	*/	DoInitialize, 	/* initialize_hook	*/	0,n 	/* realize		*/	DoRealize, 	/* actions		*/    	0, 	/* num_actions	  	*/	0, 	/* resources	  	*/	resources,* 	/* num_resources	*/	XtNumber (resources), 	/* xrm_class	  	*/	0, 	/* compress_motion	*/	0,c 	/* compress_exposure  	*/	0,x 	/* compress_enterleave	*/	0,i 	/* visible_interest	*/	0, 	/* destroy		*/	DoDestroy, 	/* resize		*/	DoResize, 	/* expose		*/	DoExpose,! 	/* set_values	  	*/	DoSetValues,  	/* set_values_hook	*/	0,d4 	/* set_values_almost  	*/	XtInheritSetValuesAlmost, 	/* get_values_hook    	*/	0,  	/* accept_focus	  	*/	0,p# 	/* version		*/	XtVersionDontCheck,  	/* callback_private   	*/	0,u 	/* tm_table		*/	0,i 	/* query_geometry	*/	0, 	/* display_accelerator	*/	0,X 	/* extension		*/	0d   }y };  _ externaldef(vhistwidgetclass) WidgetClass vhistwidgetclass = (WidgetClass)&vhistwidgetclassrec;   B Widget VHistCreate(Widget pW, char *nameP, Arg *argsP, int argCnt) { I     return (XtCreateWidget (nameP, vhistwidgetclass, pW, argsP, argCnt));	 }k    void VHistInitializeForMRM(void) {e[     MrmRegisterClass (MrmwcUnknown, "VHist", "VHistCreate", VHistCreate, vhistwidgetclass);  }BtonPress                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                