/ /* vlist.c - VList widget implementation module   O ******************************************************************************* G * VToolkit (1995) 	"If it doesn't use VToolkit, it isn't cool!"	      *  * (c) Steve Klein							      * O * Unpublished rights reserved under the copyright laws of the United States.  * O *******************************************************************************   ( This module implements the VList widget.   MODIFICATION HISTORY:   p 08-Aug-1994 (sjk) Bugfix - clear LabelInfo array to zeroes when first allocated to avoid possible strange widthsT 	being looked at before widget has been realized.  Thanks to Dave Campbell for this!  k 12-May-1994 (sjk) Bugfix - don't overflow XCopyArea height when inserting a line in the middle of the list.   | 20-Jan-1993 (sjk) Bugfix - don't try to change GCs in DoSetValues prior to widget realization.  The GCs are not created yet!  : 03-Dec-1993 (sjk) Even more portability work.  Thanks Roy!  7 29-Oct-1993 (sjk) Add VListNselectionIsLocked resource.   E 22-Oct-1993 (sjk) Add VListNgridStyle and VListNgridPixmap resources.   9 11-Oct-1993 (sjk) More portability cleanup.  Thanks Bill!   E 17-Sep-1993 (sjk) Fix typedefs from VToolkit notes 162.  Thanks Phil! j 	Reapply change from 18-MAY-1993 notesfile - Make closurePP argument optional on VListGetAllSelectedLines.f 	Reapply bugfix from 05-May-1992 - Fix timing problem with quick add/remove combination and scrolling.N 	Reapply bugfix from 10-Apr-1991 - Allow dynamic changing of background color., 	Add VListLineToCell from notesfile note 12.  h 16-Sep-1993 (sjk) Bugfix Alpha/OSF typedef problem.  Add (partial) DoDestroy callback. Thanks Jean-Paul!  N 13-Sep-1993 (sjk) Bugfix when setting labelCount to zero.  (VToolkit note 161)  " 08-Sep-1993 (sjk/nfc) VToolkit V2.  6 19-Mar-1992 (sjk) Conditionalize #pragma for VMS only.  } 03-Jan-1992 (sjk) Add VListLine.type field.  Support changing VListNfontTable and VListNcolorList resources with XtSetValues.   w 30-Dec-1991 (sjk) Integrated changes from JE_BRENNAN.  Support XtGetValues for VListNlabels and VListNfields resources. s 	Modified LabelInfo and removed FieldInfo structure.  Changed logic so that user-supplied label and field lists are > 	cloned rather than embedded in LabelInfo and FieldInfo lists.  q 11-Dec-1991 (sjk) Bugfix - Avoid divide by zero when calling VListComputePreferredWidth before widget is realized R 	and avoid divide by zero in histogram scaling if min and max values are the same.  4 11-Dec-1991 (sjk) Add VListNallowDeadspace resource.  7 19-Nov-1991 (sjk) Add VListNspaceTiersEqually resource.   o 19-Nov-1991 (sjk) Add VListChangeCell* routines, allowing application to pass field/row combination rather than o 	requiring line closure to be passed.  These new routines are more efficient than the VListChangeLine* routines - 	because the ClosureToLine search is avoided.   ^ 19-Nov-1991 (sjk) Change default value for VListNspaceGroupsEqually to false, the old default.  8 15-Nov-1991 (sjk) Add VListNspaceGroupsEqually resource.  h 08-Nov-1991 (sjk) Add VListNdragArmCallback and VListNdragDropCallback.  This incorporates drag-and-drop> 	logic into the widget itself reducing application complexity.  { 06-Nov-1991 (sjk) Defer VListMakeLineVisible calls while scroll bar is grabbed by user to avoid "stealing" scroll position.   m 31-Oct-1991 (sjk) Add VListNfieldResizePolicy and VListField.resizePolicy.  Reduce flicker when adding lines.    28-Oct-1991 (sjk) Add VListNselectButton resource.  Honor VFieldWidth as a minimum width for the field (not including margins). u     Implement multi-line segmented text.  Add VListGetFieldLines routine.  Change default VListNdashOn resource value !     to workaround SPX server bug.   s 25-Oct-1991 (sjk) Add VListNiconMarginWidth and VListNiconMarginHeight resources, and compute rowHeight dynamically G 	based on actual contents.  Reformat source and other cosmetic changes.   Y 27-Sep-1991 (sjk) Bugfix - invalidate w->yFontAdjust if w->rowHeight resource is changed.   L 26-Aug-1991 (sjk) Check for change in field and label counts in DoSetValues.  C 29-Aug-1990 (sjk) Add background color support on a per-line basis.   x 28-Aug-1990 (sjk) Bugfix VListGetAllLines to not return deleted lines that have not yet been purged from the line array.  x 28-Aug-1990 (sjk) Bugfix ClosureToLine routine so that deleted lines are ignored.  This allows the application to re-useR 	closure values while deleted lines are asynchronously purged from the line array.  / 16-Aug-1990 (sjk) Add VListGetAllLines routine.   \ 31-Jul-1990 (sjk) Bugfix cellHeight vs. tierHeight (introduced when icon support was added).  # 20-Jul-1990 (sjk) Add icon support.   G 10-May-1990 (sjk) Use portable font routines, part of MOTIF BL1.1 port.   ( 20-Apr-1990 (sjk) More portability work.  ' 28-Mar-1990 (sjk) VListSelectStyleNone.   / 27-Mar-1990 (sjk) Multi-segment histogram bars.   < 21-Mar-1990 (sjk) More work on the multiple repaint problem.  x 19-Mar-1990 (sjk) Improve expose and resize handling to avoid (minimize?) likelihood of multiple repaints.  Clear entire. 	window on partial expose during batch update.  t 16-Mar-1990 (sjk) Bugfix - When copying field information, the grid pointers were not being properly set to zero for 	text-type fields.  k 09-Mar-1990 (sjk) Properly handle font and color indices that are negative.  Add VListGetLineCount routine.   K 08-May-1990 (sjk) Change default value for VListNfieldSpacingWidth to zero.   ( 06-Mar-1990 (sjk) Add histogram support.  x 06-Mar-1990 (sjk) Remove VListChangeLinePixel.  Applications must change to use VListChangeLineColoridx instead.  Removen 	~PixelMask usage that was added on 21-Feb-1990.  Use existence / non-existence of colorTable to infer whether, 	coloridx is a color index or a pixel value.  x 05-Mar-1990 (sjk) Add VListNuserData resource to be consistent with (most) toolkit widgets.  Add selectionCount field toK     VListSelectCallbackStruct to return the (new) number of selected lines.    21-Feb-1990 (sjk) Add support for direct specification of a pixel color value in addition to the indirect coloridx specification.   G 16-Feb-1990 (sjk) Fix bug in the width calculation of 8-bit characters.   { 15-Feb-1990 (sjk) Change VListVisibleInWindow option to ensure that the upper/left corner of the line item is made visible. u 	Previously, if the item was wider than the window, the window was sometimes scrolled to show the bottom/right corner % 	(depending on the initial position).    31-Jan-1990 (sjk) If slave widgets (scrollbars and header) have not been passed to the VList widget by the time it is realized, w 	sniff the parent widget's child list to try to find them ourselves.  This gets around a DRM bug that was keeping VList " 	from working under DECwindows V1.  H 31-Jan-1990 (sjk) Make necessary changes to improve portability to RISC.  w 26-Jan-1990 (sjk) Add VListSetAutoScrollStrength routine.  Add VListSelectCallbackStruct.selectChangesP and .lineCount.   J 23-Jan-1990 (sjk) Make widget a subclass of composite.  Add stippled text.  A 22-Jan-1990 (sjk) Add header label (dashed line) padding options.   $ 19-Jan-1990 (sjk) Add MOTIF support.  z 16-Jan-1990 (sjk) Bugfix - Column layout was sometimes recomputed unnecessarily.  The column width reference count was not" 	maintained properly in all cases.  e 11-Jan-1990 (sjk) Add segmented string support.  Delete lines in reverse order to minimize shuffling.   ~ 10-Jan-1990 (sjk) Bugfix - In VListSelectStyleSingle, downclick must not select any line that is not directly under the mouse.G 	Also, don't return a closure on a double-click that is over deadspace.   9 09-Jan-1990 (sjk) Add VListComputePreferredWidth routine.    05-Jan-1990 (sjk) Bugfix - VListGetLineInfo returns 1 on success.  Bugfix - don't try to redraw lines that are not visible during       an autoscrolled drag select.  B 04-Jan-1990 (sjk) Don't allow user to assign a zero closure value.  ~ 03-Jan-1990 (sjk) Add VListAlignmentLeft and ~Right, and remove column and tier fields from VListSelectCallbackStruct.  BugfixL 	recalculation of logicalHeight and tierCnt when adding and removing a line.  x 28-Dec-1989 (sjk) Version X2.0 update.  Contributions from Tom Foley, Keith Fieldhouse, and Dave Burleigh, among others.  G 17-Nov-1988 (sjk) Changes for stand-alone usage and public consumption.  */   #include "vtoolkit.h"  #include "vlistp.h"  #include "vframe.h"  #include "vheader.h"  H #define FOR_EACH_LINE_L(w, line, lineInfoP, firstLine, increment)						\M     for (lineInfoP = LineToLineInfo (w, firstLine), line = firstLine; 						\ ! 	line < (w)->lineCnt;											\ / 	lineInfoP += (increment), line += (increment))   3 #define FOR_EACH_LINE(w, line, lineInfoP)									\ .     FOR_EACH_LINE_L (w, line, lineInfoP, 0, 1)  T #define FOR_EACH_LINE_IN_RECORD(w, line, lineInfoP, field, vFieldP, firstLine)					\B     for (line = firstLine, vFieldP = FieldToVField (w, 0),							\9 	lineInfoP = LineToLineInfo (w, line), field = 0;							\ # 	field < (w)->fieldCnt;											\ 3 	line++, vFieldP++, lineInfoP++, field++) 								\   3 #define FOR_EACH_FIELD(w, field, vFieldP)									\ 5     for (vFieldP = (w)->fieldsP, field = 0;									\ # 	field < (w)->fieldCnt;											\  	vFieldP++, field++)  > #define FOR_EACH_LABEL(w, label, labelInfoP, vLabelP)								\P     for (labelInfoP = (w)->labelInfosP, vLabelP = (w)->labelsP, label = 0;					\# 	label < (w)->labelCnt;											\ " 	labelInfoP++, vLabelP++, label++)  P #define FOR_EACH_SEGMENT_L(lineInfoP, segment, segmentInfoP, firstSegment)					\c     for (segmentInfoP = SegmentToSegmentInfo (lineInfoP, firstSegment), segment = firstSegment;			\ 2 	segment < lineInfoP->vLine.segmentCount;								\ 	segmentInfoP++, segment++)   B #define FOR_EACH_SEGMENT(lineInfoP, segment, segmentInfoP)							\<     FOR_EACH_SEGMENT_L (lineInfoP, segment, segmentInfoP, 0)  5 #define FOR_EACH_GRID(vFieldP, grid, gridP)									\ 5     for (gridP = vFieldP->gridsP, grid = 0;									\ & 	grid < vFieldP->gridCount;										\ 	gridP++, grid++)   + #define FOR_EACH_GROUP(w, group)										\ 3     for (group = 0; group < (w)->groupCnt; group++)   2 #define FOR_EACH_BAR(vLineP, bar, barP)										\2     for (barP = vLineP->barsP, bar = 0;										\$ 	bar < vLineP->barCount;											\ 	barP++, bar++)   ; #define LineToLineInfo(w, line)				(&(w)->lineInfosP[line]) 9 #define FieldToVField(w, field)				(&(w)->fieldsP[field]) D #define ColumnToColumnInfo(w, column)			(&(w)->columnInfosP[column])U #define SegmentToSegmentInfo(lineInfoP, segment)	(&lineInfoP->segmentInfosP[segment])   R #define LineToFirstLineInRecord(w, line)		((line) / (w)->fieldCnt * (w)->fieldCnt)P #define GroupFieldToColumn(w, group, field)		((group) * (w)->fieldCnt + (field))= #define ColumnToGroup(w, column)			((column) / (w)->fieldCnt) Z #define ColumnToFirstColumnInGroup(w, column)		(ColumnToGroup (w, column) * (w)->fieldCnt)\ #define ColumnGroupToField(w, column, group)            ((column) - (group) * (w)->fieldCnt)  [ #define FontidxToFont(w, fontidx)			((w)->fontPP[((unsigned int)(fontidx) % (w)->fontCnt)])   4 #define LineToRow(w, line)				((line) / w->fieldCnt)6 #define LineToField(w, line)				((line) % w->fieldCnt)  7 static int ClosureToLine(VListWidget w, Opaque closure)  { 
     int line;      LineInfo *lineInfoP;  ^     FOR_EACH_LINE (w, line, lineInfoP) if (lineInfoP->vLine.closure == closure) return (line); 										return (-1); }   1 static int RowToFirstLine(VListWidget w, int row)  { 5     if ((row < 0) || (row >= w->rowCnt)) return (-1); '     			  		 return (row * w->fieldCnt);  }   < static int FieldRowToLine(VListWidget w, int field, int row) { ^     if ((field < 0) || (field >= w->fieldCnt) || (row < 0) || (row >= w->rowCnt)) return (-1);'     return (row * w->fieldCnt + field);  }     L static int CellIsVisible(VListWidget w, int x, int y, int width, int height) { F     /* Cast width and height to avoid unsigned comparison problems. */  y     if ((x >= (int)w->core.width) || ((x + width) <= 0) || (y >= (int)w->core.height) || ((y + height) <= 0)) return (0); "     													      return (1); }   n static void ColumnTierToCell(VListWidget w, int column, int tier, int *xP, int *yP, int *widthP, int *heightP) { =     ColumnInfo *columnInfoP = ColumnToColumnInfo (w, column);   4     *xP      = columnInfoP->x - w->requestedXAdjust;O     *yP      = w->topMarginHeight + tier * w->tierHeight - w->requestedYAdjust; "     *widthP  = columnInfoP->width;     *heightP = w->cellHeight;  }   c static void GroupFieldToLines(VListWidget w, int group, int field, int *firstLineP, int *lastLineP)  { M     int firstLine = (*firstLineP) = group * w->tierCnt * w->fieldCnt + field; ?     int lastLine  = firstLine + (w->tierCnt - 1) * w->fieldCnt;   N     if (lastLine >= w->lineCnt) lastLine = (w->lineCnt - w->fieldCnt + field);       *lastLineP = lastLine; }   @ static int ColumnTierToLine(VListWidget w, int column, int tier) { 
     int line;   d     if ((column < 0) || (column >= w->columnCnt) || (tier < 0) || (tier >= w->tierCnt)) return (-1);Q     line = ((column/w->fieldCnt) * (w->tierCnt-1) + tier) * w->fieldCnt + column; 0     if (line >= w->lineCnt) 								return (-1);!     			    								return (line);  }   O static void LineToColumnTier(VListWidget w, int line, int *columnP, int *tierP)  { #     int row   = line / w->fieldCnt; "     int group = row  / w->tierCnt;  2     *columnP = line - (row - group) * w->fieldCnt;-     *tierP   = row - group 	    * w->tierCnt;  }   , static int VXToColumn(VListWidget w, int vX) {      int column;      ColumnInfo *columnInfoP;  p     for (column = 0, columnInfoP = ColumnToColumnInfo (w, 0); (column < w->columnCnt) && (vX >= columnInfoP->x);!       column++, columnInfoP++) {}   !     if (column == w->columnCnt) {  	columnInfoP--; B 	if (vX >= (columnInfoP->x + columnInfoP->width)) return (column);     }        return (column - 1); }   * static int VYToTier(VListWidget w, int vY) { 
     int tier;   :     if (vY < w->topMarginHeight) 				         return (-1);]     if ((tier = (vY - w->topMarginHeight) / w->tierHeight) > w->tierCnt) return (w->tierCnt);      									 return (tier); }   R static int RectangleToLines(VListWidget w, int vX, int vY, int width, int height, F 	int *firstColumnP, int *lastColumnP, int *firstTierP, int *lastTierP) { 5     int firstColumn, lastColumn, firstTier, lastTier;   %     firstColumn = VXToColumn (w, vX); 1     lastColumn  = VXToColumn (w, vX + width - 1);   l     if ((firstColumn == lastColumn) && ((firstColumn == (-1)) || (firstColumn == w->columnCnt))) return (0);  3     if (firstColumn == (-1))         firstColumn++; 2     if (lastColumn  == w->columnCnt) lastColumn--;  !     firstTier = VYToTier (w, vY); .     lastTier  = VYToTier (w, vY + height - 1);  b     if ((firstTier == lastTier) && ((firstTier == (-1)) || (firstTier == w->tierCnt))) return (0);  -     if (firstTier == (-1))       firstTier++; ,     if (lastTier  == w->tierCnt) lastTier--;        *firstColumnP = firstColumn;     *lastColumnP  = lastColumn;      *firstTierP   = firstTier;     *lastTierP    = lastTier;        return (1);  }   Q static void XYToColumnTier(VListWidget w, int x, int y, int *columnP, int *tierP)  {      int column;        if (x < 0) *columnP = (-1); 9     else if (x >= w->core.width) *columnP = w->columnCnt; 
     else {8         column = VXToColumn (w, x + w->externalXAdjust);  [ 	if ((w->selectUnit == VListSelectUnitRow) && (column != (-1)) && (column != w->columnCnt)) 5 	    column = ColumnToFirstColumnInGroup (w, column);    	*columnP = column;      }   "     if (y < 0) 			  *tierP = (-1);6     else if (y >= w->core.height) *tierP = w->tierCnt;<     else 			  *tierP = VYToTier (w, y + w->externalYAdjust); }   ] static void ColumnTierToFieldRow(VListWidget w, int column, int tier, int *fieldP, int *rowP)  {      int group;       if (column < 0) { 
 	group   = 0;  	*fieldP = (-1);(     } else if (column == w->columnCnt) { 	group   = w->groupCnt - 1;  	*fieldP = w->fieldCnt;      } else {,         group   = ColumnToGroup (w, column);1 	*fieldP = ColumnGroupToField (w, column, group);      }        if (tier < 0) tier = 0; 2     if (tier >= w->tierCnt) tier = w->tierCnt - 1;  &     *rowP = group * w->tierCnt + tier; }t dN static int ValueToX(int minX, int maxX, int minValue, int maxValue, int value) {*%     int vRange = maxValue - minValue;(       if (!vRange) vRange = 1;  S     return (minX + (((value - minValue) * (maxX - minX) + (vRange - 1)) / vRange));s }e  } static int ValuesToXs(int minX, int maxX, int minValue, int maxValue, int lowValue, int highValue, int *leftXP, int *rightXP)* {      if (lowValue > highValue) {i 	int t     = lowValue; 	lowValue  = highValue;9 	highValue = t;c     }b  :     if ((highValue < minValue) || (lowValue > maxValue)) { 	*leftXP  = (-1);i 	*rightXP = (-1);  	return (0);     }z  3     if (highValue > maxValue) highValue = maxValue;s3     if (lowValue  < minValue) lowValue  = minValue;e  C     *leftXP  = ValueToX (minX, maxX, minValue, maxValue, lowValue);dD     *rightXP = ValueToX (minX, maxX, minValue, maxValue, highValue);       return (1);e }e  6 static void MinMax(int a, int b, int *minP, int *maxP) {o&     if (a < b) {*minP = a; *maxP = b;}&     else       {*minP = b; *maxP = a;} }    LQ static void GetPixmapGeometry(VListWidget w, Pixmap p, int *widthP, int *heightP)y {e     Window rootWindow;
     int x, y;k$     unsigned int borderWidth, depth;  
     if (!p) {  	(*widthP) = (*heightP) = 0; 	return;     }k  !     if (p == w->latestPixmapId) {t# 	(*widthP)  = w->latestPixmapWidth; $ 	(*heightP) = w->latestPixmapHeight; 	return;     }m       XGetGeometry (VtkDisplay (w), p, &rootWindow, &x, &y, (unsigned int *)widthP, (unsigned int *)heightP, &borderWidth, &depth);f       w->latestPixmapId     = p;&     w->latestPixmapWidth  = (*widthP);'     w->latestPixmapHeight = (*heightP);a }   } static void GetTextGeometry(VListWidget w, int fontidx, char *textP, int textStrlen, int *widthP, int *heightP, int *ascentP). {      XFontStruct *fontP;o     unsigned char *chP;l     XCharStruct *charP;d-     unsigned int firstCol, numCols, c, width;N       if (!textStrlen) {) 	(*widthP) = (*heightP) = (*ascentP) = 0;1 	return;     }t  (     fontP 	= FontidxToFont (w, fontidx);"     chP 	= (unsigned char *)textP;     charP 	= fontP->per_char;I)     firstCol 	= fontP->min_char_or_byte2;e7     numCols 	= fontP->max_char_or_byte2 - firstCol + 1;      width 	= 0;a       while (textStrlen--) { 	c = (*(chP++)) - firstCol;  	if (c < numCols) ( 	    if (charP) width += charP[c].width;^ 	    else       width += fontP->max_bounds.width;	/* FIXED font has no per-char information */     }        (*widthP)  = width;DF     (*heightP) = fontP->max_bounds.descent + fontP->max_bounds.ascent;*     (*ascentP) = fontP->max_bounds.ascent; }1  X static int ComputeBodyX(int x, int width, int bodyWidth, int marginWidth, int alignment) {r     switch (alignment) { 	case VListAlignmentTopLeft	:r 	case VListAlignmentLeft		:a: 	case VListAlignmentBottomLeft	: return (x + marginWidth);   	case VListAlignmentTop		: 	case VListAlignmentCenter	:B 	case VListAlignmentBottom	: return (x + (width - bodyWidth) / 2);   	case VListAlignmentTopRight	: 	case VListAlignmentRight	:9O 	case VListAlignmentBottomRight	: return (x + width - marginWidth - bodyWidth);d     }-  2     return (0);		/* control does not reach here */ }c lr static int GetChunkGeometry(LineInfo *lineInfoP, int firstSegment, int *widthP, int *maxAscentP, int *maxDescentP) {rC     int segment, width = 0, maxAscent = 0, maxDescent = 0, descent;L     SegmentInfo *segmentInfoP;  I     FOR_EACH_SEGMENT_L (lineInfoP, segment, segmentInfoP, firstSegment) {c" 	width += segmentInfoP->bodyWidth;  V 	if (maxAscent  < segmentInfoP->maxAscent) 					 maxAscent  = segmentInfoP->maxAscent;g 	if (maxDescent < (descent = segmentInfoP->bodyHeight - segmentInfoP->maxAscent)) maxDescent = descent;b  = 	if (segmentInfoP->vSegment.mask & VListSegmentNewLineMask) {n 	    segment++;u 	    break;p 	}     }h       (*widthP) 	   = width;     (*maxAscentP)  = maxAscent;       (*maxDescentP) = maxDescent;  $     return (segment - firstSegment); }u  T static void GetChunkLayout(int bodyX, int bodyWidth, int maxAscent, int maxDescent, . 	int chunkWidth, int alignment, int *chunkXP, + 	int *chunkHeightP, int *leftMarginWidthP, i, 	int *rightMarginXP, int *rightMarginWidthP) {l     int chunkX, rightMarginX;e  1     (*chunkHeightP) 	 		= maxAscent + maxDescent; [     (*chunkXP)	    	 = chunkX 	= ComputeBodyX (bodyX, bodyWidth, chunkWidth, 0, alignment);o,     (*leftMarginWidthP)  		= chunkX - bodyX;<     (*rightMarginXP) 	 = rightMarginX = chunkX + chunkWidth;>     (*rightMarginWidthP) 		= bodyX + bodyWidth - rightMarginX; }1  T static void ComputeHistInfo(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP) {l+     lineInfoP->bodyWidth  = vFieldP->width; *     lineInfoP->bodyHeight = w->histHeight; }   T static void ComputeIconInfo(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP) {yn     GetPixmapGeometry (w, lineInfoP->vLine.icon, (int *)&lineInfoP->bodyWidth, (int *)&lineInfoP->bodyHeight); }   T static void ComputeTextInfo(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP) {i:     int segment, segmentCnt, maxAscent, maxDescent, width;     SegmentInfo *segmentInfoP;  ;     if (!lineInfoP->vLine.textP) lineInfoP->textStrlen = 0;gE     else 			 lineInfoP->textStrlen = strlen (lineInfoP->vLine.textP);.  )     if (!lineInfoP->vLine.segmentCount) {d] 	GetTextGeometry (w, lineInfoP->vLine.fontidx, lineInfoP->vLine.textP, lineInfoP->textStrlen,dY 	    (int *)&lineInfoP->bodyWidth, (int *)&lineInfoP->bodyHeight, &lineInfoP->maxAscent);r   	return;     }s  7     FOR_EACH_SEGMENT (lineInfoP, segment, segmentInfoP)t9 	if (segmentInfoP->vSegment.type == VListSegmentTypeText) 8 	    GetTextGeometry (w, segmentInfoP->vSegment.fontidx,i 	        lineInfoP->vLine.textP + segmentInfoP->vSegment.textPosition, segmentInfoP->vSegment.textStrlen, L 	        (int *)&segmentInfoP->bodyWidth, (int *)&segmentInfoP->bodyHeight,  		&segmentInfoP->maxAscent); 	else {cX 	    GetPixmapGeometry (w, segmentInfoP->vSegment.icon, (int *)&segmentInfoP->bodyWidth,% 			(int *)&segmentInfoP->bodyHeight);e< 	    segmentInfoP->maxAscent = segmentInfoP->bodyHeight / 2; 	}  ?     lineInfoP->bodyWidth = lineInfoP->bodyHeight = segment = 0;r  c     while ((segmentCnt = GetChunkGeometry (lineInfoP, segment, &width, &maxAscent, &maxDescent))) {f@ 	if (lineInfoP->bodyWidth < width) lineInfoP->bodyWidth = width;3 	lineInfoP->bodyHeight += (maxAscent + maxDescent);  	segment += segmentCnt;c     }  }e  T static void ComputeCellInfo(VListWidget w, VListField *vFieldP, LineInfo *lineInfoP) {a$     switch (lineInfoP->vLine.type) {O       case VListLineTypeText	: ComputeTextInfo (w, lineInfoP, vFieldP);		break;yO       case VListLineTypeIcon	: ComputeIconInfo (w, lineInfoP, vFieldP);		break;oO       case VListLineTypeHist	: ComputeHistInfo (w, lineInfoP, vFieldP);		break;r     }t }l  E static void SupplySegmentDefaults(VListWidget w, LineInfo *lineInfoP)A {V     int segment;     SegmentInfo *segmentInfoP;,     VListLine *vLineP = (&lineInfoP->vLine);     VListSegment *vSegmentP;  9     FOR_EACH_SEGMENT (lineInfoP, segment, segmentInfoP) {p' 	vSegmentP = (&segmentInfoP->vSegment);   _ 	if (!(vSegmentP->mask & VListSegmentTypeMask))     vSegmentP->type     = VListSegmentTypeText; Z 	if (!(vSegmentP->mask & VListSegmentFontidxMask))  vSegmentP->fontidx  = vLineP->fontidx;[ 	if (!(vSegmentP->mask & VListSegmentColoridxMask)) vSegmentP->coloridx = vLineP->coloridx; [ 	if (!(vSegmentP->mask & VListSegmentStippledMask)) vSegmentP->stippled = vLineP->stippled; W 	if (!(vSegmentP->mask & VListSegmentIconMask))     vSegmentP->icon     = vLineP->icon;      }a }a  ? static void SupplyBarDefaults(VListWidget w, VListLine *vLineP)  {5     int bar;     VListBar *barP;n  &     FOR_EACH_BAR (vLineP, bar, barP) {@ 	if (!(barP->mask & VListBarLowValueMask))  barP->lowValue  = 0;B 	if (!(barP->mask & VListBarHighValueMask)) barP->highValue = 100;O 	if (!(barP->mask & VListBarColoridxMask))  barP->coloridx  = vLineP->coloridx;rO 	if (!(barP->mask & VListBarStippledMask))  barP->stippled  = vLineP->stippled;i     }o }a  C static void SupplyFieldDefaults(VListWidget w, VListField *vFieldP)k {e\     if (!(vFieldP->mask & VListFieldTypeMask))         vFieldP->type 		= VListFieldTypeText;Z     if (!(vFieldP->mask & VListFieldAlignmentMask))    vFieldP->alignment 	= w->alignment;P     if (!(vFieldP->mask & VListFieldMaxValueMask))     vFieldP->maxValue 	= 100;N     if (!(vFieldP->mask & VListFieldMinValueMask))     vFieldP->minValue 	= 0;e     if (!(vFieldP->mask & VListFieldResizePolicyMask)) vFieldP->resizePolicy 	= w->fieldResizePolicy;t  1     if (!(vFieldP->mask & VListFieldGridsMask)) {n 	vFieldP->gridsP    = 0; 	vFieldP->gridCount = 0;     }	  5     if (!(vFieldP->mask & VListFieldMarginWidthMask))  	switch (vFieldP->type) {CO 	  case VListFieldTypeText	: vFieldP->marginWidth = w->textMarginWidth;		break;nP 	  case VListFieldTypeHist 	: vFieldP->marginWidth = w->histMarginWidth;		break;P 	  case VListFieldTypeIcon 	: vFieldP->marginWidth = w->iconMarginWidth;		break; 	}  6     if (!(vFieldP->mask & VListFieldMarginHeightMask)) 	switch (vFieldP->type) { Q 	  case VListFieldTypeText	: vFieldP->marginHeight = w->textMarginHeight;		break;	R 	  case VListFieldTypeHist 	: vFieldP->marginHeight = w->histMarginHeight;		break;R 	  case VListFieldTypeIcon 	: vFieldP->marginHeight = w->iconMarginHeight;		break; 	}  /     if (!(vFieldP->mask & VListFieldWidthMask))n 	switch (vFieldP->type) { ; 	  case VListFieldTypeText	: vFieldP->width = 0;					break;,; 	  case VListFieldTypeIcon	: vFieldP->width = 0;					break;tD 	  case VListFieldTypeHist	: vFieldP->width = w->histWidth;			break; 	} }I  ? static void SupplyGridDefaults(VListWidget w, VListGrid *gridP)  {f>     if (!(gridP->mask & VListGridRowMask))   gridP->row   = 0;>     if (!(gridP->mask & VListGridValueMask)) gridP->value = 0;>     if (!(gridP->mask & VListGridTextMask))  gridP->textP = 0;  -     if (!(gridP->mask & VListGridDashMask)) {g  	gridP->dashOn  = w->gridDashOn;! 	gridP->dashOff = w->gridDashOff;O     }G  /     if (!(gridP->mask & VListGridColoridxMask))u4 	if (!w->colorList) gridP->coloridx = w->foreground; 	else 		   gridP->coloridx = 0;  }   N static void SupplyLabelDefaults(VListWidget w, VListLabel *vLabelP, int label) {rF     if (!(vLabelP->mask & VListLabelTextMask))		vLabelP->textP 		= "";D     if (!(vLabelP->mask & VListLabelRowMask)) 		vLabelP->row 	 	= 0;a     if (!(vLabelP->mask & VListLabelFirstFieldMask)) 	vLabelP->firstField 	= label % w->fieldCnt;Ia     if (!(vLabelP->mask & VListLabelLastFieldMask))  	vLabelP->lastField  	= vLabelP->firstField;(Z     if (!(vLabelP->mask & VListLabelAlignmentMask))  	vLabelP->alignment  	= w->alignment;T     if (!(vLabelP->mask & VListLabelPadMask)) 		vLabelP->pad 	 	= w->labelPadOption; }t  U static void SupplyLineDefaults(VListWidget w, VListLine *vLineP, VListField *vFieldP)d {)G     if (!(vLineP->mask & VListLineTextMask))      vLineP->textP   	= 0;oG     if (!(vLineP->mask & VListLineFontidxMask))   vLineP->fontidx 	= 0;(I     if (!(vLineP->mask & VListLineSelectMask))    vLineP->select    	= 0;	I     if (!(vLineP->mask & VListLineSensitiveMask)) vLineP->sensitive 	= 1;nI     if (!(vLineP->mask & VListLineStippledMask))  vLineP->stippled  	= 0;nC     if (!(vLineP->mask & VListLineIconMask)) 	  vLineP->icon 		= 0;eN     if (!(vLineP->mask & VListLineTypeMask))	  vLineP->type	 	= vFieldP->type;     G     if ((!(vLineP->mask & VListLineClosureMask)) || (!vLineP->closure))r2 	vLineP->closure = (Opaque)(++w->lastUsedClosure);     0     if (!(vLineP->mask & VListLineColoridxMask))5 	if (!w->colorList) vLineP->coloridx	= w->foreground; * 	else 	           vLineP->coloridx   	= 0;  2     if (!(vLineP->mask & VListLineBackgroundMask))C 	if (!w->colorList) vLineP->background 	= w->core.background_pixel;e- 	else 	           vLineP->background 	= (-1);i  2     if (!(vLineP->mask & VListLineSegmentsMask)) { 	vLineP->segmentsP    	= 0;  	vLineP->segmentCount 	= 0;d     }(  .     if (!(vLineP->mask & VListLineBarsMask)) { 	vLineP->barsP    	= 0;u 	vLineP->barCount 	= 0;	     }r }r  [ static int ComputeBodyY(int y, int height, int bodyHeight, int marginHeight, int alignment)P {n     switch (alignment) { 	case VListAlignmentTopLeft	:  	case VListAlignmentTop		:9 	case VListAlignmentTopRight	: return (y + marginHeight);s   	case VListAlignmentLeft		:H 	case VListAlignmentCenter	:C 	case VListAlignmentRight	: return (y + (height - bodyHeight) / 2);h  ! 	case VListAlignmentBottomLeft	: i 	case VListAlignmentBottom	:  R 	case VListAlignmentBottomRight	: return (y + height - marginHeight - bodyHeight);     }L  3     return (0);			/* control does not reach here */  }  t$ static void FreeFonts(VListWidget w) {>     XtFree ((char *)w->fontPP);  }l  % static void FreeColors(VListWidget w)C {+$     XtFree ((char *)w->colorTableP); }   % static void FreeLabels(VListWidget w)e {,     LabelInfo *labelInfoP;     VListLabel *vLabelP;     int label;  K     FOR_EACH_LABEL (w, label, labelInfoP, vLabelP) XtFree (vLabelP->textP);   9     XtFree ((char *)w->labelInfosP);		w->labelInfosP = 0;f5     XtFree ((char *)w->labelsP);		w->labelsP     = 0;	 }u  * static void FreeGrids(VListField *vFieldP) { 
     int grid;i     VListGrid *gridP;g  ?     FOR_EACH_GRID (vFieldP, grid, gridP) XtFree (gridP->textP);e%     XtFree ((char *)vFieldP->gridsP);/ }>  % static void FreeFields(VListWidget w)g {p     int field;     VListField *vFieldP;  ;     FOR_EACH_FIELD (w, field, vFieldP) FreeGrids (vFieldP);       XtFree ((char *)w->fieldsP); }   $ static void FreeLines(VListWidget w) { 
     int line;P     LineInfo *lineInfoP;  (     FOR_EACH_LINE (w, line, lineInfoP) {! 	XtFree (lineInfoP->vLine.textP);n) 	XtFree ((char *)lineInfoP->vLine.barsP);t+ 	XtFree ((char *)lineInfoP->segmentInfosP);o     }c  #     XtFree ((char *)w->lineInfosP);      w->lineInfosP = 0;     w->maxLineCnt = 0; }V T% static void CopyColors(VListWidget w)  {r
     int i;     int width, height;     XImage *imageP;n  ;     if (!w->colorList) return;		/* no table was supplied */h  0     /* What is the width of the color pixmap? */  9     GetPixmapGeometry (w, w->colorList, &width, &height);e  #     /* Allocate the color table. */g       w->colorCnt    = width;lF     w->colorTableP = (Pixel *)XtMalloc (w->colorCnt * sizeof (Pixel));  |     /* Get an image of the color pixmap, copy the pixel values from that image to the color table, and destroy the image. */  S     imageP = XGetImage (VtkDisplay (w), w->colorList, 0, 0, width, 1, -1, ZPixmap);o  M     for (i = 0; i < width; i++) w->colorTableP[i] = XGetPixel (imageP, i, 0);        XDestroyImage (imageP);n }l  $ static void CopyFonts(VListWidget w) {,     int height;i     int maxAscent;  W     if (!w->fontTableP) w->fontTableP = (XmFontList)VtkGetDefaultFontList ((Widget) w);=  9     VtkGetFontA (w->fontTableP, &w->fontPP, &w->fontCnt);        GetTextGeometry (w, 0, "0", 1, (int *)&w->charWidth, &height, &maxAscent);	/* constant for horizontal scrolling increment */ }   % static void CopyLabels(VListWidget w)P { %     VListLabel *newVLabelP, *vLabelP;      LabelInfo *labelInfoP;     int label;       if (!w->labelCnt) return;e       newVLabelP = w->labelsP;P     w->labelsP     = (VListLabel *)XtMalloc (w->labelCnt * sizeof (VListLabel));  N     w->labelInfosP = (LabelInfo  *)XtCalloc (w->labelCnt, sizeof (LabelInfo));  4     FOR_EACH_LABEL (w, label, labelInfoP, vLabelP) { 	*vLabelP = (*newVLabelP++);0         SupplyLabelDefaults (w, vLabelP, label);C 	if (vLabelP->textP) vLabelP->textP = XtNewString (vLabelP->textP);t     }( };  9 static void CopyGrids(VListWidget w, VListField *vFieldP)  {e
     int grid;V      VListGrid *newGridP, *gridP;  $     if (!vFieldP->gridCount) return;       newGridP = vFieldP->gridsP;iV     vFieldP->gridsP = (VListGrid *)XtMalloc (vFieldP->gridCount * sizeof (VListGrid));  *     FOR_EACH_GRID (vFieldP, grid, gridP) { 	*gridP = (*(newGridP++)); 	SupplyGridDefaults (w, gridP);>= 	if (gridP->textP) gridP->textP = XtNewString (gridP->textP);o     }  }i  % static void CopyFields(VListWidget w)u { %     VListField *newVFieldP, *vFieldP;      int field;       newVFieldP = w->fieldsP;L     w->fieldsP = (VListField *)XtMalloc (w->fieldCnt * sizeof (VListField));  (     FOR_EACH_FIELD (w, field, vFieldP) {. 	if (newVFieldP) *vFieldP = (*(newVFieldP++)); 	else vFieldP->mask = 0;  )         SupplyFieldDefaults (w, vFieldP);  	CopyGrids (w, vFieldP);     }a }   - static void CopySegments(LineInfo *lineInfoP)n {i     int segCnt, segment;     VListSegment *segmentP;      SegmentInfo *segmentInfoP;  :     if (!(segCnt = lineInfoP->vLine.segmentCount)) return;  z     lineInfoP->segmentInfosP = (SegmentInfo *)XtRealloc ((char *)lineInfoP->segmentInfosP, sizeof (SegmentInfo) * segCnt);  *     segmentP = lineInfoP->vLine.segmentsP;a     FOR_EACH_SEGMENT (lineInfoP, segment, segmentInfoP) segmentInfoP->vSegment = (*(segmentP++));e }o  ) static void CopyBars(LineInfo *lineInfoP)o {m     int barCnt, bar;      VListBar *oldBarP, *newBarP;  0     if (!(barCnt = lineInfoP->vLine.barCount)) {#         lineInfoP->vLine.barsP = 0;c         return;a     },  %     oldBarP = lineInfoP->vLine.barsP;)Y     newBarP = lineInfoP->vLine.barsP = (VListBar *)XtMalloc (sizeof (VListBar) * barCnt);P  S     for (bar = 0; bar < barCnt; bar++, oldBarP++, newBarP++) *newBarP = (*oldBarP);W }o  + static void ComputeLabelInfo(VListWidget w)  {t     LabelInfo *labelInfoP;     VListLabel *vLabelP;)     int label, rows, fields, field, grid;m     VListField *vFieldP;     VListGrid *gridP;(  +     if ((!w->vHeaderW) || (!w->labelCnt)) {  	w->headerHeight = 0;y 	return;     }   
     rows = 1;x4     FOR_EACH_LABEL (w, label, labelInfoP, vLabelP) {P 	labelInfoP->textWidth = VHeaderComputeLabelWidth (w->vHeaderW, vLabelP->textP);  7 	fields = vLabelP->lastField - vLabelP->firstField + 1;   l         labelInfoP->widthPerColumn = (labelInfoP->textWidth + 2 * w->textMarginWidth + fields - 1) / fields;  3 	if (vLabelP->row >= rows) rows = vLabelP->row + 1;      }d  &     FOR_EACH_FIELD (w, field, vFieldP)f 	FOR_EACH_GRID (vFieldP, grid, gridP) if (gridP->textP && (gridP->row >= rows)) rows = gridP->row + 1;  F     w->headerHeight = VHeaderComputeLogicalHeight (w->vHeaderW, rows); }   * static void SetHeaderLabels(VListWidget w) {PG     int field, grid, label, group, firstColumn, lastColumn, vhLabelCnt;fE     int gridLabelCnt = 0, gridX, column, leftX, rightX, textWidth, x; A     ColumnInfo *firstColumnInfoP, *lastColumnInfoP, *columnInfoP;      LabelInfo *labelInfoP;     VListLabel *vLabelP;'     VHeaderLabel *vhLabelsP, *vhLabelP;F     VListField *vFieldP;     VListGrid *gridP;        if (!w->vHeaderW) return;*  m     FOR_EACH_FIELD (w, field, vFieldP) FOR_EACH_GRID (vFieldP, grid, gridP) if (gridP->textP) gridLabelCnt++;   <     vhLabelCnt = (w->labelCnt + gridLabelCnt) * w->groupCnt;     if (!vhLabelCnt) return;  Y     vhLabelP = vhLabelsP = (VHeaderLabel *)XtMalloc (vhLabelCnt * sizeof (VHeaderLabel));c       FOR_EACH_GROUP (w, group)t1 	FOR_EACH_LABEL (w, label, labelInfoP, vLabelP) {:' 	    vhLabelP->textP 	= vLabelP->textP;s1 	    vhLabelP->textWidth = labelInfoP->textWidth;/# 	    vhLabelP->row 	= vLabelP->row;:# 	    vhLabelP->pad 	= vLabelP->pad;   F 	    firstColumn = GroupFieldToColumn (w, group, vLabelP->firstField);E 	    lastColumn  = GroupFieldToColumn (w, group, vLabelP->lastField);   < 	    firstColumnInfoP = ColumnToColumnInfo (w, firstColumn);; 	    lastColumnInfoP  = ColumnToColumnInfo (w, lastColumn);n  @ 	    vhLabelP->x     = firstColumnInfoP->x + w->textMarginWidth;f 	    vhLabelP->width = lastColumnInfoP->x + lastColumnInfoP->width - w->textMarginWidth - vhLabelP->x;q 	    vhLabelP->textX = ComputeBodyX (vhLabelP->x, vhLabelP->width, labelInfoP->textWidth, 0, vLabelP->alignment);>   	    vhLabelP++; 	}       if (gridLabelCnt)n# 	FOR_EACH_FIELD (w, field, vFieldP)c= 	    FOR_EACH_GRID (vFieldP, grid, gridP) if (gridP->textP) {kC 		textWidth = VHeaderComputeLabelWidth (w->vHeaderW, gridP->textP);    		FOR_EACH_GROUP (w, group) {;5 		    column 	= GroupFieldToColumn (w, group, field);=3 		    columnInfoP = ColumnToColumnInfo (w, column);   5 		    leftX  = columnInfoP->x + vFieldP->marginWidth;,N 		    rightX = columnInfoP->x + columnInfoP->width - vFieldP->marginWidth - 1;  [ 		    gridX = ValueToX (leftX, rightX, vFieldP->minValue, vFieldP->maxValue, gridP->value);l  & 		    x = gridX - (textWidth + 1) / 2;  & 		    vhLabelP->textP 	= gridP->textP;& 		    vhLabelP->textWidth = textWidth;" 		    vhLabelP->row 	= gridP->row;1 		    vhLabelP->pad 	= VHeaderLabelPadWithBlanks;c 		    vhLabelP->x 	= x;h# 		    vhLabelP->width 	= textWidth;+ 		    vhLabelP->textX 	= x;i 		    vhLabelP++;+ 		}W 	    }       XtVaSetValues (w->vHeaderW,o  	VHeaderNlabelCount, vhLabelCnt,#     	VHeaderNlabels,     vhLabelsP,  	0);       XtFree ((char *)vhLabelsP);w }h  B static void SetStippled(VListWidget w, int stippled, int x, int y) {o     if (!stippled) { 	if (w->currentStippled) {: 	    XSetFillStyle (VtkDisplay (w), w->normgc, FillSolid);: 	    XSetFillStyle (VtkDisplay (w), w->invgc,  FillSolid);: 	    XSetFillStyle (VtkDisplay (w), w->flipgc, FillSolid); 	    w->currentStippled = 0; 	}   	return;     }        if (!w->stippleBitmap) {4 	w->stippleBitmap = VtkGetStippleBitmap ((Widget)w);  ; 	XSetStipple (VtkDisplay (w), w->normgc, w->stippleBitmap); ; 	XSetStipple (VtkDisplay (w), w->invgc,  w->stippleBitmap);e; 	XSetStipple (VtkDisplay (w), w->flipgc, w->stippleBitmap);t     }y       if (!w->currentStippled) {9 	XSetFillStyle (VtkDisplay (w), w->normgc, FillStippled);l9 	XSetFillStyle (VtkDisplay (w), w->invgc,  FillStippled);f9 	XSetFillStyle (VtkDisplay (w), w->flipgc, FillStippled);T 	w->currentStippled = 1;     }P  A     if ((x != w->currentStippleX) || (y != w->currentStippleY)) {G0 	XSetTSOrigin (VtkDisplay (w), w->normgc, x, y);0 	XSetTSOrigin (VtkDisplay (w), w->invgc,  x, y);0 	XSetTSOrigin (VtkDisplay (w), w->flipgc, x, y); 	w->currentStippleX = x; 	w->currentStippleY = y;     }& }m  M static void SetDashes(VListWidget w, int dashOn, int dashOff, int dashOffset)m {y     char dashList[2];m  %     dashOffset %= (dashOn + dashOff);,  w     if ((dashOn == w->currentDashOn) && (dashOff == w->currentDashOff) && (dashOffset == w->currentDashOffset)) return;-       dashList[0] = dashOn;e     dashList[1] = dashOff;D     XSetDashes (VtkDisplay (w), w->normgc, dashOffset, dashList, 2);  "     w->currentDashOn     = dashOn;#     w->currentDashOff    = dashOff;o&     w->currentDashOffset = dashOffset; }   B static void SetColors(VListWidget w, int coloridx, int background) {c+     Pixel foregroundPixel, backgroundPixel;l       if (!w->colorList) {# 	foregroundPixel = (Pixel)coloridx;e% 	backgroundPixel = (Pixel)background;:     } else {J 	foregroundPixel = w->colorTableP[((unsigned int)coloridx % w->colorCnt)];  D 	if (background == (-1)) backgroundPixel = w->core.background_pixel;[ 	else 		        backgroundPixel = w->colorTableP[((unsigned int)background % w->colorCnt)];n     }t  g     if ((foregroundPixel == w->currentForeground) && (backgroundPixel == w->currentBackground)) return;   +     w->currentForeground = foregroundPixel;t+     w->currentBackground = backgroundPixel;o  @     XSetForeground (VtkDisplay (w), w->normgc, foregroundPixel);@     XSetBackground (VtkDisplay (w), w->normgc, backgroundPixel);  @     XSetBackground (VtkDisplay (w), w->invgc,  foregroundPixel);@     XSetForeground (VtkDisplay (w), w->invgc,  backgroundPixel);  Q     XSetPlaneMask (VtkDisplay (w), w->flipgc, backgroundPixel ^ foregroundPixel);x }   / static void SetFont(VListWidget w, int fontidx)  {g-     if (fontidx == w->currentFontidx) return;e  3     w->currentFontP   = FontidxToFont (w, fontidx);o      w->currentFontidx = fontidx;  ?     XSetFont (VtkDisplay (w), w->normgc, w->currentFontP->fid); ?     XSetFont (VtkDisplay (w), w->invgc,  w->currentFontP->fid);n }  ,H static void SetInternalXYAdjust(VListWidget w, int xAdjust, int yAdjust) {i.     /* Keep both adjustments within bounds. */  6     {int maxXAdjust = w->logicalWidth - w->core.width;D     if ((maxXAdjust <= 0) || (xAdjust <= 0)) w->internalXAdjust = 0;I     else if (xAdjust > maxXAdjust) 	     w->internalXAdjust = maxXAdjust;v0     else 				     w->internalXAdjust = xAdjust;}  8     {int maxYAdjust = w->logicalHeight - w->core.height;D     if ((maxYAdjust <= 0) || (yAdjust <= 0)) w->internalYAdjust = 0;I     else if (yAdjust > maxYAdjust) 	     w->internalYAdjust = maxYAdjust; 0     else 				     w->internalYAdjust = yAdjust;} }i  ) static void SetSlaveValues(VListWidget w)s { $     w->ignoreScrollValueChanged = 1;  F     if ((w->requestedXAdjust != w->shownScrollXAdjust) && w->hScrollW)W 	XtVaSetValues (w->hScrollW, XmNvalue, w->shownScrollXAdjust = w->requestedXAdjust, 0);M  F     if ((w->requestedYAdjust != w->shownScrollYAdjust) && w->vScrollW)W 	XtVaSetValues (w->vScrollW, XmNvalue, w->shownScrollYAdjust = w->requestedYAdjust, 0);   $     w->ignoreScrollValueChanged = 0;  c     if ((w->requestedXAdjust != w->shownHeaderXAdjust) && w->vHeaderW && XtIsManaged (w->vHeaderW))t^ 	XtVaSetValues (w->vHeaderW, VHeaderNxAdjust, w->shownHeaderXAdjust = w->requestedXAdjust, 0); }   & static void SetPosition(VListWidget w) {gB     w->externalXAdjust = w->requestedXAdjust = w->internalXAdjust;B     w->externalYAdjust = w->requestedYAdjust = w->internalYAdjust;     SetSlaveValues (w);m }i  - static void StartPendingScroll(VListWidget w)L {F     int x, y, width, height;  #     if (!w->layoutIsValid)  return; #     if (w->scrollIsActive)  return;F  !     /* Check for autoscrolling */y  1     if (w->xScrollStrength || w->yScrollStrength) k 	SetInternalXYAdjust (w, w->internalXAdjust + w->xScrollStrength, w->internalYAdjust + w->yScrollStrength);i  D     /* If the scroll position is already consistent, just return. */  k     if ((w->internalXAdjust == w->requestedXAdjust) && (w->internalYAdjust == w->requestedYAdjust)) return;   y     /* Compute the CopyArea parameters and ask the server to scroll the window contents.  Keep track of the fact that the e      * server is busy, and keep track of the scroll position we requested the server to establish. */-  1     x = w->internalXAdjust - w->requestedXAdjust;s1     y = w->internalYAdjust - w->requestedYAdjust;l     width  = w->core.width;      height = w->core.height;  -     w->requestedXAdjust = w->internalXAdjust;,-     w->requestedYAdjust = w->internalYAdjust;(     SetSlaveValues (w);l       SetStippled (w, 0, 0, 0);;4     w->scrollSerial = XNextRequest (VtkDisplay (w));c     XCopyArea (VtkDisplay (w), VtkWindow (w), VtkWindow (w), w->normgc, x, y, width, height, 0, 0);%     w->scrollIsActive = 1; }l  8 void VListSetAutoScrollPosition(Widget ow, int x, int y) {a$     VListWidget w = (VListWidget)ow;
     int s;  #     if (!VtkIsRealized (w)) return;e       if (x < 0) 			 s = x;(7     else if (x >= w->core.width) s = x - w->core.width;      else 			 s = 0;t5     w->xScrollStrength = s * w->autoScrollRate / 100;L       if (y < 0) 			  s = y;9     else if (y >= w->core.height) s = y - w->core.height;      else 			  s = 0;5     w->yScrollStrength = s * w->autoScrollRate / 100;n  I     if (w->xScrollStrength || w->yScrollStrength) StartPendingScroll (w);> }e  / static void ComputeLogicalHeight(VListWidget w)s {vK     if ((!w->allowDeadspace) || (w->columnStyle != VListColumnStyleSingle))a[ 	w->logicalHeight = w->tierCnt * w->tierHeight + 2 * w->marginHeight - w->rowSpacingHeight;	     elseF 	w->logicalHeight = (w->tierCnt - 1) * w->tierHeight + w->core.height; };  W static void HPageIncCallback(Widget unused_sbW, XtPointer ow, XtPointer unused_cbDataP)o {e$     VListWidget w = (VListWidget)ow;     int maxXAdjust, xAdjust;  @     xAdjust = w->internalXAdjust + w->core.width - w->charWidth;  9     if (w->logicalWidth <= w->core.width) maxXAdjust = 0; <     else 				  maxXAdjust = w->logicalWidth - w->core.width;  3     if (xAdjust > maxXAdjust) xAdjust = maxXAdjust;   N     XtVaSetValues (w->hScrollW, XmNvalue, w->shownScrollXAdjust = xAdjust, 0);  !     w->internalXAdjust = xAdjust;P     StartPendingScroll (w);o }   W static void HPageDecCallback(Widget unused_sbW, XtPointer ow, XtPointer unused_cbDataP)  {i$     VListWidget w = (VListWidget)ow;     int xAdjust;  @     xAdjust = w->internalXAdjust - w->core.width + w->charWidth;!     if (xAdjust < 0) xAdjust = 0;   N     XtVaSetValues (w->hScrollW, XmNvalue, w->shownScrollXAdjust = xAdjust, 0);  !     w->internalXAdjust = xAdjust;      StartPendingScroll (w);H }c  V static void HValueChangedCallback(Widget unused_sbW, XtPointer ow, XtPointer cbDataOP) {)$     VListWidget w = (VListWidget)ow;O     XmScrollBarCallbackStruct *cbDataP = (XmScrollBarCallbackStruct *)cbDataOP;   ,     if (w->ignoreScrollValueChanged) return;  @     w->shownScrollXAdjust = w->internalXAdjust = cbDataP->value;  I     if (!VtkIsRealized (w)) SetPosition (w); else StartPendingScroll (w);t }c  W static void VPageIncCallback(Widget unused_sbW, XtPointer ow, XtPointer unused_cbDataP)i {r$     VListWidget w = (VListWidget)ow;     int yAdjust, maxYAdjust;  B     yAdjust = w->internalYAdjust + w->core.height - w->tierHeight;  ;     if (w->logicalHeight <= w->core.height) maxYAdjust = 0;)@     else 				    maxYAdjust = w->logicalHeight - w->core.height;  3     if (yAdjust > maxYAdjust) yAdjust = maxYAdjust;d  N     XtVaSetValues (w->vScrollW, XmNvalue, w->shownScrollYAdjust = yAdjust, 0);  !     w->internalYAdjust = yAdjust;g     StartPendingScroll (w);c }   W static void VPageDecCallback(Widget unused_sbW, XtPointer ow, XtPointer unused_cbDataP)  {s$     VListWidget w = (VListWidget)ow;     int yAdjust;  B     yAdjust = w->internalYAdjust - w->core.height + w->tierHeight;!     if (yAdjust < 0) yAdjust = 0;   N     XtVaSetValues (w->vScrollW, XmNvalue, w->shownScrollYAdjust = yAdjust, 0);  !     w->internalYAdjust = yAdjust;)     StartPendingScroll (w);P }L  V static void VValueChangedCallback(Widget unused_sbW, XtPointer ow, XtPointer cbDataOP) {l$     VListWidget w = (VListWidget)ow;O     XmScrollBarCallbackStruct *cbDataP = (XmScrollBarCallbackStruct *)cbDataOP;n  ,     if (w->ignoreScrollValueChanged) return;  @     w->shownScrollYAdjust = w->internalYAdjust = cbDataP->value;  I     if (!VtkIsRealized (w)) SetPosition (w); else StartPendingScroll (w);w }- lO #define DRAW_HIST_BAR(lowValue, highValue, coloridx, stippled, vFieldP)							\r     {															\-a     if (ValuesToXs (minX, maxX, minValue, maxValue, lowValue, highValue, &leftX, &rightX)) {				\r? 	SetColors (w, coloridx, lineInfoP->vLine.background);								\,, 	SetStippled (w, stippled, x, y);										\` 	XFillRectangle (VtkDisplay (w), VtkWindow (w), w->normgc, leftX, y + vFieldP->marginHeight,			\E 	    rightX - leftX + 1, height - 2 * vFieldP->marginHeight);							\g     }															\t     }   N static void DrawHist(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP, E 		     int x, int y, int width, unsigned height, int flip, int clear)  {=(     int bar, grid, gridX, leftX, rightX;     VListGrid *gridP;      VListBar *barP;w(     int minX = x + vFieldP->marginWidth;4     int maxX = x + width - vFieldP->marginWidth - 1;%     int minValue = vFieldP->minValue;s%     int maxValue = vFieldP->maxValue;e,     VListLine *vLineP = (&lineInfoP->vLine);       SetStippled (w, 0, 0, 0);>8     SetColors (w, vLineP->coloridx, vLineP->background);  z     if (flip || clear || (w->currentBackground != w->core.background_pixel) || (w->gridStyle != VListGridStyleBackground))O 	XFillRectangle (VtkDisplay (w), VtkWindow (w), w->invgc, x, y, width, height);l  (     FOR_EACH_GRID (vFieldP, grid, gridP)e 	if ((gridP->dashOn) && (gridP->value >= vFieldP->minValue) && (gridP->value <= vFieldP->maxValue)) {eE 	    gridX = ValueToX (minX, maxX, minValue, maxValue, gridP->value);v5 	    SetDashes (w, gridP->dashOn, gridP->dashOff, 0);*8 	    SetColors (w, gridP->coloridx, vLineP->background);[ 	    XDrawLine (VtkDisplay (w), VtkWindow (w), w->normgc, gridX, y, gridX, y + height - 1);i 	}  )     if (vLineP->mask & VListLineBarsMask) z 	FOR_EACH_BAR (vLineP, bar, barP) DRAW_HIST_BAR (barP->lowValue, barP->highValue, barP->coloridx, barP->stippled, vFieldP)     elsea 	DRAW_HIST_BAR (vLineP->lowValue, vLineP->highValue, vLineP->coloridx, vLineP->stippled, vFieldP)l       if (flip) {;<         SetColors (w, vLineP->coloridx, vLineP->background);) 	SetStippled (w, vLineP->stippled, x, y);lW         XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, x, y, width, height);d     }  }s FN static void DrawText(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP, @ 		     int x, int y, int width, int height, int flip, int clear) {nQ     int segment, bodyX, bodyY, segmentCnt, maxAscent, maxDescent, chunkX, chunkY;eC     int chunkWidth, chunkHeight, leftMarginWidth, rightMarginWidth;;     int  rightMarginX;     SegmentInfo *segmentInfoP;  g     bodyX = ComputeBodyX (x, width,  lineInfoP->bodyWidth,  vFieldP->marginWidth,  vFieldP->alignment);eg     bodyY = ComputeBodyY (y, height, lineInfoP->bodyHeight, vFieldP->marginHeight, vFieldP->alignment);)  J     SetColors (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);  t     if (clear || (w->currentBackground != w->core.background_pixel) || (w->gridStyle != VListGridStyleBackground)) { 	SetStippled (w, 0, 0, 0);O 	XFillRectangle (VtkDisplay (w), VtkWindow (w), w->invgc, x, y, width, height);P     }s  5     SetStippled (w, lineInfoP->vLine.stippled, x, y);   ]     if (flip) XFillRectangle (VtkDisplay (w), VtkWindow (w), w->normgc, x, y, width, height);   )     if (!lineInfoP->vLine.segmentCount) {e 	if (lineInfoP->textStrlen) {b+ 	    SetFont (w, lineInfoP->vLine.fontidx);eO 	    XDrawString (VtkDisplay (w), VtkWindow (w), (flip ? w->invgc : w->normgc),dV 		bodyX, bodyY + lineInfoP->maxAscent, lineInfoP->vLine.textP, lineInfoP->textStrlen); 	}           return;l     }a       if (flip) {{o 	/* Flip all internal segment areas.  Do this before drawing ANY text to avoid problems when text is kerned. */d   	chunkY = bodyY;
 	segment = 0; e 	while ((segmentCnt = GetChunkGeometry (lineInfoP, segment, &chunkWidth, &maxAscent, &maxDescent))) {;o             GetChunkLayout (bodyX, lineInfoP->bodyWidth, maxAscent, maxDescent, chunkWidth, vFieldP->alignment,E[                 &chunkX, &chunkHeight, &leftMarginWidth, &rightMarginX, &rightMarginWidth);   x 	    for (segmentInfoP = SegmentToSegmentInfo (lineInfoP, segment); segmentCnt; segmentInfoP++, segment++, segmentCnt--)  		if (segmentInfoP->bodyWidth) {X 	    	    SetColors   (w, segmentInfoP->vSegment.coloridx, lineInfoP->vLine.background);  l 	    	    XFillRectangle (VtkDisplay (w), VtkWindow (w), w->normgc, chunkX, chunkY, segmentInfoP->bodyWidth, 			chunkHeight);( 		    chunkX += segmentInfoP->bodyWidth; 		}s   	    chunkY += chunkHeight;* 	}     }        chunkY = bodyY;      segment = 0;h     while ((segmentCnt = GetChunkGeometry (lineInfoP, segment, &chunkWidth, &maxAscent, &maxDescent))) {k         GetChunkLayout (bodyX, lineInfoP->bodyWidth, maxAscent, maxDescent, chunkWidth, vFieldP->alignment,tP 	    &chunkX, &chunkHeight, &leftMarginWidth, &rightMarginX, &rightMarginWidth);  t 	for (segmentInfoP = SegmentToSegmentInfo (lineInfoP, segment); segmentCnt; segmentInfoP++, segment++, segmentCnt--)# 	    if (segmentInfoP->bodyWidth) {lW 	        SetColors   (w, segmentInfoP->vSegment.coloridx, lineInfoP->vLine.background);l@ 	        SetStippled (w, segmentInfoP->vSegment.stippled, x, y);  < 		if (segmentInfoP->vSegment.type == VListSegmentTypeText) {9 	            SetFont (w, segmentInfoP->vSegment.fontidx);ns 	            XDrawString (VtkDisplay (w), VtkWindow (w), (flip ? w->invgc : w->normgc), chunkX, chunkY + maxAscent,Lk 		        lineInfoP->vLine.textP + segmentInfoP->vSegment.textPosition, segmentInfoP->vSegment.textStrlen);u
 		} else {( 		    if (segmentInfoP->vSegment.icon) {? 		        XSetGraphicsExposures (VtkDisplay (w), w->normgc, 0);la 		        XCopyArea (VtkDisplay (w), segmentInfoP->vSegment.icon, VtkWindow (w), w->normgc, 0, 0,FJ 			    segmentInfoP->bodyWidth, segmentInfoP->bodyHeight, chunkX, chunkY);? 		        XSetGraphicsExposures (VtkDisplay (w), w->normgc, 1);- 		    }, 		}P$ 		chunkX += segmentInfoP->bodyWidth; 	    }   	chunkY += chunkHeight;o     }( }g pM static void DrawIcon(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP, : 	int x, int y, int width, int height, int flip, int clear) {m     int bodyX, bodyY;-  J     SetColors (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);  t     if (clear || (w->currentBackground != w->core.background_pixel) || (w->gridStyle != VListGridStyleBackground)) { 	SetStippled (w, 0, 0, 0);O 	XFillRectangle (VtkDisplay (w), VtkWindow (w), w->invgc, x, y, width, height);>     }V  5     SetStippled (w, lineInfoP->vLine.stippled, x, y);   ]     if (flip) XFillRectangle (VtkDisplay (w), VtkWindow (w), w->normgc, x, y, width, height);         if (lineInfoP->vLine.icon) {d 	bodyX = ComputeBodyX (x, width,  lineInfoP->bodyWidth,  vFieldP->marginWidth,  vFieldP->alignment);d 	bodyY = ComputeBodyY (y, height, lineInfoP->bodyHeight, vFieldP->marginHeight, vFieldP->alignment);  =         XSetGraphicsExposures (VtkDisplay (w), w->normgc, 0);sR 	XCopyArea (VtkDisplay (w), lineInfoP->vLine.icon, VtkWindow (w), w->normgc, 0, 0,@ 	    lineInfoP->bodyWidth, lineInfoP->bodyHeight, bodyX, bodyY);=         XSetGraphicsExposures (VtkDisplay (w), w->normgc, 1);    	if (lineInfoP->vLine.stippled)ly 	    XFillRectangle (VtkDisplay (w), VtkWindow (w), w->invgc, bodyX, bodyY, lineInfoP->bodyWidth, lineInfoP->bodyHeight);t     }y }) -I static void Draw(VListWidget w, int line, int clear, int checkVisibility)t {l     VListField *vFieldP;3     LineInfo *lineInfoP = LineToLineInfo (w, line);y     LineInfo *firstLineInfoP;l(     int column, tier, x, y, flip, field;     int width, height;       lineInfoP->expose = 0;  "     if (!w->visible)       return;"     if (!w->layoutIsValid) return;  /     LineToColumnTier (w, line, &column, &tier); @     ColumnTierToCell (w, column, tier, &x, &y, &width, &height);  M     if (checkVisibility && (!CellIsVisible (w, x, y, width, height))) return;,  $     field   = LineToField (w, line);'     vFieldP = FieldToVField (w, field);i  N     if (w->selectUnit == VListSelectUnitField) flip = lineInfoP->vLine.select;
     else {H 	firstLineInfoP = LineToLineInfo (w, LineToFirstLineInRecord (w, line));% 	flip = firstLineInfoP->vLine.select;h     }   $     switch (lineInfoP->vLine.type) {d 	case VListLineTypeHist : DrawHist (w, lineInfoP, vFieldP, x, y, width, height, flip, clear);	break;d 	case VListLineTypeText : DrawText (w, lineInfoP, vFieldP, x, y, width, height, flip, clear);	break;d 	case VListLineTypeIcon : DrawIcon (w, lineInfoP, vFieldP, x, y, width, height, flip, clear);	break;     }b }g n} static void FillMargins(VListWidget w, GC gc, int x, int y, int width, int height, int bodyX, int bodyY, LineInfo *lineInfoP)o {PO     int leftMarginWidth, rightMarginWidth, topMarginHeight, bottomMarginHeight;i  #     leftMarginWidth    = bodyX - x;i#     topMarginHeight    = bodyY - y;l  J     rightMarginWidth   = width  - lineInfoP->bodyWidth  - leftMarginWidth;J     bottomMarginHeight = height - lineInfoP->bodyHeight - topMarginHeight;  K     if (leftMarginWidth) XFillRectangle (VtkDisplay (w), VtkWindow (w), gc,u  	x, y, leftMarginWidth, height);  L     if (rightMarginWidth) XFillRectangle (VtkDisplay (w), VtkWindow (w), gc,< 	x + width - rightMarginWidth, y, rightMarginWidth, height);  K     if (topMarginHeight) XFillRectangle (VtkDisplay (w), VtkWindow (w), gc,(V 	x + leftMarginWidth, y, width - leftMarginWidth - rightMarginWidth, topMarginHeight);  N     if (bottomMarginHeight) XFillRectangle (VtkDisplay (w), VtkWindow (w), gc,w 	x + leftMarginWidth, y + height - bottomMarginHeight, width - leftMarginWidth - rightMarginWidth, bottomMarginHeight);i }  ur static void FlipHist(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP, int x, int y, int width, int height) {l5     SetStippled (w, lineInfoP->vLine.stippled, x, y);tL     SetColors   (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);S     XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, x, y, width, height);m }s  r static void FlipText(VListWidget w, LineInfo *lineInfoP, VListField *vFieldP, int x, int y, int width, int height) {)_     int bodyX, bodyY, segment, segmentCnt, maxAscent, maxDescent, chunkX, chunkY, rightMarginX;tC     int chunkWidth, chunkHeight, leftMarginWidth, rightMarginWidth;A     SegmentInfo *segmentInfoP;  5     SetStippled (w, lineInfoP->vLine.stippled, x, y);wL     SetColors   (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);  )     if (!lineInfoP->vLine.segmentCount) {tW         XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, x, y, width, height);n 	return;     }n       /* Multi-segment */u  g     bodyX = ComputeBodyX (x, width,  lineInfoP->bodyWidth,  vFieldP->marginWidth,  vFieldP->alignment);lg     bodyY = ComputeBodyY (y, height, lineInfoP->bodyHeight, vFieldP->marginHeight, vFieldP->alignment);o  M     FillMargins (w, w->flipgc, x, y, width, height, bodyX, bodyY, lineInfoP);Y       chunkY = bodyY;i     segment = 0;h     while ((segmentCnt = GetChunkGeometry (lineInfoP, segment, &chunkWidth, &maxAscent, &maxDescent))) {d 	GetChunkLayout (bodyX, lineInfoP->bodyWidth, maxAscent, maxDescent, chunkWidth, vFieldP->alignment,P 	    &chunkX, &chunkHeight, &leftMarginWidth, &rightMarginX, &rightMarginWidth);   	if (chunkHeight) {n 	    if (leftMarginWidth) {aH 		SetColors (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);q 		XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, bodyX,        chunkY, leftMarginWidth,  chunkHeight);s 	    }   	    if (rightMarginWidth) {O 	        SetColors (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);hq 		XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, rightMarginX, chunkY, rightMarginWidth, chunkHeight);> 	    } 	}  t 	for (segmentInfoP = SegmentToSegmentInfo (lineInfoP, segment); segmentCnt; segmentInfoP++, segment++, segmentCnt--)# 	    if (segmentInfoP->bodyWidth) {=P 		SetColors   (w, segmentInfoP->vSegment.coloridx, lineInfoP->vLine.background);r 		XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, chunkX, chunkY, segmentInfoP->bodyWidth, chunkHeight);$ 		chunkX += segmentInfoP->bodyWidth; 	    }   	chunkY += chunkHeight;      }t }a  s static void FlipIcon (VListWidget w, LineInfo *lineInfoP, VListField *vFieldP, int x, int y, int width, int height)  {g     int bodyX, bodyY;   5     SetStippled (w, lineInfoP->vLine.stippled, x, y);qJ     SetColors (w, lineInfoP->vLine.coloridx, lineInfoP->vLine.background);  !     if (!lineInfoP->vLine.icon) {rP 	XFillRectangle (VtkDisplay (w), VtkWindow (w), w->flipgc, x, y, width, height); 	return;     }w  g     bodyX = ComputeBodyX (x, width,  lineInfoP->bodyWidth,  vFieldP->marginWidth,  vFieldP->alignment);ig     bodyY = ComputeBodyY (y, height, lineInfoP->bodyHeight, vFieldP->marginHeight, vFieldP->alignment);)  M     FillMargins (w, w->flipgc, x, y, width, height, bodyX, bodyY, lineInfoP);- }> e) static void Flip(VListWidget w, int line)o {t"     int column, tier, x, y, field;     int width, height;     LineInfo *lineInfoP;     VListField *vFieldP;  "     if (!w->visible)       return;"     if (!w->layoutIsValid) return;  /     LineToColumnTier (w, line, &column, &tier);|@     ColumnTierToCell (w, column, tier, &x, &y, &width, &height);  8     if (!CellIsVisible (w, x, y, width, height)) return;  Q     if (w->scrollIsActive || w->activeGropCnt) {	/* if we're busy scrolling... */e? 	Draw (w, line, 1, 1);				/* previous contents are undefined */	 	return;     }o  *     lineInfoP  = LineToLineInfo (w, line);'     field      = LineToField (w, line);P*     vFieldP    = FieldToVField (w, field);  $     switch (lineInfoP->vLine.type) {W 	case VListLineTypeHist : FlipHist (w, lineInfoP, vFieldP, x, y, width, height);	break;aW 	case VListLineTypeText : FlipText (w, lineInfoP, vFieldP, x, y, width, height);	break;XW 	case VListLineTypeIcon : FlipIcon (w, lineInfoP, vFieldP, x, y, width, height);	break;j     }a }d t? static int AddCellHeightContribution(VListWidget w, int height)l { !     if (height > w->cellHeight) {; 	w->cellHeight = height; 	w->cellHeightCnt = 1; 	return (1);     }   4     if (height == w->cellHeight) w->cellHeightCnt++;       return (0);  }s  B static int RemoveCellHeightContribution(VListWidget w, int height) { F     if (w->fieldResizePolicy == VListResizePolicyGrowOnly) return (0);  +     if (height < w->cellHeight) return (0);l*     if (!(--w->cellHeightCnt)) return (1);     return (0);0 }   T static int ChangeCellHeightContribution(VListWidget w, int oldHeight, int newHeight) {e+     if (oldHeight == newHeight) return (0);o  =     if (newHeight > w->cellHeight) {					/* new max height */ 9 	w->cellHeight = newHeight;					/* save new max height */c8 	w->cellHeightCnt = 1;						/* single reference count */& 	return (1);							/* change needed */     }t  J     if (newHeight == w->cellHeight) {					/* same as current max height */9 	w->cellHeightCnt++;						/* increment reference count */a) 	return (0);							/* no change needed */o     }n  F     if (w->fieldResizePolicy == VListResizePolicyGrowOnly) return (0);  U     if (oldHeight < w->cellHeight) return (0);				/* was smaller, is still smaller */ c     if (!(--w->cellHeightCnt)) return (1);				/* was equal, decrement ref count, zap if last one */g8     return (0);								/* was equal but others remain */ }   ; static void ComputeCellHeight(VListWidget w, int minHeight)s {n     int field, line;     LineInfo *lineInfoP;     VListField *vFieldP;  )     w->cellHeight = w->cellHeightCnt = 0;g  G     AddCellHeightContribution (w, minHeight);		/* at least this high */sT     AddCellHeightContribution (w, w->rowHeight);	/* user-specified minimum height */  &     FOR_EACH_FIELD (w, field, vFieldP)9 	FOR_EACH_LINE_L (w, line, lineInfoP, field, w->fieldCnt)>V 	    AddCellHeightContribution (w, lineInfoP->bodyHeight + 2 * vFieldP->marginHeight);  8     w->tierHeight = w->cellHeight + w->rowSpacingHeight; }h e` static int AddColumnWidthContribution(VListWidget w, int column, int width, VListField *vFieldP) {o=     ColumnInfo *columnInfoP = ColumnToColumnInfo (w, column);c  %     if (width > columnInfoP->width) {S 	columnInfoP->width = width; 	columnInfoP->widthCnt = 1;- 	return (1);     }D  =     if (width == columnInfoP->width) columnInfoP->widthCnt++;        return (0);( }w  c static int RemoveColumnWidthContribution(VListWidget w, int column, int width, VListField *vFieldP)	 {	     ColumnInfo *columnInfoP;  G     if (vFieldP->resizePolicy == VListResizePolicyGrowOnly) return (0);r  1     columnInfoP = ColumnToColumnInfo (w, column);d  /     if (width < columnInfoP->width) return (0);	/     if (!(--columnInfoP->widthCnt)) return (1);w     return (0);l }X  t static int ChangeColumnWidthContribution(VListWidget w, int column, int oldWidth, int newWidth, VListField *vFieldP) {	     ColumnInfo *columnInfoP;  )     if (oldWidth == newWidth) return (0);i  1     columnInfoP = ColumnToColumnInfo (w, column);n  ?     if (newWidth > columnInfoP->width) {				/* new max width */ < 	columnInfoP->width = newWidth;					/* save new max width */< 	columnInfoP->widthCnt = 1;					/* single reference count */- 	return (1);							/* column change needed */l     }i  L     if (newWidth == columnInfoP->width) {				/* same as current max width */= 	columnInfoP->widthCnt++;					/* increment reference count */e0 	return (0);							/* no column change needed */     }   G     if (vFieldP->resizePolicy == VListResizePolicyGrowOnly) return (0);(  X     if (oldWidth < columnInfoP->width) return (0);			/* was smaller, is still smaller */h     if (!(--columnInfoP->widthCnt)) return (1);				/* was equal, decrement ref count, zap if last one */8     return (0);								/* was equal but others remain */ }m  9 static void ComputeColumnWidth(VListWidget w, int column)x {u     int group, field, label;     int line, lastLine;r=     ColumnInfo *columnInfoP = ColumnToColumnInfo (w, column);>     LineInfo *lineInfoP;     LabelInfo *labelInfoP;     VListLabel *vLabelP;     VListField *vFieldP;  (     group   = ColumnToGroup (w, column);4     field   = ColumnGroupToField (w, column, group);'     vFieldP = FieldToVField (w, field);>  3     columnInfoP->width = columnInfoP->widthCnt = 0;T  D     AddColumnWidthContribution (w, column, vFieldP->width, vFieldP);     :     GroupFieldToLines (w, group, field, &line, &lastLine);o     for (lineInfoP = LineToLineInfo (w, line); line <= lastLine; line += w->fieldCnt, lineInfoP += w->fieldCnt)(b 	AddColumnWidthContribution (w, column, lineInfoP->bodyWidth + 2 * vFieldP->marginWidth, vFieldP);  w     FOR_EACH_LABEL (w, label, labelInfoP, vLabelP) if ((vLabelP->firstField <= field) && (vLabelP->lastField >= field)) M 	AddColumnWidthContribution (w, column, labelInfoP->widthPerColumn, vFieldP);  }    #define TryLayoutCheckNone		0r" #define TryLayoutCheckAllVisible	1" #define TryLayoutCheckTwoVisible	2  E static int TryLayout(VListWidget w, int check, int width, int height), {F(     int column, x, group, field, adjust;)     int minHeight, padWidth, extraHeight;I2     ColumnInfo *columnInfoP, *previousColumnInfoP;     VListField *vFieldP;  c     if (height < (minHeight = (2 * w->marginHeight + w->tierHeight))) w->logicalHeight = minHeight;d0     else 							      w->logicalHeight = height;  J     w->tierCnt = (w->logicalHeight - 2 * w->marginHeight) / w->tierHeight;  $     if (!w->rowCnt) w->groupCnt = 1;=     else 	    w->groupCnt = (w->rowCnt - 1) / w->tierCnt + 1;v  -     w->columnCnt = w->groupCnt * w->fieldCnt;al     w->columnInfosP = (ColumnInfo *)XtRealloc ((char *)w->columnInfosP, w->columnCnt * sizeof (ColumnInfo));  ?     if (w->groupCnt == 1) w->topMarginHeight = w->marginHeight;>p     else 		  w->topMarginHeight = (w->logicalHeight - w->tierCnt * w->tierHeight + w->rowSpacingHeight + 1) / 2;       x = w->marginWidth;n  o     for (column = 0, columnInfoP = ColumnToColumnInfo (w, 0); column < w->columnCnt; column++, columnInfoP++) {r,         group   = ColumnToGroup (w, column);1 	field   = ColumnGroupToField (w, column, group); $ 	vFieldP = FieldToVField (w, field);   	columnInfoP->x = x;  	ComputeColumnWidth (w, column); 	x += columnInfoP->width;D  @ 	if (field != (w->fieldCnt - 1))      x += w->fieldSpacingWidth;@ 	else if (group != (w->groupCnt - 1)) x += (2 * w->marginWidth);  ) 	if (check == TryLayoutCheckAllVisible) {i2 	    if ((x + w->marginWidth) > width) return (0);0 	} else if (check == TryLayoutCheckTwoVisible) {1 	    if ((field == (w->fieldCnt - 1)) && group) {gV 	        previousColumnInfoP = ColumnToColumnInfo (w, (column - w->fieldCnt * 2 + 1));L 		if ((x - previousColumnInfoP->x + 2 * w->marginWidth) > width) return (0); 	    } 	}     }n  )     w->logicalWidth = x + w->marginWidth;f  L     if (w->spaceGroupsEqually && w->groupCnt && (w->logicalWidth < width)) {4 	padWidth = (width - w->logicalWidth) / w->groupCnt; 	adjust = padWidth / 2;n   	FOR_EACH_GROUP (w, group) {) 	    FOR_EACH_FIELD (w, field, vFieldP) {nT 	        columnInfoP = ColumnToColumnInfo (w, GroupFieldToColumn (w, group, field)); 		columnInfoP->x += adjust;h 	    }   	    adjust += padWidth; 	}     }c  ?     if (w->spaceTiersEqually && (w->groupCnt == 1) && w->rowCnt r       && ((extraHeight = height - (w->rowCnt * w->tierHeight + 2 * w->marginHeight - w->rowSpacingHeight)) > 0)) {, 	w->cellHeight += (extraHeight / w->rowCnt);5 	w->tierHeight = w->cellHeight + w->rowSpacingHeight;e     }v       return (1);  }   ) static void DoColumnLayout(VListWidget w)p {d     int width, height;$     Widget parentW = w->core.parent;        width = parentW->core.width;|     if (w->vScrollPolicy == VListScrollBarPolicyAlways) width -= (w->vScrollW->core.width + w->vScrollW->core.border_width);  f     if ((w->columnStyle == VListColumnStyleMultiple) || (w->columnStyle == VListColumnStyleBestFit)) { 	height = parentW->core.height;	I 	if (w->headerHeight) height -= (w->headerHeight + w->core.border_width);x  5 	if (w->hScrollPolicy == VListScrollBarPolicyNever) {A6 	    TryLayout (w, TryLayoutCheckNone, width, height); 	    return; 	}  z 	if (w->hScrollPolicy == VListScrollBarPolicyAsNeeded) if (TryLayout (w, TryLayoutCheckAllVisible, width, height)) return;  G 	height -= (w->hScrollW->core.height + w->hScrollW->core.border_width);t  2 	if (w->columnStyle == VListColumnStyleMultiple) {=             TryLayout (w, TryLayoutCheckNone, width, height);t 	    return;	         }   D 	if (TryLayout (w, TryLayoutCheckTwoVisible, width, height)) return;     }   M     if ((!w->allowDeadspace) || (w->columnStyle != VListColumnStyleSingle)) { : 	height = w->rowCnt * w->tierHeight + 2 * w->marginHeight;     } else {A 	height = (w->rowCnt - 1) * w->tierHeight + parentW->core.height;;I 	if (w->headerHeight) height -= (w->headerHeight + w->core.border_width);i{ 	if (w->hScrollPolicy == VListScrollBarPolicyAlways) height -= (w->hScrollW->core.height + w->hScrollW->core.border_width);W     }w  5     TryLayout (w, TryLayoutCheckNone, width, height);- }i iw static void ApplyLayoutPolicy(VListWidget w, int *xP, int *yP, int *widthP, int *heightP, int *hScrollP, int *vScrollP)m {e4     int x, y, width, height, hScroll, vScroll, temp;  "     hScroll = vScroll = x = y = 0;(     width  = w->core.parent->core.width;)     height = w->core.parent->core.height;)       if (w->headerHeight) {/ 	temp = w->headerHeight + w->core.border_width;i 	y += temp;P' 	if ((height -= temp) <= 0) height = 1;t     }s  8     if ((w->hScrollPolicy == VListScrollBarPolicyAlways)]       || ((w->hScrollPolicy == VListScrollBarPolicyAsNeeded) && (w->logicalWidth > width))) { B 	temp = w->hScrollW->core.height + w->hScrollW->core.border_width;' 	if ((height -= temp) <= 0) height = 1; 
 	hScroll = 1;k     }i  8     if ((w->vScrollPolicy == VListScrollBarPolicyAlways)_       || ((w->vScrollPolicy == VListScrollBarPolicyAsNeeded) && (w->logicalHeight > height))) {iA 	temp = w->vScrollW->core.width + w->vScrollW->core.border_width;fA 	if (w->vScrollPosition == VListScrollBarPositionLeft) x += temp; % 	if ((width -= temp) <= 0) width = 1; 
 	vScroll = 1;o  e 	if ((!hScroll) && (w->hScrollPolicy == VListScrollBarPolicyAsNeeded) && (w->logicalWidth > width)) {(F 	    temp = w->hScrollW->core.height + w->hScrollW->core.border_width;+ 	    if ((height -= temp) <= 0) height = 1;  	    hScroll = 1;U 	}     }t       *hScrollP 	= hScroll;n     *vScrollP 	= vScroll;e
     *xP 	= x;n
     *yP 	= y;e     *widthP 	= width;e     *heightP 	= height;i }  s) static void ArrangeWidgets(VListWidget w)w {h'     int x, y, needHScroll, needVScroll;n     int newX, newY;(     int width, height;"     Widget vHeaderW = w->vHeaderW;"     Widget hScrollW = w->hScrollW;"     Widget vScrollW = w->vScrollW;  O     ApplyLayoutPolicy (w, &x, &y, &width, &height, &needHScroll, &needVScroll);P  ]     if ((!w->headerHeight) && vHeaderW && XtIsManaged (vHeaderW)) XtUnmanageChild (vHeaderW);s]     if ((!needHScroll)     && hScrollW && XtIsManaged (hScrollW)) XtUnmanageChild (hScrollW);P]     if ((!needVScroll)     && vScrollW && XtIsManaged (vScrollW)) XtUnmanageChild (vScrollW);   $     newX = x - w->core.border_width;$     newY = y - w->core.border_width;  m     if ((w->core.x != newX) || (w->core.y != newY) || (w->core.width != width) || (w->core.height != height))o 	XtVaSetValues ((Widget)w, 	    XtNx,      newX,g 	    XtNy,      newY,  	    XtNwidth,  width, 	    XtNheight, height,M 	    0);       if (w->headerHeight) {( 	newX = x - vHeaderW->core.border_width;' 	newY = (-vHeaderW->core.border_width);g  D         if ((vHeaderW->core.x != newX) || (vHeaderW->core.y != newY)X     	  || (vHeaderW->core.width != width) || (vHeaderW->core.height != w->headerHeight)) 	    XtVaSetValues (vHeaderW,a 	        XtNx,      newX,t 	        XtNy,      newY,g 	        XtNwidth,  width,$ 	        XtNheight, w->headerHeight, 		0);-  7 	if (!XtIsManaged (vHeaderW)) XtManageChild (vHeaderW);i     }t       if (needHScroll) {& 	int logicalWidth   = w->logicalWidth;* 	int scrollBarValue = w->requestedXAdjust;  7 	if (logicalWidth < width) 		     logicalWidth = width;iT 	if ((scrollBarValue + width) > logicalWidth) scrollBarValue = logicalWidth - width;3 	if (scrollBarValue < 0) 		     scrollBarValue = 0;l  E 	/* Do separate XtSetValues to get around a scroll bar widget bug. */i  ( 	newX = x - hScrollW->core.border_width; 	newY = y + height;P  ! 	w->ignoreScrollValueChanged = 1;)  > 	if ((hScrollW->core.x != newX) || (hScrollW->core.y != newY)) 	    XtVaSetValues (hScrollW,i 	        XtNx, newX, 	        XtNy, newY, 	        0);       	XtVaSetValues (hScrollW,  	    XtNwidth,     	width, 	    XmNsliderSize,    	width, 	    XmNmaximum, 	logicalWidth, " 	    XmNvalue,    	scrollBarValue,! 	    XmNincrement, 	w->charWidth,n 	    0);  ( 	w->shownScrollXAdjust = scrollBarValue;  ! 	w->ignoreScrollValueChanged = 0;l  7 	if (!XtIsManaged (hScrollW)) XtManageChild (hScrollW);l     }e       if (needVScroll) {.         int logicalHeight  = w->logicalHeight;* 	int scrollBarValue = w->requestedYAdjust;  = 	if (logicalHeight < height) 		       logicalHeight = height;-X 	if ((scrollBarValue + height) > logicalHeight) scrollBarValue = logicalHeight - height;5 	if (scrollBarValue < 0) 		       scrollBarValue = 0;   B 	if (w->vScrollPosition == VListScrollBarPositionRight) x = width;6 	else 						       x = (-vScrollW->core.border_width);  E 	/* Do separate XtSetValues to get around a scroll bar widget bug. */t  ( 	newY = y - vScrollW->core.border_width;  ! 	w->ignoreScrollValueChanged = 1;n  B         if ((vScrollW->core.x != x) || (vScrollW->core.y != newY)) 	    XtVaSetValues (vScrollW,o 	        XtNx, 	x, 	        XtNy, 	newY,u 		0);	   	XtVaSetValues (vScrollW,) 	    XtNheight,    	height,o 	    XmNsliderSize,    	height,t  	    XmNmaximum, 	logicalHeight," 	    XmNvalue,    	scrollBarValue," 	    XmNincrement, 	w->tierHeight, 	    0);  ( 	w->shownScrollYAdjust = scrollBarValue;  ! 	w->ignoreScrollValueChanged = 0;p  7 	if (!XtIsManaged (vScrollW)) XtManageChild (vScrollW);      }  }  fA void VListMakeLineVisible(Widget ow, Opaque closure, int visible)n {t$     VListWidget w = (VListWidget)ow;E     int line, firstVY, lastVYP1, yAdjust, firstVX, lastVXP1, xAdjust;f     int column, tier, x, y;f     int width, height;  9     if ((!w->layoutIsValid) || w->deferMakeLineVisible) {h 	w->visibleClosure = closure;y 	w->visiblePosition = visible; 	return;     }o  <     if ((line = ClosureToLine (w, closure)) == (-1)) return;  /     LineToColumnTier (w, line, &column, &tier);P@     ColumnTierToCell (w, column, tier, &x, &y, &width, &height);  8     firstVX  = x + w->requestedXAdjust - w->marginWidth;@     lastVXP1 = x + w->requestedXAdjust + width + w->marginWidth;  9     firstVY  = y + w->requestedYAdjust - w->marginHeight;cB     lastVYP1 = y + w->requestedYAdjust + height + w->marginHeight;  !     xAdjust = w->internalXAdjust;w!     yAdjust = w->internalYAdjust;d       switch (visible) {!       case VListVisibleAtRight		:l#       case VListVisibleAtTopRight	:(R       case VListVisibleAtBottomRight	: xAdjust = lastVXP1 - w->core.width;		break;          case VListVisibleAtLeft		:"       case VListVisibleAtTopLeft	:B       case VListVisibleAtBottomLeft	: xAdjust = firstVX;				break;     }n       switch (visible) {"       case VListVisibleAtBottom		:%       case VListVisibleAtBottomLeft	: S       case VListVisibleAtBottomRight	: yAdjust = lastVYP1 - w->core.height;		break;u         case VListVisibleAtTop		: "       case VListVisibleAtTopLeft	:@       case VListVisibleAtTopRight	: yAdjust = firstVY;				break;     }e    *     if (visible == VListVisibleInWindow) {Q 	if (lastVXP1 > (xAdjust + w->core.width))    xAdjust = lastVXP1 - w->core.width;pR 	if (lastVYP1 > (yAdjust + w->core.height))   yAdjust = lastVYP1 - w->core.height;  9         if (firstVX < xAdjust) 			     xAdjust = firstVX; 9         if (firstVY < yAdjust) 			     yAdjust = firstVY;n     }i  .     SetInternalXYAdjust (w, xAdjust, yAdjust);     StartPendingScroll (w);d }  gn static void ScrollButtonPressHandler(Widget scrollW, XtPointer ow, XEvent *eventOP, Boolean *unused_continueP) {L$     VListWidget w = (VListWidget)ow;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;t  #     if ((eventP->button != Button1)Vi       || (eventP->state & (Button1Mask | Button2Mask | Button3Mask | Button4Mask | Button5Mask))) return;t        w->deferMakeLineVisible = 1; }f  p static void ScrollButtonReleaseHandler(Widget scrollW, XtPointer ow, XEvent *eventOP, Boolean *unused_continueP) {W$     VListWidget w = (VListWidget)ow;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;   )     if (!w->deferMakeLineVisible) return;n        w->deferMakeLineVisible = 0;       if (w->visibleClosure) {I 	VListMakeLineVisible ((Widget)w, w->visibleClosure, w->visiblePosition);t 	w->visibleClosure = 0;      }H }h =( static void ComputeLayout(VListWidget w) {      ComputeCellHeight (w, 1);a     DoColumnLayout (w);g     ArrangeWidgets (w);v     SetHeaderLabels (w);D     SetInternalXYAdjust (w, w->internalXAdjust, w->internalYAdjust);     SetPosition (w);     w->layoutIsValid = 1;h }=  ! static void Redraw(VListWidget w)e {m     SetPosition (w);       if (!w->visible) return;  4     w->redrawSerial = XNextRequest (VtkDisplay (w));  W     XClearArea (VtkDisplay (w), VtkWindow (w), 0, 0, w->core.width, w->core.height, 1);  }   # void VListEndBatchUpdate(Widget ow)0 {	$     VListWidget w = (VListWidget)ow;  7     if (--w->batchUpdate) return;	/* still batching? */l6     if (!VtkIsRealized (w)) return;	/* not real yet */  -     if (!w->layoutIsValid) ComputeLayout (w);        if (w->visibleClosure) {I 	VListMakeLineVisible ((Widget)w, w->visibleClosure, w->visiblePosition);e 	w->visibleClosure = 0;F     }        Redraw (w);  }-  % void VListStartBatchUpdate(Widget ow)C {r$     VListWidget w = (VListWidget)ow;       w->batchUpdate++;H@     w->scrollIsActive = w->activeGropCnt = w->layoutIsValid = 0; }   + static void StartUpdateSweep(VListWidget w)F {E4     XEvent event;			/* allocate full event buffer */  7     if ((!VtkIsRealized (w)) || w->batchUpdate) return;2  &     VListStartBatchUpdate ((Widget)w);  +     event.xclient.type 	  	= ClientMessage;h,     event.xclient.display 	= VtkDisplay (w);*     event.xclient.window 	= VtkWindow (w);F     event.xclient.message_type 	= 0;			/*** should be an atom (sjk) */     event.xclient.format 	= 32;n  =     XSendEvent (VtkDisplay (w), VtkWindow (w), 0, 0, &event);t }t  T static void ResizeCallback(Widget unused_pW, XtPointer ow, XtPointer unused_cbDataP) {+$     VListWidget w = (VListWidget)ow;       StartUpdateSweep (w);i }V t+ static void DrawExposedLines(VListWidget w)v {lI     int column, tier, line, firstColumn, lastColumn, firstTier, lastTier;V     LineInfo *lineInfoP;  6     if (!w->anyAreExposed) return;	/* nothing to do */"     if (w->scrollIsActive) return;"     if (w->activeGropCnt)  return;       w->anyAreExposed = 0;u  ?     /* Loop through visible lines, redrawing requested ones. */i  f     if (!RectangleToLines (w, w->requestedXAdjust, w->requestedYAdjust, w->core.width, w->core.height,@       &firstColumn, &lastColumn, &firstTier, &lastTier)) return;  >     for (column = firstColumn; column <= lastColumn; column++)8         for (tier = firstTier; tier <= lastTier; tier++)? 	    if ((line = ColumnTierToLine (w, column, tier)) != (-1)) {>' 		lineInfoP = LineToLineInfo (w, line);n2     		if (lineInfoP->expose) Draw (w, line, 0, 0);
     	    } }   R static void SaveExposeRegion(VListWidget w, int vX, int vY, int width, int height) {iI     int firstColumn, lastColumn, firstTier, lastTier, column, tier, line;l     LineInfo *lineInfoP;  "     if (!w->layoutIsValid) return;  o     if (!RectangleToLines (w, vX, vY, width, height, &firstColumn, &lastColumn, &firstTier, &lastTier)) return;   >     for (column = firstColumn; column <= lastColumn; column++)8         for (tier = firstTier; tier <= lastTier; tier++)C     	    if ((line = ColumnTierToLine (w, column, tier)) != (-1)) {c. 	        lineInfoP = LineToLineInfo (w, line); 	        lineInfoP->expose = 1;a 	    }       w->anyAreExposed = 1;o }n  R static void DrawExposeRegion(VListWidget w, int vX, int vY, int width, int height) {II     int firstColumn, lastColumn, firstTier, lastTier, column, tier, line;   o     if (!RectangleToLines (w, vX, vY, width, height, &firstColumn, &lastColumn, &firstTier, &lastTier)) return;i  >     for (column = firstColumn; column <= lastColumn; column++)8         for (tier = firstTier; tier <= lastTier; tier++)W     	    if ((line = ColumnTierToLine (w, column, tier)) != (-1)) Draw (w, line, 0, 0);  }o lF static void DoExpose(Widget ow, XEvent *eventOP, Region unused_region) { $     VListWidget w = (VListWidget)ow;3     XExposeEvent *eventP = (XExposeEvent *)eventOP;2       w->visible = 1;,  1     if (eventP->serial < w->redrawSerial) return;P  "     if (!w->layoutIsValid) return;  .     XClearArea (VtkDisplay (w), VtkWindow (w),6 	eventP->x + w->externalXAdjust - w->requestedXAdjust,6 	eventP->y + w->externalYAdjust - w->requestedYAdjust,# 	eventP->width, eventP->height, 0);   9     eventP->y      -= (w->tierHeight * w->activeGropCnt);i=     eventP->height += (w->tierHeight * w->activeGropCnt * 2);u  x     SaveExposeRegion (w, eventP->x + w->externalXAdjust, eventP->y + w->externalYAdjust, eventP->width, eventP->height);  B     if (eventP->count) return;	/* more expose events are coming */       DrawExposedLines (w);  }l  r static void HandleNonmaskableEvent(Widget ow, XtPointer unused_closure, XEvent *eventP, Boolean *unused_continueP) {w$     VListWidget w = (VListWidget)ow;!     int type = eventP->xany.type; 1     int gropIsComplete = 0, scrollIsComplete = 0;e  <     if (type == ClientMessage) {	/* update sweep complete *//         /*** should check message type (sjk) */r! 	VListEndBatchUpdate ((Widget)w);s 	return;     })  "     if (!w->layoutIsValid) return;  !     if (type == GraphicsExpose) { F 	eventP->xgraphicsexpose.y      -= (w->activeGropCnt * w->tierHeight);J 	eventP->xgraphicsexpose.height += (w->activeGropCnt * w->tierHeight * 2);   	SaveExposeRegion (w,=5 	    eventP->xgraphicsexpose.x + w->requestedXAdjust,m5 	    eventP->xgraphicsexpose.y + w->requestedYAdjust, # 	    eventP->xgraphicsexpose.width,o% 	    eventP->xgraphicsexpose.height);F  l         if (eventP->xgraphicsexpose.count) return;		/* don't get too excited yet - there are more to come */     }f  4     /* Handle completion of a graphics operation. */       if (type == NoExpose)ol         if (w->scrollIsActive && (eventP->xnoexpose.serial       >= w->scrollSerial)) 	scrollIsComplete = 1;+         else										gropIsComplete   = 1; $     else if (type == GraphicsExpose)k         if (w->scrollIsActive && (eventP->xgraphicsexpose.serial >= w->scrollSerial))	scrollIsComplete = 1; +         else										gropIsComplete   = 1;l       if (scrollIsComplete) {h         w->scrollIsActive = 0;* 	w->externalXAdjust = w->requestedXAdjust;* 	w->externalYAdjust = w->requestedYAdjust;   	DrawExposedLines (w);   	StartPendingScroll (w);4     } else if (gropIsComplete && w->activeGropCnt) { 	w->activeGropCnt--; 	DrawExposedLines (w);     }  }  RP static void SelectLine(VListWidget w, int line, int select, LineInfo *lineInfoP) {u     int otherLine;  2     if (lineInfoP->vLine.select == select) return;2     if (!lineInfoP->vLine.sensitive)       return;  >     if ((lineInfoP->vLine.select = select)) w->selectionCnt++;#     else 				    w->selectionCnt--;w     >     if (w->selectUnit == VListSelectUnitField) Flip (w, line);c     else for (otherLine = line; otherLine < (line + w->fieldCnt); otherLine++) Flip (w, otherLine);  }v  + static void DeselectAllLines(VListWidget w)u {a     int line, increment;  4     if (!w->selectionCnt) return;		/* quick check */  =     if (w->selectUnit == VListSelectUnitField) increment = 1;y,     else 				       increment = w->fieldCnt;  i     for (line = 0; w->selectionCnt; line += increment) SelectLine (w, line, 0, LineToLineInfo (w, line));) }   ) static void SelectAllLines(VListWidget w){ {h     int line, increment;     LineInfo *lineInfoP;  =     if (w->selectUnit == VListSelectUnitField) increment = 1;>G     else                                       increment = w->fieldCnt;o  Z     FOR_EACH_LINE_L (w, line, lineInfoP, 0, increment) SelectLine (w, line, 1, lineInfoP); }N eK static void CallSelectCallbacks(VListWidget w, XEvent *eventP, int confirm)i { %     VListSelectCallbackStruct cbData;l
     int line;_     LineInfo *lineInfoP;%     VListSelectChange *selectChangeP;  	 E     cbData.reason = (confirm ? VListCRSelectConfirm : VListCRSelect);      cbData.event = eventP;  Q     ColumnTierToFieldRow (w, w->upColumn, w->upTier, &cbData.field, &cbData.row);e  H     if ((line = ColumnTierToLine (w, w->upColumn, w->upTier)) != (-1)) {& 	lineInfoP = LineToLineInfo (w, line);! 	cbData.vLine = lineInfoP->vLine;C$     } else cbData.vLine.closure = 0;       if (!confirm) {d, 	cbData.selectChangesP = w->selectChangesP =i 	    (VListSelectChange *)XtRealloc ((char *)w->selectChangesP, w->lineCnt * sizeof (VListSelectChange));+  # 	selectChangeP = w->selectChangesP; % 	FOR_EACH_LINE (w, line, lineInfoP) {o9 	    selectChangeP->closure   = lineInfoP->vLine.closure;(6 	    selectChangeP->oldSelect = lineInfoP->undoSelect;8 	    selectChangeP->newSelect = lineInfoP->vLine.select; 	    selectChangeP++;r 	}%     } else cbData.selectChangesP = 0;      '     cbData.lineCount      = w->lineCnt; ,     cbData.selectionCount = w->selectionCnt;  i     XtCallCallbacks ((Widget)w, (confirm ? VListNselectConfirmCallback : VListNselectCallback), &cbData);e }  0J static void NewSelectColumnTier(VListWidget w, int newColumn, int newTier) {y=     int newLine, mouseLine, field, row, line, fieldIncrement;)C     int downField, downRow, mouseField, mouseRow, newField, newRow;+=     int oldFirstField, oldLastField, oldFirstRow, oldLastRow;e=     int newFirstField, newLastField, newFirstRow, newLastRow;      LineInfo *lineInfoP;  K     if ((newColumn == w->mouseColumn) && (newTier == w->mouseTier)) return;a  Q     if ((w->selectStyle == VListSelectStyleNone) || w->selectionIsLocked) return;d  3     if (w->selectStyle == VListSelectStyleSingle) {LG         mouseLine = ColumnTierToLine (w, w->mouseColumn, w->mouseTier); ; 	newLine   = ColumnTierToLine (w, newColumn,      newTier);y   	if (mouseLine != newLine) {X 	    if (mouseLine != (-1)) SelectLine (w, mouseLine, 0, LineToLineInfo (w, mouseLine));V 	    if (newLine   != (-1)) SelectLine (w, newLine,   1, LineToLineInfo (w, newLine)); 	}     } else {O 	ColumnTierToFieldRow (w, w->downColumn,  w->downTier,  &downField,  &downRow); P 	ColumnTierToFieldRow (w, w->mouseColumn, w->mouseTier, &mouseField, &mouseRow);N 	ColumnTierToFieldRow (w, newColumn,      newTier,      &newField,   &newRow);  ? 	MinMax (downField, mouseField, &oldFirstField, &oldLastField);h= 	MinMax (downRow,   mouseRow,   &oldFirstRow,   &oldLastRow);P? 	MinMax (downField, newField,   &newFirstField, &newLastField); = 	MinMax (downRow,   newRow,     &newFirstRow,   &newLastRow);r  j 	/* Go through the old select range, resetting any lines that are not included in the new select range. */  ? 	if (w->selectUnit == VListSelectUnitField) fieldIncrement = 1;a'     	else fieldIncrement = w->fieldCnt;l  /  	if (oldFirstField == (-1)) oldFirstField = 0;e. 	if (newFirstField == (-1)) newFirstField = 0;  2 	for (row = oldFirstRow; row <= oldLastRow; row++)P 	    for (field = oldFirstField; field <= oldLastField; field += fieldIncrement)g 		if ((field < newFirstField) || (field > newLastField) || (row < newFirstRow) || (row > newLastRow)) {f, 		    line = FieldRowToLine (w, field, row); 		    if (line != (-1)) {-( 			lineInfoP = LineToLineInfo (w, line);< 			SelectLine (w, line, lineInfoP->undragSelect, lineInfoP); 		    }  		}d  h 	/* Go through the new select range, setting any lines that are not included in the old select range. */  2 	for (row = newFirstRow; row <= newLastRow; row++)P 	    for (field = newFirstField; field <= newLastField; field += fieldIncrement)g 		if ((field < oldFirstField) || (field > oldLastField) || (row < oldFirstRow) || (row > oldLastRow)) { , 		    line = FieldRowToLine (w, field, row);X 		    if (line != (-1)) SelectLine (w, line, w->selectParity, LineToLineInfo (w, line)); 		}l     }	       w->mouseColumn = newColumn;=     w->mouseTier   = newTier;r }B a' static void CancelSelect(VListWidget w)/ {o
     int line;V     LineInfo *lineInfoP;  &     w->selectIsActive = w->upTime = 0;  1     VListSetAutoScrollPosition ((Widget)w, 0, 0);>       if (!w->selectionIsLocked)*         FOR_EACH_LINE (w, line, lineInfoP)t 	    if ((lineInfoP->vLine.select != lineInfoP->undoSelect)) SelectLine (w, line, lineInfoP->undoSelect, lineInfoP);  <     SetInternalXYAdjust (w, w->undoXAdjust, w->undoYAdjust);     StartPendingScroll (w);N }i  < static void StartSelect(VListWidget w, XButtonEvent *eventP) {n     int line, field, row;      LineInfo *lineInfoP;       w->selectIsActive = 1;  K     XYToColumnTier (w, eventP->x, eventP->y, &w->downColumn, &w->downTier);        /* If the ButtonPress came soon enough after the last ButtonRelease, and we're still over the same cell, and the widget does_      * have at least one selectConfirm callback declared, then prime the doubleClick action. */h  {     if ((eventP->time <= (w->upTime + w->doubleClickDelay)) && (w->downColumn == w->upColumn) && (w->downTier == w->upTier) Z       && (XtHasCallbacks ((Widget)w, VListNselectConfirmCallback) == XtCallbackHasSome)) { 	w->doubleClickIsPending = 1;/ 	return;     }e        w->doubleClickIsPending = 0;  (     /* Save state for chorded cancel. */  W     FOR_EACH_LINE (w, line, lineInfoP) lineInfoP->undoSelect = lineInfoP->vLine.select;   (     w->undoXAdjust = w->internalXAdjust;(     w->undoYAdjust = w->internalYAdjust;  <     /* If the select style dictates, clear the selection. */  5     if ((w->selectStyle == VListSelectStyleSingle) ||tU       ((w->selectStyle == VListSelectStyleExtend) && (!(eventP->state & ShiftMask))))n1 	if (!w->selectionIsLocked) DeselectAllLines (w);u  b     /* If range select is possible, make a snapshot of the selection state so we can backtrack. */  _     if ((w->selectStyle != VListSelectStyleSingle) && (w->selectStyle != VListSelectStyleNone))n]         FOR_EACH_LINE (w, line, lineInfoP) lineInfoP->undragSelect = lineInfoP->vLine.select;l  L     /* Determine the select parity, and flip the target line's selection. */  N     if ((w->selectStyle != VListSelectStyleNone) && (!w->selectionIsLocked)) {0 	if (w->selectStyle != VListSelectStyleSingle) {I 	    ColumnTierToFieldRow ( w, w->downColumn, w->downTier, &field, &row); + 	    line = FieldRowToLine (w, field, row); @ 	} else line = ColumnTierToLine (w, w->downColumn, w->downTier);  ' 	if (line == (-1)) w->selectParity = 1;w 	else {i* 	    lineInfoP = LineToLineInfo (w, line);5 	    w->selectParity = (1 - lineInfoP->vLine.select);u6 	    SelectLine (w, line, w->selectParity, lineInfoP); 	}     }d  #     w->mouseColumn = w->downColumn; !     w->mouseTier   = w->downTier;  }j  D static void SelectMotionHandler(VListWidget w, XMotionEvent *eventP) {l     int newColumn, newTier;t  (     if (w->doubleClickIsPending) return;  C     XYToColumnTier (w, eventP->x, eventP->y, &newColumn, &newTier);a0     NewSelectColumnTier (w, newColumn, newTier);A     VListSetAutoScrollPosition ((Widget)w, eventP->x, eventP->y);; }	  E static void SelectReleaseHandler(VListWidget w, XButtonEvent *eventP)	 { 
     int x, y;t  6     w->selectIsActive = 0;			/* done with list grab */  1     VListSetAutoScrollPosition ((Widget)w, 0, 0);   w     /* If the select style supports drag select, and we're outside the window, treat the upclick as though it were just;H      * inside the window to prevent unseen lines from being selected. */       x = eventP->x;     y = eventP->y;  S     if ((w->selectStyle != VListSelectStyleSingle) && (!w->doubleClickIsPending)) {s 	if (x < 0) x = 0;4 	else if (x >= w->core.width) x = w->core.width - 1;      	if (y < 0) y = 0;6 	else if (y >= w->core.height) y = w->core.height - 1;     }   7     XYToColumnTier (w, x, y, &w->upColumn, &w->upTier);n  "     if (w->doubleClickIsPending) {6 	w->upTime = 0;			/* don't want tripleClick problem */  T 	/* If the user didn't drag off the entry, then call the SelectConfirm callbacks. */  p 	if ((w->upColumn == w->downColumn) && (w->upTier == w->downTier)) CallSelectCallbacks (w, (XEvent *)eventP, 1);     } else {? 	w->upTime = eventP->time;	/* to test against next Down time */n  1 	NewSelectColumnTier (w, w->upColumn, w->upTier);v. 	CallSelectCallbacks (w, (XEvent *)eventP, 0);     }r }, v? static void CallDragArmCallbacks(VListWidget w, XEvent *eventP)  {i&     VListDragArmCallbackStruct cbData;
     int line;*     LineInfo *lineInfoP; 	e#     cbData.reason = VListCRDragArm;d     cbData.event  = eventP;   U     ColumnTierToFieldRow (w, w->downColumn, w->downTier, &cbData.field, &cbData.row);l  L     if ((line = ColumnTierToLine (w, w->downColumn, w->downTier)) != (-1)) {& 	lineInfoP = LineToLineInfo (w, line);! 	cbData.vLine = lineInfoP->vLine;)$     } else cbData.vLine.closure = 0;  >     /* Copy into VListDragDropCallbackStruct for later use. */  3     w->dragDropCallbackStruct.field = cbData.field;u1     w->dragDropCallbackStruct.row   = cbData.row;t3     w->dragDropCallbackStruct.vLine = cbData.vLine;)  @     XtCallCallbacks ((Widget)w, VListNdragArmCallback, &cbData); }   F static void CallDragDropCallbacks(VListWidget w, XButtonEvent *eventP) {tH     VListDragDropCallbackStruct *cbDataP = (&w->dragDropCallbackStruct);?     Window dragParentWindow = VtkWindow (VtkParent (w->dragW));b     int column, tier, line;e     LineInfo *lineInfoP;1     int dragParentRelativeX, dragParentRelativeY;a     Window dummyChildWindow;     VListWidget dropW;  '     cbDataP->reason 	= VListCRDragDrop;w(     cbDataP->event  	= (XEvent *)eventP;  `     XTranslateCoordinates (eventP->display, RootWindowOfScreen (XtScreen (w)), dragParentWindow,` 	eventP->x_root, eventP->y_root, &dragParentRelativeX, &dragParentRelativeY, &dummyChildWindow);  z     cbDataP->dropWindow = VtkGetSubwindow (eventP->display, dragParentWindow, dragParentRelativeX, dragParentRelativeY, 0,# 	&cbDataP->dropX, &cbDataP->dropY);b  R     cbDataP->dropWidget = XtWindowToWidget (eventP->display, cbDataP->dropWindow);  I     cbDataP->dropVLine.closure = 0;		/* assume target VLine is unknown */v  V     if (cbDataP->dropWidget && XtIsSubclass (cbDataP->dropWidget, vlistwidgetclass)) {* 	dropW = (VListWidget)cbDataP->dropWidget;  '         cbDataP->dropWidgetIsVList = 1;   H 	XYToColumnTier (dropW, cbDataP->dropX, cbDataP->dropY, &column, &tier);T 	ColumnTierToFieldRow (dropW, column, tier, &cbDataP->dropField, &cbDataP->dropRow);  ? 	if ((line = ColumnTierToLine (dropW, column, tier)) != (-1)) {n. 	    lineInfoP = LineToLineInfo (dropW, line);+ 	    cbDataP->dropVLine = lineInfoP->vLine;i' 	} else cbDataP->dropVLine.closure = 0;(  0 	cbDataP->dropVListFieldCount = dropW->fieldCnt;. 	cbDataP->dropVListRowCount   = dropW->rowCnt;*     } else cbDataP->dropWidgetIsVList = 0;  A     XtCallCallbacks ((Widget)w, VListNdragDropCallback, cbDataP);* }   % static void CancelDrag(VListWidget w)t {A     w->dragIsActive = 0;  ?     XUnmapWindow (VtkDisplay (w->dragW), VtkWindow (w->dragW));&  1     VListSetAutoScrollPosition ((Widget)w, 0, 0);i<     SetInternalXYAdjust (w, w->undoXAdjust, w->undoYAdjust);     StartPendingScroll (w);; }e  : static void StartDrag(VListWidget w, XButtonEvent *eventP) {)     Widget dragW; .     Window dragParentWindow, dummyChildWindow;     XWindowChanges changes;;  K     XYToColumnTier (w, eventP->x, eventP->y, &w->downColumn, &w->downTier);   /     CallDragArmCallbacks (w, (XEvent *)eventP);s  $     if (!(dragW = w->dragW)) return;  Y     /* Create the drag widget's window without ever mapping it and leave it unmanaged. */g  !     if (!VtkIsRealized (dragW)) {&3 	XtVaSetValues (dragW, XtNmappedWhenManaged, 0, 0);u 	XtRealizeWidget (dragW);i 	XtManageChild (dragW);C 	XtUnmanageChild (dragW);o3 	XtVaSetValues (dragW, XtNmappedWhenManaged, 1, 0);   V 	/* If a child of the root, override redirect to avoid window manager interference. */     N 	if (VtkWindow (VtkParent (dragW)) == RootWindowOfScreen (XtScreen (dragW))) {  	    XSetWindowAttributes attrs;! 	    attrs.override_redirect = 1; a 	    XChangeWindowAttributes (VtkDisplay (dragW), VtkWindow (dragW), CWOverrideRedirect, &attrs);  	}     }      5     dragParentWindow = VtkWindow (VtkParent (dragW));m  P     if (eventP->window == dragParentWindow) w->dragAdjustX = w->dragAdjustY = 0;z     else XTranslateCoordinates (eventP->display, eventP->window, dragParentWindow, 0, 0, &w->dragAdjustX, &w->dragAdjustY, 	&dummyChildWindow);  A     w->dragX = dragW->core.width  / 2 + dragW->core.border_width; A     w->dragY = dragW->core.height / 2 + dragW->core.border_width;   F     changes.x = dragW->core.x = eventP->x - w->dragX + w->dragAdjustX;F     changes.y = dragW->core.y = eventP->y - w->dragY + w->dragAdjustY;  R     XConfigureWindow (VtkDisplay (dragW), VtkWindow (dragW), CWX | CWY, &changes);=     XMapRaised       (VtkDisplay (dragW), VtkWindow (dragW));e       w->dragIsActive = 1; }   B static void DragMotionHandler(VListWidget w, XMotionEvent *eventP) {>     XEvent event;e     XWindowChanges changes;      int changeMask = 0;i     int dragMotionMask;n  f     /* Poor-man's motion compression.  Scan event queue until we have the most recent motion event. */       switch (w->dragButton) {@ 	case VListButton1	: dragMotionMask = Button1MotionMask;		break;@ 	case VListButton2	: dragMotionMask = Button2MotionMask;		break;@ 	case VListButton3	: dragMotionMask = Button3MotionMask;		break;@ 	case VListButton4	: dragMotionMask = Button4MotionMask;		break;@ 	case VListButton5	: dragMotionMask = Button5MotionMask;		break;     }e                      event.xmotion = *eventP;a     while (XCheckWindowEvent (eventP->display, eventP->window, dragMotionMask, &event) == True) ;W  t     if (VtkParent (w->dragW) == (Widget)w) VListSetAutoScrollPosition ((Widget)w, event.xmotion.x, event.xmotion.y);       /* If the pointer has moved, update the widget location.  Bypass XtSetValues because it causes the widget to redraw itself! */  i     if (w->dragW->core.x != (changes.x = event.xmotion.x - w->dragX + w->dragAdjustX)) changeMask |= CWX;ei     if (w->dragW->core.y != (changes.y = event.xmotion.y - w->dragY + w->dragAdjustY)) changeMask |= CWY;        if (changeMask) {h]         XConfigureWindow (VtkDisplay (w->dragW), VtkWindow (w->dragW), changeMask, &changes); %         w->dragW->core.x = changes.x;e%         w->dragW->core.y = changes.y;o     }   I     /* Synch with the server, to help motion compression do its thing. */)       XSync (eventP->display, 0);l }	  C static void DragReleaseHandler(VListWidget w, XButtonEvent *eventP)  { 4     w->dragIsActive = 0;			/* done with list grab */  ?     XUnmapWindow (VtkDisplay (w->dragW), VtkWindow (w->dragW));	  1     VListSetAutoScrollPosition ((Widget)w, 0, 0);e  &     CallDragDropCallbacks (w, eventP); }e lo static void ButtonPressHandler(Widget ow, XtPointer unused_closure, XEvent *eventOP, Boolean *unused_continueP)d {S$     VListWidget w = (VListWidget)ow;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;a       /* Chorded cancel. */   :     if (w->selectIsActive) 			{CancelSelect (w);		return;}8     if (w->dragIsActive) 			{CancelDrag   (w);		return;}  E     /* If this is not a simple un-chorded Button event, ignore it. */e  f     if (eventP->state & (Button1Mask | Button2Mask | Button3Mask | Button4Mask | Button5Mask)) return;  r     if ((eventP->button == w->selectButton) || (w->selectButton == AnyButton)) {StartSelect  (w, eventP);	return;}s     if ((eventP->button == w->dragButton)   || (w->dragButton   == AnyButton)) {StartDrag    (w, eventP); 	return;}i }t  q static void PointerMotionHandler(Widget ow, XtPointer unused_closure, XEvent *eventOP, Boolean *unused_continueP)= {i$     VListWidget w = (VListWidget)ow;3     XMotionEvent *eventP = (XMotionEvent *)eventOP;   G     if (w->selectIsActive) 	{SelectMotionHandler (w, eventP); 	return;}TE     if (w->dragIsActive)	{DragMotionHandler   (w, eventP); 	return;};{ }h  q static void ButtonReleaseHandler(Widget ow, XtPointer unused_closure, XEvent *eventOP, Boolean *unused_continueP)> { $     VListWidget w = (VListWidget)ow;3     XButtonEvent *eventP = (XButtonEvent *)eventOP;_  G     if (w->selectIsActive) 	{SelectReleaseHandler (w, eventP);	return;}ND     if (w->dragIsActive)	{DragReleaseHandler   (w, eventP);	return;} }c im static void DoInitialize(Widget unused_requestOW, Widget ow, ArgList unused_args, Cardinal *unused_num_argsP)g {s$     VListWidget w = (VListWidget)ow;  L     VtkSetFieldsToZero ((char *)&w->beginZeroInit, (char *)&w->endZeroInit);       w->currentFontidx = (-1);w       CopyColors (w);&     CopyFonts (w);     CopyFields (w);l     CopyLabels (w);e }, >) static void SniffOutSlaves(VListWidget w)P {L#     Widget vFrameW = VtkParent (w);n       if (!w->hScrollW) m 	if ((w->hScrollW = (Widget)VFrameGetScrollBarWidget (vFrameW, XmHORIZONTAL))) XtUnmanageChild (w->hScrollW);(       if (!w->vScrollW)lm 	if ((w->vScrollW = (Widget)VFrameGetScrollBarWidget (vFrameW, XmVERTICAL)))   XtUnmanageChild (w->vScrollW);P       if (!w->vHeaderW)nm 	if ((w->vHeaderW = (Widget)VtkGetChildByClass (vFrameW, vheaderwidgetclass))) XtUnmanageChild (w->vHeaderW);i }n  6 static void RealizeHandlersAndCallbacks(VListWidget w) {v     Widget hScrollW, vScrollW;  #     if ((hScrollW = w->hScrollW)) {eK 	XtAddCallback (hScrollW, XmNpageIncrementCallback, 	HPageIncCallback, 	w);nK 	XtAddCallback (hScrollW, XmNpageDecrementCallback, 	HPageDecCallback, 	w);sK 	XtAddCallback (hScrollW, XmNdragCallback, 	   	HValueChangedCallback, 	w); O 	XtAddCallback (hScrollW, XmNvalueChangedCallback, 	HValueChangedCallback, 	w);n            XtVaSetValues (hScrollW, 	    XmNminimum, 	0, 	    XmNincrement, 	1, 	    XmNpageIncrement,  	1,e 	    0);  V 	XtAddRawEventHandler (hScrollW, ButtonPressMask,   0, ScrollButtonPressHandler,   w);V 	XtAddRawEventHandler (hScrollW, ButtonReleaseMask, 0, ScrollButtonReleaseHandler, w);8     } else w->hScrollPolicy = VListScrollBarPolicyNever;  #     if ((vScrollW = w->vScrollW)) {lK 	XtAddCallback (vScrollW, XmNpageIncrementCallback, 	VPageIncCallback, 	w);lK 	XtAddCallback (vScrollW, XmNpageDecrementCallback, 	VPageDecCallback, 	w);wK 	XtAddCallback (vScrollW, XmNdragCallback, 	   	VValueChangedCallback, 	w); O 	XtAddCallback (vScrollW, XmNvalueChangedCallback, 	VValueChangedCallback, 	w);i      	XtVaSetValues (vScrollW,n 	    XmNminimum, 	0, 	    XmNincrement, 	1, 	    XmNpageIncrement,  	1,f 	    0);  V 	XtAddRawEventHandler (vScrollW, ButtonPressMask,   0, ScrollButtonPressHandler,   w);V 	XtAddRawEventHandler (vScrollW, ButtonReleaseMask, 0, ScrollButtonReleaseHandler, w);8     } else w->vScrollPolicy = VListScrollBarPolicyNever;  ;     /* Trap resize events on our parent (VFrame) widget. */e  L     XtAddCallback (VtkParent (w), VFrameNresizeCallback, ResizeCallback, w);  ;     /* Register an event handler for nonmaskable events. */F  F     XtAddRawEventHandler ((Widget)w, 0, 1, HandleNonmaskableEvent, 0);  t     /* Register raw event handlers for the events that we will receive as a result of our passive grab on Button. */  T     XtAddRawEventHandler ((Widget)w, ButtonPressMask,   0, ButtonPressHandler,   0);T     XtAddRawEventHandler ((Widget)w, PointerMotionMask, 0, PointerMotionHandler, 0);T     XtAddRawEventHandler ((Widget)w, ButtonReleaseMask, 0, ButtonReleaseHandler, 0); }+  % static void RealizeGCs(VListWidget w)d {      XGCValues values;f  v     /* The GCs must be private (allocated with XCreateGC) rather than shared (allocated with XtGetGC) because they are{      * not read-only.  Their colors and fonts are changed dynamically.  Start with foreground and background equal to zero,L]      * since that is the initial setting of w->currentForeground and w->currentBackground. */l       values.background = 0;     values.foreground = 0;     values.function = GXcopy;o&     values.line_style = LineOnOffDash;{     w->normgc = XCreateGC (VtkDisplay (w), VtkWindow (w), GCBackground | GCForeground | GCFunction | GCLineStyle, &values);        values.background = 0;     values.foreground = 0;     values.function = GXcopy;Ll     w->invgc = XCreateGC (VtkDisplay (w), VtkWindow (w), GCBackground | GCForeground | GCFunction, &values);       values.function = GXinvert;n     values.plane_mask = 0;]     w->flipgc = XCreateGC (VtkDisplay (w), VtkWindow (w), GCPlaneMask | GCFunction, &values);i }n  ' static void RealizeGrabs(VListWidget w)- {T1     /* Establish a passive grab for selection. */)       XGrabButton (($ 	VtkDisplay (w),							/* display */( 	w->selectButton,						/* button_grab */# 	AnyModifier,							/* modifiers */n" 	VtkWindow (w),							/* window */ 	0,								/* owner_events */ K 	(ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),	/* event_mask */i( 	GrabModeAsync,							/* pointer_mode */) 	GrabModeAsync,							/* keyboard_mode */n 	None,								/* confine_to */ 	None);								/* cursor */   1     /* Establish a passive grab for dragging.  */t  M     if ((w->dragButton != w->selectButton) && (w->selectButton != AnyButton))e 	XGrabButton (( 	    VtkDisplay (w),							/* display */+ 	    w->dragButton,							/* button_grab */ ' 	    AnyModifier,							/* modifiers */c& 	    VtkWindow (w),							/* window */" 	    0,									/* owner_events */P 	    (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),		/* event_mask */, 	    GrabModeAsync,							/* pointer_mode */- 	    GrabModeAsync,							/* keyboard_mode */C" 	    None,								/* confine_to */ 	    None);								/* cursor */  }   . static void SetWindowBackground(VListWidget w) {o     switch (w->gridStyle) {Op       case VListGridStylePixmap :     XSetWindowBackgroundPixmap (VtkDisplay (w), VtkWindow (w), w->gridPixmap); 					break; p       case VListGridStyleForeground : XSetWindowBackground       (VtkDisplay (w), VtkWindow (w), w->foreground); 					break;t{       case VListGridStyleBackground : XSetWindowBackground       (VtkDisplay (w), VtkWindow (w), w->core.background_pixel);i 					break;i     }k }   W static void DoRealize(Widget ow, XtValueMask *maskP, XSetWindowAttributes *attributesP)i {s$     VListWidget w = (VListWidget)ow;       SniffOutSlaves (w);e     ComputeLabelInfo (w);e  ?     /* Give a BitGravity to minimize repaints during resize. */        *maskP |= CWBitGravity;e0     attributesP->bit_gravity = NorthWestGravity;  0     if ((!w->core.width) || (!w->core.height)) {- 	w->core.width  = w->core.parent->core.width;e2     	w->core.height = w->core.parent->core.height;* 	w->core.x      = (-w->core.border_width);* 	w->core.y      = (-w->core.border_width);     }T  Q     XtCreateWindow ((Widget)w, InputOutput, CopyFromParent, *maskP, attributesP);l  J     if (w->gridStyle != VListGridStyleBackground) SetWindowBackground (w);       RealizeGCs (w);      RealizeGrabs (w);L$     RealizeHandlersAndCallbacks (w);       StartUpdateSweep (w);l })  $ #define Changed(f) (w->f != oldW->f)  y static Boolean DoSetValues(Widget oldOW, Widget unused_refOW, Widget ow, ArgList unused_args, Cardinal *unused_num_argsP)e {t*     VListWidget oldW = (VListWidget)oldOW;$     VListWidget w = (VListWidget)ow;  2     if (Changed (fieldsP) || Changed (fieldCnt)) { 	FreeFields (oldW);e 	CopyFields (w);, 	if (w->layoutIsValid) StartUpdateSweep (w);     }   2     if (Changed (labelsP) || Changed (labelCnt)) { 	FreeLabels (oldW);  	CopyLabels (w);- 	if (VtkIsRealized (w)) ComputeLabelInfo (w);w, 	if (w->layoutIsValid) StartUpdateSweep (w);     }-  8     if (Changed (selectStyle) || Changed (selectUnit)) { 	DeselectAllLines (oldW);d 	w->selectionCnt = 0;*     }   _     if  (Changed (columnStyle)		|| Changed (spaceGroupsEqually)		|| Changed (spaceTiersEqually)e]       || Changed (fieldSpacingWidth)	|| Changed (hScrollPolicy) 		|| Changed (allowDeadspace)n9       || Changed (marginWidth)		|| Changed (marginHeight)i<       || Changed (rowHeight) 		|| Changed (rowSpacingHeight)=       || Changed (vScrollPolicy)	|| Changed (vScrollPosition) . 	) if (w->layoutIsValid) StartUpdateSweep (w);  *     if (Changed (core.background_pixel)) { 	if (VtkIsRealized (w)) { I 	    XSetBackground (XtDisplay (w), w->normgc, w->core.background_pixel);pI 	    XSetForeground (XtDisplay (w), w->invgc,  w->core.background_pixel);dI 	    XSetPlaneMask  (XtDisplay (w), w->flipgc, w->core.background_pixel);C 	}  , 	if (w->layoutIsValid) StartUpdateSweep (w);     }S  6     if (Changed (gridStyle) || Changed (gridPixmap)) { 	SetWindowBackground (w); , 	if (w->layoutIsValid) StartUpdateSweep (w);     }n       if (Changed (colorList)) { 	FreeColors (oldW);s 	CopyColors (w);, 	if (w->layoutIsValid) StartUpdateSweep (w);     }b       if (Changed (fontTableP)) {  	FreeFonts (oldW); 	CopyFonts (w);c, 	if (w->layoutIsValid) StartUpdateSweep (w);     }        return (0);  }s D  static void DoDestroy(Widget ow) { $     VListWidget w = (VListWidget)ow;       FreeLines (w);  %     if (w->labelsP) 	FreeLabels 	(w);((     if (w->colorTableP) FreeColors 	(w);&     if (w->fontTableP)	FreeFonts 	(w); }n L_ #define XY(n, c, r, t, f, dr, d)	{n, c, r, sizeof(t), XtOffset(VListWidget, f), dr, (char *)d}, E #define XX(n, c, r, t, f, d)     	XY (n, c, r, t, f, XtRImmediate, d)d; #define XI(n, f, d) 		 	XX (n, XtCValue, XtRInt, int, f, d)C  ( #define DEFAULT_DRAG_BUTTON	VListButton2  ! static XtResource resources[] = {v  = XI (VListNalignment, 			alignment, 		VListAlignmentBeginning)&. XI (VListNallowDeadspace,		allowDeadspace,		0)2 XI (VListNautoScrollRate, 	  	autoScrollRate, 	15)C XI (VListNcolumnStyle, 		  	columnStyle, 		VListColumnStyleBestFit) 7 XI (VListNdoubleClickDelay, 	  	doubleClickDelay, 	250))9 XI (VListNdragButton,			dragButton,		DEFAULT_DRAG_BUTTON) F XI (VListNfieldResizePolicy,		fieldResizePolicy,	VListResizePolicyAny)) XI (VListNfieldCount, 		  	fieldCnt, 		1)a7 XI (VListNfieldSpacingWidth, 	  	fieldSpacingWidth, 	0)(- XI (VListNgridDashOff, 		  	gridDashOff, 		2)e+ XI (VListNgridDashOn, 		  	gridDashOn, 		2)(< XI (VListNgridStyle,			gridStyle,		VListGridStyleBackground), XI (VListNhistHeight, 		  	histHeight, 		10)5 XI (VListNhistMarginHeight, 	  	histMarginHeight, 	4)o3 XI (VListNhistMarginWidth, 	  	histMarginWidth, 	4)i+ XI (VListNhistWidth, 		  	histWidth, 		100)XN XI (VListNhScrollBarPolicy, 	  	hScrollPolicy, 		VListScrollBarPolicyAsNeeded)5 XI (VListNiconMarginHeight, 	  	iconMarginHeight, 	4)o3 XI (VListNiconMarginWidth, 	  	iconMarginWidth, 	4) ) XI (VListNlabelCount, 		  	labelCnt, 		0)cG XI (VListNlabelPadOption, 	  	labelPadOption, 	VListLabelPadWithDashes)d. XI (VListNmarginHeight, 	  	marginHeight, 		6)- XI (VListNmarginWidth, 		  	marginWidth, 		8)X) XI (VListNrowHeight, 		  	rowHeight, 		0)T5 XI (VListNrowSpacingHeight, 	  	rowSpacingHeight, 	0),7 XI (VListNselectButton,			selectButton, 		VListButton1)oB XI (VListNselectStyle, 		  	selectStyle, 		VListSelectStyleSingle)< XI (VListNselectUnit, 		  	selectUnit, 		VListSelectUnitRow)3 XI (VListNselectionIsLocked,		selectionIsLocked,	0)p5 XI (VListNspaceGroupsEqually,		spaceGroupsEqually,	0)R3 XI (VListNspaceTiersEqually,		spaceTiersEqually,	0)i5 XI (VListNtextMarginHeight, 	  	textMarginHeight, 	0)s3 XI (VListNtextMarginWidth, 	  	textMarginWidth, 	4)cN XI (VListNvScrollBarPolicy, 	  	vScrollPolicy, 		VListScrollBarPolicyAsNeeded)P XI (VListNvScrollBarPosition, 	  	vScrollPosition, 	VListScrollBarPositionRight)  Z XX (VListNuserData,   		 XtCValue,      XtRPointer,     XtPointer,      userData,       0)G XX (VListNcolorList, 		 XtCValue, 	XtRPixmap, 	Pixmap,  	colorList, 	0)tI XX (VListNfields, 		 XtCValue, 	XtRPointer, 	VListField *,  	fieldsP, 	0) I XX (VListNgridPixmap, 		 XtCValue, 	XtRPixmap, 	Pixmap,  	gridPixmap, 	0),I XX (VListNlabels, 		 XtCValue, 	XtRPointer, 	VListLabel *,  	labelsP, 	0)e  E XX (VListNdragWidget, 		 XtCValue, 	XtRWindow, 	Widget,  	dragW, 		0)gH XX (VListNheaderWidget, 	 XtCValue, 	XtRWindow, 	Widget,  	vHeaderW, 	0)L XX (VListNhScrollBarWidget, 	 XtCValue, 	XtRWindow, 	Widget,  	hScrollW, 	0)L XX (VListNvScrollBarWidget, 	 XtCValue, 	XtRWindow, 	Widget,  	vScrollW, 	0)  i XY (VListNfontTable, 		 XmCFontList, 	XmRFontList, 	struct _XmFontListRec *,  	fontTableP, 	XtRString, 0)dh XY (VListNforeground, 		 XtCForeground, XtRPixel, 	Pixel,  	foreground, 	XtRString, XtDefaultForeground)  g XY (VListNdragArmCallback, 	 XtCValue, 	XtRCallback, 	XtCallbackList, dragArmCallback, 	XtRCallback, 0)ni XY (VListNdragDropCallback, 	 XtCValue, 	XtRCallback, 	XtCallbackList, dragDropCallback, 	XtRCallback, 0) e XY (VListNselectCallback, 	 XtCValue, 	XtRCallback, 	XtCallbackList, selectCallback, 	XtRCallback, 0)-q XY (VListNselectConfirmCallback, XtCValue, 	XtRCallback, 	XtCallbackList, selectConfirmCallback, 	XtRCallback, 0)o };  	 #undef XXA	 #undef XY>	 #undef XI, &F externaldef(vlistwidgetclassrec) VListClassRec vlistwidgetclassrec = {       {/* core_class fields	*/3 	/* superclass		*/	(WidgetClass)&compositeClassRec,  	/* class_name	  	*/	"VList", - 	/* widget_size	  	*/	sizeof(VListWidgetRec),h! 	/* class_initialize   	*/    	0,  	/* class_part_initialize */	0,  	/* class_inited       	*/	0,(" 	/* initialize	  	*/	DoInitialize, 	/* initialize_hook	*/	0,d 	/* realize		*/	DoRealize, 	/* actions		*/    	0, 	/* num_actions	  	*/	0, 	/* resources	  	*/	resources,) 	/* num_resources	*/	XtNumber(resources),> 	/* xrm_class	  	*/	0, 	/* compress_motion	*/	0,  	/* compress_exposure  	*/	0,n 	/* compress_enterleave	*/	0,o 	/* visible_interest	*/	0, 	/* destroy		*/	DoDestroy, 	/* resize		*/	0,  	/* expose		*/	DoExpose,! 	/* set_values	  	*/	DoSetValues,B 	/* set_values_hook	*/	0,u4 	/* set_values_almost  	*/	(XtAlmostProc)_XtInherit, 	/* get_values_hook    	*/	0,r 	/* accept_focus	  	*/	0,d# 	/* version		*/	XtVersionDontCheck,r 	/* callback_private   	*/	0,M 	/* tm_table		*/	0,t 	/* query_geometry	*/	0, 	/* display_accelerator	*/	0,u 	/* extension		*/	0a     },!     {/* composite class fields	*/t5 	/* geometry_manager	*/	VtkPermissiveGeometryManager,i3 	/* change_managed	*/	(XtWidgetProc)VtkNullRoutine,e. 	/* insert_child		*/	(XtWidgetProc)_XtInherit,. 	/* delete_child		*/	(XtWidgetProc)_XtInherit, 	/* extension		*/	0i     }  };  _ externaldef(vlistwidgetclass) WidgetClass vlistwidgetclass = (WidgetClass)&vlistwidgetclassrec;e  B Widget VListCreate(Widget pW, char *nameP, Arg *argsP, int argCnt) {eI     return (XtCreateWidget (nameP, vlistwidgetclass, pW, argsP, argCnt));- }a    void VListInitializeForMRM(void) {n[     MrmRegisterClass (MrmwcUnknown, "VList", "VListCreate", VListCreate, vlistwidgetclass);i }e d* void VListSelectAll(Widget ow, int select) {,$     VListWidget w = (VListWidget)ow;  #     if (select) SelectAllLines (w);d     else DeselectAllLines (w); }   + Opaque VListGetFirstSelectedLine(Widget ow)c {r$     VListWidget w = (VListWidget)ow;
     int line;y     LineInfo *lineInfoP;  f     FOR_EACH_LINE (w, line, lineInfoP) if (lineInfoP->vLine.select) return (lineInfoP->vLine.closure);       return (0);m }i  ; int VListGetAllSelectedLines(Widget ow, Opaque **closurePP)s {t$     VListWidget w = (VListWidget)ow;     Opaque *closureP;l     int remCnt;;     LineInfo *lineInfoP;  ]     if (!closurePP) return (w->selectionCnt);		/* simply return number of selected entries */   <     if (!w->selectionCnt) closureP = (Opaque *)XtMalloc (1);O     else 		  closureP = (Opaque *)XtMalloc (w->selectionCnt * sizeof (Opaque));I       *closurePP = closureP;  R     for (remCnt = w->selectionCnt, lineInfoP = w->lineInfosP; remCnt; lineInfoP++) 	if (lineInfoP->vLine.select) {n. 	    *(closureP++) = lineInfoP->vLine.closure; 	    remCnt--; 	}       return (w->selectionCnt);a }|  T static int GetLines(VListWidget w, int firstLine, int increment, Opaque **closurePP) {=     Opaque *closureP;c
     int line;	     LineInfo *lineInfoP;  7     if (!w->lineCnt) closureP = (Opaque *)XtMalloc (1);n^     else             closureP = (Opaque *)XtMalloc (w->lineCnt / increment * sizeof (Opaque));       *closurePP = closureP;  h     FOR_EACH_LINE_L (w, line, lineInfoP, firstLine, increment) *(closureP++) = lineInfoP->vLine.closure;       return (w->lineCnt); }   3 int VListGetAllLines(Widget ow, Opaque **closurePP)) {r$     VListWidget w = (VListWidget)ow;  +     return (GetLines (w, 0, 1, closurePP));  }t  @ int VListGetFieldLines(Widget ow, int field, Opaque **closurePP) {e$     VListWidget w = (VListWidget)ow;  9     return (GetLines (w, field, w->fieldCnt, closurePP));t }v    int VListGetLineCount(Widget ow) { $     VListWidget w = (VListWidget)ow;       return (w->lineCnt); }   Z int VListGetLineInfo(Widget ow, Opaque closure, VListLine *vLineP, int *fieldP, int *rowP) {i$     VListWidget w = (VListWidget)ow;
     int line;_     LineInfo *lineInfoP;  @     if ((line = ClosureToLine (w, closure)) == (-1)) return (0);       if (vLineP) {>& 	lineInfoP = LineToLineInfo (w, line);      	*vLineP = lineInfoP->vLine;     }        if (fieldP || rowP) {t- 	if (fieldP) *fieldP = LineToField (w, line);)- 	if (rowP)   *rowP   = LineToRow   (w, line);g     }        return (1);m }=  9 Opaque VListFieldRowToLine(Widget ow, int field, int row)  {W$     VListWidget w = (VListWidget)ow;
     int line;)     LineInfo *lineInfoP;  D     if ((line = FieldRowToLine (w, field, row)) == (-1)) return (0);)     lineInfoP = LineToLineInfo (w, line);X*     return (lineInfoP->vLine.closure);     }H  - Opaque VListXYToLine(Widget ow, int x, int y)B {a$     VListWidget w = (VListWidget)ow;     int line, column, tier;      LineInfo *lineInfoP;  -     XYToColumnTier (w, x, y, &column, &tier);tH     if ((line = ColumnTierToLine (w, column, tier)) == (-1)) return (0);)     lineInfoP = LineToLineInfo (w, line);a&     return (lineInfoP->vLine.closure); }l  ; Opaque VListAddLine(Widget ow, VListLine *vLinesP, int row)l {k$     VListWidget w = (VListWidget)ow;     VListLine *vLineP;,     LineInfo *lineInfoP, *firstNewLineInfoP;     VListField *vFieldP;w     int firstNewLine, field, line, insertAtEnd, newLineCnt, selectCnt, firstVY, lastVYP1, x, fromY, width, height, toY;e  E     if (w->layoutIsValid && (w->groupCnt != 1)) StartUpdateSweep (w);l  ;     /* Determine how many of the new items are selected. */t       selectCnt = 0;M     for (field = 0, vLineP = vLinesP; field < w->fieldCnt; field++, vLineP++)yI 	if ((vLineP->mask & VListLineSelectMask) && vLineP->select) selectCnt++;m  v     /* If any of the new lines are selected and we're doing single select style, then clear the previous selection. */  V     if (selectCnt && (w->selectStyle == VListSelectStyleSingle)) DeselectAllLines (w);  1     /* Extend the LineInfo array if necessary. */h  *     newLineCnt = w->lineCnt + w->fieldCnt;  %     if (newLineCnt > w->maxLineCnt) {nC 	w->maxLineCnt = (newLineCnt * 3 / 2 + 8);	/* somewhat arbitrary */tb 	w->lineInfosP = (LineInfo *)XtRealloc ((char *)w->lineInfosP, w->maxLineCnt * sizeof (LineInfo));     }B  ;     /* Find the insertion point, shuffle and initialize. */e  L     if ((row < 0) || ((firstNewLine = (row * w->fieldCnt)) >= w->lineCnt)) { 	firstNewLine = w->lineCnt;e 	insertAtEnd = 1;c     } else insertAtEnd = 0;z       w->lineCnt += w->fieldCnt;     w->rowCnt++;!     w->selectionCnt += selectCnt;t  O     for (line = (w->lineCnt - 1); line >= (firstNewLine + w->fieldCnt); line--) 9 	w->lineInfosP[line] = w->lineInfosP[line - w->fieldCnt];i  1     lineInfoP = LineToLineInfo (w, firstNewLine); "     firstNewLineInfoP = lineInfoP;       vLineP = vLinesP; P     FOR_EACH_LINE_IN_RECORD (w, line, lineInfoP, field, vFieldP, firstNewLine) {" 	lineInfoP->vLine = (*(vLineP++));4 	SupplyLineDefaults (w, &lineInfoP->vLine, vFieldP);b         if (lineInfoP->vLine.textP) lineInfoP->vLine.textP = XtNewString (lineInfoP->vLine.textP);   	lineInfoP->expose = 0;e 	lineInfoP->segmentInfosP = 0;  % 	if (lineInfoP->vLine.segmentCount) {G 	    CopySegments (lineInfoP);* 	    SupplySegmentDefaults (w, lineInfoP); 	}  (         if (lineInfoP->vLine.barCount) { 	    CopyBars (lineInfoP);. 	    SupplyBarDefaults (w, &lineInfoP->vLine); 	}  ) 	ComputeCellInfo (w, vFieldP, lineInfoP);    	if (w->layoutIsValid)j 	    if (AddColumnWidthContribution (w, field, lineInfoP->bodyWidth  + 2 * vFieldP->marginWidth, vFieldP)) 		StartUpdateSweep (w);p   	if (w->layoutIsValid)b 	    if (AddCellHeightContribution (w,         lineInfoP->bodyHeight + 2 * vFieldP->marginHeight)) 		StartUpdateSweep (w);      }s  E     if (!w->layoutIsValid) return (firstNewLineInfoP->vLine.closure);        w->tierCnt = w->rowCnt;d     ComputeLogicalHeight (w);      ArrangeWidgets (w);t       if (!insertAtEnd) { 2 	firstVY  = w->marginHeight + row * w->tierHeight;$ 	lastVYP1 = firstVY + w->tierHeight; 	x        = 0;* 	fromY    = firstVY - w->requestedYAdjust; 	width    = w->core.width;D 	height   = (w->rowCnt - row - 1) * w->tierHeight + w->marginHeight;+ 	toY      = lastVYP1 - w->requestedYAdjust;t   	if (fromY <= 0) {* 	    w->internalYAdjust  += w->tierHeight;* 	    w->requestedYAdjust += w->tierHeight;* 	    w->externalYAdjust  += w->tierHeight;,         } else if (fromY < w->core.height) { 	    SetStippled (w, 0, 0, 0);: 	    if (height > w->core.height) height = w->core.height;j 	    XCopyArea (VtkDisplay (w), VtkWindow (w), VtkWindow (w), w->normgc, x, fromY, width, height, x, toY); 	    w->activeGropCnt++; 	}     }t  `     for (line = firstNewLine; line < (firstNewLine + w->fieldCnt); line++) Draw (w, line, 1, 1);  .     return (firstNewLineInfoP->vLine.closure); }y iB static void ChangeLine(VListWidget w, int line, VListLine *vLineP) { E     int field, selectLine, column, tier, oldBodyWidth, oldBodyHeight;M`     int redraw = 0, recomputeCellInfo = 0, resupplySegmentDefaults = 0, resupplyBarDefaults = 0;     int flipSelect = 0;o*     LineInfo *lineInfoP, *selectLineInfoP;     VListField *vFieldP;  *     lineInfoP  = LineToLineInfo (w, line);'     field      = LineToField (w, line);g*     vFieldP    = FieldToVField (w, field);  m     if ((vLineP->mask & VListLineClosureMask) && vLineP->closure) lineInfoP->vLine.closure = vLineP->closure;t  ~     if ((vLineP->mask & VListLineTextMask) && ((!lineInfoP->vLine.textP) || strcmp (vLineP->textP, lineInfoP->vLine.textP))) {) 	XtFree ((char *)lineInfoP->vLine.textP); =         lineInfoP->vLine.textP = XtNewString (vLineP->textP);   	recomputeCellInfo = redraw = 1;     }o  /     if (vLineP->mask & VListLineSegmentsMask) {t3 	lineInfoP->vLine.segmentsP    = vLineP->segmentsP;t6 	lineInfoP->vLine.segmentCount = vLineP->segmentCount;!         CopySegments (lineInfoP);i: 	resupplySegmentDefaults = recomputeCellInfo = redraw = 1;     }a  +     if (vLineP->mask & VListLineBarsMask) {t) 	XtFree ((char *)lineInfoP->vLine.barsP);-/ 	lineInfoP->vLine.barsP        = vLineP->barsP;t2 	lineInfoP->vLine.barCount     = vLineP->barCount; 	CopyBars (lineInfoP);" 	resupplyBarDefaults = redraw = 1;     }e  a     if ((vLineP->mask & VListLineFontidxMask) && (vLineP->fontidx != lineInfoP->vLine.fontidx)) {e, 	lineInfoP->vLine.fontidx = vLineP->fontidx;: 	resupplySegmentDefaults = recomputeCellInfo = redraw = 1;     }e  d     if ((vLineP->mask & VListLineColoridxMask) && (vLineP->coloridx != lineInfoP->vLine.coloridx)) {. 	lineInfoP->vLine.coloridx = vLineP->coloridx;< 	resupplySegmentDefaults = resupplyBarDefaults = redraw = 1;     }g  j     if ((vLineP->mask & VListLineBackgroundMask) && (vLineP->background != lineInfoP->vLine.background)) {2 	lineInfoP->vLine.background = vLineP->background;< 	resupplySegmentDefaults = resupplyBarDefaults = redraw = 1;     }   -     if (vLineP->mask & VListLineSelectMask) {;- 	if (w->selectUnit == VListSelectUnitField) {d 	    selectLine      = line;! 	    selectLineInfoP = lineInfoP;s	 	} else {)9 	    selectLine      = LineToFirstLineInRecord (w, line);e=             selectLineInfoP = LineToLineInfo (w, selectLine);( 	}  >         if (vLineP->select != selectLineInfoP->vLine.select) {\ 	    if (vLineP->select && (w->selectStyle == VListSelectStyleSingle)) DeselectAllLines (w);     M 	    if ((selectLineInfoP->vLine.select = vLineP->select)) w->selectionCnt++;g+ 	    else 					          w->selectionCnt--;n      	    flipSelect = 1;	         }      }a  e     if ((vLineP->mask & VListLineSensitiveMask) && (vLineP->sensitive != lineInfoP->vLine.sensitive))i0 	lineInfoP->vLine.sensitive = vLineP->sensitive;  d     if ((vLineP->mask & VListLineStippledMask) && (vLineP->stippled != lineInfoP->vLine.stippled)) {. 	lineInfoP->vLine.stippled = vLineP->stippled;< 	resupplySegmentDefaults = resupplyBarDefaults = redraw = 1;     }_  d     if ((vLineP->mask & VListLineLowValueMask) && (vLineP->lowValue != lineInfoP->vLine.lowValue)) {. 	lineInfoP->vLine.lowValue = vLineP->lowValue;" 	resupplyBarDefaults = redraw = 1;     }m  g     if ((vLineP->mask & VListLineHighValueMask) && (vLineP->highValue != lineInfoP->vLine.highValue)) { 0 	lineInfoP->vLine.highValue = vLineP->highValue;" 	resupplyBarDefaults = redraw = 1;     }e  +     if (vLineP->mask & VListLineIconMask) { & 	lineInfoP->vLine.icon = vLineP->icon;  	recomputeCellInfo = redraw = 1;     }   F     if (resupplySegmentDefaults) SupplySegmentDefaults (w, lineInfoP);N     if (resupplyBarDefaults)     SupplyBarDefaults     (w, &lineInfoP->vLine);       if (recomputeCellInfo) {& 	oldBodyWidth  = lineInfoP->bodyWidth;' 	oldBodyHeight = lineInfoP->bodyHeight;   ) 	ComputeCellInfo (w, vFieldP, lineInfoP);,  B 	if (w->layoutIsValid && (oldBodyWidth != lineInfoP->bodyWidth)) {0 	    LineToColumnTier (w, line, &column, &tier);2 	    if (ChangeColumnWidthContribution (w, column,0 		oldBodyWidth 	     + 2 * vFieldP->marginWidth,R 		lineInfoP->bodyWidth + 2 * vFieldP->marginWidth, vFieldP)) StartUpdateSweep (w); 	}  B 	if (w->layoutIsValid && (oldBodyHeight != lineInfoP->bodyHeight))) 	    if (ChangeCellHeightContribution (w,o3 		oldBodyHeight 	      + 2 * vFieldP->marginHeight,,M 		lineInfoP->bodyHeight + 2 * vFieldP->marginHeight)) 		StartUpdateSweep (w);      }   "     if (!w->layoutIsValid) return;  '     if (redraw) 	 Draw (w, line, 1, 1);P(     else if (flipSelect) Flip (w, line);  >     if (flipSelect && (w->selectUnit == VListSelectUnitRow)) {+ 	int lastLineP1 = selectLine + w->fieldCnt;I  \ 	for (; selectLine < lastLineP1; selectLine++) if (selectLine != line) Flip (w, selectLine);     }r }t ,B void VListChangeLine(Widget ow, Opaque closure, VListLine *vLineP) {s$     VListWidget w = (VListWidget)ow;
     int line;a  <     if ((line = ClosureToLine (w, closure)) == (-1)) return;  !     ChangeLine (w, line, vLineP);t }t  F void VListChangeCell(Widget ow, int field, int row, VListLine *vLineP) {l$     VListWidget w = (VListWidget)ow;
     int line;g  @     if ((line = FieldRowToLine (w, field, row)) == (-1)) return;  !     ChangeLine (w, line, vLineP);, }0   IX void VListChangeLineBars(Widget ow, Opaque closure, VListBar *newBarsP, int newBarCount) {t     VListLine vLine;  #     vLine.mask = VListLineBarsMask;i     vLine.barsP = newBarsP;h!     vLine.barCount = newBarCount;N*     VListChangeLine (ow, closure, &vLine); }I  I void VListChangeLineClosure(Widget ow, Opaque closure, Opaque newClosure), {      VListLine vLine;  &     vLine.mask = VListLineClosureMask;     vLine.closure = newClosure;t*     VListChangeLine (ow, closure, &vLine); }L  C void VListChangeLineText(Widget ow, Opaque closure, char *newTextP)( {s     VListLine vLine;  #     vLine.mask = VListLineTextMask;a     vLine.textP = newTextP;g*     VListChangeLine (ow, closure, &vLine); }r  F void VListChangeLineFontidx(Widget ow, Opaque closure, int newFontidx) {a     VListLine vLine;  &     vLine.mask = VListLineFontidxMask;     vLine.fontidx = newFontidx;)*     VListChangeLine (ow, closure, &vLine); }P  H void VListChangeLineColoridx(Widget ow, Opaque closure, int newColoridx) {e     VListLine vLine;  '     vLine.mask = VListLineColoridxMask;C!     vLine.coloridx = newColoridx; *     VListChangeLine (ow, closure, &vLine); }u  D void VListChangeLineSelect(Widget ow, Opaque closure, int newSelect) {	     VListLine vLine;  %     vLine.mask = VListLineSelectMask;g     vLine.select = newSelect;i*     VListChangeLine (ow, closure, &vLine); }   J void VListChangeLineSensitive(Widget ow, Opaque closure, int newSensitive) {V     VListLine vLine;  (     vLine.mask = VListLineSensitiveMask;#     vLine.sensitive = newSensitive;,*     VListChangeLine (ow, closure, &vLine); }F  h void VListChangeLineSegments(Widget ow, Opaque closure, VListSegment *newSegmentsP, int newSegmentCount) {e     VListLine vLine;  '     vLine.mask = VListLineSegmentsMask;g#     vLine.segmentsP = newSegmentsP;	)     vLine.segmentCount = newSegmentCount;r*     VListChangeLine (ow, closure, &vLine); }g  H void VListChangeLineStippled(Widget ow, Opaque closure, int newStippled) {C     VListLine vLine;  '     vLine.mask = VListLineStippledMask; !     vLine.stippled = newStippled;t*     VListChangeLine (ow, closure, &vLine); },  X void VListChangeLineValues(Widget ow, Opaque closure, int newLowValue, int newHighValue) {f     VListLine vLine;  @     vLine.mask = VListLineLowValueMask | VListLineHighValueMask;!     vLine.lowValue = newLowValue;s#     vLine.highValue = newHighValue;t*     VListChangeLine (ow, closure, &vLine); }/  C void VListChangeLineIcon(Widget ow, Opaque closure, Pixmap newIcon)n {a     VListLine vLine;  #     vLine.mask = VListLineIconMask;s     vLine.icon = newIcon; *     VListChangeLine (ow, closure, &vLine); }h  L void VListChangeLineBackground(Widget ow, Opaque closure, int newBackground) {*     VListLine vLine;  )     vLine.mask = VListLineBackgroundMask;(%     vLine.background = newBackground;/*     VListChangeLine (ow, closure, &vLine); }  /\ void VListChangeCellBars(Widget ow, int field, int row, VListBar *newBarsP, int newBarCount) {      VListLine vLine;  #     vLine.mask = VListLineBarsMask;/     vLine.barsP = newBarsP;s!     vLine.barCount = newBarCount; -     VListChangeCell (ow, field, row, &vLine);h }   M void VListChangeCellClosure(Widget ow, int field, int row, Opaque newClosure)  {l     VListLine vLine;  &     vLine.mask = VListLineClosureMask;     vLine.closure = newClosure;/-     VListChangeCell (ow, field, row, &vLine);p }t  G void VListChangeCellText(Widget ow, int field, int row, char *newTextP)  {      VListLine vLine;  #     vLine.mask = VListLineTextMask;c     vLine.textP = newTextP;e-     VListChangeCell (ow, field, row, &vLine);e },  J void VListChangeCellFontidx(Widget ow, int field, int row, int newFontidx) {l     VListLine vLine;  &     vLine.mask = VListLineFontidxMask;     vLine.fontidx = newFontidx;,-     VListChangeCell (ow, field, row, &vLine);a }i  L void VListChangeCellColoridx(Widget ow, int field, int row, int newColoridx) {M     VListLine vLine;  '     vLine.mask = VListLineColoridxMask;C!     vLine.coloridx = newColoridx;s-     VListChangeCell (ow, field, row, &vLine);t }l  H void VListChangeCellSelect(Widget ow, int field, int row, int newSelect) {s     VListLine vLine;  %     vLine.mask = VListLineSelectMask;r     vLine.select = newSelect; -     VListChangeCell (ow, field, row, &vLine);i }y  N void VListChangeCellSensitive(Widget ow, int field, int row, int newSensitive) {L     VListLine vLine;  (     vLine.mask = VListLineSensitiveMask;#     vLine.sensitive = newSensitive;W-     VListChangeCell (ow, field, row, &vLine);d }   l void VListChangeCellSegments(Widget ow, int field, int row, VListSegment *newSegmentsP, int newSegmentCount) {u     VListLine vLine;  '     vLine.mask = VListLineSegmentsMask;s#     vLine.segmentsP = newSegmentsP;s)     vLine.segmentCount = newSegmentCount; -     VListChangeCell (ow, field, row, &vLine);  }i  L void VListChangeCellStippled(Widget ow, int field, int row, int newStippled) {,     VListLine vLine;  '     vLine.mask = VListLineStippledMask;>!     vLine.stippled = newStippled;)-     VListChangeCell (ow, field, row, &vLine);} }   \ void VListChangeCellValues(Widget ow, int field, int row, int newLowValue, int newHighValue) {n     VListLine vLine;  @     vLine.mask = VListLineLowValueMask | VListLineHighValueMask;!     vLine.lowValue = newLowValue; #     vLine.highValue = newHighValue; -     VListChangeCell (ow, field, row, &vLine);n }t  G void VListChangeCellIcon(Widget ow, int field, int row, Pixmap newIcon)A {L     VListLine vLine;  #     vLine.mask = VListLineIconMask;)     vLine.icon = newIcon;;-     VListChangeCell (ow, field, row, &vLine);t }L  P void VListChangeCellBackground(Widget ow, int field, int row, int newBackground) {e     VListLine vLine;  )     vLine.mask = VListLineBackgroundMask;s%     vLine.background = newBackground;P-     VListChangeCell (ow, field, row, &vLine);  }  u5 void VListMoveLine(Widget ow, Opaque closure, int up)  {n$     VListWidget w = (VListWidget)ow;3     LineInfo lineInfo, *lineInfoP, *otherLineInfoP;l/     int field, firstLine, otherFirstLine, line;      VListField *vFieldP;  <     if ((line = ClosureToLine (w, closure)) == (-1)) return;  2     firstLine = LineToFirstLineInRecord (w, line);  5     if (up) otherFirstLine = firstLine - w->fieldCnt;t5     else    otherFirstLine = firstLine + w->fieldCnt;I  B     if (otherFirstLine < 0)           return;	/* already at top */E     if (otherFirstLine >= w->lineCnt) return;	/* already at bottom */r  8     otherLineInfoP = LineToLineInfo (w, otherFirstLine);M     FOR_EACH_LINE_IN_RECORD (w, line, lineInfoP, field, vFieldP, firstLine) { ;         lineInfo        = (*lineInfoP);		/* copy to temp */e=         *lineInfoP      = (*otherLineInfoP);	/* copy other */o6         *otherLineInfoP = lineInfo;		/* and restore */   	otherLineInfoP++;     }e  ?     /* If the row is changing groups, invalidate the layout. */n  r     if (w->layoutIsValid && (firstLine / w->fieldCnt / w->tierCnt) != (otherFirstLine / w->fieldCnt / w->tierCnt)) 	StartUpdateSweep (w);  "     if (!w->layoutIsValid) return; 	nf     for (field = 0, line = firstLine;      field < w->fieldCnt; field++, line++) Draw (w, line, 1, 1);f     for (field = 0, line = otherFirstLine; field < w->fieldCnt; field++, line++) Draw (w, line, 1, 1); }	 L6 static void DeleteRecord(VListWidget w, int firstLine) { 9     int line, firstVY, lastVYP1, row, fromY, toY, height;F     int field;)     LineInfo *lineInfoP, *otherLineInfoP;L     VListField *vFieldP;  E     if (w->layoutIsValid && (w->groupCnt != 1)) StartUpdateSweep (w);   M     FOR_EACH_LINE_IN_RECORD (w, line, lineInfoP, field, vFieldP, firstLine) {w0 	if (lineInfoP->vLine.select) w->selectionCnt--;  ) 	XtFree ((char *)lineInfoP->vLine.textP);-+ 	XtFree ((char *)lineInfoP->segmentInfosP);>) 	XtFree ((char *)lineInfoP->vLine.barsP);c   	if (w->layoutIsValid) Im 	    if (RemoveColumnWidthContribution (w, field, lineInfoP->bodyWidth  + 2 * vFieldP->marginWidth, vFieldP))  		StartUpdateSweep (w);-   	if (w->layoutIsValid)e 	    if (RemoveCellHeightContribution (w,         lineInfoP->bodyHeight + 2 * vFieldP->marginHeight))n 		StartUpdateSweep (w);e     }	  *     /* Collapse the row from the array. */       w->lineCnt -= w->fieldCnt;     w->rowCnt--;  y     for (line = firstLine, lineInfoP = LineToLineInfo (w, line), otherLineInfoP = LineToLineInfo (w, line + w->fieldCnt); _       line < w->lineCnt; line++, lineInfoP++, otherLineInfoP++) *lineInfoP = (*otherLineInfoP);   "     if (!w->layoutIsValid) return;  (     row      = LineToRow (w, firstLine);5     firstVY  = w->marginHeight + row * w->tierHeight;t'     lastVYP1 = firstVY + w->tierHeight;-       w->tierCnt = w->rowCnt;      ComputeLogicalHeight (w);)     ArrangeWidgets (w);   -     /* Removed row is above top of window? */>  )     if (w->internalYAdjust >= lastVYP1) {n& 	w->internalYAdjust  -= w->tierHeight;& 	w->requestedYAdjust -= w->tierHeight;& 	w->externalYAdjust  -= w->tierHeight;  ` 	SetInternalXYAdjust (w, w->internalXAdjust, w->internalYAdjust);	/***** may not be necessary */= 	StartPendingScroll (w);							/***** may not be necessary */  	return;     }i  0     /* Removed row is below bottom of window? */  A     if ((w->internalYAdjust + w->core.height) <= firstVY) return;I  7     /* Removed row is visible.  Fix window contents. */C  +     toY    = firstVY - w->requestedYAdjust;a!     fromY  = toY + w->tierHeight; $     height = w->core.height - fromY;  Z     /* If anything visible follows the row being removed, scroll it up to fill the gap. */       if (height > 0) { !         SetStippled (w, 0, 0, 0); u         XCopyArea (VtkDisplay (w), VtkWindow (w), VtkWindow (w), w->normgc, 0, fromY, w->core.width, height, 0, toY);( 	w->activeGropCnt++;     })  T     /* Clear the gap left at the end of the window and redraw lines in that area. */  s     XClearArea (VtkDisplay (w), VtkWindow (w), 0, w->core.height - w->tierHeight, w->core.width, w->tierHeight, 0);   N     DrawExposeRegion (w, 0, firstVY + height, w->logicalWidth, w->tierHeight);  :     /* Possible scroll to eliminate trailing deadspace. */  D     SetInternalXYAdjust (w, w->internalXAdjust, w->internalYAdjust);     StartPendingScroll (w);  }-  / void VListRemoveLine(Widget ow, Opaque closure)i { $     VListWidget w = (VListWidget)ow;
     int line;H  <     if ((line = ClosureToLine (w, closure)) == (-1)) return;  8     DeleteRecord (w, LineToFirstLineInRecord (w, line)); }>  ' void VListRemoveRow(Widget ow, int row)> {e$     VListWidget w = (VListWidget)ow;     int firstLine;  >     if ((firstLine = RowToFirstLine (w, row)) == (-1)) return;        DeleteRecord (w, firstLine); }i  # void VListRemoveAllLines(Widget ow)t {n$     VListWidget w = (VListWidget)ow;       FreeLines (w);  W     w->anyAreExposed = w->lineCnt = w->rowCnt = w->selectionCnt = w->layoutIsValid = 0;s  "     SetInternalXYAdjust (w, 0, 0);     SetPosition (w);     StartUpdateSweep (w);- }i c) int VListComputePreferredWidth(Widget ow)i {i$     VListWidget w = (VListWidget)ow;     int width, height;  B     /* If we are not in single column style, or we always want theD      * horizontal scrollbar anyway, just return the current size. */  g     if ((w->columnStyle != VListColumnStyleSingle) || (w->hScrollPolicy == VListScrollBarPolicyAlways)) % 	return (w->core.parent->core.width);e       ComputeCellHeight (w, 1);(     DoColumnLayout (w);        width = w->logicalWidth;)     height = w->core.parent->core.height;k  L     if (w->headerHeight) height -= (w->headerHeight + w->core.border_width);  H     if (w->vScrollW && ((w->vScrollPolicy == VListScrollBarPolicyAlways)^       || ((w->vScrollPolicy == VListScrollBarPolicyAsNeeded) && (w->logicalHeight > height))))E 	width += (w->vScrollW->core.width + w->vScrollW->core.border_width);o       return (width);  }  f[ int VListLineToCell(Widget ow, Opaque closure, int *xP, int *yP, int *widthP, int *heightP)P { $     VListWidget w = (VListWidget)ow;     int line, column, tier;y  _     /* Given the cell identified by closure, return the x, y, width and height of that cell. */f  F     if (!w->layoutIsValid) return (0);						/* can't compute it yet */U     if ((line = ClosureToLine (w, closure)) == (-1)) return (0); 		/* no such line */   /     LineToColumnTier (w, line, &column, &tier);s@     ColumnTierToCell (w, column, tier, xP, yP, widthP, heightP);       return (1);k }&vLineP->fontidx != lineInfoP->vLine.fontidx)) {e, 	lineInfoP->vLine.fontidx = vLineP->fontidx;:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 