1 /* vlist.h - VList widget C-language include file   O ******************************************************************************* G * VToolkit (1995) 	"If it doesn't use VToolkit, it isn't cool!"	      *  * (c) Steve Klein							      * O * Unpublished rights reserved under the copyright laws of the United States.  * O *******************************************************************************   L This module contains C-language declarations needed to use the VList widget.F Include this file into any C module that directly uses a VList widget.   MODIFICATION HISTORY:   7 29-Oct-1993 (sjk) Add VListNselectionIsLocked resource.   E 22-Oct-1993 (sjk) Add VListNgridStyle and VListNgridPixmap resources.   4 17-Sep-1993 (sjk) Add prototype for VListLineToCell.  ) 14-Sep-1993 (sjk) Add missing prototypes.   : 28-Aug-1993 (sjk/nfc) Run through the Motif porting tools.  5 19-Mar-1992 (sjk) Conditionalize #pragma for VMS ony.   + 03-Jan-1991 (sjk) Add VListLine.type field.   0 30-Dec-1991 (sjk) Add support for icon segments.  4 11-Dec-1991 (sjk) Add VListNallowDeadspace resource.  7 19-Nov-1991 (sjk) Add VListNspaceTiersEqually resource.   8 15-Nov-1991 (sjk) Add VListNspaceGroupsEqually resource.  , 14-Nov-1991 (sjk) Add VListAnyButton option.  v 08-Nov-1991 (sjk) Add VListNdragButton, VListNdragWidget, VListNdragArmCallback, and VListNdragDropCallback resources.   31-Oct-1991 (sjk) Add VListAlignment symbols for two-dimensional options.  Add VListNfieldResizePolicy and VListField.resizePolicy. % 	Add VListNtextMarginHeight resource.   . 29-Oct-1991 (sjk) Add VListSegmentNewLineMask.  { 28-Oct-1991 (sjk) Add VListNselectButton resource.  Add VListNhistHeight resource.  Add VListField.marginWidth and ~Height.   Q 25-Oct-1991 (sjk) Add VListNiconMarginWidth and VListNiconMarginHeight resources.   1 29-Aug-1990 (sjk) Add VListLine.background field.   d 20-Jul-1990 (sjk) Add icon support.  Add VListNrowHeight resource.  Add VListFieldTypeIcon constant.  + 28-Mar-1990 (sjk) Add VListSelectStyleNone.   2 27-Mar-1990 (sjk) Add multi-bar histogram support.   06-Mar-1990 (sjk) Add histogram support.  Add selectionCount field to VListSelectCallbackStruct.  Remove VListLinePixelMask and      VListSegmentPixelMask.  a 05-Mar-1990 (sjk) Add VListNuserData resource and VListSelectCallbackStruct.selectionCount field.   C 21-Feb-1990 (sjk) Add VListLinePixelMask and VListSegmentPixelMask.   8 31-Jan-1990 (sjk) Fix type of VListLine.segmentsP field.  M 26-Jan-1990 (sjk) Add VListSelectCallbackStruct.selectChangesP and lineCount.   , 23-Jan-1990 (sjk) Add stippled text support.  2 19-Jan-1990 (sjk) Add pad option to header labels.  / 11-Jan-1990 (sjk) Add segmented string support.   v 03-Jan-1990 (sjk) Add VListAlignmentLeft and ~Right, and remove column and tier fields from VListSelectCallbackStruct.  & 28-Dec-1989 (sjk) Version X2.0 update.    15-Nov-1988 (sjk) Initial entry. */   #ifndef _VList_h #define _VList_h   /* Widget class */  & external WidgetClass vlistwidgetclass;   /* Resource names */  % #define VListNalignment			"alignment" . #define VListNallowDeadspace		"allowDeadspace". #define VListNautoScrollRate		"autoScrollRate"% #define VListNcolorList			"colorList" ( #define VListNcolumnStyle		"columnStyle"2 #define VListNdoubleClickDelay		"doubleClickDelay"0 #define VListNdragArmCallback		"dragArmCallback"& #define VListNdragButton		"dragButton"2 #define VListNdragDropCallback		"dragDropCallback"& #define VListNdragWidget		"dragWidget"& #define VListNfieldCount		"fieldCount"4 #define VListNfieldResizePolicy		"fieldResizePolicy"4 #define VListNfieldSpacingWidth		"fieldSpacingWidth" #define VListNfields			"fields" % #define VListNfontTable			"fontTable" & #define VListNforeground		"foreground"( #define VListNgridDashOff		"gridDashOff"& #define VListNgridDashOn		"gridDashOn"& #define VListNgridPixmap		"gridPixmap"% #define VListNgridStyle			"gridStyle" * #define VListNheaderWidget		"headerWidget"& #define VListNhistHeight		"histHeight"2 #define VListNhistMarginHeight		"histMarginHeight"0 #define VListNhistMarginWidth		"histMarginWidth"% #define VListNhistWidth			"histWidth" 2 #define VListNhScrollBarPolicy		"hScrollBarPolicy"2 #define VListNhScrollBarWidget		"hScrollBarWidget"2 #define VListNiconMarginHeight		"iconMarginHeight"0 #define VListNiconMarginWidth		"iconMarginWidth"& #define VListNlabelCount		"labelCount". #define VListNlabelPadOption		"labelPadOption" #define VListNlabels			"labels" * #define VListNmarginHeight		"marginHeight"( #define VListNmarginWidth		"marginWidth"% #define VListNrowHeight			"rowHeight" 2 #define VListNrowSpacingHeight		"rowSpacingHeight"* #define VListNselectButton		"selectButton". #define VListNselectCallback		"selectCallback"; #define VListNselectConfirmCallback	"selectConfirmCallback" ( #define VListNselectStyle		"selectStyle"& #define VListNselectUnit		"selectUnit"4 #define VListNselectionIsLocked		"selectionIsLocked"5 #define VListNspaceGroupsEqually	"spaceGroupsEqually" 4 #define VListNspaceTiersEqually		"spaceTiersEqually"2 #define VListNtextMarginHeight		"textMarginHeight"0 #define VListNtextMarginWidth		"textMarginWidth"# #define VListNuserData			"userData" 2 #define VListNvScrollBarPolicy		"vScrollBarPolicy"5 #define VListNvScrollBarPosition	"vScrollBarPosition" 2 #define VListNvScrollBarWidget		"vScrollBarWidget"  ) /* Values for VListNgridStyle resource */   " #define VListGridStyleBackground	1" #define VListGridStyleForeground	2 #define VListGridStylePixmap		3   L /* Values for VListNhScrollBarPolicy and VListNvScrollBarPolicy resources */  # #define VListScrollBarPolicyNever	1 $ #define VListScrollBarPolicyAlways	2& #define VListScrollBarPolicyAsNeeded	3  2 /* Values for VListNvScrollBarPosition resource */  $ #define VListScrollBarPositionLeft	1% #define VListScrollBarPositionRight	2   + /* Values for VListNcolumnStyle resource */   ! #define VListColumnStyleSingle		1 " #define VListColumnStyleMultiple	2" #define VListColumnStyleBestFit		3  + /* Values for VListNselectStyle resource */   ! #define VListSelectStyleSingle		1 " #define VListSelectStyleMultiple	2! #define VListSelectStyleExtend		3  #define VListSelectStyleNone		4   * /* Values for VListNselectUnit resource */   #define VListSelectUnitField		1  #define VListSelectUnitRow		2   S /* Values for VListNfieldResizePolicy resource and VListField.resizePolicy field */    #define VListResizePolicyAny		1 # #define VListResizePolicyGrowOnly	2   2 /* Bar structure definition for VListLine.barsP */   typedef struct {!     int			mask;		/* mask flags */ +     int			lowValue;	/* bar low-end value */ -     int			highValue;	/* bar high-end value */ 8     int			coloridx;	/* bar color index or pixel value *//     int			stippled;	/* bar is stippled (1/0) */  } VListBar;   ( /* Mask flag values for VListBar.mask */  $ #define VListBarLowValueMask		(1<<0)% #define VListBarHighValueMask		(1<<1) $ #define VListBarColoridxMask		(1<<2)$ #define VListBarStippledMask		(1<<3)  5 /* Grid structure definition for VListField.gridsP */    typedef struct {!     int			mask;		/* mask flags */ $     char		*textP;		/* ASCIZ label */5     int			row;		/* row on which label is to appear */      int			value;		/* value */ 6     int			dashOn;		/* number of pixels on (or zero) */-     int			dashOff;	/* number of pixels off */ 9     int			coloridx;	/* grid color index or pixel value */  } VListGrid;  ) /* Mask flag values for VListGrid.mask */   ! #define VListGridTextMask		(1<<0)   #define VListGridRowMask		(1<<1)" #define VListGridValueMask		(1<<2)! #define VListGridDashMask		(1<<3) % #define VListGridColoridxMask		(1<<4)   : /* Field structure definition for VListNfields resource */   typedef struct {!     int			mask;		/* mask flags */ 7     int			width;		/* field's minimum width in pixels */ *     int			alignment;	/* VListAlignment~ */3     int			marginWidth;	/* margin width in pixels */ 5     int			marginHeight;	/* margin height in pixels */ 0     int			resizePolicy;	/* VListResizePolicy~ */&     int			type;		/* VListFieldType~ */  !     /* VListFieldTypeHist only */ '     int			maxValue;	/* maximum value */ '     int			minValue;	/* minimum value */ 3     VListGrid		*gridsP;	/* address of grid array */ *     int			gridCount;	/* number of grids */
 } VListField;   * /* Mask flag values for VListField.mask */  # #define VListFieldWidthMask		(1<<0) ' #define VListFieldAlignmentMask		(1<<1) " #define VListFieldTypeMask		(1<<2)& #define VListFieldMaxValueMask		(1<<3)& #define VListFieldMinValueMask		(1<<4)# #define VListFieldGridsMask		(1<<5) ( #define VListFieldMarginWidthMask	(1<<6)) #define VListFieldMarginHeightMask	(1<<7) ) #define VListFieldResizePolicyMask	(1<<8)     /* Values for VListField.type */   #define VListFieldTypeText		0  #define VListFieldTypeHist		1  #define VListFieldTypeIcon		2   : /* Label structure definition for VListNlabels resource */   typedef struct {!     int			mask;		/* mask flags */ 6     char		*textP;		/* pointer to label's ASCIZ text */7     int			row;		/* zero-based row within header area */ *     int			alignment;	/* label alignment */'     int			firstField;	/* first field */ %     int			lastField;	/* last field */ $     int			pad;		/* padding option */
 } VListLabel;   * /* Mask flag values for VListLabel.mask */  " #define VListLabelTextMask		(1<<0)! #define VListLabelRowMask		(1<<1) ' #define VListLabelAlignmentMask		(1<<2) ' #define VListLabelFirstFieldMask	(1<<3) ' #define VListLabelLastFieldMask		(1<<4) ! #define VListLabelPadMask		(1<<5)   8 /* Values for VListNlabelPadOption and VListLabel.pad */  " #define VListLabelPadWithBlanks		1" #define VListLabelPadWithDashes		2  Y /* Values for VListNalignment resource, VListField.alignment, and VListLabel.alignment */    #define VListAlignmentCenter		1  #define VListAlignmentTop		2 #define VListAlignmentBottom		3  #define VListAlignmentLeft		4  #define VListAlignmentRight		5  #define VListAlignmentTopLeft		6! #define VListAlignmentTopRight		7 " #define VListAlignmentBottomLeft	8# #define VListAlignmentBottomRight	9   3 #define VListAlignmentBeginning		VListAlignmentLeft . #define VListAlignmentEnd		VListAlignmentRight  B /* Values for VListNselectButton and VListNdragButton resources */   #define VListAnyButton			0 #define VListButton1			1 #define VListButton2			2 #define VListButton3			3 #define VListButton4			4 #define VListButton5			5  7 /* String segment definition for VListLine.segmentsP */    typedef struct {!     int			mask;		/* mask flags */ 7     int			type;		/* segment type (VListSegmentType~) */ 8     int			coloridx;	/* segment's color index or pixel */3     int			stippled;	/* segment is stippled (1/0) */   #     /* VListSegmentTypeText only */ ?     int			textPosition;	/* 0-based offset in VListLine.textP */ ;     int			textStrlen;	/* number of bytes in text segment */ -     int			fontidx;	/* segment's font index */   #     /* VListSegmentTypeIcon only */ $     Pixmap		icon;		/* icon pixmap */ } VListSegment;   , /* Mask flag values for VListSegment.mask */  ' #define VListSegmentFontidxMask		(1<<0) ' #define VListSegmentColoridxMask	(1<<1) ' #define VListSegmentStippledMask	(1<<2) ' #define VListSegmentNewLineMask		(1<<3) $ #define VListSegmentTypeMask		(1<<4)$ #define VListSegmentIconMask		(1<<5)  " /* Values for VListSegment.type */   #define VListSegmentTypeText		0  #define VListSegmentTypeIcon		2   $ /* Line item structure definition */   typedef struct {)     /* common fields - all field types */ !     int			mask;		/* mask flags */ :     Opaque		closure;	/* line item's Opaque closure (ID) */4     int			select;		/* line item is selected (1/0) */:     int			sensitive;	/* line item can be selected (1/0) */5     int			stippled;	/* line item is stippled (1/0) */ I     int        		coloridx;       /* line item's foreground color index */ >     int			background;	/* line item's background color index */8     int			type;		/* line item's type (VListLineType~) */        /* VListLineTypeText only */:     char		*textP;		/* pointer to line item's ASCIZ text */=     int        		fontidx;        /* line item's font index */ C     VListSegment	*segmentsP;	/* array of VListSegment structures */ ;     int			segmentCount;	/* count of VListSegment entries */         /* VListLineTypeHist only */3     int			highValue;	/* histogram high-end value */ 1     int			lowValue;	/* histogram low-end value */ 9     VListBar		*barsP;		/* array of VListBar structures */ 3     int			barCount;	/* count of VListBar entries */         /* VListLineTypeIcon only */$     Pixmap		icon;		/* icon pixmap */ } VListLine;  ) /* Mask flag values for VListLine.mask */   $ #define VListLineClosureMask		(1<<0)! #define VListLineTextMask		(1<<1) $ #define VListLineFontidxMask		(1<<2)% #define VListLineColoridxMask		(1<<3) # #define VListLineSelectMask		(1<<4) & #define VListLineSensitiveMask		(1<<5)% #define VListLineSegmentsMask		(1<<6) % #define VListLineStippledMask		(1<<7) & #define VListLineHighValueMask		(1<<8)% #define VListLineLowValueMask		(1<<9) " #define VListLineBarsMask		(1<<10)" #define VListLineIconMask		(1<<11)( #define VListLineBackgroundMask		(1<<12)" #define VListLineTypeMask		(1<<13)   /* Values for VListLine.type */    #define VListLineTypeText		0 #define VListLineTypeHist		1 #define VListLineTypeIcon		2  . /* Visible options for VListMakeLineVisible */   #define VListVisibleInWindow		1  #define VListVisibleAtTop		2 #define VListVisibleAtBottom		3  #define VListVisibleAtLeft		4  #define VListVisibleAtRight		5  #define VListVisibleAtTopLeft		6! #define VListVisibleAtTopRight		7 " #define VListVisibleAtBottomLeft	8# #define VListVisibleAtBottomRight	9   ) /* Special values for VListAddLine row */    #define VListAddAtTop			0  #define VListAddAtBottom		(-1)  0 /* Special values for VListMoveLine direction */   #define VListMoveLineDown		0 #define VListMoveLineUp			1   G /* Structure definition for VListSelectCallbackStruct.selectChangesP */    typedef struct {,     Opaque		closure;	/* line item closure */8     int			oldSelect;	/* was previously selected (1/0) */0     int			newSelect;	/* is now selected (1/0) */ } VListSelectChange;  ; /* Callback reasons for VListSelectCallbackStruct.reason */    #define VListCRSelect			1  #define VListCRSelectConfirm		2  #define VListCRDragArm			3 #define VListCRDragDrop			4   ? /* Callback structure for Select and SelectConfirm callbacks */    typedef struct {9     int			reason;			/* VListCRSelect or ~SelectConfirm */ /     XEvent		*event;			/* event (may be zero) */ 5     int			field;			/* upclick logical field number */ 1     int			row;			/* upclick logical row number */ =     VListLine		vLine;			/* line info (closure may be zero) */ N     VListSelectChange	*selectChangesP;	/* list of old and new select states */<     int			lineCount;		/* number of line items in the list */?     int			selectionCount;		/* (new) number of selected lines */  } VListSelectCallbackStruct;  - /* Callback structure for DragArm callback */    typedef struct {(     int			reason;			/* VListCRDragArm */0     XEvent		*event;			/* event (XButtonEvent) */%     int			field;			/* source field */ !     int			row;			/* source row */ D     VListLine		vLine;			/* source line info (closure may be zero) */ } VListDragArmCallbackStruct;   . /* Callback structure for DragDrop callback */   typedef struct {)     int			reason;			/* VListCRDragDrop */ 0     XEvent		*event;			/* event (XButtonEvent) */%     int			field;			/* source field */ !     int			row;			/* source row */ D     VListLine		vLine;			/* source line info (closure may be zero) */E     int			dropWindow;		/* target window on which entry was dropped */ G     int			dropX, dropY;		/* coordinates of drop within target window */ J     Widget		dropWidget;		/* target widget ID on which entry was dropped */Q     int			dropWidgetIsVList;	/* target widget is a VList widget instance (1/0) */ .     int			dropField;		/* target VList field */*     int			dropRow;		/* target VList row */M     VListLine		dropVLine;		/* target VList line info (closure may be zero) */ F     int			dropVListFieldCount;	/* number of fields in target widget */B     int			dropVListRowCount;	/* number of rows in target widget */ } VListDragDropCallbackStruct;    /* global function prototypes */  ' int VListComputePreferredWidth(Widget); 0 int VListGetAllSelectedLines(Widget, Opaque **);( int VListGetAllLines(Widget, Opaque **);@ int VListGetLineInfo(Widget, Opaque, VListLine *, int *, int *); int VListGetLineCount(Widget);. Opaque VListAddLine(Widget, VListLine *, int);) Opaque VListGetFirstSelectedLine(Widget);l- Opaque VListFieldRowToLine(Widget, int, int);o' Opaque VListXYToLine(Widget, int, int);*2 void VListChangeLine(Widget, Opaque, VListLine *);4 void VListChangeLineBackground(Widget, Opaque, int);; void VListChangeLineBars(Widget, Opaque,  VListBar *, int);o4 void VListChangeLineClosure(Widget, Opaque, Opaque);2 void VListChangeLineColoridx(Widget, Opaque, int);1 void VListChangeLineFontidx(Widget, Opaque, int);d1 void VListChangeLineIcon(Widget, Opaque, Pixmap); 0 void VListChangeLineSelect(Widget, Opaque, int);B void VListChangeLineSegments(Widget, Opaque, VListSegment *, int);3 void VListChangeLineSensitive(Widget, Opaque, int);r2 void VListChangeLineStippled(Widget, Opaque, int);1 void VListChangeLineText(Widget, Opaque, char *);D5 void VListChangeLineValues(Widget, Opaque, int, int);1! void VListEndBatchUpdate(Widget);r! void VListInitializeForMRM(void);L/ void VListMakeLineVisible(Widget, Opaque, int);s( void VListMoveLine(Widget, Opaque, int);! void VListRemoveAllLines(Widget);u% void VListRemoveLine(Widget, Opaque);L2 void VListSetAutoScrollPosition(Widget, int, int);# void VListStartBatchUpdate(Widget);r! void VListSelectAll(Widget, int);A/ Widget VListCreate(Widget, char *, Arg *, int);d4 void VListChangeCell(Widget, int, int, VListLine *);< void VListChangeCellBars(Widget, int, int, VListBar *, int);6 void VListChangeCellClosure(Widget, int, int, Opaque);3 void VListChangeCellText(Widget, int, int, char *);u3 void VListChangeCellFontidx(Widget, int, int, int);O4 void VListChangeCellColoridx(Widget, int, int, int);2 void VListChangeCellSelect(Widget, int, int, int);5 void VListChangeCellSensitive(Widget, int, int, int);nD void VListChangeCellSegments(Widget, int, int, VListSegment *, int);4 void VListChangeCellStippled(Widget, int, int, int);7 void VListChangeCellValues(Widget, int, int, int, int);63 void VListChangeCellIcon(Widget, int, int, Pixmap);C7 void VListChangeCellBackground(Widget, int, int, int );e\ int VListLineToCell(Widget ow, Opaque closure, int *xP, int *yP, int *widthP, int *heightP);  3 #define VListInitializeForDRM	VListInitializeForMRM1   #endif /* _VList_h */L