3 /* vtkutil.c - VToolkit common convenience routines   O ******************************************************************************* G * VToolkit (1995) 	"If it doesn't use VToolkit, it isn't cool!"	      *  * (c) Steve Klein							      * O * Unpublished rights reserved under the copyright laws of the United States.  * O *******************************************************************************   D This module contains common "convenience" routines for the VToolkit.   MODIFICATION HISTORY:   a 08-Aug-1994 (sjk) Bugfix - VtkGetCharWidthAndHeight was correctly calculating the maximum size of k         width and height in the given font list, but was always returning the last font's width and height. ) 	Thanks to Shinichiro IKEDA for this fix!   M 23-May-1994 (sjk) Bugfix - Call XmStringFree instead of XtFree.  Thanks Bill!   9 11-Oct-1993 (sjk) More portability cleanup.  Thanks Bill!   * 14-Sep-1993 (sjk) Fix a few more typedefs.  P 14-Sep-1993 (sjk) Add VtkAddDeleteWindowCallback and VtkFlushUntilDone routines.  V 14-Sep-1993 (sjk) Bugfix typedef of value in VtkGetOneValue to work on 64-bit systems.  5 28-Aug-1993 (nfc) Run through the Motif porting tools   L 10-Apr-1992 (sjk) Bugfix (another) memory allocation problem in VtkGetFontA.  : 26-Mar-1992 (sjk) Change include directory for XmP to Xm/.  0 02-Dec-1991 (sjk) Add VtkGetIntResource routine.  4 25-Nov-1991 (sjk) Add VtkSetIdentifierValue routine.  3 20-Nov-1991 (sjk) Add VtkGetStringResource routine.   3 14-Nov-1991 (sjk) Add VtkActivatePopupMenu routine.   9 14-Nov-1991 (sjk) Add VtkFetchWidget convenience routine.   F 08-Nov-1991 (sjk) Add VtkGetChildByClass and VtkGetSubwindow routines.  I 06-Nov-1991 (sjk) Add VtkGetDefaultsName and VtkUnitTypeDefault routines.   M 20-Aug-1991 (sjk) Bugfix - allocate enough memory in VtkWidgetResourceToName.   G 19-Jul-1991 (sjk) Bugfix - copying extra longword in VtkGetFontA (XUI).   1 09-Apr-1991 (sjk) Add VtkCopyColorNames routines.   x 28-Mar-1991 (sjk) Fix VtkComputeTextWidth to handle FIXED fonts that do not have per-char information.  Reformat source.p 	Properly initialize some context variables as required by MOTIF V1.0 toolkit.  Add VtkGetDrawableWidthAndHeight' 	and VtkGetCharWidthAndHeight routines.   v 01-Jun-1990 (sjk) Add VtkCopyColors, VtkSetFieldsToZero, VtkMinMax, VtkComputeTextWidth, VtkPermissiveGeometryManager,q 	VtkNullRoutine, VtkGetStippleBitmap, and VtkRecloneString routines.  These routines are used for widget writing.   J 25-May-1990 (sjk) Add VtkWidgetResourceToName and VtkSaveNumericResourceN.  1 10-May-1990 (sjk) Add portable fontlist routines.   . 01-May-1990 (sjk) Use portable varargs macros.    05-Apr-1990 (sjk) Initial entry. */   #include <stdio.h> #include <stdlib.h>  #include "vtoolkit.h"  #include <Xm/RowColumn.h>  #include <Xm/Protocols.h>  #include <X11/ShellP.h>   . XtArgVal VtkGetOneValue(Widget w, char *nameP) {      Arg argA[1];     XtArgVal value;   6     value = 0;				/* in case short value is fetched */&     XtSetArg (argA[0], nameP, &value);     XtGetValues (w, argA, 1);        return value;  }   j void VtkChangeRadioResource(Widget w, int *valueP, XmToggleButtonCallbackStruct *cbDataP, char *resourceP) { H     if (!cbDataP->set) return;		/* only interested when toggle is set */-     XtVaSetValues (w, resourceP, *valueP, 0);  }   < char *VtkWidgetResourceToName(Widget w, char *resourceNameP) { .     char nameA[2048], tempNameA[2048], *nameP;     int totLen, len;     Widget pW;  "     strcpy (nameA, resourceNameP);     totLen = strlen (nameA);       for (; w; w = pW) { 8 	if ((!(pW = XtParent (w))) && XtIsApplicationShell (w))S 	    nameP = XrmQuarkToString (((ApplicationShellWidget)w)->application.xrm_class); 2 	else nameP = XrmQuarkToString (w->core.xrm_name);   	len = strlen (nameP);  	memcpy (tempNameA, nameP, len); 	tempNameA[len] = '.'; 	tempNameA[len + 1] = 0; 	strcat (tempNameA, nameA);  	totLen += (len + 1); ' 	memcpy (nameA, tempNameA, totLen + 1);      }   *     nameP = (char *)XtMalloc (totLen + 1);&     memcpy (nameP, nameA, totLen + 1);       return (nameP);  }   T void VtkSaveNumericResource(XrmDatabase *databaseP, char *resourceNameP, int number) {      XrmValue value;      char valueA[256];   #     sprintf (valueA, "%d", number);      value.addr = valueA;%     value.size = strlen (valueA) + 1; A     XrmPutResource (databaseP, resourceNameP, XtRString, &value);  }   K void VtkSaveNumericResourceN(XrmDatabase *databaseP, Widget w, char *nameP)  { 0     int number = (int)VtkGetOneValue (w, nameP);=     char *resourceNameP = VtkWidgetResourceToName (w, nameP);   >     VtkSaveNumericResource (databaseP, resourceNameP, number);     XtFree (resourceNameP);  }   U void VtkSaveStringResource(XrmDatabase *databaseP, char *resourceNameP, char *valueP)  {      XrmValue value;        value.addr = valueP;%     value.size = strlen (valueP) + 1; A     XrmPutResource (databaseP, resourceNameP, XtRString, &value);  }   7 static Widget *createWidgetsP, *createNegativeWidgetsP;   l static void CreateCallback(Widget w, int *indexP, XmAnyCallbackStruct *cbDataP)   /* a widget was created */ {      int index = (*indexP);  8     if (index >= 0) createWidgetsP[index] 	         = w;6     else	    createNegativeWidgetsP[(-1) - index] = w; }   y Widget VtkFetchWidget(MrmHierarchy mrmHierarchy, char *nameP, Widget parentW, Widget *widgetsP, Widget *negativeWidgetsP)  {      MrmCode dummyClass;      Widget newW;   &     createWidgetsP         = widgetsP;.     createNegativeWidgetsP = negativeWidgetsP;  L     (void)MrmFetchWidget (mrmHierarchy, nameP, parentW, &newW, &dummyClass);       return (newW); }   5 void VtkSetIdentifierValue(char *nameP, Opaque value)  {      MrmRegisterArg registerArg;        registerArg.name  = nameP;&     registerArg.value = (char *)value;  '     MrmRegisterNames (&registerArg, 1);  }   . static MrmRegisterArg vtkMrmRegisterArgs[] = {3     {"VtkCreateCallback",		(char *)CreateCallback},  };  ] int VtkInitialize(char *appNameP, char *appClassP, int *argcP, char **argv,  char *uidFileP,  e 	MrmRegisterArg *mrmRegisterArgsP, int mrmRegisterArgCnt, MrmHierarchy *mrmHierarchyP, Widget *appWP)  { ;     /* Initialize the toolkit and attach to the display. */   E     (*appWP) = XtInitialize (appNameP, appClassP, 0, 0, argcP, argv);   -     /* For REL4, set the title explicitly. */   2     XtVaSetValues (*appWP, XtNtitle, appNameP, 0);       /* Open the UID file. */  M     (*mrmHierarchyP) = 0;	/* MOTIF requires this to be initialized to zero */   J     if (MrmOpenHierarchy (1, &uidFileP, 0, mrmHierarchyP) != MrmSUCCESS) {3 	printf ("Failure - Can't open %s file", uidFileP);  	return (0);     }   5     /* Register the application callback routines. */   ;     MrmRegisterNames (mrmRegisterArgsP, mrmRegisterArgCnt);   )     /* Register VTK callback routines. */   I     MrmRegisterNames (vtkMrmRegisterArgs, XtNumber (vtkMrmRegisterArgs));        return (1);  }   ? XFontStruct *VtkGetFirstFont(struct _XmFontListRec *fontTableP)  {      XmFontContext context = 0;     XmStringCharSet charset;     XFontStruct *fontP;   5     XmFontListInitFontContext (&context, fontTableP); 6     XmFontListGetNextFont (context, &charset, &fontP);,     XmStringFree ((unsigned char *)charset);(     XmFontListFreeFontContext (context);       return (fontP);  }   Y void VtkGetFontA(struct _XmFontListRec *fontTableP, XFontStruct ***fontAP, int *fontCntP)  {      int fontCnt = 0;     XFontStruct **fontPP;      XmFontContext context = 0;     XFontStruct *fontP;      XmStringCharSet charset;  5     XmFontListInitFontContext (&context, fontTableP); ?     while (XmFontListGetNextFont (context, &charset, &fontP)) {  	fontCnt++; ) 	XmStringFree ((unsigned char *)charset);      } (     XmFontListFreeFontContext (context);  U     (*fontAP) = fontPP = (XFontStruct **)XtMalloc (fontCnt * sizeof (XFontStruct *));      *fontCntP = fontCnt;     context = 0;5     XmFontListInitFontContext (&context, fontTableP); ?     while (XmFontListGetNextFont (context, &charset, &fontP)) {  	*fontPP++ = fontP; ) 	XmStringFree ((unsigned char *)charset);      }   (     XmFontListFreeFontContext (context); }   * XmFontList VtkGetDefaultFontList(Widget w) {       while ((w = XtParent (w))) {o 	if (XmIsBulletinBoard (w)) 		      return (XmFontListCopy ((XmFontList)VtkGetOneValue (w, XmNlabelFontList))); | 	if (XmIsVendorShell (w) || XmIsMenuShell (w)) return (XmFontListCopy ((XmFontList)VtkGetOneValue (w, XmNdefaultFontList)));     }        return (0);  }   ? void VtkUnitTypeDefault(Widget w, int offset, XrmValue *valueP)  { "     static unsigned char unitType;  %     valueP->size = sizeof (unitType); %     valueP->addr = (char *)&unitType;   m     if (XmIsManager (w->core.parent)) unitType = (unsigned char)VtkGetOneValue (w->core.parent, XmNunitType); %     else			      unitType = XmPIXELS;  }   \ int VtkCopyColorNames(Widget w, char **colorNamesPP, Pixel foreground, Pixel **colorTablePP) {      char **colorNamePP;      int colorCnt = 0;      XColor color, dummy;     Pixel pixel;     Pixel *colorTableP;   ?     /* Determine the number of names in the color name list. */   M     for (colorNamePP = colorNamesPP; *colorNamePP; colorNamePP++) colorCnt++;   !     /* Resize the color table. */   j     *colorTablePP = colorTableP = (Pixel *)XtRealloc ((char *)(*colorTablePP), colorCnt * sizeof (Pixel));  ~     /* For each entry in the color name list, try to get the pixel value of the named color.  Fallback to foreground color. */  C     for (colorNamePP = colorNamesPP; *colorNamePP; colorNamePP++) { X 	if (XAllocNamedColor (XtDisplay (w), w->core.colormap, *colorNamePP, &color, &dummy)) {              pixel = color.pixel;F             if (pixel == w->core.background_pixel) pixel = foreground;     	} else pixel = foreground;    	(*(colorTableP++)) = pixel;     }        return (colorCnt); }   C int VtkCopyColors(Widget w, Pixmap colorList, Pixel **colorTablePP)  {      Window rootWindow;     int i, x, y;6     unsigned int colorCnt, height, borderWidth, depth;     XImage *imageP;      Pixel *colorTableP;   D     if (!colorList) return (0);          /* no table was supplied */  0     /* What is the width of the color pixmap? */  k     XGetGeometry (XtDisplay (w), colorList, &rootWindow, &x, &y, &colorCnt, &height, &borderWidth, &depth);   !     /* Resize the color table. */   j     *colorTablePP = colorTableP = (Pixel *)XtRealloc ((char *)(*colorTablePP), colorCnt * sizeof (Pixel));  |     /* Get an image of the color pixmap, copy the pixel values from that image to the color table, and destroy the image. */  R     imageP = XGetImage (XtDisplay (w), colorList, 0, 0, colorCnt, 1, -1, ZPixmap);  M     for (i = 0; i < colorCnt; i++) colorTableP[i] = XGetPixel (imageP, i, 0);        XDestroyImage (imageP);        return (colorCnt); }   2 void VtkSetFieldsToZero(char *firstP, char *lastP) {      char *cP = firstP;  $     while (cP != lastP) *(cP++) = 0; }   2 void VtkMinMax(int a, int b, int *minP, int *maxP) { &     if (a < b) {*minP = a; *maxP = b;}&     else       {*minP = b; *maxP = a;} }   8 int VtkComputeTextWidth(XFontStruct *fontP, char *textP) {      int width;     unsigned char *chP;      XCharStruct *charP; &     unsigned int firstCol, numCols, c;       if (!textP) return (0);        width 	= 0; "     chP 	= (unsigned char *)textP;     charP 	= fontP->per_char; )     firstCol 	= fontP->min_char_or_byte2; 7     numCols 	= fontP->max_char_or_byte2 - firstCol + 1;        while (*chP) {          c = *(chP++) - firstCol;         if (c < numCols)  0             if (charP)  width += charP[c].width;_             else	width += fontP->max_bounds.width;	/* FIXED font has no per-char information */      }        return (width);  }   m XtGeometryResult VtkPermissiveGeometryManager(Widget w, XtWidgetGeometry *requestP, XtWidgetGeometry *replyP)  { @     if (requestP->request_mode & CWX)		w->core.x		= requestP->x;B     if (requestP->request_mode & CWY) 		w->core.y 		= requestP->y;M     if (requestP->request_mode & CWWidth) 	w->core.width 		= requestP->width; P     if (requestP->request_mode & CWHeight) 	w->core.height 		= requestP->height;_     if (requestP->request_mode & CWBorderWidth) w->core.border_width 	= requestP->border_width;   /     return (XtGeometryYes);		/* just say yes */  }    void VtkNullRoutine(void)  {  }   $ Pixmap VtkGetStippleBitmap(Widget w) {      int  x, y;     unsigned int width, height;      XGCValues values;      GC tempgc;     Pixmap stippleBitmap;   K     XQueryBestStipple (XtDisplay (w), XtWindow (w), 2, 2, &width, &height);   R     stippleBitmap = XCreatePixmap (XtDisplay (w), XtWindow (w), width, height, 1);       values.foreground = 0;     values.function = GXcopy; Z     tempgc = XCreateGC (XtDisplay (w), stippleBitmap, GCForeground | GCFunction, &values);  O     XFillRectangle (XtDisplay (w), stippleBitmap, tempgc, 0, 0, width, height);   .     XSetForeground (XtDisplay (w), tempgc, 1);        for (y = 0; y < height; y++)) 	for (x = 1 - (y & 1); x < width; x += 2) = 	    XDrawPoint (XtDisplay (w), stippleBitmap, tempgc, x, y);   $     XFreeGC (XtDisplay (w), tempgc);       return (stippleBitmap);  }   . char *VtkRecloneString(char *oldP, char *newP) {      int len;     char *toP, *toSP, *fromSP;       len = strlen (newP) + 1;'     toP = toSP = XtRealloc (oldP, len);      fromSP = newP;*     while (len--) *(toSP++) = *(fromSP++);       return (toP);  }   T void VtkGetDrawableWidthAndHeight(Display *dpy, Pixmap p, int *widthP, int *heightP) {      Window rootWindow;
     int x, y; $     unsigned int borderWidth, depth;  v     XGetGeometry (dpy, p, &rootWindow, &x, &y, (unsigned int *)widthP, (unsigned int *)heightP, &borderWidth, &depth); }   c void VtkGetCharWidthAndHeight(XFontStruct **fontPP, int fontCnt, int *charWidthP, int *charHeightP)  { >     int i, charWidth, charHeight, maxCharWidth, maxCharHeight;     XCharStruct *charP;      XFontStruct *fontP;   %     maxCharWidth = maxCharHeight = 0;   #     for (i = 0; i < fontCnt; i++) {          fontP = fontPP[i]; 	charP = fontP->per_char;   D 	if (charP) charWidth = charP['0' - fontP->min_char_or_byte2].width;] 	else	   charWidth = fontP->max_bounds.width;				/* FIXED font has no per-char information */   ?         if (maxCharWidth < charWidth) maxCharWidth = charWidth;   J         charHeight = fontP->max_bounds.descent + fontP->max_bounds.ascent;C         if (maxCharHeight < charHeight) maxCharHeight = charHeight;      }   "     (*charWidthP)  = maxCharWidth;#     (*charHeightP) = maxCharHeight;  }    static char defaultsNameA[256];   " char *VtkGetDefaultsName(Widget w) {      Widget pW;       for (; w; w = pW) A         if ((!(pW = XtParent (w))) && XtIsApplicationShell (w)) { 
 #ifdef VMS:             strcpy (defaultsNameA, "decw$user_defaults:");j             strcat (defaultsNameA, XrmQuarkToString (((ApplicationShellWidget)w)->application.xrm_class));+             strcat (defaultsNameA, ".dat");  #else <             strcpy (defaultsNameA, (char *)getenv ("HOME"));(             strcat (defaultsNameA, "/");j             strcat (defaultsNameA, XrmQuarkToString (((ApplicationShellWidget)w)->application.xrm_class)); #endif#             return (defaultsNameA); 	         }        return (""); }   6 Widget VtkGetChildByClass(Widget w, WidgetClass class) { >     int numChildren = (int)VtkGetOneValue (w, XmNnumChildren);B     Widget *childrenP = (Widget *)VtkGetOneValue (w, XmNchildren);     Widget siblingW;
     int i;  '     for (i = 0; i < numChildren; i++) {  	siblingW = childrenP[i]; >         if (XtIsSubclass (siblingW, class)) return (siblingW);     }        return ((Widget)0);  }   y Window VtkGetSubwindow(Display *dpy, Window window, int x, int y, Window avoidWindow, int *subwindowXP, int *subwindowYP)  { #     Window subwindow, newSubwindow;        subwindow = window;        while (subwindow) { 1         if (subwindow == avoidWindow) return (0);   T         XTranslateCoordinates (dpy, window, subwindow, x, y, &x, &y, &newSubwindow);           window = subwindow; !         subwindow = newSubwindow;      }        (*subwindowXP) = x;      (*subwindowYP) = y;        return (window); }   3 void VtkActivatePopupMenu(Widget w, XEvent *eventP)u {e6     XmMenuPosition (w, (XButtonPressedEvent *)eventP);  1     if (w->core.x < 0) 					       w->core.x = 0;fq     if ((w->core.x + w->core.width) > w->core.screen->width)   w->core.x = w->core.screen->width - w->core.width;   1     if (w->core.y < 0) 					       w->core.y = 0;*s     if ((w->core.y + w->core.height) > w->core.screen->height) w->core.y = w->core.screen->height - w->core.height;i       XtManageChild (w); }i  E char *VtkGetStringResource(XrmDatabase database, char *resourceNameP)n {i     char *typeP;     XrmValue value;u  ]     if (!XrmGetResource (database, resourceNameP, resourceNameP, &typeP, &value)) return (0);n  &     return (XtNewString (value.addr)); }   R int VtkGetIntResource(XrmDatabase database, char *resourceNameP, int defaultValue) {T     char *typeP;     XrmValue value;p  h     if (!XrmGetResource (database, resourceNameP, resourceNameP, &typeP, &value)) return (defaultValue);       return (atoi (value.addr));s }t oN void VtkAddDeleteWindowCallback(Widget w, void (*callbackP)(), Opaque closure) {      Arg args[1];  i     /* This routine establishes the callbackP routine as the CloseWindow callback for the shell widget w.aP      * w must be an instance of a vendorShellWidgetClass or subclass thereof. */  :     XtVaSetValues (w, XmNdeleteResponse, XmDO_NOTHING, 0);       XmAddProtocolCallback (w,n<         XmInternAtom (XtDisplay (w), "WM_PROTOCOLS",     0),<         XmInternAtom (XtDisplay (w), "WM_DELETE_WINDOW", 0),         callbackP, closure); }  F$ void VtkFlushUntilDone(Display *dpy) {v     XEvent event;G  ]     /* Call this routine to *really* make sure that the request/event pipeline is flushed. */n  .     /* Loop until the event queue is empty. */       while (1) {hM 	/* Flush out pending requests and wait for all response events to arrive. */a   	XSync (dpy, 0);  3 	/* If there are no pending events, we are done. */   8         if (!XEventsQueued (dpy, QueuedAlready)) return;  _ 	/* Read an event and process it.  Continue until the event queue is empty.  Then, loop back tom. 	 * see if we've triggered any more events. */   	do {d 	    XNextEvent (dpy, &event); 	    XtDispatchEvent (&event);. 	} while (XEventsQueued (dpy, QueuedAlready));     }F }d