/*
 * File:    bombs.cc
 * Purpose: main application module, generated by wxBuilder.
 * Author:  P. Foggia 1996
 */

#ifdef __GNUG__
#pragma implementation
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx_prec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx.h"
#endif

#include "wx_help.h"
#include "bombs.h"

#include <time.h>
#include <stdlib.h>

// A macro needed for some compilers (AIX) that need 'main' to be defined
// in the application itself.
IMPLEMENT_WXWIN_MAIN

// Declare an instance of the application: allows the program to start
AppClass theApp;

// Called to initialize the program
wxFrame *AppClass::OnInit(void)
{
  srand((unsigned)time(NULL));

  // Initialize all the top-level window members to NULL.
  BombsFrame = NULL;
  AboutFrame = NULL;
  level=IDM_EASY;
  if (!ParseCommandLine())
    return NULL;

  BombsFrame = 
    new BombsFrameClass(NULL, "wxBombs", 155, 165, 300, 300, wxSDI | wxMINIMIZE_BOX | wxSYSTEM_MENU | wxCAPTION, "BombsFrame");

  int xmax=BombsFrame->BombsCanvas->field_width*BombsFrame->BombsCanvas->x_cell*X_UNIT;
  int ymax=BombsFrame->BombsCanvas->field_height*BombsFrame->BombsCanvas->y_cell*Y_UNIT;
  BombsFrame->SetClientSize(xmax+1, ymax+1);
//  BombsFrame->Refresh();

  return BombsFrame;
}

// Parses the command line
Bool AppClass::ParseCommandLine(void)
{
  return TRUE;
}

#ifdef wx_x
#include "bombs.xbm"
#endif

BombsFrameClass::BombsFrameClass(wxFrame *parent, char *title, int x, int y, int width, int height, long style, char *name):
  wxFrame(parent, title, x, y, width, height, style, name)
{
  // Initialize child subwindow members.
  BombsCanvas = NULL;

#ifdef wx_x
  wxIcon *frameIcon = new wxIcon(bombs_bits, bombs_width, bombs_height);
#endif
#ifdef wx_msw
  wxIcon *frameIcon = new wxIcon("Bombs");
#endif
  SetIcon(frameIcon);
  CreateStatusLine();
  
  // Create a menu bar for the frame
  wxMenuBar *menuBar1 = new wxMenuBar;
  wxMenu *menu1 = new wxMenu;
  menu1->Append(IDM_EXIT, "E&xit"); // , "Quit the program");
  menu1->AppendSeparator();
  menu1->Append(IDM_ABOUT, "&About..."); // , "Infos on wxBombs");
  menuBar1->Append(menu1, "&File");
  wxMenu *menu2 = new wxMenu;
  menu2->Append(IDM_RESTART, "&Restart"); // , "Clear the play field");
  menu2->AppendSeparator();
  menu2->Append(IDM_EASY, "&Easy", NULL, TRUE); // "10x10 play field", TRUE);
  menu2->Append(IDM_MEDIUM, "&Medium", NULL, TRUE); // "15x15 play field", TRUE);
  menu2->Append(IDM_DIFFICULT, "&Difficult", NULL, TRUE); // "25x20 play field", TRUE);
  menuBar1->Append(menu2, "&Game");
  SetMenuBar(menuBar1);
  menuBar=menuBar1;
  menuBar->Check(theApp.level, TRUE);

  // Create child subwindows.
  BombsCanvas = new BombsCanvasClass(this, 0, 0, 292, 246, 0, "BombsCanvas");

  // Ensure the subwindows get resized o.k.
  OnSize(width, height);

  // Centre frame on the screen.
  Centre(wxBOTH);

  // Show the frame.
  Show(TRUE);
}

BombsFrameClass::~BombsFrameClass(void)
{
}

Bool BombsFrameClass::OnClose(void)
{
  // Clean up any associated data here.
  theApp.BombsFrame = NULL;
  return TRUE;
}

void BombsFrameClass::OnSize(int w, int h)
{
  // Let default member handle sizing for only one subwindow.
  wxFrame::OnSize(w, h);
}

void BombsFrameClass::OnMenuCommand(int commandId)
{
  switch (commandId)
  {
    // E&xit
    case IDM_EXIT:
    { Show(FALSE);
      OnClose();
      delete this;
      break;
    }
    // About...
    case IDM_ABOUT:
    {
      // Create window, or show it if already created.
      if (!theApp.AboutFrame)
      {
        theApp.AboutFrame = 
      new AboutFrameClass(NULL, "About wxBombs", 156, 199, 277, 232, wxCAPTION | wxSYSTEM_MENU, "AboutFrame");

      }
      theApp.AboutFrame->Iconize(FALSE);
      theApp.AboutFrame->Show(TRUE);
      break;
    }
    // &Restart
    case IDM_RESTART:
    {
      BombsCanvas->UpdateFieldSize();
      int xmax=BombsCanvas->field_width*BombsCanvas->x_cell*X_UNIT;
      int ymax=BombsCanvas->field_height*BombsCanvas->y_cell*Y_UNIT;
      theApp.BombsFrame->SetClientSize(xmax+1, ymax+1);
//      theApp.BombsFrame->Refresh();
      break;
    }
    // &Easy
    case IDM_EASY:
    // &Medium
    case IDM_MEDIUM:
    // &Difficult
    case IDM_DIFFICULT:
    { menuBar->Check(theApp.level, FALSE);
      theApp.level=commandId;
      menuBar->Check(theApp.level, TRUE);
      break;
    }
  default:
    break;
  }
}

BombsCanvasClass::BombsCanvasClass(wxFrame *parent, int x, int y, int width, int height, long style, char *name):
  wxCanvas(parent, x, y, width, height, style, name)
{ 
  int sx, sy;
  wxDC *dc = GetDC();
  dc->SetMapMode(MM_TEXT);
  wxFont *font=new BOMBS_FONT;
  dc->SetFont(font);  

  float chw, chh;
  char buf[]="M";

  dc->GetTextExtent(buf, &chw, &chh);
  dc->SetFont(NULL);
  delete font;

  dc->SetMapMode(MM_METRIC);

  int xcm = dc->LogicalToDeviceX(10.0);
  int ycm = dc->LogicalToDeviceY(10.0);
    // To have a square cell, there must be :
    //    sx*ycm == sy*xcm
  if (chw*ycm < chh*xcm)
    { sy=chh;
      sx=chh*xcm/ycm;
    }
  else
    { sx=chw;
      sy=chw*ycm/xcm;
    }
  x_cell = (sx+3+X_UNIT)/X_UNIT;
  y_cell = (sy+3+Y_UNIT)/Y_UNIT;
  dc->SetMapMode(MM_TEXT);
  bmp=NULL;
  UpdateFieldSize();
}

BombsCanvasClass::~BombsCanvasClass(void)
{ wxDC *dc=GetDC();
  wxFont *font=dc->GetFont();
  dc->SetFont(NULL);
  if (font)
    delete font; 
  if (bmp)
    delete bmp;
}

// Called when canvas is resized.
void BombsCanvasClass::OnSize(int w, int h)
{
  wxCanvas::OnSize(w, h);
}

// Called when canvas needs to be repainted.
void BombsCanvasClass::OnPaint(void)
{
  // Speeds up drawing under Windows.
  GetDC()->BeginDrawing();

  // Insert your drawing code here.
  if (!bmp)
    { bmp=new wxBitmap(field_width*x_cell*X_UNIT+1,
                       field_height*y_cell*Y_UNIT+1);
      if (bmp)
        { wxMemoryDC memDC;
          memDC.SelectObject(bmp);
          DrawField(&memDC, 0, 0, field_width-1, field_height-1);
        }
    }
  if (bmp)
    { wxMemoryDC memDC;
      memDC.SelectObject(bmp);
      GetDC()->Blit(0, 0, field_width*x_cell*X_UNIT+1,
                          field_height*y_cell*Y_UNIT+1,
                    &memDC, 0, 0, wxCOPY);
    }
  else
    DrawField(GetDC(), 0, 0, field_width-1, field_height-1);

  GetDC()->EndDrawing();
}


// Called when the canvas receives a key event.
void BombsCanvasClass::OnChar(wxKeyEvent& event)
{
  wxCanvas::OnChar(event);
}

// Updates the field size depending on theApp.level and
// redraws the canvas
void BombsCanvasClass::UpdateFieldSize()
  { field_width=20;
    field_height=20;

    switch(theApp.level)
      { case IDM_EASY:
          field_width=10;
          field_height=10;
          break;
        case IDM_MEDIUM:
          field_width=15;
          field_height=15;
          break;
        case IDM_DIFFICULT:
          field_width=25;
          field_height=20;
          break;
      }
    theApp.Game.Init(field_width, field_height);

/*
    SetScrollbars(X_UNIT, Y_UNIT, field_width*x_cell+1, field_height*y_cell+1,
                  10, 10, 0, 0);
*/
    if (bmp)
      delete bmp;
    bmp=NULL;
    
    OnPaint();
  }

AboutFrameClass::AboutFrameClass(wxFrame *parent, char *title, int x, int y, int width, int height, long style, char *name):
  wxFrame(parent, title, x, y, width, height, style, name)
{
  // Initialize child subwindow members.
  AboutPanel = NULL;

  // Create child subwindows.
  AboutPanel = new AboutPanelClass(this, 0, 0, 292, 303, wxBORDER, "AboutPanel");

  // Ensure the subwindows get resized o.k.
  OnSize(width, height);

  // Centre frame on the screen.
  Centre(wxBOTH);

  // Show the frame.
  Show(TRUE);
}

AboutFrameClass::~AboutFrameClass(void)
{
}

Bool AboutFrameClass::OnClose(void)
{
  // Clean up any associated data here.
  theApp.AboutFrame = NULL;
  return TRUE;
}

void AboutFrameClass::OnSize(int w, int h)
{
  // Let default member handle sizing for only one subwindow.
  wxFrame::OnSize(w, h);
}

void AboutFrameClass::OnMenuCommand(int commandId)
{
  switch (commandId)
  {
  default:
    break;
  }
}

AboutPanelClass::AboutPanelClass(wxFrame *parent, int x, int y, int width, int height, long style, char *name):
  wxPanel(parent, x, y, width, height, style, name)
{
  // Create panel items
  message_line_1 = new wxMessage(this, "wxBombs",
      81, 28, 0, "message_line_1");
  message_line_1->Centre();
  message_line_2 = new wxMessage(this, "(c) 1996 by P. Foggia ",
      60, 58, 0, "message_line_2");
  message_line_2->Centre();
  message_line_3 = new wxMessage(this, "<foggia@amalfi.dis.unina.it>",
      60, 88, 0, "message_line_2");
  message_line_3->Centre();
  message_line_4 = new wxMessage(this, "This program is freeware",
      49, 118, 0, "message_line_3");
  message_line_4->Centre();
  AboutButton = new wxButton(this, (wxFunction)ButtonProc13, "OK",
      108, 158, 80, 34, 0, "AboutButton");
  AboutButton->Centre();
}

AboutPanelClass::~AboutPanelClass(void)
{

}

void AboutPanelClass::OnSize(int w, int h)
{
  wxPanel::OnSize(w, h);
}

void ButtonProc13(wxButton& but, wxCommandEvent& event)
{
  // Close a window.
  if (theApp.AboutFrame)
{
    wxFrame *fr = theApp.AboutFrame;
    fr->Show(FALSE);
    fr->OnClose();
    delete fr;
theApp.AboutFrame = NULL;
  }
}


                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            