L /***************************************************************************  *  * xautolock  * =========  *   * Authors   :	S. De Troch (SDT)  *		M. Eyckmans (MCE)   *  * Date      :	22/07/90   *  * Comments  :  *!  * Review    :	- 12/02/92 (MCE) : +  *		  . Hacked around a dxcalendar problem.   *		- 21/02/92 (MCE) :  *		  . Major rewrite.  *		- 24/02/92 (MCE) :&  *		  . Removed an initialization bug.  *		- 25/02/92 (MCE) :2  *		  . Added code to detect multiple invocations.  *		- 06/03/92 (MCE) :=  *		  . Re-arranged the event loop in order to detect defunct %  *		    children as soon as possible.   *		- 10/03/92 (SDT & MCE) :7  *		  . Added code to detect broken server connections.   *		- 24/03/92 (MCE) ::  *		  . Don't reset the time-out counter after receiving a0  *		    synthetic or otherwise unexpected event.  *		- 15/04/92 (MCE) :8  *		  . Changed the default locker to "xlock 2>&- 1>&-".5  *		  . Fixed a couple of event mask bugs. (Thanks to .  *		    jwz@lucid.com for running into these.)<  *		  . Corrected a property type bug in CheckConnection ().  *		- 20/04/92 (MCE) :/  *		  . Cut Main () into more managable pieces. +  *		  . Periodically call XQueryPointer ().   *		- 25/04/92 (MCE) :2  *		  . Added the `corners' feature. (Suggested by  *		    weisen@alw.nih.gov.)<  *		  . Fixed a problem with pseudo-root windows. (Thanks to6  *		    sherman@unx.sas.com, nedwards@titan.trl.OZ.AU,<  *		    dave@elxr.jpl.Nasa.Gov and tmcconne@sedona.intel.com<  *		    for pointing out the problem and testing the patch.)7  *		  . Added `disable/enable on SIGHUP'. (Suggested by   *		    paul_smith@dg.com.) /  *		  . Added support for multiheaded displays.   *		- 28/04/92 (MCE) :#  *		  . Use the X resource manager.   *		- 06/05/92 (MCE) :;  *		  . Fixed a few potential portability problems. (Thanks $  *		    to paul_smith@dg.com again.)<  *		  . CheckConnection () now works properly on multiheaded:  *		    displays. (Thanks to brian@natinst.com for testing#  *		    the `multiheaded' feature.) "  *		  . Better version of Sleep().4  *		  . Recognize X resources for class "Xautolock".+  *		  . Don't update timer while sighupped. *  *		  . Switched to vfork () and execl ().  *		  . New copyright notice.   *		- 11/05/92 (MCE) :>  *		  . Close stdout and stderr in stead of using "2>&- 1>&-".-  *		    (Suggested by sinkwitz@ifi.unizh.ch.) '  *		  . Added "-noclose" for debugging.   *,  *		- 06/11/93 (TA2 [allebrandi@Inland.com])A  *		  . On VMS the sleep() function is not giving useful results. ?  *		    For example "timer" is advancing 120 counts in anywhere B  *		    from 30 to 125 seconds. Rework UpdateTimer() for VMS under   *		    conditional compilation./  *		- 06/14/94 (HG <goathunter@wkuvx1.wku.edu>) 9  *		  . Merged in changes from Rob Spencer for Motif V1.2 %  *		    <robbie@winkle.bhpese.oz.au>. /  *		- 06/20/94 (HG <goathunter@wkuvx1.wku.edu>) 2  *		  . Merged in corners fix from Jerry Leichter.  *		- 03/07/95 Ben Thomas ?  *		  . Fix command line parsing - structure was freed too soon .  *		  . Make sure to redirect back to screen 0  *		- 04/04/95 Richard Critz@  *		  . use LIB$SPAWN rather than vfork to work around DECC/VAXC!  *		    interoperability problems   *L  * -------------------------------------------------------------------------  *B  * Please send bug reports to detroch@imec.be or eyckmans@imec.be.  *L  * -------------------------------------------------------------------------  */  * Copyright 1990, 1992 by S. De Troch and MCE.   *G  * Permission to use, copy, modify and distribute this software and the J  * supporting documentation without fee is hereby granted, provided that :  *B  *  1 : Both the above copyright notice and this permission notice?  *	appear in all copies of both the software and the supporting   *	documentation. *  *  2 : You don't make a profit out of it.  *D  * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,I  * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO H  * EVENT SHALL THEY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIALE  * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA D  * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHERC  * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    * PERFORMANCE OF THIS SOFTWARE.  *M  ***************************************************************************/        /*"  *  Have a guess what this does..."  *  ==============================  *F  *  Warning for swm & tvtwm users : xautolock should *not* be compiled@  *  with vroot.h, because it needs to know the real root window.  */  #include <stdio.h> #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xresource.h> #if	(defined(VMS)) #include <string.h>  #include <time.h>  #include <processes.h> #include "wait.h"  #define pid_t long #include <lib$routines.h>  #include <descrip.h> #else  #include <X11/strings.h> #include <X11/wait.h>  #include <X11/memory.h>  #endif #include <types.h> #include <signal.h>  #include <math.h>    #ifdef AIXV3 #include <sys/m_wait.h>  #endif /* AIXV3 */  , #if !defined (news1800) && !defined (sun386)   #include <stdlib.h>    #ifndef VMS  #ifndef apollo #include <X11/malloc.h>  #include <X11/unistd.h>  #endif /* apollo */  #endif  ! #endif /* !news1800 && !sun386 */    #include "patchlevel.h"          /**  *  Usefull macros and customization stuff*  *  ======================================  */  #ifdef HasPrototypes #define PP(x)			   x #else /* HasPrototypes */  #define PP(x)			   ()  #endif /* HasPrototypes */    , #define FALSE			   0	   /* as it says		   */+ #define TRUE			   1	   /* as it says		   */   
 #ifdef VMS #include <ssdef.h>4 #define ALL_OK			   1	   /* for use by exit ()	   */< #define PROBLEMS		   SS$_ABORT   /* for use by exit ()	   */ #else 4 #define ALL_OK			   0	   /* for use by exit ()	   */5 #define PROBLEMS		   1	   /* for use by exit ()	   */  #endif /* VMS */3 #define BELL_PERCENT		   40	   /* as is says		   */ 9 #define MIN_MINUTES		   1	   /* minimum number of minutes * 					      before firing up the locker  */0 #define MINUTES 		   10	   /* default ...		   */3 #define MAX_MINUTES		   60	   /* maximum ...		   */ < #define INITIAL_SLEEP		   20	   /* for machines on which the+ 			 		      login sequence takes forever */ ? #define INCREMENTAL_SLEEP	   1	   /* time step in seconds	   */ 6 #define CREATION_DELAY		   30	   /* should be > 10 and* 					      < min (45,(MIN_MINUTES*30))  */6 #define CORNER_SIZE		   10	   /* size in pixels of the" 					      force-lock areas		   */: #define CORNER_DELAY		   5	   /* number of seconds to wait& 					      before forcing a lock	   */> #define LOCKER			   "xlock" /* NEVER use the -root option!  */ #if	(defined(VMS))/ #define LOCKER	  "sys$system:decw$pausesession"  #endif   #define CLASS			   "Xautolock" 			 	   /* as it says		   */   /*#if SystemV == YES #define vfork			   fork  #endif /* SystemV == YES */    #define Main			   main$ #define Min(a,b)		   (a < b ? a : b) #define forever 		   for (;;) , #define Output0(str)		   (Void) printf (str)6 #define Output1(str,arg1)	   (Void) printf (str, arg1)A #define Output2(str,arg1,arg2)	   (Void) printf (str, arg1, arg2) + #define Error0(str)		   (Void) printf (str) 5 #define Error1(str,arg1)	   (Void) printf (str, arg1) @ #define Error2(str,arg1,arg2)	   (Void) printf (str, arg1, arg2) #if	(!defined(VMS)) ? #define UpdateTimer(new_val)	   if (!sighupped) timer = new_val  #endif  . static void*			   ch_ptr;  /* this is dirty */D #define Skeleton(t,s)		   (ch_ptr = (Void*) malloc ((unsigned) s), \' 			       ch_ptr == (Void*) NULL		    \ / 				    ?	(Error0 ("Out of memory.\n"),       \ ) 			        (Void) exit (PROBLEMS),		    \  			        (t*) NULL			    \ 			       ) 				    \  				    : (t*) ch_ptr			    \  				   )					    \  4 #define New(type)		   Skeleton (type, sizeof (type))M #define NewArray(type,nof_elems)   Skeleton (type, sizeof (type) * nof_elems)          /*
  *  New types 
  *  =========   */ * #if defined (apollo) || defined (news1800)/ typedef int			   (*XErrorHandler) PP((Display*,* 						       XErrorEvent*)); #endif /* apollo || news1800 */x  * #if defined (news1800) || defined (sun386) typedef int			   pid_t;c  #endif /* news1800  || sun386 */  : #define Void			   void     /* no typedef because of VAX */ typedef int			   Int;a typedef char			   Char;m typedef char*			   String; typedef int			   Boolean;	 typedef caddr_t 		   Caddrt; typedef unsigned long		   Huge;	   #ifdef HasVoidSignalReturn< #define SigRet			   Void     /* no typedef because of VAX */ #else /* HasVoidSignalReturn */  typedef Int			   SigRet;  #endif /* HasVoidSignalReturn */  ; typedef SigRet			   (*SigHandler) PP((/* OS dependent */));t8 typedef Boolean 		   (*OptAction)  PP((Display*, String, 						     String));/ typedef Void			   (*OptChecker) PP((Display*));    typedef enum 	{) 	  IGNORE,				  /* ignore this corner  */:% 	  DONT_LOCK,				  /* never lock 	 */ + 	  FORCE_LOCK,				  /* lock immediately	 */  	} CornerAction;   typedef struct QueueItem_. 	{* 	  Window		   window;	  /* as it says 	 */. 	  Time			   creationtime;  /* as it says 	 */3 	  struct QueueItem_*	   next;	  /* as it says 	 */a3 	  struct QueueItem_*	   prev;	  /* as it says 	 */e 	} aQueueItem, *QueueItem;   typedef struct Queue_r 	{3 	  struct QueueItem_*	   head;	  /* as it says 	 */)3 	  struct QueueItem_*	   tail;	  /* as it says 	 */T 	} aQueue, *Queue;   typedef struct Opt_a 	{( 	  String		   name;	  /* as it says 	 *// 	  XrmOptionKind 	   kind;	  /* as it says 	 */ 0 	  Caddrt		   value;	  /* XrmOptionNoArg only */- 	  OptAction		   action;	  /* as it says 	 */e/ 	  OptChecker		   checker;	  /* as it says 	 */d 	} anOpt, *Opt;u         /*  *  Function declarationsC  *  =====================o  */m #ifdef news18006+ extern Void*	malloc		   PP((unsigned int));  #endif /* news1800 */T  ( static Void	Usage		   PP((String, Int));! static Void	Sleep		   PP((Void));r6 static Void	EvaluateCounter    PP((Display*,Window*));+ static Void	QueryPointer	   PP((Display*));m3 static Void	ProcessEvents	   PP((Display*, Queue));e$ static Queue	NewQueue	   PP((Void));. static Void	AddToQueue	   PP((Queue, Window));8 static Void	ProcessQueue	   PP((Queue, Display*, Time));< static Void	SelectEvents	   PP((Display*, Window, Boolean));6 static Void	CheckConnection    PP((Display*, String));5 static Int	FetchFalseAlarm    PP((Display*, XEvent)); 8 static Void	ProcessOpts	   PP((Display*, Int, String*));< static Boolean	TimeAction	   PP((Display*, String, String));> static Boolean	LockerAction	   PP((Display*, String, String));? static Boolean	CornersAction	   PP((Display*, String, String));sA static Boolean	CornerSizeAction   PP((Display*, String, String));pA static Boolean	CornerDelayAction  PP((Display*, String, String)); > static Boolean	NotifyAction	   PP((Display*, String, String));< static Boolean	BellAction	   PP((Display*, String, String));? static Boolean	NoCloseAction	   PP((Display*, String, String));.< static Boolean	HelpAction	   PP((Display*, String, String));? static Boolean	VersionAction	   PP((Display*, String, String));a1 static Boolean	GetPositive	   PP((String, Int*)); * static Void	TimeChecker	   PP((Display*));, static Void	NotifyChecker	   PP((Display*));. static Void	CornerSizeChecker  PP((Display*));* static Void	BellChecker	   PP((Display*));, static SigRet	DisableBySignal    PP((Void)); #if	(defined(VMS))% static Void	UpdateTimer	   PP((Int));- #endif   /*  *  Global variables  *  ================  */9
 #ifdef VMS" static Int	     completion_status; #endif; static Time	     now = 0;		    /* number of sleeps since wep) 					       started (not `Int')        */ @ static Int	     timer = 0; 	    /* as it says (not `Time')    */; static String	     locker = LOCKER;	    /* as it says		  */tG static Int	     time_limit = MINUTES;  /* as it says (not `Time')    */ C static Int	     notify_margin;	    /* as it says (not `Time')    */W, static Int	     bell_percent = BELL_PERCENT; 					    /* as it says		  */* static Int	     corner_size = CORNER_SIZE; 					    /* as it says		  */, static Int	     corner_delay = CORNER_DELAY;) 					    /* as it says (not `Time')    */ C static Boolean	     sighupped = FALSE;     /* whether to ignore allC 					       time-outs		  */NH static Boolean	     notify_lock = FALSE;   /* whether to notify the user  					       before locking		  */H static Boolean       ignore_corners= FALSE; /* whether to ignore any set$ 					       special corner action */E static CornerAction  corners[4] = { IGNORE, IGNORE, IGNORE, IGNORE }; & 					    /* default CornerActions	  */E static Boolean	     close_output = TRUE;   /* whether to close stdoutc 					       and stderr		  */ static anOpt	     options[] => 		     {+ 		       {"help"       , XrmoptionNoArg   ,u8 			(Caddrt) ""  , HelpAction       , (OptChecker) NULL},+ 		       {"version"    , XrmoptionNoArg   ,c8 			(Caddrt) ""  , VersionAction    , (OptChecker) NULL},+ 		       {"locker"     , XrmoptionSepArg  , 4 			(Caddrt) NULL, LockerAction	, (OptChecker) NULL},+ 		       {"corners"    , XrmoptionSepArg  ,i5 			(Caddrt) NULL, CornersAction	, (OptChecker) NULL},/+ 		       {"cornersize" , XrmoptionSepArg  ,88 			(Caddrt) NULL, CornerSizeAction , CornerSizeChecker},+ 		       {"cornerdelay", XrmoptionSepArg  ,s8 			(Caddrt) NULL, CornerDelayAction, (OptChecker) NULL},+ 		       {"time"       , XrmoptionSepArg  , 0 			(Caddrt) NULL, TimeAction	, TimeChecker	   },+ 		       {"notify"     , XrmoptionSepArg  ,=4 			(Caddrt) NULL, NotifyAction	, NotifyChecker    },+ 		       {"bell"       , XrmoptionSepArg  , 0 			(Caddrt) NULL, BellAction	, BellChecker	   },+ 		       {"noclose"    , XrmoptionNoArg   ,E8 			(Caddrt) ""  , NoCloseAction    , (OptChecker) NULL},+ 		     }; 		    /* as it says, the order is  					       important		  */B     #if	(defined(VMS)) static	time_t	timer_base = 0;  static	time_t	first_base = 0;o6 static $DESCRIPTOR(locker_d, "mcr decw$pausesession");   /*  * UpdateTimer() for VMS  */    static Void UpdateTimer (val)  Int	val; {s
 	time_t	t;   if (!sighupped)  	{ 	/*  	 * What is the current time?	 	 */
 	time(&t);   	/*h 	 * Dispatch based on the value  	 */
 	switch (val)	 	 {/ 	 /* 	  * 0 means reset the timer 	  */.	 	 case 0:  		{n- 		timer_base = t;	/* Base the timer at now */i5 		timer = 0;	/* Reset the ticks since base counter */d6 		if (first_base == 0) /* Set the program base time */ 			first_base = timer_base;Y 		break; 		}h   	 /*/ 	  * -1 means compute the time since last reset  	  */f
 	 case -1: 		{  		if (timer_base == 0) 			UpdateTimer(0);  A 		timer = t - timer_base;	/* Current time - reset time = ticks */s 		break; 		}    	 /*9 	  * Anything else means set the timer to the given value  	  */R
 	 default: 		{t 		timer = val;> 		timer_base = t - val; /* Reset the base so that timer - base 						= val */ 		break; 		}a 	 }c 	} }  #endif   /*+  *  Command line argument related functionsf+  *  =======================================   *  *  Support functionsd  *  -----------------   */ % static Boolean	GetPositive (arg, pos)d$ String	arg;  /* string to scan 		 */0 Int*	pos;  /* adress where to store the stuff */   {a   Char	c;	     /* dummy		 */)   Int	old = *pos;  /* backup old value */     *   if (	 sscanf (arg, "%d%c", pos, &c) == 1       && *pos >= 0      )   {p     return TRUE;   }f   else   {r     *pos = old;o     return FALSE;g   }g }        /*  *  Action functions  *  ----------------  */s /*ARGSUSED*/( static Boolean	HelpAction (d, name, arg)# Display*  d;	 /* display pointer */ % String	  name;  /* program name    */l$ String	  arg;	 /* argument value  */   {V   Usage (name, ALL_OK);   %   return TRUE;	/* for lint and gcc */  }	     /*ARGSUSED*/+ static Boolean	VersionAction (d, name, arg)	# Display*  d;	 /* display pointer */ % String	  name;  /* program name    */ $ String	  arg;	 /* argument value  */   {e4   Error2 ("%s : patchlevel %d\n", name, PATCHLEVEL);   (Void) exit (ALL_OK);p  %   return TRUE;	/* for lint and gcc */e }      /*ARGSUSED*/. static Boolean	CornerSizeAction (d, name, arg)# Display*  d;	 /* display pointer */(% String	  name;  /* program name    */;$ String	  arg;	 /* argument value  */   {e)   return GetPositive (arg, &corner_size);e }n     /*ARGSUSED*// static Boolean	CornerDelayAction (d, name, arg) # Display*  d;	 /* display pointer */A% String	  name;  /* program name    */h$ String	  arg;	 /* argument value  */   { *   return GetPositive (arg, &corner_delay); }      /*ARGSUSED*/( static Boolean	TimeAction (d, name, arg)# Display*  d;	 /* display pointer */d% String	  name;  /* program name    */e$ String	  arg;	 /* argument value  */   {	(   return GetPositive (arg, &time_limit); }/     /*ARGSUSED*/* static Boolean	NotifyAction (d, name, arg)# Display*  d;	 /* display pointer */ % String	  name;  /* program name    */n$ String	  arg;	 /* argument value  */   {i9   return notify_lock = GetPositive (arg, &notify_margin);h }c     /*ARGSUSED*/( static Boolean	BellAction (d, name, arg)# Display*  d;	 /* display pointer */ % String	  name;  /* program name    */e$ String	  arg;	 /* argument value  */   {t*   return GetPositive (arg, &bell_percent); }t     /*ARGSUSED*/+ static Boolean	NoCloseAction (d, name, arg)a# Display*  d;	 /* display pointer */ % String	  name;  /* program name    */I$ String	  arg;	 /* argument value  */   {c   close_output = FALSE;/   return TRUE; }      /*ARGSUSED*/* static Boolean	LockerAction (d, name, arg)# Display*  d;	 /* display pointer */{% String	  name;  /* program name    */ $ String	  arg;	 /* argument value  */   {a   locker = arg;r   return TRUE; }r     /*ARGSUSED*/+ static Boolean	CornersAction (d, name, arg)	# Display*  d;	 /* display pointer */ % String	  name;  /* program name    */ $ String	  arg;	 /* argument value  */   {=   Int  c;  /* loop counter */f       if (strlen (arg) == 4)   {      for (c = -1; ++c < 4; )/     {8       switch (arg[c])s       {P 	case '0' :) 	  corners[c] = IGNORE;  	  continue;   	case '-' :l 	  corners[c] = DONT_LOCK; 	  continue;   	case '+' :P 	  corners[c] = FORCE_LOCK;t 	  continue;  
 	default : 	  return FALSE;       }t     }e       return TRUE;   }    else   {d     return FALSE;u   }n })       /*  *  Consistency checkers  *  --------------------  */c /*ARGSUSED*/ static Void  TimeChecker (d)# Display*  d;  /* display pointer */o   {P   if (time_limit < MIN_MINUTES)t   {h?     Error1 ("Setting time to minimum value of %d minute(s).\n",  	    time_limit = MIN_MINUTES);t   }B$   else if (time_limit > MAX_MINUTES)   {S?     Error1 ("Setting time to maximum value of %d minute(s).\n",r 	    time_limit = MAX_MINUTES);i   }   ,   time_limit *= 60; /* convert to seconds */ }r     /*ARGSUSED*/ static Void  NotifyChecker (d)# Display*  d;  /* display pointer */(   {a   if (	 notify_lock (       && notify_margin >= time_limit / 2      )   {S5     Error1 ("Notification time set to %d seconds.\n",r% 	    notify_margin = time_limit / 2);c   }  }P     /*ARGSUSED*/ static Void  BellChecker (d)# Display*  d;  /* display pointer */r   {;   if (	 bell_percent < 1       || bell_percent > 100       )   {t-     Error1 ("Bell percentage set to %d%%.\n", " 	    bell_percent = BELL_PERCENT);   }) }      /*ARGSUSED*/" static Void  CornerSizeChecker (d)# Display*  d;  /* display pointer */;   {t&   Int	   s;		     /* screen index   */*   Screen*  scr; 	     /* screen pointer *//   Int	   max_corner_size;  /* as it says     */P    @   for (max_corner_size = 32000, s = -1; ++s < ScreenCount (d); )   { !     scr = ScreenOfDisplay (d, s);i  4     if (   max_corner_size > WidthOfScreen (scr) / 4. 	|| max_corner_size > HeightOfScreen (scr) / 4        )     {*L       max_corner_size = Min (WidthOfScreen (scr), HeightOfScreen (scr)) / 4;     }    }c  $   if (corner_size > max_corner_size)   {c.     Error1 ("Corner size set to %d pixels.\n",$ 	    corner_size = max_corner_size);   }m }i       /*7  *  Function for informing the user about syntax errorse7  *  ---------------------------------------------------I  */ ) static Void  Usage (prog_name, exit_code)s# String	prog_name;  /* as it says */r  Int	exit_code;  /* as it says */   {i.   String  blanks;  /* string full of blanks */,   size_t  len;	   /* number of blanks	    */      /* ;   *  The relative overhead is enormous here, but who cares.S<   *  I'm a perfectionist and Usage () doesn't return anyway.   */5   len = strlen ("Usage : ") + strlen (prog_name) + 1;r>   (Void) memset (blanks = NewArray (Char, len + 1), ' ', len);   blanks[len] = '\0';4      /*O/   *  This is where the actual work gets done...l   */   Error0 ("\n");$   Error1 ("Usage : %s ", prog_name);@   Error0 ("[-help][-version][-time minutes][-locker locker]\n");   Error0 (blanks);>   Error0 ("[-notify margin][-bell percent][-corners xxxx]\n");   Error0 (blanks);A   Error0 ("[-cornerdelay secs][-cornersize pixels][-noclose]\n");p     Error0 ("\n");B   Error0 (" -help              : print this message and exit.\n");D   Error0 (" -version           : print version number and exit.\n");M   Error2 (" -time minutes      : time to lock screen [%d < minutes < %d].\n",  				 MIN_MINUTES, MAX_MINUTES);};   Error0 (" -locker locker     : program used to lock.\n"); L   Error0 (" -notify margin     : beep this many seconds before locking.\n");;   Error0 (" -bell percent      : loudness of the beep.\n");rN   Error0 (" -corners xxxx      : corner actions (0, +, -) in this order :\n");M   Error0 ("                      topleft topright bottomleft bottomright\n");dJ   Error0 (" -cornerdelay secs  : time to lock screen in a `+' corner.\n");;   Error0 (" -cornersize pixels : size of corner areas.\n"); E   Error0 (" -noclose           : do not close stdout and stderr.\n");l     Error0 ("\n");   Error0 ("Defaults :\n");     Error0 ("\n");:   Error1 ("  time        : %d minutes\n"  , MINUTES     );:   Error1 ("  locker      : %s\n"          , LOCKER      );:   Error0 ("  notify      : don't beep\n"                );:   Error0 ("  bell        : 40%%\n"                      );:   Error0 ("  corners     : 0000\n"                      );:   Error1 ("  cornerdelay : %d seconds\n"  , CORNER_DELAY);:   Error1 ("  cornersize  : %d pixels\n"   , CORNER_SIZE );     Error0 ("\n");     exit (exit_code);e }m       /*2  *  Function for processing command line arguments2  *  ----------------------------------------------  */e( static Void  ProcessOpts (d, argc, argv)' Display*  d;	   /* display pointer	  */ ( Int	  argc;    /* number of arguments */+ String	  argv[];  /* array of arguments  */    {*<   Int		     nof_options = sizeof (options) / sizeof (anOpt);) 				  /* number of supported options   */t(   Int		     j; 	  /* loop counter		   */-   Int		     l; 	  /* temporary storage		   */m0   Char* 	     ptr;	  /* temporary storage		   *//   Char		     buffer[80];  /* as it says 		   */t,   Char* 	     dummy;	  /* as it says 		   */:   XrmValue	     value;	  /* resource value container	   */D   XrmOptionDescList  xoptions;	  /* optionslist in Xlib format    */2   XrmDatabase	     dpydb, db = (XrmDatabase) NULL;) 				  /* command line options database */,      /*t   *  Beautify argv[0].   */
 #ifdef VMS   ptr = strrchr(argv[0], ']');   if (ptr != NULL) { 	argv[0] = ++ptr;	 	}   ptr = strchr(argv[0], '.');o   if (ptr != NULL) {
 	*ptr = '\0';, 	} #elsesC   for (ptr = argv[0] + strlen (argv[0]) - 1; ptr >= argv[0]; ptr--)    {e     if (*ptr == '/')     {        break;     }    }      argv[0] = ptr + 1; #endif /* VMS */    /*->   *  Calling XGetDefault () on a dummy resource is the easiest/   *  way to get both Xrm and d->db initialized.m   */+   (Void) XGetDefault (d, argv[0], "dummy");e     dpydb = XtDatabase (d);n    /*LB   *  Parse the command line options into a resource database. (TheA   *  command line database and the resource file database are notd@   *  merged, because we want to know where exactly each resource   *  value came from.)   */6   xoptions = NewArray (XrmOptionDescRec, nof_options);  #   for (j = -1; ++j < nof_options; )u   {U!     l = strlen (options[j].name);   @     (Void) sprintf (xoptions[j].option = NewArray (Char, l + 2), 		    "-%s", options[j].name);C     (Void) sprintf (xoptions[j].specifier = NewArray (Char, l + 2),l 		    ".%s", options[j].name);*     xoptions[j].argKind = options[j].kind;)     xoptions[j].value = options[j].value;m   }g  E   XrmParseCommand (&db, xoptions, nof_options, argv[0], &argc, argv);   
   if (--argc)a   {/     Usage (argv[0], PROBLEMS);   }G  % /*  for (j = -1; ++j < nof_options; )    {S     free (xoptions[j].option);!     free (xoptions[j].specifier);d   }y     free (xoptions); */    /*p   *  Call the action functions.	   */#   for (j = -1; ++j < nof_options; )o   {eD     (Void) sprintf (buffer, "%s%s", argv[0], xoptions[j].specifier);  C     if (XrmGetResource (db, buffer, (String) NULL, &dummy, &value))      {r;       if (!(*(options[j].action)) (d, argv[0], value.addr))        {t 	Usage (argv[0], PROBLEMS);&       }r     } K     else if (XrmGetResource (dpydb, buffer, (String) NULL, &dummy, &value))      {l;       if (!(*(options[j].action)) (d, argv[0], value.addr))g       {/@ 	Error2 ("Can't interprete \"%s\" for \"%s\", using default.\n", 		value.addr, buffer);       }c     }n     else     {,D       (Void) sprintf (buffer, "%s%s", CLASS, xoptions[j].specifier);  J       if (   XrmGetResource (dpydb, buffer, (String) NULL, &dummy, &value)6 	  && !(*(options[j].action)) (d, argv[0], value.addr) 	 )o       {e@ 	Error2 ("Can't interprete \"%s\" for \"%s\", using default.\n", 		value.addr, buffer);       }      }g   }g  #   for (j = -1; ++j < nof_options; )r   {g     free (xoptions[j].option);!     free (xoptions[j].specifier);i   },     free (xoptions);        /*s#   *  Call the consistency checkers.p   */#   for (j = -1; ++j < nof_options; )e   {l0     if (options[j].checker != (OptChecker) NULL)     {t"       (*(options[j].checker)) (d);     }c   }  }          /*)  *  Functions related to the window queue )  *  =====================================c  *%  *  Function for creating a new queuec%  *  ---------------------------------   */C static Queue  NewQueue ()d   {t#   Queue  queue;  /* return value */e       queue = New (aQueue); !   queue->tail = New (aQueueItem);n!   queue->head = New (aQueueItem);c  "   queue->tail->next = queue->head;"   queue->head->prev = queue->tail;;   queue->tail->prev = queue->head->next = (QueueItem) NULL;e     return queue;S }        /**  *  Function for adding an item to a queue*  *  --------------------------------------  */t' static Void  AddToQueue (queue, window)E Queue	queue;	 /* as it says */  Window	window;  /* as it says */   {"!   QueueItem  new;  /* new item */i       new = New (aQueueItem);*     new->window = window;    new->creationtime = now;    new->next = queue->tail->next;   new->prev = queue->tail;    queue->tail->next->prev = new;   queue->tail->next = new; }2       /*=  *  Function for processing those entries that are old enough =  *  ---------------------------------------------------------/  */t) static Void  ProcessQueue (queue, d, age)d% Queue	  queue;  /* as it says      */p$ Display*  d;	  /* display pointer */# Time	  age;	  /* required age    */e   {a'   QueueItem  current;  /* as it says */        if (now > age)   {       current = queue->head->prev;       while (   current->prev ( 	   && current->creationtime + age < now 	  )     {e/       SelectEvents (d, current->window, False);n       current = current->prev;       free (current->next);      }m        current->next = queue->head;      queue->head->prev = current;   }c }n         /*4  *  Functions related to (the lack of) user activity4  *  ================================================  *+  *  Function for processing the event queue +  *  ---------------------------------------   */ % static Void  ProcessEvents (d, queue)o$ Display*  d;	  /* display pointer */% Queue	  queue;  /* as it says      */_   {="   XEvent  event;  /* as it says */      /*u,   *  Read whatever is available for reading.   */   while (XPending (d))   {-<     if (XCheckMaskEvent (d, SubstructureNotifyMask, &event))     {_%       if (event.type == CreateNotify)s       {	0 	AddToQueue (queue, event.xcreatewindow.window);       }t     }l     else     {        XNextEvent (d, &event);a     }         /* >     *  Reset the counter if and only if the event is of one ofC     *  the types we are expecting to get *and* was not generated by      *  XSendEvent ()."     */!     if (   event.type == KeyPresse 	&& !event.xany.send_event        )     {n       UpdateTimer (0);     }    }       /* ;   *  Check the window queue for entries that are older than;   *  CREATION_DELAY seconds.   */1   ProcessQueue (queue, d, (Time) CREATION_DELAY);c }        /*-  *  Function for monitoring pointer movementsg-  *  -----------------------------------------0  */n static Void  QueryPointer (d)s# Display*  d;  /* display pointer */)   { 2   Window	  dummy_w;	      /* as it says		       */0   Int		  dummy_c;	      /* as it says		       */1   Mask		  dummy_m;	      /* as it says		       */;/   Int		  root_x;	      /* as it says		       */c/   Int		  root_y;	      /* as it says		       */ 1   Int		  corner;	      /* corner index		       */o-   Int		  i;		      /* loop counter		       */aB   static Window   root; 	      /* root window the pointer is on */C   static Screen*  screen;	      /* screen the pointer is on      */s;   static Int	  prev_root_x = -1;   /* as it says		       */ ;   static Int	  prev_root_y = -1;   /* as it says		       */t>   static Boolean  first_call = TRUE;  /* as it says		       */      /*    *  Have a guess...   */   if (first_call)s   {z     first_call = FALSE; !     root = DefaultRootWindow (d); 4     screen = ScreenOfDisplay (d, DefaultScreen (d));   }r      /*fI   *  Find out whether the pointer has moved. Using XQueryPointer for this G   *  is gross, but it also is the only way never to mess up propagation    *  of pointer events.    *dD   *  Remark : Unlike XNextEvent(), XPending () doesn't notice if theD   *	      connection to the server is lost. For this reason, earlierA   *	      versions of xautolock periodically called XNoOp (). ButY?   *	      why not let XQueryPointer () do the job for us, since @   *	      we now call it every INCREMENTAL_SLEEP seconds anyway?   */A   if (!XQueryPointer (d, root, &root, &dummy_w, &root_x, &root_y,-& 		      &dummy_c, &dummy_c, &dummy_m))   {s    /*,H     *  Pointer has moved to another screen, so let's find out which one.     */)     for (i = -1; ++i < ScreenCount (d); )o     {e$       if (root == RootWindow (d, i))       {f! 	screen = ScreenOfDisplay (d, i);  	break;        }t     }o   }*     if (	 root_x == prev_root_xn       && root_y == prev_root_y      )   {o    /* ?     *  If the pointer has not moved since the previous call and >     *  is inside one of the 4 corners, we act according to theB     *  contents of the "corners" array - except that we first have)     *  to check the ignore_corners value.;     */     if (   (corner = 0,  	       root_x <= corner_size  	    && root_y <= corner_size  	   )a 	|| (corner++,: 	       root_x >= WidthOfScreen	(screen) - corner_size - 1 	    && root_y <= corner_size' 	   )  	|| (corner++, 	       root_x <= corner_sizet; 	    && root_y >= HeightOfScreen (screen) - corner_size - 1' 	   )  	|| (corner++,: 	       root_x >= WidthOfScreen	(screen) - corner_size - 1; 	    && root_y >= HeightOfScreen (screen) - corner_size - 1  	   )         )     {;       if (!ignore_corners)        { switch (corners[corner]) 	{ 	case FORCE_LOCK :- 	  if (timer < time_limit - corner_delay + 2)l 	  {1 	    UpdateTimer (time_limit - corner_delay + 2);e 	  }	 	  break;a   	case DONT_LOCK :  	  UpdateTimer (0);d 	}       }      }r3     else /* not in a corner - stop ignoring them */d 	ignore_corners = FALSE;   }    else   {r     prev_root_x = root_x;w     prev_root_y = root_y;e     UpdateTimer (0);   }  }        /*)  *  Function for deciding whether to lock;)  *  -------------------------------------   */ " static Void  EvaluateCounter (d,r)# Display*  d;  /* display pointer */n
 Window* r;   {,0   static pid_t	locker_pid = 0;  /* child pid  */.   static Time	prev_bell = 0;	 /* as it says */      /*)>   *  Find out whether we should do something special. This can(   *  be one (or more) of the following :   *[.   *   - Wait for the previous locker (if any).A   *   - Ring the bell, if we were asked to and are about to lock. A   *   - Start up a new locker if the time limit has been reached.o   */     if (locker_pid)(   {o3     union wait	status;  /* childs process status */     = /*   if (!wait3 (&status, WNOHANG, (struct rusage*) NULL)) */s #ifndef VMSo      if (SmPauseWindow(d,r)) #elsee       if (completion_status == 0) #endif /* VMS */     {s       UpdateTimer (0);     }o     else     {        locker_pid = 0;&     }    }      if (	 notify_lockn+       && timer + notify_margin > time_limit  #ifndef VMS(,       && prev_bell < now - notify_margin - 1 #endif      )   {      prev_bell = now;     XBell (d, bell_percent);     XSync (d, 0);(   }n     if (timer > time_limit)l   {d     if (!locker_pid)     {' #ifndef VMS\$       switch (locker_pid = vfork ())       {d
 	case -1 : 	  locker_pid = 0;	 	  break;   	 	case 0 :V' 	  (Void) close (ConnectionNumber (d));iD /*	  (Void) execl ("/bin/sh", "sh", "-c", locker, (String) NULL); */E /*	  Only fire up locker if not there--may have been done manually */v 	  if (!SmPauseWindow(d,r)) {r1 		  (Void) execl (locker, locker, (String) NULL);a           }a 	  (Void) _exit (PROBLEMS);   
 	default : #else  	completion_status = 0;sA 	locker_pid = lib$spawn(&locker_d,0,0,&1,0,0,&completion_status);p 	if (!(locker_pid&1))r 	  exit(locker_pid); #endif 	UpdateTimer (0);e; 	ignore_corners = TRUE;	/* Ignore until movement outside */  #ifndef VMSp       }c #endif     }h   }) }L         /*  *  Miscellaneous functions   *  =======================   *  *  X Error handlere  *  ---------------   */  /*ARGSUSED*/& static Int  FetchFalseAlarm (d, event)$ Display*  d;	  /* display pointer */& XEvent	  event;  /* error event     */   {Q   return 0;e }d       /*  *  SIGHUP signal handlerl  *  ---------------------a  */)! static SigRet  DisableBySignal ())   {   /*-A   *  The order in which things are done is rather important here.    */   UpdateTimer (0);   sighupped = !sighupped; 7   (Void) signal (SIGHUP, (SigHandler) DisableBySignal);e   #ifndef HasVoidSignalReturnf   return 0;i  #endif /* HasVoidSignalReturn */ }-       /*  *  Lazy functiont  *  -------------u  */e static Void  Sleep ()u   {*   Int  i;  /* loop counter */     )   for (i = -1; ++i < INCREMENTAL_SLEEP; )e   {m     (Void) sleep (1);a #if	(defined(VMS))     UpdateTimer (-1); *     now = timer + timer_base - first_base; #else-     UpdateTimer (timer + 1);
     now++; #endif   }- }e       /*I  *  Function for finding out whether another xautolock is already running I  *  ----------------------------------------------------------------------  */-+ static Void  CheckConnection (d, prog_name)q( Display*  d;	      /* display pointer */& String	  prog_name;  /* as it says	 */   {e'   pid_t   pid;	      /* as it says		 */e1   Int	  kill_val;   /* return value of kill () */ &   Window  r;	      /* root window		 */*   Atom	  property;   /* property atom		 */.   Atom	  type;       /* property type atom	 */*   Int	  format;     /* property format	 */2   Huge	  nof_items;  /* actual number of items  */#   Huge	  after;      /* dummy			 */m2   pid_t*  contents;   /* actual property value	 */    2   r = RootWindowOfScreen (ScreenOfDisplay (d, 0));?   property = XInternAtom (d, "XAUTOLOCK_SEMAPHORE_PID", False);=     XGrabServer (d);E   XGetWindowProperty (d, r, property, 0L, 2L, False, AnyPropertyType,-+ 		      &type, &format, &nof_items, &after,i% 		      (unsigned char**) &contents);      if (type == XA_INTEGER)u   {     /* 0     *  This breaks if the other xautolock is not#     *  running on the same machine.h     */#     kill_val = kill (*contents, 0);l       if (kill_val == 0)     {C2       Error2 ("%s is already running (PID %d).\n", 	      prog_name, *contents);        (Void) exit (PROBLEMS);o     }q   }      pid = getpid ();1   XChangeProperty (d, r, property, XA_INTEGER, 8,N2 		   PropModeReplace, (Char*) &pid, sizeof (pid));   XUngrabServer (d);     XFree ((Char*) contents);f }        /*6  *  Function for selecting events on a tree of windows6  *  --------------------------------------------------  */y8 static Void  SelectEvents (d, window, substructure_only)+ Display*  d;		      /* display pointer   */ ' Window	  window;	      /* window 	   */t1 Boolean   substructure_only;  /* as it says	   *//   {r5   Window	     root;		/* root window of this window */ 7   Window	     parent;		/* parent of this window      */ :   Window*	     children;		/* children of this window    */<   Int		     nof_children = 0;	/* number of children	      */*   Int		     i; 		/* loop counter 	      */?   XWindowAttributes  attribs;		/* attributes of the window   */a      /*mA   *  Start by querying the server about parent and child windows.i   */H   if (!XQueryTree (d, window, &root, &parent, &children, &nof_children))   {;     return;n   }d      /* F   *  Build the appropriate event mask. The basic idea is that we don'tE   *  want to interfere with the normal event propagation mechanism ife   *  we don't have to.   */   if (substructure_only)   { 5     XSelectInput (d, window, SubstructureNotifyMask);c   }    else   {=4     if (parent == None)  /* the *real* rootwindow */     {l       attribs.all_event_masks =/3       attribs.do_not_propagate_mask = KeyPressMask;a     } =     else if (XGetWindowAttributes (d, window, &attribs) == 0)      {c
       return;D     }(  5     XSelectInput (d, window,   SubstructureNotifyMaskt' 			     | (  (  attribs.all_event_masksi' 				   | attribs.do_not_propagate_mask)o 				& KeyPressMask));t   }s      /*g,   *  Now do the same thing for all children.   */$   for (i = -1; ++i < nof_children; )   {n5     SelectEvents (d, children[i], substructure_only);t   }      if (nof_children != 0)   {e     XFree ((Char*) children);y   }e }N       /*  *  Main functiono  *  -------------   */  Int  Main (argc, argv)$ Int	argc;	 /* number of arguments */( String	argv[];  /* array of arguments	*/   {P(   Display*  d;	    /* display pointer */(   Window    r;	    /* root window     */&   Int	    s;	    /* screen index    */)   Queue     queue;  /* as it says      */u      /*nE   *  Find out whether there actually is a server on the other side...f   */*   if (	 (d = XOpenDisplay ((String) NULL))       == (Display*) NULL      )   {      (Void) exit (PROBLEMS);    }x    &   fprintf(stderr, "Initializing....");    /*    *  Some initializations.   */   ProcessOpts (d, argc, argv);  5   XSetErrorHandler ((XErrorHandler) FetchFalseAlarm);,   CheckConnection (d, argv[0]);c7   (Void) signal (SIGHUP, (SigHandler) DisableBySignal);e     XSync (d, 0);h/   fprintf(stderr, "Setting initial sleep....");n   (Void) sleep (INITIAL_SLEEP);r     queue = NewQueue ();  '   for (s = -1; ++s < ScreenCount (d); )    {tH     AddToQueue (queue, r = RootWindowOfScreen (ScreenOfDisplay (d, s)));     SelectEvents (d, r, True);   }   $ /* Reset "r" to point to screen 0 */  /   r = RootWindowOfScreen(ScreenOfDisplay(d,0));      if (close_output)    {t     (Void) fclose (stdout);-     (Void) fclose (stderr);t   }       /*c   *  Main event loop.s   */	   forever    { (   fprintf(stderr, "Going to sleep....");
     Sleep ();o#   fprintf(stderr, "Waking up....");:       ProcessEvents (d, queue);n     QueryPointer (d);      EvaluateCounter (d,r);   }e }e