 /*&  * xgifload.c  -  based strongly on...  *O  * gif2ras.c - Converts from a Compuserve GIF (tm) image to a Sun Raster image.   *2  * Copyright (c) 1988, 1989 by Patrick J. Naughton  *  * Author: Patrick J. Naughton  * naughton@wind.sun.com  *H  * Permission to use, copy, modify, and distribute this software and itsC  * documentation for any purpose and without fee is hereby granted, I  * provided that the above copyright notice appear in all copies and that B  * both that copyright notice and this permission notice appear in  * supporting documentation.  *J  * This file is provided AS IS with no warranties of any kind.  The authorJ  * shall have no liability with respect to the infringement of copyrights,H  * trade secrets or any patents by this file or any part thereof.  In noE  * event will the author be liable for any lost revenue or profits or 5  * other special, indirect and consequential damages.   *  */    #include "xgif.h"    typedef int boolean;   #define NEXTBYTE (*ptr++)  #define IMAGESEP 0x2c  #define INTERLACEMASK 0x40 #define COLORMAPMASK 0x80   	 FILE *fp;   1 int BitOffset = 0,		/* Bit Offset of next code */ A     XC = 0, YC = 0,		/* Output X and Y coords of current pixel */ >     Pass = 0,			/* Used by output routine if interlaced pic */:     OutCount = 0,		/* Decompressor output 'stack count' */-     RWidth, RHeight,		/* screen dimensions */ *     Width, Height,		/* image dimensions */(     LeftOfs, TopOfs,		/* image offset */=     BitsPerPixel,		/* Bits per pixel, read from GIF header */ @     BytesPerScanline,		/* bytes per scanline in output raster */)     ColorMapSize,		/* number of colors */ (     Background,			/* background color */5     CodeSize,			/* Code size, read from GIF header */ >     InitCodeSize,		/* Starting code size, used during Clear */,     Code,			/* Value returned by ReadCode */9     MaxCode,			/* limiting value for current code size */ %     ClearCode,			/* GIF clear code */ 0     EOFCode,			/* GIF end-of-information code */:     CurCode, OldCode, InCode,	/* Decompressor variables */>     FirstFree,			/* First free code, generated per GIF spec */@     FreeCode,			/* Decompressor, next free slot in hash table */*     FinChar,			/* Decompressor variable */+     BitMask,			/* AND mask for data size */ 9     ReadMask;			/* Code AND mask for current code size */    boolean Interlace, HasColormap;  boolean Verbose = False; boolean debug   = False;  % byte *Image;			/* The result array */ 4 byte *RawGIF;			/* The heap array to hold it, raw */7 byte *Raster;			/* The raster data stream, unblocked */   1     /* The hash table used by the decompressor */  int Prefix[4096];  int Suffix[4096];   2     /* An output array used by the decompressor */ int OutCode[1025];  1     /* The color map, read from the GIF header */ 0 byte Red[256], Green[256], Blue[256], used[256];
 int  numused;    char *id = "GIF87a";       /*****************************/  LoadGIF(fname)   char *fname; /*****************************/  {      int            filesize;     register byte  ch, ch1;      register byte *ptr, *ptr1;     register int   i;   A     if (strcmp(fname,"-")==0) { fp = stdin;  fname = "<stdin>"; } 4                          else fp = fopen(fname,"r");  *     if (!fp) FatalError("file not found");  #     /* find the size of the file */      fseek(fp, 0L, 2);      filesize = ftell(fp);      fseek(fp, 0L, 0);   4     if (!(ptr = RawGIF = (byte *) malloc(filesize)))2 	FatalError("not enough memory to read gif file");  .     if (!(Raster = (byte *) malloc(filesize)))2 	FatalError("not enough memory to read gif file");  + /*    if (fread(ptr, filesize, 1, fp) != 1) & 	FatalError("GIF data read failed");*/     read_file(fname,ptr);   
 /*    } */         if (strncmp(ptr, id, 6)) 	FatalError("not a GIF file");  
     ptr += 6;   2 /* Get variables from the GIF screen descriptor */       ch = NEXTBYTE;H     RWidth = ch + 0x100 * NEXTBYTE;	/* screen dimensions... not used. */     ch = NEXTBYTE;$     RHeight = ch + 0x100 * NEXTBYTE;       if (Verbose); 	fprintf(stderr, "screen dims: %dx%d.\n", RWidth, RHeight);        ch = NEXTBYTE;7     HasColormap = ((ch & COLORMAPMASK) ? True : False);         BitsPerPixel = (ch & 7) + 1;/     numcols = ColorMapSize = 1 << BitsPerPixel;      BitMask = ColorMapSize - 1;   ?     Background = NEXTBYTE;		/* background color... not used. */   ,     if (NEXTBYTE)		/* supposed to be NULL */8 	FatalError("corrupt GIF file (bad screen descriptor)");     /* Read in global colormap. */       if (HasColormap) {
 	if (Verbose) F 	    fprintf(stderr, "%s is %dx%d, %d bits per pixel, (%d colors).\n",2 		fname, Width,Height,BitsPerPixel, ColorMapSize);% 	for (i = 0; i < ColorMapSize; i++) {  	    Red[i] = NEXTBYTE;  	    Green[i] = NEXTBYTE;  	    Blue[i] = NEXTBYTE;             used[i] = 0; 	    }         numused = 0;  	         }   )     else {  /* no colormap in GIF file */ X         fprintf(stderr,"%s:  warning!  no colortable in this file.  Winging it.\n",cmd);"         if (!numcols) numcols=256;>         for (i=0; i<numcols; i++) cols[i] = (unsigned long) i;	         }    /* Check for image seperator */        if (NEXTBYTE != IMAGESEP) 5 	FatalError("corrupt GIF file (no image separator)");   2 /* Now read in values from the image descriptor */       ch = NEXTBYTE;$     LeftOfs = ch + 0x100 * NEXTBYTE;     ch = NEXTBYTE;#     TopOfs = ch + 0x100 * NEXTBYTE;      ch = NEXTBYTE;"     Width = ch + 0x100 * NEXTBYTE;     ch = NEXTBYTE;#     Height = ch + 0x100 * NEXTBYTE; <     Interlace = ((NEXTBYTE & INTERLACEMASK) ? True : False);       if (Verbose)< 	fprintf(stderr, "Reading a %d by %d %sinterlaced image...",, 		Width, Height, (Interlace) ? "" : "non-");    B /* Note that I ignore the possible existence of a local color map.F  * I'm told there aren't many files around that use them, and the specA  * says it's defined for future use.  This could lead to an error   * reading some files.    */   C /* Start reading the raster data. First we get the intial code size E  * and compute decompressor constant values, based on this code size.   */        CodeSize = NEXTBYTE;      ClearCode = (1 << CodeSize);     EOFCode = ClearCode + 1;)     FreeCode = FirstFree = ClearCode + 2;   B /* The GIF spec has it that the code size is the code size used toG  * compute the above values is the code size given in the file, but the H  * code size used in compression/decompression is the code size given in$  * the file plus one. (thus the ++).  */        CodeSize++;      InitCodeSize = CodeSize;     MaxCode = (1 << CodeSize);     ReadMask = MaxCode - 1;   F /* Read the raster data.  Here we just transpose it from the GIF arrayH  * to the Raster array, turning it from a series of blocks into one long<  * data stream, which makes life much easier for ReadCode().  */        ptr1 = Raster;     do { 	ch = ch1 = NEXTBYTE; ! 	while (ch--) *ptr1++ = NEXTBYTE;   	if ((Raster - ptr1) > filesize). 	    FatalError("corrupt GIF file (unblock)");     } while(ch1);   <     free(RawGIF);		/* We're done with the raw data now... */       if (Verbose) { 	fprintf(stderr, "done.\n");% 	fprintf(stderr, "Decompressing...");      }      /* Allocate the X Image */*     Image = (byte *) malloc(Width*Height);;     if (!Image) FatalError("not enough memory for XImage");   @     theImage = XCreateImage(theDisp,theVisual,8,ZPixmap,0,Image,/                          Width,Height,8,Width); 9     if (!theImage) FatalError("unable to create XImage");        BytesPerScanline = Width;     B /* Decompress the file, continuing until you see the GIF EOF code.E  * One obvious enhancement is to add checking for corrupt files here.   */        Code = ReadCode();     while (Code != EOFCode) {   G /* Clear code sets everything back to its initial value, then reads the 4  * immediately subsequent code as uncompressed data.  */    	if (Code == ClearCode) {  	    CodeSize = InitCodeSize;  	    MaxCode = (1 << CodeSize);  	    ReadMask = MaxCode - 1; 	    FreeCode = FirstFree;+ 	    CurCode = OldCode = Code = ReadCode(); ! 	    FinChar = CurCode & BitMask;  	    AddToPixel(FinChar);  	} 	else {   M /* If not a clear code, then must be data: save same as CurCode and InCode */    	    CurCode = InCode = Code;   > /* If greater or equal to FreeCode, not in the hash table yet;$  * repeat the last character decoded  */    	    if (CurCode >= FreeCode) {  		CurCode = OldCode;  		OutCode[OutCount++] = FinChar; 	    }  G /* Unless this code is raw data, pursue the chain pointed to by CurCode E  * through the hash table to its end; each code in the chain puts its .  * associated output code on the output queue.  */     	    while (CurCode > BitMask) { 		if (OutCount > 1024) {9 		    fprintf(stderr,"\nCorrupt GIF file (OutCount)!\n"); O                     _exit(-1);  /* calling 'exit(-1)' dumps core, so I don't */                      } ( 		OutCode[OutCount++] = Suffix[CurCode]; 		CurCode = Prefix[CurCode]; 	    }  8 /* The last code in the chain is treated as raw data. */  ! 	    FinChar = CurCode & BitMask; # 	    OutCode[OutCount++] = FinChar;   1 /* Now we put the data out to the Output routine. 6  * It's been stacked LIFO, so deal with it that way...  */   ( 	    for (i = OutCount - 1; i >= 0; i--) 		AddToPixel(OutCode[i]);  	    OutCount = 0;  F /* Build the hash table on-the-fly. No table is stored in the file. */    	    Prefix[FreeCode] = OldCode;  	    Suffix[FreeCode] = FinChar; 	    OldCode = InCode;  A /* Point to the next slot in the table.  If we exceed the current H  * MaxCode value, increment the code size unless it's already 12.  If it=  * is, do nothing: the next code decompressed better be CLEAR   */    	    FreeCode++; 	    if (FreeCode >= MaxCode) {  		if (CodeSize < 12) { 		    CodeSize++;  		    MaxCode *= 2; % 		    ReadMask = (1 << CodeSize) - 1;  		}  	    } 	} 	Code = ReadCode();      }        free(Raster);        if (Verbose) 	fprintf(stderr, "done.\n");       if (fp != stdin) 	fclose(fp);       ColorDicking(fname); }     E /* Fetch the next code from the raster data stream.  The codes can be G  * any length from 3 to 12 bits, packed into 8-bit bytes, so we have to I  * maintain our location in the Raster array as a BIT Offset.  We compute G  * the byte Offset into the raster array by dividing this by 8, pick up F  * three bytes, compute the bit Offset into our 24-bit chunk, shift toI  * bring the desired code to the bottom, then mask it off and return it.    */ 
 ReadCode() {  int RawCode, ByteOffset;       ByteOffset = BitOffset / 8; D     RawCode = Raster[ByteOffset] + (0x100 * Raster[ByteOffset + 1]);     if (CodeSize >= 8)/ 	RawCode += (0x10000 * Raster[ByteOffset + 2]);       RawCode >>= (BitOffset % 8);     BitOffset += CodeSize;     return(RawCode & ReadMask);  }      AddToPixel(Index)  byte Index;  {      if (YC<Height)6         *(Image + YC * BytesPerScanline + XC) = Index;  4     if (!used[Index]) { used[Index]=1;  numused++; }  K /* Update the X-coordinate, and if it overflows, update the Y-coordinate */        if (++XC == Width) {  I /* If a non-interlaced picture, just increment YC to the next scan line.  F  * If it's interlaced, deal with the interlace as described in the GIFH  * spec.  Put the decoded scan line out to the screen if we haven't gone  * past the bottom of it  */    	XC = 0; 	if (!Interlace) YC++; 	else {  	    switch (Pass) {	 		case 0:  		    YC += 8; 		    if (YC >= Height) { 
 			Pass++;
 			YC = 4; 		    }  		break;	 		case 1:  		    YC += 8; 		    if (YC >= Height) { 
 			Pass++;
 			YC = 2; 		    }  		break;	 		case 2:  		    YC += 4; 		    if (YC >= Height) { 
 			Pass++;
 			YC = 1; 		    }  		break;	 		case 3:  		    YC += 2; 		break;
 		default: 		break; 	    } 	}     }  }        /*************************/  ColorDicking(fname)  char *fname; { O     /* we've got the picture loaded, we know what colors are needed. get 'em */        register int   i,j; P     static byte    lmasks[8] = {0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80};     byte           lmask, *ptr;          if (!HasColormap) return; C     /* no need to allocate any colors if no colormap in GIF file */   0     /* Allocate the X colors for this picture */  D     if (nostrip)  {   /* nostrip was set.  try REAL hard to do it */%         for (i=j=0; i<numcols; i++) {              if (used[i]) {*                 defs[i].red   = Red[i]<<8;,                 defs[i].green = Green[i]<<8;+                 defs[i].blue  = Blue[i]<<8; 9                 defs[i].flags = DoRed | DoGreen | DoBlue; >                 if (!XAllocColor(theDisp,theCmap,&defs[i])) { 1                     j++;  defs[i].pixel = 0xffff;                      } (                 cols[i] = defs[i].pixel;                 } 
             }   -         if (j) {		/* failed to pull it off */              XColor ctab[256];              int    dc;  3             dc = (dispcells<256) ? dispcells : 256;   f             fprintf(stderr,"failed to allocate %d out of %d colors.  Trying extra hard.\n",j,numused);  )             /* read in the color table */ 3             for (i=0; i<dc; i++) ctab[i].pixel = i; 2             XQueryColors(theDisp,theCmap,ctab,dc);                 L             /* run through the used colors.  any used color that has a pixelN                value of 0xffff wasn't allocated.  for such colors, run throughB                the entire X colormap and pick the closest color */  %             for (i=0; i<numcols; i++) M                 if (used[i] && cols[i]==0xffff) {  /* an unallocated pixel */ (                     int d, mdist, close;(                     unsigned long r,g,b;  1                     mdist = 100000;   close = -1;                       r =  Red[i];"                     g =  Green[i];!                     b =  Blue[i]; *                     for (j=0; j<dc; j++) {7                         d = abs(r - (ctab[j].red>>8)) + 9                             abs(g - (ctab[j].green>>8)) + 7                             abs(b - (ctab[j].blue>>8)); :                         if (d<mdist) { mdist=d; close=j; }                         } K                     if (close<0) FatalError("simply can't do it.  Sorry."); D                     /*bcopy(&defs[close],&defs[i],sizeof(XColor));*/A                     memcpy(&defs[close],&defs[i],sizeof(XColor)); 0                     cols[i] = ctab[close].pixel;                     } /             }	/* end 'failed to pull it off' */ 	         }   B     else {          /* strip wasn't set, do the best auto-strip */         j = 0;         while (strip<8) { "             lmask = lmasks[strip];%             for (i=0; i<numcols; i++)                  if (used[i]) {8                     defs[i].red   = (Red[i]  &lmask)<<8;8                     defs[i].green = (Green[i]&lmask)<<8;8                     defs[i].blue  = (Blue[i] &lmask)<<8;=                     defs[i].flags = DoRed | DoGreen | DoBlue; F                     if (!XAllocColor(theDisp,theCmap,&defs[i])) break;,                     cols[i] = defs[i].pixel;                     }   *             if (i<numcols) {		/* failed */                 strip++;  j++;$                 for (i--; i>=0; i--)J                     if (used[i]) XFreeColors(theDisp,theCmap,cols+i,1,0L);                 }              else break; 
             }            if (j && strip<8)  	  if (Verbose) I             fprintf(stderr,"%s:  %s stripped %d bits\n",cmd,fname,strip);            if (strip==8) { O             fprintf(stderr,"UTTERLY failed to allocate the desired colors.\n"); 0             for (i=0; i<numcols; i++) cols[i]=i;
             } 	         }        ptr = Image;     for (i=0; i<Height; i++)&         for (j=0; j<Width; j++,ptr++) %             *ptr = (byte) cols[*ptr];  }     C /*    Routine to read a file by mapping it as a section in P1 space @       (7xxxxxx addresses). For some reason seems to screw up anyA       calls to malloc() which occur after a call to this routine?   "       Just do an fread() on Ultrix */ read_file(file, out) char *file, *out;  {    #include <rms> #include <secdef>  #include <errno> #include <stsdef>   N     struct crmpsc_region                    /* Memory region descriptor     */N     {                                       /*  used by $CRMPSC service     */         char *start;         char *end;
     } region;t     int i;  N     struct FAB fab = cc$rms_fab;            /* RMS File Access Block        */       /*;     ** Load up the FAB for Create and Map Section operations     */N     fab.fab$l_fna = file;                   /* Load up the filename         */!     fab.fab$b_fns = strlen(file);gN     fab.fab$b_fac = FAB$M_GET;              /* Set up for read only.        */N     fab.fab$l_fop = FAB$M_UFO;              /* Specify want a channel       */     /*     ** Open the file     */      vaxc$errno = SYS$OPEN(&fab);)     if (!$VMS_STATUS_SUCCESS(vaxc$errno))v         LIB$SIGNAL(vaxc$errno);e     /*>     ** Call $CRMPSC to create virtual memory and map the file.     */N     region.start = &region;                 /* Initialize to make P1 space  */N     region.end   = &region;                 /* region.                      */       vaxc$errno = SYS$CRMPSC ( N                     &region,                /* INADR, which region to use   */N                     &region,                /* RETADR, resulting region     */N                     0,                      /* ACMODE, access mode          */5                     SEC$M_EXPREG|SEC$M_WRT|SEC$M_CRF,oN                                             /* FLAGS, create writable       */N                     0,                      /* GSDNAM, gbl section name     */N                     0,                      /* IDENT, vers no of gbl sect   */N                     0,                      /* RELPAG, 1st page in sec      */N                     fab.fab$l_stv,          /* CHAN, channel from RMS       */N                     0,                      /* PAGCNT, no of pgs in sec     */N                     0,                      /* VBN, 1st block in file       */N                     0,                      /* PROT, protection mask        */N                     0);                     /* PFC, page fault cluster size */A     if (!$VMS_STATUS_SUCCESS(vaxc$errno)) LIB$SIGNAL(vaxc$errno);D  >     if(debug) printf("Region start: %x end: %x length = %d\n",) 			(long) region.start,(long) region.end,D 			region.end-region.start);  5     memcpy(out,region.start,region.end-region.start);/ } 